# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=lunarlake -instruction-tables < %s | FileCheck %s

addsubpd  %xmm0, %xmm2
addsubpd  (%rax),  %xmm2

addsubps  %xmm0, %xmm2
addsubps  (%rax), %xmm2

haddpd    %xmm0, %xmm2
haddpd    (%rax), %xmm2

haddps    %xmm0, %xmm2
haddps    (%rax), %xmm2

hsubpd    %xmm0, %xmm2
hsubpd    (%rax), %xmm2

hsubps    %xmm0, %xmm2
hsubps    (%rax), %xmm2

lddqu     (%rax), %xmm2

monitor

movddup   %xmm0, %xmm2
movddup   (%rax), %xmm2

movshdup  %xmm0, %xmm2
movshdup  (%rax), %xmm2

movsldup  %xmm0, %xmm2
movsldup  (%rax), %xmm2

mwait

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     0.50                        addsubpd	%xmm0, %xmm2
# CHECK-NEXT:  2      10    0.50    *                   addsubpd	(%rax), %xmm2
# CHECK-NEXT:  1      3     0.50                        addsubps	%xmm0, %xmm2
# CHECK-NEXT:  2      10    0.50    *                   addsubps	(%rax), %xmm2
# CHECK-NEXT:  3      4     2.50                        haddpd	%xmm0, %xmm2
# CHECK-NEXT:  4      10    2.50    *                   haddpd	(%rax), %xmm2
# CHECK-NEXT:  3      4     2.50                        haddps	%xmm0, %xmm2
# CHECK-NEXT:  4      10    2.50    *                   haddps	(%rax), %xmm2
# CHECK-NEXT:  3      4     2.50                        hsubpd	%xmm0, %xmm2
# CHECK-NEXT:  4      10    2.50    *                   hsubpd	(%rax), %xmm2
# CHECK-NEXT:  3      4     2.50                        hsubps	%xmm0, %xmm2
# CHECK-NEXT:  4      10    2.50    *                   hsubps	(%rax), %xmm2
# CHECK-NEXT:  1      6     0.33    *                   lddqu	(%rax), %xmm2
# CHECK-NEXT:  1      100   0.17                  U     monitor
# CHECK-NEXT:  1      1     0.50                        movddup	%xmm0, %xmm2
# CHECK-NEXT:  1      6     2.00    *                   movddup	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        movshdup	%xmm0, %xmm2
# CHECK-NEXT:  1      6     2.00    *                   movshdup	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        movsldup	%xmm0, %xmm2
# CHECK-NEXT:  1      6     2.00    *                   movsldup	(%rax), %xmm2
# CHECK-NEXT:  1      100   0.17    *      *      U     mwait

# CHECK:      Resources:
# CHECK-NEXT: [0]   - LNLPPort00
# CHECK-NEXT: [1]   - LNLPPort01
# CHECK-NEXT: [2]   - LNLPPort02
# CHECK-NEXT: [3]   - LNLPPort03
# CHECK-NEXT: [4]   - LNLPPort04
# CHECK-NEXT: [5]   - LNLPPort05
# CHECK-NEXT: [6]   - LNLPPort10
# CHECK-NEXT: [7]   - LNLPPort11
# CHECK-NEXT: [8]   - LNLPPort20
# CHECK-NEXT: [9]   - LNLPPort21
# CHECK-NEXT: [10]  - LNLPPort22
# CHECK-NEXT: [11]  - LNLPPort25
# CHECK-NEXT: [12]  - LNLPPort26
# CHECK-NEXT: [13]  - LNLPPort27
# CHECK-NEXT: [14]  - LNLPPortInvalid
# CHECK-NEXT: [15]  - LNLPVPort00
# CHECK-NEXT: [16]  - LNLPVPort01
# CHECK-NEXT: [17]  - LNLPVPort02
# CHECK-NEXT: [18]  - LNLPVPort03

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16]   [17]   [18]
# CHECK-NEXT: 0.33   0.33   0.33   0.33   0.33   0.33    -      -     15.00  15.00  15.00   -      -      -      -      -      -     23.50  23.50

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16]   [17]   [18]   Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   addsubpd	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -     0.50   0.50   addsubpd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   addsubps	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -     0.50   0.50   addsubps	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.50   2.50   haddpd	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -      -      -     2.50   2.50   haddpd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.50   2.50   haddps	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -      -      -     2.50   2.50   haddps	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.50   2.50   hsubpd	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -      -      -     2.50   2.50   hsubpd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.50   2.50   hsubps	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -      -      -     2.50   2.50   hsubps	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     lddqu	(%rax), %xmm2
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     monitor
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   movddup	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -      -      -      -      -     movddup	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   movshdup	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -      -      -      -      -     movshdup	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   movsldup	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -      -      -      -      -     movsldup	(%rax), %xmm2
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     mwait
