; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs | FileCheck %s

define i32 @add32mi_GS() {
; CHECK-LABEL: add32mi_GS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %gs:255, %eax
; CHECK-NEXT:    addl $123456, %eax # imm = 0x1E240
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i32 255 to ptr addrspace(256)
  %t = load i32, ptr addrspace(256) %a
  %add = add i32 %t, 123456
  ret i32 %add
}

define i64 @add64mi_FS() {
; CHECK-LABEL: add64mi_FS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %fs:255, %rax
; CHECK-NEXT:    addq $123456, %rax # imm = 0x1E240
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i64 255 to ptr addrspace(257)
  %t = load i64, ptr addrspace(257) %a
  %add = add i64 %t, 123456
  ret i64 %add
}

define i32 @sub32mi_GS() {
; CHECK-LABEL: sub32mi_GS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %gs:255, %eax
; CHECK-NEXT:    addl $129, %eax
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i32 255 to ptr addrspace(256)
  %t = load i32, ptr addrspace(256) %a
  %sub = sub i32 %t, -129
  ret i32 %sub
}

define i64 @sub64mi_FS() {
; CHECK-LABEL: sub64mi_FS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %fs:255, %rax
; CHECK-NEXT:    subq $-2147483648, %rax # imm = 0x80000000
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i64 255 to ptr addrspace(257)
  %t = load i64, ptr addrspace(257) %a
  %sub = sub i64 %t, -2147483648
  ret i64 %sub
}

define i32 @and32mi_GS() {
; CHECK-LABEL: and32mi_GS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %gs:255, %eax
; CHECK-NEXT:    andl $-129, %eax
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i32 255 to ptr addrspace(256)
  %t = load i32, ptr addrspace(256) %a
  %and = and i32 %t, -129
  ret i32 %and
}

define i64 @and64mi_FS() {
; CHECK-LABEL: and64mi_FS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %fs:255, %rax
; CHECK-NEXT:    andq $-2147483648, %rax # imm = 0x80000000
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i64 255 to ptr addrspace(257)
  %t = load i64, ptr addrspace(257) %a
  %and = and i64 %t, -2147483648
  ret i64 %and
}

define i32 @or32mi_GS() {
; CHECK-LABEL: or32mi_GS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %gs:255, %eax
; CHECK-NEXT:    orl $-129, %eax
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i32 255 to ptr addrspace(256)
  %t = load i32, ptr addrspace(256) %a
  %or = or i32 %t, -129
  ret i32 %or
}

define i64 @or64mi_FS() {
; CHECK-LABEL: or64mi_FS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %fs:255, %rax
; CHECK-NEXT:    orq $-2147483648, %rax # imm = 0x80000000
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i64 255 to ptr addrspace(257)
  %t = load i64, ptr addrspace(257) %a
  %or = or i64 %t, -2147483648
  ret i64 %or
}

define i32 @xor32mi_GS() {
; CHECK-LABEL: xor32mi_GS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %gs:255, %eax
; CHECK-NEXT:    xorl $-129, %eax
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i32 255 to ptr addrspace(256)
  %t = load i32, ptr addrspace(256) %a
  %xor = xor i32 %t, -129
  ret i32 %xor
}

define i64 @xor64mi_FS() {
; CHECK-LABEL: xor64mi_FS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %fs:255, %rax
; CHECK-NEXT:    xorq $-2147483648, %rax # imm = 0x80000000
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i64 255 to ptr addrspace(257)
  %t = load i64, ptr addrspace(257) %a
  %xor = xor i64 %t, -2147483648
  ret i64 %xor
}

define i32 @adc32mi_GS(i32 %x, i32 %y) {
; CHECK-LABEL: adc32mi_GS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpl %edi, %esi
; CHECK-NEXT:    movl %gs:255, %eax
; CHECK-NEXT:    adcl $123456, %eax # imm = 0x1E240
; CHECK-NEXT:    retq
entry:
  %a = inttoptr i32 255 to ptr addrspace(256)
  %t = load i32, ptr addrspace(256) %a
  %s = add i32 %t, 123456
  %k = icmp ugt i32 %x, %y
  %z = zext i1 %k to i32
  %r = add i32 %s, %z
  ret i32 %r
}

define i64 @adc64mi_FS(i64 %x, i64 %y) {
; CHECK-LABEL: adc64mi_FS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpq %rdi, %rsi
; CHECK-NEXT:    movq %fs:255, %rax
; CHECK-NEXT:    adcq $123456, %rax # imm = 0x1E240
; CHECK-NEXT:    retq
entry:
  %a = inttoptr i64 255 to ptr addrspace(257)
  %t = load i64, ptr addrspace(257) %a
  %s = add i64 %t, 123456
  %k = icmp ugt i64 %x, %y
  %z = zext i1 %k to i64
  %r = add i64 %s, %z
  ret i64 %r
}

define i32 @sbb32mi_GS(i32 %x, i32 %y) {
; CHECK-LABEL: sbb32mi_GS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpl %edi, %esi
; CHECK-NEXT:    sbbl $0, %gs:255, %eax
; CHECK-NEXT:    addl $-123456, %eax # imm = 0xFFFE1DC0
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i32 255 to ptr addrspace(256)
  %t = load i32, ptr addrspace(256) %a
  %s = sub i32 %t, 123456
  %k = icmp ugt i32 %x, %y
  %z = zext i1 %k to i32
  %r = sub i32 %s, %z
  ret i32 %r
}

define i64 @sbb64mi_FS(i64 %x, i64 %y) {
; CHECK-LABEL: sbb64mi_FS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpq %rdi, %rsi
; CHECK-NEXT:    sbbq $0, %fs:255, %rax
; CHECK-NEXT:    addq $-123456, %rax # imm = 0xFFFE1DC0
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i64 255 to ptr addrspace(257)
  %t = load i64, ptr addrspace(257) %a
  %s = sub i64 %t, 123456
  %k = icmp ugt i64 %x, %y
  %z = zext i1 %k to i64
  %r = sub i64 %s, %z
  ret i64 %r
}

define i32 @add32mi8_GS() {
; CHECK-LABEL: add32mi8_GS:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $127, %gs:255, %eax
; CHECK-NEXT:    retq
entry:
  %a= inttoptr i32 255 to ptr addrspace(256)
  %t = load i32, ptr addrspace(256) %a
  %add = add i32 %t, 127
  ret i32 %add
}

define i32 @add32mi_GS_Disp0(ptr addrspace(256) %a, i32 %i) {
; CHECK-LABEL: add32mi_GS_Disp0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movslq %esi, %rax
; CHECK-NEXT:    addl $123456, %gs:(%rdi,%rax,4), %eax # imm = 0x1E240
; CHECK-NEXT:    retq
entry:
  %arrayidx = getelementptr inbounds i32, ptr addrspace(256) %a, i32 %i
  %t = load i32, ptr addrspace(256) %arrayidx
  %add = add i32 %t, 123456
  ret i32 %add
}

define i32 @add32mi_GS_Disp8(ptr addrspace(256) %a, i32 %i) {
; CHECK-LABEL: add32mi_GS_Disp8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movslq %esi, %rax
; CHECK-NEXT:    addl $123456, %gs:123(%rdi,%rax,4), %eax # imm = 0x1E240
; CHECK-NEXT:    retq
entry:
  %arrayidx = getelementptr inbounds i32, ptr addrspace(256) %a, i32 %i
  %add.ptr = getelementptr inbounds i8, ptr addrspace(256) %arrayidx, i32 123
  %t = load i32, ptr addrspace(256) %add.ptr
  %add = add i32 %t, 123456
  ret i32 %add
}

define i32 @add32mi_GS_Disp32(ptr addrspace(256) %a, i32 %i) {
; CHECK-LABEL: add32mi_GS_Disp32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movslq %esi, %rax
; CHECK-NEXT:    movl %gs:1234(%rdi,%rax,4), %eax
; CHECK-NEXT:    addl $123456, %eax # imm = 0x1E240
; CHECK-NEXT:    retq
entry:
  %arrayidx = getelementptr inbounds i32, ptr addrspace(256) %a, i32 %i
  %add.ptr = getelementptr inbounds i8, ptr addrspace(256) %arrayidx, i32 1234
  %t = load i32, ptr addrspace(256) %add.ptr
  %add = add i32 %t, 123456
  ret i32 %add
}
