; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=sparc-linux-gnu < %s | FileCheck %s -check-prefixes=ALL,V8,V8-OPT
; RUN: llc -mtriple=sparcel-linux-gnu < %s | FileCheck %s -check-prefixes=ALL,V8,V8-OPT
; RUN: llc -mtriple=sparc-linux-gnu -O0 < %s | FileCheck %s -check-prefixes=ALL,V8,V8-UNOPT
; RUN: llc -mtriple=sparc-linux-gnu -mattr=v9 < %s | FileCheck %s -check-prefixes=ALL,V9
; RUN: llc -mtriple=sparc64-unknown-linux < %s | FileCheck %s -check-prefixes=ALL,SPARC64

define void @test_load_store(ptr %p, ptr %q) nounwind {
; ALL-LABEL: test_load_store:
; ALL:       ! %bb.0:
; ALL-NEXT:    lduh [%o0], %o0
; ALL-NEXT:    retl
; ALL-NEXT:    sth %o0, [%o1]
  %a = load half, ptr %p
  store half %a, ptr %q
  ret void
}

define float @test_fpextend_float(ptr %p) nounwind {
; V8-LABEL: test_fpextend_float:
; V8:       ! %bb.0:
; V8-NEXT:    save %sp, -96, %sp
; V8-NEXT:    call __extendhfsf2
; V8-NEXT:    lduh [%i0], %o0
; V8-NEXT:    ret
; V8-NEXT:    restore
;
; V9-LABEL: test_fpextend_float:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -96, %sp
; V9-NEXT:    call __extendhfsf2
; V9-NEXT:    lduh [%i0], %o0
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fpextend_float:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -176, %sp
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    lduh [%i0], %o0
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = load half, ptr %p
  %r = fpext half %a to float
  ret float %r
}

define double @test_fpextend_double(ptr %p) nounwind {
; V8-LABEL: test_fpextend_double:
; V8:       ! %bb.0:
; V8-NEXT:    save %sp, -96, %sp
; V8-NEXT:    call __extendhfsf2
; V8-NEXT:    lduh [%i0], %o0
; V8-NEXT:    fstod %f0, %f0
; V8-NEXT:    ret
; V8-NEXT:    restore
;
; V9-LABEL: test_fpextend_double:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -96, %sp
; V9-NEXT:    call __extendhfsf2
; V9-NEXT:    lduh [%i0], %o0
; V9-NEXT:    fstod %f0, %f0
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fpextend_double:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -176, %sp
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    lduh [%i0], %o0
; SPARC64-NEXT:    fstod %f0, %f0
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = load half, ptr %p
  %r = fpext half %a to double
  ret double %r
}

define void @test_fpextend_fp128(ptr %p, ptr %out) nounwind {
; V8-OPT-LABEL: test_fpextend_fp128:
; V8-OPT:       ! %bb.0:
; V8-OPT-NEXT:    save %sp, -112, %sp
; V8-OPT-NEXT:    call __extendhfsf2
; V8-OPT-NEXT:    lduh [%i0], %o0
; V8-OPT-NEXT:    st %f0, [%fp+-20]
; V8-OPT-NEXT:    add %fp, -16, %i0
; V8-OPT-NEXT:    st %i0, [%sp+64]
; V8-OPT-NEXT:    call _Q_stoq
; V8-OPT-NEXT:    ld [%fp+-20], %o0
; V8-OPT-NEXT:    unimp 16
; V8-OPT-NEXT:    ldd [%fp+-8], %f0
; V8-OPT-NEXT:    ldd [%fp+-16], %f4
; V8-OPT-NEXT:    std %f0, [%i1+8]
; V8-OPT-NEXT:    std %f4, [%i1]
; V8-OPT-NEXT:    ret
; V8-OPT-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fpextend_fp128:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -112, %sp
; V8-UNOPT-NEXT:    call __extendhfsf2
; V8-UNOPT-NEXT:    lduh [%i0], %o0
; V8-UNOPT-NEXT:    st %f0, [%fp+-20]
; V8-UNOPT-NEXT:    add %fp, -16, %i0
; V8-UNOPT-NEXT:    st %i0, [%sp+64]
; V8-UNOPT-NEXT:    call _Q_stoq
; V8-UNOPT-NEXT:    ld [%fp+-20], %o0
; V8-UNOPT-NEXT:    unimp 16
; V8-UNOPT-NEXT:    ldd [%fp+-16], %f4
; V8-UNOPT-NEXT:    ! implicit-def: $q0
; V8-UNOPT-NEXT:    fmovs %f4, %f0
; V8-UNOPT-NEXT:    fmovs %f5, %f1
; V8-UNOPT-NEXT:    ldd [%fp+-8], %f4
; V8-UNOPT-NEXT:    fmovs %f4, %f2
; V8-UNOPT-NEXT:    fmovs %f5, %f3
; V8-UNOPT-NEXT:    fmovs %f2, %f4
; V8-UNOPT-NEXT:    fmovs %f3, %f5
; V8-UNOPT-NEXT:    std %f4, [%i1+8]
; V8-UNOPT-NEXT:    ! kill: def $d0 killed $d0 killed $q0
; V8-UNOPT-NEXT:    std %f0, [%i1]
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fpextend_fp128:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -112, %sp
; V9-NEXT:    call __extendhfsf2
; V9-NEXT:    lduh [%i0], %o0
; V9-NEXT:    st %f0, [%fp+-20]
; V9-NEXT:    add %fp, -16, %i0
; V9-NEXT:    st %i0, [%sp+64]
; V9-NEXT:    call _Q_stoq
; V9-NEXT:    ld [%fp+-20], %o0
; V9-NEXT:    unimp 16
; V9-NEXT:    ldd [%fp+-8], %f0
; V9-NEXT:    ldd [%fp+-16], %f4
; V9-NEXT:    std %f0, [%i1+8]
; V9-NEXT:    std %f4, [%i1]
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fpextend_fp128:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -192, %sp
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    lduh [%i0], %o0
; SPARC64-NEXT:    add %fp, 2031, %o0
; SPARC64-NEXT:    fmovs %f0, %f3
; SPARC64-NEXT:    call _Qp_stoq
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    ldd [%fp+2039], %f0
; SPARC64-NEXT:    ldd [%fp+2031], %f4
; SPARC64-NEXT:    std %f0, [%i1+8]
; SPARC64-NEXT:    std %f4, [%i1]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = load half, ptr %p
  %r = fpext half %a to fp128
  store fp128 %r, ptr %out
  ret void
}

define void @test_fptrunc_float(float %f, ptr %p) nounwind {
; V8-OPT-LABEL: test_fptrunc_float:
; V8-OPT:       ! %bb.0:
; V8-OPT-NEXT:    save %sp, -96, %sp
; V8-OPT-NEXT:    call __truncsfhf2
; V8-OPT-NEXT:    mov %i0, %o0
; V8-OPT-NEXT:    sth %o0, [%i1]
; V8-OPT-NEXT:    ret
; V8-OPT-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fptrunc_float:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -96, %sp
; V8-UNOPT-NEXT:    mov %i0, %o0
; V8-UNOPT-NEXT:    st %o0, [%fp+-4]
; V8-UNOPT-NEXT:    call __truncsfhf2
; V8-UNOPT-NEXT:    ld [%fp+-4], %f0
; V8-UNOPT-NEXT:    sth %o0, [%i1]
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fptrunc_float:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -96, %sp
; V9-NEXT:    call __truncsfhf2
; V9-NEXT:    mov %i0, %o0
; V9-NEXT:    sth %o0, [%i1]
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fptrunc_float:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -176, %sp
; SPARC64-NEXT:    call __truncsfhf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    sth %o0, [%i1]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = fptrunc float %f to half
  store half %a, ptr %p
  ret void
}

define void @test_fptrunc_double(double %d, ptr %p) nounwind {
; V8-OPT-LABEL: test_fptrunc_double:
; V8-OPT:       ! %bb.0:
; V8-OPT-NEXT:    save %sp, -112, %sp
; V8-OPT-NEXT:    ! kill: def $i1 killed $i1 killed $i0_i1 def $i0_i1
; V8-OPT-NEXT:    ! kill: def $i0 killed $i0 killed $i0_i1 def $i0_i1
; V8-OPT-NEXT:    std %i0, [%fp+-8]
; V8-OPT-NEXT:    ldd [%fp+-8], %f0
; V8-OPT-NEXT:    std %f0, [%fp+-16]
; V8-OPT-NEXT:    call __truncdfhf2
; V8-OPT-NEXT:    ldd [%fp+-16], %o0
; V8-OPT-NEXT:    sth %o0, [%i2]
; V8-OPT-NEXT:    ret
; V8-OPT-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fptrunc_double:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -112, %sp
; V8-UNOPT-NEXT:    mov %i1, %i3
; V8-UNOPT-NEXT:    mov %i0, %i4
; V8-UNOPT-NEXT:    ! implicit-def: $i0_i1
; V8-UNOPT-NEXT:    mov %i4, %i0
; V8-UNOPT-NEXT:    mov %i3, %i1
; V8-UNOPT-NEXT:    std %i0, [%fp+-8]
; V8-UNOPT-NEXT:    ldd [%fp+-8], %f0
; V8-UNOPT-NEXT:    std %f0, [%fp+-16]
; V8-UNOPT-NEXT:    ldd [%fp+-16], %i0
; V8-UNOPT-NEXT:    mov %i0, %o0
; V8-UNOPT-NEXT:    call __truncdfhf2
; V8-UNOPT-NEXT:    mov %i1, %o1
; V8-UNOPT-NEXT:    sth %o0, [%i2]
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fptrunc_double:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -112, %sp
; V9-NEXT:    ! kill: def $i1 killed $i1 killed $i0_i1 def $i0_i1
; V9-NEXT:    ! kill: def $i0 killed $i0 killed $i0_i1 def $i0_i1
; V9-NEXT:    std %i0, [%fp+-8]
; V9-NEXT:    ldd [%fp+-8], %f0
; V9-NEXT:    std %f0, [%fp+-16]
; V9-NEXT:    call __truncdfhf2
; V9-NEXT:    ldd [%fp+-16], %o0
; V9-NEXT:    sth %o0, [%i2]
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fptrunc_double:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -176, %sp
; SPARC64-NEXT:    call __truncdfhf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    sth %o0, [%i1]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = fptrunc double %d to half
  store half %a, ptr %p
  ret void
}

define void @test_fptrunc_fp128(ptr %dp, ptr %p) nounwind {
; V8-OPT-LABEL: test_fptrunc_fp128:
; V8-OPT:       ! %bb.0:
; V8-OPT-NEXT:    save %sp, -104, %sp
; V8-OPT-NEXT:    ldd [%i0], %f0
; V8-OPT-NEXT:    ldd [%i0+8], %f4
; V8-OPT-NEXT:    std %f4, [%sp+100]
; V8-OPT-NEXT:    call __trunctfhf2
; V8-OPT-NEXT:    std %f0, [%sp+92]
; V8-OPT-NEXT:    sth %o0, [%i1]
; V8-OPT-NEXT:    ret
; V8-OPT-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fptrunc_fp128:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -104, %sp
; V8-UNOPT-NEXT:    ldd [%i0], %f4
; V8-UNOPT-NEXT:    ! implicit-def: $q0
; V8-UNOPT-NEXT:    fmovs %f4, %f0
; V8-UNOPT-NEXT:    fmovs %f5, %f1
; V8-UNOPT-NEXT:    ldd [%i0+8], %f4
; V8-UNOPT-NEXT:    fmovs %f4, %f2
; V8-UNOPT-NEXT:    fmovs %f5, %f3
; V8-UNOPT-NEXT:    fmovs %f2, %f4
; V8-UNOPT-NEXT:    fmovs %f3, %f5
; V8-UNOPT-NEXT:    std %f4, [%sp+100]
; V8-UNOPT-NEXT:    ! kill: def $d0 killed $d0 killed $q0
; V8-UNOPT-NEXT:    call __trunctfhf2
; V8-UNOPT-NEXT:    std %f0, [%sp+92]
; V8-UNOPT-NEXT:    sth %o0, [%i1]
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fptrunc_fp128:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -104, %sp
; V9-NEXT:    ldd [%i0], %f0
; V9-NEXT:    ldd [%i0+8], %f4
; V9-NEXT:    std %f4, [%sp+100]
; V9-NEXT:    call __trunctfhf2
; V9-NEXT:    std %f0, [%sp+92]
; V9-NEXT:    sth %o0, [%i1]
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fptrunc_fp128:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -176, %sp
; SPARC64-NEXT:    ldd [%i0], %f0
; SPARC64-NEXT:    call __trunctfhf2
; SPARC64-NEXT:    ldd [%i0+8], %f2
; SPARC64-NEXT:    sth %o0, [%i1]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %d = load fp128, ptr %dp
  %a = fptrunc fp128 %d to half
  store half %a, ptr %p
  ret void
}

define void @test_fadd(ptr %p, ptr %q) nounwind {
; V8-OPT-LABEL: test_fadd:
; V8-OPT:       ! %bb.0:
; V8-OPT-NEXT:    save %sp, -104, %sp
; V8-OPT-NEXT:    call __extendhfsf2
; V8-OPT-NEXT:    lduh [%i0], %o0
; V8-OPT-NEXT:    st %f0, [%fp+-8] ! 4-byte Folded Spill
; V8-OPT-NEXT:    call __extendhfsf2
; V8-OPT-NEXT:    lduh [%i1], %o0
; V8-OPT-NEXT:    ld [%fp+-8], %f1 ! 4-byte Folded Reload
; V8-OPT-NEXT:    fadds %f1, %f0, %f0
; V8-OPT-NEXT:    st %f0, [%fp+-4]
; V8-OPT-NEXT:    call __truncsfhf2
; V8-OPT-NEXT:    ld [%fp+-4], %o0
; V8-OPT-NEXT:    sth %o0, [%i0]
; V8-OPT-NEXT:    ret
; V8-OPT-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fadd:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -104, %sp
; V8-UNOPT-NEXT:    call __extendhfsf2
; V8-UNOPT-NEXT:    lduh [%i0], %o0
; V8-UNOPT-NEXT:    st %f0, [%fp+-8] ! 4-byte Folded Spill
; V8-UNOPT-NEXT:    call __extendhfsf2
; V8-UNOPT-NEXT:    lduh [%i1], %o0
; V8-UNOPT-NEXT:    fmovs %f0, %f1
; V8-UNOPT-NEXT:    ld [%fp+-8], %f0 ! 4-byte Folded Reload
; V8-UNOPT-NEXT:    fadds %f0, %f1, %f0
; V8-UNOPT-NEXT:    st %f0, [%fp+-4]
; V8-UNOPT-NEXT:    call __truncsfhf2
; V8-UNOPT-NEXT:    ld [%fp+-4], %o0
; V8-UNOPT-NEXT:    sth %o0, [%i0]
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fadd:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -104, %sp
; V9-NEXT:    call __extendhfsf2
; V9-NEXT:    lduh [%i0], %o0
; V9-NEXT:    st %f0, [%fp+-8] ! 4-byte Folded Spill
; V9-NEXT:    call __extendhfsf2
; V9-NEXT:    lduh [%i1], %o0
; V9-NEXT:    ld [%fp+-8], %f1 ! 4-byte Folded Reload
; V9-NEXT:    fadds %f1, %f0, %f0
; V9-NEXT:    st %f0, [%fp+-4]
; V9-NEXT:    call __truncsfhf2
; V9-NEXT:    ld [%fp+-4], %o0
; V9-NEXT:    sth %o0, [%i0]
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fadd:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -192, %sp
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    lduh [%i0], %o0
; SPARC64-NEXT:    st %f0, [%fp+2043] ! 4-byte Folded Spill
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    lduh [%i1], %o0
; SPARC64-NEXT:    ld [%fp+2043], %f1 ! 4-byte Folded Reload
; SPARC64-NEXT:    call __truncsfhf2
; SPARC64-NEXT:    fadds %f1, %f0, %f1
; SPARC64-NEXT:    sth %o0, [%i0]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = load half, ptr %p
  %b = load half, ptr %q
  %r = fadd half %a, %b
  store half %r, ptr %p
  ret void
}

define void @test_fmul(ptr %p, ptr %q) nounwind {
; V8-OPT-LABEL: test_fmul:
; V8-OPT:       ! %bb.0:
; V8-OPT-NEXT:    save %sp, -104, %sp
; V8-OPT-NEXT:    call __extendhfsf2
; V8-OPT-NEXT:    lduh [%i0], %o0
; V8-OPT-NEXT:    st %f0, [%fp+-8] ! 4-byte Folded Spill
; V8-OPT-NEXT:    call __extendhfsf2
; V8-OPT-NEXT:    lduh [%i1], %o0
; V8-OPT-NEXT:    ld [%fp+-8], %f1 ! 4-byte Folded Reload
; V8-OPT-NEXT:    fmuls %f1, %f0, %f0
; V8-OPT-NEXT:    st %f0, [%fp+-4]
; V8-OPT-NEXT:    call __truncsfhf2
; V8-OPT-NEXT:    ld [%fp+-4], %o0
; V8-OPT-NEXT:    sth %o0, [%i0]
; V8-OPT-NEXT:    ret
; V8-OPT-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fmul:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -104, %sp
; V8-UNOPT-NEXT:    call __extendhfsf2
; V8-UNOPT-NEXT:    lduh [%i0], %o0
; V8-UNOPT-NEXT:    st %f0, [%fp+-8] ! 4-byte Folded Spill
; V8-UNOPT-NEXT:    call __extendhfsf2
; V8-UNOPT-NEXT:    lduh [%i1], %o0
; V8-UNOPT-NEXT:    fmovs %f0, %f1
; V8-UNOPT-NEXT:    ld [%fp+-8], %f0 ! 4-byte Folded Reload
; V8-UNOPT-NEXT:    fmuls %f0, %f1, %f0
; V8-UNOPT-NEXT:    st %f0, [%fp+-4]
; V8-UNOPT-NEXT:    call __truncsfhf2
; V8-UNOPT-NEXT:    ld [%fp+-4], %o0
; V8-UNOPT-NEXT:    sth %o0, [%i0]
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fmul:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -104, %sp
; V9-NEXT:    call __extendhfsf2
; V9-NEXT:    lduh [%i0], %o0
; V9-NEXT:    st %f0, [%fp+-8] ! 4-byte Folded Spill
; V9-NEXT:    call __extendhfsf2
; V9-NEXT:    lduh [%i1], %o0
; V9-NEXT:    ld [%fp+-8], %f1 ! 4-byte Folded Reload
; V9-NEXT:    fmuls %f1, %f0, %f0
; V9-NEXT:    st %f0, [%fp+-4]
; V9-NEXT:    call __truncsfhf2
; V9-NEXT:    ld [%fp+-4], %o0
; V9-NEXT:    sth %o0, [%i0]
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fmul:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -192, %sp
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    lduh [%i0], %o0
; SPARC64-NEXT:    st %f0, [%fp+2043] ! 4-byte Folded Spill
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    lduh [%i1], %o0
; SPARC64-NEXT:    ld [%fp+2043], %f1 ! 4-byte Folded Reload
; SPARC64-NEXT:    call __truncsfhf2
; SPARC64-NEXT:    fmuls %f1, %f0, %f1
; SPARC64-NEXT:    sth %o0, [%i0]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = load half, ptr %p
  %b = load half, ptr %q
  %r = fmul half %a, %b
  store half %r, ptr %p
  ret void
}
