// RUN: llvm-mc -triple=amdgcn -mcpu=gfx900 -show-encoding %s | FileCheck %s

s_cmp_eq_i32 s1, s2
// CHECK: [0x01,0x02,0x00,0xbf]

s_cmp_eq_i32 s101, s2
// CHECK: [0x65,0x02,0x00,0xbf]

s_cmp_eq_i32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x00,0xbf]

s_cmp_eq_i32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x00,0xbf]

s_cmp_eq_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x00,0xbf]

s_cmp_eq_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x00,0xbf]

s_cmp_eq_i32 ttmp15, s2
// CHECK: [0x7b,0x02,0x00,0xbf]

s_cmp_eq_i32 m0, s2
// CHECK: [0x7c,0x02,0x00,0xbf]

s_cmp_eq_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x00,0xbf]

s_cmp_eq_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x00,0xbf]

s_cmp_eq_i32 0, s2
// CHECK: [0x80,0x02,0x00,0xbf]

s_cmp_eq_i32 -1, s2
// CHECK: [0xc1,0x02,0x00,0xbf]

s_cmp_eq_i32 0.5, s2
// CHECK: [0xf0,0x02,0x00,0xbf]

s_cmp_eq_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x00,0xbf]

s_cmp_eq_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x00,0xbf]

s_cmp_eq_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x00,0xbf]

s_cmp_eq_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x00,0xbf]

s_cmp_eq_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x00,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x00,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_i32 s1, s101
// CHECK: [0x01,0x65,0x00,0xbf]

s_cmp_eq_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x00,0xbf]

s_cmp_eq_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x00,0xbf]

s_cmp_eq_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x00,0xbf]

s_cmp_eq_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x00,0xbf]

s_cmp_eq_i32 s1, ttmp15
// CHECK: [0x01,0x7b,0x00,0xbf]

s_cmp_eq_i32 s1, m0
// CHECK: [0x01,0x7c,0x00,0xbf]

s_cmp_eq_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x00,0xbf]

s_cmp_eq_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x00,0xbf]

s_cmp_eq_i32 s1, 0
// CHECK: [0x01,0x80,0x00,0xbf]

s_cmp_eq_i32 s1, -1
// CHECK: [0x01,0xc1,0x00,0xbf]

s_cmp_eq_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x00,0xbf]

s_cmp_eq_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x00,0xbf]

s_cmp_eq_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x00,0xbf]

s_cmp_eq_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x00,0xbf]

s_cmp_eq_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x00,0xbf]

s_cmp_eq_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x00,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x00,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_i32 s1, s2
// CHECK: [0x01,0x02,0x01,0xbf]

s_cmp_lg_i32 s101, s2
// CHECK: [0x65,0x02,0x01,0xbf]

s_cmp_lg_i32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x01,0xbf]

s_cmp_lg_i32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x01,0xbf]

s_cmp_lg_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x01,0xbf]

s_cmp_lg_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x01,0xbf]

s_cmp_lg_i32 ttmp15, s2
// CHECK: [0x7b,0x02,0x01,0xbf]

s_cmp_lg_i32 m0, s2
// CHECK: [0x7c,0x02,0x01,0xbf]

s_cmp_lg_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x01,0xbf]

s_cmp_lg_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x01,0xbf]

s_cmp_lg_i32 0, s2
// CHECK: [0x80,0x02,0x01,0xbf]

s_cmp_lg_i32 -1, s2
// CHECK: [0xc1,0x02,0x01,0xbf]

s_cmp_lg_i32 0.5, s2
// CHECK: [0xf0,0x02,0x01,0xbf]

s_cmp_lg_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x01,0xbf]

s_cmp_lg_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x01,0xbf]

s_cmp_lg_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x01,0xbf]

s_cmp_lg_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x01,0xbf]

s_cmp_lg_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x01,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x01,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_i32 s1, s101
// CHECK: [0x01,0x65,0x01,0xbf]

s_cmp_lg_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x01,0xbf]

s_cmp_lg_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x01,0xbf]

s_cmp_lg_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x01,0xbf]

s_cmp_lg_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x01,0xbf]

s_cmp_lg_i32 s1, ttmp15
// CHECK: [0x01,0x7b,0x01,0xbf]

s_cmp_lg_i32 s1, m0
// CHECK: [0x01,0x7c,0x01,0xbf]

s_cmp_lg_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x01,0xbf]

s_cmp_lg_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x01,0xbf]

s_cmp_lg_i32 s1, 0
// CHECK: [0x01,0x80,0x01,0xbf]

s_cmp_lg_i32 s1, -1
// CHECK: [0x01,0xc1,0x01,0xbf]

s_cmp_lg_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x01,0xbf]

s_cmp_lg_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x01,0xbf]

s_cmp_lg_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x01,0xbf]

s_cmp_lg_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x01,0xbf]

s_cmp_lg_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x01,0xbf]

s_cmp_lg_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x01,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x01,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_i32 s1, s2
// CHECK: [0x01,0x02,0x02,0xbf]

s_cmp_gt_i32 s101, s2
// CHECK: [0x65,0x02,0x02,0xbf]

s_cmp_gt_i32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x02,0xbf]

s_cmp_gt_i32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x02,0xbf]

s_cmp_gt_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x02,0xbf]

s_cmp_gt_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x02,0xbf]

s_cmp_gt_i32 ttmp15, s2
// CHECK: [0x7b,0x02,0x02,0xbf]

s_cmp_gt_i32 m0, s2
// CHECK: [0x7c,0x02,0x02,0xbf]

s_cmp_gt_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x02,0xbf]

s_cmp_gt_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x02,0xbf]

s_cmp_gt_i32 0, s2
// CHECK: [0x80,0x02,0x02,0xbf]

s_cmp_gt_i32 -1, s2
// CHECK: [0xc1,0x02,0x02,0xbf]

s_cmp_gt_i32 0.5, s2
// CHECK: [0xf0,0x02,0x02,0xbf]

s_cmp_gt_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x02,0xbf]

s_cmp_gt_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x02,0xbf]

s_cmp_gt_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x02,0xbf]

s_cmp_gt_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x02,0xbf]

s_cmp_gt_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x02,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x02,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_i32 s1, s101
// CHECK: [0x01,0x65,0x02,0xbf]

s_cmp_gt_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x02,0xbf]

s_cmp_gt_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x02,0xbf]

s_cmp_gt_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x02,0xbf]

s_cmp_gt_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x02,0xbf]

s_cmp_gt_i32 s1, ttmp15
// CHECK: [0x01,0x7b,0x02,0xbf]

s_cmp_gt_i32 s1, m0
// CHECK: [0x01,0x7c,0x02,0xbf]

s_cmp_gt_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x02,0xbf]

s_cmp_gt_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x02,0xbf]

s_cmp_gt_i32 s1, 0
// CHECK: [0x01,0x80,0x02,0xbf]

s_cmp_gt_i32 s1, -1
// CHECK: [0x01,0xc1,0x02,0xbf]

s_cmp_gt_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x02,0xbf]

s_cmp_gt_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x02,0xbf]

s_cmp_gt_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x02,0xbf]

s_cmp_gt_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x02,0xbf]

s_cmp_gt_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x02,0xbf]

s_cmp_gt_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x02,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x02,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_i32 s1, s2
// CHECK: [0x01,0x02,0x03,0xbf]

s_cmp_ge_i32 s101, s2
// CHECK: [0x65,0x02,0x03,0xbf]

s_cmp_ge_i32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x03,0xbf]

s_cmp_ge_i32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x03,0xbf]

s_cmp_ge_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x03,0xbf]

s_cmp_ge_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x03,0xbf]

s_cmp_ge_i32 ttmp15, s2
// CHECK: [0x7b,0x02,0x03,0xbf]

s_cmp_ge_i32 m0, s2
// CHECK: [0x7c,0x02,0x03,0xbf]

s_cmp_ge_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x03,0xbf]

s_cmp_ge_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x03,0xbf]

s_cmp_ge_i32 0, s2
// CHECK: [0x80,0x02,0x03,0xbf]

s_cmp_ge_i32 -1, s2
// CHECK: [0xc1,0x02,0x03,0xbf]

s_cmp_ge_i32 0.5, s2
// CHECK: [0xf0,0x02,0x03,0xbf]

s_cmp_ge_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x03,0xbf]

s_cmp_ge_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x03,0xbf]

s_cmp_ge_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x03,0xbf]

s_cmp_ge_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x03,0xbf]

s_cmp_ge_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x03,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x03,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_i32 s1, s101
// CHECK: [0x01,0x65,0x03,0xbf]

s_cmp_ge_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x03,0xbf]

s_cmp_ge_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x03,0xbf]

s_cmp_ge_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x03,0xbf]

s_cmp_ge_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x03,0xbf]

s_cmp_ge_i32 s1, ttmp15
// CHECK: [0x01,0x7b,0x03,0xbf]

s_cmp_ge_i32 s1, m0
// CHECK: [0x01,0x7c,0x03,0xbf]

s_cmp_ge_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x03,0xbf]

s_cmp_ge_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x03,0xbf]

s_cmp_ge_i32 s1, 0
// CHECK: [0x01,0x80,0x03,0xbf]

s_cmp_ge_i32 s1, -1
// CHECK: [0x01,0xc1,0x03,0xbf]

s_cmp_ge_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x03,0xbf]

s_cmp_ge_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x03,0xbf]

s_cmp_ge_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x03,0xbf]

s_cmp_ge_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x03,0xbf]

s_cmp_ge_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x03,0xbf]

s_cmp_ge_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x03,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x03,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_i32 s1, s2
// CHECK: [0x01,0x02,0x04,0xbf]

s_cmp_lt_i32 s101, s2
// CHECK: [0x65,0x02,0x04,0xbf]

s_cmp_lt_i32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x04,0xbf]

s_cmp_lt_i32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x04,0xbf]

s_cmp_lt_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x04,0xbf]

s_cmp_lt_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x04,0xbf]

s_cmp_lt_i32 ttmp15, s2
// CHECK: [0x7b,0x02,0x04,0xbf]

s_cmp_lt_i32 m0, s2
// CHECK: [0x7c,0x02,0x04,0xbf]

s_cmp_lt_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x04,0xbf]

s_cmp_lt_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x04,0xbf]

s_cmp_lt_i32 0, s2
// CHECK: [0x80,0x02,0x04,0xbf]

s_cmp_lt_i32 -1, s2
// CHECK: [0xc1,0x02,0x04,0xbf]

s_cmp_lt_i32 0.5, s2
// CHECK: [0xf0,0x02,0x04,0xbf]

s_cmp_lt_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x04,0xbf]

s_cmp_lt_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x04,0xbf]

s_cmp_lt_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x04,0xbf]

s_cmp_lt_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x04,0xbf]

s_cmp_lt_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x04,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x04,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_i32 s1, s101
// CHECK: [0x01,0x65,0x04,0xbf]

s_cmp_lt_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x04,0xbf]

s_cmp_lt_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x04,0xbf]

s_cmp_lt_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x04,0xbf]

s_cmp_lt_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x04,0xbf]

s_cmp_lt_i32 s1, ttmp15
// CHECK: [0x01,0x7b,0x04,0xbf]

s_cmp_lt_i32 s1, m0
// CHECK: [0x01,0x7c,0x04,0xbf]

s_cmp_lt_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x04,0xbf]

s_cmp_lt_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x04,0xbf]

s_cmp_lt_i32 s1, 0
// CHECK: [0x01,0x80,0x04,0xbf]

s_cmp_lt_i32 s1, -1
// CHECK: [0x01,0xc1,0x04,0xbf]

s_cmp_lt_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x04,0xbf]

s_cmp_lt_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x04,0xbf]

s_cmp_lt_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x04,0xbf]

s_cmp_lt_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x04,0xbf]

s_cmp_lt_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x04,0xbf]

s_cmp_lt_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x04,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x04,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_i32 s1, s2
// CHECK: [0x01,0x02,0x05,0xbf]

s_cmp_le_i32 s101, s2
// CHECK: [0x65,0x02,0x05,0xbf]

s_cmp_le_i32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x05,0xbf]

s_cmp_le_i32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x05,0xbf]

s_cmp_le_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0xbf]

s_cmp_le_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0xbf]

s_cmp_le_i32 ttmp15, s2
// CHECK: [0x7b,0x02,0x05,0xbf]

s_cmp_le_i32 m0, s2
// CHECK: [0x7c,0x02,0x05,0xbf]

s_cmp_le_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0xbf]

s_cmp_le_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0xbf]

s_cmp_le_i32 0, s2
// CHECK: [0x80,0x02,0x05,0xbf]

s_cmp_le_i32 -1, s2
// CHECK: [0xc1,0x02,0x05,0xbf]

s_cmp_le_i32 0.5, s2
// CHECK: [0xf0,0x02,0x05,0xbf]

s_cmp_le_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x05,0xbf]

s_cmp_le_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0xbf]

s_cmp_le_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x05,0xbf]

s_cmp_le_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x05,0xbf]

s_cmp_le_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_i32 s1, s101
// CHECK: [0x01,0x65,0x05,0xbf]

s_cmp_le_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x05,0xbf]

s_cmp_le_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x05,0xbf]

s_cmp_le_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0xbf]

s_cmp_le_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0xbf]

s_cmp_le_i32 s1, ttmp15
// CHECK: [0x01,0x7b,0x05,0xbf]

s_cmp_le_i32 s1, m0
// CHECK: [0x01,0x7c,0x05,0xbf]

s_cmp_le_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0xbf]

s_cmp_le_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0xbf]

s_cmp_le_i32 s1, 0
// CHECK: [0x01,0x80,0x05,0xbf]

s_cmp_le_i32 s1, -1
// CHECK: [0x01,0xc1,0x05,0xbf]

s_cmp_le_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x05,0xbf]

s_cmp_le_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x05,0xbf]

s_cmp_le_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0xbf]

s_cmp_le_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x05,0xbf]

s_cmp_le_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x05,0xbf]

s_cmp_le_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u32 s1, s2
// CHECK: [0x01,0x02,0x06,0xbf]

s_cmp_eq_u32 s101, s2
// CHECK: [0x65,0x02,0x06,0xbf]

s_cmp_eq_u32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x06,0xbf]

s_cmp_eq_u32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x06,0xbf]

s_cmp_eq_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x06,0xbf]

s_cmp_eq_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x06,0xbf]

s_cmp_eq_u32 ttmp15, s2
// CHECK: [0x7b,0x02,0x06,0xbf]

s_cmp_eq_u32 m0, s2
// CHECK: [0x7c,0x02,0x06,0xbf]

s_cmp_eq_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x06,0xbf]

s_cmp_eq_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x06,0xbf]

s_cmp_eq_u32 0, s2
// CHECK: [0x80,0x02,0x06,0xbf]

s_cmp_eq_u32 -1, s2
// CHECK: [0xc1,0x02,0x06,0xbf]

s_cmp_eq_u32 0.5, s2
// CHECK: [0xf0,0x02,0x06,0xbf]

s_cmp_eq_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x06,0xbf]

s_cmp_eq_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x06,0xbf]

s_cmp_eq_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x06,0xbf]

s_cmp_eq_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x06,0xbf]

s_cmp_eq_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x06,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x06,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u32 s1, s101
// CHECK: [0x01,0x65,0x06,0xbf]

s_cmp_eq_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x06,0xbf]

s_cmp_eq_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x06,0xbf]

s_cmp_eq_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x06,0xbf]

s_cmp_eq_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x06,0xbf]

s_cmp_eq_u32 s1, ttmp15
// CHECK: [0x01,0x7b,0x06,0xbf]

s_cmp_eq_u32 s1, m0
// CHECK: [0x01,0x7c,0x06,0xbf]

s_cmp_eq_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x06,0xbf]

s_cmp_eq_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x06,0xbf]

s_cmp_eq_u32 s1, 0
// CHECK: [0x01,0x80,0x06,0xbf]

s_cmp_eq_u32 s1, -1
// CHECK: [0x01,0xc1,0x06,0xbf]

s_cmp_eq_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x06,0xbf]

s_cmp_eq_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x06,0xbf]

s_cmp_eq_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x06,0xbf]

s_cmp_eq_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x06,0xbf]

s_cmp_eq_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x06,0xbf]

s_cmp_eq_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x06,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x06,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u32 s1, s2
// CHECK: [0x01,0x02,0x07,0xbf]

s_cmp_lg_u32 s101, s2
// CHECK: [0x65,0x02,0x07,0xbf]

s_cmp_lg_u32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x07,0xbf]

s_cmp_lg_u32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x07,0xbf]

s_cmp_lg_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x07,0xbf]

s_cmp_lg_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x07,0xbf]

s_cmp_lg_u32 ttmp15, s2
// CHECK: [0x7b,0x02,0x07,0xbf]

s_cmp_lg_u32 m0, s2
// CHECK: [0x7c,0x02,0x07,0xbf]

s_cmp_lg_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x07,0xbf]

s_cmp_lg_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x07,0xbf]

s_cmp_lg_u32 0, s2
// CHECK: [0x80,0x02,0x07,0xbf]

s_cmp_lg_u32 -1, s2
// CHECK: [0xc1,0x02,0x07,0xbf]

s_cmp_lg_u32 0.5, s2
// CHECK: [0xf0,0x02,0x07,0xbf]

s_cmp_lg_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x07,0xbf]

s_cmp_lg_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x07,0xbf]

s_cmp_lg_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x07,0xbf]

s_cmp_lg_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x07,0xbf]

s_cmp_lg_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x07,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x07,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u32 s1, s101
// CHECK: [0x01,0x65,0x07,0xbf]

s_cmp_lg_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x07,0xbf]

s_cmp_lg_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x07,0xbf]

s_cmp_lg_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x07,0xbf]

s_cmp_lg_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x07,0xbf]

s_cmp_lg_u32 s1, ttmp15
// CHECK: [0x01,0x7b,0x07,0xbf]

s_cmp_lg_u32 s1, m0
// CHECK: [0x01,0x7c,0x07,0xbf]

s_cmp_lg_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x07,0xbf]

s_cmp_lg_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x07,0xbf]

s_cmp_lg_u32 s1, 0
// CHECK: [0x01,0x80,0x07,0xbf]

s_cmp_lg_u32 s1, -1
// CHECK: [0x01,0xc1,0x07,0xbf]

s_cmp_lg_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x07,0xbf]

s_cmp_lg_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x07,0xbf]

s_cmp_lg_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x07,0xbf]

s_cmp_lg_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x07,0xbf]

s_cmp_lg_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x07,0xbf]

s_cmp_lg_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x07,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x07,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_u32 s1, s2
// CHECK: [0x01,0x02,0x08,0xbf]

s_cmp_gt_u32 s101, s2
// CHECK: [0x65,0x02,0x08,0xbf]

s_cmp_gt_u32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x08,0xbf]

s_cmp_gt_u32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x08,0xbf]

s_cmp_gt_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x08,0xbf]

s_cmp_gt_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x08,0xbf]

s_cmp_gt_u32 ttmp15, s2
// CHECK: [0x7b,0x02,0x08,0xbf]

s_cmp_gt_u32 m0, s2
// CHECK: [0x7c,0x02,0x08,0xbf]

s_cmp_gt_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x08,0xbf]

s_cmp_gt_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x08,0xbf]

s_cmp_gt_u32 0, s2
// CHECK: [0x80,0x02,0x08,0xbf]

s_cmp_gt_u32 -1, s2
// CHECK: [0xc1,0x02,0x08,0xbf]

s_cmp_gt_u32 0.5, s2
// CHECK: [0xf0,0x02,0x08,0xbf]

s_cmp_gt_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x08,0xbf]

s_cmp_gt_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x08,0xbf]

s_cmp_gt_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x08,0xbf]

s_cmp_gt_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x08,0xbf]

s_cmp_gt_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x08,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x08,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_u32 s1, s101
// CHECK: [0x01,0x65,0x08,0xbf]

s_cmp_gt_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x08,0xbf]

s_cmp_gt_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x08,0xbf]

s_cmp_gt_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x08,0xbf]

s_cmp_gt_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x08,0xbf]

s_cmp_gt_u32 s1, ttmp15
// CHECK: [0x01,0x7b,0x08,0xbf]

s_cmp_gt_u32 s1, m0
// CHECK: [0x01,0x7c,0x08,0xbf]

s_cmp_gt_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x08,0xbf]

s_cmp_gt_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x08,0xbf]

s_cmp_gt_u32 s1, 0
// CHECK: [0x01,0x80,0x08,0xbf]

s_cmp_gt_u32 s1, -1
// CHECK: [0x01,0xc1,0x08,0xbf]

s_cmp_gt_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x08,0xbf]

s_cmp_gt_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x08,0xbf]

s_cmp_gt_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x08,0xbf]

s_cmp_gt_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x08,0xbf]

s_cmp_gt_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x08,0xbf]

s_cmp_gt_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x08,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x08,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_u32 s1, s2
// CHECK: [0x01,0x02,0x09,0xbf]

s_cmp_ge_u32 s101, s2
// CHECK: [0x65,0x02,0x09,0xbf]

s_cmp_ge_u32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x09,0xbf]

s_cmp_ge_u32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x09,0xbf]

s_cmp_ge_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x09,0xbf]

s_cmp_ge_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x09,0xbf]

s_cmp_ge_u32 ttmp15, s2
// CHECK: [0x7b,0x02,0x09,0xbf]

s_cmp_ge_u32 m0, s2
// CHECK: [0x7c,0x02,0x09,0xbf]

s_cmp_ge_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x09,0xbf]

s_cmp_ge_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x09,0xbf]

s_cmp_ge_u32 0, s2
// CHECK: [0x80,0x02,0x09,0xbf]

s_cmp_ge_u32 -1, s2
// CHECK: [0xc1,0x02,0x09,0xbf]

s_cmp_ge_u32 0.5, s2
// CHECK: [0xf0,0x02,0x09,0xbf]

s_cmp_ge_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x09,0xbf]

s_cmp_ge_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x09,0xbf]

s_cmp_ge_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x09,0xbf]

s_cmp_ge_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x09,0xbf]

s_cmp_ge_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x09,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x09,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_u32 s1, s101
// CHECK: [0x01,0x65,0x09,0xbf]

s_cmp_ge_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x09,0xbf]

s_cmp_ge_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x09,0xbf]

s_cmp_ge_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x09,0xbf]

s_cmp_ge_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x09,0xbf]

s_cmp_ge_u32 s1, ttmp15
// CHECK: [0x01,0x7b,0x09,0xbf]

s_cmp_ge_u32 s1, m0
// CHECK: [0x01,0x7c,0x09,0xbf]

s_cmp_ge_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x09,0xbf]

s_cmp_ge_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x09,0xbf]

s_cmp_ge_u32 s1, 0
// CHECK: [0x01,0x80,0x09,0xbf]

s_cmp_ge_u32 s1, -1
// CHECK: [0x01,0xc1,0x09,0xbf]

s_cmp_ge_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x09,0xbf]

s_cmp_ge_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x09,0xbf]

s_cmp_ge_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x09,0xbf]

s_cmp_ge_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x09,0xbf]

s_cmp_ge_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x09,0xbf]

s_cmp_ge_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x09,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x09,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_u32 s1, s2
// CHECK: [0x01,0x02,0x0a,0xbf]

s_cmp_lt_u32 s101, s2
// CHECK: [0x65,0x02,0x0a,0xbf]

s_cmp_lt_u32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x0a,0xbf]

s_cmp_lt_u32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x0a,0xbf]

s_cmp_lt_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0a,0xbf]

s_cmp_lt_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0a,0xbf]

s_cmp_lt_u32 ttmp15, s2
// CHECK: [0x7b,0x02,0x0a,0xbf]

s_cmp_lt_u32 m0, s2
// CHECK: [0x7c,0x02,0x0a,0xbf]

s_cmp_lt_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0a,0xbf]

s_cmp_lt_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0a,0xbf]

s_cmp_lt_u32 0, s2
// CHECK: [0x80,0x02,0x0a,0xbf]

s_cmp_lt_u32 -1, s2
// CHECK: [0xc1,0x02,0x0a,0xbf]

s_cmp_lt_u32 0.5, s2
// CHECK: [0xf0,0x02,0x0a,0xbf]

s_cmp_lt_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x0a,0xbf]

s_cmp_lt_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x0a,0xbf]

s_cmp_lt_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x0a,0xbf]

s_cmp_lt_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x0a,0xbf]

s_cmp_lt_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_u32 s1, s101
// CHECK: [0x01,0x65,0x0a,0xbf]

s_cmp_lt_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x0a,0xbf]

s_cmp_lt_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x0a,0xbf]

s_cmp_lt_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0a,0xbf]

s_cmp_lt_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0a,0xbf]

s_cmp_lt_u32 s1, ttmp15
// CHECK: [0x01,0x7b,0x0a,0xbf]

s_cmp_lt_u32 s1, m0
// CHECK: [0x01,0x7c,0x0a,0xbf]

s_cmp_lt_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0a,0xbf]

s_cmp_lt_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0a,0xbf]

s_cmp_lt_u32 s1, 0
// CHECK: [0x01,0x80,0x0a,0xbf]

s_cmp_lt_u32 s1, -1
// CHECK: [0x01,0xc1,0x0a,0xbf]

s_cmp_lt_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x0a,0xbf]

s_cmp_lt_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x0a,0xbf]

s_cmp_lt_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x0a,0xbf]

s_cmp_lt_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x0a,0xbf]

s_cmp_lt_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x0a,0xbf]

s_cmp_lt_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_u32 s1, s2
// CHECK: [0x01,0x02,0x0b,0xbf]

s_cmp_le_u32 s101, s2
// CHECK: [0x65,0x02,0x0b,0xbf]

s_cmp_le_u32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x0b,0xbf]

s_cmp_le_u32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x0b,0xbf]

s_cmp_le_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0b,0xbf]

s_cmp_le_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0b,0xbf]

s_cmp_le_u32 ttmp15, s2
// CHECK: [0x7b,0x02,0x0b,0xbf]

s_cmp_le_u32 m0, s2
// CHECK: [0x7c,0x02,0x0b,0xbf]

s_cmp_le_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0b,0xbf]

s_cmp_le_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0b,0xbf]

s_cmp_le_u32 0, s2
// CHECK: [0x80,0x02,0x0b,0xbf]

s_cmp_le_u32 -1, s2
// CHECK: [0xc1,0x02,0x0b,0xbf]

s_cmp_le_u32 0.5, s2
// CHECK: [0xf0,0x02,0x0b,0xbf]

s_cmp_le_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x0b,0xbf]

s_cmp_le_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x0b,0xbf]

s_cmp_le_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x0b,0xbf]

s_cmp_le_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x0b,0xbf]

s_cmp_le_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0b,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0b,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_u32 s1, s101
// CHECK: [0x01,0x65,0x0b,0xbf]

s_cmp_le_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x0b,0xbf]

s_cmp_le_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x0b,0xbf]

s_cmp_le_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0b,0xbf]

s_cmp_le_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0b,0xbf]

s_cmp_le_u32 s1, ttmp15
// CHECK: [0x01,0x7b,0x0b,0xbf]

s_cmp_le_u32 s1, m0
// CHECK: [0x01,0x7c,0x0b,0xbf]

s_cmp_le_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0b,0xbf]

s_cmp_le_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0b,0xbf]

s_cmp_le_u32 s1, 0
// CHECK: [0x01,0x80,0x0b,0xbf]

s_cmp_le_u32 s1, -1
// CHECK: [0x01,0xc1,0x0b,0xbf]

s_cmp_le_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x0b,0xbf]

s_cmp_le_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x0b,0xbf]

s_cmp_le_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x0b,0xbf]

s_cmp_le_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x0b,0xbf]

s_cmp_le_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x0b,0xbf]

s_cmp_le_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0b,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0b,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b32 s1, s2
// CHECK: [0x01,0x02,0x0c,0xbf]

s_bitcmp0_b32 s101, s2
// CHECK: [0x65,0x02,0x0c,0xbf]

s_bitcmp0_b32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x0c,0xbf]

s_bitcmp0_b32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x0c,0xbf]

s_bitcmp0_b32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0c,0xbf]

s_bitcmp0_b32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0c,0xbf]

s_bitcmp0_b32 ttmp15, s2
// CHECK: [0x7b,0x02,0x0c,0xbf]

s_bitcmp0_b32 m0, s2
// CHECK: [0x7c,0x02,0x0c,0xbf]

s_bitcmp0_b32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0c,0xbf]

s_bitcmp0_b32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0c,0xbf]

s_bitcmp0_b32 0, s2
// CHECK: [0x80,0x02,0x0c,0xbf]

s_bitcmp0_b32 -1, s2
// CHECK: [0xc1,0x02,0x0c,0xbf]

s_bitcmp0_b32 0.5, s2
// CHECK: [0xf0,0x02,0x0c,0xbf]

s_bitcmp0_b32 -4.0, s2
// CHECK: [0xf7,0x02,0x0c,0xbf]

s_bitcmp0_b32 src_vccz, s2
// CHECK: [0xfb,0x02,0x0c,0xbf]

s_bitcmp0_b32 src_execz, s2
// CHECK: [0xfc,0x02,0x0c,0xbf]

s_bitcmp0_b32 src_scc, s2
// CHECK: [0xfd,0x02,0x0c,0xbf]

s_bitcmp0_b32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0c,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0c,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b32 s1, s101
// CHECK: [0x01,0x65,0x0c,0xbf]

s_bitcmp0_b32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x0c,0xbf]

s_bitcmp0_b32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x0c,0xbf]

s_bitcmp0_b32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0c,0xbf]

s_bitcmp0_b32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0c,0xbf]

s_bitcmp0_b32 s1, ttmp15
// CHECK: [0x01,0x7b,0x0c,0xbf]

s_bitcmp0_b32 s1, m0
// CHECK: [0x01,0x7c,0x0c,0xbf]

s_bitcmp0_b32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0c,0xbf]

s_bitcmp0_b32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0c,0xbf]

s_bitcmp0_b32 s1, 0
// CHECK: [0x01,0x80,0x0c,0xbf]

s_bitcmp0_b32 s1, -1
// CHECK: [0x01,0xc1,0x0c,0xbf]

s_bitcmp0_b32 s1, 0.5
// CHECK: [0x01,0xf0,0x0c,0xbf]

s_bitcmp0_b32 s1, -4.0
// CHECK: [0x01,0xf7,0x0c,0xbf]

s_bitcmp0_b32 s1, src_vccz
// CHECK: [0x01,0xfb,0x0c,0xbf]

s_bitcmp0_b32 s1, src_execz
// CHECK: [0x01,0xfc,0x0c,0xbf]

s_bitcmp0_b32 s1, src_scc
// CHECK: [0x01,0xfd,0x0c,0xbf]

s_bitcmp0_b32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0c,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0c,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b32 s1, s2
// CHECK: [0x01,0x02,0x0d,0xbf]

s_bitcmp1_b32 s101, s2
// CHECK: [0x65,0x02,0x0d,0xbf]

s_bitcmp1_b32 flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x0d,0xbf]

s_bitcmp1_b32 flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x0d,0xbf]

s_bitcmp1_b32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0d,0xbf]

s_bitcmp1_b32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0d,0xbf]

s_bitcmp1_b32 ttmp15, s2
// CHECK: [0x7b,0x02,0x0d,0xbf]

s_bitcmp1_b32 m0, s2
// CHECK: [0x7c,0x02,0x0d,0xbf]

s_bitcmp1_b32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0d,0xbf]

s_bitcmp1_b32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0d,0xbf]

s_bitcmp1_b32 0, s2
// CHECK: [0x80,0x02,0x0d,0xbf]

s_bitcmp1_b32 -1, s2
// CHECK: [0xc1,0x02,0x0d,0xbf]

s_bitcmp1_b32 0.5, s2
// CHECK: [0xf0,0x02,0x0d,0xbf]

s_bitcmp1_b32 -4.0, s2
// CHECK: [0xf7,0x02,0x0d,0xbf]

s_bitcmp1_b32 src_vccz, s2
// CHECK: [0xfb,0x02,0x0d,0xbf]

s_bitcmp1_b32 src_execz, s2
// CHECK: [0xfc,0x02,0x0d,0xbf]

s_bitcmp1_b32 src_scc, s2
// CHECK: [0xfd,0x02,0x0d,0xbf]

s_bitcmp1_b32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0d,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0d,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b32 s1, s101
// CHECK: [0x01,0x65,0x0d,0xbf]

s_bitcmp1_b32 s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x0d,0xbf]

s_bitcmp1_b32 s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x0d,0xbf]

s_bitcmp1_b32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0d,0xbf]

s_bitcmp1_b32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0d,0xbf]

s_bitcmp1_b32 s1, ttmp15
// CHECK: [0x01,0x7b,0x0d,0xbf]

s_bitcmp1_b32 s1, m0
// CHECK: [0x01,0x7c,0x0d,0xbf]

s_bitcmp1_b32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0d,0xbf]

s_bitcmp1_b32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0d,0xbf]

s_bitcmp1_b32 s1, 0
// CHECK: [0x01,0x80,0x0d,0xbf]

s_bitcmp1_b32 s1, -1
// CHECK: [0x01,0xc1,0x0d,0xbf]

s_bitcmp1_b32 s1, 0.5
// CHECK: [0x01,0xf0,0x0d,0xbf]

s_bitcmp1_b32 s1, -4.0
// CHECK: [0x01,0xf7,0x0d,0xbf]

s_bitcmp1_b32 s1, src_vccz
// CHECK: [0x01,0xfb,0x0d,0xbf]

s_bitcmp1_b32 s1, src_execz
// CHECK: [0x01,0xfc,0x0d,0xbf]

s_bitcmp1_b32 s1, src_scc
// CHECK: [0x01,0xfd,0x0d,0xbf]

s_bitcmp1_b32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0d,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0d,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b64 s[2:3], s2
// CHECK: [0x02,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[4:5], s2
// CHECK: [0x04,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[100:101], s2
// CHECK: [0x64,0x02,0x0e,0xbf]

s_bitcmp0_b64 flat_scratch, s2
// CHECK: [0x66,0x02,0x0e,0xbf]

s_bitcmp0_b64 vcc, s2
// CHECK: [0x6a,0x02,0x0e,0xbf]

s_bitcmp0_b64 ttmp[14:15], s2
// CHECK: [0x7a,0x02,0x0e,0xbf]

s_bitcmp0_b64 exec, s2
// CHECK: [0x7e,0x02,0x0e,0xbf]

s_bitcmp0_b64 0, s2
// CHECK: [0x80,0x02,0x0e,0xbf]

s_bitcmp0_b64 -1, s2
// CHECK: [0xc1,0x02,0x0e,0xbf]

s_bitcmp0_b64 0.5, s2
// CHECK: [0xf0,0x02,0x0e,0xbf]

s_bitcmp0_b64 -4.0, s2
// CHECK: [0xf7,0x02,0x0e,0xbf]

s_bitcmp0_b64 src_vccz, s2
// CHECK: [0xfb,0x02,0x0e,0xbf]

s_bitcmp0_b64 src_execz, s2
// CHECK: [0xfc,0x02,0x0e,0xbf]

s_bitcmp0_b64 src_scc, s2
// CHECK: [0xfd,0x02,0x0e,0xbf]

s_bitcmp0_b64 0xaf123456, s2
// CHECK: [0xff,0x02,0x0e,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b64 0x3f717273, s2
// CHECK: [0xff,0x02,0x0e,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b64 s[2:3], s101
// CHECK: [0x02,0x65,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], flat_scratch_lo
// CHECK: [0x02,0x66,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], flat_scratch_hi
// CHECK: [0x02,0x67,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], ttmp15
// CHECK: [0x02,0x7b,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], m0
// CHECK: [0x02,0x7c,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], 0
// CHECK: [0x02,0x80,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], -1
// CHECK: [0x02,0xc1,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], 0.5
// CHECK: [0x02,0xf0,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], -4.0
// CHECK: [0x02,0xf7,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], src_execz
// CHECK: [0x02,0xfc,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], src_scc
// CHECK: [0x02,0xfd,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x0e,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b64 s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x0e,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b64 s[2:3], s2
// CHECK: [0x02,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[4:5], s2
// CHECK: [0x04,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[100:101], s2
// CHECK: [0x64,0x02,0x0f,0xbf]

s_bitcmp1_b64 flat_scratch, s2
// CHECK: [0x66,0x02,0x0f,0xbf]

s_bitcmp1_b64 vcc, s2
// CHECK: [0x6a,0x02,0x0f,0xbf]

s_bitcmp1_b64 ttmp[14:15], s2
// CHECK: [0x7a,0x02,0x0f,0xbf]

s_bitcmp1_b64 exec, s2
// CHECK: [0x7e,0x02,0x0f,0xbf]

s_bitcmp1_b64 0, s2
// CHECK: [0x80,0x02,0x0f,0xbf]

s_bitcmp1_b64 -1, s2
// CHECK: [0xc1,0x02,0x0f,0xbf]

s_bitcmp1_b64 0.5, s2
// CHECK: [0xf0,0x02,0x0f,0xbf]

s_bitcmp1_b64 -4.0, s2
// CHECK: [0xf7,0x02,0x0f,0xbf]

s_bitcmp1_b64 src_vccz, s2
// CHECK: [0xfb,0x02,0x0f,0xbf]

s_bitcmp1_b64 src_execz, s2
// CHECK: [0xfc,0x02,0x0f,0xbf]

s_bitcmp1_b64 src_scc, s2
// CHECK: [0xfd,0x02,0x0f,0xbf]

s_bitcmp1_b64 0xaf123456, s2
// CHECK: [0xff,0x02,0x0f,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b64 0x3f717273, s2
// CHECK: [0xff,0x02,0x0f,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b64 s[2:3], s101
// CHECK: [0x02,0x65,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], flat_scratch_lo
// CHECK: [0x02,0x66,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], flat_scratch_hi
// CHECK: [0x02,0x67,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], ttmp15
// CHECK: [0x02,0x7b,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], m0
// CHECK: [0x02,0x7c,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], 0
// CHECK: [0x02,0x80,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], -1
// CHECK: [0x02,0xc1,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], 0.5
// CHECK: [0x02,0xf0,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], -4.0
// CHECK: [0x02,0xf7,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], src_execz
// CHECK: [0x02,0xfc,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], src_scc
// CHECK: [0x02,0xfd,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x0f,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b64 s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x0f,0xbf,0x73,0x72,0x71,0x3f]

s_setvskip s1, s2
// CHECK: [0x01,0x02,0x10,0xbf]

s_setvskip s101, s2
// CHECK: [0x65,0x02,0x10,0xbf]

s_setvskip flat_scratch_lo, s2
// CHECK: [0x66,0x02,0x10,0xbf]

s_setvskip flat_scratch_hi, s2
// CHECK: [0x67,0x02,0x10,0xbf]

s_setvskip vcc_lo, s2
// CHECK: [0x6a,0x02,0x10,0xbf]

s_setvskip vcc_hi, s2
// CHECK: [0x6b,0x02,0x10,0xbf]

s_setvskip ttmp15, s2
// CHECK: [0x7b,0x02,0x10,0xbf]

s_setvskip m0, s2
// CHECK: [0x7c,0x02,0x10,0xbf]

s_setvskip exec_lo, s2
// CHECK: [0x7e,0x02,0x10,0xbf]

s_setvskip exec_hi, s2
// CHECK: [0x7f,0x02,0x10,0xbf]

s_setvskip 0, s2
// CHECK: [0x80,0x02,0x10,0xbf]

s_setvskip -1, s2
// CHECK: [0xc1,0x02,0x10,0xbf]

s_setvskip 0.5, s2
// CHECK: [0xf0,0x02,0x10,0xbf]

s_setvskip -4.0, s2
// CHECK: [0xf7,0x02,0x10,0xbf]

s_setvskip src_vccz, s2
// CHECK: [0xfb,0x02,0x10,0xbf]

s_setvskip src_execz, s2
// CHECK: [0xfc,0x02,0x10,0xbf]

s_setvskip src_scc, s2
// CHECK: [0xfd,0x02,0x10,0xbf]

s_setvskip 0xaf123456, s2
// CHECK: [0xff,0x02,0x10,0xbf,0x56,0x34,0x12,0xaf]

s_setvskip 0x3f717273, s2
// CHECK: [0xff,0x02,0x10,0xbf,0x73,0x72,0x71,0x3f]

s_setvskip s1, s101
// CHECK: [0x01,0x65,0x10,0xbf]

s_setvskip s1, flat_scratch_lo
// CHECK: [0x01,0x66,0x10,0xbf]

s_setvskip s1, flat_scratch_hi
// CHECK: [0x01,0x67,0x10,0xbf]

s_setvskip s1, vcc_lo
// CHECK: [0x01,0x6a,0x10,0xbf]

s_setvskip s1, vcc_hi
// CHECK: [0x01,0x6b,0x10,0xbf]

s_setvskip s1, ttmp15
// CHECK: [0x01,0x7b,0x10,0xbf]

s_setvskip s1, m0
// CHECK: [0x01,0x7c,0x10,0xbf]

s_setvskip s1, exec_lo
// CHECK: [0x01,0x7e,0x10,0xbf]

s_setvskip s1, exec_hi
// CHECK: [0x01,0x7f,0x10,0xbf]

s_setvskip s1, 0
// CHECK: [0x01,0x80,0x10,0xbf]

s_setvskip s1, -1
// CHECK: [0x01,0xc1,0x10,0xbf]

s_setvskip s1, 0.5
// CHECK: [0x01,0xf0,0x10,0xbf]

s_setvskip s1, -4.0
// CHECK: [0x01,0xf7,0x10,0xbf]

s_setvskip s1, src_vccz
// CHECK: [0x01,0xfb,0x10,0xbf]

s_setvskip s1, src_execz
// CHECK: [0x01,0xfc,0x10,0xbf]

s_setvskip s1, src_scc
// CHECK: [0x01,0xfd,0x10,0xbf]

s_setvskip s1, 0xaf123456
// CHECK: [0x01,0xff,0x10,0xbf,0x56,0x34,0x12,0xaf]

s_setvskip s1, 0x3f717273
// CHECK: [0x01,0xff,0x10,0xbf,0x73,0x72,0x71,0x3f]

s_set_gpr_idx_on s1, 0x0
// CHECK: [0x01,0x00,0x11,0xbf]

s_set_gpr_idx_on s101, 0x0
// CHECK: [0x65,0x00,0x11,0xbf]

s_set_gpr_idx_on flat_scratch_lo, 0x0
// CHECK: [0x66,0x00,0x11,0xbf]

s_set_gpr_idx_on flat_scratch_hi, 0x0
// CHECK: [0x67,0x00,0x11,0xbf]

s_set_gpr_idx_on vcc_lo, 0x0
// CHECK: [0x6a,0x00,0x11,0xbf]

s_set_gpr_idx_on vcc_hi, 0x0
// CHECK: [0x6b,0x00,0x11,0xbf]

s_set_gpr_idx_on ttmp15, 0x0
// CHECK: [0x7b,0x00,0x11,0xbf]

s_set_gpr_idx_on m0, 0x0
// CHECK: [0x7c,0x00,0x11,0xbf]

s_set_gpr_idx_on 0, 0x0
// CHECK: [0x80,0x00,0x11,0xbf]

s_set_gpr_idx_on -1, 0x0
// CHECK: [0xc1,0x00,0x11,0xbf]

s_set_gpr_idx_on 0.5, 0x0
// CHECK: [0xf0,0x00,0x11,0xbf]

s_set_gpr_idx_on -4.0, 0x0
// CHECK: [0xf7,0x00,0x11,0xbf]

s_set_gpr_idx_on src_vccz, 0x0
// CHECK: [0xfb,0x00,0x11,0xbf]

s_set_gpr_idx_on src_execz, 0x0
// CHECK: [0xfc,0x00,0x11,0xbf]

s_set_gpr_idx_on src_scc, 0x0
// CHECK: [0xfd,0x00,0x11,0xbf]

s_set_gpr_idx_on 0xaf123456, 0x0
// CHECK: [0xff,0x00,0x11,0xbf,0x56,0x34,0x12,0xaf]

s_set_gpr_idx_on 0x3f717273, 0x0
// CHECK: [0xff,0x00,0x11,0xbf,0x73,0x72,0x71,0x3f]

s_set_gpr_idx_on s1, 0x1
// CHECK: [0x01,0x01,0x11,0xbf]

s_set_gpr_idx_on s1, 0xF
// CHECK: [0x01,0x0f,0x11,0xbf]

s_cmp_eq_u64 s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x12,0xbf]

s_cmp_eq_u64 s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x12,0xbf]

s_cmp_eq_u64 s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x12,0xbf]

s_cmp_eq_u64 flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x12,0xbf]

s_cmp_eq_u64 vcc, s[4:5]
// CHECK: [0x6a,0x04,0x12,0xbf]

s_cmp_eq_u64 ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x12,0xbf]

s_cmp_eq_u64 exec, s[4:5]
// CHECK: [0x7e,0x04,0x12,0xbf]

s_cmp_eq_u64 0, s[4:5]
// CHECK: [0x80,0x04,0x12,0xbf]

s_cmp_eq_u64 -1, s[4:5]
// CHECK: [0xc1,0x04,0x12,0xbf]

s_cmp_eq_u64 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x12,0xbf]

s_cmp_eq_u64 -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x12,0xbf]

s_cmp_eq_u64 src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x12,0xbf]

s_cmp_eq_u64 src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x12,0xbf]

s_cmp_eq_u64 src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x12,0xbf]

s_cmp_eq_u64 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x12,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u64 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x12,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u64 s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x12,0xbf]

s_cmp_eq_u64 s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x12,0xbf]

s_cmp_eq_u64 s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x12,0xbf]

s_cmp_eq_u64 s[2:3], vcc
// CHECK: [0x02,0x6a,0x12,0xbf]

s_cmp_eq_u64 s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x12,0xbf]

s_cmp_eq_u64 s[2:3], exec
// CHECK: [0x02,0x7e,0x12,0xbf]

s_cmp_eq_u64 s[2:3], 0
// CHECK: [0x02,0x80,0x12,0xbf]

s_cmp_eq_u64 s[2:3], -1
// CHECK: [0x02,0xc1,0x12,0xbf]

s_cmp_eq_u64 s[2:3], 0.5
// CHECK: [0x02,0xf0,0x12,0xbf]

s_cmp_eq_u64 s[2:3], -4.0
// CHECK: [0x02,0xf7,0x12,0xbf]

s_cmp_eq_u64 s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x12,0xbf]

s_cmp_eq_u64 s[2:3], src_execz
// CHECK: [0x02,0xfc,0x12,0xbf]

s_cmp_eq_u64 s[2:3], src_scc
// CHECK: [0x02,0xfd,0x12,0xbf]

s_cmp_eq_u64 s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x12,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u64 s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x12,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u64 s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x13,0xbf]

s_cmp_lg_u64 s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x13,0xbf]

s_cmp_lg_u64 s[100:101], s[4:5]
// CHECK: [0x64,0x04,0x13,0xbf]

s_cmp_lg_u64 flat_scratch, s[4:5]
// CHECK: [0x66,0x04,0x13,0xbf]

s_cmp_lg_u64 vcc, s[4:5]
// CHECK: [0x6a,0x04,0x13,0xbf]

s_cmp_lg_u64 ttmp[14:15], s[4:5]
// CHECK: [0x7a,0x04,0x13,0xbf]

s_cmp_lg_u64 exec, s[4:5]
// CHECK: [0x7e,0x04,0x13,0xbf]

s_cmp_lg_u64 0, s[4:5]
// CHECK: [0x80,0x04,0x13,0xbf]

s_cmp_lg_u64 -1, s[4:5]
// CHECK: [0xc1,0x04,0x13,0xbf]

s_cmp_lg_u64 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x13,0xbf]

s_cmp_lg_u64 -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x13,0xbf]

s_cmp_lg_u64 src_vccz, s[4:5]
// CHECK: [0xfb,0x04,0x13,0xbf]

s_cmp_lg_u64 src_execz, s[4:5]
// CHECK: [0xfc,0x04,0x13,0xbf]

s_cmp_lg_u64 src_scc, s[4:5]
// CHECK: [0xfd,0x04,0x13,0xbf]

s_cmp_lg_u64 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x13,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u64 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x13,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u64 s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x13,0xbf]

s_cmp_lg_u64 s[2:3], s[100:101]
// CHECK: [0x02,0x64,0x13,0xbf]

s_cmp_lg_u64 s[2:3], flat_scratch
// CHECK: [0x02,0x66,0x13,0xbf]

s_cmp_lg_u64 s[2:3], vcc
// CHECK: [0x02,0x6a,0x13,0xbf]

s_cmp_lg_u64 s[2:3], ttmp[14:15]
// CHECK: [0x02,0x7a,0x13,0xbf]

s_cmp_lg_u64 s[2:3], exec
// CHECK: [0x02,0x7e,0x13,0xbf]

s_cmp_lg_u64 s[2:3], 0
// CHECK: [0x02,0x80,0x13,0xbf]

s_cmp_lg_u64 s[2:3], -1
// CHECK: [0x02,0xc1,0x13,0xbf]

s_cmp_lg_u64 s[2:3], 0.5
// CHECK: [0x02,0xf0,0x13,0xbf]

s_cmp_lg_u64 s[2:3], -4.0
// CHECK: [0x02,0xf7,0x13,0xbf]

s_cmp_lg_u64 s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x13,0xbf]

s_cmp_lg_u64 s[2:3], src_execz
// CHECK: [0x02,0xfc,0x13,0xbf]

s_cmp_lg_u64 s[2:3], src_scc
// CHECK: [0x02,0xfd,0x13,0xbf]

s_cmp_lg_u64 s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x13,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u64 s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x13,0xbf,0x73,0x72,0x71,0x3f]
