; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test i128 maximum on z17.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z17 | FileCheck %s

; Test with slt.
define i128 @f1(i128 %val1, i128 %val2) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vmxq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp slt i128 %val1, %val2
  %ret = select i1 %cmp, i128 %val2, i128 %val1
  ret i128 %ret
}

; Test with sle.
define i128 @f2(i128 %val1, i128 %val2) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vmxq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp sle i128 %val1, %val2
  %ret = select i1 %cmp, i128 %val2, i128 %val1
  ret i128 %ret
}

; Test with sgt.
define i128 @f3(i128 %val1, i128 %val2) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vmxq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp sgt i128 %val1, %val2
  %ret = select i1 %cmp, i128 %val1, i128 %val2
  ret i128 %ret
}

; Test with sge.
define i128 @f4(i128 %val1, i128 %val2) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vmxq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp sge i128 %val1, %val2
  %ret = select i1 %cmp, i128 %val1, i128 %val2
  ret i128 %ret
}

; Test with ult.
define i128 @f5(i128 %val1, i128 %val2) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vmxlq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp ult i128 %val1, %val2
  %ret = select i1 %cmp, i128 %val2, i128 %val1
  ret i128 %ret
}

; Test with ule.
define i128 @f6(i128 %val1, i128 %val2) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vmxlq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp ule i128 %val1, %val2
  %ret = select i1 %cmp, i128 %val2, i128 %val1
  ret i128 %ret
}

; Test with ugt.
define i128 @f7(i128 %val1, i128 %val2) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vmxlq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp ugt i128 %val1, %val2
  %ret = select i1 %cmp, i128 %val1, i128 %val2
  ret i128 %ret
}

; Test with uge.
define i128 @f8(i128 %val1, i128 %val2) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vmxlq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp uge i128 %val1, %val2
  %ret = select i1 %cmp, i128 %val1, i128 %val2
  ret i128 %ret
}
