; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=aarch64-unknown-linux-gnu -mattr=+sve2 -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output | FileCheck %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define void @srem() {
; CHECK-LABEL: 'srem'
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V2i64 = srem <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V4i64 = srem <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = srem <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:4 SizeLat:4 for: %V2i32 = srem <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i32 = srem <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i32 = srem <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V16i32 = srem <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V2i16 = srem <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V4i16 = srem <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %V8i16 = srem <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V16i16 = srem <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = srem <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V2i8 = srem <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %V4i8 = srem <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %V8i8 = srem <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:4 Lat:4 SizeLat:4 for: %V16i8 = srem <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:4 Lat:4 SizeLat:4 for: %V32i8 = srem <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:4 Lat:4 SizeLat:4 for: %V64i8 = srem <64 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:Invalid CodeSize:4 Lat:4 SizeLat:4 for: %NV2i128 = srem <vscale x 2 x i128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV2i64 = srem <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i64 = srem <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i64 = srem <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV2i32 = srem <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV4i32 = srem <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i32 = srem <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i32 = srem <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV2i16 = srem <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV4i16 = srem <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i16 = srem <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i16 = srem <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i16 = srem <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV2i8 = srem <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV4i8 = srem <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i8 = srem <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i8 = srem <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i8 = srem <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:4 Lat:4 SizeLat:4 for: %NV64i8 = srem <vscale x 64 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2i64 = srem <2 x i64> undef, undef
  %V4i64 = srem <4 x i64> undef, undef
  %V8i64 = srem <8 x i64> undef, undef
  %V2i32 = srem <2 x i32> undef, undef
  %V4i32 = srem <4 x i32> undef, undef
  %V8i32 = srem <8 x i32> undef, undef
  %V16i32 = srem <16 x i32> undef, undef
  %V2i16 = srem <2 x i16> undef, undef
  %V4i16 = srem <4 x i16> undef, undef
  %V8i16 = srem <8 x i16> undef, undef
  %V16i16 = srem <16 x i16> undef, undef
  %V32i16 = srem <32 x i16> undef, undef
  %V2i8 = srem <2 x i8> undef, undef
  %V4i8 = srem <4 x i8> undef, undef
  %V8i8 = srem <8 x i8> undef, undef
  %V16i8 = srem <16 x i8> undef, undef
  %V32i8 = srem <32 x i8> undef, undef
  %V64i8 = srem <64 x i8> undef, undef
  %NV2i128 = srem <vscale x 2 x i128> undef, undef
  %NV2i64 = srem <vscale x 2 x i64> undef, undef
  %NV4i64 = srem <vscale x 4 x i64> undef, undef
  %NV8i64 = srem <vscale x 8 x i64> undef, undef
  %NV2i32 = srem <vscale x 2 x i32> undef, undef
  %NV4i32 = srem <vscale x 4 x i32> undef, undef
  %NV8i32 = srem <vscale x 8 x i32> undef, undef
  %NV16i32 = srem <vscale x 16 x i32> undef, undef
  %NV2i16 = srem <vscale x 2 x i16> undef, undef
  %NV4i16 = srem <vscale x 4 x i16> undef, undef
  %NV8i16 = srem <vscale x 8 x i16> undef, undef
  %NV16i16 = srem <vscale x 16 x i16> undef, undef
  %NV32i16 = srem <vscale x 32 x i16> undef, undef
  %NV2i8 = srem <vscale x 2 x i8> undef, undef
  %NV4i8 = srem <vscale x 4 x i8> undef, undef
  %NV8i8 = srem <vscale x 8 x i8> undef, undef
  %NV16i8 = srem <vscale x 16 x i8> undef, undef
  %NV32i8 = srem <vscale x 32 x i8> undef, undef
  %NV64i8 = srem <vscale x 64 x i8> undef, undef
  ret void
}

define void @urem() {
; CHECK-LABEL: 'urem'
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V2i64 = urem <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V4i64 = urem <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = urem <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:4 SizeLat:4 for: %V2i32 = urem <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i32 = urem <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i32 = urem <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V16i32 = urem <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V2i16 = urem <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V4i16 = urem <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %V8i16 = urem <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V16i16 = urem <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = urem <32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V2i8 = urem <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %V4i8 = urem <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %V8i8 = urem <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:4 Lat:4 SizeLat:4 for: %V16i8 = urem <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:4 Lat:4 SizeLat:4 for: %V32i8 = urem <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:4 Lat:4 SizeLat:4 for: %V64i8 = urem <64 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:Invalid CodeSize:4 Lat:4 SizeLat:4 for: %NV2i128 = urem <vscale x 2 x i128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV2i64 = urem <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i64 = urem <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i64 = urem <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV2i32 = urem <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV4i32 = urem <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i32 = urem <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i32 = urem <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV2i16 = urem <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV4i16 = urem <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i16 = urem <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i16 = urem <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i16 = urem <vscale x 32 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV2i8 = urem <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV4i8 = urem <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i8 = urem <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i8 = urem <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i8 = urem <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:4 Lat:4 SizeLat:4 for: %NV64i8 = urem <vscale x 64 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2i64 = urem <2 x i64> undef, undef
  %V4i64 = urem <4 x i64> undef, undef
  %V8i64 = urem <8 x i64> undef, undef
  %V2i32 = urem <2 x i32> undef, undef
  %V4i32 = urem <4 x i32> undef, undef
  %V8i32 = urem <8 x i32> undef, undef
  %V16i32 = urem <16 x i32> undef, undef
  %V2i16 = urem <2 x i16> undef, undef
  %V4i16 = urem <4 x i16> undef, undef
  %V8i16 = urem <8 x i16> undef, undef
  %V16i16 = urem <16 x i16> undef, undef
  %V32i16 = urem <32 x i16> undef, undef
  %V2i8 = urem <2 x i8> undef, undef
  %V4i8 = urem <4 x i8> undef, undef
  %V8i8 = urem <8 x i8> undef, undef
  %V16i8 = urem <16 x i8> undef, undef
  %V32i8 = urem <32 x i8> undef, undef
  %V64i8 = urem <64 x i8> undef, undef
  %NV2i128 = urem <vscale x 2 x i128> undef, undef
  %NV2i64 = urem <vscale x 2 x i64> undef, undef
  %NV4i64 = urem <vscale x 4 x i64> undef, undef
  %NV8i64 = urem <vscale x 8 x i64> undef, undef
  %NV2i32 = urem <vscale x 2 x i32> undef, undef
  %NV4i32 = urem <vscale x 4 x i32> undef, undef
  %NV8i32 = urem <vscale x 8 x i32> undef, undef
  %NV16i32 = urem <vscale x 16 x i32> undef, undef
  %NV2i16 = urem <vscale x 2 x i16> undef, undef
  %NV4i16 = urem <vscale x 4 x i16> undef, undef
  %NV8i16 = urem <vscale x 8 x i16> undef, undef
  %NV16i16 = urem <vscale x 16 x i16> undef, undef
  %NV32i16 = urem <vscale x 32 x i16> undef, undef
  %NV2i8 = urem <vscale x 2 x i8> undef, undef
  %NV4i8 = urem <vscale x 4 x i8> undef, undef
  %NV8i8 = urem <vscale x 8 x i8> undef, undef
  %NV16i8 = urem <vscale x 16 x i8> undef, undef
  %NV32i8 = urem <vscale x 32 x i8> undef, undef
  %NV64i8 = urem <vscale x 64 x i8> undef, undef
  ret void
}

define void @srem_uniformconst() {
; CHECK-LABEL: 'srem_uniformconst'
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V2i64 = srem <2 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V4i64 = srem <4 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = srem <8 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %V2i32 = srem <2 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %V4i32 = srem <4 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V8i32 = srem <8 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:4 Lat:4 SizeLat:4 for: %V16i32 = srem <16 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %V2i16 = srem <2 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %V4i16 = srem <4 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %V8i16 = srem <8 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V16i16 = srem <16 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = srem <32 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %V2i8 = srem <2 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %V4i8 = srem <4 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %V8i8 = srem <8 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %V16i8 = srem <16 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V32i8 = srem <32 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:4 Lat:4 SizeLat:4 for: %V64i8 = srem <64 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:Invalid CodeSize:4 Lat:4 SizeLat:4 for: %NV2i128 = srem <vscale x 2 x i128> undef, splat (i128 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i64 = srem <vscale x 2 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i64 = srem <vscale x 4 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i64 = srem <vscale x 8 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i32 = srem <vscale x 2 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i32 = srem <vscale x 4 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i32 = srem <vscale x 8 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i32 = srem <vscale x 16 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i16 = srem <vscale x 2 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i16 = srem <vscale x 4 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i16 = srem <vscale x 8 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i16 = srem <vscale x 16 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i16 = srem <vscale x 32 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i8 = srem <vscale x 2 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i8 = srem <vscale x 4 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i8 = srem <vscale x 8 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i8 = srem <vscale x 16 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i8 = srem <vscale x 32 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %NV64i8 = srem <vscale x 64 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2i64 = srem <2 x i64> undef, splat (i64 7)
  %V4i64 = srem <4 x i64> undef, splat (i64 7)
  %V8i64 = srem <8 x i64> undef, splat (i64 7)
  %V2i32 = srem <2 x i32> undef, splat (i32 7)
  %V4i32 = srem <4 x i32> undef, splat (i32 7)
  %V8i32 = srem <8 x i32> undef, splat (i32 7)
  %V16i32 = srem <16 x i32> undef, splat (i32 7)
  %V2i16 = srem <2 x i16> undef, splat (i16 7)
  %V4i16 = srem <4 x i16> undef, splat (i16 7)
  %V8i16 = srem <8 x i16> undef, splat (i16 7)
  %V16i16 = srem <16 x i16> undef, splat (i16 7)
  %V32i16 = srem <32 x i16> undef, splat (i16 7)
  %V2i8 = srem <2 x i8> undef, splat (i8 7)
  %V4i8 = srem <4 x i8> undef, splat (i8 7)
  %V8i8 = srem <8 x i8> undef, splat (i8 7)
  %V16i8 = srem <16 x i8> undef, splat (i8 7)
  %V32i8 = srem <32 x i8> undef, splat (i8 7)
  %V64i8 = srem <64 x i8> undef, splat (i8 7)
  %NV2i128 = srem <vscale x 2 x i128> undef, splat (i128 7)
  %NV2i64 = srem <vscale x 2 x i64> undef, splat (i64 7)
  %NV4i64 = srem <vscale x 4 x i64> undef, splat (i64 7)
  %NV8i64 = srem <vscale x 8 x i64> undef, splat (i64 7)
  %NV2i32 = srem <vscale x 2 x i32> undef, splat (i32 7)
  %NV4i32 = srem <vscale x 4 x i32> undef, splat (i32 7)
  %NV8i32 = srem <vscale x 8 x i32> undef, splat (i32 7)
  %NV16i32 = srem <vscale x 16 x i32> undef, splat (i32 7)
  %NV2i16 = srem <vscale x 2 x i16> undef, splat (i16 7)
  %NV4i16 = srem <vscale x 4 x i16> undef, splat (i16 7)
  %NV8i16 = srem <vscale x 8 x i16> undef, splat (i16 7)
  %NV16i16 = srem <vscale x 16 x i16> undef, splat (i16 7)
  %NV32i16 = srem <vscale x 32 x i16> undef, splat (i16 7)
  %NV2i8 = srem <vscale x 2 x i8> undef, splat (i8 7)
  %NV4i8 = srem <vscale x 4 x i8> undef, splat (i8 7)
  %NV8i8 = srem <vscale x 8 x i8> undef, splat (i8 7)
  %NV16i8 = srem <vscale x 16 x i8> undef, splat (i8 7)
  %NV32i8 = srem <vscale x 32 x i8> undef, splat (i8 7)
  %NV64i8 = srem <vscale x 64 x i8> undef, splat (i8 7)
  ret void
}

define void @urem_uniformconst() {
; CHECK-LABEL: 'urem_uniformconst'
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V2i64 = urem <2 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V4i64 = urem <4 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = urem <8 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V2i32 = urem <2 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V4i32 = urem <4 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V8i32 = urem <8 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V16i32 = urem <16 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V2i16 = urem <2 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V4i16 = urem <4 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i16 = urem <8 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V16i16 = urem <16 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = urem <32 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V2i8 = urem <2 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V4i8 = urem <4 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V8i8 = urem <8 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V16i8 = urem <16 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V32i8 = urem <32 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V64i8 = urem <64 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:Invalid CodeSize:4 Lat:4 SizeLat:4 for: %NV2i128 = urem <vscale x 2 x i128> undef, splat (i128 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i64 = urem <vscale x 2 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i64 = urem <vscale x 4 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i64 = urem <vscale x 8 x i64> undef, splat (i64 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i32 = urem <vscale x 2 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i32 = urem <vscale x 4 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i32 = urem <vscale x 8 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i32 = urem <vscale x 16 x i32> undef, splat (i32 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i16 = urem <vscale x 2 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i16 = urem <vscale x 4 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i16 = urem <vscale x 8 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i16 = urem <vscale x 16 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i16 = urem <vscale x 32 x i16> undef, splat (i16 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i8 = urem <vscale x 2 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i8 = urem <vscale x 4 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i8 = urem <vscale x 8 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i8 = urem <vscale x 16 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i8 = urem <vscale x 32 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:4 Lat:4 SizeLat:4 for: %NV64i8 = urem <vscale x 64 x i8> undef, splat (i8 7)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2i64 = urem <2 x i64> undef, splat (i64 7)
  %V4i64 = urem <4 x i64> undef, splat (i64 7)
  %V8i64 = urem <8 x i64> undef, splat (i64 7)
  %V2i32 = urem <2 x i32> undef, splat (i32 7)
  %V4i32 = urem <4 x i32> undef, splat (i32 7)
  %V8i32 = urem <8 x i32> undef, splat (i32 7)
  %V16i32 = urem <16 x i32> undef, splat (i32 7)
  %V2i16 = urem <2 x i16> undef, splat (i16 7)
  %V4i16 = urem <4 x i16> undef, splat (i16 7)
  %V8i16 = urem <8 x i16> undef, splat (i16 7)
  %V16i16 = urem <16 x i16> undef, splat (i16 7)
  %V32i16 = urem <32 x i16> undef, splat (i16 7)
  %V2i8 = urem <2 x i8> undef, splat (i8 7)
  %V4i8 = urem <4 x i8> undef, splat (i8 7)
  %V8i8 = urem <8 x i8> undef, splat (i8 7)
  %V16i8 = urem <16 x i8> undef, splat (i8 7)
  %V32i8 = urem <32 x i8> undef, splat (i8 7)
  %V64i8 = urem <64 x i8> undef, splat (i8 7)
  %NV2i128 = urem <vscale x 2 x i128> undef, splat (i128 7)
  %NV2i64 = urem <vscale x 2 x i64> undef, splat (i64 7)
  %NV4i64 = urem <vscale x 4 x i64> undef, splat (i64 7)
  %NV8i64 = urem <vscale x 8 x i64> undef, splat (i64 7)
  %NV2i32 = urem <vscale x 2 x i32> undef, splat (i32 7)
  %NV4i32 = urem <vscale x 4 x i32> undef, splat (i32 7)
  %NV8i32 = urem <vscale x 8 x i32> undef, splat (i32 7)
  %NV16i32 = urem <vscale x 16 x i32> undef, splat (i32 7)
  %NV2i16 = urem <vscale x 2 x i16> undef, splat (i16 7)
  %NV4i16 = urem <vscale x 4 x i16> undef, splat (i16 7)
  %NV8i16 = urem <vscale x 8 x i16> undef, splat (i16 7)
  %NV16i16 = urem <vscale x 16 x i16> undef, splat (i16 7)
  %NV32i16 = urem <vscale x 32 x i16> undef, splat (i16 7)
  %NV2i8 = urem <vscale x 2 x i8> undef, splat (i8 7)
  %NV4i8 = urem <vscale x 4 x i8> undef, splat (i8 7)
  %NV8i8 = urem <vscale x 8 x i8> undef, splat (i8 7)
  %NV16i8 = urem <vscale x 16 x i8> undef, splat (i8 7)
  %NV32i8 = urem <vscale x 32 x i8> undef, splat (i8 7)
  %NV64i8 = urem <vscale x 64 x i8> undef, splat (i8 7)
  ret void
}

define void @srem_uniformconstpow2() {
; CHECK-LABEL: 'srem_uniformconstpow2'
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V2i64 = srem <2 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V4i64 = srem <4 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = srem <8 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V2i32 = srem <2 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i32 = srem <4 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i32 = srem <8 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V16i32 = srem <16 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V2i16 = srem <2 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i16 = srem <4 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V8i16 = srem <8 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V16i16 = srem <16 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = srem <32 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V2i8 = srem <2 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i8 = srem <4 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V8i8 = srem <8 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V16i8 = srem <16 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i8 = srem <32 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V64i8 = srem <64 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:Invalid CodeSize:4 Lat:4 SizeLat:4 for: %NV2i128 = srem <vscale x 2 x i128> undef, splat (i128 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i64 = srem <vscale x 2 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV4i64 = srem <vscale x 4 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i64 = srem <vscale x 8 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i32 = srem <vscale x 2 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i32 = srem <vscale x 4 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV8i32 = srem <vscale x 8 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i32 = srem <vscale x 16 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i16 = srem <vscale x 2 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i16 = srem <vscale x 4 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i16 = srem <vscale x 8 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV16i16 = srem <vscale x 16 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i16 = srem <vscale x 32 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i8 = srem <vscale x 2 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i8 = srem <vscale x 4 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i8 = srem <vscale x 8 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i8 = srem <vscale x 16 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV32i8 = srem <vscale x 32 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV64i8 = srem <vscale x 64 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2i64 = srem <2 x i64> undef, splat (i64 16)
  %V4i64 = srem <4 x i64> undef, splat (i64 16)
  %V8i64 = srem <8 x i64> undef, splat (i64 16)
  %V2i32 = srem <2 x i32> undef, splat (i32 16)
  %V4i32 = srem <4 x i32> undef, splat (i32 16)
  %V8i32 = srem <8 x i32> undef, splat (i32 16)
  %V16i32 = srem <16 x i32> undef, splat (i32 16)
  %V2i16 = srem <2 x i16> undef, splat (i16 16)
  %V4i16 = srem <4 x i16> undef, splat (i16 16)
  %V8i16 = srem <8 x i16> undef, splat (i16 16)
  %V16i16 = srem <16 x i16> undef, splat (i16 16)
  %V32i16 = srem <32 x i16> undef, splat (i16 16)
  %V2i8 = srem <2 x i8> undef, splat (i8 16)
  %V4i8 = srem <4 x i8> undef, splat (i8 16)
  %V8i8 = srem <8 x i8> undef, splat (i8 16)
  %V16i8 = srem <16 x i8> undef, splat (i8 16)
  %V32i8 = srem <32 x i8> undef, splat (i8 16)
  %V64i8 = srem <64 x i8> undef, splat (i8 16)
  %NV2i128 = srem <vscale x 2 x i128> undef, splat (i128 16)
  %NV2i64 = srem <vscale x 2 x i64> undef, splat (i64 16)
  %NV4i64 = srem <vscale x 4 x i64> undef, splat (i64 16)
  %NV8i64 = srem <vscale x 8 x i64> undef, splat (i64 16)
  %NV2i32 = srem <vscale x 2 x i32> undef, splat (i32 16)
  %NV4i32 = srem <vscale x 4 x i32> undef, splat (i32 16)
  %NV8i32 = srem <vscale x 8 x i32> undef, splat (i32 16)
  %NV16i32 = srem <vscale x 16 x i32> undef, splat (i32 16)
  %NV2i16 = srem <vscale x 2 x i16> undef, splat (i16 16)
  %NV4i16 = srem <vscale x 4 x i16> undef, splat (i16 16)
  %NV8i16 = srem <vscale x 8 x i16> undef, splat (i16 16)
  %NV16i16 = srem <vscale x 16 x i16> undef, splat (i16 16)
  %NV32i16 = srem <vscale x 32 x i16> undef, splat (i16 16)
  %NV2i8 = srem <vscale x 2 x i8> undef, splat (i8 16)
  %NV4i8 = srem <vscale x 4 x i8> undef, splat (i8 16)
  %NV8i8 = srem <vscale x 8 x i8> undef, splat (i8 16)
  %NV16i8 = srem <vscale x 16 x i8> undef, splat (i8 16)
  %NV32i8 = srem <vscale x 32 x i8> undef, splat (i8 16)
  %NV64i8 = srem <vscale x 64 x i8> undef, splat (i8 16)
  ret void
}

define void @urem_uniformconstpow2() {
; CHECK-LABEL: 'urem_uniformconstpow2'
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V2i64 = urem <2 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %V4i64 = urem <4 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V8i64 = urem <8 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V2i32 = urem <2 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V4i32 = urem <4 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %V8i32 = urem <8 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V16i32 = urem <16 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V2i16 = urem <2 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V4i16 = urem <4 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V8i16 = urem <8 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %V16i16 = urem <16 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V32i16 = urem <32 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V2i8 = urem <2 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V4i8 = urem <4 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V8i8 = urem <8 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V16i8 = urem <16 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %V32i8 = urem <32 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V64i8 = urem <64 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:Invalid CodeSize:4 Lat:4 SizeLat:4 for: %NV2i128 = urem <vscale x 2 x i128> undef, splat (i128 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i64 = urem <vscale x 2 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i64 = urem <vscale x 4 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV8i64 = urem <vscale x 8 x i64> undef, splat (i64 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i32 = urem <vscale x 2 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i32 = urem <vscale x 4 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i32 = urem <vscale x 8 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV16i32 = urem <vscale x 16 x i32> undef, splat (i32 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i16 = urem <vscale x 2 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i16 = urem <vscale x 4 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i16 = urem <vscale x 8 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i16 = urem <vscale x 16 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV32i16 = urem <vscale x 32 x i16> undef, splat (i16 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i8 = urem <vscale x 2 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i8 = urem <vscale x 4 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i8 = urem <vscale x 8 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i8 = urem <vscale x 16 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i8 = urem <vscale x 32 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV64i8 = urem <vscale x 64 x i8> undef, splat (i8 16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2i64 = urem <2 x i64> undef, splat (i64 16)
  %V4i64 = urem <4 x i64> undef, splat (i64 16)
  %V8i64 = urem <8 x i64> undef, splat (i64 16)
  %V2i32 = urem <2 x i32> undef, splat (i32 16)
  %V4i32 = urem <4 x i32> undef, splat (i32 16)
  %V8i32 = urem <8 x i32> undef, splat (i32 16)
  %V16i32 = urem <16 x i32> undef, splat (i32 16)
  %V2i16 = urem <2 x i16> undef, splat (i16 16)
  %V4i16 = urem <4 x i16> undef, splat (i16 16)
  %V8i16 = urem <8 x i16> undef, splat (i16 16)
  %V16i16 = urem <16 x i16> undef, splat (i16 16)
  %V32i16 = urem <32 x i16> undef, splat (i16 16)
  %V2i8 = urem <2 x i8> undef, splat (i8 16)
  %V4i8 = urem <4 x i8> undef, splat (i8 16)
  %V8i8 = urem <8 x i8> undef, splat (i8 16)
  %V16i8 = urem <16 x i8> undef, splat (i8 16)
  %V32i8 = urem <32 x i8> undef, splat (i8 16)
  %V64i8 = urem <64 x i8> undef, splat (i8 16)
  %NV2i128 = urem <vscale x 2 x i128> undef, splat (i128 16)
  %NV2i64 = urem <vscale x 2 x i64> undef, splat (i64 16)
  %NV4i64 = urem <vscale x 4 x i64> undef, splat (i64 16)
  %NV8i64 = urem <vscale x 8 x i64> undef, splat (i64 16)
  %NV2i32 = urem <vscale x 2 x i32> undef, splat (i32 16)
  %NV4i32 = urem <vscale x 4 x i32> undef, splat (i32 16)
  %NV8i32 = urem <vscale x 8 x i32> undef, splat (i32 16)
  %NV16i32 = urem <vscale x 16 x i32> undef, splat (i32 16)
  %NV2i16 = urem <vscale x 2 x i16> undef, splat (i16 16)
  %NV4i16 = urem <vscale x 4 x i16> undef, splat (i16 16)
  %NV8i16 = urem <vscale x 8 x i16> undef, splat (i16 16)
  %NV16i16 = urem <vscale x 16 x i16> undef, splat (i16 16)
  %NV32i16 = urem <vscale x 32 x i16> undef, splat (i16 16)
  %NV2i8 = urem <vscale x 2 x i8> undef, splat (i8 16)
  %NV4i8 = urem <vscale x 4 x i8> undef, splat (i8 16)
  %NV8i8 = urem <vscale x 8 x i8> undef, splat (i8 16)
  %NV16i8 = urem <vscale x 16 x i8> undef, splat (i8 16)
  %NV32i8 = urem <vscale x 32 x i8> undef, splat (i8 16)
  %NV64i8 = urem <vscale x 64 x i8> undef, splat (i8 16)
  ret void
}

define void @srem_uniformconstnegpow2() {
; CHECK-LABEL: 'srem_uniformconstnegpow2'
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V2i64 = srem <2 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V4i64 = srem <4 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = srem <8 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V2i32 = srem <2 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i32 = srem <4 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i32 = srem <8 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V16i32 = srem <16 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V2i16 = srem <2 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i16 = srem <4 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V8i16 = srem <8 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V16i16 = srem <16 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = srem <32 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V2i8 = srem <2 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i8 = srem <4 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V8i8 = srem <8 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V16i8 = srem <16 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i8 = srem <32 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V64i8 = srem <64 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:Invalid CodeSize:4 Lat:4 SizeLat:4 for: %NV2i128 = srem <vscale x 2 x i128> undef, splat (i128 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i64 = srem <vscale x 2 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV4i64 = srem <vscale x 4 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i64 = srem <vscale x 8 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i32 = srem <vscale x 2 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i32 = srem <vscale x 4 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV8i32 = srem <vscale x 8 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i32 = srem <vscale x 16 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i16 = srem <vscale x 2 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i16 = srem <vscale x 4 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i16 = srem <vscale x 8 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV16i16 = srem <vscale x 16 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i16 = srem <vscale x 32 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i8 = srem <vscale x 2 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i8 = srem <vscale x 4 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i8 = srem <vscale x 8 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i8 = srem <vscale x 16 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %NV32i8 = srem <vscale x 32 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %NV64i8 = srem <vscale x 64 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2i64 = srem <2 x i64> undef, splat (i64 -16)
  %V4i64 = srem <4 x i64> undef, splat (i64 -16)
  %V8i64 = srem <8 x i64> undef, splat (i64 -16)
  %V2i32 = srem <2 x i32> undef, splat (i32 -16)
  %V4i32 = srem <4 x i32> undef, splat (i32 -16)
  %V8i32 = srem <8 x i32> undef, splat (i32 -16)
  %V16i32 = srem <16 x i32> undef, splat (i32 -16)
  %V2i16 = srem <2 x i16> undef, splat (i16 -16)
  %V4i16 = srem <4 x i16> undef, splat (i16 -16)
  %V8i16 = srem <8 x i16> undef, splat (i16 -16)
  %V16i16 = srem <16 x i16> undef, splat (i16 -16)
  %V32i16 = srem <32 x i16> undef, splat (i16 -16)
  %V2i8 = srem <2 x i8> undef, splat (i8 -16)
  %V4i8 = srem <4 x i8> undef, splat (i8 -16)
  %V8i8 = srem <8 x i8> undef, splat (i8 -16)
  %V16i8 = srem <16 x i8> undef, splat (i8 -16)
  %V32i8 = srem <32 x i8> undef, splat (i8 -16)
  %V64i8 = srem <64 x i8> undef, splat (i8 -16)
  %NV2i128 = srem <vscale x 2 x i128> undef, splat (i128 -16)
  %NV2i64 = srem <vscale x 2 x i64> undef, splat (i64 -16)
  %NV4i64 = srem <vscale x 4 x i64> undef, splat (i64 -16)
  %NV8i64 = srem <vscale x 8 x i64> undef, splat (i64 -16)
  %NV2i32 = srem <vscale x 2 x i32> undef, splat (i32 -16)
  %NV4i32 = srem <vscale x 4 x i32> undef, splat (i32 -16)
  %NV8i32 = srem <vscale x 8 x i32> undef, splat (i32 -16)
  %NV16i32 = srem <vscale x 16 x i32> undef, splat (i32 -16)
  %NV2i16 = srem <vscale x 2 x i16> undef, splat (i16 -16)
  %NV4i16 = srem <vscale x 4 x i16> undef, splat (i16 -16)
  %NV8i16 = srem <vscale x 8 x i16> undef, splat (i16 -16)
  %NV16i16 = srem <vscale x 16 x i16> undef, splat (i16 -16)
  %NV32i16 = srem <vscale x 32 x i16> undef, splat (i16 -16)
  %NV2i8 = srem <vscale x 2 x i8> undef, splat (i8 -16)
  %NV4i8 = srem <vscale x 4 x i8> undef, splat (i8 -16)
  %NV8i8 = srem <vscale x 8 x i8> undef, splat (i8 -16)
  %NV16i8 = srem <vscale x 16 x i8> undef, splat (i8 -16)
  %NV32i8 = srem <vscale x 32 x i8> undef, splat (i8 -16)
  %NV64i8 = srem <vscale x 64 x i8> undef, splat (i8 -16)
  ret void
}

define void @urem_uniformconstnegpow2() {
; CHECK-LABEL: 'urem_uniformconstnegpow2'
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V2i64 = urem <2 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V4i64 = urem <4 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = urem <8 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V2i32 = urem <2 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V4i32 = urem <4 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V8i32 = urem <8 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V16i32 = urem <16 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V2i16 = urem <2 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V4i16 = urem <4 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i16 = urem <8 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V16i16 = urem <16 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = urem <32 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V2i8 = urem <2 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V4i8 = urem <4 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %V8i8 = urem <8 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V16i8 = urem <16 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V32i8 = urem <32 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V64i8 = urem <64 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:Invalid CodeSize:4 Lat:4 SizeLat:4 for: %NV2i128 = urem <vscale x 2 x i128> undef, splat (i128 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i64 = urem <vscale x 2 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i64 = urem <vscale x 4 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i64 = urem <vscale x 8 x i64> undef, splat (i64 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i32 = urem <vscale x 2 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i32 = urem <vscale x 4 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i32 = urem <vscale x 8 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i32 = urem <vscale x 16 x i32> undef, splat (i32 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i16 = urem <vscale x 2 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i16 = urem <vscale x 4 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i16 = urem <vscale x 8 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i16 = urem <vscale x 16 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i16 = urem <vscale x 32 x i16> undef, splat (i16 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV2i8 = urem <vscale x 2 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV4i8 = urem <vscale x 4 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV8i8 = urem <vscale x 8 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %NV16i8 = urem <vscale x 16 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %NV32i8 = urem <vscale x 32 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:4 Lat:4 SizeLat:4 for: %NV64i8 = urem <vscale x 64 x i8> undef, splat (i8 -16)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2i64 = urem <2 x i64> undef, splat (i64 -16)
  %V4i64 = urem <4 x i64> undef, splat (i64 -16)
  %V8i64 = urem <8 x i64> undef, splat (i64 -16)
  %V2i32 = urem <2 x i32> undef, splat (i32 -16)
  %V4i32 = urem <4 x i32> undef, splat (i32 -16)
  %V8i32 = urem <8 x i32> undef, splat (i32 -16)
  %V16i32 = urem <16 x i32> undef, splat (i32 -16)
  %V2i16 = urem <2 x i16> undef, splat (i16 -16)
  %V4i16 = urem <4 x i16> undef, splat (i16 -16)
  %V8i16 = urem <8 x i16> undef, splat (i16 -16)
  %V16i16 = urem <16 x i16> undef, splat (i16 -16)
  %V32i16 = urem <32 x i16> undef, splat (i16 -16)
  %V2i8 = urem <2 x i8> undef, splat (i8 -16)
  %V4i8 = urem <4 x i8> undef, splat (i8 -16)
  %V8i8 = urem <8 x i8> undef, splat (i8 -16)
  %V16i8 = urem <16 x i8> undef, splat (i8 -16)
  %V32i8 = urem <32 x i8> undef, splat (i8 -16)
  %V64i8 = urem <64 x i8> undef, splat (i8 -16)
  %NV2i128 = urem <vscale x 2 x i128> undef, splat (i128 -16)
  %NV2i64 = urem <vscale x 2 x i64> undef, splat (i64 -16)
  %NV4i64 = urem <vscale x 4 x i64> undef, splat (i64 -16)
  %NV8i64 = urem <vscale x 8 x i64> undef, splat (i64 -16)
  %NV2i32 = urem <vscale x 2 x i32> undef, splat (i32 -16)
  %NV4i32 = urem <vscale x 4 x i32> undef, splat (i32 -16)
  %NV8i32 = urem <vscale x 8 x i32> undef, splat (i32 -16)
  %NV16i32 = urem <vscale x 16 x i32> undef, splat (i32 -16)
  %NV2i16 = urem <vscale x 2 x i16> undef, splat (i16 -16)
  %NV4i16 = urem <vscale x 4 x i16> undef, splat (i16 -16)
  %NV8i16 = urem <vscale x 8 x i16> undef, splat (i16 -16)
  %NV16i16 = urem <vscale x 16 x i16> undef, splat (i16 -16)
  %NV32i16 = urem <vscale x 32 x i16> undef, splat (i16 -16)
  %NV2i8 = urem <vscale x 2 x i8> undef, splat (i8 -16)
  %NV4i8 = urem <vscale x 4 x i8> undef, splat (i8 -16)
  %NV8i8 = urem <vscale x 8 x i8> undef, splat (i8 -16)
  %NV16i8 = urem <vscale x 16 x i8> undef, splat (i8 -16)
  %NV32i8 = urem <vscale x 32 x i8> undef, splat (i8 -16)
  %NV64i8 = urem <vscale x 64 x i8> undef, splat (i8 -16)
  ret void
}
