; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -verify-machineinstrs \
; RUN:   | FileCheck -check-prefix=ILP32-ILP32F-FPELIM %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -verify-machineinstrs -frame-pointer=all \
; RUN:   | FileCheck -check-prefix=ILP32-ILP32F-WITHFP %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+d -verify-machineinstrs \
; RUN:   | FileCheck -check-prefix=RV32D-ILP32-ILP32F-ILP32D-FPELIM %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+d -target-abi ilp32f \
; RUN:     -verify-machineinstrs \
; RUN:   | FileCheck -check-prefix=RV32D-ILP32-ILP32F-ILP32D-FPELIM %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+d -target-abi ilp32d \
; RUN:     -verify-machineinstrs \
; RUN:   | FileCheck -check-prefix=RV32D-ILP32-ILP32F-ILP32D-FPELIM %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -target-abi ilp32e \
; RUN:     -verify-machineinstrs \
; RUN:   | FileCheck -check-prefix=ILP32E-FPELIM %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -target-abi ilp32e -frame-pointer=all \
; RUN:     -verify-machineinstrs \
; RUN:   | FileCheck -check-prefix=ILP32E-WITHFP %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -verify-machineinstrs \
; RUN:   | FileCheck -check-prefix=LP64-LP64F-LP64D-FPELIM %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+d -target-abi lp64f \
; RUN:     -verify-machineinstrs \
; RUN:   | FileCheck -check-prefix=LP64-LP64F-LP64D-FPELIM %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+d -target-abi lp64d \
; RUN:     -verify-machineinstrs \
; RUN:   | FileCheck -check-prefix=LP64-LP64F-LP64D-FPELIM %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -verify-machineinstrs -frame-pointer=all \
; RUN:   | FileCheck -check-prefix=LP64-LP64F-LP64D-WITHFP %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -target-abi lp64e \
; RUN:     -verify-machineinstrs \
; RUN:   | FileCheck -check-prefix=LP64E-FPELIM %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -target-abi lp64e -frame-pointer=all \
; RUN:     -verify-machineinstrs \
; RUN:   | FileCheck -check-prefix=LP64E-WITHFP %s

; The same vararg calling convention is used for ilp32/ilp32f/ilp32d and for
; lp64/lp64f/lp64d. Different CHECK lines are required for RV32D due to slight
; codegen differences due to the way the f64 load operations are lowered.
; The nounwind attribute is omitted for some of the tests, to check that CFI
; directives are correctly generated.

declare void @llvm.va_start(ptr)
declare void @llvm.va_end(ptr)

declare void @notdead(ptr)

; Although frontends are recommended to not generate va_arg due to the lack of
; support for aggregate types, we test simple cases here to ensure they are
; lowered correctly

define i32 @va1(ptr %fmt, ...) {
; ILP32-ILP32F-FPELIM-LABEL: va1:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-FPELIM-NEXT:    .cfi_def_cfa_offset 48
; ILP32-ILP32F-FPELIM-NEXT:    mv a0, a1
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 36(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a6, 40(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a7, 44(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 20(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a2, 24(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a3, 28(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 32(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi a1, sp, 24
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 12(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va1:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_def_cfa_offset 48
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_offset ra, -36
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_offset s0, -40
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_def_cfa s0, 32
; ILP32-ILP32F-WITHFP-NEXT:    mv a0, a1
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a6, 24(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a7, 28(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a1, s0, 8
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, -12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_def_cfa sp, 48
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_restore ra
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_restore s0
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va1:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    .cfi_def_cfa_offset 48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    mv a0, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 36(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a6, 40(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a7, 44(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 20(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a2, 24(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a3, 28(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 32(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a1, sp, 24
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 12(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va1:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -28
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 28
; ILP32E-FPELIM-NEXT:    mv a0, a1
; ILP32E-FPELIM-NEXT:    sw a5, 24(sp)
; ILP32E-FPELIM-NEXT:    sw a1, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a2, 12(sp)
; ILP32E-FPELIM-NEXT:    sw a3, 16(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 20(sp)
; ILP32E-FPELIM-NEXT:    addi a1, sp, 12
; ILP32E-FPELIM-NEXT:    sw a1, 0(sp)
; ILP32E-FPELIM-NEXT:    addi sp, sp, 28
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va1:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -36
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 36
; ILP32E-WITHFP-NEXT:    sw ra, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -28
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -32
; ILP32E-WITHFP-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 24
; ILP32E-WITHFP-NEXT:    mv a0, a1
; ILP32E-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32E-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32E-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32E-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32E-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32E-WITHFP-NEXT:    addi a1, s0, 8
; ILP32E-WITHFP-NEXT:    sw a1, -12(s0)
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 36
; ILP32E-WITHFP-NEXT:    lw ra, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 36
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va1:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -80
; LP64-LP64F-LP64D-FPELIM-NEXT:    .cfi_def_cfa_offset 80
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 24(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a0, sp, 28
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a0, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lw a0, 24(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a5, 56(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a6, 64(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a7, 72(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a2, 32(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 40(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a4, 48(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 80
; LP64-LP64F-LP64D-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va1:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -96
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_def_cfa_offset 96
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_offset ra, -72
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_offset s0, -80
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 32
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_def_cfa s0, 64
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a0, s0, 12
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a0, -24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    lw a0, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a5, 40(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a6, 48(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a7, 56(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a2, 16(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, 24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a4, 32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_def_cfa sp, 96
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_restore ra
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_restore s0
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 96
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va1:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -56
; LP64E-FPELIM-NEXT:    .cfi_def_cfa_offset 56
; LP64E-FPELIM-NEXT:    addi a0, sp, 20
; LP64E-FPELIM-NEXT:    sd a0, 0(sp)
; LP64E-FPELIM-NEXT:    sd a1, 16(sp)
; LP64E-FPELIM-NEXT:    lw a0, 16(sp)
; LP64E-FPELIM-NEXT:    sd a5, 48(sp)
; LP64E-FPELIM-NEXT:    sd a2, 24(sp)
; LP64E-FPELIM-NEXT:    sd a3, 32(sp)
; LP64E-FPELIM-NEXT:    sd a4, 40(sp)
; LP64E-FPELIM-NEXT:    addi sp, sp, 56
; LP64E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va1:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -72
; LP64E-WITHFP-NEXT:    .cfi_def_cfa_offset 72
; LP64E-WITHFP-NEXT:    sd ra, 16(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 8(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    .cfi_offset ra, -56
; LP64E-WITHFP-NEXT:    .cfi_offset s0, -64
; LP64E-WITHFP-NEXT:    addi s0, sp, 24
; LP64E-WITHFP-NEXT:    .cfi_def_cfa s0, 48
; LP64E-WITHFP-NEXT:    addi a0, s0, 12
; LP64E-WITHFP-NEXT:    sd a0, -24(s0)
; LP64E-WITHFP-NEXT:    sd a1, 8(s0)
; LP64E-WITHFP-NEXT:    lw a0, 8(s0)
; LP64E-WITHFP-NEXT:    sd a5, 40(s0)
; LP64E-WITHFP-NEXT:    sd a2, 16(s0)
; LP64E-WITHFP-NEXT:    sd a3, 24(s0)
; LP64E-WITHFP-NEXT:    sd a4, 32(s0)
; LP64E-WITHFP-NEXT:    .cfi_def_cfa sp, 72
; LP64E-WITHFP-NEXT:    ld ra, 16(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 8(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    .cfi_restore ra
; LP64E-WITHFP-NEXT:    .cfi_restore s0
; LP64E-WITHFP-NEXT:    addi sp, sp, 72
; LP64E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; LP64E-WITHFP-NEXT:    ret
  %va = alloca ptr
  call void @llvm.va_start(ptr %va)
  %argp.cur = load ptr, ptr %va, align 4
  %argp.next = getelementptr inbounds i8, ptr %argp.cur, i32 4
  store ptr %argp.next, ptr %va, align 4
  %1 = load i32, ptr %argp.cur, align 4
  call void @llvm.va_end(ptr %va)
  ret i32 %1
}

define i32 @va1_va_arg(ptr %fmt, ...) nounwind {
; ILP32-ILP32F-FPELIM-LABEL: va1_va_arg:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-FPELIM-NEXT:    mv a0, a1
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 36(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a6, 40(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a7, 44(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 20(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a2, 24(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a3, 28(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 32(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi a1, sp, 24
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 12(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va1_va_arg:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    mv a0, a1
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a6, 24(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a7, 28(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a1, s0, 8
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, -12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va1_va_arg:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    mv a0, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 36(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a6, 40(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a7, 44(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 20(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a2, 24(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a3, 28(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 32(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a1, sp, 24
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 12(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va1_va_arg:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -28
; ILP32E-FPELIM-NEXT:    mv a0, a1
; ILP32E-FPELIM-NEXT:    sw a5, 24(sp)
; ILP32E-FPELIM-NEXT:    sw a1, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a2, 12(sp)
; ILP32E-FPELIM-NEXT:    sw a3, 16(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 20(sp)
; ILP32E-FPELIM-NEXT:    addi a1, sp, 12
; ILP32E-FPELIM-NEXT:    sw a1, 0(sp)
; ILP32E-FPELIM-NEXT:    addi sp, sp, 28
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va1_va_arg:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -36
; ILP32E-WITHFP-NEXT:    sw ra, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-NEXT:    mv a0, a1
; ILP32E-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32E-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32E-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32E-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32E-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32E-WITHFP-NEXT:    addi a1, s0, 8
; ILP32E-WITHFP-NEXT:    sw a1, -12(s0)
; ILP32E-WITHFP-NEXT:    lw ra, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 36
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va1_va_arg:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -80
; LP64-LP64F-LP64D-FPELIM-NEXT:    mv a0, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a5, 56(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a6, 64(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a7, 72(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 24(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a2, 32(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 40(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a4, 48(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a1, sp, 32
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 80
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va1_va_arg:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -96
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 32
; LP64-LP64F-LP64D-WITHFP-NEXT:    mv a0, a1
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a5, 40(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a6, 48(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a7, 56(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a2, 16(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, 24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a4, 32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a1, s0, 16
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, -24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 96
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va1_va_arg:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -56
; LP64E-FPELIM-NEXT:    mv a0, a1
; LP64E-FPELIM-NEXT:    sd a5, 48(sp)
; LP64E-FPELIM-NEXT:    sd a1, 16(sp)
; LP64E-FPELIM-NEXT:    sd a2, 24(sp)
; LP64E-FPELIM-NEXT:    sd a3, 32(sp)
; LP64E-FPELIM-NEXT:    sd a4, 40(sp)
; LP64E-FPELIM-NEXT:    addi a1, sp, 24
; LP64E-FPELIM-NEXT:    sd a1, 0(sp)
; LP64E-FPELIM-NEXT:    addi sp, sp, 56
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va1_va_arg:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -72
; LP64E-WITHFP-NEXT:    sd ra, 16(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 8(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 24
; LP64E-WITHFP-NEXT:    mv a0, a1
; LP64E-WITHFP-NEXT:    sd a5, 40(s0)
; LP64E-WITHFP-NEXT:    sd a1, 8(s0)
; LP64E-WITHFP-NEXT:    sd a2, 16(s0)
; LP64E-WITHFP-NEXT:    sd a3, 24(s0)
; LP64E-WITHFP-NEXT:    sd a4, 32(s0)
; LP64E-WITHFP-NEXT:    addi a1, s0, 16
; LP64E-WITHFP-NEXT:    sd a1, -24(s0)
; LP64E-WITHFP-NEXT:    ld ra, 16(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 8(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 72
; LP64E-WITHFP-NEXT:    ret
  %va = alloca ptr
  call void @llvm.va_start(ptr %va)
  %1 = va_arg ptr %va, i32
  call void @llvm.va_end(ptr %va)
  ret i32 %1
}

; Ensure the adjustment when restoring the stack pointer using the frame
; pointer is correct
define i32 @va1_va_arg_alloca(ptr %fmt, ...) nounwind {
; ILP32-ILP32F-FPELIM-LABEL: va1_va_arg_alloca:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-FPELIM-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32-ILP32F-FPELIM-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; ILP32-ILP32F-FPELIM-NEXT:    addi s0, sp, 16
; ILP32-ILP32F-FPELIM-NEXT:    mv s1, a1
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 20(s0)
; ILP32-ILP32F-FPELIM-NEXT:    sw a6, 24(s0)
; ILP32-ILP32F-FPELIM-NEXT:    sw a7, 28(s0)
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 4(s0)
; ILP32-ILP32F-FPELIM-NEXT:    sw a2, 8(s0)
; ILP32-ILP32F-FPELIM-NEXT:    sw a3, 12(s0)
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 16(s0)
; ILP32-ILP32F-FPELIM-NEXT:    addi a0, s0, 8
; ILP32-ILP32F-FPELIM-NEXT:    sw a0, -16(s0)
; ILP32-ILP32F-FPELIM-NEXT:    addi a0, a1, 15
; ILP32-ILP32F-FPELIM-NEXT:    andi a0, a0, -16
; ILP32-ILP32F-FPELIM-NEXT:    sub a0, sp, a0
; ILP32-ILP32F-FPELIM-NEXT:    mv sp, a0
; ILP32-ILP32F-FPELIM-NEXT:    call notdead
; ILP32-ILP32F-FPELIM-NEXT:    mv a0, s1
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, s0, -16
; ILP32-ILP32F-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-FPELIM-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32-ILP32F-FPELIM-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va1_va_arg_alloca:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    mv s1, a1
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a6, 24(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a7, 28(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a0, s0, 8
; ILP32-ILP32F-WITHFP-NEXT:    sw a0, -16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a0, a1, 15
; ILP32-ILP32F-WITHFP-NEXT:    andi a0, a0, -16
; ILP32-ILP32F-WITHFP-NEXT:    sub a0, sp, a0
; ILP32-ILP32F-WITHFP-NEXT:    mv sp, a0
; ILP32-ILP32F-WITHFP-NEXT:    call notdead
; ILP32-ILP32F-WITHFP-NEXT:    mv a0, s1
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, s0, -16
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va1_va_arg_alloca:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi s0, sp, 16
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    mv s1, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 20(s0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a6, 24(s0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a7, 28(s0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 4(s0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a2, 8(s0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a3, 12(s0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 16(s0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a0, s0, 8
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a0, -16(s0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a0, a1, 15
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    andi a0, a0, -16
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sub a0, sp, a0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    mv sp, a0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    call notdead
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    mv a0, s1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, s0, -16
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va1_va_arg_alloca:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -40
; ILP32E-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    addi s0, sp, 16
; ILP32E-FPELIM-NEXT:    mv s1, a1
; ILP32E-FPELIM-NEXT:    sw a5, 20(s0)
; ILP32E-FPELIM-NEXT:    sw a1, 4(s0)
; ILP32E-FPELIM-NEXT:    sw a2, 8(s0)
; ILP32E-FPELIM-NEXT:    sw a3, 12(s0)
; ILP32E-FPELIM-NEXT:    sw a4, 16(s0)
; ILP32E-FPELIM-NEXT:    addi a0, s0, 8
; ILP32E-FPELIM-NEXT:    sw a0, -16(s0)
; ILP32E-FPELIM-NEXT:    addi a0, a1, 3
; ILP32E-FPELIM-NEXT:    andi a0, a0, -4
; ILP32E-FPELIM-NEXT:    sub a0, sp, a0
; ILP32E-FPELIM-NEXT:    mv sp, a0
; ILP32E-FPELIM-NEXT:    call notdead
; ILP32E-FPELIM-NEXT:    mv a0, s1
; ILP32E-FPELIM-NEXT:    addi sp, s0, -16
; ILP32E-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    addi sp, sp, 40
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va1_va_arg_alloca:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -40
; ILP32E-WITHFP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 16
; ILP32E-WITHFP-NEXT:    mv s1, a1
; ILP32E-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32E-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32E-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32E-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32E-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32E-WITHFP-NEXT:    addi a0, s0, 8
; ILP32E-WITHFP-NEXT:    sw a0, -16(s0)
; ILP32E-WITHFP-NEXT:    addi a0, a1, 3
; ILP32E-WITHFP-NEXT:    andi a0, a0, -4
; ILP32E-WITHFP-NEXT:    sub a0, sp, a0
; ILP32E-WITHFP-NEXT:    mv sp, a0
; ILP32E-WITHFP-NEXT:    call notdead
; ILP32E-WITHFP-NEXT:    mv a0, s1
; ILP32E-WITHFP-NEXT:    addi sp, s0, -16
; ILP32E-WITHFP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 40
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va1_va_arg_alloca:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -96
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi s0, sp, 32
; LP64-LP64F-LP64D-FPELIM-NEXT:    mv s1, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a5, 40(s0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a6, 48(s0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a7, 56(s0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 8(s0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a2, 16(s0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 24(s0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a4, 32(s0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a0, s0, 16
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a0, -32(s0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    slli a0, a1, 32
; LP64-LP64F-LP64D-FPELIM-NEXT:    srli a0, a0, 32
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a0, a0, 15
; LP64-LP64F-LP64D-FPELIM-NEXT:    andi a0, a0, -16
; LP64-LP64F-LP64D-FPELIM-NEXT:    sub a0, sp, a0
; LP64-LP64F-LP64D-FPELIM-NEXT:    mv sp, a0
; LP64-LP64F-LP64D-FPELIM-NEXT:    call notdead
; LP64-LP64F-LP64D-FPELIM-NEXT:    mv a0, s1
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, s0, -32
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 96
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va1_va_arg_alloca:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -96
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 32
; LP64-LP64F-LP64D-WITHFP-NEXT:    mv s1, a1
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a5, 40(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a6, 48(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a7, 56(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a2, 16(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, 24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a4, 32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a0, s0, 16
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a0, -32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    slli a0, a1, 32
; LP64-LP64F-LP64D-WITHFP-NEXT:    srli a0, a0, 32
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a0, a0, 15
; LP64-LP64F-LP64D-WITHFP-NEXT:    andi a0, a0, -16
; LP64-LP64F-LP64D-WITHFP-NEXT:    sub a0, sp, a0
; LP64-LP64F-LP64D-WITHFP-NEXT:    mv sp, a0
; LP64-LP64F-LP64D-WITHFP-NEXT:    call notdead
; LP64-LP64F-LP64D-WITHFP-NEXT:    mv a0, s1
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, s0, -32
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 96
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va1_va_arg_alloca:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -80
; LP64E-FPELIM-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64E-FPELIM-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64E-FPELIM-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; LP64E-FPELIM-NEXT:    addi s0, sp, 32
; LP64E-FPELIM-NEXT:    mv s1, a1
; LP64E-FPELIM-NEXT:    sd a5, 40(s0)
; LP64E-FPELIM-NEXT:    sd a1, 8(s0)
; LP64E-FPELIM-NEXT:    sd a2, 16(s0)
; LP64E-FPELIM-NEXT:    sd a3, 24(s0)
; LP64E-FPELIM-NEXT:    sd a4, 32(s0)
; LP64E-FPELIM-NEXT:    addi a0, s0, 16
; LP64E-FPELIM-NEXT:    sd a0, -32(s0)
; LP64E-FPELIM-NEXT:    slli a0, a1, 32
; LP64E-FPELIM-NEXT:    srli a0, a0, 32
; LP64E-FPELIM-NEXT:    addi a0, a0, 7
; LP64E-FPELIM-NEXT:    andi a0, a0, -8
; LP64E-FPELIM-NEXT:    sub a0, sp, a0
; LP64E-FPELIM-NEXT:    mv sp, a0
; LP64E-FPELIM-NEXT:    call notdead
; LP64E-FPELIM-NEXT:    mv a0, s1
; LP64E-FPELIM-NEXT:    addi sp, s0, -32
; LP64E-FPELIM-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64E-FPELIM-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64E-FPELIM-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; LP64E-FPELIM-NEXT:    addi sp, sp, 80
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va1_va_arg_alloca:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -80
; LP64E-WITHFP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 32
; LP64E-WITHFP-NEXT:    mv s1, a1
; LP64E-WITHFP-NEXT:    sd a5, 40(s0)
; LP64E-WITHFP-NEXT:    sd a1, 8(s0)
; LP64E-WITHFP-NEXT:    sd a2, 16(s0)
; LP64E-WITHFP-NEXT:    sd a3, 24(s0)
; LP64E-WITHFP-NEXT:    sd a4, 32(s0)
; LP64E-WITHFP-NEXT:    addi a0, s0, 16
; LP64E-WITHFP-NEXT:    sd a0, -32(s0)
; LP64E-WITHFP-NEXT:    slli a0, a1, 32
; LP64E-WITHFP-NEXT:    srli a0, a0, 32
; LP64E-WITHFP-NEXT:    addi a0, a0, 7
; LP64E-WITHFP-NEXT:    andi a0, a0, -8
; LP64E-WITHFP-NEXT:    sub a0, sp, a0
; LP64E-WITHFP-NEXT:    mv sp, a0
; LP64E-WITHFP-NEXT:    call notdead
; LP64E-WITHFP-NEXT:    mv a0, s1
; LP64E-WITHFP-NEXT:    addi sp, s0, -32
; LP64E-WITHFP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 80
; LP64E-WITHFP-NEXT:    ret
  %va = alloca ptr
  call void @llvm.va_start(ptr %va)
  %1 = va_arg ptr %va, i32
  %2 = alloca i8, i32 %1
  call void @notdead(ptr %2)
  call void @llvm.va_end(ptr %va)
  ret i32 %1
}

define void @va1_caller() nounwind {
; Pass a double, as a float would be promoted by a C/C++ frontend
; ILP32-ILP32F-FPELIM-LABEL: va1_caller:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -16
; ILP32-ILP32F-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-FPELIM-NEXT:    lui a3, 261888
; ILP32-ILP32F-FPELIM-NEXT:    li a4, 2
; ILP32-ILP32F-FPELIM-NEXT:    li a2, 0
; ILP32-ILP32F-FPELIM-NEXT:    call va1
; ILP32-ILP32F-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 16
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va1_caller:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -16
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    lui a3, 261888
; ILP32-ILP32F-WITHFP-NEXT:    li a4, 2
; ILP32-ILP32F-WITHFP-NEXT:    li a2, 0
; ILP32-ILP32F-WITHFP-NEXT:    call va1
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va1_caller:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -16
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a3, 261888
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a4, 2
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a2, 0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    call va1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 16
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va1_caller:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -4
; ILP32E-FPELIM-NEXT:    sw ra, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    lui a2, 261888
; ILP32E-FPELIM-NEXT:    li a3, 2
; ILP32E-FPELIM-NEXT:    li a1, 0
; ILP32E-FPELIM-NEXT:    call va1
; ILP32E-FPELIM-NEXT:    lw ra, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    addi sp, sp, 4
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va1_caller:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    lui a2, 261888
; ILP32E-WITHFP-NEXT:    li a3, 2
; ILP32E-WITHFP-NEXT:    li a1, 0
; ILP32E-WITHFP-NEXT:    call va1
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va1_caller:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -16
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-FPELIM-NEXT:    li a1, 1023
; LP64-LP64F-LP64D-FPELIM-NEXT:    slli a1, a1, 52
; LP64-LP64F-LP64D-FPELIM-NEXT:    li a2, 2
; LP64-LP64F-LP64D-FPELIM-NEXT:    call va1
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 16
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va1_caller:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -16
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 16
; LP64-LP64F-LP64D-WITHFP-NEXT:    li a1, 1023
; LP64-LP64F-LP64D-WITHFP-NEXT:    slli a1, a1, 52
; LP64-LP64F-LP64D-WITHFP-NEXT:    li a2, 2
; LP64-LP64F-LP64D-WITHFP-NEXT:    call va1
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 16
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va1_caller:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -8
; LP64E-FPELIM-NEXT:    sd ra, 0(sp) # 8-byte Folded Spill
; LP64E-FPELIM-NEXT:    li a1, 1023
; LP64E-FPELIM-NEXT:    slli a1, a1, 52
; LP64E-FPELIM-NEXT:    li a2, 2
; LP64E-FPELIM-NEXT:    call va1
; LP64E-FPELIM-NEXT:    ld ra, 0(sp) # 8-byte Folded Reload
; LP64E-FPELIM-NEXT:    addi sp, sp, 8
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va1_caller:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -16
; LP64E-WITHFP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 16
; LP64E-WITHFP-NEXT:    li a1, 1023
; LP64E-WITHFP-NEXT:    slli a1, a1, 52
; LP64E-WITHFP-NEXT:    li a2, 2
; LP64E-WITHFP-NEXT:    call va1
; LP64E-WITHFP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 16
; LP64E-WITHFP-NEXT:    ret
  %1 = call i32 (ptr, ...) @va1(ptr undef, double 1.0, i32 2)
  ret void
}

; Ensure that 2x xlen size+alignment varargs are accessed via an "aligned"
; register pair (where the first register is even-numbered).

define i64 @va2(ptr %fmt, ...) nounwind {
; ILP32-ILP32F-FPELIM-LABEL: va2:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 36(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a6, 40(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a7, 44(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 20(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a2, 24(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a3, 28(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 32(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi a0, sp, 20
; ILP32-ILP32F-FPELIM-NEXT:    addi a1, sp, 27
; ILP32-ILP32F-FPELIM-NEXT:    addi a2, sp, 35
; ILP32-ILP32F-FPELIM-NEXT:    sw a0, 12(sp)
; ILP32-ILP32F-FPELIM-NEXT:    andi a1, a1, -8
; ILP32-ILP32F-FPELIM-NEXT:    sw a2, 12(sp)
; ILP32-ILP32F-FPELIM-NEXT:    lw a0, 0(a1)
; ILP32-ILP32F-FPELIM-NEXT:    lw a1, 4(a1)
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va2:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a6, 24(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a7, 28(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a0, s0, 4
; ILP32-ILP32F-WITHFP-NEXT:    addi a1, s0, 11
; ILP32-ILP32F-WITHFP-NEXT:    addi a2, s0, 19
; ILP32-ILP32F-WITHFP-NEXT:    sw a0, -12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    andi a1, a1, -8
; ILP32-ILP32F-WITHFP-NEXT:    sw a2, -12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    lw a0, 0(a1)
; ILP32-ILP32F-WITHFP-NEXT:    lw a1, 4(a1)
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va2:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 36(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a6, 40(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a7, 44(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 20(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a2, 24(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a3, 28(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 32(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a0, sp, 20
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a1, sp, 27
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a2, sp, 35
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a0, 12(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    andi a1, a1, -8
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a2, 12(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a0, 0(a1)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a1, 4(a1)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va2:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -28
; ILP32E-FPELIM-NEXT:    sw a5, 24(sp)
; ILP32E-FPELIM-NEXT:    sw a1, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a2, 12(sp)
; ILP32E-FPELIM-NEXT:    sw a3, 16(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 20(sp)
; ILP32E-FPELIM-NEXT:    addi a0, sp, 8
; ILP32E-FPELIM-NEXT:    addi a1, sp, 15
; ILP32E-FPELIM-NEXT:    addi a2, sp, 23
; ILP32E-FPELIM-NEXT:    sw a0, 0(sp)
; ILP32E-FPELIM-NEXT:    andi a1, a1, -8
; ILP32E-FPELIM-NEXT:    sw a2, 0(sp)
; ILP32E-FPELIM-NEXT:    lw a0, 0(a1)
; ILP32E-FPELIM-NEXT:    lw a1, 4(a1)
; ILP32E-FPELIM-NEXT:    addi sp, sp, 28
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va2:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -36
; ILP32E-WITHFP-NEXT:    sw ra, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32E-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32E-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32E-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32E-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32E-WITHFP-NEXT:    addi a0, s0, 4
; ILP32E-WITHFP-NEXT:    addi a1, s0, 11
; ILP32E-WITHFP-NEXT:    addi a2, s0, 19
; ILP32E-WITHFP-NEXT:    sw a0, -12(s0)
; ILP32E-WITHFP-NEXT:    andi a1, a1, -8
; ILP32E-WITHFP-NEXT:    sw a2, -12(s0)
; ILP32E-WITHFP-NEXT:    lw a0, 0(a1)
; ILP32E-WITHFP-NEXT:    lw a1, 4(a1)
; ILP32E-WITHFP-NEXT:    lw ra, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 36
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va2:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -80
; LP64-LP64F-LP64D-FPELIM-NEXT:    mv a0, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a5, 56(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a6, 64(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a7, 72(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 24(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a2, 32(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 40(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a4, 48(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a1, sp, 39
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 80
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va2:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -96
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 32
; LP64-LP64F-LP64D-WITHFP-NEXT:    mv a0, a1
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a5, 40(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a6, 48(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a7, 56(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a2, 16(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, 24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a4, 32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a1, s0, 23
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, -24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 96
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va2:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -56
; LP64E-FPELIM-NEXT:    mv a0, a1
; LP64E-FPELIM-NEXT:    sd a5, 48(sp)
; LP64E-FPELIM-NEXT:    sd a1, 16(sp)
; LP64E-FPELIM-NEXT:    sd a2, 24(sp)
; LP64E-FPELIM-NEXT:    sd a3, 32(sp)
; LP64E-FPELIM-NEXT:    sd a4, 40(sp)
; LP64E-FPELIM-NEXT:    addi a1, sp, 31
; LP64E-FPELIM-NEXT:    sd a1, 0(sp)
; LP64E-FPELIM-NEXT:    addi sp, sp, 56
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va2:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -72
; LP64E-WITHFP-NEXT:    sd ra, 16(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 8(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 24
; LP64E-WITHFP-NEXT:    mv a0, a1
; LP64E-WITHFP-NEXT:    sd a5, 40(s0)
; LP64E-WITHFP-NEXT:    sd a1, 8(s0)
; LP64E-WITHFP-NEXT:    sd a2, 16(s0)
; LP64E-WITHFP-NEXT:    sd a3, 24(s0)
; LP64E-WITHFP-NEXT:    sd a4, 32(s0)
; LP64E-WITHFP-NEXT:    addi a1, s0, 23
; LP64E-WITHFP-NEXT:    sd a1, -24(s0)
; LP64E-WITHFP-NEXT:    ld ra, 16(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 8(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 72
; LP64E-WITHFP-NEXT:    ret
  %va = alloca ptr
  call void @llvm.va_start(ptr %va)
  %argp.cur = load ptr, ptr %va
  %ptrint = ptrtoint ptr %argp.cur to iXLen
  %1 = add iXLen %ptrint, 7
  %2 = and iXLen %1, -8
  %argp.cur.aligned = inttoptr iXLen %1 to ptr
  %argp.next = getelementptr inbounds i8, ptr %argp.cur.aligned, i32 8
  store ptr %argp.next, ptr %va
  %3 = inttoptr iXLen %2 to ptr
  %4 = load double, ptr %3, align 8
  %5 = bitcast double %4 to i64
  call void @llvm.va_end(ptr %va)
  ret i64 %5
}

define i64 @va2_va_arg(ptr %fmt, ...) nounwind {
; ILP32-ILP32F-FPELIM-LABEL: va2_va_arg:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 36(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a6, 40(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a7, 44(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 20(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a2, 24(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a3, 28(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 32(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi a0, sp, 27
; ILP32-ILP32F-FPELIM-NEXT:    andi a1, a0, -8
; ILP32-ILP32F-FPELIM-NEXT:    addi a0, a1, 4
; ILP32-ILP32F-FPELIM-NEXT:    addi a2, a1, 8
; ILP32-ILP32F-FPELIM-NEXT:    sw a0, 12(sp)
; ILP32-ILP32F-FPELIM-NEXT:    lw a0, 0(a1)
; ILP32-ILP32F-FPELIM-NEXT:    sw a2, 12(sp)
; ILP32-ILP32F-FPELIM-NEXT:    lw a1, 4(a1)
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va2_va_arg:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a6, 24(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a7, 28(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a0, s0, 11
; ILP32-ILP32F-WITHFP-NEXT:    andi a1, a0, -8
; ILP32-ILP32F-WITHFP-NEXT:    addi a0, a1, 4
; ILP32-ILP32F-WITHFP-NEXT:    addi a2, a1, 8
; ILP32-ILP32F-WITHFP-NEXT:    sw a0, -12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    lw a0, 0(a1)
; ILP32-ILP32F-WITHFP-NEXT:    sw a2, -12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    lw a1, 4(a1)
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va2_va_arg:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 36(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a6, 40(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a7, 44(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 20(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a2, 24(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a3, 28(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 32(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a0, sp, 27
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    andi a0, a0, -8
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a1, a0, 8
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 12(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    fld fa5, 0(a0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    fsd fa5, 0(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a0, 0(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a1, 4(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va2_va_arg:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -28
; ILP32E-FPELIM-NEXT:    sw a5, 24(sp)
; ILP32E-FPELIM-NEXT:    sw a1, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a2, 12(sp)
; ILP32E-FPELIM-NEXT:    sw a3, 16(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 20(sp)
; ILP32E-FPELIM-NEXT:    addi a0, sp, 15
; ILP32E-FPELIM-NEXT:    andi a1, a0, -8
; ILP32E-FPELIM-NEXT:    addi a0, a1, 4
; ILP32E-FPELIM-NEXT:    addi a2, a1, 8
; ILP32E-FPELIM-NEXT:    sw a0, 0(sp)
; ILP32E-FPELIM-NEXT:    lw a0, 0(a1)
; ILP32E-FPELIM-NEXT:    sw a2, 0(sp)
; ILP32E-FPELIM-NEXT:    lw a1, 4(a1)
; ILP32E-FPELIM-NEXT:    addi sp, sp, 28
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va2_va_arg:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -36
; ILP32E-WITHFP-NEXT:    sw ra, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32E-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32E-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32E-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32E-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32E-WITHFP-NEXT:    addi a0, s0, 11
; ILP32E-WITHFP-NEXT:    andi a1, a0, -8
; ILP32E-WITHFP-NEXT:    addi a0, a1, 4
; ILP32E-WITHFP-NEXT:    addi a2, a1, 8
; ILP32E-WITHFP-NEXT:    sw a0, -12(s0)
; ILP32E-WITHFP-NEXT:    lw a0, 0(a1)
; ILP32E-WITHFP-NEXT:    sw a2, -12(s0)
; ILP32E-WITHFP-NEXT:    lw a1, 4(a1)
; ILP32E-WITHFP-NEXT:    lw ra, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 36
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va2_va_arg:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -80
; LP64-LP64F-LP64D-FPELIM-NEXT:    mv a0, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a5, 56(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a6, 64(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a7, 72(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 24(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a2, 32(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 40(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a4, 48(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a1, sp, 32
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 80
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va2_va_arg:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -96
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 32
; LP64-LP64F-LP64D-WITHFP-NEXT:    mv a0, a1
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a5, 40(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a6, 48(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a7, 56(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a2, 16(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, 24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a4, 32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a1, s0, 16
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, -24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 96
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va2_va_arg:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -56
; LP64E-FPELIM-NEXT:    mv a0, a1
; LP64E-FPELIM-NEXT:    sd a5, 48(sp)
; LP64E-FPELIM-NEXT:    sd a1, 16(sp)
; LP64E-FPELIM-NEXT:    sd a2, 24(sp)
; LP64E-FPELIM-NEXT:    sd a3, 32(sp)
; LP64E-FPELIM-NEXT:    sd a4, 40(sp)
; LP64E-FPELIM-NEXT:    addi a1, sp, 24
; LP64E-FPELIM-NEXT:    sd a1, 0(sp)
; LP64E-FPELIM-NEXT:    addi sp, sp, 56
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va2_va_arg:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -72
; LP64E-WITHFP-NEXT:    sd ra, 16(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 8(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 24
; LP64E-WITHFP-NEXT:    mv a0, a1
; LP64E-WITHFP-NEXT:    sd a5, 40(s0)
; LP64E-WITHFP-NEXT:    sd a1, 8(s0)
; LP64E-WITHFP-NEXT:    sd a2, 16(s0)
; LP64E-WITHFP-NEXT:    sd a3, 24(s0)
; LP64E-WITHFP-NEXT:    sd a4, 32(s0)
; LP64E-WITHFP-NEXT:    addi a1, s0, 16
; LP64E-WITHFP-NEXT:    sd a1, -24(s0)
; LP64E-WITHFP-NEXT:    ld ra, 16(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 8(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 72
; LP64E-WITHFP-NEXT:    ret
  %va = alloca ptr
  call void @llvm.va_start(ptr %va)
  %1 = va_arg ptr %va, double
  call void @llvm.va_end(ptr %va)
  %2 = bitcast double %1 to i64
  ret i64 %2
}

define void @va2_caller() nounwind {
; ILP32-ILP32F-FPELIM-LABEL: va2_caller:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -16
; ILP32-ILP32F-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-FPELIM-NEXT:    lui a3, 261888
; ILP32-ILP32F-FPELIM-NEXT:    li a2, 0
; ILP32-ILP32F-FPELIM-NEXT:    call va2
; ILP32-ILP32F-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 16
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va2_caller:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -16
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    lui a3, 261888
; ILP32-ILP32F-WITHFP-NEXT:    li a2, 0
; ILP32-ILP32F-WITHFP-NEXT:    call va2
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va2_caller:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -16
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a3, 261888
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a2, 0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    call va2
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 16
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va2_caller:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -4
; ILP32E-FPELIM-NEXT:    sw ra, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    lui a2, 261888
; ILP32E-FPELIM-NEXT:    li a1, 0
; ILP32E-FPELIM-NEXT:    call va2
; ILP32E-FPELIM-NEXT:    lw ra, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    addi sp, sp, 4
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va2_caller:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    lui a2, 261888
; ILP32E-WITHFP-NEXT:    li a1, 0
; ILP32E-WITHFP-NEXT:    call va2
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va2_caller:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -16
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-FPELIM-NEXT:    li a1, 1023
; LP64-LP64F-LP64D-FPELIM-NEXT:    slli a1, a1, 52
; LP64-LP64F-LP64D-FPELIM-NEXT:    call va2
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 16
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va2_caller:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -16
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 16
; LP64-LP64F-LP64D-WITHFP-NEXT:    li a1, 1023
; LP64-LP64F-LP64D-WITHFP-NEXT:    slli a1, a1, 52
; LP64-LP64F-LP64D-WITHFP-NEXT:    call va2
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 16
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va2_caller:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -8
; LP64E-FPELIM-NEXT:    sd ra, 0(sp) # 8-byte Folded Spill
; LP64E-FPELIM-NEXT:    li a1, 1023
; LP64E-FPELIM-NEXT:    slli a1, a1, 52
; LP64E-FPELIM-NEXT:    call va2
; LP64E-FPELIM-NEXT:    ld ra, 0(sp) # 8-byte Folded Reload
; LP64E-FPELIM-NEXT:    addi sp, sp, 8
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va2_caller:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -16
; LP64E-WITHFP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 16
; LP64E-WITHFP-NEXT:    li a1, 1023
; LP64E-WITHFP-NEXT:    slli a1, a1, 52
; LP64E-WITHFP-NEXT:    call va2
; LP64E-WITHFP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 16
; LP64E-WITHFP-NEXT:    ret
 %1 = call i64 (ptr, ...) @va2(ptr undef, double 1.000000e+00)
 ret void
}

; On RV32, Ensure a named 2*xlen argument is passed in a1 and a2, while the
; vararg double is passed in a4 and a5 (rather than a3 and a4)

define i64 @va3(i32 %a, i64 %b, ...) nounwind {
; ILP32-ILP32F-FPELIM-LABEL: va3:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -32
; ILP32-ILP32F-FPELIM-NEXT:    sw a7, 28(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a3, 12(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 16(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 20(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a6, 24(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi a0, sp, 12
; ILP32-ILP32F-FPELIM-NEXT:    addi a3, sp, 19
; ILP32-ILP32F-FPELIM-NEXT:    addi a4, sp, 27
; ILP32-ILP32F-FPELIM-NEXT:    sw a0, 4(sp)
; ILP32-ILP32F-FPELIM-NEXT:    andi a3, a3, -8
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 4(sp)
; ILP32-ILP32F-FPELIM-NEXT:    lw a0, 4(a3)
; ILP32-ILP32F-FPELIM-NEXT:    lw a3, 0(a3)
; ILP32-ILP32F-FPELIM-NEXT:    add a2, a2, a0
; ILP32-ILP32F-FPELIM-NEXT:    add a0, a1, a3
; ILP32-ILP32F-FPELIM-NEXT:    sltu a1, a0, a1
; ILP32-ILP32F-FPELIM-NEXT:    add a1, a2, a1
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 32
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va3:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 20(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 16(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 24
; ILP32-ILP32F-WITHFP-NEXT:    sw a7, 20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a3, 4(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, 8(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a6, 16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a0, s0, 4
; ILP32-ILP32F-WITHFP-NEXT:    addi a3, s0, 11
; ILP32-ILP32F-WITHFP-NEXT:    addi a4, s0, 19
; ILP32-ILP32F-WITHFP-NEXT:    sw a0, -12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    andi a3, a3, -8
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, -12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    lw a0, 4(a3)
; ILP32-ILP32F-WITHFP-NEXT:    lw a3, 0(a3)
; ILP32-ILP32F-WITHFP-NEXT:    add a2, a2, a0
; ILP32-ILP32F-WITHFP-NEXT:    add a0, a1, a3
; ILP32-ILP32F-WITHFP-NEXT:    sltu a1, a0, a1
; ILP32-ILP32F-WITHFP-NEXT:    add a1, a2, a1
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 20(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 16(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va3:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -32
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a7, 28(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a3, 12(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 16(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 20(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a6, 24(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a0, sp, 12
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a3, sp, 19
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a4, sp, 27
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a0, 4(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    andi a3, a3, -8
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 4(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a0, 4(a3)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a3, 0(a3)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a2, a2, a0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a0, a1, a3
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sltu a1, a0, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a1, a2, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 32
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va3:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -20
; ILP32E-FPELIM-NEXT:    sw a3, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 12(sp)
; ILP32E-FPELIM-NEXT:    sw a5, 16(sp)
; ILP32E-FPELIM-NEXT:    addi a0, sp, 8
; ILP32E-FPELIM-NEXT:    addi a3, sp, 15
; ILP32E-FPELIM-NEXT:    addi a4, sp, 23
; ILP32E-FPELIM-NEXT:    sw a0, 0(sp)
; ILP32E-FPELIM-NEXT:    andi a3, a3, -8
; ILP32E-FPELIM-NEXT:    sw a4, 0(sp)
; ILP32E-FPELIM-NEXT:    lw a0, 4(a3)
; ILP32E-FPELIM-NEXT:    lw a3, 0(a3)
; ILP32E-FPELIM-NEXT:    add a2, a2, a0
; ILP32E-FPELIM-NEXT:    add a0, a1, a3
; ILP32E-FPELIM-NEXT:    sltu a1, a0, a1
; ILP32E-FPELIM-NEXT:    add a1, a2, a1
; ILP32E-FPELIM-NEXT:    addi sp, sp, 20
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va3:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -28
; ILP32E-WITHFP-NEXT:    sw ra, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-NEXT:    sw a3, 4(s0)
; ILP32E-WITHFP-NEXT:    sw a4, 8(s0)
; ILP32E-WITHFP-NEXT:    sw a5, 12(s0)
; ILP32E-WITHFP-NEXT:    addi a0, s0, 4
; ILP32E-WITHFP-NEXT:    addi a3, s0, 11
; ILP32E-WITHFP-NEXT:    addi a4, s0, 19
; ILP32E-WITHFP-NEXT:    sw a0, -12(s0)
; ILP32E-WITHFP-NEXT:    andi a3, a3, -8
; ILP32E-WITHFP-NEXT:    sw a4, -12(s0)
; ILP32E-WITHFP-NEXT:    lw a0, 4(a3)
; ILP32E-WITHFP-NEXT:    lw a3, 0(a3)
; ILP32E-WITHFP-NEXT:    add a2, a2, a0
; ILP32E-WITHFP-NEXT:    add a0, a1, a3
; ILP32E-WITHFP-NEXT:    sltu a1, a0, a1
; ILP32E-WITHFP-NEXT:    add a1, a2, a1
; ILP32E-WITHFP-NEXT:    lw ra, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 28
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va3:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -64
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a6, 48(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a7, 56(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a2, 16(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 24(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a4, 32(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a5, 40(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a3, sp, 31
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a0, a1, a2
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 64
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va3:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -80
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 32
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a6, 32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a7, 40(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a2, 0(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a4, 16(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a5, 24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a3, s0, 15
; LP64-LP64F-LP64D-WITHFP-NEXT:    add a0, a1, a2
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, -24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 80
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va3:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -40
; LP64E-FPELIM-NEXT:    sd a2, 8(sp)
; LP64E-FPELIM-NEXT:    sd a3, 16(sp)
; LP64E-FPELIM-NEXT:    sd a4, 24(sp)
; LP64E-FPELIM-NEXT:    sd a5, 32(sp)
; LP64E-FPELIM-NEXT:    addi a3, sp, 23
; LP64E-FPELIM-NEXT:    add a0, a1, a2
; LP64E-FPELIM-NEXT:    sd a3, 0(sp)
; LP64E-FPELIM-NEXT:    addi sp, sp, 40
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va3:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -56
; LP64E-WITHFP-NEXT:    sd ra, 16(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 8(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 24
; LP64E-WITHFP-NEXT:    sd a2, 0(s0)
; LP64E-WITHFP-NEXT:    sd a3, 8(s0)
; LP64E-WITHFP-NEXT:    sd a4, 16(s0)
; LP64E-WITHFP-NEXT:    sd a5, 24(s0)
; LP64E-WITHFP-NEXT:    addi a3, s0, 15
; LP64E-WITHFP-NEXT:    add a0, a1, a2
; LP64E-WITHFP-NEXT:    sd a3, -24(s0)
; LP64E-WITHFP-NEXT:    ld ra, 16(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 8(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 56
; LP64E-WITHFP-NEXT:    ret
  %va = alloca ptr
  call void @llvm.va_start(ptr %va)
  %argp.cur = load ptr, ptr %va
  %ptrint = ptrtoint ptr %argp.cur to iXLen
  %1 = add iXLen %ptrint, 7
  %2 = and iXLen %1, -8
  %argp.cur.aligned = inttoptr iXLen %1 to ptr
  %argp.next = getelementptr inbounds i8, ptr %argp.cur.aligned, i32 8
  store ptr %argp.next, ptr %va
  %3 = inttoptr iXLen %2 to ptr
  %4 = load double, ptr %3, align 8
  call void @llvm.va_end(ptr %va)
  %5 = bitcast double %4 to i64
  %6 = add i64 %b, %5
  ret i64 %6
}

define i64 @va3_va_arg(i32 %a, i64 %b, ...) nounwind {
; ILP32-ILP32F-FPELIM-LABEL: va3_va_arg:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -32
; ILP32-ILP32F-FPELIM-NEXT:    sw a7, 28(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a3, 12(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 16(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 20(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a6, 24(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi a0, sp, 19
; ILP32-ILP32F-FPELIM-NEXT:    andi a0, a0, -8
; ILP32-ILP32F-FPELIM-NEXT:    addi a3, a0, 4
; ILP32-ILP32F-FPELIM-NEXT:    addi a4, a0, 8
; ILP32-ILP32F-FPELIM-NEXT:    sw a3, 4(sp)
; ILP32-ILP32F-FPELIM-NEXT:    lw a3, 0(a0)
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 4(sp)
; ILP32-ILP32F-FPELIM-NEXT:    lw a4, 4(a0)
; ILP32-ILP32F-FPELIM-NEXT:    add a0, a1, a3
; ILP32-ILP32F-FPELIM-NEXT:    sltu a1, a0, a1
; ILP32-ILP32F-FPELIM-NEXT:    add a2, a2, a4
; ILP32-ILP32F-FPELIM-NEXT:    add a1, a2, a1
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 32
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va3_va_arg:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 20(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 16(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 24
; ILP32-ILP32F-WITHFP-NEXT:    sw a7, 20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a3, 4(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, 8(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a6, 16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a0, s0, 11
; ILP32-ILP32F-WITHFP-NEXT:    andi a0, a0, -8
; ILP32-ILP32F-WITHFP-NEXT:    addi a3, a0, 4
; ILP32-ILP32F-WITHFP-NEXT:    addi a4, a0, 8
; ILP32-ILP32F-WITHFP-NEXT:    sw a3, -12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    lw a3, 0(a0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, -12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    lw a4, 4(a0)
; ILP32-ILP32F-WITHFP-NEXT:    add a0, a1, a3
; ILP32-ILP32F-WITHFP-NEXT:    sltu a1, a0, a1
; ILP32-ILP32F-WITHFP-NEXT:    add a2, a2, a4
; ILP32-ILP32F-WITHFP-NEXT:    add a1, a2, a1
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 20(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 16(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va3_va_arg:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a7, 44(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a3, 28(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 32(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 36(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a6, 40(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a0, sp, 35
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    andi a0, a0, -8
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a3, a0, 8
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a3, 20(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    fld fa5, 0(a0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    fsd fa5, 8(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a0, 12(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a3, 8(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a2, a2, a0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a0, a1, a3
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sltu a1, a0, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a1, a2, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va3_va_arg:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -20
; ILP32E-FPELIM-NEXT:    sw a3, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 12(sp)
; ILP32E-FPELIM-NEXT:    sw a5, 16(sp)
; ILP32E-FPELIM-NEXT:    addi a0, sp, 15
; ILP32E-FPELIM-NEXT:    andi a0, a0, -8
; ILP32E-FPELIM-NEXT:    addi a3, a0, 4
; ILP32E-FPELIM-NEXT:    addi a4, a0, 8
; ILP32E-FPELIM-NEXT:    sw a3, 0(sp)
; ILP32E-FPELIM-NEXT:    lw a3, 0(a0)
; ILP32E-FPELIM-NEXT:    sw a4, 0(sp)
; ILP32E-FPELIM-NEXT:    lw a4, 4(a0)
; ILP32E-FPELIM-NEXT:    add a0, a1, a3
; ILP32E-FPELIM-NEXT:    sltu a1, a0, a1
; ILP32E-FPELIM-NEXT:    add a2, a2, a4
; ILP32E-FPELIM-NEXT:    add a1, a2, a1
; ILP32E-FPELIM-NEXT:    addi sp, sp, 20
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va3_va_arg:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -28
; ILP32E-WITHFP-NEXT:    sw ra, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-NEXT:    sw a3, 4(s0)
; ILP32E-WITHFP-NEXT:    sw a4, 8(s0)
; ILP32E-WITHFP-NEXT:    sw a5, 12(s0)
; ILP32E-WITHFP-NEXT:    addi a0, s0, 11
; ILP32E-WITHFP-NEXT:    andi a0, a0, -8
; ILP32E-WITHFP-NEXT:    addi a3, a0, 4
; ILP32E-WITHFP-NEXT:    addi a4, a0, 8
; ILP32E-WITHFP-NEXT:    sw a3, -12(s0)
; ILP32E-WITHFP-NEXT:    lw a3, 0(a0)
; ILP32E-WITHFP-NEXT:    sw a4, -12(s0)
; ILP32E-WITHFP-NEXT:    lw a4, 4(a0)
; ILP32E-WITHFP-NEXT:    add a0, a1, a3
; ILP32E-WITHFP-NEXT:    sltu a1, a0, a1
; ILP32E-WITHFP-NEXT:    add a2, a2, a4
; ILP32E-WITHFP-NEXT:    add a1, a2, a1
; ILP32E-WITHFP-NEXT:    lw ra, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 28
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va3_va_arg:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -64
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a6, 48(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a7, 56(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a2, 16(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 24(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a4, 32(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a5, 40(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a3, sp, 24
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a0, a1, a2
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 64
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va3_va_arg:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -80
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 32
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a6, 32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a7, 40(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a2, 0(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a4, 16(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a5, 24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a3, s0, 8
; LP64-LP64F-LP64D-WITHFP-NEXT:    add a0, a1, a2
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, -24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 80
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va3_va_arg:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -40
; LP64E-FPELIM-NEXT:    sd a2, 8(sp)
; LP64E-FPELIM-NEXT:    sd a3, 16(sp)
; LP64E-FPELIM-NEXT:    sd a4, 24(sp)
; LP64E-FPELIM-NEXT:    sd a5, 32(sp)
; LP64E-FPELIM-NEXT:    addi a3, sp, 16
; LP64E-FPELIM-NEXT:    add a0, a1, a2
; LP64E-FPELIM-NEXT:    sd a3, 0(sp)
; LP64E-FPELIM-NEXT:    addi sp, sp, 40
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va3_va_arg:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -56
; LP64E-WITHFP-NEXT:    sd ra, 16(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 8(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 24
; LP64E-WITHFP-NEXT:    sd a2, 0(s0)
; LP64E-WITHFP-NEXT:    sd a3, 8(s0)
; LP64E-WITHFP-NEXT:    sd a4, 16(s0)
; LP64E-WITHFP-NEXT:    sd a5, 24(s0)
; LP64E-WITHFP-NEXT:    addi a3, s0, 8
; LP64E-WITHFP-NEXT:    add a0, a1, a2
; LP64E-WITHFP-NEXT:    sd a3, -24(s0)
; LP64E-WITHFP-NEXT:    ld ra, 16(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 8(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 56
; LP64E-WITHFP-NEXT:    ret
  %va = alloca ptr
  call void @llvm.va_start(ptr %va)
  %1 = va_arg ptr %va, double
  call void @llvm.va_end(ptr %va)
  %2 = bitcast double %1 to i64
  %3 = add i64 %b, %2
  ret i64 %3
}

define void @va3_caller() nounwind {
; ILP32-ILP32F-FPELIM-LABEL: va3_caller:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -16
; ILP32-ILP32F-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-FPELIM-NEXT:    li a0, 2
; ILP32-ILP32F-FPELIM-NEXT:    li a1, 1111
; ILP32-ILP32F-FPELIM-NEXT:    lui a5, 262144
; ILP32-ILP32F-FPELIM-NEXT:    li a2, 0
; ILP32-ILP32F-FPELIM-NEXT:    li a4, 0
; ILP32-ILP32F-FPELIM-NEXT:    call va3
; ILP32-ILP32F-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 16
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va3_caller:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -16
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    li a0, 2
; ILP32-ILP32F-WITHFP-NEXT:    li a1, 1111
; ILP32-ILP32F-WITHFP-NEXT:    lui a5, 262144
; ILP32-ILP32F-WITHFP-NEXT:    li a2, 0
; ILP32-ILP32F-WITHFP-NEXT:    li a4, 0
; ILP32-ILP32F-WITHFP-NEXT:    call va3
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va3_caller:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -16
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a0, 2
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a1, 1111
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a5, 262144
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a2, 0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a4, 0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    call va3
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 16
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va3_caller:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -4
; ILP32E-FPELIM-NEXT:    sw ra, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    li a0, 2
; ILP32E-FPELIM-NEXT:    li a1, 1111
; ILP32E-FPELIM-NEXT:    lui a4, 262144
; ILP32E-FPELIM-NEXT:    li a2, 0
; ILP32E-FPELIM-NEXT:    li a3, 0
; ILP32E-FPELIM-NEXT:    call va3
; ILP32E-FPELIM-NEXT:    lw ra, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    addi sp, sp, 4
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va3_caller:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    li a0, 2
; ILP32E-WITHFP-NEXT:    li a1, 1111
; ILP32E-WITHFP-NEXT:    lui a4, 262144
; ILP32E-WITHFP-NEXT:    li a2, 0
; ILP32E-WITHFP-NEXT:    li a3, 0
; ILP32E-WITHFP-NEXT:    call va3
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va3_caller:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -16
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-FPELIM-NEXT:    li a2, 1
; LP64-LP64F-LP64D-FPELIM-NEXT:    li a0, 2
; LP64-LP64F-LP64D-FPELIM-NEXT:    slli a2, a2, 62
; LP64-LP64F-LP64D-FPELIM-NEXT:    li a1, 1111
; LP64-LP64F-LP64D-FPELIM-NEXT:    call va3
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 16
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va3_caller:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -16
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 16
; LP64-LP64F-LP64D-WITHFP-NEXT:    li a2, 1
; LP64-LP64F-LP64D-WITHFP-NEXT:    li a0, 2
; LP64-LP64F-LP64D-WITHFP-NEXT:    slli a2, a2, 62
; LP64-LP64F-LP64D-WITHFP-NEXT:    li a1, 1111
; LP64-LP64F-LP64D-WITHFP-NEXT:    call va3
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 16
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va3_caller:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -8
; LP64E-FPELIM-NEXT:    sd ra, 0(sp) # 8-byte Folded Spill
; LP64E-FPELIM-NEXT:    li a2, 1
; LP64E-FPELIM-NEXT:    li a0, 2
; LP64E-FPELIM-NEXT:    slli a2, a2, 62
; LP64E-FPELIM-NEXT:    li a1, 1111
; LP64E-FPELIM-NEXT:    call va3
; LP64E-FPELIM-NEXT:    ld ra, 0(sp) # 8-byte Folded Reload
; LP64E-FPELIM-NEXT:    addi sp, sp, 8
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va3_caller:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -16
; LP64E-WITHFP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 16
; LP64E-WITHFP-NEXT:    li a2, 1
; LP64E-WITHFP-NEXT:    li a0, 2
; LP64E-WITHFP-NEXT:    slli a2, a2, 62
; LP64E-WITHFP-NEXT:    li a1, 1111
; LP64E-WITHFP-NEXT:    call va3
; LP64E-WITHFP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 16
; LP64E-WITHFP-NEXT:    ret
 %1 = call i64 (i32, i64, ...) @va3(i32 2, i64 1111, double 2.000000e+00)
 ret void
}

declare void @llvm.va_copy(ptr, ptr)

define i32 @va4_va_copy(i32 %argno, ...) nounwind {
; ILP32-ILP32F-FPELIM-LABEL: va4_va_copy:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-FPELIM-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32-ILP32F-FPELIM-NEXT:    mv s0, a1
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 36(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a6, 40(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a7, 44(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 20(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a2, 24(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a3, 28(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 32(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi a0, sp, 24
; ILP32-ILP32F-FPELIM-NEXT:    sw a0, 4(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a0, 0(sp)
; ILP32-ILP32F-FPELIM-NEXT:    call notdead
; ILP32-ILP32F-FPELIM-NEXT:    lw a0, 4(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi a0, a0, 3
; ILP32-ILP32F-FPELIM-NEXT:    andi a0, a0, -4
; ILP32-ILP32F-FPELIM-NEXT:    addi a1, a0, 4
; ILP32-ILP32F-FPELIM-NEXT:    addi a2, a0, 7
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 4(sp)
; ILP32-ILP32F-FPELIM-NEXT:    andi a2, a2, -4
; ILP32-ILP32F-FPELIM-NEXT:    lw a0, 0(a0)
; ILP32-ILP32F-FPELIM-NEXT:    addi a1, a2, 4
; ILP32-ILP32F-FPELIM-NEXT:    addi a3, a2, 7
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 4(sp)
; ILP32-ILP32F-FPELIM-NEXT:    andi a3, a3, -4
; ILP32-ILP32F-FPELIM-NEXT:    lw a1, 0(a2)
; ILP32-ILP32F-FPELIM-NEXT:    addi a2, a3, 4
; ILP32-ILP32F-FPELIM-NEXT:    sw a2, 4(sp)
; ILP32-ILP32F-FPELIM-NEXT:    lw a2, 0(a3)
; ILP32-ILP32F-FPELIM-NEXT:    add a0, a0, s0
; ILP32-ILP32F-FPELIM-NEXT:    add a0, a0, a1
; ILP32-ILP32F-FPELIM-NEXT:    add a0, a0, a2
; ILP32-ILP32F-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-FPELIM-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va4_va_copy:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -64
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 32
; ILP32-ILP32F-WITHFP-NEXT:    mv s1, a1
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a6, 24(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a7, 28(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a0, s0, 8
; ILP32-ILP32F-WITHFP-NEXT:    sw a0, -16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a0, -20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    call notdead
; ILP32-ILP32F-WITHFP-NEXT:    lw a0, -16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a0, a0, 3
; ILP32-ILP32F-WITHFP-NEXT:    andi a0, a0, -4
; ILP32-ILP32F-WITHFP-NEXT:    addi a1, a0, 4
; ILP32-ILP32F-WITHFP-NEXT:    addi a2, a0, 7
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, -16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    andi a2, a2, -4
; ILP32-ILP32F-WITHFP-NEXT:    lw a0, 0(a0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a1, a2, 4
; ILP32-ILP32F-WITHFP-NEXT:    addi a3, a2, 7
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, -16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    andi a3, a3, -4
; ILP32-ILP32F-WITHFP-NEXT:    lw a1, 0(a2)
; ILP32-ILP32F-WITHFP-NEXT:    addi a2, a3, 4
; ILP32-ILP32F-WITHFP-NEXT:    sw a2, -16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    lw a2, 0(a3)
; ILP32-ILP32F-WITHFP-NEXT:    add a0, a0, s1
; ILP32-ILP32F-WITHFP-NEXT:    add a0, a0, a1
; ILP32-ILP32F-WITHFP-NEXT:    add a0, a0, a2
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 64
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va4_va_copy:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    mv s0, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 36(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a6, 40(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a7, 44(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 20(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a2, 24(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a3, 28(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 32(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a0, sp, 24
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a0, 4(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a0, 0(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    call notdead
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a0, 4(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a0, a0, 3
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    andi a0, a0, -4
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a1, a0, 4
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a2, a0, 7
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 4(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    andi a2, a2, -4
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a0, 0(a0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a1, a2, 4
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a3, a2, 7
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 4(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    andi a3, a3, -4
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a1, 0(a2)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a2, a3, 4
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a2, 4(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw a2, 0(a3)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a0, a0, s0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a0, a0, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a0, a0, a2
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va4_va_copy:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -40
; ILP32E-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    mv s0, a1
; ILP32E-FPELIM-NEXT:    sw a5, 36(sp)
; ILP32E-FPELIM-NEXT:    sw a1, 20(sp)
; ILP32E-FPELIM-NEXT:    sw a2, 24(sp)
; ILP32E-FPELIM-NEXT:    sw a3, 28(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 32(sp)
; ILP32E-FPELIM-NEXT:    addi a0, sp, 24
; ILP32E-FPELIM-NEXT:    sw a0, 4(sp)
; ILP32E-FPELIM-NEXT:    sw a0, 0(sp)
; ILP32E-FPELIM-NEXT:    call notdead
; ILP32E-FPELIM-NEXT:    lw a0, 4(sp)
; ILP32E-FPELIM-NEXT:    addi a0, a0, 3
; ILP32E-FPELIM-NEXT:    andi a0, a0, -4
; ILP32E-FPELIM-NEXT:    addi a1, a0, 4
; ILP32E-FPELIM-NEXT:    addi a2, a0, 7
; ILP32E-FPELIM-NEXT:    sw a1, 4(sp)
; ILP32E-FPELIM-NEXT:    andi a2, a2, -4
; ILP32E-FPELIM-NEXT:    lw a0, 0(a0)
; ILP32E-FPELIM-NEXT:    addi a1, a2, 4
; ILP32E-FPELIM-NEXT:    addi a3, a2, 7
; ILP32E-FPELIM-NEXT:    sw a1, 4(sp)
; ILP32E-FPELIM-NEXT:    andi a3, a3, -4
; ILP32E-FPELIM-NEXT:    lw a1, 0(a2)
; ILP32E-FPELIM-NEXT:    addi a2, a3, 4
; ILP32E-FPELIM-NEXT:    sw a2, 4(sp)
; ILP32E-FPELIM-NEXT:    lw a2, 0(a3)
; ILP32E-FPELIM-NEXT:    add a0, a0, s0
; ILP32E-FPELIM-NEXT:    add a0, a0, a1
; ILP32E-FPELIM-NEXT:    add a0, a0, a2
; ILP32E-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    addi sp, sp, 40
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va4_va_copy:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -44
; ILP32E-WITHFP-NEXT:    sw ra, 16(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 12(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s1, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 20
; ILP32E-WITHFP-NEXT:    mv s1, a1
; ILP32E-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32E-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32E-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32E-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32E-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32E-WITHFP-NEXT:    addi a0, s0, 8
; ILP32E-WITHFP-NEXT:    sw a0, -16(s0)
; ILP32E-WITHFP-NEXT:    sw a0, -20(s0)
; ILP32E-WITHFP-NEXT:    call notdead
; ILP32E-WITHFP-NEXT:    lw a0, -16(s0)
; ILP32E-WITHFP-NEXT:    addi a0, a0, 3
; ILP32E-WITHFP-NEXT:    andi a0, a0, -4
; ILP32E-WITHFP-NEXT:    addi a1, a0, 4
; ILP32E-WITHFP-NEXT:    addi a2, a0, 7
; ILP32E-WITHFP-NEXT:    sw a1, -16(s0)
; ILP32E-WITHFP-NEXT:    andi a2, a2, -4
; ILP32E-WITHFP-NEXT:    lw a0, 0(a0)
; ILP32E-WITHFP-NEXT:    addi a1, a2, 4
; ILP32E-WITHFP-NEXT:    addi a3, a2, 7
; ILP32E-WITHFP-NEXT:    sw a1, -16(s0)
; ILP32E-WITHFP-NEXT:    andi a3, a3, -4
; ILP32E-WITHFP-NEXT:    lw a1, 0(a2)
; ILP32E-WITHFP-NEXT:    addi a2, a3, 4
; ILP32E-WITHFP-NEXT:    sw a2, -16(s0)
; ILP32E-WITHFP-NEXT:    lw a2, 0(a3)
; ILP32E-WITHFP-NEXT:    add a0, a0, s1
; ILP32E-WITHFP-NEXT:    add a0, a0, a1
; ILP32E-WITHFP-NEXT:    add a0, a0, a2
; ILP32E-WITHFP-NEXT:    lw ra, 16(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 12(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s1, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 44
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va4_va_copy:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -96
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-FPELIM-NEXT:    mv s0, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a5, 72(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a6, 80(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a7, 88(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 40(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a2, 48(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 56(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a4, 64(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a0, sp, 48
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a0, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a0, 0(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    call notdead
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld a0, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a0, a0, 3
; LP64-LP64F-LP64D-FPELIM-NEXT:    andi a0, a0, -4
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a1, a0, 8
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a2, a0, 11
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    andi a2, a2, -4
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld a0, 0(a0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a1, a2, 8
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a3, a2, 11
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    andi a3, a3, -4
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld a1, 0(a2)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a2, a3, 8
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a2, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld a2, 0(a3)
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a0, a0, s0
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a0, a0, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    addw a0, a0, a2
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 96
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va4_va_copy:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -112
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 48
; LP64-LP64F-LP64D-WITHFP-NEXT:    mv s1, a1
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a5, 40(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a6, 48(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a7, 56(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a2, 16(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, 24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a4, 32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a0, s0, 16
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a0, -32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a0, -40(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    call notdead
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld a0, -32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a0, a0, 3
; LP64-LP64F-LP64D-WITHFP-NEXT:    andi a0, a0, -4
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a1, a0, 8
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a2, a0, 11
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, -32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    andi a2, a2, -4
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld a0, 0(a0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a1, a2, 8
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a3, a2, 11
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, -32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    andi a3, a3, -4
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld a1, 0(a2)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a2, a3, 8
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a2, -32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld a2, 0(a3)
; LP64-LP64F-LP64D-WITHFP-NEXT:    add a0, a0, s1
; LP64-LP64F-LP64D-WITHFP-NEXT:    add a0, a0, a1
; LP64-LP64F-LP64D-WITHFP-NEXT:    addw a0, a0, a2
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 112
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va4_va_copy:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -80
; LP64E-FPELIM-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64E-FPELIM-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64E-FPELIM-NEXT:    mv s0, a1
; LP64E-FPELIM-NEXT:    sd a5, 72(sp)
; LP64E-FPELIM-NEXT:    sd a1, 40(sp)
; LP64E-FPELIM-NEXT:    sd a2, 48(sp)
; LP64E-FPELIM-NEXT:    sd a3, 56(sp)
; LP64E-FPELIM-NEXT:    sd a4, 64(sp)
; LP64E-FPELIM-NEXT:    addi a0, sp, 48
; LP64E-FPELIM-NEXT:    sd a0, 8(sp)
; LP64E-FPELIM-NEXT:    sd a0, 0(sp)
; LP64E-FPELIM-NEXT:    call notdead
; LP64E-FPELIM-NEXT:    ld a0, 8(sp)
; LP64E-FPELIM-NEXT:    addi a0, a0, 3
; LP64E-FPELIM-NEXT:    andi a0, a0, -4
; LP64E-FPELIM-NEXT:    addi a1, a0, 8
; LP64E-FPELIM-NEXT:    addi a2, a0, 11
; LP64E-FPELIM-NEXT:    sd a1, 8(sp)
; LP64E-FPELIM-NEXT:    andi a2, a2, -4
; LP64E-FPELIM-NEXT:    ld a0, 0(a0)
; LP64E-FPELIM-NEXT:    addi a1, a2, 8
; LP64E-FPELIM-NEXT:    addi a3, a2, 11
; LP64E-FPELIM-NEXT:    sd a1, 8(sp)
; LP64E-FPELIM-NEXT:    andi a3, a3, -4
; LP64E-FPELIM-NEXT:    ld a1, 0(a2)
; LP64E-FPELIM-NEXT:    addi a2, a3, 8
; LP64E-FPELIM-NEXT:    sd a2, 8(sp)
; LP64E-FPELIM-NEXT:    ld a2, 0(a3)
; LP64E-FPELIM-NEXT:    add a0, a0, s0
; LP64E-FPELIM-NEXT:    add a0, a0, a1
; LP64E-FPELIM-NEXT:    addw a0, a0, a2
; LP64E-FPELIM-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64E-FPELIM-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64E-FPELIM-NEXT:    addi sp, sp, 80
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va4_va_copy:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -88
; LP64E-WITHFP-NEXT:    sd ra, 32(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 24(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s1, 16(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 40
; LP64E-WITHFP-NEXT:    mv s1, a1
; LP64E-WITHFP-NEXT:    sd a5, 40(s0)
; LP64E-WITHFP-NEXT:    sd a1, 8(s0)
; LP64E-WITHFP-NEXT:    sd a2, 16(s0)
; LP64E-WITHFP-NEXT:    sd a3, 24(s0)
; LP64E-WITHFP-NEXT:    sd a4, 32(s0)
; LP64E-WITHFP-NEXT:    addi a0, s0, 16
; LP64E-WITHFP-NEXT:    sd a0, -32(s0)
; LP64E-WITHFP-NEXT:    sd a0, -40(s0)
; LP64E-WITHFP-NEXT:    call notdead
; LP64E-WITHFP-NEXT:    ld a0, -32(s0)
; LP64E-WITHFP-NEXT:    addi a0, a0, 3
; LP64E-WITHFP-NEXT:    andi a0, a0, -4
; LP64E-WITHFP-NEXT:    addi a1, a0, 8
; LP64E-WITHFP-NEXT:    addi a2, a0, 11
; LP64E-WITHFP-NEXT:    sd a1, -32(s0)
; LP64E-WITHFP-NEXT:    andi a2, a2, -4
; LP64E-WITHFP-NEXT:    ld a0, 0(a0)
; LP64E-WITHFP-NEXT:    addi a1, a2, 8
; LP64E-WITHFP-NEXT:    addi a3, a2, 11
; LP64E-WITHFP-NEXT:    sd a1, -32(s0)
; LP64E-WITHFP-NEXT:    andi a3, a3, -4
; LP64E-WITHFP-NEXT:    ld a1, 0(a2)
; LP64E-WITHFP-NEXT:    addi a2, a3, 8
; LP64E-WITHFP-NEXT:    sd a2, -32(s0)
; LP64E-WITHFP-NEXT:    ld a2, 0(a3)
; LP64E-WITHFP-NEXT:    add a0, a0, s1
; LP64E-WITHFP-NEXT:    add a0, a0, a1
; LP64E-WITHFP-NEXT:    addw a0, a0, a2
; LP64E-WITHFP-NEXT:    ld ra, 32(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 24(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s1, 16(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 88
; LP64E-WITHFP-NEXT:    ret
  %vargs = alloca ptr
  %wargs = alloca ptr
  call void @llvm.va_start(ptr %vargs)
  %1 = va_arg ptr %vargs, i32
  call void @llvm.va_copy(ptr %wargs, ptr %vargs)
  %2 = load ptr, ptr %wargs, align 4
  call void @notdead(ptr %2)
  %3 = va_arg ptr %vargs, i32
  %4 = va_arg ptr %vargs, i32
  %5 = va_arg ptr %vargs, i32
  call void @llvm.va_end(ptr %vargs)
  call void @llvm.va_end(ptr %wargs)
  %add1 = add i32 %3, %1
  %add2 = add i32 %add1, %4
  %add3 = add i32 %add2, %5
  ret i32 %add3
}

; Check 2x*xlen values are aligned appropriately when passed on the stack in a vararg call

declare i32 @va5_aligned_stack_callee(i32, ...)

define void @va5_aligned_stack_caller() nounwind {
; The double should be 8-byte aligned on the stack, but the two-element array
; should only be 4-byte aligned
; ILP32-ILP32F-FPELIM-LABEL: va5_aligned_stack_caller:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -64
; ILP32-ILP32F-FPELIM-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; ILP32-ILP32F-FPELIM-NEXT:    li a4, 17
; ILP32-ILP32F-FPELIM-NEXT:    li a5, 16
; ILP32-ILP32F-FPELIM-NEXT:    li a6, 15
; ILP32-ILP32F-FPELIM-NEXT:    lui a7, 262236
; ILP32-ILP32F-FPELIM-NEXT:    lui t0, 377487
; ILP32-ILP32F-FPELIM-NEXT:    li t1, 14
; ILP32-ILP32F-FPELIM-NEXT:    lui t2, 262153
; ILP32-ILP32F-FPELIM-NEXT:    lui t3, 545260
; ILP32-ILP32F-FPELIM-NEXT:    lui t4, 964690
; ILP32-ILP32F-FPELIM-NEXT:    lui t5, 335544
; ILP32-ILP32F-FPELIM-NEXT:    lui t6, 688509
; ILP32-ILP32F-FPELIM-NEXT:    li a0, 1
; ILP32-ILP32F-FPELIM-NEXT:    li a1, 11
; ILP32-ILP32F-FPELIM-NEXT:    addi a2, sp, 32
; ILP32-ILP32F-FPELIM-NEXT:    li a3, 12
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 20(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 24(sp)
; ILP32-ILP32F-FPELIM-NEXT:    li a4, 13
; ILP32-ILP32F-FPELIM-NEXT:    addi a5, a7, 655
; ILP32-ILP32F-FPELIM-NEXT:    addi a7, t0, 1475
; ILP32-ILP32F-FPELIM-NEXT:    sw t1, 0(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a7, 8(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 12(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a6, 16(sp)
; ILP32-ILP32F-FPELIM-NEXT:    li a7, 4
; ILP32-ILP32F-FPELIM-NEXT:    addi a5, t2, 491
; ILP32-ILP32F-FPELIM-NEXT:    addi t0, t3, -1967
; ILP32-ILP32F-FPELIM-NEXT:    addi t1, t4, -328
; ILP32-ILP32F-FPELIM-NEXT:    addi t2, t5, 1311
; ILP32-ILP32F-FPELIM-NEXT:    addi a6, t6, -2048
; ILP32-ILP32F-FPELIM-NEXT:    sw t2, 32(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw t1, 36(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw t0, 40(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 44(sp)
; ILP32-ILP32F-FPELIM-NEXT:    call va5_aligned_stack_callee
; ILP32-ILP32F-FPELIM-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 64
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va5_aligned_stack_caller:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -64
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 64
; ILP32-ILP32F-WITHFP-NEXT:    li a4, 17
; ILP32-ILP32F-WITHFP-NEXT:    li a5, 16
; ILP32-ILP32F-WITHFP-NEXT:    li a6, 15
; ILP32-ILP32F-WITHFP-NEXT:    lui a7, 262236
; ILP32-ILP32F-WITHFP-NEXT:    lui t0, 377487
; ILP32-ILP32F-WITHFP-NEXT:    li t1, 14
; ILP32-ILP32F-WITHFP-NEXT:    lui t2, 262153
; ILP32-ILP32F-WITHFP-NEXT:    lui t3, 545260
; ILP32-ILP32F-WITHFP-NEXT:    lui t4, 964690
; ILP32-ILP32F-WITHFP-NEXT:    lui t5, 335544
; ILP32-ILP32F-WITHFP-NEXT:    lui t6, 688509
; ILP32-ILP32F-WITHFP-NEXT:    li a0, 1
; ILP32-ILP32F-WITHFP-NEXT:    li a1, 11
; ILP32-ILP32F-WITHFP-NEXT:    addi a2, s0, -32
; ILP32-ILP32F-WITHFP-NEXT:    li a3, 12
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 20(sp)
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, 24(sp)
; ILP32-ILP32F-WITHFP-NEXT:    li a4, 13
; ILP32-ILP32F-WITHFP-NEXT:    addi a5, a7, 655
; ILP32-ILP32F-WITHFP-NEXT:    addi a7, t0, 1475
; ILP32-ILP32F-WITHFP-NEXT:    sw t1, 0(sp)
; ILP32-ILP32F-WITHFP-NEXT:    sw a7, 8(sp)
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 12(sp)
; ILP32-ILP32F-WITHFP-NEXT:    sw a6, 16(sp)
; ILP32-ILP32F-WITHFP-NEXT:    li a7, 4
; ILP32-ILP32F-WITHFP-NEXT:    addi a5, t2, 491
; ILP32-ILP32F-WITHFP-NEXT:    addi t0, t3, -1967
; ILP32-ILP32F-WITHFP-NEXT:    addi t1, t4, -328
; ILP32-ILP32F-WITHFP-NEXT:    addi t2, t5, 1311
; ILP32-ILP32F-WITHFP-NEXT:    addi a6, t6, -2048
; ILP32-ILP32F-WITHFP-NEXT:    sw t2, -32(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw t1, -28(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw t0, -24(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, -20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    call va5_aligned_stack_callee
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 64
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va5_aligned_stack_caller:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -64
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a5, 262236
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a6, 377487
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a4, 17
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a7, 16
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li t0, 15
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li t1, 14
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui t2, 262153
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui t3, 545260
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui t4, 964690
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui t5, 335544
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui t6, 688509
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a0, 1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a1, 11
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a2, sp, 32
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a3, 12
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a7, 20(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 24(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a4, 13
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a5, a5, 655
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a6, a6, 1475
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw t1, 0(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a6, 8(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 12(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw t0, 16(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    li a7, 4
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a5, t2, 491
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi t0, t3, -1967
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi t1, t4, -328
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi t2, t5, 1311
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a6, t6, -2048
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw t2, 32(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw t1, 36(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw t0, 40(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 44(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    call va5_aligned_stack_callee
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 64
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va5_aligned_stack_caller:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -64
; ILP32E-FPELIM-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    addi s0, sp, 64
; ILP32E-FPELIM-NEXT:    andi sp, sp, -16
; ILP32E-FPELIM-NEXT:    li a3, 17
; ILP32E-FPELIM-NEXT:    li a4, 16
; ILP32E-FPELIM-NEXT:    li a5, 15
; ILP32E-FPELIM-NEXT:    lui a6, 262236
; ILP32E-FPELIM-NEXT:    lui a7, 377487
; ILP32E-FPELIM-NEXT:    li t0, 14
; ILP32E-FPELIM-NEXT:    li t1, 4
; ILP32E-FPELIM-NEXT:    lui t2, 262153
; ILP32E-FPELIM-NEXT:    lui t3, 545260
; ILP32E-FPELIM-NEXT:    lui t4, 964690
; ILP32E-FPELIM-NEXT:    lui t5, 335544
; ILP32E-FPELIM-NEXT:    lui t6, 688509
; ILP32E-FPELIM-NEXT:    li a0, 1
; ILP32E-FPELIM-NEXT:    li a1, 11
; ILP32E-FPELIM-NEXT:    addi a2, sp, 32
; ILP32E-FPELIM-NEXT:    sw a5, 16(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 20(sp)
; ILP32E-FPELIM-NEXT:    sw a3, 24(sp)
; ILP32E-FPELIM-NEXT:    li a3, 12
; ILP32E-FPELIM-NEXT:    addi a4, a6, 655
; ILP32E-FPELIM-NEXT:    addi a5, a7, 1475
; ILP32E-FPELIM-NEXT:    sw t1, 0(sp)
; ILP32E-FPELIM-NEXT:    sw t0, 4(sp)
; ILP32E-FPELIM-NEXT:    sw a5, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 12(sp)
; ILP32E-FPELIM-NEXT:    li a4, 13
; ILP32E-FPELIM-NEXT:    addi a6, t2, 491
; ILP32E-FPELIM-NEXT:    addi a7, t3, -1967
; ILP32E-FPELIM-NEXT:    addi t0, t4, -328
; ILP32E-FPELIM-NEXT:    addi t1, t5, 1311
; ILP32E-FPELIM-NEXT:    addi a5, t6, -2048
; ILP32E-FPELIM-NEXT:    sw t1, 32(sp)
; ILP32E-FPELIM-NEXT:    sw t0, 36(sp)
; ILP32E-FPELIM-NEXT:    sw a7, 40(sp)
; ILP32E-FPELIM-NEXT:    sw a6, 44(sp)
; ILP32E-FPELIM-NEXT:    call va5_aligned_stack_callee
; ILP32E-FPELIM-NEXT:    addi sp, s0, -64
; ILP32E-FPELIM-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    addi sp, sp, 64
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va5_aligned_stack_caller:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -64
; ILP32E-WITHFP-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 64
; ILP32E-WITHFP-NEXT:    andi sp, sp, -16
; ILP32E-WITHFP-NEXT:    li a3, 17
; ILP32E-WITHFP-NEXT:    li a4, 16
; ILP32E-WITHFP-NEXT:    li a5, 15
; ILP32E-WITHFP-NEXT:    lui a6, 262236
; ILP32E-WITHFP-NEXT:    lui a7, 377487
; ILP32E-WITHFP-NEXT:    li t0, 14
; ILP32E-WITHFP-NEXT:    li t1, 4
; ILP32E-WITHFP-NEXT:    lui t2, 262153
; ILP32E-WITHFP-NEXT:    lui t3, 545260
; ILP32E-WITHFP-NEXT:    lui t4, 964690
; ILP32E-WITHFP-NEXT:    lui t5, 335544
; ILP32E-WITHFP-NEXT:    lui t6, 688509
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    li a1, 11
; ILP32E-WITHFP-NEXT:    addi a2, sp, 32
; ILP32E-WITHFP-NEXT:    sw a5, 16(sp)
; ILP32E-WITHFP-NEXT:    sw a4, 20(sp)
; ILP32E-WITHFP-NEXT:    sw a3, 24(sp)
; ILP32E-WITHFP-NEXT:    li a3, 12
; ILP32E-WITHFP-NEXT:    addi a4, a6, 655
; ILP32E-WITHFP-NEXT:    addi a5, a7, 1475
; ILP32E-WITHFP-NEXT:    sw t1, 0(sp)
; ILP32E-WITHFP-NEXT:    sw t0, 4(sp)
; ILP32E-WITHFP-NEXT:    sw a5, 8(sp)
; ILP32E-WITHFP-NEXT:    sw a4, 12(sp)
; ILP32E-WITHFP-NEXT:    li a4, 13
; ILP32E-WITHFP-NEXT:    addi a6, t2, 491
; ILP32E-WITHFP-NEXT:    addi a7, t3, -1967
; ILP32E-WITHFP-NEXT:    addi t0, t4, -328
; ILP32E-WITHFP-NEXT:    addi t1, t5, 1311
; ILP32E-WITHFP-NEXT:    addi a5, t6, -2048
; ILP32E-WITHFP-NEXT:    sw t1, 32(sp)
; ILP32E-WITHFP-NEXT:    sw t0, 36(sp)
; ILP32E-WITHFP-NEXT:    sw a7, 40(sp)
; ILP32E-WITHFP-NEXT:    sw a6, 44(sp)
; ILP32E-WITHFP-NEXT:    call va5_aligned_stack_callee
; ILP32E-WITHFP-NEXT:    addi sp, s0, -64
; ILP32E-WITHFP-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 64
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va5_aligned_stack_caller:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -48
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-FPELIM-NEXT:    li t0, 17
; LP64-LP64F-LP64D-FPELIM-NEXT:    li t1, 16
; LP64-LP64F-LP64D-FPELIM-NEXT:    li t2, 15
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a2, %hi(.LCPI11_0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a3, %hi(.LCPI11_1)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a6, %hi(.LCPI11_2)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui t3, 2384
; LP64-LP64F-LP64D-FPELIM-NEXT:    li a0, 1
; LP64-LP64F-LP64D-FPELIM-NEXT:    li a1, 11
; LP64-LP64F-LP64D-FPELIM-NEXT:    li a4, 12
; LP64-LP64F-LP64D-FPELIM-NEXT:    li a5, 13
; LP64-LP64F-LP64D-FPELIM-NEXT:    li a7, 14
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld t4, %lo(.LCPI11_0)(a2)
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld a2, %lo(.LCPI11_1)(a3)
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld a3, %lo(.LCPI11_2)(a6)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addiw a6, t3, 761
; LP64-LP64F-LP64D-FPELIM-NEXT:    slli a6, a6, 11
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd t4, 0(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd t2, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd t1, 16(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd t0, 24(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    call va5_aligned_stack_callee
; LP64-LP64F-LP64D-FPELIM-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 48
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va5_aligned_stack_caller:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -48
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 48
; LP64-LP64F-LP64D-WITHFP-NEXT:    li t0, 17
; LP64-LP64F-LP64D-WITHFP-NEXT:    li t1, 16
; LP64-LP64F-LP64D-WITHFP-NEXT:    li t2, 15
; LP64-LP64F-LP64D-WITHFP-NEXT:    lui a2, %hi(.LCPI11_0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    lui a3, %hi(.LCPI11_1)
; LP64-LP64F-LP64D-WITHFP-NEXT:    lui a6, %hi(.LCPI11_2)
; LP64-LP64F-LP64D-WITHFP-NEXT:    lui t3, 2384
; LP64-LP64F-LP64D-WITHFP-NEXT:    li a0, 1
; LP64-LP64F-LP64D-WITHFP-NEXT:    li a1, 11
; LP64-LP64F-LP64D-WITHFP-NEXT:    li a4, 12
; LP64-LP64F-LP64D-WITHFP-NEXT:    li a5, 13
; LP64-LP64F-LP64D-WITHFP-NEXT:    li a7, 14
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld t4, %lo(.LCPI11_0)(a2)
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld a2, %lo(.LCPI11_1)(a3)
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld a3, %lo(.LCPI11_2)(a6)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addiw a6, t3, 761
; LP64-LP64F-LP64D-WITHFP-NEXT:    slli a6, a6, 11
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd t4, 0(sp)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd t2, 8(sp)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd t1, 16(sp)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd t0, 24(sp)
; LP64-LP64F-LP64D-WITHFP-NEXT:    call va5_aligned_stack_callee
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 48
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va5_aligned_stack_caller:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -56
; LP64E-FPELIM-NEXT:    sd ra, 48(sp) # 8-byte Folded Spill
; LP64E-FPELIM-NEXT:    li a2, 17
; LP64E-FPELIM-NEXT:    li a3, 16
; LP64E-FPELIM-NEXT:    li a6, 15
; LP64E-FPELIM-NEXT:    lui a7, %hi(.LCPI11_0)
; LP64E-FPELIM-NEXT:    li t0, 14
; LP64E-FPELIM-NEXT:    lui t1, 2384
; LP64E-FPELIM-NEXT:    lui t2, %hi(.LCPI11_1)
; LP64E-FPELIM-NEXT:    lui t3, %hi(.LCPI11_2)
; LP64E-FPELIM-NEXT:    li a0, 1
; LP64E-FPELIM-NEXT:    li a1, 11
; LP64E-FPELIM-NEXT:    li a4, 12
; LP64E-FPELIM-NEXT:    sd a3, 32(sp)
; LP64E-FPELIM-NEXT:    sd a2, 40(sp)
; LP64E-FPELIM-NEXT:    li a5, 13
; LP64E-FPELIM-NEXT:    ld a7, %lo(.LCPI11_0)(a7)
; LP64E-FPELIM-NEXT:    addiw t1, t1, 761
; LP64E-FPELIM-NEXT:    ld a2, %lo(.LCPI11_1)(t2)
; LP64E-FPELIM-NEXT:    ld a3, %lo(.LCPI11_2)(t3)
; LP64E-FPELIM-NEXT:    slli t1, t1, 11
; LP64E-FPELIM-NEXT:    sd t1, 0(sp)
; LP64E-FPELIM-NEXT:    sd t0, 8(sp)
; LP64E-FPELIM-NEXT:    sd a7, 16(sp)
; LP64E-FPELIM-NEXT:    sd a6, 24(sp)
; LP64E-FPELIM-NEXT:    call va5_aligned_stack_callee
; LP64E-FPELIM-NEXT:    ld ra, 48(sp) # 8-byte Folded Reload
; LP64E-FPELIM-NEXT:    addi sp, sp, 56
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va5_aligned_stack_caller:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -64
; LP64E-WITHFP-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 64
; LP64E-WITHFP-NEXT:    li a2, 17
; LP64E-WITHFP-NEXT:    li a3, 16
; LP64E-WITHFP-NEXT:    li a6, 15
; LP64E-WITHFP-NEXT:    lui a7, %hi(.LCPI11_0)
; LP64E-WITHFP-NEXT:    li t0, 14
; LP64E-WITHFP-NEXT:    lui t1, 2384
; LP64E-WITHFP-NEXT:    lui t2, %hi(.LCPI11_1)
; LP64E-WITHFP-NEXT:    lui t3, %hi(.LCPI11_2)
; LP64E-WITHFP-NEXT:    li a0, 1
; LP64E-WITHFP-NEXT:    li a1, 11
; LP64E-WITHFP-NEXT:    li a4, 12
; LP64E-WITHFP-NEXT:    sd a3, 32(sp)
; LP64E-WITHFP-NEXT:    sd a2, 40(sp)
; LP64E-WITHFP-NEXT:    li a5, 13
; LP64E-WITHFP-NEXT:    ld a7, %lo(.LCPI11_0)(a7)
; LP64E-WITHFP-NEXT:    addiw t1, t1, 761
; LP64E-WITHFP-NEXT:    ld a2, %lo(.LCPI11_1)(t2)
; LP64E-WITHFP-NEXT:    ld a3, %lo(.LCPI11_2)(t3)
; LP64E-WITHFP-NEXT:    slli t1, t1, 11
; LP64E-WITHFP-NEXT:    sd t1, 0(sp)
; LP64E-WITHFP-NEXT:    sd t0, 8(sp)
; LP64E-WITHFP-NEXT:    sd a7, 16(sp)
; LP64E-WITHFP-NEXT:    sd a6, 24(sp)
; LP64E-WITHFP-NEXT:    call va5_aligned_stack_callee
; LP64E-WITHFP-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 64
; LP64E-WITHFP-NEXT:    ret
  %1 = call i32 (i32, ...) @va5_aligned_stack_callee(i32 1, i32 11,
    fp128 0xLEB851EB851EB851F400091EB851EB851, i32 12, i32 13, i64 20000000000,
    i32 14, double 2.720000e+00, i32 15, [2 x i32] [i32 16, i32 17])
  ret void
}

; A function with no fixed arguments is not valid C, but can be
; specified in LLVM IR. We must ensure the vararg save area is
; still set up correctly.

define i32 @va6_no_fixed_args(...) nounwind {
; ILP32-ILP32F-FPELIM-LABEL: va6_no_fixed_args:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 32(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 36(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a6, 40(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a7, 44(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a0, 16(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 20(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a2, 24(sp)
; ILP32-ILP32F-FPELIM-NEXT:    sw a3, 28(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi a1, sp, 20
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 12(sp)
; ILP32-ILP32F-FPELIM-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va6_no_fixed_args:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -48
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 16
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a6, 24(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a7, 28(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a0, 0(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a1, s0, 4
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, -12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 48
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va6_no_fixed_args:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, -48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 32(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 36(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a6, 40(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a7, 44(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a0, 16(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 20(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a2, 24(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a3, 28(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a1, sp, 20
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 12(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi sp, sp, 48
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va6_no_fixed_args:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -28
; ILP32E-FPELIM-NEXT:    sw a4, 20(sp)
; ILP32E-FPELIM-NEXT:    sw a5, 24(sp)
; ILP32E-FPELIM-NEXT:    sw a0, 4(sp)
; ILP32E-FPELIM-NEXT:    sw a1, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a2, 12(sp)
; ILP32E-FPELIM-NEXT:    sw a3, 16(sp)
; ILP32E-FPELIM-NEXT:    addi a1, sp, 8
; ILP32E-FPELIM-NEXT:    sw a1, 0(sp)
; ILP32E-FPELIM-NEXT:    addi sp, sp, 28
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va6_no_fixed_args:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -36
; ILP32E-WITHFP-NEXT:    sw ra, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32E-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32E-WITHFP-NEXT:    sw a0, 0(s0)
; ILP32E-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32E-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32E-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32E-WITHFP-NEXT:    addi a1, s0, 4
; ILP32E-WITHFP-NEXT:    sw a1, -12(s0)
; ILP32E-WITHFP-NEXT:    lw ra, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 36
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va6_no_fixed_args:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, -80
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a4, 48(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a5, 56(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a6, 64(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a7, 72(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a0, 16(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 24(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a2, 32(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 40(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi a1, sp, 24
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    addi sp, sp, 80
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va6_no_fixed_args:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -96
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 32
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a4, 32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a5, 40(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a6, 48(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a7, 56(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a0, 0(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a2, 16(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, 24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a1, s0, 8
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, -24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 96
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va6_no_fixed_args:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    addi sp, sp, -56
; LP64E-FPELIM-NEXT:    sd a4, 40(sp)
; LP64E-FPELIM-NEXT:    sd a5, 48(sp)
; LP64E-FPELIM-NEXT:    sd a0, 8(sp)
; LP64E-FPELIM-NEXT:    sd a1, 16(sp)
; LP64E-FPELIM-NEXT:    sd a2, 24(sp)
; LP64E-FPELIM-NEXT:    sd a3, 32(sp)
; LP64E-FPELIM-NEXT:    addi a1, sp, 16
; LP64E-FPELIM-NEXT:    sd a1, 0(sp)
; LP64E-FPELIM-NEXT:    addi sp, sp, 56
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va6_no_fixed_args:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -72
; LP64E-WITHFP-NEXT:    sd ra, 16(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 8(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    addi s0, sp, 24
; LP64E-WITHFP-NEXT:    sd a4, 32(s0)
; LP64E-WITHFP-NEXT:    sd a5, 40(s0)
; LP64E-WITHFP-NEXT:    sd a0, 0(s0)
; LP64E-WITHFP-NEXT:    sd a1, 8(s0)
; LP64E-WITHFP-NEXT:    sd a2, 16(s0)
; LP64E-WITHFP-NEXT:    sd a3, 24(s0)
; LP64E-WITHFP-NEXT:    addi a1, s0, 8
; LP64E-WITHFP-NEXT:    sd a1, -24(s0)
; LP64E-WITHFP-NEXT:    ld ra, 16(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 8(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    addi sp, sp, 72
; LP64E-WITHFP-NEXT:    ret
  %va = alloca ptr
  call void @llvm.va_start(ptr %va)
  %1 = va_arg ptr %va, i32
  call void @llvm.va_end(ptr %va)
  ret i32 %1
}

; TODO: improve constant materialization of stack addresses

define i32 @va_large_stack(ptr %fmt, ...) {
; ILP32-ILP32F-FPELIM-LABEL: va_large_stack:
; ILP32-ILP32F-FPELIM:       # %bb.0:
; ILP32-ILP32F-FPELIM-NEXT:    lui a0, 24414
; ILP32-ILP32F-FPELIM-NEXT:    addi a0, a0, 304
; ILP32-ILP32F-FPELIM-NEXT:    sub sp, sp, a0
; ILP32-ILP32F-FPELIM-NEXT:    .cfi_def_cfa_offset 100000048
; ILP32-ILP32F-FPELIM-NEXT:    mv a0, a1
; ILP32-ILP32F-FPELIM-NEXT:    lui t0, 24414
; ILP32-ILP32F-FPELIM-NEXT:    add t0, sp, t0
; ILP32-ILP32F-FPELIM-NEXT:    sw a5, 292(t0)
; ILP32-ILP32F-FPELIM-NEXT:    lui a5, 24414
; ILP32-ILP32F-FPELIM-NEXT:    add a5, sp, a5
; ILP32-ILP32F-FPELIM-NEXT:    sw a6, 296(a5)
; ILP32-ILP32F-FPELIM-NEXT:    lui a5, 24414
; ILP32-ILP32F-FPELIM-NEXT:    add a5, sp, a5
; ILP32-ILP32F-FPELIM-NEXT:    sw a7, 300(a5)
; ILP32-ILP32F-FPELIM-NEXT:    lui a5, 24414
; ILP32-ILP32F-FPELIM-NEXT:    add a5, sp, a5
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 276(a5)
; ILP32-ILP32F-FPELIM-NEXT:    lui a1, 24414
; ILP32-ILP32F-FPELIM-NEXT:    add a1, sp, a1
; ILP32-ILP32F-FPELIM-NEXT:    sw a2, 280(a1)
; ILP32-ILP32F-FPELIM-NEXT:    lui a1, 24414
; ILP32-ILP32F-FPELIM-NEXT:    add a1, sp, a1
; ILP32-ILP32F-FPELIM-NEXT:    sw a3, 284(a1)
; ILP32-ILP32F-FPELIM-NEXT:    lui a1, 24414
; ILP32-ILP32F-FPELIM-NEXT:    add a1, sp, a1
; ILP32-ILP32F-FPELIM-NEXT:    sw a4, 288(a1)
; ILP32-ILP32F-FPELIM-NEXT:    lui a1, 24414
; ILP32-ILP32F-FPELIM-NEXT:    addi a1, a1, 280
; ILP32-ILP32F-FPELIM-NEXT:    add a1, sp, a1
; ILP32-ILP32F-FPELIM-NEXT:    sw a1, 12(sp)
; ILP32-ILP32F-FPELIM-NEXT:    lui a1, 24414
; ILP32-ILP32F-FPELIM-NEXT:    addi a1, a1, 304
; ILP32-ILP32F-FPELIM-NEXT:    add sp, sp, a1
; ILP32-ILP32F-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32-ILP32F-FPELIM-NEXT:    ret
;
; ILP32-ILP32F-WITHFP-LABEL: va_large_stack:
; ILP32-ILP32F-WITHFP:       # %bb.0:
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, -2032
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_def_cfa_offset 2032
; ILP32-ILP32F-WITHFP-NEXT:    sw ra, 1996(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    sw s0, 1992(sp) # 4-byte Folded Spill
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_offset ra, -36
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_offset s0, -40
; ILP32-ILP32F-WITHFP-NEXT:    addi s0, sp, 2000
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_def_cfa s0, 32
; ILP32-ILP32F-WITHFP-NEXT:    lui a0, 24414
; ILP32-ILP32F-WITHFP-NEXT:    addi a0, a0, -1728
; ILP32-ILP32F-WITHFP-NEXT:    sub sp, sp, a0
; ILP32-ILP32F-WITHFP-NEXT:    mv a0, a1
; ILP32-ILP32F-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a6, 24(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a7, 28(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32-ILP32F-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32-ILP32F-WITHFP-NEXT:    addi a1, s0, 8
; ILP32-ILP32F-WITHFP-NEXT:    lui a2, 24414
; ILP32-ILP32F-WITHFP-NEXT:    sub a2, s0, a2
; ILP32-ILP32F-WITHFP-NEXT:    sw a1, -272(a2)
; ILP32-ILP32F-WITHFP-NEXT:    lui a1, 24414
; ILP32-ILP32F-WITHFP-NEXT:    addi a1, a1, -1728
; ILP32-ILP32F-WITHFP-NEXT:    add sp, sp, a1
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_def_cfa sp, 2032
; ILP32-ILP32F-WITHFP-NEXT:    lw ra, 1996(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    lw s0, 1992(sp) # 4-byte Folded Reload
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_restore ra
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_restore s0
; ILP32-ILP32F-WITHFP-NEXT:    addi sp, sp, 2032
; ILP32-ILP32F-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32-ILP32F-WITHFP-NEXT:    ret
;
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-LABEL: va_large_stack:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM:       # %bb.0:
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a0, 24414
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a0, a0, 304
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sub sp, sp, a0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    .cfi_def_cfa_offset 100000048
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    mv a0, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui t0, 24414
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add t0, sp, t0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a5, 292(t0)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a5, 24414
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a5, sp, a5
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a6, 296(a5)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a5, 24414
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a5, sp, a5
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a7, 300(a5)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a5, 24414
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a5, sp, a5
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 276(a5)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a1, 24414
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a1, sp, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a2, 280(a1)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a1, 24414
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a1, sp, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a3, 284(a1)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a1, 24414
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a1, sp, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a4, 288(a1)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a1, 24414
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a1, a1, 280
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add a1, sp, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    sw a1, 12(sp)
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    lui a1, 24414
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    addi a1, a1, 304
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    add sp, sp, a1
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; RV32D-ILP32-ILP32F-ILP32D-FPELIM-NEXT:    ret
;
; ILP32E-FPELIM-LABEL: va_large_stack:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    lui a0, 24414
; ILP32E-FPELIM-NEXT:    addi a0, a0, 288
; ILP32E-FPELIM-NEXT:    sub sp, sp, a0
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 100000032
; ILP32E-FPELIM-NEXT:    mv a0, a1
; ILP32E-FPELIM-NEXT:    lui a6, 24414
; ILP32E-FPELIM-NEXT:    add a6, sp, a6
; ILP32E-FPELIM-NEXT:    sw a5, 284(a6)
; ILP32E-FPELIM-NEXT:    lui a5, 24414
; ILP32E-FPELIM-NEXT:    add a5, sp, a5
; ILP32E-FPELIM-NEXT:    sw a1, 268(a5)
; ILP32E-FPELIM-NEXT:    lui a1, 24414
; ILP32E-FPELIM-NEXT:    add a1, sp, a1
; ILP32E-FPELIM-NEXT:    sw a2, 272(a1)
; ILP32E-FPELIM-NEXT:    lui a1, 24414
; ILP32E-FPELIM-NEXT:    add a1, sp, a1
; ILP32E-FPELIM-NEXT:    sw a3, 276(a1)
; ILP32E-FPELIM-NEXT:    lui a1, 24414
; ILP32E-FPELIM-NEXT:    add a1, sp, a1
; ILP32E-FPELIM-NEXT:    sw a4, 280(a1)
; ILP32E-FPELIM-NEXT:    lui a1, 24414
; ILP32E-FPELIM-NEXT:    addi a1, a1, 272
; ILP32E-FPELIM-NEXT:    add a1, sp, a1
; ILP32E-FPELIM-NEXT:    sw a1, 4(sp)
; ILP32E-FPELIM-NEXT:    lui a1, 24414
; ILP32E-FPELIM-NEXT:    addi a1, a1, 288
; ILP32E-FPELIM-NEXT:    add sp, sp, a1
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: va_large_stack:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -2044
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 2044
; ILP32E-WITHFP-NEXT:    sw ra, 2016(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 2012(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -28
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -32
; ILP32E-WITHFP-NEXT:    addi s0, sp, 2020
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 24
; ILP32E-WITHFP-NEXT:    lui a0, 24414
; ILP32E-WITHFP-NEXT:    addi a0, a0, -1748
; ILP32E-WITHFP-NEXT:    sub sp, sp, a0
; ILP32E-WITHFP-NEXT:    mv a0, a1
; ILP32E-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32E-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32E-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32E-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32E-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32E-WITHFP-NEXT:    addi a1, s0, 8
; ILP32E-WITHFP-NEXT:    lui a2, 24414
; ILP32E-WITHFP-NEXT:    sub a2, s0, a2
; ILP32E-WITHFP-NEXT:    sw a1, -272(a2)
; ILP32E-WITHFP-NEXT:    lui a1, 24414
; ILP32E-WITHFP-NEXT:    addi a1, a1, -1748
; ILP32E-WITHFP-NEXT:    add sp, sp, a1
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 2044
; ILP32E-WITHFP-NEXT:    lw ra, 2016(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 2012(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 2044
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; LP64-LP64F-LP64D-FPELIM-LABEL: va_large_stack:
; LP64-LP64F-LP64D-FPELIM:       # %bb.0:
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a0, 24414
; LP64-LP64F-LP64D-FPELIM-NEXT:    addiw a0, a0, 336
; LP64-LP64F-LP64D-FPELIM-NEXT:    sub sp, sp, a0
; LP64-LP64F-LP64D-FPELIM-NEXT:    .cfi_def_cfa_offset 100000080
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a0, 24414
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a0, sp, a0
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a1, 280(a0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a0, 24414
; LP64-LP64F-LP64D-FPELIM-NEXT:    addiw a0, a0, 284
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a0, sp, a0
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a0, 8(sp)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a0, 24414
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a0, sp, a0
; LP64-LP64F-LP64D-FPELIM-NEXT:    lw a0, 280(a0)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a1, 24414
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a1, sp, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a5, 312(a1)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a1, 24414
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a1, sp, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a6, 320(a1)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a1, 24414
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a1, sp, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a7, 328(a1)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a1, 24414
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a1, sp, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a2, 288(a1)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a1, 24414
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a1, sp, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a3, 296(a1)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a1, 24414
; LP64-LP64F-LP64D-FPELIM-NEXT:    add a1, sp, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    sd a4, 304(a1)
; LP64-LP64F-LP64D-FPELIM-NEXT:    lui a1, 24414
; LP64-LP64F-LP64D-FPELIM-NEXT:    addiw a1, a1, 336
; LP64-LP64F-LP64D-FPELIM-NEXT:    add sp, sp, a1
; LP64-LP64F-LP64D-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; LP64-LP64F-LP64D-FPELIM-NEXT:    ret
;
; LP64-LP64F-LP64D-WITHFP-LABEL: va_large_stack:
; LP64-LP64F-LP64D-WITHFP:       # %bb.0:
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, -2032
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_def_cfa_offset 2032
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd ra, 1960(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd s0, 1952(sp) # 8-byte Folded Spill
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_offset ra, -72
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_offset s0, -80
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi s0, sp, 1968
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_def_cfa s0, 64
; LP64-LP64F-LP64D-WITHFP-NEXT:    lui a0, 24414
; LP64-LP64F-LP64D-WITHFP-NEXT:    addiw a0, a0, -1680
; LP64-LP64F-LP64D-WITHFP-NEXT:    sub sp, sp, a0
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a1, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi a0, s0, 12
; LP64-LP64F-LP64D-WITHFP-NEXT:    lui a1, 24414
; LP64-LP64F-LP64D-WITHFP-NEXT:    sub a1, s0, a1
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a0, -288(a1)
; LP64-LP64F-LP64D-WITHFP-NEXT:    lw a0, 8(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a5, 40(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a6, 48(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a7, 56(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a2, 16(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a3, 24(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    sd a4, 32(s0)
; LP64-LP64F-LP64D-WITHFP-NEXT:    lui a1, 24414
; LP64-LP64F-LP64D-WITHFP-NEXT:    addiw a1, a1, -1680
; LP64-LP64F-LP64D-WITHFP-NEXT:    add sp, sp, a1
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_def_cfa sp, 2032
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld ra, 1960(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    ld s0, 1952(sp) # 8-byte Folded Reload
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_restore ra
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_restore s0
; LP64-LP64F-LP64D-WITHFP-NEXT:    addi sp, sp, 2032
; LP64-LP64F-LP64D-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; LP64-LP64F-LP64D-WITHFP-NEXT:    ret
;
; LP64E-FPELIM-LABEL: va_large_stack:
; LP64E-FPELIM:       # %bb.0:
; LP64E-FPELIM-NEXT:    lui a0, 24414
; LP64E-FPELIM-NEXT:    addiw a0, a0, 320
; LP64E-FPELIM-NEXT:    sub sp, sp, a0
; LP64E-FPELIM-NEXT:    .cfi_def_cfa_offset 100000064
; LP64E-FPELIM-NEXT:    lui a0, 24414
; LP64E-FPELIM-NEXT:    addiw a0, a0, 284
; LP64E-FPELIM-NEXT:    add a0, sp, a0
; LP64E-FPELIM-NEXT:    sd a0, 8(sp)
; LP64E-FPELIM-NEXT:    lui a0, 24414
; LP64E-FPELIM-NEXT:    add a0, sp, a0
; LP64E-FPELIM-NEXT:    sd a1, 280(a0)
; LP64E-FPELIM-NEXT:    lui a0, 24414
; LP64E-FPELIM-NEXT:    add a0, sp, a0
; LP64E-FPELIM-NEXT:    lw a0, 280(a0)
; LP64E-FPELIM-NEXT:    lui a1, 24414
; LP64E-FPELIM-NEXT:    add a1, sp, a1
; LP64E-FPELIM-NEXT:    sd a5, 312(a1)
; LP64E-FPELIM-NEXT:    lui a1, 24414
; LP64E-FPELIM-NEXT:    add a1, sp, a1
; LP64E-FPELIM-NEXT:    sd a2, 288(a1)
; LP64E-FPELIM-NEXT:    lui a1, 24414
; LP64E-FPELIM-NEXT:    add a1, sp, a1
; LP64E-FPELIM-NEXT:    sd a3, 296(a1)
; LP64E-FPELIM-NEXT:    lui a1, 24414
; LP64E-FPELIM-NEXT:    add a1, sp, a1
; LP64E-FPELIM-NEXT:    sd a4, 304(a1)
; LP64E-FPELIM-NEXT:    lui a1, 24414
; LP64E-FPELIM-NEXT:    addiw a1, a1, 320
; LP64E-FPELIM-NEXT:    add sp, sp, a1
; LP64E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; LP64E-FPELIM-NEXT:    ret
;
; LP64E-WITHFP-LABEL: va_large_stack:
; LP64E-WITHFP:       # %bb.0:
; LP64E-WITHFP-NEXT:    addi sp, sp, -2040
; LP64E-WITHFP-NEXT:    .cfi_def_cfa_offset 2040
; LP64E-WITHFP-NEXT:    sd ra, 1984(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    sd s0, 1976(sp) # 8-byte Folded Spill
; LP64E-WITHFP-NEXT:    .cfi_offset ra, -56
; LP64E-WITHFP-NEXT:    .cfi_offset s0, -64
; LP64E-WITHFP-NEXT:    addi s0, sp, 1992
; LP64E-WITHFP-NEXT:    .cfi_def_cfa s0, 48
; LP64E-WITHFP-NEXT:    lui a0, 24414
; LP64E-WITHFP-NEXT:    addiw a0, a0, -1704
; LP64E-WITHFP-NEXT:    sub sp, sp, a0
; LP64E-WITHFP-NEXT:    addi a0, s0, 12
; LP64E-WITHFP-NEXT:    lui a6, 24414
; LP64E-WITHFP-NEXT:    sub a6, s0, a6
; LP64E-WITHFP-NEXT:    sd a0, -288(a6)
; LP64E-WITHFP-NEXT:    sd a1, 8(s0)
; LP64E-WITHFP-NEXT:    lw a0, 8(s0)
; LP64E-WITHFP-NEXT:    sd a5, 40(s0)
; LP64E-WITHFP-NEXT:    sd a2, 16(s0)
; LP64E-WITHFP-NEXT:    sd a3, 24(s0)
; LP64E-WITHFP-NEXT:    sd a4, 32(s0)
; LP64E-WITHFP-NEXT:    lui a1, 24414
; LP64E-WITHFP-NEXT:    addiw a1, a1, -1704
; LP64E-WITHFP-NEXT:    add sp, sp, a1
; LP64E-WITHFP-NEXT:    .cfi_def_cfa sp, 2040
; LP64E-WITHFP-NEXT:    ld ra, 1984(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    ld s0, 1976(sp) # 8-byte Folded Reload
; LP64E-WITHFP-NEXT:    .cfi_restore ra
; LP64E-WITHFP-NEXT:    .cfi_restore s0
; LP64E-WITHFP-NEXT:    addi sp, sp, 2040
; LP64E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; LP64E-WITHFP-NEXT:    ret
  %large = alloca [ 100000000 x i8 ]
  %va = alloca ptr
  call void @llvm.va_start(ptr %va)
  %argp.cur = load ptr, ptr %va, align 4
  %argp.next = getelementptr inbounds i8, ptr %argp.cur, i32 4
  store ptr %argp.next, ptr %va, align 4
  %1 = load i32, ptr %argp.cur, align 4
  call void @llvm.va_end(ptr %va)
  ret i32 %1
}
