; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zfbfmin,+zvfh,+zvfbfmin -verify-machineinstrs | FileCheck --check-prefixes=CHECK,RV32,ZFMIN %s
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zfbfmin,+zvfh,+zvfbfmin -verify-machineinstrs | FileCheck --check-prefixes=CHECK,RV64,ZFMIN %s
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zvfhmin,+zvfbfmin -verify-machineinstrs | FileCheck --check-prefixes=CHECK,RV32,NOZFMIN %s
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zvfhmin,+zvfbfmin -verify-machineinstrs | FileCheck --check-prefixes=CHECK,RV64,NOZFMIN %s

define i64 @i64(<vscale x 1 x i64> %v, i1 %c) {
; RV32-LABEL: i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    sub sp, sp, a1
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; RV32-NEXT:    addi a1, sp, 16
; RV32-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    andi a0, a0, 1
; RV32-NEXT:    #APP
; RV32-NEXT:    #NO_APP
; RV32-NEXT:    beqz a0, .LBB0_2
; RV32-NEXT:  # %bb.1: # %truebb
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vl1r.v v9, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v9, a0
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:    vmv.x.s a0, v9
; RV32-NEXT:    j .LBB0_3
; RV32-NEXT:  .LBB0_2: # %falsebb
; RV32-NEXT:    li a1, 0
; RV32-NEXT:  .LBB0_3: # %falsebb
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    add sp, sp, a2
; RV32-NEXT:    .cfi_def_cfa sp, 16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: i64:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -16
; RV64-NEXT:    .cfi_def_cfa_offset 16
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    sub sp, sp, a1
; RV64-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    andi a0, a0, 1
; RV64-NEXT:    #APP
; RV64-NEXT:    #NO_APP
; RV64-NEXT:    beqz a0, .LBB0_2
; RV64-NEXT:  # %bb.1: # %truebb
; RV64-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64-NEXT:  .LBB0_2: # %falsebb
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    add sp, sp, a1
; RV64-NEXT:    .cfi_def_cfa sp, 16
; RV64-NEXT:    addi sp, sp, 16
; RV64-NEXT:    .cfi_def_cfa_offset 0
; RV64-NEXT:    ret
  tail call void asm sideeffect "", "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9},~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19},~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"()
  br i1 %c, label %truebb, label %falsebb
truebb:
  %x = extractelement <vscale x 1 x i64> %v, i32 0
  ret i64 %x
falsebb:
  ret i64 0
}

define i32 @i32(<vscale x 2 x i32> %v, i1 %c) {
; CHECK-LABEL: i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; CHECK-NEXT:    addi a1, sp, 16
; CHECK-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    beqz a0, .LBB1_2
; CHECK-NEXT:  # %bb.1: # %truebb
; CHECK-NEXT:    lw a0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:  .LBB1_2: # %falsebb
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    add sp, sp, a1
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
  tail call void asm sideeffect "", "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9},~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19},~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"()
  br i1 %c, label %truebb, label %falsebb
truebb:
  %x = extractelement <vscale x 2 x i32> %v, i32 0
  ret i32 %x
falsebb:
  ret i32 0
}

define i16 @i16(<vscale x 4 x i16> %v, i1 %c) {
; CHECK-LABEL: i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; CHECK-NEXT:    addi a1, sp, 16
; CHECK-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    beqz a0, .LBB2_2
; CHECK-NEXT:  # %bb.1: # %truebb
; CHECK-NEXT:    lh a0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:  .LBB2_2: # %falsebb
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    add sp, sp, a1
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
  tail call void asm sideeffect "", "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9},~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19},~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"()
  br i1 %c, label %truebb, label %falsebb
truebb:
  %x = extractelement <vscale x 4 x i16> %v, i32 0
  ret i16 %x
falsebb:
  ret i16 0
}

define i8 @i8(<vscale x 8 x i8> %v, i1 %c) {
; CHECK-LABEL: i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; CHECK-NEXT:    addi a1, sp, 16
; CHECK-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    beqz a0, .LBB3_2
; CHECK-NEXT:  # %bb.1: # %truebb
; CHECK-NEXT:    lb a0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:  .LBB3_2: # %falsebb
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    add sp, sp, a1
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
  tail call void asm sideeffect "", "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9},~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19},~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"()
  br i1 %c, label %truebb, label %falsebb
truebb:
  %x = extractelement <vscale x 8 x i8> %v, i32 0
  ret i8 %x
falsebb:
  ret i8 0
}

define double @f64(<vscale x 1 x double> %v, i1 %c) {
; RV32-LABEL: f64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    sub sp, sp, a1
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; RV32-NEXT:    addi a1, sp, 16
; RV32-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    andi a0, a0, 1
; RV32-NEXT:    #APP
; RV32-NEXT:    #NO_APP
; RV32-NEXT:    beqz a0, .LBB4_2
; RV32-NEXT:  # %bb.1: # %truebb
; RV32-NEXT:    fld fa0, 16(sp) # 8-byte Folded Reload
; RV32-NEXT:    j .LBB4_3
; RV32-NEXT:  .LBB4_2: # %falsebb
; RV32-NEXT:    fcvt.d.w fa0, zero
; RV32-NEXT:  .LBB4_3: # %falsebb
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    .cfi_def_cfa sp, 16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: f64:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -16
; RV64-NEXT:    .cfi_def_cfa_offset 16
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    sub sp, sp, a1
; RV64-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    andi a0, a0, 1
; RV64-NEXT:    #APP
; RV64-NEXT:    #NO_APP
; RV64-NEXT:    beqz a0, .LBB4_2
; RV64-NEXT:  # %bb.1: # %truebb
; RV64-NEXT:    fld fa0, 16(sp) # 8-byte Folded Reload
; RV64-NEXT:    j .LBB4_3
; RV64-NEXT:  .LBB4_2: # %falsebb
; RV64-NEXT:    fmv.d.x fa0, zero
; RV64-NEXT:  .LBB4_3: # %falsebb
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    .cfi_def_cfa sp, 16
; RV64-NEXT:    addi sp, sp, 16
; RV64-NEXT:    .cfi_def_cfa_offset 0
; RV64-NEXT:    ret
  tail call void asm sideeffect "", "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9},~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19},~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"()
  br i1 %c, label %truebb, label %falsebb
truebb:
  %x = extractelement <vscale x 1 x double> %v, i32 0
  ret double %x
falsebb:
  ret double 0.0
}

define float @f32(<vscale x 2 x float> %v, i1 %c) {
; CHECK-LABEL: f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; CHECK-NEXT:    addi a1, sp, 16
; CHECK-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    beqz a0, .LBB5_2
; CHECK-NEXT:  # %bb.1: # %truebb
; CHECK-NEXT:    flw fa0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    j .LBB5_3
; CHECK-NEXT:  .LBB5_2: # %falsebb
; CHECK-NEXT:    fmv.w.x fa0, zero
; CHECK-NEXT:  .LBB5_3: # %falsebb
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
  tail call void asm sideeffect "", "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9},~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19},~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"()
  br i1 %c, label %truebb, label %falsebb
truebb:
  %x = extractelement <vscale x 2 x float> %v, i32 0
  ret float %x
falsebb:
  ret float 0.0
}

define half @f16(<vscale x 1 x half> %v, i1 %c) {
; ZFMIN-LABEL: f16:
; ZFMIN:       # %bb.0:
; ZFMIN-NEXT:    addi sp, sp, -16
; ZFMIN-NEXT:    .cfi_def_cfa_offset 16
; ZFMIN-NEXT:    csrr a1, vlenb
; ZFMIN-NEXT:    sub sp, sp, a1
; ZFMIN-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; ZFMIN-NEXT:    addi a1, sp, 16
; ZFMIN-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; ZFMIN-NEXT:    andi a0, a0, 1
; ZFMIN-NEXT:    #APP
; ZFMIN-NEXT:    #NO_APP
; ZFMIN-NEXT:    beqz a0, .LBB6_2
; ZFMIN-NEXT:  # %bb.1: # %truebb
; ZFMIN-NEXT:    flh fa0, 16(sp) # 8-byte Folded Reload
; ZFMIN-NEXT:    j .LBB6_3
; ZFMIN-NEXT:  .LBB6_2: # %falsebb
; ZFMIN-NEXT:    fmv.h.x fa0, zero
; ZFMIN-NEXT:  .LBB6_3: # %falsebb
; ZFMIN-NEXT:    csrr a0, vlenb
; ZFMIN-NEXT:    add sp, sp, a0
; ZFMIN-NEXT:    .cfi_def_cfa sp, 16
; ZFMIN-NEXT:    addi sp, sp, 16
; ZFMIN-NEXT:    .cfi_def_cfa_offset 0
; ZFMIN-NEXT:    ret
;
; NOZFMIN-LABEL: f16:
; NOZFMIN:       # %bb.0:
; NOZFMIN-NEXT:    addi sp, sp, -16
; NOZFMIN-NEXT:    .cfi_def_cfa_offset 16
; NOZFMIN-NEXT:    csrr a1, vlenb
; NOZFMIN-NEXT:    sub sp, sp, a1
; NOZFMIN-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; NOZFMIN-NEXT:    addi a1, sp, 16
; NOZFMIN-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; NOZFMIN-NEXT:    andi a0, a0, 1
; NOZFMIN-NEXT:    #APP
; NOZFMIN-NEXT:    #NO_APP
; NOZFMIN-NEXT:    beqz a0, .LBB6_2
; NOZFMIN-NEXT:  # %bb.1: # %truebb
; NOZFMIN-NEXT:    lh a0, 16(sp) # 8-byte Folded Reload
; NOZFMIN-NEXT:    lui a1, 1048560
; NOZFMIN-NEXT:    or a0, a0, a1
; NOZFMIN-NEXT:    j .LBB6_3
; NOZFMIN-NEXT:  .LBB6_2: # %falsebb
; NOZFMIN-NEXT:    lui a0, 1048560
; NOZFMIN-NEXT:  .LBB6_3: # %falsebb
; NOZFMIN-NEXT:    fmv.w.x fa0, a0
; NOZFMIN-NEXT:    csrr a0, vlenb
; NOZFMIN-NEXT:    add sp, sp, a0
; NOZFMIN-NEXT:    .cfi_def_cfa sp, 16
; NOZFMIN-NEXT:    addi sp, sp, 16
; NOZFMIN-NEXT:    .cfi_def_cfa_offset 0
; NOZFMIN-NEXT:    ret
  tail call void asm sideeffect "", "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9},~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19},~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"()
  br i1 %c, label %truebb, label %falsebb
truebb:
  %x = extractelement <vscale x 1 x half> %v, i32 0
  ret half %x
falsebb:
  ret half 0.0
}

define bfloat @bf16(<vscale x 2 x bfloat> %v, i1 %c) {
; ZFMIN-LABEL: bf16:
; ZFMIN:       # %bb.0:
; ZFMIN-NEXT:    addi sp, sp, -16
; ZFMIN-NEXT:    .cfi_def_cfa_offset 16
; ZFMIN-NEXT:    csrr a1, vlenb
; ZFMIN-NEXT:    sub sp, sp, a1
; ZFMIN-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; ZFMIN-NEXT:    addi a1, sp, 16
; ZFMIN-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; ZFMIN-NEXT:    andi a0, a0, 1
; ZFMIN-NEXT:    #APP
; ZFMIN-NEXT:    #NO_APP
; ZFMIN-NEXT:    beqz a0, .LBB7_2
; ZFMIN-NEXT:  # %bb.1: # %truebb
; ZFMIN-NEXT:    lh a0, 16(sp) # 8-byte Folded Reload
; ZFMIN-NEXT:    fmv.h.x fa0, a0
; ZFMIN-NEXT:    j .LBB7_3
; ZFMIN-NEXT:  .LBB7_2: # %falsebb
; ZFMIN-NEXT:    fmv.h.x fa0, zero
; ZFMIN-NEXT:  .LBB7_3: # %falsebb
; ZFMIN-NEXT:    csrr a0, vlenb
; ZFMIN-NEXT:    add sp, sp, a0
; ZFMIN-NEXT:    .cfi_def_cfa sp, 16
; ZFMIN-NEXT:    addi sp, sp, 16
; ZFMIN-NEXT:    .cfi_def_cfa_offset 0
; ZFMIN-NEXT:    ret
;
; NOZFMIN-LABEL: bf16:
; NOZFMIN:       # %bb.0:
; NOZFMIN-NEXT:    addi sp, sp, -16
; NOZFMIN-NEXT:    .cfi_def_cfa_offset 16
; NOZFMIN-NEXT:    csrr a1, vlenb
; NOZFMIN-NEXT:    sub sp, sp, a1
; NOZFMIN-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 1 * vlenb
; NOZFMIN-NEXT:    addi a1, sp, 16
; NOZFMIN-NEXT:    vs1r.v v8, (a1) # Unknown-size Folded Spill
; NOZFMIN-NEXT:    andi a0, a0, 1
; NOZFMIN-NEXT:    #APP
; NOZFMIN-NEXT:    #NO_APP
; NOZFMIN-NEXT:    beqz a0, .LBB7_2
; NOZFMIN-NEXT:  # %bb.1: # %truebb
; NOZFMIN-NEXT:    lh a0, 16(sp) # 8-byte Folded Reload
; NOZFMIN-NEXT:    lui a1, 1048560
; NOZFMIN-NEXT:    or a0, a0, a1
; NOZFMIN-NEXT:    j .LBB7_3
; NOZFMIN-NEXT:  .LBB7_2: # %falsebb
; NOZFMIN-NEXT:    lui a0, 1048560
; NOZFMIN-NEXT:  .LBB7_3: # %falsebb
; NOZFMIN-NEXT:    fmv.w.x fa0, a0
; NOZFMIN-NEXT:    csrr a0, vlenb
; NOZFMIN-NEXT:    add sp, sp, a0
; NOZFMIN-NEXT:    .cfi_def_cfa sp, 16
; NOZFMIN-NEXT:    addi sp, sp, 16
; NOZFMIN-NEXT:    .cfi_def_cfa_offset 0
; NOZFMIN-NEXT:    ret
  tail call void asm sideeffect "", "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9},~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19},~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"()
  br i1 %c, label %truebb, label %falsebb
truebb:
  %x = extractelement <vscale x 2 x bfloat> %v, i32 0
  ret bfloat %x
falsebb:
  ret bfloat 0.0
}

