; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

;
; UADDV
;

define i8 @uaddv_v8i8(<8 x i8> %a) {
; CHECK-LABEL: uaddv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    uaddv d0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uaddv_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #14]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    add w12, w13, w12
; NONEON-NOSVE-NEXT:    add w10, w11, w10
; NONEON-NOSVE-NEXT:    add w10, w12, w10
; NONEON-NOSVE-NEXT:    add w8, w8, w14
; NONEON-NOSVE-NEXT:    add w8, w10, w8
; NONEON-NOSVE-NEXT:    add w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.add.v8i8(<8 x i8> %a)
  ret i8 %res
}

define i8 @uaddv_v16i8(<16 x i8> %a) {
; CHECK-LABEL: uaddv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uaddv d0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uaddv_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #3]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #2]
; NONEON-NOSVE-NEXT:    add w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #8]
; NONEON-NOSVE-NEXT:    add w11, w14, w13
; NONEON-NOSVE-NEXT:    add w9, w12, w9
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #7]
; NONEON-NOSVE-NEXT:    add w10, w10, w11
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #13]
; NONEON-NOSVE-NEXT:    add w9, w9, w16
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #9]
; NONEON-NOSVE-NEXT:    add w12, w12, w15
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #14]
; NONEON-NOSVE-NEXT:    add w8, w13, w8
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #15]
; NONEON-NOSVE-NEXT:    add w12, w12, w14
; NONEON-NOSVE-NEXT:    add w8, w8, w11
; NONEON-NOSVE-NEXT:    add w9, w10, w9
; NONEON-NOSVE-NEXT:    add w10, w12, w16
; NONEON-NOSVE-NEXT:    add w8, w8, w15
; NONEON-NOSVE-NEXT:    add w9, w9, w10
; NONEON-NOSVE-NEXT:    add w8, w8, w13
; NONEON-NOSVE-NEXT:    add w0, w9, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.add.v16i8(<16 x i8> %a)
  ret i8 %res
}

define i8 @uaddv_v32i8(ptr %a) {
; CHECK-LABEL: uaddv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    add z0.b, z1.b, z0.b
; CHECK-NEXT:    uaddv d0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uaddv_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #2]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #3]
; NONEON-NOSVE-NEXT:    add w9, w11, w10
; NONEON-NOSVE-NEXT:    add w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #5]
; NONEON-NOSVE-NEXT:    add w11, w15, w14
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #4]
; NONEON-NOSVE-NEXT:    add w9, w10, w11
; NONEON-NOSVE-NEXT:    add w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #6]
; NONEON-NOSVE-NEXT:    add w14, w17, w16
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #8]
; NONEON-NOSVE-NEXT:    add w10, w14, w10
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #7]
; NONEON-NOSVE-NEXT:    add w11, w12, w11
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #24]
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    add w9, w10, w11
; NONEON-NOSVE-NEXT:    add w10, w14, w13
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #9]
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    add w11, w15, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #26]
; NONEON-NOSVE-NEXT:    add w9, w10, w11
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #10]
; NONEON-NOSVE-NEXT:    add w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #12]
; NONEON-NOSVE-NEXT:    add w9, w9, w10
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #14]
; NONEON-NOSVE-NEXT:    add w11, w12, w11
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #15]
; NONEON-NOSVE-NEXT:    add w10, w13, w10
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #13]
; NONEON-NOSVE-NEXT:    add w14, w15, w14
; NONEON-NOSVE-NEXT:    add w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #30]
; NONEON-NOSVE-NEXT:    add w9, w9, w14
; NONEON-NOSVE-NEXT:    add w12, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #31]
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    add w10, w10, w12
; NONEON-NOSVE-NEXT:    add w11, w16, w11
; NONEON-NOSVE-NEXT:    add w10, w10, w11
; NONEON-NOSVE-NEXT:    add w11, w17, w13
; NONEON-NOSVE-NEXT:    add w9, w10, w11
; NONEON-NOSVE-NEXT:    add w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call i8 @llvm.vector.reduce.add.v32i8(<32 x i8> %op)
  ret i8 %res
}

define i16 @uaddv_v4i16(<4 x i16> %a) {
; CHECK-LABEL: uaddv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    uaddv d0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uaddv_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #8]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    add w10, w11, w10
; NONEON-NOSVE-NEXT:    add w0, w10, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.add.v4i16(<4 x i16> %a)
  ret i16 %res
}

define i16 @uaddv_v8i16(<8 x i16> %a) {
; CHECK-LABEL: uaddv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uaddv d0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uaddv_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w14, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    add w12, w13, w12
; NONEON-NOSVE-NEXT:    add w10, w11, w10
; NONEON-NOSVE-NEXT:    add w10, w12, w10
; NONEON-NOSVE-NEXT:    add w8, w8, w14
; NONEON-NOSVE-NEXT:    add w8, w10, w8
; NONEON-NOSVE-NEXT:    add w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.add.v8i16(<8 x i16> %a)
  ret i16 %res
}

define i16 @uaddv_v16i16(ptr %a) {
; CHECK-LABEL: uaddv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    add z0.h, z1.h, z0.h
; CHECK-NEXT:    uaddv d0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uaddv_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #4]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w14, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w15, [sp, #6]
; NONEON-NOSVE-NEXT:    add w9, w11, w10
; NONEON-NOSVE-NEXT:    add w12, w13, w12
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #10]
; NONEON-NOSVE-NEXT:    add w13, w15, w14
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w16, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w17, [sp, #8]
; NONEON-NOSVE-NEXT:    add w9, w12, w13
; NONEON-NOSVE-NEXT:    add w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w15, [sp, #12]
; NONEON-NOSVE-NEXT:    add w14, w17, w16
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #14]
; NONEON-NOSVE-NEXT:    add w10, w14, w10
; NONEON-NOSVE-NEXT:    add w11, w15, w11
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    add w9, w10, w11
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    add w9, w13, w12
; NONEON-NOSVE-NEXT:    add w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %op)
  ret i16 %res
}

define i32 @uaddv_v2i32(<2 x i32> %a) {
; CHECK-LABEL: uaddv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    uaddv d0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uaddv_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    add w0, w9, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.add.v2i32(<2 x i32> %a)
  ret i32 %res
}

define i32 @uaddv_v4i32(<4 x i32> %a) {
; CHECK-LABEL: uaddv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uaddv d0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uaddv_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w11, w10, [sp], #16
; NONEON-NOSVE-NEXT:    add w10, w11, w10
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    add w0, w10, w8
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %a)
  ret i32 %res
}

define i32 @uaddv_v8i32(ptr %a) {
; CHECK-LABEL: uaddv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    add z0.s, z1.s, z0.s
; CHECK-NEXT:    uaddv d0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uaddv_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w11, w10, [sp]
; NONEON-NOSVE-NEXT:    ldp w12, w13, [sp, #24]
; NONEON-NOSVE-NEXT:    ldp w14, w15, [sp, #8]
; NONEON-NOSVE-NEXT:    add w8, w10, w8
; NONEON-NOSVE-NEXT:    add w9, w11, w9
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    add w10, w14, w12
; NONEON-NOSVE-NEXT:    add w11, w15, w13
; NONEON-NOSVE-NEXT:    add w9, w10, w11
; NONEON-NOSVE-NEXT:    add w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call i32 @llvm.vector.reduce.add.v8i32(<8 x i32> %op)
  ret i32 %res
}

define i64 @uaddv_v2i64(<2 x i64> %a) {
; CHECK-LABEL: uaddv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uaddv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uaddv_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp], #16
; NONEON-NOSVE-NEXT:    add x0, x9, x8
; NONEON-NOSVE-NEXT:    ret
  %res = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %a)
  ret i64 %res
}

define i64 @uaddv_v4i64(ptr %a) {
; CHECK-LABEL: uaddv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    add z0.d, z1.d, z0.d
; CHECK-NEXT:    uaddv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uaddv_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp x11, x10, [sp], #32
; NONEON-NOSVE-NEXT:    add x8, x10, x8
; NONEON-NOSVE-NEXT:    add x9, x11, x9
; NONEON-NOSVE-NEXT:    add x0, x9, x8
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %op)
  ret i64 %res
}

;
; SMAXV
;

define i8 @smaxv_v8i8(<8 x i8> %a) {
; CHECK-LABEL: smaxv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    smaxv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smaxv_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, gt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> %a)
  ret i8 %res
}

define i8 @smaxv_v16i8(<16 x i8> %a) {
; CHECK-LABEL: smaxv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    smaxv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smaxv_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp]
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, gt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> %a)
  ret i8 %res
}

define i8 @smaxv_v32i8(ptr %a) {
; CHECK-LABEL: smaxv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    smax z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    smaxv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smaxv_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, gt
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> %op)
  ret i8 %res
}

define i16 @smaxv_v4i16(<4 x i16> %a) {
; CHECK-LABEL: smaxv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    smaxv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smaxv_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, gt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> %a)
  ret i16 %res
}

define i16 @smaxv_v8i16(<8 x i16> %a) {
; CHECK-LABEL: smaxv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    smaxv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smaxv_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp]
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, gt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> %a)
  ret i16 %res
}

define i16 @smaxv_v16i16(ptr %a) {
; CHECK-LABEL: smaxv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    smax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    smaxv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smaxv_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, gt
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> %op)
  ret i16 %res
}

define i32 @smaxv_v2i32(<2 x i32> %a) {
; CHECK-LABEL: smaxv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    smaxv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smaxv_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w0, w9, w8, gt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> %a)
  ret i32 %res
}

define i32 @smaxv_v4i32(<4 x i32> %a) {
; CHECK-LABEL: smaxv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    smaxv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smaxv_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, gt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> %a)
  ret i32 %res
}

define i32 @smaxv_v8i32(ptr %a) {
; CHECK-LABEL: smaxv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    smax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    smaxv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smaxv_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w11, w8, [sp]
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, gt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, gt
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    ldp w10, w12, [sp, #8]
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldp w11, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w10, w11
; NONEON-NOSVE-NEXT:    csel w10, w10, w11, gt
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, gt
; NONEON-NOSVE-NEXT:    cmp w12, w9
; NONEON-NOSVE-NEXT:    csel w9, w12, w9, gt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, gt
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> %op)
  ret i32 %res
}

; No NEON 64-bit vector SMAXV support. Use SVE.
define i64 @smaxv_v2i64(<2 x i64> %a) {
; CHECK-LABEL: smaxv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    smaxv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smaxv_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp], #16
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x0, x9, x8, gt
; NONEON-NOSVE-NEXT:    ret
  %res = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> %a)
  ret i64 %res
}

define i64 @smaxv_v4i64(ptr %a) {
; CHECK-LABEL: smaxv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    smax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    smaxv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smaxv_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x8, x10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr x11, [sp], #32
; NONEON-NOSVE-NEXT:    cmp x8, x9
; NONEON-NOSVE-NEXT:    csel x8, x8, x9, gt
; NONEON-NOSVE-NEXT:    cmp x11, x10
; NONEON-NOSVE-NEXT:    csel x9, x11, x10, gt
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x0, x9, x8, gt
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> %op)
  ret i64 %res
}

;
; SMINV
;

define i8 @sminv_v8i8(<8 x i8> %a) {
; CHECK-LABEL: sminv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    sminv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sminv_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.smin.v8i8(<8 x i8> %a)
  ret i8 %res
}

define i8 @sminv_v16i8(<16 x i8> %a) {
; CHECK-LABEL: sminv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    sminv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sminv_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp]
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.smin.v16i8(<16 x i8> %a)
  ret i8 %res
}

define i8 @sminv_v32i8(ptr %a) {
; CHECK-LABEL: sminv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    smin z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    sminv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sminv_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsb w10, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrsb w11, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lt
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call i8 @llvm.vector.reduce.smin.v32i8(<32 x i8> %op)
  ret i8 %res
}

define i16 @sminv_v4i16(<4 x i16> %a) {
; CHECK-LABEL: sminv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    sminv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sminv_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.smin.v4i16(<4 x i16> %a)
  ret i16 %res
}

define i16 @sminv_v8i16(<8 x i16> %a) {
; CHECK-LABEL: sminv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    sminv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sminv_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp]
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.smin.v8i16(<8 x i16> %a)
  ret i16 %res
}

define i16 @sminv_v16i16(ptr %a) {
; CHECK-LABEL: sminv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    smin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    sminv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sminv_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    ldrsh w10, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsh w11, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lt
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call i16 @llvm.vector.reduce.smin.v16i16(<16 x i16> %op)
  ret i16 %res
}

define i32 @sminv_v2i32(<2 x i32> %a) {
; CHECK-LABEL: sminv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    sminv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sminv_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w0, w9, w8, lt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.smin.v2i32(<2 x i32> %a)
  ret i32 %res
}

define i32 @sminv_v4i32(<4 x i32> %a) {
; CHECK-LABEL: sminv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    sminv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sminv_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lt
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.smin.v4i32(<4 x i32> %a)
  ret i32 %res
}

define i32 @sminv_v8i32(ptr %a) {
; CHECK-LABEL: sminv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    smin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    sminv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sminv_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w11, w8, [sp]
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lt
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lt
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    ldp w10, w12, [sp, #8]
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldp w11, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w10, w11
; NONEON-NOSVE-NEXT:    csel w10, w10, w11, lt
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lt
; NONEON-NOSVE-NEXT:    cmp w12, w9
; NONEON-NOSVE-NEXT:    csel w9, w12, w9, lt
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lt
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call i32 @llvm.vector.reduce.smin.v8i32(<8 x i32> %op)
  ret i32 %res
}

; No NEON 64-bit vector SMINV support. Use SVE.
define i64 @sminv_v2i64(<2 x i64> %a) {
; CHECK-LABEL: sminv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    sminv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sminv_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp], #16
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x0, x9, x8, lt
; NONEON-NOSVE-NEXT:    ret
  %res = call i64 @llvm.vector.reduce.smin.v2i64(<2 x i64> %a)
  ret i64 %res
}

define i64 @sminv_v4i64(ptr %a) {
; CHECK-LABEL: sminv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    smin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    sminv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sminv_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x8, x10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr x11, [sp], #32
; NONEON-NOSVE-NEXT:    cmp x8, x9
; NONEON-NOSVE-NEXT:    csel x8, x8, x9, lt
; NONEON-NOSVE-NEXT:    cmp x11, x10
; NONEON-NOSVE-NEXT:    csel x9, x11, x10, lt
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x0, x9, x8, lt
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call i64 @llvm.vector.reduce.smin.v4i64(<4 x i64> %op)
  ret i64 %res
}

;
; UMAXV
;

define i8 @umaxv_v8i8(<8 x i8> %a) {
; CHECK-LABEL: umaxv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    umaxv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umaxv_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, hi
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.umax.v8i8(<8 x i8> %a)
  ret i8 %res
}

define i8 @umaxv_v16i8(<16 x i8> %a) {
; CHECK-LABEL: umaxv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    umaxv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umaxv_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, hi
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.umax.v16i8(<16 x i8> %a)
  ret i8 %res
}

define i8 @umaxv_v32i8(ptr %a) {
; CHECK-LABEL: umaxv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    umax z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    umaxv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umaxv_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, hi
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call i8 @llvm.vector.reduce.umax.v32i8(<32 x i8> %op)
  ret i8 %res
}

define i16 @umaxv_v4i16(<4 x i16> %a) {
; CHECK-LABEL: umaxv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    umaxv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umaxv_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, hi
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.umax.v4i16(<4 x i16> %a)
  ret i16 %res
}

define i16 @umaxv_v8i16(<8 x i16> %a) {
; CHECK-LABEL: umaxv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    umaxv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umaxv_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, hi
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.umax.v8i16(<8 x i16> %a)
  ret i16 %res
}

define i16 @umaxv_v16i16(ptr %a) {
; CHECK-LABEL: umaxv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    umax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    umaxv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umaxv_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, hi
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call i16 @llvm.vector.reduce.umax.v16i16(<16 x i16> %op)
  ret i16 %res
}

define i32 @umaxv_v2i32(<2 x i32> %a) {
; CHECK-LABEL: umaxv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    umaxv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umaxv_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w0, w9, w8, hi
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.umax.v2i32(<2 x i32> %a)
  ret i32 %res
}

define i32 @umaxv_v4i32(<4 x i32> %a) {
; CHECK-LABEL: umaxv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    umaxv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umaxv_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, hi
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.umax.v4i32(<4 x i32> %a)
  ret i32 %res
}

define i32 @umaxv_v8i32(ptr %a) {
; CHECK-LABEL: umaxv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    umax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    umaxv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umaxv_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w11, w8, [sp]
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, hi
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, hi
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    ldp w10, w12, [sp, #8]
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldp w11, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w10, w11
; NONEON-NOSVE-NEXT:    csel w10, w10, w11, hi
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, hi
; NONEON-NOSVE-NEXT:    cmp w12, w9
; NONEON-NOSVE-NEXT:    csel w9, w12, w9, hi
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, hi
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call i32 @llvm.vector.reduce.umax.v8i32(<8 x i32> %op)
  ret i32 %res
}

; No NEON 64-bit vector UMAXV support. Use SVE.
define i64 @umaxv_v2i64(<2 x i64> %a) {
; CHECK-LABEL: umaxv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    umaxv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umaxv_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp], #16
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x0, x9, x8, hi
; NONEON-NOSVE-NEXT:    ret
  %res = call i64 @llvm.vector.reduce.umax.v2i64(<2 x i64> %a)
  ret i64 %res
}

define i64 @umaxv_v4i64(ptr %a) {
; CHECK-LABEL: umaxv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    umax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    umaxv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umaxv_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x8, x10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr x11, [sp], #32
; NONEON-NOSVE-NEXT:    cmp x8, x9
; NONEON-NOSVE-NEXT:    csel x8, x8, x9, hi
; NONEON-NOSVE-NEXT:    cmp x11, x10
; NONEON-NOSVE-NEXT:    csel x9, x11, x10, hi
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x0, x9, x8, hi
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call i64 @llvm.vector.reduce.umax.v4i64(<4 x i64> %op)
  ret i64 %res
}

;
; UMINV
;

define i8 @uminv_v8i8(<8 x i8> %a) {
; CHECK-LABEL: uminv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    uminv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uminv_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lo
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.umin.v8i8(<8 x i8> %a)
  ret i8 %res
}

define i8 @uminv_v16i8(<16 x i8> %a) {
; CHECK-LABEL: uminv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uminv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uminv_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lo
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.umin.v16i8(<16 x i8> %a)
  ret i8 %res
}

define i8 @uminv_v32i8(ptr %a) {
; CHECK-LABEL: uminv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    umin z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    uminv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uminv_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lo
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call i8 @llvm.vector.reduce.umin.v32i8(<32 x i8> %op)
  ret i8 %res
}

define i16 @uminv_v4i16(<4 x i16> %a) {
; CHECK-LABEL: uminv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    uminv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uminv_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lo
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.umin.v4i16(<4 x i16> %a)
  ret i16 %res
}

define i16 @uminv_v8i16(<8 x i16> %a) {
; CHECK-LABEL: uminv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uminv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uminv_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lo
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.umin.v8i16(<8 x i16> %a)
  ret i16 %res
}

define i16 @uminv_v16i16(ptr %a) {
; CHECK-LABEL: uminv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    umin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    uminv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uminv_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lo
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call i16 @llvm.vector.reduce.umin.v16i16(<16 x i16> %op)
  ret i16 %res
}

define i32 @uminv_v2i32(<2 x i32> %a) {
; CHECK-LABEL: uminv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    uminv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uminv_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w0, w9, w8, lo
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.umin.v2i32(<2 x i32> %a)
  ret i32 %res
}

define i32 @uminv_v4i32(<4 x i32> %a) {
; CHECK-LABEL: uminv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uminv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uminv_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lo
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.umin.v4i32(<4 x i32> %a)
  ret i32 %res
}

define i32 @uminv_v8i32(ptr %a) {
; CHECK-LABEL: uminv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    umin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    uminv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uminv_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w11, w8, [sp]
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w8, w8, w9, lo
; NONEON-NOSVE-NEXT:    cmp w11, w10
; NONEON-NOSVE-NEXT:    csel w9, w11, w10, lo
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    ldp w10, w12, [sp, #8]
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldp w11, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w10, w11
; NONEON-NOSVE-NEXT:    csel w10, w10, w11, lo
; NONEON-NOSVE-NEXT:    cmp w8, w10
; NONEON-NOSVE-NEXT:    csel w8, w8, w10, lo
; NONEON-NOSVE-NEXT:    cmp w12, w9
; NONEON-NOSVE-NEXT:    csel w9, w12, w9, lo
; NONEON-NOSVE-NEXT:    cmp w8, w9
; NONEON-NOSVE-NEXT:    csel w0, w8, w9, lo
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call i32 @llvm.vector.reduce.umin.v8i32(<8 x i32> %op)
  ret i32 %res
}

; No NEON 64-bit vector UMINV support. Use SVE.
define i64 @uminv_v2i64(<2 x i64> %a) {
; CHECK-LABEL: uminv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uminv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uminv_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp], #16
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x0, x9, x8, lo
; NONEON-NOSVE-NEXT:    ret
  %res = call i64 @llvm.vector.reduce.umin.v2i64(<2 x i64> %a)
  ret i64 %res
}

define i64 @uminv_v4i64(ptr %a) {
; CHECK-LABEL: uminv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    umin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    uminv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uminv_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x8, x10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr x11, [sp], #32
; NONEON-NOSVE-NEXT:    cmp x8, x9
; NONEON-NOSVE-NEXT:    csel x8, x8, x9, lo
; NONEON-NOSVE-NEXT:    cmp x11, x10
; NONEON-NOSVE-NEXT:    csel x9, x11, x10, lo
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x0, x9, x8, lo
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call i64 @llvm.vector.reduce.umin.v4i64(<4 x i64> %op)
  ret i64 %res
}

declare i8 @llvm.vector.reduce.add.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.add.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.add.v32i8(<32 x i8>)

declare i16 @llvm.vector.reduce.add.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.add.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.add.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.add.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.add.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.add.v8i32(<8 x i32>)

declare i64 @llvm.vector.reduce.add.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.add.v4i64(<4 x i64>)

declare i8 @llvm.vector.reduce.smax.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.smax.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.smax.v32i8(<32 x i8>)

declare i16 @llvm.vector.reduce.smax.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.smax.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.smax.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.smax.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.smax.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.smax.v8i32(<8 x i32>)

declare i64 @llvm.vector.reduce.smax.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.smax.v4i64(<4 x i64>)

declare i8 @llvm.vector.reduce.smin.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.smin.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.smin.v32i8(<32 x i8>)

declare i16 @llvm.vector.reduce.smin.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.smin.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.smin.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.smin.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.smin.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.smin.v8i32(<8 x i32>)

declare i64 @llvm.vector.reduce.smin.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.smin.v4i64(<4 x i64>)

declare i8 @llvm.vector.reduce.umax.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.umax.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.umax.v32i8(<32 x i8>)

declare i16 @llvm.vector.reduce.umax.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.umax.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.umax.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.umax.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.umax.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.umax.v8i32(<8 x i32>)

declare i64 @llvm.vector.reduce.umax.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.umax.v4i64(<4 x i64>)

declare i8 @llvm.vector.reduce.umin.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.umin.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.umin.v32i8(<32 x i8>)

declare i16 @llvm.vector.reduce.umin.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.umin.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.umin.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.umin.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.umin.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.umin.v8i32(<8 x i32>)

declare i64 @llvm.vector.reduce.umin.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.umin.v4i64(<4 x i64>)
