# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=thumbv8.1-m.main-none-none-eabi -mcpu=cortex-m55 -timeline < %s | FileCheck %s

# Most MVE operations are either latency=1 or can forward into stores
vadd.i8  q0, q2, q1
vstrb.8 q0, [r0, #0]
vadd.f32  q0, q2, q1
vstrb.8 q0, [r0, #0]
vmul.i8  q0, q2, q1
vstrb.8 q0, [r0, #0]
vmlas.u32  q0, q2, r0
vstrb.8 q0, [r0, #0]
vfma.f16  q0, q2, q1
vstrb.8 q0, [r0, #0]
vmullb.s16  q0, q2, q1
vstrb.8 q0, [r0, #0]
vcvtt.f32.f16  q0, q2
vstrb.8 q0, [r0, #0]
vcvtb.f32.f16  q0, q2
vstrb.8 q0, [r0, #0]

# The ones that cannot are VCVT.f16.f32 t/b and any VMOVN/VQMOVN/VSHRN/VQSHRN/VRSHRN
vmovnt.s16  q0, q2
vstrb.8 q0, [r0, #0]
vmovnb.u32  q0, q2
vstrb.8 q0, [r0, #0]
vqmovnt.s32  q0, q2
vstrb.8 q0, [r0, #0]
vqmovnb.u16  q0, q2
vstrb.8 q0, [r0, #0]
vshrnt.s32  q0, q2, #1
vstrb.8 q0, [r0, #0]
vshrnb.u16  q0, q2, #1
vstrb.8 q0, [r0, #0]
vqshrnt.s16  q0, q2, #1
vstrb.8 q0, [r0, #0]
vqshrnb.u32  q0, q2, #1
vstrb.8 q0, [r0, #0]
vrshrnt.s16  q0, q2, #1
vstrb.8 q0, [r0, #0]
vrshrnb.u16  q0, q2, #1
vstrb.8 q0, [r0, #0]
vcvtt.f16.f32  q0, q2
vstrb.8 q0, [r0, #0]
vcvtb.f16.f32  q0, q2
vstrb.8 q0, [r0, #0]

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      4000
# CHECK-NEXT: Total Cycles:      6401
# CHECK-NEXT: Total uOps:        4000

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.62
# CHECK-NEXT: IPC:               0.62
# CHECK-NEXT: Block RThroughput: 40.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     2.00                        vadd.i8	q0, q2, q1
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      1     2.00                        vadd.f32	q0, q2, q1
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      2     2.00                        vmul.i8	q0, q2, q1
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      2     2.00                        vmlas.i32	q0, q2, r0
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      2     2.00                        vfma.f16	q0, q2, q1
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      2     2.00                        vmullb.s16	q0, q2, q1
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      2     2.00                        vcvtt.f32.f16	q0, q2
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      2     2.00                        vcvtb.f32.f16	q0, q2
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vmovnt.i16	q0, q2
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vmovnb.i32	q0, q2
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vqmovnt.s32	q0, q2
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vqmovnb.u16	q0, q2
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vshrnt.i32	q0, q2, #1
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vshrnb.i16	q0, q2, #1
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vqshrnt.s16	q0, q2, #1
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vqshrnb.u32	q0, q2, #1
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vrshrnt.i16	q0, q2, #1
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vrshrnb.i16	q0, q2, #1
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vcvtt.f16.f32	q0, q2
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]
# CHECK-NEXT:  1      3     2.00                        vcvtb.f16.f32	q0, q2
# CHECK-NEXT:  1      1     2.00           *            vstrb.8	q0, [r0]

# CHECK:      Resources:
# CHECK-NEXT: [0]   - M55UnitALU
# CHECK-NEXT: [1]   - M55UnitLoadStore
# CHECK-NEXT: [2]   - M55UnitVecALU
# CHECK-NEXT: [3]   - M55UnitVecFPALU
# CHECK-NEXT: [4]   - M55UnitVecSys

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]
# CHECK-NEXT:  -     40.00  22.00  18.00   -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    Instructions:
# CHECK-NEXT:  -      -     2.00    -      -     vadd.i8	q0, q2, q1
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -      -     2.00    -     vadd.f32	q0, q2, q1
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -      -     2.00    -     vmul.i8	q0, q2, q1
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -      -     2.00    -     vmlas.i32	q0, q2, r0
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -      -     2.00    -     vfma.f16	q0, q2, q1
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -      -     2.00    -     vmullb.s16	q0, q2, q1
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -      -     2.00    -     vcvtt.f32.f16	q0, q2
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -      -     2.00    -     vcvtb.f32.f16	q0, q2
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -     2.00    -      -     vmovnt.i16	q0, q2
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -     2.00    -      -     vmovnb.i32	q0, q2
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -     2.00    -      -     vqmovnt.s32	q0, q2
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -     2.00    -      -     vqmovnb.u16	q0, q2
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -     2.00    -      -     vshrnt.i32	q0, q2, #1
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -     2.00    -      -     vshrnb.i16	q0, q2, #1
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -     2.00    -      -     vqshrnt.s16	q0, q2, #1
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -     2.00    -      -     vqshrnb.u32	q0, q2, #1
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -     2.00    -      -     vrshrnt.i16	q0, q2, #1
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -     2.00    -      -     vrshrnb.i16	q0, q2, #1
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -      -     2.00    -     vcvtt.f16.f32	q0, q2
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]
# CHECK-NEXT:  -      -      -     2.00    -     vcvtb.f16.f32	q0, q2
# CHECK-NEXT:  -     2.00    -      -      -     vstrb.8	q0, [r0]

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789          0123456789          0123456789
# CHECK-NEXT: Index     0123456789          0123456789          0123456789          0123456789

# CHECK:      [0,0]     DE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   vadd.i8	q0, q2, q1
# CHECK-NEXT: [0,1]     .DE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,2]     . DE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   vadd.f32	q0, q2, q1
# CHECK-NEXT: [0,3]     .  DE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,4]     .   DeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   vmul.i8	q0, q2, q1
# CHECK-NEXT: [0,5]     .    DE   .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,6]     .    .DeE .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   vmlas.i32	q0, q2, r0
# CHECK-NEXT: [0,7]     .    . DE .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,8]     .    .  DeE    .    .    .    .    .    .    .    .    .    .    .    .    .   .   vfma.f16	q0, q2, q1
# CHECK-NEXT: [0,9]     .    .   DE    .    .    .    .    .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,10]    .    .    DeE  .    .    .    .    .    .    .    .    .    .    .    .    .   .   vmullb.s16	q0, q2, q1
# CHECK-NEXT: [0,11]    .    .    .DE  .    .    .    .    .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,12]    .    .    . DeE.    .    .    .    .    .    .    .    .    .    .    .    .   .   vcvtt.f32.f16	q0, q2
# CHECK-NEXT: [0,13]    .    .    .  DE.    .    .    .    .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,14]    .    .    .   DeE   .    .    .    .    .    .    .    .    .    .    .    .   .   vcvtb.f32.f16	q0, q2
# CHECK-NEXT: [0,15]    .    .    .    DE   .    .    .    .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,16]    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .   .   vmovnt.i16	q0, q2
# CHECK-NEXT: [0,17]    .    .    .    .   DE    .    .    .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,18]    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .   .   vmovnb.i32	q0, q2
# CHECK-NEXT: [0,19]    .    .    .    .    .  DE.    .    .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,20]    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .   .   vqmovnt.s32	q0, q2
# CHECK-NEXT: [0,21]    .    .    .    .    .    . DE .    .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,22]    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .   .   vqmovnb.u16	q0, q2
# CHECK-NEXT: [0,23]    .    .    .    .    .    .    .DE  .    .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,24]    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .   .   vshrnt.i32	q0, q2, #1
# CHECK-NEXT: [0,25]    .    .    .    .    .    .    .    DE   .    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,26]    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .   .   vshrnb.i16	q0, q2, #1
# CHECK-NEXT: [0,27]    .    .    .    .    .    .    .    .   DE    .    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,28]    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .   .   vqshrnt.s16	q0, q2, #1
# CHECK-NEXT: [0,29]    .    .    .    .    .    .    .    .    .  DE.    .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,30]    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .   .   vqshrnb.u32	q0, q2, #1
# CHECK-NEXT: [0,31]    .    .    .    .    .    .    .    .    .    . DE .    .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,32]    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .   .   vrshrnt.i16	q0, q2, #1
# CHECK-NEXT: [0,33]    .    .    .    .    .    .    .    .    .    .    .DE  .    .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,34]    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .   .   vrshrnb.i16	q0, q2, #1
# CHECK-NEXT: [0,35]    .    .    .    .    .    .    .    .    .    .    .    DE   .    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,36]    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .   .   vcvtt.f16.f32	q0, q2
# CHECK-NEXT: [0,37]    .    .    .    .    .    .    .    .    .    .    .    .   DE    .    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [0,38]    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .   .   vcvtb.f16.f32	q0, q2
# CHECK-NEXT: [0,39]    .    .    .    .    .    .    .    .    .    .    .    .    .  DE.    .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [1,0]     .    .    .    .    .    .    .    .    .    .    .    .    .   DE    .    .   .   vadd.i8	q0, q2, q1
# CHECK-NEXT: [1,1]     .    .    .    .    .    .    .    .    .    .    .    .    .    DE   .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [1,2]     .    .    .    .    .    .    .    .    .    .    .    .    .    .DE  .    .   .   vadd.f32	q0, q2, q1
# CHECK-NEXT: [1,3]     .    .    .    .    .    .    .    .    .    .    .    .    .    . DE .    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [1,4]     .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeE    .   .   vmul.i8	q0, q2, q1
# CHECK-NEXT: [1,5]     .    .    .    .    .    .    .    .    .    .    .    .    .    .   DE    .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [1,6]     .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeE  .   .   vmlas.i32	q0, q2, r0
# CHECK-NEXT: [1,7]     .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DE  .   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [1,8]     .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeE.   .   vfma.f16	q0, q2, q1
# CHECK-NEXT: [1,9]     .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DE.   .   vstrb.8	q0, [r0]
# CHECK-NEXT: [1,10]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeE  .   vmullb.s16	q0, q2, q1
# CHECK-NEXT: [1,11]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DE  .   vstrb.8	q0, [r0]
# CHECK-NEXT: [1,12]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeE.   vcvtt.f32.f16	q0, q2
# CHECK-NEXT: [1,13]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DE.   vstrb.8	q0, [r0]
# CHECK-NEXT: Truncated display due to cycle limit

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     10    0.0    0.0    0.0       vadd.i8	q0, q2, q1
# CHECK-NEXT: 1.     10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 2.     10    0.0    0.0    0.0       vadd.f32	q0, q2, q1
# CHECK-NEXT: 3.     10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 4.     10    0.0    0.0    0.0       vmul.i8	q0, q2, q1
# CHECK-NEXT: 5.     10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 6.     10    0.0    0.0    0.0       vmlas.i32	q0, q2, r0
# CHECK-NEXT: 7.     10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 8.     10    0.0    0.0    0.0       vfma.f16	q0, q2, q1
# CHECK-NEXT: 9.     10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 10.    10    0.0    0.0    0.0       vmullb.s16	q0, q2, q1
# CHECK-NEXT: 11.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 12.    10    0.0    0.0    0.0       vcvtt.f32.f16	q0, q2
# CHECK-NEXT: 13.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 14.    10    0.0    0.0    0.0       vcvtb.f32.f16	q0, q2
# CHECK-NEXT: 15.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 16.    10    0.0    0.0    0.0       vmovnt.i16	q0, q2
# CHECK-NEXT: 17.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 18.    10    0.0    0.0    0.0       vmovnb.i32	q0, q2
# CHECK-NEXT: 19.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 20.    10    0.0    0.0    0.0       vqmovnt.s32	q0, q2
# CHECK-NEXT: 21.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 22.    10    0.0    0.0    0.0       vqmovnb.u16	q0, q2
# CHECK-NEXT: 23.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 24.    10    0.0    0.0    0.0       vshrnt.i32	q0, q2, #1
# CHECK-NEXT: 25.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 26.    10    0.0    0.0    0.0       vshrnb.i16	q0, q2, #1
# CHECK-NEXT: 27.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 28.    10    0.0    0.0    0.0       vqshrnt.s16	q0, q2, #1
# CHECK-NEXT: 29.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 30.    10    0.0    0.0    0.0       vqshrnb.u32	q0, q2, #1
# CHECK-NEXT: 31.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 32.    10    0.0    0.0    0.0       vrshrnt.i16	q0, q2, #1
# CHECK-NEXT: 33.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 34.    10    0.0    0.0    0.0       vrshrnb.i16	q0, q2, #1
# CHECK-NEXT: 35.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 36.    10    0.0    0.0    0.0       vcvtt.f16.f32	q0, q2
# CHECK-NEXT: 37.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT: 38.    10    0.0    0.0    0.0       vcvtb.f16.f32	q0, q2
# CHECK-NEXT: 39.    10    0.0    0.0    0.0       vstrb.8	q0, [r0]
# CHECK-NEXT:        10    0.0    0.0    0.0       <total>
