; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mattr=+sve    < %s | FileCheck %s -check-prefix CHECK-SVE
; RUN: llc -mattr=+sve2p1 < %s | FileCheck %s -check-prefix CHECK-SVE2p1
target triple = "aarch64-linux"

; Test combining of getActiveLaneMask with a pair of extract_vector operations.

define void @test_2x8bit_mask_with_32bit_index_and_trip_count(i32 %i, i32 %n) #0 {
; CHECK-SVE-LABEL: test_2x8bit_mask_with_32bit_index_and_trip_count:
; CHECK-SVE:       // %bb.0:
; CHECK-SVE-NEXT:    whilelo p1.b, w0, w1
; CHECK-SVE-NEXT:    punpklo p0.h, p1.b
; CHECK-SVE-NEXT:    punpkhi p1.h, p1.b
; CHECK-SVE-NEXT:    b use
;
; CHECK-SVE2p1-LABEL: test_2x8bit_mask_with_32bit_index_and_trip_count:
; CHECK-SVE2p1:       // %bb.0:
; CHECK-SVE2p1-NEXT:    mov w8, w1
; CHECK-SVE2p1-NEXT:    mov w9, w0
; CHECK-SVE2p1-NEXT:    whilelo { p0.h, p1.h }, x9, x8
; CHECK-SVE2p1-NEXT:    b use
    %r = call <vscale x 16 x i1> @llvm.get.active.lane.mask.nxv16i1.i32(i32 %i, i32 %n)
    %v0 = call <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv16i1.i64(<vscale x 16 x i1> %r, i64 0)
    %v1 = call <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv16i1.i64(<vscale x 16 x i1> %r, i64 8)
    tail call void @use(<vscale x 8 x i1> %v0, <vscale x 8 x i1> %v1)
    ret void
}

define void @test_2x8bit_mask_with_64bit_index_and_trip_count(i64 %i, i64 %n) #0 {
; CHECK-SVE-LABEL: test_2x8bit_mask_with_64bit_index_and_trip_count:
; CHECK-SVE:       // %bb.0:
; CHECK-SVE-NEXT:    whilelo p1.b, x0, x1
; CHECK-SVE-NEXT:    punpklo p0.h, p1.b
; CHECK-SVE-NEXT:    punpkhi p1.h, p1.b
; CHECK-SVE-NEXT:    b use
;
; CHECK-SVE2p1-LABEL: test_2x8bit_mask_with_64bit_index_and_trip_count:
; CHECK-SVE2p1:       // %bb.0:
; CHECK-SVE2p1-NEXT:    whilelo { p0.h, p1.h }, x0, x1
; CHECK-SVE2p1-NEXT:    b use
    %r = call <vscale x 16 x i1> @llvm.get.active.lane.mask.nxv16i1.i64(i64 %i, i64 %n)
    %v0 = call <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv16i1.i64(<vscale x 16 x i1> %r, i64 0)
    %v1 = call <vscale x 8 x i1> @llvm.vector.extract.nxv8i1.nxv16i1.i64(<vscale x 16 x i1> %r, i64 8)
    tail call void @use(<vscale x 8 x i1> %v0, <vscale x 8 x i1> %v1)
    ret void
}

define void @test_edge_case_2x1bit_mask(i64 %i, i64 %n) #0 {
; CHECK-SVE-LABEL: test_edge_case_2x1bit_mask:
; CHECK-SVE:       // %bb.0:
; CHECK-SVE-NEXT:    whilelo p1.d, x0, x1
; CHECK-SVE-NEXT:    punpklo p0.h, p1.b
; CHECK-SVE-NEXT:    punpkhi p1.h, p1.b
; CHECK-SVE-NEXT:    b use
;
; CHECK-SVE2p1-LABEL: test_edge_case_2x1bit_mask:
; CHECK-SVE2p1:       // %bb.0:
; CHECK-SVE2p1-NEXT:    whilelo p1.d, x0, x1
; CHECK-SVE2p1-NEXT:    punpklo p0.h, p1.b
; CHECK-SVE2p1-NEXT:    punpkhi p1.h, p1.b
; CHECK-SVE2p1-NEXT:    b use
    %r = call <vscale x 2 x i1> @llvm.get.active.lane.mask.nxv2i1.i64(i64 %i, i64 %n)
    %v0 = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv2i1.i64(<vscale x 2 x i1> %r, i64 0)
    %v1 = call <vscale x 1 x i1> @llvm.vector.extract.nxv1i1.nxv2i1.i64(<vscale x 2 x i1> %r, i64 1)
    tail call void @use(<vscale x 1 x i1> %v0, <vscale x 1 x i1> %v1)
    ret void
}

define void @test_boring_case_2x2bit_mask(i64 %i, i64 %n) #0 {
; CHECK-SVE-LABEL: test_boring_case_2x2bit_mask:
; CHECK-SVE:       // %bb.0:
; CHECK-SVE-NEXT:    whilelo p1.s, x0, x1
; CHECK-SVE-NEXT:    punpklo p0.h, p1.b
; CHECK-SVE-NEXT:    punpkhi p1.h, p1.b
; CHECK-SVE-NEXT:    b use
;
; CHECK-SVE2p1-LABEL: test_boring_case_2x2bit_mask:
; CHECK-SVE2p1:       // %bb.0:
; CHECK-SVE2p1-NEXT:    whilelo { p0.d, p1.d }, x0, x1
; CHECK-SVE2p1-NEXT:    b use
    %r = call <vscale x 4 x i1> @llvm.get.active.lane.mask.nxv4i1.i64(i64 %i, i64 %n)
    %v0 = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv4i1.i64(<vscale x 4 x i1> %r, i64 0)
    %v1 = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv4i1.i64(<vscale x 4 x i1> %r, i64 2)
    tail call void @use(<vscale x 2 x i1> %v0, <vscale x 2 x i1> %v1)
    ret void
}

; Negative test for when not extracting exactly two halves of the source vector
define void @test_partial_extract(i64 %i, i64 %n) #0 {
; CHECK-SVE-LABEL: test_partial_extract:
; CHECK-SVE:       // %bb.0:
; CHECK-SVE-NEXT:    whilelo p0.h, x0, x1
; CHECK-SVE-NEXT:    punpklo p1.h, p0.b
; CHECK-SVE-NEXT:    punpkhi p2.h, p0.b
; CHECK-SVE-NEXT:    punpklo p0.h, p1.b
; CHECK-SVE-NEXT:    punpklo p1.h, p2.b
; CHECK-SVE-NEXT:    b use
;
; CHECK-SVE2p1-LABEL: test_partial_extract:
; CHECK-SVE2p1:       // %bb.0:
; CHECK-SVE2p1-NEXT:    whilelo p0.h, x0, x1
; CHECK-SVE2p1-NEXT:    punpklo p1.h, p0.b
; CHECK-SVE2p1-NEXT:    punpkhi p2.h, p0.b
; CHECK-SVE2p1-NEXT:    punpklo p0.h, p1.b
; CHECK-SVE2p1-NEXT:    punpklo p1.h, p2.b
; CHECK-SVE2p1-NEXT:    b use
    %r = call <vscale x 8 x i1> @llvm.get.active.lane.mask.nxv8i1.i64(i64 %i, i64 %n)
    %v0 = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv8i1.i64(<vscale x 8 x i1> %r, i64 0)
    %v1 = call <vscale x 2 x i1> @llvm.vector.extract.nxv2i1.nxv8i1.i64(<vscale x 8 x i1> %r, i64 4)
    tail call void @use(<vscale x 2 x i1> %v0, <vscale x 2 x i1> %v1)
    ret void
}

;; Negative test for when extracting a fixed-length vector.
define void @test_fixed_extract(i64 %i, i64 %n) #0 {
; CHECK-SVE-LABEL: test_fixed_extract:
; CHECK-SVE:       // %bb.0:
; CHECK-SVE-NEXT:    whilelo p0.h, x0, x1
; CHECK-SVE-NEXT:    cset w8, mi
; CHECK-SVE-NEXT:    mov z0.h, p0/z, #1 // =0x1
; CHECK-SVE-NEXT:    umov w9, v0.h[4]
; CHECK-SVE-NEXT:    umov w10, v0.h[1]
; CHECK-SVE-NEXT:    umov w11, v0.h[5]
; CHECK-SVE-NEXT:    fmov s0, w8
; CHECK-SVE-NEXT:    fmov s1, w9
; CHECK-SVE-NEXT:    mov v0.s[1], w10
; CHECK-SVE-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SVE-NEXT:    mov v1.s[1], w11
; CHECK-SVE-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SVE-NEXT:    b use
;
; CHECK-SVE2p1-LABEL: test_fixed_extract:
; CHECK-SVE2p1:       // %bb.0:
; CHECK-SVE2p1-NEXT:    whilelo p0.h, x0, x1
; CHECK-SVE2p1-NEXT:    cset w8, mi
; CHECK-SVE2p1-NEXT:    mov z0.h, p0/z, #1 // =0x1
; CHECK-SVE2p1-NEXT:    umov w9, v0.h[4]
; CHECK-SVE2p1-NEXT:    umov w10, v0.h[1]
; CHECK-SVE2p1-NEXT:    umov w11, v0.h[5]
; CHECK-SVE2p1-NEXT:    fmov s0, w8
; CHECK-SVE2p1-NEXT:    fmov s1, w9
; CHECK-SVE2p1-NEXT:    mov v0.s[1], w10
; CHECK-SVE2p1-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SVE2p1-NEXT:    mov v1.s[1], w11
; CHECK-SVE2p1-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SVE2p1-NEXT:    b use
    %r = call <vscale x 8 x i1> @llvm.get.active.lane.mask.nxv8i1.i64(i64 %i, i64 %n)
    %v0 = call <2 x i1> @llvm.vector.extract.v2i1.nxv8i1.i64(<vscale x 8 x i1> %r, i64 0)
    %v1 = call <2 x i1> @llvm.vector.extract.v2i1.nxv8i1.i64(<vscale x 8 x i1> %r, i64 4)
    tail call void @use(<2 x i1> %v0, <2 x i1> %v1)
    ret void
}

declare void @use(...)

attributes #0 = { nounwind }
