; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py

; Check the attribute.

; RUN: llc < %s -mtriple=x86_64-- -mattr=-sbb-dep-breaking | FileCheck %s --check-prefixes=ZERO
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sbb-dep-breaking | FileCheck %s --check-prefixes=IDIOM

; And check that CPUs have included the attribute as expected.

; RUN: llc < %s -mtriple=x86_64--                   | FileCheck %s --check-prefixes=ZERO
; RUN: llc < %s -mtriple=x86_64-- -mcpu=sandybridge | FileCheck %s --check-prefixes=ZERO
; RUN: llc < %s -mtriple=x86_64-- -mcpu=skylake     | FileCheck %s --check-prefixes=ZERO
; RUN: llc < %s -mtriple=x86_64-- -mcpu=k8          | FileCheck %s --check-prefixes=IDIOM
; RUN: llc < %s -mtriple=x86_64-- -mcpu=btver1      | FileCheck %s --check-prefixes=IDIOM
; RUN: llc < %s -mtriple=x86_64-- -mcpu=bdver2      | FileCheck %s --check-prefixes=IDIOM
; RUN: llc < %s -mtriple=x86_64-- -mcpu=znver3      | FileCheck %s --check-prefixes=IDIOM

define i32 @i32_select_0_or_neg1(i32 %x) {
; ZERO-LABEL: i32_select_0_or_neg1:
; ZERO:       # %bb.0:
; ZERO-NEXT:    xorl %eax, %eax
; ZERO-NEXT:    negl %edi
; ZERO-NEXT:    sbbl %eax, %eax
; ZERO-NEXT:    retq
;
; IDIOM-LABEL: i32_select_0_or_neg1:
; IDIOM:       # %bb.0:
; IDIOM-NEXT:    negl %edi
; IDIOM-NEXT:    sbbl %eax, %eax
; IDIOM-NEXT:    retq
  %cmp = icmp ne i32 %x, 0
  %sel = select i1 %cmp, i32 -1, i32 0
  ret i32 %sel
}
