; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64 -global-isel=0 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel=1 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define i8 @ti8(i1 %c, ptr %p, i8 %a, i8 %b) {
; CHECK-SD-LABEL: ti8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB0_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov w3, w2
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB0_2: // %e
; CHECK-SD-NEXT:    mov w0, w3
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ti8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    mov w0, w3
; CHECK-GI-NEXT:    tbz w8, #0, .LBB0_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov w0, w2
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB0_2: // %e
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi i8 [%a, %t], [%b, %entry]
    ret i8 %h
}

define i16 @ti16(i1 %c, ptr %p, i16 %a, i16 %b) {
; CHECK-SD-LABEL: ti16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB1_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov w3, w2
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB1_2: // %e
; CHECK-SD-NEXT:    mov w0, w3
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ti16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    mov w0, w3
; CHECK-GI-NEXT:    tbz w8, #0, .LBB1_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov w0, w2
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB1_2: // %e
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi i16 [%a, %t], [%b, %entry]
    ret i16 %h
}

define i32 @ti32(i1 %c, ptr %p, i32 %a, i32 %b) {
; CHECK-SD-LABEL: ti32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB2_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov w3, w2
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB2_2: // %e
; CHECK-SD-NEXT:    mov w0, w3
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ti32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    mov w0, w3
; CHECK-GI-NEXT:    tbz w8, #0, .LBB2_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov w0, w2
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB2_2: // %e
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi i32 [%a, %t], [%b, %entry]
    ret i32 %h
}

define i64 @ti64(i1 %c, ptr %p, i64 %a, i64 %b) {
; CHECK-SD-LABEL: ti64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB3_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov x3, x2
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB3_2: // %e
; CHECK-SD-NEXT:    mov x0, x3
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ti64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    mov x0, x3
; CHECK-GI-NEXT:    tbz w8, #0, .LBB3_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov x0, x2
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB3_2: // %e
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi i64 [%a, %t], [%b, %entry]
    ret i64 %h
}

define i128 @ti128(i1 %c, ptr %p, i128 %a, i128 %b) {
; CHECK-SD-LABEL: ti128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB4_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov x4, x2
; CHECK-SD-NEXT:    mov x5, x3
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB4_2: // %e
; CHECK-SD-NEXT:    mov x0, x4
; CHECK-SD-NEXT:    mov x1, x5
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ti128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    mov x0, x4
; CHECK-GI-NEXT:    tbz w8, #0, .LBB4_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov x0, x2
; CHECK-GI-NEXT:    mov x5, x3
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB4_2: // %e
; CHECK-GI-NEXT:    mov x1, x5
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi i128 [%a, %t], [%b, %entry]
    ret i128 %h
}

define ptr @tp0(i1 %c, ptr %p, ptr %a, ptr %b) {
; CHECK-SD-LABEL: tp0:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB5_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov x3, x2
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB5_2: // %e
; CHECK-SD-NEXT:    mov x0, x3
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tp0:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    mov x0, x3
; CHECK-GI-NEXT:    tbz w8, #0, .LBB5_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov x0, x2
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB5_2: // %e
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi ptr [%a, %t], [%b, %entry]
    ret ptr %h
}

define half @tf16(i1 %c, ptr %p, half %a, half %b) {
; CHECK-LABEL: tf16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB6_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    fmov s1, s0
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB6_2: // %e
; CHECK-NEXT:    fmov s0, s1
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi half [%a, %t], [%b, %entry]
    ret half %h
}

define float @tf32(i1 %c, ptr %p, float %a, float %b) {
; CHECK-LABEL: tf32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB7_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    fmov s1, s0
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB7_2: // %e
; CHECK-NEXT:    fmov s0, s1
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi float [%a, %t], [%b, %entry]
    ret float %h
}

define double @tf64(i1 %c, ptr %p, double %a, double %b) {
; CHECK-LABEL: tf64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB8_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    fmov d1, d0
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB8_2: // %e
; CHECK-NEXT:    fmov d0, d1
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi double [%a, %t], [%b, %entry]
    ret double %h
}

define fp128 @tf128(i1 %c, ptr %p, fp128 %a, fp128 %b) {
; CHECK-SD-LABEL: tf128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB9_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov v1.16b, v0.16b
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB9_2: // %e
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tf128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    tbz w0, #0, .LBB9_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov d2, v0.d[1]
; CHECK-GI-NEXT:    fmov d1, d0
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:    b .LBB9_3
; CHECK-GI-NEXT:  .LBB9_2:
; CHECK-GI-NEXT:    mov d2, v1.d[1]
; CHECK-GI-NEXT:  .LBB9_3: // %e
; CHECK-GI-NEXT:    fmov x8, d1
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    fmov x8, d2
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi fp128 [%a, %t], [%b, %entry]
    ret fp128 %h
}

define <2 x i8> @tv2i8(i1 %c, ptr %p, <2 x i8> %a, <2 x i8> %b) {
; CHECK-SD-LABEL: tv2i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB10_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    fmov d1, d0
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB10_2: // %e
; CHECK-SD-NEXT:    fmov d0, d1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv2i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    tbz w0, #0, .LBB10_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov w8, v0.s[1]
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:    mov v0.b[1], w8
; CHECK-GI-NEXT:    fmov d1, d0
; CHECK-GI-NEXT:    b .LBB10_3
; CHECK-GI-NEXT:  .LBB10_2:
; CHECK-GI-NEXT:    mov w8, v1.s[1]
; CHECK-GI-NEXT:    mov v1.b[1], w8
; CHECK-GI-NEXT:  .LBB10_3: // %e
; CHECK-GI-NEXT:    umov w8, v1.b[0]
; CHECK-GI-NEXT:    umov w9, v1.b[1]
; CHECK-GI-NEXT:    mov v0.s[0], w8
; CHECK-GI-NEXT:    mov v0.s[1], w9
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <2 x i8> [%a, %t], [%b, %entry]
    ret <2 x i8> %h
}

define <3 x i8> @tv3i8(i1 %c, ptr %p, <3 x i8> %a, <3 x i8> %b) {
; CHECK-SD-LABEL: tv3i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB11_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov w5, w2
; CHECK-SD-NEXT:    mov w6, w3
; CHECK-SD-NEXT:    mov w7, w4
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB11_2: // %e
; CHECK-SD-NEXT:    mov w0, w5
; CHECK-SD-NEXT:    mov w1, w6
; CHECK-SD-NEXT:    mov w2, w7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv3i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    tbz w0, #0, .LBB11_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    fmov s0, w2
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:    mov v0.b[1], w3
; CHECK-GI-NEXT:    mov v0.b[2], w4
; CHECK-GI-NEXT:    b .LBB11_3
; CHECK-GI-NEXT:  .LBB11_2:
; CHECK-GI-NEXT:    fmov s0, w5
; CHECK-GI-NEXT:    mov v0.b[1], w6
; CHECK-GI-NEXT:    mov v0.b[2], w7
; CHECK-GI-NEXT:  .LBB11_3: // %e
; CHECK-GI-NEXT:    umov w0, v0.b[0]
; CHECK-GI-NEXT:    umov w1, v0.b[1]
; CHECK-GI-NEXT:    umov w2, v0.b[2]
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <3 x i8> [%a, %t], [%b, %entry]
    ret <3 x i8> %h
}

define <4 x i8> @tv4i8(i1 %c, ptr %p, <4 x i8> %a, <4 x i8> %b) {
; CHECK-SD-LABEL: tv4i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB12_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    fmov d1, d0
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB12_2: // %e
; CHECK-SD-NEXT:    fmov d0, d1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv4i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    tbz w0, #0, .LBB12_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    uzp1 v0.8b, v0.8b, v0.8b
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
; CHECK-GI-NEXT:  .LBB12_2:
; CHECK-GI-NEXT:    uzp1 v0.8b, v1.8b, v0.8b
; CHECK-GI-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <4 x i8> [%a, %t], [%b, %entry]
    ret <4 x i8> %h
}

define <8 x i8> @tv8i8(i1 %c, ptr %p, <8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: tv8i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB13_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    fmov d1, d0
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB13_2: // %e
; CHECK-NEXT:    fmov d0, d1
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <8 x i8> [%a, %t], [%b, %entry]
    ret <8 x i8> %h
}

define <16 x i8> @tv16i8(i1 %c, ptr %p, <16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: tv16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB14_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB14_2: // %e
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <16 x i8> [%a, %t], [%b, %entry]
    ret <16 x i8> %h
}

define <32 x i8> @tv32i8(i1 %c, ptr %p, <32 x i8> %a, <32 x i8> %b) {
; CHECK-SD-LABEL: tv32i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB15_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov v2.16b, v0.16b
; CHECK-SD-NEXT:    mov v3.16b, v1.16b
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB15_2: // %e
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    mov v1.16b, v3.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv32i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov v4.16b, v0.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    tbz w0, #0, .LBB15_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v3.16b, v1.16b
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB15_2: // %e
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <32 x i8> [%a, %t], [%b, %entry]
    ret <32 x i8> %h
}

define <2 x i16> @tv2i16(i1 %c, ptr %p, <2 x i16> %a, <2 x i16> %b) {
; CHECK-SD-LABEL: tv2i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB16_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    fmov d1, d0
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB16_2: // %e
; CHECK-SD-NEXT:    fmov d0, d1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv2i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    tbz w0, #0, .LBB16_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    uzp1 v0.4h, v0.4h, v0.4h
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
; CHECK-GI-NEXT:  .LBB16_2:
; CHECK-GI-NEXT:    uzp1 v0.4h, v1.4h, v0.4h
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <2 x i16> [%a, %t], [%b, %entry]
    ret <2 x i16> %h
}

define <3 x i16> @tv3i16(i1 %c, ptr %p, <3 x i16> %a, <3 x i16> %b) {
; CHECK-LABEL: tv3i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB17_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    fmov d1, d0
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB17_2: // %e
; CHECK-NEXT:    fmov d0, d1
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <3 x i16> [%a, %t], [%b, %entry]
    ret <3 x i16> %h
}

define <4 x i16> @tv4i16(i1 %c, ptr %p, <4 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: tv4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB18_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    fmov d1, d0
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB18_2: // %e
; CHECK-NEXT:    fmov d0, d1
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <4 x i16> [%a, %t], [%b, %entry]
    ret <4 x i16> %h
}

define <8 x i16> @tv8i16(i1 %c, ptr %p, <8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: tv8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB19_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB19_2: // %e
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <8 x i16> [%a, %t], [%b, %entry]
    ret <8 x i16> %h
}

define <16 x i16> @tv16i16(i1 %c, ptr %p, <16 x i16> %a, <16 x i16> %b) {
; CHECK-SD-LABEL: tv16i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB20_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov v2.16b, v0.16b
; CHECK-SD-NEXT:    mov v3.16b, v1.16b
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB20_2: // %e
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    mov v1.16b, v3.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv16i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov v4.16b, v0.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    tbz w0, #0, .LBB20_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v3.16b, v1.16b
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB20_2: // %e
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <16 x i16> [%a, %t], [%b, %entry]
    ret <16 x i16> %h
}

define <2 x i32> @tv2i32(i1 %c, ptr %p, <2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: tv2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB21_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    fmov d1, d0
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB21_2: // %e
; CHECK-NEXT:    fmov d0, d1
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <2 x i32> [%a, %t], [%b, %entry]
    ret <2 x i32> %h
}

define <3 x i32> @tv3i32(i1 %c, ptr %p, <3 x i32> %a, <3 x i32> %b) {
; CHECK-LABEL: tv3i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB22_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB22_2: // %e
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <3 x i32> [%a, %t], [%b, %entry]
    ret <3 x i32> %h
}

define <4 x i32> @tv4i32(i1 %c, ptr %p, <4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: tv4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB23_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB23_2: // %e
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <4 x i32> [%a, %t], [%b, %entry]
    ret <4 x i32> %h
}

define <8 x i32> @tv8i32(i1 %c, ptr %p, <8 x i32> %a, <8 x i32> %b) {
; CHECK-SD-LABEL: tv8i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB24_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov v2.16b, v0.16b
; CHECK-SD-NEXT:    mov v3.16b, v1.16b
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB24_2: // %e
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    mov v1.16b, v3.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv8i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov v4.16b, v0.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    tbz w0, #0, .LBB24_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v3.16b, v1.16b
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB24_2: // %e
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <8 x i32> [%a, %t], [%b, %entry]
    ret <8 x i32> %h
}

define <2 x i64> @tv2i64(i1 %c, ptr %p, <2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: tv2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB25_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB25_2: // %e
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <2 x i64> [%a, %t], [%b, %entry]
    ret <2 x i64> %h
}

define <3 x i64> @tv3i64(i1 %c, ptr %p, <3 x i64> %a, <3 x i64> %b) {
; CHECK-SD-LABEL: tv3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB26_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    fmov d3, d0
; CHECK-SD-NEXT:    fmov d4, d1
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:    fmov d5, d2
; CHECK-SD-NEXT:  .LBB26_2: // %e
; CHECK-SD-NEXT:    fmov d0, d3
; CHECK-SD-NEXT:    fmov d1, d4
; CHECK-SD-NEXT:    fmov d2, d5
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d4 killed $d4 def $q4
; CHECK-GI-NEXT:    tbz w0, #0, .LBB26_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    fmov d6, d0
; CHECK-GI-NEXT:    fmov d7, d2
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:    mov v6.d[1], v1.d[0]
; CHECK-GI-NEXT:    mov v2.16b, v7.16b
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    mov d1, v6.d[1]
; CHECK-GI-NEXT:    mov v0.16b, v6.16b
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
; CHECK-GI-NEXT:  .LBB26_2:
; CHECK-GI-NEXT:    fmov d0, d3
; CHECK-GI-NEXT:    fmov d2, d5
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    mov v0.d[1], v4.d[0]
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <3 x i64> [%a, %t], [%b, %entry]
    ret <3 x i64> %h
}

define <4 x i64> @tv4i64(i1 %c, ptr %p, <4 x i64> %a, <4 x i64> %b) {
; CHECK-SD-LABEL: tv4i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB27_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov v2.16b, v0.16b
; CHECK-SD-NEXT:    mov v3.16b, v1.16b
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB27_2: // %e
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    mov v1.16b, v3.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv4i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov v4.16b, v0.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    tbz w0, #0, .LBB27_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v3.16b, v1.16b
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB27_2: // %e
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <4 x i64> [%a, %t], [%b, %entry]
    ret <4 x i64> %h
}

define <2 x i128> @tv2i128(i1 %c, ptr %p, <2 x i128> %a, <2 x i128> %b) {
; CHECK-SD-LABEL: tv2i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB28_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov x6, x2
; CHECK-SD-NEXT:    mov x7, x3
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:    b .LBB28_3
; CHECK-SD-NEXT:  .LBB28_2:
; CHECK-SD-NEXT:    ldp x4, x5, [sp]
; CHECK-SD-NEXT:  .LBB28_3: // %e
; CHECK-SD-NEXT:    mov x0, x6
; CHECK-SD-NEXT:    mov x1, x7
; CHECK-SD-NEXT:    mov x2, x4
; CHECK-SD-NEXT:    mov x3, x5
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv2i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    tbz w0, #0, .LBB28_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov x9, x2
; CHECK-GI-NEXT:    mov x10, x3
; CHECK-GI-NEXT:    mov x2, x4
; CHECK-GI-NEXT:    mov x3, x5
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:    mov x0, x9
; CHECK-GI-NEXT:    mov x1, x10
; CHECK-GI-NEXT:    ret
; CHECK-GI-NEXT:  .LBB28_2:
; CHECK-GI-NEXT:    ldp x2, x3, [sp]
; CHECK-GI-NEXT:    mov x0, x6
; CHECK-GI-NEXT:    mov x1, x7
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <2 x i128> [%a, %t], [%b, %entry]
    ret <2 x i128> %h
}

define <2 x ptr> @tv2p0(i1 %c, ptr %p, <2 x ptr> %a, <2 x ptr> %b) {
; CHECK-LABEL: tv2p0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB29_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB29_2: // %e
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <2 x ptr> [%a, %t], [%b, %entry]
    ret <2 x ptr> %h
}

define <3 x ptr> @tv3p0(i1 %c, ptr %p, <3 x ptr> %a, <3 x ptr> %b) {
; CHECK-SD-LABEL: tv3p0:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB30_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    fmov d3, d0
; CHECK-SD-NEXT:    fmov d4, d1
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:    fmov d5, d2
; CHECK-SD-NEXT:  .LBB30_2: // %e
; CHECK-SD-NEXT:    fmov d0, d3
; CHECK-SD-NEXT:    fmov d1, d4
; CHECK-SD-NEXT:    fmov d2, d5
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv3p0:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    tbz w0, #0, .LBB30_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    fmov x9, d2
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    fmov x8, d1
; CHECK-GI-NEXT:    b .LBB30_3
; CHECK-GI-NEXT:  .LBB30_2:
; CHECK-GI-NEXT:    fmov x8, d3
; CHECK-GI-NEXT:    fmov x9, d5
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    fmov x8, d4
; CHECK-GI-NEXT:  .LBB30_3: // %e
; CHECK-GI-NEXT:    mov v1.d[0], x9
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    mov d2, v0.d[1]
; CHECK-GI-NEXT:    fmov x10, d1
; CHECK-GI-NEXT:    fmov d1, d2
; CHECK-GI-NEXT:    fmov d2, x10
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <3 x ptr> [%a, %t], [%b, %entry]
    ret <3 x ptr> %h
}

define <4 x ptr> @tv4p0(i1 %c, ptr %p, <4 x ptr> %a, <4 x ptr> %b) {
; CHECK-SD-LABEL: tv4p0:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB31_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov v2.16b, v0.16b
; CHECK-SD-NEXT:    mov v3.16b, v1.16b
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB31_2: // %e
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    mov v1.16b, v3.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv4p0:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov v4.16b, v0.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    tbz w0, #0, .LBB31_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v3.16b, v1.16b
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB31_2: // %e
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <4 x ptr> [%a, %t], [%b, %entry]
    ret <4 x ptr> %h
}

define <2 x half> @tv2f16(i1 %c, ptr %p, <2 x half> %a, <2 x half> %b) {
; CHECK-LABEL: tv2f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB32_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    fmov d1, d0
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB32_2: // %e
; CHECK-NEXT:    fmov d0, d1
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <2 x half> [%a, %t], [%b, %entry]
    ret <2 x half> %h
}

define <3 x half> @tv3f16(i1 %c, ptr %p, <3 x half> %a, <3 x half> %b) {
; CHECK-LABEL: tv3f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB33_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    fmov d1, d0
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB33_2: // %e
; CHECK-NEXT:    fmov d0, d1
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <3 x half> [%a, %t], [%b, %entry]
    ret <3 x half> %h
}

define <4 x half> @tv4f16(i1 %c, ptr %p, <4 x half> %a, <4 x half> %b) {
; CHECK-LABEL: tv4f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB34_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    fmov d1, d0
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB34_2: // %e
; CHECK-NEXT:    fmov d0, d1
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <4 x half> [%a, %t], [%b, %entry]
    ret <4 x half> %h
}

define <8 x half> @tv8f16(i1 %c, ptr %p, <8 x half> %a, <8 x half> %b) {
; CHECK-LABEL: tv8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB35_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB35_2: // %e
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <8 x half> [%a, %t], [%b, %entry]
    ret <8 x half> %h
}

define <16 x half> @tv16f16(i1 %c, ptr %p, <16 x half> %a, <16 x half> %b) {
; CHECK-SD-LABEL: tv16f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB36_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov v2.16b, v0.16b
; CHECK-SD-NEXT:    mov v3.16b, v1.16b
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB36_2: // %e
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    mov v1.16b, v3.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv16f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov v4.16b, v0.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    tbz w0, #0, .LBB36_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v3.16b, v1.16b
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB36_2: // %e
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <16 x half> [%a, %t], [%b, %entry]
    ret <16 x half> %h
}

define <2 x float> @tv2f32(i1 %c, ptr %p, <2 x float> %a, <2 x float> %b) {
; CHECK-LABEL: tv2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB37_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    fmov d1, d0
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB37_2: // %e
; CHECK-NEXT:    fmov d0, d1
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <2 x float> [%a, %t], [%b, %entry]
    ret <2 x float> %h
}

define <3 x float> @tv3f32(i1 %c, ptr %p, <3 x float> %a, <3 x float> %b) {
; CHECK-LABEL: tv3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB38_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB38_2: // %e
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <3 x float> [%a, %t], [%b, %entry]
    ret <3 x float> %h
}

define <4 x float> @tv4f32(i1 %c, ptr %p, <4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: tv4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB39_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB39_2: // %e
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <4 x float> [%a, %t], [%b, %entry]
    ret <4 x float> %h
}

define <8 x float> @tv8f32(i1 %c, ptr %p, <8 x float> %a, <8 x float> %b) {
; CHECK-SD-LABEL: tv8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB40_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov v2.16b, v0.16b
; CHECK-SD-NEXT:    mov v3.16b, v1.16b
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB40_2: // %e
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    mov v1.16b, v3.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov v4.16b, v0.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    tbz w0, #0, .LBB40_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v3.16b, v1.16b
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB40_2: // %e
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <8 x float> [%a, %t], [%b, %entry]
    ret <8 x float> %h
}

define <2 x double> @tv2f64(i1 %c, ptr %p, <2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: tv2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    tbz w0, #0, .LBB41_2
; CHECK-NEXT:  // %bb.1: // %t
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    str wzr, [x1]
; CHECK-NEXT:  .LBB41_2: // %e
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <2 x double> [%a, %t], [%b, %entry]
    ret <2 x double> %h
}

define <3 x double> @tv3f64(i1 %c, ptr %p, <3 x double> %a, <3 x double> %b) {
; CHECK-SD-LABEL: tv3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB42_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    fmov d3, d0
; CHECK-SD-NEXT:    fmov d4, d1
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:    fmov d5, d2
; CHECK-SD-NEXT:  .LBB42_2: // %e
; CHECK-SD-NEXT:    fmov d0, d3
; CHECK-SD-NEXT:    fmov d1, d4
; CHECK-SD-NEXT:    fmov d2, d5
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d4 killed $d4 def $q4
; CHECK-GI-NEXT:    tbz w0, #0, .LBB42_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    fmov d6, d0
; CHECK-GI-NEXT:    fmov d7, d2
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:    mov v6.d[1], v1.d[0]
; CHECK-GI-NEXT:    mov v2.16b, v7.16b
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    mov d1, v6.d[1]
; CHECK-GI-NEXT:    mov v0.16b, v6.16b
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
; CHECK-GI-NEXT:  .LBB42_2:
; CHECK-GI-NEXT:    fmov d0, d3
; CHECK-GI-NEXT:    fmov d2, d5
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    mov v0.d[1], v4.d[0]
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <3 x double> [%a, %t], [%b, %entry]
    ret <3 x double> %h
}

define <4 x double> @tv4f64(i1 %c, ptr %p, <4 x double> %a, <4 x double> %b) {
; CHECK-SD-LABEL: tv4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB43_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov v2.16b, v0.16b
; CHECK-SD-NEXT:    mov v3.16b, v1.16b
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB43_2: // %e
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    mov v1.16b, v3.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov v4.16b, v0.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    tbz w0, #0, .LBB43_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v3.16b, v1.16b
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:  .LBB43_2: // %e
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <4 x double> [%a, %t], [%b, %entry]
    ret <4 x double> %h
}

define <2 x fp128> @tv2f128(i1 %c, ptr %p, <2 x fp128> %a, <2 x fp128> %b) {
; CHECK-SD-LABEL: tv2f128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    tbz w0, #0, .LBB44_2
; CHECK-SD-NEXT:  // %bb.1: // %t
; CHECK-SD-NEXT:    mov v2.16b, v0.16b
; CHECK-SD-NEXT:    mov v3.16b, v1.16b
; CHECK-SD-NEXT:    str wzr, [x1]
; CHECK-SD-NEXT:  .LBB44_2: // %e
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    mov v1.16b, v3.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: tv2f128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    tbz w0, #0, .LBB44_2
; CHECK-GI-NEXT:  // %bb.1: // %t
; CHECK-GI-NEXT:    mov d4, v1.d[1]
; CHECK-GI-NEXT:    mov d5, v0.d[1]
; CHECK-GI-NEXT:    str wzr, [x1]
; CHECK-GI-NEXT:    fmov d2, d0
; CHECK-GI-NEXT:    fmov d3, d1
; CHECK-GI-NEXT:    b .LBB44_3
; CHECK-GI-NEXT:  .LBB44_2:
; CHECK-GI-NEXT:    mov d4, v3.d[1]
; CHECK-GI-NEXT:    mov d5, v2.d[1]
; CHECK-GI-NEXT:  .LBB44_3: // %e
; CHECK-GI-NEXT:    fmov x8, d2
; CHECK-GI-NEXT:    fmov x9, d3
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    mov v1.d[0], x9
; CHECK-GI-NEXT:    fmov x8, d5
; CHECK-GI-NEXT:    fmov x9, d4
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    mov v1.d[1], x9
; CHECK-GI-NEXT:    ret
entry:
    br i1 %c, label %t, label %e
t:
    store i32 0, ptr %p
    br label %e
e:
    %h = phi <2 x fp128> [%a, %t], [%b, %entry]
    ret <2 x fp128> %h
}
