# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple thumbv7m-none-eabi -mcpu=cortex-m4 < %s | FileCheck %s
str.w r1, [r0], #16
str.w r1, [r0, 16]!
strb.w r1, [r0], #16
strb.w r1, [r0, 16]!
strh.w r1, [r0], #16
strh.w r1, [r0, 16]!
ldr.w r1, [r0], #16
ldr.w r1, [r0, 16]!
ldrb.w r1, [r0], #16
ldrb.w r1, [r0, 16]!
ldrh.w r1, [r0], #16
ldrh.w r1, [r0, 16]!
ldrsb.w r1, [r0], #16
ldrsb.w r1, [r0, 16]!
ldrsh.w r1, [r0], #16
ldrsh.w r1, [r0, 16]!

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      1600
# CHECK-NEXT: Total Cycles:      2601
# CHECK-NEXT: Total uOps:        1600

# CHECK:      Dispatch Width:    1
# CHECK-NEXT: uOps Per Cycle:    0.62
# CHECK-NEXT: IPC:               0.62
# CHECK-NEXT: Block RThroughput: 16.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     1.00           *            str	r1, [r0], #16
# CHECK-NEXT:  1      1     1.00           *            str	r1, [r0, #16]!
# CHECK-NEXT:  1      1     1.00           *            strb	r1, [r0], #16
# CHECK-NEXT:  1      1     1.00           *            strb	r1, [r0, #16]!
# CHECK-NEXT:  1      1     1.00           *            strh	r1, [r0], #16
# CHECK-NEXT:  1      1     1.00           *            strh	r1, [r0, #16]!
# CHECK-NEXT:  1      2     1.00    *                   ldr	r1, [r0], #16
# CHECK-NEXT:  1      2     1.00    *                   ldr	r1, [r0, #16]!
# CHECK-NEXT:  1      2     1.00    *                   ldrb	r1, [r0], #16
# CHECK-NEXT:  1      2     1.00    *                   ldrb	r1, [r0, #16]!
# CHECK-NEXT:  1      2     1.00    *                   ldrh	r1, [r0], #16
# CHECK-NEXT:  1      2     1.00    *                   ldrh	r1, [r0, #16]!
# CHECK-NEXT:  1      2     1.00    *                   ldrsb	r1, [r0], #16
# CHECK-NEXT:  1      2     1.00    *                   ldrsb	r1, [r0, #16]!
# CHECK-NEXT:  1      2     1.00    *                   ldrsh	r1, [r0], #16
# CHECK-NEXT:  1      2     1.00    *                   ldrsh	r1, [r0, #16]!

# CHECK:      Resources:
# CHECK-NEXT: [0]   - M4Unit

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]
# CHECK-NEXT: 16.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    Instructions:
# CHECK-NEXT: 1.00   str	r1, [r0], #16
# CHECK-NEXT: 1.00   str	r1, [r0, #16]!
# CHECK-NEXT: 1.00   strb	r1, [r0], #16
# CHECK-NEXT: 1.00   strb	r1, [r0, #16]!
# CHECK-NEXT: 1.00   strh	r1, [r0], #16
# CHECK-NEXT: 1.00   strh	r1, [r0, #16]!
# CHECK-NEXT: 1.00   ldr	r1, [r0], #16
# CHECK-NEXT: 1.00   ldr	r1, [r0, #16]!
# CHECK-NEXT: 1.00   ldrb	r1, [r0], #16
# CHECK-NEXT: 1.00   ldrb	r1, [r0, #16]!
# CHECK-NEXT: 1.00   ldrh	r1, [r0], #16
# CHECK-NEXT: 1.00   ldrh	r1, [r0, #16]!
# CHECK-NEXT: 1.00   ldrsb	r1, [r0], #16
# CHECK-NEXT: 1.00   ldrsb	r1, [r0, #16]!
# CHECK-NEXT: 1.00   ldrsh	r1, [r0], #16
# CHECK-NEXT: 1.00   ldrsh	r1, [r0, #16]!
