# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p470 -iterations=1 < %s | FileCheck %s

vsetvli zero, zero, e32, m2, tu, mu
vslidedown.vx v5, v7, x6

vsetvli zero, zero, e32, m4, tu, mu
vslidedown.vx v5, v7, x6

vsetvli zero, zero, e32, m8, tu, mu
vslidedown.vx v5, v7, x6

vsetvli zero, zero, e32, m2, tu, mu
vslideup.vx v5, v7, x6

vsetvli zero, zero, e32, m4, tu, mu
vslideup.vx v5, v7, x6

vsetvli zero, zero, e32, m8, tu, mu
vslideup.vx v5, v7, x6

vsetvli zero, zero, e32, m2, tu, mu
vslideup.vx v5, v7, x6, v0.t

vsetvli zero, zero, e32, m4, tu, mu
vslideup.vx v5, v7, x6, v0.t

vsetvli zero, zero, e32, m8, tu, mu
vslideup.vx v5, v7, x6, v0.t

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      18
# CHECK-NEXT: Total Cycles:      125
# CHECK-NEXT: Total uOps:        18

# CHECK:      Dispatch Width:    3
# CHECK-NEXT: uOps Per Cycle:    0.14
# CHECK-NEXT: IPC:               0.14
# CHECK-NEXT: Block RThroughput: 121.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      11    11.00                       vslidedown.vx v5, v7, t1
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      14    14.00                       vslidedown.vx v5, v7, t1
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      20    20.00                       vslidedown.vx v5, v7, t1
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      10    10.00                       vslideup.vx v5, v7, t1
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      12    12.00                       vslideup.vx v5, v7, t1
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      16    16.00                       vslideup.vx v5, v7, t1
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      10    10.00                       vslideup.vx v5, v7, t1, v0.t
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      12    12.00                       vslideup.vx v5, v7, t1, v0.t
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      16    16.00                       vslideup.vx v5, v7, t1, v0.t

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP400Div
# CHECK-NEXT: [1]   - SiFiveP400FEXQ0
# CHECK-NEXT: [2]   - SiFiveP400FloatDiv
# CHECK-NEXT: [3]   - SiFiveP400IEXQ0
# CHECK-NEXT: [4]   - SiFiveP400IEXQ1
# CHECK-NEXT: [5]   - SiFiveP400IEXQ2
# CHECK-NEXT: [6]   - SiFiveP400Load
# CHECK-NEXT: [7]   - SiFiveP400Store
# CHECK-NEXT: [8]   - SiFiveP400VDiv
# CHECK-NEXT: [9]   - SiFiveP400VEXQ0
# CHECK-NEXT: [10]  - SiFiveP400VFloatDiv
# CHECK-NEXT: [11]  - SiFiveP400VLD
# CHECK-NEXT: [12]  - SiFiveP400VST

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]
# CHECK-NEXT:  -      -      -      -     9.00    -      -      -      -     121.00  -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   Instructions:
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     11.00   -      -      -     vslidedown.vx  v5, v7, t1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     14.00   -      -      -     vslidedown.vx  v5, v7, t1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     20.00   -      -      -     vslidedown.vx  v5, v7, t1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     10.00   -      -      -     vslideup.vx  v5, v7, t1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     12.00   -      -      -     vslideup.vx  v5, v7, t1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     16.00   -      -      -     vslideup.vx  v5, v7, t1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     10.00   -      -      -     vslideup.vx  v5, v7, t1, v0.t
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     12.00   -      -      -     vslideup.vx  v5, v7, t1, v0.t
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     16.00   -      -      -     vslideup.vx  v5, v7, t1, v0.t

