; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2             | FileCheck %s --check-prefixes=SSE2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse4.2           | FileCheck %s --check-prefixes=SSE42
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2             | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f          | FileCheck %s --check-prefixes=AVX512F
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f,avx512vl | FileCheck %s --check-prefixes=AVX512VL

define <2 x i64> @select_cast_cond_multiuse_v2i64(<2 x i64> %x, <2 x i64> %y, i2 %m, ptr %o) {
; SSE2-LABEL: select_cast_cond_multiuse_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [1,2]
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    movdqa %xmm3, (%rsi)
; SSE2-NEXT:    pandn %xmm1, %xmm3
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: select_cast_cond_multiuse_v2i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movapd %xmm0, %xmm2
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE42-NEXT:    pmovsxbq {{.*#+}} xmm3 = [1,2]
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm3, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE42-NEXT:    movdqa %xmm0, (%rsi)
; SSE42-NEXT:    movapd %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: select_cast_cond_multiuse_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX2-NEXT:    vpmovsxbq {{.*#+}} xmm3 = [1,2]
; AVX2-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqq %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: select_cast_cond_multiuse_v2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogq {{.*#+}} zmm2 {%k1} {z} = -1
; AVX512F-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: select_cast_cond_multiuse_v2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vmovdqa64 %xmm2, %xmm2 {%k1} {z}
; AVX512VL-NEXT:    vpblendmq %xmm0, %xmm1, %xmm0 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512VL-NEXT:    retq
  %z = bitcast i2 %m to <2 x i1>
  %s = sext <2 x i1> %z to <2 x i64>
  %v = select <2 x i1> %z, <2 x i64> %x, <2 x i64> %y
  store <2 x i64> %s, ptr %o
  ret <2 x i64> %v
}

define <4 x i32> @select_cast_cond_multiuse_v4i32(<4 x i32> %x, <4 x i32> %y, i4 %m, ptr %o) {
; SSE2-LABEL: select_cast_cond_multiuse_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm2, (%rsi)
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: select_cast_cond_multiuse_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movaps %xmm0, %xmm2
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE42-NEXT:    pmovsxbd {{.*#+}} xmm3 = [1,2,4,8]
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm3, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm2, %xmm1
; SSE42-NEXT:    movdqa %xmm0, (%rsi)
; SSE42-NEXT:    movaps %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: select_cast_cond_multiuse_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX2-NEXT:    vpmovsxbd {{.*#+}} xmm3 = [1,2,4,8]
; AVX2-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: select_cast_cond_multiuse_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogd {{.*#+}} zmm2 {%k1} {z} = -1
; AVX512F-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: select_cast_cond_multiuse_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vmovdqa32 %xmm2, %xmm2 {%k1} {z}
; AVX512VL-NEXT:    vpblendmd %xmm0, %xmm1, %xmm0 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512VL-NEXT:    retq
  %z = bitcast i4 %m to <4 x i1>
  %s = sext <4 x i1> %z to <4 x i32>
  %v = select <4 x i1> %z, <4 x i32> %x, <4 x i32> %y
  store <4 x i32> %s, ptr %o
  ret <4 x i32> %v
}

define <8 x i16> @select_cast_cond_multiuse_v8i16(<8 x i16> %x, <8 x i16> %y, i8 %m, ptr %o) {
; SSE2-LABEL: select_cast_cond_multiuse_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm2
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8,16,32,64,128]
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm3, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm2, (%rsi)
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: select_cast_cond_multiuse_v8i16:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE42-NEXT:    pmovzxbw {{.*#+}} xmm3 = [1,2,4,8,16,32,64,128]
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    pcmpeqw %xmm3, %xmm0
; SSE42-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; SSE42-NEXT:    movdqa %xmm0, (%rsi)
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: select_cast_cond_multiuse_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: select_cast_cond_multiuse_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogd {{.*#+}} zmm2 {%k1} {z} = -1
; AVX512F-NEXT:    vpmovdw %zmm2, %ymm2
; AVX512F-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: select_cast_cond_multiuse_v8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm2 {%k1} {z}
; AVX512VL-NEXT:    vpmovdw %ymm2, %xmm2
; AVX512VL-NEXT:    vpternlogq {{.*#+}} xmm0 = xmm1 ^ (xmm2 & (xmm0 ^ xmm1))
; AVX512VL-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %z = bitcast i8 %m to <8 x i1>
  %s = sext <8 x i1> %z to <8 x i16>
  %v = select <8 x i1> %z, <8 x i16> %x, <8 x i16> %y
  store <8 x i16> %s, ptr %o
  ret <8 x i16> %v
}

define <16 x i8> @select_cast_cond_multiuse_v16i8(<16 x i8> %x, <16 x i8> %y, i16 %m, ptr %o) {
; SSE2-LABEL: select_cast_cond_multiuse_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,1,1,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm3, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm2, (%rsi)
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: select_cast_cond_multiuse_v16i8:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1]
; SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    pcmpeqb %xmm3, %xmm0
; SSE42-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; SSE42-NEXT:    movdqa %xmm0, (%rsi)
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: select_cast_cond_multiuse_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: select_cast_cond_multiuse_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogd {{.*#+}} zmm2 {%k1} {z} = -1
; AVX512F-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512F-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: select_cast_cond_multiuse_v16i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpternlogd {{.*#+}} zmm2 {%k1} {z} = -1
; AVX512VL-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512VL-NEXT:    vpternlogq {{.*#+}} xmm0 = xmm1 ^ (xmm2 & (xmm0 ^ xmm1))
; AVX512VL-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %z = bitcast i16 %m to <16 x i1>
  %s = sext <16 x i1> %z to <16 x i8>
  %v = select <16 x i1> %z, <16 x i8> %x, <16 x i8> %y
  store <16 x i8> %s, ptr %o
  ret <16 x i8> %v
}

define <8 x float> @select_cast_cond_multiuse_v8i16_v8f32(<8 x float> %x, <8 x float> %y, i8 %m, ptr %o) {
; SSE2-LABEL: select_cast_cond_multiuse_v8i16_v8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm4
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm4[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [1,2,4,8,16,32,64,128]
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    pcmpeqw %xmm6, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [1,2,4,8]
; SSE2-NEXT:    movdqa %xmm4, %xmm7
; SSE2-NEXT:    pand %xmm6, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm7
; SSE2-NEXT:    pand %xmm7, %xmm0
; SSE2-NEXT:    pandn %xmm2, %xmm7
; SSE2-NEXT:    por %xmm7, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [16,32,64,128]
; SSE2-NEXT:    pand %xmm2, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    pandn %xmm3, %xmm4
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm5, (%rsi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: select_cast_cond_multiuse_v8i16_v8f32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movaps %xmm0, %xmm4
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm0[0,0,0,0,4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,0,0]
; SSE42-NEXT:    pmovzxbw {{.*#+}} xmm5 = [1,2,4,8,16,32,64,128]
; SSE42-NEXT:    pand %xmm5, %xmm6
; SSE42-NEXT:    pcmpeqw %xmm5, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,0,0]
; SSE42-NEXT:    pmovsxbd {{.*#+}} xmm7 = [1,2,4,8]
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    pand %xmm7, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm7, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm4, %xmm2
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = [16,32,64,128]
; SSE42-NEXT:    pand %xmm0, %xmm5
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm1, %xmm3
; SSE42-NEXT:    movdqa %xmm6, (%rsi)
; SSE42-NEXT:    movaps %xmm2, %xmm0
; SSE42-NEXT:    movaps %xmm3, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: select_cast_cond_multiuse_v8i16_v8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX2-NEXT:    vpcmpeqw %xmm3, %xmm4, %xmm3
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm4 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqa %xmm3, (%rsi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: select_cast_cond_multiuse_v8i16_v8f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogd {{.*#+}} zmm2 {%k1} {z} = -1
; AVX512F-NEXT:    vpmovdw %zmm2, %ymm2
; AVX512F-NEXT:    vblendmps %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: select_cast_cond_multiuse_v8i16_v8f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm2 {%k1} {z}
; AVX512VL-NEXT:    vblendmps %ymm0, %ymm1, %ymm0 {%k1}
; AVX512VL-NEXT:    vpmovdw %ymm2, (%rsi)
; AVX512VL-NEXT:    retq
  %z = bitcast i8 %m to <8 x i1>
  %s = sext <8 x i1> %z to <8 x i16>
  %v = select <8 x i1> %z, <8 x float> %x, <8 x float> %y
  store <8 x i16> %s, ptr %o
  ret <8 x float> %v
}
