; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu | FileCheck %s

define half @use_atan2f16(half %a, half %b) nounwind {
; CHECK-LABEL: use_atan2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movaps %xmm1, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    movss %xmm0, (%rsp) # 4-byte Spill
; CHECK-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    movss (%rsp), %xmm1 # 4-byte Reload
; CHECK-NEXT:    # xmm1 = mem[0],zero,zero,zero
; CHECK-NEXT:    callq atan2f@PLT
; CHECK-NEXT:    callq __truncsfhf2@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
  %x = call half @llvm.atan2.f16(half %a, half %b)
  ret half %x
}

define float @use_atan2f32(float %a, float %b) nounwind {
; CHECK-LABEL: use_atan2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp atan2f@PLT # TAILCALL
  %x = call float @llvm.atan2.f32(float %a, float %b)
  ret float %x
}

define double @use_atan2f64(double %a, double %b) nounwind {
; CHECK-LABEL: use_atan2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp atan2@PLT # TAILCALL
  %x = call double @llvm.atan2.f64(double %a, double %b)
  ret double %x
}

define x86_fp80 @use_atan2f80(x86_fp80 %a, x86_fp80 %b) nounwind {
; CHECK-LABEL: use_atan2f80:
; CHECK:       # %bb.0:
; CHECK-NEXT:    subq $40, %rsp
; CHECK-NEXT:    fldt {{[0-9]+}}(%rsp)
; CHECK-NEXT:    fldt {{[0-9]+}}(%rsp)
; CHECK-NEXT:    fstpt {{[0-9]+}}(%rsp)
; CHECK-NEXT:    fstpt (%rsp)
; CHECK-NEXT:    callq atan2l@PLT
; CHECK-NEXT:    addq $40, %rsp
; CHECK-NEXT:    retq
  %x = call x86_fp80 @llvm.atan2.f80(x86_fp80 %a, x86_fp80 %b)
  ret x86_fp80 %x
}

define fp128 @use_atan2fp128(fp128 %a, fp128 %b) nounwind {
; CHECK-LABEL: use_atan2fp128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp atan2f128@PLT # TAILCALL
  %x = call fp128 @llvm.atan2.f128(fp128 %a, fp128 %b)
  ret fp128 %x
}

define ppc_fp128 @use_atan2ppc_fp128(ppc_fp128 %a, ppc_fp128 %b) nounwind {
; CHECK-LABEL: use_atan2ppc_fp128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq atan2l@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
  %x = call ppc_fp128 @llvm.atan2.ppcf128(ppc_fp128 %a, ppc_fp128 %b)
  ret ppc_fp128 %x
}

declare half @llvm.atan2.f16(half, half)
declare float @llvm.atan2.f32(float, float)
declare double @llvm.atan2.f64(double, double)
declare x86_fp80 @llvm.atan2.f80(x86_fp80, x86_fp80)
declare fp128 @llvm.atan2.f128(fp128, fp128)
declare ppc_fp128 @llvm.atan2.ppcf128(ppc_fp128, ppc_fp128)
