; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --include-generated-funcs --version 5
; RUN: opt -passes="ipsccp<func-spec>,deadargelim" -funcspec-for-literal-constant=false -force-specialization -S < %s | FileCheck %s
; RUN: opt -passes="ipsccp<func-spec>,deadargelim" -funcspec-for-literal-constant=false -funcspec-max-iters=1 -force-specialization -S < %s | FileCheck %s --check-prefix=ONE-ITER
; RUN: opt -passes="ipsccp<func-spec>,deadargelim" -funcspec-for-literal-constant=false -funcspec-max-iters=0 -force-specialization -S < %s | FileCheck %s --check-prefix=DISABLED


define internal i32 @func(ptr %0, i32 %1, ptr nocapture %2) {
  %4 = alloca i32, align 4
  store i32 %1, ptr %4, align 4
  %5 = load i32, ptr %4, align 4
  %6 = icmp slt i32 %5, 1
  br i1 %6, label %14, label %7

7:                                                ; preds = %3
  %8 = load i32, ptr %4, align 4
  %9 = sext i32 %8 to i64
  %10 = getelementptr inbounds i32, ptr %0, i64 %9
  call void %2(ptr %10)
  %11 = load i32, ptr %4, align 4
  %12 = add nsw i32 %11, -1
  %13 = call i32 @func(ptr %0, i32 %12, ptr %2)
  br label %14

14:                                               ; preds = %3, %7
  ret i32 0
}

define internal void @increment(ptr nocapture %0) {
  %2 = load i32, ptr %0, align 4
  %3 = add nsw i32 %2, 1
  store i32 %3, ptr %0, align 4
  ret void
}

define internal void @decrement(ptr nocapture %0) {
  %2 = load i32, ptr %0, align 4
  %3 = add nsw i32 %2, -1
  store i32 %3, ptr %0, align 4
  ret void
}

define i32 @main(ptr %0, i32 %1) {
  %3 = call i32 @func(ptr %0, i32 %1, ptr nonnull @increment)
  %4 = call i32 @func(ptr %0, i32 %3, ptr nonnull @decrement)
  ret i32 %4
}

; CHECK-LABEL: define internal void @increment(
; CHECK-SAME: ptr nocapture [[TMP0:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP0]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP2]], 1
; CHECK-NEXT:    store i32 [[TMP3]], ptr [[TMP0]], align 4
; CHECK-NEXT:    ret void
;
;
; CHECK-LABEL: define internal void @decrement(
; CHECK-SAME: ptr nocapture [[TMP0:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP0]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP2]], -1
; CHECK-NEXT:    store i32 [[TMP3]], ptr [[TMP0]], align 4
; CHECK-NEXT:    ret void
;
;
; CHECK-LABEL: define i32 @main(
; CHECK-SAME: ptr [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; CHECK-NEXT:    call void @func.specialized.2(ptr [[TMP0]], i32 [[TMP1]])
; CHECK-NEXT:    call void @func.specialized.1(ptr [[TMP0]], i32 0)
; CHECK-NEXT:    ret i32 0
;
;
; CHECK-LABEL: define internal void @func.specialized.1(
; CHECK-SAME: ptr [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[TMP2]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = icmp slt i32 [[TMP3]], 1
; CHECK-NEXT:    br i1 [[TMP4]], label %[[BB12:.*]], label %[[BB6:.*]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP2]], align 4
; CHECK-NEXT:    [[TMP7:%.*]] = sext i32 [[TMP6]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i32, ptr [[TMP0]], i64 [[TMP7]]
; CHECK-NEXT:    call void @decrement(ptr [[TMP8]])
; CHECK-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP2]], align 4
; CHECK-NEXT:    [[TMP10:%.*]] = add nsw i32 [[TMP9]], -1
; CHECK-NEXT:    call void @func.specialized.1(ptr [[TMP0]], i32 [[TMP10]])
; CHECK-NEXT:    br label %[[BB12]]
; CHECK:       [[BB12]]:
; CHECK-NEXT:    ret void
;
;
; CHECK-LABEL: define internal void @func.specialized.2(
; CHECK-SAME: ptr [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; CHECK-NEXT:    [[TMP3:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[TMP3]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = icmp slt i32 [[TMP4]], 1
; CHECK-NEXT:    br i1 [[TMP5]], label %[[BB12:.*]], label %[[BB6:.*]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP3]], align 4
; CHECK-NEXT:    [[TMP8:%.*]] = sext i32 [[TMP7]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i32, ptr [[TMP0]], i64 [[TMP8]]
; CHECK-NEXT:    call void @increment(ptr [[TMP9]])
; CHECK-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP3]], align 4
; CHECK-NEXT:    [[TMP11:%.*]] = add nsw i32 [[TMP10]], -1
; CHECK-NEXT:    call void @func.specialized.2(ptr [[TMP0]], i32 [[TMP11]])
; CHECK-NEXT:    br label %[[BB12]]
; CHECK:       [[BB12]]:
; CHECK-NEXT:    ret void
;
;
; ONE-ITER-LABEL: define internal void @increment(
; ONE-ITER-SAME: ptr nocapture [[TMP0:%.*]]) {
; ONE-ITER-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP0]], align 4
; ONE-ITER-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP2]], 1
; ONE-ITER-NEXT:    store i32 [[TMP3]], ptr [[TMP0]], align 4
; ONE-ITER-NEXT:    ret void
;
;
; ONE-ITER-LABEL: define internal void @decrement(
; ONE-ITER-SAME: ptr nocapture [[TMP0:%.*]]) {
; ONE-ITER-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP0]], align 4
; ONE-ITER-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP2]], -1
; ONE-ITER-NEXT:    store i32 [[TMP3]], ptr [[TMP0]], align 4
; ONE-ITER-NEXT:    ret void
;
;
; ONE-ITER-LABEL: define i32 @main(
; ONE-ITER-SAME: ptr [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; ONE-ITER-NEXT:    call void @func.specialized.2(ptr [[TMP0]], i32 [[TMP1]])
; ONE-ITER-NEXT:    call void @func.specialized.1(ptr [[TMP0]], i32 0)
; ONE-ITER-NEXT:    ret i32 0
;
;
; ONE-ITER-LABEL: define internal void @func.specialized.1(
; ONE-ITER-SAME: ptr [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; ONE-ITER-NEXT:    [[TMP2:%.*]] = alloca i32, align 4
; ONE-ITER-NEXT:    store i32 [[TMP1]], ptr [[TMP2]], align 4
; ONE-ITER-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
; ONE-ITER-NEXT:    [[TMP4:%.*]] = icmp slt i32 [[TMP3]], 1
; ONE-ITER-NEXT:    br i1 [[TMP4]], label %[[BB12:.*]], label %[[BB6:.*]]
; ONE-ITER:       [[BB6]]:
; ONE-ITER-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP2]], align 4
; ONE-ITER-NEXT:    [[TMP7:%.*]] = sext i32 [[TMP6]] to i64
; ONE-ITER-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i32, ptr [[TMP0]], i64 [[TMP7]]
; ONE-ITER-NEXT:    call void @decrement(ptr [[TMP8]])
; ONE-ITER-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP2]], align 4
; ONE-ITER-NEXT:    [[TMP10:%.*]] = add nsw i32 [[TMP9]], -1
; ONE-ITER-NEXT:    call void @func.specialized.1(ptr [[TMP0]], i32 [[TMP10]])
; ONE-ITER-NEXT:    br label %[[BB12]]
; ONE-ITER:       [[BB12]]:
; ONE-ITER-NEXT:    ret void
;
;
; ONE-ITER-LABEL: define internal void @func.specialized.2(
; ONE-ITER-SAME: ptr [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; ONE-ITER-NEXT:    [[TMP3:%.*]] = alloca i32, align 4
; ONE-ITER-NEXT:    store i32 [[TMP1]], ptr [[TMP3]], align 4
; ONE-ITER-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
; ONE-ITER-NEXT:    [[TMP5:%.*]] = icmp slt i32 [[TMP4]], 1
; ONE-ITER-NEXT:    br i1 [[TMP5]], label %[[BB12:.*]], label %[[BB6:.*]]
; ONE-ITER:       [[BB6]]:
; ONE-ITER-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP3]], align 4
; ONE-ITER-NEXT:    [[TMP8:%.*]] = sext i32 [[TMP7]] to i64
; ONE-ITER-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i32, ptr [[TMP0]], i64 [[TMP8]]
; ONE-ITER-NEXT:    call void @increment(ptr [[TMP9]])
; ONE-ITER-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP3]], align 4
; ONE-ITER-NEXT:    [[TMP11:%.*]] = add nsw i32 [[TMP10]], -1
; ONE-ITER-NEXT:    call void @func.specialized.2(ptr [[TMP0]], i32 [[TMP11]])
; ONE-ITER-NEXT:    br label %[[BB12]]
; ONE-ITER:       [[BB12]]:
; ONE-ITER-NEXT:    ret void
;
;
; DISABLED-LABEL: define internal void @func(
; DISABLED-SAME: ptr [[TMP0:%.*]], i32 [[TMP1:%.*]], ptr nocapture [[TMP2:%.*]]) {
; DISABLED-NEXT:    [[TMP4:%.*]] = alloca i32, align 4
; DISABLED-NEXT:    store i32 [[TMP1]], ptr [[TMP4]], align 4
; DISABLED-NEXT:    [[TMP5:%.*]] = load i32, ptr [[TMP4]], align 4
; DISABLED-NEXT:    [[TMP6:%.*]] = icmp slt i32 [[TMP5]], 1
; DISABLED-NEXT:    br i1 [[TMP6]], label %[[BB13:.*]], label %[[BB7:.*]]
; DISABLED:       [[BB7]]:
; DISABLED-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP4]], align 4
; DISABLED-NEXT:    [[TMP9:%.*]] = sext i32 [[TMP8]] to i64
; DISABLED-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i32, ptr [[TMP0]], i64 [[TMP9]]
; DISABLED-NEXT:    call void [[TMP2]](ptr [[TMP10]])
; DISABLED-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP4]], align 4
; DISABLED-NEXT:    [[TMP12:%.*]] = add nsw i32 [[TMP11]], -1
; DISABLED-NEXT:    call void @func(ptr [[TMP0]], i32 [[TMP12]], ptr [[TMP2]])
; DISABLED-NEXT:    br label %[[BB13]]
; DISABLED:       [[BB13]]:
; DISABLED-NEXT:    ret void
;
;
; DISABLED-LABEL: define internal void @increment(
; DISABLED-SAME: ptr nocapture [[TMP0:%.*]]) {
; DISABLED-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP0]], align 4
; DISABLED-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP2]], 1
; DISABLED-NEXT:    store i32 [[TMP3]], ptr [[TMP0]], align 4
; DISABLED-NEXT:    ret void
;
;
; DISABLED-LABEL: define internal void @decrement(
; DISABLED-SAME: ptr nocapture [[TMP0:%.*]]) {
; DISABLED-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP0]], align 4
; DISABLED-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP2]], -1
; DISABLED-NEXT:    store i32 [[TMP3]], ptr [[TMP0]], align 4
; DISABLED-NEXT:    ret void
;
;
; DISABLED-LABEL: define i32 @main(
; DISABLED-SAME: ptr [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; DISABLED-NEXT:    call void @func(ptr [[TMP0]], i32 [[TMP1]], ptr nonnull @increment)
; DISABLED-NEXT:    call void @func(ptr [[TMP0]], i32 0, ptr nonnull @decrement)
; DISABLED-NEXT:    ret i32 0
;
