; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=s390x-ibm-zos | FileCheck %s

; The current function's return address is in the link register.
define ptr @rt0() norecurse nounwind readnone {
; CHECK-LABEL: rt0:
; CHECK:         lgr 3, 7
; CHECK-NEXT:    b 2(7)
entry:
  %0 = tail call ptr @llvm.returnaddress(i32 0)
  ret ptr %0
}

; Check the caller's return address.
define ptr @rtcaller() nounwind "backchain" {
; CHECK-LABEL: rtcaller:
; CHECK:         stmg 4, 7, 2048(4)
; CHECK-NEXT:    lg 1, 2048(4)
; CHECK-NEXT:    lg 3, 24(1)
; CHECK-NEXT:    lmg 4, 7, 2048(4)
; CHECK-NEXT:    b 2(7)
entry:
  %0 = tail call ptr @llvm.returnaddress(i32 1)
  ret ptr %0
}

; Check the caller's caller's return address.
define ptr @rtcallercaller() nounwind "backchain" {
; CHECK-LABEL: rtcallercaller:
; CHECK:         stmg 4, 7, 2048(4)
; CHECK-NEXT:    lg 1, 2048(4)
; CHECK-NEXT:    lg 1, 0(1)
; CHECK-NEXT:    lg 3, 24(1)
; CHECK-NEXT:    lmg 4, 7, 2048(4)
; CHECK-NEXT:    b 2(7)
entry:
  %0 = tail call ptr @llvm.returnaddress(i32 2)
  ret ptr %0
}

declare ptr @llvm.returnaddress(i32) nounwind readnone
