; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -fast-isel -fast-isel-abort=3 -mtriple=x86_64-unknown-unknown -mattr=-sse4.2,+crc32 --show-mc-encoding | FileCheck %s
; RUN: llc < %s -fast-isel -fast-isel-abort=3 -mtriple=x86_64-unknown-unknown -mattr=+crc32 --show-mc-encoding | FileCheck %s
; RUN: llc < %s -fast-isel -fast-isel-abort=3 -mtriple=x86_64-unknown-unknown -mattr=+crc32,+egpr --show-mc-encoding | FileCheck %s -check-prefix=EGPR

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/sse42-builtins.c

; Note: %a1 is i32 as FastISel can't handle i8/i16 arguments.
define i64 @test_mm_crc64_u8(i64 %a0, i32 %a1) nounwind{
; CHECK-LABEL: test_mm_crc64_u8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    crc32b %sil, %edi # encoding: [0xf2,0x40,0x0f,0x38,0xf0,0xfe]
; CHECK-NEXT:    movl %edi, %eax # encoding: [0x89,0xf8]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; EGPR-LABEL: test_mm_crc64_u8:
; EGPR:       # %bb.0:
; EGPR-NEXT:    crc32b %sil, %edi # EVEX TO LEGACY Compression encoding: [0xf2,0x40,0x0f,0x38,0xf0,0xfe]
; EGPR-NEXT:    movl %edi, %eax # encoding: [0x89,0xf8]
; EGPR-NEXT:    retq # encoding: [0xc3]
  %trunc = trunc i32 %a1 to i8
  %res = call i64 @llvm.x86.sse42.crc32.64.8(i64 %a0, i8 %trunc)
  ret i64 %res
}
declare i64 @llvm.x86.sse42.crc32.64.8(i64, i8) nounwind readnone

define i64 @test_mm_crc64_u64(i64 %a0, i64 %a1) nounwind{
; CHECK-LABEL: test_mm_crc64_u64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rdi, %rax # encoding: [0x48,0x89,0xf8]
; CHECK-NEXT:    crc32q %rsi, %rax # encoding: [0xf2,0x48,0x0f,0x38,0xf1,0xc6]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; EGPR-LABEL: test_mm_crc64_u64:
; EGPR:       # %bb.0:
; EGPR-NEXT:    movq %rdi, %rax # encoding: [0x48,0x89,0xf8]
; EGPR-NEXT:    crc32q %rsi, %rax # EVEX TO LEGACY Compression encoding: [0xf2,0x48,0x0f,0x38,0xf1,0xc6]
; EGPR-NEXT:    retq # encoding: [0xc3]
  %res = call i64 @llvm.x86.sse42.crc32.64.64(i64 %a0, i64 %a1)
  ret i64 %res
}
declare i64 @llvm.x86.sse42.crc32.64.64(i64, i64) nounwind readnone
