; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr="+wavefrontsize64" -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1100 -mattr="+wavefrontsize64" -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9,GFX9-SDAG %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9,GFX9-GISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefixes=VI-SDAG %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefixes=VI-GISEL %s

declare i64 @llvm.amdgcn.fcmp.f32(float, float, i32) #0
declare i64 @llvm.amdgcn.fcmp.f64(double, double, i32) #0
declare float @llvm.fabs.f32(float) #0

declare i64 @llvm.amdgcn.fcmp.f16(half, half, i32) #0
declare half @llvm.fabs.f16(half) #0

define amdgpu_kernel void @v_fcmp_f32_oeq_with_fabs(ptr addrspace(1) %out, float %src, float %a) {
; GFX11-LABEL: v_fcmp_f32_oeq_with_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_f32_e64 s[2:3], s2, |s3|
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_oeq_with_fabs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_cmp_eq_f32_e64 s[0:1], s6, |v0|
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_oeq_with_fabs:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s3
; VI-SDAG-NEXT:    v_cmp_eq_f32_e64 s[2:3], s2, |v0|
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_oeq_with_fabs:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s3
; VI-GISEL-NEXT:    v_cmp_eq_f32_e64 s[2:3], s2, |v0|
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %temp = call float @llvm.fabs.f32(float %a)
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float %temp, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_oeq_both_operands_with_fabs(ptr addrspace(1) %out, float %src, float %a) {
; GFX11-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_f32_e64 s[2:3], |s2|, |s3|
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_cmp_eq_f32_e64 s[0:1], |s6|, |v0|
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s3
; VI-SDAG-NEXT:    v_cmp_eq_f32_e64 s[2:3], |s2|, |v0|
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s3
; VI-GISEL-NEXT:    v_cmp_eq_f32_e64 s[2:3], |s2|, |v0|
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %temp = call float @llvm.fabs.f32(float %a)
  %src_input = call float @llvm.fabs.f32(float %src)
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src_input, float %temp, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32(ptr addrspace(1) %out, float %src) {
; GFX11-SDAG-LABEL: v_fcmp_f32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_fcmp_f32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_fcmp_f32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_fcmp_f32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 -1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_oeq(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_oeq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_oeq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_oeq:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_eq_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_oeq:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_eq_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_one(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_one:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_one:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_neq_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_one:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_neq_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_one:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_neq_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 6)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ogt(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ogt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ogt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_ogt:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_gt_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_ogt:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_gt_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 2)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_oge(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_oge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_oge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ge_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_oge:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_ge_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_oge:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_ge_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 3)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_olt(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_olt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_olt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_olt:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_lt_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_olt:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_lt_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 4)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ole(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ole:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ole:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_le_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_ole:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_le_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_ole:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_le_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 5)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_o(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_o:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_o_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_o:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_o_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_o:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_o_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_o:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_o_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 7)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_uo(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_uo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_u_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_uo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_u_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_uo:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_u_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_uo:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_u_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 8)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ueq(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ueq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlg_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ueq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlg_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_ueq:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nlg_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_ueq:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nlg_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 9)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_une(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_une:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_une:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_neq_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_une:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_neq_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_une:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_neq_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 14)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ugt(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ugt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nge_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ugt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nle_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_ugt:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nle_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_ugt:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nle_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 10)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_uge(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_uge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ngt_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_uge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_uge:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nlt_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_uge:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nlt_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 11)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ult(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ult:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nle_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ult:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nge_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_ult:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nge_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_ult:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nge_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 12)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ule(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ule:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlt_f32_e64 s[2:3], 0x42c80000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ule:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f32_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f32_ule:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_ngt_f32_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f32_ule:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_ngt_f32_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 13)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_oeq(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_oeq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_oeq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_oeq:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_eq_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_oeq:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_eq_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_one(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_one:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_one:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_neq_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_one:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_one:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 6)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ogt(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ogt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_ogt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_ogt:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_gt_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_ogt:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_gt_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 2)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_oge(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_oge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_oge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ge_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_oge:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_ge_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_oge:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_ge_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 3)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_olt(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_olt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_olt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_olt:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_lt_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_olt:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_lt_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 4)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ole(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ole:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_ole:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_le_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_ole:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_le_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_ole:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_le_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 5)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ueq(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ueq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlg_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_ueq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlg_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_ueq:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nlg_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_ueq:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nlg_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 9)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_o(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_o:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_o_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_o:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_o_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_o:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_o_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_o:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_o_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 7)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_uo(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_uo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_u_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_uo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_u_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_uo:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_u_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_uo:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_u_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 8)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_une(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_une:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_une:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_neq_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_une:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_une:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 14)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ugt(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ugt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nge_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_ugt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nle_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_ugt:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nle_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_ugt:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nle_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 10)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_uge(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_uge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ngt_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_uge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_uge:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nlt_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_uge:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nlt_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 11)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ult(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ult:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nle_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_ult:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nge_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_ult:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nge_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_ult:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nge_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 12)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ule(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ule:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlt_f64_e64 s[2:3], 0x40590000, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f64_ule:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f64_e64 s[0:1], s[6:7], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f64_ule:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_ngt_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f64_ule:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40590000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_ngt_f64_e64 s[2:3], s[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 13)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oeq_with_fabs(ptr addrspace(1) %out, half %src, half %a) {
; GFX11-LABEL: v_fcmp_f16_oeq_with_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s2, s4, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_f16_e64 s[2:3], s4, |s2|
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_oeq_with_fabs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_cmp_eq_f16_e64 s[2:3], s4, |v0|
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_oeq_with_fabs:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_lshr_b32 s2, s4, 16
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; VI-SDAG-NEXT:    v_cmp_eq_f16_e64 s[2:3], s4, |v0|
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_oeq_with_fabs:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_lshr_b32 s2, s4, 16
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_cmp_eq_f16_e64 s[2:3], s4, |v0|
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %temp = call half @llvm.fabs.f16(half %a)
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half %temp, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oeq_both_operands_with_fabs(ptr addrspace(1) %out, half %src, half %a) {
; GFX11-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s2, s4, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_f16_e64 s[2:3], |s4|, |s2|
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_cmp_eq_f16_e64 s[2:3], |s4|, |v0|
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_lshr_b32 s2, s4, 16
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; VI-SDAG-NEXT:    v_cmp_eq_f16_e64 s[2:3], |s4|, |v0|
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_lshr_b32 s2, s4, 16
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_cmp_eq_f16_e64 s[2:3], |s4|, |v0|
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %temp = call half @llvm.fabs.f16(half %a)
  %src_input = call half @llvm.fabs.f16(half %src)
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src_input, half %temp, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f16(ptr addrspace(1) %out, half %src) {
; GFX11-SDAG-LABEL: v_fcmp_f16:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_fcmp_f16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_fcmp_f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_fcmp_f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 -1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oeq(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_oeq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_oeq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_oeq:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_eq_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_oeq:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_eq_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_one(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_one:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_one:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_neq_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_one:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_neq_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_one:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_neq_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 6)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ogt(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ogt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ogt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_ogt:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_gt_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_ogt:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_gt_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 2)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oge(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_oge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_oge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ge_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_oge:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_ge_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_oge:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_ge_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 3)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_olt(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_olt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_olt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_olt:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_lt_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_olt:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_lt_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 4)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ole(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ole:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ole:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_le_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_ole:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_le_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_ole:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_le_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 5)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ueq(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ueq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlg_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ueq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlg_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_ueq:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nlg_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_ueq:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nlg_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 9)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_une(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_une:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_une:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_neq_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_une:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_neq_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_une:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_neq_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 14)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ugt(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ugt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nge_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ugt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nle_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_ugt:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nle_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_ugt:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nle_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 10)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_uge(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_uge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ngt_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_uge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_uge:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nlt_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_uge:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nlt_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 11)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ult(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ult:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nle_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ult:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nge_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_ult:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_nge_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_ult:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_nge_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 12)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f16_o(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_o:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_o_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_o:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_o_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_o:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_o_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_o:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_o_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 7)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f16_uo(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_uo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_u_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_uo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_u_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_uo:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_u_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_uo:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_u_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 8)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f16_ule(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ule:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlt_f16_e64 s[2:3], 0x5640, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ule:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f16_e64 s[2:3], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_fcmp_f16_ule:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_cmp_ngt_f16_e64 s[2:3], s4, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, s3
; VI-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_fcmp_f16_ule:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, 0x5640
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cmp_ngt_f16_e64 s[2:3], s4, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; VI-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 13)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

attributes #0 = { nounwind readnone convergent }
