; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-none-elf -verify-machineinstrs %s -o - | FileCheck %s

define i32 @from_cmpeq(i32 %xx, i32 %y) {
; CHECK-LABEL: from_cmpeq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w1, #0x1
; CHECK-NEXT:    cmp w0, #9
; CHECK-NEXT:    csel w0, w8, wzr, eq
; CHECK-NEXT:    ret
  %x = icmp eq i32 %xx, 9
  %masked = and i32 %y, 1

  %r = select i1 %x, i32 %masked, i32 0
  ret i32 %r
}

define i32 @from_cmpeq_fail_bad_andmask(i32 %xx, i32 %y) {
; CHECK-LABEL: from_cmpeq_fail_bad_andmask:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w1, #0x3
; CHECK-NEXT:    cmp w0, #9
; CHECK-NEXT:    csel w0, w8, wzr, eq
; CHECK-NEXT:    ret
  %x = icmp eq i32 %xx, 9
  %masked = and i32 %y, 3
  %r = select i1 %x, i32 %masked, i32 0
  ret i32 %r
}

define i32 @from_i1(i1 %x, i32 %y) {
; CHECK-LABEL: from_i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, w1
; CHECK-NEXT:    and w0, w8, #0x1
; CHECK-NEXT:    ret
  %masked = and i32 %y, 1
  %r = select i1 %x, i32 %masked, i32 0
  ret i32 %r
}

define i32 @from_trunc_i8(i8 %xx, i32 %y) {
; CHECK-LABEL: from_trunc_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, w1
; CHECK-NEXT:    and w0, w8, #0x1
; CHECK-NEXT:    ret
  %masked = and i32 %y, 1
  %x = trunc i8 %xx to i1
  %r = select i1 %x, i32 %masked, i32 0
  ret i32 %r
}

define i32 @from_trunc_i64(i64 %xx, i32 %y) {
; CHECK-LABEL: from_trunc_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, w1
; CHECK-NEXT:    and w0, w8, #0x1
; CHECK-NEXT:    ret
  %masked = and i32 %y, 1
  %x = trunc i64 %xx to i1
  %r = select i1 %x, i32 %masked, i32 0
  ret i32 %r
}

define i32 @from_i1_fail_bad_select0(i1 %x, i32 %y) {
; CHECK-LABEL: from_i1_fail_bad_select0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w1, #0x1
; CHECK-NEXT:    tst w0, #0x1
; CHECK-NEXT:    csinc w0, w8, wzr, ne
; CHECK-NEXT:    ret
  %masked = and i32 %y, 1
  %r = select i1 %x, i32 %masked, i32 1
  ret i32 %r
}

define i32 @from_i1_fail_bad_select1(i1 %x, i32 %y) {
; CHECK-LABEL: from_i1_fail_bad_select1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w1, #0x1
; CHECK-NEXT:    tst w0, #0x1
; CHECK-NEXT:    csel w0, wzr, w8, ne
; CHECK-NEXT:    ret
  %masked = and i32 %y, 1
  %r = select i1 %x, i32 0, i32 %masked
  ret i32 %r
}
