// RUN: llvm-mc -arch=amdgcn -show-encoding -mcpu=gfx1200 %s | FileCheck --check-prefix=GFX12 %s

s_add_i32 s0, s1, s2
// GFX12: encoding: [0x01,0x02,0x00,0x81]

s_add_u32 s0, s1, s2
// GFX12: encoding: [0x01,0x02,0x00,0x80]

s_add_u64 s[0:1], s[2:3], s[4:5]
// GFX12: encoding: [0x02,0x04,0x80,0xa9]

s_addc_u32 s0, s1, s2
// GFX12: encoding: [0x01,0x02,0x00,0x82]

s_sub_i32 s0, s1, s2
// GFX12: encoding: [0x01,0x02,0x80,0x81]

s_sub_u32 s0, s1, s2
// GFX12: encoding: [0x01,0x02,0x80,0x80]

s_sub_u64 s[0:1], s[2:3], s[4:5]
// GFX12: encoding: [0x02,0x04,0x00,0xaa]

s_subb_u32 s0, s1, s2
// GFX12: encoding: [0x01,0x02,0x80,0x82]

s_min_f32 s5, s1, s2
// GFX12: encoding: [0x01,0x02,0x05,0xa1]

s_min_f32 s105, s1, s2
// GFX12: encoding: [0x01,0x02,0x69,0xa1]

s_min_f32 s5, s105, s2
// GFX12: encoding: [0x69,0x02,0x05,0xa1]

s_min_f32 s5, s103, s2
// GFX12: encoding: [0x67,0x02,0x05,0xa1]

s_min_f32 s5, vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x05,0xa1]

s_min_f32 s5, vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x05,0xa1]

s_min_f32 s5, ttmp11, s2
// GFX12: encoding: [0x77,0x02,0x05,0xa1]

s_min_f32 s5, m0, s2
// GFX12: encoding: [0x7d,0x02,0x05,0xa1]

s_min_f32 s5, exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x05,0xa1]

s_min_f32 s5, exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x05,0xa1]

s_min_f32 s5, 0, s2
// GFX12: encoding: [0x80,0x02,0x05,0xa1]

s_min_f32 s5, -1, s2
// GFX12: encoding: [0xc1,0x02,0x05,0xa1]

s_min_f32 s5, 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x05,0xa1]

s_min_f32 s5, -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x05,0xa1]

s_min_f32 s5, 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x05,0xa1,0x56,0x34,0x12,0xaf]

s_min_f32 s5, 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x05,0xa1,0x73,0x72,0x71,0x3f]

s_min_f32 s5, s1, s105
// GFX12: encoding: [0x01,0x69,0x05,0xa1]

s_max_f32 s5, s1, s2
// GFX12: encoding: [0x01,0x02,0x85,0xa1]

s_max_f32 s105, s1, s2
// GFX12: encoding: [0x01,0x02,0xe9,0xa1]

s_max_f32 s5, s105, s2
// GFX12: encoding: [0x69,0x02,0x85,0xa1]

s_max_f32 s5, s103, s2
// GFX12: encoding: [0x67,0x02,0x85,0xa1]

s_max_f32 s5, vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x85,0xa1]

s_max_f32 s5, vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x85,0xa1]

s_max_f32 s5, ttmp11, s2
// GFX12: encoding: [0x77,0x02,0x85,0xa1]

s_max_f32 s5, m0, s2
// GFX12: encoding: [0x7d,0x02,0x85,0xa1]

s_max_f32 s5, exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x85,0xa1]

s_max_f32 s5, exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x85,0xa1]

s_max_f32 s5, 0, s2
// GFX12: encoding: [0x80,0x02,0x85,0xa1]

s_max_f32 s5, -1, s2
// GFX12: encoding: [0xc1,0x02,0x85,0xa1]

s_max_f32 s5, 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x85,0xa1]

s_max_f32 s5, -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x85,0xa1]

s_max_f32 s5, 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x85,0xa1,0x56,0x34,0x12,0xaf]

s_max_f32 s5, 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x85,0xa1,0x73,0x72,0x71,0x3f]

s_max_f32 s5, s1, s105
// GFX12: encoding: [0x01,0x69,0x85,0xa1]

s_max_f16 s5, s1, s2
// GFX12: encoding: [0x01,0x02,0x05,0xa6]

s_max_f16 s105, s1, s2
// GFX12: encoding: [0x01,0x02,0x69,0xa6]

s_max_f16 s5, s105, s2
// GFX12: encoding: [0x69,0x02,0x05,0xa6]

s_max_f16 s5, s101, s2
// GFX12: encoding: [0x65,0x02,0x05,0xa6]

s_max_f16 s5, vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x05,0xa6]

s_max_f16 s5, vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x05,0xa6]

s_max_f16 s5, m0, s2
// GFX12: encoding: [0x7d,0x02,0x05,0xa6]

s_max_f16 s5, exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x05,0xa6]

s_max_f16 s5, exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x05,0xa6]

s_max_f16 s5, 0, s2
// GFX12: encoding: [0x80,0x02,0x05,0xa6]

s_max_f16 s5, -1, s2
// GFX12: encoding: [0xc1,0x02,0x05,0xa6]

s_max_f16 s5, 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x05,0xa6]

s_max_f16 s5, -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x05,0xa6]

s_max_f16 s5, 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x05,0xa6,0x0b,0xfe,0x00,0x00]

s_max_f16 s5, 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x05,0xa6,0x56,0x34,0x00,0x00]

s_max_f16 s5, s1, s105
// GFX12: encoding: [0x01,0x69,0x05,0xa6]

s_min_f16 s5, s1, s2
// GFX12: encoding: [0x01,0x02,0x85,0xa5]

s_min_f16 s105, s1, s2
// GFX12: encoding: [0x01,0x02,0xe9,0xa5]

s_min_f16 s5, s105, s2
// GFX12: encoding: [0x69,0x02,0x85,0xa5]

s_min_f16 s5, s101, s2
// GFX12: encoding: [0x65,0x02,0x85,0xa5]

s_min_f16 s5, vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x85,0xa5]

s_min_f16 s5, vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x85,0xa5]

s_min_f16 s5, m0, s2
// GFX12: encoding: [0x7d,0x02,0x85,0xa5]

s_min_f16 s5, exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x85,0xa5]

s_min_f16 s5, exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x85,0xa5]

s_min_f16 s5, 0, s2
// GFX12: encoding: [0x80,0x02,0x85,0xa5]

s_min_f16 s5, -1, s2
// GFX12: encoding: [0xc1,0x02,0x85,0xa5]

s_min_f16 s5, 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x85,0xa5]

s_min_f16 s5, -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x85,0xa5]

s_min_f16 s5, 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x85,0xa5,0x0b,0xfe,0x00,0x00]

s_min_f16 s5, 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x85,0xa5,0x56,0x34,0x00,0x00]

s_min_f16 s5, s1, s105
// GFX12: encoding: [0x01,0x69,0x85,0xa5]
