; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs --show-mc-encoding | FileCheck %s

define i8 @sub8rr(i8 noundef %a, i8 noundef %b) {
; CHECK-LABEL: sub8rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subb %sil, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x28,0xf7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = sub i8 %a, %b
    ret i8 %sub
}

define i16 @sub16rr(i16 noundef %a, i16 noundef %b) {
; CHECK-LABEL: sub16rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl %esi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x29,0xf7]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = sub i16 %a, %b
    ret i16 %sub
}

define i32 @sub32rr(i32 noundef %a, i32 noundef %b) {
; CHECK-LABEL: sub32rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl %esi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x29,0xf7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = sub i32 %a, %b
    ret i32 %sub
}

define i64 @sub64rr(i64 noundef %a, i64 noundef %b) {
; CHECK-LABEL: sub64rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq %rsi, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x29,0xf7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = sub i64 %a, %b
    ret i64 %sub
}

define i8 @sub8rm(i8 noundef %a, ptr %ptr) {
; CHECK-LABEL: sub8rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subb (%rsi), %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x2a,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %b = load i8, ptr %ptr
    %sub = sub i8 %a, %b
    ret i8 %sub
}

define i16 @sub16rm(i16 noundef %a, ptr %ptr) {
; CHECK-LABEL: sub16rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subw (%rsi), %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x2b,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %b = load i16, ptr %ptr
    %sub = sub i16 %a, %b
    ret i16 %sub
}

define i32 @sub32rm(i32 noundef %a, ptr %ptr) {
; CHECK-LABEL: sub32rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl (%rsi), %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x2b,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %b = load i32, ptr %ptr
    %sub = sub i32 %a, %b
    ret i32 %sub
}

define i64 @sub64rm(i64 noundef %a, ptr %ptr) {
; CHECK-LABEL: sub64rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq (%rsi), %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x2b,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %b = load i64, ptr %ptr
    %sub = sub i64 %a, %b
    ret i64 %sub
}

define i16 @sub16ri8(i16 noundef %a) {
; CHECK-LABEL: sub16ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-123, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xc7,0x85,0xff,0xff,0xff]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = sub i16 %a, 123
    ret i16 %sub
}

define i32 @sub32ri8(i32 noundef %a) {
; CHECK-LABEL: sub32ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-123, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xc7,0x85,0xff,0xff,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = sub i32 %a, 123
    ret i32 %sub
}

define i64 @sub64ri8(i64 noundef %a) {
; CHECK-LABEL: sub64ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $-123, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x81,0xc7,0x85,0xff,0xff,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = sub i64 %a, 123
    ret i64 %sub
}

define i8 @sub8ri(i8 noundef %a) {
; CHECK-LABEL: sub8ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb $-123, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x80,0xc7,0x85]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = sub i8 %a, 123
    ret i8 %sub
}

define i16 @sub16ri(i16 noundef %a) {
; CHECK-LABEL: sub16ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-1234, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xc7,0x2e,0xfb,0xff,0xff]
; CHECK-NEXT:    # imm = 0xFB2E
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = sub i16 %a, 1234
    ret i16 %sub
}

define i32 @sub32ri(i32 noundef %a) {
; CHECK-LABEL: sub32ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-123456, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xc7,0xc0,0x1d,0xfe,0xff]
; CHECK-NEXT:    # imm = 0xFFFE1DC0
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = sub i32 %a, 123456
    ret i32 %sub
}

define i64 @sub64ri(i64 noundef %a) {
; CHECK-LABEL: sub64ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $-123456, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x81,0xc7,0xc0,0x1d,0xfe,0xff]
; CHECK-NEXT:    # imm = 0xFFFE1DC0
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = sub i64 %a, 123456
    ret i64 %sub
}

define i8 @sub8mr(ptr %a, i8 noundef %b) {
; CHECK-LABEL: sub8mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subb %sil, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0x28,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %sub = sub nsw i8 %t, %b
  ret i8 %sub
}

define i16 @sub16mr(ptr %a, i16 noundef %b) {
; CHECK-LABEL: sub16mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movzwl (%rdi), %eax # encoding: [0x0f,0xb7,0x07]
; CHECK-NEXT:    subl %esi, %eax # EVEX TO LEGACY Compression encoding: [0x29,0xf0]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %sub = sub nsw i16 %t, %b
  ret i16 %sub
}

define i32 @sub32mr(ptr %a, i32 noundef %b) {
; CHECK-LABEL: sub32mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl %esi, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0x29,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %sub = sub nsw i32 %t, %b
  ret i32 %sub
}

define i64 @sub64mr(ptr %a, i64 noundef %b) {
; CHECK-LABEL: sub64mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq %rsi, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0x29,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %sub = sub nsw i64 %t, %b
  ret i64 %sub
}

define i16 @sub16mi8(ptr %a) {
; CHECK-LABEL: sub16mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movzwl (%rdi), %eax # encoding: [0x0f,0xb7,0x07]
; CHECK-NEXT:    addl $-123, %eax # EVEX TO LEGACY Compression encoding: [0x83,0xc0,0x85]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %sub = sub nsw i16 %t, 123
  ret i16 %sub
}

define i32 @sub32mi8(ptr %a) {
; CHECK-LABEL: sub32mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-123, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0x07,0x85,0xff,0xff,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %sub = sub nsw i32 %t, 123
  ret i32 %sub
}

define i64 @sub64mi8(ptr %a) {
; CHECK-LABEL: sub64mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $-123, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0x81,0x07,0x85,0xff,0xff,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %sub = sub nsw i64 %t, 123
  ret i64 %sub
}

define i8 @sub8mi(ptr %a) {
; CHECK-LABEL: sub8mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb $-123, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0x80,0x07,0x85]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %sub = sub nsw i8 %t, 123
  ret i8 %sub
}

define i16 @sub16mi(ptr %a) {
; CHECK-LABEL: sub16mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movzwl (%rdi), %eax # encoding: [0x0f,0xb7,0x07]
; CHECK-NEXT:    addl $-1234, %eax # EVEX TO LEGACY Compression encoding: [0x05,0x2e,0xfb,0xff,0xff]
; CHECK-NEXT:    # imm = 0xFB2E
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %sub = sub nsw i16 %t, 1234
  ret i16 %sub
}

define i32 @sub32mi(ptr %a) {
; CHECK-LABEL: sub32mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-123456, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0x07,0xc0,0x1d,0xfe,0xff]
; CHECK-NEXT:    # imm = 0xFFFE1DC0
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %sub = sub nsw i32 %t, 123456
  ret i32 %sub
}

define i64 @sub64mi(ptr %a) {
; CHECK-LABEL: sub64mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $-123456, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0x81,0x07,0xc0,0x1d,0xfe,0xff]
; CHECK-NEXT:    # imm = 0xFFFE1DC0
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %sub = sub nsw i64 %t, 123456
  ret i64 %sub
}

declare i8 @llvm.usub.sat.i8(i8, i8)
declare i16 @llvm.usub.sat.i16(i16, i16)
declare i32 @llvm.usub.sat.i32(i32, i32)
declare i64 @llvm.usub.sat.i64(i64, i64)

define i8 @subflag8rr(i8 noundef %a, i8 noundef %b) {
; CHECK-LABEL: subflag8rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %ecx, %ecx # encoding: [0x31,0xc9]
; CHECK-NEXT:    subb %sil, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x28,0xf7]
; CHECK-NEXT:    movzbl %al, %eax # encoding: [0x0f,0xb6,0xc0]
; CHECK-NEXT:    cmovbl %ecx, %eax # encoding: [0x0f,0x42,0xc1]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = call i8 @llvm.usub.sat.i8(i8 %a, i8 %b)
    ret i8 %sub
}

define i16 @subflag16rr(i16 noundef %a, i16 noundef %b) {
; CHECK-LABEL: subflag16rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %ecx, %ecx # encoding: [0x31,0xc9]
; CHECK-NEXT:    subw %si, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x29,0xf7]
; CHECK-NEXT:    cmovbl %ecx, %eax # encoding: [0x0f,0x42,0xc1]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = call i16 @llvm.usub.sat.i16(i16 %a, i16 %b)
    ret i16 %sub
}

define i32 @subflag32rr(i32 noundef %a, i32 noundef %b) {
; CHECK-LABEL: subflag32rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %ecx, %ecx # encoding: [0x31,0xc9]
; CHECK-NEXT:    subl %esi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x29,0xf7]
; CHECK-NEXT:    cmovbl %ecx, %eax # encoding: [0x0f,0x42,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = call i32 @llvm.usub.sat.i32(i32 %a, i32 %b)
    ret i32 %sub
}

define i64 @subflag64rr(i64 noundef %a, i64 noundef %b) {
; CHECK-LABEL: subflag64rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    subq %rsi, %rdi, %rcx # encoding: [0x62,0xf4,0xf4,0x18,0x29,0xf7]
; CHECK-NEXT:    cmovaeq %rcx, %rax # encoding: [0x48,0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = call i64 @llvm.usub.sat.i64(i64 %a, i64 %b)
    ret i64 %sub
}

define i8 @subflag8rm(i8 noundef %a, ptr %b) {
; CHECK-LABEL: subflag8rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %ecx, %ecx # encoding: [0x31,0xc9]
; CHECK-NEXT:    subb (%rsi), %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x2a,0x3e]
; CHECK-NEXT:    movzbl %al, %eax # encoding: [0x0f,0xb6,0xc0]
; CHECK-NEXT:    cmovbl %ecx, %eax # encoding: [0x0f,0x42,0xc1]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i8, ptr %b
    %sub = call i8 @llvm.usub.sat.i8(i8 %a, i8 %t)
    ret i8 %sub
}

define i16 @subflag16rm(i16 noundef %a, ptr %b) {
; CHECK-LABEL: subflag16rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %ecx, %ecx # encoding: [0x31,0xc9]
; CHECK-NEXT:    subw (%rsi), %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x2b,0x3e]
; CHECK-NEXT:    cmovbl %ecx, %eax # encoding: [0x0f,0x42,0xc1]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i16, ptr %b
    %sub = call i16 @llvm.usub.sat.i16(i16 %a, i16 %t)
    ret i16 %sub
}

define i32 @subflag32rm(i32 noundef %a, ptr %b) {
; CHECK-LABEL: subflag32rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %ecx, %ecx # encoding: [0x31,0xc9]
; CHECK-NEXT:    subl (%rsi), %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x2b,0x3e]
; CHECK-NEXT:    cmovbl %ecx, %eax # encoding: [0x0f,0x42,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i32, ptr %b
    %sub = call i32 @llvm.usub.sat.i32(i32 %a, i32 %t)
    ret i32 %sub
}

define i64 @subflag64rm(i64 noundef %a, ptr %b) {
; CHECK-LABEL: subflag64rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    subq (%rsi), %rdi, %rcx # encoding: [0x62,0xf4,0xf4,0x18,0x2b,0x3e]
; CHECK-NEXT:    cmovaeq %rcx, %rax # encoding: [0x48,0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i64, ptr %b
    %sub = call i64 @llvm.usub.sat.i64(i64 %a, i64 %t)
    ret i64 %sub
}

define i16 @subflag16ri8(i16 noundef %a) {
; CHECK-LABEL: subflag16ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %ecx, %ecx # encoding: [0x31,0xc9]
; CHECK-NEXT:    subw $123, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x81,0xef,0x7b,0x00]
; CHECK-NEXT:    cmovbl %ecx, %eax # encoding: [0x0f,0x42,0xc1]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = call i16 @llvm.usub.sat.i16(i16 %a, i16 123)
    ret i16 %sub
}

define i32 @subflag32ri8(i32 noundef %a) {
; CHECK-LABEL: subflag32ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %ecx, %ecx # encoding: [0x31,0xc9]
; CHECK-NEXT:    subl $123, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xef,0x7b,0x00,0x00,0x00]
; CHECK-NEXT:    cmovbl %ecx, %eax # encoding: [0x0f,0x42,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = call i32 @llvm.usub.sat.i32(i32 %a, i32 123)
    ret i32 %sub
}

define i64 @subflag64ri8(i64 noundef %a) {
; CHECK-LABEL: subflag64ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    subq $123, %rdi, %rcx # encoding: [0x62,0xf4,0xf4,0x18,0x81,0xef,0x7b,0x00,0x00,0x00]
; CHECK-NEXT:    cmovaeq %rcx, %rax # encoding: [0x48,0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = call i64 @llvm.usub.sat.i64(i64 %a, i64 123)
    ret i64 %sub
}

define i8 @subflag8ri(i8 noundef %a) {
; CHECK-LABEL: subflag8ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %ecx, %ecx # encoding: [0x31,0xc9]
; CHECK-NEXT:    subb $123, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x80,0xef,0x7b]
; CHECK-NEXT:    movzbl %al, %eax # encoding: [0x0f,0xb6,0xc0]
; CHECK-NEXT:    cmovbl %ecx, %eax # encoding: [0x0f,0x42,0xc1]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = call i8 @llvm.usub.sat.i8(i8 %a, i8 123)
    ret i8 %sub
}

define i16 @subflag16ri(i16 noundef %a) {
; CHECK-LABEL: subflag16ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %ecx, %ecx # encoding: [0x31,0xc9]
; CHECK-NEXT:    subw $1234, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x81,0xef,0xd2,0x04]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    cmovbl %ecx, %eax # encoding: [0x0f,0x42,0xc1]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = call i16 @llvm.usub.sat.i16(i16 %a, i16 1234)
    ret i16 %sub
}

define i32 @subflag32ri(i32 noundef %a) {
; CHECK-LABEL: subflag32ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %ecx, %ecx # encoding: [0x31,0xc9]
; CHECK-NEXT:    subl $123456, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xef,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    cmovbl %ecx, %eax # encoding: [0x0f,0x42,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = call i32 @llvm.usub.sat.i32(i32 %a, i32 123456)
    ret i32 %sub
}

define i64 @subflag64ri(i64 noundef %a) {
; CHECK-LABEL: subflag64ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    subq $123456, %rdi, %rcx # encoding: [0x62,0xf4,0xf4,0x18,0x81,0xef,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    cmovaeq %rcx, %rax # encoding: [0x48,0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %sub = call i64 @llvm.usub.sat.i64(i64 %a, i64 123456)
    ret i64 %sub
}

@val = external hidden global i8

declare void @f()

define void @sub64ri_reloc(i64 %val) {
; CHECK-LABEL: sub64ri_reloc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    subq $val, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x81,0xef,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 6, value: val, kind: reloc_signed_4byte
; CHECK-NEXT:    jbe .LBB41_2 # encoding: [0x76,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB41_2-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %t
; CHECK-NEXT:    pushq %rax # encoding: [0x50]
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    callq f@PLT # encoding: [0xe8,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: f@PLT-4, kind: FK_PCRel_4
; CHECK-NEXT:    popq %rax # encoding: [0x58]
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:  .LBB41_2: # %f
; CHECK-NEXT:    retq # encoding: [0xc3]
  %cmp = icmp ugt i64 %val, ptrtoint (ptr @val to i64)
  br i1 %cmp, label %t, label %f

t:
  call void @f()
  ret void

f:
  ret void
}

define void @sub8mr_legacy(ptr %a, i8 noundef %b) {
; CHECK-LABEL: sub8mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subb %sil, (%rdi) # encoding: [0x40,0x28,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %sub = sub i8 %t, %b
  store i8 %sub, ptr %a
  ret void
}

define void @sub16mr_legacy(ptr %a, i16 noundef %b) {
; CHECK-LABEL: sub16mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subw %si, (%rdi) # encoding: [0x66,0x29,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %sub = sub i16 %t, %b
  store i16 %sub, ptr %a
  ret void
}

define void @sub32mr_legacy(ptr %a, i32 noundef %b) {
; CHECK-LABEL: sub32mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl %esi, (%rdi) # encoding: [0x29,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %sub = sub i32 %t, %b
  store i32 %sub, ptr %a
  ret void
}

define void @sub64mr_legacy(ptr %a, i64 noundef %b) {
; CHECK-LABEL: sub64mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq %rsi, (%rdi) # encoding: [0x48,0x29,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %sub = sub i64 %t, %b
  store i64 %sub, ptr %a
  ret void
}

define void @sub8mi_legacy(ptr %a) {
; CHECK-LABEL: sub8mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb $-123, (%rdi) # encoding: [0x80,0x07,0x85]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %sub = sub nsw i8 %t, 123
  store i8 %sub, ptr %a
  ret void
}

define void @sub16mi_legacy(ptr %a) {
; CHECK-LABEL: sub16mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $-1234, (%rdi) # encoding: [0x66,0x81,0x07,0x2e,0xfb]
; CHECK-NEXT:    # imm = 0xFB2E
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %sub = sub nsw i16 %t, 1234
  store i16 %sub, ptr %a
  ret void
}

define void @sub32mi_legacy(ptr %a) {
; CHECK-LABEL: sub32mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-123456, (%rdi) # encoding: [0x81,0x07,0xc0,0x1d,0xfe,0xff]
; CHECK-NEXT:    # imm = 0xFFFE1DC0
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %sub = sub nsw i32 %t, 123456
  store i32 %sub, ptr %a
  ret void
}

define void @sub64mi_legacy(ptr %a) {
; CHECK-LABEL: sub64mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $-123456, (%rdi) # encoding: [0x48,0x81,0x07,0xc0,0x1d,0xfe,0xff]
; CHECK-NEXT:    # imm = 0xFFFE1DC0
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %sub = sub nsw i64 %t, 123456
  store i64 %sub, ptr %a
  ret void
}
