; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -stop-after=x86-isel -mattr=+sse2,+ssse3,+egpr  | FileCheck %s --check-prefix=SSE
; RUN: llc < %s -mtriple=x86_64-unknown -stop-after=x86-isel -mattr=+sse2,+ssse3,+egpr,+avx | FileCheck %s --check-prefix=AVX

define i32 @map0(ptr nocapture noundef readonly %a, i64 noundef %b) {
  ; SSE-LABEL: name: map0
  ; SSE: bb.0.entry:
  ; SSE-NEXT:   liveins: $rdi, $rsi
  ; SSE-NEXT: {{  $}}
  ; SSE-NEXT:   [[COPY:%[0-9]+]]:gr64_nosp = COPY $rsi
  ; SSE-NEXT:   [[COPY1:%[0-9]+]]:gr64 = COPY $rdi
  ; SSE-NEXT:   [[MOV32rm:%[0-9]+]]:gr32 = MOV32rm [[COPY1]], 4, [[COPY]], 0, $noreg :: (load (s32) from %ir.add.ptr)
  ; SSE-NEXT:   $eax = COPY [[MOV32rm]]
  ; SSE-NEXT:   RET 0, $eax
  ; AVX-LABEL: name: map0
  ; AVX: bb.0.entry:
  ; AVX-NEXT:   liveins: $rdi, $rsi
  ; AVX-NEXT: {{  $}}
  ; AVX-NEXT:   [[COPY:%[0-9]+]]:gr64_nosp = COPY $rsi
  ; AVX-NEXT:   [[COPY1:%[0-9]+]]:gr64 = COPY $rdi
  ; AVX-NEXT:   [[MOV32rm:%[0-9]+]]:gr32 = MOV32rm [[COPY1]], 4, [[COPY]], 0, $noreg :: (load (s32) from %ir.add.ptr)
  ; AVX-NEXT:   $eax = COPY [[MOV32rm]]
  ; AVX-NEXT:   RET 0, $eax
entry:
  %add.ptr = getelementptr inbounds i32, ptr %a, i64 %b
  %0 = load i32, ptr %add.ptr
  ret i32 %0
}

define i32 @map1_or_vex(<2 x double> noundef %a) {
  ; SSE-LABEL: name: map1_or_vex
  ; SSE: bb.0.entry:
  ; SSE-NEXT:   liveins: $xmm0
  ; SSE-NEXT: {{  $}}
  ; SSE-NEXT:   [[COPY:%[0-9]+]]:vr128 = COPY $xmm0
  ; SSE-NEXT:   [[CVTSD2SIrr_Int:%[0-9]+]]:gr32 = nofpexcept CVTSD2SIrr_Int [[COPY]], implicit $mxcsr
  ; SSE-NEXT:   $eax = COPY [[CVTSD2SIrr_Int]]
  ; SSE-NEXT:   RET 0, $eax
  ; AVX-LABEL: name: map1_or_vex
  ; AVX: bb.0.entry:
  ; AVX-NEXT:   liveins: $xmm0
  ; AVX-NEXT: {{  $}}
  ; AVX-NEXT:   [[COPY:%[0-9]+]]:vr128 = COPY $xmm0
  ; AVX-NEXT:   [[VCVTSD2SIrr_Int:%[0-9]+]]:gr32_norex2 = nofpexcept VCVTSD2SIrr_Int [[COPY]], implicit $mxcsr
  ; AVX-NEXT:   $eax = COPY [[VCVTSD2SIrr_Int]]
  ; AVX-NEXT:   RET 0, $eax
entry:
  %0 = tail call i32 @llvm.x86.sse2.cvtsd2si(<2 x double> %a)
  ret i32 %0
}

define <2 x i64> @map2_or_vex(ptr nocapture noundef readonly %b, i64 noundef %c) {
  ; SSE-LABEL: name: map2_or_vex
  ; SSE: bb.0.entry:
  ; SSE-NEXT:   liveins: $rdi, $rsi
  ; SSE-NEXT: {{  $}}
  ; SSE-NEXT:   [[COPY:%[0-9]+]]:gr64_norex2_nosp = COPY $rsi
  ; SSE-NEXT:   [[COPY1:%[0-9]+]]:gr64_norex2 = COPY $rdi
  ; SSE-NEXT:   [[PABSBrm:%[0-9]+]]:vr128 = PABSBrm [[COPY1]], 4, [[COPY]], 0, $noreg :: (load (s128) from %ir.add.ptr)
  ; SSE-NEXT:   $xmm0 = COPY [[PABSBrm]]
  ; SSE-NEXT:   RET 0, $xmm0
  ; AVX-LABEL: name: map2_or_vex
  ; AVX: bb.0.entry:
  ; AVX-NEXT:   liveins: $rdi, $rsi
  ; AVX-NEXT: {{  $}}
  ; AVX-NEXT:   [[COPY:%[0-9]+]]:gr64_norex2_nosp = COPY $rsi
  ; AVX-NEXT:   [[COPY1:%[0-9]+]]:gr64_norex2 = COPY $rdi
  ; AVX-NEXT:   [[VPABSBrm:%[0-9]+]]:vr128 = VPABSBrm [[COPY1]], 4, [[COPY]], 0, $noreg :: (load (s128) from %ir.add.ptr)
  ; AVX-NEXT:   $xmm0 = COPY [[VPABSBrm]]
  ; AVX-NEXT:   RET 0, $xmm0
entry:
  %add.ptr = getelementptr inbounds i32, ptr %b, i64 %c
  %a = load <2 x i64>, ptr %add.ptr
  %0 = bitcast <2 x i64> %a to <16 x i8>
  %elt.abs.i = tail call <16 x i8> @llvm.abs.v16i8(<16 x i8> %0, i1 false)
  %1 = bitcast <16 x i8> %elt.abs.i to <2 x i64>
  ret <2 x i64> %1
}

declare i32 @llvm.x86.sse2.cvtsd2si(<2 x double>)
declare <16 x i8> @llvm.abs.v16i8(<16 x i8>, i1 immarg)
