; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

define void @udiv_v16i8(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: udiv_v16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vdiv.bu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %v2 = udiv <16 x i8> %v0, %v1
  store <16 x i8> %v2, ptr %res
  ret void
}

define void @udiv_v8i16(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: udiv_v8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vdiv.hu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %v2 = udiv <8 x i16> %v0, %v1
  store <8 x i16> %v2, ptr %res
  ret void
}

define void @udiv_v4i32(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: udiv_v4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vdiv.wu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %v2 = udiv <4 x i32> %v0, %v1
  store <4 x i32> %v2, ptr %res
  ret void
}

define void @udiv_v2i64(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: udiv_v2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vdiv.du $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %v2 = udiv <2 x i64> %v0, %v1
  store <2 x i64> %v2, ptr %res
  ret void
}

define void @udiv_v16i8_8(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: udiv_v16i8_8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrli.b $vr0, $vr0, 3
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <16 x i8>, ptr %a0
  %v1 = udiv <16 x i8> %v0, <i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8>
  store <16 x i8> %v1, ptr %res
  ret void
}

define void @udiv_v8i16_8(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: udiv_v8i16_8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrli.h $vr0, $vr0, 3
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <8 x i16>, ptr %a0
  %v1 = udiv <8 x i16> %v0, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  store <8 x i16> %v1, ptr %res
  ret void
}

define void @udiv_v4i32_8(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: udiv_v4i32_8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrli.w $vr0, $vr0, 3
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x i32>, ptr %a0
  %v1 = udiv <4 x i32> %v0, <i32 8, i32 8, i32 8, i32 8>
  store <4 x i32> %v1, ptr %res
  ret void
}

define void @udiv_v2i64_8(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: udiv_v2i64_8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrli.d $vr0, $vr0, 3
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <2 x i64>, ptr %a0
  %v1 = udiv <2 x i64> %v0, <i64 8, i64 8>
  store <2 x i64> %v1, ptr %res
  ret void
}
