; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn-- -verify-machineinstrs < %s | FileCheck -check-prefix=GFX6 %s
; RUN: llc -mtriple=amdgcn-- -mcpu=tonga -verify-machineinstrs < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -mtriple=r600 -mtriple=r600-- -mcpu=cypress < %s | FileCheck -check-prefix=EG %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX12 %s

define amdgpu_kernel void @constant_load_i1(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_load_i1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_load_i1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_i1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 11, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     AND_INT * T1.W, T0.X, 1,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL * T0.W, PV.W, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, T1.W, PV.W,
; EG-NEXT:     LSHL * T0.W, literal.x, PV.W,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_load_i1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_u8 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_and_b32 s2, s2, 1
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX12-NEXT:    global_store_b8 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load i1, ptr addrspace(4) %in
  store i1 %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v2i1(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_load_v2i1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_load_v2i1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v2i1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 11, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     AND_INT * T1.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL * T0.W, PV.W, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, T1.W, PV.W,
; EG-NEXT:     LSHL * T0.W, literal.x, PV.W,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_load_v2i1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v1, v0, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b8 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <2 x i1>, ptr addrspace(4) %in
  store <2 x i1> %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v3i1(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_load_v3i1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_load_v3i1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v3i1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 10, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     AND_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL * T0.W, PV.W, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, T0.X, PV.W,
; EG-NEXT:     LSHL * T0.W, literal.x, PV.W,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_load_v3i1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v1, v0, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b8 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <3 x i1>, ptr addrspace(4) %in
  store <3 x i1> %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v4i1(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_load_v4i1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_load_v4i1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v4i1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 11, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     AND_INT * T1.W, T0.X, literal.y,
; EG-NEXT:    3(4.203895e-45), 15(2.101948e-44)
; EG-NEXT:     LSHL * T0.W, PV.W, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, T1.W, PV.W,
; EG-NEXT:     LSHL * T0.W, literal.x, PV.W,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_load_v4i1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v1, v0, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b8 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <4 x i1>, ptr addrspace(4) %in
  store <4 x i1> %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v8i1(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_load_v8i1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_load_v8i1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v8i1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 11, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     AND_INT * T1.W, T0.X, literal.y,
; EG-NEXT:    3(4.203895e-45), 255(3.573311e-43)
; EG-NEXT:     LSHL * T0.W, PV.W, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, T1.W, PV.W,
; EG-NEXT:     LSHL * T0.W, literal.x, PV.W,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_load_v8i1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v1, v0, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b8 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <8 x i1>, ptr addrspace(4) %in
  store <8 x i1> %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v16i1(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_load_v16i1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_load_v16i1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ushort v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v16i1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 11, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     AND_INT * T1.W, T0.X, literal.y,
; EG-NEXT:    3(4.203895e-45), 65535(9.183409e-41)
; EG-NEXT:     LSHL * T0.W, PV.W, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, T1.W, PV.W,
; EG-NEXT:     LSHL * T0.W, literal.x, PV.W,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_load_v16i1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <16 x i1>, ptr addrspace(4) %in
  store <16 x i1> %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v32i1(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_load_v32i1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_load_v32i1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v32i1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 1, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_load_v32i1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <32 x i1>, ptr addrspace(4) %in
  store <32 x i1> %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v64i1(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_load_v64i1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_load_v64i1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v64i1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 1, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_load_v64i1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <64 x i1>, ptr addrspace(4) %in
  store <64 x i1> %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_i1_to_i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_i1_to_i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_i1_to_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_i1_to_i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 1, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_i1_to_i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_u8 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %a = load i1, ptr addrspace(4) %in
  %ext = zext i1 %a to i32
  store i32 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_i1_to_i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_i1_to_i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_i1_to_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_i1_to_i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_INT T0.X, T0.X, 0.0, 1,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_i1_to_i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_u8 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %a = load i1, ptr addrspace(4) %in
  %ext = sext i1 %a to i32
  store i32 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v1i1_to_v1i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v1i1_to_v1i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v1i1_to_v1i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v1i1_to_v1i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 1, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v1i1_to_v1i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_u8 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <1 x i1>, ptr addrspace(4) %in
  %ext = zext <1 x i1> %load to <1 x i32>
  store <1 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v1i1_to_v1i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v1i1_to_v1i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v1i1_to_v1i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v1i1_to_v1i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_INT T0.X, T0.X, 0.0, 1,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v1i1_to_v1i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_u8 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <1 x i1>, ptr addrspace(4) %in
  %ext = sext <1 x i1> %load to <1 x i32>
  store <1 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v2i1_to_v2i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v2i1_to_v2i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 1, v0
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v2i1_to_v2i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v2
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 1, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff, v4
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v2i1_to_v2i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 3, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_UINT * T0.Y, T0.X, 1, 1,
; EG-NEXT:     AND_INT T0.X, T0.X, 1,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v2i1_to_v2i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v2, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v1, 1, v0
; GFX12-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX12-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <2 x i1>, ptr addrspace(4) %in
  %ext = zext <2 x i1> %load to <2 x i32>
  store <2 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v2i1_to_v2i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v2i1_to_v2i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v1, v0, 1, 1
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v2i1_to_v2i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 1, v2
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    v_bfe_i32 v3, v3, 0, 1
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v2i1_to_v2i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 4, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XY, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_INT T1.X, T0.X, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T0.X, 1,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT * T1.Y, PV.W, 0.0, 1,
;
; GFX12-LABEL: constant_sextload_v2i1_to_v2i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v2, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v1, 1, v0
; GFX12-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_bfe_i32 v1, v1, 0, 1
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <2 x i1>, ptr addrspace(4) %in
  %ext = sext <2 x i1> %load to <2 x i32>
  store <2 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v3i1_to_v3i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v3i1_to_v3i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v2, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v2
; GFX6-NEXT:    v_bfe_u32 v1, v2, 1, 1
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; GFX6-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:8
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v3i1_to_v3i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NEXT:    v_mov_b32_e32 v4, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v5, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 2, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 0xffff, v5
; GFX8-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX8-NEXT:    flat_store_dwordx3 v[3:4], v[0:2]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v3i1_to_v3i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 8, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XY, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_UINT * T1.Y, T0.X, 1, 1,
; EG-NEXT:     AND_INT T1.X, T0.X, 1,
; EG-NEXT:     LSHR * T2.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, T0.X, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 8(1.121039e-44)
; EG-NEXT:     LSHR * T3.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v3i1_to_v3i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v3, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v3, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v1, 1, v0
; GFX12-NEXT:    v_lshrrev_b16 v2, 2, v0
; GFX12-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX12-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX12-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX12-NEXT:    global_store_b96 v3, v[0:2], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <3 x i1>, ptr addrspace(4) %in
  %ext = zext <3 x i1> %load to <3 x i32>
  store <3 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v3i1_to_v3i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v3i1_to_v3i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v2, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v1, v2, 1, 1
; GFX6-NEXT:    v_bfe_i32 v0, v2, 0, 1
; GFX6-NEXT:    v_bfe_i32 v2, v2, 2, 1
; GFX6-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:8
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v3i1_to_v3i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NEXT:    v_mov_b32_e32 v4, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 2, v0
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    v_bfe_i32 v1, v1, 0, 1
; GFX8-NEXT:    flat_store_dwordx3 v[3:4], v[0:2]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v3i1_to_v3i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 10, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.X, T0.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     LSHR * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT * T2.X, PV.W, 0.0, 1,
; EG-NEXT:     BFE_INT T3.X, T0.X, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T0.X, 1,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PS, literal.x,
; EG-NEXT:     BFE_INT * T3.Y, PV.W, 0.0, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v3i1_to_v3i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v3, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v3, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v1, 2, v0
; GFX12-NEXT:    v_lshrrev_b16 v4, 1, v0
; GFX12-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_i32 v2, v1, 0, 1
; GFX12-NEXT:    v_bfe_i32 v1, v4, 0, 1
; GFX12-NEXT:    global_store_b96 v3, v[0:2], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <3 x i1>, ptr addrspace(4) %in
  %ext = sext <3 x i1> %load to <3 x i32>
  store <3 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v4i1_to_v4i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v4i1_to_v4i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v1, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 3, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v1
; GFX6-NEXT:    v_bfe_u32 v2, v1, 2, 1
; GFX6-NEXT:    v_bfe_u32 v1, v1, 1, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v4i1_to_v4i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 2, v0
; GFX8-NEXT:    v_and_b32_e32 v6, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 3, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 0xffff, v6
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX8-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v4i1_to_v4i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 7, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_UINT * T0.W, T0.X, literal.x, 1,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT * T0.Z, T0.X, literal.x, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT * T0.Y, T0.X, 1, 1,
; EG-NEXT:     AND_INT T0.X, T0.X, 1,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v4i1_to_v4i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v4, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v1, 2, v0
; GFX12-NEXT:    v_lshrrev_b16 v2, 1, v0
; GFX12-NEXT:    v_lshrrev_b16 v3, 3, v0
; GFX12-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX12-NEXT:    v_and_b32_e32 v5, 1, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX12-NEXT:    v_and_b32_e32 v1, 0xffff, v5
; GFX12-NEXT:    global_store_b128 v4, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <4 x i1>, ptr addrspace(4) %in
  %ext = zext <4 x i1> %load to <4 x i32>
  store <4 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v4i1_to_v4i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v4i1_to_v4i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v3, v0, 3, 1
; GFX6-NEXT:    v_bfe_i32 v2, v0, 2, 1
; GFX6-NEXT:    v_bfe_i32 v1, v0, 1, 1
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v4i1_to_v4i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 2, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 3, v0
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX8-NEXT:    v_bfe_i32 v3, v3, 0, 1
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    v_bfe_i32 v1, v1, 0, 1
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v4i1_to_v4i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 10, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_INT T1.X, T0.X, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T1.W, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T1.Z, PS, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T0.X, 1,
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     BFE_INT * T1.Y, PV.W, 0.0, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v4i1_to_v4i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v4, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v1, 3, v0
; GFX12-NEXT:    v_lshrrev_b16 v2, 2, v0
; GFX12-NEXT:    v_lshrrev_b16 v5, 1, v0
; GFX12-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_bfe_i32 v3, v1, 0, 1
; GFX12-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX12-NEXT:    v_bfe_i32 v1, v5, 0, 1
; GFX12-NEXT:    global_store_b128 v4, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <4 x i1>, ptr addrspace(4) %in
  %ext = sext <4 x i1> %load to <4 x i32>
  store <4 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v8i1_to_v8i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v8i1_to_v8i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v4, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_u32 v3, v4, 3, 1
; GFX6-NEXT:    v_bfe_u32 v1, v4, 1, 1
; GFX6-NEXT:    v_lshrrev_b32_e32 v7, 7, v4
; GFX6-NEXT:    v_bfe_u32 v5, v4, 5, 1
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v4
; GFX6-NEXT:    v_bfe_u32 v2, v4, 2, 1
; GFX6-NEXT:    v_bfe_u32 v6, v4, 6, 1
; GFX6-NEXT:    v_bfe_u32 v4, v4, 4, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v8i1_to_v8i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v1, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v11, s3
; GFX8-NEXT:    v_mov_b32_e32 v9, s1
; GFX8-NEXT:    v_mov_b32_e32 v10, s2
; GFX8-NEXT:    v_mov_b32_e32 v8, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 5, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v5, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v12, 3, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 4, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v4, 6, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 2, v1
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v7, 7, v1
; GFX8-NEXT:    v_and_b32_e32 v13, 1, v2
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v5
; GFX8-NEXT:    v_and_b32_e32 v5, 1, v12
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v6
; GFX8-NEXT:    v_and_b32_e32 v6, 1, v4
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v3
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff, v5
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff, v13
; GFX8-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v8i1_to_v8i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 17, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T8.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T6.XYZW, T7.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T5.X, T5.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T5.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_UINT * T6.W, T5.X, literal.x, 1,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT * T6.Z, T5.X, literal.x, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T6.Y, T5.X, 1, 1,
; EG-NEXT:     BFE_UINT * T5.W, T5.X, literal.x, 1,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T6.X, T5.X, 1,
; EG-NEXT:     BFE_UINT T5.Z, T5.X, literal.x, 1,
; EG-NEXT:     LSHR * T7.X, KC0[2].Y, literal.y,
; EG-NEXT:    6(8.407791e-45), 2(2.802597e-45)
; EG-NEXT:     BFE_UINT * T5.Y, T5.X, literal.x, 1,
; EG-NEXT:    5(7.006492e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T5.X, T5.X, literal.x, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    4(5.605194e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR * T8.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v8i1_to_v8i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v8, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v8, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v2, 5, v0
; GFX12-NEXT:    v_lshrrev_b16 v5, 1, v0
; GFX12-NEXT:    v_lshrrev_b16 v6, 3, v0
; GFX12-NEXT:    v_lshrrev_b16 v1, 4, v0
; GFX12-NEXT:    v_lshrrev_b16 v3, 6, v0
; GFX12-NEXT:    v_and_b32_e32 v9, 1, v2
; GFX12-NEXT:    v_lshrrev_b16 v4, 7, v0
; GFX12-NEXT:    v_lshrrev_b16 v7, 2, v0
; GFX12-NEXT:    v_and_b32_e32 v10, 1, v5
; GFX12-NEXT:    v_and_b32_e32 v5, 1, v6
; GFX12-NEXT:    v_and_b32_e32 v6, 1, v3
; GFX12-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX12-NEXT:    v_and_b32_e32 v2, 1, v7
; GFX12-NEXT:    v_and_b32_e32 v7, 0xffff, v4
; GFX12-NEXT:    v_and_b32_e32 v4, 1, v1
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v5
; GFX12-NEXT:    v_and_b32_e32 v5, 0xffff, v9
; GFX12-NEXT:    v_and_b32_e32 v1, 0xffff, v10
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v8, v[4:7], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v8, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <8 x i1>, ptr addrspace(4) %in
  %ext = zext <8 x i1> %load to <8 x i32>
  store <8 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v8i1_to_v8i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v8i1_to_v8i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v4, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v3, v4, 3, 1
; GFX6-NEXT:    v_bfe_i32 v2, v4, 2, 1
; GFX6-NEXT:    v_bfe_i32 v1, v4, 1, 1
; GFX6-NEXT:    v_bfe_i32 v0, v4, 0, 1
; GFX6-NEXT:    v_bfe_i32 v7, v4, 7, 1
; GFX6-NEXT:    v_bfe_i32 v6, v4, 6, 1
; GFX6-NEXT:    v_bfe_i32 v5, v4, 5, 1
; GFX6-NEXT:    v_bfe_i32 v4, v4, 4, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v8i1_to_v8i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v11, s3
; GFX8-NEXT:    v_mov_b32_e32 v9, s1
; GFX8-NEXT:    v_mov_b32_e32 v10, s2
; GFX8-NEXT:    v_mov_b32_e32 v8, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v4, 4, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v5, 5, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 6, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v7, 7, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 2, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 3, v0
; GFX8-NEXT:    v_bfe_i32 v7, v7, 0, 1
; GFX8-NEXT:    v_bfe_i32 v6, v6, 0, 1
; GFX8-NEXT:    v_bfe_i32 v5, v5, 0, 1
; GFX8-NEXT:    v_bfe_i32 v4, v4, 0, 1
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX8-NEXT:    v_bfe_i32 v3, v3, 0, 1
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    v_bfe_i32 v1, v1, 0, 1
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v8i1_to_v8i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 23, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T6.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T8.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T5.X, T5.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T5.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T0.W, T5.X, literal.x,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T6.W, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T5.X, literal.x,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T7.X, T5.X, 0.0, 1,
; EG-NEXT:     BFE_INT T6.Z, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T5.X, literal.x,
; EG-NEXT:     LSHR * T1.W, T5.X, literal.y,
; EG-NEXT:    3(4.203895e-45), 5(7.006492e-45)
; EG-NEXT:     LSHR T8.X, KC0[2].Y, literal.x,
; EG-NEXT:     BFE_INT T6.Y, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T5.X, literal.x,
; EG-NEXT:     BFE_INT T7.W, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T5.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 4(5.605194e-45)
; EG-NEXT:     BFE_INT T6.X, PS, 0.0, 1,
; EG-NEXT:     BFE_INT T7.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T5.X, 1,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T5.X, PS, literal.x,
; EG-NEXT:     BFE_INT * T7.Y, PV.W, 0.0, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v8i1_to_v8i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v8, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v8, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v1, 4, v0
; GFX12-NEXT:    v_lshrrev_b16 v4, 5, v0
; GFX12-NEXT:    v_lshrrev_b16 v5, 6, v0
; GFX12-NEXT:    v_lshrrev_b16 v2, 3, v0
; GFX12-NEXT:    v_lshrrev_b16 v6, 2, v0
; GFX12-NEXT:    v_lshrrev_b16 v7, 7, v0
; GFX12-NEXT:    v_lshrrev_b16 v9, 1, v0
; GFX12-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX12-NEXT:    v_bfe_i32 v3, v2, 0, 1
; GFX12-NEXT:    v_bfe_i32 v2, v6, 0, 1
; GFX12-NEXT:    v_bfe_i32 v7, v7, 0, 1
; GFX12-NEXT:    v_bfe_i32 v6, v5, 0, 1
; GFX12-NEXT:    v_bfe_i32 v5, v4, 0, 1
; GFX12-NEXT:    v_bfe_i32 v4, v1, 0, 1
; GFX12-NEXT:    v_bfe_i32 v1, v9, 0, 1
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v8, v[4:7], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v8, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <8 x i1>, ptr addrspace(4) %in
  %ext = sext <8 x i1> %load to <8 x i32>
  store <8 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v16i1_to_v16i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v16i1_to_v16i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_mov_b32 s10, s2
; GFX6-NEXT:    s_mov_b32 s11, s3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    buffer_load_ushort v12, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s0, s4
; GFX6-NEXT:    s_mov_b32 s1, s5
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_u32 v3, v12, 3, 1
; GFX6-NEXT:    v_bfe_u32 v1, v12, 1, 1
; GFX6-NEXT:    v_bfe_u32 v7, v12, 7, 1
; GFX6-NEXT:    v_bfe_u32 v5, v12, 5, 1
; GFX6-NEXT:    v_bfe_u32 v11, v12, 11, 1
; GFX6-NEXT:    v_bfe_u32 v9, v12, 9, 1
; GFX6-NEXT:    v_lshrrev_b32_e32 v15, 15, v12
; GFX6-NEXT:    v_bfe_u32 v13, v12, 13, 1
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v12
; GFX6-NEXT:    v_bfe_u32 v2, v12, 2, 1
; GFX6-NEXT:    v_bfe_u32 v6, v12, 6, 1
; GFX6-NEXT:    v_bfe_u32 v4, v12, 4, 1
; GFX6-NEXT:    v_bfe_u32 v10, v12, 10, 1
; GFX6-NEXT:    v_bfe_u32 v8, v12, 8, 1
; GFX6-NEXT:    v_bfe_u32 v14, v12, 14, 1
; GFX6-NEXT:    v_bfe_u32 v12, v12, 12, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; GFX6-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v16i1_to_v16i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ushort v1, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 48
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v19, s3
; GFX8-NEXT:    v_mov_b32_e32 v18, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    v_mov_b32_e32 v0, 1
; GFX8-NEXT:    v_mov_b32_e32 v17, s1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v16, s0
; GFX8-NEXT:    s_add_u32 s0, s0, 16
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v21, s3
; GFX8-NEXT:    v_mov_b32_e32 v23, s1
; GFX8-NEXT:    v_mov_b32_e32 v20, s2
; GFX8-NEXT:    v_mov_b32_e32 v22, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 12, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v8, 3, v1
; GFX8-NEXT:    v_and_b32_e32 v12, 1, v8
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v3
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 1, v1
; GFX8-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX8-NEXT:    v_and_b32_e32 v13, 0xffff, v3
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 7, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v7, 14, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v11, 2, v1
; GFX8-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX8-NEXT:    v_lshrrev_b16_e32 v5, 13, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v9, 9, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 10, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v4, 4, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 6, v1
; GFX8-NEXT:    v_and_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_e32 v10, 1, v7
; GFX8-NEXT:    v_and_b32_e32 v14, 1, v11
; GFX8-NEXT:    v_and_b32_e32 v15, 0xffff, v12
; GFX8-NEXT:    v_and_b32_e32 v7, 0xffff, v3
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 11, v1
; GFX8-NEXT:    v_and_b32_e32 v12, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v11, 15, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 5, v1
; GFX8-NEXT:    v_and_b32_e32 v24, 1, v5
; GFX8-NEXT:    v_and_b32_e32 v9, 1, v9
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX8-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff, v1
; GFX8-NEXT:    v_and_b32_e32 v1, 0xffff, v9
; GFX8-NEXT:    v_and_b32_e32 v9, 0xffff, v24
; GFX8-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX8-NEXT:    flat_store_dwordx4 v[18:19], v[8:11]
; GFX8-NEXT:    flat_store_dwordx4 v[20:21], v[0:3]
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[4:7]
; GFX8-NEXT:    flat_store_dwordx4 v[16:17], v[12:15]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v16i1_to_v16i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 36, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T14.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T11.XYZW, T13.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T9.XYZW, T12.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T10.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_16 T7.X, T7.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T7.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     BFE_UINT * T8.W, T7.X, literal.x, 1,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT * T8.Z, T7.X, literal.x, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T8.Y, T7.X, 1, 1,
; EG-NEXT:     BFE_UINT * T9.W, T7.X, literal.x, 1,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T8.X, T7.X, 1,
; EG-NEXT:     BFE_UINT T9.Z, T7.X, literal.x, 1,
; EG-NEXT:     LSHR * T10.X, KC0[2].Y, literal.y,
; EG-NEXT:    6(8.407791e-45), 2(2.802597e-45)
; EG-NEXT:     BFE_UINT T9.Y, T7.X, literal.x, 1,
; EG-NEXT:     BFE_UINT * T11.W, T7.X, literal.y, 1,
; EG-NEXT:    5(7.006492e-45), 11(1.541428e-44)
; EG-NEXT:     BFE_UINT T9.X, T7.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T11.Z, T7.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    4(5.605194e-45), 10(1.401298e-44)
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T12.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T11.Y, T7.X, literal.y, 1,
; EG-NEXT:     LSHR * T7.W, T7.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 9(1.261169e-44)
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T11.X, T7.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T7.Z, T7.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    8(1.121039e-44), 14(1.961818e-44)
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T13.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT * T7.Y, T7.X, literal.y, 1,
; EG-NEXT:    2(2.802597e-45), 13(1.821688e-44)
; EG-NEXT:     BFE_UINT T7.X, T7.X, literal.x, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    12(1.681558e-44), 48(6.726233e-44)
; EG-NEXT:     LSHR * T14.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v16i1_to_v16i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v16, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u16 v0, v16, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v2, 13, v0
; GFX12-NEXT:    v_lshrrev_b16 v13, 1, v0
; GFX12-NEXT:    v_lshrrev_b16 v15, 3, v0
; GFX12-NEXT:    v_lshrrev_b16 v4, 9, v0
; GFX12-NEXT:    v_lshrrev_b16 v6, 11, v0
; GFX12-NEXT:    v_and_b32_e32 v17, 1, v2
; GFX12-NEXT:    v_lshrrev_b16 v10, 5, v0
; GFX12-NEXT:    v_lshrrev_b16 v12, 7, v0
; GFX12-NEXT:    v_lshrrev_b16 v1, 12, v0
; GFX12-NEXT:    v_lshrrev_b16 v3, 14, v0
; GFX12-NEXT:    v_lshrrev_b16 v5, 15, v0
; GFX12-NEXT:    v_lshrrev_b16 v14, 2, v0
; GFX12-NEXT:    v_and_b32_e32 v22, 1, v13
; GFX12-NEXT:    v_and_b32_e32 v13, 1, v15
; GFX12-NEXT:    v_lshrrev_b16 v7, 8, v0
; GFX12-NEXT:    v_lshrrev_b16 v8, 10, v0
; GFX12-NEXT:    v_lshrrev_b16 v9, 4, v0
; GFX12-NEXT:    v_lshrrev_b16 v11, 6, v0
; GFX12-NEXT:    v_and_b32_e32 v18, 1, v4
; GFX12-NEXT:    v_and_b32_e32 v19, 1, v6
; GFX12-NEXT:    v_and_b32_e32 v20, 1, v10
; GFX12-NEXT:    v_and_b32_e32 v21, 1, v12
; GFX12-NEXT:    v_and_b32_e32 v2, 1, v14
; GFX12-NEXT:    v_and_b32_e32 v15, 0xffff, v5
; GFX12-NEXT:    v_and_b32_e32 v14, 1, v3
; GFX12-NEXT:    v_and_b32_e32 v12, 1, v1
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v13
; GFX12-NEXT:    v_and_b32_e32 v13, 0xffff, v17
; GFX12-NEXT:    v_and_b32_e32 v6, 1, v11
; GFX12-NEXT:    v_and_b32_e32 v4, 1, v9
; GFX12-NEXT:    v_and_b32_e32 v10, 1, v8
; GFX12-NEXT:    v_and_b32_e32 v8, 1, v7
; GFX12-NEXT:    v_and_b32_e32 v11, 0xffff, v19
; GFX12-NEXT:    v_and_b32_e32 v9, 0xffff, v18
; GFX12-NEXT:    v_and_b32_e32 v7, 0xffff, v21
; GFX12-NEXT:    v_and_b32_e32 v5, 0xffff, v20
; GFX12-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX12-NEXT:    v_and_b32_e32 v1, 0xffff, v22
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    global_store_b128 v16, v[12:15], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v16, v[8:11], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v16, v[4:7], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v16, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <16 x i1>, ptr addrspace(4) %in
  %ext = zext <16 x i1> %load to <16 x i32>
  store <16 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v16i1_to_v16i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v16i1_to_v16i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_mov_b32 s10, s2
; GFX6-NEXT:    s_mov_b32 s11, s3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    buffer_load_ushort v12, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s0, s4
; GFX6-NEXT:    s_mov_b32 s1, s5
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v3, v12, 3, 1
; GFX6-NEXT:    v_bfe_i32 v2, v12, 2, 1
; GFX6-NEXT:    v_bfe_i32 v1, v12, 1, 1
; GFX6-NEXT:    v_bfe_i32 v0, v12, 0, 1
; GFX6-NEXT:    v_bfe_i32 v7, v12, 7, 1
; GFX6-NEXT:    v_bfe_i32 v6, v12, 6, 1
; GFX6-NEXT:    v_bfe_i32 v5, v12, 5, 1
; GFX6-NEXT:    v_bfe_i32 v4, v12, 4, 1
; GFX6-NEXT:    v_bfe_i32 v11, v12, 11, 1
; GFX6-NEXT:    v_bfe_i32 v10, v12, 10, 1
; GFX6-NEXT:    v_bfe_i32 v9, v12, 9, 1
; GFX6-NEXT:    v_bfe_i32 v8, v12, 8, 1
; GFX6-NEXT:    v_bfe_i32 v15, v12, 15, 1
; GFX6-NEXT:    v_bfe_i32 v14, v12, 14, 1
; GFX6-NEXT:    v_bfe_i32 v13, v12, 13, 1
; GFX6-NEXT:    v_bfe_i32 v12, v12, 12, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; GFX6-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v16i1_to_v16i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 48
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v19, s3
; GFX8-NEXT:    v_mov_b32_e32 v18, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    v_mov_b32_e32 v17, s1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v16, s0
; GFX8-NEXT:    s_add_u32 s0, s0, 16
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v21, s3
; GFX8-NEXT:    v_mov_b32_e32 v23, s1
; GFX8-NEXT:    v_mov_b32_e32 v20, s2
; GFX8-NEXT:    v_mov_b32_e32 v22, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v12, 12, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v13, 13, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v14, 14, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v15, 15, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v8, 8, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v9, 9, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v10, 10, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v11, 11, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v4, 4, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v5, 5, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 6, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v7, 7, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 2, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 3, v0
; GFX8-NEXT:    v_bfe_i32 v15, v15, 0, 1
; GFX8-NEXT:    v_bfe_i32 v14, v14, 0, 1
; GFX8-NEXT:    v_bfe_i32 v13, v13, 0, 1
; GFX8-NEXT:    v_bfe_i32 v12, v12, 0, 1
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX8-NEXT:    v_bfe_i32 v3, v3, 0, 1
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    v_bfe_i32 v1, v1, 0, 1
; GFX8-NEXT:    v_bfe_i32 v7, v7, 0, 1
; GFX8-NEXT:    v_bfe_i32 v6, v6, 0, 1
; GFX8-NEXT:    v_bfe_i32 v5, v5, 0, 1
; GFX8-NEXT:    v_bfe_i32 v4, v4, 0, 1
; GFX8-NEXT:    v_bfe_i32 v11, v11, 0, 1
; GFX8-NEXT:    v_bfe_i32 v10, v10, 0, 1
; GFX8-NEXT:    v_bfe_i32 v9, v9, 0, 1
; GFX8-NEXT:    v_bfe_i32 v8, v8, 0, 1
; GFX8-NEXT:    flat_store_dwordx4 v[18:19], v[12:15]
; GFX8-NEXT:    flat_store_dwordx4 v[20:21], v[8:11]
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[4:7]
; GFX8-NEXT:    flat_store_dwordx4 v[16:17], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v16i1_to_v16i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 51, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T12.XYZW, T7.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T10.XYZW, T14.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T11.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T13.XYZW, T9.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_16 T7.X, T7.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T7.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     LSHR * T0.W, T7.X, literal.x,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T8.W, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T7.X, literal.x,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T8.Z, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, literal.x,
; EG-NEXT:     LSHR * T1.W, T7.X, literal.y,
; EG-NEXT:    11(1.541428e-44), 5(7.006492e-45)
; EG-NEXT:     LSHR T9.X, KC0[2].Y, literal.x,
; EG-NEXT:     BFE_INT T8.Y, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T7.X, literal.y,
; EG-NEXT:     BFE_INT T10.W, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T7.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 10(1.401298e-44)
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T8.X, PS, 0.0, 1,
; EG-NEXT:     BFE_INT T10.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, literal.x,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    9(1.261169e-44), 16(2.242078e-44)
; EG-NEXT:     LSHR T11.X, PS, literal.x,
; EG-NEXT:     BFE_INT T10.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, literal.y,
; EG-NEXT:     LSHR * T1.W, T7.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 15(2.101948e-44)
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T10.X, PS, 0.0, 1,
; EG-NEXT:     BFE_INT T12.W, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T7.X, literal.x,
; EG-NEXT:    14(1.961818e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T13.X, T7.X, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T7.X, literal.x,
; EG-NEXT:     BFE_INT T12.Z, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    3(4.203895e-45), 13(1.821688e-44)
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T14.X, PS, literal.x,
; EG-NEXT:     BFE_INT T12.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T7.X, literal.x,
; EG-NEXT:     BFE_INT T13.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T7.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 12(1.681558e-44)
; EG-NEXT:     BFE_INT T12.X, PS, 0.0, 1,
; EG-NEXT:     BFE_INT T13.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, 1,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T7.X, PS, literal.x,
; EG-NEXT:     BFE_INT * T13.Y, PV.W, 0.0, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v16i1_to_v16i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v16, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u16 v0, v16, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v1, 12, v0
; GFX12-NEXT:    v_lshrrev_b16 v4, 13, v0
; GFX12-NEXT:    v_lshrrev_b16 v8, 14, v0
; GFX12-NEXT:    v_lshrrev_b16 v12, 15, v0
; GFX12-NEXT:    v_lshrrev_b16 v2, 3, v0
; GFX12-NEXT:    v_lshrrev_b16 v7, 2, v0
; GFX12-NEXT:    v_lshrrev_b16 v13, 7, v0
; GFX12-NEXT:    v_lshrrev_b16 v17, 8, v0
; GFX12-NEXT:    v_lshrrev_b16 v9, 9, v0
; GFX12-NEXT:    v_lshrrev_b16 v10, 10, v0
; GFX12-NEXT:    v_lshrrev_b16 v11, 11, v0
; GFX12-NEXT:    v_lshrrev_b16 v18, 4, v0
; GFX12-NEXT:    v_lshrrev_b16 v5, 5, v0
; GFX12-NEXT:    v_lshrrev_b16 v6, 6, v0
; GFX12-NEXT:    v_lshrrev_b16 v19, 1, v0
; GFX12-NEXT:    v_bfe_i32 v3, v2, 0, 1
; GFX12-NEXT:    v_bfe_i32 v2, v7, 0, 1
; GFX12-NEXT:    v_bfe_i32 v7, v13, 0, 1
; GFX12-NEXT:    v_bfe_i32 v15, v12, 0, 1
; GFX12-NEXT:    v_bfe_i32 v14, v8, 0, 1
; GFX12-NEXT:    v_bfe_i32 v13, v4, 0, 1
; GFX12-NEXT:    v_bfe_i32 v12, v1, 0, 1
; GFX12-NEXT:    v_bfe_i32 v11, v11, 0, 1
; GFX12-NEXT:    v_bfe_i32 v10, v10, 0, 1
; GFX12-NEXT:    v_bfe_i32 v9, v9, 0, 1
; GFX12-NEXT:    v_bfe_i32 v8, v17, 0, 1
; GFX12-NEXT:    v_bfe_i32 v6, v6, 0, 1
; GFX12-NEXT:    v_bfe_i32 v5, v5, 0, 1
; GFX12-NEXT:    v_bfe_i32 v4, v18, 0, 1
; GFX12-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX12-NEXT:    v_bfe_i32 v1, v19, 0, 1
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    global_store_b128 v16, v[12:15], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v16, v[8:11], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v16, v[4:7], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v16, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <16 x i1>, ptr addrspace(4) %in
  %ext = sext <16 x i1> %load to <16 x i32>
  store <16 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v32i1_to_v32i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v32i1_to_v32i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_bfe_u32 s5, s4, 0x10003
; GFX6-NEXT:    s_bfe_u32 s6, s4, 0x10001
; GFX6-NEXT:    s_bfe_u32 s7, s4, 0x10007
; GFX6-NEXT:    s_bfe_u32 s8, s4, 0x10005
; GFX6-NEXT:    s_bfe_u32 s9, s4, 0x1000b
; GFX6-NEXT:    s_bfe_u32 s10, s4, 0x10009
; GFX6-NEXT:    s_bfe_u32 s11, s4, 0x1000f
; GFX6-NEXT:    s_bfe_u32 s12, s4, 0x1000d
; GFX6-NEXT:    s_bfe_u32 s13, s4, 0x10013
; GFX6-NEXT:    s_bfe_u32 s14, s4, 0x10011
; GFX6-NEXT:    s_bfe_u32 s15, s4, 0x10017
; GFX6-NEXT:    s_bfe_u32 s16, s4, 0x10015
; GFX6-NEXT:    s_bfe_u32 s17, s4, 0x1001b
; GFX6-NEXT:    s_bfe_u32 s18, s4, 0x10019
; GFX6-NEXT:    s_lshr_b32 s19, s4, 31
; GFX6-NEXT:    s_bfe_u32 s20, s4, 0x1001d
; GFX6-NEXT:    s_and_b32 s21, s4, 1
; GFX6-NEXT:    s_bfe_u32 s22, s4, 0x10002
; GFX6-NEXT:    s_bfe_u32 s23, s4, 0x10006
; GFX6-NEXT:    s_bfe_u32 s24, s4, 0x10004
; GFX6-NEXT:    s_bfe_u32 s25, s4, 0x1000a
; GFX6-NEXT:    s_bfe_u32 s26, s4, 0x10008
; GFX6-NEXT:    s_bfe_u32 s27, s4, 0x1000e
; GFX6-NEXT:    s_bfe_u32 s28, s4, 0x1000c
; GFX6-NEXT:    s_bfe_u32 s29, s4, 0x10012
; GFX6-NEXT:    s_bfe_u32 s30, s4, 0x10010
; GFX6-NEXT:    s_bfe_u32 s31, s4, 0x10016
; GFX6-NEXT:    s_bfe_u32 s33, s4, 0x10014
; GFX6-NEXT:    s_bfe_u32 s34, s4, 0x1001a
; GFX6-NEXT:    s_bfe_u32 s35, s4, 0x1001e
; GFX6-NEXT:    s_bfe_u32 s36, s4, 0x1001c
; GFX6-NEXT:    s_bfe_u32 s4, s4, 0x10018
; GFX6-NEXT:    v_mov_b32_e32 v0, s36
; GFX6-NEXT:    v_mov_b32_e32 v1, s20
; GFX6-NEXT:    v_mov_b32_e32 v2, s35
; GFX6-NEXT:    v_mov_b32_e32 v3, s19
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:112
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s18
; GFX6-NEXT:    v_mov_b32_e32 v2, s34
; GFX6-NEXT:    v_mov_b32_e32 v3, s17
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:96
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s33
; GFX6-NEXT:    v_mov_b32_e32 v1, s16
; GFX6-NEXT:    v_mov_b32_e32 v2, s31
; GFX6-NEXT:    v_mov_b32_e32 v3, s15
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:80
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s30
; GFX6-NEXT:    v_mov_b32_e32 v1, s14
; GFX6-NEXT:    v_mov_b32_e32 v2, s29
; GFX6-NEXT:    v_mov_b32_e32 v3, s13
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:64
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s28
; GFX6-NEXT:    v_mov_b32_e32 v1, s12
; GFX6-NEXT:    v_mov_b32_e32 v2, s27
; GFX6-NEXT:    v_mov_b32_e32 v3, s11
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s26
; GFX6-NEXT:    v_mov_b32_e32 v1, s10
; GFX6-NEXT:    v_mov_b32_e32 v2, s25
; GFX6-NEXT:    v_mov_b32_e32 v3, s9
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:32
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s24
; GFX6-NEXT:    v_mov_b32_e32 v1, s8
; GFX6-NEXT:    v_mov_b32_e32 v2, s23
; GFX6-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s21
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s22
; GFX6-NEXT:    v_mov_b32_e32 v3, s5
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v32i1_to_v32i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 13, s4
; GFX8-NEXT:    v_and_b32_e32 v24, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 5, s4
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 7, s4
; GFX8-NEXT:    v_and_b32_e32 v15, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 1, s4
; GFX8-NEXT:    v_and_b32_e32 v23, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 3, s4
; GFX8-NEXT:    s_lshr_b32 s2, s4, 24
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 9, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v3, 11, s4
; GFX8-NEXT:    v_and_b32_e32 v26, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 5, s2
; GFX8-NEXT:    v_and_b32_e32 v17, 1, v2
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v3
; GFX8-NEXT:    v_lshrrev_b16_e64 v4, 4, s2
; GFX8-NEXT:    v_and_b32_e32 v5, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v6, 6, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 1, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 2, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v3, 3, s2
; GFX8-NEXT:    s_bfe_u32 s5, s4, 0x10018
; GFX8-NEXT:    v_lshrrev_b16_e64 v7, 7, s2
; GFX8-NEXT:    s_and_b32 s6, s4, 1
; GFX8-NEXT:    s_bfe_u32 s7, s4, 0x10013
; GFX8-NEXT:    s_bfe_u32 s8, s4, 0x10012
; GFX8-NEXT:    s_bfe_u32 s9, s4, 0x10011
; GFX8-NEXT:    s_bfe_u32 s10, s4, 0x10010
; GFX8-NEXT:    s_bfe_u32 s2, s4, 0x10017
; GFX8-NEXT:    s_bfe_u32 s3, s4, 0x10016
; GFX8-NEXT:    s_bfe_u32 s11, s4, 0x10015
; GFX8-NEXT:    s_bfe_u32 s12, s4, 0x10014
; GFX8-NEXT:    v_mov_b32_e32 v11, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 0x50
; GFX8-NEXT:    v_mov_b32_e32 v10, s3
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v13, s3
; GFX8-NEXT:    v_mov_b32_e32 v12, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 64
; GFX8-NEXT:    v_mov_b32_e32 v8, s12
; GFX8-NEXT:    v_mov_b32_e32 v9, s11
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; GFX8-NEXT:    v_mov_b32_e32 v13, s3
; GFX8-NEXT:    v_mov_b32_e32 v12, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 48
; GFX8-NEXT:    v_lshrrev_b16_e64 v21, 14, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v25, 2, s4
; GFX8-NEXT:    v_mov_b32_e32 v8, s10
; GFX8-NEXT:    v_mov_b32_e32 v9, s9
; GFX8-NEXT:    v_mov_b32_e32 v10, s8
; GFX8-NEXT:    v_mov_b32_e32 v11, s7
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; GFX8-NEXT:    v_and_b32_e32 v13, 0xffff, v22
; GFX8-NEXT:    v_and_b32_e32 v10, 1, v25
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v21
; GFX8-NEXT:    v_and_b32_e32 v21, 0xffff, v24
; GFX8-NEXT:    v_mov_b32_e32 v25, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v20, 12, s4
; GFX8-NEXT:    v_mov_b32_e32 v24, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    v_and_b32_e32 v9, 0xffff, v23
; GFX8-NEXT:    v_lshrrev_b16_e64 v23, 15, s4
; GFX8-NEXT:    v_and_b32_e32 v20, 1, v20
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[24:25], v[20:23]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v21, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v16, 10, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v19, 4, s4
; GFX8-NEXT:    v_mov_b32_e32 v8, 1
; GFX8-NEXT:    v_mov_b32_e32 v20, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    v_and_b32_e32 v12, 1, v19
; GFX8-NEXT:    v_and_b32_e32 v19, 0xffff, v18
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v16
; GFX8-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX8-NEXT:    v_and_b32_sdwa v16, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 6, s4
; GFX8-NEXT:    flat_store_dwordx4 v[20:21], v[16:19]
; GFX8-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX8-NEXT:    v_mov_b32_e32 v17, s3
; GFX8-NEXT:    v_and_b32_e32 v14, 1, v14
; GFX8-NEXT:    v_mov_b32_e32 v16, s2
; GFX8-NEXT:    flat_store_dwordx4 v[16:17], v[12:15]
; GFX8-NEXT:    s_add_u32 s2, s0, 0x70
; GFX8-NEXT:    v_mov_b32_e32 v13, s1
; GFX8-NEXT:    v_and_b32_e32 v11, 0xffff, v26
; GFX8-NEXT:    v_mov_b32_e32 v8, s6
; GFX8-NEXT:    v_mov_b32_e32 v12, s0
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; GFX8-NEXT:    s_add_u32 s0, s0, 0x60
; GFX8-NEXT:    v_mov_b32_e32 v9, s3
; GFX8-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX8-NEXT:    v_mov_b32_e32 v8, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX8-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX8-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s5
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v32i1_to_v32i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @12
; EG-NEXT:    ALU 76, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T11.XYZW, T26.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T23.XYZW, T25.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T21.XYZW, T24.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T19.XYZW, T22.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T17.XYZW, T20.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T15.XYZW, T18.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T13.XYZW, T16.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T12.XYZW, T14.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_32 T11.X, T11.X, 0, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T11.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     BFE_UINT * T12.W, T11.X, literal.x, 1,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT * T12.Z, T11.X, literal.x, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T12.Y, T11.X, 1, 1,
; EG-NEXT:     BFE_UINT * T13.W, T11.X, literal.x, 1,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T12.X, T11.X, 1,
; EG-NEXT:     BFE_UINT T13.Z, T11.X, literal.x, 1,
; EG-NEXT:     LSHR * T14.X, KC0[2].Y, literal.y,
; EG-NEXT:    6(8.407791e-45), 2(2.802597e-45)
; EG-NEXT:     BFE_UINT T13.Y, T11.X, literal.x, 1,
; EG-NEXT:     BFE_UINT * T15.W, T11.X, literal.y, 1,
; EG-NEXT:    5(7.006492e-45), 11(1.541428e-44)
; EG-NEXT:     BFE_UINT T13.X, T11.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T15.Z, T11.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    4(5.605194e-45), 10(1.401298e-44)
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T16.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T15.Y, T11.X, literal.y, 1,
; EG-NEXT:     BFE_UINT * T17.W, T11.X, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 9(1.261169e-44)
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T15.X, T11.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T17.Z, T11.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    8(1.121039e-44), 14(1.961818e-44)
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T18.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T17.Y, T11.X, literal.y, 1,
; EG-NEXT:     BFE_UINT * T19.W, T11.X, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 13(1.821688e-44)
; EG-NEXT:    19(2.662467e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T17.X, T11.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T19.Z, T11.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    12(1.681558e-44), 18(2.522337e-44)
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T20.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T19.Y, T11.X, literal.y, 1,
; EG-NEXT:     BFE_UINT * T21.W, T11.X, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 17(2.382207e-44)
; EG-NEXT:    23(3.222986e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T19.X, T11.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T21.Z, T11.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    16(2.242078e-44), 22(3.082857e-44)
; EG-NEXT:    64(8.968310e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T22.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T21.Y, T11.X, literal.y, 1,
; EG-NEXT:     BFE_UINT * T23.W, T11.X, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 21(2.942727e-44)
; EG-NEXT:    27(3.783506e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T21.X, T11.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T23.Z, T11.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    20(2.802597e-44), 26(3.643376e-44)
; EG-NEXT:    80(1.121039e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T24.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T23.Y, T11.X, literal.y, 1,
; EG-NEXT:     LSHR * T11.W, T11.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 25(3.503246e-44)
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T23.X, T11.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T11.Z, T11.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    24(3.363116e-44), 30(4.203895e-44)
; EG-NEXT:    96(1.345247e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T25.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT * T11.Y, T11.X, literal.y, 1,
; EG-NEXT:    2(2.802597e-45), 29(4.063766e-44)
; EG-NEXT:     BFE_UINT T11.X, T11.X, literal.x, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    28(3.923636e-44), 112(1.569454e-43)
; EG-NEXT:     LSHR * T26.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v32i1_to_v32i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshr_b32 s3, s2, 24
; GFX12-NEXT:    v_lshrrev_b16 v1, 13, s2
; GFX12-NEXT:    v_lshrrev_b16 v2, 9, s2
; GFX12-NEXT:    v_lshrrev_b16 v4, 11, s2
; GFX12-NEXT:    v_lshrrev_b16 v6, 5, s2
; GFX12-NEXT:    v_lshrrev_b16 v9, 7, s2
; GFX12-NEXT:    v_lshrrev_b16 v13, 3, s2
; GFX12-NEXT:    v_lshrrev_b16 v14, 5, s3
; GFX12-NEXT:    v_lshrrev_b16 v18, 1, s3
; GFX12-NEXT:    v_lshrrev_b16 v21, 3, s3
; GFX12-NEXT:    v_lshrrev_b16 v10, 1, s2
; GFX12-NEXT:    v_dual_mov_b32 v32, 0 :: v_dual_and_b32 v33, 1, v1
; GFX12-NEXT:    v_lshrrev_b16 v0, 12, s2
; GFX12-NEXT:    v_lshrrev_b16 v12, 14, s2
; GFX12-NEXT:    v_lshrrev_b16 v20, 15, s2
; GFX12-NEXT:    v_lshrrev_b16 v8, 8, s2
; GFX12-NEXT:    v_lshrrev_b16 v3, 10, s2
; GFX12-NEXT:    v_lshrrev_b16 v5, 4, s2
; GFX12-NEXT:    v_lshrrev_b16 v7, 6, s2
; GFX12-NEXT:    v_lshrrev_b16 v11, 2, s2
; GFX12-NEXT:    s_bfe_u32 s4, s2, 0x10018
; GFX12-NEXT:    s_and_b32 s5, s2, 1
; GFX12-NEXT:    v_lshrrev_b16 v15, 4, s3
; GFX12-NEXT:    v_lshrrev_b16 v16, 6, s3
; GFX12-NEXT:    v_lshrrev_b16 v17, 7, s3
; GFX12-NEXT:    v_lshrrev_b16 v19, 2, s3
; GFX12-NEXT:    v_and_b32_e32 v25, 1, v14
; GFX12-NEXT:    v_and_b32_e32 v26, 1, v18
; GFX12-NEXT:    v_and_b32_e32 v21, 1, v21
; GFX12-NEXT:    s_bfe_u32 s3, s2, 0x10013
; GFX12-NEXT:    s_bfe_u32 s6, s2, 0x10012
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v30, s6 :: v_dual_and_b32 v13, 1, v13
; GFX12-NEXT:    s_bfe_u32 s7, s2, 0x10011
; GFX12-NEXT:    s_bfe_u32 s8, s2, 0x10010
; GFX12-NEXT:    s_bfe_u32 s9, s2, 0x10017
; GFX12-NEXT:    v_dual_mov_b32 v27, s9 :: v_dual_and_b32 v24, 1, v6
; GFX12-NEXT:    s_bfe_u32 s10, s2, 0x10016
; GFX12-NEXT:    v_and_b32_e32 v9, 1, v9
; GFX12-NEXT:    s_bfe_u32 s11, s2, 0x10014
; GFX12-NEXT:    v_and_b32_e32 v23, 1, v4
; GFX12-NEXT:    s_bfe_u32 s2, s2, 0x10015
; GFX12-NEXT:    v_and_b32_e32 v22, 1, v2
; GFX12-NEXT:    v_dual_mov_b32 v28, s8 :: v_dual_and_b32 v1, 1, v10
; GFX12-NEXT:    v_dual_mov_b32 v29, s7 :: v_dual_and_b32 v2, 1, v11
; GFX12-NEXT:    v_dual_mov_b32 v31, s3 :: v_dual_and_b32 v6, 1, v7
; GFX12-NEXT:    v_and_b32_e32 v4, 1, v5
; GFX12-NEXT:    v_and_b32_e32 v10, 1, v3
; GFX12-NEXT:    v_and_b32_e32 v14, 1, v19
; GFX12-NEXT:    v_and_b32_e32 v19, 0xffff, v17
; GFX12-NEXT:    v_and_b32_e32 v18, 1, v16
; GFX12-NEXT:    v_and_b32_e32 v16, 1, v15
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v13
; GFX12-NEXT:    v_and_b32_e32 v5, 0xffff, v24
; GFX12-NEXT:    v_dual_mov_b32 v24, s11 :: v_dual_and_b32 v13, 0xffff, v26
; GFX12-NEXT:    v_and_b32_e32 v11, 0xffff, v23
; GFX12-NEXT:    v_dual_mov_b32 v26, s10 :: v_dual_and_b32 v23, 0xffff, v20
; GFX12-NEXT:    v_and_b32_e32 v7, 0xffff, v9
; GFX12-NEXT:    v_and_b32_e32 v20, 1, v0
; GFX12-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_and_b32 v17, 0xffff, v25
; GFX12-NEXT:    v_mov_b32_e32 v25, s2
; GFX12-NEXT:    v_and_b32_e32 v9, 0xffff, v22
; GFX12-NEXT:    v_and_b32_e32 v22, 1, v12
; GFX12-NEXT:    v_dual_mov_b32 v12, s4 :: v_dual_and_b32 v15, 0xffff, v21
; GFX12-NEXT:    v_and_b32_e32 v21, 0xffff, v33
; GFX12-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX12-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX12-NEXT:    s_clause 0x7
; GFX12-NEXT:    global_store_b128 v32, v[24:27], s[0:1] offset:80
; GFX12-NEXT:    global_store_b128 v32, v[28:31], s[0:1] offset:64
; GFX12-NEXT:    global_store_b128 v32, v[20:23], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v32, v[8:11], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v32, v[4:7], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v32, v[0:3], s[0:1]
; GFX12-NEXT:    global_store_b128 v32, v[16:19], s[0:1] offset:112
; GFX12-NEXT:    global_store_b128 v32, v[12:15], s[0:1] offset:96
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <32 x i1>, ptr addrspace(4) %in
  %ext = zext <32 x i1> %load to <32 x i32>
  store <32 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v32i1_to_v32i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v32i1_to_v32i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_bfe_i32 s5, s4, 0x10003
; GFX6-NEXT:    s_bfe_i32 s6, s4, 0x10002
; GFX6-NEXT:    s_bfe_i32 s7, s4, 0x10001
; GFX6-NEXT:    s_bfe_i32 s8, s4, 0x10000
; GFX6-NEXT:    s_bfe_i32 s9, s4, 0x10007
; GFX6-NEXT:    s_bfe_i32 s10, s4, 0x10006
; GFX6-NEXT:    s_bfe_i32 s11, s4, 0x10005
; GFX6-NEXT:    s_bfe_i32 s12, s4, 0x10004
; GFX6-NEXT:    s_bfe_i32 s13, s4, 0x1000b
; GFX6-NEXT:    s_bfe_i32 s14, s4, 0x1000a
; GFX6-NEXT:    s_bfe_i32 s15, s4, 0x10009
; GFX6-NEXT:    s_bfe_i32 s16, s4, 0x10008
; GFX6-NEXT:    s_bfe_i32 s17, s4, 0x1000f
; GFX6-NEXT:    s_bfe_i32 s18, s4, 0x1000e
; GFX6-NEXT:    s_bfe_i32 s19, s4, 0x1000d
; GFX6-NEXT:    s_bfe_i32 s20, s4, 0x1000c
; GFX6-NEXT:    s_bfe_i32 s21, s4, 0x10013
; GFX6-NEXT:    s_bfe_i32 s22, s4, 0x10012
; GFX6-NEXT:    s_bfe_i32 s23, s4, 0x10011
; GFX6-NEXT:    s_bfe_i32 s24, s4, 0x10010
; GFX6-NEXT:    s_bfe_i32 s25, s4, 0x10017
; GFX6-NEXT:    s_bfe_i32 s26, s4, 0x10016
; GFX6-NEXT:    s_bfe_i32 s27, s4, 0x10015
; GFX6-NEXT:    s_bfe_i32 s28, s4, 0x10014
; GFX6-NEXT:    s_bfe_i32 s29, s4, 0x1001b
; GFX6-NEXT:    s_bfe_i32 s30, s4, 0x1001a
; GFX6-NEXT:    s_bfe_i32 s31, s4, 0x10019
; GFX6-NEXT:    s_ashr_i32 s33, s4, 31
; GFX6-NEXT:    s_bfe_i32 s34, s4, 0x1001e
; GFX6-NEXT:    s_bfe_i32 s35, s4, 0x1001d
; GFX6-NEXT:    s_bfe_i32 s36, s4, 0x1001c
; GFX6-NEXT:    s_bfe_i32 s4, s4, 0x10018
; GFX6-NEXT:    v_mov_b32_e32 v0, s36
; GFX6-NEXT:    v_mov_b32_e32 v1, s35
; GFX6-NEXT:    v_mov_b32_e32 v2, s34
; GFX6-NEXT:    v_mov_b32_e32 v3, s33
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:112
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s31
; GFX6-NEXT:    v_mov_b32_e32 v2, s30
; GFX6-NEXT:    v_mov_b32_e32 v3, s29
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:96
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s28
; GFX6-NEXT:    v_mov_b32_e32 v1, s27
; GFX6-NEXT:    v_mov_b32_e32 v2, s26
; GFX6-NEXT:    v_mov_b32_e32 v3, s25
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:80
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s24
; GFX6-NEXT:    v_mov_b32_e32 v1, s23
; GFX6-NEXT:    v_mov_b32_e32 v2, s22
; GFX6-NEXT:    v_mov_b32_e32 v3, s21
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:64
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s20
; GFX6-NEXT:    v_mov_b32_e32 v1, s19
; GFX6-NEXT:    v_mov_b32_e32 v2, s18
; GFX6-NEXT:    v_mov_b32_e32 v3, s17
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s16
; GFX6-NEXT:    v_mov_b32_e32 v1, s15
; GFX6-NEXT:    v_mov_b32_e32 v2, s14
; GFX6-NEXT:    v_mov_b32_e32 v3, s13
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:32
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s12
; GFX6-NEXT:    v_mov_b32_e32 v1, s11
; GFX6-NEXT:    v_mov_b32_e32 v2, s10
; GFX6-NEXT:    v_mov_b32_e32 v3, s9
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s8
; GFX6-NEXT:    v_mov_b32_e32 v1, s7
; GFX6-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NEXT:    v_mov_b32_e32 v3, s5
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v32i1_to_v32i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s3, s2, 24
; GFX8-NEXT:    v_lshrrev_b16_e64 v8, 12, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v20, 13, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v21, 14, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v22, 15, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v16, 8, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v17, 9, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v18, 10, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v19, 11, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v12, 4, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v13, 5, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 6, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v15, 7, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v9, 1, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v10, 2, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v11, 3, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v23, 4, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v24, 5, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v6, 6, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v7, 7, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v25, 1, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v26, 2, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v27, 3, s3
; GFX8-NEXT:    s_bfe_i32 s4, s2, 0x10018
; GFX8-NEXT:    s_bfe_i32 s5, s2, 0x10000
; GFX8-NEXT:    s_bfe_i32 s6, s2, 0x10013
; GFX8-NEXT:    s_bfe_i32 s7, s2, 0x10012
; GFX8-NEXT:    s_bfe_i32 s8, s2, 0x10011
; GFX8-NEXT:    s_bfe_i32 s9, s2, 0x10010
; GFX8-NEXT:    s_bfe_i32 s3, s2, 0x10017
; GFX8-NEXT:    s_bfe_i32 s10, s2, 0x10016
; GFX8-NEXT:    s_bfe_i32 s11, s2, 0x10015
; GFX8-NEXT:    s_bfe_i32 s2, s2, 0x10014
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 0x50
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 64
; GFX8-NEXT:    v_mov_b32_e32 v1, s11
; GFX8-NEXT:    v_mov_b32_e32 v2, s10
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 48
; GFX8-NEXT:    v_mov_b32_e32 v0, s9
; GFX8-NEXT:    v_mov_b32_e32 v1, s8
; GFX8-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NEXT:    v_mov_b32_e32 v3, s6
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    v_bfe_i32 v5, v24, 0, 1
; GFX8-NEXT:    v_bfe_i32 v1, v25, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v25, s3
; GFX8-NEXT:    v_mov_b32_e32 v24, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    v_bfe_i32 v4, v23, 0, 1
; GFX8-NEXT:    v_bfe_i32 v23, v22, 0, 1
; GFX8-NEXT:    v_bfe_i32 v22, v21, 0, 1
; GFX8-NEXT:    v_bfe_i32 v21, v20, 0, 1
; GFX8-NEXT:    v_bfe_i32 v20, v8, 0, 1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[24:25], v[20:23]
; GFX8-NEXT:    v_bfe_i32 v19, v19, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v21, s3
; GFX8-NEXT:    v_mov_b32_e32 v20, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    v_bfe_i32 v18, v18, 0, 1
; GFX8-NEXT:    v_bfe_i32 v17, v17, 0, 1
; GFX8-NEXT:    v_bfe_i32 v16, v16, 0, 1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[20:21], v[16:19]
; GFX8-NEXT:    v_bfe_i32 v15, v15, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v17, s3
; GFX8-NEXT:    v_bfe_i32 v14, v14, 0, 1
; GFX8-NEXT:    v_bfe_i32 v13, v13, 0, 1
; GFX8-NEXT:    v_bfe_i32 v12, v12, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v16, s2
; GFX8-NEXT:    flat_store_dwordx4 v[16:17], v[12:15]
; GFX8-NEXT:    s_add_u32 s2, s0, 0x70
; GFX8-NEXT:    v_mov_b32_e32 v13, s1
; GFX8-NEXT:    v_bfe_i32 v11, v11, 0, 1
; GFX8-NEXT:    v_bfe_i32 v10, v10, 0, 1
; GFX8-NEXT:    v_bfe_i32 v9, v9, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v8, s5
; GFX8-NEXT:    v_mov_b32_e32 v12, s0
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; GFX8-NEXT:    s_add_u32 s0, s0, 0x60
; GFX8-NEXT:    v_mov_b32_e32 v9, s3
; GFX8-NEXT:    v_bfe_i32 v7, v7, 0, 1
; GFX8-NEXT:    v_bfe_i32 v6, v6, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v8, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GFX8-NEXT:    v_bfe_i32 v3, v27, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_bfe_i32 v2, v26, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v32i1_to_v32i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @16, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @14
; EG-NEXT:    ALU 99, @17, KC0[CB0:0-32], KC1[]
; EG-NEXT:    ALU 5, @117, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T24.XYZW, T11.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T22.XYZW, T26.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T20.XYZW, T23.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T18.XYZW, T21.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T16.XYZW, T19.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T17.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T12.XYZW, T15.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T25.XYZW, T13.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 14:
; EG-NEXT:     VTX_READ_32 T11.X, T11.X, 0, #1
; EG-NEXT:    ALU clause starting at 16:
; EG-NEXT:     MOV * T11.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 17:
; EG-NEXT:     LSHR * T0.W, T11.X, literal.x,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T12.W, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T11.X, literal.x,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T12.Z, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T11.X, literal.x,
; EG-NEXT:     LSHR * T1.W, T11.X, literal.y,
; EG-NEXT:    11(1.541428e-44), 5(7.006492e-45)
; EG-NEXT:     LSHR T13.X, KC0[2].Y, literal.x,
; EG-NEXT:     BFE_INT T12.Y, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T11.X, literal.y,
; EG-NEXT:     BFE_INT T14.W, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T11.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 10(1.401298e-44)
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T12.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T11.X, literal.x,
; EG-NEXT:     BFE_INT T14.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T11.X, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    15(2.101948e-44), 9(1.261169e-44)
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T15.X, PS, literal.x,
; EG-NEXT:     BFE_INT T14.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T11.X, literal.y,
; EG-NEXT:     BFE_INT T16.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T11.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 14(1.961818e-44)
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T14.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T11.X, literal.x,
; EG-NEXT:     BFE_INT T16.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T11.X, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    19(2.662467e-44), 13(1.821688e-44)
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T17.X, PS, literal.x,
; EG-NEXT:     BFE_INT T16.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T11.X, literal.y,
; EG-NEXT:     BFE_INT T18.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T11.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 18(2.522337e-44)
; EG-NEXT:    12(1.681558e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T16.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T11.X, literal.x,
; EG-NEXT:     BFE_INT T18.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T11.X, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    23(3.222986e-44), 17(2.382207e-44)
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T19.X, PS, literal.x,
; EG-NEXT:     BFE_INT T18.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T11.X, literal.y,
; EG-NEXT:     BFE_INT T20.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T11.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 22(3.082857e-44)
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T18.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T11.X, literal.x,
; EG-NEXT:     BFE_INT T20.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T11.X, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    27(3.783506e-44), 21(2.942727e-44)
; EG-NEXT:    64(8.968310e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T21.X, PS, literal.x,
; EG-NEXT:     BFE_INT T20.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T11.X, literal.y,
; EG-NEXT:     BFE_INT T22.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T11.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 26(3.643376e-44)
; EG-NEXT:    20(2.802597e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T20.X, PS, 0.0, 1,
; EG-NEXT:     BFE_INT T22.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T11.X, literal.x,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    25(3.503246e-44), 80(1.121039e-43)
; EG-NEXT:     LSHR T23.X, PS, literal.x,
; EG-NEXT:     BFE_INT T22.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T11.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 24(3.363116e-44)
; EG-NEXT:     BFE_INT T22.X, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T11.X, literal.x,
; EG-NEXT:     ASHR * T24.W, T11.X, literal.y,
; EG-NEXT:    30(4.203895e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_INT T25.X, T11.X, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T11.X, literal.x,
; EG-NEXT:     BFE_INT T24.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T11.X, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    3(4.203895e-45), 29(4.063766e-44)
; EG-NEXT:    96(1.345247e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T26.X, PS, literal.x,
; EG-NEXT:     BFE_INT T24.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T11.X, literal.x,
; EG-NEXT:     BFE_INT T25.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T11.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 28(3.923636e-44)
; EG-NEXT:     BFE_INT T24.X, PS, 0.0, 1,
; EG-NEXT:     BFE_INT * T25.Z, PV.Z, 0.0, 1,
; EG-NEXT:    ALU clause starting at 117:
; EG-NEXT:     LSHR T0.W, T11.X, 1,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    112(1.569454e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T11.X, PS, literal.x,
; EG-NEXT:     BFE_INT * T25.Y, PV.W, 0.0, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v32i1_to_v32i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v0, 12, s2
; GFX12-NEXT:    v_lshrrev_b16 v12, 13, s2
; GFX12-NEXT:    v_lshrrev_b16 v13, 14, s2
; GFX12-NEXT:    v_lshrrev_b16 v14, 15, s2
; GFX12-NEXT:    v_lshrrev_b16 v8, 8, s2
; GFX12-NEXT:    v_lshrrev_b16 v9, 9, s2
; GFX12-NEXT:    v_lshrrev_b16 v10, 10, s2
; GFX12-NEXT:    v_lshrrev_b16 v11, 11, s2
; GFX12-NEXT:    s_lshr_b32 s3, s2, 24
; GFX12-NEXT:    v_lshrrev_b16 v4, 4, s2
; GFX12-NEXT:    v_lshrrev_b16 v5, 5, s2
; GFX12-NEXT:    v_lshrrev_b16 v6, 6, s2
; GFX12-NEXT:    v_lshrrev_b16 v7, 7, s2
; GFX12-NEXT:    v_lshrrev_b16 v1, 1, s2
; GFX12-NEXT:    v_lshrrev_b16 v2, 2, s2
; GFX12-NEXT:    v_lshrrev_b16 v3, 3, s2
; GFX12-NEXT:    s_bfe_i32 s4, s2, 0x10018
; GFX12-NEXT:    s_bfe_i32 s5, s2, 0x10000
; GFX12-NEXT:    s_bfe_i32 s6, s2, 0x10013
; GFX12-NEXT:    s_bfe_i32 s7, s2, 0x10012
; GFX12-NEXT:    v_lshrrev_b16 v16, 4, s3
; GFX12-NEXT:    v_lshrrev_b16 v20, 5, s3
; GFX12-NEXT:    v_lshrrev_b16 v21, 6, s3
; GFX12-NEXT:    v_lshrrev_b16 v22, 7, s3
; GFX12-NEXT:    v_lshrrev_b16 v17, 1, s3
; GFX12-NEXT:    v_lshrrev_b16 v18, 2, s3
; GFX12-NEXT:    v_lshrrev_b16 v19, 3, s3
; GFX12-NEXT:    s_bfe_i32 s3, s2, 0x10011
; GFX12-NEXT:    s_bfe_i32 s8, s2, 0x10010
; GFX12-NEXT:    s_bfe_i32 s9, s2, 0x10017
; GFX12-NEXT:    s_bfe_i32 s10, s2, 0x10016
; GFX12-NEXT:    s_bfe_i32 s11, s2, 0x10014
; GFX12-NEXT:    s_bfe_i32 s2, s2, 0x10015
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v32, 0 :: v_dual_mov_b32 v25, s2
; GFX12-NEXT:    v_bfe_i32 v15, v14, 0, 1
; GFX12-NEXT:    v_dual_mov_b32 v24, s11 :: v_dual_mov_b32 v27, s9
; GFX12-NEXT:    v_dual_mov_b32 v26, s10 :: v_dual_mov_b32 v29, s3
; GFX12-NEXT:    v_bfe_i32 v14, v13, 0, 1
; GFX12-NEXT:    v_bfe_i32 v13, v12, 0, 1
; GFX12-NEXT:    v_bfe_i32 v12, v0, 0, 1
; GFX12-NEXT:    v_bfe_i32 v11, v11, 0, 1
; GFX12-NEXT:    v_bfe_i32 v10, v10, 0, 1
; GFX12-NEXT:    v_bfe_i32 v9, v9, 0, 1
; GFX12-NEXT:    v_bfe_i32 v8, v8, 0, 1
; GFX12-NEXT:    v_dual_mov_b32 v28, s8 :: v_dual_mov_b32 v31, s6
; GFX12-NEXT:    v_mov_b32_e32 v30, s7
; GFX12-NEXT:    v_bfe_i32 v7, v7, 0, 1
; GFX12-NEXT:    v_bfe_i32 v6, v6, 0, 1
; GFX12-NEXT:    v_bfe_i32 v5, v5, 0, 1
; GFX12-NEXT:    v_bfe_i32 v4, v4, 0, 1
; GFX12-NEXT:    v_bfe_i32 v3, v3, 0, 1
; GFX12-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX12-NEXT:    v_bfe_i32 v1, v1, 0, 1
; GFX12-NEXT:    v_mov_b32_e32 v0, s5
; GFX12-NEXT:    v_bfe_i32 v23, v22, 0, 1
; GFX12-NEXT:    v_bfe_i32 v22, v21, 0, 1
; GFX12-NEXT:    v_bfe_i32 v21, v20, 0, 1
; GFX12-NEXT:    v_bfe_i32 v20, v16, 0, 1
; GFX12-NEXT:    v_bfe_i32 v19, v19, 0, 1
; GFX12-NEXT:    v_bfe_i32 v18, v18, 0, 1
; GFX12-NEXT:    v_bfe_i32 v17, v17, 0, 1
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v32, v[24:27], s[0:1] offset:80
; GFX12-NEXT:    global_store_b128 v32, v[28:31], s[0:1] offset:64
; GFX12-NEXT:    v_mov_b32_e32 v16, s4
; GFX12-NEXT:    s_clause 0x5
; GFX12-NEXT:    global_store_b128 v32, v[12:15], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v32, v[8:11], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v32, v[4:7], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v32, v[0:3], s[0:1]
; GFX12-NEXT:    global_store_b128 v32, v[20:23], s[0:1] offset:112
; GFX12-NEXT:    global_store_b128 v32, v[16:19], s[0:1] offset:96
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <32 x i1>, ptr addrspace(4) %in
  %ext = sext <32 x i1> %load to <32 x i32>
  store <32 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v64i1_to_v64i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v64i1_to_v64i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_bfe_u32 s4, s2, 0x10003
; GFX6-NEXT:    s_bfe_u32 s5, s2, 0x10001
; GFX6-NEXT:    s_bfe_u32 s6, s2, 0x10007
; GFX6-NEXT:    s_bfe_u32 s7, s2, 0x10005
; GFX6-NEXT:    s_bfe_u32 s8, s2, 0x1000b
; GFX6-NEXT:    s_bfe_u32 s9, s2, 0x10009
; GFX6-NEXT:    s_bfe_u32 s10, s2, 0x1000f
; GFX6-NEXT:    s_bfe_u32 s11, s2, 0x1000d
; GFX6-NEXT:    s_bfe_u32 s12, s2, 0x10013
; GFX6-NEXT:    s_bfe_u32 s13, s2, 0x10011
; GFX6-NEXT:    s_bfe_u32 s14, s2, 0x10017
; GFX6-NEXT:    s_bfe_u32 s15, s2, 0x10015
; GFX6-NEXT:    s_bfe_u32 s16, s2, 0x1001b
; GFX6-NEXT:    s_bfe_u32 s17, s2, 0x10019
; GFX6-NEXT:    s_lshr_b32 s18, s2, 31
; GFX6-NEXT:    s_bfe_u32 s19, s2, 0x1001d
; GFX6-NEXT:    s_bfe_u32 s20, s3, 0x10003
; GFX6-NEXT:    s_bfe_u32 s21, s3, 0x10001
; GFX6-NEXT:    s_bfe_u32 s22, s3, 0x10007
; GFX6-NEXT:    s_bfe_u32 s23, s3, 0x10005
; GFX6-NEXT:    s_bfe_u32 s24, s3, 0x1000b
; GFX6-NEXT:    s_bfe_u32 s25, s3, 0x10009
; GFX6-NEXT:    s_bfe_u32 s26, s3, 0x1000f
; GFX6-NEXT:    s_bfe_u32 s27, s3, 0x1000d
; GFX6-NEXT:    s_bfe_u32 s28, s3, 0x10013
; GFX6-NEXT:    s_bfe_u32 s29, s3, 0x10011
; GFX6-NEXT:    s_bfe_u32 s30, s3, 0x10017
; GFX6-NEXT:    s_bfe_u32 s31, s3, 0x10015
; GFX6-NEXT:    s_bfe_u32 s33, s3, 0x1001b
; GFX6-NEXT:    s_bfe_u32 s34, s3, 0x10019
; GFX6-NEXT:    s_lshr_b32 s35, s3, 31
; GFX6-NEXT:    s_bfe_u32 s36, s3, 0x1001d
; GFX6-NEXT:    s_and_b32 s37, s2, 1
; GFX6-NEXT:    s_bfe_u32 s38, s2, 0x10002
; GFX6-NEXT:    s_bfe_u32 s39, s2, 0x10006
; GFX6-NEXT:    s_bfe_u32 s40, s2, 0x10004
; GFX6-NEXT:    s_bfe_u32 s41, s2, 0x1000a
; GFX6-NEXT:    s_bfe_u32 s42, s2, 0x10008
; GFX6-NEXT:    s_bfe_u32 s43, s2, 0x1000e
; GFX6-NEXT:    s_bfe_u32 s44, s2, 0x1000c
; GFX6-NEXT:    s_bfe_u32 s45, s2, 0x10012
; GFX6-NEXT:    s_bfe_u32 s46, s2, 0x10010
; GFX6-NEXT:    s_bfe_u32 s47, s2, 0x10016
; GFX6-NEXT:    s_bfe_u32 s48, s2, 0x10014
; GFX6-NEXT:    s_bfe_u32 s49, s2, 0x1001a
; GFX6-NEXT:    s_bfe_u32 s50, s2, 0x10018
; GFX6-NEXT:    s_bfe_u32 s51, s2, 0x1001e
; GFX6-NEXT:    s_bfe_u32 s52, s2, 0x1001c
; GFX6-NEXT:    s_and_b32 s53, s3, 1
; GFX6-NEXT:    s_bfe_u32 s54, s3, 0x10002
; GFX6-NEXT:    s_bfe_u32 s55, s3, 0x10006
; GFX6-NEXT:    s_bfe_u32 s56, s3, 0x10004
; GFX6-NEXT:    s_bfe_u32 s57, s3, 0x1000a
; GFX6-NEXT:    s_bfe_u32 s58, s3, 0x10008
; GFX6-NEXT:    s_bfe_u32 s59, s3, 0x1000e
; GFX6-NEXT:    s_bfe_u32 s60, s3, 0x10012
; GFX6-NEXT:    s_bfe_u32 s61, s3, 0x10010
; GFX6-NEXT:    s_bfe_u32 s62, s3, 0x10016
; GFX6-NEXT:    s_bfe_u32 s63, s3, 0x1001a
; GFX6-NEXT:    s_bfe_u32 s64, s3, 0x10018
; GFX6-NEXT:    s_bfe_u32 s65, s3, 0x1001e
; GFX6-NEXT:    s_bfe_u32 s66, s3, 0x1001c
; GFX6-NEXT:    s_bfe_u32 s67, s3, 0x10014
; GFX6-NEXT:    s_bfe_u32 s68, s3, 0x1000c
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s66
; GFX6-NEXT:    v_mov_b32_e32 v1, s36
; GFX6-NEXT:    v_mov_b32_e32 v2, s65
; GFX6-NEXT:    v_mov_b32_e32 v3, s35
; GFX6-NEXT:    v_mov_b32_e32 v4, s64
; GFX6-NEXT:    v_mov_b32_e32 v5, s34
; GFX6-NEXT:    v_mov_b32_e32 v6, s63
; GFX6-NEXT:    v_mov_b32_e32 v7, s33
; GFX6-NEXT:    v_mov_b32_e32 v8, s67
; GFX6-NEXT:    v_mov_b32_e32 v9, s31
; GFX6-NEXT:    v_mov_b32_e32 v10, s62
; GFX6-NEXT:    v_mov_b32_e32 v11, s30
; GFX6-NEXT:    v_mov_b32_e32 v12, s61
; GFX6-NEXT:    v_mov_b32_e32 v13, s29
; GFX6-NEXT:    v_mov_b32_e32 v14, s60
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:240
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:224
; GFX6-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:208
; GFX6-NEXT:    v_mov_b32_e32 v15, s28
; GFX6-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:192
; GFX6-NEXT:    s_waitcnt expcnt(3)
; GFX6-NEXT:    v_mov_b32_e32 v0, s68
; GFX6-NEXT:    v_mov_b32_e32 v1, s27
; GFX6-NEXT:    v_mov_b32_e32 v2, s59
; GFX6-NEXT:    v_mov_b32_e32 v3, s26
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:176
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s58
; GFX6-NEXT:    v_mov_b32_e32 v1, s25
; GFX6-NEXT:    v_mov_b32_e32 v2, s57
; GFX6-NEXT:    v_mov_b32_e32 v3, s24
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:160
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s56
; GFX6-NEXT:    v_mov_b32_e32 v1, s23
; GFX6-NEXT:    v_mov_b32_e32 v2, s55
; GFX6-NEXT:    v_mov_b32_e32 v3, s22
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:144
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s53
; GFX6-NEXT:    v_mov_b32_e32 v1, s21
; GFX6-NEXT:    v_mov_b32_e32 v2, s54
; GFX6-NEXT:    v_mov_b32_e32 v3, s20
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:128
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s52
; GFX6-NEXT:    v_mov_b32_e32 v1, s19
; GFX6-NEXT:    v_mov_b32_e32 v2, s51
; GFX6-NEXT:    v_mov_b32_e32 v3, s18
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:112
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s50
; GFX6-NEXT:    v_mov_b32_e32 v1, s17
; GFX6-NEXT:    v_mov_b32_e32 v2, s49
; GFX6-NEXT:    v_mov_b32_e32 v3, s16
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:96
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s48
; GFX6-NEXT:    v_mov_b32_e32 v1, s15
; GFX6-NEXT:    v_mov_b32_e32 v2, s47
; GFX6-NEXT:    v_mov_b32_e32 v3, s14
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:80
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s46
; GFX6-NEXT:    v_mov_b32_e32 v1, s13
; GFX6-NEXT:    v_mov_b32_e32 v2, s45
; GFX6-NEXT:    v_mov_b32_e32 v3, s12
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:64
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s44
; GFX6-NEXT:    v_mov_b32_e32 v1, s11
; GFX6-NEXT:    v_mov_b32_e32 v2, s43
; GFX6-NEXT:    v_mov_b32_e32 v3, s10
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s42
; GFX6-NEXT:    v_mov_b32_e32 v1, s9
; GFX6-NEXT:    v_mov_b32_e32 v2, s41
; GFX6-NEXT:    v_mov_b32_e32 v3, s8
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:32
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s40
; GFX6-NEXT:    v_mov_b32_e32 v1, s7
; GFX6-NEXT:    v_mov_b32_e32 v2, s39
; GFX6-NEXT:    v_mov_b32_e32 v3, s6
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s37
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s38
; GFX6-NEXT:    v_mov_b32_e32 v3, s4
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v64i1_to_v64i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s6, s3, 24
; GFX8-NEXT:    s_lshr_b32 s8, s2, 24
; GFX8-NEXT:    s_bfe_u32 s4, s2, 0x10018
; GFX8-NEXT:    s_bfe_u32 s5, s3, 0x10018
; GFX8-NEXT:    s_and_b32 s7, s3, 1
; GFX8-NEXT:    s_and_b32 s9, s2, 1
; GFX8-NEXT:    s_bfe_u32 s12, s2, 0x10013
; GFX8-NEXT:    s_bfe_u32 s13, s2, 0x10012
; GFX8-NEXT:    s_bfe_u32 s14, s2, 0x10011
; GFX8-NEXT:    s_bfe_u32 s15, s2, 0x10010
; GFX8-NEXT:    s_bfe_u32 s16, s2, 0x10017
; GFX8-NEXT:    s_bfe_u32 s17, s2, 0x10016
; GFX8-NEXT:    s_bfe_u32 s18, s2, 0x10015
; GFX8-NEXT:    s_bfe_u32 s19, s2, 0x10014
; GFX8-NEXT:    s_bfe_u32 s20, s3, 0x10013
; GFX8-NEXT:    s_bfe_u32 s21, s3, 0x10012
; GFX8-NEXT:    s_bfe_u32 s22, s3, 0x10011
; GFX8-NEXT:    s_bfe_u32 s23, s3, 0x10010
; GFX8-NEXT:    s_bfe_u32 s10, s3, 0x10017
; GFX8-NEXT:    s_bfe_u32 s11, s3, 0x10016
; GFX8-NEXT:    s_bfe_u32 s24, s3, 0x10015
; GFX8-NEXT:    s_bfe_u32 s25, s3, 0x10014
; GFX8-NEXT:    v_mov_b32_e32 v25, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 0xd0
; GFX8-NEXT:    v_mov_b32_e32 v24, s11
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v27, s11
; GFX8-NEXT:    v_mov_b32_e32 v26, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 0xc0
; GFX8-NEXT:    v_mov_b32_e32 v22, s25
; GFX8-NEXT:    v_mov_b32_e32 v23, s24
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s11
; GFX8-NEXT:    v_mov_b32_e32 v26, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 0x50
; GFX8-NEXT:    v_mov_b32_e32 v22, s23
; GFX8-NEXT:    v_mov_b32_e32 v23, s22
; GFX8-NEXT:    v_mov_b32_e32 v24, s21
; GFX8-NEXT:    v_mov_b32_e32 v25, s20
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s11
; GFX8-NEXT:    v_mov_b32_e32 v26, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 64
; GFX8-NEXT:    v_mov_b32_e32 v22, s19
; GFX8-NEXT:    v_mov_b32_e32 v23, s18
; GFX8-NEXT:    v_mov_b32_e32 v24, s17
; GFX8-NEXT:    v_mov_b32_e32 v25, s16
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s11
; GFX8-NEXT:    v_mov_b32_e32 v26, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 48
; GFX8-NEXT:    v_mov_b32_e32 v22, s15
; GFX8-NEXT:    v_mov_b32_e32 v23, s14
; GFX8-NEXT:    v_mov_b32_e32 v24, s13
; GFX8-NEXT:    v_mov_b32_e32 v25, s12
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 13, s2
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_lshrrev_b16_e64 v19, 12, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v22, 7, s3
; GFX8-NEXT:    v_mov_b32_e32 v25, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v20, 14, s2
; GFX8-NEXT:    v_and_b32_e32 v21, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v27, 1, v22
; GFX8-NEXT:    v_lshrrev_b16_e64 v22, 1, s3
; GFX8-NEXT:    v_mov_b32_e32 v24, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 32
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 9, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 11, s2
; GFX8-NEXT:    v_and_b32_e32 v28, 1, v22
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v20
; GFX8-NEXT:    v_lshrrev_b16_e64 v23, 15, s2
; GFX8-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; GFX8-NEXT:    v_and_b32_e32 v20, 1, v19
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v14, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v16, 10, s2
; GFX8-NEXT:    v_and_b32_e32 v17, 1, v1
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v2
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 5, s2
; GFX8-NEXT:    flat_store_dwordx4 v[24:25], v[20:23]
; GFX8-NEXT:    v_lshrrev_b16_e64 v19, 3, s3
; GFX8-NEXT:    v_mov_b32_e32 v25, 1
; GFX8-NEXT:    v_mov_b32_e32 v21, s11
; GFX8-NEXT:    v_and_b32_e32 v12, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 7, s2
; GFX8-NEXT:    v_and_b32_e32 v23, 1, v19
; GFX8-NEXT:    v_and_b32_e32 v19, 0xffff, v18
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v16
; GFX8-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX8-NEXT:    v_and_b32_sdwa v16, v14, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v20, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 5, s6
; GFX8-NEXT:    v_and_b32_e32 v15, 1, v0
; GFX8-NEXT:    flat_store_dwordx4 v[20:21], v[16:19]
; GFX8-NEXT:    v_and_b32_e32 v20, 1, v14
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 1, s6
; GFX8-NEXT:    s_add_u32 s10, s0, 16
; GFX8-NEXT:    v_and_b32_e32 v17, 1, v14
; GFX8-NEXT:    v_and_b32_e32 v14, 0xffff, v15
; GFX8-NEXT:    v_lshrrev_b16_e64 v15, 3, s6
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    v_lshrrev_b16_e64 v11, 4, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v13, 6, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 1, s2
; GFX8-NEXT:    v_and_b32_e32 v19, 1, v15
; GFX8-NEXT:    v_mov_b32_e32 v16, s11
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 3, s2
; GFX8-NEXT:    v_and_b32_e32 v13, 1, v13
; GFX8-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX8-NEXT:    v_and_b32_e32 v11, 1, v11
; GFX8-NEXT:    v_mov_b32_e32 v15, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v9, 2, s2
; GFX8-NEXT:    v_and_b32_e32 v10, 1, v0
; GFX8-NEXT:    flat_store_dwordx4 v[15:16], v[11:14]
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 13, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v11, 5, s8
; GFX8-NEXT:    v_mov_b32_e32 v13, s1
; GFX8-NEXT:    v_and_b32_e32 v15, 1, v11
; GFX8-NEXT:    v_and_b32_e32 v11, 0xffff, v10
; GFX8-NEXT:    v_and_b32_e32 v10, 1, v9
; GFX8-NEXT:    v_and_b32_e32 v9, 0xffff, v8
; GFX8-NEXT:    v_mov_b32_e32 v8, s9
; GFX8-NEXT:    v_mov_b32_e32 v12, s0
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; GFX8-NEXT:    s_add_u32 s10, s0, 0xb0
; GFX8-NEXT:    v_lshrrev_b16_e64 v8, 1, s8
; GFX8-NEXT:    v_lshrrev_b16_e64 v5, 12, s3
; GFX8-NEXT:    v_and_b32_e32 v6, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e64 v7, 14, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 9, s3
; GFX8-NEXT:    v_and_b32_e32 v11, 1, v8
; GFX8-NEXT:    v_lshrrev_b16_e64 v8, 3, s8
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v9, s10
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v13, 1, v8
; GFX8-NEXT:    v_and_b32_e32 v7, 1, v7
; GFX8-NEXT:    v_lshrrev_b16_e64 v8, 15, s3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 1, v5
; GFX8-NEXT:    v_mov_b32_e32 v10, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v3, 10, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 11, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v18, 2, s6
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 4, s8
; GFX8-NEXT:    v_lshrrev_b16_e64 v16, 6, s8
; GFX8-NEXT:    flat_store_dwordx4 v[9:10], v[5:8]
; GFX8-NEXT:    s_add_u32 s2, s0, 0xa0
; GFX8-NEXT:    v_and_b32_e32 v7, 0xffff, v13
; GFX8-NEXT:    v_and_b32_e32 v13, 0xffff, v17
; GFX8-NEXT:    v_and_b32_e32 v17, 0xffff, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 4, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 5, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v26, 6, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v22, 2, s3
; GFX8-NEXT:    v_and_b32_e32 v10, 1, v16
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v14
; GFX8-NEXT:    v_and_b32_e32 v14, 1, v18
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v3
; GFX8-NEXT:    v_and_b32_sdwa v16, v2, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX8-NEXT:    v_and_b32_e32 v9, 0xffff, v15
; GFX8-NEXT:    v_and_b32_e32 v15, 0xffff, v19
; GFX8-NEXT:    v_and_b32_e32 v19, 0xffff, v4
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0x90
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[16:19]
; GFX8-NEXT:    v_and_b32_e32 v21, 0xffff, v1
; GFX8-NEXT:    v_and_b32_e32 v17, 0xffff, v20
; GFX8-NEXT:    v_and_b32_e32 v20, 1, v0
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v4, 6, s6
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0x80
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v4
; GFX8-NEXT:    v_and_b32_e32 v4, 0xffff, v23
; GFX8-NEXT:    v_and_b32_e32 v3, 1, v22
; GFX8-NEXT:    v_and_b32_e32 v23, 0xffff, v27
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v26
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[20:23]
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff, v28
; GFX8-NEXT:    v_mov_b32_e32 v21, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v20, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 0xf0
; GFX8-NEXT:    v_lshrrev_b16_e64 v24, 4, s6
; GFX8-NEXT:    flat_store_dwordx4 v[20:21], v[1:4]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v19, 7, s6
; GFX8-NEXT:    v_and_b32_e32 v16, 1, v24
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0xe0
; GFX8-NEXT:    v_lshrrev_b16_e64 v12, 2, s8
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[16:19]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_and_b32_e32 v6, 1, v12
; GFX8-NEXT:    v_mov_b32_e32 v12, s5
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0x70
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[12:15]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff, v11
; GFX8-NEXT:    v_lshrrev_b16_e64 v11, 7, s8
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 0x60
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[8:11]
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v64i1_to_v64i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @24, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @22
; EG-NEXT:    ALU 96, @25, KC0[CB0:0-32], KC1[]
; EG-NEXT:    ALU 57, @122, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T48.XYZW, T50.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T46.XYZW, T49.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T44.XYZW, T47.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T42.XYZW, T45.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T40.XYZW, T43.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T38.XYZW, T41.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T36.XYZW, T39.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T35.XYZW, T37.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T33.XYZW, T21.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T31.XYZW, T34.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T29.XYZW, T32.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T27.XYZW, T30.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T25.XYZW, T28.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T23.XYZW, T26.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T20.XYZW, T24.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T19.XYZW, T22.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 22:
; EG-NEXT:     VTX_READ_64 T21.XY, T19.X, 0, #1
; EG-NEXT:    ALU clause starting at 24:
; EG-NEXT:     MOV * T19.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 25:
; EG-NEXT:     BFE_UINT * T19.W, T21.X, literal.x, 1,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT * T19.Z, T21.X, literal.x, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T19.Y, T21.X, 1, 1,
; EG-NEXT:     BFE_UINT * T20.W, T21.X, literal.x, 1,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T19.X, T21.X, 1,
; EG-NEXT:     BFE_UINT T20.Z, T21.X, literal.x, 1,
; EG-NEXT:     LSHR * T22.X, KC0[2].Y, literal.y,
; EG-NEXT:    6(8.407791e-45), 2(2.802597e-45)
; EG-NEXT:     BFE_UINT T20.Y, T21.X, literal.x, 1,
; EG-NEXT:     BFE_UINT * T23.W, T21.X, literal.y, 1,
; EG-NEXT:    5(7.006492e-45), 11(1.541428e-44)
; EG-NEXT:     BFE_UINT T20.X, T21.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T23.Z, T21.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    4(5.605194e-45), 10(1.401298e-44)
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T24.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T23.Y, T21.X, literal.y, 1,
; EG-NEXT:     BFE_UINT * T25.W, T21.X, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 9(1.261169e-44)
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T23.X, T21.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T25.Z, T21.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    8(1.121039e-44), 14(1.961818e-44)
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T26.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T25.Y, T21.X, literal.y, 1,
; EG-NEXT:     BFE_UINT * T27.W, T21.X, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 13(1.821688e-44)
; EG-NEXT:    19(2.662467e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T25.X, T21.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T27.Z, T21.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    12(1.681558e-44), 18(2.522337e-44)
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T28.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T27.Y, T21.X, literal.y, 1,
; EG-NEXT:     BFE_UINT * T29.W, T21.X, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 17(2.382207e-44)
; EG-NEXT:    23(3.222986e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T27.X, T21.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T29.Z, T21.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    16(2.242078e-44), 22(3.082857e-44)
; EG-NEXT:    64(8.968310e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T30.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T29.Y, T21.X, literal.y, 1,
; EG-NEXT:     BFE_UINT * T31.W, T21.X, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 21(2.942727e-44)
; EG-NEXT:    27(3.783506e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T29.X, T21.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T31.Z, T21.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    20(2.802597e-44), 26(3.643376e-44)
; EG-NEXT:    80(1.121039e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T32.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T31.Y, T21.X, literal.y, 1,
; EG-NEXT:     LSHR * T33.W, T21.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 25(3.503246e-44)
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T31.X, T21.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T33.Z, T21.X, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    24(3.363116e-44), 30(4.203895e-44)
; EG-NEXT:    96(1.345247e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T34.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T33.Y, T21.X, literal.y, 1,
; EG-NEXT:     BFE_UINT * T35.W, T21.Y, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 29(4.063766e-44)
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T33.X, T21.X, literal.x, 1,
; EG-NEXT:     BFE_UINT T35.Z, T21.Y, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    28(3.923636e-44), 2(2.802597e-45)
; EG-NEXT:    112(1.569454e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T21.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T35.Y, T21.Y, 1, 1,
; EG-NEXT:     BFE_UINT T36.W, T21.Y, literal.y, 1,
; EG-NEXT:     AND_INT * T35.X, T21.Y, 1,
; EG-NEXT:    2(2.802597e-45), 7(9.809089e-45)
; EG-NEXT:     BFE_UINT T36.Z, T21.Y, literal.x, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    6(8.407791e-45), 128(1.793662e-43)
; EG-NEXT:     LSHR T37.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T36.Y, T21.Y, literal.y, 1,
; EG-NEXT:     BFE_UINT * T38.W, T21.Y, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 5(7.006492e-45)
; EG-NEXT:    11(1.541428e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T36.X, T21.Y, literal.x, 1,
; EG-NEXT:     BFE_UINT T38.Z, T21.Y, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    4(5.605194e-45), 10(1.401298e-44)
; EG-NEXT:    144(2.017870e-43), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 122:
; EG-NEXT:     LSHR T39.X, T0.W, literal.x,
; EG-NEXT:     BFE_UINT T38.Y, T21.Y, literal.y, 1,
; EG-NEXT:     BFE_UINT * T40.W, T21.Y, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 9(1.261169e-44)
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T38.X, T21.Y, literal.x, 1,
; EG-NEXT:     BFE_UINT T40.Z, T21.Y, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    8(1.121039e-44), 14(1.961818e-44)
; EG-NEXT:    160(2.242078e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T41.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T40.Y, T21.Y, literal.y, 1,
; EG-NEXT:     BFE_UINT * T42.W, T21.Y, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 13(1.821688e-44)
; EG-NEXT:    19(2.662467e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T40.X, T21.Y, literal.x, 1,
; EG-NEXT:     BFE_UINT T42.Z, T21.Y, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    12(1.681558e-44), 18(2.522337e-44)
; EG-NEXT:    176(2.466285e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T43.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T42.Y, T21.Y, literal.y, 1,
; EG-NEXT:     BFE_UINT * T44.W, T21.Y, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 17(2.382207e-44)
; EG-NEXT:    23(3.222986e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T42.X, T21.Y, literal.x, 1,
; EG-NEXT:     BFE_UINT T44.Z, T21.Y, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    16(2.242078e-44), 22(3.082857e-44)
; EG-NEXT:    192(2.690493e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T45.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T44.Y, T21.Y, literal.y, 1,
; EG-NEXT:     BFE_UINT * T46.W, T21.Y, literal.z, 1,
; EG-NEXT:    2(2.802597e-45), 21(2.942727e-44)
; EG-NEXT:    27(3.783506e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T44.X, T21.Y, literal.x, 1,
; EG-NEXT:     BFE_UINT T46.Z, T21.Y, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    20(2.802597e-44), 26(3.643376e-44)
; EG-NEXT:    208(2.914701e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T47.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT T46.Y, T21.Y, literal.y, 1,
; EG-NEXT:     LSHR * T48.W, T21.Y, literal.z,
; EG-NEXT:    2(2.802597e-45), 25(3.503246e-44)
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T46.X, T21.Y, literal.x, 1,
; EG-NEXT:     BFE_UINT T48.Z, T21.Y, literal.y, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.z,
; EG-NEXT:    24(3.363116e-44), 30(4.203895e-44)
; EG-NEXT:    224(3.138909e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T49.X, PV.W, literal.x,
; EG-NEXT:     BFE_UINT * T48.Y, T21.Y, literal.y, 1,
; EG-NEXT:    2(2.802597e-45), 29(4.063766e-44)
; EG-NEXT:     BFE_UINT T48.X, T21.Y, literal.x, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    28(3.923636e-44), 240(3.363116e-43)
; EG-NEXT:     LSHR * T50.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v64i1_to_v64i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v2, 13, s2
; GFX12-NEXT:    s_lshr_b32 s4, s3, 24
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    v_lshrrev_b16 v10, 13, s3
; GFX12-NEXT:    v_lshrrev_b16 v3, 9, s2
; GFX12-NEXT:    v_and_b32_e32 v45, 1, v2
; GFX12-NEXT:    v_lshrrev_b16 v2, 1, s4
; GFX12-NEXT:    v_lshrrev_b16 v4, 11, s2
; GFX12-NEXT:    v_lshrrev_b16 v5, 5, s2
; GFX12-NEXT:    v_lshrrev_b16 v7, 1, s2
; GFX12-NEXT:    v_lshrrev_b16 v8, 3, s2
; GFX12-NEXT:    v_lshrrev_b16 v12, 11, s3
; GFX12-NEXT:    v_lshrrev_b16 v14, 7, s3
; GFX12-NEXT:    v_lshrrev_b16 v18, 5, s4
; GFX12-NEXT:    s_lshr_b32 s5, s2, 24
; GFX12-NEXT:    s_and_b32 s6, s3, 1
; GFX12-NEXT:    s_bfe_u32 s14, s3, 0x10012
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v55, s14 :: v_dual_and_b32 v36, 1, v10
; GFX12-NEXT:    v_and_b32_e32 v10, 1, v2
; GFX12-NEXT:    v_lshrrev_b16 v2, 3, s4
; GFX12-NEXT:    v_lshrrev_b16 v6, 7, s2
; GFX12-NEXT:    v_lshrrev_b16 v11, 9, s3
; GFX12-NEXT:    v_lshrrev_b16 v13, 5, s3
; GFX12-NEXT:    v_lshrrev_b16 v15, 1, s3
; GFX12-NEXT:    v_lshrrev_b16 v16, 3, s3
; GFX12-NEXT:    v_and_b32_e32 v43, 1, v4
; GFX12-NEXT:    v_lshrrev_b16 v4, 3, s5
; GFX12-NEXT:    s_bfe_u32 s19, s3, 0x10014
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v49, s19 :: v_dual_and_b32 v42, 1, v3
; GFX12-NEXT:    v_lshrrev_b16 v3, 5, s5
; GFX12-NEXT:    s_bfe_u32 s13, s3, 0x10013
; GFX12-NEXT:    v_lshrrev_b16 v29, 12, s3
; GFX12-NEXT:    v_lshrrev_b16 v30, 14, s3
; GFX12-NEXT:    v_lshrrev_b16 v31, 15, s3
; GFX12-NEXT:    v_lshrrev_b16 v25, 8, s3
; GFX12-NEXT:    v_lshrrev_b16 v26, 10, s3
; GFX12-NEXT:    v_lshrrev_b16 v21, 4, s3
; GFX12-NEXT:    v_lshrrev_b16 v22, 6, s3
; GFX12-NEXT:    v_dual_mov_b32 v56, s13 :: v_dual_and_b32 v27, 1, v12
; GFX12-NEXT:    v_lshrrev_b16 v19, 2, s3
; GFX12-NEXT:    v_and_b32_e32 v12, 1, v2
; GFX12-NEXT:    v_lshrrev_b16 v2, 1, s5
; GFX12-NEXT:    s_and_b32 s7, s2, 1
; GFX12-NEXT:    s_bfe_u32 s15, s3, 0x10011
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v54, s15 :: v_dual_and_b32 v35, 1, v8
; GFX12-NEXT:    v_lshrrev_b16 v8, 7, s5
; GFX12-NEXT:    s_bfe_u32 s16, s3, 0x10010
; GFX12-NEXT:    v_dual_mov_b32 v53, s16 :: v_dual_and_b32 v40, 1, v7
; GFX12-NEXT:    v_lshrrev_b16 v7, 2, s5
; GFX12-NEXT:    s_bfe_u32 s17, s3, 0x10017
; GFX12-NEXT:    s_bfe_u32 s18, s3, 0x10016
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v51, s18 :: v_dual_and_b32 v44, 1, v5
; GFX12-NEXT:    v_lshrrev_b16 v5, 4, s5
; GFX12-NEXT:    s_bfe_u32 s13, s2, 0x10015
; GFX12-NEXT:    v_and_b32_e32 v23, 1, v14
; GFX12-NEXT:    v_and_b32_e32 v14, 1, v18
; GFX12-NEXT:    v_lshrrev_b16 v18, 6, s5
; GFX12-NEXT:    s_bfe_u32 s5, s3, 0x10018
; GFX12-NEXT:    s_bfe_u32 s3, s3, 0x10015
; GFX12-NEXT:    v_dual_mov_b32 v52, s17 :: v_dual_and_b32 v39, 1, v6
; GFX12-NEXT:    v_and_b32_e32 v32, 1, v11
; GFX12-NEXT:    v_lshrrev_b16 v11, 2, s4
; GFX12-NEXT:    s_bfe_u32 s9, s2, 0x10012
; GFX12-NEXT:    v_and_b32_e32 v20, 1, v16
; GFX12-NEXT:    v_lshrrev_b16 v16, 7, s4
; GFX12-NEXT:    s_bfe_u32 s11, s2, 0x10010
; GFX12-NEXT:    v_and_b32_e32 v24, 1, v15
; GFX12-NEXT:    v_lshrrev_b16 v15, 6, s4
; GFX12-NEXT:    s_bfe_u32 s12, s2, 0x10017
; GFX12-NEXT:    v_mov_b32_e32 v50, s3
; GFX12-NEXT:    s_bfe_u32 s3, s2, 0x10016
; GFX12-NEXT:    v_and_b32_e32 v28, 1, v13
; GFX12-NEXT:    v_lshrrev_b16 v13, 4, s4
; GFX12-NEXT:    s_bfe_u32 s4, s2, 0x10018
; GFX12-NEXT:    v_and_b32_e32 v6, 1, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 1, v4
; GFX12-NEXT:    v_lshrrev_b16 v17, 15, s2
; GFX12-NEXT:    v_lshrrev_b16 v1, 12, s2
; GFX12-NEXT:    v_lshrrev_b16 v9, 14, s2
; GFX12-NEXT:    v_lshrrev_b16 v33, 8, s2
; GFX12-NEXT:    v_lshrrev_b16 v41, 10, s2
; GFX12-NEXT:    v_lshrrev_b16 v38, 6, s2
; GFX12-NEXT:    v_lshrrev_b16 v34, 2, s2
; GFX12-NEXT:    v_lshrrev_b16 v37, 4, s2
; GFX12-NEXT:    s_bfe_u32 s8, s2, 0x10013
; GFX12-NEXT:    s_bfe_u32 s10, s2, 0x10011
; GFX12-NEXT:    s_bfe_u32 s2, s2, 0x10014
; GFX12-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX12-NEXT:    v_and_b32_e32 v21, 1, v21
; GFX12-NEXT:    v_and_b32_e32 v29, 1, v29
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v0, v[49:52], s[0:1] offset:208
; GFX12-NEXT:    global_store_b128 v0, v[53:56], s[0:1] offset:192
; GFX12-NEXT:    v_mov_b32_e32 v52, s12
; GFX12-NEXT:    v_and_b32_e32 v4, 0xffff, v3
; GFX12-NEXT:    v_dual_mov_b32 v54, s10 :: v_dual_and_b32 v3, 1, v7
; GFX12-NEXT:    v_dual_mov_b32 v56, s8 :: v_dual_and_b32 v7, 1, v18
; GFX12-NEXT:    v_dual_mov_b32 v49, s2 :: v_dual_mov_b32 v50, s13
; GFX12-NEXT:    v_mov_b32_e32 v51, s3
; GFX12-NEXT:    v_dual_mov_b32 v53, s11 :: v_dual_and_b32 v18, 0xffff, v24
; GFX12-NEXT:    v_and_b32_e32 v24, 0xffff, v23
; GFX12-NEXT:    v_and_b32_e32 v23, 1, v22
; GFX12-NEXT:    v_and_b32_e32 v22, 0xffff, v28
; GFX12-NEXT:    v_and_b32_e32 v28, 0xffff, v27
; GFX12-NEXT:    v_and_b32_e32 v27, 1, v26
; GFX12-NEXT:    v_and_b32_e32 v26, 0xffff, v32
; GFX12-NEXT:    v_and_b32_e32 v32, 0xffff, v31
; GFX12-NEXT:    v_and_b32_e32 v31, 1, v30
; GFX12-NEXT:    v_and_b32_e32 v30, 0xffff, v36
; GFX12-NEXT:    v_and_b32_e32 v19, 1, v19
; GFX12-NEXT:    v_and_b32_e32 v25, 1, v25
; GFX12-NEXT:    v_dual_mov_b32 v55, s9 :: v_dual_and_b32 v48, 0xffff, v17
; GFX12-NEXT:    v_dual_mov_b32 v17, s6 :: v_dual_and_b32 v20, 0xffff, v20
; GFX12-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX12-NEXT:    v_and_b32_e32 v15, 1, v15
; GFX12-NEXT:    v_and_b32_e32 v13, 1, v13
; GFX12-NEXT:    v_and_b32_e32 v36, 0xffff, v35
; GFX12-NEXT:    v_and_b32_e32 v35, 1, v34
; GFX12-NEXT:    v_and_b32_e32 v34, 0xffff, v40
; GFX12-NEXT:    v_and_b32_e32 v40, 0xffff, v39
; GFX12-NEXT:    v_and_b32_e32 v39, 1, v38
; GFX12-NEXT:    v_and_b32_e32 v38, 0xffff, v44
; GFX12-NEXT:    v_and_b32_e32 v44, 0xffff, v43
; GFX12-NEXT:    v_and_b32_e32 v43, 1, v41
; GFX12-NEXT:    v_and_b32_e32 v47, 1, v9
; GFX12-NEXT:    v_and_b32_e32 v46, 0xffff, v45
; GFX12-NEXT:    v_and_b32_e32 v45, 1, v1
; GFX12-NEXT:    v_and_b32_e32 v41, 1, v33
; GFX12-NEXT:    v_dual_mov_b32 v33, s7 :: v_dual_and_b32 v14, 0xffff, v14
; GFX12-NEXT:    v_and_b32_e32 v11, 1, v11
; GFX12-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX12-NEXT:    v_dual_mov_b32 v9, s5 :: v_dual_and_b32 v42, 0xffff, v42
; GFX12-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX12-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX12-NEXT:    v_and_b32_e32 v5, 1, v5
; GFX12-NEXT:    v_and_b32_e32 v37, 1, v37
; GFX12-NEXT:    v_dual_mov_b32 v1, s4 :: v_dual_and_b32 v6, 0xffff, v6
; GFX12-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX12-NEXT:    s_clause 0xd
; GFX12-NEXT:    global_store_b128 v0, v[49:52], s[0:1] offset:80
; GFX12-NEXT:    global_store_b128 v0, v[53:56], s[0:1] offset:64
; GFX12-NEXT:    global_store_b128 v0, v[45:48], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v0, v[41:44], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v0, v[37:40], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v0, v[33:36], s[0:1]
; GFX12-NEXT:    global_store_b128 v0, v[29:32], s[0:1] offset:176
; GFX12-NEXT:    global_store_b128 v0, v[25:28], s[0:1] offset:160
; GFX12-NEXT:    global_store_b128 v0, v[21:24], s[0:1] offset:144
; GFX12-NEXT:    global_store_b128 v0, v[17:20], s[0:1] offset:128
; GFX12-NEXT:    global_store_b128 v0, v[13:16], s[0:1] offset:240
; GFX12-NEXT:    global_store_b128 v0, v[9:12], s[0:1] offset:224
; GFX12-NEXT:    global_store_b128 v0, v[5:8], s[0:1] offset:112
; GFX12-NEXT:    global_store_b128 v0, v[1:4], s[0:1] offset:96
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <64 x i1>, ptr addrspace(4) %in
  %ext = zext <64 x i1> %load to <64 x i32>
  store <64 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v64i1_to_v64i32(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v64i1_to_v64i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_bfe_i32 s4, s2, 0x10003
; GFX6-NEXT:    s_bfe_i32 s5, s2, 0x10002
; GFX6-NEXT:    s_bfe_i32 s6, s2, 0x10001
; GFX6-NEXT:    s_bfe_i32 s7, s2, 0x10000
; GFX6-NEXT:    s_bfe_i32 s8, s2, 0x10007
; GFX6-NEXT:    s_bfe_i32 s9, s2, 0x10006
; GFX6-NEXT:    s_bfe_i32 s10, s2, 0x10005
; GFX6-NEXT:    s_bfe_i32 s11, s2, 0x10004
; GFX6-NEXT:    s_bfe_i32 s12, s2, 0x1000b
; GFX6-NEXT:    s_bfe_i32 s13, s2, 0x1000a
; GFX6-NEXT:    s_bfe_i32 s14, s2, 0x10009
; GFX6-NEXT:    s_bfe_i32 s15, s2, 0x10008
; GFX6-NEXT:    s_bfe_i32 s16, s2, 0x1000f
; GFX6-NEXT:    s_bfe_i32 s17, s2, 0x1000e
; GFX6-NEXT:    s_bfe_i32 s18, s2, 0x1000d
; GFX6-NEXT:    s_bfe_i32 s19, s2, 0x1000c
; GFX6-NEXT:    s_bfe_i32 s20, s2, 0x10013
; GFX6-NEXT:    s_bfe_i32 s21, s2, 0x10012
; GFX6-NEXT:    s_bfe_i32 s22, s2, 0x10011
; GFX6-NEXT:    s_bfe_i32 s23, s2, 0x10010
; GFX6-NEXT:    s_bfe_i32 s24, s2, 0x10017
; GFX6-NEXT:    s_bfe_i32 s25, s2, 0x10016
; GFX6-NEXT:    s_bfe_i32 s26, s2, 0x10015
; GFX6-NEXT:    s_bfe_i32 s27, s2, 0x10014
; GFX6-NEXT:    s_bfe_i32 s28, s2, 0x1001b
; GFX6-NEXT:    s_bfe_i32 s29, s2, 0x1001a
; GFX6-NEXT:    s_bfe_i32 s30, s2, 0x10019
; GFX6-NEXT:    s_bfe_i32 s31, s2, 0x10018
; GFX6-NEXT:    s_ashr_i32 s33, s2, 31
; GFX6-NEXT:    s_bfe_i32 s34, s2, 0x1001e
; GFX6-NEXT:    s_bfe_i32 s35, s2, 0x1001d
; GFX6-NEXT:    s_bfe_i32 s36, s2, 0x1001c
; GFX6-NEXT:    s_bfe_i32 s37, s3, 0x10003
; GFX6-NEXT:    s_bfe_i32 s38, s3, 0x10002
; GFX6-NEXT:    s_bfe_i32 s39, s3, 0x10001
; GFX6-NEXT:    s_bfe_i32 s40, s3, 0x10000
; GFX6-NEXT:    s_bfe_i32 s41, s3, 0x10007
; GFX6-NEXT:    s_bfe_i32 s42, s3, 0x10006
; GFX6-NEXT:    s_bfe_i32 s43, s3, 0x10005
; GFX6-NEXT:    s_bfe_i32 s44, s3, 0x10004
; GFX6-NEXT:    s_bfe_i32 s45, s3, 0x1000b
; GFX6-NEXT:    s_bfe_i32 s46, s3, 0x1000a
; GFX6-NEXT:    s_bfe_i32 s47, s3, 0x10009
; GFX6-NEXT:    s_bfe_i32 s48, s3, 0x10008
; GFX6-NEXT:    s_bfe_i32 s49, s3, 0x1000f
; GFX6-NEXT:    s_bfe_i32 s50, s3, 0x1000e
; GFX6-NEXT:    s_bfe_i32 s51, s3, 0x1000d
; GFX6-NEXT:    s_bfe_i32 s52, s3, 0x1000c
; GFX6-NEXT:    s_bfe_i32 s53, s3, 0x10012
; GFX6-NEXT:    s_bfe_i32 s54, s3, 0x10011
; GFX6-NEXT:    s_bfe_i32 s55, s3, 0x10010
; GFX6-NEXT:    s_bfe_i32 s56, s3, 0x10017
; GFX6-NEXT:    s_bfe_i32 s57, s3, 0x10016
; GFX6-NEXT:    s_bfe_i32 s58, s3, 0x10015
; GFX6-NEXT:    s_bfe_i32 s59, s3, 0x1001b
; GFX6-NEXT:    s_bfe_i32 s60, s3, 0x1001a
; GFX6-NEXT:    s_bfe_i32 s61, s3, 0x10019
; GFX6-NEXT:    s_bfe_i32 s62, s3, 0x10018
; GFX6-NEXT:    s_ashr_i32 s63, s3, 31
; GFX6-NEXT:    s_bfe_i32 s64, s3, 0x1001e
; GFX6-NEXT:    s_bfe_i32 s65, s3, 0x1001d
; GFX6-NEXT:    s_bfe_i32 s66, s3, 0x1001c
; GFX6-NEXT:    s_bfe_i32 s67, s3, 0x10014
; GFX6-NEXT:    s_bfe_i32 s68, s3, 0x10013
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s66
; GFX6-NEXT:    v_mov_b32_e32 v1, s65
; GFX6-NEXT:    v_mov_b32_e32 v2, s64
; GFX6-NEXT:    v_mov_b32_e32 v3, s63
; GFX6-NEXT:    v_mov_b32_e32 v4, s62
; GFX6-NEXT:    v_mov_b32_e32 v5, s61
; GFX6-NEXT:    v_mov_b32_e32 v6, s60
; GFX6-NEXT:    v_mov_b32_e32 v7, s59
; GFX6-NEXT:    v_mov_b32_e32 v8, s67
; GFX6-NEXT:    v_mov_b32_e32 v9, s58
; GFX6-NEXT:    v_mov_b32_e32 v10, s57
; GFX6-NEXT:    v_mov_b32_e32 v11, s56
; GFX6-NEXT:    v_mov_b32_e32 v12, s55
; GFX6-NEXT:    v_mov_b32_e32 v13, s54
; GFX6-NEXT:    v_mov_b32_e32 v14, s53
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:240
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:224
; GFX6-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:208
; GFX6-NEXT:    v_mov_b32_e32 v15, s68
; GFX6-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:192
; GFX6-NEXT:    s_waitcnt expcnt(3)
; GFX6-NEXT:    v_mov_b32_e32 v0, s52
; GFX6-NEXT:    v_mov_b32_e32 v1, s51
; GFX6-NEXT:    v_mov_b32_e32 v2, s50
; GFX6-NEXT:    v_mov_b32_e32 v3, s49
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:176
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s48
; GFX6-NEXT:    v_mov_b32_e32 v1, s47
; GFX6-NEXT:    v_mov_b32_e32 v2, s46
; GFX6-NEXT:    v_mov_b32_e32 v3, s45
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:160
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s44
; GFX6-NEXT:    v_mov_b32_e32 v1, s43
; GFX6-NEXT:    v_mov_b32_e32 v2, s42
; GFX6-NEXT:    v_mov_b32_e32 v3, s41
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:144
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s40
; GFX6-NEXT:    v_mov_b32_e32 v1, s39
; GFX6-NEXT:    v_mov_b32_e32 v2, s38
; GFX6-NEXT:    v_mov_b32_e32 v3, s37
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:128
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s36
; GFX6-NEXT:    v_mov_b32_e32 v1, s35
; GFX6-NEXT:    v_mov_b32_e32 v2, s34
; GFX6-NEXT:    v_mov_b32_e32 v3, s33
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:112
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s31
; GFX6-NEXT:    v_mov_b32_e32 v1, s30
; GFX6-NEXT:    v_mov_b32_e32 v2, s29
; GFX6-NEXT:    v_mov_b32_e32 v3, s28
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:96
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s27
; GFX6-NEXT:    v_mov_b32_e32 v1, s26
; GFX6-NEXT:    v_mov_b32_e32 v2, s25
; GFX6-NEXT:    v_mov_b32_e32 v3, s24
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:80
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s23
; GFX6-NEXT:    v_mov_b32_e32 v1, s22
; GFX6-NEXT:    v_mov_b32_e32 v2, s21
; GFX6-NEXT:    v_mov_b32_e32 v3, s20
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:64
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s19
; GFX6-NEXT:    v_mov_b32_e32 v1, s18
; GFX6-NEXT:    v_mov_b32_e32 v2, s17
; GFX6-NEXT:    v_mov_b32_e32 v3, s16
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s15
; GFX6-NEXT:    v_mov_b32_e32 v1, s14
; GFX6-NEXT:    v_mov_b32_e32 v2, s13
; GFX6-NEXT:    v_mov_b32_e32 v3, s12
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:32
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s11
; GFX6-NEXT:    v_mov_b32_e32 v1, s10
; GFX6-NEXT:    v_mov_b32_e32 v2, s9
; GFX6-NEXT:    v_mov_b32_e32 v3, s8
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s7
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    v_mov_b32_e32 v3, s4
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v64i1_to_v64i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e64 v18, 12, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v19, 13, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v20, 14, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v21, 15, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 8, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v15, 9, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v16, 10, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v17, 11, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v10, 4, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v11, 5, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v12, 6, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v13, 7, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v7, 1, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v8, 2, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v9, 3, s2
; GFX8-NEXT:    s_lshr_b32 s7, s3, 24
; GFX8-NEXT:    s_lshr_b32 s8, s2, 24
; GFX8-NEXT:    s_bfe_i32 s4, s2, 0x10018
; GFX8-NEXT:    s_bfe_i32 s5, s3, 0x10018
; GFX8-NEXT:    s_bfe_i32 s6, s3, 0x10000
; GFX8-NEXT:    s_bfe_i32 s9, s2, 0x10000
; GFX8-NEXT:    s_bfe_i32 s12, s2, 0x10013
; GFX8-NEXT:    s_bfe_i32 s13, s2, 0x10012
; GFX8-NEXT:    s_bfe_i32 s14, s2, 0x10011
; GFX8-NEXT:    s_bfe_i32 s15, s2, 0x10010
; GFX8-NEXT:    s_bfe_i32 s16, s2, 0x10017
; GFX8-NEXT:    s_bfe_i32 s17, s2, 0x10016
; GFX8-NEXT:    s_bfe_i32 s18, s2, 0x10015
; GFX8-NEXT:    s_bfe_i32 s2, s2, 0x10014
; GFX8-NEXT:    s_bfe_i32 s19, s3, 0x10013
; GFX8-NEXT:    s_bfe_i32 s20, s3, 0x10012
; GFX8-NEXT:    s_bfe_i32 s21, s3, 0x10011
; GFX8-NEXT:    s_bfe_i32 s22, s3, 0x10010
; GFX8-NEXT:    s_bfe_i32 s10, s3, 0x10017
; GFX8-NEXT:    s_bfe_i32 s11, s3, 0x10016
; GFX8-NEXT:    s_bfe_i32 s23, s3, 0x10015
; GFX8-NEXT:    s_bfe_i32 s24, s3, 0x10014
; GFX8-NEXT:    v_mov_b32_e32 v25, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 0xd0
; GFX8-NEXT:    v_mov_b32_e32 v24, s11
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v27, s11
; GFX8-NEXT:    v_mov_b32_e32 v26, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 0xc0
; GFX8-NEXT:    v_mov_b32_e32 v22, s24
; GFX8-NEXT:    v_mov_b32_e32 v23, s23
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s11
; GFX8-NEXT:    v_mov_b32_e32 v26, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 0x50
; GFX8-NEXT:    v_mov_b32_e32 v22, s22
; GFX8-NEXT:    v_mov_b32_e32 v23, s21
; GFX8-NEXT:    v_mov_b32_e32 v24, s20
; GFX8-NEXT:    v_mov_b32_e32 v25, s19
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s11
; GFX8-NEXT:    v_mov_b32_e32 v26, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 64
; GFX8-NEXT:    v_mov_b32_e32 v22, s2
; GFX8-NEXT:    v_mov_b32_e32 v23, s18
; GFX8-NEXT:    v_mov_b32_e32 v24, s17
; GFX8-NEXT:    v_mov_b32_e32 v25, s16
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s11
; GFX8-NEXT:    v_mov_b32_e32 v26, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 48
; GFX8-NEXT:    v_mov_b32_e32 v22, s15
; GFX8-NEXT:    v_mov_b32_e32 v23, s14
; GFX8-NEXT:    v_mov_b32_e32 v24, s13
; GFX8-NEXT:    v_mov_b32_e32 v25, s12
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_bfe_i32 v21, v21, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v23, s11
; GFX8-NEXT:    v_bfe_i32 v20, v20, 0, 1
; GFX8-NEXT:    v_bfe_i32 v19, v19, 0, 1
; GFX8-NEXT:    v_bfe_i32 v18, v18, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v22, s10
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    v_lshrrev_b16_e64 v3, 12, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v4, 13, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v5, 14, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v6, 15, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 8, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 9, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 10, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v24, 11, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v26, 4, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v27, 5, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v28, 6, s3
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[18:21]
; GFX8-NEXT:    v_lshrrev_b16_e64 v22, 7, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v23, 1, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v20, 2, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v21, 3, s3
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v19, s3
; GFX8-NEXT:    v_mov_b32_e32 v18, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    v_bfe_i32 v17, v17, 0, 1
; GFX8-NEXT:    v_bfe_i32 v16, v16, 0, 1
; GFX8-NEXT:    v_bfe_i32 v15, v15, 0, 1
; GFX8-NEXT:    v_bfe_i32 v14, v14, 0, 1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[18:19], v[14:17]
; GFX8-NEXT:    v_bfe_i32 v13, v13, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v15, s3
; GFX8-NEXT:    v_bfe_i32 v12, v12, 0, 1
; GFX8-NEXT:    v_bfe_i32 v11, v11, 0, 1
; GFX8-NEXT:    v_bfe_i32 v10, v10, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v14, s2
; GFX8-NEXT:    flat_store_dwordx4 v[14:15], v[10:13]
; GFX8-NEXT:    s_add_u32 s2, s0, 0xb0
; GFX8-NEXT:    v_mov_b32_e32 v12, s1
; GFX8-NEXT:    v_bfe_i32 v10, v9, 0, 1
; GFX8-NEXT:    v_bfe_i32 v9, v8, 0, 1
; GFX8-NEXT:    v_bfe_i32 v8, v7, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v7, s9
; GFX8-NEXT:    v_mov_b32_e32 v11, s0
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[11:12], v[7:10]
; GFX8-NEXT:    v_lshrrev_b16_e64 v11, 6, s8
; GFX8-NEXT:    v_mov_b32_e32 v8, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v10, 5, s8
; GFX8-NEXT:    v_bfe_i32 v6, v6, 0, 1
; GFX8-NEXT:    v_bfe_i32 v5, v5, 0, 1
; GFX8-NEXT:    v_bfe_i32 v4, v4, 0, 1
; GFX8-NEXT:    v_bfe_i32 v3, v3, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v7, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 0xa0
; GFX8-NEXT:    v_lshrrev_b16_e64 v13, 4, s8
; GFX8-NEXT:    v_lshrrev_b16_e64 v12, 1, s8
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[3:6]
; GFX8-NEXT:    v_bfe_i32 v8, v11, 0, 1
; GFX8-NEXT:    v_lshrrev_b16_e64 v3, 2, s8
; GFX8-NEXT:    v_lshrrev_b16_e64 v4, 3, s8
; GFX8-NEXT:    v_bfe_i32 v7, v10, 0, 1
; GFX8-NEXT:    v_bfe_i32 v11, v1, 0, 1
; GFX8-NEXT:    v_bfe_i32 v10, v0, 0, 1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_bfe_i32 v5, v4, 0, 1
; GFX8-NEXT:    v_bfe_i32 v4, v3, 0, 1
; GFX8-NEXT:    v_bfe_i32 v3, v12, 0, 1
; GFX8-NEXT:    v_bfe_i32 v6, v13, 0, 1
; GFX8-NEXT:    v_bfe_i32 v13, v24, 0, 1
; GFX8-NEXT:    v_bfe_i32 v12, v2, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0x90
; GFX8-NEXT:    v_lshrrev_b16_e64 v19, 5, s7
; GFX8-NEXT:    v_lshrrev_b16_e64 v15, 2, s7
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[10:13]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_bfe_i32 v12, v15, 0, 1
; GFX8-NEXT:    v_bfe_i32 v15, v19, 0, 1
; GFX8-NEXT:    v_bfe_i32 v19, v23, 0, 1
; GFX8-NEXT:    v_bfe_i32 v25, v22, 0, 1
; GFX8-NEXT:    v_bfe_i32 v24, v28, 0, 1
; GFX8-NEXT:    v_bfe_i32 v23, v27, 0, 1
; GFX8-NEXT:    v_bfe_i32 v22, v26, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0x80
; GFX8-NEXT:    v_lshrrev_b16_e64 v18, 4, s7
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 1, s7
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[22:25]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_bfe_i32 v11, v14, 0, 1
; GFX8-NEXT:    v_bfe_i32 v14, v18, 0, 1
; GFX8-NEXT:    v_bfe_i32 v21, v21, 0, 1
; GFX8-NEXT:    v_bfe_i32 v20, v20, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v18, s6
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0xf0
; GFX8-NEXT:    v_lshrrev_b16_e64 v16, 6, s7
; GFX8-NEXT:    v_lshrrev_b16_e64 v17, 7, s7
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[18:21]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_bfe_i32 v17, v17, 0, 1
; GFX8-NEXT:    v_bfe_i32 v16, v16, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0xe0
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 3, s7
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[14:17]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_bfe_i32 v13, v2, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v10, s5
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0x70
; GFX8-NEXT:    v_lshrrev_b16_e64 v9, 7, s8
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[10:13]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_bfe_i32 v9, v9, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 0x60
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[6:9]
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[2:5]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v64i1_to_v64i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @24, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @22
; EG-NEXT:    ALU 99, @25, KC0[CB0:0-32], KC1[]
; EG-NEXT:    ALU 98, @125, KC0[CB0:0-32], KC1[]
; EG-NEXT:    ALU 13, @224, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T48.XYZW, T50.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T45.XYZW, T49.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T43.XYZW, T46.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T41.XYZW, T44.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T39.XYZW, T42.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T37.XYZW, T40.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T34.XYZW, T38.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T19.XYZW, T36.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T32.XYZW, T35.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T30.XYZW, T33.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T28.XYZW, T31.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T26.XYZW, T29.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T24.XYZW, T27.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T22.XYZW, T25.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T20.XYZW, T23.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T47.XYZW, T21.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 22:
; EG-NEXT:     VTX_READ_64 T19.XY, T19.X, 0, #1
; EG-NEXT:    ALU clause starting at 24:
; EG-NEXT:     MOV * T19.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 25:
; EG-NEXT:     LSHR * T0.W, T19.X, literal.x,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T20.W, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.X, literal.x,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T20.Z, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.X, literal.x,
; EG-NEXT:     LSHR * T1.W, T19.X, literal.y,
; EG-NEXT:    11(1.541428e-44), 5(7.006492e-45)
; EG-NEXT:     LSHR T21.X, KC0[2].Y, literal.x,
; EG-NEXT:     BFE_INT T20.Y, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.X, literal.y,
; EG-NEXT:     BFE_INT T22.W, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 10(1.401298e-44)
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T20.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T19.X, literal.x,
; EG-NEXT:     BFE_INT T22.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.X, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    15(2.101948e-44), 9(1.261169e-44)
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T23.X, PS, literal.x,
; EG-NEXT:     BFE_INT T22.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.X, literal.y,
; EG-NEXT:     BFE_INT T24.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 14(1.961818e-44)
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T22.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T19.X, literal.x,
; EG-NEXT:     BFE_INT T24.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.X, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    19(2.662467e-44), 13(1.821688e-44)
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T25.X, PS, literal.x,
; EG-NEXT:     BFE_INT T24.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.X, literal.y,
; EG-NEXT:     BFE_INT T26.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 18(2.522337e-44)
; EG-NEXT:    12(1.681558e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T24.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T19.X, literal.x,
; EG-NEXT:     BFE_INT T26.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.X, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    23(3.222986e-44), 17(2.382207e-44)
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T27.X, PS, literal.x,
; EG-NEXT:     BFE_INT T26.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.X, literal.y,
; EG-NEXT:     BFE_INT T28.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 22(3.082857e-44)
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T26.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T19.X, literal.x,
; EG-NEXT:     BFE_INT T28.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.X, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    27(3.783506e-44), 21(2.942727e-44)
; EG-NEXT:    64(8.968310e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T29.X, PS, literal.x,
; EG-NEXT:     BFE_INT T28.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.X, literal.y,
; EG-NEXT:     BFE_INT T30.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 26(3.643376e-44)
; EG-NEXT:    20(2.802597e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T28.X, PS, 0.0, 1,
; EG-NEXT:     BFE_INT T30.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.X, literal.x,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    25(3.503246e-44), 80(1.121039e-43)
; EG-NEXT:     LSHR T31.X, PS, literal.x,
; EG-NEXT:     BFE_INT T30.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.X, literal.y,
; EG-NEXT:     LSHR T0.W, T19.X, literal.z,
; EG-NEXT:     ASHR * T32.W, T19.X, literal.w,
; EG-NEXT:    2(2.802597e-45), 30(4.203895e-44)
; EG-NEXT:    24(3.363116e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_INT T30.X, PV.W, 0.0, 1,
; EG-NEXT:     BFE_INT T32.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.X, literal.x,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    29(4.063766e-44), 96(1.345247e-43)
; EG-NEXT:     LSHR T33.X, PS, literal.x,
; EG-NEXT:     BFE_INT T32.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.Y, literal.y,
; EG-NEXT:     LSHR * T1.W, T19.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 7(9.809089e-45)
; EG-NEXT:    28(3.923636e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T32.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.Y, literal.x,
; EG-NEXT:     BFE_INT T34.W, PV.W, 0.0, 1,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    6(8.407791e-45), 112(1.569454e-43)
; EG-NEXT:    ALU clause starting at 125:
; EG-NEXT:     LSHR T35.X, T0.W, literal.x,
; EG-NEXT:     LSHR T0.Y, T19.Y, literal.y,
; EG-NEXT:     BFE_INT T34.Z, T0.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.Y, literal.z,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.w,
; EG-NEXT:    2(2.802597e-45), 11(1.541428e-44)
; EG-NEXT:    5(7.006492e-45), 128(1.793662e-43)
; EG-NEXT:     LSHR T36.X, PS, literal.x,
; EG-NEXT:     BFE_INT T34.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.Y, literal.y,
; EG-NEXT:     BFE_INT T37.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.Y, literal.z,
; EG-NEXT:    2(2.802597e-45), 10(1.401298e-44)
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T34.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T19.Y, literal.x,
; EG-NEXT:     BFE_INT T37.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.Y, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    15(2.101948e-44), 9(1.261169e-44)
; EG-NEXT:    144(2.017870e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T38.X, PS, literal.x,
; EG-NEXT:     BFE_INT T37.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.Y, literal.y,
; EG-NEXT:     BFE_INT T39.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.Y, literal.z,
; EG-NEXT:    2(2.802597e-45), 14(1.961818e-44)
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T37.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T19.Y, literal.x,
; EG-NEXT:     BFE_INT T39.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.Y, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    19(2.662467e-44), 13(1.821688e-44)
; EG-NEXT:    160(2.242078e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T40.X, PS, literal.x,
; EG-NEXT:     BFE_INT T39.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.Y, literal.y,
; EG-NEXT:     BFE_INT T41.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.Y, literal.z,
; EG-NEXT:    2(2.802597e-45), 18(2.522337e-44)
; EG-NEXT:    12(1.681558e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T39.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T19.Y, literal.x,
; EG-NEXT:     BFE_INT T41.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.Y, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    23(3.222986e-44), 17(2.382207e-44)
; EG-NEXT:    176(2.466285e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T42.X, PS, literal.x,
; EG-NEXT:     BFE_INT T41.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.Y, literal.y,
; EG-NEXT:     BFE_INT T43.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.Y, literal.z,
; EG-NEXT:    2(2.802597e-45), 22(3.082857e-44)
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T41.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T19.Y, literal.x,
; EG-NEXT:     BFE_INT T43.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.Y, literal.y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.z,
; EG-NEXT:    27(3.783506e-44), 21(2.942727e-44)
; EG-NEXT:    192(2.690493e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T44.X, PS, literal.x,
; EG-NEXT:     BFE_INT T43.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.Y, literal.y,
; EG-NEXT:     BFE_INT T45.W, PV.Y, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.Y, literal.z,
; EG-NEXT:    2(2.802597e-45), 26(3.643376e-44)
; EG-NEXT:    20(2.802597e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T43.X, PS, 0.0, 1,
; EG-NEXT:     BFE_INT T45.Z, PV.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.Y, literal.x,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    25(3.503246e-44), 208(2.914701e-43)
; EG-NEXT:     LSHR T46.X, PS, literal.x,
; EG-NEXT:     BFE_INT T45.Y, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T19.Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 24(3.363116e-44)
; EG-NEXT:     BFE_INT T45.X, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.Z, T19.Y, literal.x,
; EG-NEXT:     LSHR T0.W, T19.X, 1,
; EG-NEXT:     LSHR * T1.W, T19.Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 3(4.203895e-45)
; EG-NEXT:     BFE_INT T47.X, T19.X, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T19.X, literal.x,
; EG-NEXT:     LSHR T1.Z, T19.X, literal.y,
; EG-NEXT:     LSHR T2.W, T19.Y, literal.z,
; EG-NEXT:     ASHR * T48.W, T19.Y, literal.w,
; EG-NEXT:    2(2.802597e-45), 3(4.203895e-45)
; EG-NEXT:    30(4.203895e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_INT T19.X, T19.Y, 0.0, 1,
; EG-NEXT:     LSHR T1.Y, T19.Y, literal.x,
; EG-NEXT:     BFE_INT T48.Z, PV.W, 0.0, 1,
; EG-NEXT:     BFE_INT T47.W, PV.Z, 0.0, 1,
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.y,
; EG-NEXT:    29(4.063766e-44), 224(3.138909e-43)
; EG-NEXT:     LSHR * T49.X, PS, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 224:
; EG-NEXT:     BFE_INT T48.Y, T1.Y, 0.0, 1,
; EG-NEXT:     BFE_INT T47.Z, T0.Y, 0.0, 1, BS:VEC_120/SCL_212
; EG-NEXT:     BFE_INT T19.W, T1.W, 0.0, 1,
; EG-NEXT:     LSHR * T1.W, T19.Y, literal.x,
; EG-NEXT:    28(3.923636e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T48.X, PS, 0.0, 1,
; EG-NEXT:     BFE_INT T47.Y, T0.W, 0.0, 1,
; EG-NEXT:     BFE_INT T19.Z, T0.Z, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T19.Y, 1,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    240(3.363116e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T50.X, PS, literal.x,
; EG-NEXT:     BFE_INT * T19.Y, PV.W, 0.0, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v64i1_to_v64i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshr_b32 s5, s2, 24
; GFX12-NEXT:    v_lshrrev_b16 v28, 12, s3
; GFX12-NEXT:    v_lshrrev_b16 v29, 13, s3
; GFX12-NEXT:    v_lshrrev_b16 v30, 14, s3
; GFX12-NEXT:    v_lshrrev_b16 v31, 15, s3
; GFX12-NEXT:    v_lshrrev_b16 v24, 8, s3
; GFX12-NEXT:    v_lshrrev_b16 v25, 9, s3
; GFX12-NEXT:    v_lshrrev_b16 v26, 10, s3
; GFX12-NEXT:    v_lshrrev_b16 v27, 11, s3
; GFX12-NEXT:    v_lshrrev_b16 v20, 4, s3
; GFX12-NEXT:    v_lshrrev_b16 v21, 5, s3
; GFX12-NEXT:    v_lshrrev_b16 v22, 6, s3
; GFX12-NEXT:    v_lshrrev_b16 v23, 7, s3
; GFX12-NEXT:    v_lshrrev_b16 v17, 1, s3
; GFX12-NEXT:    v_lshrrev_b16 v18, 2, s3
; GFX12-NEXT:    v_lshrrev_b16 v19, 3, s3
; GFX12-NEXT:    s_lshr_b32 s4, s3, 24
; GFX12-NEXT:    v_lshrrev_b16 v4, 4, s5
; GFX12-NEXT:    v_lshrrev_b16 v5, 5, s5
; GFX12-NEXT:    v_lshrrev_b16 v6, 6, s5
; GFX12-NEXT:    v_lshrrev_b16 v1, 3, s5
; GFX12-NEXT:    v_lshrrev_b16 v2, 2, s5
; GFX12-NEXT:    v_lshrrev_b16 v7, 1, s5
; GFX12-NEXT:    v_lshrrev_b16 v44, 7, s5
; GFX12-NEXT:    s_bfe_i32 s5, s3, 0x10018
; GFX12-NEXT:    s_bfe_i32 s6, s3, 0x10000
; GFX12-NEXT:    s_bfe_i32 s13, s3, 0x10013
; GFX12-NEXT:    s_bfe_i32 s14, s3, 0x10012
; GFX12-NEXT:    s_bfe_i32 s15, s3, 0x10011
; GFX12-NEXT:    s_bfe_i32 s16, s3, 0x10010
; GFX12-NEXT:    s_bfe_i32 s17, s3, 0x10017
; GFX12-NEXT:    s_bfe_i32 s18, s3, 0x10016
; GFX12-NEXT:    s_bfe_i32 s19, s3, 0x10014
; GFX12-NEXT:    s_bfe_i32 s3, s3, 0x10015
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v56, 0 :: v_dual_mov_b32 v49, s3
; GFX12-NEXT:    v_dual_mov_b32 v48, s19 :: v_dual_mov_b32 v51, s17
; GFX12-NEXT:    v_dual_mov_b32 v50, s18 :: v_dual_mov_b32 v53, s15
; GFX12-NEXT:    v_lshrrev_b16 v16, 14, s2
; GFX12-NEXT:    v_dual_mov_b32 v52, s16 :: v_dual_mov_b32 v55, s13
; GFX12-NEXT:    s_bfe_i32 s13, s2, 0x10015
; GFX12-NEXT:    v_mov_b32_e32 v54, s14
; GFX12-NEXT:    v_lshrrev_b16 v0, 12, s2
; GFX12-NEXT:    v_lshrrev_b16 v8, 13, s2
; GFX12-NEXT:    v_lshrrev_b16 v32, 15, s2
; GFX12-NEXT:    v_lshrrev_b16 v12, 4, s4
; GFX12-NEXT:    v_lshrrev_b16 v13, 5, s4
; GFX12-NEXT:    v_lshrrev_b16 v14, 6, s4
; GFX12-NEXT:    v_lshrrev_b16 v15, 7, s4
; GFX12-NEXT:    v_lshrrev_b16 v40, 8, s2
; GFX12-NEXT:    v_lshrrev_b16 v41, 9, s2
; GFX12-NEXT:    v_lshrrev_b16 v42, 10, s2
; GFX12-NEXT:    v_lshrrev_b16 v43, 11, s2
; GFX12-NEXT:    v_lshrrev_b16 v36, 4, s2
; GFX12-NEXT:    v_lshrrev_b16 v37, 5, s2
; GFX12-NEXT:    v_lshrrev_b16 v38, 6, s2
; GFX12-NEXT:    v_lshrrev_b16 v39, 7, s2
; GFX12-NEXT:    v_lshrrev_b16 v33, 1, s2
; GFX12-NEXT:    v_lshrrev_b16 v34, 2, s2
; GFX12-NEXT:    v_lshrrev_b16 v35, 3, s2
; GFX12-NEXT:    v_lshrrev_b16 v9, 1, s4
; GFX12-NEXT:    v_lshrrev_b16 v10, 2, s4
; GFX12-NEXT:    v_lshrrev_b16 v11, 3, s4
; GFX12-NEXT:    s_bfe_i32 s4, s2, 0x10018
; GFX12-NEXT:    s_bfe_i32 s7, s2, 0x10000
; GFX12-NEXT:    s_bfe_i32 s8, s2, 0x10013
; GFX12-NEXT:    s_bfe_i32 s9, s2, 0x10012
; GFX12-NEXT:    s_bfe_i32 s10, s2, 0x10011
; GFX12-NEXT:    s_bfe_i32 s11, s2, 0x10010
; GFX12-NEXT:    s_bfe_i32 s12, s2, 0x10017
; GFX12-NEXT:    s_bfe_i32 s3, s2, 0x10016
; GFX12-NEXT:    s_bfe_i32 s2, s2, 0x10014
; GFX12-NEXT:    v_bfe_i32 v23, v23, 0, 1
; GFX12-NEXT:    v_bfe_i32 v22, v22, 0, 1
; GFX12-NEXT:    v_bfe_i32 v21, v21, 0, 1
; GFX12-NEXT:    v_bfe_i32 v20, v20, 0, 1
; GFX12-NEXT:    v_bfe_i32 v31, v31, 0, 1
; GFX12-NEXT:    v_bfe_i32 v30, v30, 0, 1
; GFX12-NEXT:    v_bfe_i32 v29, v29, 0, 1
; GFX12-NEXT:    v_bfe_i32 v28, v28, 0, 1
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v56, v[48:51], s[0:1] offset:208
; GFX12-NEXT:    global_store_b128 v56, v[52:55], s[0:1] offset:192
; GFX12-NEXT:    v_dual_mov_b32 v49, s13 :: v_dual_mov_b32 v48, s2
; GFX12-NEXT:    v_dual_mov_b32 v51, s12 :: v_dual_mov_b32 v50, s3
; GFX12-NEXT:    v_mov_b32_e32 v53, s10
; GFX12-NEXT:    v_bfe_i32 v19, v19, 0, 1
; GFX12-NEXT:    v_bfe_i32 v18, v18, 0, 1
; GFX12-NEXT:    v_bfe_i32 v17, v17, 0, 1
; GFX12-NEXT:    v_bfe_i32 v27, v27, 0, 1
; GFX12-NEXT:    v_bfe_i32 v26, v26, 0, 1
; GFX12-NEXT:    v_bfe_i32 v25, v25, 0, 1
; GFX12-NEXT:    v_bfe_i32 v24, v24, 0, 1
; GFX12-NEXT:    v_bfe_i32 v46, v16, 0, 1
; GFX12-NEXT:    v_dual_mov_b32 v52, s11 :: v_dual_mov_b32 v55, s8
; GFX12-NEXT:    v_mov_b32_e32 v54, s9
; GFX12-NEXT:    v_mov_b32_e32 v16, s6
; GFX12-NEXT:    v_bfe_i32 v3, v1, 0, 1
; GFX12-NEXT:    v_bfe_i32 v1, v7, 0, 1
; GFX12-NEXT:    v_bfe_i32 v7, v44, 0, 1
; GFX12-NEXT:    v_bfe_i32 v15, v15, 0, 1
; GFX12-NEXT:    v_bfe_i32 v14, v14, 0, 1
; GFX12-NEXT:    v_bfe_i32 v13, v13, 0, 1
; GFX12-NEXT:    v_bfe_i32 v12, v12, 0, 1
; GFX12-NEXT:    v_bfe_i32 v47, v32, 0, 1
; GFX12-NEXT:    v_bfe_i32 v45, v8, 0, 1
; GFX12-NEXT:    v_bfe_i32 v44, v0, 0, 1
; GFX12-NEXT:    v_bfe_i32 v11, v11, 0, 1
; GFX12-NEXT:    v_bfe_i32 v10, v10, 0, 1
; GFX12-NEXT:    v_bfe_i32 v9, v9, 0, 1
; GFX12-NEXT:    v_bfe_i32 v43, v43, 0, 1
; GFX12-NEXT:    v_bfe_i32 v42, v42, 0, 1
; GFX12-NEXT:    v_bfe_i32 v41, v41, 0, 1
; GFX12-NEXT:    v_bfe_i32 v40, v40, 0, 1
; GFX12-NEXT:    v_mov_b32_e32 v8, s5
; GFX12-NEXT:    v_bfe_i32 v6, v6, 0, 1
; GFX12-NEXT:    v_bfe_i32 v5, v5, 0, 1
; GFX12-NEXT:    v_bfe_i32 v4, v4, 0, 1
; GFX12-NEXT:    v_bfe_i32 v39, v39, 0, 1
; GFX12-NEXT:    v_bfe_i32 v38, v38, 0, 1
; GFX12-NEXT:    v_bfe_i32 v37, v37, 0, 1
; GFX12-NEXT:    v_bfe_i32 v36, v36, 0, 1
; GFX12-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX12-NEXT:    v_bfe_i32 v35, v35, 0, 1
; GFX12-NEXT:    v_bfe_i32 v34, v34, 0, 1
; GFX12-NEXT:    v_bfe_i32 v33, v33, 0, 1
; GFX12-NEXT:    v_mov_b32_e32 v32, s7
; GFX12-NEXT:    s_clause 0x7
; GFX12-NEXT:    global_store_b128 v56, v[48:51], s[0:1] offset:80
; GFX12-NEXT:    global_store_b128 v56, v[52:55], s[0:1] offset:64
; GFX12-NEXT:    global_store_b128 v56, v[44:47], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v56, v[40:43], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v56, v[36:39], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v56, v[32:35], s[0:1]
; GFX12-NEXT:    global_store_b128 v56, v[28:31], s[0:1] offset:176
; GFX12-NEXT:    global_store_b128 v56, v[24:27], s[0:1] offset:160
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_clause 0x5
; GFX12-NEXT:    global_store_b128 v56, v[20:23], s[0:1] offset:144
; GFX12-NEXT:    global_store_b128 v56, v[16:19], s[0:1] offset:128
; GFX12-NEXT:    global_store_b128 v56, v[12:15], s[0:1] offset:240
; GFX12-NEXT:    global_store_b128 v56, v[8:11], s[0:1] offset:224
; GFX12-NEXT:    global_store_b128 v56, v[4:7], s[0:1] offset:112
; GFX12-NEXT:    global_store_b128 v56, v[0:3], s[0:1] offset:96
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <64 x i1>, ptr addrspace(4) %in
  %ext = sext <64 x i1> %load to <64 x i32>
  store <64 x i32> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_i1_to_i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_i1_to_i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_i1_to_i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_i1_to_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MOV * T0.Y, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_i1_to_i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_u8 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_and_b32 s2, s2, 1
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX12-NEXT:    global_store_b64 v1, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %a = load i1, ptr addrspace(4) %in
  %ext = zext i1 %a to i64
  store i64 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_i1_to_i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_i1_to_i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_i1_to_i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_i1_to_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 3, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_INT T0.X, T0.X, 0.0, 1,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV * T0.Y, PV.X,
;
; GFX12-LABEL: constant_sextload_i1_to_i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_u8 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_bfe_i64 s[2:3], s[2:3], 0x10000
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %a = load i1, ptr addrspace(4) %in
  %ext = sext i1 %a to i64
  store i64 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v1i1_to_v1i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v1i1_to_v1i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v1i1_to_v1i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v1i1_to_v1i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MOV * T0.Y, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v1i1_to_v1i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_u8 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_and_b32 s2, s2, 1
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX12-NEXT:    global_store_b64 v1, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <1 x i1>, ptr addrspace(4) %in
  %ext = zext <1 x i1> %load to <1 x i64>
  store <1 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v1i1_to_v1i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v1i1_to_v1i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v1i1_to_v1i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v1i1_to_v1i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 3, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_INT T0.X, T0.X, 0.0, 1,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV * T0.Y, PV.X,
;
; GFX12-LABEL: constant_sextload_v1i1_to_v1i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_u8 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_bfe_i64 s[2:3], s[2:3], 0x10000
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <1 x i1>, ptr addrspace(4) %in
  %ext = sext <1 x i1> %load to <1 x i64>
  store <1 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v2i1_to_v2i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v2i1_to_v2i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 1, v0
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v2i1_to_v2i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 0xffff, v3
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v2i1_to_v2i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 5, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_UINT * T0.Z, T0.X, 1, 1,
; EG-NEXT:     AND_INT T0.X, T0.X, 1,
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV T0.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v2i1_to_v2i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v1, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v2, 1, v0
; GFX12-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_and_b32 v0, 1, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX12-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <2 x i1>, ptr addrspace(4) %in
  %ext = zext <2 x i1> %load to <2 x i64>
  store <2 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v2i1_to_v2i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v2i1_to_v2i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 1, v0
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX6-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v2i1_to_v2i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 1, v0
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v2i1_to_v2i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 6, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_INT T1.X, T0.X, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T0.X, 1,
; EG-NEXT:     BFE_INT * T1.Z, PV.W, 0.0, 1,
; EG-NEXT:     MOV * T1.Y, T1.X,
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     MOV * T1.W, T1.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v2i1_to_v2i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v4, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v1, 1, v0
; GFX12-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_bfe_i32 v2, v1, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX12-NEXT:    global_store_b128 v4, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <2 x i1>, ptr addrspace(4) %in
  %ext = sext <2 x i1> %load to <2 x i64>
  store <2 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v3i1_to_v3i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v3i1_to_v3i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v4, off, s[8:11], 0
; GFX6-NEXT:    v_mov_b32_e32 v5, 0
; GFX6-NEXT:    v_mov_b32_e32 v1, v5
; GFX6-NEXT:    v_mov_b32_e32 v3, v5
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v4
; GFX6-NEXT:    v_bfe_u32 v2, v4, 1, 1
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 2, v4
; GFX6-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v3i1_to_v3i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, v5
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v7, s3
; GFX8-NEXT:    v_mov_b32_e32 v6, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, v5
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v4, 2, v0
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX8-NEXT:    flat_store_dwordx2 v[6:7], v[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_and_b32_e32 v0, 0xffff, v8
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v3i1_to_v3i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 11, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_UINT * T1.Z, T0.X, 1, 1,
; EG-NEXT:     AND_INT T1.X, T0.X, 1,
; EG-NEXT:     MOV T1.Y, 0.0,
; EG-NEXT:     LSHR * T0.X, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T1.W, 0.0,
; EG-NEXT:     LSHR T2.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR * T3.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v3i1_to_v3i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v5, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v5, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v2, 1, v0
; GFX12-NEXT:    v_lshrrev_b16 v1, 1, v0
; GFX12-NEXT:    v_lshrrev_b16 v3, 2, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_and_b32_e32 v0, 0xffff, v2
; GFX12-NEXT:    v_dual_mov_b32 v1, v5 :: v_dual_and_b32 v6, 1, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_dual_mov_b32 v3, v5 :: v_dual_and_b32 v4, 0xffff, v3
; GFX12-NEXT:    v_and_b32_e32 v2, 0xffff, v6
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b64 v5, v[4:5], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v5, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <3 x i1>, ptr addrspace(4) %in
  %ext = zext <3 x i1> %load to <3 x i64>
  store <3 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v3i1_to_v3i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v3i1_to_v3i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 2, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 1, v0
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX6-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX6-NEXT:    v_bfe_i32 v4, v3, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX6-NEXT:    buffer_store_dwordx2 v[4:5], off, s[4:7], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v3i1_to_v3i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v7, s3
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v6, s2
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 2, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 1, v0
; GFX8-NEXT:    v_bfe_i32 v8, v3, 0, 1
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v9, 31, v8
; GFX8-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX8-NEXT:    flat_store_dwordx2 v[6:7], v[8:9]
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v3i1_to_v3i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 14, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_INT T1.X, T0.X, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T0.X, 1,
; EG-NEXT:     LSHR * T2.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T1.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T0.X, PV.W, 0.0, 1,
; EG-NEXT:     MOV T1.Y, T1.X,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     MOV T0.Y, PV.X,
; EG-NEXT:     MOV * T1.W, T1.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v3i1_to_v3i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v6, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v6, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v1, 2, v0
; GFX12-NEXT:    v_lshrrev_b16 v2, 1, v0
; GFX12-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_i32 v4, v1, 0, 1
; GFX12-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX12-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b64 v6, v[4:5], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v6, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <3 x i1>, ptr addrspace(4) %in
  %ext = sext <3 x i1> %load to <3 x i64>
  store <3 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v4i1_to_v4i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v4i1_to_v4i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NEXT:    v_mov_b32_e32 v5, v1
; GFX6-NEXT:    v_mov_b32_e32 v7, v1
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, 1, v0
; GFX6-NEXT:    v_bfe_u32 v6, v0, 1, 1
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 3, v0
; GFX6-NEXT:    v_bfe_u32 v0, v0, 2, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v4i1_to_v4i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v11, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v9, s1
; GFX8-NEXT:    v_mov_b32_e32 v10, s2
; GFX8-NEXT:    v_mov_b32_e32 v5, v1
; GFX8-NEXT:    v_mov_b32_e32 v7, v1
; GFX8-NEXT:    v_mov_b32_e32 v8, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v4, 2, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v12, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 3, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v4
; GFX8-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX8-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX8-NEXT:    v_and_b32_e32 v4, 0xffff, v12
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[0:3]
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v4i1_to_v4i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 14, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_UINT * T1.Z, T0.X, literal.x, 1,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T1.X, T0.X, literal.x, 1,
; EG-NEXT:     MOV T1.Y, 0.0,
; EG-NEXT:     BFE_UINT T0.Z, T0.X, 1, 1,
; EG-NEXT:     AND_INT * T0.X, T0.X, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV T1.W, 0.0,
; EG-NEXT:     MOV * T0.W, 0.0,
; EG-NEXT:     LSHR T2.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR * T3.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v4i1_to_v4i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v1, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v6, 1, v0
; GFX12-NEXT:    v_lshrrev_b16 v2, 2, v0
; GFX12-NEXT:    v_lshrrev_b16 v4, 1, v0
; GFX12-NEXT:    v_mov_b32_e32 v3, v1
; GFX12-NEXT:    v_lshrrev_b16 v0, 3, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_dual_mov_b32 v7, v1 :: v_dual_and_b32 v8, 1, v2
; GFX12-NEXT:    v_and_b32_e32 v9, 1, v4
; GFX12-NEXT:    v_dual_mov_b32 v5, v1 :: v_dual_and_b32 v4, 0xffff, v6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; GFX12-NEXT:    v_and_b32_e32 v0, 0xffff, v8
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX12-NEXT:    v_and_b32_e32 v6, 0xffff, v9
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v1, v[4:7], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <4 x i1>, ptr addrspace(4) %in
  %ext = zext <4 x i1> %load to <4 x i64>
  store <4 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v4i1_to_v4i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v4i1_to_v4i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 2, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 3, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 1, v0
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX6-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX6-NEXT:    v_bfe_i32 v6, v4, 0, 1
; GFX6-NEXT:    v_bfe_i32 v4, v3, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX6-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v4i1_to_v4i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v11, s3
; GFX8-NEXT:    v_mov_b32_e32 v9, s1
; GFX8-NEXT:    v_mov_b32_e32 v10, s2
; GFX8-NEXT:    v_mov_b32_e32 v8, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 2, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v4, 3, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 1, v0
; GFX8-NEXT:    v_bfe_i32 v6, v4, 0, 1
; GFX8-NEXT:    v_bfe_i32 v4, v3, 0, 1
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX8-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX8-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v4i1_to_v4i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 17, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T1.X, T0.X, 0.0, 1,
; EG-NEXT:     BFE_INT T2.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T2.X, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T0.X, 1,
; EG-NEXT:     MOV T2.Y, PV.X,
; EG-NEXT:     BFE_INT * T1.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     MOV T1.Y, T1.X,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     MOV T1.W, T1.Z,
; EG-NEXT:     MOV * T2.W, T2.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v4i1_to_v4i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v8, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v8, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v1, 3, v0
; GFX12-NEXT:    v_lshrrev_b16 v2, 2, v0
; GFX12-NEXT:    v_lshrrev_b16 v3, 1, v0
; GFX12-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_bfe_i32 v6, v1, 0, 1
; GFX12-NEXT:    v_bfe_i32 v4, v2, 0, 1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_bfe_i32 v2, v3, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX12-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX12-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v8, v[4:7], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v8, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <4 x i1>, ptr addrspace(4) %in
  %ext = sext <4 x i1> %load to <4 x i64>
  store <4 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v8i1_to_v8i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v8i1_to_v8i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_mov_b32 s10, s2
; GFX6-NEXT:    s_mov_b32 s11, s3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NEXT:    v_mov_b32_e32 v5, v1
; GFX6-NEXT:    v_mov_b32_e32 v7, v1
; GFX6-NEXT:    v_mov_b32_e32 v9, v1
; GFX6-NEXT:    v_mov_b32_e32 v11, v1
; GFX6-NEXT:    v_mov_b32_e32 v13, v1
; GFX6-NEXT:    v_mov_b32_e32 v15, v1
; GFX6-NEXT:    s_mov_b32 s0, s4
; GFX6-NEXT:    s_mov_b32 s1, s5
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_u32 v14, v0, 1, 1
; GFX6-NEXT:    v_bfe_u32 v10, v0, 3, 1
; GFX6-NEXT:    v_bfe_u32 v6, v0, 5, 1
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 7, v0
; GFX6-NEXT:    v_and_b32_e32 v12, 1, v0
; GFX6-NEXT:    v_bfe_u32 v8, v0, 2, 1
; GFX6-NEXT:    v_bfe_u32 v4, v0, 4, 1
; GFX6-NEXT:    v_bfe_u32 v0, v0, 6, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:32
; GFX6-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v8i1_to_v8i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 48
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v19, s3
; GFX8-NEXT:    v_mov_b32_e32 v18, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    v_mov_b32_e32 v17, s1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v16, s0
; GFX8-NEXT:    s_add_u32 s0, s0, 16
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v21, s3
; GFX8-NEXT:    v_mov_b32_e32 v23, s1
; GFX8-NEXT:    v_mov_b32_e32 v5, v1
; GFX8-NEXT:    v_mov_b32_e32 v7, v1
; GFX8-NEXT:    v_mov_b32_e32 v9, v1
; GFX8-NEXT:    v_mov_b32_e32 v11, v1
; GFX8-NEXT:    v_mov_b32_e32 v13, v1
; GFX8-NEXT:    v_mov_b32_e32 v15, v1
; GFX8-NEXT:    v_mov_b32_e32 v20, s2
; GFX8-NEXT:    v_mov_b32_e32 v22, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 2, v0
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v2
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 4, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 6, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v10, 5, v0
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v2
; GFX8-NEXT:    v_lshrrev_b16_e32 v14, 3, v0
; GFX8-NEXT:    v_and_b32_e32 v12, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 7, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v0, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v24, 1, v10
; GFX8-NEXT:    v_and_b32_e32 v10, 1, v14
; GFX8-NEXT:    v_and_b32_e32 v14, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v6
; GFX8-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX8-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff, v24
; GFX8-NEXT:    flat_store_dwordx4 v[18:19], v[0:3]
; GFX8-NEXT:    flat_store_dwordx4 v[20:21], v[4:7]
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[8:11]
; GFX8-NEXT:    flat_store_dwordx4 v[16:17], v[12:15]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v8i1_to_v8i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 30, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T6.XYZW, T12.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T11.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T10.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T9.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_8 T5.X, T5.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T5.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     BFE_UINT * T6.Z, T5.X, literal.x, 1,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T6.X, T5.X, literal.x, 1,
; EG-NEXT:     MOV T6.Y, 0.0,
; EG-NEXT:     BFE_UINT * T7.Z, T5.X, literal.y, 1,
; EG-NEXT:    6(8.407791e-45), 5(7.006492e-45)
; EG-NEXT:     BFE_UINT T7.X, T5.X, literal.x, 1,
; EG-NEXT:     MOV T7.Y, 0.0,
; EG-NEXT:     BFE_UINT * T8.Z, T5.X, literal.y, 1,
; EG-NEXT:    4(5.605194e-45), 3(4.203895e-45)
; EG-NEXT:     BFE_UINT T8.X, T5.X, literal.x, 1,
; EG-NEXT:     MOV T8.Y, 0.0,
; EG-NEXT:     BFE_UINT T5.Z, T5.X, 1, 1,
; EG-NEXT:     AND_INT * T5.X, T5.X, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV T5.Y, 0.0,
; EG-NEXT:     MOV T6.W, 0.0,
; EG-NEXT:     MOV * T7.W, 0.0,
; EG-NEXT:     MOV T8.W, 0.0,
; EG-NEXT:     MOV * T5.W, 0.0,
; EG-NEXT:     LSHR T9.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T10.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T11.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR * T12.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v8i1_to_v8i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v0, v1, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v12, 1, v0
; GFX12-NEXT:    v_lshrrev_b16 v4, 5, v0
; GFX12-NEXT:    v_lshrrev_b16 v8, 3, v0
; GFX12-NEXT:    v_lshrrev_b16 v14, 1, v0
; GFX12-NEXT:    v_lshrrev_b16 v2, 7, v0
; GFX12-NEXT:    v_lshrrev_b16 v6, 6, v0
; GFX12-NEXT:    v_lshrrev_b16 v10, 4, v0
; GFX12-NEXT:    v_and_b32_e32 v17, 1, v4
; GFX12-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_and_b32 v18, 1, v8
; GFX12-NEXT:    v_lshrrev_b16 v16, 2, v0
; GFX12-NEXT:    v_dual_mov_b32 v5, v1 :: v_dual_and_b32 v14, 1, v14
; GFX12-NEXT:    v_dual_mov_b32 v11, v1 :: v_dual_and_b32 v0, 1, v6
; GFX12-NEXT:    v_dual_mov_b32 v13, v1 :: v_dual_and_b32 v2, 0xffff, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX12-NEXT:    v_dual_mov_b32 v7, v1 :: v_dual_and_b32 v8, 1, v16
; GFX12-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_and_b32 v4, 1, v10
; GFX12-NEXT:    v_dual_mov_b32 v15, v1 :: v_dual_and_b32 v6, 0xffff, v17
; GFX12-NEXT:    v_and_b32_e32 v10, 0xffff, v18
; GFX12-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v1, v[4:7], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v1, v[8:11], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v1, v[12:15], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <8 x i1>, ptr addrspace(4) %in
  %ext = zext <8 x i1> %load to <8 x i64>
  store <8 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v8i1_to_v8i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v8i1_to_v8i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_mov_b32 s10, s2
; GFX6-NEXT:    s_mov_b32 s11, s3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s0, s4
; GFX6-NEXT:    s_mov_b32 s1, s5
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 6, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 7, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v7, 4, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v8, 5, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v6, 3, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 1, v0
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX6-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX6-NEXT:    v_bfe_i32 v6, v6, 0, 1
; GFX6-NEXT:    v_bfe_i32 v4, v4, 0, 1
; GFX6-NEXT:    v_bfe_i32 v10, v8, 0, 1
; GFX6-NEXT:    v_bfe_i32 v8, v7, 0, 1
; GFX6-NEXT:    v_bfe_i32 v14, v5, 0, 1
; GFX6-NEXT:    v_bfe_i32 v12, v3, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX6-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX6-NEXT:    v_ashrrev_i32_e32 v11, 31, v10
; GFX6-NEXT:    v_ashrrev_i32_e32 v9, 31, v8
; GFX6-NEXT:    v_ashrrev_i32_e32 v15, 31, v14
; GFX6-NEXT:    v_ashrrev_i32_e32 v13, 31, v12
; GFX6-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; GFX6-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v8i1_to_v8i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 48
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v19, s3
; GFX8-NEXT:    v_mov_b32_e32 v18, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    v_mov_b32_e32 v17, s1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v16, s0
; GFX8-NEXT:    s_add_u32 s0, s0, 16
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v21, s3
; GFX8-NEXT:    v_mov_b32_e32 v23, s1
; GFX8-NEXT:    v_mov_b32_e32 v20, s2
; GFX8-NEXT:    v_mov_b32_e32 v22, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 6, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v5, 7, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v7, 4, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v8, 5, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v4, 2, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 3, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 1, v0
; GFX8-NEXT:    v_bfe_i32 v14, v5, 0, 1
; GFX8-NEXT:    v_bfe_i32 v12, v3, 0, 1
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX8-NEXT:    v_bfe_i32 v6, v6, 0, 1
; GFX8-NEXT:    v_bfe_i32 v4, v4, 0, 1
; GFX8-NEXT:    v_bfe_i32 v10, v8, 0, 1
; GFX8-NEXT:    v_bfe_i32 v8, v7, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v15, 31, v14
; GFX8-NEXT:    v_ashrrev_i32_e32 v13, 31, v12
; GFX8-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX8-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX8-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX8-NEXT:    v_ashrrev_i32_e32 v11, 31, v10
; GFX8-NEXT:    v_ashrrev_i32_e32 v9, 31, v8
; GFX8-NEXT:    flat_store_dwordx4 v[18:19], v[12:15]
; GFX8-NEXT:    flat_store_dwordx4 v[20:21], v[8:11]
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[4:7]
; GFX8-NEXT:    flat_store_dwordx4 v[16:17], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v8i1_to_v8i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 37, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T12.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T11.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T9.XYZW, T10.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T6.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_8 T5.X, T5.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T5.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     LSHR T6.X, KC0[2].Y, literal.x,
; EG-NEXT:     LSHR * T0.W, T5.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 7(9.809089e-45)
; EG-NEXT:     BFE_INT T7.X, T5.X, 0.0, 1,
; EG-NEXT:     BFE_INT T8.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T5.X, literal.x,
; EG-NEXT:     LSHR * T1.W, T5.X, literal.y,
; EG-NEXT:    3(4.203895e-45), 6(8.407791e-45)
; EG-NEXT:     BFE_INT T8.X, PS, 0.0, 1,
; EG-NEXT:     BFE_INT T9.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T5.X, 1,
; EG-NEXT:     LSHR * T1.W, T5.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T9.X, PS, 0.0, 1,
; EG-NEXT:     MOV T8.Y, PV.X,
; EG-NEXT:     BFE_INT T7.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T5.X, literal.x,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    5(7.006492e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T10.X, PS, literal.x,
; EG-NEXT:     MOV T9.Y, PV.X,
; EG-NEXT:     BFE_INT T5.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T0.W, T5.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 4(5.605194e-45)
; EG-NEXT:     BFE_INT T5.X, PV.W, 0.0, 1,
; EG-NEXT:     MOV T7.Y, T7.X,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T11.X, PV.W, literal.x,
; EG-NEXT:     MOV T5.Y, PV.X,
; EG-NEXT:     ADD_INT T0.Z, KC0[2].Y, literal.y,
; EG-NEXT:     MOV T7.W, T7.Z,
; EG-NEXT:     MOV * T9.W, T9.Z,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T12.X, PV.Z, literal.x,
; EG-NEXT:     MOV T5.W, T5.Z,
; EG-NEXT:     MOV * T8.W, T8.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v8i1_to_v8i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v16, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u8 v1, v16, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v3, 6, v1
; GFX12-NEXT:    v_lshrrev_b16 v5, 7, v1
; GFX12-NEXT:    v_lshrrev_b16 v7, 4, v1
; GFX12-NEXT:    v_lshrrev_b16 v4, 3, v1
; GFX12-NEXT:    v_lshrrev_b16 v8, 2, v1
; GFX12-NEXT:    v_lshrrev_b16 v9, 5, v1
; GFX12-NEXT:    v_lshrrev_b16 v2, 1, v1
; GFX12-NEXT:    v_bfe_i32 v14, v5, 0, 1
; GFX12-NEXT:    v_bfe_i32 v12, v3, 0, 1
; GFX12-NEXT:    v_bfe_i32 v6, v4, 0, 1
; GFX12-NEXT:    v_bfe_i32 v4, v8, 0, 1
; GFX12-NEXT:    v_bfe_i32 v10, v9, 0, 1
; GFX12-NEXT:    v_bfe_i32 v8, v7, 0, 1
; GFX12-NEXT:    v_bfe_i32 v0, v1, 0, 1
; GFX12-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v15, 31, v14
; GFX12-NEXT:    v_ashrrev_i32_e32 v13, 31, v12
; GFX12-NEXT:    v_ashrrev_i32_e32 v11, 31, v10
; GFX12-NEXT:    v_ashrrev_i32_e32 v9, 31, v8
; GFX12-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX12-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX12-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX12-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    global_store_b128 v16, v[12:15], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v16, v[8:11], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v16, v[4:7], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v16, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <8 x i1>, ptr addrspace(4) %in
  %ext = sext <8 x i1> %load to <8 x i64>
  store <8 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v16i1_to_v16i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v16i1_to_v16i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_mov_b32 s10, s2
; GFX6-NEXT:    s_mov_b32 s11, s3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    buffer_load_ushort v29, off, s[8:11], 0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NEXT:    v_mov_b32_e32 v4, v1
; GFX6-NEXT:    v_mov_b32_e32 v6, v1
; GFX6-NEXT:    v_mov_b32_e32 v7, v1
; GFX6-NEXT:    v_mov_b32_e32 v9, v1
; GFX6-NEXT:    v_mov_b32_e32 v10, v1
; GFX6-NEXT:    v_mov_b32_e32 v12, v1
; GFX6-NEXT:    v_mov_b32_e32 v14, v1
; GFX6-NEXT:    v_mov_b32_e32 v16, v1
; GFX6-NEXT:    v_mov_b32_e32 v18, v1
; GFX6-NEXT:    v_mov_b32_e32 v20, v1
; GFX6-NEXT:    v_mov_b32_e32 v22, v1
; GFX6-NEXT:    v_mov_b32_e32 v24, v1
; GFX6-NEXT:    v_mov_b32_e32 v26, v1
; GFX6-NEXT:    v_mov_b32_e32 v28, v1
; GFX6-NEXT:    s_mov_b32 s0, s4
; GFX6-NEXT:    s_mov_b32 s1, s5
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_bfe_u32 v2, v29, 11, 1
; GFX6-NEXT:    v_bfe_u32 v0, v29, 10, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:80
; GFX6-NEXT:    v_bfe_u32 v5, v29, 9, 1
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_bfe_u32 v3, v29, 8, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[3:6], off, s[0:3], 0 offset:64
; GFX6-NEXT:    v_lshrrev_b32_e32 v8, 15, v29
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_bfe_u32 v6, v29, 14, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[6:9], off, s[0:3], 0 offset:112
; GFX6-NEXT:    v_bfe_u32 v27, v29, 5, 1
; GFX6-NEXT:    v_bfe_u32 v23, v29, 7, 1
; GFX6-NEXT:    v_bfe_u32 v19, v29, 1, 1
; GFX6-NEXT:    v_bfe_u32 v15, v29, 3, 1
; GFX6-NEXT:    v_bfe_u32 v11, v29, 13, 1
; GFX6-NEXT:    v_bfe_u32 v25, v29, 4, 1
; GFX6-NEXT:    v_bfe_u32 v21, v29, 6, 1
; GFX6-NEXT:    v_and_b32_e32 v17, 1, v29
; GFX6-NEXT:    v_bfe_u32 v13, v29, 2, 1
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_bfe_u32 v9, v29, 12, 1
; GFX6-NEXT:    buffer_store_dwordx4 v[9:12], off, s[0:3], 0 offset:96
; GFX6-NEXT:    buffer_store_dwordx4 v[13:16], off, s[0:3], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[17:20], off, s[0:3], 0
; GFX6-NEXT:    buffer_store_dwordx4 v[21:24], off, s[0:3], 0 offset:48
; GFX6-NEXT:    buffer_store_dwordx4 v[25:28], off, s[0:3], 0 offset:32
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v16i1_to_v16i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v6, v2
; GFX8-NEXT:    v_mov_b32_e32 v8, v2
; GFX8-NEXT:    v_mov_b32_e32 v4, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 0x70
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    s_add_u32 s4, s0, 0x50
; GFX8-NEXT:    s_addc_u32 s5, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v23, s5
; GFX8-NEXT:    v_mov_b32_e32 v22, s4
; GFX8-NEXT:    v_mov_b32_e32 v9, v2
; GFX8-NEXT:    v_mov_b32_e32 v11, v2
; GFX8-NEXT:    v_mov_b32_e32 v12, v2
; GFX8-NEXT:    v_mov_b32_e32 v14, v2
; GFX8-NEXT:    v_mov_b32_e32 v15, v2
; GFX8-NEXT:    v_mov_b32_e32 v17, v2
; GFX8-NEXT:    v_mov_b32_e32 v19, v2
; GFX8-NEXT:    v_mov_b32_e32 v21, v2
; GFX8-NEXT:    v_mov_b32_e32 v25, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 10, v0
; GFX8-NEXT:    v_and_b32_e32 v5, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 11, v0
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX8-NEXT:    v_and_b32_e32 v7, 0xffff, v1
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[5:8]
; GFX8-NEXT:    v_mov_b32_e32 v23, s3
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 14, v0
; GFX8-NEXT:    v_mov_b32_e32 v22, s2
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 15, v0
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX8-NEXT:    s_add_u32 s2, s0, 64
; GFX8-NEXT:    v_mov_b32_e32 v5, v2
; GFX8-NEXT:    v_mov_b32_e32 v7, v2
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[1:4]
; GFX8-NEXT:    v_mov_b32_e32 v23, v2
; GFX8-NEXT:    v_mov_b32_e32 v3, 1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_and_b32_sdwa v8, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 9, v0
; GFX8-NEXT:    s_add_u32 s2, s0, 0x60
; GFX8-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v10, 0xffff, v3
; GFX8-NEXT:    v_mov_b32_e32 v4, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 48
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 12, v0
; GFX8-NEXT:    flat_store_dwordx4 v[1:2], v[8:11]
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_mov_b32_e32 v9, s3
; GFX8-NEXT:    v_and_b32_e32 v11, 1, v6
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 13, v0
; GFX8-NEXT:    v_mov_b32_e32 v8, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v13, 0xffff, v6
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    flat_store_dwordx4 v[3:4], v[11:14]
; GFX8-NEXT:    s_add_u32 s0, s0, 16
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 7, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 6, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v14, 4, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v16, 5, v0
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_lshrrev_b16_e32 v4, 2, v0
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v14
; GFX8-NEXT:    v_and_b32_e32 v14, 1, v6
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 3, v0
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v0, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX8-NEXT:    v_and_b32_e32 v16, 1, v16
; GFX8-NEXT:    v_mov_b32_e32 v11, s3
; GFX8-NEXT:    v_mov_b32_e32 v13, s1
; GFX8-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v20, 0xffff, v16
; GFX8-NEXT:    v_and_b32_e32 v16, 0xffff, v3
; GFX8-NEXT:    v_mov_b32_e32 v10, s2
; GFX8-NEXT:    v_mov_b32_e32 v12, s0
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX8-NEXT:    v_and_b32_e32 v24, 0xffff, v0
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[14:17]
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[18:21]
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[4:7]
; GFX8-NEXT:    flat_store_dwordx4 v[1:2], v[22:25]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v16i1_to_v16i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @12
; EG-NEXT:    ALU 62, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T22.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T9.XYZW, T21.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T10.XYZW, T20.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T11.XYZW, T19.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T12.XYZW, T18.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T13.XYZW, T17.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T16.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T15.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_16 T7.X, T7.X, 0, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T7.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     LSHR * T8.Z, T7.X, literal.x,
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T8.X, T7.X, literal.x, 1,
; EG-NEXT:     MOV T8.Y, 0.0,
; EG-NEXT:     BFE_UINT * T9.Z, T7.X, literal.y, 1,
; EG-NEXT:    14(1.961818e-44), 13(1.821688e-44)
; EG-NEXT:     BFE_UINT T9.X, T7.X, literal.x, 1,
; EG-NEXT:     MOV T9.Y, 0.0,
; EG-NEXT:     BFE_UINT * T10.Z, T7.X, literal.y, 1,
; EG-NEXT:    12(1.681558e-44), 11(1.541428e-44)
; EG-NEXT:     BFE_UINT T10.X, T7.X, literal.x, 1,
; EG-NEXT:     MOV T10.Y, 0.0,
; EG-NEXT:     BFE_UINT * T11.Z, T7.X, literal.y, 1,
; EG-NEXT:    10(1.401298e-44), 9(1.261169e-44)
; EG-NEXT:     BFE_UINT T11.X, T7.X, literal.x, 1,
; EG-NEXT:     MOV T11.Y, 0.0,
; EG-NEXT:     BFE_UINT * T12.Z, T7.X, literal.y, 1,
; EG-NEXT:    8(1.121039e-44), 7(9.809089e-45)
; EG-NEXT:     BFE_UINT T12.X, T7.X, literal.x, 1,
; EG-NEXT:     MOV T12.Y, 0.0,
; EG-NEXT:     BFE_UINT * T13.Z, T7.X, literal.y, 1,
; EG-NEXT:    6(8.407791e-45), 5(7.006492e-45)
; EG-NEXT:     BFE_UINT T13.X, T7.X, literal.x, 1,
; EG-NEXT:     MOV T13.Y, 0.0,
; EG-NEXT:     BFE_UINT * T14.Z, T7.X, literal.y, 1,
; EG-NEXT:    4(5.605194e-45), 3(4.203895e-45)
; EG-NEXT:     BFE_UINT T14.X, T7.X, literal.x, 1,
; EG-NEXT:     MOV T14.Y, 0.0,
; EG-NEXT:     BFE_UINT T7.Z, T7.X, 1, 1,
; EG-NEXT:     AND_INT * T7.X, T7.X, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV T7.Y, 0.0,
; EG-NEXT:     MOV T8.W, 0.0,
; EG-NEXT:     MOV * T9.W, 0.0,
; EG-NEXT:     MOV T10.W, 0.0,
; EG-NEXT:     MOV * T11.W, 0.0,
; EG-NEXT:     MOV T12.W, 0.0,
; EG-NEXT:     MOV * T13.W, 0.0,
; EG-NEXT:     MOV T14.W, 0.0,
; EG-NEXT:     MOV * T7.W, 0.0,
; EG-NEXT:     LSHR T15.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T16.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T17.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T18.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T19.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T20.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:     LSHR T21.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR * T22.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v16i1_to_v16i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u16 v0, v1, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v28, 1, v0
; GFX12-NEXT:    v_lshrrev_b16 v4, 11, v0
; GFX12-NEXT:    v_lshrrev_b16 v8, 9, v0
; GFX12-NEXT:    v_lshrrev_b16 v12, 13, v0
; GFX12-NEXT:    v_lshrrev_b16 v16, 7, v0
; GFX12-NEXT:    v_lshrrev_b16 v2, 15, v0
; GFX12-NEXT:    v_lshrrev_b16 v6, 14, v0
; GFX12-NEXT:    v_lshrrev_b16 v10, 10, v0
; GFX12-NEXT:    v_lshrrev_b16 v20, 5, v0
; GFX12-NEXT:    v_lshrrev_b16 v24, 3, v0
; GFX12-NEXT:    v_lshrrev_b16 v32, 1, v0
; GFX12-NEXT:    v_and_b32_e32 v33, 1, v4
; GFX12-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_and_b32 v34, 1, v8
; GFX12-NEXT:    v_lshrrev_b16 v14, 8, v0
; GFX12-NEXT:    v_lshrrev_b16 v18, 12, v0
; GFX12-NEXT:    v_and_b32_e32 v35, 1, v12
; GFX12-NEXT:    v_dual_mov_b32 v5, v1 :: v_dual_and_b32 v36, 1, v16
; GFX12-NEXT:    v_lshrrev_b16 v22, 6, v0
; GFX12-NEXT:    v_dual_mov_b32 v7, v1 :: v_dual_and_b32 v38, 1, v24
; GFX12-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_and_b32 v32, 1, v32
; GFX12-NEXT:    v_dual_mov_b32 v21, v1 :: v_dual_and_b32 v4, 1, v10
; GFX12-NEXT:    v_mov_b32_e32 v23, v1
; GFX12-NEXT:    v_dual_mov_b32 v25, v1 :: v_dual_and_b32 v2, 0xffff, v2
; GFX12-NEXT:    v_mov_b32_e32 v31, v1
; GFX12-NEXT:    v_lshrrev_b16 v26, 4, v0
; GFX12-NEXT:    v_lshrrev_b16 v30, 2, v0
; GFX12-NEXT:    v_and_b32_e32 v37, 1, v20
; GFX12-NEXT:    v_and_b32_e32 v0, 1, v6
; GFX12-NEXT:    v_dual_mov_b32 v11, v1 :: v_dual_and_b32 v6, 0xffff, v33
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX12-NEXT:    v_dual_mov_b32 v19, v1 :: v_dual_and_b32 v24, 1, v30
; GFX12-NEXT:    v_and_b32_e32 v8, 1, v14
; GFX12-NEXT:    v_dual_mov_b32 v13, v1 :: v_dual_and_b32 v10, 0xffff, v34
; GFX12-NEXT:    v_dual_mov_b32 v15, v1 :: v_dual_and_b32 v20, 1, v26
; GFX12-NEXT:    v_dual_mov_b32 v17, v1 :: v_dual_and_b32 v16, 1, v22
; GFX12-NEXT:    v_and_b32_e32 v12, 1, v18
; GFX12-NEXT:    v_and_b32_e32 v14, 0xffff, v35
; GFX12-NEXT:    v_dual_mov_b32 v27, v1 :: v_dual_and_b32 v18, 0xffff, v36
; GFX12-NEXT:    v_dual_mov_b32 v29, v1 :: v_dual_and_b32 v30, 0xffff, v32
; GFX12-NEXT:    v_and_b32_e32 v26, 0xffff, v38
; GFX12-NEXT:    v_and_b32_e32 v22, 0xffff, v37
; GFX12-NEXT:    s_clause 0x7
; GFX12-NEXT:    global_store_b128 v1, v[4:7], s[0:1] offset:80
; GFX12-NEXT:    global_store_b128 v1, v[8:11], s[0:1] offset:64
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:112
; GFX12-NEXT:    global_store_b128 v1, v[12:15], s[0:1] offset:96
; GFX12-NEXT:    global_store_b128 v1, v[16:19], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v1, v[20:23], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v1, v[24:27], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v1, v[28:31], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <16 x i1>, ptr addrspace(4) %in
  %ext = zext <16 x i1> %load to <16 x i64>
  store <16 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v16i1_to_v16i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v16i1_to_v16i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_mov_b32 s10, s2
; GFX6-NEXT:    s_mov_b32 s11, s3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    buffer_load_ushort v1, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s0, s4
; GFX6-NEXT:    s_mov_b32 s1, s5
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 14, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 15, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v7, 12, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v9, 13, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v11, 10, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v12, 8, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v13, 9, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v8, 6, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v10, 7, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 4, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v6, 5, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 2, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 3, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v16, 1, v1
; GFX6-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX6-NEXT:    v_bfe_i32 v6, v6, 0, 1
; GFX6-NEXT:    v_bfe_i32 v4, v4, 0, 1
; GFX6-NEXT:    v_bfe_i32 v10, v10, 0, 1
; GFX6-NEXT:    v_bfe_i32 v8, v8, 0, 1
; GFX6-NEXT:    v_bfe_i32 v14, v13, 0, 1
; GFX6-NEXT:    v_bfe_i32 v12, v12, 0, 1
; GFX6-NEXT:    v_bfe_i32 v17, v5, 0, 1
; GFX6-NEXT:    v_bfe_i32 v15, v3, 0, 1
; GFX6-NEXT:    v_bfe_i32 v21, v16, 0, 1
; GFX6-NEXT:    v_bfe_i32 v19, v1, 0, 1
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 11, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v18, 31, v17
; GFX6-NEXT:    v_ashrrev_i32_e32 v16, 31, v15
; GFX6-NEXT:    buffer_store_dwordx4 v[15:18], off, s[0:3], 0 offset:112
; GFX6-NEXT:    v_bfe_i32 v25, v1, 0, 1
; GFX6-NEXT:    v_bfe_i32 v23, v11, 0, 1
; GFX6-NEXT:    v_bfe_i32 v29, v9, 0, 1
; GFX6-NEXT:    v_bfe_i32 v27, v7, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v20, 31, v19
; GFX6-NEXT:    v_ashrrev_i32_e32 v22, 31, v21
; GFX6-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX6-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX6-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX6-NEXT:    v_ashrrev_i32_e32 v11, 31, v10
; GFX6-NEXT:    v_ashrrev_i32_e32 v9, 31, v8
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_ashrrev_i32_e32 v15, 31, v14
; GFX6-NEXT:    v_ashrrev_i32_e32 v13, 31, v12
; GFX6-NEXT:    v_ashrrev_i32_e32 v26, 31, v25
; GFX6-NEXT:    v_ashrrev_i32_e32 v24, 31, v23
; GFX6-NEXT:    v_ashrrev_i32_e32 v30, 31, v29
; GFX6-NEXT:    v_ashrrev_i32_e32 v28, 31, v27
; GFX6-NEXT:    buffer_store_dwordx4 v[27:30], off, s[0:3], 0 offset:96
; GFX6-NEXT:    buffer_store_dwordx4 v[23:26], off, s[0:3], 0 offset:80
; GFX6-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:64
; GFX6-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:48
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:32
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NEXT:    buffer_store_dwordx4 v[19:22], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v16i1_to_v16i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    s_add_u32 s2, s0, 0x70
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v6, s3
; GFX8-NEXT:    v_mov_b32_e32 v5, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 0x60
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v8, s3
; GFX8-NEXT:    v_mov_b32_e32 v7, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 0x50
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v10, s3
; GFX8-NEXT:    v_mov_b32_e32 v9, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 64
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v16, s3
; GFX8-NEXT:    v_mov_b32_e32 v15, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 48
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v23, s3
; GFX8-NEXT:    v_mov_b32_e32 v22, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    v_mov_b32_e32 v21, s1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v20, s0
; GFX8-NEXT:    s_add_u32 s0, s0, 16
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v25, s3
; GFX8-NEXT:    v_mov_b32_e32 v27, s1
; GFX8-NEXT:    v_mov_b32_e32 v24, s2
; GFX8-NEXT:    v_mov_b32_e32 v26, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 14, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 15, v0
; GFX8-NEXT:    v_bfe_i32 v3, v2, 0, 1
; GFX8-NEXT:    v_bfe_i32 v1, v1, 0, 1
; GFX8-NEXT:    v_lshrrev_b16_e32 v11, 12, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v12, 13, v0
; GFX8-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GFX8-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GFX8-NEXT:    flat_store_dwordx4 v[5:6], v[1:4]
; GFX8-NEXT:    v_lshrrev_b16_e32 v13, 10, v0
; GFX8-NEXT:    v_bfe_i32 v3, v12, 0, 1
; GFX8-NEXT:    v_bfe_i32 v1, v11, 0, 1
; GFX8-NEXT:    v_lshrrev_b16_e32 v14, 11, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v6, 3, v0
; GFX8-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GFX8-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GFX8-NEXT:    v_lshrrev_b16_e32 v5, 2, v0
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[1:4]
; GFX8-NEXT:    v_lshrrev_b16_e32 v17, 8, v0
; GFX8-NEXT:    v_bfe_i32 v3, v6, 0, 1
; GFX8-NEXT:    v_bfe_i32 v6, v14, 0, 1
; GFX8-NEXT:    v_bfe_i32 v4, v13, 0, 1
; GFX8-NEXT:    v_lshrrev_b16_e32 v18, 9, v0
; GFX8-NEXT:    v_bfe_i32 v1, v5, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX8-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX8-NEXT:    flat_store_dwordx4 v[9:10], v[4:7]
; GFX8-NEXT:    v_bfe_i32 v10, v18, 0, 1
; GFX8-NEXT:    v_bfe_i32 v8, v17, 0, 1
; GFX8-NEXT:    v_lshrrev_b16_e32 v19, 6, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v28, 4, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v29, 5, v0
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 1, v0
; GFX8-NEXT:    v_bfe_i32 v12, v0, 0, 1
; GFX8-NEXT:    v_lshrrev_b16_e32 v0, 7, v0
; GFX8-NEXT:    v_ashrrev_i32_e32 v11, 31, v10
; GFX8-NEXT:    v_ashrrev_i32_e32 v9, 31, v8
; GFX8-NEXT:    flat_store_dwordx4 v[15:16], v[8:11]
; GFX8-NEXT:    v_bfe_i32 v18, v0, 0, 1
; GFX8-NEXT:    v_bfe_i32 v16, v19, 0, 1
; GFX8-NEXT:    v_bfe_i32 v7, v29, 0, 1
; GFX8-NEXT:    v_bfe_i32 v5, v28, 0, 1
; GFX8-NEXT:    v_bfe_i32 v14, v2, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v19, 31, v18
; GFX8-NEXT:    v_ashrrev_i32_e32 v17, 31, v16
; GFX8-NEXT:    v_ashrrev_i32_e32 v13, 31, v12
; GFX8-NEXT:    v_ashrrev_i32_e32 v15, 31, v14
; GFX8-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GFX8-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GFX8-NEXT:    v_ashrrev_i32_e32 v8, 31, v7
; GFX8-NEXT:    v_ashrrev_i32_e32 v6, 31, v5
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[16:19]
; GFX8-NEXT:    flat_store_dwordx4 v[24:25], v[5:8]
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[1:4]
; GFX8-NEXT:    flat_store_dwordx4 v[20:21], v[12:15]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v16i1_to_v16i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @12
; EG-NEXT:    ALU 78, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T22.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T20.XYZW, T21.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T15.XYZW, T18.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T12.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T16.XYZW, T11.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T19.XYZW, T10.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T17.XYZW, T9.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T13.XYZW, T8.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_16 T7.X, T7.X, 0, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T7.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     LSHR T8.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T9.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T10.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T11.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T12.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T0.W, T7.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 15(2.101948e-44)
; EG-NEXT:     BFE_INT T13.X, T7.X, 0.0, 1,
; EG-NEXT:     BFE_INT T14.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, literal.x,
; EG-NEXT:     LSHR * T1.W, T7.X, literal.y,
; EG-NEXT:    11(1.541428e-44), 14(1.961818e-44)
; EG-NEXT:     BFE_INT T14.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T0.Y, T7.X, literal.x,
; EG-NEXT:     BFE_INT T15.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, literal.y,
; EG-NEXT:     LSHR * T1.W, T7.X, literal.z,
; EG-NEXT:    12(1.681558e-44), 7(9.809089e-45)
; EG-NEXT:    10(1.401298e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T15.X, PS, 0.0, 1,
; EG-NEXT:     MOV T14.Y, PV.X,
; EG-NEXT:     BFE_INT T16.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, literal.x,
; EG-NEXT:     LSHR * T1.W, T7.X, literal.y,
; EG-NEXT:    3(4.203895e-45), 6(8.407791e-45)
; EG-NEXT:     BFE_INT T16.X, PS, 0.0, 1,
; EG-NEXT:     MOV T15.Y, PV.X,
; EG-NEXT:     BFE_INT T17.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, 1,
; EG-NEXT:     LSHR * T1.W, T7.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T17.X, PS, 0.0, 1,
; EG-NEXT:     MOV T16.Y, PV.X,
; EG-NEXT:     BFE_INT T13.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, literal.x,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    5(7.006492e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T18.X, PS, literal.x,
; EG-NEXT:     MOV T17.Y, PV.X,
; EG-NEXT:     BFE_INT T19.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, literal.y,
; EG-NEXT:     LSHR * T1.W, T7.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 9(1.261169e-44)
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T19.X, PS, 0.0, 1,
; EG-NEXT:     MOV T13.Y, T13.X,
; EG-NEXT:     BFE_INT T7.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T0.W, T7.X, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     LSHR * T1.W, T7.X, literal.y,
; EG-NEXT:    13(1.821688e-44), 8(1.121039e-44)
; EG-NEXT:     BFE_INT T7.X, PS, 0.0, 1,
; EG-NEXT:     MOV T19.Y, PV.X,
; EG-NEXT:     BFE_INT T20.Z, PV.W, 0.0, 1,
; EG-NEXT:     MOV T13.W, T13.Z,
; EG-NEXT:     MOV * T17.W, T17.Z,
; EG-NEXT:     BFE_INT T20.X, T0.Y, 0.0, 1,
; EG-NEXT:     MOV T7.Y, PV.X,
; EG-NEXT:     ADD_INT T0.Z, KC0[2].Y, literal.x,
; EG-NEXT:     MOV T19.W, T19.Z,
; EG-NEXT:     MOV * T16.W, T16.Z,
; EG-NEXT:    96(1.345247e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T21.X, PV.Z, literal.x,
; EG-NEXT:     MOV T20.Y, PV.X,
; EG-NEXT:     ADD_INT T0.Z, KC0[2].Y, literal.y,
; EG-NEXT:     MOV T7.W, T7.Z,
; EG-NEXT:     MOV * T15.W, T15.Z,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR T22.X, PV.Z, literal.x,
; EG-NEXT:     MOV T20.W, T20.Z,
; EG-NEXT:     MOV * T14.W, T14.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v16i1_to_v16i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v32, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_u16 v1, v32, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v3, 14, v1
; GFX12-NEXT:    v_lshrrev_b16 v5, 15, v1
; GFX12-NEXT:    v_lshrrev_b16 v7, 12, v1
; GFX12-NEXT:    v_lshrrev_b16 v9, 13, v1
; GFX12-NEXT:    v_lshrrev_b16 v11, 10, v1
; GFX12-NEXT:    v_lshrrev_b16 v13, 11, v1
; GFX12-NEXT:    v_lshrrev_b16 v15, 8, v1
; GFX12-NEXT:    v_lshrrev_b16 v16, 9, v1
; GFX12-NEXT:    v_lshrrev_b16 v12, 6, v1
; GFX12-NEXT:    v_lshrrev_b16 v14, 7, v1
; GFX12-NEXT:    v_lshrrev_b16 v8, 4, v1
; GFX12-NEXT:    v_lshrrev_b16 v2, 1, v1
; GFX12-NEXT:    v_lshrrev_b16 v4, 3, v1
; GFX12-NEXT:    v_lshrrev_b16 v10, 2, v1
; GFX12-NEXT:    v_lshrrev_b16 v17, 5, v1
; GFX12-NEXT:    v_bfe_i32 v30, v5, 0, 1
; GFX12-NEXT:    v_bfe_i32 v28, v3, 0, 1
; GFX12-NEXT:    v_bfe_i32 v26, v9, 0, 1
; GFX12-NEXT:    v_bfe_i32 v24, v7, 0, 1
; GFX12-NEXT:    v_bfe_i32 v22, v13, 0, 1
; GFX12-NEXT:    v_bfe_i32 v20, v11, 0, 1
; GFX12-NEXT:    v_bfe_i32 v18, v16, 0, 1
; GFX12-NEXT:    v_bfe_i32 v16, v15, 0, 1
; GFX12-NEXT:    v_bfe_i32 v14, v14, 0, 1
; GFX12-NEXT:    v_bfe_i32 v12, v12, 0, 1
; GFX12-NEXT:    v_bfe_i32 v0, v1, 0, 1
; GFX12-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX12-NEXT:    v_bfe_i32 v6, v4, 0, 1
; GFX12-NEXT:    v_bfe_i32 v4, v10, 0, 1
; GFX12-NEXT:    v_bfe_i32 v10, v17, 0, 1
; GFX12-NEXT:    v_bfe_i32 v8, v8, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v31, 31, v30
; GFX12-NEXT:    v_ashrrev_i32_e32 v29, 31, v28
; GFX12-NEXT:    v_ashrrev_i32_e32 v27, 31, v26
; GFX12-NEXT:    v_ashrrev_i32_e32 v25, 31, v24
; GFX12-NEXT:    v_ashrrev_i32_e32 v23, 31, v22
; GFX12-NEXT:    v_ashrrev_i32_e32 v21, 31, v20
; GFX12-NEXT:    v_ashrrev_i32_e32 v19, 31, v18
; GFX12-NEXT:    v_ashrrev_i32_e32 v17, 31, v16
; GFX12-NEXT:    v_ashrrev_i32_e32 v15, 31, v14
; GFX12-NEXT:    v_ashrrev_i32_e32 v13, 31, v12
; GFX12-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX12-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX12-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX12-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX12-NEXT:    v_ashrrev_i32_e32 v11, 31, v10
; GFX12-NEXT:    v_ashrrev_i32_e32 v9, 31, v8
; GFX12-NEXT:    s_clause 0x7
; GFX12-NEXT:    global_store_b128 v32, v[28:31], s[0:1] offset:112
; GFX12-NEXT:    global_store_b128 v32, v[24:27], s[0:1] offset:96
; GFX12-NEXT:    global_store_b128 v32, v[20:23], s[0:1] offset:80
; GFX12-NEXT:    global_store_b128 v32, v[16:19], s[0:1] offset:64
; GFX12-NEXT:    global_store_b128 v32, v[12:15], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v32, v[8:11], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v32, v[4:7], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v32, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <16 x i1>, ptr addrspace(4) %in
  %ext = sext <16 x i1> %load to <16 x i64>
  store <16 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v32i1_to_v32i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v32i1_to_v32i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_bfe_u32 s5, s4, 0x10001
; GFX6-NEXT:    s_bfe_u32 s6, s4, 0x10003
; GFX6-NEXT:    s_bfe_u32 s7, s4, 0x10005
; GFX6-NEXT:    s_bfe_u32 s8, s4, 0x10007
; GFX6-NEXT:    s_bfe_u32 s9, s4, 0x10009
; GFX6-NEXT:    s_bfe_u32 s10, s4, 0x1000b
; GFX6-NEXT:    s_bfe_u32 s11, s4, 0x1000d
; GFX6-NEXT:    s_bfe_u32 s12, s4, 0x1000f
; GFX6-NEXT:    s_bfe_u32 s13, s4, 0x10011
; GFX6-NEXT:    s_bfe_u32 s14, s4, 0x10013
; GFX6-NEXT:    s_bfe_u32 s15, s4, 0x10015
; GFX6-NEXT:    s_bfe_u32 s16, s4, 0x10017
; GFX6-NEXT:    s_bfe_u32 s17, s4, 0x10019
; GFX6-NEXT:    s_bfe_u32 s18, s4, 0x1001b
; GFX6-NEXT:    s_bfe_u32 s19, s4, 0x1001d
; GFX6-NEXT:    s_lshr_b32 s20, s4, 31
; GFX6-NEXT:    s_and_b32 s21, s4, 1
; GFX6-NEXT:    s_bfe_u32 s22, s4, 0x10002
; GFX6-NEXT:    s_bfe_u32 s23, s4, 0x10004
; GFX6-NEXT:    s_bfe_u32 s24, s4, 0x10006
; GFX6-NEXT:    s_bfe_u32 s25, s4, 0x10008
; GFX6-NEXT:    s_bfe_u32 s26, s4, 0x1000a
; GFX6-NEXT:    s_bfe_u32 s27, s4, 0x1000c
; GFX6-NEXT:    s_bfe_u32 s28, s4, 0x1000e
; GFX6-NEXT:    s_bfe_u32 s29, s4, 0x10010
; GFX6-NEXT:    s_bfe_u32 s30, s4, 0x10012
; GFX6-NEXT:    s_bfe_u32 s31, s4, 0x10014
; GFX6-NEXT:    s_bfe_u32 s33, s4, 0x10016
; GFX6-NEXT:    s_bfe_u32 s34, s4, 0x10018
; GFX6-NEXT:    s_bfe_u32 s35, s4, 0x1001a
; GFX6-NEXT:    s_bfe_u32 s36, s4, 0x1001e
; GFX6-NEXT:    s_bfe_u32 s4, s4, 0x1001c
; GFX6-NEXT:    v_mov_b32_e32 v0, s36
; GFX6-NEXT:    v_mov_b32_e32 v2, s20
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:240
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v2, s19
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:224
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s35
; GFX6-NEXT:    v_mov_b32_e32 v2, s18
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:208
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s34
; GFX6-NEXT:    v_mov_b32_e32 v2, s17
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:192
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s33
; GFX6-NEXT:    v_mov_b32_e32 v2, s16
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:176
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s31
; GFX6-NEXT:    v_mov_b32_e32 v2, s15
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:160
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s30
; GFX6-NEXT:    v_mov_b32_e32 v2, s14
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:144
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s29
; GFX6-NEXT:    v_mov_b32_e32 v2, s13
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:128
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s28
; GFX6-NEXT:    v_mov_b32_e32 v2, s12
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:112
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s27
; GFX6-NEXT:    v_mov_b32_e32 v2, s11
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:96
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s26
; GFX6-NEXT:    v_mov_b32_e32 v2, s10
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:80
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s25
; GFX6-NEXT:    v_mov_b32_e32 v2, s9
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:64
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s24
; GFX6-NEXT:    v_mov_b32_e32 v2, s8
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s23
; GFX6-NEXT:    v_mov_b32_e32 v2, s7
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:32
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s22
; GFX6-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s21
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v32i1_to_v32i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 13, s2
; GFX8-NEXT:    v_and_b32_e32 v15, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 9, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 11, s2
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 7, s2
; GFX8-NEXT:    v_and_b32_e32 v11, 1, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 5, s2
; GFX8-NEXT:    s_lshr_b32 s14, s2, 24
; GFX8-NEXT:    v_and_b32_e32 v5, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 3, s2
; GFX8-NEXT:    s_bfe_u32 s10, s2, 0x10018
; GFX8-NEXT:    s_and_b32 s11, s2, 1
; GFX8-NEXT:    s_bfe_u32 s15, s2, 0x10011
; GFX8-NEXT:    s_bfe_u32 s16, s2, 0x10010
; GFX8-NEXT:    s_bfe_u32 s17, s2, 0x10012
; GFX8-NEXT:    s_bfe_u32 s18, s2, 0x10013
; GFX8-NEXT:    s_bfe_u32 s19, s2, 0x10014
; GFX8-NEXT:    s_bfe_u32 s20, s2, 0x10015
; GFX8-NEXT:    s_bfe_u32 s21, s2, 0x10016
; GFX8-NEXT:    s_bfe_u32 s22, s2, 0x10017
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v4, 14, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 12, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v9, 10, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v3, 6, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v7, 4, s2
; GFX8-NEXT:    v_and_b32_e32 v10, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v12, 2, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 1, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v20, 15, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 0xb0
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    s_add_u32 s4, s0, 0xa0
; GFX8-NEXT:    s_addc_u32 s5, s1, 0
; GFX8-NEXT:    s_add_u32 s6, s0, 0x90
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    s_add_u32 s8, s0, 0x80
; GFX8-NEXT:    s_addc_u32 s9, s1, 0
; GFX8-NEXT:    s_add_u32 s12, s0, 0x70
; GFX8-NEXT:    v_and_b32_e32 v16, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 5, s14
; GFX8-NEXT:    s_addc_u32 s13, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v17, 1, v1
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 3, s14
; GFX8-NEXT:    v_mov_b32_e32 v23, s13
; GFX8-NEXT:    v_and_b32_e32 v25, 1, v1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v22, s12
; GFX8-NEXT:    s_add_u32 s12, s0, 0xf0
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v4
; GFX8-NEXT:    v_mov_b32_e32 v19, v1
; GFX8-NEXT:    v_mov_b32_e32 v21, v1
; GFX8-NEXT:    s_addc_u32 s13, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[18:21]
; GFX8-NEXT:    v_mov_b32_e32 v23, s13
; GFX8-NEXT:    v_lshrrev_b16_e64 v6, 6, s14
; GFX8-NEXT:    v_mov_b32_e32 v22, s12
; GFX8-NEXT:    s_add_u32 s12, s0, 0x60
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v6
; GFX8-NEXT:    v_lshrrev_b16_e64 v20, 7, s14
; GFX8-NEXT:    s_addc_u32 s13, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[18:21]
; GFX8-NEXT:    v_lshrrev_b16_e64 v24, 4, s14
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v14
; GFX8-NEXT:    v_and_b32_e32 v20, 0xffff, v15
; GFX8-NEXT:    v_mov_b32_e32 v15, s13
; GFX8-NEXT:    v_mov_b32_e32 v14, s12
; GFX8-NEXT:    s_add_u32 s12, s0, 0x50
; GFX8-NEXT:    s_addc_u32 s13, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v23, s13
; GFX8-NEXT:    v_mov_b32_e32 v22, s12
; GFX8-NEXT:    s_add_u32 s12, s0, 64
; GFX8-NEXT:    flat_store_dwordx4 v[14:15], v[18:21]
; GFX8-NEXT:    s_addc_u32 s13, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v9
; GFX8-NEXT:    v_and_b32_e32 v20, 0xffff, v11
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[18:21]
; GFX8-NEXT:    v_and_b32_e32 v11, 0xffff, v10
; GFX8-NEXT:    v_mov_b32_e32 v10, 1
; GFX8-NEXT:    v_mov_b32_e32 v23, s13
; GFX8-NEXT:    v_and_b32_sdwa v18, v0, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_e32 v20, 0xffff, v8
; GFX8-NEXT:    v_mov_b32_e32 v22, s12
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[18:21]
; GFX8-NEXT:    v_and_b32_e32 v23, 0xffff, v2
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v7
; GFX8-NEXT:    v_mov_b32_e32 v8, s3
; GFX8-NEXT:    v_and_b32_e32 v21, 1, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, s21
; GFX8-NEXT:    v_mov_b32_e32 v2, s22
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v7, s2
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v8, s5
; GFX8-NEXT:    v_mov_b32_e32 v0, s19
; GFX8-NEXT:    v_mov_b32_e32 v2, s20
; GFX8-NEXT:    v_mov_b32_e32 v7, s4
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v8, s7
; GFX8-NEXT:    v_mov_b32_e32 v0, s17
; GFX8-NEXT:    v_mov_b32_e32 v2, s18
; GFX8-NEXT:    v_mov_b32_e32 v7, s6
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v7, s8
; GFX8-NEXT:    v_mov_b32_e32 v0, s16
; GFX8-NEXT:    v_mov_b32_e32 v2, s15
; GFX8-NEXT:    v_mov_b32_e32 v8, s9
; GFX8-NEXT:    s_add_u32 s2, s0, 48
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_and_b32_e32 v15, 1, v24
; GFX8-NEXT:    v_mov_b32_e32 v22, v1
; GFX8-NEXT:    v_mov_b32_e32 v24, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[21:24]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_and_b32_e32 v20, 0xffff, v5
; GFX8-NEXT:    v_mov_b32_e32 v21, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[18:21]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_and_b32_e32 v14, 0xffff, v16
; GFX8-NEXT:    v_and_b32_e32 v9, 1, v12
; GFX8-NEXT:    v_mov_b32_e32 v10, v1
; GFX8-NEXT:    v_mov_b32_e32 v12, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_mov_b32_e32 v8, s1
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[9:12]
; GFX8-NEXT:    v_mov_b32_e32 v0, s11
; GFX8-NEXT:    v_mov_b32_e32 v2, v14
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v7, s0
; GFX8-NEXT:    s_add_u32 s2, s0, 0xe0
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0xd0
; GFX8-NEXT:    v_lshrrev_b16_e64 v4, 1, s14
; GFX8-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX8-NEXT:    v_mov_b32_e32 v16, v1
; GFX8-NEXT:    v_mov_b32_e32 v18, v1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_lshrrev_b16_e64 v26, 2, s14
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[15:18]
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    s_add_u32 s0, s0, 0xc0
; GFX8-NEXT:    v_and_b32_e32 v13, 0xffff, v4
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v26
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff, v25
; GFX8-NEXT:    v_mov_b32_e32 v5, v1
; GFX8-NEXT:    v_mov_b32_e32 v7, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[4:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, s10
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, v13
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v32i1_to_v32i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @24, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @22
; EG-NEXT:    ALU 96, @25, KC0[CB0:0-32], KC1[]
; EG-NEXT:    ALU 30, @122, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T12.XYZW, T42.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T13.XYZW, T41.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T40.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T15.XYZW, T39.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T16.XYZW, T38.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T17.XYZW, T37.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T18.XYZW, T36.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T19.XYZW, T35.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T20.XYZW, T34.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T21.XYZW, T33.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T22.XYZW, T32.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T23.XYZW, T31.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T24.XYZW, T30.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T25.XYZW, T29.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T26.XYZW, T28.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T11.XYZW, T27.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 22:
; EG-NEXT:     VTX_READ_32 T11.X, T11.X, 0, #1
; EG-NEXT:    ALU clause starting at 24:
; EG-NEXT:     MOV * T11.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 25:
; EG-NEXT:     LSHR * T12.Z, T11.X, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T12.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T12.Y, 0.0,
; EG-NEXT:     BFE_UINT * T13.Z, T11.X, literal.y, 1,
; EG-NEXT:    30(4.203895e-44), 29(4.063766e-44)
; EG-NEXT:     BFE_UINT T13.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T13.Y, 0.0,
; EG-NEXT:     BFE_UINT * T14.Z, T11.X, literal.y, 1,
; EG-NEXT:    28(3.923636e-44), 27(3.783506e-44)
; EG-NEXT:     BFE_UINT T14.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T14.Y, 0.0,
; EG-NEXT:     BFE_UINT * T15.Z, T11.X, literal.y, 1,
; EG-NEXT:    26(3.643376e-44), 25(3.503246e-44)
; EG-NEXT:     BFE_UINT T15.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T15.Y, 0.0,
; EG-NEXT:     BFE_UINT * T16.Z, T11.X, literal.y, 1,
; EG-NEXT:    24(3.363116e-44), 23(3.222986e-44)
; EG-NEXT:     BFE_UINT T16.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T16.Y, 0.0,
; EG-NEXT:     BFE_UINT * T17.Z, T11.X, literal.y, 1,
; EG-NEXT:    22(3.082857e-44), 21(2.942727e-44)
; EG-NEXT:     BFE_UINT T17.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T17.Y, 0.0,
; EG-NEXT:     BFE_UINT * T18.Z, T11.X, literal.y, 1,
; EG-NEXT:    20(2.802597e-44), 19(2.662467e-44)
; EG-NEXT:     BFE_UINT T18.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T18.Y, 0.0,
; EG-NEXT:     BFE_UINT * T19.Z, T11.X, literal.y, 1,
; EG-NEXT:    18(2.522337e-44), 17(2.382207e-44)
; EG-NEXT:     BFE_UINT T19.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T19.Y, 0.0,
; EG-NEXT:     BFE_UINT * T20.Z, T11.X, literal.y, 1,
; EG-NEXT:    16(2.242078e-44), 15(2.101948e-44)
; EG-NEXT:     BFE_UINT T20.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T20.Y, 0.0,
; EG-NEXT:     BFE_UINT * T21.Z, T11.X, literal.y, 1,
; EG-NEXT:    14(1.961818e-44), 13(1.821688e-44)
; EG-NEXT:     BFE_UINT T21.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T21.Y, 0.0,
; EG-NEXT:     BFE_UINT * T22.Z, T11.X, literal.y, 1,
; EG-NEXT:    12(1.681558e-44), 11(1.541428e-44)
; EG-NEXT:     BFE_UINT T22.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T22.Y, 0.0,
; EG-NEXT:     BFE_UINT * T23.Z, T11.X, literal.y, 1,
; EG-NEXT:    10(1.401298e-44), 9(1.261169e-44)
; EG-NEXT:     BFE_UINT T23.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T23.Y, 0.0,
; EG-NEXT:     BFE_UINT * T24.Z, T11.X, literal.y, 1,
; EG-NEXT:    8(1.121039e-44), 7(9.809089e-45)
; EG-NEXT:     BFE_UINT T24.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T24.Y, 0.0,
; EG-NEXT:     BFE_UINT * T25.Z, T11.X, literal.y, 1,
; EG-NEXT:    6(8.407791e-45), 5(7.006492e-45)
; EG-NEXT:     BFE_UINT T25.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T25.Y, 0.0,
; EG-NEXT:     BFE_UINT * T26.Z, T11.X, literal.y, 1,
; EG-NEXT:    4(5.605194e-45), 3(4.203895e-45)
; EG-NEXT:     BFE_UINT T26.X, T11.X, literal.x, 1,
; EG-NEXT:     MOV T26.Y, 0.0,
; EG-NEXT:     BFE_UINT T11.Z, T11.X, 1, 1,
; EG-NEXT:     AND_INT * T11.X, T11.X, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV T11.Y, 0.0,
; EG-NEXT:     MOV T12.W, 0.0,
; EG-NEXT:     MOV * T13.W, 0.0,
; EG-NEXT:     MOV T14.W, 0.0,
; EG-NEXT:     MOV * T15.W, 0.0,
; EG-NEXT:     MOV T16.W, 0.0,
; EG-NEXT:     MOV * T17.W, 0.0,
; EG-NEXT:     MOV T18.W, 0.0,
; EG-NEXT:     MOV * T19.W, 0.0,
; EG-NEXT:     MOV T20.W, 0.0,
; EG-NEXT:     MOV * T21.W, 0.0,
; EG-NEXT:     MOV T22.W, 0.0,
; EG-NEXT:     MOV * T23.W, 0.0,
; EG-NEXT:     MOV T24.W, 0.0,
; EG-NEXT:     MOV * T25.W, 0.0,
; EG-NEXT:     MOV T26.W, 0.0,
; EG-NEXT:     MOV * T11.W, 0.0,
; EG-NEXT:     LSHR T27.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T28.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T29.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T30.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T31.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR * T32.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 122:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    96(1.345247e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T33.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR T34.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 128(1.793662e-43)
; EG-NEXT:     LSHR T35.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 144(2.017870e-43)
; EG-NEXT:     LSHR T36.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 160(2.242078e-43)
; EG-NEXT:     LSHR T37.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 176(2.466285e-43)
; EG-NEXT:     LSHR T38.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 192(2.690493e-43)
; EG-NEXT:     LSHR T39.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 208(2.914701e-43)
; EG-NEXT:     LSHR T40.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 224(3.138909e-43)
; EG-NEXT:     LSHR T41.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 240(3.363116e-43)
; EG-NEXT:     LSHR * T42.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v32i1_to_v32i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v0, 13, s2
; GFX12-NEXT:    v_lshrrev_b16 v3, 11, s2
; GFX12-NEXT:    s_lshr_b32 s3, s2, 24
; GFX12-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-NEXT:    v_lshrrev_b16 v2, 12, s2
; GFX12-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX12-NEXT:    v_lshrrev_b16 v4, 9, s2
; GFX12-NEXT:    v_lshrrev_b16 v8, 7, s2
; GFX12-NEXT:    v_lshrrev_b16 v16, 7, s3
; GFX12-NEXT:    v_lshrrev_b16 v18, 6, s3
; GFX12-NEXT:    v_lshrrev_b16 v17, 5, s3
; GFX12-NEXT:    v_lshrrev_b16 v20, 4, s3
; GFX12-NEXT:    v_lshrrev_b16 v21, 3, s3
; GFX12-NEXT:    v_lshrrev_b16 v22, 2, s3
; GFX12-NEXT:    v_lshrrev_b16 v23, 1, s3
; GFX12-NEXT:    s_bfe_u32 s3, s2, 0x10016
; GFX12-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX12-NEXT:    s_bfe_u32 s6, s2, 0x10017
; GFX12-NEXT:    v_lshrrev_b16 v11, 5, s2
; GFX12-NEXT:    v_lshrrev_b16 v13, 3, s2
; GFX12-NEXT:    v_and_b32_e32 v24, 1, v4
; GFX12-NEXT:    v_and_b32_e32 v25, 1, v8
; GFX12-NEXT:    v_and_b32_e32 v28, 1, v21
; GFX12-NEXT:    v_dual_mov_b32 v42, v1 :: v_dual_and_b32 v31, 1, v2
; GFX12-NEXT:    v_dual_mov_b32 v32, v1 :: v_dual_and_b32 v33, 0xffff, v0
; GFX12-NEXT:    v_dual_mov_b32 v0, s3 :: v_dual_and_b32 v21, 0xffff, v3
; GFX12-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, v1
; GFX12-NEXT:    s_bfe_u32 s3, s2, 0x10014
; GFX12-NEXT:    s_bfe_u32 s6, s2, 0x10015
; GFX12-NEXT:    v_lshrrev_b16 v9, 8, s2
; GFX12-NEXT:    v_lshrrev_b16 v15, 1, s2
; GFX12-NEXT:    v_and_b32_e32 v11, 1, v11
; GFX12-NEXT:    v_and_b32_e32 v13, 1, v13
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:176
; GFX12-NEXT:    v_mov_b32_e32 v2, s6
; GFX12-NEXT:    v_mov_b32_e32 v0, s3
; GFX12-NEXT:    s_bfe_u32 s3, s2, 0x10012
; GFX12-NEXT:    s_bfe_u32 s6, s2, 0x10013
; GFX12-NEXT:    v_lshrrev_b16 v6, 10, s2
; GFX12-NEXT:    v_and_b32_e32 v26, 1, v15
; GFX12-NEXT:    v_dual_mov_b32 v36, v1 :: v_dual_and_b32 v15, 1, v9
; GFX12-NEXT:    v_and_b32_e32 v9, 1, v17
; GFX12-NEXT:    v_and_b32_e32 v29, 1, v23
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:160
; GFX12-NEXT:    v_mov_b32_e32 v2, s6
; GFX12-NEXT:    v_mov_b32_e32 v0, s3
; GFX12-NEXT:    v_lshrrev_b16 v5, 15, s2
; GFX12-NEXT:    v_lshrrev_b16 v7, 14, s2
; GFX12-NEXT:    v_lshrrev_b16 v10, 6, s2
; GFX12-NEXT:    v_lshrrev_b16 v12, 4, s2
; GFX12-NEXT:    v_lshrrev_b16 v14, 2, s2
; GFX12-NEXT:    s_bfe_u32 s4, s2, 0x10018
; GFX12-NEXT:    s_and_b32 s5, s2, 1
; GFX12-NEXT:    s_bfe_u32 s3, s2, 0x10011
; GFX12-NEXT:    s_bfe_u32 s2, s2, 0x10010
; GFX12-NEXT:    v_dual_mov_b32 v38, v1 :: v_dual_and_b32 v19, 1, v6
; GFX12-NEXT:    v_and_b32_e32 v6, 0xffff, v13
; GFX12-NEXT:    v_and_b32_e32 v17, 0xffff, v24
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:144
; GFX12-NEXT:    v_mov_b32_e32 v2, s3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v13, v1
; GFX12-NEXT:    v_and_b32_e32 v43, 0xffff, v26
; GFX12-NEXT:    v_and_b32_e32 v4, 1, v14
; GFX12-NEXT:    v_and_b32_e32 v8, 1, v12
; GFX12-NEXT:    v_and_b32_e32 v44, 0xffff, v29
; GFX12-NEXT:    v_dual_mov_b32 v34, v1 :: v_dual_and_b32 v35, 1, v18
; GFX12-NEXT:    v_and_b32_e32 v37, 0xffff, v16
; GFX12-NEXT:    v_and_b32_e32 v39, 1, v7
; GFX12-NEXT:    v_dual_mov_b32 v16, v1 :: v_dual_and_b32 v41, 0xffff, v5
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:128
; GFX12-NEXT:    v_mov_b32_e32 v5, v1
; GFX12-NEXT:    v_dual_mov_b32 v7, v1 :: v_dual_mov_b32 v0, s5
; GFX12-NEXT:    v_dual_mov_b32 v2, v43 :: v_dual_and_b32 v29, 0xffff, v9
; GFX12-NEXT:    v_dual_mov_b32 v40, v1 :: v_dual_and_b32 v23, 1, v22
; GFX12-NEXT:    v_dual_mov_b32 v30, v1 :: v_dual_and_b32 v27, 1, v20
; GFX12-NEXT:    v_mov_b32_e32 v20, v1
; GFX12-NEXT:    v_mov_b32_e32 v22, v1
; GFX12-NEXT:    v_mov_b32_e32 v18, v1
; GFX12-NEXT:    v_and_b32_e32 v12, 1, v10
; GFX12-NEXT:    v_and_b32_e32 v10, 0xffff, v11
; GFX12-NEXT:    v_and_b32_e32 v14, 0xffff, v25
; GFX12-NEXT:    v_mov_b32_e32 v24, v1
; GFX12-NEXT:    s_clause 0x4
; GFX12-NEXT:    global_store_b128 v1, v[35:38], s[0:1] offset:240
; GFX12-NEXT:    global_store_b128 v1, v[39:42], s[0:1] offset:112
; GFX12-NEXT:    global_store_b128 v1, v[31:34], s[0:1] offset:96
; GFX12-NEXT:    global_store_b128 v1, v[19:22], s[0:1] offset:80
; GFX12-NEXT:    global_store_b128 v1, v[15:18], s[0:1] offset:64
; GFX12-NEXT:    v_mov_b32_e32 v15, v1
; GFX12-NEXT:    v_mov_b32_e32 v11, v1
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v1, v[4:7], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1]
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    v_dual_mov_b32 v2, v44 :: v_dual_mov_b32 v9, v1
; GFX12-NEXT:    v_dual_mov_b32 v26, v1 :: v_dual_and_b32 v25, 0xffff, v28
; GFX12-NEXT:    v_mov_b32_e32 v28, v1
; GFX12-NEXT:    s_clause 0x4
; GFX12-NEXT:    global_store_b128 v1, v[12:15], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v1, v[8:11], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v1, v[27:30], s[0:1] offset:224
; GFX12-NEXT:    global_store_b128 v1, v[23:26], s[0:1] offset:208
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:192
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <32 x i1>, ptr addrspace(4) %in
  %ext = zext <32 x i1> %load to <32 x i64>
  store <32 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v32i1_to_v32i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v32i1_to_v32i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dword s8, s[2:3], 0x0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_lshr_b32 s52, s8, 30
; GFX6-NEXT:    s_lshr_b32 s46, s8, 31
; GFX6-NEXT:    s_lshr_b32 s48, s8, 28
; GFX6-NEXT:    s_lshr_b32 s36, s8, 29
; GFX6-NEXT:    s_lshr_b32 s38, s8, 26
; GFX6-NEXT:    s_lshr_b32 s26, s8, 27
; GFX6-NEXT:    s_lshr_b32 s28, s8, 24
; GFX6-NEXT:    s_lshr_b32 s4, s8, 25
; GFX6-NEXT:    s_lshr_b32 s6, s8, 22
; GFX6-NEXT:    s_lshr_b32 s10, s8, 23
; GFX6-NEXT:    s_lshr_b32 s12, s8, 20
; GFX6-NEXT:    s_lshr_b32 s14, s8, 21
; GFX6-NEXT:    s_lshr_b32 s16, s8, 18
; GFX6-NEXT:    s_lshr_b32 s18, s8, 19
; GFX6-NEXT:    s_lshr_b32 s20, s8, 16
; GFX6-NEXT:    s_lshr_b32 s22, s8, 17
; GFX6-NEXT:    s_lshr_b32 s24, s8, 14
; GFX6-NEXT:    s_lshr_b32 s30, s8, 15
; GFX6-NEXT:    s_lshr_b32 s34, s8, 12
; GFX6-NEXT:    s_lshr_b32 s40, s8, 13
; GFX6-NEXT:    s_lshr_b32 s42, s8, 10
; GFX6-NEXT:    s_lshr_b32 s44, s8, 11
; GFX6-NEXT:    s_bfe_i64 s[50:51], s[8:9], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[52:53], s[52:53], 0x10000
; GFX6-NEXT:    v_mov_b32_e32 v0, s50
; GFX6-NEXT:    v_mov_b32_e32 v1, s51
; GFX6-NEXT:    s_lshr_b32 s50, s8, 8
; GFX6-NEXT:    v_mov_b32_e32 v2, s52
; GFX6-NEXT:    v_mov_b32_e32 v3, s53
; GFX6-NEXT:    s_lshr_b32 s52, s8, 9
; GFX6-NEXT:    s_bfe_i64 s[46:47], s[46:47], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[48:49], s[48:49], 0x10000
; GFX6-NEXT:    v_mov_b32_e32 v4, s46
; GFX6-NEXT:    v_mov_b32_e32 v5, s47
; GFX6-NEXT:    s_lshr_b32 s46, s8, 6
; GFX6-NEXT:    v_mov_b32_e32 v6, s48
; GFX6-NEXT:    v_mov_b32_e32 v7, s49
; GFX6-NEXT:    s_lshr_b32 s48, s8, 7
; GFX6-NEXT:    s_bfe_i64 s[36:37], s[36:37], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[38:39], s[38:39], 0x10000
; GFX6-NEXT:    v_mov_b32_e32 v8, s36
; GFX6-NEXT:    v_mov_b32_e32 v9, s37
; GFX6-NEXT:    s_lshr_b32 s36, s8, 4
; GFX6-NEXT:    v_mov_b32_e32 v10, s38
; GFX6-NEXT:    v_mov_b32_e32 v11, s39
; GFX6-NEXT:    s_lshr_b32 s38, s8, 5
; GFX6-NEXT:    s_bfe_i64 s[26:27], s[26:27], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[28:29], s[28:29], 0x10000
; GFX6-NEXT:    v_mov_b32_e32 v12, s26
; GFX6-NEXT:    v_mov_b32_e32 v13, s27
; GFX6-NEXT:    s_lshr_b32 s26, s8, 2
; GFX6-NEXT:    v_mov_b32_e32 v14, s28
; GFX6-NEXT:    v_mov_b32_e32 v15, s29
; GFX6-NEXT:    s_lshr_b32 s28, s8, 3
; GFX6-NEXT:    s_lshr_b32 s8, s8, 1
; GFX6-NEXT:    s_bfe_i64 s[8:9], s[8:9], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[28:29], s[28:29], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[26:27], s[26:27], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[38:39], s[38:39], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[36:37], s[36:37], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[48:49], s[48:49], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[46:47], s[46:47], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[52:53], s[52:53], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[50:51], s[50:51], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[44:45], s[44:45], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[42:43], s[42:43], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[40:41], s[40:41], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[34:35], s[34:35], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[30:31], s[30:31], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[24:25], s[24:25], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[22:23], s[22:23], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[20:21], s[20:21], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[18:19], s[18:19], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[16:17], s[16:17], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[14:15], s[14:15], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[12:13], s[12:13], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[10:11], s[10:11], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[6:7], s[6:7], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[4:5], s[4:5], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:240
; GFX6-NEXT:    buffer_store_dwordx4 v[6:9], off, s[0:3], 0 offset:224
; GFX6-NEXT:    buffer_store_dwordx4 v[10:13], off, s[0:3], 0 offset:208
; GFX6-NEXT:    v_mov_b32_e32 v16, s4
; GFX6-NEXT:    v_mov_b32_e32 v17, s5
; GFX6-NEXT:    buffer_store_dwordx4 v[14:17], off, s[0:3], 0 offset:192
; GFX6-NEXT:    s_waitcnt expcnt(3)
; GFX6-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NEXT:    v_mov_b32_e32 v4, s10
; GFX6-NEXT:    v_mov_b32_e32 v5, s11
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:176
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, s12
; GFX6-NEXT:    v_mov_b32_e32 v3, s13
; GFX6-NEXT:    v_mov_b32_e32 v4, s14
; GFX6-NEXT:    v_mov_b32_e32 v5, s15
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:160
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, s16
; GFX6-NEXT:    v_mov_b32_e32 v3, s17
; GFX6-NEXT:    v_mov_b32_e32 v4, s18
; GFX6-NEXT:    v_mov_b32_e32 v5, s19
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:144
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, s20
; GFX6-NEXT:    v_mov_b32_e32 v3, s21
; GFX6-NEXT:    v_mov_b32_e32 v4, s22
; GFX6-NEXT:    v_mov_b32_e32 v5, s23
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:128
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, s24
; GFX6-NEXT:    v_mov_b32_e32 v3, s25
; GFX6-NEXT:    v_mov_b32_e32 v4, s30
; GFX6-NEXT:    v_mov_b32_e32 v5, s31
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:112
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, s34
; GFX6-NEXT:    v_mov_b32_e32 v3, s35
; GFX6-NEXT:    v_mov_b32_e32 v4, s40
; GFX6-NEXT:    v_mov_b32_e32 v5, s41
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:96
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, s42
; GFX6-NEXT:    v_mov_b32_e32 v3, s43
; GFX6-NEXT:    v_mov_b32_e32 v4, s44
; GFX6-NEXT:    v_mov_b32_e32 v5, s45
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:80
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, s50
; GFX6-NEXT:    v_mov_b32_e32 v3, s51
; GFX6-NEXT:    v_mov_b32_e32 v4, s52
; GFX6-NEXT:    v_mov_b32_e32 v5, s53
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:64
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, s46
; GFX6-NEXT:    v_mov_b32_e32 v3, s47
; GFX6-NEXT:    v_mov_b32_e32 v4, s48
; GFX6-NEXT:    v_mov_b32_e32 v5, s49
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:48
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, s36
; GFX6-NEXT:    v_mov_b32_e32 v3, s37
; GFX6-NEXT:    v_mov_b32_e32 v4, s38
; GFX6-NEXT:    v_mov_b32_e32 v5, s39
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:32
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, s26
; GFX6-NEXT:    v_mov_b32_e32 v3, s27
; GFX6-NEXT:    v_mov_b32_e32 v4, s28
; GFX6-NEXT:    v_mov_b32_e32 v5, s29
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], off, s[0:3], 0 offset:16
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, s8
; GFX6-NEXT:    v_mov_b32_e32 v3, s9
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v32i1_to_v32i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s6, s4, 22
; GFX8-NEXT:    s_lshr_b32 s8, s4, 23
; GFX8-NEXT:    s_lshr_b32 s10, s4, 20
; GFX8-NEXT:    s_lshr_b32 s12, s4, 21
; GFX8-NEXT:    s_lshr_b32 s14, s4, 18
; GFX8-NEXT:    s_lshr_b32 s16, s4, 19
; GFX8-NEXT:    s_lshr_b32 s18, s4, 16
; GFX8-NEXT:    s_lshr_b32 s20, s4, 17
; GFX8-NEXT:    s_lshr_b32 s2, s4, 24
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 14, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v3, 15, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v15, 12, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v17, 13, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v13, 10, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 11, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v9, 8, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v10, 9, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v6, 6, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v8, 7, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v4, 4, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v5, 5, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 2, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 3, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v7, 1, s4
; GFX8-NEXT:    v_lshrrev_b16_e64 v11, 6, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v12, 7, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v16, 4, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v18, 5, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v19, 2, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v20, 3, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v27, 1, s2
; GFX8-NEXT:    s_bfe_i64 s[2:3], s[2:3], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[4:5], s[4:5], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[20:21], s[20:21], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[18:19], s[18:19], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[16:17], s[16:17], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[14:15], s[14:15], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[12:13], s[12:13], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[10:11], s[10:11], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[8:9], s[8:9], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[6:7], s[6:7], 0x10000
; GFX8-NEXT:    v_mov_b32_e32 v21, s6
; GFX8-NEXT:    s_add_u32 s6, s0, 0xb0
; GFX8-NEXT:    v_mov_b32_e32 v22, s7
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v26, s7
; GFX8-NEXT:    v_mov_b32_e32 v25, s6
; GFX8-NEXT:    s_add_u32 s6, s0, 0xa0
; GFX8-NEXT:    v_mov_b32_e32 v23, s8
; GFX8-NEXT:    v_mov_b32_e32 v24, s9
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[25:26], v[21:24]
; GFX8-NEXT:    v_mov_b32_e32 v26, s7
; GFX8-NEXT:    v_mov_b32_e32 v25, s6
; GFX8-NEXT:    s_add_u32 s6, s0, 0x90
; GFX8-NEXT:    v_mov_b32_e32 v21, s10
; GFX8-NEXT:    v_mov_b32_e32 v22, s11
; GFX8-NEXT:    v_mov_b32_e32 v23, s12
; GFX8-NEXT:    v_mov_b32_e32 v24, s13
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[25:26], v[21:24]
; GFX8-NEXT:    v_mov_b32_e32 v26, s7
; GFX8-NEXT:    v_mov_b32_e32 v25, s6
; GFX8-NEXT:    s_add_u32 s6, s0, 0x80
; GFX8-NEXT:    v_mov_b32_e32 v21, s14
; GFX8-NEXT:    v_mov_b32_e32 v22, s15
; GFX8-NEXT:    v_mov_b32_e32 v23, s16
; GFX8-NEXT:    v_mov_b32_e32 v24, s17
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[25:26], v[21:24]
; GFX8-NEXT:    v_mov_b32_e32 v26, s7
; GFX8-NEXT:    v_mov_b32_e32 v21, s18
; GFX8-NEXT:    v_mov_b32_e32 v22, s19
; GFX8-NEXT:    v_mov_b32_e32 v23, s20
; GFX8-NEXT:    v_mov_b32_e32 v24, s21
; GFX8-NEXT:    v_mov_b32_e32 v25, s6
; GFX8-NEXT:    s_add_u32 s6, s0, 0x70
; GFX8-NEXT:    flat_store_dwordx4 v[25:26], v[21:24]
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    v_bfe_i32 v23, v3, 0, 1
; GFX8-NEXT:    v_bfe_i32 v21, v2, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    s_add_u32 s6, s0, 0x60
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    v_ashrrev_i32_e32 v24, 31, v23
; GFX8-NEXT:    v_ashrrev_i32_e32 v22, 31, v21
; GFX8-NEXT:    v_mov_b32_e32 v26, s7
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[21:24]
; GFX8-NEXT:    v_mov_b32_e32 v25, s6
; GFX8-NEXT:    v_bfe_i32 v23, v17, 0, 1
; GFX8-NEXT:    v_bfe_i32 v21, v15, 0, 1
; GFX8-NEXT:    s_add_u32 s6, s0, 0x50
; GFX8-NEXT:    v_ashrrev_i32_e32 v24, 31, v23
; GFX8-NEXT:    v_ashrrev_i32_e32 v22, 31, v21
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[25:26], v[21:24]
; GFX8-NEXT:    v_bfe_i32 v25, v14, 0, 1
; GFX8-NEXT:    v_bfe_i32 v23, v13, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v14, s7
; GFX8-NEXT:    v_mov_b32_e32 v13, s6
; GFX8-NEXT:    s_add_u32 s6, s0, 64
; GFX8-NEXT:    v_ashrrev_i32_e32 v26, 31, v25
; GFX8-NEXT:    v_ashrrev_i32_e32 v24, 31, v23
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[13:14], v[23:26]
; GFX8-NEXT:    v_bfe_i32 v12, v12, 0, 1
; GFX8-NEXT:    v_bfe_i32 v25, v10, 0, 1
; GFX8-NEXT:    v_bfe_i32 v23, v9, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v10, s7
; GFX8-NEXT:    v_mov_b32_e32 v9, s6
; GFX8-NEXT:    s_add_u32 s6, s0, 48
; GFX8-NEXT:    v_ashrrev_i32_e32 v26, 31, v25
; GFX8-NEXT:    v_ashrrev_i32_e32 v24, 31, v23
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[9:10], v[23:26]
; GFX8-NEXT:    v_bfe_i32 v10, v11, 0, 1
; GFX8-NEXT:    v_bfe_i32 v25, v8, 0, 1
; GFX8-NEXT:    v_bfe_i32 v23, v6, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v9, s7
; GFX8-NEXT:    v_ashrrev_i32_e32 v26, 31, v25
; GFX8-NEXT:    v_ashrrev_i32_e32 v24, 31, v23
; GFX8-NEXT:    v_mov_b32_e32 v8, s6
; GFX8-NEXT:    s_add_u32 s6, s0, 32
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[23:26]
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    v_bfe_i32 v25, v5, 0, 1
; GFX8-NEXT:    v_bfe_i32 v23, v4, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v4, s6
; GFX8-NEXT:    v_ashrrev_i32_e32 v26, 31, v25
; GFX8-NEXT:    v_ashrrev_i32_e32 v24, 31, v23
; GFX8-NEXT:    v_mov_b32_e32 v5, s7
; GFX8-NEXT:    s_add_u32 s6, s0, 16
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[23:26]
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    v_bfe_i32 v25, v1, 0, 1
; GFX8-NEXT:    v_bfe_i32 v23, v0, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_ashrrev_i32_e32 v26, 31, v25
; GFX8-NEXT:    v_ashrrev_i32_e32 v24, 31, v23
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_bfe_i32 v6, v7, 0, 1
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[23:26]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX8-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_add_u32 s4, s0, 0xf0
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX8-NEXT:    s_addc_u32 s5, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_ashrrev_i32_e32 v13, 31, v12
; GFX8-NEXT:    v_ashrrev_i32_e32 v11, 31, v10
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_add_u32 s4, s0, 0xe0
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[10:13]
; GFX8-NEXT:    s_addc_u32 s5, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_add_u32 s4, s0, 0xd0
; GFX8-NEXT:    v_bfe_i32 v17, v18, 0, 1
; GFX8-NEXT:    v_bfe_i32 v15, v16, 0, 1
; GFX8-NEXT:    s_addc_u32 s5, s1, 0
; GFX8-NEXT:    v_ashrrev_i32_e32 v18, 31, v17
; GFX8-NEXT:    v_ashrrev_i32_e32 v16, 31, v15
; GFX8-NEXT:    s_add_u32 s0, s0, 0xc0
; GFX8-NEXT:    v_bfe_i32 v21, v20, 0, 1
; GFX8-NEXT:    v_bfe_i32 v19, v19, 0, 1
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[15:18]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_bfe_i32 v2, v27, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v22, 31, v21
; GFX8-NEXT:    v_ashrrev_i32_e32 v20, 31, v19
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[19:22]
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v32i1_to_v32i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @24, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @22
; EG-NEXT:    ALU 92, @25, KC0[CB0:0-32], KC1[]
; EG-NEXT:    ALU 65, @118, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T26.XYZW, T42.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T40.XYZW, T41.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T27.XYZW, T34.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T39.XYZW, T24.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T28.XYZW, T23.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T38.XYZW, T22.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T29.XYZW, T21.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T37.XYZW, T20.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T30.XYZW, T19.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T36.XYZW, T18.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T31.XYZW, T17.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T11.XYZW, T16.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T32.XYZW, T15.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T35.XYZW, T14.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T33.XYZW, T13.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T25.XYZW, T12.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 22:
; EG-NEXT:     VTX_READ_32 T11.X, T11.X, 0, #1
; EG-NEXT:    ALU clause starting at 24:
; EG-NEXT:     MOV * T11.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 25:
; EG-NEXT:     LSHR T12.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T13.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T14.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T15.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T16.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T17.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:     LSHR T18.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR T19.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 128(1.793662e-43)
; EG-NEXT:     LSHR T20.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 144(2.017870e-43)
; EG-NEXT:     LSHR T21.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 160(2.242078e-43)
; EG-NEXT:     LSHR T22.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 176(2.466285e-43)
; EG-NEXT:     LSHR T23.X, PV.W, literal.x,
; EG-NEXT:     LSHR T0.Y, T11.X, literal.y,
; EG-NEXT:     LSHR T0.Z, T11.X, literal.z,
; EG-NEXT:     LSHR * T0.W, T11.X, literal.w,
; EG-NEXT:    2(2.802597e-45), 28(3.923636e-44)
; EG-NEXT:    29(4.063766e-44), 24(3.363116e-44)
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    192(2.690493e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T24.X, PV.W, literal.x,
; EG-NEXT:     LSHR T1.Y, T11.X, literal.y,
; EG-NEXT:     LSHR T1.Z, T11.X, literal.z,
; EG-NEXT:     LSHR * T1.W, T11.X, literal.w,
; EG-NEXT:    2(2.802597e-45), 25(3.503246e-44)
; EG-NEXT:    20(2.802597e-44), 21(2.942727e-44)
; EG-NEXT:     LSHR * T2.W, T11.X, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T25.X, T11.X, 0.0, 1,
; EG-NEXT:     LSHR T2.Y, T11.X, literal.x,
; EG-NEXT:     ASHR T26.Z, T11.X, literal.y,
; EG-NEXT:     LSHR T3.W, T11.X, literal.z,
; EG-NEXT:     LSHR * T4.W, T11.X, literal.w,
; EG-NEXT:    17(2.382207e-44), 31(4.344025e-44)
; EG-NEXT:    27(3.783506e-44), 30(4.203895e-44)
; EG-NEXT:     BFE_INT T26.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T3.Y, T11.X, literal.x,
; EG-NEXT:     BFE_INT T27.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T3.W, T11.X, literal.y,
; EG-NEXT:     LSHR * T4.W, T11.X, literal.z,
; EG-NEXT:    12(1.681558e-44), 23(3.222986e-44)
; EG-NEXT:    26(3.643376e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T27.X, PS, 0.0, 1,
; EG-NEXT:     MOV T26.Y, PV.X,
; EG-NEXT:     BFE_INT T28.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T3.W, T11.X, literal.x,
; EG-NEXT:     LSHR * T4.W, T11.X, literal.y,
; EG-NEXT:    19(2.662467e-44), 22(3.082857e-44)
; EG-NEXT:     BFE_INT T28.X, PS, 0.0, 1,
; EG-NEXT:     MOV T27.Y, PV.X,
; EG-NEXT:     BFE_INT T29.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T3.W, T11.X, literal.x,
; EG-NEXT:     LSHR * T4.W, T11.X, literal.y,
; EG-NEXT:    15(2.101948e-44), 18(2.522337e-44)
; EG-NEXT:     BFE_INT T29.X, PS, 0.0, 1,
; EG-NEXT:     MOV T28.Y, PV.X,
; EG-NEXT:     BFE_INT T30.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T3.W, T11.X, literal.x,
; EG-NEXT:     LSHR * T4.W, T11.X, literal.y,
; EG-NEXT:    11(1.541428e-44), 14(1.961818e-44)
; EG-NEXT:     BFE_INT T30.X, PS, 0.0, 1,
; EG-NEXT:     MOV T29.Y, PV.X,
; EG-NEXT:     BFE_INT T31.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T3.W, T11.X, literal.x,
; EG-NEXT:     LSHR * T4.W, T11.X, literal.y,
; EG-NEXT:    7(9.809089e-45), 10(1.401298e-44)
; EG-NEXT:     BFE_INT T31.X, PS, 0.0, 1,
; EG-NEXT:     MOV T30.Y, PV.X,
; EG-NEXT:     BFE_INT T32.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T3.W, T11.X, literal.x,
; EG-NEXT:     LSHR * T4.W, T11.X, literal.y,
; EG-NEXT:    3(4.203895e-45), 6(8.407791e-45)
; EG-NEXT:    ALU clause starting at 118:
; EG-NEXT:     BFE_INT T32.X, T4.W, 0.0, 1,
; EG-NEXT:     MOV T31.Y, T31.X,
; EG-NEXT:     BFE_INT T33.Z, T3.W, 0.0, 1, BS:VEC_120/SCL_212
; EG-NEXT:     LSHR T3.W, T11.X, 1, BS:VEC_120/SCL_212
; EG-NEXT:     LSHR * T4.W, T11.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T33.X, PS, 0.0, 1,
; EG-NEXT:     MOV T32.Y, PV.X,
; EG-NEXT:     BFE_INT T25.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T3.W, T11.X, literal.x,
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.y,
; EG-NEXT:    5(7.006492e-45), 208(2.914701e-43)
; EG-NEXT:     LSHR T34.X, PS, literal.x,
; EG-NEXT:     MOV T33.Y, PV.X,
; EG-NEXT:     BFE_INT T35.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T3.W, T11.X, literal.y,
; EG-NEXT:     LSHR * T4.W, T11.X, literal.z,
; EG-NEXT:    2(2.802597e-45), 9(1.261169e-44)
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T35.X, PS, 0.0, 1,
; EG-NEXT:     MOV T25.Y, T25.X,
; EG-NEXT:     BFE_INT T11.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T3.W, T11.X, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     LSHR * T4.W, T11.X, literal.y,
; EG-NEXT:    13(1.821688e-44), 8(1.121039e-44)
; EG-NEXT:     BFE_INT T11.X, PS, 0.0, 1,
; EG-NEXT:     MOV T35.Y, PV.X,
; EG-NEXT:     BFE_INT T36.Z, PV.W, 0.0, 1,
; EG-NEXT:     MOV T25.W, T25.Z,
; EG-NEXT:     MOV * T33.W, T33.Z,
; EG-NEXT:     BFE_INT T36.X, T3.Y, 0.0, 1,
; EG-NEXT:     MOV T11.Y, PV.X,
; EG-NEXT:     BFE_INT T37.Z, T2.Y, 0.0, 1, BS:VEC_120/SCL_212
; EG-NEXT:     MOV T35.W, T35.Z,
; EG-NEXT:     MOV * T32.W, T32.Z,
; EG-NEXT:     BFE_INT T37.X, T2.W, 0.0, 1,
; EG-NEXT:     MOV T36.Y, PV.X,
; EG-NEXT:     BFE_INT T38.Z, T1.W, 0.0, 1, BS:VEC_120/SCL_212
; EG-NEXT:     MOV T11.W, T11.Z,
; EG-NEXT:     MOV * T31.W, T31.Z,
; EG-NEXT:     BFE_INT T38.X, T1.Z, 0.0, 1,
; EG-NEXT:     MOV T37.Y, PV.X,
; EG-NEXT:     BFE_INT T39.Z, T1.Y, 0.0, 1,
; EG-NEXT:     MOV T36.W, T36.Z, BS:VEC_120/SCL_212
; EG-NEXT:     MOV * T30.W, T30.Z,
; EG-NEXT:     BFE_INT T39.X, T0.W, 0.0, 1,
; EG-NEXT:     MOV T38.Y, PV.X,
; EG-NEXT:     BFE_INT T40.Z, T0.Z, 0.0, 1,
; EG-NEXT:     MOV T37.W, T37.Z, BS:VEC_120/SCL_212
; EG-NEXT:     MOV * T29.W, T29.Z,
; EG-NEXT:     BFE_INT T40.X, T0.Y, 0.0, 1,
; EG-NEXT:     MOV T39.Y, PV.X,
; EG-NEXT:     ADD_INT T0.Z, KC0[2].Y, literal.x,
; EG-NEXT:     MOV T38.W, T38.Z,
; EG-NEXT:     MOV * T28.W, T28.Z,
; EG-NEXT:    224(3.138909e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T41.X, PV.Z, literal.x,
; EG-NEXT:     MOV T40.Y, PV.X,
; EG-NEXT:     ADD_INT T0.Z, KC0[2].Y, literal.y,
; EG-NEXT:     MOV T39.W, T39.Z,
; EG-NEXT:     MOV * T27.W, T27.Z,
; EG-NEXT:    2(2.802597e-45), 240(3.363116e-43)
; EG-NEXT:     LSHR T42.X, PV.Z, literal.x,
; EG-NEXT:     MOV T40.W, T40.Z,
; EG-NEXT:     MOV * T26.W, T26.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v32i1_to_v32i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v26, 6, s2
; GFX12-NEXT:    v_lshrrev_b16 v28, 7, s2
; GFX12-NEXT:    v_lshrrev_b16 v4, 2, s2
; GFX12-NEXT:    v_lshrrev_b16 v5, 3, s2
; GFX12-NEXT:    s_lshr_b32 s22, s2, 24
; GFX12-NEXT:    s_lshr_b32 s12, s2, 22
; GFX12-NEXT:    s_lshr_b32 s14, s2, 23
; GFX12-NEXT:    v_lshrrev_b16 v6, 4, s2
; GFX12-NEXT:    v_lshrrev_b16 v8, 5, s2
; GFX12-NEXT:    v_lshrrev_b16 v3, 1, s2
; GFX12-NEXT:    s_lshr_b32 s16, s2, 20
; GFX12-NEXT:    s_lshr_b32 s18, s2, 21
; GFX12-NEXT:    v_lshrrev_b16 v1, 14, s2
; GFX12-NEXT:    v_lshrrev_b16 v2, 15, s2
; GFX12-NEXT:    v_lshrrev_b16 v12, 6, s22
; GFX12-NEXT:    v_lshrrev_b16 v14, 7, s22
; GFX12-NEXT:    v_lshrrev_b16 v9, 12, s2
; GFX12-NEXT:    v_lshrrev_b16 v10, 13, s2
; GFX12-NEXT:    v_lshrrev_b16 v16, 4, s22
; GFX12-NEXT:    v_lshrrev_b16 v17, 5, s22
; GFX12-NEXT:    s_bfe_i64 s[12:13], s[12:13], 0x10000
; GFX12-NEXT:    s_bfe_i64 s[14:15], s[14:15], 0x10000
; GFX12-NEXT:    s_lshr_b32 s4, s2, 18
; GFX12-NEXT:    v_lshrrev_b16 v37, 10, s2
; GFX12-NEXT:    v_lshrrev_b16 v34, 11, s2
; GFX12-NEXT:    v_lshrrev_b16 v13, 2, s22
; GFX12-NEXT:    v_lshrrev_b16 v15, 3, s22
; GFX12-NEXT:    s_bfe_i64 s[18:19], s[18:19], 0x10000
; GFX12-NEXT:    s_bfe_i64 s[16:17], s[16:17], 0x10000
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v49, s12
; GFX12-NEXT:    v_lshrrev_b16 v30, 8, s2
; GFX12-NEXT:    v_lshrrev_b16 v32, 9, s2
; GFX12-NEXT:    v_lshrrev_b16 v11, 1, s22
; GFX12-NEXT:    v_bfe_i32 v7, v5, 0, 1
; GFX12-NEXT:    v_bfe_i32 v5, v4, 0, 1
; GFX12-NEXT:    v_bfe_i32 v31, v28, 0, 1
; GFX12-NEXT:    v_bfe_i32 v29, v26, 0, 1
; GFX12-NEXT:    v_dual_mov_b32 v50, s13 :: v_dual_mov_b32 v51, s14
; GFX12-NEXT:    v_dual_mov_b32 v52, s15 :: v_dual_mov_b32 v53, s16
; GFX12-NEXT:    s_lshr_b32 s6, s2, 19
; GFX12-NEXT:    v_bfe_i32 v3, v3, 0, 1
; GFX12-NEXT:    v_bfe_i32 v27, v8, 0, 1
; GFX12-NEXT:    v_bfe_i32 v25, v6, 0, 1
; GFX12-NEXT:    v_dual_mov_b32 v54, s17 :: v_dual_mov_b32 v55, s18
; GFX12-NEXT:    s_bfe_i64 s[4:5], s[4:5], 0x10000
; GFX12-NEXT:    v_mov_b32_e32 v56, s19
; GFX12-NEXT:    s_lshr_b32 s10, s2, 16
; GFX12-NEXT:    s_lshr_b32 s20, s2, 17
; GFX12-NEXT:    v_bfe_i32 v23, v14, 0, 1
; GFX12-NEXT:    v_bfe_i32 v21, v12, 0, 1
; GFX12-NEXT:    v_bfe_i32 v47, v2, 0, 1
; GFX12-NEXT:    v_bfe_i32 v45, v1, 0, 1
; GFX12-NEXT:    v_bfe_i32 v19, v17, 0, 1
; GFX12-NEXT:    v_bfe_i32 v17, v16, 0, 1
; GFX12-NEXT:    v_bfe_i32 v43, v10, 0, 1
; GFX12-NEXT:    v_bfe_i32 v41, v9, 0, 1
; GFX12-NEXT:    s_bfe_i64 s[6:7], s[6:7], 0x10000
; GFX12-NEXT:    s_bfe_i64 s[8:9], s[2:3], 0x10000
; GFX12-NEXT:    v_bfe_i32 v15, v15, 0, 1
; GFX12-NEXT:    v_bfe_i32 v13, v13, 0, 1
; GFX12-NEXT:    v_bfe_i32 v39, v34, 0, 1
; GFX12-NEXT:    v_bfe_i32 v37, v37, 0, 1
; GFX12-NEXT:    s_bfe_i64 s[20:21], s[20:21], 0x10000
; GFX12-NEXT:    s_bfe_i64 s[10:11], s[10:11], 0x10000
; GFX12-NEXT:    v_bfe_i32 v11, v11, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v8, 31, v7
; GFX12-NEXT:    v_ashrrev_i32_e32 v6, 31, v5
; GFX12-NEXT:    v_bfe_i32 v35, v32, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v32, 31, v31
; GFX12-NEXT:    v_bfe_i32 v33, v30, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v30, 31, v29
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v0, v[49:52], s[0:1] offset:176
; GFX12-NEXT:    global_store_b128 v0, v[53:56], s[0:1] offset:160
; GFX12-NEXT:    v_dual_mov_b32 v49, s4 :: v_dual_mov_b32 v50, s5
; GFX12-NEXT:    v_dual_mov_b32 v51, s6 :: v_dual_mov_b32 v52, s7
; GFX12-NEXT:    v_mov_b32_e32 v53, s10
; GFX12-NEXT:    s_bfe_i64 s[2:3], s[22:23], 0x10000
; GFX12-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GFX12-NEXT:    v_ashrrev_i32_e32 v28, 31, v27
; GFX12-NEXT:    v_ashrrev_i32_e32 v26, 31, v25
; GFX12-NEXT:    v_dual_mov_b32 v54, s11 :: v_dual_mov_b32 v55, s20
; GFX12-NEXT:    v_dual_mov_b32 v56, s21 :: v_dual_mov_b32 v1, s8
; GFX12-NEXT:    v_dual_mov_b32 v2, s9 :: v_dual_mov_b32 v9, s2
; GFX12-NEXT:    v_ashrrev_i32_e32 v24, 31, v23
; GFX12-NEXT:    v_ashrrev_i32_e32 v22, 31, v21
; GFX12-NEXT:    v_ashrrev_i32_e32 v48, 31, v47
; GFX12-NEXT:    v_ashrrev_i32_e32 v46, 31, v45
; GFX12-NEXT:    v_ashrrev_i32_e32 v20, 31, v19
; GFX12-NEXT:    v_ashrrev_i32_e32 v18, 31, v17
; GFX12-NEXT:    v_ashrrev_i32_e32 v44, 31, v43
; GFX12-NEXT:    v_ashrrev_i32_e32 v42, 31, v41
; GFX12-NEXT:    v_ashrrev_i32_e32 v16, 31, v15
; GFX12-NEXT:    v_ashrrev_i32_e32 v14, 31, v13
; GFX12-NEXT:    v_ashrrev_i32_e32 v40, 31, v39
; GFX12-NEXT:    v_ashrrev_i32_e32 v38, 31, v37
; GFX12-NEXT:    v_ashrrev_i32_e32 v12, 31, v11
; GFX12-NEXT:    v_ashrrev_i32_e32 v36, 31, v35
; GFX12-NEXT:    v_ashrrev_i32_e32 v34, 31, v33
; GFX12-NEXT:    s_clause 0x7
; GFX12-NEXT:    global_store_b128 v0, v[49:52], s[0:1] offset:144
; GFX12-NEXT:    global_store_b128 v0, v[53:56], s[0:1] offset:128
; GFX12-NEXT:    global_store_b128 v0, v[45:48], s[0:1] offset:112
; GFX12-NEXT:    global_store_b128 v0, v[41:44], s[0:1] offset:96
; GFX12-NEXT:    global_store_b128 v0, v[37:40], s[0:1] offset:80
; GFX12-NEXT:    global_store_b128 v0, v[33:36], s[0:1] offset:64
; GFX12-NEXT:    global_store_b128 v0, v[29:32], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v0, v[25:28], s[0:1] offset:32
; GFX12-NEXT:    v_mov_b32_e32 v10, s3
; GFX12-NEXT:    s_clause 0x5
; GFX12-NEXT:    global_store_b128 v0, v[5:8], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v0, v[1:4], s[0:1]
; GFX12-NEXT:    global_store_b128 v0, v[21:24], s[0:1] offset:240
; GFX12-NEXT:    global_store_b128 v0, v[17:20], s[0:1] offset:224
; GFX12-NEXT:    global_store_b128 v0, v[13:16], s[0:1] offset:208
; GFX12-NEXT:    global_store_b128 v0, v[9:12], s[0:1] offset:192
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <32 x i1>, ptr addrspace(4) %in
  %ext = sext <32 x i1> %load to <32 x i64>
  store <32 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v64i1_to_v64i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_zextload_v64i1_to_v64i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_bfe_u32 s4, s2, 0x10003
; GFX6-NEXT:    s_bfe_u32 s5, s2, 0x10005
; GFX6-NEXT:    s_bfe_u32 s8, s2, 0x10007
; GFX6-NEXT:    s_bfe_u32 s11, s2, 0x10009
; GFX6-NEXT:    s_bfe_u32 s13, s2, 0x1000b
; GFX6-NEXT:    s_bfe_u32 s15, s2, 0x1000d
; GFX6-NEXT:    s_bfe_u32 s17, s2, 0x1000f
; GFX6-NEXT:    s_bfe_u32 s19, s2, 0x10011
; GFX6-NEXT:    s_bfe_u32 s21, s2, 0x10013
; GFX6-NEXT:    s_bfe_u32 s23, s2, 0x10015
; GFX6-NEXT:    s_bfe_u32 s25, s2, 0x10017
; GFX6-NEXT:    s_bfe_u32 s27, s2, 0x10019
; GFX6-NEXT:    s_bfe_u32 s29, s2, 0x1001b
; GFX6-NEXT:    s_bfe_u32 s31, s2, 0x1001d
; GFX6-NEXT:    s_lshr_b32 s34, s2, 31
; GFX6-NEXT:    s_bfe_u32 s36, s3, 0x10003
; GFX6-NEXT:    s_bfe_u32 s37, s3, 0x10005
; GFX6-NEXT:    s_bfe_u32 s38, s3, 0x10007
; GFX6-NEXT:    s_bfe_u32 s39, s3, 0x10009
; GFX6-NEXT:    s_bfe_u32 s40, s3, 0x1000b
; GFX6-NEXT:    s_bfe_u32 s41, s3, 0x1000d
; GFX6-NEXT:    s_bfe_u32 s42, s3, 0x1000f
; GFX6-NEXT:    s_bfe_u32 s43, s3, 0x10011
; GFX6-NEXT:    s_bfe_u32 s44, s3, 0x10013
; GFX6-NEXT:    s_bfe_u32 s45, s3, 0x10015
; GFX6-NEXT:    s_bfe_u32 s46, s3, 0x10017
; GFX6-NEXT:    s_bfe_u32 s47, s3, 0x10019
; GFX6-NEXT:    s_bfe_u32 s48, s3, 0x1001b
; GFX6-NEXT:    s_bfe_u32 s49, s3, 0x1001d
; GFX6-NEXT:    s_lshr_b32 s50, s3, 31
; GFX6-NEXT:    s_bfe_u32 s9, s3, 0x10001
; GFX6-NEXT:    s_bfe_u32 s6, s2, 0x10001
; GFX6-NEXT:    s_and_b32 s7, s2, 1
; GFX6-NEXT:    s_and_b32 s10, s3, 1
; GFX6-NEXT:    s_bfe_u32 s12, s2, 0x10002
; GFX6-NEXT:    s_bfe_u32 s14, s2, 0x10004
; GFX6-NEXT:    s_bfe_u32 s16, s2, 0x10006
; GFX6-NEXT:    s_bfe_u32 s18, s2, 0x10008
; GFX6-NEXT:    s_bfe_u32 s20, s2, 0x1000a
; GFX6-NEXT:    s_bfe_u32 s22, s2, 0x1000c
; GFX6-NEXT:    s_bfe_u32 s24, s2, 0x1000e
; GFX6-NEXT:    s_bfe_u32 s26, s2, 0x10010
; GFX6-NEXT:    s_bfe_u32 s28, s2, 0x10012
; GFX6-NEXT:    s_bfe_u32 s30, s2, 0x10014
; GFX6-NEXT:    s_bfe_u32 s33, s2, 0x10016
; GFX6-NEXT:    s_bfe_u32 s35, s2, 0x10018
; GFX6-NEXT:    s_bfe_u32 s51, s2, 0x1001a
; GFX6-NEXT:    s_bfe_u32 s52, s2, 0x1001c
; GFX6-NEXT:    s_bfe_u32 s53, s2, 0x1001e
; GFX6-NEXT:    s_bfe_u32 s54, s3, 0x10002
; GFX6-NEXT:    s_bfe_u32 s55, s3, 0x10004
; GFX6-NEXT:    s_bfe_u32 s56, s3, 0x10006
; GFX6-NEXT:    s_bfe_u32 s57, s3, 0x10008
; GFX6-NEXT:    s_bfe_u32 s58, s3, 0x1000a
; GFX6-NEXT:    s_bfe_u32 s59, s3, 0x1000c
; GFX6-NEXT:    s_bfe_u32 s60, s3, 0x1000e
; GFX6-NEXT:    s_bfe_u32 s61, s3, 0x10010
; GFX6-NEXT:    s_bfe_u32 s62, s3, 0x10012
; GFX6-NEXT:    s_bfe_u32 s63, s3, 0x10014
; GFX6-NEXT:    s_bfe_u32 s64, s3, 0x10016
; GFX6-NEXT:    s_bfe_u32 s65, s3, 0x10018
; GFX6-NEXT:    s_bfe_u32 s66, s3, 0x1001a
; GFX6-NEXT:    s_bfe_u32 s67, s3, 0x1001e
; GFX6-NEXT:    s_bfe_u32 s68, s3, 0x1001c
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NEXT:    v_mov_b32_e32 v0, s67
; GFX6-NEXT:    v_mov_b32_e32 v2, s50
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:496
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s68
; GFX6-NEXT:    v_mov_b32_e32 v2, s49
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:480
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s66
; GFX6-NEXT:    v_mov_b32_e32 v2, s48
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:464
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s65
; GFX6-NEXT:    v_mov_b32_e32 v2, s47
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:448
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s64
; GFX6-NEXT:    v_mov_b32_e32 v2, s46
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:432
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s63
; GFX6-NEXT:    v_mov_b32_e32 v2, s45
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:416
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s62
; GFX6-NEXT:    v_mov_b32_e32 v2, s44
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:400
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s61
; GFX6-NEXT:    v_mov_b32_e32 v2, s43
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:384
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s60
; GFX6-NEXT:    v_mov_b32_e32 v2, s42
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:368
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s59
; GFX6-NEXT:    v_mov_b32_e32 v2, s41
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:352
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s58
; GFX6-NEXT:    v_mov_b32_e32 v2, s40
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:336
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s57
; GFX6-NEXT:    v_mov_b32_e32 v2, s39
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:320
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s56
; GFX6-NEXT:    v_mov_b32_e32 v2, s38
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:304
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s55
; GFX6-NEXT:    v_mov_b32_e32 v2, s37
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:288
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s54
; GFX6-NEXT:    v_mov_b32_e32 v2, s36
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:272
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s53
; GFX6-NEXT:    v_mov_b32_e32 v2, s34
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:240
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s52
; GFX6-NEXT:    v_mov_b32_e32 v2, s31
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:224
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s51
; GFX6-NEXT:    v_mov_b32_e32 v2, s29
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:208
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s35
; GFX6-NEXT:    v_mov_b32_e32 v2, s27
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:192
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s33
; GFX6-NEXT:    v_mov_b32_e32 v2, s25
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:176
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s30
; GFX6-NEXT:    v_mov_b32_e32 v2, s23
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:160
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s28
; GFX6-NEXT:    v_mov_b32_e32 v2, s21
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:144
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s26
; GFX6-NEXT:    v_mov_b32_e32 v2, s19
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:128
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s24
; GFX6-NEXT:    v_mov_b32_e32 v2, s17
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:112
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s22
; GFX6-NEXT:    v_mov_b32_e32 v2, s15
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:96
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s20
; GFX6-NEXT:    v_mov_b32_e32 v2, s13
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:80
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s18
; GFX6-NEXT:    v_mov_b32_e32 v2, s11
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:64
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s16
; GFX6-NEXT:    v_mov_b32_e32 v2, s8
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s14
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:32
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s12
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s10
; GFX6-NEXT:    v_mov_b32_e32 v2, s9
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:256
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s7
; GFX6-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_zextload_v64i1_to_v64i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 13, s2
; GFX8-NEXT:    v_and_b32_e32 v18, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 11, s2
; GFX8-NEXT:    v_and_b32_e32 v16, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 9, s2
; GFX8-NEXT:    v_and_b32_e32 v15, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 7, s2
; GFX8-NEXT:    v_and_b32_e32 v13, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 5, s2
; GFX8-NEXT:    v_and_b32_e32 v10, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 3, s2
; GFX8-NEXT:    v_mov_b32_e32 v12, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 14, s2
; GFX8-NEXT:    s_lshr_b32 s33, s3, 24
; GFX8-NEXT:    s_lshr_b32 s24, s2, 24
; GFX8-NEXT:    v_lshrrev_b16_e64 v19, 12, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v17, 10, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 6, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v11, 4, s2
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v0
; GFX8-NEXT:    v_lshrrev_b16_e64 v9, 2, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 1, s2
; GFX8-NEXT:    s_bfe_u32 s20, s2, 0x10018
; GFX8-NEXT:    s_bfe_u32 s21, s3, 0x10018
; GFX8-NEXT:    s_and_b32 s22, s3, 1
; GFX8-NEXT:    s_and_b32 s23, s2, 1
; GFX8-NEXT:    v_lshrrev_b16_e64 v4, 15, s2
; GFX8-NEXT:    s_bfe_u32 s25, s2, 0x10011
; GFX8-NEXT:    s_bfe_u32 s26, s2, 0x10010
; GFX8-NEXT:    s_bfe_u32 s27, s2, 0x10012
; GFX8-NEXT:    s_bfe_u32 s28, s2, 0x10013
; GFX8-NEXT:    s_bfe_u32 s29, s2, 0x10014
; GFX8-NEXT:    s_bfe_u32 s30, s2, 0x10015
; GFX8-NEXT:    s_bfe_u32 s31, s2, 0x10016
; GFX8-NEXT:    s_bfe_u32 s2, s2, 0x10017
; GFX8-NEXT:    s_bfe_u32 s34, s3, 0x10011
; GFX8-NEXT:    s_bfe_u32 s35, s3, 0x10010
; GFX8-NEXT:    s_bfe_u32 s36, s3, 0x10012
; GFX8-NEXT:    s_bfe_u32 s37, s3, 0x10013
; GFX8-NEXT:    s_bfe_u32 s38, s3, 0x10016
; GFX8-NEXT:    s_bfe_u32 s39, s3, 0x10017
; GFX8-NEXT:    s_bfe_u32 s40, s3, 0x10015
; GFX8-NEXT:    s_bfe_u32 s41, s3, 0x10014
; GFX8-NEXT:    s_add_u32 s4, s0, 0x1a0
; GFX8-NEXT:    s_addc_u32 s5, s1, 0
; GFX8-NEXT:    s_add_u32 s6, s0, 0x1b0
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    s_add_u32 s8, s0, 0x190
; GFX8-NEXT:    s_addc_u32 s9, s1, 0
; GFX8-NEXT:    s_add_u32 s10, s0, 0x180
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    s_add_u32 s12, s0, 0xb0
; GFX8-NEXT:    s_addc_u32 s13, s1, 0
; GFX8-NEXT:    s_add_u32 s14, s0, 0xa0
; GFX8-NEXT:    s_addc_u32 s15, s1, 0
; GFX8-NEXT:    s_add_u32 s16, s0, 0x90
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    s_add_u32 s18, s0, 0x80
; GFX8-NEXT:    s_addc_u32 s19, s1, 0
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 13, s3
; GFX8-NEXT:    s_add_u32 s42, s0, 0x70
; GFX8-NEXT:    v_and_b32_e32 v7, 1, v1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v23, s42
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v5, v1
; GFX8-NEXT:    v_mov_b32_e32 v24, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 0x170
; GFX8-NEXT:    v_lshrrev_b16_e64 v22, 14, s3
; GFX8-NEXT:    flat_store_dwordx4 v[23:24], v[2:5]
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s42
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v22
; GFX8-NEXT:    v_lshrrev_b16_e64 v24, 15, s3
; GFX8-NEXT:    v_mov_b32_e32 v23, v1
; GFX8-NEXT:    v_mov_b32_e32 v25, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, s43
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[22:25]
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 11, s3
; GFX8-NEXT:    s_add_u32 s42, s0, 0x1f0
; GFX8-NEXT:    v_lshrrev_b16_e64 v21, 6, s33
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v2
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s42
; GFX8-NEXT:    v_and_b32_e32 v21, 1, v21
; GFX8-NEXT:    v_lshrrev_b16_e64 v23, 7, s33
; GFX8-NEXT:    v_mov_b32_e32 v22, v1
; GFX8-NEXT:    v_mov_b32_e32 v24, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 0xf0
; GFX8-NEXT:    v_lshrrev_b16_e64 v20, 6, s24
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[21:24]
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s42
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v20
; GFX8-NEXT:    v_lshrrev_b16_e64 v24, 7, s24
; GFX8-NEXT:    v_mov_b32_e32 v23, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 0x60
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[22:25]
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v19
; GFX8-NEXT:    v_and_b32_e32 v24, 0xffff, v18
; GFX8-NEXT:    v_mov_b32_e32 v18, s42
; GFX8-NEXT:    v_mov_b32_e32 v19, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 0x50
; GFX8-NEXT:    flat_store_dwordx4 v[18:19], v[22:25]
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v17
; GFX8-NEXT:    v_and_b32_e32 v24, 0xffff, v16
; GFX8-NEXT:    v_mov_b32_e32 v16, s42
; GFX8-NEXT:    v_mov_b32_e32 v17, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 64
; GFX8-NEXT:    flat_store_dwordx4 v[16:17], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v17, 1
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v26, s42
; GFX8-NEXT:    v_and_b32_sdwa v22, v12, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_e32 v24, 0xffff, v15
; GFX8-NEXT:    v_mov_b32_e32 v27, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 48
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v14
; GFX8-NEXT:    v_and_b32_e32 v24, 0xffff, v13
; GFX8-NEXT:    v_mov_b32_e32 v13, s42
; GFX8-NEXT:    v_mov_b32_e32 v14, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 32
; GFX8-NEXT:    flat_store_dwordx4 v[13:14], v[22:25]
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v11
; GFX8-NEXT:    v_and_b32_e32 v24, 0xffff, v10
; GFX8-NEXT:    v_mov_b32_e32 v10, s42
; GFX8-NEXT:    v_mov_b32_e32 v11, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 16
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[22:25]
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v9
; GFX8-NEXT:    v_and_b32_e32 v24, 0xffff, v8
; GFX8-NEXT:    v_mov_b32_e32 v8, s42
; GFX8-NEXT:    v_mov_b32_e32 v9, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 0x160
; GFX8-NEXT:    v_lshrrev_b16_e64 v5, 12, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v10, 3, s33
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[22:25]
; GFX8-NEXT:    v_lshrrev_b16_e64 v8, 1, s33
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v22, s42
; GFX8-NEXT:    v_and_b32_e32 v28, 1, v10
; GFX8-NEXT:    v_and_b32_e32 v19, 1, v8
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v5
; GFX8-NEXT:    v_and_b32_e32 v10, 0xffff, v7
; GFX8-NEXT:    v_mov_b32_e32 v9, v1
; GFX8-NEXT:    v_mov_b32_e32 v11, v1
; GFX8-NEXT:    v_mov_b32_e32 v23, s43
; GFX8-NEXT:    v_lshrrev_b16_e64 v5, 5, s24
; GFX8-NEXT:    s_add_u32 s42, s0, 0x150
; GFX8-NEXT:    v_lshrrev_b16_e64 v21, 10, s3
; GFX8-NEXT:    flat_store_dwordx4 v[22:23], v[8:11]
; GFX8-NEXT:    v_and_b32_e32 v22, 1, v5
; GFX8-NEXT:    v_and_b32_e32 v9, 0xffff, v4
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v4, s42
; GFX8-NEXT:    v_and_b32_e32 v7, 1, v21
; GFX8-NEXT:    v_mov_b32_e32 v8, v1
; GFX8-NEXT:    v_mov_b32_e32 v10, v1
; GFX8-NEXT:    v_mov_b32_e32 v5, s43
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[7:10]
; GFX8-NEXT:    v_lshrrev_b16_e64 v4, 3, s24
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 9, s3
; GFX8-NEXT:    v_and_b32_e32 v10, 1, v4
; GFX8-NEXT:    v_lshrrev_b16_e64 v4, 1, s24
; GFX8-NEXT:    s_add_u32 s42, s0, 0x140
; GFX8-NEXT:    v_mov_b32_e32 v6, s3
; GFX8-NEXT:    v_and_b32_e32 v20, 1, v2
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v8, s42
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 7, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v18, 6, s3
; GFX8-NEXT:    v_and_b32_e32 v11, 0xffff, v4
; GFX8-NEXT:    v_and_b32_sdwa v4, v6, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff, v20
; GFX8-NEXT:    v_mov_b32_e32 v5, v1
; GFX8-NEXT:    v_mov_b32_e32 v7, v1
; GFX8-NEXT:    v_mov_b32_e32 v9, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 0x130
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX8-NEXT:    v_lshrrev_b16_e64 v3, 5, s3
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v7, 1, v18
; GFX8-NEXT:    v_mov_b32_e32 v17, s42
; GFX8-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff, v10
; GFX8-NEXT:    v_and_b32_e32 v9, 0xffff, v2
; GFX8-NEXT:    v_mov_b32_e32 v8, v1
; GFX8-NEXT:    v_mov_b32_e32 v10, v1
; GFX8-NEXT:    v_mov_b32_e32 v18, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 0x120
; GFX8-NEXT:    v_lshrrev_b16_e64 v16, 4, s3
; GFX8-NEXT:    flat_store_dwordx4 v[17:18], v[7:10]
; GFX8-NEXT:    v_and_b32_e32 v18, 0xffff, v3
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s42
; GFX8-NEXT:    v_lshrrev_b16_e64 v12, 3, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v13, 1, s3
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff, v19
; GFX8-NEXT:    v_and_b32_e32 v16, 1, v16
; GFX8-NEXT:    v_mov_b32_e32 v17, v1
; GFX8-NEXT:    v_mov_b32_e32 v19, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, s43
; GFX8-NEXT:    s_add_u32 s42, s0, 0x110
; GFX8-NEXT:    v_and_b32_e32 v12, 1, v12
; GFX8-NEXT:    v_lshrrev_b16_e64 v15, 2, s3
; GFX8-NEXT:    v_and_b32_e32 v13, 1, v13
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[16:19]
; GFX8-NEXT:    s_addc_u32 s43, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s42
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v17, 1, v15
; GFX8-NEXT:    v_and_b32_e32 v19, 0xffff, v12
; GFX8-NEXT:    v_mov_b32_e32 v18, v1
; GFX8-NEXT:    v_mov_b32_e32 v20, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, s43
; GFX8-NEXT:    v_and_b32_e32 v8, 0xffff, v13
; GFX8-NEXT:    v_mov_b32_e32 v13, s5
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[17:20]
; GFX8-NEXT:    v_and_b32_e32 v10, 0xffff, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s41
; GFX8-NEXT:    v_mov_b32_e32 v2, s40
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v12, s4
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v13, s7
; GFX8-NEXT:    v_mov_b32_e32 v0, s38
; GFX8-NEXT:    v_mov_b32_e32 v2, s39
; GFX8-NEXT:    v_mov_b32_e32 v12, s6
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v13, s9
; GFX8-NEXT:    v_mov_b32_e32 v0, s36
; GFX8-NEXT:    v_mov_b32_e32 v2, s37
; GFX8-NEXT:    v_mov_b32_e32 v12, s8
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v13, s11
; GFX8-NEXT:    v_mov_b32_e32 v0, s35
; GFX8-NEXT:    v_mov_b32_e32 v2, s34
; GFX8-NEXT:    v_mov_b32_e32 v12, s10
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v12, s12
; GFX8-NEXT:    v_mov_b32_e32 v0, s31
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v13, s13
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v12, s14
; GFX8-NEXT:    v_mov_b32_e32 v0, s29
; GFX8-NEXT:    v_mov_b32_e32 v2, s30
; GFX8-NEXT:    v_mov_b32_e32 v13, s15
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v12, s16
; GFX8-NEXT:    v_mov_b32_e32 v0, s27
; GFX8-NEXT:    v_mov_b32_e32 v2, s28
; GFX8-NEXT:    v_mov_b32_e32 v13, s17
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v12, s18
; GFX8-NEXT:    v_mov_b32_e32 v0, s26
; GFX8-NEXT:    v_mov_b32_e32 v2, s25
; GFX8-NEXT:    v_mov_b32_e32 v13, s19
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v13, s1
; GFX8-NEXT:    s_add_u32 s2, s0, 0x100
; GFX8-NEXT:    v_mov_b32_e32 v0, s23
; GFX8-NEXT:    v_mov_b32_e32 v2, v10
; GFX8-NEXT:    v_mov_b32_e32 v12, s0
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GFX8-NEXT:    v_mov_b32_e32 v13, s3
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 5, s33
; GFX8-NEXT:    v_mov_b32_e32 v0, s22
; GFX8-NEXT:    v_mov_b32_e32 v2, v8
; GFX8-NEXT:    v_mov_b32_e32 v12, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 0x1e0
; GFX8-NEXT:    v_and_b32_e32 v26, 1, v14
; GFX8-NEXT:    v_lshrrev_b16_e64 v27, 4, s33
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_and_b32_e32 v17, 1, v27
; GFX8-NEXT:    v_and_b32_e32 v19, 0xffff, v26
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0x1d0
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[17:20]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0x1c0
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 2, s33
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_and_b32_e32 v14, 1, v14
; GFX8-NEXT:    v_and_b32_e32 v16, 0xffff, v28
; GFX8-NEXT:    v_mov_b32_e32 v15, v1
; GFX8-NEXT:    v_mov_b32_e32 v17, v1
; GFX8-NEXT:    v_mov_b32_e32 v13, s3
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[14:17]
; GFX8-NEXT:    v_mov_b32_e32 v0, s21
; GFX8-NEXT:    v_mov_b32_e32 v2, v5
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v12, s2
; GFX8-NEXT:    s_add_u32 s2, s0, 0xe0
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_lshrrev_b16_e64 v23, 4, s24
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 0xd0
; GFX8-NEXT:    v_and_b32_e32 v7, 1, v23
; GFX8-NEXT:    v_and_b32_e32 v9, 0xffff, v22
; GFX8-NEXT:    v_mov_b32_e32 v8, v1
; GFX8-NEXT:    v_mov_b32_e32 v10, v1
; GFX8-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NEXT:    v_lshrrev_b16_e64 v21, 2, s24
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[7:10]
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    s_add_u32 s0, s0, 0xc0
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v21
; GFX8-NEXT:    v_mov_b32_e32 v5, v1
; GFX8-NEXT:    v_mov_b32_e32 v7, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[2:3], v[4:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, s20
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, v11
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v64i1_to_v64i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @40, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @38
; EG-NEXT:    ALU 95, @41, KC0[], KC1[]
; EG-NEXT:    ALU 99, @137, KC0[CB0:0-32], KC1[]
; EG-NEXT:    ALU 60, @237, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T19.XYZW, T82.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T20.XYZW, T81.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T21.XYZW, T80.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T22.XYZW, T79.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T23.XYZW, T78.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T24.XYZW, T77.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T26.XYZW, T76.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T27.XYZW, T75.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T28.XYZW, T74.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T29.XYZW, T73.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T30.XYZW, T72.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T31.XYZW, T71.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T32.XYZW, T70.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T33.XYZW, T69.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T34.XYZW, T68.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T35.XYZW, T67.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T36.XYZW, T66.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T37.XYZW, T65.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T38.XYZW, T64.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T39.XYZW, T63.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T40.XYZW, T62.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T41.XYZW, T61.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T42.XYZW, T60.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T43.XYZW, T59.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T44.XYZW, T58.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T45.XYZW, T57.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T46.XYZW, T56.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T47.XYZW, T55.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T48.XYZW, T54.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T49.XYZW, T53.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T50.XYZW, T52.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T25.XYZW, T51.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 38:
; EG-NEXT:     VTX_READ_64 T25.XY, T19.X, 0, #1
; EG-NEXT:    ALU clause starting at 40:
; EG-NEXT:     MOV * T19.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 41:
; EG-NEXT:     LSHR * T19.Z, T25.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T19.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T19.Y, 0.0,
; EG-NEXT:     BFE_UINT * T20.Z, T25.Y, literal.y, 1,
; EG-NEXT:    30(4.203895e-44), 29(4.063766e-44)
; EG-NEXT:     BFE_UINT T20.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T20.Y, 0.0,
; EG-NEXT:     BFE_UINT * T21.Z, T25.Y, literal.y, 1,
; EG-NEXT:    28(3.923636e-44), 27(3.783506e-44)
; EG-NEXT:     BFE_UINT T21.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T21.Y, 0.0,
; EG-NEXT:     BFE_UINT * T22.Z, T25.Y, literal.y, 1,
; EG-NEXT:    26(3.643376e-44), 25(3.503246e-44)
; EG-NEXT:     BFE_UINT T22.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T22.Y, 0.0,
; EG-NEXT:     BFE_UINT * T23.Z, T25.Y, literal.y, 1,
; EG-NEXT:    24(3.363116e-44), 23(3.222986e-44)
; EG-NEXT:     BFE_UINT T23.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T23.Y, 0.0,
; EG-NEXT:     BFE_UINT * T24.Z, T25.Y, literal.y, 1,
; EG-NEXT:    22(3.082857e-44), 21(2.942727e-44)
; EG-NEXT:     BFE_UINT T24.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T24.Y, 0.0,
; EG-NEXT:     BFE_UINT * T26.Z, T25.Y, literal.y, 1,
; EG-NEXT:    20(2.802597e-44), 19(2.662467e-44)
; EG-NEXT:     BFE_UINT T26.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T26.Y, 0.0,
; EG-NEXT:     BFE_UINT * T27.Z, T25.Y, literal.y, 1,
; EG-NEXT:    18(2.522337e-44), 17(2.382207e-44)
; EG-NEXT:     BFE_UINT T27.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T27.Y, 0.0,
; EG-NEXT:     BFE_UINT * T28.Z, T25.Y, literal.y, 1,
; EG-NEXT:    16(2.242078e-44), 15(2.101948e-44)
; EG-NEXT:     BFE_UINT T28.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T28.Y, 0.0,
; EG-NEXT:     BFE_UINT * T29.Z, T25.Y, literal.y, 1,
; EG-NEXT:    14(1.961818e-44), 13(1.821688e-44)
; EG-NEXT:     BFE_UINT T29.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T29.Y, 0.0,
; EG-NEXT:     BFE_UINT * T30.Z, T25.Y, literal.y, 1,
; EG-NEXT:    12(1.681558e-44), 11(1.541428e-44)
; EG-NEXT:     BFE_UINT T30.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T30.Y, 0.0,
; EG-NEXT:     BFE_UINT * T31.Z, T25.Y, literal.y, 1,
; EG-NEXT:    10(1.401298e-44), 9(1.261169e-44)
; EG-NEXT:     BFE_UINT T31.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T31.Y, 0.0,
; EG-NEXT:     BFE_UINT * T32.Z, T25.Y, literal.y, 1,
; EG-NEXT:    8(1.121039e-44), 7(9.809089e-45)
; EG-NEXT:     BFE_UINT T32.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T32.Y, 0.0,
; EG-NEXT:     BFE_UINT * T33.Z, T25.Y, literal.y, 1,
; EG-NEXT:    6(8.407791e-45), 5(7.006492e-45)
; EG-NEXT:     BFE_UINT T33.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T33.Y, 0.0,
; EG-NEXT:     BFE_UINT * T34.Z, T25.Y, literal.y, 1,
; EG-NEXT:    4(5.605194e-45), 3(4.203895e-45)
; EG-NEXT:     BFE_UINT T34.X, T25.Y, literal.x, 1,
; EG-NEXT:     MOV T34.Y, 0.0,
; EG-NEXT:     BFE_UINT T35.Z, T25.Y, 1, 1,
; EG-NEXT:     AND_INT * T35.X, T25.Y, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV T35.Y, 0.0,
; EG-NEXT:     LSHR * T36.Z, T25.X, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T36.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T36.Y, 0.0,
; EG-NEXT:     BFE_UINT * T37.Z, T25.X, literal.y, 1,
; EG-NEXT:    30(4.203895e-44), 29(4.063766e-44)
; EG-NEXT:     BFE_UINT T37.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T37.Y, 0.0,
; EG-NEXT:     BFE_UINT * T38.Z, T25.X, literal.y, 1,
; EG-NEXT:    28(3.923636e-44), 27(3.783506e-44)
; EG-NEXT:     BFE_UINT T38.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T38.Y, 0.0,
; EG-NEXT:     BFE_UINT * T39.Z, T25.X, literal.y, 1,
; EG-NEXT:    26(3.643376e-44), 25(3.503246e-44)
; EG-NEXT:     BFE_UINT T39.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T39.Y, 0.0,
; EG-NEXT:     BFE_UINT * T40.Z, T25.X, literal.y, 1,
; EG-NEXT:    24(3.363116e-44), 23(3.222986e-44)
; EG-NEXT:     BFE_UINT T40.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T40.Y, 0.0,
; EG-NEXT:     BFE_UINT * T41.Z, T25.X, literal.y, 1,
; EG-NEXT:    22(3.082857e-44), 21(2.942727e-44)
; EG-NEXT:     BFE_UINT T41.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T41.Y, 0.0,
; EG-NEXT:     BFE_UINT * T42.Z, T25.X, literal.y, 1,
; EG-NEXT:    20(2.802597e-44), 19(2.662467e-44)
; EG-NEXT:     BFE_UINT T42.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T42.Y, 0.0,
; EG-NEXT:     BFE_UINT * T43.Z, T25.X, literal.y, 1,
; EG-NEXT:    18(2.522337e-44), 17(2.382207e-44)
; EG-NEXT:     BFE_UINT * T43.X, T25.X, literal.x, 1,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 137:
; EG-NEXT:     MOV T43.Y, 0.0,
; EG-NEXT:     BFE_UINT * T44.Z, T25.X, literal.x, 1,
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T44.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T44.Y, 0.0,
; EG-NEXT:     BFE_UINT * T45.Z, T25.X, literal.y, 1,
; EG-NEXT:    14(1.961818e-44), 13(1.821688e-44)
; EG-NEXT:     BFE_UINT T45.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T45.Y, 0.0,
; EG-NEXT:     BFE_UINT * T46.Z, T25.X, literal.y, 1,
; EG-NEXT:    12(1.681558e-44), 11(1.541428e-44)
; EG-NEXT:     BFE_UINT T46.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T46.Y, 0.0,
; EG-NEXT:     BFE_UINT * T47.Z, T25.X, literal.y, 1,
; EG-NEXT:    10(1.401298e-44), 9(1.261169e-44)
; EG-NEXT:     BFE_UINT T47.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T47.Y, 0.0,
; EG-NEXT:     BFE_UINT * T48.Z, T25.X, literal.y, 1,
; EG-NEXT:    8(1.121039e-44), 7(9.809089e-45)
; EG-NEXT:     BFE_UINT T48.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T48.Y, 0.0,
; EG-NEXT:     BFE_UINT * T49.Z, T25.X, literal.y, 1,
; EG-NEXT:    6(8.407791e-45), 5(7.006492e-45)
; EG-NEXT:     BFE_UINT T49.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T49.Y, 0.0,
; EG-NEXT:     BFE_UINT * T50.Z, T25.X, literal.y, 1,
; EG-NEXT:    4(5.605194e-45), 3(4.203895e-45)
; EG-NEXT:     BFE_UINT T50.X, T25.X, literal.x, 1,
; EG-NEXT:     MOV T50.Y, 0.0,
; EG-NEXT:     BFE_UINT T25.Z, T25.X, 1, 1,
; EG-NEXT:     AND_INT * T25.X, T25.X, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV T25.Y, 0.0,
; EG-NEXT:     MOV T19.W, 0.0,
; EG-NEXT:     MOV * T20.W, 0.0,
; EG-NEXT:     MOV T21.W, 0.0,
; EG-NEXT:     MOV * T22.W, 0.0,
; EG-NEXT:     MOV T23.W, 0.0,
; EG-NEXT:     MOV * T24.W, 0.0,
; EG-NEXT:     MOV T26.W, 0.0,
; EG-NEXT:     MOV * T27.W, 0.0,
; EG-NEXT:     MOV T28.W, 0.0,
; EG-NEXT:     MOV * T29.W, 0.0,
; EG-NEXT:     MOV T30.W, 0.0,
; EG-NEXT:     MOV * T31.W, 0.0,
; EG-NEXT:     MOV T32.W, 0.0,
; EG-NEXT:     MOV * T33.W, 0.0,
; EG-NEXT:     MOV T34.W, 0.0,
; EG-NEXT:     MOV * T35.W, 0.0,
; EG-NEXT:     MOV T36.W, 0.0,
; EG-NEXT:     MOV * T37.W, 0.0,
; EG-NEXT:     MOV T38.W, 0.0,
; EG-NEXT:     MOV * T39.W, 0.0,
; EG-NEXT:     MOV T40.W, 0.0,
; EG-NEXT:     MOV * T41.W, 0.0,
; EG-NEXT:     MOV T42.W, 0.0,
; EG-NEXT:     MOV * T43.W, 0.0,
; EG-NEXT:     MOV T44.W, 0.0,
; EG-NEXT:     MOV * T45.W, 0.0,
; EG-NEXT:     MOV T46.W, 0.0,
; EG-NEXT:     MOV * T47.W, 0.0,
; EG-NEXT:     MOV T48.W, 0.0,
; EG-NEXT:     MOV * T49.W, 0.0,
; EG-NEXT:     MOV T50.W, 0.0,
; EG-NEXT:     MOV * T25.W, 0.0,
; EG-NEXT:     LSHR T51.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T52.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T53.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T54.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T55.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T56.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:     LSHR T57.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR T58.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 128(1.793662e-43)
; EG-NEXT:     LSHR T59.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 144(2.017870e-43)
; EG-NEXT:     LSHR T60.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 160(2.242078e-43)
; EG-NEXT:     LSHR T61.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 176(2.466285e-43)
; EG-NEXT:     LSHR * T62.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 237:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    192(2.690493e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T63.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 208(2.914701e-43)
; EG-NEXT:     LSHR T64.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 224(3.138909e-43)
; EG-NEXT:     LSHR T65.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 240(3.363116e-43)
; EG-NEXT:     LSHR T66.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 256(3.587324e-43)
; EG-NEXT:     LSHR T67.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 272(3.811532e-43)
; EG-NEXT:     LSHR T68.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 288(4.035740e-43)
; EG-NEXT:     LSHR T69.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 304(4.259947e-43)
; EG-NEXT:     LSHR T70.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 320(4.484155e-43)
; EG-NEXT:     LSHR T71.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 336(4.708363e-43)
; EG-NEXT:     LSHR T72.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 352(4.932571e-43)
; EG-NEXT:     LSHR T73.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 368(5.156778e-43)
; EG-NEXT:     LSHR T74.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 384(5.380986e-43)
; EG-NEXT:     LSHR T75.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 400(5.605194e-43)
; EG-NEXT:     LSHR T76.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 416(5.829402e-43)
; EG-NEXT:     LSHR T77.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 432(6.053609e-43)
; EG-NEXT:     LSHR T78.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 448(6.277817e-43)
; EG-NEXT:     LSHR T79.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 464(6.502025e-43)
; EG-NEXT:     LSHR T80.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 480(6.726233e-43)
; EG-NEXT:     LSHR T81.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 496(6.950440e-43)
; EG-NEXT:     LSHR * T82.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_zextload_v64i1_to_v64i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_lshrrev_b16 v4, 11, s2
; GFX12-NEXT:    v_lshrrev_b16 v6, 7, s2
; GFX12-NEXT:    s_lshr_b32 s4, s3, 24
; GFX12-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-NEXT:    v_lshrrev_b16 v14, 13, s3
; GFX12-NEXT:    v_and_b32_e32 v34, 1, v4
; GFX12-NEXT:    v_lshrrev_b16 v18, 9, s3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX12-NEXT:    v_dual_mov_b32 v28, v1 :: v_dual_and_b32 v41, 1, v6
; GFX12-NEXT:    v_lshrrev_b16 v4, 5, s4
; GFX12-NEXT:    v_lshrrev_b16 v6, 3, s4
; GFX12-NEXT:    s_lshr_b32 s5, s2, 24
; GFX12-NEXT:    v_lshrrev_b16 v3, 13, s2
; GFX12-NEXT:    v_lshrrev_b16 v8, 5, s2
; GFX12-NEXT:    v_lshrrev_b16 v10, 3, s2
; GFX12-NEXT:    v_lshrrev_b16 v23, 7, s3
; GFX12-NEXT:    v_lshrrev_b16 v24, 5, s3
; GFX12-NEXT:    v_lshrrev_b16 v25, 3, s3
; GFX12-NEXT:    v_and_b32_e32 v50, 1, v14
; GFX12-NEXT:    v_and_b32_e32 v47, 1, v18
; GFX12-NEXT:    v_and_b32_e32 v18, 1, v4
; GFX12-NEXT:    v_and_b32_e32 v14, 1, v6
; GFX12-NEXT:    v_lshrrev_b16 v4, 3, s5
; GFX12-NEXT:    v_lshrrev_b16 v6, 5, s5
; GFX12-NEXT:    v_lshrrev_b16 v0, 15, s2
; GFX12-NEXT:    v_lshrrev_b16 v2, 14, s2
; GFX12-NEXT:    v_lshrrev_b16 v7, 12, s2
; GFX12-NEXT:    v_lshrrev_b16 v5, 9, s2
; GFX12-NEXT:    v_lshrrev_b16 v12, 1, s2
; GFX12-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX12-NEXT:    v_and_b32_e32 v42, 1, v8
; GFX12-NEXT:    v_and_b32_e32 v52, 1, v10
; GFX12-NEXT:    v_and_b32_e32 v40, 1, v23
; GFX12-NEXT:    v_dual_mov_b32 v44, v1 :: v_dual_and_b32 v43, 1, v24
; GFX12-NEXT:    v_lshrrev_b16 v8, 1, s5
; GFX12-NEXT:    v_lshrrev_b16 v10, 2, s5
; GFX12-NEXT:    v_lshrrev_b16 v24, 4, s5
; GFX12-NEXT:    s_bfe_u32 s7, s3, 0x10014
; GFX12-NEXT:    v_and_b32_e32 v33, 1, v25
; GFX12-NEXT:    v_and_b32_e32 v25, 1, v6
; GFX12-NEXT:    s_bfe_u32 s8, s3, 0x10015
; GFX12-NEXT:    v_and_b32_e32 v23, 1, v4
; GFX12-NEXT:    v_lshrrev_b16 v11, 8, s2
; GFX12-NEXT:    v_lshrrev_b16 v16, 11, s3
; GFX12-NEXT:    v_dual_mov_b32 v26, v1 :: v_dual_and_b32 v35, 1, v5
; GFX12-NEXT:    v_dual_mov_b32 v30, v1 :: v_dual_and_b32 v5, 1, v12
; GFX12-NEXT:    v_lshrrev_b16 v36, 7, s5
; GFX12-NEXT:    v_lshrrev_b16 v37, 6, s5
; GFX12-NEXT:    v_and_b32_e32 v56, 1, v8
; GFX12-NEXT:    v_and_b32_e32 v4, 1, v10
; GFX12-NEXT:    v_and_b32_e32 v6, 0xffff, v23
; GFX12-NEXT:    v_and_b32_e32 v8, 1, v24
; GFX12-NEXT:    v_and_b32_e32 v10, 0xffff, v25
; GFX12-NEXT:    v_and_b32_e32 v23, 1, v2
; GFX12-NEXT:    v_dual_mov_b32 v24, v1 :: v_dual_and_b32 v25, 0xffff, v0
; GFX12-NEXT:    v_and_b32_e32 v29, 0xffff, v3
; GFX12-NEXT:    s_bfe_u32 s9, s3, 0x10013
; GFX12-NEXT:    v_and_b32_e32 v27, 1, v7
; GFX12-NEXT:    v_lshrrev_b16 v9, 10, s2
; GFX12-NEXT:    v_lshrrev_b16 v13, 6, s2
; GFX12-NEXT:    v_and_b32_e32 v22, 1, v16
; GFX12-NEXT:    v_lshrrev_b16 v54, 1, s3
; GFX12-NEXT:    v_lshrrev_b16 v55, 1, s4
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v1, v[23:26], s[0:1] offset:112
; GFX12-NEXT:    global_store_b128 v1, v[27:30], s[0:1] offset:96
; GFX12-NEXT:    v_and_b32_e32 v23, 1, v37
; GFX12-NEXT:    v_and_b32_e32 v25, 0xffff, v36
; GFX12-NEXT:    v_dual_mov_b32 v57, v1 :: v_dual_and_b32 v28, 0xffff, v34
; GFX12-NEXT:    v_dual_mov_b32 v59, v1 :: v_dual_and_b32 v34, 1, v11
; GFX12-NEXT:    v_dual_mov_b32 v35, v1 :: v_dual_and_b32 v36, 0xffff, v35
; GFX12-NEXT:    v_dual_mov_b32 v37, v1 :: v_dual_and_b32 v26, 1, v9
; GFX12-NEXT:    v_mov_b32_e32 v27, v1
; GFX12-NEXT:    v_dual_mov_b32 v29, v1 :: v_dual_and_b32 v0, 1, v55
; GFX12-NEXT:    global_store_b128 v1, v[34:37], s[0:1] offset:64
; GFX12-NEXT:    v_and_b32_e32 v34, 1, v13
; GFX12-NEXT:    v_and_b32_e32 v36, 0xffff, v41
; GFX12-NEXT:    v_and_b32_e32 v2, 1, v54
; GFX12-NEXT:    global_store_b128 v1, v[26:29], s[0:1] offset:80
; GFX12-NEXT:    v_and_b32_e32 v30, 0xffff, v0
; GFX12-NEXT:    v_mov_b32_e32 v0, s7
; GFX12-NEXT:    global_store_b128 v1, v[34:37], s[0:1] offset:48
; GFX12-NEXT:    v_and_b32_e32 v36, 0xffff, v2
; GFX12-NEXT:    v_dual_mov_b32 v2, s8 :: v_dual_mov_b32 v3, v1
; GFX12-NEXT:    s_bfe_u32 s7, s3, 0x10016
; GFX12-NEXT:    s_bfe_u32 s8, s3, 0x10017
; GFX12-NEXT:    v_lshrrev_b16 v20, 15, s3
; GFX12-NEXT:    v_lshrrev_b16 v21, 14, s3
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:416
; GFX12-NEXT:    v_mov_b32_e32 v0, s7
; GFX12-NEXT:    v_mov_b32_e32 v2, s8
; GFX12-NEXT:    s_bfe_u32 s8, s3, 0x10012
; GFX12-NEXT:    v_lshrrev_b16 v19, 12, s3
; GFX12-NEXT:    v_lshrrev_b16 v32, 8, s3
; GFX12-NEXT:    v_lshrrev_b16 v38, 6, s3
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:432
; GFX12-NEXT:    v_mov_b32_e32 v0, s8
; GFX12-NEXT:    v_mov_b32_e32 v2, s9
; GFX12-NEXT:    v_lshrrev_b16 v39, 4, s3
; GFX12-NEXT:    v_lshrrev_b16 v31, 2, s3
; GFX12-NEXT:    v_lshrrev_b16 v28, 10, s3
; GFX12-NEXT:    s_bfe_u32 s5, s3, 0x10018
; GFX12-NEXT:    s_and_b32 s6, s3, 1
; GFX12-NEXT:    s_bfe_u32 s8, s3, 0x10011
; GFX12-NEXT:    s_bfe_u32 s3, s3, 0x10010
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:400
; GFX12-NEXT:    v_mov_b32_e32 v0, s3
; GFX12-NEXT:    v_mov_b32_e32 v2, s8
; GFX12-NEXT:    s_bfe_u32 s3, s2, 0x10016
; GFX12-NEXT:    s_bfe_u32 s8, s2, 0x10017
; GFX12-NEXT:    v_lshrrev_b16 v15, 4, s2
; GFX12-NEXT:    v_and_b32_e32 v31, 1, v31
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:384
; GFX12-NEXT:    v_mov_b32_e32 v2, s8
; GFX12-NEXT:    v_mov_b32_e32 v0, s3
; GFX12-NEXT:    s_bfe_u32 s3, s2, 0x10014
; GFX12-NEXT:    s_bfe_u32 s8, s2, 0x10015
; GFX12-NEXT:    v_and_b32_e32 v29, 0xffff, v43
; GFX12-NEXT:    v_and_b32_e32 v41, 1, v15
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:176
; GFX12-NEXT:    v_mov_b32_e32 v2, s8
; GFX12-NEXT:    v_mov_b32_e32 v0, s3
; GFX12-NEXT:    s_bfe_u32 s3, s2, 0x10012
; GFX12-NEXT:    s_bfe_u32 s8, s2, 0x10013
; GFX12-NEXT:    v_lshrrev_b16 v17, 2, s2
; GFX12-NEXT:    v_lshrrev_b16 v46, 7, s4
; GFX12-NEXT:    v_lshrrev_b16 v49, 6, s4
; GFX12-NEXT:    v_dual_mov_b32 v26, v1 :: v_dual_and_b32 v43, 0xffff, v42
; GFX12-NEXT:    v_dual_mov_b32 v42, v1 :: v_dual_and_b32 v45, 1, v32
; GFX12-NEXT:    v_and_b32_e32 v47, 0xffff, v47
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:160
; GFX12-NEXT:    v_mov_b32_e32 v2, s8
; GFX12-NEXT:    v_mov_b32_e32 v0, s3
; GFX12-NEXT:    v_lshrrev_b16 v16, 4, s4
; GFX12-NEXT:    v_lshrrev_b16 v12, 2, s4
; GFX12-NEXT:    s_bfe_u32 s4, s2, 0x10018
; GFX12-NEXT:    s_and_b32 s7, s2, 1
; GFX12-NEXT:    s_bfe_u32 s3, s2, 0x10011
; GFX12-NEXT:    s_bfe_u32 s2, s2, 0x10010
; GFX12-NEXT:    v_and_b32_e32 v51, 1, v17
; GFX12-NEXT:    v_dual_mov_b32 v54, v1 :: v_dual_and_b32 v53, 0xffff, v52
; GFX12-NEXT:    v_and_b32_e32 v37, 0xffff, v5
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:144
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    v_mov_b32_e32 v2, s3
; GFX12-NEXT:    v_mov_b32_e32 v52, v1
; GFX12-NEXT:    global_store_b128 v1, v[41:44], s[0:1] offset:32
; GFX12-NEXT:    v_and_b32_e32 v41, 1, v49
; GFX12-NEXT:    v_and_b32_e32 v43, 0xffff, v46
; GFX12-NEXT:    v_mov_b32_e32 v13, v1
; GFX12-NEXT:    v_and_b32_e32 v35, 0xffff, v56
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:128
; GFX12-NEXT:    v_mov_b32_e32 v0, s7
; GFX12-NEXT:    v_mov_b32_e32 v46, v1
; GFX12-NEXT:    v_mov_b32_e32 v2, v37
; GFX12-NEXT:    v_dual_mov_b32 v55, v1 :: v_dual_and_b32 v16, 1, v16
; GFX12-NEXT:    v_dual_mov_b32 v19, v1 :: v_dual_and_b32 v48, 1, v19
; GFX12-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX12-NEXT:    global_store_b128 v1, v[51:54], s[0:1] offset:16
; GFX12-NEXT:    v_dual_mov_b32 v53, v1 :: v_dual_and_b32 v52, 1, v21
; GFX12-NEXT:    v_and_b32_e32 v54, 0xffff, v20
; GFX12-NEXT:    v_dual_mov_b32 v17, v1 :: v_dual_and_b32 v50, 0xffff, v50
; GFX12-NEXT:    v_dual_mov_b32 v49, v1 :: v_dual_and_b32 v18, 0xffff, v18
; GFX12-NEXT:    v_mov_b32_e32 v51, v1
; GFX12-NEXT:    v_dual_mov_b32 v34, v1 :: v_dual_and_b32 v27, 1, v39
; GFX12-NEXT:    v_and_b32_e32 v38, 1, v38
; GFX12-NEXT:    v_and_b32_e32 v40, 0xffff, v40
; GFX12-NEXT:    v_and_b32_e32 v56, 1, v28
; GFX12-NEXT:    v_and_b32_e32 v58, 0xffff, v22
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1]
; GFX12-NEXT:    global_store_b128 v1, v[41:44], s[0:1] offset:496
; GFX12-NEXT:    global_store_b128 v1, v[52:55], s[0:1] offset:368
; GFX12-NEXT:    global_store_b128 v1, v[48:51], s[0:1] offset:352
; GFX12-NEXT:    v_mov_b32_e32 v41, v1
; GFX12-NEXT:    v_dual_mov_b32 v39, v1 :: v_dual_mov_b32 v0, s6
; GFX12-NEXT:    v_mov_b32_e32 v2, v36
; GFX12-NEXT:    v_dual_mov_b32 v48, v1 :: v_dual_and_b32 v33, 0xffff, v33
; GFX12-NEXT:    v_mov_b32_e32 v32, v1
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    global_store_b128 v1, v[56:59], s[0:1] offset:336
; GFX12-NEXT:    global_store_b128 v1, v[45:48], s[0:1] offset:320
; GFX12-NEXT:    global_store_b128 v1, v[38:41], s[0:1] offset:304
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:256
; GFX12-NEXT:    v_mov_b32_e32 v0, s5
; GFX12-NEXT:    v_mov_b32_e32 v2, v30
; GFX12-NEXT:    v_dual_mov_b32 v7, v1 :: v_dual_and_b32 v12, 1, v12
; GFX12-NEXT:    v_mov_b32_e32 v15, v1
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    global_store_b128 v1, v[31:34], s[0:1] offset:272
; GFX12-NEXT:    global_store_b128 v1, v[23:26], s[0:1] offset:240
; GFX12-NEXT:    global_store_b128 v1, v[16:19], s[0:1] offset:480
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:448
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    v_dual_mov_b32 v2, v35 :: v_dual_mov_b32 v9, v1
; GFX12-NEXT:    v_mov_b32_e32 v11, v1
; GFX12-NEXT:    v_dual_mov_b32 v5, v1 :: v_dual_mov_b32 v28, v1
; GFX12-NEXT:    v_mov_b32_e32 v30, v1
; GFX12-NEXT:    s_clause 0x4
; GFX12-NEXT:    global_store_b128 v1, v[12:15], s[0:1] offset:464
; GFX12-NEXT:    global_store_b128 v1, v[8:11], s[0:1] offset:224
; GFX12-NEXT:    global_store_b128 v1, v[4:7], s[0:1] offset:208
; GFX12-NEXT:    global_store_b128 v1, v[27:30], s[0:1] offset:288
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:192
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <64 x i1>, ptr addrspace(4) %in
  %ext = zext <64 x i1> %load to <64 x i64>
  store <64 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v64i1_to_v64i64(ptr addrspace(1) %out, ptr addrspace(4) nocapture %in) #0 {
; GFX6-LABEL: constant_sextload_v64i1_to_v64i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_lshr_b32 s48, s5, 30
; GFX6-NEXT:    s_lshr_b32 s46, s5, 28
; GFX6-NEXT:    s_lshr_b32 s44, s5, 29
; GFX6-NEXT:    s_lshr_b32 s40, s5, 26
; GFX6-NEXT:    s_lshr_b32 s42, s5, 27
; GFX6-NEXT:    s_lshr_b32 s36, s5, 24
; GFX6-NEXT:    s_lshr_b32 s38, s5, 25
; GFX6-NEXT:    s_lshr_b32 s30, s5, 22
; GFX6-NEXT:    s_lshr_b32 s34, s5, 23
; GFX6-NEXT:    s_lshr_b32 s26, s5, 20
; GFX6-NEXT:    s_lshr_b32 s28, s5, 21
; GFX6-NEXT:    s_lshr_b32 s22, s5, 18
; GFX6-NEXT:    s_lshr_b32 s24, s5, 19
; GFX6-NEXT:    s_lshr_b32 s18, s5, 16
; GFX6-NEXT:    s_lshr_b32 s20, s5, 17
; GFX6-NEXT:    s_lshr_b32 s14, s5, 14
; GFX6-NEXT:    s_lshr_b32 s16, s5, 15
; GFX6-NEXT:    s_lshr_b32 s10, s5, 12
; GFX6-NEXT:    s_lshr_b32 s12, s5, 13
; GFX6-NEXT:    s_lshr_b32 s6, s5, 10
; GFX6-NEXT:    s_lshr_b32 s8, s5, 11
; GFX6-NEXT:    s_mov_b32 s50, s5
; GFX6-NEXT:    s_bfe_i64 s[50:51], s[50:51], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[52:53], s[4:5], 0x10000
; GFX6-NEXT:    v_mov_b32_e32 v0, s50
; GFX6-NEXT:    v_mov_b32_e32 v1, s51
; GFX6-NEXT:    s_lshr_b32 s50, s5, 8
; GFX6-NEXT:    v_mov_b32_e32 v4, s52
; GFX6-NEXT:    v_mov_b32_e32 v5, s53
; GFX6-NEXT:    s_lshr_b32 s52, s5, 9
; GFX6-NEXT:    s_bfe_i64 s[48:49], s[48:49], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[54:55], s[46:47], 0x10000
; GFX6-NEXT:    v_mov_b32_e32 v6, s48
; GFX6-NEXT:    v_mov_b32_e32 v7, s49
; GFX6-NEXT:    s_lshr_b32 s46, s5, 6
; GFX6-NEXT:    v_mov_b32_e32 v10, s54
; GFX6-NEXT:    v_mov_b32_e32 v11, s55
; GFX6-NEXT:    s_lshr_b32 s48, s5, 7
; GFX6-NEXT:    s_bfe_i64 s[44:45], s[44:45], 0x10000
; GFX6-NEXT:    s_ashr_i32 s7, s5, 31
; GFX6-NEXT:    v_mov_b32_e32 v12, s44
; GFX6-NEXT:    v_mov_b32_e32 v13, s45
; GFX6-NEXT:    s_lshr_b32 s44, s5, 4
; GFX6-NEXT:    s_bfe_i64 s[40:41], s[40:41], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[54:55], s[42:43], 0x10000
; GFX6-NEXT:    v_mov_b32_e32 v14, s40
; GFX6-NEXT:    v_mov_b32_e32 v15, s41
; GFX6-NEXT:    s_lshr_b32 s42, s5, 5
; GFX6-NEXT:    v_mov_b32_e32 v16, s54
; GFX6-NEXT:    v_mov_b32_e32 v17, s55
; GFX6-NEXT:    s_lshr_b32 s40, s5, 2
; GFX6-NEXT:    v_mov_b32_e32 v8, s7
; GFX6-NEXT:    s_bfe_i64 s[36:37], s[36:37], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[38:39], s[38:39], 0x10000
; GFX6-NEXT:    v_mov_b32_e32 v9, s7
; GFX6-NEXT:    buffer_store_dwordx4 v[6:9], off, s[0:3], 0 offset:496
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, s36
; GFX6-NEXT:    v_mov_b32_e32 v7, s37
; GFX6-NEXT:    s_lshr_b32 s36, s5, 3
; GFX6-NEXT:    v_mov_b32_e32 v8, s38
; GFX6-NEXT:    v_mov_b32_e32 v9, s39
; GFX6-NEXT:    s_lshr_b32 s38, s5, 1
; GFX6-NEXT:    s_bfe_i64 s[30:31], s[30:31], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[34:35], s[34:35], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[10:13], off, s[0:3], 0 offset:480
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v10, s30
; GFX6-NEXT:    v_mov_b32_e32 v11, s31
; GFX6-NEXT:    s_lshr_b32 s30, s4, 30
; GFX6-NEXT:    v_mov_b32_e32 v12, s34
; GFX6-NEXT:    v_mov_b32_e32 v13, s35
; GFX6-NEXT:    s_lshr_b32 s34, s4, 31
; GFX6-NEXT:    s_bfe_i64 s[28:29], s[28:29], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[26:27], s[26:27], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[14:17], off, s[0:3], 0 offset:464
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v14, s26
; GFX6-NEXT:    v_mov_b32_e32 v15, s27
; GFX6-NEXT:    s_lshr_b32 s26, s4, 28
; GFX6-NEXT:    v_mov_b32_e32 v16, s28
; GFX6-NEXT:    v_mov_b32_e32 v17, s29
; GFX6-NEXT:    s_lshr_b32 s28, s4, 29
; GFX6-NEXT:    s_bfe_i64 s[24:25], s[24:25], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[22:23], s[22:23], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[6:9], off, s[0:3], 0 offset:448
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, s22
; GFX6-NEXT:    v_mov_b32_e32 v7, s23
; GFX6-NEXT:    s_lshr_b32 s22, s4, 26
; GFX6-NEXT:    v_mov_b32_e32 v8, s24
; GFX6-NEXT:    v_mov_b32_e32 v9, s25
; GFX6-NEXT:    s_lshr_b32 s24, s4, 27
; GFX6-NEXT:    s_bfe_i64 s[54:55], s[20:21], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[18:19], s[18:19], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[10:13], off, s[0:3], 0 offset:432
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v10, s18
; GFX6-NEXT:    v_mov_b32_e32 v11, s19
; GFX6-NEXT:    s_lshr_b32 s20, s4, 24
; GFX6-NEXT:    v_mov_b32_e32 v12, s54
; GFX6-NEXT:    v_mov_b32_e32 v13, s55
; GFX6-NEXT:    s_lshr_b32 s18, s4, 25
; GFX6-NEXT:    s_bfe_i64 s[16:17], s[16:17], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[14:15], s[14:15], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[14:17], off, s[0:3], 0 offset:416
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v14, s14
; GFX6-NEXT:    v_mov_b32_e32 v15, s15
; GFX6-NEXT:    s_lshr_b32 s14, s4, 22
; GFX6-NEXT:    v_mov_b32_e32 v16, s16
; GFX6-NEXT:    v_mov_b32_e32 v17, s17
; GFX6-NEXT:    s_lshr_b32 s16, s4, 23
; GFX6-NEXT:    s_bfe_i64 s[12:13], s[12:13], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[10:11], s[10:11], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[6:9], off, s[0:3], 0 offset:400
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, s10
; GFX6-NEXT:    v_mov_b32_e32 v7, s11
; GFX6-NEXT:    s_lshr_b32 s10, s4, 20
; GFX6-NEXT:    v_mov_b32_e32 v8, s12
; GFX6-NEXT:    v_mov_b32_e32 v9, s13
; GFX6-NEXT:    s_lshr_b32 s12, s4, 21
; GFX6-NEXT:    s_bfe_i64 s[8:9], s[8:9], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[6:7], s[6:7], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[10:13], off, s[0:3], 0 offset:384
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v10, s6
; GFX6-NEXT:    v_mov_b32_e32 v11, s7
; GFX6-NEXT:    s_lshr_b32 s6, s4, 18
; GFX6-NEXT:    v_mov_b32_e32 v12, s8
; GFX6-NEXT:    v_mov_b32_e32 v13, s9
; GFX6-NEXT:    s_lshr_b32 s8, s4, 19
; GFX6-NEXT:    s_bfe_i64 s[52:53], s[52:53], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[50:51], s[50:51], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[14:17], off, s[0:3], 0 offset:368
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v14, s50
; GFX6-NEXT:    v_mov_b32_e32 v15, s51
; GFX6-NEXT:    s_lshr_b32 s50, s4, 16
; GFX6-NEXT:    v_mov_b32_e32 v16, s52
; GFX6-NEXT:    v_mov_b32_e32 v17, s53
; GFX6-NEXT:    s_lshr_b32 s52, s4, 17
; GFX6-NEXT:    s_bfe_i64 s[48:49], s[48:49], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[46:47], s[46:47], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[6:9], off, s[0:3], 0 offset:352
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, s46
; GFX6-NEXT:    v_mov_b32_e32 v7, s47
; GFX6-NEXT:    s_lshr_b32 s46, s4, 14
; GFX6-NEXT:    v_mov_b32_e32 v8, s48
; GFX6-NEXT:    v_mov_b32_e32 v9, s49
; GFX6-NEXT:    s_lshr_b32 s48, s4, 15
; GFX6-NEXT:    s_bfe_i64 s[54:55], s[42:43], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[42:43], s[44:45], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[10:13], off, s[0:3], 0 offset:336
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v10, s42
; GFX6-NEXT:    v_mov_b32_e32 v11, s43
; GFX6-NEXT:    s_lshr_b32 s42, s4, 12
; GFX6-NEXT:    v_mov_b32_e32 v12, s54
; GFX6-NEXT:    v_mov_b32_e32 v13, s55
; GFX6-NEXT:    s_lshr_b32 s44, s4, 13
; GFX6-NEXT:    s_bfe_i64 s[40:41], s[40:41], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[14:17], off, s[0:3], 0 offset:320
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v14, s40
; GFX6-NEXT:    v_mov_b32_e32 v15, s41
; GFX6-NEXT:    s_lshr_b32 s40, s4, 10
; GFX6-NEXT:    s_bfe_i64 s[36:37], s[36:37], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[38:39], s[38:39], 0x10000
; GFX6-NEXT:    v_mov_b32_e32 v16, s36
; GFX6-NEXT:    v_mov_b32_e32 v17, s37
; GFX6-NEXT:    s_lshr_b32 s36, s4, 11
; GFX6-NEXT:    v_mov_b32_e32 v2, s38
; GFX6-NEXT:    v_mov_b32_e32 v3, s39
; GFX6-NEXT:    s_lshr_b32 s38, s4, 8
; GFX6-NEXT:    s_bfe_i64 s[34:35], s[34:35], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[30:31], s[30:31], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[6:9], off, s[0:3], 0 offset:304
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, s30
; GFX6-NEXT:    v_mov_b32_e32 v7, s31
; GFX6-NEXT:    s_lshr_b32 s30, s4, 9
; GFX6-NEXT:    v_mov_b32_e32 v8, s34
; GFX6-NEXT:    v_mov_b32_e32 v9, s35
; GFX6-NEXT:    s_lshr_b32 s34, s4, 6
; GFX6-NEXT:    s_bfe_i64 s[26:27], s[26:27], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[28:29], s[28:29], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[10:13], off, s[0:3], 0 offset:288
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v10, s26
; GFX6-NEXT:    v_mov_b32_e32 v11, s27
; GFX6-NEXT:    s_lshr_b32 s26, s4, 7
; GFX6-NEXT:    v_mov_b32_e32 v12, s28
; GFX6-NEXT:    v_mov_b32_e32 v13, s29
; GFX6-NEXT:    s_lshr_b32 s28, s4, 4
; GFX6-NEXT:    s_bfe_i64 s[24:25], s[24:25], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[22:23], s[22:23], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[14:17], off, s[0:3], 0 offset:272
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v14, s22
; GFX6-NEXT:    v_mov_b32_e32 v15, s23
; GFX6-NEXT:    s_lshr_b32 s22, s4, 5
; GFX6-NEXT:    v_mov_b32_e32 v16, s24
; GFX6-NEXT:    v_mov_b32_e32 v17, s25
; GFX6-NEXT:    s_lshr_b32 s24, s4, 2
; GFX6-NEXT:    s_bfe_i64 s[20:21], s[20:21], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:256
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s20
; GFX6-NEXT:    v_mov_b32_e32 v1, s21
; GFX6-NEXT:    s_lshr_b32 s20, s4, 3
; GFX6-NEXT:    s_lshr_b32 s4, s4, 1
; GFX6-NEXT:    s_bfe_i64 s[4:5], s[4:5], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[20:21], s[20:21], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[24:25], s[24:25], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[22:23], s[22:23], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[28:29], s[28:29], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[26:27], s[26:27], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[34:35], s[34:35], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[30:31], s[30:31], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[38:39], s[38:39], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[36:37], s[36:37], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[40:41], s[40:41], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[44:45], s[44:45], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[42:43], s[42:43], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[48:49], s[48:49], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[46:47], s[46:47], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[52:53], s[52:53], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[50:51], s[50:51], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[8:9], s[8:9], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[6:7], s[6:7], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[12:13], s[12:13], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[10:11], s[10:11], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[16:17], s[16:17], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[14:15], s[14:15], 0x10000
; GFX6-NEXT:    s_bfe_i64 s[18:19], s[18:19], 0x10000
; GFX6-NEXT:    buffer_store_dwordx4 v[6:9], off, s[0:3], 0 offset:240
; GFX6-NEXT:    buffer_store_dwordx4 v[10:13], off, s[0:3], 0 offset:224
; GFX6-NEXT:    buffer_store_dwordx4 v[14:17], off, s[0:3], 0 offset:208
; GFX6-NEXT:    v_mov_b32_e32 v2, s18
; GFX6-NEXT:    v_mov_b32_e32 v3, s19
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:192
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s14
; GFX6-NEXT:    v_mov_b32_e32 v1, s15
; GFX6-NEXT:    v_mov_b32_e32 v2, s16
; GFX6-NEXT:    v_mov_b32_e32 v3, s17
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:176
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s10
; GFX6-NEXT:    v_mov_b32_e32 v1, s11
; GFX6-NEXT:    v_mov_b32_e32 v2, s12
; GFX6-NEXT:    v_mov_b32_e32 v3, s13
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:160
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s7
; GFX6-NEXT:    v_mov_b32_e32 v2, s8
; GFX6-NEXT:    v_mov_b32_e32 v3, s9
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:144
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s50
; GFX6-NEXT:    v_mov_b32_e32 v1, s51
; GFX6-NEXT:    v_mov_b32_e32 v2, s52
; GFX6-NEXT:    v_mov_b32_e32 v3, s53
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:128
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s46
; GFX6-NEXT:    v_mov_b32_e32 v1, s47
; GFX6-NEXT:    v_mov_b32_e32 v2, s48
; GFX6-NEXT:    v_mov_b32_e32 v3, s49
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:112
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s42
; GFX6-NEXT:    v_mov_b32_e32 v1, s43
; GFX6-NEXT:    v_mov_b32_e32 v2, s44
; GFX6-NEXT:    v_mov_b32_e32 v3, s45
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:96
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s40
; GFX6-NEXT:    v_mov_b32_e32 v1, s41
; GFX6-NEXT:    v_mov_b32_e32 v2, s36
; GFX6-NEXT:    v_mov_b32_e32 v3, s37
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:80
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s38
; GFX6-NEXT:    v_mov_b32_e32 v1, s39
; GFX6-NEXT:    v_mov_b32_e32 v2, s30
; GFX6-NEXT:    v_mov_b32_e32 v3, s31
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:64
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s34
; GFX6-NEXT:    v_mov_b32_e32 v1, s35
; GFX6-NEXT:    v_mov_b32_e32 v2, s26
; GFX6-NEXT:    v_mov_b32_e32 v3, s27
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s28
; GFX6-NEXT:    v_mov_b32_e32 v1, s29
; GFX6-NEXT:    v_mov_b32_e32 v2, s22
; GFX6-NEXT:    v_mov_b32_e32 v3, s23
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:32
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s24
; GFX6-NEXT:    v_mov_b32_e32 v1, s25
; GFX6-NEXT:    v_mov_b32_e32 v2, s20
; GFX6-NEXT:    v_mov_b32_e32 v3, s21
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NEXT:    v_mov_b32_e32 v6, s4
; GFX6-NEXT:    v_mov_b32_e32 v7, s5
; GFX6-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: constant_sextload_v64i1_to_v64i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b32 s7, 0
; GFX8-NEXT:    s_mov_b32 s13, s7
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx2 s[10:11], s[2:3], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v29, s1
; GFX8-NEXT:    v_mov_b32_e32 v28, s0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s16, s11, 22
; GFX8-NEXT:    s_lshr_b32 s18, s11, 23
; GFX8-NEXT:    s_lshr_b32 s20, s11, 20
; GFX8-NEXT:    s_lshr_b32 s22, s11, 21
; GFX8-NEXT:    s_lshr_b32 s24, s11, 18
; GFX8-NEXT:    s_lshr_b32 s26, s11, 19
; GFX8-NEXT:    s_lshr_b32 s28, s11, 16
; GFX8-NEXT:    s_lshr_b32 s30, s11, 17
; GFX8-NEXT:    s_lshr_b32 s34, s10, 22
; GFX8-NEXT:    s_lshr_b32 s36, s10, 23
; GFX8-NEXT:    s_lshr_b32 s38, s10, 20
; GFX8-NEXT:    s_lshr_b32 s40, s10, 21
; GFX8-NEXT:    s_lshr_b32 s42, s10, 18
; GFX8-NEXT:    s_lshr_b32 s44, s10, 19
; GFX8-NEXT:    s_lshr_b32 s46, s10, 16
; GFX8-NEXT:    s_lshr_b32 s48, s10, 17
; GFX8-NEXT:    s_mov_b32 s6, s11
; GFX8-NEXT:    s_lshr_b32 s12, s11, 24
; GFX8-NEXT:    s_lshr_b32 s8, s10, 24
; GFX8-NEXT:    s_bfe_i64 s[2:3], s[8:9], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[4:5], s[12:13], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[6:7], s[6:7], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[14:15], s[10:11], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[48:49], s[48:49], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[46:47], s[46:47], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[44:45], s[44:45], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[42:43], s[42:43], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[40:41], s[40:41], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[38:39], s[38:39], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[36:37], s[36:37], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[34:35], s[34:35], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[30:31], s[30:31], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[28:29], s[28:29], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[26:27], s[26:27], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[24:25], s[24:25], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[22:23], s[22:23], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[20:21], s[20:21], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[18:19], s[18:19], 0x10000
; GFX8-NEXT:    s_bfe_i64 s[16:17], s[16:17], 0x10000
; GFX8-NEXT:    v_mov_b32_e32 v22, s16
; GFX8-NEXT:    s_add_u32 s16, s0, 0x1b0
; GFX8-NEXT:    v_mov_b32_e32 v23, s17
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v27, s17
; GFX8-NEXT:    v_mov_b32_e32 v26, s16
; GFX8-NEXT:    s_add_u32 s16, s0, 0x1a0
; GFX8-NEXT:    v_mov_b32_e32 v24, s18
; GFX8-NEXT:    v_mov_b32_e32 v25, s19
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s17
; GFX8-NEXT:    v_mov_b32_e32 v26, s16
; GFX8-NEXT:    s_add_u32 s16, s0, 0x190
; GFX8-NEXT:    v_mov_b32_e32 v22, s20
; GFX8-NEXT:    v_mov_b32_e32 v23, s21
; GFX8-NEXT:    v_mov_b32_e32 v24, s22
; GFX8-NEXT:    v_mov_b32_e32 v25, s23
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s17
; GFX8-NEXT:    v_mov_b32_e32 v26, s16
; GFX8-NEXT:    s_add_u32 s16, s0, 0x180
; GFX8-NEXT:    v_mov_b32_e32 v22, s24
; GFX8-NEXT:    v_mov_b32_e32 v23, s25
; GFX8-NEXT:    v_mov_b32_e32 v24, s26
; GFX8-NEXT:    v_mov_b32_e32 v25, s27
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s17
; GFX8-NEXT:    v_mov_b32_e32 v26, s16
; GFX8-NEXT:    s_add_u32 s16, s0, 0xb0
; GFX8-NEXT:    v_mov_b32_e32 v22, s28
; GFX8-NEXT:    v_mov_b32_e32 v23, s29
; GFX8-NEXT:    v_mov_b32_e32 v24, s30
; GFX8-NEXT:    v_mov_b32_e32 v25, s31
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s17
; GFX8-NEXT:    v_mov_b32_e32 v26, s16
; GFX8-NEXT:    s_add_u32 s16, s0, 0xa0
; GFX8-NEXT:    v_mov_b32_e32 v22, s34
; GFX8-NEXT:    v_mov_b32_e32 v23, s35
; GFX8-NEXT:    v_mov_b32_e32 v24, s36
; GFX8-NEXT:    v_mov_b32_e32 v25, s37
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s17
; GFX8-NEXT:    v_mov_b32_e32 v26, s16
; GFX8-NEXT:    s_add_u32 s16, s0, 0x90
; GFX8-NEXT:    v_mov_b32_e32 v22, s38
; GFX8-NEXT:    v_mov_b32_e32 v23, s39
; GFX8-NEXT:    v_mov_b32_e32 v24, s40
; GFX8-NEXT:    v_mov_b32_e32 v25, s41
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s17
; GFX8-NEXT:    v_mov_b32_e32 v26, s16
; GFX8-NEXT:    s_add_u32 s16, s0, 0x80
; GFX8-NEXT:    v_mov_b32_e32 v22, s42
; GFX8-NEXT:    v_mov_b32_e32 v23, s43
; GFX8-NEXT:    v_mov_b32_e32 v24, s44
; GFX8-NEXT:    v_mov_b32_e32 v25, s45
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_mov_b32_e32 v27, s17
; GFX8-NEXT:    v_mov_b32_e32 v26, s16
; GFX8-NEXT:    s_add_u32 s16, s0, 0x70
; GFX8-NEXT:    v_lshrrev_b16_e64 v20, 14, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v21, 15, s10
; GFX8-NEXT:    v_mov_b32_e32 v22, s46
; GFX8-NEXT:    v_mov_b32_e32 v23, s47
; GFX8-NEXT:    v_mov_b32_e32 v24, s48
; GFX8-NEXT:    v_mov_b32_e32 v25, s49
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[26:27], v[22:25]
; GFX8-NEXT:    v_bfe_i32 v26, v21, 0, 1
; GFX8-NEXT:    v_bfe_i32 v24, v20, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v21, s17
; GFX8-NEXT:    v_mov_b32_e32 v20, s16
; GFX8-NEXT:    s_add_u32 s16, s0, 0x60
; GFX8-NEXT:    v_lshrrev_b16_e64 v18, 12, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v19, 13, s10
; GFX8-NEXT:    v_ashrrev_i32_e32 v27, 31, v26
; GFX8-NEXT:    v_ashrrev_i32_e32 v25, 31, v24
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[20:21], v[24:27]
; GFX8-NEXT:    v_lshrrev_b16_e64 v16, 10, s10
; GFX8-NEXT:    v_bfe_i32 v26, v19, 0, 1
; GFX8-NEXT:    v_bfe_i32 v24, v18, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v19, s17
; GFX8-NEXT:    v_lshrrev_b16_e64 v17, 11, s10
; GFX8-NEXT:    v_ashrrev_i32_e32 v27, 31, v26
; GFX8-NEXT:    v_ashrrev_i32_e32 v25, 31, v24
; GFX8-NEXT:    v_mov_b32_e32 v18, s16
; GFX8-NEXT:    s_add_u32 s16, s0, 0x50
; GFX8-NEXT:    flat_store_dwordx4 v[18:19], v[24:27]
; GFX8-NEXT:    s_addc_u32 s17, s1, 0
; GFX8-NEXT:    v_bfe_i32 v26, v17, 0, 1
; GFX8-NEXT:    v_bfe_i32 v24, v16, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v16, s16
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 8, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v15, 9, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v12, 6, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v13, 7, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v10, 4, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v11, 5, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v8, 2, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v9, 3, s10
; GFX8-NEXT:    v_lshrrev_b16_e64 v7, 1, s10
; GFX8-NEXT:    v_ashrrev_i32_e32 v27, 31, v26
; GFX8-NEXT:    v_ashrrev_i32_e32 v25, 31, v24
; GFX8-NEXT:    v_mov_b32_e32 v17, s17
; GFX8-NEXT:    s_add_u32 s10, s0, 64
; GFX8-NEXT:    v_lshrrev_b16_e64 v5, 14, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v6, 15, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v3, 12, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v4, 13, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v1, 10, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v2, 11, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v0, 8, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v23, 9, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v22, 6, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v21, 7, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v20, 4, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v19, 5, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v18, 2, s11
; GFX8-NEXT:    flat_store_dwordx4 v[16:17], v[24:27]
; GFX8-NEXT:    v_lshrrev_b16_e64 v17, 3, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v16, 1, s11
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    v_bfe_i32 v26, v15, 0, 1
; GFX8-NEXT:    v_bfe_i32 v24, v14, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v15, s11
; GFX8-NEXT:    v_mov_b32_e32 v14, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 48
; GFX8-NEXT:    v_ashrrev_i32_e32 v27, 31, v26
; GFX8-NEXT:    v_ashrrev_i32_e32 v25, 31, v24
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[14:15], v[24:27]
; GFX8-NEXT:    v_bfe_i32 v3, v3, 0, 1
; GFX8-NEXT:    v_bfe_i32 v26, v13, 0, 1
; GFX8-NEXT:    v_bfe_i32 v24, v12, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v13, s11
; GFX8-NEXT:    v_ashrrev_i32_e32 v27, 31, v26
; GFX8-NEXT:    v_ashrrev_i32_e32 v25, 31, v24
; GFX8-NEXT:    v_mov_b32_e32 v12, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 32
; GFX8-NEXT:    flat_store_dwordx4 v[12:13], v[24:27]
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    v_bfe_i32 v26, v11, 0, 1
; GFX8-NEXT:    v_bfe_i32 v24, v10, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v10, s10
; GFX8-NEXT:    v_ashrrev_i32_e32 v27, 31, v26
; GFX8-NEXT:    v_ashrrev_i32_e32 v25, 31, v24
; GFX8-NEXT:    v_mov_b32_e32 v11, s11
; GFX8-NEXT:    s_add_u32 s10, s0, 16
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[24:27]
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    v_bfe_i32 v26, v9, 0, 1
; GFX8-NEXT:    v_bfe_i32 v24, v8, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v8, s10
; GFX8-NEXT:    v_ashrrev_i32_e32 v27, 31, v26
; GFX8-NEXT:    v_ashrrev_i32_e32 v25, 31, v24
; GFX8-NEXT:    v_mov_b32_e32 v9, s11
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[24:27]
; GFX8-NEXT:    s_add_u32 s10, s0, 0x170
; GFX8-NEXT:    v_bfe_i32 v26, v7, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v27, 31, v26
; GFX8-NEXT:    v_mov_b32_e32 v24, s14
; GFX8-NEXT:    v_mov_b32_e32 v25, s15
; GFX8-NEXT:    flat_store_dwordx4 v[28:29], v[24:27]
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    v_bfe_i32 v26, v6, 0, 1
; GFX8-NEXT:    v_bfe_i32 v24, v5, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v5, s10
; GFX8-NEXT:    v_mov_b32_e32 v6, s11
; GFX8-NEXT:    s_add_u32 s10, s0, 0x160
; GFX8-NEXT:    v_ashrrev_i32_e32 v27, 31, v26
; GFX8-NEXT:    v_ashrrev_i32_e32 v25, 31, v24
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[5:6], v[24:27]
; GFX8-NEXT:    v_bfe_i32 v5, v4, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v25, s11
; GFX8-NEXT:    v_ashrrev_i32_e32 v6, 31, v5
; GFX8-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GFX8-NEXT:    v_mov_b32_e32 v24, s10
; GFX8-NEXT:    s_add_u32 s10, s0, 0x150
; GFX8-NEXT:    flat_store_dwordx4 v[24:25], v[3:6]
; GFX8-NEXT:    v_bfe_i32 v1, v1, 0, 1
; GFX8-NEXT:    v_bfe_i32 v3, v2, 0, 1
; GFX8-NEXT:    s_addc_u32 s11, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, s10
; GFX8-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GFX8-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GFX8-NEXT:    v_mov_b32_e32 v6, s11
; GFX8-NEXT:    v_lshrrev_b16_e64 v9, 6, s8
; GFX8-NEXT:    v_lshrrev_b16_e64 v28, 7, s8
; GFX8-NEXT:    v_lshrrev_b16_e64 v26, 4, s8
; GFX8-NEXT:    v_lshrrev_b16_e64 v27, 5, s8
; GFX8-NEXT:    v_lshrrev_b16_e64 v24, 2, s8
; GFX8-NEXT:    v_lshrrev_b16_e64 v25, 3, s8
; GFX8-NEXT:    flat_store_dwordx4 v[5:6], v[1:4]
; GFX8-NEXT:    v_lshrrev_b16_e64 v6, 1, s8
; GFX8-NEXT:    s_add_u32 s8, s0, 0x140
; GFX8-NEXT:    v_bfe_i32 v2, v23, 0, 1
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 1
; GFX8-NEXT:    s_addc_u32 s9, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX8-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX8-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NEXT:    s_add_u32 s8, s0, 0x130
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    v_bfe_i32 v4, v22, 0, 1
; GFX8-NEXT:    v_bfe_i32 v2, v6, 0, 1
; GFX8-NEXT:    v_bfe_i32 v6, v21, 0, 1
; GFX8-NEXT:    s_addc_u32 s9, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX8-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    s_add_u32 s8, s0, 0x120
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX8-NEXT:    v_bfe_i32 v21, v19, 0, 1
; GFX8-NEXT:    v_bfe_i32 v19, v20, 0, 1
; GFX8-NEXT:    s_addc_u32 s9, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    v_ashrrev_i32_e32 v22, 31, v21
; GFX8-NEXT:    v_ashrrev_i32_e32 v20, 31, v19
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    s_add_u32 s8, s0, 0x110
; GFX8-NEXT:    v_bfe_i32 v6, v25, 0, 1
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[19:22]
; GFX8-NEXT:    v_bfe_i32 v25, v17, 0, 1
; GFX8-NEXT:    v_bfe_i32 v23, v18, 0, 1
; GFX8-NEXT:    s_addc_u32 s9, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    v_bfe_i32 v4, v24, 0, 1
; GFX8-NEXT:    v_bfe_i32 v19, v26, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v26, 31, v25
; GFX8-NEXT:    v_ashrrev_i32_e32 v24, 31, v23
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[23:26]
; GFX8-NEXT:    v_lshrrev_b16_e64 v14, 6, s12
; GFX8-NEXT:    v_mov_b32_e32 v23, s6
; GFX8-NEXT:    s_add_u32 s6, s0, 0x100
; GFX8-NEXT:    v_bfe_i32 v25, v16, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v24, s7
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_lshrrev_b16_e64 v15, 7, s12
; GFX8-NEXT:    v_ashrrev_i32_e32 v26, 31, v25
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    s_add_u32 s6, s0, 0x1f0
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[23:26]
; GFX8-NEXT:    v_bfe_i32 v16, v15, 0, 1
; GFX8-NEXT:    v_bfe_i32 v14, v14, 0, 1
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_lshrrev_b16_e64 v12, 4, s12
; GFX8-NEXT:    v_lshrrev_b16_e64 v13, 5, s12
; GFX8-NEXT:    v_ashrrev_i32_e32 v17, 31, v16
; GFX8-NEXT:    v_ashrrev_i32_e32 v15, 31, v14
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    s_add_u32 s6, s0, 0x1e0
; GFX8-NEXT:    v_bfe_i32 v21, v27, 0, 1
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[14:17]
; GFX8-NEXT:    v_bfe_i32 v29, v13, 0, 1
; GFX8-NEXT:    v_bfe_i32 v27, v12, 0, 1
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_lshrrev_b16_e64 v10, 2, s12
; GFX8-NEXT:    v_lshrrev_b16_e64 v11, 3, s12
; GFX8-NEXT:    v_bfe_i32 v25, v28, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v30, 31, v29
; GFX8-NEXT:    v_ashrrev_i32_e32 v28, 31, v27
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    s_add_u32 s6, s0, 0x1d0
; GFX8-NEXT:    v_bfe_i32 v23, v9, 0, 1
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[27:30]
; GFX8-NEXT:    v_bfe_i32 v11, v11, 0, 1
; GFX8-NEXT:    v_bfe_i32 v9, v10, 0, 1
; GFX8-NEXT:    s_addc_u32 s7, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_ashrrev_i32_e32 v12, 31, v11
; GFX8-NEXT:    v_ashrrev_i32_e32 v10, 31, v9
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_lshrrev_b16_e64 v8, 1, s12
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[9:12]
; GFX8-NEXT:    v_bfe_i32 v14, v8, 0, 1
; GFX8-NEXT:    v_mov_b32_e32 v12, s4
; GFX8-NEXT:    s_add_u32 s4, s0, 0x1c0
; GFX8-NEXT:    v_mov_b32_e32 v13, s5
; GFX8-NEXT:    s_addc_u32 s5, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_ashrrev_i32_e32 v15, 31, v14
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_add_u32 s4, s0, 0xf0
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[12:15]
; GFX8-NEXT:    s_addc_u32 s5, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_ashrrev_i32_e32 v26, 31, v25
; GFX8-NEXT:    v_ashrrev_i32_e32 v24, 31, v23
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_add_u32 s4, s0, 0xe0
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[23:26]
; GFX8-NEXT:    s_addc_u32 s5, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_add_u32 s4, s0, 0xd0
; GFX8-NEXT:    v_ashrrev_i32_e32 v22, 31, v21
; GFX8-NEXT:    v_ashrrev_i32_e32 v20, 31, v19
; GFX8-NEXT:    s_addc_u32 s5, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[19:22]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    s_add_u32 s0, s0, 0xc0
; GFX8-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX8-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v64i1_to_v64i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 22, @40, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @38
; EG-NEXT:    ALU 89, @63, KC0[CB0:0-32], KC1[]
; EG-NEXT:    ALU 99, @153, KC0[], KC1[]
; EG-NEXT:    ALU 107, @253, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T50.XYZW, T82.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T80.XYZW, T81.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T51.XYZW, T73.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T79.XYZW, T48.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T52.XYZW, T47.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T78.XYZW, T46.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T53.XYZW, T45.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T77.XYZW, T44.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T54.XYZW, T43.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T76.XYZW, T42.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T55.XYZW, T41.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T75.XYZW, T39.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T56.XYZW, T38.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T74.XYZW, T37.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T57.XYZW, T36.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T66.XYZW, T35.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T58.XYZW, T34.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T72.XYZW, T33.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T59.XYZW, T32.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T71.XYZW, T31.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T60.XYZW, T30.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T70.XYZW, T29.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T61.XYZW, T28.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T69.XYZW, T27.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T62.XYZW, T26.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T68.XYZW, T25.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T63.XYZW, T24.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T40.XYZW, T23.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T64.XYZW, T22.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T67.XYZW, T21.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T65.XYZW, T20.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T49.XYZW, T19.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 38:
; EG-NEXT:     VTX_READ_64 T40.XY, T26.X, 0, #1
; EG-NEXT:    ALU clause starting at 40:
; EG-NEXT:     LSHR T19.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T20.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T21.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T22.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T23.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T24.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:     LSHR T25.X, PV.W, literal.x,
; EG-NEXT:     MOV * T26.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    112(1.569454e-43), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 63:
; EG-NEXT:     LSHR T26.X, T0.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 128(1.793662e-43)
; EG-NEXT:     LSHR T27.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 144(2.017870e-43)
; EG-NEXT:     LSHR T28.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 160(2.242078e-43)
; EG-NEXT:     LSHR T29.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 176(2.466285e-43)
; EG-NEXT:     LSHR T30.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 192(2.690493e-43)
; EG-NEXT:     LSHR T31.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 208(2.914701e-43)
; EG-NEXT:     LSHR T32.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 224(3.138909e-43)
; EG-NEXT:     LSHR T33.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 240(3.363116e-43)
; EG-NEXT:     LSHR T34.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 256(3.587324e-43)
; EG-NEXT:     LSHR T35.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 272(3.811532e-43)
; EG-NEXT:     LSHR T36.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 288(4.035740e-43)
; EG-NEXT:     LSHR T37.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 304(4.259947e-43)
; EG-NEXT:     LSHR T38.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 320(4.484155e-43)
; EG-NEXT:     LSHR T39.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 336(4.708363e-43)
; EG-NEXT:     LSHR T41.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 352(4.932571e-43)
; EG-NEXT:     LSHR T42.X, PV.W, literal.x,
; EG-NEXT:     LSHR T0.Z, T40.Y, literal.y,
; EG-NEXT:     LSHR T0.W, T40.Y, literal.z,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.w,
; EG-NEXT:    2(2.802597e-45), 28(3.923636e-44)
; EG-NEXT:    29(4.063766e-44), 368(5.156778e-43)
; EG-NEXT:     LSHR T43.X, PS, literal.x,
; EG-NEXT:     LSHR T0.Y, T40.Y, literal.y,
; EG-NEXT:     LSHR T1.Z, T40.Y, literal.z,
; EG-NEXT:     LSHR * T1.W, T40.Y, literal.w,
; EG-NEXT:    2(2.802597e-45), 24(3.363116e-44)
; EG-NEXT:    25(3.503246e-44), 20(2.802597e-44)
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.x,
; EG-NEXT:    384(5.380986e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T44.X, PV.W, literal.x,
; EG-NEXT:     LSHR T1.Y, T40.Y, literal.y,
; EG-NEXT:     LSHR T2.Z, T40.Y, literal.z,
; EG-NEXT:     LSHR * T2.W, T40.Y, literal.w,
; EG-NEXT:    2(2.802597e-45), 21(2.942727e-44)
; EG-NEXT:    16(2.242078e-44), 17(2.382207e-44)
; EG-NEXT:     ADD_INT * T3.W, KC0[2].Y, literal.x,
; EG-NEXT:    400(5.605194e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T45.X, PV.W, literal.x,
; EG-NEXT:     LSHR T2.Y, T40.Y, literal.y,
; EG-NEXT:     LSHR T3.Z, T40.Y, literal.z,
; EG-NEXT:     LSHR * T3.W, T40.Y, literal.w,
; EG-NEXT:    2(2.802597e-45), 12(1.681558e-44)
; EG-NEXT:    13(1.821688e-44), 8(1.121039e-44)
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.x,
; EG-NEXT:    416(5.829402e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T46.X, PV.W, literal.x,
; EG-NEXT:     LSHR T3.Y, T40.Y, literal.y,
; EG-NEXT:     LSHR T4.Z, T40.Y, literal.z,
; EG-NEXT:     LSHR * T4.W, T40.Y, literal.w,
; EG-NEXT:    2(2.802597e-45), 9(1.261169e-44)
; EG-NEXT:    4(5.605194e-45), 5(7.006492e-45)
; EG-NEXT:     ADD_INT * T5.W, KC0[2].Y, literal.x,
; EG-NEXT:    432(6.053609e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T47.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT T4.Y, KC0[2].Y, literal.y,
; EG-NEXT:     LSHR T5.Z, T40.Y, 1,
; EG-NEXT:     LSHR T5.W, T40.X, literal.z,
; EG-NEXT:     ADD_INT * T6.W, KC0[2].Y, literal.w,
; EG-NEXT:    2(2.802597e-45), 464(6.502025e-43)
; EG-NEXT:    28(3.923636e-44), 448(6.277817e-43)
; EG-NEXT:    ALU clause starting at 153:
; EG-NEXT:     LSHR T48.X, T6.W, literal.x,
; EG-NEXT:     LSHR T5.Y, T40.X, literal.y,
; EG-NEXT:     LSHR T6.Z, T40.X, literal.z,
; EG-NEXT:     LSHR * T6.W, T40.X, literal.w,
; EG-NEXT:    2(2.802597e-45), 29(4.063766e-44)
; EG-NEXT:    24(3.363116e-44), 25(3.503246e-44)
; EG-NEXT:     LSHR * T7.W, T40.X, literal.x,
; EG-NEXT:    20(2.802597e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T49.X, T40.X, 0.0, 1,
; EG-NEXT:     LSHR T6.Y, T40.X, literal.x,
; EG-NEXT:     ASHR T50.Z, T40.Y, literal.y,
; EG-NEXT:     LSHR T8.W, T40.Y, literal.z,
; EG-NEXT:     LSHR * T9.W, T40.Y, literal.w,
; EG-NEXT:    21(2.942727e-44), 31(4.344025e-44)
; EG-NEXT:    27(3.783506e-44), 30(4.203895e-44)
; EG-NEXT:     BFE_INT T50.X, PS, 0.0, 1,
; EG-NEXT:     LSHR T7.Y, T40.X, literal.x,
; EG-NEXT:     BFE_INT T51.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T8.W, T40.Y, literal.y,
; EG-NEXT:     LSHR * T9.W, T40.Y, literal.z,
; EG-NEXT:    16(2.242078e-44), 23(3.222986e-44)
; EG-NEXT:    26(3.643376e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T51.X, PS, 0.0, 1,
; EG-NEXT:     MOV T50.Y, PV.X,
; EG-NEXT:     BFE_INT T52.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T8.W, T40.Y, literal.x,
; EG-NEXT:     LSHR * T9.W, T40.Y, literal.y,
; EG-NEXT:    19(2.662467e-44), 22(3.082857e-44)
; EG-NEXT:     BFE_INT T52.X, PS, 0.0, 1,
; EG-NEXT:     MOV T51.Y, PV.X,
; EG-NEXT:     BFE_INT T53.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T8.W, T40.Y, literal.x,
; EG-NEXT:     LSHR * T9.W, T40.Y, literal.y,
; EG-NEXT:    15(2.101948e-44), 18(2.522337e-44)
; EG-NEXT:     BFE_INT T53.X, PS, 0.0, 1,
; EG-NEXT:     MOV T52.Y, PV.X,
; EG-NEXT:     BFE_INT T54.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T8.W, T40.Y, literal.x,
; EG-NEXT:     LSHR * T9.W, T40.Y, literal.y,
; EG-NEXT:    11(1.541428e-44), 14(1.961818e-44)
; EG-NEXT:     BFE_INT T54.X, PS, 0.0, 1,
; EG-NEXT:     MOV T53.Y, PV.X,
; EG-NEXT:     BFE_INT T55.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T8.W, T40.Y, literal.x,
; EG-NEXT:     LSHR * T9.W, T40.Y, literal.y,
; EG-NEXT:    7(9.809089e-45), 10(1.401298e-44)
; EG-NEXT:     BFE_INT T55.X, PS, 0.0, 1,
; EG-NEXT:     MOV T54.Y, PV.X,
; EG-NEXT:     BFE_INT T56.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T8.W, T40.Y, literal.x,
; EG-NEXT:     LSHR * T9.W, T40.Y, literal.y,
; EG-NEXT:    3(4.203895e-45), 6(8.407791e-45)
; EG-NEXT:     BFE_INT T56.X, PS, 0.0, 1,
; EG-NEXT:     MOV T55.Y, PV.X,
; EG-NEXT:     BFE_INT T57.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T8.W, T40.X, literal.x,
; EG-NEXT:     LSHR * T9.W, T40.Y, literal.y,
; EG-NEXT:    17(2.382207e-44), 2(2.802597e-45)
; EG-NEXT:     BFE_INT T57.X, PS, 0.0, 1,
; EG-NEXT:     MOV T56.Y, PV.X,
; EG-NEXT:     ASHR T58.Z, T40.X, literal.x,
; EG-NEXT:     LSHR T9.W, T40.X, literal.y,
; EG-NEXT:     LSHR * T10.W, T40.X, literal.z,
; EG-NEXT:    31(4.344025e-44), 27(3.783506e-44)
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T58.X, PS, 0.0, 1,
; EG-NEXT:     MOV T57.Y, PV.X,
; EG-NEXT:     BFE_INT T59.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T9.W, T40.X, literal.x,
; EG-NEXT:     LSHR * T10.W, T40.X, literal.y,
; EG-NEXT:    23(3.222986e-44), 26(3.643376e-44)
; EG-NEXT:     BFE_INT T59.X, PS, 0.0, 1,
; EG-NEXT:     MOV T58.Y, PV.X,
; EG-NEXT:     BFE_INT T60.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T9.W, T40.X, literal.x,
; EG-NEXT:     LSHR * T10.W, T40.X, literal.y,
; EG-NEXT:    19(2.662467e-44), 22(3.082857e-44)
; EG-NEXT:     BFE_INT T60.X, PS, 0.0, 1,
; EG-NEXT:     MOV T59.Y, PV.X,
; EG-NEXT:     BFE_INT T61.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T9.W, T40.X, literal.x,
; EG-NEXT:     LSHR * T10.W, T40.X, literal.y,
; EG-NEXT:    15(2.101948e-44), 18(2.522337e-44)
; EG-NEXT:     BFE_INT T61.X, PS, 0.0, 1,
; EG-NEXT:     MOV T60.Y, PV.X,
; EG-NEXT:     BFE_INT T62.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T9.W, T40.X, literal.x,
; EG-NEXT:     LSHR * T10.W, T40.X, literal.y,
; EG-NEXT:    11(1.541428e-44), 14(1.961818e-44)
; EG-NEXT:     BFE_INT T62.X, PS, 0.0, 1,
; EG-NEXT:     MOV T61.Y, PV.X,
; EG-NEXT:     BFE_INT T63.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T9.W, T40.X, literal.x,
; EG-NEXT:     LSHR * T10.W, T40.X, literal.y,
; EG-NEXT:    7(9.809089e-45), 10(1.401298e-44)
; EG-NEXT:     BFE_INT T63.X, PS, 0.0, 1,
; EG-NEXT:     MOV T62.Y, PV.X,
; EG-NEXT:     BFE_INT T64.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR * T9.W, T40.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 253:
; EG-NEXT:     LSHR * T10.W, T40.X, literal.x,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T64.X, PV.W, 0.0, 1,
; EG-NEXT:     MOV T63.Y, T63.X,
; EG-NEXT:     BFE_INT T65.Z, T9.W, 0.0, 1,
; EG-NEXT:     LSHR T9.W, T40.X, 1, BS:VEC_120/SCL_212
; EG-NEXT:     LSHR * T10.W, T40.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T65.X, PS, 0.0, 1,
; EG-NEXT:     MOV T64.Y, PV.X,
; EG-NEXT:     BFE_INT T49.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T9.W, T40.X, literal.x,
; EG-NEXT:     LSHR * T10.W, T40.X, literal.y,
; EG-NEXT:    12(1.681558e-44), 5(7.006492e-45)
; EG-NEXT:     BFE_INT T66.X, T40.Y, 0.0, 1,
; EG-NEXT:     MOV T65.Y, PV.X,
; EG-NEXT:     BFE_INT T67.Z, PS, 0.0, 1,
; EG-NEXT:     LSHR T10.W, T40.X, literal.x,
; EG-NEXT:     LSHR * T11.W, T40.X, literal.y,
; EG-NEXT:    9(1.261169e-44), 4(5.605194e-45)
; EG-NEXT:     BFE_INT T67.X, PS, 0.0, 1,
; EG-NEXT:     MOV T49.Y, T49.X,
; EG-NEXT:     BFE_INT T40.Z, PV.W, 0.0, 1,
; EG-NEXT:     LSHR T10.W, T40.X, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     LSHR * T11.W, T40.X, literal.y,
; EG-NEXT:    13(1.821688e-44), 8(1.121039e-44)
; EG-NEXT:     BFE_INT T40.X, PS, 0.0, 1,
; EG-NEXT:     MOV T67.Y, PV.X,
; EG-NEXT:     BFE_INT T68.Z, PV.W, 0.0, 1,
; EG-NEXT:     MOV T49.W, T49.Z,
; EG-NEXT:     MOV * T65.W, T65.Z,
; EG-NEXT:     BFE_INT T68.X, T9.W, 0.0, 1,
; EG-NEXT:     MOV T40.Y, PV.X,
; EG-NEXT:     BFE_INT T69.Z, T8.W, 0.0, 1, BS:VEC_120/SCL_212
; EG-NEXT:     MOV T67.W, T67.Z,
; EG-NEXT:     MOV * T64.W, T64.Z,
; EG-NEXT:     BFE_INT T69.X, T7.Y, 0.0, 1,
; EG-NEXT:     MOV T68.Y, PV.X,
; EG-NEXT:     BFE_INT T70.Z, T6.Y, 0.0, 1, BS:VEC_120/SCL_212
; EG-NEXT:     MOV T40.W, T40.Z,
; EG-NEXT:     MOV * T63.W, T63.Z,
; EG-NEXT:     BFE_INT T70.X, T7.W, 0.0, 1,
; EG-NEXT:     MOV T69.Y, PV.X,
; EG-NEXT:     BFE_INT T71.Z, T6.W, 0.0, 1, BS:VEC_120/SCL_212
; EG-NEXT:     MOV T68.W, T68.Z,
; EG-NEXT:     MOV * T62.W, T62.Z,
; EG-NEXT:     BFE_INT T71.X, T6.Z, 0.0, 1,
; EG-NEXT:     MOV T70.Y, PV.X,
; EG-NEXT:     BFE_INT T72.Z, T5.Y, 0.0, 1,
; EG-NEXT:     MOV T69.W, T69.Z, BS:VEC_120/SCL_212
; EG-NEXT:     MOV * T61.W, T61.Z,
; EG-NEXT:     BFE_INT T72.X, T5.W, 0.0, 1,
; EG-NEXT:     MOV T71.Y, PV.X,
; EG-NEXT:     BFE_INT T66.Z, T5.Z, 0.0, 1,
; EG-NEXT:     MOV T70.W, T70.Z, BS:VEC_120/SCL_212
; EG-NEXT:     MOV * T60.W, T60.Z,
; EG-NEXT:     LSHR T73.X, T4.Y, literal.x,
; EG-NEXT:     MOV T72.Y, PV.X,
; EG-NEXT:     BFE_INT T74.Z, T4.W, 0.0, 1,
; EG-NEXT:     MOV T71.W, T71.Z,
; EG-NEXT:     MOV * T59.W, T59.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T74.X, T4.Z, 0.0, 1,
; EG-NEXT:     MOV T66.Y, T66.X,
; EG-NEXT:     BFE_INT T75.Z, T3.Y, 0.0, 1,
; EG-NEXT:     MOV T72.W, T72.Z, BS:VEC_120/SCL_212
; EG-NEXT:     MOV * T58.W, T58.Z,
; EG-NEXT:     BFE_INT T75.X, T3.W, 0.0, 1,
; EG-NEXT:     MOV T74.Y, PV.X,
; EG-NEXT:     BFE_INT T76.Z, T3.Z, 0.0, 1,
; EG-NEXT:     MOV T66.W, T66.Z, BS:VEC_120/SCL_212
; EG-NEXT:     MOV * T57.W, T57.Z,
; EG-NEXT:     BFE_INT T76.X, T2.Y, 0.0, 1,
; EG-NEXT:     MOV T75.Y, PV.X,
; EG-NEXT:     BFE_INT T77.Z, T2.W, 0.0, 1,
; EG-NEXT:     MOV T74.W, T74.Z,
; EG-NEXT:     MOV * T56.W, T56.Z,
; EG-NEXT:     BFE_INT T77.X, T2.Z, 0.0, 1,
; EG-NEXT:     MOV T76.Y, PV.X,
; EG-NEXT:     BFE_INT T78.Z, T1.Y, 0.0, 1,
; EG-NEXT:     MOV T75.W, T75.Z, BS:VEC_120/SCL_212
; EG-NEXT:     MOV * T55.W, T55.Z,
; EG-NEXT:     BFE_INT T78.X, T1.W, 0.0, 1,
; EG-NEXT:     MOV T77.Y, PV.X,
; EG-NEXT:     BFE_INT T79.Z, T1.Z, 0.0, 1,
; EG-NEXT:     MOV T76.W, T76.Z, BS:VEC_120/SCL_212
; EG-NEXT:     MOV * T54.W, T54.Z,
; EG-NEXT:     BFE_INT T79.X, T0.Y, 0.0, 1,
; EG-NEXT:     MOV T78.Y, PV.X,
; EG-NEXT:     BFE_INT T80.Z, T0.W, 0.0, 1,
; EG-NEXT:     MOV T77.W, T77.Z,
; EG-NEXT:     MOV * T53.W, T53.Z,
; EG-NEXT:     BFE_INT T80.X, T0.Z, 0.0, 1,
; EG-NEXT:     MOV T79.Y, PV.X,
; EG-NEXT:     ADD_INT T0.Z, KC0[2].Y, literal.x,
; EG-NEXT:     MOV T78.W, T78.Z, BS:VEC_120/SCL_212
; EG-NEXT:     MOV * T52.W, T52.Z,
; EG-NEXT:    480(6.726233e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T81.X, PV.Z, literal.x,
; EG-NEXT:     MOV T80.Y, PV.X,
; EG-NEXT:     ADD_INT T0.Z, KC0[2].Y, literal.y,
; EG-NEXT:     MOV T79.W, T79.Z,
; EG-NEXT:     MOV * T51.W, T51.Z,
; EG-NEXT:    2(2.802597e-45), 496(6.950440e-43)
; EG-NEXT:     LSHR T82.X, PV.Z, literal.x,
; EG-NEXT:     MOV T80.W, T80.Z,
; EG-NEXT:     MOV * T50.W, T50.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_sextload_v64i1_to_v64i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_mov_b32 s5, 0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_mov_b32 s19, s5
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshr_b32 s26, s3, 22
; GFX12-NEXT:    s_lshr_b32 s28, s3, 23
; GFX12-NEXT:    s_lshr_b32 s30, s3, 20
; GFX12-NEXT:    s_lshr_b32 s34, s3, 21
; GFX12-NEXT:    s_bfe_i64 s[26:27], s[26:27], 0x10000
; GFX12-NEXT:    s_bfe_i64 s[28:29], s[28:29], 0x10000
; GFX12-NEXT:    s_lshr_b32 s20, s3, 18
; GFX12-NEXT:    s_bfe_i64 s[34:35], s[34:35], 0x10000
; GFX12-NEXT:    s_bfe_i64 s[30:31], s[30:31], 0x10000
; GFX12-NEXT:    v_dual_mov_b32 v12, 0 :: v_dual_mov_b32 v43, s27
; GFX12-NEXT:    v_dual_mov_b32 v42, s26 :: v_dual_mov_b32 v45, s29
; GFX12-NEXT:    v_dual_mov_b32 v44, s28 :: v_dual_mov_b32 v47, s31
; GFX12-NEXT:    s_lshr_b32 s22, s3, 19
; GFX12-NEXT:    v_dual_mov_b32 v46, s30 :: v_dual_mov_b32 v49, s35
; GFX12-NEXT:    s_bfe_i64 s[20:21], s[20:21], 0x10000
; GFX12-NEXT:    v_mov_b32_e32 v48, s34
; GFX12-NEXT:    s_lshr_b32 s24, s3, 16
; GFX12-NEXT:    s_lshr_b32 s36, s3, 17
; GFX12-NEXT:    s_bfe_i64 s[22:23], s[22:23], 0x10000
; GFX12-NEXT:    s_lshr_b32 s12, s2, 22
; GFX12-NEXT:    s_bfe_i64 s[36:37], s[36:37], 0x10000
; GFX12-NEXT:    s_bfe_i64 s[24:25], s[24:25], 0x10000
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v12, v[42:45], s[0:1] offset:432
; GFX12-NEXT:    global_store_b128 v12, v[46:49], s[0:1] offset:416
; GFX12-NEXT:    v_dual_mov_b32 v43, s21 :: v_dual_mov_b32 v42, s20
; GFX12-NEXT:    v_dual_mov_b32 v45, s23 :: v_dual_mov_b32 v44, s22
; GFX12-NEXT:    v_mov_b32_e32 v47, s25
; GFX12-NEXT:    s_lshr_b32 s14, s2, 23
; GFX12-NEXT:    v_dual_mov_b32 v46, s24 :: v_dual_mov_b32 v49, s37
; GFX12-NEXT:    s_bfe_i64 s[12:13], s[12:13], 0x10000
; GFX12-NEXT:    v_mov_b32_e32 v48, s36
; GFX12-NEXT:    s_lshr_b32 s16, s2, 20
; GFX12-NEXT:    s_lshr_b32 s40, s2, 21
; GFX12-NEXT:    s_bfe_i64 s[14:15], s[14:15], 0x10000
; GFX12-NEXT:    s_lshr_b32 s6, s2, 18
; GFX12-NEXT:    s_bfe_i64 s[40:41], s[40:41], 0x10000
; GFX12-NEXT:    s_bfe_i64 s[16:17], s[16:17], 0x10000
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v12, v[42:45], s[0:1] offset:400
; GFX12-NEXT:    global_store_b128 v12, v[46:49], s[0:1] offset:384
; GFX12-NEXT:    v_dual_mov_b32 v43, s13 :: v_dual_mov_b32 v42, s12
; GFX12-NEXT:    v_dual_mov_b32 v45, s15 :: v_dual_mov_b32 v44, s14
; GFX12-NEXT:    v_mov_b32_e32 v47, s17
; GFX12-NEXT:    s_lshr_b32 s8, s2, 19
; GFX12-NEXT:    v_dual_mov_b32 v46, s16 :: v_dual_mov_b32 v49, s41
; GFX12-NEXT:    s_bfe_i64 s[6:7], s[6:7], 0x10000
; GFX12-NEXT:    v_mov_b32_e32 v48, s40
; GFX12-NEXT:    s_lshr_b32 s10, s2, 16
; GFX12-NEXT:    s_bfe_i64 s[8:9], s[8:9], 0x10000
; GFX12-NEXT:    v_lshrrev_b16 v3, 14, s2
; GFX12-NEXT:    v_lshrrev_b16 v5, 15, s2
; GFX12-NEXT:    v_lshrrev_b16 v7, 12, s2
; GFX12-NEXT:    v_lshrrev_b16 v9, 13, s2
; GFX12-NEXT:    s_bfe_i64 s[10:11], s[10:11], 0x10000
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v12, v[42:45], s[0:1] offset:176
; GFX12-NEXT:    global_store_b128 v12, v[46:49], s[0:1] offset:160
; GFX12-NEXT:    v_dual_mov_b32 v43, s7 :: v_dual_mov_b32 v42, s6
; GFX12-NEXT:    v_dual_mov_b32 v45, s9 :: v_dual_mov_b32 v44, s8
; GFX12-NEXT:    v_mov_b32_e32 v47, s11
; GFX12-NEXT:    s_lshr_b32 s42, s2, 17
; GFX12-NEXT:    v_lshrrev_b16 v32, 10, s2
; GFX12-NEXT:    s_bfe_i64 s[42:43], s[42:43], 0x10000
; GFX12-NEXT:    v_lshrrev_b16 v34, 11, s2
; GFX12-NEXT:    v_lshrrev_b16 v33, 8, s2
; GFX12-NEXT:    v_lshrrev_b16 v35, 9, s2
; GFX12-NEXT:    v_lshrrev_b16 v27, 6, s2
; GFX12-NEXT:    v_lshrrev_b16 v29, 7, s2
; GFX12-NEXT:    v_lshrrev_b16 v30, 4, s2
; GFX12-NEXT:    v_lshrrev_b16 v31, 5, s2
; GFX12-NEXT:    v_lshrrev_b16 v24, 2, s2
; GFX12-NEXT:    v_lshrrev_b16 v25, 3, s2
; GFX12-NEXT:    v_lshrrev_b16 v23, 1, s2
; GFX12-NEXT:    v_lshrrev_b16 v18, 14, s3
; GFX12-NEXT:    v_lshrrev_b16 v20, 15, s3
; GFX12-NEXT:    v_lshrrev_b16 v16, 12, s3
; GFX12-NEXT:    v_lshrrev_b16 v19, 13, s3
; GFX12-NEXT:    v_lshrrev_b16 v0, 10, s3
; GFX12-NEXT:    v_lshrrev_b16 v1, 11, s3
; GFX12-NEXT:    v_lshrrev_b16 v13, 8, s3
; GFX12-NEXT:    v_lshrrev_b16 v15, 9, s3
; GFX12-NEXT:    v_lshrrev_b16 v14, 6, s3
; GFX12-NEXT:    v_lshrrev_b16 v17, 7, s3
; GFX12-NEXT:    v_lshrrev_b16 v21, 4, s3
; GFX12-NEXT:    v_lshrrev_b16 v22, 5, s3
; GFX12-NEXT:    v_lshrrev_b16 v26, 2, s3
; GFX12-NEXT:    v_lshrrev_b16 v28, 3, s3
; GFX12-NEXT:    v_lshrrev_b16 v36, 1, s3
; GFX12-NEXT:    s_lshr_b32 s18, s3, 24
; GFX12-NEXT:    s_mov_b32 s4, s3
; GFX12-NEXT:    s_lshr_b32 s38, s2, 24
; GFX12-NEXT:    v_dual_mov_b32 v46, s10 :: v_dual_mov_b32 v49, s43
; GFX12-NEXT:    v_bfe_i32 v52, v5, 0, 1
; GFX12-NEXT:    v_bfe_i32 v50, v3, 0, 1
; GFX12-NEXT:    s_bfe_i64 s[2:3], s[2:3], 0x10000
; GFX12-NEXT:    v_mov_b32_e32 v48, s42
; GFX12-NEXT:    global_store_b128 v12, v[42:45], s[0:1] offset:144
; GFX12-NEXT:    v_bfe_i32 v44, v9, 0, 1
; GFX12-NEXT:    v_bfe_i32 v42, v7, 0, 1
; GFX12-NEXT:    v_lshrrev_b16 v41, 2, s18
; GFX12-NEXT:    global_store_b128 v12, v[46:49], s[0:1] offset:128
; GFX12-NEXT:    v_lshrrev_b16 v54, 3, s18
; GFX12-NEXT:    v_lshrrev_b16 v56, 6, s38
; GFX12-NEXT:    v_ashrrev_i32_e32 v53, 31, v52
; GFX12-NEXT:    v_ashrrev_i32_e32 v51, 31, v50
; GFX12-NEXT:    v_ashrrev_i32_e32 v45, 31, v44
; GFX12-NEXT:    v_ashrrev_i32_e32 v43, 31, v42
; GFX12-NEXT:    v_bfe_i32 v46, v56, 0, 1
; GFX12-NEXT:    v_bfe_i32 v56, v54, 0, 1
; GFX12-NEXT:    global_store_b128 v12, v[50:53], s[0:1] offset:112
; GFX12-NEXT:    v_bfe_i32 v34, v34, 0, 1
; GFX12-NEXT:    global_store_b128 v12, v[42:45], s[0:1] offset:96
; GFX12-NEXT:    v_bfe_i32 v32, v32, 0, 1
; GFX12-NEXT:    v_bfe_i32 v54, v41, 0, 1
; GFX12-NEXT:    v_bfe_i32 v43, v35, 0, 1
; GFX12-NEXT:    v_bfe_i32 v41, v33, 0, 1
; GFX12-NEXT:    v_lshrrev_b16 v39, 4, s18
; GFX12-NEXT:    v_ashrrev_i32_e32 v35, 31, v34
; GFX12-NEXT:    v_ashrrev_i32_e32 v33, 31, v32
; GFX12-NEXT:    v_ashrrev_i32_e32 v44, 31, v43
; GFX12-NEXT:    v_ashrrev_i32_e32 v42, 31, v41
; GFX12-NEXT:    v_lshrrev_b16 v40, 5, s18
; GFX12-NEXT:    v_lshrrev_b16 v37, 6, s18
; GFX12-NEXT:    global_store_b128 v12, v[32:35], s[0:1] offset:80
; GFX12-NEXT:    v_bfe_i32 v32, v39, 0, 1
; GFX12-NEXT:    global_store_b128 v12, v[41:44], s[0:1] offset:64
; GFX12-NEXT:    v_bfe_i32 v41, v29, 0, 1
; GFX12-NEXT:    v_bfe_i32 v39, v27, 0, 1
; GFX12-NEXT:    v_bfe_i32 v34, v40, 0, 1
; GFX12-NEXT:    v_bfe_i32 v60, v31, 0, 1
; GFX12-NEXT:    v_bfe_i32 v58, v30, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v42, 31, v41
; GFX12-NEXT:    v_ashrrev_i32_e32 v40, 31, v39
; GFX12-NEXT:    v_lshrrev_b16 v38, 7, s18
; GFX12-NEXT:    v_bfe_i32 v62, v37, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v61, 31, v60
; GFX12-NEXT:    v_ashrrev_i32_e32 v59, 31, v58
; GFX12-NEXT:    global_store_b128 v12, v[39:42], s[0:1] offset:48
; GFX12-NEXT:    v_bfe_i32 v39, v25, 0, 1
; GFX12-NEXT:    v_bfe_i32 v37, v24, 0, 1
; GFX12-NEXT:    v_bfe_i32 v64, v38, 0, 1
; GFX12-NEXT:    global_store_b128 v12, v[58:61], s[0:1] offset:32
; GFX12-NEXT:    v_bfe_i32 v43, v23, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v40, 31, v39
; GFX12-NEXT:    v_ashrrev_i32_e32 v38, 31, v37
; GFX12-NEXT:    s_bfe_i64 s[4:5], s[4:5], 0x10000
; GFX12-NEXT:    v_bfe_i32 v24, v36, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v44, 31, v43
; GFX12-NEXT:    v_dual_mov_b32 v41, s2 :: v_dual_mov_b32 v42, s3
; GFX12-NEXT:    v_mov_b32_e32 v23, s5
; GFX12-NEXT:    global_store_b128 v12, v[37:40], s[0:1] offset:16
; GFX12-NEXT:    v_bfe_i32 v38, v20, 0, 1
; GFX12-NEXT:    v_bfe_i32 v36, v18, 0, 1
; GFX12-NEXT:    global_store_b128 v12, v[41:44], s[0:1]
; GFX12-NEXT:    v_bfe_i32 v20, v19, 0, 1
; GFX12-NEXT:    v_bfe_i32 v18, v16, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v39, 31, v38
; GFX12-NEXT:    v_ashrrev_i32_e32 v37, 31, v36
; GFX12-NEXT:    v_lshrrev_b16 v55, 1, s18
; GFX12-NEXT:    v_bfe_i32 v40, v21, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v21, 31, v20
; GFX12-NEXT:    v_ashrrev_i32_e32 v19, 31, v18
; GFX12-NEXT:    v_lshrrev_b16 v9, 7, s38
; GFX12-NEXT:    v_lshrrev_b16 v4, 3, s38
; GFX12-NEXT:    v_lshrrev_b16 v8, 2, s38
; GFX12-NEXT:    v_lshrrev_b16 v10, 5, s38
; GFX12-NEXT:    v_lshrrev_b16 v11, 4, s38
; GFX12-NEXT:    v_lshrrev_b16 v2, 1, s38
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v12, v[36:39], s[0:1] offset:368
; GFX12-NEXT:    global_store_b128 v12, v[18:21], s[0:1] offset:352
; GFX12-NEXT:    v_bfe_i32 v38, v1, 0, 1
; GFX12-NEXT:    v_bfe_i32 v36, v0, 0, 1
; GFX12-NEXT:    v_bfe_i32 v52, v55, 0, 1
; GFX12-NEXT:    v_bfe_i32 v20, v15, 0, 1
; GFX12-NEXT:    v_bfe_i32 v18, v13, 0, 1
; GFX12-NEXT:    v_bfe_i32 v48, v9, 0, 1
; GFX12-NEXT:    v_bfe_i32 v16, v17, 0, 1
; GFX12-NEXT:    v_bfe_i32 v14, v14, 0, 1
; GFX12-NEXT:    v_bfe_i32 v6, v4, 0, 1
; GFX12-NEXT:    v_bfe_i32 v4, v8, 0, 1
; GFX12-NEXT:    v_bfe_i32 v10, v10, 0, 1
; GFX12-NEXT:    v_bfe_i32 v8, v11, 0, 1
; GFX12-NEXT:    v_bfe_i32 v42, v22, 0, 1
; GFX12-NEXT:    s_bfe_i64 s[8:9], s[18:19], 0x10000
; GFX12-NEXT:    v_bfe_i32 v28, v28, 0, 1
; GFX12-NEXT:    v_bfe_i32 v26, v26, 0, 1
; GFX12-NEXT:    v_bfe_i32 v2, v2, 0, 1
; GFX12-NEXT:    v_ashrrev_i32_e32 v57, 31, v56
; GFX12-NEXT:    v_ashrrev_i32_e32 v55, 31, v54
; GFX12-NEXT:    v_ashrrev_i32_e32 v65, 31, v64
; GFX12-NEXT:    v_ashrrev_i32_e32 v63, 31, v62
; GFX12-NEXT:    v_ashrrev_i32_e32 v39, 31, v38
; GFX12-NEXT:    v_ashrrev_i32_e32 v37, 31, v36
; GFX12-NEXT:    s_bfe_i64 s[6:7], s[38:39], 0x10000
; GFX12-NEXT:    v_ashrrev_i32_e32 v53, 31, v52
; GFX12-NEXT:    v_ashrrev_i32_e32 v35, 31, v34
; GFX12-NEXT:    v_ashrrev_i32_e32 v33, 31, v32
; GFX12-NEXT:    v_ashrrev_i32_e32 v21, 31, v20
; GFX12-NEXT:    v_ashrrev_i32_e32 v19, 31, v18
; GFX12-NEXT:    v_dual_mov_b32 v22, s4 :: v_dual_mov_b32 v51, s9
; GFX12-NEXT:    v_dual_mov_b32 v50, s8 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    v_ashrrev_i32_e32 v49, 31, v48
; GFX12-NEXT:    v_ashrrev_i32_e32 v47, 31, v46
; GFX12-NEXT:    v_ashrrev_i32_e32 v17, 31, v16
; GFX12-NEXT:    v_ashrrev_i32_e32 v15, 31, v14
; GFX12-NEXT:    v_ashrrev_i32_e32 v11, 31, v10
; GFX12-NEXT:    v_ashrrev_i32_e32 v9, 31, v8
; GFX12-NEXT:    v_ashrrev_i32_e32 v43, 31, v42
; GFX12-NEXT:    v_ashrrev_i32_e32 v41, 31, v40
; GFX12-NEXT:    v_ashrrev_i32_e32 v7, 31, v6
; GFX12-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX12-NEXT:    v_ashrrev_i32_e32 v29, 31, v28
; GFX12-NEXT:    v_ashrrev_i32_e32 v27, 31, v26
; GFX12-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; GFX12-NEXT:    v_ashrrev_i32_e32 v25, 31, v24
; GFX12-NEXT:    s_clause 0x7
; GFX12-NEXT:    global_store_b128 v12, v[36:39], s[0:1] offset:336
; GFX12-NEXT:    global_store_b128 v12, v[18:21], s[0:1] offset:320
; GFX12-NEXT:    global_store_b128 v12, v[14:17], s[0:1] offset:304
; GFX12-NEXT:    global_store_b128 v12, v[40:43], s[0:1] offset:288
; GFX12-NEXT:    global_store_b128 v12, v[26:29], s[0:1] offset:272
; GFX12-NEXT:    global_store_b128 v12, v[22:25], s[0:1] offset:256
; GFX12-NEXT:    global_store_b128 v12, v[62:65], s[0:1] offset:496
; GFX12-NEXT:    global_store_b128 v12, v[32:35], s[0:1] offset:480
; GFX12-NEXT:    v_mov_b32_e32 v0, s6
; GFX12-NEXT:    s_clause 0x5
; GFX12-NEXT:    global_store_b128 v12, v[54:57], s[0:1] offset:464
; GFX12-NEXT:    global_store_b128 v12, v[50:53], s[0:1] offset:448
; GFX12-NEXT:    global_store_b128 v12, v[46:49], s[0:1] offset:240
; GFX12-NEXT:    global_store_b128 v12, v[8:11], s[0:1] offset:224
; GFX12-NEXT:    global_store_b128 v12, v[4:7], s[0:1] offset:208
; GFX12-NEXT:    global_store_b128 v12, v[0:3], s[0:1] offset:192
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %load = load <64 x i1>, ptr addrspace(4) %in
  %ext = sext <64 x i1> %load to <64 x i64>
  store <64 x i64> %ext, ptr addrspace(1) %out
  ret void
}

attributes #0 = { nounwind }
