; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 3
; RUN: opt -disable-output -passes='print<access-info>' %s 2>&1 | FileCheck %s
; RUN: opt -disable-output -passes='print<access-info>' -max-forked-scev-depth=2 %s 2>&1 | FileCheck -check-prefix=RECURSE %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define void @forked_ptrs_simple(ptr nocapture readonly %Base1, ptr nocapture readonly %Base2, ptr %Dest) {
; CHECK-LABEL: 'forked_ptrs_simple'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP1:0x[0-9a-f]+]]):
; CHECK-NEXT:          %gep.Dest = getelementptr inbounds float, ptr %Dest, i64 %iv
; CHECK-NEXT:          %gep.Dest = getelementptr inbounds float, ptr %Dest, i64 %iv
; CHECK-NEXT:        Against group ([[GRP2:0x[0-9a-f]+]]):
; CHECK-NEXT:          %select = select i1 %cmp, ptr %gep.1, ptr %gep.2
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group ([[GRP1]]):
; CHECK-NEXT:          %gep.Dest = getelementptr inbounds float, ptr %Dest, i64 %iv
; CHECK-NEXT:          %gep.Dest = getelementptr inbounds float, ptr %Dest, i64 %iv
; CHECK-NEXT:        Against group ([[GRP3:0x[0-9a-f]+]]):
; CHECK-NEXT:          %select = select i1 %cmp, ptr %gep.1, ptr %gep.2
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP1]]:
; CHECK-NEXT:          (Low: %Dest High: (400 + %Dest))
; CHECK-NEXT:            Member: {%Dest,+,4}<nuw><%loop>
; CHECK-NEXT:            Member: {%Dest,+,4}<nuw><%loop>
; CHECK-NEXT:        Group [[GRP2]]:
; CHECK-NEXT:          (Low: %Base1 High: (400 + %Base1))
; CHECK-NEXT:            Member: {%Base1,+,4}<nw><%loop>
; CHECK-NEXT:        Group [[GRP3]]:
; CHECK-NEXT:          (Low: %Base2 High: (400 + %Base2))
; CHECK-NEXT:            Member: {%Base2,+,4}<nw><%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_simple'
; RECURSE-NEXT:    loop:
; RECURSE-NEXT:      Memory dependences are safe with run-time checks
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Check 0:
; RECURSE-NEXT:        Comparing group ([[GRP4:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %gep.Dest = getelementptr inbounds float, ptr %Dest, i64 %iv
; RECURSE-NEXT:          %gep.Dest = getelementptr inbounds float, ptr %Dest, i64 %iv
; RECURSE-NEXT:        Against group ([[GRP5:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %select = select i1 %cmp, ptr %gep.1, ptr %gep.2
; RECURSE-NEXT:      Check 1:
; RECURSE-NEXT:        Comparing group ([[GRP4]]):
; RECURSE-NEXT:          %gep.Dest = getelementptr inbounds float, ptr %Dest, i64 %iv
; RECURSE-NEXT:          %gep.Dest = getelementptr inbounds float, ptr %Dest, i64 %iv
; RECURSE-NEXT:        Against group ([[GRP6:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %select = select i1 %cmp, ptr %gep.1, ptr %gep.2
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-NEXT:        Group [[GRP4]]:
; RECURSE-NEXT:          (Low: %Dest High: (400 + %Dest))
; RECURSE-NEXT:            Member: {%Dest,+,4}<nuw><%loop>
; RECURSE-NEXT:            Member: {%Dest,+,4}<nuw><%loop>
; RECURSE-NEXT:        Group [[GRP5]]:
; RECURSE-NEXT:          (Low: %Base1 High: (400 + %Base1))
; RECURSE-NEXT:            Member: {%Base1,+,4}<nw><%loop>
; RECURSE-NEXT:        Group [[GRP6]]:
; RECURSE-NEXT:          (Low: %Base2 High: (400 + %Base2))
; RECURSE-NEXT:            Member: {%Base2,+,4}<nw><%loop>
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %gep.Dest = getelementptr inbounds float, ptr %Dest, i64 %iv
  %l.Dest = load float, ptr %gep.Dest
  %cmp = fcmp une float %l.Dest, 0.0
  %gep.1 = getelementptr inbounds float, ptr %Base1, i64 %iv
  %gep.2 = getelementptr inbounds float, ptr %Base2, i64 %iv
  %select = select i1 %cmp, ptr %gep.1, ptr %gep.2
  %sink = load float, ptr %select, align 4
  store float %sink, ptr %gep.Dest, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, 100
  br i1 %exitcond.not, label %exit, label %loop

exit:
  ret void
}

;; We have a limit on the recursion depth for finding a loop invariant or
;; addrec term; confirm we won't exceed that depth by forcing a lower
;; limit via -max-forked-scev-depth=2

;;;; Derived from the following C code
;; void forked_ptrs_different_base_same_offset(float *A, float *B, float *C, int *D) {
;;   for (int i=0; i<100; i++) {
;;     if (D[i] != 0) {
;;       C[i] = A[i];
;;     } else {
;;       C[i] = B[i];
;;     }
;;   }
;; }

define dso_local void @forked_ptrs_different_base_same_offset(ptr nocapture readonly nonnull %Base1, ptr nocapture readonly %Base2, ptr nocapture %Dest, ptr nocapture readonly %Preds) {
; CHECK-LABEL: 'forked_ptrs_different_base_same_offset'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP7:0x[0-9a-f]+]]):
; CHECK-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP8:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group ([[GRP7]]):
; CHECK-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP9:0x[0-9a-f]+]]):
; CHECK-NEXT:          %.sink.in = getelementptr inbounds float, ptr %spec.select, i64 %indvars.iv
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group ([[GRP7]]):
; CHECK-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP10:0x[0-9a-f]+]]):
; CHECK-NEXT:          %.sink.in = getelementptr inbounds float, ptr %spec.select, i64 %indvars.iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP7]]:
; CHECK-NEXT:          (Low: %Dest High: (400 + %Dest))
; CHECK-NEXT:            Member: {%Dest,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP8]]:
; CHECK-NEXT:          (Low: %Preds High: (400 + %Preds))
; CHECK-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP9]]:
; CHECK-NEXT:          (Low: %Base2 High: (400 + %Base2))
; CHECK-NEXT:            Member: {%Base2,+,4}<nw><%for.body>
; CHECK-NEXT:        Group [[GRP10]]:
; CHECK-NEXT:          (Low: %Base1 High: (400 + %Base1))
; CHECK-NEXT:            Member: {%Base1,+,4}<nw><%for.body>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_different_base_same_offset'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Memory dependences are safe with run-time checks
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Check 0:
; RECURSE-NEXT:        Comparing group ([[GRP11:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP12:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; RECURSE-NEXT:      Check 1:
; RECURSE-NEXT:        Comparing group ([[GRP11]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP13:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %.sink.in = getelementptr inbounds float, ptr %spec.select, i64 %indvars.iv
; RECURSE-NEXT:      Check 2:
; RECURSE-NEXT:        Comparing group ([[GRP11]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP14:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %.sink.in = getelementptr inbounds float, ptr %spec.select, i64 %indvars.iv
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-NEXT:        Group [[GRP11]]:
; RECURSE-NEXT:          (Low: %Dest High: (400 + %Dest))
; RECURSE-NEXT:            Member: {%Dest,+,4}<nuw><%for.body>
; RECURSE-NEXT:        Group [[GRP12]]:
; RECURSE-NEXT:          (Low: %Preds High: (400 + %Preds))
; RECURSE-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; RECURSE-NEXT:        Group [[GRP13]]:
; RECURSE-NEXT:          (Low: %Base2 High: (400 + %Base2))
; RECURSE-NEXT:            Member: {%Base2,+,4}<nw><%for.body>
; RECURSE-NEXT:        Group [[GRP14]]:
; RECURSE-NEXT:          (Low: %Base1 High: (400 + %Base1))
; RECURSE-NEXT:            Member: {%Base1,+,4}<nw><%for.body>
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:
  ret void

for.body:
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp1.not = icmp eq i32 %0, 0
  %spec.select = select i1 %cmp1.not, ptr %Base2, ptr %Base1
  %.sink.in = getelementptr inbounds float, ptr %spec.select, i64 %indvars.iv
  %.sink = load float, ptr %.sink.in, align 4
  %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
  store float %.sink, ptr %1, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

define dso_local void @forked_ptrs_different_base_same_offset_64b(ptr nocapture readonly nonnull %Base1, ptr nocapture readonly %Base2, ptr nocapture %Dest, ptr nocapture readonly %Preds) {
; CHECK-LABEL: 'forked_ptrs_different_base_same_offset_64b'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP15:0x[0-9a-f]+]]):
; CHECK-NEXT:          %1 = getelementptr inbounds double, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP16:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group ([[GRP15]]):
; CHECK-NEXT:          %1 = getelementptr inbounds double, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP17:0x[0-9a-f]+]]):
; CHECK-NEXT:          %.sink.in = getelementptr inbounds double, ptr %spec.select, i64 %indvars.iv
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group ([[GRP15]]):
; CHECK-NEXT:          %1 = getelementptr inbounds double, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP18:0x[0-9a-f]+]]):
; CHECK-NEXT:          %.sink.in = getelementptr inbounds double, ptr %spec.select, i64 %indvars.iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP15]]:
; CHECK-NEXT:          (Low: %Dest High: (800 + %Dest))
; CHECK-NEXT:            Member: {%Dest,+,8}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP16]]:
; CHECK-NEXT:          (Low: %Preds High: (400 + %Preds))
; CHECK-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP17]]:
; CHECK-NEXT:          (Low: %Base2 High: (800 + %Base2))
; CHECK-NEXT:            Member: {%Base2,+,8}<nw><%for.body>
; CHECK-NEXT:        Group [[GRP18]]:
; CHECK-NEXT:          (Low: %Base1 High: (800 + %Base1))
; CHECK-NEXT:            Member: {%Base1,+,8}<nw><%for.body>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_different_base_same_offset_64b'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Memory dependences are safe with run-time checks
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Check 0:
; RECURSE-NEXT:        Comparing group ([[GRP19:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds double, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP20:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; RECURSE-NEXT:      Check 1:
; RECURSE-NEXT:        Comparing group ([[GRP19]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds double, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP21:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %.sink.in = getelementptr inbounds double, ptr %spec.select, i64 %indvars.iv
; RECURSE-NEXT:      Check 2:
; RECURSE-NEXT:        Comparing group ([[GRP19]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds double, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP22:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %.sink.in = getelementptr inbounds double, ptr %spec.select, i64 %indvars.iv
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-NEXT:        Group [[GRP19]]:
; RECURSE-NEXT:          (Low: %Dest High: (800 + %Dest))
; RECURSE-NEXT:            Member: {%Dest,+,8}<nuw><%for.body>
; RECURSE-NEXT:        Group [[GRP20]]:
; RECURSE-NEXT:          (Low: %Preds High: (400 + %Preds))
; RECURSE-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; RECURSE-NEXT:        Group [[GRP21]]:
; RECURSE-NEXT:          (Low: %Base2 High: (800 + %Base2))
; RECURSE-NEXT:            Member: {%Base2,+,8}<nw><%for.body>
; RECURSE-NEXT:        Group [[GRP22]]:
; RECURSE-NEXT:          (Low: %Base1 High: (800 + %Base1))
; RECURSE-NEXT:            Member: {%Base1,+,8}<nw><%for.body>
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:
  ret void

for.body:
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp1.not = icmp eq i32 %0, 0
  %spec.select = select i1 %cmp1.not, ptr %Base2, ptr %Base1
  %.sink.in = getelementptr inbounds double, ptr %spec.select, i64 %indvars.iv
  %.sink = load double, ptr %.sink.in, align 8
  %1 = getelementptr inbounds double, ptr %Dest, i64 %indvars.iv
  store double %.sink, ptr %1, align 8
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

define dso_local void @forked_ptrs_different_base_same_offset_23b(ptr nocapture readonly nonnull %Base1, ptr nocapture readonly %Base2, ptr nocapture %Dest, ptr nocapture readonly %Preds) {
; CHECK-LABEL: 'forked_ptrs_different_base_same_offset_23b'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP23:0x[0-9a-f]+]]):
; CHECK-NEXT:          %1 = getelementptr inbounds i23, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP24:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group ([[GRP23]]):
; CHECK-NEXT:          %1 = getelementptr inbounds i23, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP25:0x[0-9a-f]+]]):
; CHECK-NEXT:          %.sink.in = getelementptr inbounds i23, ptr %spec.select, i64 %indvars.iv
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group ([[GRP23]]):
; CHECK-NEXT:          %1 = getelementptr inbounds i23, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP26:0x[0-9a-f]+]]):
; CHECK-NEXT:          %.sink.in = getelementptr inbounds i23, ptr %spec.select, i64 %indvars.iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP23]]:
; CHECK-NEXT:          (Low: %Dest High: (399 + %Dest))
; CHECK-NEXT:            Member: {%Dest,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP24]]:
; CHECK-NEXT:          (Low: %Preds High: (400 + %Preds))
; CHECK-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP25]]:
; CHECK-NEXT:          (Low: %Base2 High: (399 + %Base2))
; CHECK-NEXT:            Member: {%Base2,+,4}<nw><%for.body>
; CHECK-NEXT:        Group [[GRP26]]:
; CHECK-NEXT:          (Low: %Base1 High: (399 + %Base1))
; CHECK-NEXT:            Member: {%Base1,+,4}<nw><%for.body>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_different_base_same_offset_23b'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Memory dependences are safe with run-time checks
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Check 0:
; RECURSE-NEXT:        Comparing group ([[GRP27:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds i23, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP28:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; RECURSE-NEXT:      Check 1:
; RECURSE-NEXT:        Comparing group ([[GRP27]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds i23, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP29:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %.sink.in = getelementptr inbounds i23, ptr %spec.select, i64 %indvars.iv
; RECURSE-NEXT:      Check 2:
; RECURSE-NEXT:        Comparing group ([[GRP27]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds i23, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP30:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %.sink.in = getelementptr inbounds i23, ptr %spec.select, i64 %indvars.iv
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-NEXT:        Group [[GRP27]]:
; RECURSE-NEXT:          (Low: %Dest High: (399 + %Dest))
; RECURSE-NEXT:            Member: {%Dest,+,4}<nuw><%for.body>
; RECURSE-NEXT:        Group [[GRP28]]:
; RECURSE-NEXT:          (Low: %Preds High: (400 + %Preds))
; RECURSE-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; RECURSE-NEXT:        Group [[GRP29]]:
; RECURSE-NEXT:          (Low: %Base2 High: (399 + %Base2))
; RECURSE-NEXT:            Member: {%Base2,+,4}<nw><%for.body>
; RECURSE-NEXT:        Group [[GRP30]]:
; RECURSE-NEXT:          (Low: %Base1 High: (399 + %Base1))
; RECURSE-NEXT:            Member: {%Base1,+,4}<nw><%for.body>
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:
  ret void

for.body:
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp1.not = icmp eq i32 %0, 0
  %spec.select = select i1 %cmp1.not, ptr %Base2, ptr %Base1
  %.sink.in = getelementptr inbounds i23, ptr %spec.select, i64 %indvars.iv
  %.sink = load i23, ptr %.sink.in
  %1 = getelementptr inbounds i23, ptr %Dest, i64 %indvars.iv
  store i23 %.sink, ptr %1
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

define dso_local void @forked_ptrs_different_base_same_offset_6b(ptr nocapture readonly nonnull %Base1, ptr nocapture readonly %Base2, ptr nocapture %Dest, ptr nocapture readonly %Preds) {
; CHECK-LABEL: 'forked_ptrs_different_base_same_offset_6b'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP31:0x[0-9a-f]+]]):
; CHECK-NEXT:          %1 = getelementptr inbounds i6, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP32:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group ([[GRP31]]):
; CHECK-NEXT:          %1 = getelementptr inbounds i6, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP33:0x[0-9a-f]+]]):
; CHECK-NEXT:          %.sink.in = getelementptr inbounds i6, ptr %spec.select, i64 %indvars.iv
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group ([[GRP31]]):
; CHECK-NEXT:          %1 = getelementptr inbounds i6, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP34:0x[0-9a-f]+]]):
; CHECK-NEXT:          %.sink.in = getelementptr inbounds i6, ptr %spec.select, i64 %indvars.iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP31]]:
; CHECK-NEXT:          (Low: %Dest High: (100 + %Dest))
; CHECK-NEXT:            Member: {%Dest,+,1}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP32]]:
; CHECK-NEXT:          (Low: %Preds High: (400 + %Preds))
; CHECK-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP33]]:
; CHECK-NEXT:          (Low: %Base2 High: (100 + %Base2))
; CHECK-NEXT:            Member: {%Base2,+,1}<nw><%for.body>
; CHECK-NEXT:        Group [[GRP34]]:
; CHECK-NEXT:          (Low: %Base1 High: (100 + %Base1))
; CHECK-NEXT:            Member: {%Base1,+,1}<nw><%for.body>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_different_base_same_offset_6b'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Memory dependences are safe with run-time checks
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Check 0:
; RECURSE-NEXT:        Comparing group ([[GRP35:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds i6, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP36:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; RECURSE-NEXT:      Check 1:
; RECURSE-NEXT:        Comparing group ([[GRP35]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds i6, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP37:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %.sink.in = getelementptr inbounds i6, ptr %spec.select, i64 %indvars.iv
; RECURSE-NEXT:      Check 2:
; RECURSE-NEXT:        Comparing group ([[GRP35]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds i6, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP38:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %.sink.in = getelementptr inbounds i6, ptr %spec.select, i64 %indvars.iv
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-NEXT:        Group [[GRP35]]:
; RECURSE-NEXT:          (Low: %Dest High: (100 + %Dest))
; RECURSE-NEXT:            Member: {%Dest,+,1}<nuw><%for.body>
; RECURSE-NEXT:        Group [[GRP36]]:
; RECURSE-NEXT:          (Low: %Preds High: (400 + %Preds))
; RECURSE-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; RECURSE-NEXT:        Group [[GRP37]]:
; RECURSE-NEXT:          (Low: %Base2 High: (100 + %Base2))
; RECURSE-NEXT:            Member: {%Base2,+,1}<nw><%for.body>
; RECURSE-NEXT:        Group [[GRP38]]:
; RECURSE-NEXT:          (Low: %Base1 High: (100 + %Base1))
; RECURSE-NEXT:            Member: {%Base1,+,1}<nw><%for.body>
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:
  ret void

for.body:
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp1.not = icmp eq i32 %0, 0
  %spec.select = select i1 %cmp1.not, ptr %Base2, ptr %Base1
  %.sink.in = getelementptr inbounds i6, ptr %spec.select, i64 %indvars.iv
  %.sink = load i6, ptr %.sink.in
  %1 = getelementptr inbounds i6, ptr %Dest, i64 %indvars.iv
  store i6 %.sink, ptr %1
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

define dso_local void @forked_ptrs_different_base_same_offset_possible_poison(ptr nocapture readonly %Base1, ptr nocapture readonly %Base2, ptr nocapture %Dest, ptr nocapture readonly %Preds, i1 %c) {
; CHECK-LABEL: 'forked_ptrs_different_base_same_offset_possible_poison'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP39:0x[0-9a-f]+]]):
; CHECK-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP40:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group ([[GRP39]]):
; CHECK-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP41:0x[0-9a-f]+]]):
; CHECK-NEXT:          %.sink.in = getelementptr inbounds float, ptr %spec.select, i64 %indvars.iv
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group ([[GRP39]]):
; CHECK-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP42:0x[0-9a-f]+]]):
; CHECK-NEXT:          %.sink.in = getelementptr inbounds float, ptr %spec.select, i64 %indvars.iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP39]]:
; CHECK-NEXT:          (Low: %Dest High: (400 + %Dest))
; CHECK-NEXT:            Member: {%Dest,+,4}<nw><%for.body>
; CHECK-NEXT:        Group [[GRP40]]:
; CHECK-NEXT:          (Low: %Preds High: (400 + %Preds))
; CHECK-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP41]]:
; CHECK-NEXT:          (Low: %Base2 High: (400 + %Base2))
; CHECK-NEXT:            Member: {%Base2,+,4}<nw><%for.body>
; CHECK-NEXT:        Group [[GRP42]]:
; CHECK-NEXT:          (Low: %Base1 High: (400 + %Base1))
; CHECK-NEXT:            Member: {%Base1,+,4}<nw><%for.body>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_different_base_same_offset_possible_poison'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Memory dependences are safe with run-time checks
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Check 0:
; RECURSE-NEXT:        Comparing group ([[GRP43:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP44:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; RECURSE-NEXT:      Check 1:
; RECURSE-NEXT:        Comparing group ([[GRP43]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP45:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %.sink.in = getelementptr inbounds float, ptr %spec.select, i64 %indvars.iv
; RECURSE-NEXT:      Check 2:
; RECURSE-NEXT:        Comparing group ([[GRP43]]):
; RECURSE-NEXT:          %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP46:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %.sink.in = getelementptr inbounds float, ptr %spec.select, i64 %indvars.iv
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-NEXT:        Group [[GRP43]]:
; RECURSE-NEXT:          (Low: %Dest High: (400 + %Dest))
; RECURSE-NEXT:            Member: {%Dest,+,4}<nw><%for.body>
; RECURSE-NEXT:        Group [[GRP44]]:
; RECURSE-NEXT:          (Low: %Preds High: (400 + %Preds))
; RECURSE-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; RECURSE-NEXT:        Group [[GRP45]]:
; RECURSE-NEXT:          (Low: %Base2 High: (400 + %Base2))
; RECURSE-NEXT:            Member: {%Base2,+,4}<nw><%for.body>
; RECURSE-NEXT:        Group [[GRP46]]:
; RECURSE-NEXT:          (Low: %Base1 High: (400 + %Base1))
; RECURSE-NEXT:            Member: {%Base1,+,4}<nw><%for.body>
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:
  ret void

for.body:
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %latch ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp1.not = icmp eq i32 %0, 0
  %spec.select = select i1 %cmp1.not, ptr %Base2, ptr %Base1
  %.sink.in = getelementptr inbounds float, ptr %spec.select, i64 %indvars.iv
  %.sink = load float, ptr %.sink.in, align 4
  %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
  br i1 %c, label %then, label %latch

then:
  store float %.sink, ptr %1, align 4
  br label %latch

latch:
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

;;;; Derived from the following C code
;; void forked_ptrs_same_base_different_offset(float *A, float *B, int *C) {
;;   int offset;
;;   for (int i = 0; i < 100; i++) {
;;     if (C[i] != 0)
;;       offset = i;
;;     else
;;       offset = i+1;
;;     B[i] = A[offset];
;;   }
;; }

define dso_local void @forked_ptrs_same_base_different_offset(ptr nocapture readonly %Base, ptr nocapture %Dest, ptr nocapture readonly %Preds) {
; CHECK-LABEL: 'forked_ptrs_same_base_different_offset'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Report: cannot identify array bounds
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_same_base_different_offset'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body
  ret void

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %i.014 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp1.not = icmp eq i32 %0, 0
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %add = add nuw nsw i32 %i.014, 1
  %1 = trunc i64 %indvars.iv to i32
  %offset.0 = select i1 %cmp1.not, i32 %add, i32 %1
  %idxprom213 = zext i32 %offset.0 to i64
  %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %idxprom213
  %2 = load float, ptr %arrayidx3, align 4
  %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
  store float %2, ptr %arrayidx5, align 4
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

define dso_local void @forked_ptrs_add_to_offset(ptr nocapture readonly %Base, ptr nocapture %Dest, ptr nocapture readonly %Preds, i64 %extra_offset) {
; CHECK-LABEL: 'forked_ptrs_add_to_offset'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP47:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP48:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group ([[GRP47]]):
; CHECK-NEXT:          %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP49:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %offset
; CHECK-NEXT:          %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %offset
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP47]]:
; CHECK-NEXT:          (Low: %Dest High: (400 + %Dest))
; CHECK-NEXT:            Member: {%Dest,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP48]]:
; CHECK-NEXT:          (Low: %Preds High: (400 + %Preds))
; CHECK-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP49]]:
; CHECK-NEXT:          (Low: ((4 * %extra_offset) + %Base) High: (404 + (4 * %extra_offset) + %Base))
; CHECK-NEXT:            Member: {(4 + (4 * %extra_offset) + %Base),+,4}<%for.body>
; CHECK-NEXT:            Member: {((4 * %extra_offset) + %Base),+,4}<%for.body>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_add_to_offset'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body
  ret void

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp.not = icmp eq i32 %0, 0
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %sel = select i1 %cmp.not, i64 %indvars.iv.next, i64 %indvars.iv
  %offset = add nuw nsw i64 %sel, %extra_offset
  %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %offset
  %1 = load float, ptr %arrayidx3, align 4
  %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
  store float %1, ptr %arrayidx5, align 4
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

define dso_local void @forked_ptrs_sub_from_offset(ptr nocapture readonly %Base, ptr nocapture %Dest, ptr nocapture readonly %Preds, i64 %extra_offset) {
; CHECK-LABEL: 'forked_ptrs_sub_from_offset'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP50:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP51:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group ([[GRP50]]):
; CHECK-NEXT:          %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP52:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %offset
; CHECK-NEXT:          %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %offset
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP50]]:
; CHECK-NEXT:          (Low: %Dest High: (400 + %Dest))
; CHECK-NEXT:            Member: {%Dest,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP51]]:
; CHECK-NEXT:          (Low: %Preds High: (400 + %Preds))
; CHECK-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP52]]:
; CHECK-NEXT:          (Low: ((-4 * %extra_offset) + %Base) High: (404 + (-4 * %extra_offset) + %Base))
; CHECK-NEXT:            Member: {(4 + (-4 * %extra_offset) + %Base),+,4}<%for.body>
; CHECK-NEXT:            Member: {((-4 * %extra_offset) + %Base),+,4}<%for.body>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_sub_from_offset'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body
  ret void

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp.not = icmp eq i32 %0, 0
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %sel = select i1 %cmp.not, i64 %indvars.iv.next, i64 %indvars.iv
  %offset = sub nuw nsw i64 %sel, %extra_offset
  %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %offset
  %1 = load float, ptr %arrayidx3, align 4
  %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
  store float %1, ptr %arrayidx5, align 4
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

define dso_local void @forked_ptrs_add_sub_offset(ptr nocapture readonly %Base, ptr nocapture %Dest, ptr nocapture readonly %Preds, i64 %to_add, i64 %to_sub) {
; CHECK-LABEL: 'forked_ptrs_add_sub_offset'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP53:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP54:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group ([[GRP53]]):
; CHECK-NEXT:          %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP55:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %offset
; CHECK-NEXT:          %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %offset
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP53]]:
; CHECK-NEXT:          (Low: %Dest High: (400 + %Dest))
; CHECK-NEXT:            Member: {%Dest,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP54]]:
; CHECK-NEXT:          (Low: %Preds High: (400 + %Preds))
; CHECK-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP55]]:
; CHECK-NEXT:          (Low: ((4 * %to_add) + (-4 * %to_sub) + %Base) High: (404 + (4 * %to_add) + (-4 * %to_sub) + %Base))
; CHECK-NEXT:            Member: {(4 + (4 * %to_add) + (-4 * %to_sub) + %Base),+,4}<%for.body>
; CHECK-NEXT:            Member: {((4 * %to_add) + (-4 * %to_sub) + %Base),+,4}<%for.body>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_add_sub_offset'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body
  ret void

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp.not = icmp eq i32 %0, 0
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %sel = select i1 %cmp.not, i64 %indvars.iv.next, i64 %indvars.iv
  %add = add nuw nsw i64 %sel, %to_add
  %offset = sub nuw nsw i64 %add, %to_sub
  %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %offset
  %1 = load float, ptr %arrayidx3, align 4
  %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
  store float %1, ptr %arrayidx5, align 4
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

;;;; Cases that can be handled by a forked pointer but are not currently allowed.

define dso_local void @forked_ptrs_mul_by_offset(ptr nocapture readonly %Base, ptr nocapture %Dest, ptr nocapture readonly %Preds, i64 %extra_offset) {
; CHECK-LABEL: 'forked_ptrs_mul_by_offset'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Report: cannot identify array bounds
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_mul_by_offset'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body
  ret void

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp.not = icmp eq i32 %0, 0
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %sel = select i1 %cmp.not, i64 %indvars.iv.next, i64 %indvars.iv
  %offset = mul nuw nsw i64 %sel, %extra_offset
  %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %offset
  %1 = load float, ptr %arrayidx3, align 4
  %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
  store float %1, ptr %arrayidx5, align 4
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

;;;; Derived from forked_ptrs_same_base_different_offset with a manually
;;;; added uniform offset and a mul to provide a stride

define dso_local void @forked_ptrs_uniform_and_strided_forks(float* nocapture readonly %Base, float* nocapture %Dest, i32* nocapture readonly %Preds) {
; CHECK-LABEL: 'forked_ptrs_uniform_and_strided_forks'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Report: cannot identify array bounds
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_uniform_and_strided_forks'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body
  ret void

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %i.014 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp1.not = icmp eq i32 %0, 0
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %add = add nuw nsw i32 %i.014, 1
  %1 = trunc i64 %indvars.iv to i32
  %mul = mul i32 %1, 3
  %offset.0 = select i1 %cmp1.not, i32 4, i32 %mul
  %idxprom213 = sext i32 %offset.0 to i64
  %arrayidx3 = getelementptr inbounds float, ptr %Base, i64 %idxprom213
  %2 = load float, ptr %arrayidx3, align 4
  %arrayidx5 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
  store float %2, ptr %arrayidx5, align 4
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

;;;; Derived from forked_ptrs_same_base_different_offset with a gather
;;;; added using Preds as an index array in addition to the per-iteration
;;;; condition.

define dso_local void @forked_ptrs_gather_and_contiguous_forks(ptr nocapture readonly %Base1, ptr nocapture readonly %Base2, ptr nocapture %Dest, ptr nocapture readonly %Preds) {
; CHECK-LABEL: 'forked_ptrs_gather_and_contiguous_forks'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Report: cannot identify array bounds
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_gather_and_contiguous_forks'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body
  ret void

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp1.not = icmp eq i32 %0, 0
  %arrayidx9 = getelementptr inbounds float, ptr %Base2, i64 %indvars.iv
  %idxprom4 = sext i32 %0 to i64
  %arrayidx5 = getelementptr inbounds float, ptr %Base1, i64 %idxprom4
  %.sink.in = select i1 %cmp1.not, ptr %arrayidx9, ptr %arrayidx5
  %.sink = load float, ptr %.sink.in, align 4
  %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
  store float %.sink, ptr %1, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

;; We don't currently handle a fork in both the base and the offset of a
;; GEP instruction.

define dso_local void @forked_ptrs_two_forks_gep(ptr nocapture readonly %Base1, ptr nocapture readonly %Base2, ptr nocapture %Dest, ptr nocapture readonly %Preds) {
; CHECK-LABEL: 'forked_ptrs_two_forks_gep'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Report: cannot identify array bounds
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_two_forks_gep'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.cond.cleanup:
  ret void

for.body:
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, i32* %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp1.not = icmp eq i32 %0, 0
  %spec.select = select i1 %cmp1.not, ptr %Base2, ptr %Base1
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %offset = select i1 %cmp1.not, i64 %indvars.iv.next, i64 %indvars.iv
  %.sink.in = getelementptr inbounds float, ptr %spec.select, i64 %offset
  %.sink = load float, ptr %.sink.in, align 4
  %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
  store float %.sink, ptr %1, align 4
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

;; We don't handle forks as children of a select

define void @forked_ptrs_two_select(ptr nocapture readonly %Base1, ptr nocapture readonly %Base2, ptr nocapture readonly %Base3, ptr %Dest) {
; CHECK-LABEL: 'forked_ptrs_two_select'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Report: cannot identify array bounds
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_two_select'
; RECURSE-NEXT:    loop:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %gep.Dest = getelementptr inbounds float, ptr %Dest, i64 %iv
  %l.Dest = load float, ptr %gep.Dest
  %cmp = fcmp une float %l.Dest, 0.0
  %cmp1 = fcmp une float %l.Dest, 1.0
  %gep.1 = getelementptr inbounds float, ptr %Base1, i64 %iv
  %gep.2 = getelementptr inbounds float, ptr %Base2, i64 %iv
  %gep.3 = getelementptr inbounds float, ptr %Base3, i64 %iv
  %select = select i1 %cmp, ptr %gep.1, ptr %gep.2
  %select1 = select i1 %cmp1, ptr %select, ptr %gep.3
  %sink = load float, ptr %select1, align 4
  store float %sink, ptr %gep.Dest, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, 100
  br i1 %exitcond.not, label %exit, label %loop

exit:
  ret void
}

;; We don't yet handle geps with more than 2 operands

define void @forked_ptrs_too_many_gep_ops(ptr nocapture readonly %Base1, ptr nocapture readonly %Base2, ptr nocapture %Dest, ptr nocapture readonly %Preds) {
; CHECK-LABEL: 'forked_ptrs_too_many_gep_ops'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Report: cannot identify array bounds
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_too_many_gep_ops'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.body:
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp1.not = icmp eq i32 %0, 0
  %spec.select = select i1 %cmp1.not, ptr %Base2, ptr %Base1
  %.sink.in = getelementptr inbounds [1000 x float], ptr %spec.select, i64 0, i64 %indvars.iv
  %.sink = load float, ptr %.sink.in, align 4
  %1 = getelementptr inbounds float, ptr %Dest, i64 %indvars.iv
  store float %.sink, ptr %1, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body

for.cond.cleanup:
  ret void
}

;; We don't currently handle vector GEPs

define void @forked_ptrs_vector_gep(ptr nocapture readonly %Base1, ptr nocapture readonly %Base2, ptr nocapture %Dest, ptr nocapture readonly %Preds) {
; CHECK-LABEL: 'forked_ptrs_vector_gep'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Report: cannot identify array bounds
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_vector_gep'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  br label %for.body

for.body:
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %cmp1.not = icmp eq i32 %0, 0
  %spec.select = select i1 %cmp1.not, ptr %Base2, ptr %Base1
  %.sink.in = getelementptr inbounds <4 x float>, ptr %spec.select, i64 %indvars.iv
  %.sink = load <4 x float>, ptr %.sink.in, align 4
  %1 = getelementptr inbounds <4 x float>, ptr %Dest, i64 %indvars.iv
  store <4 x float> %.sink, ptr %1, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 4
  %exitcond.not = icmp eq i64 %indvars.iv.next, 100
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body

for.cond.cleanup:
  ret void
}

;;; The following test caused an ICE with the initial forked pointers work.
;;; One fork is loop invariant (%Base2 + 0), the other is an scAddExpr that
;;; contains an scAddRecExpr inside it:
;;;   ((8 * (zext i32 {0,+,1}<%for.body> to i64))<nuw><nsw> + %Base2)<nuw>
;;;
;;; RtCheck::insert was expecting either loop invariant or SAR, so asserted
;;; on a plain scAddExpr. For now we restrict to loop invariant or SAR
;;; forks only, but we should be able to do better.

define void @sc_add_expr_ice(ptr %Base1, ptr %Base2, i64 %N) {
; CHECK-LABEL: 'sc_add_expr_ice'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP56:0x[0-9a-f]+]]):
; CHECK-NEXT:        ptr %Base1
; CHECK-NEXT:        Against group ([[GRP57:0x[0-9a-f]+]]):
; CHECK-NEXT:          %fptr = getelementptr inbounds double, ptr %Base2, i64 %sel
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP56]]:
; CHECK-NEXT:          (Low: %Base1 High: (8 + %Base1))
; CHECK-NEXT:            Member: %Base1
; CHECK-NEXT:        Group [[GRP57]]:
; CHECK-NEXT:          (Low: %Base2 High: ((8 * %N) + %Base2))
; CHECK-NEXT:            Member: {%Base2,+,8}<%for.body>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-NEXT:      {0,+,1}<%for.body> Added Flags: <nusw>
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
; CHECK-NEXT:      [PSE] %fptr = getelementptr inbounds double, ptr %Base2, i64 %sel:
; CHECK-NEXT:        ((8 * (zext i32 {0,+,1}<%for.body> to i64))<nuw><nsw> + %Base2)<nuw>
; CHECK-NEXT:        --> {%Base2,+,8}<%for.body>
;
; RECURSE-LABEL: 'sc_add_expr_ice'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Memory dependences are safe with run-time checks
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Check 0:
; RECURSE-NEXT:        Comparing group ([[GRP58:0x[0-9a-f]+]]):
; RECURSE-NEXT:        ptr %Base1
; RECURSE-NEXT:        Against group ([[GRP59:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %fptr = getelementptr inbounds double, ptr %Base2, i64 %sel
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-NEXT:        Group [[GRP58]]:
; RECURSE-NEXT:          (Low: %Base1 High: (8 + %Base1))
; RECURSE-NEXT:            Member: %Base1
; RECURSE-NEXT:        Group [[GRP59]]:
; RECURSE-NEXT:          (Low: %Base2 High: ((8 * %N) + %Base2))
; RECURSE-NEXT:            Member: {%Base2,+,8}<%for.body>
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-NEXT:      {0,+,1}<%for.body> Added Flags: <nusw>
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
; RECURSE-NEXT:      [PSE] %fptr = getelementptr inbounds double, ptr %Base2, i64 %sel:
; RECURSE-NEXT:        ((8 * (zext i32 {0,+,1}<%for.body> to i64))<nuw><nsw> + %Base2)<nuw>
; RECURSE-NEXT:        --> {%Base2,+,8}<%for.body>
;
entry:
  br label %for.body

for.body:
  %iv = phi i64 [ %iv.next, %for.body ], [ 0, %entry ]
  %iv.trunc = trunc i64 %iv to i32
  store double 0.000000e+00, ptr %Base1, align 8
  %iv.zext = zext i32 %iv.trunc to i64
  %sel = select i1 true, i64 %iv.zext, i64 0
  %fptr = getelementptr inbounds double, ptr %Base2, i64 %sel
  %dummy.load = load double, ptr %fptr, align 8
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond = icmp eq i64 %iv.next, %N
  br i1 %exitcond, label %exit, label %for.body

exit:
  ret void
}

define void @forked_ptrs_with_different_base(ptr nocapture readonly %Preds, ptr nocapture %a, ptr nocapture %b, ptr nocapture readonly %c)  {
; CHECK-LABEL: 'forked_ptrs_with_different_base'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP60:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx7 = getelementptr inbounds double, ptr %.sink, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP61:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group ([[GRP60]]):
; CHECK-NEXT:          %arrayidx7 = getelementptr inbounds double, ptr %.sink, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP62:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx5 = getelementptr inbounds double, ptr %0, i64 %indvars.iv
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group ([[GRP63:0x[0-9a-f]+]]):
; CHECK-NEXT:          %arrayidx7 = getelementptr inbounds double, ptr %.sink, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP61]]):
; CHECK-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; CHECK-NEXT:      Check 3:
; CHECK-NEXT:        Comparing group ([[GRP63]]):
; CHECK-NEXT:          %arrayidx7 = getelementptr inbounds double, ptr %.sink, i64 %indvars.iv
; CHECK-NEXT:        Against group ([[GRP62]]):
; CHECK-NEXT:          %arrayidx5 = getelementptr inbounds double, ptr %0, i64 %indvars.iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP60]]:
; CHECK-NEXT:          (Low: %1 High: (63992 + %1))
; CHECK-NEXT:            Member: {%1,+,8}<nw><%for.body>
; CHECK-NEXT:        Group [[GRP63]]:
; CHECK-NEXT:          (Low: %2 High: (63992 + %2))
; CHECK-NEXT:            Member: {%2,+,8}<nw><%for.body>
; CHECK-NEXT:        Group [[GRP61]]:
; CHECK-NEXT:          (Low: %Preds High: (31996 + %Preds))
; CHECK-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; CHECK-NEXT:        Group [[GRP62]]:
; CHECK-NEXT:          (Low: %0 High: (63992 + %0))
; CHECK-NEXT:            Member: {%0,+,8}<nw><%for.body>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_with_different_base'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Memory dependences are safe with run-time checks
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Check 0:
; RECURSE-NEXT:        Comparing group ([[GRP64:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %arrayidx7 = getelementptr inbounds double, ptr %.sink, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP65:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; RECURSE-NEXT:      Check 1:
; RECURSE-NEXT:        Comparing group ([[GRP64]]):
; RECURSE-NEXT:          %arrayidx7 = getelementptr inbounds double, ptr %.sink, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP66:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %arrayidx5 = getelementptr inbounds double, ptr %0, i64 %indvars.iv
; RECURSE-NEXT:      Check 2:
; RECURSE-NEXT:        Comparing group ([[GRP67:0x[0-9a-f]+]]):
; RECURSE-NEXT:          %arrayidx7 = getelementptr inbounds double, ptr %.sink, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP65]]):
; RECURSE-NEXT:          %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
; RECURSE-NEXT:      Check 3:
; RECURSE-NEXT:        Comparing group ([[GRP67]]):
; RECURSE-NEXT:          %arrayidx7 = getelementptr inbounds double, ptr %.sink, i64 %indvars.iv
; RECURSE-NEXT:        Against group ([[GRP66]]):
; RECURSE-NEXT:          %arrayidx5 = getelementptr inbounds double, ptr %0, i64 %indvars.iv
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-NEXT:        Group [[GRP64]]:
; RECURSE-NEXT:          (Low: %1 High: (63992 + %1))
; RECURSE-NEXT:            Member: {%1,+,8}<nw><%for.body>
; RECURSE-NEXT:        Group [[GRP67]]:
; RECURSE-NEXT:          (Low: %2 High: (63992 + %2))
; RECURSE-NEXT:            Member: {%2,+,8}<nw><%for.body>
; RECURSE-NEXT:        Group [[GRP65]]:
; RECURSE-NEXT:          (Low: %Preds High: (31996 + %Preds))
; RECURSE-NEXT:            Member: {%Preds,+,4}<nuw><%for.body>
; RECURSE-NEXT:        Group [[GRP66]]:
; RECURSE-NEXT:          (Low: %0 High: (63992 + %0))
; RECURSE-NEXT:            Member: {%0,+,8}<nw><%for.body>
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  %0 = load ptr, ptr %c, align 64
  %1 = load ptr, ptr %a, align 64
  %2 = load ptr, ptr %b, align 64
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.inc
  ret void

for.body:                                         ; preds = %entry, %for.inc
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.inc ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %3 = load i32, ptr %arrayidx, align 4
  %cmp2.not = icmp eq i32 %3, 0
  br i1 %cmp2.not, label %if.else, label %if.then

if.then:                                          ; preds = %for.body
  %arrayidx5 = getelementptr inbounds double, ptr %0, i64 %indvars.iv
  %4 = load double, ptr %arrayidx5, align 8
  %add = fadd fast double %4, 1.000000e+00
  br label %for.inc

if.else:                                          ; preds = %for.body
  %5 = mul nuw nsw i64 %indvars.iv, %indvars.iv
  %6 = trunc i64 %5 to i32
  %conv8 = sitofp i32 %6 to double
  br label %for.inc

for.inc:                                          ; preds = %if.then, %if.else
  %.sink = phi ptr [ %1, %if.then ], [ %2, %if.else ]
  %add.sink = phi double [ %add, %if.then ], [ %conv8, %if.else ]
  %arrayidx7 = getelementptr inbounds double, ptr %.sink, i64 %indvars.iv
  store double %add.sink, ptr %arrayidx7, align 8
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond.not = icmp eq i64 %indvars.iv.next, 7999
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

; Negative test: the operator number of PhiNode is not 2.
define void @forked_ptrs_with_different_base3(ptr nocapture readonly %Preds, ptr nocapture %a, ptr nocapture %b, ptr nocapture readonly %c)  {
; CHECK-LABEL: 'forked_ptrs_with_different_base3'
; CHECK-NEXT:    for.body:
; CHECK-NEXT:      Report: cannot identify array bounds
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; RECURSE-LABEL: 'forked_ptrs_with_different_base3'
; RECURSE-NEXT:    for.body:
; RECURSE-NEXT:      Report: cannot identify array bounds
; RECURSE-NEXT:      Dependences:
; RECURSE-NEXT:      Run-time memory checks:
; RECURSE-NEXT:      Grouped accesses:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; RECURSE-NEXT:      SCEV assumptions:
; RECURSE-EMPTY:
; RECURSE-NEXT:      Expressions re-written:
;
entry:
  %ld.c = load ptr, ptr %c, align 64
  %ld.a = load ptr, ptr %a, align 64
  %ld.b = load ptr, ptr %b, align 64
  br label %for.body

for.body:                                         ; preds = %entry, %for.inc
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.inc ]
  %arrayidx = getelementptr inbounds i32, ptr %Preds, i64 %indvars.iv
  %ld.preds = load i32, ptr %arrayidx, align 4
  switch i32 %ld.preds, label %if.else [
    i32 0, label %if.br0
	i32 1, label %if.br1
  ]

if.br0:                                          ; preds = %for.body
  br label %for.inc

if.br1:                                          ; preds = %for.body
  br label %for.inc

if.else:                                         ; preds = %for.body
  br label %for.inc

for.inc:                                          ; preds = %if.br1, %if.br0
  %.sink = phi ptr [ %ld.a, %if.br0 ], [ %ld.b, %if.br1 ], [ %ld.c, %if.else ]
  %arrayidx7 = getelementptr inbounds double, ptr %.sink, i64 %indvars.iv
  store double 1.000000e+00, ptr %arrayidx7, align 8
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond.not = icmp eq i64 %indvars.iv.next, 7999
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body

for.cond.cleanup:                                 ; preds = %for.inc
  ret void
}
