// RUN: llvm-mc -triple=amdgcn -show-encoding -mcpu=gfx1100 %s | FileCheck --check-prefix=GFX11 %s

s_cmp_eq_i32 s0, s1
// GFX11: encoding: [0x00,0x01,0x00,0xbf]

s_cmp_eq_i32 s105, s104
// GFX11: encoding: [0x69,0x68,0x00,0xbf]

s_cmp_eq_i32 s0, s104
// GFX11: encoding: [0x00,0x68,0x00,0xbf]

s_cmp_eq_i32 s105, s1
// GFX11: encoding: [0x69,0x01,0x00,0xbf]

s_cmp_eq_i32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x00,0xbf]

s_cmp_eq_i32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x00,0xbf]

s_cmp_eq_i32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x00,0xbf]

s_cmp_eq_i32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x00,0xbf]

s_cmp_eq_i32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x00,0xbf]

s_cmp_eq_i32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x00,0xbf]

s_cmp_eq_i32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x00,0xbf]

s_cmp_eq_i32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x00,0xbf]

s_cmp_eq_i32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x00,0xbf]

s_cmp_eq_i32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x00,0xbf]

s_cmp_eq_i32 s0, 0
// GFX11: encoding: [0x00,0x80,0x00,0xbf]

s_cmp_eq_i32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x00,0xbf]

s_cmp_eq_i32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x00,0xbf]

s_cmp_eq_i32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x00,0xbf]

s_cmp_eq_i32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x00,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_i32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x00,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_i32 s0, s1
// GFX11: encoding: [0x00,0x01,0x01,0xbf]

s_cmp_lg_i32 s105, s104
// GFX11: encoding: [0x69,0x68,0x01,0xbf]

s_cmp_lg_i32 s0, s104
// GFX11: encoding: [0x00,0x68,0x01,0xbf]

s_cmp_lg_i32 s105, s1
// GFX11: encoding: [0x69,0x01,0x01,0xbf]

s_cmp_lg_i32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x01,0xbf]

s_cmp_lg_i32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x01,0xbf]

s_cmp_lg_i32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x01,0xbf]

s_cmp_lg_i32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x01,0xbf]

s_cmp_lg_i32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x01,0xbf]

s_cmp_lg_i32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x01,0xbf]

s_cmp_lg_i32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x01,0xbf]

s_cmp_lg_i32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x01,0xbf]

s_cmp_lg_i32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x01,0xbf]

s_cmp_lg_i32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x01,0xbf]

s_cmp_lg_i32 s0, 0
// GFX11: encoding: [0x00,0x80,0x01,0xbf]

s_cmp_lg_i32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x01,0xbf]

s_cmp_lg_i32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x01,0xbf]

s_cmp_lg_i32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x01,0xbf]

s_cmp_lg_i32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x01,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_i32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x01,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_i32 s0, s1
// GFX11: encoding: [0x00,0x01,0x02,0xbf]

s_cmp_gt_i32 s105, s104
// GFX11: encoding: [0x69,0x68,0x02,0xbf]

s_cmp_gt_i32 s0, s104
// GFX11: encoding: [0x00,0x68,0x02,0xbf]

s_cmp_gt_i32 s105, s1
// GFX11: encoding: [0x69,0x01,0x02,0xbf]

s_cmp_gt_i32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x02,0xbf]

s_cmp_gt_i32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x02,0xbf]

s_cmp_gt_i32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x02,0xbf]

s_cmp_gt_i32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x02,0xbf]

s_cmp_gt_i32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x02,0xbf]

s_cmp_gt_i32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x02,0xbf]

s_cmp_gt_i32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x02,0xbf]

s_cmp_gt_i32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x02,0xbf]

s_cmp_gt_i32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x02,0xbf]

s_cmp_gt_i32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x02,0xbf]

s_cmp_gt_i32 s0, 0
// GFX11: encoding: [0x00,0x80,0x02,0xbf]

s_cmp_gt_i32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x02,0xbf]

s_cmp_gt_i32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x02,0xbf]

s_cmp_gt_i32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x02,0xbf]

s_cmp_gt_i32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x02,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_i32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x02,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_i32 s0, s1
// GFX11: encoding: [0x00,0x01,0x03,0xbf]

s_cmp_ge_i32 s105, s104
// GFX11: encoding: [0x69,0x68,0x03,0xbf]

s_cmp_ge_i32 s0, s104
// GFX11: encoding: [0x00,0x68,0x03,0xbf]

s_cmp_ge_i32 s105, s1
// GFX11: encoding: [0x69,0x01,0x03,0xbf]

s_cmp_ge_i32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x03,0xbf]

s_cmp_ge_i32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x03,0xbf]

s_cmp_ge_i32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x03,0xbf]

s_cmp_ge_i32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x03,0xbf]

s_cmp_ge_i32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x03,0xbf]

s_cmp_ge_i32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x03,0xbf]

s_cmp_ge_i32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x03,0xbf]

s_cmp_ge_i32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x03,0xbf]

s_cmp_ge_i32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x03,0xbf]

s_cmp_ge_i32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x03,0xbf]

s_cmp_ge_i32 s0, 0
// GFX11: encoding: [0x00,0x80,0x03,0xbf]

s_cmp_ge_i32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x03,0xbf]

s_cmp_ge_i32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x03,0xbf]

s_cmp_ge_i32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x03,0xbf]

s_cmp_ge_i32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x03,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_i32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x03,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_i32 s0, s1
// GFX11: encoding: [0x00,0x01,0x04,0xbf]

s_cmp_lt_i32 s105, s104
// GFX11: encoding: [0x69,0x68,0x04,0xbf]

s_cmp_lt_i32 s0, s104
// GFX11: encoding: [0x00,0x68,0x04,0xbf]

s_cmp_lt_i32 s105, s1
// GFX11: encoding: [0x69,0x01,0x04,0xbf]

s_cmp_lt_i32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x04,0xbf]

s_cmp_lt_i32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x04,0xbf]

s_cmp_lt_i32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x04,0xbf]

s_cmp_lt_i32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x04,0xbf]

s_cmp_lt_i32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x04,0xbf]

s_cmp_lt_i32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x04,0xbf]

s_cmp_lt_i32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x04,0xbf]

s_cmp_lt_i32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x04,0xbf]

s_cmp_lt_i32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x04,0xbf]

s_cmp_lt_i32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x04,0xbf]

s_cmp_lt_i32 s0, 0
// GFX11: encoding: [0x00,0x80,0x04,0xbf]

s_cmp_lt_i32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x04,0xbf]

s_cmp_lt_i32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x04,0xbf]

s_cmp_lt_i32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x04,0xbf]

s_cmp_lt_i32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x04,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_i32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x04,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_i32 s0, s1
// GFX11: encoding: [0x00,0x01,0x05,0xbf]

s_cmp_le_i32 s105, s104
// GFX11: encoding: [0x69,0x68,0x05,0xbf]

s_cmp_le_i32 s0, s104
// GFX11: encoding: [0x00,0x68,0x05,0xbf]

s_cmp_le_i32 s105, s1
// GFX11: encoding: [0x69,0x01,0x05,0xbf]

s_cmp_le_i32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x05,0xbf]

s_cmp_le_i32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x05,0xbf]

s_cmp_le_i32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x05,0xbf]

s_cmp_le_i32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x05,0xbf]

s_cmp_le_i32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x05,0xbf]

s_cmp_le_i32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x05,0xbf]

s_cmp_le_i32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x05,0xbf]

s_cmp_le_i32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x05,0xbf]

s_cmp_le_i32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x05,0xbf]

s_cmp_le_i32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x05,0xbf]

s_cmp_le_i32 s0, 0
// GFX11: encoding: [0x00,0x80,0x05,0xbf]

s_cmp_le_i32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x05,0xbf]

s_cmp_le_i32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x05,0xbf]

s_cmp_le_i32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x05,0xbf]

s_cmp_le_i32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x05,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_i32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x05,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u32 s0, s1
// GFX11: encoding: [0x00,0x01,0x06,0xbf]

s_cmp_eq_u32 s105, s104
// GFX11: encoding: [0x69,0x68,0x06,0xbf]

s_cmp_eq_u32 s0, s104
// GFX11: encoding: [0x00,0x68,0x06,0xbf]

s_cmp_eq_u32 s105, s1
// GFX11: encoding: [0x69,0x01,0x06,0xbf]

s_cmp_eq_u32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x06,0xbf]

s_cmp_eq_u32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x06,0xbf]

s_cmp_eq_u32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x06,0xbf]

s_cmp_eq_u32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x06,0xbf]

s_cmp_eq_u32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x06,0xbf]

s_cmp_eq_u32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x06,0xbf]

s_cmp_eq_u32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x06,0xbf]

s_cmp_eq_u32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x06,0xbf]

s_cmp_eq_u32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x06,0xbf]

s_cmp_eq_u32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x06,0xbf]

s_cmp_eq_u32 s0, 0
// GFX11: encoding: [0x00,0x80,0x06,0xbf]

s_cmp_eq_u32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x06,0xbf]

s_cmp_eq_u32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x06,0xbf]

s_cmp_eq_u32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x06,0xbf]

s_cmp_eq_u32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x06,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x06,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u32 s0, s1
// GFX11: encoding: [0x00,0x01,0x07,0xbf]

s_cmp_lg_u32 s105, s104
// GFX11: encoding: [0x69,0x68,0x07,0xbf]

s_cmp_lg_u32 s0, s104
// GFX11: encoding: [0x00,0x68,0x07,0xbf]

s_cmp_lg_u32 s105, s1
// GFX11: encoding: [0x69,0x01,0x07,0xbf]

s_cmp_lg_u32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x07,0xbf]

s_cmp_lg_u32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x07,0xbf]

s_cmp_lg_u32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x07,0xbf]

s_cmp_lg_u32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x07,0xbf]

s_cmp_lg_u32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x07,0xbf]

s_cmp_lg_u32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x07,0xbf]

s_cmp_lg_u32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x07,0xbf]

s_cmp_lg_u32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x07,0xbf]

s_cmp_lg_u32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x07,0xbf]

s_cmp_lg_u32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x07,0xbf]

s_cmp_lg_u32 s0, 0
// GFX11: encoding: [0x00,0x80,0x07,0xbf]

s_cmp_lg_u32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x07,0xbf]

s_cmp_lg_u32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x07,0xbf]

s_cmp_lg_u32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x07,0xbf]

s_cmp_lg_u32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x07,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x07,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_u32 s0, s1
// GFX11: encoding: [0x00,0x01,0x08,0xbf]

s_cmp_gt_u32 s105, s104
// GFX11: encoding: [0x69,0x68,0x08,0xbf]

s_cmp_gt_u32 s0, s104
// GFX11: encoding: [0x00,0x68,0x08,0xbf]

s_cmp_gt_u32 s105, s1
// GFX11: encoding: [0x69,0x01,0x08,0xbf]

s_cmp_gt_u32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x08,0xbf]

s_cmp_gt_u32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x08,0xbf]

s_cmp_gt_u32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x08,0xbf]

s_cmp_gt_u32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x08,0xbf]

s_cmp_gt_u32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x08,0xbf]

s_cmp_gt_u32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x08,0xbf]

s_cmp_gt_u32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x08,0xbf]

s_cmp_gt_u32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x08,0xbf]

s_cmp_gt_u32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x08,0xbf]

s_cmp_gt_u32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x08,0xbf]

s_cmp_gt_u32 s0, 0
// GFX11: encoding: [0x00,0x80,0x08,0xbf]

s_cmp_gt_u32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x08,0xbf]

s_cmp_gt_u32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x08,0xbf]

s_cmp_gt_u32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x08,0xbf]

s_cmp_gt_u32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x08,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_u32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x08,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_u32 s0, s1
// GFX11: encoding: [0x00,0x01,0x09,0xbf]

s_cmp_ge_u32 s105, s104
// GFX11: encoding: [0x69,0x68,0x09,0xbf]

s_cmp_ge_u32 s0, s104
// GFX11: encoding: [0x00,0x68,0x09,0xbf]

s_cmp_ge_u32 s105, s1
// GFX11: encoding: [0x69,0x01,0x09,0xbf]

s_cmp_ge_u32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x09,0xbf]

s_cmp_ge_u32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x09,0xbf]

s_cmp_ge_u32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x09,0xbf]

s_cmp_ge_u32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x09,0xbf]

s_cmp_ge_u32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x09,0xbf]

s_cmp_ge_u32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x09,0xbf]

s_cmp_ge_u32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x09,0xbf]

s_cmp_ge_u32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x09,0xbf]

s_cmp_ge_u32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x09,0xbf]

s_cmp_ge_u32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x09,0xbf]

s_cmp_ge_u32 s0, 0
// GFX11: encoding: [0x00,0x80,0x09,0xbf]

s_cmp_ge_u32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x09,0xbf]

s_cmp_ge_u32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x09,0xbf]

s_cmp_ge_u32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x09,0xbf]

s_cmp_ge_u32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x09,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_u32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x09,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_u32 s0, s1
// GFX11: encoding: [0x00,0x01,0x0a,0xbf]

s_cmp_lt_u32 s105, s104
// GFX11: encoding: [0x69,0x68,0x0a,0xbf]

s_cmp_lt_u32 s0, s104
// GFX11: encoding: [0x00,0x68,0x0a,0xbf]

s_cmp_lt_u32 s105, s1
// GFX11: encoding: [0x69,0x01,0x0a,0xbf]

s_cmp_lt_u32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x0a,0xbf]

s_cmp_lt_u32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x0a,0xbf]

s_cmp_lt_u32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x0a,0xbf]

s_cmp_lt_u32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x0a,0xbf]

s_cmp_lt_u32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x0a,0xbf]

s_cmp_lt_u32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x0a,0xbf]

s_cmp_lt_u32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x0a,0xbf]

s_cmp_lt_u32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x0a,0xbf]

s_cmp_lt_u32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x0a,0xbf]

s_cmp_lt_u32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x0a,0xbf]

s_cmp_lt_u32 s0, 0
// GFX11: encoding: [0x00,0x80,0x0a,0xbf]

s_cmp_lt_u32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x0a,0xbf]

s_cmp_lt_u32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x0a,0xbf]

s_cmp_lt_u32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x0a,0xbf]

s_cmp_lt_u32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x0a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_u32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x0a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_u32 s0, s1
// GFX11: encoding: [0x00,0x01,0x0b,0xbf]

s_cmp_le_u32 s105, s104
// GFX11: encoding: [0x69,0x68,0x0b,0xbf]

s_cmp_le_u32 s0, s104
// GFX11: encoding: [0x00,0x68,0x0b,0xbf]

s_cmp_le_u32 s105, s1
// GFX11: encoding: [0x69,0x01,0x0b,0xbf]

s_cmp_le_u32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x0b,0xbf]

s_cmp_le_u32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x0b,0xbf]

s_cmp_le_u32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x0b,0xbf]

s_cmp_le_u32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x0b,0xbf]

s_cmp_le_u32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x0b,0xbf]

s_cmp_le_u32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x0b,0xbf]

s_cmp_le_u32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x0b,0xbf]

s_cmp_le_u32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x0b,0xbf]

s_cmp_le_u32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x0b,0xbf]

s_cmp_le_u32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x0b,0xbf]

s_cmp_le_u32 s0, 0
// GFX11: encoding: [0x00,0x80,0x0b,0xbf]

s_cmp_le_u32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x0b,0xbf]

s_cmp_le_u32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x0b,0xbf]

s_cmp_le_u32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x0b,0xbf]

s_cmp_le_u32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x0b,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_u32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x0b,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b32 s0, s1
// GFX11: encoding: [0x00,0x01,0x0c,0xbf]

s_bitcmp0_b32 s105, s104
// GFX11: encoding: [0x69,0x68,0x0c,0xbf]

s_bitcmp0_b32 s0, s104
// GFX11: encoding: [0x00,0x68,0x0c,0xbf]

s_bitcmp0_b32 s105, s1
// GFX11: encoding: [0x69,0x01,0x0c,0xbf]

s_bitcmp0_b32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x0c,0xbf]

s_bitcmp0_b32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x0c,0xbf]

s_bitcmp0_b32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x0c,0xbf]

s_bitcmp0_b32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x0c,0xbf]

s_bitcmp0_b32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x0c,0xbf]

s_bitcmp0_b32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x0c,0xbf]

s_bitcmp0_b32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x0c,0xbf]

s_bitcmp0_b32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x0c,0xbf]

s_bitcmp0_b32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x0c,0xbf]

s_bitcmp0_b32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x0c,0xbf]

s_bitcmp0_b32 s0, 0
// GFX11: encoding: [0x00,0x80,0x0c,0xbf]

s_bitcmp0_b32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x0c,0xbf]

s_bitcmp0_b32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x0c,0xbf]

s_bitcmp0_b32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x0c,0xbf]

s_bitcmp0_b32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x0c,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x0c,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b32 s0, s1
// GFX11: encoding: [0x00,0x01,0x0d,0xbf]

s_bitcmp1_b32 s105, s104
// GFX11: encoding: [0x69,0x68,0x0d,0xbf]

s_bitcmp1_b32 s0, s104
// GFX11: encoding: [0x00,0x68,0x0d,0xbf]

s_bitcmp1_b32 s105, s1
// GFX11: encoding: [0x69,0x01,0x0d,0xbf]

s_bitcmp1_b32 exec_lo, s1
// GFX11: encoding: [0x7e,0x01,0x0d,0xbf]

s_bitcmp1_b32 exec_hi, s1
// GFX11: encoding: [0x7f,0x01,0x0d,0xbf]

s_bitcmp1_b32 vcc_lo, s1
// GFX11: encoding: [0x6a,0x01,0x0d,0xbf]

s_bitcmp1_b32 vcc_hi, s1
// GFX11: encoding: [0x6b,0x01,0x0d,0xbf]

s_bitcmp1_b32 m0, s1
// GFX11: encoding: [0x7d,0x01,0x0d,0xbf]

s_bitcmp1_b32 s0, exec_lo
// GFX11: encoding: [0x00,0x7e,0x0d,0xbf]

s_bitcmp1_b32 s0, exec_hi
// GFX11: encoding: [0x00,0x7f,0x0d,0xbf]

s_bitcmp1_b32 s0, vcc_lo
// GFX11: encoding: [0x00,0x6a,0x0d,0xbf]

s_bitcmp1_b32 s0, vcc_hi
// GFX11: encoding: [0x00,0x6b,0x0d,0xbf]

s_bitcmp1_b32 s0, m0
// GFX11: encoding: [0x00,0x7d,0x0d,0xbf]

s_bitcmp1_b32 s0, 0
// GFX11: encoding: [0x00,0x80,0x0d,0xbf]

s_bitcmp1_b32 s0, -1
// GFX11: encoding: [0x00,0xc1,0x0d,0xbf]

s_bitcmp1_b32 s0, 0.5
// GFX11: encoding: [0x00,0xf0,0x0d,0xbf]

s_bitcmp1_b32 s0, -4.0
// GFX11: encoding: [0x00,0xf7,0x0d,0xbf]

s_bitcmp1_b32 s0, 0x3f717273
// GFX11: encoding: [0x00,0xff,0x0d,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b32 s0, 0xaf123456
// GFX11: encoding: [0x00,0xff,0x0d,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b64 s[0:1], s2
// GFX11: encoding: [0x00,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[104:105], s102
// GFX11: encoding: [0x68,0x66,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], s102
// GFX11: encoding: [0x00,0x66,0x0e,0xbf]

s_bitcmp0_b64 s[104:105], s2
// GFX11: encoding: [0x68,0x02,0x0e,0xbf]

s_bitcmp0_b64 exec, s2
// GFX11: encoding: [0x7e,0x02,0x0e,0xbf]

s_bitcmp0_b64 vcc, s2
// GFX11: encoding: [0x6a,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], exec_lo
// GFX11: encoding: [0x00,0x7e,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], exec_hi
// GFX11: encoding: [0x00,0x7f,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], vcc_lo
// GFX11: encoding: [0x00,0x6a,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], vcc_hi
// GFX11: encoding: [0x00,0x6b,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], m0
// GFX11: encoding: [0x00,0x7d,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0
// GFX11: encoding: [0x00,0x80,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], -1
// GFX11: encoding: [0x00,0xc1,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0.5
// GFX11: encoding: [0x00,0xf0,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], -4.0
// GFX11: encoding: [0x00,0xf7,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0x00,0xff,0x0e,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0x00,0xff,0x0e,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b64 s[0:1], s2
// GFX11: encoding: [0x00,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[104:105], s102
// GFX11: encoding: [0x68,0x66,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], s102
// GFX11: encoding: [0x00,0x66,0x0f,0xbf]

s_bitcmp1_b64 s[104:105], s2
// GFX11: encoding: [0x68,0x02,0x0f,0xbf]

s_bitcmp1_b64 exec, s2
// GFX11: encoding: [0x7e,0x02,0x0f,0xbf]

s_bitcmp1_b64 vcc, s2
// GFX11: encoding: [0x6a,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], exec_lo
// GFX11: encoding: [0x00,0x7e,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], exec_hi
// GFX11: encoding: [0x00,0x7f,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], vcc_lo
// GFX11: encoding: [0x00,0x6a,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], vcc_hi
// GFX11: encoding: [0x00,0x6b,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], m0
// GFX11: encoding: [0x00,0x7d,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0
// GFX11: encoding: [0x00,0x80,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], -1
// GFX11: encoding: [0x00,0xc1,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0.5
// GFX11: encoding: [0x00,0xf0,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], -4.0
// GFX11: encoding: [0x00,0xf7,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0x3f717273
// GFX11: encoding: [0x00,0xff,0x0f,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b64 s[0:1], 0xaf123456
// GFX11: encoding: [0x00,0xff,0x0f,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u64 s[0:1], s[2:3]
// GFX11: encoding: [0x00,0x02,0x10,0xbf]

s_cmp_eq_u64 s[104:105], s[102:103]
// GFX11: encoding: [0x68,0x66,0x10,0xbf]

s_cmp_eq_u64 s[0:1], s[102:103]
// GFX11: encoding: [0x00,0x66,0x10,0xbf]

s_cmp_eq_u64 s[104:105], s[2:3]
// GFX11: encoding: [0x68,0x02,0x10,0xbf]

s_cmp_eq_u64 exec, s[2:3]
// GFX11: encoding: [0x7e,0x02,0x10,0xbf]

s_cmp_eq_u64 vcc, s[2:3]
// GFX11: encoding: [0x6a,0x02,0x10,0xbf]

s_cmp_eq_u64 s[0:1], exec
// GFX11: encoding: [0x00,0x7e,0x10,0xbf]

s_cmp_eq_u64 s[0:1], vcc
// GFX11: encoding: [0x00,0x6a,0x10,0xbf]

s_cmp_eq_u64 s[0:1], 0
// GFX11: encoding: [0x00,0x80,0x10,0xbf]

s_cmp_eq_u64 s[0:1], -1
// GFX11: encoding: [0x00,0xc1,0x10,0xbf]

s_cmp_eq_u64 s[0:1], 0.5
// GFX11: encoding: [0x00,0xf0,0x10,0xbf]

s_cmp_eq_u64 s[0:1], -4.0
// GFX11: encoding: [0x00,0xf7,0x10,0xbf]

s_cmp_eq_u64 s[0:1], 0x3f717273
// GFX11: encoding: [0x00,0xff,0x10,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u64 s[0:1], 0xaf123456
// GFX11: encoding: [0x00,0xff,0x10,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u64 s[0:1], s[2:3]
// GFX11: encoding: [0x00,0x02,0x11,0xbf]

s_cmp_lg_u64 s[104:105], s[102:103]
// GFX11: encoding: [0x68,0x66,0x11,0xbf]

s_cmp_lg_u64 s[0:1], s[102:103]
// GFX11: encoding: [0x00,0x66,0x11,0xbf]

s_cmp_lg_u64 s[104:105], s[2:3]
// GFX11: encoding: [0x68,0x02,0x11,0xbf]

s_cmp_lg_u64 exec, s[2:3]
// GFX11: encoding: [0x7e,0x02,0x11,0xbf]

s_cmp_lg_u64 vcc, s[2:3]
// GFX11: encoding: [0x6a,0x02,0x11,0xbf]

s_cmp_lg_u64 s[0:1], exec
// GFX11: encoding: [0x00,0x7e,0x11,0xbf]

s_cmp_lg_u64 s[0:1], vcc
// GFX11: encoding: [0x00,0x6a,0x11,0xbf]

s_cmp_lg_u64 s[0:1], 0
// GFX11: encoding: [0x00,0x80,0x11,0xbf]

s_cmp_lg_u64 s[0:1], -1
// GFX11: encoding: [0x00,0xc1,0x11,0xbf]

s_cmp_lg_u64 s[0:1], 0.5
// GFX11: encoding: [0x00,0xf0,0x11,0xbf]

s_cmp_lg_u64 s[0:1], -4.0
// GFX11: encoding: [0x00,0xf7,0x11,0xbf]

s_cmp_lg_u64 s[0:1], 0x3f717273
// GFX11: encoding: [0x00,0xff,0x11,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u64 s[0:1], 0xaf123456
// GFX11: encoding: [0x00,0xff,0x11,0xbf,0x56,0x34,0x12,0xaf]
