; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -amdgpu-atomic-optimizer-strategy=None -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -amdgpu-atomic-optimizer-strategy=None -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -amdgpu-atomic-optimizer-strategy=None -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX9 %s

; ---------------------------------------------------------------------
; atomicrmw xchg
; ---------------------------------------------------------------------

define void @global_atomic_xchg_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_xchg_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_swap v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_swap v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_swap v[0:1], v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw xchg ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_xchg_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_xchg_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_swap v2, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_swap v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_swap v[0:1], v2, off offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw xchg ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_xchg_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_xchg_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_swap v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_swap v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_swap v0, v[0:1], v2, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw xchg ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_xchg_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_xchg_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_swap v2, v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_swap v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_swap v0, v[0:1], v2, off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw xchg ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_xchg_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_xchg_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_swap v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_swap v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_swap v0, v1, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw xchg ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_xchg_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_xchg_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_swap v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_swap v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_swap v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw xchg ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_xchg_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_xchg_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_swap v0, off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_swap v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_swap v0, v0, v1, s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw xchg ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_xchg_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_xchg_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_swap v0, off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_swap v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_swap v0, v0, v1, s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw xchg ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

; ---------------------------------------------------------------------
; atomicrmw xchg f32
; ---------------------------------------------------------------------

define void @global_atomic_xchg_f32_noret(ptr addrspace(1) %ptr, float %in) {
; GCN1-LABEL: global_atomic_xchg_f32_noret:
; GCN1:       ; %bb.0:
; GCN1-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN1-NEXT:    global_load_dword v3, v[0:1]
; GCN1-NEXT:    s_mov_b64 s[4:5], 0
; GCN1-NEXT:  .LBB0_1: ; %atomicrmw.start
; GCN1-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    global_atomic_cmpswap v4, v[0:1], v[2:3] glc
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    buffer_wbinvl1_vol
; GCN1-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GCN1-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN1-NEXT:    v_mov_b32_e32 v3, v4
; GCN1-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN1-NEXT:    s_cbranch_execnz .LBB0_1
; GCN1-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN1-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN1-NEXT:    s_setpc_b64 s[30:31]
;
; GCN2-LABEL: global_atomic_xchg_f32_noret:
; GCN2:       ; %bb.0:
; GCN2-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN2-NEXT:    global_load_dword v3, v[0:1]
; GCN2-NEXT:    s_mov_b64 s[4:5], 0
; GCN2-NEXT:  .LBB0_1: ; %atomicrmw.start
; GCN2-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    global_atomic_cmpswap v4, v[0:1], v[2:3] glc
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    buffer_wbinvl1_vol
; GCN2-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GCN2-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN2-NEXT:    v_mov_b32_e32 v3, v4
; GCN2-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN2-NEXT:    s_cbranch_execnz .LBB0_1
; GCN2-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN2-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN2-NEXT:    s_setpc_b64 s[30:31]
;
; GCN3-LABEL: global_atomic_xchg_f32_noret:
; GCN3:       ; %bb.0:
; GCN3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_load_dword v3, v[0:1]
; GCN3-NEXT:    s_mov_b64 s[4:5], 0
; GCN3-NEXT:  .LBB0_1: ; %atomicrmw.start
; GCN3-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_atomic_cmpswap v4, v[0:1], v[2:3] glc
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    buffer_wbinvl1_vol
; GCN3-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GCN3-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN3-NEXT:    v_mov_b32_e32 v3, v4
; GCN3-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN3-NEXT:    s_cbranch_execnz .LBB0_1
; GCN3-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN3-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN3-NEXT:    s_setpc_b64 s[30:31]
; SI-LABEL: global_atomic_xchg_f32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_swap v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_f32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_swap v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_f32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_swap v[0:1], v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw xchg ptr addrspace(1) %ptr, float %in seq_cst
  ret void
}

define void @global_atomic_xchg_f32_noret_offset(ptr addrspace(1) %out, float %in) {
; GCN1-LABEL: global_atomic_xchg_f32_noret_offset:
; GCN1:       ; %bb.0:
; GCN1-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN1-NEXT:    v_add_f32_e32 v0, vcc, 16, v0
; GCN1-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GCN1-NEXT:    global_load_dword v3, v[0:1]
; GCN1-NEXT:    s_mov_b64 s[4:5], 0
; GCN1-NEXT:  .LBB1_1: ; %atomicrmw.start
; GCN1-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    global_atomic_cmpswap v4, v[0:1], v[2:3] glc
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    buffer_wbinvl1_vol
; GCN1-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GCN1-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN1-NEXT:    v_mov_b32_e32 v3, v4
; GCN1-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN1-NEXT:    s_cbranch_execnz .LBB1_1
; GCN1-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN1-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN1-NEXT:    s_setpc_b64 s[30:31]
;
; GCN2-LABEL: global_atomic_xchg_f32_noret_offset:
; GCN2:       ; %bb.0:
; GCN2-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN2-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; GCN2-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GCN2-NEXT:    global_load_dword v3, v[0:1]
; GCN2-NEXT:    s_mov_b64 s[4:5], 0
; GCN2-NEXT:  .LBB1_1: ; %atomicrmw.start
; GCN2-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    global_atomic_cmpswap v4, v[0:1], v[2:3] glc
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    buffer_wbinvl1_vol
; GCN2-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GCN2-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN2-NEXT:    v_mov_b32_e32 v3, v4
; GCN2-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN2-NEXT:    s_cbranch_execnz .LBB1_1
; GCN2-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN2-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN2-NEXT:    s_setpc_b64 s[30:31]
;
; GCN3-LABEL: global_atomic_xchg_f32_noret_offset:
; GCN3:       ; %bb.0:
; GCN3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_load_dword v3, v[0:1] offset:16
; GCN3-NEXT:    s_mov_b64 s[4:5], 0
; GCN3-NEXT:  .LBB1_1: ; %atomicrmw.start
; GCN3-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_atomic_cmpswap v4, v[0:1], v[2:3] offset:16 glc
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    buffer_wbinvl1_vol
; GCN3-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GCN3-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN3-NEXT:    v_mov_b32_e32 v3, v4
; GCN3-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN3-NEXT:    s_cbranch_execnz .LBB1_1
; GCN3-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN3-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN3-NEXT:    s_setpc_b64 s[30:31]
; SI-LABEL: global_atomic_xchg_f32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_swap v2, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_f32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_swap v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_f32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_swap v[0:1], v2, off offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw xchg ptr addrspace(1) %gep, float %in seq_cst
  ret void
}

define float @global_atomic_xchg_f32_ret(ptr addrspace(1) %ptr, float %in) {
; GCN1-LABEL: global_atomic_xchg_f32_ret:
; GCN1:       ; %bb.0:
; GCN1-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN1-NEXT:    global_load_dword v4, v[0:1]
; GCN1-NEXT:    s_mov_b64 s[4:5], 0
; GCN1-NEXT:  .LBB2_1: ; %atomicrmw.start
; GCN1-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    v_mov_b32_e32 v3, v4
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    global_atomic_cmpswap v4, v[0:1], v[2:3] glc
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    buffer_wbinvl1_vol
; GCN1-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GCN1-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN1-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN1-NEXT:    s_cbranch_execnz .LBB2_1
; GCN1-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN1-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN1-NEXT:    v_mov_b32_e32 v0, v4
; GCN1-NEXT:    s_setpc_b64 s[30:31]
;
; GCN2-LABEL: global_atomic_xchg_f32_ret:
; GCN2:       ; %bb.0:
; GCN2-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN2-NEXT:    global_load_dword v4, v[0:1]
; GCN2-NEXT:    s_mov_b64 s[4:5], 0
; GCN2-NEXT:  .LBB2_1: ; %atomicrmw.start
; GCN2-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    v_mov_b32_e32 v3, v4
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    global_atomic_cmpswap v4, v[0:1], v[2:3] glc
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    buffer_wbinvl1_vol
; GCN2-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GCN2-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN2-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN2-NEXT:    s_cbranch_execnz .LBB2_1
; GCN2-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN2-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN2-NEXT:    v_mov_b32_e32 v0, v4
; GCN2-NEXT:    s_setpc_b64 s[30:31]
;
; GCN3-LABEL: global_atomic_xchg_f32_ret:
; GCN3:       ; %bb.0:
; GCN3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_load_dword v4, v[0:1]
; GCN3-NEXT:    s_mov_b64 s[4:5], 0
; GCN3-NEXT:  .LBB2_1: ; %atomicrmw.start
; GCN3-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    v_mov_b32_e32 v3, v4
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_atomic_cmpswap v4, v[0:1], v[2:3] glc
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    buffer_wbinvl1_vol
; GCN3-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GCN3-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN3-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN3-NEXT:    s_cbranch_execnz .LBB2_1
; GCN3-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN3-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN3-NEXT:    v_mov_b32_e32 v0, v4
; GCN3-NEXT:    s_setpc_b64 s[30:31]
; SI-LABEL: global_atomic_xchg_f32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_swap v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_f32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_swap v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_f32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_swap v0, v[0:1], v2, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw xchg ptr addrspace(1) %ptr, float %in seq_cst
  ret float %result
}

define float @global_atomic_xchg_f32_ret_offset(ptr addrspace(1) %out, float %in) {
; GCN1-LABEL: global_atomic_xchg_f32_ret_offset:
; GCN1:       ; %bb.0:
; GCN1-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN1-NEXT:    v_add_f32_e32 v4, vcc, 16, v0
; GCN1-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GCN1-NEXT:    global_load_dword v0, v[4:5]
; GCN1-NEXT:    s_mov_b64 s[4:5], 0
; GCN1-NEXT:  .LBB3_1: ; %atomicrmw.start
; GCN1-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    v_mov_b32_e32 v3, v0
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    global_atomic_cmpswap v0, v[4:5], v[2:3] glc
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    buffer_wbinvl1_vol
; GCN1-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GCN1-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN1-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN1-NEXT:    s_cbranch_execnz .LBB3_1
; GCN1-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN1-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN1-NEXT:    s_setpc_b64 s[30:31]
;
; GCN2-LABEL: global_atomic_xchg_f32_ret_offset:
; GCN2:       ; %bb.0:
; GCN2-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN2-NEXT:    v_add_u32_e32 v4, vcc, 16, v0
; GCN2-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GCN2-NEXT:    global_load_dword v0, v[4:5]
; GCN2-NEXT:    s_mov_b64 s[4:5], 0
; GCN2-NEXT:  .LBB3_1: ; %atomicrmw.start
; GCN2-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    v_mov_b32_e32 v3, v0
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    global_atomic_cmpswap v0, v[4:5], v[2:3] glc
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    buffer_wbinvl1_vol
; GCN2-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GCN2-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN2-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN2-NEXT:    s_cbranch_execnz .LBB3_1
; GCN2-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN2-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN2-NEXT:    s_setpc_b64 s[30:31]
;
; GCN3-LABEL: global_atomic_xchg_f32_ret_offset:
; GCN3:       ; %bb.0:
; GCN3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_load_dword v4, v[0:1] offset:16
; GCN3-NEXT:    s_mov_b64 s[4:5], 0
; GCN3-NEXT:  .LBB3_1: ; %atomicrmw.start
; GCN3-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    v_mov_b32_e32 v3, v4
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_atomic_cmpswap v4, v[0:1], v[2:3] offset:16 glc
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    buffer_wbinvl1_vol
; GCN3-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GCN3-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN3-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GCN3-NEXT:    s_cbranch_execnz .LBB3_1
; GCN3-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN3-NEXT:    s_or_b64 exec, exec, s[4:5]
; GCN3-NEXT:    v_mov_b32_e32 v0, v4
; GCN3-NEXT:    s_setpc_b64 s[30:31]
; SI-LABEL: global_atomic_xchg_f32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_swap v2, v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_f32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_swap v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_f32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_swap v0, v[0:1], v2, off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %out, i32 4
  %result = atomicrmw xchg ptr addrspace(1) %gep, float %in seq_cst
  ret float %result
}

define amdgpu_gfx void @global_atomic_xchg_f32_noret_scalar(ptr addrspace(1) inreg %ptr, float inreg %in) {
; GCN1-LABEL: global_atomic_xchg_f32_noret_scalar:
; GCN1:       ; %bb.0:
; GCN1-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN1-NEXT:    v_mov_b32_e32 v0, s4
; GCN1-NEXT:    v_mov_b32_e32 v1, s5
; GCN1-NEXT:    global_load_dword v1, v[0:1]
; GCN1-NEXT:    s_mov_b64 s[34:35], 0
; GCN1-NEXT:  .LBB4_1: ; %atomicrmw.start
; GCN1-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN1-NEXT:    v_mov_b32_e32 v2, s4
; GCN1-NEXT:    v_mov_b32_e32 v0, s6
; GCN1-NEXT:    v_mov_b32_e32 v3, s5
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    global_atomic_cmpswap v0, v[2:3], v[0:1] glc
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    buffer_wbinvl1_vol
; GCN1-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GCN1-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GCN1-NEXT:    v_mov_b32_e32 v1, v0
; GCN1-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GCN1-NEXT:    s_cbranch_execnz .LBB4_1
; GCN1-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN1-NEXT:    s_or_b64 exec, exec, s[34:35]
; GCN1-NEXT:    s_setpc_b64 s[30:31]
;
; GCN2-LABEL: global_atomic_xchg_f32_noret_scalar:
; GCN2:       ; %bb.0:
; GCN2-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN2-NEXT:    v_mov_b32_e32 v0, s4
; GCN2-NEXT:    v_mov_b32_e32 v1, s5
; GCN2-NEXT:    global_load_dword v1, v[0:1]
; GCN2-NEXT:    s_mov_b64 s[34:35], 0
; GCN2-NEXT:  .LBB4_1: ; %atomicrmw.start
; GCN2-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN2-NEXT:    v_mov_b32_e32 v2, s4
; GCN2-NEXT:    v_mov_b32_e32 v0, s6
; GCN2-NEXT:    v_mov_b32_e32 v3, s5
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    global_atomic_cmpswap v0, v[2:3], v[0:1] glc
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    buffer_wbinvl1_vol
; GCN2-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GCN2-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GCN2-NEXT:    v_mov_b32_e32 v1, v0
; GCN2-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GCN2-NEXT:    s_cbranch_execnz .LBB4_1
; GCN2-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN2-NEXT:    s_or_b64 exec, exec, s[34:35]
; GCN2-NEXT:    s_setpc_b64 s[30:31]
;
; GCN3-LABEL: global_atomic_xchg_f32_noret_scalar:
; GCN3:       ; %bb.0:
; GCN3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN3-NEXT:    v_mov_b32_e32 v0, s4
; GCN3-NEXT:    v_mov_b32_e32 v1, s5
; GCN3-NEXT:    global_load_dword v1, v[0:1]
; GCN3-NEXT:    s_mov_b64 s[34:35], 0
; GCN3-NEXT:  .LBB4_1: ; %atomicrmw.start
; GCN3-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN3-NEXT:    v_mov_b32_e32 v2, s4
; GCN3-NEXT:    v_mov_b32_e32 v0, s6
; GCN3-NEXT:    v_mov_b32_e32 v3, s5
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_atomic_cmpswap v0, v[2:3], v[0:1] glc
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    buffer_wbinvl1_vol
; GCN3-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GCN3-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GCN3-NEXT:    v_mov_b32_e32 v1, v0
; GCN3-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GCN3-NEXT:    s_cbranch_execnz .LBB4_1
; GCN3-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN3-NEXT:    s_or_b64 exec, exec, s[34:35]
; GCN3-NEXT:    s_setpc_b64 s[30:31]
; SI-LABEL: global_atomic_xchg_f32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_swap v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_f32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_swap v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_f32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_swap v0, v1, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw xchg ptr addrspace(1) %ptr, float %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_xchg_f32_noret_offset_scalar(ptr addrspace(1) inreg %out, float inreg %in) {
; GCN1-LABEL: global_atomic_xchg_f32_noret_offset_scalar:
; GCN1:       ; %bb.0:
; GCN1-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN1-NEXT:    s_add_u32 s34, s4, 16
; GCN1-NEXT:    s_addc_u32 s35, s5, 0
; GCN1-NEXT:    v_mov_b32_e32 v0, s34
; GCN1-NEXT:    v_mov_b32_e32 v1, s35
; GCN1-NEXT:    global_load_dword v1, v[0:1]
; GCN1-NEXT:    s_mov_b64 s[36:37], 0
; GCN1-NEXT:  .LBB5_1: ; %atomicrmw.start
; GCN1-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN1-NEXT:    v_mov_b32_e32 v2, s34
; GCN1-NEXT:    v_mov_b32_e32 v0, s6
; GCN1-NEXT:    v_mov_b32_e32 v3, s35
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    global_atomic_cmpswap v0, v[2:3], v[0:1] glc
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    buffer_wbinvl1_vol
; GCN1-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GCN1-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; GCN1-NEXT:    v_mov_b32_e32 v1, v0
; GCN1-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; GCN1-NEXT:    s_cbranch_execnz .LBB5_1
; GCN1-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN1-NEXT:    s_or_b64 exec, exec, s[36:37]
; GCN1-NEXT:    s_setpc_b64 s[30:31]
;
; GCN2-LABEL: global_atomic_xchg_f32_noret_offset_scalar:
; GCN2:       ; %bb.0:
; GCN2-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN2-NEXT:    s_add_u32 s34, s4, 16
; GCN2-NEXT:    s_addc_u32 s35, s5, 0
; GCN2-NEXT:    v_mov_b32_e32 v0, s34
; GCN2-NEXT:    v_mov_b32_e32 v1, s35
; GCN2-NEXT:    global_load_dword v1, v[0:1]
; GCN2-NEXT:    s_mov_b64 s[36:37], 0
; GCN2-NEXT:  .LBB5_1: ; %atomicrmw.start
; GCN2-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN2-NEXT:    v_mov_b32_e32 v2, s34
; GCN2-NEXT:    v_mov_b32_e32 v0, s6
; GCN2-NEXT:    v_mov_b32_e32 v3, s35
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    global_atomic_cmpswap v0, v[2:3], v[0:1] glc
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    buffer_wbinvl1_vol
; GCN2-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GCN2-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; GCN2-NEXT:    v_mov_b32_e32 v1, v0
; GCN2-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; GCN2-NEXT:    s_cbranch_execnz .LBB5_1
; GCN2-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN2-NEXT:    s_or_b64 exec, exec, s[36:37]
; GCN2-NEXT:    s_setpc_b64 s[30:31]
;
; GCN3-LABEL: global_atomic_xchg_f32_noret_offset_scalar:
; GCN3:       ; %bb.0:
; GCN3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN3-NEXT:    v_mov_b32_e32 v0, s4
; GCN3-NEXT:    v_mov_b32_e32 v1, s5
; GCN3-NEXT:    global_load_dword v1, v[0:1] offset:16
; GCN3-NEXT:    s_mov_b64 s[34:35], 0
; GCN3-NEXT:  .LBB5_1: ; %atomicrmw.start
; GCN3-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN3-NEXT:    v_mov_b32_e32 v2, s4
; GCN3-NEXT:    v_mov_b32_e32 v0, s6
; GCN3-NEXT:    v_mov_b32_e32 v3, s5
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_atomic_cmpswap v0, v[2:3], v[0:1] offset:16 glc
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    buffer_wbinvl1_vol
; GCN3-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GCN3-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GCN3-NEXT:    v_mov_b32_e32 v1, v0
; GCN3-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GCN3-NEXT:    s_cbranch_execnz .LBB5_1
; GCN3-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN3-NEXT:    s_or_b64 exec, exec, s[34:35]
; GCN3-NEXT:    s_setpc_b64 s[30:31]
; SI-LABEL: global_atomic_xchg_f32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_swap v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_f32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_swap v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_f32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_swap v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw xchg ptr addrspace(1) %gep, float %in seq_cst
  ret void
}

define amdgpu_gfx float @global_atomic_xchg_f32_ret_scalar(ptr addrspace(1) inreg %ptr, float inreg %in) {
; GCN1-LABEL: global_atomic_xchg_f32_ret_scalar:
; GCN1:       ; %bb.0:
; GCN1-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN1-NEXT:    v_mov_b32_e32 v0, s4
; GCN1-NEXT:    v_mov_b32_e32 v1, s5
; GCN1-NEXT:    global_load_dword v0, v[0:1]
; GCN1-NEXT:    s_mov_b64 s[34:35], 0
; GCN1-NEXT:  .LBB6_1: ; %atomicrmw.start
; GCN1-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN1-NEXT:    v_mov_b32_e32 v3, s4
; GCN1-NEXT:    v_mov_b32_e32 v1, s6
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    v_mov_b32_e32 v2, v0
; GCN1-NEXT:    v_mov_b32_e32 v4, s5
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    global_atomic_cmpswap v0, v[3:4], v[1:2] glc
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    buffer_wbinvl1_vol
; GCN1-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; GCN1-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GCN1-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GCN1-NEXT:    s_cbranch_execnz .LBB6_1
; GCN1-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN1-NEXT:    s_or_b64 exec, exec, s[34:35]
; GCN1-NEXT:    s_setpc_b64 s[30:31]
;
; GCN2-LABEL: global_atomic_xchg_f32_ret_scalar:
; GCN2:       ; %bb.0:
; GCN2-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN2-NEXT:    v_mov_b32_e32 v0, s4
; GCN2-NEXT:    v_mov_b32_e32 v1, s5
; GCN2-NEXT:    global_load_dword v0, v[0:1]
; GCN2-NEXT:    s_mov_b64 s[34:35], 0
; GCN2-NEXT:  .LBB6_1: ; %atomicrmw.start
; GCN2-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN2-NEXT:    v_mov_b32_e32 v3, s4
; GCN2-NEXT:    v_mov_b32_e32 v1, s6
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    v_mov_b32_e32 v2, v0
; GCN2-NEXT:    v_mov_b32_e32 v4, s5
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    global_atomic_cmpswap v0, v[3:4], v[1:2] glc
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    buffer_wbinvl1_vol
; GCN2-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; GCN2-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GCN2-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GCN2-NEXT:    s_cbranch_execnz .LBB6_1
; GCN2-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN2-NEXT:    s_or_b64 exec, exec, s[34:35]
; GCN2-NEXT:    s_setpc_b64 s[30:31]
;
; GCN3-LABEL: global_atomic_xchg_f32_ret_scalar:
; GCN3:       ; %bb.0:
; GCN3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN3-NEXT:    v_mov_b32_e32 v0, s4
; GCN3-NEXT:    v_mov_b32_e32 v1, s5
; GCN3-NEXT:    global_load_dword v0, v[0:1]
; GCN3-NEXT:    s_mov_b64 s[34:35], 0
; GCN3-NEXT:  .LBB6_1: ; %atomicrmw.start
; GCN3-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN3-NEXT:    v_mov_b32_e32 v3, s4
; GCN3-NEXT:    v_mov_b32_e32 v1, s6
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    v_mov_b32_e32 v2, v0
; GCN3-NEXT:    v_mov_b32_e32 v4, s5
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_atomic_cmpswap v0, v[3:4], v[1:2] glc
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    buffer_wbinvl1_vol
; GCN3-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; GCN3-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GCN3-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GCN3-NEXT:    s_cbranch_execnz .LBB6_1
; GCN3-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN3-NEXT:    s_or_b64 exec, exec, s[34:35]
; GCN3-NEXT:    s_setpc_b64 s[30:31]
; SI-LABEL: global_atomic_xchg_f32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_swap v0, off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_f32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_swap v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_f32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_swap v0, v0, v1, s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw xchg ptr addrspace(1) %ptr, float %in seq_cst
  ret float %result
}

define amdgpu_gfx float @global_atomic_xchg_f32_ret_offset_scalar(ptr addrspace(1) inreg %out, float inreg %in) {
; GCN1-LABEL: global_atomic_xchg_f32_ret_offset_scalar:
; GCN1:       ; %bb.0:
; GCN1-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN1-NEXT:    s_add_u32 s34, s4, 16
; GCN1-NEXT:    s_addc_u32 s35, s5, 0
; GCN1-NEXT:    v_mov_b32_e32 v0, s34
; GCN1-NEXT:    v_mov_b32_e32 v1, s35
; GCN1-NEXT:    global_load_dword v0, v[0:1]
; GCN1-NEXT:    s_mov_b64 s[36:37], 0
; GCN1-NEXT:  .LBB7_1: ; %atomicrmw.start
; GCN1-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN1-NEXT:    v_mov_b32_e32 v3, s34
; GCN1-NEXT:    v_mov_b32_e32 v1, s6
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    v_mov_b32_e32 v2, v0
; GCN1-NEXT:    v_mov_b32_e32 v4, s35
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    global_atomic_cmpswap v0, v[3:4], v[1:2] glc
; GCN1-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN1-NEXT:    buffer_wbinvl1_vol
; GCN1-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; GCN1-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; GCN1-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; GCN1-NEXT:    s_cbranch_execnz .LBB7_1
; GCN1-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN1-NEXT:    s_or_b64 exec, exec, s[36:37]
; GCN1-NEXT:    s_setpc_b64 s[30:31]
;
; GCN2-LABEL: global_atomic_xchg_f32_ret_offset_scalar:
; GCN2:       ; %bb.0:
; GCN2-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN2-NEXT:    s_add_u32 s34, s4, 16
; GCN2-NEXT:    s_addc_u32 s35, s5, 0
; GCN2-NEXT:    v_mov_b32_e32 v0, s34
; GCN2-NEXT:    v_mov_b32_e32 v1, s35
; GCN2-NEXT:    global_load_dword v0, v[0:1]
; GCN2-NEXT:    s_mov_b64 s[36:37], 0
; GCN2-NEXT:  .LBB7_1: ; %atomicrmw.start
; GCN2-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN2-NEXT:    v_mov_b32_e32 v3, s34
; GCN2-NEXT:    v_mov_b32_e32 v1, s6
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    v_mov_b32_e32 v2, v0
; GCN2-NEXT:    v_mov_b32_e32 v4, s35
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    global_atomic_cmpswap v0, v[3:4], v[1:2] glc
; GCN2-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN2-NEXT:    buffer_wbinvl1_vol
; GCN2-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; GCN2-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; GCN2-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; GCN2-NEXT:    s_cbranch_execnz .LBB7_1
; GCN2-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN2-NEXT:    s_or_b64 exec, exec, s[36:37]
; GCN2-NEXT:    s_setpc_b64 s[30:31]
;
; GCN3-LABEL: global_atomic_xchg_f32_ret_offset_scalar:
; GCN3:       ; %bb.0:
; GCN3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN3-NEXT:    v_mov_b32_e32 v0, s4
; GCN3-NEXT:    v_mov_b32_e32 v1, s5
; GCN3-NEXT:    global_load_dword v0, v[0:1] offset:16
; GCN3-NEXT:    s_mov_b64 s[34:35], 0
; GCN3-NEXT:  .LBB7_1: ; %atomicrmw.start
; GCN3-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN3-NEXT:    v_mov_b32_e32 v3, s4
; GCN3-NEXT:    v_mov_b32_e32 v1, s6
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    v_mov_b32_e32 v2, v0
; GCN3-NEXT:    v_mov_b32_e32 v4, s5
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    global_atomic_cmpswap v0, v[3:4], v[1:2] offset:16 glc
; GCN3-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN3-NEXT:    buffer_wbinvl1_vol
; GCN3-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; GCN3-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GCN3-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GCN3-NEXT:    s_cbranch_execnz .LBB7_1
; GCN3-NEXT:  ; %bb.2: ; %atomicrmw.end
; GCN3-NEXT:    s_or_b64 exec, exec, s[34:35]
; GCN3-NEXT:    s_setpc_b64 s[30:31]
; SI-LABEL: global_atomic_xchg_f32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_swap v0, off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xchg_f32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_swap v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xchg_f32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_swap v0, v0, v1, s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %out, i32 4
  %result = atomicrmw xchg ptr addrspace(1) %gep, float %in seq_cst
  ret float %result
}

; ---------------------------------------------------------------------
; atomicrmw add
; ---------------------------------------------------------------------

define void @global_atomic_add_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_add_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_add v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_add_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_add v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_add_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_add v[0:1], v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw add ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_add_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_add_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_add v2, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_add_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_add v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_add_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_add v[0:1], v2, off offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw add ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_add_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_add_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_add v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_add_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_add v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_add_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_add v0, v[0:1], v2, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw add ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_add_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_add_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_add v2, v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_add_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_add v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_add_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_add v0, v[0:1], v2, off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw add ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_add_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_add_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_add v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_add_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_add v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_add_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_add v0, v1, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw add ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_add_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_add_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_add v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_add_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_add v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_add_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_add v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw add ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_add_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_add_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_add v0, off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_add_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_add v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_add_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_add v0, v0, v1, s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw add ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_add_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_add_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_add v0, off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_add_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_add v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_add_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_add v0, v0, v1, s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw add ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

; ---------------------------------------------------------------------
; atomicrmw sub
; ---------------------------------------------------------------------

define void @global_atomic_sub_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_sub_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_sub v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_sub_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_sub v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_sub_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_sub v[0:1], v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw sub ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_sub_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_sub_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_sub v2, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_sub_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_sub v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_sub_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_sub v[0:1], v2, off offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw sub ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_sub_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_sub_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_sub v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_sub_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_sub v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_sub_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_sub v0, v[0:1], v2, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw sub ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_sub_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_sub_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_sub v2, v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_sub_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_sub v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_sub_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_sub v0, v[0:1], v2, off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw sub ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_sub_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_sub_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_sub v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_sub_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_sub v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_sub_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_sub v0, v1, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw sub ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_sub_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_sub_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_sub v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_sub_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_sub v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_sub_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_sub v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw sub ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_sub_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_sub_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_sub v0, off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_sub_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_sub v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_sub_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_sub v0, v0, v1, s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw sub ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_sub_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_sub_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_sub v0, off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_sub_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_sub v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_sub_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_sub v0, v0, v1, s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw sub ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

; ---------------------------------------------------------------------
; atomicrmw and
; ---------------------------------------------------------------------

define void @global_atomic_and_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_and_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_and v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_and_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_and v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_and_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_and v[0:1], v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw and ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_and_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_and_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_and v2, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_and_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_and v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_and_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_and v[0:1], v2, off offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw and ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_and_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_and_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_and v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_and_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_and v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_and_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_and v0, v[0:1], v2, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw and ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_and_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_and_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_and v2, v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_and_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_and v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_and_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_and v0, v[0:1], v2, off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw and ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_and_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_and_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_and v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_and_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_and v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_and_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_and v0, v1, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw and ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_and_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_and_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_and v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_and_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_and v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_and_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_and v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw and ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_and_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_and_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_and v0, off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_and_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_and v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_and_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_and v0, v0, v1, s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw and ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_and_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_and_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_and v0, off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_and_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_and v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_and_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_and v0, v0, v1, s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw and ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

; ---------------------------------------------------------------------
; atomicrmw nand
; ---------------------------------------------------------------------

define void @global_atomic_nand_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_nand_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB40_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v3, v4, v2
; SI-NEXT:    v_not_b32_e32 v3, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v6, v4
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB40_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_nand_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB40_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v3, v4, v2
; VI-NEXT:    v_not_b32_e32 v3, v3
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB40_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_nand_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v4, v[0:1], off
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v3, v4, v2
; GFX9-NEXT:    v_not_b32_e32 v3, v3
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB40_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw nand ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_nand_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_nand_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB41_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v3, v4, v2
; SI-NEXT:    v_not_b32_e32 v3, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v6, v4
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB41_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_nand_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB41_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v3, v4, v2
; VI-NEXT:    v_not_b32_e32 v3, v3
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB41_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_nand_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v4, v[0:1], off offset:16
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v3, v4, v2
; GFX9-NEXT:    v_not_b32_e32 v3, v3
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB41_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw nand ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_nand_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_nand_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB42_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v3, v5, v2
; SI-NEXT:    v_not_b32_e32 v4, v3
; SI-NEXT:    v_mov_b32_e32 v3, v4
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB42_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_nand_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB42_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    v_and_b32_e32 v3, v4, v2
; VI-NEXT:    v_not_b32_e32 v3, v3
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB42_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_nand_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v[0:1], off
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    v_and_b32_e32 v3, v4, v2
; GFX9-NEXT:    v_not_b32_e32 v3, v3
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB42_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw nand ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_nand_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_nand_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB43_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v3, v5, v2
; SI-NEXT:    v_not_b32_e32 v4, v3
; SI-NEXT:    v_mov_b32_e32 v3, v4
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB43_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_nand_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v3, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[3:4]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB43_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, v0
; VI-NEXT:    v_and_b32_e32 v0, v1, v2
; VI-NEXT:    v_not_b32_e32 v0, v0
; VI-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB43_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_nand_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v[0:1], off offset:16
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    v_and_b32_e32 v3, v4, v2
; GFX9-NEXT:    v_not_b32_e32 v3, v3
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB43_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw nand ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_nand_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_nand_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v4, s6, 0
; SI-NEXT:    v_writelane_b32 v4, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v1, off, s[4:7], 0
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB44_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v0, s34, v1
; SI-NEXT:    v_not_b32_e32 v0, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB44_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v4, 1
; SI-NEXT:    v_readlane_b32 s6, v4, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_nand_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB44_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, s6, v3
; VI-NEXT:    v_not_b32_e32 v2, v2
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB44_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_nand_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_dword v1, v2, s[4:5]
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, s6, v1
; GFX9-NEXT:    v_not_b32_e32 v0, v0
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB44_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw nand ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_nand_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_nand_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v4, s6, 0
; SI-NEXT:    v_writelane_b32 v4, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v1, off, s[4:7], 0 offset:16
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB45_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v0, s34, v1
; SI-NEXT:    v_not_b32_e32 v0, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB45_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v4, 1
; SI-NEXT:    v_readlane_b32 s6, v4, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_nand_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB45_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, s6, v3
; VI-NEXT:    v_not_b32_e32 v2, v2
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB45_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_nand_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_dword v1, v2, s[4:5] offset:16
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, s6, v1
; GFX9-NEXT:    v_not_b32_e32 v0, v0
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB45_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw nand ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_nand_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_nand_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v3, s6, 0
; SI-NEXT:    v_writelane_b32 v3, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v0, off, s[4:7], 0
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB46_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v0, s34, v2
; SI-NEXT:    v_not_b32_e32 v1, v0
; SI-NEXT:    v_mov_b32_e32 v0, v1
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    buffer_atomic_cmpswap v[0:1], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB46_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v3, 1
; SI-NEXT:    v_readlane_b32 s6, v3, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_nand_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:  .LBB46_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    v_and_b32_e32 v0, s6, v4
; VI-NEXT:    v_not_b32_e32 v3, v0
; VI-NEXT:    flat_atomic_cmpswap v0, v[1:2], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v4
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB46_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_nand_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_dword v0, v1, s[4:5]
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_and_b32_e32 v0, s6, v3
; GFX9-NEXT:    v_not_b32_e32 v2, v0
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB46_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw nand ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_nand_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_nand_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v3, s6, 0
; SI-NEXT:    v_writelane_b32 v3, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB47_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v0, s34, v2
; SI-NEXT:    v_not_b32_e32 v1, v0
; SI-NEXT:    v_mov_b32_e32 v0, v1
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    buffer_atomic_cmpswap v[0:1], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB47_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v3, 1
; SI-NEXT:    v_readlane_b32 s6, v3, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_nand_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v1, s34
; VI-NEXT:    v_mov_b32_e32 v2, s35
; VI-NEXT:    flat_load_dword v0, v[1:2]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB47_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    v_and_b32_e32 v0, s6, v4
; VI-NEXT:    v_not_b32_e32 v3, v0
; VI-NEXT:    flat_atomic_cmpswap v0, v[1:2], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v4
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB47_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_nand_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_dword v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_and_b32_e32 v0, s6, v3
; GFX9-NEXT:    v_not_b32_e32 v2, v0
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB47_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw nand ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

; ---------------------------------------------------------------------
; atomicrmw or
; ---------------------------------------------------------------------

define void @global_atomic_or_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_or_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_or v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_or_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_or v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_or_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_or v[0:1], v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw or ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_or_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_or_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_or v2, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_or_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_or v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_or_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_or v[0:1], v2, off offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw or ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_or_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_or_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_or v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_or_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_or v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_or_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_or v0, v[0:1], v2, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw or ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_or_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_or_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_or v2, v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_or_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_or v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_or_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_or v0, v[0:1], v2, off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw or ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_or_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_or_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_or v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_or_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_or v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_or_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_or v0, v1, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw or ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_or_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_or_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_or v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_or_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_or v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_or_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_or v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw or ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_or_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_or_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_or v0, off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_or_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_or v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_or_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_or v0, v0, v1, s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw or ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_or_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_or_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_or v0, off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_or_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_or v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_or_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_or v0, v0, v1, s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw or ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

; ---------------------------------------------------------------------
; atomicrmw xor
; ---------------------------------------------------------------------

define void @global_atomic_xor_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_xor_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_xor v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xor_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_xor v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xor_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_xor v[0:1], v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw xor ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_xor_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_xor_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_xor v2, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xor_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_xor v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xor_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_xor v[0:1], v2, off offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw xor ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_xor_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_xor_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_xor v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xor_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_xor v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xor_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_xor v0, v[0:1], v2, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw xor ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_xor_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_xor_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_xor v2, v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xor_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_xor v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xor_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_xor v0, v[0:1], v2, off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw xor ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_xor_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_xor_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_xor v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xor_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_xor v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xor_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_xor v0, v1, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw xor ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_xor_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_xor_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_xor v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xor_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_xor v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xor_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_xor v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw xor ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_xor_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_xor_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_xor v0, off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xor_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_xor v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xor_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_xor v0, v0, v1, s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw xor ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_xor_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_xor_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_xor v0, off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_xor_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_xor v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_xor_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_xor v0, v0, v1, s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw xor ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

; ---------------------------------------------------------------------
; atomicrmw max
; ---------------------------------------------------------------------

define void @global_atomic_max_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_max_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB64_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_max_i32_e32 v3, v4, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v6, v4
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB64_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_max_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB64_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_max_i32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB64_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_max_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v4, v[0:1], off
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB64_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_i32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB64_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw max ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_max_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_max_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB65_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_max_i32_e32 v3, v4, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v6, v4
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB65_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_max_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB65_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_max_i32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB65_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_max_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v4, v[0:1], off offset:16
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB65_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_i32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB65_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw max ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_max_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_max_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB66_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_max_i32_e32 v4, v5, v2
; SI-NEXT:    v_mov_b32_e32 v3, v4
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB66_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_max_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB66_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    v_max_i32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB66_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_max_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v[0:1], off
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB66_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    v_max_i32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB66_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw max ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_max_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_max_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB67_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_max_i32_e32 v4, v5, v2
; SI-NEXT:    v_mov_b32_e32 v3, v4
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB67_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_max_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v3, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[3:4]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB67_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, v0
; VI-NEXT:    v_max_i32_e32 v0, v1, v2
; VI-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB67_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_max_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v[0:1], off offset:16
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB67_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    v_max_i32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB67_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw max ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_max_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_max_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v4, s6, 0
; SI-NEXT:    v_writelane_b32 v4, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v1, off, s[4:7], 0
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB68_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_max_i32_e32 v0, s34, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB68_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v4, 1
; SI-NEXT:    v_readlane_b32 s6, v4, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_max_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB68_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_max_i32_e32 v2, s6, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB68_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_max_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_dword v1, v2, s[4:5]
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB68_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_i32_e32 v0, s6, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB68_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw max ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_max_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_max_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v4, s6, 0
; SI-NEXT:    v_writelane_b32 v4, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v1, off, s[4:7], 0 offset:16
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB69_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_max_i32_e32 v0, s34, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB69_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v4, 1
; SI-NEXT:    v_readlane_b32 s6, v4, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_max_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB69_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_max_i32_e32 v2, s6, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB69_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_max_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_dword v1, v2, s[4:5] offset:16
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB69_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_i32_e32 v0, s6, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB69_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw max ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_max_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_max_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v3, s6, 0
; SI-NEXT:    v_writelane_b32 v3, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v0, off, s[4:7], 0
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB70_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_max_i32_e32 v1, s34, v2
; SI-NEXT:    v_mov_b32_e32 v0, v1
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    buffer_atomic_cmpswap v[0:1], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB70_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v3, 1
; SI-NEXT:    v_readlane_b32 s6, v3, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_max_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:  .LBB70_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    v_max_i32_e32 v3, s6, v4
; VI-NEXT:    flat_atomic_cmpswap v0, v[1:2], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v4
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB70_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_max_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_dword v0, v1, s[4:5]
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB70_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_i32_e32 v2, s6, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB70_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw max ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_max_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_max_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v3, s6, 0
; SI-NEXT:    v_writelane_b32 v3, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB71_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_max_i32_e32 v1, s34, v2
; SI-NEXT:    v_mov_b32_e32 v0, v1
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    buffer_atomic_cmpswap v[0:1], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB71_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v3, 1
; SI-NEXT:    v_readlane_b32 s6, v3, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_max_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v1, s34
; VI-NEXT:    v_mov_b32_e32 v2, s35
; VI-NEXT:    flat_load_dword v0, v[1:2]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB71_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    v_max_i32_e32 v3, s6, v4
; VI-NEXT:    flat_atomic_cmpswap v0, v[1:2], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v4
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB71_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_max_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_dword v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB71_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_i32_e32 v2, s6, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB71_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw max ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_kernel void @atomic_max_i32_addr64_offset(ptr addrspace(1) %out, i32 %in, i32 %index) {
; SI-LABEL: atomic_max_i32_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_ashr_i32 s5, s3, 31
; SI-NEXT:    s_mov_b32 s4, s3
; SI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; SI-NEXT:    s_add_u32 s4, s0, s4
; SI-NEXT:    s_addc_u32 s5, s1, s5
; SI-NEXT:    s_load_dword s3, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB72_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB72_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_ashr_i32 s5, s3, 31
; VI-NEXT:    s_mov_b32 s4, s3
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dword s3, s[4:5], 0x10
; VI-NEXT:    s_add_u32 s4, s4, 16
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:  .LBB72_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_i32_e32 v2, s2, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB72_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_ashr_i32 s5, s3, 31
; GFX9-NEXT:    s_mov_b32 s4, s3
; GFX9-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; GFX9-NEXT:    s_add_u32 s0, s0, s4
; GFX9-NEXT:    s_addc_u32 s1, s1, s5
; GFX9-NEXT:    s_load_dword s3, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:  .LBB72_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_i32_e32 v0, s2, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB72_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i32 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i32 4
  %tmp0 = atomicrmw max ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i32_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i32 %index) {
; SI-LABEL: atomic_max_i32_ret_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_ashr_i32 s5, s9, 31
; SI-NEXT:    s_mov_b32 s4, s9
; SI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; SI-NEXT:    s_add_u32 s4, s0, s4
; SI-NEXT:    s_addc_u32 s5, s1, s5
; SI-NEXT:    s_load_dword s6, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s6
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB73_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB73_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[0:1]
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s2
; SI-NEXT:    s_mov_b32 s5, s3
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_ashr_i32 s7, s5, 31
; VI-NEXT:    s_mov_b32 s6, s5
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 2
; VI-NEXT:    s_add_u32 s6, s0, s6
; VI-NEXT:    s_addc_u32 s7, s1, s7
; VI-NEXT:    s_load_dword s5, s[6:7], 0x10
; VI-NEXT:    s_add_u32 s6, s6, 16
; VI-NEXT:    s_addc_u32 s7, s7, 0
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:  .LBB73_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    v_max_i32_e32 v2, s4, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB73_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_ashr_i32 s1, s3, 31
; GFX9-NEXT:    s_mov_b32 s0, s3
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s3, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB73_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_i32_e32 v2, s2, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB73_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i32 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i32 4
  %tmp0 = atomicrmw max ptr addrspace(1) %gep, i32 %in seq_cst
  store i32 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i32_addr64(ptr addrspace(1) %out, i32 %in, i32 %index) {
; SI-LABEL: atomic_max_i32_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_ashr_i32 s5, s3, 31
; SI-NEXT:    s_mov_b32 s4, s3
; SI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; SI-NEXT:    s_add_u32 s4, s0, s4
; SI-NEXT:    s_addc_u32 s5, s1, s5
; SI-NEXT:    s_load_dword s3, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB74_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB74_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_ashr_i32 s5, s3, 31
; VI-NEXT:    s_mov_b32 s4, s3
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dword s3, s[4:5], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:  .LBB74_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_i32_e32 v2, s2, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB74_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_ashr_i32 s5, s3, 31
; GFX9-NEXT:    s_mov_b32 s4, s3
; GFX9-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; GFX9-NEXT:    s_add_u32 s0, s0, s4
; GFX9-NEXT:    s_addc_u32 s1, s1, s5
; GFX9-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:  .LBB74_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_i32_e32 v0, s2, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB74_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i32 %index
  %tmp0 = atomicrmw max ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i32_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i32 %index) {
; SI-LABEL: atomic_max_i32_ret_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_ashr_i32 s5, s9, 31
; SI-NEXT:    s_mov_b32 s4, s9
; SI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; SI-NEXT:    s_add_u32 s4, s0, s4
; SI-NEXT:    s_addc_u32 s5, s1, s5
; SI-NEXT:    s_load_dword s6, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s6
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB75_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB75_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[0:1]
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s2
; SI-NEXT:    s_mov_b32 s5, s3
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_ashr_i32 s7, s5, 31
; VI-NEXT:    s_mov_b32 s6, s5
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 2
; VI-NEXT:    s_add_u32 s6, s0, s6
; VI-NEXT:    s_addc_u32 s7, s1, s7
; VI-NEXT:    s_load_dword s5, s[6:7], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:  .LBB75_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    v_max_i32_e32 v2, s4, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB75_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_ashr_i32 s1, s3, 31
; GFX9-NEXT:    s_mov_b32 s0, s3
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB75_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_i32_e32 v2, s2, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB75_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i32 %index
  %tmp0 = atomicrmw max ptr addrspace(1) %ptr, i32 %in seq_cst
  store i32 %tmp0, ptr addrspace(1) %out2
  ret void
}

; ---------------------------------------------------------------------
; atomicrmw umax
; ---------------------------------------------------------------------

define void @global_atomic_umax_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_umax_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB76_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_max_u32_e32 v3, v4, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v6, v4
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB76_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umax_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB76_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_max_u32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB76_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umax_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v4, v[0:1], off
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB76_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_u32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB76_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw umax ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_umax_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_umax_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB77_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_max_u32_e32 v3, v4, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v6, v4
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB77_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umax_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB77_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_max_u32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB77_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umax_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v4, v[0:1], off offset:16
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB77_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_u32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB77_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw umax ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_umax_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_umax_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB78_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_max_u32_e32 v4, v5, v2
; SI-NEXT:    v_mov_b32_e32 v3, v4
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB78_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umax_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB78_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    v_max_u32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB78_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umax_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v[0:1], off
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB78_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    v_max_u32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB78_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw umax ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_umax_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_umax_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB79_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_max_u32_e32 v4, v5, v2
; SI-NEXT:    v_mov_b32_e32 v3, v4
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB79_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umax_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v3, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[3:4]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB79_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, v0
; VI-NEXT:    v_max_u32_e32 v0, v1, v2
; VI-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB79_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umax_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v[0:1], off offset:16
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB79_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    v_max_u32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB79_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw umax ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_umax_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_umax_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v4, s6, 0
; SI-NEXT:    v_writelane_b32 v4, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v1, off, s[4:7], 0
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB80_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_max_u32_e32 v0, s34, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB80_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v4, 1
; SI-NEXT:    v_readlane_b32 s6, v4, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umax_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB80_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_max_u32_e32 v2, s6, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB80_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umax_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_dword v1, v2, s[4:5]
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB80_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_u32_e32 v0, s6, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB80_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw umax ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_umax_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_umax_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v4, s6, 0
; SI-NEXT:    v_writelane_b32 v4, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v1, off, s[4:7], 0 offset:16
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB81_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_max_u32_e32 v0, s34, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB81_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v4, 1
; SI-NEXT:    v_readlane_b32 s6, v4, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umax_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB81_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_max_u32_e32 v2, s6, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB81_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umax_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_dword v1, v2, s[4:5] offset:16
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB81_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_max_u32_e32 v0, s6, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB81_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw umax ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_umax_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_umax_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v3, s6, 0
; SI-NEXT:    v_writelane_b32 v3, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v0, off, s[4:7], 0
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB82_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_max_u32_e32 v1, s34, v2
; SI-NEXT:    v_mov_b32_e32 v0, v1
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    buffer_atomic_cmpswap v[0:1], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB82_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v3, 1
; SI-NEXT:    v_readlane_b32 s6, v3, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umax_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:  .LBB82_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    v_max_u32_e32 v3, s6, v4
; VI-NEXT:    flat_atomic_cmpswap v0, v[1:2], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v4
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB82_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umax_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_dword v0, v1, s[4:5]
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB82_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_u32_e32 v2, s6, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB82_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw umax ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_umax_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_umax_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v3, s6, 0
; SI-NEXT:    v_writelane_b32 v3, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB83_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_max_u32_e32 v1, s34, v2
; SI-NEXT:    v_mov_b32_e32 v0, v1
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    buffer_atomic_cmpswap v[0:1], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB83_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v3, 1
; SI-NEXT:    v_readlane_b32 s6, v3, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umax_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v1, s34
; VI-NEXT:    v_mov_b32_e32 v2, s35
; VI-NEXT:    flat_load_dword v0, v[1:2]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB83_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    v_max_u32_e32 v3, s6, v4
; VI-NEXT:    flat_atomic_cmpswap v0, v[1:2], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v4
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB83_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umax_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_dword v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB83_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_u32_e32 v2, s6, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB83_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw umax ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_kernel void @atomic_umax_i32_addr64_offset(ptr addrspace(1) %out, i32 %in, i32 %index) {
; SI-LABEL: atomic_umax_i32_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_ashr_i32 s5, s3, 31
; SI-NEXT:    s_mov_b32 s4, s3
; SI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; SI-NEXT:    s_add_u32 s4, s0, s4
; SI-NEXT:    s_addc_u32 s5, s1, s5
; SI-NEXT:    s_load_dword s3, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB84_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_u32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB84_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i32_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_ashr_i32 s5, s3, 31
; VI-NEXT:    s_mov_b32 s4, s3
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dword s3, s[4:5], 0x10
; VI-NEXT:    s_add_u32 s4, s4, 16
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:  .LBB84_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_u32_e32 v2, s2, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB84_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i32_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_ashr_i32 s5, s3, 31
; GFX9-NEXT:    s_mov_b32 s4, s3
; GFX9-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; GFX9-NEXT:    s_add_u32 s0, s0, s4
; GFX9-NEXT:    s_addc_u32 s1, s1, s5
; GFX9-NEXT:    s_load_dword s3, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:  .LBB84_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_u32_e32 v0, s2, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB84_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i32 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i32 4
  %tmp0 = atomicrmw umax ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i32_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i32 %index) {
; SI-LABEL: atomic_umax_i32_ret_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_ashr_i32 s5, s9, 31
; SI-NEXT:    s_mov_b32 s4, s9
; SI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; SI-NEXT:    s_add_u32 s4, s0, s4
; SI-NEXT:    s_addc_u32 s5, s1, s5
; SI-NEXT:    s_load_dword s6, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s6
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB85_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_u32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB85_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[0:1]
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s2
; SI-NEXT:    s_mov_b32 s5, s3
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i32_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_ashr_i32 s7, s5, 31
; VI-NEXT:    s_mov_b32 s6, s5
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 2
; VI-NEXT:    s_add_u32 s6, s0, s6
; VI-NEXT:    s_addc_u32 s7, s1, s7
; VI-NEXT:    s_load_dword s5, s[6:7], 0x10
; VI-NEXT:    s_add_u32 s6, s6, 16
; VI-NEXT:    s_addc_u32 s7, s7, 0
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:  .LBB85_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    v_max_u32_e32 v2, s4, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB85_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i32_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_ashr_i32 s1, s3, 31
; GFX9-NEXT:    s_mov_b32 s0, s3
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s3, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB85_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_u32_e32 v2, s2, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB85_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i32 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i32 4
  %tmp0 = atomicrmw umax ptr addrspace(1) %gep, i32 %in seq_cst
  store i32 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i32_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i32 %index) {
; SI-LABEL: atomic_umax_i32_ret_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_ashr_i32 s5, s9, 31
; SI-NEXT:    s_mov_b32 s4, s9
; SI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; SI-NEXT:    s_add_u32 s4, s0, s4
; SI-NEXT:    s_addc_u32 s5, s1, s5
; SI-NEXT:    s_load_dword s6, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s6
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB86_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_u32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB86_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[0:1]
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s2
; SI-NEXT:    s_mov_b32 s5, s3
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i32_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_ashr_i32 s7, s5, 31
; VI-NEXT:    s_mov_b32 s6, s5
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 2
; VI-NEXT:    s_add_u32 s6, s0, s6
; VI-NEXT:    s_addc_u32 s7, s1, s7
; VI-NEXT:    s_load_dword s5, s[6:7], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:  .LBB86_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    v_max_u32_e32 v2, s4, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB86_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i32_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_ashr_i32 s1, s3, 31
; GFX9-NEXT:    s_mov_b32 s0, s3
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB86_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_u32_e32 v2, s2, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB86_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i32 %index
  %tmp0 = atomicrmw umax ptr addrspace(1) %ptr, i32 %in seq_cst
  store i32 %tmp0, ptr addrspace(1) %out2
  ret void
}

; ---------------------------------------------------------------------
; atomicrmw umin
; ---------------------------------------------------------------------

define void @global_atomic_umin_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_umin_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB87_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_min_u32_e32 v3, v4, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v6, v4
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB87_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umin_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB87_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_min_u32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB87_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umin_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v4, v[0:1], off
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB87_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_min_u32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB87_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw umin ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_umin_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_umin_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB88_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_min_u32_e32 v3, v4, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v6, v4
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB88_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umin_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB88_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_min_u32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB88_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umin_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v4, v[0:1], off offset:16
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB88_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_min_u32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB88_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw umin ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_umin_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_umin_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB89_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_min_u32_e32 v4, v5, v2
; SI-NEXT:    v_mov_b32_e32 v3, v4
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB89_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umin_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB89_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    v_min_u32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB89_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umin_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v[0:1], off
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB89_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    v_min_u32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB89_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw umin ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_umin_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_umin_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB90_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_min_u32_e32 v4, v5, v2
; SI-NEXT:    v_mov_b32_e32 v3, v4
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB90_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umin_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v3, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[3:4]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB90_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, v0
; VI-NEXT:    v_min_u32_e32 v0, v1, v2
; VI-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB90_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umin_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v[0:1], off offset:16
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB90_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    v_min_u32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB90_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw umin ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_umin_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_umin_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v4, s6, 0
; SI-NEXT:    v_writelane_b32 v4, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v1, off, s[4:7], 0
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB91_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_min_u32_e32 v0, s34, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB91_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v4, 1
; SI-NEXT:    v_readlane_b32 s6, v4, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umin_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB91_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_min_u32_e32 v2, s6, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB91_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umin_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_dword v1, v2, s[4:5]
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB91_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_min_u32_e32 v0, s6, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB91_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw umin ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_umin_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_umin_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v4, s6, 0
; SI-NEXT:    v_writelane_b32 v4, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v1, off, s[4:7], 0 offset:16
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB92_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_min_u32_e32 v0, s34, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB92_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v4, 1
; SI-NEXT:    v_readlane_b32 s6, v4, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umin_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB92_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_min_u32_e32 v2, s6, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB92_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umin_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_dword v1, v2, s[4:5] offset:16
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB92_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_min_u32_e32 v0, s6, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB92_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw umin ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_umin_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_umin_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v3, s6, 0
; SI-NEXT:    v_writelane_b32 v3, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v0, off, s[4:7], 0
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB93_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_min_u32_e32 v1, s34, v2
; SI-NEXT:    v_mov_b32_e32 v0, v1
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    buffer_atomic_cmpswap v[0:1], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB93_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v3, 1
; SI-NEXT:    v_readlane_b32 s6, v3, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umin_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:  .LBB93_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    v_min_u32_e32 v3, s6, v4
; VI-NEXT:    flat_atomic_cmpswap v0, v[1:2], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v4
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB93_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umin_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_dword v0, v1, s[4:5]
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB93_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_u32_e32 v2, s6, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB93_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw umin ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_umin_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_umin_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v3, s6, 0
; SI-NEXT:    v_writelane_b32 v3, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB94_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_min_u32_e32 v1, s34, v2
; SI-NEXT:    v_mov_b32_e32 v0, v1
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    buffer_atomic_cmpswap v[0:1], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB94_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v3, 1
; SI-NEXT:    v_readlane_b32 s6, v3, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_umin_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v1, s34
; VI-NEXT:    v_mov_b32_e32 v2, s35
; VI-NEXT:    flat_load_dword v0, v[1:2]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB94_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    v_min_u32_e32 v3, s6, v4
; VI-NEXT:    flat_atomic_cmpswap v0, v[1:2], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v4
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB94_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_umin_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_dword v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB94_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_u32_e32 v2, s6, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB94_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw umin ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

; ---------------------------------------------------------------------
; atomicrmw min
; ---------------------------------------------------------------------

define void @global_atomic_min_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_min_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB95_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_min_i32_e32 v3, v4, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v6, v4
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB95_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_min_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB95_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_min_i32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB95_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_min_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v4, v[0:1], off
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB95_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_min_i32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB95_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw min ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_min_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_min_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB96_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_min_i32_e32 v3, v4, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v6, v4
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB96_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_min_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB96_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_min_i32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB96_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_min_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v4, v[0:1], off offset:16
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB96_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_min_i32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB96_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw min ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_min_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_min_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB97_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_min_i32_e32 v4, v5, v2
; SI-NEXT:    v_mov_b32_e32 v3, v4
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB97_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_min_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB97_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    v_min_i32_e32 v3, v4, v2
; VI-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB97_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_min_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v[0:1], off
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB97_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    v_min_i32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB97_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw min ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_min_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_min_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:  .LBB98_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_min_i32_e32 v4, v5, v2
; SI-NEXT:    v_mov_b32_e32 v3, v4
; SI-NEXT:    v_mov_b32_e32 v4, v5
; SI-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB98_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_min_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v3, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[3:4]
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:  .LBB98_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, v0
; VI-NEXT:    v_min_i32_e32 v0, v1, v2
; VI-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB98_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_min_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v[0:1], off offset:16
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:  .LBB98_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, v3
; GFX9-NEXT:    v_min_i32_e32 v3, v4, v2
; GFX9-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB98_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw min ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_min_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_min_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v4, s6, 0
; SI-NEXT:    v_writelane_b32 v4, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v1, off, s[4:7], 0
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB99_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_min_i32_e32 v0, s34, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB99_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v4, 1
; SI-NEXT:    v_readlane_b32 s6, v4, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_min_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB99_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_min_i32_e32 v2, s6, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB99_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_min_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_dword v1, v2, s[4:5]
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB99_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_min_i32_e32 v0, s6, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB99_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw min ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_min_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_min_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v4, s6, 0
; SI-NEXT:    v_writelane_b32 v4, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v1, off, s[4:7], 0 offset:16
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB100_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_min_i32_e32 v0, s34, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB100_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v4, 1
; SI-NEXT:    v_readlane_b32 s6, v4, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_min_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB100_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_min_i32_e32 v2, s6, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB100_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_min_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_dword v1, v2, s[4:5] offset:16
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB100_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_min_i32_e32 v0, s6, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB100_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw min ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_min_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_min_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v3, s6, 0
; SI-NEXT:    v_writelane_b32 v3, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v0, off, s[4:7], 0
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB101_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_min_i32_e32 v1, s34, v2
; SI-NEXT:    v_mov_b32_e32 v0, v1
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    buffer_atomic_cmpswap v[0:1], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB101_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v3, 1
; SI-NEXT:    v_readlane_b32 s6, v3, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_min_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:  .LBB101_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    v_min_i32_e32 v3, s6, v4
; VI-NEXT:    flat_atomic_cmpswap v0, v[1:2], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v4
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB101_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_min_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_dword v0, v1, s[4:5]
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB101_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_i32_e32 v2, s6, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB101_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw min ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_min_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_min_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v3, s6, 0
; SI-NEXT:    v_writelane_b32 v3, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    buffer_load_dword v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_mov_b64 s[36:37], 0
; SI-NEXT:  .LBB102_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_min_i32_e32 v1, s34, v2
; SI-NEXT:    v_mov_b32_e32 v0, v1
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    buffer_atomic_cmpswap v[0:1], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; SI-NEXT:    s_or_b64 s[36:37], vcc, s[36:37]
; SI-NEXT:    s_andn2_b64 exec, exec, s[36:37]
; SI-NEXT:    s_cbranch_execnz .LBB102_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[36:37]
; SI-NEXT:    v_readlane_b32 s7, v3, 1
; SI-NEXT:    v_readlane_b32 s6, v3, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_min_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v1, s34
; VI-NEXT:    v_mov_b32_e32 v2, s35
; VI-NEXT:    flat_load_dword v0, v[1:2]
; VI-NEXT:    s_mov_b64 s[34:35], 0
; VI-NEXT:  .LBB102_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, v0
; VI-NEXT:    v_min_i32_e32 v3, s6, v4
; VI-NEXT:    flat_atomic_cmpswap v0, v[1:2], v[3:4] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v4
; VI-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; VI-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; VI-NEXT:    s_cbranch_execnz .LBB102_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[34:35]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_min_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_dword v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_mov_b64 s[34:35], 0
; GFX9-NEXT:  .LBB102_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_i32_e32 v2, s6, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[34:35], vcc, s[34:35]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_cbranch_execnz .LBB102_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw min ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_kernel void @atomic_min_i32_addr64_offset(ptr addrspace(1) %out, i32 %in, i32 %index) {
; SI-LABEL: atomic_min_i32_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_ashr_i32 s5, s3, 31
; SI-NEXT:    s_mov_b32 s4, s3
; SI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; SI-NEXT:    s_add_u32 s4, s0, s4
; SI-NEXT:    s_addc_u32 s5, s1, s5
; SI-NEXT:    s_load_dword s3, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB103_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB103_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_ashr_i32 s5, s3, 31
; VI-NEXT:    s_mov_b32 s4, s3
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; VI-NEXT:    s_add_u32 s4, s0, s4
; VI-NEXT:    s_addc_u32 s5, s1, s5
; VI-NEXT:    s_load_dword s3, s[4:5], 0x10
; VI-NEXT:    s_add_u32 s4, s4, 16
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:  .LBB103_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_i32_e32 v2, s2, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB103_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_ashr_i32 s5, s3, 31
; GFX9-NEXT:    s_mov_b32 s4, s3
; GFX9-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; GFX9-NEXT:    s_add_u32 s0, s0, s4
; GFX9-NEXT:    s_addc_u32 s1, s1, s5
; GFX9-NEXT:    s_load_dword s3, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:  .LBB103_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_min_i32_e32 v0, s2, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB103_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i32 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i32 4
  %tmp0 = atomicrmw min ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i32_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i32 %index) {
; SI-LABEL: atomic_min_i32_ret_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_ashr_i32 s5, s9, 31
; SI-NEXT:    s_mov_b32 s4, s9
; SI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; SI-NEXT:    s_add_u32 s4, s0, s4
; SI-NEXT:    s_addc_u32 s5, s1, s5
; SI-NEXT:    s_load_dword s6, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s6
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB104_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB104_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[0:1]
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s2
; SI-NEXT:    s_mov_b32 s5, s3
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_ashr_i32 s7, s5, 31
; VI-NEXT:    s_mov_b32 s6, s5
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 2
; VI-NEXT:    s_add_u32 s6, s0, s6
; VI-NEXT:    s_addc_u32 s7, s1, s7
; VI-NEXT:    s_load_dword s5, s[6:7], 0x10
; VI-NEXT:    s_add_u32 s6, s6, 16
; VI-NEXT:    s_addc_u32 s7, s7, 0
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:  .LBB104_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    v_min_i32_e32 v2, s4, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB104_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_ashr_i32 s1, s3, 31
; GFX9-NEXT:    s_mov_b32 s0, s3
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s3, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB104_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_i32_e32 v2, s2, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB104_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i32 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i32 4
  %tmp0 = atomicrmw min ptr addrspace(1) %gep, i32 %in seq_cst
  store i32 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i32(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: atomic_min_i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s3, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB105_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB105_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s3, s[4:5], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:  .LBB105_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_i32_e32 v2, s2, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB105_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s5, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB105_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_min_i32_e32 v0, s4, v1
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[2:3] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB105_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw min ptr addrspace(1) %out, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i32_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i32 %index) {
; SI-LABEL: atomic_min_i32_ret_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_ashr_i32 s5, s9, 31
; SI-NEXT:    s_mov_b32 s4, s9
; SI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 2
; SI-NEXT:    s_add_u32 s4, s0, s4
; SI-NEXT:    s_addc_u32 s5, s1, s5
; SI-NEXT:    s_load_dword s6, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s6
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB106_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB106_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[0:1]
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s2
; SI-NEXT:    s_mov_b32 s5, s3
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_ashr_i32 s7, s5, 31
; VI-NEXT:    s_mov_b32 s6, s5
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], 2
; VI-NEXT:    s_add_u32 s6, s0, s6
; VI-NEXT:    s_addc_u32 s7, s1, s7
; VI-NEXT:    s_load_dword s5, s[6:7], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:  .LBB106_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_mov_b32_e32 v3, v2
; VI-NEXT:    v_min_i32_e32 v2, s4, v3
; VI-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB106_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_ashr_i32 s1, s3, 31
; GFX9-NEXT:    s_mov_b32 s0, s3
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB106_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_i32_e32 v2, s2, v3
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB106_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i32 %index
  %tmp0 = atomicrmw min ptr addrspace(1) %ptr, i32 %in seq_cst
  store i32 %tmp0, ptr addrspace(1) %out2
  ret void
}

; ---------------------------------------------------------------------
; atomicrmw uinc_wrap
; ---------------------------------------------------------------------

define void @global_atomic_uinc_wrap_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_uinc_wrap_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_inc v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_uinc_wrap_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_inc v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_uinc_wrap_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_inc v[0:1], v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw uinc_wrap ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_uinc_wrap_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_uinc_wrap_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_inc v2, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_uinc_wrap_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_inc v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_uinc_wrap_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_inc v[0:1], v2, off offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw uinc_wrap ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_uinc_wrap_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_uinc_wrap_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_inc v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_uinc_wrap_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_inc v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_uinc_wrap_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_inc v0, v[0:1], v2, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw uinc_wrap ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_uinc_wrap_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_uinc_wrap_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_inc v2, v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_uinc_wrap_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_inc v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_uinc_wrap_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_inc v0, v[0:1], v2, off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw uinc_wrap ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_uinc_wrap_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_uinc_wrap_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_inc v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_uinc_wrap_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_inc v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_uinc_wrap_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_inc v0, v1, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw uinc_wrap ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_uinc_wrap_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_uinc_wrap_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_inc v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_uinc_wrap_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_inc v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_uinc_wrap_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_inc v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw uinc_wrap ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_uinc_wrap_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_uinc_wrap_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_inc v0, off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_uinc_wrap_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_inc v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_uinc_wrap_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_inc v0, v0, v1, s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw uinc_wrap ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_uinc_wrap_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_uinc_wrap_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_inc v0, off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_uinc_wrap_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_inc v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_uinc_wrap_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_inc v0, v0, v1, s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw uinc_wrap ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

; ---------------------------------------------------------------------
; atomicrmw udec_wrap
; ---------------------------------------------------------------------

define void @global_atomic_udec_wrap_i32_noret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_udec_wrap_i32_noret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_dec v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_udec_wrap_i32_noret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_dec v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_udec_wrap_i32_noret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_dec v[0:1], v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw udec_wrap ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define void @global_atomic_udec_wrap_i32_noret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_udec_wrap_i32_noret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_dec v2, v[0:1], s[4:7], 0 addr64 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_udec_wrap_i32_noret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_dec v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_udec_wrap_i32_noret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_dec v[0:1], v2, off offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw udec_wrap ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define i32 @global_atomic_udec_wrap_i32_ret(ptr addrspace(1) %ptr, i32 %in) {
; SI-LABEL: global_atomic_udec_wrap_i32_ret:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_dec v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_udec_wrap_i32_ret:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    flat_atomic_dec v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_udec_wrap_i32_ret:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_dec v0, v[0:1], v2, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw udec_wrap ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define i32 @global_atomic_udec_wrap_i32_ret_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: global_atomic_udec_wrap_i32_ret_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_atomic_dec v2, v[0:1], s[4:7], 0 addr64 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_udec_wrap_i32_ret_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_atomic_dec v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_udec_wrap_i32_ret_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_dec v0, v[0:1], v2, off offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw udec_wrap ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx void @global_atomic_udec_wrap_i32_noret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_udec_wrap_i32_noret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_dec v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_udec_wrap_i32_noret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_dec v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_udec_wrap_i32_noret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_dec v0, v1, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = atomicrmw udec_wrap ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_gfx void @global_atomic_udec_wrap_i32_noret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_udec_wrap_i32_noret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_dec v0, off, s[4:7], 0 offset:16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_udec_wrap_i32_noret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_dec v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_udec_wrap_i32_noret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_dec v0, v1, s[4:5] offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %tmp0 = atomicrmw udec_wrap ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_gfx i32 @global_atomic_udec_wrap_i32_ret_scalar(ptr addrspace(1) inreg %ptr, i32 inreg %in) {
; SI-LABEL: global_atomic_udec_wrap_i32_ret_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_dec v0, off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_udec_wrap_i32_ret_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_dec v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_udec_wrap_i32_ret_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_dec v0, v0, v1, s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw udec_wrap ptr addrspace(1) %ptr, i32 %in seq_cst
  ret i32 %result
}

define amdgpu_gfx i32 @global_atomic_udec_wrap_i32_ret_offset_scalar(ptr addrspace(1) inreg %out, i32 inreg %in) {
; SI-LABEL: global_atomic_udec_wrap_i32_ret_offset_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v1, s6, 0
; SI-NEXT:    v_writelane_b32 v1, s7, 1
; SI-NEXT:    s_mov_b32 s34, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s34
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_atomic_dec v0, off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_readlane_b32 s7, v1, 1
; SI-NEXT:    v_readlane_b32 s6, v1, 0
; SI-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[34:35]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: global_atomic_udec_wrap_i32_ret_offset_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_add_u32 s34, s4, 16
; VI-NEXT:    s_addc_u32 s35, s5, 0
; VI-NEXT:    v_mov_b32_e32 v0, s34
; VI-NEXT:    v_mov_b32_e32 v1, s35
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    flat_atomic_dec v0, v[0:1], v2 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: global_atomic_udec_wrap_i32_ret_offset_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    global_atomic_dec v0, v0, v1, s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i32, ptr addrspace(1) %out, i32 4
  %result = atomicrmw udec_wrap ptr addrspace(1) %gep, i32 %in seq_cst
  ret i32 %result
}
