// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX12,W32 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1200 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX12,W64 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize32,-wavefrontsize64 %s 2>&1 | FileCheck --check-prefix=W32-ERR --implicit-check-not=error: %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1200 -mattr=-wavefrontsize32,+wavefrontsize64 %s 2>&1 | FileCheck --check-prefix=W64-ERR --implicit-check-not=error: %s

v_add_co_ci_u32_e64 v5, s6, v1, 0xaf123456, s3
// W32: encoding: [0x05,0x06,0x20,0xd5,0x01,0xff,0x0d,0x00,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s6, v255, src_scc, s3
// W32: encoding: [0x05,0x06,0x20,0xd5,0xff,0xfb,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s6, s105, s105, s3
// W32: encoding: [0x05,0x06,0x20,0xd5,0x69,0xd2,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s6, vcc_lo, v2, s3
// W32: encoding: [0x05,0x06,0x20,0xd5,0x6a,0x04,0x0e,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s6, vcc_hi, v255, s3
// W32: encoding: [0x05,0x06,0x20,0xd5,0x6b,0xfe,0x0f,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s6, ttmp15, ttmp15, s3
// W32: encoding: [0x05,0x06,0x20,0xd5,0x7b,0xf6,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s6, m0, 0.5, s3
// W32: encoding: [0x05,0x06,0x20,0xd5,0x7d,0xe0,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s6, exec_lo, exec_lo, s3
// W32: encoding: [0x05,0x06,0x20,0xd5,0x7e,0xfc,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s6, exec_hi, -1, s3
// W32: encoding: [0x05,0x06,0x20,0xd5,0x7f,0x82,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s105, null, exec_hi, s105
// W32: encoding: [0x05,0x69,0x20,0xd5,0x7c,0xfe,0xa4,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, vcc_lo, -1, m0, vcc_lo
// W32: encoding: [0x05,0x6a,0x20,0xd5,0xc1,0xfa,0xa8,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, vcc_hi, 0.5, vcc_lo, vcc_hi
// W32: encoding: [0x05,0x6b,0x20,0xd5,0xf0,0xd4,0xac,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, ttmp15, src_scc, null, ttmp15
// W32: encoding: [0x05,0x7b,0x20,0xd5,0xfd,0xf8,0xec,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], v1, 0xaf123456, s[6:7]
// W64: encoding: [0x05,0x0c,0x20,0xd5,0x01,0xff,0x19,0x00,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], v255, src_scc, s[6:7]
// W64: encoding: [0x05,0x0c,0x20,0xd5,0xff,0xfb,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], s105, s105, s[6:7]
// W64: encoding: [0x05,0x0c,0x20,0xd5,0x69,0xd2,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], vcc_lo, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x20,0xd5,0x6a,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], vcc_hi, v255, s[6:7]
// W64: encoding: [0x05,0x0c,0x20,0xd5,0x6b,0xfe,0x1b,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], ttmp15, ttmp15, s[6:7]
// W64: encoding: [0x05,0x0c,0x20,0xd5,0x7b,0xf6,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], m0, 0.5, s[6:7]
// W64: encoding: [0x05,0x0c,0x20,0xd5,0x7d,0xe0,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], exec_lo, exec_lo, s[6:7]
// W64: encoding: [0x05,0x0c,0x20,0xd5,0x7e,0xfc,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], exec_hi, -1, s[6:7]
// W64: encoding: [0x05,0x0c,0x20,0xd5,0x7f,0x82,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], null, exec_hi, s[6:7]
// W64: encoding: [0x05,0x0c,0x20,0xd5,0x7c,0xfe,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[104:105], -1, m0, s[104:105]
// W64: encoding: [0x05,0x68,0x20,0xd5,0xc1,0xfa,0xa0,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, vcc, 0.5, vcc_lo, vcc
// W64: encoding: [0x05,0x6a,0x20,0xd5,0xf0,0xd4,0xa8,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, ttmp[14:15], src_scc, null, ttmp[14:15]
// W64: encoding: [0x05,0x7a,0x20,0xd5,0xfd,0xf8,0xe8,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v255, null, 0xaf123456, vcc_hi, null clamp
// GFX12: encoding: [0xff,0xfc,0x20,0xd5,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_add_f16_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0x01,0x05,0x02,0x00]

v_add_f16_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0xff,0xff,0x03,0x00]

v_add_f16_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0x01,0x04,0x00,0x00]

v_add_f16_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0x69,0xd2,0x00,0x00]

v_add_f16_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0x6a,0xf6,0x00,0x00]

v_add_f16_e64 v5, vcc_hi, 0xfe0b
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_add_f16_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0x7b,0xfa,0x01,0x00]

v_add_f16_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0x7d,0xe0,0x01,0x00]

v_add_f16_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0x7e,0x82,0x01,0x00]

v_add_f16_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x32,0xd5,0x7f,0xf8,0x00,0x00]

v_add_f16_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0x7c,0xfc,0x00,0x00]

v_add_f16_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0xc1,0xfe,0x00,0x00]

v_add_f16_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x32,0xd5,0xf0,0xfa,0x00,0x48]

v_add_f16_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x32,0xd5,0xfd,0xd4,0x00,0x30]

v_add_f16_e64 v255, -|0xfe0b|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x32,0xd5,0xff,0xd6,0x00,0x78,0x0b,0xfe,0x00,0x00]

v_add_f32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0xff,0xff,0x03,0x00]

v_add_f32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0x01,0x04,0x00,0x00]

v_add_f32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0x69,0xd2,0x00,0x00]

v_add_f32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0x6a,0xf6,0x00,0x00]

v_add_f32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_add_f32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0x7b,0xfa,0x01,0x00]

v_add_f32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0x7d,0xe0,0x01,0x00]

v_add_f32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0x7e,0x82,0x01,0x00]

v_add_f32_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x03,0xd5,0x7f,0xf8,0x00,0x00]

v_add_f32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0x7c,0xfc,0x00,0x00]

v_add_f32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0xc1,0xfe,0x00,0x00]

v_add_f32_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x03,0xd5,0xf0,0xfa,0x00,0x48]

v_add_f32_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x03,0xd5,0xfd,0xd4,0x00,0x30]

v_add_f32_e64 v255, -|0xaf123456|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x03,0xd5,0xff,0xd6,0x00,0x78,0x56,0x34,0x12,0xaf]

v_add_f64_e64 v[5:6], v[2:3], v[4:5]
// GFX12: encoding: [0x05,0x00,0x02,0xd5,0x02,0x09,0x02,0x00]

v_add_f64_e64 v[5:6], v[104:105], v[104:105]
// GFX12: encoding: [0x05,0x00,0x02,0xd5,0x68,0xd1,0x02,0x00]

v_add_f64_e64 v[5:6], s[2:3], s[4:5]
// GFX12: encoding: [0x05,0x00,0x02,0xd5,0x02,0x08,0x00,0x00]

v_add_f64_e64 v[5:6], s[104:105], s[104:105]
// GFX12: encoding: [0x05,0x00,0x02,0xd5,0x68,0xd0,0x00,0x00]

v_add_f64_e64 v[5:6], vcc, ttmp[14:15]
// GFX12: encoding: [0x05,0x00,0x02,0xd5,0x6a,0xf4,0x00,0x00]

v_add_f64_e64 v[5:6], ttmp[14:15], 0xaf123456
// GFX12: encoding: [0x05,0x00,0x02,0xd5,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_add_f64_e64 v[5:6], -|exec|, src_scc
// GFX12: encoding: [0x05,0x01,0x02,0xd5,0x7e,0xfa,0x01,0x20]

v_add_f64_e64 v[5:6], null, 0.5
// GFX12: encoding: [0x05,0x00,0x02,0xd5,0x7c,0xe0,0x01,0x00]

v_add_f64_e64 v[5:6], -1, -1
// GFX12: encoding: [0x05,0x00,0x02,0xd5,0xc1,0x82,0x01,0x00]

v_add_f64_e64 v[5:6], 0.5, null mul:2
// GFX12: encoding: [0x05,0x00,0x02,0xd5,0xf0,0xf8,0x00,0x08]

v_add_f64_e64 v[5:6], -|src_scc|, -|exec| mul:4
// GFX12: encoding: [0x05,0x03,0x02,0xd5,0xfd,0xfc,0x00,0x70]

v_add_f64_e64 v[254:255], 0xaf123456, -|vcc| clamp div:2
// GFX12: encoding: [0xfe,0x82,0x02,0xd5,0xff,0xd4,0x00,0x58,0x56,0x34,0x12,0xaf]

v_add_nc_u32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0x01,0x05,0x02,0x00]

v_add_nc_u32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0xff,0xff,0x03,0x00]

v_add_nc_u32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0x01,0x04,0x00,0x00]

v_add_nc_u32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0x69,0xd2,0x00,0x00]

v_add_nc_u32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0x6a,0xf6,0x00,0x00]

v_add_nc_u32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_add_nc_u32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0x7b,0xfa,0x01,0x00]

v_add_nc_u32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0x7d,0xe0,0x01,0x00]

v_add_nc_u32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0x7e,0x82,0x01,0x00]

v_add_nc_u32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0x7f,0xf8,0x00,0x00]

v_add_nc_u32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0x7c,0xfc,0x00,0x00]

v_add_nc_u32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0xc1,0xfe,0x00,0x00]

v_add_nc_u32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0xf0,0xfa,0x00,0x00]

v_add_nc_u32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x25,0xd5,0xfd,0xd4,0x00,0x00]

v_add_nc_u32_e64 v255, 0xaf123456, vcc_hi clamp
// GFX12: encoding: [0xff,0x80,0x25,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_and_b32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0x01,0x05,0x02,0x00]

v_and_b32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0xff,0xff,0x03,0x00]

v_and_b32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0x01,0x04,0x00,0x00]

v_and_b32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0x69,0xd2,0x00,0x00]

v_and_b32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0x6a,0xf6,0x00,0x00]

v_and_b32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_and_b32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0x7b,0xfa,0x01,0x00]

v_and_b32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0x7d,0xe0,0x01,0x00]

v_and_b32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0x7e,0x82,0x01,0x00]

v_and_b32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0x7f,0xf8,0x00,0x00]

v_and_b32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0x7c,0xfc,0x00,0x00]

v_and_b32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0xc1,0xfe,0x00,0x00]

v_and_b32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0xf0,0xfa,0x00,0x00]

v_and_b32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x1b,0xd5,0xfd,0xd4,0x00,0x00]

v_and_b32_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x1b,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_ashrrev_i32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0x01,0x05,0x02,0x00]

v_ashrrev_i32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0xff,0xff,0x03,0x00]

v_ashrrev_i32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0x01,0x04,0x00,0x00]

v_ashrrev_i32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0x69,0xd2,0x00,0x00]

v_ashrrev_i32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0x6a,0xf6,0x00,0x00]

v_ashrrev_i32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_ashrrev_i32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0x7b,0xfa,0x01,0x00]

v_ashrrev_i32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0x7d,0xe0,0x01,0x00]

v_ashrrev_i32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0x7e,0x82,0x01,0x00]

v_ashrrev_i32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0x7f,0xf8,0x00,0x00]

v_ashrrev_i32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0x7c,0xfc,0x00,0x00]

v_ashrrev_i32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0xc1,0xfe,0x00,0x00]

v_ashrrev_i32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0xf0,0xfa,0x00,0x00]

v_ashrrev_i32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x1a,0xd5,0xfd,0xd4,0x00,0x00]

v_ashrrev_i32_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x1a,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cndmask_b32_e64 v5, v1, 0xaf123456, s3
// W32: encoding: [0x05,0x00,0x01,0xd5,0x01,0xff,0x0d,0x00,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v255, src_scc, s3
// W32: encoding: [0x05,0x00,0x01,0xd5,0xff,0xfb,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, s105, s105, s3
// W32: encoding: [0x05,0x00,0x01,0xd5,0x69,0xd2,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, vcc_lo, v2, s3
// W32: encoding: [0x05,0x00,0x01,0xd5,0x6a,0x04,0x0e,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, vcc_hi, v255, s3
// W32: encoding: [0x05,0x00,0x01,0xd5,0x6b,0xfe,0x0f,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, ttmp15, ttmp15, s3
// W32: encoding: [0x05,0x00,0x01,0xd5,0x7b,0xf6,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, m0, 0.5, s3
// W32: encoding: [0x05,0x00,0x01,0xd5,0x7d,0xe0,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, exec_lo, exec_lo, s3
// W32: encoding: [0x05,0x00,0x01,0xd5,0x7e,0xfc,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, exec_hi, -1, s3
// W32: encoding: [0x05,0x00,0x01,0xd5,0x7f,0x82,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, null, exec_hi, s105
// W32: encoding: [0x05,0x00,0x01,0xd5,0x7c,0xfe,0xa4,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, -1, m0, vcc_lo
// W32: encoding: [0x05,0x00,0x01,0xd5,0xc1,0xfa,0xa8,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, 0.5, -|vcc_lo|, vcc_hi
// W32: encoding: [0x05,0x02,0x01,0xd5,0xf0,0xd4,0xac,0x41]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, -|src_scc|, null, ttmp15
// W32: encoding: [0x05,0x01,0x01,0xd5,0xfd,0xf8,0xec,0x21]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, 0xaf123456, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x01,0xff,0x19,0x00,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v255, src_scc, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0xff,0xfb,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, s105, s105, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x69,0xd2,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, vcc_lo, v2, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x6a,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, vcc_hi, v255, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x6b,0xfe,0x1b,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, ttmp15, ttmp15, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x7b,0xf6,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, m0, 0.5, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x7d,0xe0,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, exec_lo, exec_lo, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x7e,0xfc,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, exec_hi, -1, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x7f,0x82,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, null, exec_hi, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x7c,0xfe,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, -1, m0, s[104:105]
// W64: encoding: [0x05,0x00,0x01,0xd5,0xc1,0xfa,0xa0,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, 0.5, -|vcc_lo|, vcc
// W64: encoding: [0x05,0x02,0x01,0xd5,0xf0,0xd4,0xa8,0x41]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, -|src_scc|, null, ttmp[14:15]
// W64: encoding: [0x05,0x01,0x01,0xd5,0xfd,0xf8,0xe8,0x21]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v255, -|0xaf123456|, -|vcc_hi|, null
// GFX12: encoding: [0xff,0x03,0x01,0xd5,0xff,0xd6,0xf0,0x61,0x56,0x34,0x12,0xaf]

v_cvt_pk_rtz_f16_f32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x05,0x02,0x00]

v_cvt_pk_rtz_f16_f32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0xff,0xff,0x03,0x00]

v_cvt_pk_rtz_f16_f32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x04,0x00,0x00]

v_cvt_pk_rtz_f16_f32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x69,0xd2,0x00,0x00]

v_cvt_pk_rtz_f16_f32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x6a,0xf6,0x00,0x00]

v_cvt_pk_rtz_f16_f32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cvt_pk_rtz_f16_f32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x7b,0xfa,0x01,0x00]

v_cvt_pk_rtz_f16_f32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x7d,0xe0,0x01,0x00]

v_cvt_pk_rtz_f16_f32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x7e,0x82,0x01,0x00]

v_cvt_pk_rtz_f16_f32_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x2f,0xd5,0x7f,0xf8,0x00,0x00]

v_cvt_pk_rtz_f16_f32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x7c,0xfc,0x00,0x00]

v_cvt_pk_rtz_f16_f32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0xc1,0xfe,0x00,0x00]

v_cvt_pk_rtz_f16_f32_e64 v5, 0.5, -m0
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0xf0,0xfa,0x00,0x40]

v_cvt_pk_rtz_f16_f32_e64 v5, -src_scc, |vcc_lo|
// GFX12: encoding: [0x05,0x02,0x2f,0xd5,0xfd,0xd4,0x00,0x20]

v_cvt_pk_rtz_f16_f32_e64 v255, -|0xaf123456|, -|vcc_hi| clamp
// GFX12: encoding: [0xff,0x83,0x2f,0xd5,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cvt_pkrtz_f16_f32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0xff,0xff,0x03,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x04,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x69,0xd2,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x6a,0xf6,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cvt_pkrtz_f16_f32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x7b,0xfa,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x7d,0xe0,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x7e,0x82,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x2f,0xd5,0x7f,0xf8,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0x7c,0xfc,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0xc1,0xfe,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, 0.5, -m0
// GFX12: encoding: [0x05,0x00,0x2f,0xd5,0xf0,0xfa,0x00,0x40]

v_cvt_pkrtz_f16_f32_e64 v5, -src_scc, |vcc_lo|
// GFX12: encoding: [0x05,0x02,0x2f,0xd5,0xfd,0xd4,0x00,0x20]

v_cvt_pkrtz_f16_f32_e64 v255, -|0xaf123456|, -|vcc_hi| clamp
// GFX12: encoding: [0xff,0x83,0x2f,0xd5,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_fmac_f16_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f16_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0xff,0xff,0x03,0x00]

v_fmac_f16_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0x01,0x04,0x00,0x00]

v_fmac_f16_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0x69,0xd2,0x00,0x00]

v_fmac_f16_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0x6a,0xf6,0x00,0x00]

v_fmac_f16_e64 v5, vcc_hi, 0xfe0b
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_fmac_f16_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0x7b,0xfa,0x01,0x00]

v_fmac_f16_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0x7d,0xe0,0x01,0x00]

v_fmac_f16_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0x7e,0x82,0x01,0x00]

v_fmac_f16_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x36,0xd5,0x7f,0xf8,0x00,0x00]

v_fmac_f16_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0x7c,0xfc,0x00,0x00]

v_fmac_f16_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0xc1,0xfe,0x00,0x00]

v_fmac_f16_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x36,0xd5,0xf0,0xfa,0x00,0x48]

v_fmac_f16_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x36,0xd5,0xfd,0xd4,0x00,0x30]

v_fmac_f16_e64 v255, -|0xfe0b|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x36,0xd5,0xff,0xd6,0x00,0x78,0x0b,0xfe,0x00,0x00]

v_fmac_f32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0xff,0xff,0x03,0x00]

v_fmac_f32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x04,0x00,0x00]

v_fmac_f32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0x69,0xd2,0x00,0x00]

v_fmac_f32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0x6a,0xf6,0x00,0x00]

v_fmac_f32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_fmac_f32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0x7b,0xfa,0x01,0x00]

v_fmac_f32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0x7d,0xe0,0x01,0x00]

v_fmac_f32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0x7e,0x82,0x01,0x00]

v_fmac_f32_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x2b,0xd5,0x7f,0xf8,0x00,0x00]

v_fmac_f32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0x7c,0xfc,0x00,0x00]

v_fmac_f32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0xc1,0xfe,0x00,0x00]

v_fmac_f32_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x2b,0xd5,0xf0,0xfa,0x00,0x48]

v_fmac_f32_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x2b,0xd5,0xfd,0xd4,0x00,0x30]

v_fmac_f32_e64 v255, -|0xaf123456|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x2b,0xd5,0xff,0xd6,0x00,0x78,0x56,0x34,0x12,0xaf]

v_ldexp_f16_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0x01,0x05,0x02,0x00]

v_ldexp_f16_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0xff,0xff,0x03,0x00]

v_ldexp_f16_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0x01,0x04,0x00,0x00]

v_ldexp_f16_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0x69,0xd2,0x00,0x00]

v_ldexp_f16_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0x6a,0xf6,0x00,0x00]

v_ldexp_f16_e64 v5, vcc_hi, 0xfe0b
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_ldexp_f16_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0x7b,0xfa,0x01,0x00]

v_ldexp_f16_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0x7d,0xe0,0x01,0x00]

v_ldexp_f16_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0x7e,0x82,0x01,0x00]

v_ldexp_f16_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0x7f,0xf8,0x00,0x00]

v_ldexp_f16_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0x7c,0xfc,0x00,0x00]

v_ldexp_f16_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0xc1,0xfe,0x00,0x00]

v_ldexp_f16_e64 v5, 0.5, m0 mul:2
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0xf0,0xfa,0x00,0x08]

v_ldexp_f16_e64 v5, src_scc, vcc_lo mul:4
// GFX12: encoding: [0x05,0x00,0x3b,0xd5,0xfd,0xd4,0x00,0x10]

v_ldexp_f16_e64 v255, -|0xfe0b|, vcc_hi clamp div:2
// GFX12: encoding: [0xff,0x81,0x3b,0xd5,0xff,0xd6,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0x01,0x05,0x02,0x00]

v_lshlrev_b32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0xff,0xff,0x03,0x00]

v_lshlrev_b32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0x01,0x04,0x00,0x00]

v_lshlrev_b32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0x69,0xd2,0x00,0x00]

v_lshlrev_b32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0x6a,0xf6,0x00,0x00]

v_lshlrev_b32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_lshlrev_b32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0x7b,0xfa,0x01,0x00]

v_lshlrev_b32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0x7d,0xe0,0x01,0x00]

v_lshlrev_b32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0x7e,0x82,0x01,0x00]

v_lshlrev_b32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0x7f,0xf8,0x00,0x00]

v_lshlrev_b32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0x7c,0xfc,0x00,0x00]

v_lshlrev_b32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0xc1,0xfe,0x00,0x00]

v_lshlrev_b32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0xf0,0xfa,0x00,0x00]

v_lshlrev_b32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x18,0xd5,0xfd,0xd4,0x00,0x00]

v_lshlrev_b32_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x18,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_lshlrev_b64_e64 v[5:6], v1, v[2:3]
// GFX12: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x05,0x02,0x00]

v_lshlrev_b64_e64 v[5:6], v255, v[254:255]
// GFX12: encoding: [0x05,0x00,0x1f,0xd5,0xff,0xfd,0x03,0x00]

v_lshlrev_b64_e64 v[5:6], v1, vcc
// GFX12: encoding: [0x05,0x00,0x1f,0xd5,0x01,0xd5,0x00,0x00]

v_lshlrev_b64_e64 v[5:6], v255, exec
// GFX12: encoding: [0x05,0x00,0x1f,0xd5,0xff,0xfd,0x00,0x00]

v_lshlrev_b64_e64 v[5:6], null, null
// GFX12: encoding: [0x05,0x00,0x1f,0xd5,0x7c,0xf8,0x00,0x00]

v_lshlrev_b64_e64 v[5:6], -1, -1
// GFX12: encoding: [0x05,0x00,0x1f,0xd5,0xc1,0x82,0x01,0x00]

v_lshlrev_b64_e64 v[5:6], 0.5, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x1f,0xd5,0xf0,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_lshlrev_b64_e64 v[5:6], src_scc, src_scc
// GFX12: encoding: [0x05,0x00,0x1f,0xd5,0xfd,0xfa,0x01,0x00]

v_lshlrev_b64_e64 v[254:255], 0xaf123456, 0.5
// GFX12: encoding: [0xfe,0x00,0x1f,0xd5,0xff,0xe0,0x01,0x00,0x56,0x34,0x12,0xaf]

v_lshrrev_b32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0x01,0x05,0x02,0x00]

v_lshrrev_b32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0xff,0xff,0x03,0x00]

v_lshrrev_b32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0x01,0x04,0x00,0x00]

v_lshrrev_b32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0x69,0xd2,0x00,0x00]

v_lshrrev_b32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0x6a,0xf6,0x00,0x00]

v_lshrrev_b32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_lshrrev_b32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0x7b,0xfa,0x01,0x00]

v_lshrrev_b32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0x7d,0xe0,0x01,0x00]

v_lshrrev_b32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0x7e,0x82,0x01,0x00]

v_lshrrev_b32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0x7f,0xf8,0x00,0x00]

v_lshrrev_b32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0x7c,0xfc,0x00,0x00]

v_lshrrev_b32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0xc1,0xfe,0x00,0x00]

v_lshrrev_b32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0xf0,0xfa,0x00,0x00]

v_lshrrev_b32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x19,0xd5,0xfd,0xd4,0x00,0x00]

v_lshrrev_b32_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x19,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_max_num_f16_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0x01,0x05,0x02,0x00]

v_max_num_f16_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0xff,0xff,0x03,0x00]

v_max_num_f16_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0x01,0x04,0x00,0x00]

v_max_num_f16_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0x69,0xd2,0x00,0x00]

v_max_num_f16_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0x6a,0xf6,0x00,0x00]

v_max_num_f16_e64 v5, vcc_hi, 0xfe0b
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_max_num_f16_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0x7b,0xfa,0x01,0x00]

v_max_num_f16_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0x7d,0xe0,0x01,0x00]

v_max_num_f16_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0x7e,0x82,0x01,0x00]

v_max_num_f16_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x31,0xd5,0x7f,0xf8,0x00,0x00]

v_max_num_f16_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0x7c,0xfc,0x00,0x00]

v_max_num_f16_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0xc1,0xfe,0x00,0x00]

v_max_num_f16_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x31,0xd5,0xf0,0xfa,0x00,0x48]

v_max_num_f16_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x31,0xd5,0xfd,0xd4,0x00,0x30]

v_max_num_f16_e64 v255, -|0xfe0b|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x31,0xd5,0xff,0xd6,0x00,0x78,0x0b,0xfe,0x00,0x00]

v_max_num_f32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0x01,0x05,0x02,0x00]

v_max_num_f32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0xff,0xff,0x03,0x00]

v_max_num_f32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0x01,0x04,0x00,0x00]

v_max_num_f32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0x69,0xd2,0x00,0x00]

v_max_num_f32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0x6a,0xf6,0x00,0x00]

v_max_num_f32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_max_num_f32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0x7b,0xfa,0x01,0x00]

v_max_num_f32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0x7d,0xe0,0x01,0x00]

v_max_num_f32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0x7e,0x82,0x01,0x00]

v_max_num_f32_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x16,0xd5,0x7f,0xf8,0x00,0x00]

v_max_num_f32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0x7c,0xfc,0x00,0x00]

v_max_num_f32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0xc1,0xfe,0x00,0x00]

v_max_num_f32_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x16,0xd5,0xf0,0xfa,0x00,0x48]

v_max_num_f32_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x16,0xd5,0xfd,0xd4,0x00,0x30]

v_max_num_f32_e64 v255, -|0xaf123456|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x16,0xd5,0xff,0xd6,0x00,0x78,0x56,0x34,0x12,0xaf]

v_max_num_f64_e64 v[5:6], v[2:3], v[4:5]
// GFX12: encoding: [0x05,0x00,0x0e,0xd5,0x02,0x09,0x02,0x00]

v_max_num_f64_e64 v[5:6], v[104:105], v[104:105]
// GFX12: encoding: [0x05,0x00,0x0e,0xd5,0x68,0xd1,0x02,0x00]

v_max_num_f64_e64 v[5:6], s[2:3], s[4:5]
// GFX12: encoding: [0x05,0x00,0x0e,0xd5,0x02,0x08,0x00,0x00]

v_max_num_f64_e64 v[5:6], s[104:105], s[104:105]
// GFX12: encoding: [0x05,0x00,0x0e,0xd5,0x68,0xd0,0x00,0x00]

v_max_num_f64_e64 v[5:6], vcc, ttmp[14:15]
// GFX12: encoding: [0x05,0x00,0x0e,0xd5,0x6a,0xf4,0x00,0x00]

v_max_num_f64_e64 v[5:6], ttmp[14:15], 0xaf123456
// GFX12: encoding: [0x05,0x00,0x0e,0xd5,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_max_num_f64_e64 v[5:6], -|exec|, src_scc
// GFX12: encoding: [0x05,0x01,0x0e,0xd5,0x7e,0xfa,0x01,0x20]

v_max_num_f64_e64 v[5:6], null, 0.5
// GFX12: encoding: [0x05,0x00,0x0e,0xd5,0x7c,0xe0,0x01,0x00]

v_max_num_f64_e64 v[5:6], -1, -1
// GFX12: encoding: [0x05,0x00,0x0e,0xd5,0xc1,0x82,0x01,0x00]

v_max_num_f64_e64 v[5:6], 0.5, null mul:2
// GFX12: encoding: [0x05,0x00,0x0e,0xd5,0xf0,0xf8,0x00,0x08]

v_max_num_f64_e64 v[5:6], -|src_scc|, -|exec| mul:4
// GFX12: encoding: [0x05,0x03,0x0e,0xd5,0xfd,0xfc,0x00,0x70]

v_max_num_f64_e64 v[254:255], 0xaf123456, -|vcc| clamp div:2
// GFX12: encoding: [0xfe,0x82,0x0e,0xd5,0xff,0xd4,0x00,0x58,0x56,0x34,0x12,0xaf]

v_max_i32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0x01,0x05,0x02,0x00]

v_max_i32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0xff,0xff,0x03,0x00]

v_max_i32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0x01,0x04,0x00,0x00]

v_max_i32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0x69,0xd2,0x00,0x00]

v_max_i32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0x6a,0xf6,0x00,0x00]

v_max_i32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_max_i32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0x7b,0xfa,0x01,0x00]

v_max_i32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0x7d,0xe0,0x01,0x00]

v_max_i32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0x7e,0x82,0x01,0x00]

v_max_i32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0x7f,0xf8,0x00,0x00]

v_max_i32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0x7c,0xfc,0x00,0x00]

v_max_i32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0xc1,0xfe,0x00,0x00]

v_max_i32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0xf0,0xfa,0x00,0x00]

v_max_i32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x12,0xd5,0xfd,0xd4,0x00,0x00]

v_max_i32_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x12,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_max_u32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0x01,0x05,0x02,0x00]

v_max_u32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0xff,0xff,0x03,0x00]

v_max_u32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0x01,0x04,0x00,0x00]

v_max_u32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0x69,0xd2,0x00,0x00]

v_max_u32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0x6a,0xf6,0x00,0x00]

v_max_u32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_max_u32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0x7b,0xfa,0x01,0x00]

v_max_u32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0x7d,0xe0,0x01,0x00]

v_max_u32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0x7e,0x82,0x01,0x00]

v_max_u32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0x7f,0xf8,0x00,0x00]

v_max_u32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0x7c,0xfc,0x00,0x00]

v_max_u32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0xc1,0xfe,0x00,0x00]

v_max_u32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0xf0,0xfa,0x00,0x00]

v_max_u32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x14,0xd5,0xfd,0xd4,0x00,0x00]

v_max_u32_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x14,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_min_num_f16_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0x01,0x05,0x02,0x00]

v_min_num_f16_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0xff,0xff,0x03,0x00]

v_min_num_f16_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0x01,0x04,0x00,0x00]

v_min_num_f16_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0x69,0xd2,0x00,0x00]

v_min_num_f16_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0x6a,0xf6,0x00,0x00]

v_min_num_f16_e64 v5, vcc_hi, 0xfe0b
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_min_num_f16_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0x7b,0xfa,0x01,0x00]

v_min_num_f16_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0x7d,0xe0,0x01,0x00]

v_min_num_f16_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0x7e,0x82,0x01,0x00]

v_min_num_f16_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x30,0xd5,0x7f,0xf8,0x00,0x00]

v_min_num_f16_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0x7c,0xfc,0x00,0x00]

v_min_num_f16_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0xc1,0xfe,0x00,0x00]

v_min_num_f16_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x30,0xd5,0xf0,0xfa,0x00,0x48]

v_min_num_f16_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x30,0xd5,0xfd,0xd4,0x00,0x30]

v_min_num_f16_e64 v255, -|0xfe0b|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x30,0xd5,0xff,0xd6,0x00,0x78,0x0b,0xfe,0x00,0x00]

v_min_num_f32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0x01,0x05,0x02,0x00]

v_min_num_f32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0xff,0xff,0x03,0x00]

v_min_num_f32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0x01,0x04,0x00,0x00]

v_min_num_f32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0x69,0xd2,0x00,0x00]

v_min_num_f32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0x6a,0xf6,0x00,0x00]

v_min_num_f32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_min_num_f32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0x7b,0xfa,0x01,0x00]

v_min_num_f32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0x7d,0xe0,0x01,0x00]

v_min_num_f32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0x7e,0x82,0x01,0x00]

v_min_num_f32_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x15,0xd5,0x7f,0xf8,0x00,0x00]

v_min_num_f32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0x7c,0xfc,0x00,0x00]

v_min_num_f32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0xc1,0xfe,0x00,0x00]

v_min_num_f32_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x15,0xd5,0xf0,0xfa,0x00,0x48]

v_min_num_f32_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x15,0xd5,0xfd,0xd4,0x00,0x30]

v_min_num_f32_e64 v255, -|0xaf123456|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x15,0xd5,0xff,0xd6,0x00,0x78,0x56,0x34,0x12,0xaf]

v_min_num_f64_e64 v[5:6], v[2:3], v[4:5]
// GFX12: encoding: [0x05,0x00,0x0d,0xd5,0x02,0x09,0x02,0x00]

v_min_num_f64_e64 v[5:6], v[104:105], v[104:105]
// GFX12: encoding: [0x05,0x00,0x0d,0xd5,0x68,0xd1,0x02,0x00]

v_min_num_f64_e64 v[5:6], s[2:3], s[4:5]
// GFX12: encoding: [0x05,0x00,0x0d,0xd5,0x02,0x08,0x00,0x00]

v_min_num_f64_e64 v[5:6], s[104:105], s[104:105]
// GFX12: encoding: [0x05,0x00,0x0d,0xd5,0x68,0xd0,0x00,0x00]

v_min_num_f64_e64 v[5:6], vcc, ttmp[14:15]
// GFX12: encoding: [0x05,0x00,0x0d,0xd5,0x6a,0xf4,0x00,0x00]

v_min_num_f64_e64 v[5:6], ttmp[14:15], 0xaf123456
// GFX12: encoding: [0x05,0x00,0x0d,0xd5,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_min_num_f64_e64 v[5:6], -|exec|, src_scc
// GFX12: encoding: [0x05,0x01,0x0d,0xd5,0x7e,0xfa,0x01,0x20]

v_min_num_f64_e64 v[5:6], null, 0.5
// GFX12: encoding: [0x05,0x00,0x0d,0xd5,0x7c,0xe0,0x01,0x00]

v_min_num_f64_e64 v[5:6], -1, -1
// GFX12: encoding: [0x05,0x00,0x0d,0xd5,0xc1,0x82,0x01,0x00]

v_min_num_f64_e64 v[5:6], 0.5, null mul:2
// GFX12: encoding: [0x05,0x00,0x0d,0xd5,0xf0,0xf8,0x00,0x08]

v_min_num_f64_e64 v[5:6], -|src_scc|, -|exec| mul:4
// GFX12: encoding: [0x05,0x03,0x0d,0xd5,0xfd,0xfc,0x00,0x70]

v_min_num_f64_e64 v[254:255], 0xaf123456, -|vcc| clamp div:2
// GFX12: encoding: [0xfe,0x82,0x0d,0xd5,0xff,0xd4,0x00,0x58,0x56,0x34,0x12,0xaf]

v_min_i32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0x01,0x05,0x02,0x00]

v_min_i32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0xff,0xff,0x03,0x00]

v_min_i32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0x01,0x04,0x00,0x00]

v_min_i32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0x69,0xd2,0x00,0x00]

v_min_i32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0x6a,0xf6,0x00,0x00]

v_min_i32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_min_i32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0x7b,0xfa,0x01,0x00]

v_min_i32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0x7d,0xe0,0x01,0x00]

v_min_i32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0x7e,0x82,0x01,0x00]

v_min_i32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0x7f,0xf8,0x00,0x00]

v_min_i32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0x7c,0xfc,0x00,0x00]

v_min_i32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0xc1,0xfe,0x00,0x00]

v_min_i32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0xf0,0xfa,0x00,0x00]

v_min_i32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x11,0xd5,0xfd,0xd4,0x00,0x00]

v_min_i32_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x11,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_min_u32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0x01,0x05,0x02,0x00]

v_min_u32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0xff,0xff,0x03,0x00]

v_min_u32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0x01,0x04,0x00,0x00]

v_min_u32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0x69,0xd2,0x00,0x00]

v_min_u32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0x6a,0xf6,0x00,0x00]

v_min_u32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_min_u32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0x7b,0xfa,0x01,0x00]

v_min_u32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0x7d,0xe0,0x01,0x00]

v_min_u32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0x7e,0x82,0x01,0x00]

v_min_u32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0x7f,0xf8,0x00,0x00]

v_min_u32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0x7c,0xfc,0x00,0x00]

v_min_u32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0xc1,0xfe,0x00,0x00]

v_min_u32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0xf0,0xfa,0x00,0x00]

v_min_u32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x13,0xd5,0xfd,0xd4,0x00,0x00]

v_min_u32_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x13,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_mul_dx9_zero_f32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x01,0x05,0x02,0x00]

v_mul_dx9_zero_f32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0xff,0xff,0x03,0x00]

v_mul_dx9_zero_f32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x01,0x04,0x00,0x00]

v_mul_dx9_zero_f32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x69,0xd2,0x00,0x00]

v_mul_dx9_zero_f32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x6a,0xf6,0x00,0x00]

v_mul_dx9_zero_f32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_dx9_zero_f32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x7b,0xfa,0x01,0x00]

v_mul_dx9_zero_f32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x7d,0xe0,0x01,0x00]

v_mul_dx9_zero_f32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x7e,0x82,0x01,0x00]

v_mul_dx9_zero_f32_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x07,0xd5,0x7f,0xf8,0x00,0x00]

v_mul_dx9_zero_f32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x7c,0xfc,0x00,0x00]

v_mul_dx9_zero_f32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0xc1,0xfe,0x00,0x00]

v_mul_dx9_zero_f32_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0xf0,0xfa,0x00,0x48]

v_mul_dx9_zero_f32_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x07,0xd5,0xfd,0xd4,0x00,0x30]

v_mul_dx9_zero_f32_e64 v255, -|0xaf123456|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x07,0xd5,0xff,0xd6,0x00,0x78,0x56,0x34,0x12,0xaf]

v_mul_f16_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0xff,0xff,0x03,0x00]

v_mul_f16_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0x01,0x04,0x00,0x00]

v_mul_f16_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0x69,0xd2,0x00,0x00]

v_mul_f16_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0x6a,0xf6,0x00,0x00]

v_mul_f16_e64 v5, vcc_hi, 0xfe0b
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_mul_f16_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0x7b,0xfa,0x01,0x00]

v_mul_f16_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0x7d,0xe0,0x01,0x00]

v_mul_f16_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0x7e,0x82,0x01,0x00]

v_mul_f16_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x35,0xd5,0x7f,0xf8,0x00,0x00]

v_mul_f16_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0x7c,0xfc,0x00,0x00]

v_mul_f16_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0xc1,0xfe,0x00,0x00]

v_mul_f16_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x35,0xd5,0xf0,0xfa,0x00,0x48]

v_mul_f16_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x35,0xd5,0xfd,0xd4,0x00,0x30]

v_mul_f16_e64 v255, -|0xfe0b|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x35,0xd5,0xff,0xd6,0x00,0x78,0x0b,0xfe,0x00,0x00]

v_mul_f32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0xff,0xff,0x03,0x00]

v_mul_f32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0x01,0x04,0x00,0x00]

v_mul_f32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0x69,0xd2,0x00,0x00]

v_mul_f32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0x6a,0xf6,0x00,0x00]

v_mul_f32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_f32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0x7b,0xfa,0x01,0x00]

v_mul_f32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0x7d,0xe0,0x01,0x00]

v_mul_f32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0x7e,0x82,0x01,0x00]

v_mul_f32_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x08,0xd5,0x7f,0xf8,0x00,0x00]

v_mul_f32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0x7c,0xfc,0x00,0x00]

v_mul_f32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0xc1,0xfe,0x00,0x00]

v_mul_f32_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x08,0xd5,0xf0,0xfa,0x00,0x48]

v_mul_f32_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x08,0xd5,0xfd,0xd4,0x00,0x30]

v_mul_f32_e64 v255, -|0xaf123456|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x08,0xd5,0xff,0xd6,0x00,0x78,0x56,0x34,0x12,0xaf]

v_mul_f64_e64 v[5:6], v[2:3], v[4:5]
// GFX12: encoding: [0x05,0x00,0x06,0xd5,0x02,0x09,0x02,0x00]

v_mul_f64_e64 v[5:6], v[104:105], v[104:105]
// GFX12: encoding: [0x05,0x00,0x06,0xd5,0x68,0xd1,0x02,0x00]

v_mul_f64_e64 v[5:6], s[2:3], s[4:5]
// GFX12: encoding: [0x05,0x00,0x06,0xd5,0x02,0x08,0x00,0x00]

v_mul_f64_e64 v[5:6], s[104:105], s[104:105]
// GFX12: encoding: [0x05,0x00,0x06,0xd5,0x68,0xd0,0x00,0x00]

v_mul_f64_e64 v[5:6], vcc, ttmp[14:15]
// GFX12: encoding: [0x05,0x00,0x06,0xd5,0x6a,0xf4,0x00,0x00]

v_mul_f64_e64 v[5:6], ttmp[14:15], 0xaf123456
// GFX12: encoding: [0x05,0x00,0x06,0xd5,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_f64_e64 v[5:6], -|exec|, src_scc
// GFX12: encoding: [0x05,0x01,0x06,0xd5,0x7e,0xfa,0x01,0x20]

v_mul_f64_e64 v[5:6], null, 0.5
// GFX12: encoding: [0x05,0x00,0x06,0xd5,0x7c,0xe0,0x01,0x00]

v_mul_f64_e64 v[5:6], -1, -1
// GFX12: encoding: [0x05,0x00,0x06,0xd5,0xc1,0x82,0x01,0x00]

v_mul_f64_e64 v[5:6], 0.5, null mul:2
// GFX12: encoding: [0x05,0x00,0x06,0xd5,0xf0,0xf8,0x00,0x08]

v_mul_f64_e64 v[5:6], -|src_scc|, -|exec| mul:4
// GFX12: encoding: [0x05,0x03,0x06,0xd5,0xfd,0xfc,0x00,0x70]

v_mul_f64_e64 v[254:255], 0xaf123456, -|vcc| clamp div:2
// GFX12: encoding: [0xfe,0x82,0x06,0xd5,0xff,0xd4,0x00,0x58,0x56,0x34,0x12,0xaf]

v_mul_hi_i32_i24_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0x01,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0xff,0xff,0x03,0x00]

v_mul_hi_i32_i24_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0x01,0x04,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0x69,0xd2,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0x6a,0xf6,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_hi_i32_i24_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0x7b,0xfa,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0x7d,0xe0,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0x7e,0x82,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0x7f,0xf8,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0x7c,0xfc,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0xc1,0xfe,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0xf0,0xfa,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x0a,0xd5,0xfd,0xd4,0x00,0x00]

v_mul_hi_i32_i24_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x0a,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_mul_hi_u32_u24_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0x01,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0xff,0xff,0x03,0x00]

v_mul_hi_u32_u24_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0x01,0x04,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0x69,0xd2,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0x6a,0xf6,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_hi_u32_u24_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0x7b,0xfa,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0x7d,0xe0,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0x7e,0x82,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0x7f,0xf8,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0x7c,0xfc,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0xc1,0xfe,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0xf0,0xfa,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x0c,0xd5,0xfd,0xd4,0x00,0x00]

v_mul_hi_u32_u24_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x0c,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_mul_i32_i24_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0x01,0x05,0x02,0x00]

v_mul_i32_i24_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0xff,0xff,0x03,0x00]

v_mul_i32_i24_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0x01,0x04,0x00,0x00]

v_mul_i32_i24_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0x69,0xd2,0x00,0x00]

v_mul_i32_i24_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0x6a,0xf6,0x00,0x00]

v_mul_i32_i24_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_i32_i24_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0x7b,0xfa,0x01,0x00]

v_mul_i32_i24_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0x7d,0xe0,0x01,0x00]

v_mul_i32_i24_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0x7e,0x82,0x01,0x00]

v_mul_i32_i24_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0x7f,0xf8,0x00,0x00]

v_mul_i32_i24_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0x7c,0xfc,0x00,0x00]

v_mul_i32_i24_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0xc1,0xfe,0x00,0x00]

v_mul_i32_i24_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0xf0,0xfa,0x00,0x00]

v_mul_i32_i24_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x09,0xd5,0xfd,0xd4,0x00,0x00]

v_mul_i32_i24_e64 v255, 0xaf123456, vcc_hi clamp
// GFX12: encoding: [0xff,0x80,0x09,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_mul_legacy_f32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0xff,0xff,0x03,0x00]

v_mul_legacy_f32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x01,0x04,0x00,0x00]

v_mul_legacy_f32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x69,0xd2,0x00,0x00]

v_mul_legacy_f32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x6a,0xf6,0x00,0x00]

v_mul_legacy_f32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_legacy_f32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x7b,0xfa,0x01,0x00]

v_mul_legacy_f32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x7d,0xe0,0x01,0x00]

v_mul_legacy_f32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x7e,0x82,0x01,0x00]

v_mul_legacy_f32_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x07,0xd5,0x7f,0xf8,0x00,0x00]

v_mul_legacy_f32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0x7c,0xfc,0x00,0x00]

v_mul_legacy_f32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0xc1,0xfe,0x00,0x00]

v_mul_legacy_f32_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x07,0xd5,0xf0,0xfa,0x00,0x48]

v_mul_legacy_f32_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x07,0xd5,0xfd,0xd4,0x00,0x30]

v_mul_legacy_f32_e64 v255, -|0xaf123456|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x07,0xd5,0xff,0xd6,0x00,0x78,0x56,0x34,0x12,0xaf]

v_mul_u32_u24_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0x01,0x05,0x02,0x00]

v_mul_u32_u24_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0xff,0xff,0x03,0x00]

v_mul_u32_u24_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0x01,0x04,0x00,0x00]

v_mul_u32_u24_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0x69,0xd2,0x00,0x00]

v_mul_u32_u24_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0x6a,0xf6,0x00,0x00]

v_mul_u32_u24_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_u32_u24_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0x7b,0xfa,0x01,0x00]

v_mul_u32_u24_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0x7d,0xe0,0x01,0x00]

v_mul_u32_u24_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0x7e,0x82,0x01,0x00]

v_mul_u32_u24_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0x7f,0xf8,0x00,0x00]

v_mul_u32_u24_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0x7c,0xfc,0x00,0x00]

v_mul_u32_u24_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0xc1,0xfe,0x00,0x00]

v_mul_u32_u24_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0xf0,0xfa,0x00,0x00]

v_mul_u32_u24_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x0b,0xd5,0xfd,0xd4,0x00,0x00]

v_mul_u32_u24_e64 v255, 0xaf123456, vcc_hi clamp
// GFX12: encoding: [0xff,0x80,0x0b,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_or_b32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0x01,0x05,0x02,0x00]

v_or_b32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0xff,0xff,0x03,0x00]

v_or_b32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0x01,0x04,0x00,0x00]

v_or_b32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0x69,0xd2,0x00,0x00]

v_or_b32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0x6a,0xf6,0x00,0x00]

v_or_b32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_or_b32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0x7b,0xfa,0x01,0x00]

v_or_b32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0x7d,0xe0,0x01,0x00]

v_or_b32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0x7e,0x82,0x01,0x00]

v_or_b32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0x7f,0xf8,0x00,0x00]

v_or_b32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0x7c,0xfc,0x00,0x00]

v_or_b32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0xc1,0xfe,0x00,0x00]

v_or_b32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0xf0,0xfa,0x00,0x00]

v_or_b32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x1c,0xd5,0xfd,0xd4,0x00,0x00]

v_or_b32_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x1c,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_sub_co_ci_u32_e64 v5, s6, v1, 0xaf123456, s3
// W32: encoding: [0x05,0x06,0x21,0xd5,0x01,0xff,0x0d,0x00,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s6, v255, src_scc, s3
// W32: encoding: [0x05,0x06,0x21,0xd5,0xff,0xfb,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s6, s105, s105, s3
// W32: encoding: [0x05,0x06,0x21,0xd5,0x69,0xd2,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s6, vcc_lo, v2, s3
// W32: encoding: [0x05,0x06,0x21,0xd5,0x6a,0x04,0x0e,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s6, vcc_hi, v255, s3
// W32: encoding: [0x05,0x06,0x21,0xd5,0x6b,0xfe,0x0f,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s6, ttmp15, ttmp15, s3
// W32: encoding: [0x05,0x06,0x21,0xd5,0x7b,0xf6,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s6, m0, 0.5, s3
// W32: encoding: [0x05,0x06,0x21,0xd5,0x7d,0xe0,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s6, exec_lo, exec_lo, s3
// W32: encoding: [0x05,0x06,0x21,0xd5,0x7e,0xfc,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s6, exec_hi, -1, s3
// W32: encoding: [0x05,0x06,0x21,0xd5,0x7f,0x82,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s105, null, exec_hi, s105
// W32: encoding: [0x05,0x69,0x21,0xd5,0x7c,0xfe,0xa4,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, vcc_lo, -1, m0, vcc_lo
// W32: encoding: [0x05,0x6a,0x21,0xd5,0xc1,0xfa,0xa8,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, vcc_hi, 0.5, vcc_lo, vcc_hi
// W32: encoding: [0x05,0x6b,0x21,0xd5,0xf0,0xd4,0xac,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, ttmp15, src_scc, null, ttmp15
// W32: encoding: [0x05,0x7b,0x21,0xd5,0xfd,0xf8,0xec,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], v1, 0xaf123456, s[6:7]
// W64: encoding: [0x05,0x0c,0x21,0xd5,0x01,0xff,0x19,0x00,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], v255, src_scc, s[6:7]
// W64: encoding: [0x05,0x0c,0x21,0xd5,0xff,0xfb,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], s105, s105, s[6:7]
// W64: encoding: [0x05,0x0c,0x21,0xd5,0x69,0xd2,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], vcc_lo, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x21,0xd5,0x6a,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], vcc_hi, v255, s[6:7]
// W64: encoding: [0x05,0x0c,0x21,0xd5,0x6b,0xfe,0x1b,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], ttmp15, ttmp15, s[6:7]
// W64: encoding: [0x05,0x0c,0x21,0xd5,0x7b,0xf6,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], m0, 0.5, s[6:7]
// W64: encoding: [0x05,0x0c,0x21,0xd5,0x7d,0xe0,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], exec_lo, exec_lo, s[6:7]
// W64: encoding: [0x05,0x0c,0x21,0xd5,0x7e,0xfc,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], exec_hi, -1, s[6:7]
// W64: encoding: [0x05,0x0c,0x21,0xd5,0x7f,0x82,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], null, exec_hi, s[6:7]
// W64: encoding: [0x05,0x0c,0x21,0xd5,0x7c,0xfe,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[104:105], -1, m0, s[104:105]
// W64: encoding: [0x05,0x68,0x21,0xd5,0xc1,0xfa,0xa0,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, vcc, 0.5, vcc_lo, vcc
// W64: encoding: [0x05,0x6a,0x21,0xd5,0xf0,0xd4,0xa8,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, ttmp[14:15], src_scc, null, ttmp[14:15]
// W64: encoding: [0x05,0x7a,0x21,0xd5,0xfd,0xf8,0xe8,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v255, null, 0xaf123456, vcc_hi, null clamp
// GFX12: encoding: [0xff,0xfc,0x21,0xd5,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_sub_f16_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0xff,0xff,0x03,0x00]

v_sub_f16_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0x01,0x04,0x00,0x00]

v_sub_f16_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0x69,0xd2,0x00,0x00]

v_sub_f16_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0x6a,0xf6,0x00,0x00]

v_sub_f16_e64 v5, vcc_hi, 0xfe0b
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_sub_f16_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0x7b,0xfa,0x01,0x00]

v_sub_f16_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0x7d,0xe0,0x01,0x00]

v_sub_f16_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0x7e,0x82,0x01,0x00]

v_sub_f16_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x33,0xd5,0x7f,0xf8,0x00,0x00]

v_sub_f16_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0x7c,0xfc,0x00,0x00]

v_sub_f16_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0xc1,0xfe,0x00,0x00]

v_sub_f16_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x33,0xd5,0xf0,0xfa,0x00,0x48]

v_sub_f16_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x33,0xd5,0xfd,0xd4,0x00,0x30]

v_sub_f16_e64 v255, -|0xfe0b|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x33,0xd5,0xff,0xd6,0x00,0x78,0x0b,0xfe,0x00,0x00]

v_sub_f32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0xff,0xff,0x03,0x00]

v_sub_f32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0x01,0x04,0x00,0x00]

v_sub_f32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0x69,0xd2,0x00,0x00]

v_sub_f32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0x6a,0xf6,0x00,0x00]

v_sub_f32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_sub_f32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0x7b,0xfa,0x01,0x00]

v_sub_f32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0x7d,0xe0,0x01,0x00]

v_sub_f32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0x7e,0x82,0x01,0x00]

v_sub_f32_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x04,0xd5,0x7f,0xf8,0x00,0x00]

v_sub_f32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0x7c,0xfc,0x00,0x00]

v_sub_f32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0xc1,0xfe,0x00,0x00]

v_sub_f32_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x04,0xd5,0xf0,0xfa,0x00,0x48]

v_sub_f32_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x04,0xd5,0xfd,0xd4,0x00,0x30]

v_sub_f32_e64 v255, -|0xaf123456|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x04,0xd5,0xff,0xd6,0x00,0x78,0x56,0x34,0x12,0xaf]

v_sub_nc_u32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0x01,0x05,0x02,0x00]

v_sub_nc_u32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0xff,0xff,0x03,0x00]

v_sub_nc_u32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0x01,0x04,0x00,0x00]

v_sub_nc_u32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0x69,0xd2,0x00,0x00]

v_sub_nc_u32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0x6a,0xf6,0x00,0x00]

v_sub_nc_u32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_sub_nc_u32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0x7b,0xfa,0x01,0x00]

v_sub_nc_u32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0x7d,0xe0,0x01,0x00]

v_sub_nc_u32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0x7e,0x82,0x01,0x00]

v_sub_nc_u32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0x7f,0xf8,0x00,0x00]

v_sub_nc_u32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0x7c,0xfc,0x00,0x00]

v_sub_nc_u32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0xc1,0xfe,0x00,0x00]

v_sub_nc_u32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0xf0,0xfa,0x00,0x00]

v_sub_nc_u32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x26,0xd5,0xfd,0xd4,0x00,0x00]

v_sub_nc_u32_e64 v255, 0xaf123456, vcc_hi clamp
// GFX12: encoding: [0xff,0x80,0x26,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_subrev_co_ci_u32_e64 v5, s6, v1, 0xaf123456, s3
// W32: encoding: [0x05,0x06,0x22,0xd5,0x01,0xff,0x0d,0x00,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s6, v255, src_scc, s3
// W32: encoding: [0x05,0x06,0x22,0xd5,0xff,0xfb,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s6, s105, s105, s3
// W32: encoding: [0x05,0x06,0x22,0xd5,0x69,0xd2,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s6, vcc_lo, v2, s3
// W32: encoding: [0x05,0x06,0x22,0xd5,0x6a,0x04,0x0e,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s6, vcc_hi, v255, s3
// W32: encoding: [0x05,0x06,0x22,0xd5,0x6b,0xfe,0x0f,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s6, ttmp15, ttmp15, s3
// W32: encoding: [0x05,0x06,0x22,0xd5,0x7b,0xf6,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s6, m0, 0.5, s3
// W32: encoding: [0x05,0x06,0x22,0xd5,0x7d,0xe0,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s6, exec_lo, exec_lo, s3
// W32: encoding: [0x05,0x06,0x22,0xd5,0x7e,0xfc,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s6, exec_hi, -1, s3
// W32: encoding: [0x05,0x06,0x22,0xd5,0x7f,0x82,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s105, null, exec_hi, s105
// W32: encoding: [0x05,0x69,0x22,0xd5,0x7c,0xfe,0xa4,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, vcc_lo, -1, m0, vcc_lo
// W32: encoding: [0x05,0x6a,0x22,0xd5,0xc1,0xfa,0xa8,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, vcc_hi, 0.5, vcc_lo, vcc_hi
// W32: encoding: [0x05,0x6b,0x22,0xd5,0xf0,0xd4,0xac,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, ttmp15, src_scc, null, ttmp15
// W32: encoding: [0x05,0x7b,0x22,0xd5,0xfd,0xf8,0xec,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], v1, 0xaf123456, s[6:7]
// W64: encoding: [0x05,0x0c,0x22,0xd5,0x01,0xff,0x19,0x00,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], v255, src_scc, s[6:7]
// W64: encoding: [0x05,0x0c,0x22,0xd5,0xff,0xfb,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], s105, s105, s[6:7]
// W64: encoding: [0x05,0x0c,0x22,0xd5,0x69,0xd2,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], vcc_lo, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x22,0xd5,0x6a,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], vcc_hi, v255, s[6:7]
// W64: encoding: [0x05,0x0c,0x22,0xd5,0x6b,0xfe,0x1b,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], ttmp15, ttmp15, s[6:7]
// W64: encoding: [0x05,0x0c,0x22,0xd5,0x7b,0xf6,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], m0, 0.5, s[6:7]
// W64: encoding: [0x05,0x0c,0x22,0xd5,0x7d,0xe0,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], exec_lo, exec_lo, s[6:7]
// W64: encoding: [0x05,0x0c,0x22,0xd5,0x7e,0xfc,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], exec_hi, -1, s[6:7]
// W64: encoding: [0x05,0x0c,0x22,0xd5,0x7f,0x82,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], null, exec_hi, s[6:7]
// W64: encoding: [0x05,0x0c,0x22,0xd5,0x7c,0xfe,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[104:105], -1, m0, s[104:105]
// W64: encoding: [0x05,0x68,0x22,0xd5,0xc1,0xfa,0xa0,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, vcc, 0.5, vcc_lo, vcc
// W64: encoding: [0x05,0x6a,0x22,0xd5,0xf0,0xd4,0xa8,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, ttmp[14:15], src_scc, null, ttmp[14:15]
// W64: encoding: [0x05,0x7a,0x22,0xd5,0xfd,0xf8,0xe8,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v255, null, 0xaf123456, vcc_hi, null clamp
// GFX12: encoding: [0xff,0xfc,0x22,0xd5,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_subrev_f16_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0xff,0xff,0x03,0x00]

v_subrev_f16_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0x01,0x04,0x00,0x00]

v_subrev_f16_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0x69,0xd2,0x00,0x00]

v_subrev_f16_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0x6a,0xf6,0x00,0x00]

v_subrev_f16_e64 v5, vcc_hi, 0xfe0b
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_subrev_f16_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0x7b,0xfa,0x01,0x00]

v_subrev_f16_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0x7d,0xe0,0x01,0x00]

v_subrev_f16_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0x7e,0x82,0x01,0x00]

v_subrev_f16_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x34,0xd5,0x7f,0xf8,0x00,0x00]

v_subrev_f16_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0x7c,0xfc,0x00,0x00]

v_subrev_f16_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0xc1,0xfe,0x00,0x00]

v_subrev_f16_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x34,0xd5,0xf0,0xfa,0x00,0x48]

v_subrev_f16_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x34,0xd5,0xfd,0xd4,0x00,0x30]

v_subrev_f16_e64 v255, -|0xfe0b|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x34,0xd5,0xff,0xd6,0x00,0x78,0x0b,0xfe,0x00,0x00]

v_subrev_f32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0xff,0xff,0x03,0x00]

v_subrev_f32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0x01,0x04,0x00,0x00]

v_subrev_f32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0x69,0xd2,0x00,0x00]

v_subrev_f32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0x6a,0xf6,0x00,0x00]

v_subrev_f32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_subrev_f32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0x7b,0xfa,0x01,0x00]

v_subrev_f32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0x7d,0xe0,0x01,0x00]

v_subrev_f32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0x7e,0x82,0x01,0x00]

v_subrev_f32_e64 v5, |exec_hi|, null
// GFX12: encoding: [0x05,0x01,0x05,0xd5,0x7f,0xf8,0x00,0x00]

v_subrev_f32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0x7c,0xfc,0x00,0x00]

v_subrev_f32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0xc1,0xfe,0x00,0x00]

v_subrev_f32_e64 v5, 0.5, -m0 mul:2
// GFX12: encoding: [0x05,0x00,0x05,0xd5,0xf0,0xfa,0x00,0x48]

v_subrev_f32_e64 v5, -src_scc, |vcc_lo| mul:4
// GFX12: encoding: [0x05,0x02,0x05,0xd5,0xfd,0xd4,0x00,0x30]

v_subrev_f32_e64 v255, -|0xaf123456|, -|vcc_hi| clamp div:2
// GFX12: encoding: [0xff,0x83,0x05,0xd5,0xff,0xd6,0x00,0x78,0x56,0x34,0x12,0xaf]

v_subrev_nc_u32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0x01,0x05,0x02,0x00]

v_subrev_nc_u32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0xff,0xff,0x03,0x00]

v_subrev_nc_u32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0x01,0x04,0x00,0x00]

v_subrev_nc_u32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0x69,0xd2,0x00,0x00]

v_subrev_nc_u32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0x6a,0xf6,0x00,0x00]

v_subrev_nc_u32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_subrev_nc_u32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0x7b,0xfa,0x01,0x00]

v_subrev_nc_u32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0x7d,0xe0,0x01,0x00]

v_subrev_nc_u32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0x7e,0x82,0x01,0x00]

v_subrev_nc_u32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0x7f,0xf8,0x00,0x00]

v_subrev_nc_u32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0x7c,0xfc,0x00,0x00]

v_subrev_nc_u32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0xc1,0xfe,0x00,0x00]

v_subrev_nc_u32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0xf0,0xfa,0x00,0x00]

v_subrev_nc_u32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x27,0xd5,0xfd,0xd4,0x00,0x00]

v_subrev_nc_u32_e64 v255, 0xaf123456, vcc_hi clamp
// GFX12: encoding: [0xff,0x80,0x27,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_xnor_b32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0x01,0x05,0x02,0x00]

v_xnor_b32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0xff,0xff,0x03,0x00]

v_xnor_b32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0x01,0x04,0x00,0x00]

v_xnor_b32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0x69,0xd2,0x00,0x00]

v_xnor_b32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0x6a,0xf6,0x00,0x00]

v_xnor_b32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_xnor_b32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0x7b,0xfa,0x01,0x00]

v_xnor_b32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0x7d,0xe0,0x01,0x00]

v_xnor_b32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0x7e,0x82,0x01,0x00]

v_xnor_b32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0x7f,0xf8,0x00,0x00]

v_xnor_b32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0x7c,0xfc,0x00,0x00]

v_xnor_b32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0xc1,0xfe,0x00,0x00]

v_xnor_b32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0xf0,0xfa,0x00,0x00]

v_xnor_b32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x1e,0xd5,0xfd,0xd4,0x00,0x00]

v_xnor_b32_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x1e,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_xor_b32_e64 v5, v1, v2
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0x01,0x05,0x02,0x00]

v_xor_b32_e64 v5, v255, v255
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0xff,0xff,0x03,0x00]

v_xor_b32_e64 v5, s1, s2
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0x01,0x04,0x00,0x00]

v_xor_b32_e64 v5, s105, s105
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0x69,0xd2,0x00,0x00]

v_xor_b32_e64 v5, vcc_lo, ttmp15
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0x6a,0xf6,0x00,0x00]

v_xor_b32_e64 v5, vcc_hi, 0xaf123456
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_xor_b32_e64 v5, ttmp15, src_scc
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0x7b,0xfa,0x01,0x00]

v_xor_b32_e64 v5, m0, 0.5
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0x7d,0xe0,0x01,0x00]

v_xor_b32_e64 v5, exec_lo, -1
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0x7e,0x82,0x01,0x00]

v_xor_b32_e64 v5, exec_hi, null
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0x7f,0xf8,0x00,0x00]

v_xor_b32_e64 v5, null, exec_lo
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0x7c,0xfc,0x00,0x00]

v_xor_b32_e64 v5, -1, exec_hi
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0xc1,0xfe,0x00,0x00]

v_xor_b32_e64 v5, 0.5, m0
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0xf0,0xfa,0x00,0x00]

v_xor_b32_e64 v5, src_scc, vcc_lo
// GFX12: encoding: [0x05,0x00,0x1d,0xd5,0xfd,0xd4,0x00,0x00]

v_xor_b32_e64 v255, 0xaf123456, vcc_hi
// GFX12: encoding: [0xff,0x00,0x1d,0xd5,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]
