; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=mips-linux-gnu -march=mips -mcpu=mips32 | FileCheck %s --check-prefixes=CHECK,CHECK-BE
; RUN: llc < %s -mtriple=mipsel-linux-gnu -march=mipsel -mcpu=mips32 | FileCheck %s --check-prefixes=CHECK,CHECK-LE

declare i8 @llvm.fshl.i8(i8, i8, i8)
declare i16 @llvm.fshl.i16(i16, i16, i16)
declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i64 @llvm.fshl.i64(i64, i64, i64)
declare <4 x i32> @llvm.fshl.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)

declare i8 @llvm.fshr.i8(i8, i8, i8)
declare i16 @llvm.fshr.i16(i16, i16, i16)
declare i32 @llvm.fshr.i32(i32, i32, i32)
declare i64 @llvm.fshr.i64(i64, i64, i64)
declare <4 x i32> @llvm.fshr.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)

; When first 2 operands match, it's a rotate.

define i8 @rotl_i8_const_shift(i8 %x) {
; CHECK-LABEL: rotl_i8_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll $1, $4, 3
; CHECK-NEXT:    andi $2, $4, 224
; CHECK-NEXT:    srl $2, $2, 5
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $1, $2
  %f = call i8 @llvm.fshl.i8(i8 %x, i8 %x, i8 3)
  ret i8 %f
}

define i64 @rotl_i64_const_shift(i64 %x) {
; CHECK-LABEL: rotl_i64_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl $1, $5, 29
; CHECK-NEXT:    sll $2, $4, 3
; CHECK-NEXT:    or $2, $2, $1
; CHECK-NEXT:    srl $1, $4, 29
; CHECK-NEXT:    sll $3, $5, 3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $3, $3, $1
  %f = call i64 @llvm.fshl.i64(i64 %x, i64 %x, i64 3)
  ret i64 %f
}

; When first 2 operands match, it's a rotate (by variable amount).

define i16 @rotl_i16(i16 %x, i16 %z) {
; CHECK-LABEL: rotl_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi $1, $5, 15
; CHECK-NEXT:    sllv $1, $4, $1
; CHECK-NEXT:    negu $2, $5
; CHECK-NEXT:    andi $2, $2, 15
; CHECK-NEXT:    andi $3, $4, 65535
; CHECK-NEXT:    srlv $2, $3, $2
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $1, $2
  %f = call i16 @llvm.fshl.i16(i16 %x, i16 %x, i16 %z)
  ret i16 %f
}

define i32 @rotl_i32(i32 %x, i32 %z) {
; CHECK-LABEL: rotl_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sllv $1, $4, $5
; CHECK-NEXT:    negu $2, $5
; CHECK-NEXT:    srlv $2, $4, $2
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $1, $2
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %x, i32 %z)
  ret i32 %f
}

define i64 @rotl_i64(i64 %x, i64 %z) {
; CHECK-BE-LABEL: rotl_i64:
; CHECK-BE:       # %bb.0:
; CHECK-BE-NEXT:    srl $1, $7, 5
; CHECK-BE-NEXT:    andi $1, $1, 1
; CHECK-BE-NEXT:    move $3, $4
; CHECK-BE-NEXT:    movn $3, $5, $1
; CHECK-BE-NEXT:    sllv $2, $3, $7
; CHECK-BE-NEXT:    movn $5, $4, $1
; CHECK-BE-NEXT:    srl $1, $5, 1
; CHECK-BE-NEXT:    not $4, $7
; CHECK-BE-NEXT:    srlv $1, $1, $4
; CHECK-BE-NEXT:    or $2, $2, $1
; CHECK-BE-NEXT:    sllv $1, $5, $7
; CHECK-BE-NEXT:    srl $3, $3, 1
; CHECK-BE-NEXT:    srlv $3, $3, $4
; CHECK-BE-NEXT:    jr $ra
; CHECK-BE-NEXT:    or $3, $1, $3
;
; CHECK-LE-LABEL: rotl_i64:
; CHECK-LE:       # %bb.0:
; CHECK-LE-NEXT:    srl $1, $6, 5
; CHECK-LE-NEXT:    andi $1, $1, 1
; CHECK-LE-NEXT:    move $3, $4
; CHECK-LE-NEXT:    movn $3, $5, $1
; CHECK-LE-NEXT:    sllv $2, $3, $6
; CHECK-LE-NEXT:    movn $5, $4, $1
; CHECK-LE-NEXT:    srl $1, $5, 1
; CHECK-LE-NEXT:    not $4, $6
; CHECK-LE-NEXT:    srlv $1, $1, $4
; CHECK-LE-NEXT:    or $2, $2, $1
; CHECK-LE-NEXT:    sllv $1, $5, $6
; CHECK-LE-NEXT:    srl $3, $3, 1
; CHECK-LE-NEXT:    srlv $3, $3, $4
; CHECK-LE-NEXT:    jr $ra
; CHECK-LE-NEXT:    or $3, $1, $3
  %f = call i64 @llvm.fshl.i64(i64 %x, i64 %x, i64 %z)
  ret i64 %f
}

; Vector rotate.

define <4 x i32> @rotl_v4i32(<4 x i32> %x, <4 x i32> %z) {
; CHECK-LABEL: rotl_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lw $1, 20($sp)
; CHECK-NEXT:    negu $2, $1
; CHECK-NEXT:    lw $3, 24($sp)
; CHECK-NEXT:    negu $8, $3
; CHECK-NEXT:    sllv $9, $6, $3
; CHECK-NEXT:    srlv $6, $6, $8
; CHECK-NEXT:    sllv $1, $5, $1
; CHECK-NEXT:    srlv $3, $5, $2
; CHECK-NEXT:    lw $2, 16($sp)
; CHECK-NEXT:    sllv $5, $4, $2
; CHECK-NEXT:    negu $2, $2
; CHECK-NEXT:    srlv $2, $4, $2
; CHECK-NEXT:    or $2, $5, $2
; CHECK-NEXT:    or $3, $1, $3
; CHECK-NEXT:    or $4, $9, $6
; CHECK-NEXT:    lw $1, 28($sp)
; CHECK-NEXT:    sllv $5, $7, $1
; CHECK-NEXT:    negu $1, $1
; CHECK-NEXT:    srlv $1, $7, $1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $5, $5, $1
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> %z)
  ret <4 x i32> %f
}

; Vector rotate by constant splat amount.

define <4 x i32> @rotl_v4i32_rotl_const_shift(<4 x i32> %x) {
; CHECK-LABEL: rotl_v4i32_rotl_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl $1, $5, 29
; CHECK-NEXT:    sll $3, $5, 3
; CHECK-NEXT:    srl $2, $4, 29
; CHECK-NEXT:    sll $4, $4, 3
; CHECK-NEXT:    or $2, $4, $2
; CHECK-NEXT:    or $3, $3, $1
; CHECK-NEXT:    srl $1, $6, 29
; CHECK-NEXT:    sll $4, $6, 3
; CHECK-NEXT:    or $4, $4, $1
; CHECK-NEXT:    srl $1, $7, 29
; CHECK-NEXT:    sll $5, $7, 3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $5, $5, $1
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> <i32 3, i32 3, i32 3, i32 3>)
  ret <4 x i32> %f
}

; Repeat everything for funnel shift right.

; When first 2 operands match, it's a rotate.

define i8 @rotr_i8_const_shift(i8 %x) {
; CHECK-LABEL: rotr_i8_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll $1, $4, 5
; CHECK-NEXT:    andi $2, $4, 248
; CHECK-NEXT:    srl $2, $2, 3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $2, $1
  %f = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 3)
  ret i8 %f
}

define i32 @rotr_i32_const_shift(i32 %x) {
; CHECK-LABEL: rotr_i32_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll $1, $4, 29
; CHECK-NEXT:    srl $2, $4, 3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $2, $1
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %x, i32 3)
  ret i32 %f
}

; When first 2 operands match, it's a rotate (by variable amount).

define i16 @rotr_i16(i16 %x, i16 %z) {
; CHECK-LABEL: rotr_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi $1, $5, 15
; CHECK-NEXT:    andi $2, $4, 65535
; CHECK-NEXT:    srlv $1, $2, $1
; CHECK-NEXT:    negu $2, $5
; CHECK-NEXT:    andi $2, $2, 15
; CHECK-NEXT:    sllv $2, $4, $2
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $1, $2
  %f = call i16 @llvm.fshr.i16(i16 %x, i16 %x, i16 %z)
  ret i16 %f
}

define i32 @rotr_i32(i32 %x, i32 %z) {
; CHECK-LABEL: rotr_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srlv $1, $4, $5
; CHECK-NEXT:    negu $2, $5
; CHECK-NEXT:    sllv $2, $4, $2
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $1, $2
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %x, i32 %z)
  ret i32 %f
}

define i64 @rotr_i64(i64 %x, i64 %z) {
; CHECK-BE-LABEL: rotr_i64:
; CHECK-BE:       # %bb.0:
; CHECK-BE-NEXT:    andi $1, $7, 32
; CHECK-BE-NEXT:    move $3, $5
; CHECK-BE-NEXT:    movz $3, $4, $1
; CHECK-BE-NEXT:    srlv $2, $3, $7
; CHECK-BE-NEXT:    movz $4, $5, $1
; CHECK-BE-NEXT:    sll $1, $4, 1
; CHECK-BE-NEXT:    not $5, $7
; CHECK-BE-NEXT:    sllv $1, $1, $5
; CHECK-BE-NEXT:    or $2, $1, $2
; CHECK-BE-NEXT:    srlv $1, $4, $7
; CHECK-BE-NEXT:    sll $3, $3, 1
; CHECK-BE-NEXT:    sllv $3, $3, $5
; CHECK-BE-NEXT:    jr $ra
; CHECK-BE-NEXT:    or $3, $3, $1
;
; CHECK-LE-LABEL: rotr_i64:
; CHECK-LE:       # %bb.0:
; CHECK-LE-NEXT:    andi $1, $6, 32
; CHECK-LE-NEXT:    move $3, $5
; CHECK-LE-NEXT:    movz $3, $4, $1
; CHECK-LE-NEXT:    srlv $2, $3, $6
; CHECK-LE-NEXT:    movz $4, $5, $1
; CHECK-LE-NEXT:    sll $1, $4, 1
; CHECK-LE-NEXT:    not $5, $6
; CHECK-LE-NEXT:    sllv $1, $1, $5
; CHECK-LE-NEXT:    or $2, $1, $2
; CHECK-LE-NEXT:    srlv $1, $4, $6
; CHECK-LE-NEXT:    sll $3, $3, 1
; CHECK-LE-NEXT:    sllv $3, $3, $5
; CHECK-LE-NEXT:    jr $ra
; CHECK-LE-NEXT:    or $3, $3, $1
  %f = call i64 @llvm.fshr.i64(i64 %x, i64 %x, i64 %z)
  ret i64 %f
}

; Vector rotate.

define <4 x i32> @rotr_v4i32(<4 x i32> %x, <4 x i32> %z) {
; CHECK-LABEL: rotr_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lw $1, 20($sp)
; CHECK-NEXT:    negu $2, $1
; CHECK-NEXT:    lw $3, 24($sp)
; CHECK-NEXT:    negu $8, $3
; CHECK-NEXT:    srlv $9, $6, $3
; CHECK-NEXT:    sllv $6, $6, $8
; CHECK-NEXT:    srlv $1, $5, $1
; CHECK-NEXT:    sllv $3, $5, $2
; CHECK-NEXT:    lw $2, 16($sp)
; CHECK-NEXT:    srlv $5, $4, $2
; CHECK-NEXT:    negu $2, $2
; CHECK-NEXT:    sllv $2, $4, $2
; CHECK-NEXT:    or $2, $5, $2
; CHECK-NEXT:    or $3, $1, $3
; CHECK-NEXT:    or $4, $9, $6
; CHECK-NEXT:    lw $1, 28($sp)
; CHECK-NEXT:    srlv $5, $7, $1
; CHECK-NEXT:    negu $1, $1
; CHECK-NEXT:    sllv $1, $7, $1
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $5, $5, $1
  %f = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> %z)
  ret <4 x i32> %f
}

; Vector rotate by constant splat amount.

define <4 x i32> @rotr_v4i32_const_shift(<4 x i32> %x) {
; CHECK-LABEL: rotr_v4i32_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll $1, $5, 29
; CHECK-NEXT:    srl $3, $5, 3
; CHECK-NEXT:    sll $2, $4, 29
; CHECK-NEXT:    srl $4, $4, 3
; CHECK-NEXT:    or $2, $4, $2
; CHECK-NEXT:    or $3, $3, $1
; CHECK-NEXT:    sll $1, $6, 29
; CHECK-NEXT:    srl $4, $6, 3
; CHECK-NEXT:    or $4, $4, $1
; CHECK-NEXT:    sll $1, $7, 29
; CHECK-NEXT:    srl $5, $7, 3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $5, $5, $1
  %f = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> <i32 3, i32 3, i32 3, i32 3>)
  ret <4 x i32> %f
}

define i32 @rotl_i32_shift_by_bitwidth(i32 %x) {
; CHECK-LABEL: rotl_i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $4
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %x, i32 32)
  ret i32 %f
}

define i32 @rotr_i32_shift_by_bitwidth(i32 %x) {
; CHECK-LABEL: rotr_i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $4
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %x, i32 32)
  ret i32 %f
}

define <4 x i32> @rotl_v4i32_shift_by_bitwidth(<4 x i32> %x) {
; CHECK-LABEL: rotl_v4i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    move $2, $4
; CHECK-NEXT:    move $3, $5
; CHECK-NEXT:    move $4, $6
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $5, $7
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> <i32 32, i32 32, i32 32, i32 32>)
  ret <4 x i32> %f
}

define <4 x i32> @rotr_v4i32_shift_by_bitwidth(<4 x i32> %x) {
; CHECK-LABEL: rotr_v4i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    move $2, $4
; CHECK-NEXT:    move $3, $5
; CHECK-NEXT:    move $4, $6
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $5, $7
  %f = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> <i32 32, i32 32, i32 32, i32 32>)
  ret <4 x i32> %f
}

