; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sme2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=STRIDED
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve2p1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CONTIGUOUS

define <vscale x 32 x i8> @ld1_x2_i8_z0_z8(<vscale x 16 x i8> %unused, <vscale x 16 x i8> %z1, target("aarch64.svcount") %pn, ptr %ptr) nounwind {
; CHECK-LABEL: ld1_x2_i8_z0_z8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1b { z0.b, z8.b }, pn8/z, [x0]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z8.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x2_i8_z0_z8:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1b { z0.b, z8.b }, pn8/z, [x0]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z8.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x2_i8_z0_z8:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-16
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-2
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1b { z0.b, z1.b }, pn8/z, [x0]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #2
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #16
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %res = call { <vscale x 16 x i8>, <vscale x 16 x i8> } @llvm.aarch64.sve.ld1.pn.x2.nxv16i8(target("aarch64.svcount") %pn, ptr %ptr)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z4},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z12},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 0
  %v0 = call <vscale x 32 x i8> @llvm.vector.insert.nxv32i8.nxv16i8(<vscale x 32 x i8> poison, <vscale x 16 x i8> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 1
  %v1 = call <vscale x 32 x i8> @llvm.vector.insert.nxv32i8.nxv16i8(<vscale x 32 x i8> %v0, <vscale x 16 x i8> %res.v1, i64 16)
  ret <vscale x 32 x i8> %v1
}

define <vscale x 32 x i8> @ld1_x2_i8_z0_z8_scalar(<vscale x 16 x i8> %unused, <vscale x 16 x i8> %z1, target("aarch64.svcount") %pn, ptr %ptr, i64 %index) nounwind {
; CHECK-LABEL: ld1_x2_i8_z0_z8_scalar:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1b { z0.b, z8.b }, pn8/z, [x0, x1]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z8.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x2_i8_z0_z8_scalar:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1b { z0.b, z8.b }, pn8/z, [x0, x1]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z8.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x2_i8_z0_z8_scalar:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-16
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-2
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1b { z0.b, z1.b }, pn8/z, [x0, x1]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #2
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #16
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %base = getelementptr i8, ptr %ptr, i64 %index
  %res = call { <vscale x 16 x i8>, <vscale x 16 x i8> } @llvm.aarch64.sve.ld1.pn.x2.nxv16i8(target("aarch64.svcount") %pn, ptr %base)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z4},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z12},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 0
  %v0 = call <vscale x 32 x i8> @llvm.vector.insert.nxv32i8.nxv16i8(<vscale x 32 x i8> poison, <vscale x 16 x i8> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 1
  %v1 = call <vscale x 32 x i8> @llvm.vector.insert.nxv32i8.nxv16i8(<vscale x 32 x i8> %v0, <vscale x 16 x i8> %res.v1, i64 16)
  ret <vscale x 32 x i8> %v1
}

define <vscale x 16 x i16> @ld1_x2_i16_z0_z8(<vscale x 8 x i16> %unused, <vscale x 8 x i16> %z1, target("aarch64.svcount") %pn, ptr %ptr) nounwind {
; CHECK-LABEL: ld1_x2_i16_z0_z8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1h { z0.h, z8.h }, pn8/z, [x0]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z8.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x2_i16_z0_z8:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1h { z0.h, z8.h }, pn8/z, [x0]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z8.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x2_i16_z0_z8:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-16
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-2
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1h { z0.h, z1.h }, pn8/z, [x0]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #2
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #16
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %res = call { <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld1.pn.x2.nxv8i16(target("aarch64.svcount") %pn, ptr %ptr)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z4},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z12},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 0
  %v0 = call <vscale x 16 x i16> @llvm.vector.insert.nxv16i16.nxv8i16(<vscale x 16 x i16> poison, <vscale x 8 x i16> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 1
  %v1 = call <vscale x 16 x i16> @llvm.vector.insert.nxv16i16.nxv8i16(<vscale x 16 x i16> %v0, <vscale x 8 x i16> %res.v1, i64 8)
  ret <vscale x 16 x i16> %v1
}

define <vscale x 16 x i16> @ld1_x2_i16_z0_z8_scalar(<vscale x 8 x i16> %unused, <vscale x 8 x i16> %z1, target("aarch64.svcount") %pn, ptr %ptr, i64 %index) nounwind {
; CHECK-LABEL: ld1_x2_i16_z0_z8_scalar:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1h { z0.h, z8.h }, pn8/z, [x0, x1, lsl #1]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z8.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x2_i16_z0_z8_scalar:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1h { z0.h, z8.h }, pn8/z, [x0, x1, lsl #1]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z8.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x2_i16_z0_z8_scalar:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-16
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-2
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1h { z0.h, z1.h }, pn8/z, [x0, x1, lsl #1]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #2
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #16
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %base = getelementptr i16, ptr %ptr, i64 %index
  %res = call { <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld1.pn.x2.nxv8i16(target("aarch64.svcount") %pn, ptr %base)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z4},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z12},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 0
  %v0 = call <vscale x 16 x i16> @llvm.vector.insert.nxv16i16.nxv8i16(<vscale x 16 x i16> poison, <vscale x 8 x i16> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 1
  %v1 = call <vscale x 16 x i16> @llvm.vector.insert.nxv16i16.nxv8i16(<vscale x 16 x i16> %v0, <vscale x 8 x i16> %res.v1, i64 8)
  ret <vscale x 16 x i16> %v1
}

define <vscale x 8 x i32> @ld1_x2_i32_z0_z8(<vscale x 4 x i32> %unused, <vscale x 4 x i32> %z1, target("aarch64.svcount") %pn, ptr %ptr) nounwind {
; CHECK-LABEL: ld1_x2_i32_z0_z8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1w { z0.s, z8.s }, pn8/z, [x0]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z8.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x2_i32_z0_z8:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1w { z0.s, z8.s }, pn8/z, [x0]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z8.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x2_i32_z0_z8:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-16
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-2
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1w { z0.s, z1.s }, pn8/z, [x0]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #2
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #16
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %res = call { <vscale x 4 x i32>, <vscale x 4 x i32> } @llvm.aarch64.sve.ld1.pn.x2.nxv4i32(target("aarch64.svcount") %pn, ptr %ptr)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z4},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z12},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 0
  %v0 = call <vscale x 8 x i32> @llvm.vector.insert.nxv8i32.nxv4i32(<vscale x 8 x i32> poison, <vscale x 4 x i32> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 1
  %v1 = call <vscale x 8 x i32> @llvm.vector.insert.nxv8i32.nxv4i32(<vscale x 8 x i32> %v0, <vscale x 4 x i32> %res.v1, i64 4)
  ret <vscale x 8 x i32> %v1
}

define <vscale x 8 x i32> @ld1_x2_i32_z0_z8_scalar(<vscale x 4 x i32> %unused, <vscale x 4 x i32> %z1, target("aarch64.svcount") %pn, ptr %ptr, i64 %index) nounwind {
; CHECK-LABEL: ld1_x2_i32_z0_z8_scalar:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1w { z0.s, z8.s }, pn8/z, [x0, x1, lsl #2]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z8.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x2_i32_z0_z8_scalar:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1w { z0.s, z8.s }, pn8/z, [x0, x1, lsl #2]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z8.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x2_i32_z0_z8_scalar:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-16
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-2
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1w { z0.s, z1.s }, pn8/z, [x0, x1, lsl #2]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #2
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #16
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %base = getelementptr i32, ptr %ptr, i64 %index
  %res = call { <vscale x 4 x i32>, <vscale x 4 x i32> } @llvm.aarch64.sve.ld1.pn.x2.nxv4i32(target("aarch64.svcount") %pn, ptr %base)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z4},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z12},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 0
  %v0 = call <vscale x 8 x i32> @llvm.vector.insert.nxv8i32.nxv4i32(<vscale x 8 x i32> poison, <vscale x 4 x i32> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 1
  %v1 = call <vscale x 8 x i32> @llvm.vector.insert.nxv8i32.nxv4i32(<vscale x 8 x i32> %v0, <vscale x 4 x i32> %res.v1, i64 4)
  ret <vscale x 8 x i32> %v1
}

define <vscale x 4 x i64> @ld1_x2_i64_z0_z8(<vscale x 2 x i64> %unused, <vscale x 2 x i64> %z1, target("aarch64.svcount") %pn, ptr %ptr) nounwind {
; CHECK-LABEL: ld1_x2_i64_z0_z8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1d { z0.d, z8.d }, pn8/z, [x0]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z8.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x2_i64_z0_z8:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1d { z0.d, z8.d }, pn8/z, [x0]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z8.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x2_i64_z0_z8:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-16
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-2
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1d { z0.d, z1.d }, pn8/z, [x0]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #2
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #16
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %res = call { <vscale x 2 x i64>, <vscale x 2 x i64> } @llvm.aarch64.sve.ld1.pn.x2.nxv2i64(target("aarch64.svcount") %pn, ptr %ptr)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z4},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z12},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 0
  %v0 = call <vscale x 4 x i64> @llvm.vector.insert.nxv4i64.nxv2i64(<vscale x 4 x i64> poison, <vscale x 2 x i64> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 1
  %v1 = call <vscale x 4 x i64> @llvm.vector.insert.nxv4i64.nxv2i64(<vscale x 4 x i64> %v0, <vscale x 2 x i64> %res.v1, i64 2)
  ret <vscale x 4 x i64> %v1
}

define <vscale x 4 x i64> @ld1_x2_i64_z0_z8_scalar(<vscale x 2 x i64> %unused, <vscale x 2 x i64> %z1, target("aarch64.svcount") %pn, ptr %ptr, i64 %index) nounwind {
; CHECK-LABEL: ld1_x2_i64_z0_z8_scalar:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1d { z0.d, z8.d }, pn8/z, [x0, x1, lsl #3]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z8.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x2_i64_z0_z8_scalar:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1d { z0.d, z8.d }, pn8/z, [x0, x1, lsl #3]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z8.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x2_i64_z0_z8_scalar:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-16
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-2
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1d { z0.d, z1.d }, pn8/z, [x0, x1, lsl #3]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #2
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #16
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %base = getelementptr i64, ptr %ptr, i64 %index
  %res = call { <vscale x 2 x i64>, <vscale x 2 x i64> } @llvm.aarch64.sve.ld1.pn.x2.nxv2i64(target("aarch64.svcount") %pn, ptr %base)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z4},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z12},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 0
  %v0 = call <vscale x 4 x i64> @llvm.vector.insert.nxv4i64.nxv2i64(<vscale x 4 x i64> poison, <vscale x 2 x i64> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 1
  %v1 = call <vscale x 4 x i64> @llvm.vector.insert.nxv4i64.nxv2i64(<vscale x 4 x i64> %v0, <vscale x 2 x i64> %res.v1, i64 2)
  ret <vscale x 4 x i64> %v1
}

define <vscale x 64 x i8> @ld1_x4_i8_z0_z4_z8_z12(<vscale x 16 x i8> %unused, <vscale x 16 x i8> %z1, target("aarch64.svcount") %pn, ptr %ptr) nounwind {
; CHECK-LABEL: ld1_x4_i8_z0_z4_z8_z12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1b { z0.b, z4.b, z8.b, z12.b }, pn8/z, [x0]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z2.d, z8.d
; CHECK-NEXT:    mov z3.d, z12.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x4_i8_z0_z4_z8_z12:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1b { z0.b, z4.b, z8.b, z12.b }, pn8/z, [x0]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z2.d, z8.d
; STRIDED-NEXT:    mov z3.d, z12.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z4.d
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x4_i8_z0_z4_z8_z12:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-15
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-4
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1b { z0.b - z3.b }, pn8/z, [x0]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    str z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    str z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    ldr z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    ldr z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #4
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #15
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %res = call { <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8> } @llvm.aarch64.sve.ld1.pn.x4.nxv16i8(target("aarch64.svcount") %pn, ptr %ptr)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 0
  %v0 = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv16i8(<vscale x 64 x i8> poison, <vscale x 16 x i8> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 1
  %v1 = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv16i8(<vscale x 64 x i8> %v0, <vscale x 16 x i8> %res.v1, i64 16)
  %res.v2 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 2
  %v2 = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv16i8(<vscale x 64 x i8> %v1, <vscale x 16 x i8> %res.v2, i64 32)
  %res.v3 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 3
  %v3 = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv16i8(<vscale x 64 x i8> %v2, <vscale x 16 x i8> %res.v3, i64 48)
  ret <vscale x 64 x i8> %v3
}

define <vscale x 64 x i8> @ld1_x4_i8_z0_z4_z8_z12_scalar(<vscale x 16 x i8> %unused, <vscale x 16 x i8> %z1, target("aarch64.svcount") %pn, ptr %ptr, i64 %index) nounwind {
; CHECK-LABEL: ld1_x4_i8_z0_z4_z8_z12_scalar:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1b { z0.b, z4.b, z8.b, z12.b }, pn8/z, [x0, x1]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z2.d, z8.d
; CHECK-NEXT:    mov z3.d, z12.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x4_i8_z0_z4_z8_z12_scalar:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1b { z0.b, z4.b, z8.b, z12.b }, pn8/z, [x0, x1]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z2.d, z8.d
; STRIDED-NEXT:    mov z3.d, z12.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z4.d
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x4_i8_z0_z4_z8_z12_scalar:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-15
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-4
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1b { z0.b - z3.b }, pn8/z, [x0, x1]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    str z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    str z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    ldr z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    ldr z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #4
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #15
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %base = getelementptr i8, ptr %ptr, i64 %index
  %res = call { <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8> } @llvm.aarch64.sve.ld1.pn.x4.nxv16i8(target("aarch64.svcount") %pn, ptr %base)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 0
  %v0 = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv16i8(<vscale x 64 x i8> poison, <vscale x 16 x i8> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 1
  %v1 = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv16i8(<vscale x 64 x i8> %v0, <vscale x 16 x i8> %res.v1, i64 16)
  %res.v2 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 2
  %v2 = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv16i8(<vscale x 64 x i8> %v1, <vscale x 16 x i8> %res.v2, i64 32)
  %res.v3 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8> } %res, 3
  %v3 = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv16i8(<vscale x 64 x i8> %v2, <vscale x 16 x i8> %res.v3, i64 48)
  ret <vscale x 64 x i8> %v3
}

define <vscale x 32 x i16> @ld1_x4_i16_z0_z4_z8_z12(<vscale x 8 x i16> %unused, <vscale x 8 x i16> %z1, target("aarch64.svcount") %pn, ptr %ptr) nounwind {
; CHECK-LABEL: ld1_x4_i16_z0_z4_z8_z12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1h { z0.h, z4.h, z8.h, z12.h }, pn8/z, [x0]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z2.d, z8.d
; CHECK-NEXT:    mov z3.d, z12.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x4_i16_z0_z4_z8_z12:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1h { z0.h, z4.h, z8.h, z12.h }, pn8/z, [x0]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z2.d, z8.d
; STRIDED-NEXT:    mov z3.d, z12.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z4.d
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x4_i16_z0_z4_z8_z12:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-15
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-4
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1h { z0.h - z3.h }, pn8/z, [x0]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    str z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    str z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    ldr z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    ldr z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #4
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #15
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %res = call { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld1.pn.x4.nxv8i16(target("aarch64.svcount") %pn, ptr %ptr)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 0
  %v0 = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv8i16(<vscale x 32 x i16> poison, <vscale x 8 x i16> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 1
  %v1 = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv8i16(<vscale x 32 x i16> %v0, <vscale x 8 x i16> %res.v1, i64 8)
  %res.v2 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 2
  %v2 = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv8i16(<vscale x 32 x i16> %v1, <vscale x 8 x i16> %res.v2, i64 16)
  %res.v3 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 3
  %v3 = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv8i16(<vscale x 32 x i16> %v2, <vscale x 8 x i16> %res.v3, i64 24)
  ret <vscale x 32 x i16> %v3
}

define <vscale x 32 x i16> @ld1_x4_i16_z0_z4_z8_z12_scalar(<vscale x 8 x i16> %unused, <vscale x 8 x i16> %z1, target("aarch64.svcount") %pn, ptr %ptr, i64 %index) nounwind {
; CHECK-LABEL: ld1_x4_i16_z0_z4_z8_z12_scalar:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    lsl x8, x1, #1
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1h { z0.h, z4.h, z8.h, z12.h }, pn8/z, [x0, x8, lsl #1]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z2.d, z8.d
; CHECK-NEXT:    mov z3.d, z12.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x4_i16_z0_z4_z8_z12_scalar:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1h { z0.h, z4.h, z8.h, z12.h }, pn8/z, [x0, x1, lsl #1]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z2.d, z8.d
; STRIDED-NEXT:    mov z3.d, z12.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z4.d
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x4_i16_z0_z4_z8_z12_scalar:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-15
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-4
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1h { z0.h - z3.h }, pn8/z, [x0, x1, lsl #1]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    str z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    str z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    ldr z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    ldr z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #4
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #15
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %base = getelementptr i16, ptr %ptr, i64 %index
  %res = call { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld1.pn.x4.nxv8i16(target("aarch64.svcount") %pn, ptr %base)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 0
  %v0 = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv8i16(<vscale x 32 x i16> poison, <vscale x 8 x i16> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 1
  %v1 = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv8i16(<vscale x 32 x i16> %v0, <vscale x 8 x i16> %res.v1, i64 8)
  %res.v2 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 2
  %v2 = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv8i16(<vscale x 32 x i16> %v1, <vscale x 8 x i16> %res.v2, i64 16)
  %res.v3 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %res, 3
  %v3 = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv8i16(<vscale x 32 x i16> %v2, <vscale x 8 x i16> %res.v3, i64 24)
  ret <vscale x 32 x i16> %v3
}

define <vscale x 16 x i32> @ld1_x4_i32_z0_z4_z8_z12(<vscale x 4 x i32> %unused, <vscale x 4 x i32> %z1, target("aarch64.svcount") %pn, ptr %ptr) nounwind {
; CHECK-LABEL: ld1_x4_i32_z0_z4_z8_z12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1w { z0.s, z4.s, z8.s, z12.s }, pn8/z, [x0]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z2.d, z8.d
; CHECK-NEXT:    mov z3.d, z12.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x4_i32_z0_z4_z8_z12:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1w { z0.s, z4.s, z8.s, z12.s }, pn8/z, [x0]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z2.d, z8.d
; STRIDED-NEXT:    mov z3.d, z12.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z4.d
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x4_i32_z0_z4_z8_z12:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-15
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-4
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1w { z0.s - z3.s }, pn8/z, [x0]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    str z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    str z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    ldr z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    ldr z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #4
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #15
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %res = call { <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32> } @llvm.aarch64.sve.ld1.pn.x4.nxv4i32(target("aarch64.svcount") %pn, ptr %ptr)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 0
  %v0 = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv4i32(<vscale x 16 x i32> poison, <vscale x 4 x i32> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 1
  %v1 = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv4i32(<vscale x 16 x i32> %v0, <vscale x 4 x i32> %res.v1, i64 4)
  %res.v2 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 2
  %v2 = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv4i32(<vscale x 16 x i32> %v1, <vscale x 4 x i32> %res.v2, i64 8)
  %res.v3 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 3
  %v3 = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv4i32(<vscale x 16 x i32> %v2, <vscale x 4 x i32> %res.v3, i64 12)
  ret <vscale x 16 x i32> %v3
}

define <vscale x 16 x i32> @ld1_x4_i32_z0_z4_z8_z12_scalar(<vscale x 4 x i32> %unused, <vscale x 4 x i32> %z1, target("aarch64.svcount") %pn, ptr %ptr, i64 %index) nounwind {
; CHECK-LABEL: ld1_x4_i32_z0_z4_z8_z12_scalar:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    lsl x8, x1, #2
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1w { z0.s, z4.s, z8.s, z12.s }, pn8/z, [x0, x8, lsl #2]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z2.d, z8.d
; CHECK-NEXT:    mov z3.d, z12.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x4_i32_z0_z4_z8_z12_scalar:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1w { z0.s, z4.s, z8.s, z12.s }, pn8/z, [x0, x1, lsl #2]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z2.d, z8.d
; STRIDED-NEXT:    mov z3.d, z12.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z4.d
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x4_i32_z0_z4_z8_z12_scalar:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-15
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-4
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1w { z0.s - z3.s }, pn8/z, [x0, x1, lsl #2]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    str z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    str z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    ldr z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    ldr z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #4
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #15
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %base = getelementptr i32, ptr %ptr, i64 %index
  %res = call { <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32> } @llvm.aarch64.sve.ld1.pn.x4.nxv4i32(target("aarch64.svcount") %pn, ptr %base)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 0
  %v0 = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv4i32(<vscale x 16 x i32> poison, <vscale x 4 x i32> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 1
  %v1 = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv4i32(<vscale x 16 x i32> %v0, <vscale x 4 x i32> %res.v1, i64 4)
  %res.v2 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 2
  %v2 = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv4i32(<vscale x 16 x i32> %v1, <vscale x 4 x i32> %res.v2, i64 8)
  %res.v3 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32> } %res, 3
  %v3 = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv4i32(<vscale x 16 x i32> %v2, <vscale x 4 x i32> %res.v3, i64 12)
  ret <vscale x 16 x i32> %v3
}

define <vscale x 8 x i64> @ld1_x4_i64_z0_z4_z8_z12(<vscale x 2 x i64> %unused, <vscale x 2 x i64> %z1, target("aarch64.svcount") %pn, ptr %ptr) nounwind {
; CHECK-LABEL: ld1_x4_i64_z0_z4_z8_z12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1d { z0.d, z4.d, z8.d, z12.d }, pn8/z, [x0]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z2.d, z8.d
; CHECK-NEXT:    mov z3.d, z12.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x4_i64_z0_z4_z8_z12:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1d { z0.d, z4.d, z8.d, z12.d }, pn8/z, [x0]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z2.d, z8.d
; STRIDED-NEXT:    mov z3.d, z12.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z4.d
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x4_i64_z0_z4_z8_z12:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-15
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-4
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1d { z0.d - z3.d }, pn8/z, [x0]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    str z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    str z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    ldr z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    ldr z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #4
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #15
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %res = call { <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64> } @llvm.aarch64.sve.ld1.pn.x4.nxv2i64(target("aarch64.svcount") %pn, ptr %ptr)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 0
  %v0 = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv2i64(<vscale x 8 x i64> poison, <vscale x 2 x i64> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 1
  %v1 = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv2i64(<vscale x 8 x i64> %v0, <vscale x 2 x i64> %res.v1, i64 2)
  %res.v2 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 2
  %v2 = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv2i64(<vscale x 8 x i64> %v1, <vscale x 2 x i64> %res.v2, i64 4)
  %res.v3 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 3
  %v3 = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv2i64(<vscale x 8 x i64> %v2, <vscale x 2 x i64> %res.v3, i64 6)
  ret <vscale x 8 x i64> %v3
}

define <vscale x 8 x i64> @ld1_x4_i64_z0_z4_z8_z12_scalar(<vscale x 2 x i64> %unused, <vscale x 2 x i64> %z1, target("aarch64.svcount") %pn, ptr %ptr, i64 %index) nounwind {
; CHECK-LABEL: ld1_x4_i64_z0_z4_z8_z12_scalar:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-17
; CHECK-NEXT:    lsl x8, x1, #3
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    ld1d { z0.d, z4.d, z8.d, z12.d }, pn8/z, [x0, x8, lsl #3]
; CHECK-NEXT:    //APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z2.d, z8.d
; CHECK-NEXT:    mov z3.d, z12.d
; CHECK-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    addvl sp, sp, #17
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
; STRIDED-LABEL: ld1_x4_i64_z0_z4_z8_z12_scalar:
; STRIDED:       // %bb.0:
; STRIDED-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; STRIDED-NEXT:    addvl sp, sp, #-17
; STRIDED-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; STRIDED-NEXT:    mov p8.b, p0.b
; STRIDED-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z12, [sp, #12, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z11, [sp, #13, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z10, [sp, #14, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z9, [sp, #15, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    str z8, [sp, #16, mul vl] // 16-byte Folded Spill
; STRIDED-NEXT:    ld1d { z0.d, z4.d, z8.d, z12.d }, pn8/z, [x0, x1, lsl #3]
; STRIDED-NEXT:    //APP
; STRIDED-NEXT:    nop
; STRIDED-NEXT:    //NO_APP
; STRIDED-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; STRIDED-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z2.d, z8.d
; STRIDED-NEXT:    mov z3.d, z12.d
; STRIDED-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z12, [sp, #12, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z11, [sp, #13, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z10, [sp, #14, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z9, [sp, #15, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    ldr z8, [sp, #16, mul vl] // 16-byte Folded Reload
; STRIDED-NEXT:    mov z1.d, z4.d
; STRIDED-NEXT:    addvl sp, sp, #17
; STRIDED-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; STRIDED-NEXT:    ret
;
; CONTIGUOUS-LABEL: ld1_x4_i64_z0_z4_z8_z12_scalar:
; CONTIGUOUS:       // %bb.0:
; CONTIGUOUS-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-15
; CONTIGUOUS-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CONTIGUOUS-NEXT:    str z23, [sp, #1, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z22, [sp, #2, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z21, [sp, #3, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z20, [sp, #4, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z19, [sp, #5, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z18, [sp, #6, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z17, [sp, #7, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z16, [sp, #8, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z15, [sp, #9, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z14, [sp, #10, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z13, [sp, #11, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z11, [sp, #12, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z10, [sp, #13, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    str z9, [sp, #14, mul vl] // 16-byte Folded Spill
; CONTIGUOUS-NEXT:    addvl sp, sp, #-4
; CONTIGUOUS-NEXT:    mov p8.b, p0.b
; CONTIGUOUS-NEXT:    ld1d { z0.d - z3.d }, pn8/z, [x0, x1, lsl #3]
; CONTIGUOUS-NEXT:    str z0, [sp]
; CONTIGUOUS-NEXT:    str z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    str z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    str z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    //APP
; CONTIGUOUS-NEXT:    nop
; CONTIGUOUS-NEXT:    //NO_APP
; CONTIGUOUS-NEXT:    ldr z0, [sp]
; CONTIGUOUS-NEXT:    ldr z1, [sp, #1, mul vl]
; CONTIGUOUS-NEXT:    ldr z2, [sp, #2, mul vl]
; CONTIGUOUS-NEXT:    ldr z3, [sp, #3, mul vl]
; CONTIGUOUS-NEXT:    addvl sp, sp, #4
; CONTIGUOUS-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z23, [sp, #1, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z22, [sp, #2, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z21, [sp, #3, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z20, [sp, #4, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z19, [sp, #5, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z18, [sp, #6, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z17, [sp, #7, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z16, [sp, #8, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z15, [sp, #9, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z14, [sp, #10, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z13, [sp, #11, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z11, [sp, #12, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z10, [sp, #13, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    ldr z9, [sp, #14, mul vl] // 16-byte Folded Reload
; CONTIGUOUS-NEXT:    addvl sp, sp, #15
; CONTIGUOUS-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CONTIGUOUS-NEXT:    ret
  %base = getelementptr i64, ptr %ptr, i64 %index
  %res = call { <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64> } @llvm.aarch64.sve.ld1.pn.x4.nxv2i64(target("aarch64.svcount") %pn, ptr %base)
  call void asm sideeffect "nop", "~{z1},~{z2},~{z3},~{z5},~{z6},~{z7},~{z9},~{z10},~{z11},~{z13},~{z14},~{z15},~{z16},~{z17},~{z18},~{z19},~{z20},~{z21},~{z22},~{z23},~{z24},~{z25},~{z26},~{z27},~{z28},~{z29},~{z30},~{z31}"() nounwind
  %res.v0 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 0
  %v0 = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv2i64(<vscale x 8 x i64> poison, <vscale x 2 x i64> %res.v0, i64 0)
  %res.v1 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 1
  %v1 = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv2i64(<vscale x 8 x i64> %v0, <vscale x 2 x i64> %res.v1, i64 2)
  %res.v2 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 2
  %v2 = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv2i64(<vscale x 8 x i64> %v1, <vscale x 2 x i64> %res.v2, i64 4)
  %res.v3 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64> } %res, 3
  %v3 = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv2i64(<vscale x 8 x i64> %v2, <vscale x 2 x i64> %res.v3, i64 6)
  ret <vscale x 8 x i64> %v3
}

declare <vscale x 32 x i8> @llvm.vector.insert.nxv32i8.nxv16i8(<vscale x 32 x i8>, <vscale x 16 x i8>, i64)
declare <vscale x 16 x i16> @llvm.vector.insert.nxv16i16.nxv8i16(<vscale x 16 x i16>, <vscale x 8 x i16>, i64)
declare <vscale x 8 x i32> @llvm.vector.insert.nxv8i32.nxv4i32(<vscale x 8 x i32>, <vscale x 4 x i32>, i64)
declare <vscale x 4 x i64> @llvm.vector.insert.nxv4i64.nxv2i64(<vscale x 4 x i64>, <vscale x 2 x i64>, i64)
declare <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv16i8(<vscale x 64 x i8>, <vscale x 16 x i8>, i64)
declare <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv8i16(<vscale x 32 x i16>, <vscale x 8 x i16>, i64)
declare <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv4i32(<vscale x 16 x i32>, <vscale x 4 x i32>, i64)
declare <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv2i64(<vscale x 8 x i64>, <vscale x 2 x i64>, i64)
declare { <vscale x 16 x i8>, <vscale x 16 x i8> } @llvm.aarch64.sve.ld1.pn.x2.nxv16i8(target("aarch64.svcount"), ptr)
declare { <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld1.pn.x2.nxv8i16(target("aarch64.svcount"), ptr)
declare { <vscale x 4 x i32>, <vscale x 4 x i32> } @llvm.aarch64.sve.ld1.pn.x2.nxv4i32(target("aarch64.svcount"), ptr)
declare { <vscale x 2 x i64>, <vscale x 2 x i64> } @llvm.aarch64.sve.ld1.pn.x2.nxv2i64(target("aarch64.svcount"), ptr)
declare { <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8> } @llvm.aarch64.sve.ld1.pn.x4.nxv16i8(target("aarch64.svcount"), ptr)
declare { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld1.pn.x4.nxv8i16(target("aarch64.svcount"), ptr)
declare { <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32> } @llvm.aarch64.sve.ld1.pn.x4.nxv4i32(target("aarch64.svcount"), ptr)
declare { <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64> } @llvm.aarch64.sve.ld1.pn.x4.nxv2i64(target("aarch64.svcount"), ptr)
