; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=aarch64-none-linux-gnu | FileCheck %s --check-prefixes=CHECK,CHECK-NO16
; RUN: llc -verify-machineinstrs < %s -mtriple=aarch64-none-linux-gnu -mattr=+fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-FP16

; fptoui

define i32 @fcvtzs_f32_i32_7(float %flt) {
; CHECK-LABEL: fcvtzs_f32_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, s0, #7
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = fptosi float %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzs_f32_i32_32(float %flt) {
; CHECK-LABEL: fcvtzs_f32_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, s0, #32
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 4294967296.0
  %cvt = fptosi float %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzs_f32_i64_7(float %flt) {
; CHECK-LABEL: fcvtzs_f32_i64_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x0, s0, #7
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = fptosi float %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzs_f32_i64_64(float %flt) {
; CHECK-LABEL: fcvtzs_f32_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x0, s0, #64
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 18446744073709551616.0
  %cvt = fptosi float %fix to i64
  ret i64 %cvt
}

define i32 @fcvtzs_f64_i32_7(double %dbl) {
; CHECK-LABEL: fcvtzs_f64_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, d0, #7
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = fptosi double %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzs_f64_i32_32(double %dbl) {
; CHECK-LABEL: fcvtzs_f64_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, d0, #32
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 4294967296.0
  %cvt = fptosi double %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzs_f64_i64_7(double %dbl) {
; CHECK-LABEL: fcvtzs_f64_i64_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x0, d0, #7
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = fptosi double %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzs_f64_i64_64(double %dbl) {
; CHECK-LABEL: fcvtzs_f64_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x0, d0, #64
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 18446744073709551616.0
  %cvt = fptosi double %fix to i64
  ret i64 %cvt
}

define i32 @fcvtzs_f16_i32_7(half %flt) {
; CHECK-NO16-LABEL: fcvtzs_f16_i32_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzs w0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzs_f16_i32_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs w0, h0, #7
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %flt, 128.0
  %cvt = fptosi half %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzs_f16_i32_15(half %flt) {
; CHECK-NO16-LABEL: fcvtzs_f16_i32_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzs w0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzs_f16_i32_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs w0, h0, #15
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %flt, 32768.0
  %cvt = fptosi half %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzs_f16_i64_7(half %flt) {
; CHECK-NO16-LABEL: fcvtzs_f16_i64_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzs x0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzs_f16_i64_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs x0, h0, #7
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %flt, 128.0
  %cvt = fptosi half %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzs_f16_i64_15(half %flt) {
; CHECK-NO16-LABEL: fcvtzs_f16_i64_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzs x0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzs_f16_i64_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs x0, h0, #15
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %flt, 32768.0
  %cvt = fptosi half %fix to i64
  ret i64 %cvt
}

; fptoui

define i32 @fcvtzu_f32_i32_7(float %flt) {
; CHECK-LABEL: fcvtzu_f32_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu w0, s0, #7
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = fptoui float %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzu_f32_i32_32(float %flt) {
; CHECK-LABEL: fcvtzu_f32_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu w0, s0, #32
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 4294967296.0
  %cvt = fptoui float %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzu_f32_i64_7(float %flt) {
; CHECK-LABEL: fcvtzu_f32_i64_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu x0, s0, #7
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = fptoui float %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzu_f32_i64_64(float %flt) {
; CHECK-LABEL: fcvtzu_f32_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu x0, s0, #64
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 18446744073709551616.0
  %cvt = fptoui float %fix to i64
  ret i64 %cvt
}

define i32 @fcvtzu_f64_i32_7(double %dbl) {
; CHECK-LABEL: fcvtzu_f64_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu w0, d0, #7
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = fptoui double %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzu_f64_i32_32(double %dbl) {
; CHECK-LABEL: fcvtzu_f64_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu w0, d0, #32
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 4294967296.0
  %cvt = fptoui double %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzu_f64_i64_7(double %dbl) {
; CHECK-LABEL: fcvtzu_f64_i64_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu x0, d0, #7
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = fptoui double %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzu_f64_i64_64(double %dbl) {
; CHECK-LABEL: fcvtzu_f64_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu x0, d0, #64
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 18446744073709551616.0
  %cvt = fptoui double %fix to i64
  ret i64 %cvt
}

define i32 @fcvtzu_f16_i32_7(half %flt) {
; CHECK-NO16-LABEL: fcvtzu_f16_i32_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzu w0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzu_f16_i32_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu w0, h0, #7
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %flt, 128.0
  %cvt = fptoui half %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzu_f16_i32_15(half %flt) {
; CHECK-NO16-LABEL: fcvtzu_f16_i32_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzu w0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzu_f16_i32_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu w0, h0, #15
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %flt, 32768.0
  %cvt = fptoui half %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzu_f16_i64_7(half %flt) {
; CHECK-NO16-LABEL: fcvtzu_f16_i64_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzu x0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzu_f16_i64_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu x0, h0, #7
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %flt, 128.0
  %cvt = fptoui half %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzu_f16_i64_15(half %flt) {
; CHECK-NO16-LABEL: fcvtzu_f16_i64_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzu x0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzu_f16_i64_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu x0, h0, #15
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %flt, 32768.0
  %cvt = fptoui half %fix to i64
  ret i64 %cvt
}

; sitofp

define float @scvtf_f32_i32_7(i32 %int) {
; CHECK-LABEL: scvtf_f32_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    scvtf s0, w0, #7
; CHECK-NEXT:    ret
  %cvt = sitofp i32 %int to float
  %fix = fdiv float %cvt, 128.0
  ret float %fix
}

define float @scvtf_f32_i32_32(i32 %int) {
; CHECK-LABEL: scvtf_f32_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    scvtf s0, w0, #32
; CHECK-NEXT:    ret
  %cvt = sitofp i32 %int to float
  %fix = fdiv float %cvt, 4294967296.0
  ret float %fix
}

define float @scvtf_f32_i64_7(i64 %long) {
; CHECK-LABEL: scvtf_f32_i64_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    scvtf s0, x0, #7
; CHECK-NEXT:    ret
  %cvt = sitofp i64 %long to float
  %fix = fdiv float %cvt, 128.0
  ret float %fix
}

define float @scvtf_f32_i64_64(i64 %long) {
; CHECK-LABEL: scvtf_f32_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    scvtf s0, x0, #64
; CHECK-NEXT:    ret
  %cvt = sitofp i64 %long to float
  %fix = fdiv float %cvt, 18446744073709551616.0
  ret float %fix
}

define double @scvtf_f64_i32_7(i32 %int) {
; CHECK-LABEL: scvtf_f64_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    scvtf d0, w0, #7
; CHECK-NEXT:    ret
  %cvt = sitofp i32 %int to double
  %fix = fdiv double %cvt, 128.0
  ret double %fix
}

define double @scvtf_f64_i32_32(i32 %int) {
; CHECK-LABEL: scvtf_f64_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    scvtf d0, w0, #32
; CHECK-NEXT:    ret
  %cvt = sitofp i32 %int to double
  %fix = fdiv double %cvt, 4294967296.0
  ret double %fix
}

define double @scvtf_f64_i64_7(i64 %long) {
; CHECK-LABEL: scvtf_f64_i64_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    scvtf d0, x0, #7
; CHECK-NEXT:    ret
  %cvt = sitofp i64 %long to double
  %fix = fdiv double %cvt, 128.0
  ret double %fix
}

define double @scvtf_f64_i64_64(i64 %long) {
; CHECK-LABEL: scvtf_f64_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    scvtf d0, x0, #64
; CHECK-NEXT:    ret
  %cvt = sitofp i64 %long to double
  %fix = fdiv double %cvt, 18446744073709551616.0
  ret double %fix
}

define half @scvtf_f16_i32_7(i32 %int) {
; CHECK-NO16-LABEL: scvtf_f16_i32_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    scvtf s1, w0
; CHECK-NO16-NEXT:    movi v0.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt h1, s1
; CHECK-NO16-NEXT:    fcvt s1, h1
; CHECK-NO16-NEXT:    fdiv s0, s1, s0
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: scvtf_f16_i32_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    scvtf h0, w0, #7
; CHECK-FP16-NEXT:    ret
  %cvt = sitofp i32 %int to half
  %fix = fdiv half %cvt, 128.0
  ret half %fix
}

define half @scvtf_f16_i32_15(i32 %int) {
; CHECK-NO16-LABEL: scvtf_f16_i32_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    scvtf s1, w0
; CHECK-NO16-NEXT:    movi v0.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt h1, s1
; CHECK-NO16-NEXT:    fcvt s1, h1
; CHECK-NO16-NEXT:    fdiv s0, s1, s0
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: scvtf_f16_i32_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    scvtf h0, w0, #15
; CHECK-FP16-NEXT:    ret
  %cvt = sitofp i32 %int to half
  %fix = fdiv half %cvt, 32768.0
  ret half %fix
}

define half @scvtf_f16_i64_7(i64 %long) {
; CHECK-NO16-LABEL: scvtf_f16_i64_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    scvtf s1, x0
; CHECK-NO16-NEXT:    movi v0.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt h1, s1
; CHECK-NO16-NEXT:    fcvt s1, h1
; CHECK-NO16-NEXT:    fdiv s0, s1, s0
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: scvtf_f16_i64_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    scvtf h0, x0, #7
; CHECK-FP16-NEXT:    ret
  %cvt = sitofp i64 %long to half
  %fix = fdiv half %cvt, 128.0
  ret half %fix
}

define half @scvtf_f16_i64_15(i64 %long) {
; CHECK-NO16-LABEL: scvtf_f16_i64_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    scvtf s1, x0
; CHECK-NO16-NEXT:    movi v0.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt h1, s1
; CHECK-NO16-NEXT:    fcvt s1, h1
; CHECK-NO16-NEXT:    fdiv s0, s1, s0
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: scvtf_f16_i64_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    scvtf h0, x0, #15
; CHECK-FP16-NEXT:    ret
  %cvt = sitofp i64 %long to half
  %fix = fdiv half %cvt, 32768.0
  ret half %fix
}

; uitofp

define float @ucvtf_f32_i32_7(i32 %int) {
; CHECK-LABEL: ucvtf_f32_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ucvtf s0, w0, #7
; CHECK-NEXT:    ret
  %cvt = uitofp i32 %int to float
  %fix = fdiv float %cvt, 128.0
  ret float %fix
}

define float @ucvtf_f32_i32_32(i32 %int) {
; CHECK-LABEL: ucvtf_f32_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ucvtf s0, w0, #32
; CHECK-NEXT:    ret
  %cvt = uitofp i32 %int to float
  %fix = fdiv float %cvt, 4294967296.0
  ret float %fix
}

define float @ucvtf_f32_i64_7(i64 %long) {
; CHECK-LABEL: ucvtf_f32_i64_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ucvtf s0, x0, #7
; CHECK-NEXT:    ret
  %cvt = uitofp i64 %long to float
  %fix = fdiv float %cvt, 128.0
  ret float %fix
}

define float @ucvtf_f32_i64_64(i64 %long) {
; CHECK-LABEL: ucvtf_f32_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ucvtf s0, x0, #64
; CHECK-NEXT:    ret
  %cvt = uitofp i64 %long to float
  %fix = fdiv float %cvt, 18446744073709551616.0
  ret float %fix
}

define double @ucvtf_f64_i32_7(i32 %int) {
; CHECK-LABEL: ucvtf_f64_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ucvtf d0, w0, #7
; CHECK-NEXT:    ret
  %cvt = uitofp i32 %int to double
  %fix = fdiv double %cvt, 128.0
  ret double %fix
}

define double @ucvtf_f64_i32_32(i32 %int) {
; CHECK-LABEL: ucvtf_f64_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ucvtf d0, w0, #32
; CHECK-NEXT:    ret
  %cvt = uitofp i32 %int to double
  %fix = fdiv double %cvt, 4294967296.0
  ret double %fix
}

define double @ucvtf_f64_i64_7(i64 %long) {
; CHECK-LABEL: ucvtf_f64_i64_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ucvtf d0, x0, #7
; CHECK-NEXT:    ret
  %cvt = uitofp i64 %long to double
  %fix = fdiv double %cvt, 128.0
  ret double %fix
}

define double @ucvtf_f64_i64_64(i64 %long) {
; CHECK-LABEL: ucvtf_f64_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ucvtf d0, x0, #64
; CHECK-NEXT:    ret
  %cvt = uitofp i64 %long to double
  %fix = fdiv double %cvt, 18446744073709551616.0
  ret double %fix
}

define half @ucvtf_f16_i32_7(i32 %int) {
; CHECK-NO16-LABEL: ucvtf_f16_i32_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    ucvtf s1, w0
; CHECK-NO16-NEXT:    movi v0.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt h1, s1
; CHECK-NO16-NEXT:    fcvt s1, h1
; CHECK-NO16-NEXT:    fdiv s0, s1, s0
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: ucvtf_f16_i32_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    ucvtf h0, w0, #7
; CHECK-FP16-NEXT:    ret
  %cvt = uitofp i32 %int to half
  %fix = fdiv half %cvt, 128.0
  ret half %fix
}

define half @ucvtf_f16_i32_15(i32 %int) {
; CHECK-NO16-LABEL: ucvtf_f16_i32_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    ucvtf s1, w0
; CHECK-NO16-NEXT:    movi v0.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt h1, s1
; CHECK-NO16-NEXT:    fcvt s1, h1
; CHECK-NO16-NEXT:    fdiv s0, s1, s0
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: ucvtf_f16_i32_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    ucvtf h0, w0, #15
; CHECK-FP16-NEXT:    ret
  %cvt = uitofp i32 %int to half
  %fix = fdiv half %cvt, 32768.0
  ret half %fix
}

define half @ucvtf_f16_i64_7(i64 %long) {
; CHECK-NO16-LABEL: ucvtf_f16_i64_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    ucvtf s1, x0
; CHECK-NO16-NEXT:    movi v0.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt h1, s1
; CHECK-NO16-NEXT:    fcvt s1, h1
; CHECK-NO16-NEXT:    fdiv s0, s1, s0
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: ucvtf_f16_i64_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    ucvtf h0, x0, #7
; CHECK-FP16-NEXT:    ret
  %cvt = uitofp i64 %long to half
  %fix = fdiv half %cvt, 128.0
  ret half %fix
}

define half @ucvtf_f16_i64_15(i64 %long) {
; CHECK-NO16-LABEL: ucvtf_f16_i64_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    ucvtf s1, x0
; CHECK-NO16-NEXT:    movi v0.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt h1, s1
; CHECK-NO16-NEXT:    fcvt s1, h1
; CHECK-NO16-NEXT:    fdiv s0, s1, s0
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: ucvtf_f16_i64_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    ucvtf h0, x0, #15
; CHECK-FP16-NEXT:    ret
  %cvt = uitofp i64 %long to half
  %fix = fdiv half %cvt, 32768.0
  ret half %fix
}


; fptoui.sat

declare i32 @llvm.fptosi.sat.i32.f32(float)
declare i64 @llvm.fptosi.sat.i64.f32(float)
declare i32 @llvm.fptosi.sat.i32.f64(double)
declare i64 @llvm.fptosi.sat.i64.f64(double)
declare i32 @llvm.fptosi.sat.i32.f16(half)
declare i64 @llvm.fptosi.sat.i64.f16(half)

define i32 @fcvtzs_sat_f32_i32_7(float %flt) {
; CHECK-LABEL: fcvtzs_sat_f32_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, s0, #7
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f32(float %fix)
  ret i32 %cvt
}

define i32 @fcvtzs_sat_f32_i32_32(float %flt) {
; CHECK-LABEL: fcvtzs_sat_f32_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, s0, #32
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 4294967296.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f32(float %fix)
  ret i32 %cvt
}

define i64 @fcvtzs_sat_f32_i64_64(float %flt) {
; CHECK-LABEL: fcvtzs_sat_f32_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x0, s0, #64
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 18446744073709551616.0
  %cvt = call i64 @llvm.fptosi.sat.i64.f32(float %fix)
  ret i64 %cvt
}

define i32 @fcvtzs_sat_f64_i32_7(double %dbl) {
; CHECK-LABEL: fcvtzs_sat_f64_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, d0, #7
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f64(double %fix)
  ret i32 %cvt
}

define i32 @fcvtzs_sat_f64_i32_32(double %dbl) {
; CHECK-LABEL: fcvtzs_sat_f64_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, d0, #32
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 4294967296.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f64(double %fix)
  ret i32 %cvt
}

define i64 @fcvtzs_sat_f64_i64_7(double %dbl) {
; CHECK-LABEL: fcvtzs_sat_f64_i64_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x0, d0, #7
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = call i64 @llvm.fptosi.sat.i64.f64(double %fix)
  ret i64 %cvt
}

define i64 @fcvtzs_sat_f64_i64_64(double %dbl) {
; CHECK-LABEL: fcvtzs_sat_f64_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x0, d0, #64
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 18446744073709551616.0
  %cvt = call i64 @llvm.fptosi.sat.i64.f64(double %fix)
  ret i64 %cvt
}

define i32 @fcvtzs_sat_f16_i32_7(half %dbl) {
; CHECK-NO16-LABEL: fcvtzs_sat_f16_i32_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzs w0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzs_sat_f16_i32_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs w0, h0, #7
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %dbl, 128.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f16(half %fix)
  ret i32 %cvt
}

define i32 @fcvtzs_sat_f16_i32_15(half %dbl) {
; CHECK-NO16-LABEL: fcvtzs_sat_f16_i32_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzs w0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzs_sat_f16_i32_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs w0, h0, #15
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %dbl, 32768.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f16(half %fix)
  ret i32 %cvt
}

define i64 @fcvtzs_sat_f16_i64_7(half %dbl) {
; CHECK-NO16-LABEL: fcvtzs_sat_f16_i64_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzs x0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzs_sat_f16_i64_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs x0, h0, #7
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %dbl, 128.0
  %cvt = call i64 @llvm.fptosi.sat.i64.f16(half %fix)
  ret i64 %cvt
}

define i64 @fcvtzs_sat_f16_i64_15(half %dbl) {
; CHECK-NO16-LABEL: fcvtzs_sat_f16_i64_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzs x0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzs_sat_f16_i64_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs x0, h0, #15
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %dbl, 32768.0
  %cvt = call i64 @llvm.fptosi.sat.i64.f16(half %fix)
  ret i64 %cvt
}

; fptoui

declare i32 @llvm.fptoui.sat.i32.f32(float)
declare i64 @llvm.fptoui.sat.i64.f32(float)
declare i32 @llvm.fptoui.sat.i32.f64(double)
declare i64 @llvm.fptoui.sat.i64.f64(double)
declare i32 @llvm.fptoui.sat.i32.f16(half)
declare i64 @llvm.fptoui.sat.i64.f16(half)

define i32 @fcvtzu_sat_f32_i32_7(float %flt) {
; CHECK-LABEL: fcvtzu_sat_f32_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu w0, s0, #7
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f32(float %fix)
  ret i32 %cvt
}

define i32 @fcvtzu_sat_f32_i32_32(float %flt) {
; CHECK-LABEL: fcvtzu_sat_f32_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu w0, s0, #32
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 4294967296.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f32(float %fix)
  ret i32 %cvt
}

define i64 @fcvtzu_sat_f32_i64_64(float %flt) {
; CHECK-LABEL: fcvtzu_sat_f32_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu x0, s0, #64
; CHECK-NEXT:    ret
  %fix = fmul float %flt, 18446744073709551616.0
  %cvt = call i64 @llvm.fptoui.sat.i64.f32(float %fix)
  ret i64 %cvt
}

define i32 @fcvtzu_sat_f64_i32_7(double %dbl) {
; CHECK-LABEL: fcvtzu_sat_f64_i32_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu w0, d0, #7
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f64(double %fix)
  ret i32 %cvt
}

define i32 @fcvtzu_sat_f64_i32_32(double %dbl) {
; CHECK-LABEL: fcvtzu_sat_f64_i32_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu w0, d0, #32
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 4294967296.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f64(double %fix)
  ret i32 %cvt
}

define i64 @fcvtzu_sat_f64_i64_7(double %dbl) {
; CHECK-LABEL: fcvtzu_sat_f64_i64_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu x0, d0, #7
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = call i64 @llvm.fptoui.sat.i64.f64(double %fix)
  ret i64 %cvt
}

define i64 @fcvtzu_sat_f64_i64_64(double %dbl) {
; CHECK-LABEL: fcvtzu_sat_f64_i64_64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu x0, d0, #64
; CHECK-NEXT:    ret
  %fix = fmul double %dbl, 18446744073709551616.0
  %cvt = call i64 @llvm.fptoui.sat.i64.f64(double %fix)
  ret i64 %cvt
}

define i32 @fcvtzu_sat_f16_i32_7(half %dbl) {
; CHECK-NO16-LABEL: fcvtzu_sat_f16_i32_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzu w0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzu_sat_f16_i32_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu w0, h0, #7
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %dbl, 128.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f16(half %fix)
  ret i32 %cvt
}

define i32 @fcvtzu_sat_f16_i32_15(half %dbl) {
; CHECK-NO16-LABEL: fcvtzu_sat_f16_i32_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzu w0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzu_sat_f16_i32_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu w0, h0, #15
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %dbl, 32768.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f16(half %fix)
  ret i32 %cvt
}

define i64 @fcvtzu_sat_f16_i64_7(half %dbl) {
; CHECK-NO16-LABEL: fcvtzu_sat_f16_i64_7:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzu x0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzu_sat_f16_i64_7:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu x0, h0, #7
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %dbl, 128.0
  %cvt = call i64 @llvm.fptoui.sat.i64.f16(half %fix)
  ret i64 %cvt
}

define i64 @fcvtzu_sat_f16_i64_15(half %dbl) {
; CHECK-NO16-LABEL: fcvtzu_sat_f16_i64_15:
; CHECK-NO16:       // %bb.0:
; CHECK-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fmul s0, s0, s1
; CHECK-NO16-NEXT:    fcvt h0, s0
; CHECK-NO16-NEXT:    fcvt s0, h0
; CHECK-NO16-NEXT:    fcvtzu x0, s0
; CHECK-NO16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcvtzu_sat_f16_i64_15:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu x0, h0, #15
; CHECK-FP16-NEXT:    ret
  %fix = fmul half %dbl, 32768.0
  %cvt = call i64 @llvm.fptoui.sat.i64.f16(half %fix)
  ret i64 %cvt
}
