/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_c_ccalda.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t8, t10, t13, t14;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t26, t29, t30, t31, t32, t33, t34;
  double t35, t36, t39, t41, t42, t45, t47, t48;
  double t49, t52, t54, t57, t58, t62, t64, t70;
  double t72, t77, t80, t81, t85, t87, t89, t90;
  double t93, t94, tzk0;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t8 = rho[0] * rho[0];
  t10 = 0.1e1 / t4 / t8;
  t13 = tau[0] * t6 - sigma[0] * t10 / 0.8e1;
  t14 = t2 * t13;
  t15 = M_CBRT6;
  t16 = t14 * t15;
  t17 = M_PI * M_PI;
  t18 = POW_1_3(t17);
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = t20 * t22;
  t26 = t15 * t20 * t22;
  t29 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t13 * t26;
  t30 = 0.1e1 / t29;
  t31 = M_CBRT3;
  t32 = 0.1e1 / M_PI;
  t33 = POW_1_3(t32);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t39 = t34 * t36 / t3;
  t41 = 0.1e1 + 0.53425e-1 * t39;
  t42 = sqrt(t39);
  t45 = POW_3_2(t39);
  t47 = t31 * t31;
  t48 = t33 * t33;
  t49 = t47 * t48;
  t52 = t49 * t35 / t4;
  t54 = 0.379785e1 * t42 + 0.8969e0 * t39 + 0.204775e0 * t45 + 0.123235e0 * t52;
  t57 = 0.1e1 + 0.16081979498692535067e2 / t54;
  t58 = log(t57);
  t62 = POW_1_3(p->zeta_threshold);
  t64 = my_piecewise3(0.1e1 <= p->zeta_threshold, t62 * p->zeta_threshold, 1);
  t70 = (0.2e1 * t64 - 0.2e1) / (0.2e1 * t21 - 0.2e1);
  t72 = 0.1e1 + 0.278125e-1 * t39;
  t77 = 0.51785e1 * t42 + 0.905775e0 * t39 + 0.1100325e0 * t45 + 0.1241775e0 * t52;
  t80 = 0.1e1 + 0.29608749977793437516e2 / t77;
  t81 = log(t80);
  t85 = -0.621814e-1 * t41 * t58 + 0.19751673498613801407e-1 * t70 * t72 * t81;
  t87 = t23 * t30 * t85;
  t89 = 0.5e1 / 0.9e1 * t16 * t87;
  t90 = t23 * t30;
  t93 = 0.1e1 - 0.5e1 / 0.9e1 * t16 * t90;
  t94 = t93 * t85;
  tzk0 = t89 + t94;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t8, t10, t13, t14;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t26, t29, t30, t31, t32, t33, t34;
  double t35, t36, t39, t41, t42, t45, t47, t48;
  double t49, t52, t54, t57, t58, t62, t64, t70;
  double t72, t77, t80, t81, t85, t87, t89, t90;
  double t93, t94, tzk0;

  double t97, t99, t102, t103, t104, t105, t107, t109;
  double t110, t111, t112, t113, t114, t115, t117, t118;
  double t121, t122, t126, t127, t128, t130, t131, t132;
  double t133, t135, t137, t138, t139, t142, t144, t145;
  double t146, t149, t154, t155, t156, t161, t163, t164;
  double t167, t169, t170, t175, t178, t179, t180, tvrho0;
  double t183, t184, t185, t186, t189, t190, t191, t195;
  double t197, t198, tvsigma0, tvlapl0, t200, t201, t203, t207;
  double t214, t215, tvtau0;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t8 = rho[0] * rho[0];
  t10 = 0.1e1 / t4 / t8;
  t13 = tau[0] * t6 - sigma[0] * t10 / 0.8e1;
  t14 = t2 * t13;
  t15 = M_CBRT6;
  t16 = t14 * t15;
  t17 = M_PI * M_PI;
  t18 = POW_1_3(t17);
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = t20 * t22;
  t26 = t15 * t20 * t22;
  t29 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t13 * t26;
  t30 = 0.1e1 / t29;
  t31 = M_CBRT3;
  t32 = 0.1e1 / M_PI;
  t33 = POW_1_3(t32);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t39 = t34 * t36 / t3;
  t41 = 0.1e1 + 0.53425e-1 * t39;
  t42 = sqrt(t39);
  t45 = POW_3_2(t39);
  t47 = t31 * t31;
  t48 = t33 * t33;
  t49 = t47 * t48;
  t52 = t49 * t35 / t4;
  t54 = 0.379785e1 * t42 + 0.8969e0 * t39 + 0.204775e0 * t45 + 0.123235e0 * t52;
  t57 = 0.1e1 + 0.16081979498692535067e2 / t54;
  t58 = log(t57);
  t62 = POW_1_3(p->zeta_threshold);
  t64 = my_piecewise3(0.1e1 <= p->zeta_threshold, t62 * p->zeta_threshold, 1);
  t70 = (0.2e1 * t64 - 0.2e1) / (0.2e1 * t21 - 0.2e1);
  t72 = 0.1e1 + 0.278125e-1 * t39;
  t77 = 0.51785e1 * t42 + 0.905775e0 * t39 + 0.1100325e0 * t45 + 0.1241775e0 * t52;
  t80 = 0.1e1 + 0.29608749977793437516e2 / t77;
  t81 = log(t80);
  t85 = -0.621814e-1 * t41 * t58 + 0.19751673498613801407e-1 * t70 * t72 * t81;
  t87 = t23 * t30 * t85;
  t89 = 0.5e1 / 0.9e1 * t16 * t87;
  t90 = t23 * t30;
  t93 = 0.1e1 - 0.5e1 / 0.9e1 * t16 * t90;
  t94 = t93 * t85;
  tzk0 = t89 + t94;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t97 = t8 * rho[0];
  t99 = 0.1e1 / t4 / t97;
  t102 = -0.5e1 / 0.3e1 * tau[0] * t10 + sigma[0] * t99 / 0.3e1;
  t103 = t2 * t102;
  t104 = t103 * t15;
  t105 = t104 * t87;
  t107 = t15 * t15;
  t109 = 0.1e1 / t18 / t17;
  t110 = t107 * t109;
  t111 = t14 * t110;
  t112 = t29 * t29;
  t113 = 0.1e1 / t112;
  t114 = t21 * t113;
  t115 = t85 * params->c;
  t117 = t114 * t115 * t102;
  t118 = t111 * t117;
  t121 = 0.1e1 / t3 / rho[0];
  t122 = t36 * t121;
  t126 = t54 * t54;
  t127 = 0.1e1 / t126;
  t128 = t41 * t127;
  t130 = 0.1e1 / t42 * t31;
  t131 = t33 * t36;
  t132 = t131 * t121;
  t133 = t130 * t132;
  t135 = t34 * t122;
  t137 = sqrt(t39);
  t138 = t137 * t31;
  t139 = t138 * t132;
  t142 = t49 * t35 * t6;
  t144 = -0.632975e0 * t133 - 0.29896666666666666667e0 * t135 - 0.1023875e0 * t139 - 0.82156666666666666667e-1 * t142;
  t145 = 0.1e1 / t57;
  t146 = t144 * t145;
  t149 = t70 * t31;
  t154 = t70 * t72;
  t155 = t77 * t77;
  t156 = 0.1e1 / t155;
  t161 = -0.86308333333333333334e0 * t133 - 0.301925e0 * t135 - 0.5501625e-1 * t139 - 0.82785e-1 * t142;
  t163 = 0.1e1 / t80;
  t164 = t156 * t161 * t163;
  t167 = 0.11073470983333333333e-2 * t34 * t122 * t58 + 0.1e1 * t128 * t146 - 0.18311447306006545054e-3 * t149 * t131 * t121 * t81 - 0.5848223622634646207e0 * t154 * t164;
  t169 = t23 * t30 * t167;
  t170 = t16 * t169;
  t175 = t114 * params->c * t102;
  t178 = -0.5e1 / 0.9e1 * t104 * t90 + 0.5e2 / 0.81e2 * t111 * t175;
  t179 = t178 * t85;
  t180 = t93 * t167;
  tvrho0 = t89 + t94 + rho[0] * (0.5e1 / 0.9e1 * t105 - 0.5e2 / 0.81e2 * t118 + 0.5e1 / 0.9e1 * t170 + t179 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t183 = t2 * t10;
  t184 = t183 * t15;
  t185 = t184 * t87;
  t186 = 0.5e1 / 0.72e2 * t185;
  t189 = t111 * t114 * t115 * t10;
  t190 = 0.25e2 / 0.324e3 * t189;
  t191 = t184 * t90;
  t195 = t111 * t114 * params->c * t10;
  t197 = 0.5e1 / 0.72e2 * t191 - 0.25e2 / 0.324e3 * t195;
  t198 = t197 * t85;
  tvsigma0 = rho[0] * (-t186 + t190 + t198);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t200 = t2 * t6;
  t201 = t200 * t15;
  t203 = 0.5e1 / 0.9e1 * t201 * t87;
  t207 = 0.5e2 / 0.81e2 * t111 * t114 * t115 * t6;
  t214 = -0.5e1 / 0.9e1 * t201 * t90 + 0.5e2 / 0.81e2 * t111 * t114 * params->c * t6;
  t215 = t214 * t85;
  tvtau0 = rho[0] * (t203 - t207 + t215);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t8, t10, t13, t14;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t26, t29, t30, t31, t32, t33, t34;
  double t35, t36, t39, t41, t42, t45, t47, t48;
  double t49, t52, t54, t57, t58, t62, t64, t70;
  double t72, t77, t80, t81, t85, t87, t89, t90;
  double t93, t94, tzk0;

  double t97, t99, t102, t103, t104, t105, t107, t109;
  double t110, t111, t112, t113, t114, t115, t117, t118;
  double t121, t122, t126, t127, t128, t130, t131, t132;
  double t133, t135, t137, t138, t139, t142, t144, t145;
  double t146, t149, t154, t155, t156, t161, t163, t164;
  double t167, t169, t170, t175, t178, t179, t180, tvrho0;
  double t183, t184, t185, t186, t189, t190, t191, t195;
  double t197, t198, tvsigma0, tvlapl0, t200, t201, t203, t207;
  double t214, t215, tvtau0;

  double t224, t226, t229, t230, t231, t232, t234, t235;
  double t236, t237, t238, t240, t242, t243, t244, t246;
  double t247, t248, t249, t250, t251, t253, t255, t256;
  double t259, t260, t263, t264, t268, t269, t273, t274;
  double t275, t276, t277, t282, t283, t284, t285, t287;
  double t288, t290, t292, t293, t294, t296, t299, t301;
  double t302, t305, t306, t307, t308, t309, t310, t317;
  double t321, t322, t323, t325, t334, t336, t339, t340;
  double t341, t342, t343, t344, t347, t349, t350, t355;
  double t357, t360, t361, t365, t368, t369, t370, t372;
  double tv2rho20, t375, t376, t377, t379, t380, t382, t384;
  double t385, t386, t387, t389, t393, t397, t399, t401;
  double t404, t408, t410, t411, t412, tv2rhosigma0, tv2rholapl0, t416;
  double t417, t419, t421, t423, t427, t437, t438, t439;
  double tv2rhotau0, t442, t444, t445, t446, t447, t448, t449;
  double t451, t452, t454, t457, t459, t460, tv2sigma20, tv2sigmalapl0;
  double t463, t464, t465, t466, t467, t468, t470, t471;
  double t473, t476, t478, t479, tv2sigmatau0, tv2lapl20, tv2lapltau0, t482;
  double t483, t484, t486, t487, t490, t497, t498, tv2tau20;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t8 = rho[0] * rho[0];
  t10 = 0.1e1 / t4 / t8;
  t13 = tau[0] * t6 - sigma[0] * t10 / 0.8e1;
  t14 = t2 * t13;
  t15 = M_CBRT6;
  t16 = t14 * t15;
  t17 = M_PI * M_PI;
  t18 = POW_1_3(t17);
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = t20 * t22;
  t26 = t15 * t20 * t22;
  t29 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t13 * t26;
  t30 = 0.1e1 / t29;
  t31 = M_CBRT3;
  t32 = 0.1e1 / M_PI;
  t33 = POW_1_3(t32);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t39 = t34 * t36 / t3;
  t41 = 0.1e1 + 0.53425e-1 * t39;
  t42 = sqrt(t39);
  t45 = POW_3_2(t39);
  t47 = t31 * t31;
  t48 = t33 * t33;
  t49 = t47 * t48;
  t52 = t49 * t35 / t4;
  t54 = 0.379785e1 * t42 + 0.8969e0 * t39 + 0.204775e0 * t45 + 0.123235e0 * t52;
  t57 = 0.1e1 + 0.16081979498692535067e2 / t54;
  t58 = log(t57);
  t62 = POW_1_3(p->zeta_threshold);
  t64 = my_piecewise3(0.1e1 <= p->zeta_threshold, t62 * p->zeta_threshold, 1);
  t70 = (0.2e1 * t64 - 0.2e1) / (0.2e1 * t21 - 0.2e1);
  t72 = 0.1e1 + 0.278125e-1 * t39;
  t77 = 0.51785e1 * t42 + 0.905775e0 * t39 + 0.1100325e0 * t45 + 0.1241775e0 * t52;
  t80 = 0.1e1 + 0.29608749977793437516e2 / t77;
  t81 = log(t80);
  t85 = -0.621814e-1 * t41 * t58 + 0.19751673498613801407e-1 * t70 * t72 * t81;
  t87 = t23 * t30 * t85;
  t89 = 0.5e1 / 0.9e1 * t16 * t87;
  t90 = t23 * t30;
  t93 = 0.1e1 - 0.5e1 / 0.9e1 * t16 * t90;
  t94 = t93 * t85;
  tzk0 = t89 + t94;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t97 = t8 * rho[0];
  t99 = 0.1e1 / t4 / t97;
  t102 = -0.5e1 / 0.3e1 * tau[0] * t10 + sigma[0] * t99 / 0.3e1;
  t103 = t2 * t102;
  t104 = t103 * t15;
  t105 = t104 * t87;
  t107 = t15 * t15;
  t109 = 0.1e1 / t18 / t17;
  t110 = t107 * t109;
  t111 = t14 * t110;
  t112 = t29 * t29;
  t113 = 0.1e1 / t112;
  t114 = t21 * t113;
  t115 = t85 * params->c;
  t117 = t114 * t115 * t102;
  t118 = t111 * t117;
  t121 = 0.1e1 / t3 / rho[0];
  t122 = t36 * t121;
  t126 = t54 * t54;
  t127 = 0.1e1 / t126;
  t128 = t41 * t127;
  t130 = 0.1e1 / t42 * t31;
  t131 = t33 * t36;
  t132 = t131 * t121;
  t133 = t130 * t132;
  t135 = t34 * t122;
  t137 = sqrt(t39);
  t138 = t137 * t31;
  t139 = t138 * t132;
  t142 = t49 * t35 * t6;
  t144 = -0.632975e0 * t133 - 0.29896666666666666667e0 * t135 - 0.1023875e0 * t139 - 0.82156666666666666667e-1 * t142;
  t145 = 0.1e1 / t57;
  t146 = t144 * t145;
  t149 = t70 * t31;
  t154 = t70 * t72;
  t155 = t77 * t77;
  t156 = 0.1e1 / t155;
  t161 = -0.86308333333333333334e0 * t133 - 0.301925e0 * t135 - 0.5501625e-1 * t139 - 0.82785e-1 * t142;
  t163 = 0.1e1 / t80;
  t164 = t156 * t161 * t163;
  t167 = 0.11073470983333333333e-2 * t34 * t122 * t58 + 0.1e1 * t128 * t146 - 0.18311447306006545054e-3 * t149 * t131 * t121 * t81 - 0.5848223622634646207e0 * t154 * t164;
  t169 = t23 * t30 * t167;
  t170 = t16 * t169;
  t175 = t114 * params->c * t102;
  t178 = -0.5e1 / 0.9e1 * t104 * t90 + 0.5e2 / 0.81e2 * t111 * t175;
  t179 = t178 * t85;
  t180 = t93 * t167;
  tvrho0 = t89 + t94 + rho[0] * (0.5e1 / 0.9e1 * t105 - 0.5e2 / 0.81e2 * t118 + 0.5e1 / 0.9e1 * t170 + t179 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t183 = t2 * t10;
  t184 = t183 * t15;
  t185 = t184 * t87;
  t186 = 0.5e1 / 0.72e2 * t185;
  t189 = t111 * t114 * t115 * t10;
  t190 = 0.25e2 / 0.324e3 * t189;
  t191 = t184 * t90;
  t195 = t111 * t114 * params->c * t10;
  t197 = 0.5e1 / 0.72e2 * t191 - 0.25e2 / 0.324e3 * t195;
  t198 = t197 * t85;
  tvsigma0 = rho[0] * (-t186 + t190 + t198);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t200 = t2 * t6;
  t201 = t200 * t15;
  t203 = 0.5e1 / 0.9e1 * t201 * t87;
  t207 = 0.5e2 / 0.81e2 * t111 * t114 * t115 * t6;
  t214 = -0.5e1 / 0.9e1 * t201 * t90 + 0.5e2 / 0.81e2 * t111 * t114 * params->c * t6;
  t215 = t214 * t85;
  tvtau0 = rho[0] * (t203 - t207 + t215);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t224 = t8 * t8;
  t226 = 0.1e1 / t4 / t224;
  t229 = 0.4e2 / 0.9e1 * tau[0] * t99 - 0.11e2 / 0.9e1 * sigma[0] * t226;
  t230 = t2 * t229;
  t231 = t230 * t15;
  t232 = t231 * t87;
  t234 = t102 * t102;
  t235 = t2 * t234;
  t236 = t235 * t110;
  t237 = t114 * t115;
  t238 = t236 * t237;
  t240 = t104 * t169;
  t242 = t17 * t17;
  t243 = 0.1e1 / t242;
  t244 = t14 * t243;
  t246 = 0.1e1 / t112 / t29;
  t247 = t246 * t85;
  t248 = params->c * params->c;
  t249 = t248 * t234;
  t250 = t247 * t249;
  t251 = t244 * t250;
  t253 = t167 * params->c;
  t255 = t114 * t253 * t102;
  t256 = t111 * t255;
  t259 = t114 * t115 * t229;
  t260 = t111 * t259;
  t263 = 0.1e1 / t3 / t8;
  t264 = t36 * t263;
  t268 = t34 * t36;
  t269 = t121 * t127;
  t273 = t126 * t54;
  t274 = 0.1e1 / t273;
  t275 = t41 * t274;
  t276 = t144 * t144;
  t277 = t276 * t145;
  t282 = 0.1e1 / t42 / t39 * t47;
  t283 = t48 * t35;
  t284 = t283 * t10;
  t285 = t282 * t284;
  t287 = t131 * t263;
  t288 = t130 * t287;
  t290 = t34 * t264;
  t292 = 0.1e1/sqrt(t39);
  t293 = t292 * t47;
  t294 = t293 * t284;
  t296 = t138 * t287;
  t299 = t49 * t35 * t10;
  t301 = -0.42198333333333333333e0 * t285 + 0.84396666666666666666e0 * t288 + 0.39862222222222222223e0 * t290 + 0.68258333333333333333e-1 * t294 + 0.13651666666666666667e0 * t296 + 0.13692777777777777778e0 * t299;
  t302 = t301 * t145;
  t305 = t126 * t126;
  t306 = 0.1e1 / t305;
  t307 = t41 * t306;
  t308 = t57 * t57;
  t309 = 0.1e1 / t308;
  t310 = t276 * t309;
  t317 = t70 * t34;
  t321 = t155 * t77;
  t322 = 0.1e1 / t321;
  t323 = t161 * t161;
  t325 = t322 * t323 * t163;
  t334 = -0.57538888888888888889e0 * t285 + 0.11507777777777777778e1 * t288 + 0.40256666666666666667e0 * t290 + 0.366775e-1 * t294 + 0.73355e-1 * t296 + 0.137975e0 * t299;
  t336 = t156 * t334 * t163;
  t339 = t155 * t155;
  t340 = 0.1e1 / t339;
  t341 = t340 * t323;
  t342 = t80 * t80;
  t343 = 0.1e1 / t342;
  t344 = t341 * t343;
  t347 = -0.14764627977777777777e-2 * t34 * t264 * t58 - 0.35616666666666666666e-1 * t268 * t269 * t146 - 0.2e1 * t275 * t277 + 0.1e1 * t128 * t302 + 0.16081979498692535067e2 * t307 * t310 + 0.24415263074675393405e-3 * t149 * t131 * t263 * t81 + 0.10843581300301739842e-1 * t317 * t122 * t164 + 0.11696447245269292414e1 * t154 * t325 - 0.5848223622634646207e0 * t154 * t336 - 0.17315859105681463759e2 * t154 * t344;
  t349 = t23 * t30 * t347;
  t350 = t16 * t349;
  t355 = t109 * t21;
  t357 = t355 * t113 * params->c;
  t360 = t246 * t248;
  t361 = t360 * t234;
  t365 = t114 * params->c * t229;
  t368 = -0.5e1 / 0.9e1 * t231 * t90 + 0.1e3 / 0.81e2 * t235 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t361 + 0.5e2 / 0.81e2 * t111 * t365;
  t369 = t368 * t85;
  t370 = t178 * t167;
  t372 = t93 * t347;
  tv2rho20 = 0.1e2 / 0.9e1 * t105 - 0.1e3 / 0.81e2 * t118 + 0.1e2 / 0.9e1 * t170 + 0.2e1 * t179 + 0.2e1 * t180 + rho[0] * (0.5e1 / 0.9e1 * t232 - 0.1e3 / 0.81e2 * t238 + 0.1e2 / 0.9e1 * t240 + 0.2e4 / 0.243e3 * t251 - 0.1e3 / 0.81e2 * t256 - 0.5e2 / 0.81e2 * t260 + 0.5e1 / 0.9e1 * t350 + t369 + 0.2e1 * t370 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t375 = t2 * t99;
  t376 = t375 * t15;
  t377 = t376 * t87;
  t379 = t183 * t110;
  t380 = t379 * t117;
  t382 = t184 * t169;
  t384 = t243 * t246;
  t385 = t14 * t384;
  t386 = t85 * t248;
  t387 = t10 * t102;
  t389 = t385 * t386 * t387;
  t393 = t111 * t114 * t253 * t10;
  t397 = t111 * t114 * t115 * t99;
  t399 = t376 * t90;
  t401 = t379 * t175;
  t404 = t244 * t360 * t387;
  t408 = t111 * t114 * params->c * t99;
  t410 = -0.5e1 / 0.27e2 * t399 - 0.25e2 / 0.162e3 * t401 + 0.25e3 / 0.243e3 * t404 + 0.5e2 / 0.243e3 * t408;
  t411 = t410 * t85;
  t412 = t197 * t167;
  tv2rhosigma0 = -t186 + t190 + t198 + rho[0] * (0.5e1 / 0.27e2 * t377 + 0.25e2 / 0.162e3 * t380 - 0.5e1 / 0.72e2 * t382 - 0.25e3 / 0.243e3 * t389 + 0.25e2 / 0.324e3 * t393 - 0.5e2 / 0.243e3 * t397 + t411 + t412);

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t416 = t200 * t110;
  t417 = t416 * t117;
  t419 = t201 * t169;
  t421 = t6 * t102;
  t423 = t385 * t386 * t421;
  t427 = t111 * t114 * t253 * t6;
  t437 = 0.25e2 / 0.27e2 * t191 + 0.1e3 / 0.81e2 * t416 * t175 - 0.2e4 / 0.243e3 * t244 * t360 * t421 - 0.25e3 / 0.243e3 * t195;
  t438 = t437 * t85;
  t439 = t214 * t167;
  tv2rhotau0 = t203 - t207 + t215 + rho[0] * (-0.25e2 / 0.27e2 * t185 - 0.1e3 / 0.81e2 * t417 + 0.5e1 / 0.9e1 * t419 + 0.2e4 / 0.243e3 * t423 - 0.5e2 / 0.81e2 * t427 + 0.25e3 / 0.243e3 * t189 + t438 + t439);

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t442 = t224 * rho[0];
  t444 = 0.1e1 / t3 / t442;
  t445 = t2 * t444;
  t446 = t445 * t110;
  t447 = t446 * t237;
  t448 = 0.25e2 / 0.1296e4 * t447;
  t449 = t248 * t444;
  t451 = t244 * t247 * t449;
  t452 = 0.125e3 / 0.972e3 * t451;
  t454 = t445 * t107 * t357;
  t457 = t244 * t360 * t444;
  t459 = 0.25e2 / 0.1296e4 * t454 - 0.125e3 / 0.972e3 * t457;
  t460 = t459 * t85;
  tv2sigma20 = rho[0] * (-t448 + t452 + t460);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t463 = 0.1e1 / t3 / t224;
  t464 = t2 * t463;
  t465 = t464 * t110;
  t466 = t465 * t237;
  t467 = 0.25e2 / 0.162e3 * t466;
  t468 = t248 * t463;
  t470 = t244 * t247 * t468;
  t471 = 0.25e3 / 0.243e3 * t470;
  t473 = t464 * t107 * t357;
  t476 = t244 * t360 * t463;
  t478 = -0.25e2 / 0.162e3 * t473 + 0.25e3 / 0.243e3 * t476;
  t479 = t478 * t85;
  tv2sigmatau0 = rho[0] * (t467 - t471 + t479);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t482 = 0.1e1 / t3 / t97;
  t483 = t2 * t482;
  t484 = t483 * t110;
  t486 = 0.1e3 / 0.81e2 * t484 * t237;
  t487 = t248 * t482;
  t490 = 0.2e4 / 0.243e3 * t244 * t247 * t487;
  t497 = 0.1e3 / 0.81e2 * t483 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t360 * t482;
  t498 = t497 * t85;
  tv2tau20 = rho[0] * (-t486 + t490 + t498);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t8, t10, t13, t14;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t26, t29, t30, t31, t32, t33, t34;
  double t35, t36, t39, t41, t42, t45, t47, t48;
  double t49, t52, t54, t57, t58, t62, t64, t70;
  double t72, t77, t80, t81, t85, t87, t89, t90;
  double t93, t94, tzk0;

  double t97, t99, t102, t103, t104, t105, t107, t109;
  double t110, t111, t112, t113, t114, t115, t117, t118;
  double t121, t122, t126, t127, t128, t130, t131, t132;
  double t133, t135, t137, t138, t139, t142, t144, t145;
  double t146, t149, t154, t155, t156, t161, t163, t164;
  double t167, t169, t170, t175, t178, t179, t180, tvrho0;
  double t183, t184, t185, t186, t189, t190, t191, t195;
  double t197, t198, tvsigma0, tvlapl0, t200, t201, t203, t207;
  double t214, t215, tvtau0;

  double t224, t226, t229, t230, t231, t232, t234, t235;
  double t236, t237, t238, t240, t242, t243, t244, t246;
  double t247, t248, t249, t250, t251, t253, t255, t256;
  double t259, t260, t263, t264, t268, t269, t273, t274;
  double t275, t276, t277, t282, t283, t284, t285, t287;
  double t288, t290, t292, t293, t294, t296, t299, t301;
  double t302, t305, t306, t307, t308, t309, t310, t317;
  double t321, t322, t323, t325, t334, t336, t339, t340;
  double t341, t342, t343, t344, t347, t349, t350, t355;
  double t357, t360, t361, t365, t368, t369, t370, t372;
  double tv2rho20, t375, t376, t377, t379, t380, t382, t384;
  double t385, t386, t387, t389, t393, t397, t399, t401;
  double t404, t408, t410, t411, t412, tv2rhosigma0, tv2rholapl0, t416;
  double t417, t419, t421, t423, t427, t437, t438, t439;
  double tv2rhotau0, t442, t444, t445, t446, t447, t448, t449;
  double t451, t452, t454, t457, t459, t460, tv2sigma20, tv2sigmalapl0;
  double t463, t464, t465, t466, t467, t468, t470, t471;
  double t473, t476, t478, t479, tv2sigmatau0, tv2lapl20, tv2lapltau0, t482;
  double t483, t484, t486, t487, t490, t497, t498, tv2tau20;

  double t501, t502, t503, t505, t506, t510, t511, t512;
  double t518, t519, t520, t522, t523, t525, t526, t528;
  double t529, t531, t532, t533, t535, t537, t540, t542;
  double t543, t547, t548, t551, t552, t556, t558, t569;
  double t571, t581, t591, t597, t602, t606, t610, t614;
  double t633, t634, t635, t636, t641, t644, t645, t646;
  double t649, t652, t653, t654, t657, t658, t659, t660;
  double t661, t663, t666, t667, t671, t674, t675, t676;
  double t678, t679, t680, t682, t683, t685, t686, t689;
  double t690, t692, t693, t694, t696, t698, t700, t702;
  double t703, t704, t707, t708, t711, t712, t714, t716;
  double t718, t719, t721, tv3rho30, t741, t742, t743, t744;
  double t746, t747, t749, t750, t752, t755, t758, t760;
  double t762, t764, t766, t770, t772, t773, t774, t776;
  double t778, t780, t782, t784, t787, t789, t793, t794;
  double t798, t802, t805, t809, t811, t813, t815, t817;
  double tv3rho2sigma0, tv3rho2lapl0, t827, t829, t832, t842, t847, t848;
  double t849, t851, t854, t857, t861, t862, t867, t869;
  double t871, t878, tv3rho2tau0, t880, t882, t883, t884, t885;
  double t887, t888, t889, t890, t892, t894, t896, t897;
  double t900, t902, t904, t907, t909, t910, t914, t917;
  double t919, t920, t921, tv3rhosigma20, tv3rhosigmalapl0, t925, t926, t928;
  double t930, t932, t933, t936, t940, t944, t947, t948;
  double t949, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t953, t954, t956, t958;
  double t960, t961, t964, t975, t976, t977, tv3rhotau20, t980;
  double t981, t982, t983, t984, t985, t987, t988, t989;
  double t990, t992, t994, t995, tv3sigma30, tv3sigma2lapl0, t997, t998;
  double t999, t1000, t1001, t1002, t1004, t1005, t1006, t1007;
  double t1009, t1011, t1012, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t1014, t1015;
  double t1016, t1017, t1018, t1020, t1021, t1022, t1023, t1025;
  double t1027, t1028, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20, t1030, t1031;
  double t1032, t1034, t1036, t1038, t1043, t1044, tv3tau30;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t8 = rho[0] * rho[0];
  t10 = 0.1e1 / t4 / t8;
  t13 = tau[0] * t6 - sigma[0] * t10 / 0.8e1;
  t14 = t2 * t13;
  t15 = M_CBRT6;
  t16 = t14 * t15;
  t17 = M_PI * M_PI;
  t18 = POW_1_3(t17);
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = t20 * t22;
  t26 = t15 * t20 * t22;
  t29 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t13 * t26;
  t30 = 0.1e1 / t29;
  t31 = M_CBRT3;
  t32 = 0.1e1 / M_PI;
  t33 = POW_1_3(t32);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t39 = t34 * t36 / t3;
  t41 = 0.1e1 + 0.53425e-1 * t39;
  t42 = sqrt(t39);
  t45 = POW_3_2(t39);
  t47 = t31 * t31;
  t48 = t33 * t33;
  t49 = t47 * t48;
  t52 = t49 * t35 / t4;
  t54 = 0.379785e1 * t42 + 0.8969e0 * t39 + 0.204775e0 * t45 + 0.123235e0 * t52;
  t57 = 0.1e1 + 0.16081979498692535067e2 / t54;
  t58 = log(t57);
  t62 = POW_1_3(p->zeta_threshold);
  t64 = my_piecewise3(0.1e1 <= p->zeta_threshold, t62 * p->zeta_threshold, 1);
  t70 = (0.2e1 * t64 - 0.2e1) / (0.2e1 * t21 - 0.2e1);
  t72 = 0.1e1 + 0.278125e-1 * t39;
  t77 = 0.51785e1 * t42 + 0.905775e0 * t39 + 0.1100325e0 * t45 + 0.1241775e0 * t52;
  t80 = 0.1e1 + 0.29608749977793437516e2 / t77;
  t81 = log(t80);
  t85 = -0.621814e-1 * t41 * t58 + 0.19751673498613801407e-1 * t70 * t72 * t81;
  t87 = t23 * t30 * t85;
  t89 = 0.5e1 / 0.9e1 * t16 * t87;
  t90 = t23 * t30;
  t93 = 0.1e1 - 0.5e1 / 0.9e1 * t16 * t90;
  t94 = t93 * t85;
  tzk0 = t89 + t94;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t97 = t8 * rho[0];
  t99 = 0.1e1 / t4 / t97;
  t102 = -0.5e1 / 0.3e1 * tau[0] * t10 + sigma[0] * t99 / 0.3e1;
  t103 = t2 * t102;
  t104 = t103 * t15;
  t105 = t104 * t87;
  t107 = t15 * t15;
  t109 = 0.1e1 / t18 / t17;
  t110 = t107 * t109;
  t111 = t14 * t110;
  t112 = t29 * t29;
  t113 = 0.1e1 / t112;
  t114 = t21 * t113;
  t115 = t85 * params->c;
  t117 = t114 * t115 * t102;
  t118 = t111 * t117;
  t121 = 0.1e1 / t3 / rho[0];
  t122 = t36 * t121;
  t126 = t54 * t54;
  t127 = 0.1e1 / t126;
  t128 = t41 * t127;
  t130 = 0.1e1 / t42 * t31;
  t131 = t33 * t36;
  t132 = t131 * t121;
  t133 = t130 * t132;
  t135 = t34 * t122;
  t137 = sqrt(t39);
  t138 = t137 * t31;
  t139 = t138 * t132;
  t142 = t49 * t35 * t6;
  t144 = -0.632975e0 * t133 - 0.29896666666666666667e0 * t135 - 0.1023875e0 * t139 - 0.82156666666666666667e-1 * t142;
  t145 = 0.1e1 / t57;
  t146 = t144 * t145;
  t149 = t70 * t31;
  t154 = t70 * t72;
  t155 = t77 * t77;
  t156 = 0.1e1 / t155;
  t161 = -0.86308333333333333334e0 * t133 - 0.301925e0 * t135 - 0.5501625e-1 * t139 - 0.82785e-1 * t142;
  t163 = 0.1e1 / t80;
  t164 = t156 * t161 * t163;
  t167 = 0.11073470983333333333e-2 * t34 * t122 * t58 + 0.1e1 * t128 * t146 - 0.18311447306006545054e-3 * t149 * t131 * t121 * t81 - 0.5848223622634646207e0 * t154 * t164;
  t169 = t23 * t30 * t167;
  t170 = t16 * t169;
  t175 = t114 * params->c * t102;
  t178 = -0.5e1 / 0.9e1 * t104 * t90 + 0.5e2 / 0.81e2 * t111 * t175;
  t179 = t178 * t85;
  t180 = t93 * t167;
  tvrho0 = t89 + t94 + rho[0] * (0.5e1 / 0.9e1 * t105 - 0.5e2 / 0.81e2 * t118 + 0.5e1 / 0.9e1 * t170 + t179 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t183 = t2 * t10;
  t184 = t183 * t15;
  t185 = t184 * t87;
  t186 = 0.5e1 / 0.72e2 * t185;
  t189 = t111 * t114 * t115 * t10;
  t190 = 0.25e2 / 0.324e3 * t189;
  t191 = t184 * t90;
  t195 = t111 * t114 * params->c * t10;
  t197 = 0.5e1 / 0.72e2 * t191 - 0.25e2 / 0.324e3 * t195;
  t198 = t197 * t85;
  tvsigma0 = rho[0] * (-t186 + t190 + t198);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t200 = t2 * t6;
  t201 = t200 * t15;
  t203 = 0.5e1 / 0.9e1 * t201 * t87;
  t207 = 0.5e2 / 0.81e2 * t111 * t114 * t115 * t6;
  t214 = -0.5e1 / 0.9e1 * t201 * t90 + 0.5e2 / 0.81e2 * t111 * t114 * params->c * t6;
  t215 = t214 * t85;
  tvtau0 = rho[0] * (t203 - t207 + t215);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t224 = t8 * t8;
  t226 = 0.1e1 / t4 / t224;
  t229 = 0.4e2 / 0.9e1 * tau[0] * t99 - 0.11e2 / 0.9e1 * sigma[0] * t226;
  t230 = t2 * t229;
  t231 = t230 * t15;
  t232 = t231 * t87;
  t234 = t102 * t102;
  t235 = t2 * t234;
  t236 = t235 * t110;
  t237 = t114 * t115;
  t238 = t236 * t237;
  t240 = t104 * t169;
  t242 = t17 * t17;
  t243 = 0.1e1 / t242;
  t244 = t14 * t243;
  t246 = 0.1e1 / t112 / t29;
  t247 = t246 * t85;
  t248 = params->c * params->c;
  t249 = t248 * t234;
  t250 = t247 * t249;
  t251 = t244 * t250;
  t253 = t167 * params->c;
  t255 = t114 * t253 * t102;
  t256 = t111 * t255;
  t259 = t114 * t115 * t229;
  t260 = t111 * t259;
  t263 = 0.1e1 / t3 / t8;
  t264 = t36 * t263;
  t268 = t34 * t36;
  t269 = t121 * t127;
  t273 = t126 * t54;
  t274 = 0.1e1 / t273;
  t275 = t41 * t274;
  t276 = t144 * t144;
  t277 = t276 * t145;
  t282 = 0.1e1 / t42 / t39 * t47;
  t283 = t48 * t35;
  t284 = t283 * t10;
  t285 = t282 * t284;
  t287 = t131 * t263;
  t288 = t130 * t287;
  t290 = t34 * t264;
  t292 = 0.1e1/sqrt(t39);
  t293 = t292 * t47;
  t294 = t293 * t284;
  t296 = t138 * t287;
  t299 = t49 * t35 * t10;
  t301 = -0.42198333333333333333e0 * t285 + 0.84396666666666666666e0 * t288 + 0.39862222222222222223e0 * t290 + 0.68258333333333333333e-1 * t294 + 0.13651666666666666667e0 * t296 + 0.13692777777777777778e0 * t299;
  t302 = t301 * t145;
  t305 = t126 * t126;
  t306 = 0.1e1 / t305;
  t307 = t41 * t306;
  t308 = t57 * t57;
  t309 = 0.1e1 / t308;
  t310 = t276 * t309;
  t317 = t70 * t34;
  t321 = t155 * t77;
  t322 = 0.1e1 / t321;
  t323 = t161 * t161;
  t325 = t322 * t323 * t163;
  t334 = -0.57538888888888888889e0 * t285 + 0.11507777777777777778e1 * t288 + 0.40256666666666666667e0 * t290 + 0.366775e-1 * t294 + 0.73355e-1 * t296 + 0.137975e0 * t299;
  t336 = t156 * t334 * t163;
  t339 = t155 * t155;
  t340 = 0.1e1 / t339;
  t341 = t340 * t323;
  t342 = t80 * t80;
  t343 = 0.1e1 / t342;
  t344 = t341 * t343;
  t347 = -0.14764627977777777777e-2 * t34 * t264 * t58 - 0.35616666666666666666e-1 * t268 * t269 * t146 - 0.2e1 * t275 * t277 + 0.1e1 * t128 * t302 + 0.16081979498692535067e2 * t307 * t310 + 0.24415263074675393405e-3 * t149 * t131 * t263 * t81 + 0.10843581300301739842e-1 * t317 * t122 * t164 + 0.11696447245269292414e1 * t154 * t325 - 0.5848223622634646207e0 * t154 * t336 - 0.17315859105681463759e2 * t154 * t344;
  t349 = t23 * t30 * t347;
  t350 = t16 * t349;
  t355 = t109 * t21;
  t357 = t355 * t113 * params->c;
  t360 = t246 * t248;
  t361 = t360 * t234;
  t365 = t114 * params->c * t229;
  t368 = -0.5e1 / 0.9e1 * t231 * t90 + 0.1e3 / 0.81e2 * t235 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t361 + 0.5e2 / 0.81e2 * t111 * t365;
  t369 = t368 * t85;
  t370 = t178 * t167;
  t372 = t93 * t347;
  tv2rho20 = 0.1e2 / 0.9e1 * t105 - 0.1e3 / 0.81e2 * t118 + 0.1e2 / 0.9e1 * t170 + 0.2e1 * t179 + 0.2e1 * t180 + rho[0] * (0.5e1 / 0.9e1 * t232 - 0.1e3 / 0.81e2 * t238 + 0.1e2 / 0.9e1 * t240 + 0.2e4 / 0.243e3 * t251 - 0.1e3 / 0.81e2 * t256 - 0.5e2 / 0.81e2 * t260 + 0.5e1 / 0.9e1 * t350 + t369 + 0.2e1 * t370 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t375 = t2 * t99;
  t376 = t375 * t15;
  t377 = t376 * t87;
  t379 = t183 * t110;
  t380 = t379 * t117;
  t382 = t184 * t169;
  t384 = t243 * t246;
  t385 = t14 * t384;
  t386 = t85 * t248;
  t387 = t10 * t102;
  t389 = t385 * t386 * t387;
  t393 = t111 * t114 * t253 * t10;
  t397 = t111 * t114 * t115 * t99;
  t399 = t376 * t90;
  t401 = t379 * t175;
  t404 = t244 * t360 * t387;
  t408 = t111 * t114 * params->c * t99;
  t410 = -0.5e1 / 0.27e2 * t399 - 0.25e2 / 0.162e3 * t401 + 0.25e3 / 0.243e3 * t404 + 0.5e2 / 0.243e3 * t408;
  t411 = t410 * t85;
  t412 = t197 * t167;
  tv2rhosigma0 = -t186 + t190 + t198 + rho[0] * (0.5e1 / 0.27e2 * t377 + 0.25e2 / 0.162e3 * t380 - 0.5e1 / 0.72e2 * t382 - 0.25e3 / 0.243e3 * t389 + 0.25e2 / 0.324e3 * t393 - 0.5e2 / 0.243e3 * t397 + t411 + t412);

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t416 = t200 * t110;
  t417 = t416 * t117;
  t419 = t201 * t169;
  t421 = t6 * t102;
  t423 = t385 * t386 * t421;
  t427 = t111 * t114 * t253 * t6;
  t437 = 0.25e2 / 0.27e2 * t191 + 0.1e3 / 0.81e2 * t416 * t175 - 0.2e4 / 0.243e3 * t244 * t360 * t421 - 0.25e3 / 0.243e3 * t195;
  t438 = t437 * t85;
  t439 = t214 * t167;
  tv2rhotau0 = t203 - t207 + t215 + rho[0] * (-0.25e2 / 0.27e2 * t185 - 0.1e3 / 0.81e2 * t417 + 0.5e1 / 0.9e1 * t419 + 0.2e4 / 0.243e3 * t423 - 0.5e2 / 0.81e2 * t427 + 0.25e3 / 0.243e3 * t189 + t438 + t439);

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t442 = t224 * rho[0];
  t444 = 0.1e1 / t3 / t442;
  t445 = t2 * t444;
  t446 = t445 * t110;
  t447 = t446 * t237;
  t448 = 0.25e2 / 0.1296e4 * t447;
  t449 = t248 * t444;
  t451 = t244 * t247 * t449;
  t452 = 0.125e3 / 0.972e3 * t451;
  t454 = t445 * t107 * t357;
  t457 = t244 * t360 * t444;
  t459 = 0.25e2 / 0.1296e4 * t454 - 0.125e3 / 0.972e3 * t457;
  t460 = t459 * t85;
  tv2sigma20 = rho[0] * (-t448 + t452 + t460);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t463 = 0.1e1 / t3 / t224;
  t464 = t2 * t463;
  t465 = t464 * t110;
  t466 = t465 * t237;
  t467 = 0.25e2 / 0.162e3 * t466;
  t468 = t248 * t463;
  t470 = t244 * t247 * t468;
  t471 = 0.25e3 / 0.243e3 * t470;
  t473 = t464 * t107 * t357;
  t476 = t244 * t360 * t463;
  t478 = -0.25e2 / 0.162e3 * t473 + 0.25e3 / 0.243e3 * t476;
  t479 = t478 * t85;
  tv2sigmatau0 = rho[0] * (t467 - t471 + t479);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t482 = 0.1e1 / t3 / t97;
  t483 = t2 * t482;
  t484 = t483 * t110;
  t486 = 0.1e3 / 0.81e2 * t484 * t237;
  t487 = t248 * t482;
  t490 = 0.2e4 / 0.243e3 * t244 * t247 * t487;
  t497 = 0.1e3 / 0.81e2 * t483 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t360 * t482;
  t498 = t497 * t85;
  tv2tau20 = rho[0] * (-t486 + t490 + t498);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t501 = 0.1e1 / t305 / t126;
  t502 = t41 * t501;
  t503 = t276 * t144;
  t505 = 0.1e1 / t308 / t57;
  t506 = t503 * t505;
  t510 = 0.1e1 / t305 / t54;
  t511 = t41 * t510;
  t512 = t503 * t309;
  t518 = 0.1e1 / t42 / t52 * t32 / 0.4e1;
  t519 = 0.1e1 / t224;
  t520 = t518 * t519;
  t522 = t283 * t99;
  t523 = t282 * t522;
  t525 = t131 * t482;
  t526 = t130 * t525;
  t528 = t36 * t482;
  t529 = t34 * t528;
  t531 = 0.1e1/POW_3_2(t39);
  t532 = t531 * t32;
  t533 = t532 * t519;
  t535 = t293 * t522;
  t537 = t138 * t525;
  t540 = t49 * t35 * t99;
  t542 = -0.25319e1 * t520 + 0.16879333333333333333e1 * t523 - 0.19692555555555555555e1 * t526 - 0.93011851851851851854e0 * t529 + 0.13651666666666666667e0 * t533 - 0.27303333333333333333e0 * t535 - 0.3185388888888888889e0 * t537 - 0.36514074074074074075e0 * t540;
  t543 = t542 * t145;
  t547 = 0.1e1 / t339 / t155;
  t548 = t323 * t161;
  t551 = 0.1e1 / t342 / t80;
  t552 = t547 * t548 * t551;
  t556 = 0.1e1 / t339 / t77;
  t558 = t556 * t548 * t343;
  t569 = -0.34523333333333333333e1 * t520 + 0.23015555555555555556e1 * t523 - 0.26851481481481481482e1 * t526 - 0.93932222222222222223e0 * t529 + 0.73355e-1 * t533 - 0.14671e0 * t535 - 0.17116166666666666667e0 * t537 - 0.36793333333333333333e0 * t540;
  t571 = t156 * t569 * t163;
  t581 = t503 * t145;
  t591 = 0.51726012919273400301e3 * t502 * t506 - 0.96491876992155210402e2 * t511 * t512 + 0.1e1 * t128 * t543 - 0.10254018858216406658e4 * t154 * t552 + 0.10389515463408878255e3 * t154 * t558 - 0.5848223622634646207e0 * t154 * t571 + 0.34450798614814814813e-2 * t34 * t528 * t58 + 0.48245938496077605201e2 * t307 * t301 * t309 * t144 + 0.6e1 * t307 * t581 - 0.6e1 * t275 * t146 * t301 + 0.10685e0 * t268 * t121 * t274 * t277;
  t597 = t343 * t161;
  t602 = t340 * t548 * t163;
  t606 = t163 * t334;
  t610 = t121 * t306;
  t614 = t263 * t127;
  t633 = -0.56968947174242584612e-3 * t149 * t131 * t482 * t81 - 0.51947577317044391277e2 * t154 * t340 * t334 * t597 - 0.35089341735807877242e1 * t154 * t602 + 0.35089341735807877242e1 * t154 * t322 * t161 * t606 - 0.85917975471764868594e0 * t268 * t610 * t310 + 0.71233333333333333332e-1 * t268 * t614 * t146 - 0.53424999999999999999e-1 * t268 * t269 * t302 - 0.32530743900905219526e-1 * t317 * t122 * t325 - 0.21687162600603479684e-1 * t317 * t264 * t164 + 0.16265371950452609763e-1 * t317 * t122 * t336 + 0.48159733137676571078e0 * t317 * t122 * t344;
  t634 = t591 + t633;
  t635 = t93 * t634;
  t636 = t178 * t347;
  t641 = 0.1e1 / t4 / t442;
  t644 = -0.44e3 / 0.27e2 * tau[0] * t226 + 0.154e3 / 0.27e2 * sigma[0] * t641;
  t645 = t2 * t644;
  t646 = t645 * t15;
  t649 = t230 * t110;
  t652 = t234 * t102;
  t653 = t2 * t652;
  t654 = t384 * t248;
  t657 = t112 * t112;
  t658 = 0.1e1 / t657;
  t659 = t243 * t658;
  t660 = t14 * t659;
  t661 = t248 * params->c;
  t663 = t661 * t652 * t26;
  t666 = t102 * t229;
  t667 = t360 * t666;
  t671 = t114 * params->c * t644;
  t674 = -0.5e1 / 0.9e1 * t646 * t90 + 0.1e3 / 0.27e2 * t649 * t175 - 0.2e4 / 0.81e2 * t653 * t654 + 0.1e5 / 0.729e3 * t660 * t663 - 0.2e4 / 0.81e2 * t244 * t667 + 0.5e2 / 0.81e2 * t111 * t671;
  t675 = t674 * t85;
  t676 = t368 * t167;
  t678 = t653 * t243;
  t679 = t247 * t248;
  t680 = t678 * t679;
  t682 = t114 * t253;
  t683 = t236 * t682;
  t685 = t386 * t666;
  t686 = t385 * t685;
  t689 = t23 * t30 * t634;
  t690 = t16 * t689;
  t692 = t246 * t167;
  t693 = t692 * t249;
  t694 = t244 * t693;
  t696 = t646 * t87;
  t698 = t231 * t169;
  t700 = t104 * t349;
  t702 = t659 * t85;
  t703 = t14 * t702;
  t704 = t703 * t663;
  t707 = t114 * t253 * t229;
  t708 = t111 * t707;
  t711 = t114 * t115 * t644;
  t712 = t111 * t711;
  t714 = t649 * t117;
  t716 = t347 * params->c;
  t718 = t114 * t716 * t102;
  t719 = t111 * t718;
  t721 = t635 + 0.3e1 * t636 + t675 + 0.3e1 * t676 + 0.2e4 / 0.81e2 * t680 - 0.1e3 / 0.27e2 * t683 + 0.2e4 / 0.81e2 * t686 + 0.5e1 / 0.9e1 * t690 + 0.2e4 / 0.81e2 * t694 + 0.5e1 / 0.9e1 * t696 + 0.5e1 / 0.3e1 * t698 + 0.5e1 / 0.3e1 * t700 - 0.1e5 / 0.729e3 * t704 - 0.5e2 / 0.27e2 * t708 - 0.5e2 / 0.81e2 * t712 - 0.1e3 / 0.27e2 * t714 - 0.5e2 / 0.27e2 * t719;
  tv3rho30 = rho[0] * t721 - 0.1e3 / 0.27e2 * t256 - 0.5e2 / 0.27e2 * t260 + 0.3e1 * t372 + 0.3e1 * t369 + 0.6e1 * t370 + 0.5e1 / 0.3e1 * t232 + 0.1e2 / 0.3e1 * t240 + 0.2e4 / 0.81e2 * t251 + 0.5e1 / 0.3e1 * t350 - 0.1e3 / 0.27e2 * t238;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t741 = t197 * t347;
  t742 = t2 * t226;
  t743 = t742 * t15;
  t744 = t743 * t90;
  t746 = t375 * t110;
  t747 = t746 * t175;
  t749 = t183 * t243;
  t750 = t749 * t361;
  t752 = t379 * t365;
  t755 = t14 * t659 * t661;
  t758 = t755 * t10 * t234 * t26;
  t760 = t99 * t102;
  t762 = t244 * t360 * t760;
  t764 = t10 * t229;
  t766 = t244 * t360 * t764;
  t770 = t111 * t114 * params->c * t226;
  t772 = 0.55e2 / 0.81e2 * t744 + 0.2e3 / 0.243e3 * t747 + 0.25e3 / 0.81e2 * t750 - 0.25e2 / 0.162e3 * t752 - 0.125e4 / 0.729e3 * t758 - 0.4e4 / 0.729e3 * t762 + 0.25e3 / 0.243e3 * t766 - 0.55e3 / 0.729e3 * t770;
  t773 = t772 * t85;
  t774 = t410 * t167;
  t776 = t376 * t169;
  t778 = t749 * t250;
  t780 = t184 * t349;
  t782 = t167 * t248;
  t784 = t385 * t782 * t387;
  t787 = t385 * t386 * t764;
  t789 = t743 * t87;
  t793 = t661 * t10 * t234 * t26;
  t794 = t703 * t793;
  t798 = t111 * t114 * t115 * t226;
  t802 = t111 * t114 * t253 * t99;
  t805 = t385 * t386 * t760;
  t809 = t111 * t114 * t716 * t10;
  t811 = t746 * t117;
  t813 = t379 * t255;
  t815 = t379 * t259;
  t817 = t741 + t773 + 0.2e1 * t774 + 0.1e2 / 0.27e2 * t776 - 0.25e3 / 0.81e2 * t778 - 0.5e1 / 0.72e2 * t780 - 0.5e3 / 0.243e3 * t784 - 0.25e3 / 0.243e3 * t787 - 0.55e2 / 0.81e2 * t789 + 0.125e4 / 0.729e3 * t794 + 0.55e3 / 0.729e3 * t798 - 0.1e3 / 0.243e3 * t802 + 0.4e4 / 0.729e3 * t805 + 0.25e2 / 0.324e3 * t809 - 0.2e3 / 0.243e3 * t811 + 0.25e2 / 0.81e2 * t813 + 0.25e2 / 0.162e3 * t815;
  tv3rho2sigma0 = 0.1e2 / 0.27e2 * t377 + 0.25e2 / 0.81e2 * t380 - 0.5e1 / 0.36e2 * t382 - 0.5e3 / 0.243e3 * t389 + 0.25e2 / 0.162e3 * t393 - 0.1e3 / 0.243e3 * t397 + 0.2e1 * t411 + 0.2e1 * t412 + rho[0] * t817;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t827 = t437 * t167;
  t829 = t214 * t347;
  t832 = t200 * t243;
  t842 = t6 * t229;
  t847 = -0.2e3 / 0.81e2 * t399 - 0.1e4 / 0.243e3 * t401 - 0.2e4 / 0.81e2 * t832 * t361 + 0.1e3 / 0.81e2 * t416 * t365 + 0.1e5 / 0.729e3 * t755 * t6 * t234 * t26 + 0.2e5 / 0.729e3 * t404 - 0.2e4 / 0.243e3 * t244 * t360 * t842 + 0.2e4 / 0.729e3 * t408;
  t848 = t847 * t85;
  t849 = t832 * t250;
  t851 = t201 * t349;
  t854 = t385 * t782 * t421;
  t857 = t385 * t386 * t842;
  t861 = t661 * t6 * t234 * t26;
  t862 = t703 * t861;
  t867 = t111 * t114 * t716 * t6;
  t869 = t416 * t255;
  t871 = t416 * t259;
  t878 = 0.2e1 * t827 + t829 + t848 + 0.2e4 / 0.81e2 * t849 + 0.5e1 / 0.9e1 * t851 + 0.4e4 / 0.243e3 * t854 + 0.2e4 / 0.243e3 * t857 - 0.1e5 / 0.729e3 * t862 - 0.2e4 / 0.729e3 * t397 - 0.5e2 / 0.81e2 * t867 - 0.2e3 / 0.81e2 * t869 - 0.1e3 / 0.81e2 * t871 + 0.1e4 / 0.243e3 * t380 + 0.5e3 / 0.243e3 * t393 - 0.5e2 / 0.27e2 * t382 + 0.2e3 / 0.81e2 * t377 - 0.2e5 / 0.729e3 * t389;
  tv3rho2tau0 = -0.5e2 / 0.27e2 * t185 - 0.2e3 / 0.81e2 * t417 + 0.1e2 / 0.9e1 * t419 + 0.4e4 / 0.243e3 * t423 - 0.1e3 / 0.81e2 * t427 + 0.5e3 / 0.243e3 * t189 + 0.2e1 * t438 + 0.2e1 * t439 + rho[0] * t878;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t880 = t224 * t8;
  t882 = 0.1e1 / t3 / t880;
  t883 = t2 * t882;
  t884 = t883 * t110;
  t885 = t884 * t237;
  t887 = t445 * t243;
  t888 = t248 * t102;
  t889 = t247 * t888;
  t890 = t887 * t889;
  t892 = t446 * t682;
  t894 = t661 * t444;
  t896 = t894 * t102 * t26;
  t897 = t703 * t896;
  t900 = t244 * t692 * t449;
  t902 = t248 * t882;
  t904 = t244 * t247 * t902;
  t907 = t883 * t107 * t357;
  t909 = t360 * t102;
  t910 = t887 * t909;
  t914 = t755 * t444 * t102 * t26;
  t917 = t244 * t360 * t882;
  t919 = -0.25e2 / 0.243e3 * t907 - 0.125e3 / 0.324e3 * t910 + 0.625e3 / 0.2916e4 * t914 + 0.5e3 / 0.729e3 * t917;
  t920 = t919 * t85;
  t921 = t459 * t167;
  tv3rhosigma20 = -t448 + t452 + t460 + rho[0] * (0.25e2 / 0.243e3 * t885 + 0.125e3 / 0.324e3 * t890 - 0.25e2 / 0.1296e4 * t892 - 0.625e3 / 0.2916e4 * t897 + 0.125e3 / 0.972e3 * t900 - 0.5e3 / 0.729e3 * t904 + t920 + t921);

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t925 = t464 * t243;
  t926 = t925 * t889;
  t928 = t465 * t682;
  t930 = t661 * t463;
  t932 = t930 * t102 * t26;
  t933 = t703 * t932;
  t936 = t244 * t692 * t468;
  t940 = t925 * t909;
  t944 = t755 * t463 * t102 * t26;
  t947 = 0.325e3 / 0.486e3 * t454 + 0.25e3 / 0.81e2 * t940 - 0.125e4 / 0.729e3 * t944 - 0.325e4 / 0.729e3 * t457;
  t948 = t947 * t85;
  t949 = t478 * t167;
  tv3rhosigmatau0 = t467 - t471 + t479 + rho[0] * (-0.325e3 / 0.486e3 * t447 - 0.25e3 / 0.81e2 * t926 + 0.25e2 / 0.162e3 * t928 + 0.125e4 / 0.729e3 * t933 - 0.25e3 / 0.243e3 * t936 + 0.325e4 / 0.729e3 * t451 + t948 + t949);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t953 = t483 * t243;
  t954 = t953 * t889;
  t956 = t484 * t682;
  t958 = t661 * t482;
  t960 = t958 * t102 * t26;
  t961 = t703 * t960;
  t964 = t244 * t692 * t487;
  t975 = -0.1e4 / 0.243e3 * t473 - 0.2e4 / 0.81e2 * t953 * t909 + 0.1e5 / 0.729e3 * t755 * t482 * t102 * t26 + 0.2e5 / 0.729e3 * t476;
  t976 = t975 * t85;
  t977 = t497 * t167;
  tv3rhotau20 = -t486 + t490 + t498 + rho[0] * (0.1e4 / 0.243e3 * t466 + 0.2e4 / 0.81e2 * t954 - 0.1e3 / 0.81e2 * t956 - 0.1e5 / 0.729e3 * t961 + 0.2e4 / 0.243e3 * t964 - 0.2e5 / 0.729e3 * t470 + t976 + t977);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t980 = t224 * t224;
  t981 = 0.1e1 / t980;
  t982 = t2 * t981;
  t983 = t982 * t243;
  t984 = t983 * t679;
  t985 = 0.125e3 / 0.2592e4 * t984;
  t987 = t661 * t981 * t26;
  t988 = t703 * t987;
  t989 = 0.625e3 / 0.23328e5 * t988;
  t990 = t982 * t654;
  t992 = t660 * t987;
  t994 = 0.125e3 / 0.2592e4 * t990 - 0.625e3 / 0.23328e5 * t992;
  t995 = t994 * t85;
  tv3sigma30 = rho[0] * (-t985 + t989 + t995);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t997 = t224 * t97;
  t998 = 0.1e1 / t997;
  t999 = t2 * t998;
  t1000 = t999 * t243;
  t1001 = t1000 * t679;
  t1002 = 0.125e3 / 0.324e3 * t1001;
  t1004 = t661 * t998 * t26;
  t1005 = t703 * t1004;
  t1006 = 0.625e3 / 0.2916e4 * t1005;
  t1007 = t999 * t654;
  t1009 = t660 * t1004;
  t1011 = -0.125e3 / 0.324e3 * t1007 + 0.625e3 / 0.2916e4 * t1009;
  t1012 = t1011 * t85;
  tv3sigma2tau0 = rho[0] * (t1002 - t1006 + t1012);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1014 = 0.1e1 / t880;
  t1015 = t2 * t1014;
  t1016 = t1015 * t243;
  t1017 = t1016 * t679;
  t1018 = 0.25e3 / 0.81e2 * t1017;
  t1020 = t661 * t1014 * t26;
  t1021 = t703 * t1020;
  t1022 = 0.125e4 / 0.729e3 * t1021;
  t1023 = t1015 * t654;
  t1025 = t660 * t1020;
  t1027 = 0.25e3 / 0.81e2 * t1023 - 0.125e4 / 0.729e3 * t1025;
  t1028 = t1027 * t85;
  tv3sigmatau20 = rho[0] * (-t1018 + t1022 + t1028);

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1030 = 0.1e1 / t442;
  t1031 = t2 * t1030;
  t1032 = t1031 * t243;
  t1034 = 0.2e4 / 0.81e2 * t1032 * t679;
  t1036 = t661 * t1030 * t26;
  t1038 = 0.1e5 / 0.729e3 * t703 * t1036;
  t1043 = -0.2e4 / 0.81e2 * t1031 * t654 + 0.1e5 / 0.729e3 * t660 * t1036;
  t1044 = t1043 * t85;
  tv3tau30 = rho[0] * (t1034 - t1038 + t1044);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t8, t10, t13, t14;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t26, t29, t30, t31, t32, t33, t34;
  double t35, t36, t39, t41, t42, t45, t47, t48;
  double t49, t52, t54, t57, t58, t62, t64, t70;
  double t72, t77, t80, t81, t85, t87, t89, t90;
  double t93, t94, tzk0;

  double t97, t99, t102, t103, t104, t105, t107, t109;
  double t110, t111, t112, t113, t114, t115, t117, t118;
  double t121, t122, t126, t127, t128, t130, t131, t132;
  double t133, t135, t137, t138, t139, t142, t144, t145;
  double t146, t149, t154, t155, t156, t161, t163, t164;
  double t167, t169, t170, t175, t178, t179, t180, tvrho0;
  double t183, t184, t185, t186, t189, t190, t191, t195;
  double t197, t198, tvsigma0, tvlapl0, t200, t201, t203, t207;
  double t214, t215, tvtau0;

  double t224, t226, t229, t230, t231, t232, t234, t235;
  double t236, t237, t238, t240, t242, t243, t244, t246;
  double t247, t248, t249, t250, t251, t253, t255, t256;
  double t259, t260, t263, t264, t268, t269, t273, t274;
  double t275, t276, t277, t282, t283, t284, t285, t287;
  double t288, t290, t292, t293, t294, t296, t299, t301;
  double t302, t305, t306, t307, t308, t309, t310, t317;
  double t321, t322, t323, t325, t334, t336, t339, t340;
  double t341, t342, t343, t344, t347, t349, t350, t355;
  double t357, t360, t361, t365, t368, t369, t370, t372;
  double tv2rho20, t375, t376, t377, t379, t380, t382, t384;
  double t385, t386, t387, t389, t393, t397, t399, t401;
  double t404, t408, t410, t411, t412, tv2rhosigma0, tv2rholapl0, t416;
  double t417, t419, t421, t423, t427, t437, t438, t439;
  double tv2rhotau0, t442, t444, t445, t446, t447, t448, t449;
  double t451, t452, t454, t457, t459, t460, tv2sigma20, tv2sigmalapl0;
  double t463, t464, t465, t466, t467, t468, t470, t471;
  double t473, t476, t478, t479, tv2sigmatau0, tv2lapl20, tv2lapltau0, t482;
  double t483, t484, t486, t487, t490, t497, t498, tv2tau20;

  double t501, t502, t503, t505, t506, t510, t511, t512;
  double t518, t519, t520, t522, t523, t525, t526, t528;
  double t529, t531, t532, t533, t535, t537, t540, t542;
  double t543, t547, t548, t551, t552, t556, t558, t569;
  double t571, t581, t591, t597, t602, t606, t610, t614;
  double t633, t634, t635, t636, t641, t644, t645, t646;
  double t649, t652, t653, t654, t657, t658, t659, t660;
  double t661, t663, t666, t667, t671, t674, t675, t676;
  double t678, t679, t680, t682, t683, t685, t686, t689;
  double t690, t692, t693, t694, t696, t698, t700, t702;
  double t703, t704, t707, t708, t711, t712, t714, t716;
  double t718, t719, t721, tv3rho30, t741, t742, t743, t744;
  double t746, t747, t749, t750, t752, t755, t758, t760;
  double t762, t764, t766, t770, t772, t773, t774, t776;
  double t778, t780, t782, t784, t787, t789, t793, t794;
  double t798, t802, t805, t809, t811, t813, t815, t817;
  double tv3rho2sigma0, tv3rho2lapl0, t827, t829, t832, t842, t847, t848;
  double t849, t851, t854, t857, t861, t862, t867, t869;
  double t871, t878, tv3rho2tau0, t880, t882, t883, t884, t885;
  double t887, t888, t889, t890, t892, t894, t896, t897;
  double t900, t902, t904, t907, t909, t910, t914, t917;
  double t919, t920, t921, tv3rhosigma20, tv3rhosigmalapl0, t925, t926, t928;
  double t930, t932, t933, t936, t940, t944, t947, t948;
  double t949, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t953, t954, t956, t958;
  double t960, t961, t964, t975, t976, t977, tv3rhotau20, t980;
  double t981, t982, t983, t984, t985, t987, t988, t989;
  double t990, t992, t994, t995, tv3sigma30, tv3sigma2lapl0, t997, t998;
  double t999, t1000, t1001, t1002, t1004, t1005, t1006, t1007;
  double t1009, t1011, t1012, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t1014, t1015;
  double t1016, t1017, t1018, t1020, t1021, t1022, t1023, t1025;
  double t1027, t1028, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20, t1030, t1031;
  double t1032, t1034, t1036, t1038, t1043, t1044, tv3tau30;

  double t1063, t1069, t1073, t1074, t1079, t1084, t1086, t1087;
  double t1088, t1090, t1091, t1095, t1097, t1103, t1108, t1122;
  double t1125, t1132, t1135, t1166, t1168, t1170, t1171, t1173;
  double t1174, t1176, t1177, t1179, t1182, t1184, t1186, t1188;
  double t1191, t1198, t1200, t1202, t1207, t1209, t1215, t1220;
  double t1223, t1224, t1229, t1253, t1273, t1286, t1324, t1372;
  double t1374, t1386, t1389, t1402, t1405, t1423, t1426, t1430;
  double t1446, tv4rho40, t1455, t1460, t1469, t1476, t1480, t1484;
  double t1496, t1511, t1526, t1536, t1538, t1541, t1588, tv4rho3sigma0;
  double tv4rho3lapl0, t1615, t1631, t1636, t1664, t1695, tv4rho3tau0, t1724;
  double t1728, t1729, t1748, t1754, t1781, t1802, tv4rho2sigma20, tv4rho2sigmalapl0;
  double t1863, tv4rho2sigmatau0, tv4rho2lapl20, tv4rho2lapltau0, t1924, tv4rho2tau20, t1926, t1927;
  double t1928, t1934, t1941, t1948, tv4rhosigma30, tv4rhosigma2lapl0, tv4rhosigma2tau0, tv4rhosigmalapl20;
  double tv4rhosigmalapltau0, tv4rhosigmatau20, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20, tv4rhotau30, t2053, t2055;
  double t2059, tv4sigma40, tv4sigma3lapl0, t2070, t2072, t2076, tv4sigma3tau0, tv4sigma2lapl20;
  double tv4sigma2lapltau0, t2087, t2089, t2093, tv4sigma2tau20, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20;
  double t2104, t2106, t2110, tv4sigmatau30, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30;
  double t2121, t2125, tv4tau40;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t8 = rho[0] * rho[0];
  t10 = 0.1e1 / t4 / t8;
  t13 = tau[0] * t6 - sigma[0] * t10 / 0.8e1;
  t14 = t2 * t13;
  t15 = M_CBRT6;
  t16 = t14 * t15;
  t17 = M_PI * M_PI;
  t18 = POW_1_3(t17);
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = t20 * t22;
  t26 = t15 * t20 * t22;
  t29 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t13 * t26;
  t30 = 0.1e1 / t29;
  t31 = M_CBRT3;
  t32 = 0.1e1 / M_PI;
  t33 = POW_1_3(t32);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t39 = t34 * t36 / t3;
  t41 = 0.1e1 + 0.53425e-1 * t39;
  t42 = sqrt(t39);
  t45 = POW_3_2(t39);
  t47 = t31 * t31;
  t48 = t33 * t33;
  t49 = t47 * t48;
  t52 = t49 * t35 / t4;
  t54 = 0.379785e1 * t42 + 0.8969e0 * t39 + 0.204775e0 * t45 + 0.123235e0 * t52;
  t57 = 0.1e1 + 0.16081979498692535067e2 / t54;
  t58 = log(t57);
  t62 = POW_1_3(p->zeta_threshold);
  t64 = my_piecewise3(0.1e1 <= p->zeta_threshold, t62 * p->zeta_threshold, 1);
  t70 = (0.2e1 * t64 - 0.2e1) / (0.2e1 * t21 - 0.2e1);
  t72 = 0.1e1 + 0.278125e-1 * t39;
  t77 = 0.51785e1 * t42 + 0.905775e0 * t39 + 0.1100325e0 * t45 + 0.1241775e0 * t52;
  t80 = 0.1e1 + 0.29608749977793437516e2 / t77;
  t81 = log(t80);
  t85 = -0.621814e-1 * t41 * t58 + 0.19751673498613801407e-1 * t70 * t72 * t81;
  t87 = t23 * t30 * t85;
  t89 = 0.5e1 / 0.9e1 * t16 * t87;
  t90 = t23 * t30;
  t93 = 0.1e1 - 0.5e1 / 0.9e1 * t16 * t90;
  t94 = t93 * t85;
  tzk0 = t89 + t94;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t97 = t8 * rho[0];
  t99 = 0.1e1 / t4 / t97;
  t102 = -0.5e1 / 0.3e1 * tau[0] * t10 + sigma[0] * t99 / 0.3e1;
  t103 = t2 * t102;
  t104 = t103 * t15;
  t105 = t104 * t87;
  t107 = t15 * t15;
  t109 = 0.1e1 / t18 / t17;
  t110 = t107 * t109;
  t111 = t14 * t110;
  t112 = t29 * t29;
  t113 = 0.1e1 / t112;
  t114 = t21 * t113;
  t115 = t85 * params->c;
  t117 = t114 * t115 * t102;
  t118 = t111 * t117;
  t121 = 0.1e1 / t3 / rho[0];
  t122 = t36 * t121;
  t126 = t54 * t54;
  t127 = 0.1e1 / t126;
  t128 = t41 * t127;
  t130 = 0.1e1 / t42 * t31;
  t131 = t33 * t36;
  t132 = t131 * t121;
  t133 = t130 * t132;
  t135 = t34 * t122;
  t137 = sqrt(t39);
  t138 = t137 * t31;
  t139 = t138 * t132;
  t142 = t49 * t35 * t6;
  t144 = -0.632975e0 * t133 - 0.29896666666666666667e0 * t135 - 0.1023875e0 * t139 - 0.82156666666666666667e-1 * t142;
  t145 = 0.1e1 / t57;
  t146 = t144 * t145;
  t149 = t70 * t31;
  t154 = t70 * t72;
  t155 = t77 * t77;
  t156 = 0.1e1 / t155;
  t161 = -0.86308333333333333334e0 * t133 - 0.301925e0 * t135 - 0.5501625e-1 * t139 - 0.82785e-1 * t142;
  t163 = 0.1e1 / t80;
  t164 = t156 * t161 * t163;
  t167 = 0.11073470983333333333e-2 * t34 * t122 * t58 + 0.1e1 * t128 * t146 - 0.18311447306006545054e-3 * t149 * t131 * t121 * t81 - 0.5848223622634646207e0 * t154 * t164;
  t169 = t23 * t30 * t167;
  t170 = t16 * t169;
  t175 = t114 * params->c * t102;
  t178 = -0.5e1 / 0.9e1 * t104 * t90 + 0.5e2 / 0.81e2 * t111 * t175;
  t179 = t178 * t85;
  t180 = t93 * t167;
  tvrho0 = t89 + t94 + rho[0] * (0.5e1 / 0.9e1 * t105 - 0.5e2 / 0.81e2 * t118 + 0.5e1 / 0.9e1 * t170 + t179 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t183 = t2 * t10;
  t184 = t183 * t15;
  t185 = t184 * t87;
  t186 = 0.5e1 / 0.72e2 * t185;
  t189 = t111 * t114 * t115 * t10;
  t190 = 0.25e2 / 0.324e3 * t189;
  t191 = t184 * t90;
  t195 = t111 * t114 * params->c * t10;
  t197 = 0.5e1 / 0.72e2 * t191 - 0.25e2 / 0.324e3 * t195;
  t198 = t197 * t85;
  tvsigma0 = rho[0] * (-t186 + t190 + t198);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t200 = t2 * t6;
  t201 = t200 * t15;
  t203 = 0.5e1 / 0.9e1 * t201 * t87;
  t207 = 0.5e2 / 0.81e2 * t111 * t114 * t115 * t6;
  t214 = -0.5e1 / 0.9e1 * t201 * t90 + 0.5e2 / 0.81e2 * t111 * t114 * params->c * t6;
  t215 = t214 * t85;
  tvtau0 = rho[0] * (t203 - t207 + t215);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t224 = t8 * t8;
  t226 = 0.1e1 / t4 / t224;
  t229 = 0.4e2 / 0.9e1 * tau[0] * t99 - 0.11e2 / 0.9e1 * sigma[0] * t226;
  t230 = t2 * t229;
  t231 = t230 * t15;
  t232 = t231 * t87;
  t234 = t102 * t102;
  t235 = t2 * t234;
  t236 = t235 * t110;
  t237 = t114 * t115;
  t238 = t236 * t237;
  t240 = t104 * t169;
  t242 = t17 * t17;
  t243 = 0.1e1 / t242;
  t244 = t14 * t243;
  t246 = 0.1e1 / t112 / t29;
  t247 = t246 * t85;
  t248 = params->c * params->c;
  t249 = t248 * t234;
  t250 = t247 * t249;
  t251 = t244 * t250;
  t253 = t167 * params->c;
  t255 = t114 * t253 * t102;
  t256 = t111 * t255;
  t259 = t114 * t115 * t229;
  t260 = t111 * t259;
  t263 = 0.1e1 / t3 / t8;
  t264 = t36 * t263;
  t268 = t34 * t36;
  t269 = t121 * t127;
  t273 = t126 * t54;
  t274 = 0.1e1 / t273;
  t275 = t41 * t274;
  t276 = t144 * t144;
  t277 = t276 * t145;
  t282 = 0.1e1 / t42 / t39 * t47;
  t283 = t48 * t35;
  t284 = t283 * t10;
  t285 = t282 * t284;
  t287 = t131 * t263;
  t288 = t130 * t287;
  t290 = t34 * t264;
  t292 = 0.1e1/sqrt(t39);
  t293 = t292 * t47;
  t294 = t293 * t284;
  t296 = t138 * t287;
  t299 = t49 * t35 * t10;
  t301 = -0.42198333333333333333e0 * t285 + 0.84396666666666666666e0 * t288 + 0.39862222222222222223e0 * t290 + 0.68258333333333333333e-1 * t294 + 0.13651666666666666667e0 * t296 + 0.13692777777777777778e0 * t299;
  t302 = t301 * t145;
  t305 = t126 * t126;
  t306 = 0.1e1 / t305;
  t307 = t41 * t306;
  t308 = t57 * t57;
  t309 = 0.1e1 / t308;
  t310 = t276 * t309;
  t317 = t70 * t34;
  t321 = t155 * t77;
  t322 = 0.1e1 / t321;
  t323 = t161 * t161;
  t325 = t322 * t323 * t163;
  t334 = -0.57538888888888888889e0 * t285 + 0.11507777777777777778e1 * t288 + 0.40256666666666666667e0 * t290 + 0.366775e-1 * t294 + 0.73355e-1 * t296 + 0.137975e0 * t299;
  t336 = t156 * t334 * t163;
  t339 = t155 * t155;
  t340 = 0.1e1 / t339;
  t341 = t340 * t323;
  t342 = t80 * t80;
  t343 = 0.1e1 / t342;
  t344 = t341 * t343;
  t347 = -0.14764627977777777777e-2 * t34 * t264 * t58 - 0.35616666666666666666e-1 * t268 * t269 * t146 - 0.2e1 * t275 * t277 + 0.1e1 * t128 * t302 + 0.16081979498692535067e2 * t307 * t310 + 0.24415263074675393405e-3 * t149 * t131 * t263 * t81 + 0.10843581300301739842e-1 * t317 * t122 * t164 + 0.11696447245269292414e1 * t154 * t325 - 0.5848223622634646207e0 * t154 * t336 - 0.17315859105681463759e2 * t154 * t344;
  t349 = t23 * t30 * t347;
  t350 = t16 * t349;
  t355 = t109 * t21;
  t357 = t355 * t113 * params->c;
  t360 = t246 * t248;
  t361 = t360 * t234;
  t365 = t114 * params->c * t229;
  t368 = -0.5e1 / 0.9e1 * t231 * t90 + 0.1e3 / 0.81e2 * t235 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t361 + 0.5e2 / 0.81e2 * t111 * t365;
  t369 = t368 * t85;
  t370 = t178 * t167;
  t372 = t93 * t347;
  tv2rho20 = 0.1e2 / 0.9e1 * t105 - 0.1e3 / 0.81e2 * t118 + 0.1e2 / 0.9e1 * t170 + 0.2e1 * t179 + 0.2e1 * t180 + rho[0] * (0.5e1 / 0.9e1 * t232 - 0.1e3 / 0.81e2 * t238 + 0.1e2 / 0.9e1 * t240 + 0.2e4 / 0.243e3 * t251 - 0.1e3 / 0.81e2 * t256 - 0.5e2 / 0.81e2 * t260 + 0.5e1 / 0.9e1 * t350 + t369 + 0.2e1 * t370 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t375 = t2 * t99;
  t376 = t375 * t15;
  t377 = t376 * t87;
  t379 = t183 * t110;
  t380 = t379 * t117;
  t382 = t184 * t169;
  t384 = t243 * t246;
  t385 = t14 * t384;
  t386 = t85 * t248;
  t387 = t10 * t102;
  t389 = t385 * t386 * t387;
  t393 = t111 * t114 * t253 * t10;
  t397 = t111 * t114 * t115 * t99;
  t399 = t376 * t90;
  t401 = t379 * t175;
  t404 = t244 * t360 * t387;
  t408 = t111 * t114 * params->c * t99;
  t410 = -0.5e1 / 0.27e2 * t399 - 0.25e2 / 0.162e3 * t401 + 0.25e3 / 0.243e3 * t404 + 0.5e2 / 0.243e3 * t408;
  t411 = t410 * t85;
  t412 = t197 * t167;
  tv2rhosigma0 = -t186 + t190 + t198 + rho[0] * (0.5e1 / 0.27e2 * t377 + 0.25e2 / 0.162e3 * t380 - 0.5e1 / 0.72e2 * t382 - 0.25e3 / 0.243e3 * t389 + 0.25e2 / 0.324e3 * t393 - 0.5e2 / 0.243e3 * t397 + t411 + t412);

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t416 = t200 * t110;
  t417 = t416 * t117;
  t419 = t201 * t169;
  t421 = t6 * t102;
  t423 = t385 * t386 * t421;
  t427 = t111 * t114 * t253 * t6;
  t437 = 0.25e2 / 0.27e2 * t191 + 0.1e3 / 0.81e2 * t416 * t175 - 0.2e4 / 0.243e3 * t244 * t360 * t421 - 0.25e3 / 0.243e3 * t195;
  t438 = t437 * t85;
  t439 = t214 * t167;
  tv2rhotau0 = t203 - t207 + t215 + rho[0] * (-0.25e2 / 0.27e2 * t185 - 0.1e3 / 0.81e2 * t417 + 0.5e1 / 0.9e1 * t419 + 0.2e4 / 0.243e3 * t423 - 0.5e2 / 0.81e2 * t427 + 0.25e3 / 0.243e3 * t189 + t438 + t439);

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t442 = t224 * rho[0];
  t444 = 0.1e1 / t3 / t442;
  t445 = t2 * t444;
  t446 = t445 * t110;
  t447 = t446 * t237;
  t448 = 0.25e2 / 0.1296e4 * t447;
  t449 = t248 * t444;
  t451 = t244 * t247 * t449;
  t452 = 0.125e3 / 0.972e3 * t451;
  t454 = t445 * t107 * t357;
  t457 = t244 * t360 * t444;
  t459 = 0.25e2 / 0.1296e4 * t454 - 0.125e3 / 0.972e3 * t457;
  t460 = t459 * t85;
  tv2sigma20 = rho[0] * (-t448 + t452 + t460);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t463 = 0.1e1 / t3 / t224;
  t464 = t2 * t463;
  t465 = t464 * t110;
  t466 = t465 * t237;
  t467 = 0.25e2 / 0.162e3 * t466;
  t468 = t248 * t463;
  t470 = t244 * t247 * t468;
  t471 = 0.25e3 / 0.243e3 * t470;
  t473 = t464 * t107 * t357;
  t476 = t244 * t360 * t463;
  t478 = -0.25e2 / 0.162e3 * t473 + 0.25e3 / 0.243e3 * t476;
  t479 = t478 * t85;
  tv2sigmatau0 = rho[0] * (t467 - t471 + t479);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t482 = 0.1e1 / t3 / t97;
  t483 = t2 * t482;
  t484 = t483 * t110;
  t486 = 0.1e3 / 0.81e2 * t484 * t237;
  t487 = t248 * t482;
  t490 = 0.2e4 / 0.243e3 * t244 * t247 * t487;
  t497 = 0.1e3 / 0.81e2 * t483 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t360 * t482;
  t498 = t497 * t85;
  tv2tau20 = rho[0] * (-t486 + t490 + t498);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t501 = 0.1e1 / t305 / t126;
  t502 = t41 * t501;
  t503 = t276 * t144;
  t505 = 0.1e1 / t308 / t57;
  t506 = t503 * t505;
  t510 = 0.1e1 / t305 / t54;
  t511 = t41 * t510;
  t512 = t503 * t309;
  t518 = 0.1e1 / t42 / t52 * t32 / 0.4e1;
  t519 = 0.1e1 / t224;
  t520 = t518 * t519;
  t522 = t283 * t99;
  t523 = t282 * t522;
  t525 = t131 * t482;
  t526 = t130 * t525;
  t528 = t36 * t482;
  t529 = t34 * t528;
  t531 = 0.1e1/POW_3_2(t39);
  t532 = t531 * t32;
  t533 = t532 * t519;
  t535 = t293 * t522;
  t537 = t138 * t525;
  t540 = t49 * t35 * t99;
  t542 = -0.25319e1 * t520 + 0.16879333333333333333e1 * t523 - 0.19692555555555555555e1 * t526 - 0.93011851851851851854e0 * t529 + 0.13651666666666666667e0 * t533 - 0.27303333333333333333e0 * t535 - 0.3185388888888888889e0 * t537 - 0.36514074074074074075e0 * t540;
  t543 = t542 * t145;
  t547 = 0.1e1 / t339 / t155;
  t548 = t323 * t161;
  t551 = 0.1e1 / t342 / t80;
  t552 = t547 * t548 * t551;
  t556 = 0.1e1 / t339 / t77;
  t558 = t556 * t548 * t343;
  t569 = -0.34523333333333333333e1 * t520 + 0.23015555555555555556e1 * t523 - 0.26851481481481481482e1 * t526 - 0.93932222222222222223e0 * t529 + 0.73355e-1 * t533 - 0.14671e0 * t535 - 0.17116166666666666667e0 * t537 - 0.36793333333333333333e0 * t540;
  t571 = t156 * t569 * t163;
  t581 = t503 * t145;
  t591 = 0.51726012919273400301e3 * t502 * t506 - 0.96491876992155210402e2 * t511 * t512 + 0.1e1 * t128 * t543 - 0.10254018858216406658e4 * t154 * t552 + 0.10389515463408878255e3 * t154 * t558 - 0.5848223622634646207e0 * t154 * t571 + 0.34450798614814814813e-2 * t34 * t528 * t58 + 0.48245938496077605201e2 * t307 * t301 * t309 * t144 + 0.6e1 * t307 * t581 - 0.6e1 * t275 * t146 * t301 + 0.10685e0 * t268 * t121 * t274 * t277;
  t597 = t343 * t161;
  t602 = t340 * t548 * t163;
  t606 = t163 * t334;
  t610 = t121 * t306;
  t614 = t263 * t127;
  t633 = -0.56968947174242584612e-3 * t149 * t131 * t482 * t81 - 0.51947577317044391277e2 * t154 * t340 * t334 * t597 - 0.35089341735807877242e1 * t154 * t602 + 0.35089341735807877242e1 * t154 * t322 * t161 * t606 - 0.85917975471764868594e0 * t268 * t610 * t310 + 0.71233333333333333332e-1 * t268 * t614 * t146 - 0.53424999999999999999e-1 * t268 * t269 * t302 - 0.32530743900905219526e-1 * t317 * t122 * t325 - 0.21687162600603479684e-1 * t317 * t264 * t164 + 0.16265371950452609763e-1 * t317 * t122 * t336 + 0.48159733137676571078e0 * t317 * t122 * t344;
  t634 = t591 + t633;
  t635 = t93 * t634;
  t636 = t178 * t347;
  t641 = 0.1e1 / t4 / t442;
  t644 = -0.44e3 / 0.27e2 * tau[0] * t226 + 0.154e3 / 0.27e2 * sigma[0] * t641;
  t645 = t2 * t644;
  t646 = t645 * t15;
  t649 = t230 * t110;
  t652 = t234 * t102;
  t653 = t2 * t652;
  t654 = t384 * t248;
  t657 = t112 * t112;
  t658 = 0.1e1 / t657;
  t659 = t243 * t658;
  t660 = t14 * t659;
  t661 = t248 * params->c;
  t663 = t661 * t652 * t26;
  t666 = t102 * t229;
  t667 = t360 * t666;
  t671 = t114 * params->c * t644;
  t674 = -0.5e1 / 0.9e1 * t646 * t90 + 0.1e3 / 0.27e2 * t649 * t175 - 0.2e4 / 0.81e2 * t653 * t654 + 0.1e5 / 0.729e3 * t660 * t663 - 0.2e4 / 0.81e2 * t244 * t667 + 0.5e2 / 0.81e2 * t111 * t671;
  t675 = t674 * t85;
  t676 = t368 * t167;
  t678 = t653 * t243;
  t679 = t247 * t248;
  t680 = t678 * t679;
  t682 = t114 * t253;
  t683 = t236 * t682;
  t685 = t386 * t666;
  t686 = t385 * t685;
  t689 = t23 * t30 * t634;
  t690 = t16 * t689;
  t692 = t246 * t167;
  t693 = t692 * t249;
  t694 = t244 * t693;
  t696 = t646 * t87;
  t698 = t231 * t169;
  t700 = t104 * t349;
  t702 = t659 * t85;
  t703 = t14 * t702;
  t704 = t703 * t663;
  t707 = t114 * t253 * t229;
  t708 = t111 * t707;
  t711 = t114 * t115 * t644;
  t712 = t111 * t711;
  t714 = t649 * t117;
  t716 = t347 * params->c;
  t718 = t114 * t716 * t102;
  t719 = t111 * t718;
  t721 = t635 + 0.3e1 * t636 + t675 + 0.3e1 * t676 + 0.2e4 / 0.81e2 * t680 - 0.1e3 / 0.27e2 * t683 + 0.2e4 / 0.81e2 * t686 + 0.5e1 / 0.9e1 * t690 + 0.2e4 / 0.81e2 * t694 + 0.5e1 / 0.9e1 * t696 + 0.5e1 / 0.3e1 * t698 + 0.5e1 / 0.3e1 * t700 - 0.1e5 / 0.729e3 * t704 - 0.5e2 / 0.27e2 * t708 - 0.5e2 / 0.81e2 * t712 - 0.1e3 / 0.27e2 * t714 - 0.5e2 / 0.27e2 * t719;
  tv3rho30 = rho[0] * t721 - 0.1e3 / 0.27e2 * t256 - 0.5e2 / 0.27e2 * t260 + 0.3e1 * t372 + 0.3e1 * t369 + 0.6e1 * t370 + 0.5e1 / 0.3e1 * t232 + 0.1e2 / 0.3e1 * t240 + 0.2e4 / 0.81e2 * t251 + 0.5e1 / 0.3e1 * t350 - 0.1e3 / 0.27e2 * t238;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t741 = t197 * t347;
  t742 = t2 * t226;
  t743 = t742 * t15;
  t744 = t743 * t90;
  t746 = t375 * t110;
  t747 = t746 * t175;
  t749 = t183 * t243;
  t750 = t749 * t361;
  t752 = t379 * t365;
  t755 = t14 * t659 * t661;
  t758 = t755 * t10 * t234 * t26;
  t760 = t99 * t102;
  t762 = t244 * t360 * t760;
  t764 = t10 * t229;
  t766 = t244 * t360 * t764;
  t770 = t111 * t114 * params->c * t226;
  t772 = 0.55e2 / 0.81e2 * t744 + 0.2e3 / 0.243e3 * t747 + 0.25e3 / 0.81e2 * t750 - 0.25e2 / 0.162e3 * t752 - 0.125e4 / 0.729e3 * t758 - 0.4e4 / 0.729e3 * t762 + 0.25e3 / 0.243e3 * t766 - 0.55e3 / 0.729e3 * t770;
  t773 = t772 * t85;
  t774 = t410 * t167;
  t776 = t376 * t169;
  t778 = t749 * t250;
  t780 = t184 * t349;
  t782 = t167 * t248;
  t784 = t385 * t782 * t387;
  t787 = t385 * t386 * t764;
  t789 = t743 * t87;
  t793 = t661 * t10 * t234 * t26;
  t794 = t703 * t793;
  t798 = t111 * t114 * t115 * t226;
  t802 = t111 * t114 * t253 * t99;
  t805 = t385 * t386 * t760;
  t809 = t111 * t114 * t716 * t10;
  t811 = t746 * t117;
  t813 = t379 * t255;
  t815 = t379 * t259;
  t817 = t741 + t773 + 0.2e1 * t774 + 0.1e2 / 0.27e2 * t776 - 0.25e3 / 0.81e2 * t778 - 0.5e1 / 0.72e2 * t780 - 0.5e3 / 0.243e3 * t784 - 0.25e3 / 0.243e3 * t787 - 0.55e2 / 0.81e2 * t789 + 0.125e4 / 0.729e3 * t794 + 0.55e3 / 0.729e3 * t798 - 0.1e3 / 0.243e3 * t802 + 0.4e4 / 0.729e3 * t805 + 0.25e2 / 0.324e3 * t809 - 0.2e3 / 0.243e3 * t811 + 0.25e2 / 0.81e2 * t813 + 0.25e2 / 0.162e3 * t815;
  tv3rho2sigma0 = 0.1e2 / 0.27e2 * t377 + 0.25e2 / 0.81e2 * t380 - 0.5e1 / 0.36e2 * t382 - 0.5e3 / 0.243e3 * t389 + 0.25e2 / 0.162e3 * t393 - 0.1e3 / 0.243e3 * t397 + 0.2e1 * t411 + 0.2e1 * t412 + rho[0] * t817;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t827 = t437 * t167;
  t829 = t214 * t347;
  t832 = t200 * t243;
  t842 = t6 * t229;
  t847 = -0.2e3 / 0.81e2 * t399 - 0.1e4 / 0.243e3 * t401 - 0.2e4 / 0.81e2 * t832 * t361 + 0.1e3 / 0.81e2 * t416 * t365 + 0.1e5 / 0.729e3 * t755 * t6 * t234 * t26 + 0.2e5 / 0.729e3 * t404 - 0.2e4 / 0.243e3 * t244 * t360 * t842 + 0.2e4 / 0.729e3 * t408;
  t848 = t847 * t85;
  t849 = t832 * t250;
  t851 = t201 * t349;
  t854 = t385 * t782 * t421;
  t857 = t385 * t386 * t842;
  t861 = t661 * t6 * t234 * t26;
  t862 = t703 * t861;
  t867 = t111 * t114 * t716 * t6;
  t869 = t416 * t255;
  t871 = t416 * t259;
  t878 = 0.2e1 * t827 + t829 + t848 + 0.2e4 / 0.81e2 * t849 + 0.5e1 / 0.9e1 * t851 + 0.4e4 / 0.243e3 * t854 + 0.2e4 / 0.243e3 * t857 - 0.1e5 / 0.729e3 * t862 - 0.2e4 / 0.729e3 * t397 - 0.5e2 / 0.81e2 * t867 - 0.2e3 / 0.81e2 * t869 - 0.1e3 / 0.81e2 * t871 + 0.1e4 / 0.243e3 * t380 + 0.5e3 / 0.243e3 * t393 - 0.5e2 / 0.27e2 * t382 + 0.2e3 / 0.81e2 * t377 - 0.2e5 / 0.729e3 * t389;
  tv3rho2tau0 = -0.5e2 / 0.27e2 * t185 - 0.2e3 / 0.81e2 * t417 + 0.1e2 / 0.9e1 * t419 + 0.4e4 / 0.243e3 * t423 - 0.1e3 / 0.81e2 * t427 + 0.5e3 / 0.243e3 * t189 + 0.2e1 * t438 + 0.2e1 * t439 + rho[0] * t878;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t880 = t224 * t8;
  t882 = 0.1e1 / t3 / t880;
  t883 = t2 * t882;
  t884 = t883 * t110;
  t885 = t884 * t237;
  t887 = t445 * t243;
  t888 = t248 * t102;
  t889 = t247 * t888;
  t890 = t887 * t889;
  t892 = t446 * t682;
  t894 = t661 * t444;
  t896 = t894 * t102 * t26;
  t897 = t703 * t896;
  t900 = t244 * t692 * t449;
  t902 = t248 * t882;
  t904 = t244 * t247 * t902;
  t907 = t883 * t107 * t357;
  t909 = t360 * t102;
  t910 = t887 * t909;
  t914 = t755 * t444 * t102 * t26;
  t917 = t244 * t360 * t882;
  t919 = -0.25e2 / 0.243e3 * t907 - 0.125e3 / 0.324e3 * t910 + 0.625e3 / 0.2916e4 * t914 + 0.5e3 / 0.729e3 * t917;
  t920 = t919 * t85;
  t921 = t459 * t167;
  tv3rhosigma20 = -t448 + t452 + t460 + rho[0] * (0.25e2 / 0.243e3 * t885 + 0.125e3 / 0.324e3 * t890 - 0.25e2 / 0.1296e4 * t892 - 0.625e3 / 0.2916e4 * t897 + 0.125e3 / 0.972e3 * t900 - 0.5e3 / 0.729e3 * t904 + t920 + t921);

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t925 = t464 * t243;
  t926 = t925 * t889;
  t928 = t465 * t682;
  t930 = t661 * t463;
  t932 = t930 * t102 * t26;
  t933 = t703 * t932;
  t936 = t244 * t692 * t468;
  t940 = t925 * t909;
  t944 = t755 * t463 * t102 * t26;
  t947 = 0.325e3 / 0.486e3 * t454 + 0.25e3 / 0.81e2 * t940 - 0.125e4 / 0.729e3 * t944 - 0.325e4 / 0.729e3 * t457;
  t948 = t947 * t85;
  t949 = t478 * t167;
  tv3rhosigmatau0 = t467 - t471 + t479 + rho[0] * (-0.325e3 / 0.486e3 * t447 - 0.25e3 / 0.81e2 * t926 + 0.25e2 / 0.162e3 * t928 + 0.125e4 / 0.729e3 * t933 - 0.25e3 / 0.243e3 * t936 + 0.325e4 / 0.729e3 * t451 + t948 + t949);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t953 = t483 * t243;
  t954 = t953 * t889;
  t956 = t484 * t682;
  t958 = t661 * t482;
  t960 = t958 * t102 * t26;
  t961 = t703 * t960;
  t964 = t244 * t692 * t487;
  t975 = -0.1e4 / 0.243e3 * t473 - 0.2e4 / 0.81e2 * t953 * t909 + 0.1e5 / 0.729e3 * t755 * t482 * t102 * t26 + 0.2e5 / 0.729e3 * t476;
  t976 = t975 * t85;
  t977 = t497 * t167;
  tv3rhotau20 = -t486 + t490 + t498 + rho[0] * (0.1e4 / 0.243e3 * t466 + 0.2e4 / 0.81e2 * t954 - 0.1e3 / 0.81e2 * t956 - 0.1e5 / 0.729e3 * t961 + 0.2e4 / 0.243e3 * t964 - 0.2e5 / 0.729e3 * t470 + t976 + t977);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t980 = t224 * t224;
  t981 = 0.1e1 / t980;
  t982 = t2 * t981;
  t983 = t982 * t243;
  t984 = t983 * t679;
  t985 = 0.125e3 / 0.2592e4 * t984;
  t987 = t661 * t981 * t26;
  t988 = t703 * t987;
  t989 = 0.625e3 / 0.23328e5 * t988;
  t990 = t982 * t654;
  t992 = t660 * t987;
  t994 = 0.125e3 / 0.2592e4 * t990 - 0.625e3 / 0.23328e5 * t992;
  t995 = t994 * t85;
  tv3sigma30 = rho[0] * (-t985 + t989 + t995);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t997 = t224 * t97;
  t998 = 0.1e1 / t997;
  t999 = t2 * t998;
  t1000 = t999 * t243;
  t1001 = t1000 * t679;
  t1002 = 0.125e3 / 0.324e3 * t1001;
  t1004 = t661 * t998 * t26;
  t1005 = t703 * t1004;
  t1006 = 0.625e3 / 0.2916e4 * t1005;
  t1007 = t999 * t654;
  t1009 = t660 * t1004;
  t1011 = -0.125e3 / 0.324e3 * t1007 + 0.625e3 / 0.2916e4 * t1009;
  t1012 = t1011 * t85;
  tv3sigma2tau0 = rho[0] * (t1002 - t1006 + t1012);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1014 = 0.1e1 / t880;
  t1015 = t2 * t1014;
  t1016 = t1015 * t243;
  t1017 = t1016 * t679;
  t1018 = 0.25e3 / 0.81e2 * t1017;
  t1020 = t661 * t1014 * t26;
  t1021 = t703 * t1020;
  t1022 = 0.125e4 / 0.729e3 * t1021;
  t1023 = t1015 * t654;
  t1025 = t660 * t1020;
  t1027 = 0.25e3 / 0.81e2 * t1023 - 0.125e4 / 0.729e3 * t1025;
  t1028 = t1027 * t85;
  tv3sigmatau20 = rho[0] * (-t1018 + t1022 + t1028);

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1030 = 0.1e1 / t442;
  t1031 = t2 * t1030;
  t1032 = t1031 * t243;
  t1034 = 0.2e4 / 0.81e2 * t1032 * t679;
  t1036 = t661 * t1030 * t26;
  t1038 = 0.1e5 / 0.729e3 * t703 * t1036;
  t1043 = -0.2e4 / 0.81e2 * t1031 * t654 + 0.1e5 / 0.729e3 * t660 * t1036;
  t1044 = t1043 * t85;
  tv3tau30 = rho[0] * (t1034 - t1038 + t1044);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1063 = t114 * t716;
  t1069 = t102 * t644;
  t1073 = t229 * t229;
  t1074 = t2 * t1073;
  t1079 = t14 * t659 * t167;
  t1084 = t243 / t657 / t29;
  t1086 = t14 * t1084 * t85;
  t1087 = t248 * t248;
  t1088 = t234 * t234;
  t1090 = t110 * t21;
  t1091 = t1087 * t1088 * t1090;
  t1095 = t2 * t1088 * t659;
  t1097 = t85 * t661 * t26;
  t1103 = t634 * params->c;
  t1108 = t645 * t110;
  t1122 = 0.1e1 / t4 / t880;
  t1125 = 0.616e4 / 0.81e2 * tau[0] * t641 - 0.2618e4 / 0.81e2 * sigma[0] * t1122;
  t1132 = t247 * t248 * t229;
  t1135 = -0.2e3 / 0.27e2 * t236 * t1063 + 0.8e4 / 0.81e2 * t385 * t782 * t666 + 0.8e4 / 0.243e3 * t385 * t386 * t1069 - 0.1e3 / 0.27e2 * t1074 * t110 * t237 - 0.4e5 / 0.729e3 * t1079 * t663 + 0.4e6 / 0.6561e4 * t1086 * t1091 - 0.4e5 / 0.729e3 * t1095 * t1097 - 0.4e3 / 0.27e2 * t103 * t110 * t707 - 0.2e3 / 0.81e2 * t111 * t114 * t1103 * t102 - 0.4e3 / 0.81e2 * t1108 * t117 - 0.1e3 / 0.27e2 * t111 * t114 * t716 * t229 - 0.2e3 / 0.81e2 * t111 * t114 * t253 * t644 - 0.5e2 / 0.81e2 * t111 * t114 * t115 * t1125 + 0.4e4 / 0.27e2 * t235 * t243 * t1132;
  t1166 = 0.1e1 / t42 * rho[0] * t444 * t268 / 0.48e2;
  t1168 = t518 * t1030;
  t1170 = t283 * t226;
  t1171 = t282 * t1170;
  t1173 = t131 * t463;
  t1174 = t130 * t1173;
  t1176 = t36 * t463;
  t1177 = t34 * t1176;
  t1179 = pow(t39, -0.25e1);
  t1182 = t1179 * t32 * t444 * t268;
  t1184 = t532 * t1030;
  t1186 = t293 * t1170;
  t1188 = t138 * t1173;
  t1191 = t49 * t35 * t226;
  t1198 = t339 * t339;
  t1200 = t323 * t323;
  t1202 = t342 * t342;
  t1207 = t70 * t268;
  t1209 = t334 * t343;
  t1215 = t161 * t163;
  t1220 = t305 * t305;
  t1223 = t276 * t276;
  t1224 = t308 * t308;
  t1229 = -0.34367190188705947437e1 * t135 * t306 * t301 * t309 * t144 + 0.4274e0 * t135 * t274 * t144 * t302 - 0.57895126195293126241e3 * t511 * t310 * t301 - 0.8e1 * t275 * t543 * t144 + 0.64327917994770140268e2 * t307 * t542 * t309 * t144 + 0.3103560775156404018e4 * t502 * t276 * t505 * t301 - 0.5848223622634646207e0 * t154 * t156 * (-0.28769444444444444444e1 * t1166 + 0.27618666666666666667e2 * t1168 - 0.10229135802469135803e2 * t1171 + 0.89504938271604938273e1 * t1174 + 0.31310740740740740741e1 * t1177 + 0.366775e-1 * t1182 - 0.58684e0 * t1184 + 0.65204444444444444445e0 * t1186 + 0.5705388888888888889e0 * t1188 + 0.13490888888888888889e1 * t1191) * t163 - 0.91082604192152556044e5 * t154 / t1198 * t1200 / t1202 + 0.19263893255070628431e1 * t1207 * t121 * t340 * t1209 * t161 - 0.1301229756036208781e0 * t1207 * t121 * t322 * t1215 * t334 + 0.24955700379505800916e5 * t41 / t1220 * t1223 / t1224;
  t1253 = t301 * t301;
  t1273 = t334 * t334;
  t1286 = 0.1e1 * t128 * (-0.21099166666666666667e1 * t1166 + 0.202552e2 * t1168 - 0.75019259259259259258e1 * t1171 + 0.6564185185185185185e1 * t1174 + 0.31003950617283950618e1 * t1177 + 0.68258333333333333335e-1 * t1182 - 0.10921333333333333333e1 * t1184 + 0.12134814814814814815e1 * t1186 + 0.10617962962962962963e1 * t1188 + 0.13388493827160493828e1 * t1191) * t145 - 0.62071215503128080361e4 * t41 / t305 / t273 * t1223 * t505 + 0.57895126195293126241e3 * t502 * t1223 * t309 + 0.48245938496077605201e2 * t307 * t1253 * t309 - 0.24e2 * t511 * t1223 * t145 + 0.36e2 * t307 * t277 * t301 - 0.11483599538271604938e-1 * t34 * t1176 * t58 - 0.6e1 * t275 * t1253 * t145 + 0.14035736694323150897e2 * t154 * t556 * t1200 * t163 + 0.35089341735807877242e1 * t154 * t322 * t1273 * t163 - 0.6233709278045326953e3 * t154 * t547 * t1200 * t343 - 0.51947577317044391277e2 * t154 * t340 * t1273 * t343;
  t1324 = 0.86748650402413918736e-1 * t317 * t264 * t325 + 0.38025319932552508021e2 * t317 * t122 * t552 - 0.38527786510141256862e1 * t317 * t122 * t558 + 0.21687162600603479684e-1 * t317 * t122 * t571 + 0.67471172535210825684e-1 * t317 * t528 * t164 + 0.1301229756036208781e0 * t317 * t122 * t602 - 0.43374325201206959368e-1 * t317 * t264 * t336 - 0.12842595503380418954e1 * t317 * t264 * t344 + 0.12304822629859687989e5 * t154 / t339 / t321 * t1200 * t551 - 0.4274e0 * t268 * t610 * t581 - 0.21053605041484726346e2 * t154 * t341 * t606;
  t1372 = 0.14246666666666666666e0 * t268 * t614 * t302 - 0.28493333333333333333e0 * t268 * t263 * t274 * t277 + 0.18989649058080861537e-2 * t149 * t131 * t463 * t81 + 0.22911460125803964958e1 * t268 * t263 * t306 * t310 - 0.3684616320282908548e2 * t268 * t121 * t501 * t506 + 0.68734380377411894876e1 * t268 * t121 * t510 * t512 - 0.71233333333333333332e-1 * t268 * t269 * t543 - 0.61524113149298439947e4 * t154 * t547 * t323 * t551 * t334 + 0.62337092780453269531e3 * t154 * t556 * t323 * t1209 + 0.46785788981077169656e1 * t154 * t322 * t569 * t1215 - 0.69263436422725855036e2 * t154 * t340 * t569 * t597 - 0.22161481481481481481e0 * t268 * t482 * t127 * t146;
  t1374 = t1229 + t1286 + t1324 + t1372;
  t1386 = t2 * t1125 * t15;
  t1389 = t246 * t347;
  t1402 = t692 * t248;
  t1405 = t661 * t234;
  t1423 = t661 * t15 * t23;
  t1426 = t14 * t1084;
  t1430 = t23 * t229;
  t1446 = 0.5e1 / 0.9e1 * t16 * t23 * t30 * t1374 + 0.2e4 / 0.81e2 * t244 * t247 * t248 * t1073 + 0.1e2 / 0.3e1 * t231 * t349 + 0.5e1 / 0.9e1 * t1386 * t87 + 0.4e4 / 0.81e2 * t244 * t1389 * t249 + 0.2e2 / 0.9e1 * t104 * t689 + 0.2e2 / 0.9e1 * t646 * t169 + 0.6e1 * t368 * t347 + 0.4e1 * t178 * t634 + t93 * t1374 + 0.8e4 / 0.81e2 * t678 * t1402 - 0.2e5 / 0.243e3 * t703 * t1405 * t229 * t26 + 0.4e1 * t674 * t167 + (-0.5e1 / 0.9e1 * t1386 * t90 + 0.4e3 / 0.81e2 * t1108 * t175 - 0.4e4 / 0.27e2 * t230 * t243 * t361 + 0.1e3 / 0.27e2 * t1074 * t107 * t357 + 0.4e5 / 0.729e3 * t1095 * t1423 - 0.4e6 / 0.6561e4 * t1426 * t1091 + 0.2e5 / 0.243e3 * t755 * t234 * t15 * t1430 - 0.2e4 / 0.81e2 * t244 * t360 * t1073 - 0.8e4 / 0.243e3 * t244 * t360 * t1069 + 0.5e2 / 0.81e2 * t111 * t114 * params->c * t1125) * t85;
  tv4rho40 = 0.4e1 * t635 + 0.12e2 * t636 + 0.4e1 * t675 + 0.12e2 * t676 + 0.8e4 / 0.81e2 * t680 - 0.4e3 / 0.27e2 * t683 + 0.8e4 / 0.81e2 * t686 + 0.2e2 / 0.9e1 * t690 + 0.8e4 / 0.81e2 * t694 + 0.2e2 / 0.9e1 * t696 + 0.2e2 / 0.3e1 * t698 + 0.2e2 / 0.3e1 * t700 - 0.4e5 / 0.729e3 * t704 - 0.2e3 / 0.27e2 * t708 - 0.2e3 / 0.81e2 * t712 - 0.4e3 / 0.27e2 * t714 - 0.2e3 / 0.27e2 * t719 + rho[0] * (t1135 + t1446);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1455 = t2 * t641 * t15;
  t1460 = t375 * t243;
  t1469 = t99 * t229;
  t1476 = t10 * t644;
  t1480 = t226 * t102;
  t1484 = t347 * t248;
  t1496 = t14 * t1084 * t1087;
  t1511 = t742 * t110;
  t1526 = t387 * t15 * t1430;
  t1536 = -0.2e4 / 0.81e2 * t1460 * t361 + 0.5e5 / 0.6561e4 * t1496 * t10 * t652 * t1090 + 0.25e3 / 0.27e2 * t749 * t667 - 0.2e4 / 0.243e3 * t244 * t360 * t1469 + 0.25e3 / 0.243e3 * t244 * t360 * t1476 - 0.77e3 / 0.243e3 * t1455 * t90 - 0.11e4 / 0.243e3 * t1511 * t175 + 0.1e3 / 0.81e2 * t746 * t365 - 0.25e2 / 0.162e3 * t379 * t671 + 0.22e5 / 0.729e3 * t244 * t360 * t1480 + 0.1e5 / 0.729e3 * t755 * t99 * t234 * t26 - 0.125e4 / 0.243e3 * t755 * t1526 + 0.77e4 / 0.2187e4 * t111 * t114 * params->c * t641 - 0.5e4 / 0.729e3 * t183 * t659 * t663;
  t1538 = 0.5e4 / 0.729e3 * t183 * t702 * t663 + 0.5e1 / 0.9e1 * t376 * t349 + 0.77e3 / 0.243e3 * t1455 * t87 - 0.55e2 / 0.27e2 * t743 * t169 + 0.2e4 / 0.81e2 * t1460 * t250 + 0.3e1 * t410 * t347 + t197 * t634 + 0.4e4 / 0.243e3 * t385 * t782 * t760 + 0.2e4 / 0.243e3 * t385 * t386 * t1469 - 0.25e3 / 0.81e2 * t385 * t782 * t764 - 0.25e3 / 0.243e3 * t385 * t386 * t1476 - 0.22e5 / 0.729e3 * t385 * t386 * t1480 - 0.25e3 / 0.81e2 * t385 * t1484 * t387 - 0.25e3 / 0.27e2 * t183 * t384 * t685 + 0.3e1 * t772 * t167 + t1536 * t85;
  t1541 = t244 * t658 * t85 * t661;
  t1588 = 0.125e4 / 0.243e3 * t1541 * t1526 - 0.1e5 / 0.729e3 * t703 * t661 * t99 * t234 * t26 - 0.5e5 / 0.6561e4 * t1086 * t1087 * t10 * t652 * t1090 + 0.125e4 / 0.243e3 * t1079 * t793 + 0.25e2 / 0.324e3 * t111 * t114 * t1103 * t10 + 0.25e2 / 0.54e2 * t379 * t718 + 0.11e4 / 0.243e3 * t1511 * t117 + 0.55e3 / 0.243e3 * t111 * t114 * t253 * t226 - 0.2e3 / 0.81e2 * t746 * t255 + 0.25e2 / 0.54e2 * t379 * t707 + 0.25e2 / 0.162e3 * t379 * t711 - 0.1e3 / 0.81e2 * t746 * t259 - 0.5e2 / 0.81e2 * t111 * t114 * t716 * t99 - 0.77e4 / 0.2187e4 * t111 * t114 * t115 * t641 - 0.25e3 / 0.27e2 * t749 * t693 - 0.5e1 / 0.72e2 * t184 * t689;
  tv4rho3sigma0 = rho[0] * (t1538 + t1588) + 0.3e1 * t741 + 0.3e1 * t773 + 0.6e1 * t774 + 0.1e2 / 0.9e1 * t776 - 0.25e3 / 0.27e2 * t778 - 0.5e1 / 0.24e2 * t780 - 0.5e3 / 0.81e2 * t784 - 0.25e3 / 0.81e2 * t787 - 0.55e2 / 0.27e2 * t789 + 0.125e4 / 0.243e3 * t794 + 0.55e3 / 0.243e3 * t798 - 0.1e3 / 0.81e2 * t802 + 0.4e4 / 0.243e3 * t805 + 0.25e2 / 0.108e3 * t809 - 0.2e3 / 0.81e2 * t811 + 0.25e2 / 0.27e2 * t813 + 0.25e2 / 0.54e2 * t815;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t1615 = t6 * t644;
  t1631 = t421 * t15 * t1430;
  t1636 = 0.1e3 / 0.81e2 * t416 * t671 - 0.4e6 / 0.6561e4 * t1496 * t6 * t652 * t1090 - 0.2e4 / 0.243e3 * t244 * t360 * t1615 - 0.2e4 / 0.27e2 * t832 * t667 + 0.4e5 / 0.729e3 * t200 * t659 * t663 + 0.1e5 / 0.81e2 * t750 + 0.22e4 / 0.243e3 * t744 + 0.1e5 / 0.243e3 * t766 - 0.8e5 / 0.729e3 * t762 + 0.4e4 / 0.243e3 * t747 - 0.5e3 / 0.81e2 * t752 + 0.1e5 / 0.243e3 * t755 * t1631 - 0.5e5 / 0.729e3 * t758 - 0.22e5 / 0.2187e4 * t770;
  t1664 = t214 * t634 + t1636 * t85 + 0.3e1 * t437 * t347 + 0.2e4 / 0.81e2 * t385 * t1484 * t421 + 0.2e4 / 0.81e2 * t385 * t782 * t842 + 0.2e4 / 0.243e3 * t385 * t386 * t1615 + 0.2e4 / 0.27e2 * t200 * t384 * t685 + 0.22e5 / 0.2187e4 * t798 - 0.2e4 / 0.243e3 * t802 + 0.25e3 / 0.81e2 * t809 - 0.4e4 / 0.243e3 * t811 + 0.1e4 / 0.81e2 * t813 + 0.5e3 / 0.81e2 * t815 - 0.4e5 / 0.729e3 * t200 * t702 * t663 + 0.3e1 * t847 * t167 - 0.2e5 / 0.243e3 * t784;
  t1695 = -0.1e5 / 0.243e3 * t787 + 0.8e5 / 0.729e3 * t805 + 0.2e3 / 0.27e2 * t776 - 0.1e5 / 0.81e2 * t778 - 0.25e2 / 0.9e1 * t780 - 0.22e4 / 0.243e3 * t789 - 0.1e5 / 0.243e3 * t1541 * t1631 - 0.1e5 / 0.243e3 * t1079 * t861 + 0.4e6 / 0.6561e4 * t1086 * t1087 * t6 * t652 * t1090 + 0.5e5 / 0.729e3 * t794 - 0.1e3 / 0.27e2 * t416 * t707 - 0.1e3 / 0.81e2 * t416 * t711 - 0.5e2 / 0.81e2 * t111 * t114 * t1103 * t6 - 0.1e3 / 0.27e2 * t416 * t718 + 0.2e4 / 0.27e2 * t832 * t693 + 0.5e1 / 0.9e1 * t201 * t689;
  tv4rho3tau0 = rho[0] * (t1664 + t1695) + 0.6e1 * t827 + 0.3e1 * t829 + 0.3e1 * t848 + 0.2e4 / 0.27e2 * t849 + 0.5e1 / 0.3e1 * t851 + 0.4e4 / 0.81e2 * t854 + 0.2e4 / 0.81e2 * t857 - 0.1e5 / 0.243e3 * t862 - 0.2e4 / 0.243e3 * t397 - 0.5e2 / 0.27e2 * t867 - 0.2e3 / 0.27e2 * t869 - 0.1e3 / 0.27e2 * t871 + 0.1e4 / 0.81e2 * t380 + 0.5e3 / 0.81e2 * t393 - 0.5e2 / 0.9e1 * t382 + 0.2e3 / 0.27e2 * t377 - 0.2e5 / 0.243e3 * t389;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t1724 = t1405 * t26;
  t1728 = 0.1e1 / t3 / t997;
  t1729 = t2 * t1728;
  t1748 = t883 * t243;
  t1754 = t360 * t229;
  t1781 = t692 * t888;
  t1802 = -0.625e3 / 0.729e3 * t445 * t702 * t1724 - 0.475e3 / 0.729e3 * t1729 * t110 * t237 - 0.1e4 / 0.729e3 * t244 * t692 * t902 + 0.95e4 / 0.2187e4 * t244 * t247 * t248 * t1728 + 0.5e2 / 0.243e3 * t884 * t682 - 0.25e2 / 0.1296e4 * t446 * t1063 + t459 * t347 + (0.475e3 / 0.729e3 * t1729 * t107 * t357 + 0.1e4 / 0.243e3 * t1748 * t909 + 0.625e3 / 0.729e3 * t445 * t659 * t1724 - 0.125e3 / 0.324e3 * t887 * t1754 - 0.625e4 / 0.6561e4 * t1496 * t444 * t234 * t1090 - 0.5e4 / 0.2187e4 * t755 * t882 * t102 * t26 + 0.625e3 / 0.2916e4 * t755 * t444 * t229 * t26 - 0.95e4 / 0.2187e4 * t244 * t360 * t1728) * t85 + 0.2e1 * t919 * t167 + 0.125e3 / 0.972e3 * t244 * t1389 * t449 - 0.1e4 / 0.243e3 * t1748 * t889 + 0.125e3 / 0.162e3 * t887 * t1781 + 0.125e3 / 0.324e3 * t887 * t1132 + 0.5e4 / 0.2187e4 * t703 * t661 * t882 * t102 * t26 - 0.625e3 / 0.1458e4 * t1079 * t896 - 0.625e3 / 0.2916e4 * t703 * t894 * t229 * t26 + 0.625e4 / 0.6561e4 * t1086 * t1087 * t444 * t234 * t1090;
  tv4rho2sigma20 = 0.5e2 / 0.243e3 * t885 + 0.125e3 / 0.162e3 * t890 - 0.25e2 / 0.648e3 * t892 - 0.625e3 / 0.1458e4 * t897 + 0.125e3 / 0.486e3 * t900 - 0.1e4 / 0.729e3 * t904 + 0.2e1 * t920 + 0.2e1 * t921 + rho[0] * t1802;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  t1863 = t478 * t347 + (-0.26e4 / 0.729e3 * t907 - 0.65e4 / 0.243e3 * t910 - 0.5e4 / 0.729e3 * t464 * t659 * t1724 + 0.25e3 / 0.81e2 * t925 * t1754 + 0.5e5 / 0.6561e4 * t1496 * t463 * t234 * t1090 + 0.325e5 / 0.2187e4 * t914 - 0.125e4 / 0.729e3 * t755 * t463 * t229 * t26 + 0.52e5 / 0.2187e4 * t917) * t85 + 0.2e1 * t947 * t167 - 0.25e3 / 0.243e3 * t244 * t1389 * t468 - 0.5e3 / 0.81e2 * t925 * t1781 - 0.25e3 / 0.81e2 * t925 * t1132 + 0.5e4 / 0.729e3 * t464 * t702 * t1724 + 0.26e4 / 0.729e3 * t885 + 0.25e2 / 0.162e3 * t465 * t1063 + 0.65e4 / 0.243e3 * t890 + 0.65e4 / 0.729e3 * t900 - 0.325e3 / 0.243e3 * t892 - 0.52e5 / 0.2187e4 * t904 + 0.25e4 / 0.729e3 * t1079 * t932 + 0.125e4 / 0.729e3 * t703 * t930 * t229 * t26 - 0.5e5 / 0.6561e4 * t1086 * t1087 * t463 * t234 * t1090 - 0.325e5 / 0.2187e4 * t897;
  tv4rho2sigmatau0 = -0.325e3 / 0.243e3 * t447 - 0.5e3 / 0.81e2 * t926 + 0.25e2 / 0.81e2 * t928 + 0.25e4 / 0.729e3 * t933 - 0.5e3 / 0.243e3 * t936 + 0.65e4 / 0.729e3 * t451 + 0.2e1 * t948 + 0.2e1 * t949 + rho[0] * t1863;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t1924 = t497 * t347 + (0.13e5 / 0.729e3 * t454 + 0.4e5 / 0.243e3 * t940 + 0.4e5 / 0.729e3 * t483 * t659 * t1724 - 0.2e4 / 0.81e2 * t953 * t1754 - 0.4e6 / 0.6561e4 * t1496 * t482 * t234 * t1090 - 0.2e6 / 0.2187e4 * t944 + 0.1e5 / 0.729e3 * t755 * t482 * t229 * t26 - 0.26e6 / 0.2187e4 * t457) * t85 + 0.2e1 * t975 * t167 - 0.1e3 / 0.81e2 * t484 * t1063 + 0.2e4 / 0.243e3 * t928 - 0.4e5 / 0.729e3 * t483 * t702 * t1724 - 0.4e5 / 0.729e3 * t936 - 0.4e5 / 0.243e3 * t926 + 0.2e6 / 0.2187e4 * t933 - 0.1e5 / 0.729e3 * t703 * t958 * t229 * t26 + 0.4e6 / 0.6561e4 * t1086 * t1087 * t482 * t234 * t1090 + 0.2e4 / 0.243e3 * t244 * t1389 * t487 + 0.4e4 / 0.81e2 * t953 * t1781 + 0.2e4 / 0.81e2 * t953 * t1132 + 0.26e6 / 0.2187e4 * t451 - 0.2e5 / 0.729e3 * t1079 * t960 - 0.13e5 / 0.729e3 * t447;
  tv4rho2tau20 = 0.2e4 / 0.243e3 * t466 + 0.4e4 / 0.81e2 * t954 - 0.2e3 / 0.81e2 * t956 - 0.2e5 / 0.729e3 * t961 + 0.4e4 / 0.243e3 * t964 - 0.4e5 / 0.729e3 * t470 + 0.2e1 * t976 + 0.2e1 * t977 + rho[0] * t1924;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t1926 = t980 * rho[0];
  t1927 = 0.1e1 / t1926;
  t1928 = t2 * t1927;
  t1934 = t661 * t102 * t26;
  t1941 = t355 * t102;
  t1948 = t661 * t1927 * t26;
  tv4rhosigma30 = -t985 + t989 + t995 + rho[0] * (0.125e3 / 0.324e3 * t1928 * t243 * t679 + 0.625e3 / 0.5832e4 * t982 * t702 * t1934 - 0.125e3 / 0.2592e4 * t983 * t1402 - 0.3125e4 / 0.26244e5 * t1086 * t1087 * t981 * t107 * t1941 + 0.625e3 / 0.23328e5 * t1079 * t987 - 0.625e3 / 0.2916e4 * t703 * t1948 + (-0.125e3 / 0.324e3 * t1928 * t654 - 0.625e3 / 0.5832e4 * t982 * t659 * t1934 + 0.3125e4 / 0.26244e5 * t1496 * t981 * t107 * t1941 + 0.625e3 / 0.2916e4 * t660 * t1948) * t85 + t994 * t167);

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = t1002 - t1006 + t1012 + rho[0] * (-0.875e3 / 0.324e3 * t984 - 0.625e3 / 0.729e3 * t999 * t702 * t1934 + 0.125e3 / 0.324e3 * t1000 * t1402 + 0.625e4 / 0.6561e4 * t1086 * t1087 * t998 * t107 * t1941 - 0.625e3 / 0.2916e4 * t1079 * t1004 + 0.4375e4 / 0.2916e4 * t988 + (0.875e3 / 0.324e3 * t990 + 0.625e3 / 0.729e3 * t999 * t659 * t1934 - 0.625e4 / 0.6561e4 * t1496 * t998 * t107 * t1941 - 0.4375e4 / 0.2916e4 * t992) * t85 + t1011 * t167);

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = -t1018 + t1022 + t1028 + rho[0] * (0.5e3 / 0.27e2 * t1001 + 0.5e4 / 0.729e3 * t1015 * t702 * t1934 - 0.25e3 / 0.81e2 * t1016 * t1402 - 0.5e5 / 0.6561e4 * t1086 * t1087 * t1014 * t107 * t1941 + 0.125e4 / 0.729e3 * t1079 * t1020 - 0.25e4 / 0.243e3 * t1005 + (-0.5e3 / 0.27e2 * t1007 - 0.5e4 / 0.729e3 * t1015 * t659 * t1934 + 0.5e5 / 0.6561e4 * t1496 * t1014 * t107 * t1941 + 0.25e4 / 0.243e3 * t1009) * t85 + t1027 * t167);

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rhotau30 = t1034 - t1038 + t1044 + rho[0] * (-0.1e5 / 0.81e2 * t1017 - 0.4e5 / 0.729e3 * t1031 * t702 * t1934 + 0.2e4 / 0.81e2 * t1032 * t1402 + 0.4e6 / 0.6561e4 * t1086 * t1087 * t1030 * t107 * t1941 - 0.1e5 / 0.729e3 * t1079 * t1036 + 0.5e5 / 0.729e3 * t1021 + (0.1e5 / 0.81e2 * t1023 + 0.4e5 / 0.729e3 * t1031 * t659 * t1934 - 0.4e6 / 0.6561e4 * t1496 * t1030 * t107 * t1941 - 0.5e5 / 0.729e3 * t1025) * t85 + t1043 * t167);

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t2053 = 0.1e1 / t4 / t980 / t8;
  t2055 = t2 * t2053 * t659;
  t2059 = t1087 * t2053 * t1090;
  tv4sigma40 = rho[0] * (-0.625e3 / 0.46656e5 * t2055 * t1097 + 0.3125e4 / 0.209952e6 * t1086 * t2059 + (0.625e3 / 0.46656e5 * t2055 * t1423 - 0.3125e4 / 0.209952e6 * t1426 * t2059) * t85);

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  t2070 = 0.1e1 / t4 / t1926;
  t2072 = t2 * t2070 * t659;
  t2076 = t1087 * t2070 * t1090;
  tv4sigma3tau0 = rho[0] * (0.625e3 / 0.5832e4 * t2072 * t1097 - 0.3125e4 / 0.26244e5 * t1086 * t2076 + (-0.625e3 / 0.5832e4 * t2072 * t1423 + 0.3125e4 / 0.26244e5 * t1426 * t2076) * t85);

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  t2087 = 0.1e1 / t4 / t980;
  t2089 = t2 * t2087 * t659;
  t2093 = t1087 * t2087 * t1090;
  tv4sigma2tau20 = rho[0] * (-0.625e3 / 0.729e3 * t2089 * t1097 + 0.625e4 / 0.6561e4 * t1086 * t2093 + (0.625e3 / 0.729e3 * t2089 * t1423 - 0.625e4 / 0.6561e4 * t1426 * t2093) * t85);

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  t2104 = 0.1e1 / t4 / t997;
  t2106 = t2 * t2104 * t659;
  t2110 = t1087 * t2104 * t1090;
  tv4sigmatau30 = rho[0] * (0.5e4 / 0.729e3 * t2106 * t1097 - 0.5e5 / 0.6561e4 * t1086 * t2110 + (-0.5e4 / 0.729e3 * t2106 * t1423 + 0.5e5 / 0.6561e4 * t1426 * t2110) * t85);

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t2121 = t2 * t1122 * t659;
  t2125 = t1087 * t1122 * t1090;
  tv4tau40 = rho[0] * (-0.4e5 / 0.729e3 * t2121 * t1097 + 0.4e6 / 0.6561e4 * t1086 * t2125 + (0.4e5 / 0.729e3 * t2121 * t1423 - 0.4e6 / 0.6561e4 * t1426 * t2125) * t85);

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t26, t27;
  double t28, t30, t31, t32, t33, t35, t38, t39;
  double t40, t41, t42, t43, t44, t45, t46, t47;
  double t48, t50, t53, t54, t55, t56, t58, t59;
  double t60, t61, t62, t63, t66, t67, t68, t69;
  double t70, t71, t72, t75, t77, t78, t81, t83;
  double t84, t85, t88, t90, t93, t94, t96, t97;
  double t98, t99, t100, t101, t102, t103, t105, t106;
  double t107, t109, t110, t113, t114, t116, t121, t124;
  double t125, t129, t134, t137, t138, t139, t141, t142;
  double t146, t147, t148, t150, t151, t152, t153, t154;
  double t156, t157, tzk0;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t7 = tau[0] * t6;
  t8 = rho[0] - rho[1];
  t9 = rho[0] + rho[1];
  t10 = 0.1e1 / t9;
  t11 = t8 * t10;
  t12 = 0.1e1 + t11;
  t13 = t12 / 0.2e1;
  t14 = POW_1_3(t13);
  t15 = t14 * t14;
  t16 = t15 * t13;
  t17 = t7 * t16;
  t18 = POW_1_3(rho[1]);
  t19 = t18 * t18;
  t21 = 0.1e1 / t19 / rho[1];
  t22 = tau[1] * t21;
  t23 = 0.1e1 - t11;
  t24 = t23 / 0.2e1;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = t26 * t24;
  t28 = t22 * t27;
  t30 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t31 = t9 * t9;
  t32 = POW_1_3(t9);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / t31;
  t38 = t17 + t28 - t30 * t35 / 0.8e1;
  t39 = t2 * t38;
  t40 = M_CBRT6;
  t41 = M_PI * M_PI;
  t42 = POW_1_3(t41);
  t43 = t42 * t42;
  t44 = 0.1e1 / t43;
  t45 = t40 * t44;
  t46 = t39 * t45;
  t47 = M_CBRT2;
  t48 = t47 * t47;
  t50 = t45 * t48;
  t53 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t38 * t50;
  t54 = 0.1e1 / t53;
  t55 = t48 * t54;
  t56 = t31 * t31;
  t58 = 0.1e1 / t33 / t56;
  t59 = t30 * t58;
  t60 = t17 + t28;
  t61 = 0.1e1 / t60;
  t62 = t8 * t8;
  t63 = t61 * t62;
  t66 = 0.1e1 - t59 * t63 / 0.8e1;
  t67 = M_CBRT3;
  t68 = 0.1e1 / M_PI;
  t69 = POW_1_3(t68);
  t70 = t67 * t69;
  t71 = M_CBRT4;
  t72 = t71 * t71;
  t75 = t70 * t72 / t32;
  t77 = 0.1e1 + 0.53425e-1 * t75;
  t78 = sqrt(t75);
  t81 = POW_3_2(t75);
  t83 = t67 * t67;
  t84 = t69 * t69;
  t85 = t83 * t84;
  t88 = t85 * t71 / t33;
  t90 = 0.379785e1 * t78 + 0.8969e0 * t75 + 0.204775e0 * t81 + 0.123235e0 * t88;
  t93 = 0.1e1 + 0.16081979498692535067e2 / t90;
  t94 = log(t93);
  t96 = 0.621814e-1 * t77 * t94;
  t97 = t62 * t62;
  t98 = 0.1e1 / t56;
  t99 = t97 * t98;
  t100 = t12 <= p->zeta_threshold;
  t101 = POW_1_3(p->zeta_threshold);
  t102 = t101 * p->zeta_threshold;
  t103 = POW_1_3(t12);
  t105 = my_piecewise3(t100, t102, t103 * t12);
  t106 = t23 <= p->zeta_threshold;
  t107 = POW_1_3(t23);
  t109 = my_piecewise3(t106, t102, t107 * t23);
  t110 = t105 + t109 - 0.2e1;
  t113 = 0.1e1 / (0.2e1 * t47 - 0.2e1);
  t114 = t110 * t113;
  t116 = 0.1e1 + 0.5137e-1 * t75;
  t121 = 0.705945e1 * t78 + 0.1549425e1 * t75 + 0.420775e0 * t81 + 0.1562925e0 * t88;
  t124 = 0.1e1 + 0.32163958997385070134e2 / t121;
  t125 = log(t124);
  t129 = 0.1e1 + 0.278125e-1 * t75;
  t134 = 0.51785e1 * t78 + 0.905775e0 * t75 + 0.1100325e0 * t81 + 0.1241775e0 * t88;
  t137 = 0.1e1 + 0.29608749977793437516e2 / t134;
  t138 = log(t137);
  t139 = t129 * t138;
  t141 = -0.310907e-1 * t116 * t125 + t96 - 0.19751673498613801407e-1 * t139;
  t142 = t114 * t141;
  t146 = -t96 + t99 * t142 + 0.19751673498613801407e-1 * t114 * t139;
  t147 = t66 * t146;
  t148 = t55 * t147;
  t150 = 0.5e1 / 0.9e1 * t46 * t148;
  t151 = t39 * t40;
  t152 = t44 * t48;
  t153 = t152 * t54;
  t154 = t151 * t153;
  t156 = 0.1e1 - 0.5e1 / 0.9e1 * t154;
  t157 = t156 * t146;
  tzk0 = t150 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t26, t27;
  double t28, t30, t31, t32, t33, t35, t38, t39;
  double t40, t41, t42, t43, t44, t45, t46, t47;
  double t48, t50, t53, t54, t55, t56, t58, t59;
  double t60, t61, t62, t63, t66, t67, t68, t69;
  double t70, t71, t72, t75, t77, t78, t81, t83;
  double t84, t85, t88, t90, t93, t94, t96, t97;
  double t98, t99, t100, t101, t102, t103, t105, t106;
  double t107, t109, t110, t113, t114, t116, t121, t124;
  double t125, t129, t134, t137, t138, t139, t141, t142;
  double t146, t147, t148, t150, t151, t152, t153, t154;
  double t156, t157, tzk0;

  double t158, t160, t161, t162, t164, t165, t166, t167;
  double t168, t169, t171, t172, t173, t175, t177, t179;
  double t180, t181, t182, t183, t184, t185, t187, t188;
  double t189, t190, t191, t192, t193, t194, t195, t196;
  double t197, t198, t199, t201, t202, t204, t205, t206;
  double t207, t209, t210, t213, t215, t216, t217, t218;
  double t219, t220, t222, t223, t226, t227, t228, t229;
  double t231, t232, t233, t234, t236, t238, t239, t240;
  double t245, t247, t248, t249, t251, t252, t253, t255;
  double t256, t257, t259, t262, t263, t266, t268, t269;
  double t274, t275, t276, t281, t282, t283, t289, t290;
  double t291, t296, t297, t298, t301, t302, t303, t306;
  double t308, t310, t311, t313, t315, t316, t317, t318;
  double t319, t320, t321, t322, t324, t325, t326, t327;
  double t330, t331, t332, tvrho0, t335, t336, t337, t338;
  double t340, t342, t343, t344, t346, t347, t348, t350;
  double t351, t352, t353, t354, t355, t356, t357, t358;
  double t360, t361, t364, t365, t366, t367, t368, t371;
  double t372, t375, t377, t378, t382, t383, t384, t385;
  double t386, t387, t388, t390, t391, t394, t395, t396;
  double tvrho1, t399, t400, t401, t402, t403, t405, t406;
  double t407, t408, t409, t410, t411, t412, t414, t416;
  double t418, t420, t421, tvsigma0, t423, t424, t425, t428;
  double t429, tvsigma1, tvsigma2, tvlapl0, tvlapl1, t431, t432, t433;
  double t434, t435, t436, t438, t439, t440, t441, t442;
  double t444, t445, t446, t447, t448, t449, t451, t452;
  double t453, t456, t459, t460, tvtau0, t462, t463, t464;
  double t466, t467, t468, t471, t472, t473, t474, t475;
  double t477, t478, t479, t484, t485, tvtau1;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t7 = tau[0] * t6;
  t8 = rho[0] - rho[1];
  t9 = rho[0] + rho[1];
  t10 = 0.1e1 / t9;
  t11 = t8 * t10;
  t12 = 0.1e1 + t11;
  t13 = t12 / 0.2e1;
  t14 = POW_1_3(t13);
  t15 = t14 * t14;
  t16 = t15 * t13;
  t17 = t7 * t16;
  t18 = POW_1_3(rho[1]);
  t19 = t18 * t18;
  t21 = 0.1e1 / t19 / rho[1];
  t22 = tau[1] * t21;
  t23 = 0.1e1 - t11;
  t24 = t23 / 0.2e1;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = t26 * t24;
  t28 = t22 * t27;
  t30 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t31 = t9 * t9;
  t32 = POW_1_3(t9);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / t31;
  t38 = t17 + t28 - t30 * t35 / 0.8e1;
  t39 = t2 * t38;
  t40 = M_CBRT6;
  t41 = M_PI * M_PI;
  t42 = POW_1_3(t41);
  t43 = t42 * t42;
  t44 = 0.1e1 / t43;
  t45 = t40 * t44;
  t46 = t39 * t45;
  t47 = M_CBRT2;
  t48 = t47 * t47;
  t50 = t45 * t48;
  t53 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t38 * t50;
  t54 = 0.1e1 / t53;
  t55 = t48 * t54;
  t56 = t31 * t31;
  t58 = 0.1e1 / t33 / t56;
  t59 = t30 * t58;
  t60 = t17 + t28;
  t61 = 0.1e1 / t60;
  t62 = t8 * t8;
  t63 = t61 * t62;
  t66 = 0.1e1 - t59 * t63 / 0.8e1;
  t67 = M_CBRT3;
  t68 = 0.1e1 / M_PI;
  t69 = POW_1_3(t68);
  t70 = t67 * t69;
  t71 = M_CBRT4;
  t72 = t71 * t71;
  t75 = t70 * t72 / t32;
  t77 = 0.1e1 + 0.53425e-1 * t75;
  t78 = sqrt(t75);
  t81 = POW_3_2(t75);
  t83 = t67 * t67;
  t84 = t69 * t69;
  t85 = t83 * t84;
  t88 = t85 * t71 / t33;
  t90 = 0.379785e1 * t78 + 0.8969e0 * t75 + 0.204775e0 * t81 + 0.123235e0 * t88;
  t93 = 0.1e1 + 0.16081979498692535067e2 / t90;
  t94 = log(t93);
  t96 = 0.621814e-1 * t77 * t94;
  t97 = t62 * t62;
  t98 = 0.1e1 / t56;
  t99 = t97 * t98;
  t100 = t12 <= p->zeta_threshold;
  t101 = POW_1_3(p->zeta_threshold);
  t102 = t101 * p->zeta_threshold;
  t103 = POW_1_3(t12);
  t105 = my_piecewise3(t100, t102, t103 * t12);
  t106 = t23 <= p->zeta_threshold;
  t107 = POW_1_3(t23);
  t109 = my_piecewise3(t106, t102, t107 * t23);
  t110 = t105 + t109 - 0.2e1;
  t113 = 0.1e1 / (0.2e1 * t47 - 0.2e1);
  t114 = t110 * t113;
  t116 = 0.1e1 + 0.5137e-1 * t75;
  t121 = 0.705945e1 * t78 + 0.1549425e1 * t75 + 0.420775e0 * t81 + 0.1562925e0 * t88;
  t124 = 0.1e1 + 0.32163958997385070134e2 / t121;
  t125 = log(t124);
  t129 = 0.1e1 + 0.278125e-1 * t75;
  t134 = 0.51785e1 * t78 + 0.905775e0 * t75 + 0.1100325e0 * t81 + 0.1241775e0 * t88;
  t137 = 0.1e1 + 0.29608749977793437516e2 / t134;
  t138 = log(t137);
  t139 = t129 * t138;
  t141 = -0.310907e-1 * t116 * t125 + t96 - 0.19751673498613801407e-1 * t139;
  t142 = t114 * t141;
  t146 = -t96 + t99 * t142 + 0.19751673498613801407e-1 * t114 * t139;
  t147 = t66 * t146;
  t148 = t55 * t147;
  t150 = 0.5e1 / 0.9e1 * t46 * t148;
  t151 = t39 * t40;
  t152 = t44 * t48;
  t153 = t152 * t54;
  t154 = t151 * t153;
  t156 = 0.1e1 - 0.5e1 / 0.9e1 * t154;
  t157 = t156 * t146;
  tzk0 = t150 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = rho[0] * rho[0];
  t160 = 0.1e1 / t4 / t158;
  t161 = tau[0] * t160;
  t162 = t161 * t16;
  t164 = 0.1e1 / t31;
  t165 = t8 * t164;
  t166 = t10 - t165;
  t167 = t166 / 0.2e1;
  t168 = t15 * t167;
  t169 = t7 * t168;
  t171 = -t167;
  t172 = t26 * t171;
  t173 = t22 * t172;
  t175 = t31 * t9;
  t177 = 0.1e1 / t33 / t175;
  t179 = t30 * t177 / 0.3e1;
  t180 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173 + t179;
  t181 = t2 * t180;
  t182 = t181 * t45;
  t183 = t182 * t148;
  t184 = 0.5e1 / 0.9e1 * t183;
  t185 = t40 * t40;
  t187 = 0.1e1 / t42 / t41;
  t188 = t185 * t187;
  t189 = t188 * t47;
  t190 = t39 * t189;
  t191 = t53 * t53;
  t192 = 0.1e1 / t191;
  t193 = t192 * t66;
  t194 = t146 * params->c;
  t195 = t194 * t180;
  t196 = t193 * t195;
  t197 = t190 * t196;
  t198 = 0.5e2 / 0.81e2 * t197;
  t199 = t56 * t9;
  t201 = 0.1e1 / t33 / t199;
  t202 = t30 * t201;
  t204 = 0.7e1 / 0.12e2 * t202 * t63;
  t205 = t60 * t60;
  t206 = 0.1e1 / t205;
  t207 = t206 * t62;
  t209 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173;
  t210 = t207 * t209;
  t213 = t61 * t8;
  t215 = t59 * t213 / 0.4e1;
  t216 = t204 + t59 * t210 / 0.8e1 - t215;
  t217 = t216 * t146;
  t218 = t55 * t217;
  t219 = t46 * t218;
  t220 = 0.5e1 / 0.9e1 * t219;
  t222 = 0.1e1 / t32 / t9;
  t223 = t72 * t222;
  t226 = 0.11073470983333333333e-2 * t70 * t223 * t94;
  t227 = t90 * t90;
  t228 = 0.1e1 / t227;
  t229 = t77 * t228;
  t231 = 0.1e1 / t78 * t67;
  t232 = t69 * t72;
  t233 = t232 * t222;
  t234 = t231 * t233;
  t236 = t70 * t223;
  t238 = sqrt(t75);
  t239 = t238 * t67;
  t240 = t239 * t233;
  t245 = t85 * t71 / t33 / t9;
  t247 = -0.632975e0 * t234 - 0.29896666666666666667e0 * t236 - 0.1023875e0 * t240 - 0.82156666666666666667e-1 * t245;
  t248 = 0.1e1 / t93;
  t249 = t247 * t248;
  t251 = 0.1e1 * t229 * t249;
  t252 = t62 * t8;
  t253 = t252 * t98;
  t255 = 0.4e1 * t253 * t142;
  t256 = 0.1e1 / t199;
  t257 = t97 * t256;
  t259 = 0.4e1 * t257 * t142;
  t262 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t166);
  t263 = -t166;
  t266 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t263);
  t268 = (t262 + t266) * t113;
  t269 = t268 * t141;
  t274 = t121 * t121;
  t275 = 0.1e1 / t274;
  t276 = t116 * t275;
  t281 = -0.1176575e1 * t234 - 0.516475e0 * t236 - 0.2103875e0 * t240 - 0.104195e0 * t245;
  t282 = 0.1e1 / t124;
  t283 = t281 * t282;
  t289 = t134 * t134;
  t290 = 0.1e1 / t289;
  t291 = t129 * t290;
  t296 = -0.86308333333333333334e0 * t234 - 0.301925e0 * t236 - 0.5501625e-1 * t240 - 0.82785e-1 * t245;
  t297 = 0.1e1 / t137;
  t298 = t296 * t297;
  t301 = 0.53237641966666666666e-3 * t70 * t223 * t125 + 0.1e1 * t276 * t283 - t226 - t251 + 0.18311447306006545054e-3 * t70 * t223 * t138 + 0.5848223622634646207e0 * t291 * t298;
  t302 = t114 * t301;
  t303 = t99 * t302;
  t306 = t114 * t67;
  t308 = t232 * t222 * t138;
  t310 = 0.18311447306006545054e-3 * t306 * t308;
  t311 = t114 * t129;
  t313 = t290 * t296 * t297;
  t315 = 0.5848223622634646207e0 * t311 * t313;
  t316 = t226 + t251 + t255 - t259 + t99 * t269 + t303 + 0.19751673498613801407e-1 * t268 * t139 - t310 - t315;
  t317 = t66 * t316;
  t318 = t55 * t317;
  t319 = t46 * t318;
  t320 = 0.5e1 / 0.9e1 * t319;
  t321 = t181 * t40;
  t322 = t321 * t153;
  t324 = t39 * t188;
  t325 = t47 * t192;
  t326 = params->c * t180;
  t327 = t325 * t326;
  t330 = -0.5e1 / 0.9e1 * t322 + 0.5e2 / 0.81e2 * t324 * t327;
  t331 = t330 * t146;
  t332 = t156 * t316;
  tvrho0 = t150 + t157 + t9 * (t184 - t198 + t220 + t320 + t331 + t332);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t335 = -t10 - t165;
  t336 = t335 / 0.2e1;
  t337 = t15 * t336;
  t338 = t7 * t337;
  t340 = rho[1] * rho[1];
  t342 = 0.1e1 / t19 / t340;
  t343 = tau[1] * t342;
  t344 = t343 * t27;
  t346 = -t336;
  t347 = t26 * t346;
  t348 = t22 * t347;
  t350 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348 + t179;
  t351 = t2 * t350;
  t352 = t351 * t45;
  t353 = t352 * t148;
  t354 = 0.5e1 / 0.9e1 * t353;
  t355 = t194 * t350;
  t356 = t193 * t355;
  t357 = t190 * t356;
  t358 = 0.5e2 / 0.81e2 * t357;
  t360 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348;
  t361 = t207 * t360;
  t364 = t204 + t59 * t361 / 0.8e1 + t215;
  t365 = t364 * t146;
  t366 = t55 * t365;
  t367 = t46 * t366;
  t368 = 0.5e1 / 0.9e1 * t367;
  t371 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t335);
  t372 = -t335;
  t375 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t372);
  t377 = (t371 + t375) * t113;
  t378 = t377 * t141;
  t382 = t226 + t251 - t255 - t259 + t99 * t378 + t303 + 0.19751673498613801407e-1 * t377 * t139 - t310 - t315;
  t383 = t66 * t382;
  t384 = t55 * t383;
  t385 = t46 * t384;
  t386 = 0.5e1 / 0.9e1 * t385;
  t387 = t351 * t40;
  t388 = t387 * t153;
  t390 = params->c * t350;
  t391 = t325 * t390;
  t394 = -0.5e1 / 0.9e1 * t388 + 0.5e2 / 0.81e2 * t324 * t391;
  t395 = t394 * t146;
  t396 = t156 * t382;
  tvrho1 = t150 + t157 + t9 * (t354 - t358 + t368 + t386 + t395 + t396);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t399 = t2 * t35;
  t400 = t399 * t45;
  t401 = t400 * t148;
  t402 = 0.5e1 / 0.72e2 * t401;
  t403 = t194 * t35;
  t405 = t190 * t193 * t403;
  t406 = 0.25e2 / 0.324e3 * t405;
  t407 = t39 * t50;
  t408 = t54 * t58;
  t409 = t63 * t146;
  t410 = t408 * t409;
  t411 = t407 * t410;
  t412 = 0.5e1 / 0.72e2 * t411;
  t414 = t399 * t40 * t153;
  t416 = params->c * t35;
  t418 = t324 * t325 * t416;
  t420 = 0.5e1 / 0.72e2 * t414 - 0.25e2 / 0.324e3 * t418;
  t421 = t420 * t146;
  tvsigma0 = t9 * (-t402 + t406 - t412 + t421);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t423 = 0.5e1 / 0.36e2 * t401;
  t424 = 0.25e2 / 0.162e3 * t405;
  t425 = 0.5e1 / 0.36e2 * t411;
  t428 = 0.5e1 / 0.36e2 * t414 - 0.25e2 / 0.162e3 * t418;
  t429 = t428 * t146;
  tvsigma1 = t9 * (-t423 + t424 - t425 + t429);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t431 = t2 * t6;
  t432 = t16 * t40;
  t433 = t431 * t432;
  t434 = t54 * t66;
  t435 = t434 * t146;
  t436 = t152 * t435;
  t438 = 0.5e1 / 0.9e1 * t433 * t436;
  t439 = t193 * t146;
  t440 = params->c * t6;
  t441 = t440 * t16;
  t442 = t439 * t441;
  t444 = 0.5e2 / 0.81e2 * t190 * t442;
  t445 = t59 * t206;
  t446 = t62 * t6;
  t447 = t16 * t146;
  t448 = t446 * t447;
  t449 = t445 * t448;
  t451 = 0.5e1 / 0.72e2 * t154 * t449;
  t452 = t431 * t16;
  t453 = t45 * t55;
  t456 = t325 * t441;
  t459 = -0.5e1 / 0.9e1 * t452 * t453 + 0.5e2 / 0.81e2 * t324 * t456;
  t460 = t459 * t146;
  tvtau0 = t9 * (t438 - t444 + t451 + t460);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t462 = t2 * t21;
  t463 = t27 * t40;
  t464 = t462 * t463;
  t466 = 0.5e1 / 0.9e1 * t464 * t436;
  t467 = params->c * t21;
  t468 = t467 * t27;
  t471 = 0.5e2 / 0.81e2 * t190 * t439 * t468;
  t472 = t62 * t21;
  t473 = t27 * t146;
  t474 = t472 * t473;
  t475 = t445 * t474;
  t477 = 0.5e1 / 0.72e2 * t154 * t475;
  t478 = t462 * t27;
  t479 = t478 * t453;
  t484 = -0.5e1 / 0.9e1 * t479 + 0.5e2 / 0.81e2 * t324 * t325 * t468;
  t485 = t484 * t146;
  tvtau1 = t9 * (t466 - t471 + t477 + t485);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t26, t27;
  double t28, t30, t31, t32, t33, t35, t38, t39;
  double t40, t41, t42, t43, t44, t45, t46, t47;
  double t48, t50, t53, t54, t55, t56, t58, t59;
  double t60, t61, t62, t63, t66, t67, t68, t69;
  double t70, t71, t72, t75, t77, t78, t81, t83;
  double t84, t85, t88, t90, t93, t94, t96, t97;
  double t98, t99, t100, t101, t102, t103, t105, t106;
  double t107, t109, t110, t113, t114, t116, t121, t124;
  double t125, t129, t134, t137, t138, t139, t141, t142;
  double t146, t147, t148, t150, t151, t152, t153, t154;
  double t156, t157, tzk0;

  double t158, t160, t161, t162, t164, t165, t166, t167;
  double t168, t169, t171, t172, t173, t175, t177, t179;
  double t180, t181, t182, t183, t184, t185, t187, t188;
  double t189, t190, t191, t192, t193, t194, t195, t196;
  double t197, t198, t199, t201, t202, t204, t205, t206;
  double t207, t209, t210, t213, t215, t216, t217, t218;
  double t219, t220, t222, t223, t226, t227, t228, t229;
  double t231, t232, t233, t234, t236, t238, t239, t240;
  double t245, t247, t248, t249, t251, t252, t253, t255;
  double t256, t257, t259, t262, t263, t266, t268, t269;
  double t274, t275, t276, t281, t282, t283, t289, t290;
  double t291, t296, t297, t298, t301, t302, t303, t306;
  double t308, t310, t311, t313, t315, t316, t317, t318;
  double t319, t320, t321, t322, t324, t325, t326, t327;
  double t330, t331, t332, tvrho0, t335, t336, t337, t338;
  double t340, t342, t343, t344, t346, t347, t348, t350;
  double t351, t352, t353, t354, t355, t356, t357, t358;
  double t360, t361, t364, t365, t366, t367, t368, t371;
  double t372, t375, t377, t378, t382, t383, t384, t385;
  double t386, t387, t388, t390, t391, t394, t395, t396;
  double tvrho1, t399, t400, t401, t402, t403, t405, t406;
  double t407, t408, t409, t410, t411, t412, t414, t416;
  double t418, t420, t421, tvsigma0, t423, t424, t425, t428;
  double t429, tvsigma1, tvsigma2, tvlapl0, tvlapl1, t431, t432, t433;
  double t434, t435, t436, t438, t439, t440, t441, t442;
  double t444, t445, t446, t447, t448, t449, t451, t452;
  double t453, t456, t459, t460, tvtau0, t462, t463, t464;
  double t466, t467, t468, t471, t472, t473, t474, t475;
  double t477, t478, t479, t484, t485, tvtau1;

  double t493, t495, t496, t498, t500, t501, t502, t503;
  double t505, t506, t507, t508, t509, t511, t512, t513;
  double t514, t516, t517, t518, t520, t521, t522, t523;
  double t524, t525, t526, t527, t528, t529, t530, t531;
  double t532, t533, t534, t535, t536, t537, t538, t539;
  double t541, t542, t543, t544, t545, t546, t547, t548;
  double t549, t550, t551, t552, t553, t554, t555, t556;
  double t557, t558, t559, t560, t561, t562, t564, t565;
  double t567, t568, t571, t573, t574, t575, t576, t579;
  double t580, t581, t583, t584, t588, t589, t590, t591;
  double t592, t593, t594, t595, t596, t597, t598, t599;
  double t600, t601, t602, t603, t604, t606, t609, t610;
  double t611, t612, t615, t616, t617, t619, t620, t622;
  double t623, t624, t626, t629, t631, t633, t635, t636;
  double t637, t639, t640, t641, t644, t648, t649, t650;
  double t651, t654, t658, t660, t664, t666, t670, t671;
  double t675, t676, t677, t678, t679, t688, t689, t692;
  double t693, t694, t695, t696, t697, t702, t703, t706;
  double t707, t708, t709, t710, t711, t713, t720, t721;
  double t723, t724, t725, t726, t727, t728, t729, t731;
  double t735, t739, t740, t741, t742, t745, t748, t749;
  double t752, t753, t754, t755, t757, t758, t760, t763;
  double t764, t766, t768, t769, t770, t772, t773, t775;
  double t776, t778, t779, t780, t782, t783, t784, t787;
  double t789, t790, t791, t792, t793, t794, t795, t796;
  double t797, t799, t800, t801, t802, t805, t806, t807;
  double t810, t811, t814, t815, t816, t817, t818, t819;
  double tv2rho20, t822, t823, t824, t826, t827, t828, t830;
  double t832, t833, t834, t836, t837, t838, t840, t841;
  double t842, t843, t844, t846, t847, t849, t851, t853;
  double t854, t855, t856, t858, t859, t861, t862, t863;
  double t865, t866, t867, t869, t871, t872, t873, t876;
  double t878, t879, t880, t883, t884, t886, t887, t891;
  double t892, t893, t894, t896, t897, t898, t900, t902;
  double t903, t904, t905, t907, t908, t909, t911, t912;
  double t915, t916, t919, t921, t923, t925, t928, t932;
  double t933, t936, t940, t942, t943, t945, t946, t950;
  double t951, t952, t953, t954, t956, t957, t959, t962;
  double t963, t966, t967, t970, t971, t972, t973, t974;
  double t975, tv2rho21, t983, t984, t986, t987, t988, t990;
  double t991, t993, t994, t996, t998, t999, t1000, t1002;
  double t1003, t1004, t1006, t1007, t1008, t1009, t1010, t1011;
  double t1012, t1013, t1014, t1015, t1016, t1017, t1018, t1019;
  double t1020, t1021, t1022, t1023, t1024, t1025, t1026, t1027;
  double t1028, t1029, t1030, t1031, t1032, t1033, t1034, t1035;
  double t1037, t1038, t1042, t1043, t1046, t1047, t1048, t1049;
  double t1050, t1051, t1052, t1053, t1054, t1055, t1058, t1062;
  double t1063, t1066, t1070, t1072, t1073, t1081, t1083, t1084;
  double t1085, t1086, t1087, t1088, t1089, t1090, t1092, t1095;
  double t1098, t1099, t1102, t1103, t1104, t1105, t1106, t1107;
  double tv2rho22, t1109, t1110, t1111, t1112, t1113, t1114, t1115;
  double t1116, t1117, t1118, t1119, t1120, t1121, t1122, t1123;
  double t1124, t1126, t1127, t1128, t1130, t1131, t1132, t1134;
  double t1135, t1136, t1137, t1138, t1139, t1140, t1141, t1142;
  double t1143, t1144, t1145, t1146, t1147, t1148, t1149, t1150;
  double t1151, t1152, t1153, t1154, t1155, t1156, t1157, t1158;
  double t1159, t1160, t1161, t1162, t1163, t1164, t1166, t1167;
  double t1168, t1169, t1171, t1172, t1173, t1175, t1177, t1178;
  double t1179, t1180, t1181, t1182, tv2rhosigma0, t1184, t1185, t1186;
  double t1187, t1188, t1189, t1190, t1191, t1192, t1193, t1194;
  double t1195, t1196, t1197, t1198, t1201, t1202, t1203, t1204;
  double t1205, tv2rhosigma1, tv2rhosigma2, t1207, t1208, t1209, t1210, t1211;
  double t1212, t1213, t1214, t1215, t1216, t1218, t1219, t1220;
  double t1222, t1223, t1224, t1225, t1226, t1227, t1228, t1229;
  double t1230, t1231, t1232, t1233, t1234, t1235, t1236, t1237;
  double t1238, t1240, t1241, t1242, t1244, t1245, t1246, t1247;
  double tv2rhosigma3, t1249, t1250, t1251, t1252, t1253, t1254, t1255;
  double t1256, t1257, t1258, t1261, t1262, t1263, t1264, tv2rhosigma4;
  double tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t1266, t1267, t1268;
  double t1269, t1270, t1271, t1272, t1274, t1275, t1276, t1277;
  double t1278, t1279, t1280, t1281, t1282, t1283, t1284, t1286;
  double t1287, t1288, t1290, t1291, t1292, t1293, t1294, t1295;
  double t1296, t1297, t1298, t1299, t1300, t1301, t1302, t1303;
  double t1304, t1305, t1306, t1307, t1308, t1309, t1310, t1311;
  double t1312, t1313, t1314, t1315, t1317, t1318, t1319, t1320;
  double t1321, t1322, t1323, t1324, t1325, t1326, t1327, t1328;
  double t1329, t1330, t1331, t1332, t1333, t1334, t1335, t1336;
  double t1337, t1338, t1339, t1340, t1341, t1342, t1343, t1344;
  double t1345, t1346, t1347, t1348, t1349, t1350, t1351, t1352;
  double t1353, t1354, t1355, t1356, t1357, t1358, t1359, t1360;
  double t1361, t1362, t1363, t1364, t1365, t1368, t1369, t1370;
  double t1373, t1375, t1378, t1379, t1380, t1383, t1389, t1390;
  double t1391, t1392, tv2rhotau0, t1394, t1395, t1396, t1398, t1399;
  double t1400, t1401, t1402, t1403, t1404, t1405, t1406, t1407;
  double t1408, t1409, t1410, t1411, t1412, t1413, t1414, t1416;
  double t1417, t1419, t1420, t1421, t1422, t1424, t1425, t1426;
  double t1427, t1428, t1429, t1430, t1431, t1432, t1433, t1434;
  double t1435, t1436, t1437, t1438, t1439, t1440, t1441, t1442;
  double t1443, t1444, t1445, t1446, t1447, t1448, t1449, t1450;
  double t1451, t1452, t1453, t1454, t1455, t1456, t1457, t1460;
  double t1463, t1464, t1465, t1471, t1472, t1473, t1474, tv2rhotau1;
  double t1477, t1478, t1479, t1480, t1481, t1482, t1483, t1485;
  double t1486, t1487, t1489, t1490, t1491, t1492, t1493, t1494;
  double t1495, t1496, t1497, t1498, t1499, t1500, t1501, t1502;
  double t1503, t1504, t1506, t1507, t1508, t1509, t1510, t1511;
  double t1512, t1513, t1514, t1515, t1516, t1517, t1518, t1519;
  double t1520, t1521, t1522, t1523, t1524, t1525, t1526, t1527;
  double t1528, t1529, t1530, t1534, t1537, t1538, t1544, t1545;
  double t1546, t1547, tv2rhotau2, t1549, t1550, t1551, t1552, t1554;
  double t1555, t1556, t1557, t1558, t1559, t1560, t1561, t1562;
  double t1563, t1564, t1565, t1566, t1568, t1569, t1571, t1572;
  double t1573, t1574, t1576, t1577, t1578, t1580, t1581, t1582;
  double t1583, t1584, t1586, t1587, t1588, t1589, t1590, t1591;
  double t1592, t1593, t1594, t1595, t1596, t1597, t1598, t1599;
  double t1600, t1601, t1602, t1603, t1604, t1605, t1606, t1607;
  double t1608, t1610, t1611, t1616, t1617, t1626, t1627, t1628;
  double t1629, tv2rhotau3, t1632, t1633, t1634, t1635, t1636, t1637;
  double t1639, t1640, t1641, t1642, t1643, t1644, t1645, t1647;
  double t1648, t1649, t1650, t1651, t1652, t1653, t1654, t1656;
  double t1659, t1661, t1662, tv2sigma20, t1664, t1665, t1666, t1667;
  double t1670, t1671, tv2sigma21, tv2sigma22, t1673, t1674, t1675, t1676;
  double t1679, t1680, tv2sigma23, tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1682, t1683, t1684, t1685, t1686;
  double t1687, t1688, t1689, t1690, t1691, t1692, t1693, t1694;
  double t1695, t1696, t1697, t1698, t1699, t1700, t1701, t1702;
  double t1703, t1704, t1705, t1706, t1707, t1708, t1709, t1710;
  double t1711, t1712, t1713, t1714, t1716, t1717, t1719, t1721;
  double t1723, t1724, tv2sigmatau0, t1726, t1727, t1728, t1729, t1730;
  double t1731, t1732, t1733, t1734, t1735, t1736, t1738, t1739;
  double t1740, t1741, t1742, t1743, t1744, t1745, t1746, t1747;
  double t1748, t1749, t1750, t1752, t1754, t1756, t1757, tv2sigmatau1;
  double t1759, t1760, t1761, t1762, t1763, t1764, t1765, t1768;
  double t1769, tv2sigmatau2, t1771, t1772, t1773, t1774, t1775, t1776;
  double t1777, t1780, t1781, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, tv2lapl20, tv2lapl21;
  double tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, t1784, t1785, t1786;
  double t1788, t1789, t1790, t1791, t1793, t1794, t1795, t1796;
  double t1797, t1798, t1800, t1801, t1802, t1803, t1805, t1806;
  double t1807, t1808, t1810, t1811, t1812, t1813, t1814, t1816;
  double t1820, t1823, t1824, tv2tau20, t1826, t1828, t1830, t1831;
  double t1832, t1833, t1834, t1836, t1837, t1838, t1839, t1840;
  double t1842, t1843, t1844, t1845, t1847, t1853, t1854, tv2tau21;
  double t1857, t1858, t1859, t1861, t1862, t1863, t1864, t1866;
  double t1867, t1868, t1870, t1871, t1872, t1875, t1876, t1877;
  double t1878, t1880, t1881, t1882, t1883, t1884, t1886, t1887;
  double t1893, t1894, tv2tau22;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t7 = tau[0] * t6;
  t8 = rho[0] - rho[1];
  t9 = rho[0] + rho[1];
  t10 = 0.1e1 / t9;
  t11 = t8 * t10;
  t12 = 0.1e1 + t11;
  t13 = t12 / 0.2e1;
  t14 = POW_1_3(t13);
  t15 = t14 * t14;
  t16 = t15 * t13;
  t17 = t7 * t16;
  t18 = POW_1_3(rho[1]);
  t19 = t18 * t18;
  t21 = 0.1e1 / t19 / rho[1];
  t22 = tau[1] * t21;
  t23 = 0.1e1 - t11;
  t24 = t23 / 0.2e1;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = t26 * t24;
  t28 = t22 * t27;
  t30 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t31 = t9 * t9;
  t32 = POW_1_3(t9);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / t31;
  t38 = t17 + t28 - t30 * t35 / 0.8e1;
  t39 = t2 * t38;
  t40 = M_CBRT6;
  t41 = M_PI * M_PI;
  t42 = POW_1_3(t41);
  t43 = t42 * t42;
  t44 = 0.1e1 / t43;
  t45 = t40 * t44;
  t46 = t39 * t45;
  t47 = M_CBRT2;
  t48 = t47 * t47;
  t50 = t45 * t48;
  t53 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t38 * t50;
  t54 = 0.1e1 / t53;
  t55 = t48 * t54;
  t56 = t31 * t31;
  t58 = 0.1e1 / t33 / t56;
  t59 = t30 * t58;
  t60 = t17 + t28;
  t61 = 0.1e1 / t60;
  t62 = t8 * t8;
  t63 = t61 * t62;
  t66 = 0.1e1 - t59 * t63 / 0.8e1;
  t67 = M_CBRT3;
  t68 = 0.1e1 / M_PI;
  t69 = POW_1_3(t68);
  t70 = t67 * t69;
  t71 = M_CBRT4;
  t72 = t71 * t71;
  t75 = t70 * t72 / t32;
  t77 = 0.1e1 + 0.53425e-1 * t75;
  t78 = sqrt(t75);
  t81 = POW_3_2(t75);
  t83 = t67 * t67;
  t84 = t69 * t69;
  t85 = t83 * t84;
  t88 = t85 * t71 / t33;
  t90 = 0.379785e1 * t78 + 0.8969e0 * t75 + 0.204775e0 * t81 + 0.123235e0 * t88;
  t93 = 0.1e1 + 0.16081979498692535067e2 / t90;
  t94 = log(t93);
  t96 = 0.621814e-1 * t77 * t94;
  t97 = t62 * t62;
  t98 = 0.1e1 / t56;
  t99 = t97 * t98;
  t100 = t12 <= p->zeta_threshold;
  t101 = POW_1_3(p->zeta_threshold);
  t102 = t101 * p->zeta_threshold;
  t103 = POW_1_3(t12);
  t105 = my_piecewise3(t100, t102, t103 * t12);
  t106 = t23 <= p->zeta_threshold;
  t107 = POW_1_3(t23);
  t109 = my_piecewise3(t106, t102, t107 * t23);
  t110 = t105 + t109 - 0.2e1;
  t113 = 0.1e1 / (0.2e1 * t47 - 0.2e1);
  t114 = t110 * t113;
  t116 = 0.1e1 + 0.5137e-1 * t75;
  t121 = 0.705945e1 * t78 + 0.1549425e1 * t75 + 0.420775e0 * t81 + 0.1562925e0 * t88;
  t124 = 0.1e1 + 0.32163958997385070134e2 / t121;
  t125 = log(t124);
  t129 = 0.1e1 + 0.278125e-1 * t75;
  t134 = 0.51785e1 * t78 + 0.905775e0 * t75 + 0.1100325e0 * t81 + 0.1241775e0 * t88;
  t137 = 0.1e1 + 0.29608749977793437516e2 / t134;
  t138 = log(t137);
  t139 = t129 * t138;
  t141 = -0.310907e-1 * t116 * t125 + t96 - 0.19751673498613801407e-1 * t139;
  t142 = t114 * t141;
  t146 = -t96 + t99 * t142 + 0.19751673498613801407e-1 * t114 * t139;
  t147 = t66 * t146;
  t148 = t55 * t147;
  t150 = 0.5e1 / 0.9e1 * t46 * t148;
  t151 = t39 * t40;
  t152 = t44 * t48;
  t153 = t152 * t54;
  t154 = t151 * t153;
  t156 = 0.1e1 - 0.5e1 / 0.9e1 * t154;
  t157 = t156 * t146;
  tzk0 = t150 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = rho[0] * rho[0];
  t160 = 0.1e1 / t4 / t158;
  t161 = tau[0] * t160;
  t162 = t161 * t16;
  t164 = 0.1e1 / t31;
  t165 = t8 * t164;
  t166 = t10 - t165;
  t167 = t166 / 0.2e1;
  t168 = t15 * t167;
  t169 = t7 * t168;
  t171 = -t167;
  t172 = t26 * t171;
  t173 = t22 * t172;
  t175 = t31 * t9;
  t177 = 0.1e1 / t33 / t175;
  t179 = t30 * t177 / 0.3e1;
  t180 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173 + t179;
  t181 = t2 * t180;
  t182 = t181 * t45;
  t183 = t182 * t148;
  t184 = 0.5e1 / 0.9e1 * t183;
  t185 = t40 * t40;
  t187 = 0.1e1 / t42 / t41;
  t188 = t185 * t187;
  t189 = t188 * t47;
  t190 = t39 * t189;
  t191 = t53 * t53;
  t192 = 0.1e1 / t191;
  t193 = t192 * t66;
  t194 = t146 * params->c;
  t195 = t194 * t180;
  t196 = t193 * t195;
  t197 = t190 * t196;
  t198 = 0.5e2 / 0.81e2 * t197;
  t199 = t56 * t9;
  t201 = 0.1e1 / t33 / t199;
  t202 = t30 * t201;
  t204 = 0.7e1 / 0.12e2 * t202 * t63;
  t205 = t60 * t60;
  t206 = 0.1e1 / t205;
  t207 = t206 * t62;
  t209 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173;
  t210 = t207 * t209;
  t213 = t61 * t8;
  t215 = t59 * t213 / 0.4e1;
  t216 = t204 + t59 * t210 / 0.8e1 - t215;
  t217 = t216 * t146;
  t218 = t55 * t217;
  t219 = t46 * t218;
  t220 = 0.5e1 / 0.9e1 * t219;
  t222 = 0.1e1 / t32 / t9;
  t223 = t72 * t222;
  t226 = 0.11073470983333333333e-2 * t70 * t223 * t94;
  t227 = t90 * t90;
  t228 = 0.1e1 / t227;
  t229 = t77 * t228;
  t231 = 0.1e1 / t78 * t67;
  t232 = t69 * t72;
  t233 = t232 * t222;
  t234 = t231 * t233;
  t236 = t70 * t223;
  t238 = sqrt(t75);
  t239 = t238 * t67;
  t240 = t239 * t233;
  t245 = t85 * t71 / t33 / t9;
  t247 = -0.632975e0 * t234 - 0.29896666666666666667e0 * t236 - 0.1023875e0 * t240 - 0.82156666666666666667e-1 * t245;
  t248 = 0.1e1 / t93;
  t249 = t247 * t248;
  t251 = 0.1e1 * t229 * t249;
  t252 = t62 * t8;
  t253 = t252 * t98;
  t255 = 0.4e1 * t253 * t142;
  t256 = 0.1e1 / t199;
  t257 = t97 * t256;
  t259 = 0.4e1 * t257 * t142;
  t262 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t166);
  t263 = -t166;
  t266 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t263);
  t268 = (t262 + t266) * t113;
  t269 = t268 * t141;
  t274 = t121 * t121;
  t275 = 0.1e1 / t274;
  t276 = t116 * t275;
  t281 = -0.1176575e1 * t234 - 0.516475e0 * t236 - 0.2103875e0 * t240 - 0.104195e0 * t245;
  t282 = 0.1e1 / t124;
  t283 = t281 * t282;
  t289 = t134 * t134;
  t290 = 0.1e1 / t289;
  t291 = t129 * t290;
  t296 = -0.86308333333333333334e0 * t234 - 0.301925e0 * t236 - 0.5501625e-1 * t240 - 0.82785e-1 * t245;
  t297 = 0.1e1 / t137;
  t298 = t296 * t297;
  t301 = 0.53237641966666666666e-3 * t70 * t223 * t125 + 0.1e1 * t276 * t283 - t226 - t251 + 0.18311447306006545054e-3 * t70 * t223 * t138 + 0.5848223622634646207e0 * t291 * t298;
  t302 = t114 * t301;
  t303 = t99 * t302;
  t306 = t114 * t67;
  t308 = t232 * t222 * t138;
  t310 = 0.18311447306006545054e-3 * t306 * t308;
  t311 = t114 * t129;
  t313 = t290 * t296 * t297;
  t315 = 0.5848223622634646207e0 * t311 * t313;
  t316 = t226 + t251 + t255 - t259 + t99 * t269 + t303 + 0.19751673498613801407e-1 * t268 * t139 - t310 - t315;
  t317 = t66 * t316;
  t318 = t55 * t317;
  t319 = t46 * t318;
  t320 = 0.5e1 / 0.9e1 * t319;
  t321 = t181 * t40;
  t322 = t321 * t153;
  t324 = t39 * t188;
  t325 = t47 * t192;
  t326 = params->c * t180;
  t327 = t325 * t326;
  t330 = -0.5e1 / 0.9e1 * t322 + 0.5e2 / 0.81e2 * t324 * t327;
  t331 = t330 * t146;
  t332 = t156 * t316;
  tvrho0 = t150 + t157 + t9 * (t184 - t198 + t220 + t320 + t331 + t332);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t335 = -t10 - t165;
  t336 = t335 / 0.2e1;
  t337 = t15 * t336;
  t338 = t7 * t337;
  t340 = rho[1] * rho[1];
  t342 = 0.1e1 / t19 / t340;
  t343 = tau[1] * t342;
  t344 = t343 * t27;
  t346 = -t336;
  t347 = t26 * t346;
  t348 = t22 * t347;
  t350 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348 + t179;
  t351 = t2 * t350;
  t352 = t351 * t45;
  t353 = t352 * t148;
  t354 = 0.5e1 / 0.9e1 * t353;
  t355 = t194 * t350;
  t356 = t193 * t355;
  t357 = t190 * t356;
  t358 = 0.5e2 / 0.81e2 * t357;
  t360 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348;
  t361 = t207 * t360;
  t364 = t204 + t59 * t361 / 0.8e1 + t215;
  t365 = t364 * t146;
  t366 = t55 * t365;
  t367 = t46 * t366;
  t368 = 0.5e1 / 0.9e1 * t367;
  t371 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t335);
  t372 = -t335;
  t375 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t372);
  t377 = (t371 + t375) * t113;
  t378 = t377 * t141;
  t382 = t226 + t251 - t255 - t259 + t99 * t378 + t303 + 0.19751673498613801407e-1 * t377 * t139 - t310 - t315;
  t383 = t66 * t382;
  t384 = t55 * t383;
  t385 = t46 * t384;
  t386 = 0.5e1 / 0.9e1 * t385;
  t387 = t351 * t40;
  t388 = t387 * t153;
  t390 = params->c * t350;
  t391 = t325 * t390;
  t394 = -0.5e1 / 0.9e1 * t388 + 0.5e2 / 0.81e2 * t324 * t391;
  t395 = t394 * t146;
  t396 = t156 * t382;
  tvrho1 = t150 + t157 + t9 * (t354 - t358 + t368 + t386 + t395 + t396);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t399 = t2 * t35;
  t400 = t399 * t45;
  t401 = t400 * t148;
  t402 = 0.5e1 / 0.72e2 * t401;
  t403 = t194 * t35;
  t405 = t190 * t193 * t403;
  t406 = 0.25e2 / 0.324e3 * t405;
  t407 = t39 * t50;
  t408 = t54 * t58;
  t409 = t63 * t146;
  t410 = t408 * t409;
  t411 = t407 * t410;
  t412 = 0.5e1 / 0.72e2 * t411;
  t414 = t399 * t40 * t153;
  t416 = params->c * t35;
  t418 = t324 * t325 * t416;
  t420 = 0.5e1 / 0.72e2 * t414 - 0.25e2 / 0.324e3 * t418;
  t421 = t420 * t146;
  tvsigma0 = t9 * (-t402 + t406 - t412 + t421);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t423 = 0.5e1 / 0.36e2 * t401;
  t424 = 0.25e2 / 0.162e3 * t405;
  t425 = 0.5e1 / 0.36e2 * t411;
  t428 = 0.5e1 / 0.36e2 * t414 - 0.25e2 / 0.162e3 * t418;
  t429 = t428 * t146;
  tvsigma1 = t9 * (-t423 + t424 - t425 + t429);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t431 = t2 * t6;
  t432 = t16 * t40;
  t433 = t431 * t432;
  t434 = t54 * t66;
  t435 = t434 * t146;
  t436 = t152 * t435;
  t438 = 0.5e1 / 0.9e1 * t433 * t436;
  t439 = t193 * t146;
  t440 = params->c * t6;
  t441 = t440 * t16;
  t442 = t439 * t441;
  t444 = 0.5e2 / 0.81e2 * t190 * t442;
  t445 = t59 * t206;
  t446 = t62 * t6;
  t447 = t16 * t146;
  t448 = t446 * t447;
  t449 = t445 * t448;
  t451 = 0.5e1 / 0.72e2 * t154 * t449;
  t452 = t431 * t16;
  t453 = t45 * t55;
  t456 = t325 * t441;
  t459 = -0.5e1 / 0.9e1 * t452 * t453 + 0.5e2 / 0.81e2 * t324 * t456;
  t460 = t459 * t146;
  tvtau0 = t9 * (t438 - t444 + t451 + t460);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t462 = t2 * t21;
  t463 = t27 * t40;
  t464 = t462 * t463;
  t466 = 0.5e1 / 0.9e1 * t464 * t436;
  t467 = params->c * t21;
  t468 = t467 * t27;
  t471 = 0.5e2 / 0.81e2 * t190 * t439 * t468;
  t472 = t62 * t21;
  t473 = t27 * t146;
  t474 = t472 * t473;
  t475 = t445 * t474;
  t477 = 0.5e1 / 0.72e2 * t154 * t475;
  t478 = t462 * t27;
  t479 = t478 * t453;
  t484 = -0.5e1 / 0.9e1 * t479 + 0.5e2 / 0.81e2 * t324 * t325 * t468;
  t485 = t484 * t146;
  tvtau1 = t9 * (t466 - t471 + t477 + t485);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t493 = t158 * rho[0];
  t495 = 0.1e1 / t4 / t493;
  t496 = tau[0] * t495;
  t498 = 0.4e2 / 0.9e1 * t496 * t16;
  t500 = 0.5e2 / 0.9e1 * t161 * t168;
  t501 = 0.1e1 / t14;
  t502 = t167 * t167;
  t503 = t501 * t502;
  t505 = 0.1e2 / 0.9e1 * t7 * t503;
  t506 = 0.1e1 / t175;
  t507 = t8 * t506;
  t508 = -t164 + t507;
  t509 = t15 * t508;
  t511 = 0.5e1 / 0.3e1 * t7 * t509;
  t512 = 0.1e1 / t25;
  t513 = t171 * t171;
  t514 = t512 * t513;
  t516 = 0.1e2 / 0.9e1 * t22 * t514;
  t517 = -t508;
  t518 = t26 * t517;
  t520 = 0.5e1 / 0.3e1 * t22 * t518;
  t521 = 0.11e2 / 0.9e1 * t59;
  t522 = t498 - t500 + t505 + t511 + t516 + t520 - t521;
  t523 = t2 * t522;
  t524 = t523 * t45;
  t525 = t524 * t148;
  t526 = 0.5e1 / 0.9e1 * t525;
  t527 = t180 * t180;
  t528 = t2 * t527;
  t529 = t528 * t188;
  t530 = t147 * params->c;
  t531 = t325 * t530;
  t532 = t529 * t531;
  t533 = 0.1e3 / 0.81e2 * t532;
  t534 = t182 * t218;
  t535 = 0.1e2 / 0.9e1 * t534;
  t536 = t182 * t318;
  t537 = 0.1e2 / 0.9e1 * t536;
  t538 = t41 * t41;
  t539 = 0.1e1 / t538;
  t541 = 0.1e1 / t191 / t53;
  t542 = t539 * t541;
  t543 = t39 * t542;
  t544 = params->c * params->c;
  t545 = t544 * t527;
  t546 = t147 * t545;
  t547 = t543 * t546;
  t548 = 0.2e4 / 0.243e3 * t547;
  t549 = t192 * t216;
  t550 = t549 * t195;
  t551 = t190 * t550;
  t552 = 0.1e3 / 0.81e2 * t551;
  t553 = t316 * params->c;
  t554 = t553 * t180;
  t555 = t193 * t554;
  t556 = t190 * t555;
  t557 = 0.1e3 / 0.81e2 * t556;
  t558 = t194 * t522;
  t559 = t193 * t558;
  t560 = t190 * t559;
  t561 = 0.5e2 / 0.81e2 * t560;
  t562 = t56 * t31;
  t564 = 0.1e1 / t33 / t562;
  t565 = t30 * t564;
  t567 = 0.119e3 / 0.36e2 * t565 * t63;
  t568 = t202 * t210;
  t571 = 0.7e1 / 0.3e1 * t202 * t213;
  t573 = 0.1e1 / t205 / t60;
  t574 = t573 * t62;
  t575 = t209 * t209;
  t576 = t574 * t575;
  t579 = t206 * t8;
  t580 = t579 * t209;
  t581 = t59 * t580;
  t583 = t498 - t500 + t505 + t511 + t516 + t520;
  t584 = t207 * t583;
  t588 = t59 * t61 / 0.4e1;
  t589 = -t567 - 0.7e1 / 0.6e1 * t568 + t571 - t59 * t576 / 0.4e1 + t581 / 0.2e1 + t59 * t584 / 0.8e1 - t588;
  t590 = t589 * t146;
  t591 = t55 * t590;
  t592 = t46 * t591;
  t593 = 0.5e1 / 0.9e1 * t592;
  t594 = t216 * t316;
  t595 = t55 * t594;
  t596 = t46 * t595;
  t597 = 0.1e2 / 0.9e1 * t596;
  t598 = t289 * t289;
  t599 = 0.1e1 / t598;
  t600 = t296 * t296;
  t601 = t599 * t600;
  t602 = t137 * t137;
  t603 = 0.1e1 / t602;
  t604 = t601 * t603;
  t606 = 0.17315859105681463759e2 * t311 * t604;
  t609 = 0.1e1 / t78 / t75 * t83;
  t610 = t84 * t71;
  t611 = t610 * t35;
  t612 = t609 * t611;
  t615 = 0.1e1 / t32 / t31;
  t616 = t232 * t615;
  t617 = t231 * t616;
  t619 = t72 * t615;
  t620 = t70 * t619;
  t622 = 0.1e1/sqrt(t75);
  t623 = t622 * t83;
  t624 = t623 * t611;
  t626 = t239 * t616;
  t629 = t85 * t71 * t35;
  t631 = -0.57538888888888888889e0 * t612 + 0.11507777777777777778e1 * t617 + 0.40256666666666666667e0 * t620 + 0.366775e-1 * t624 + 0.73355e-1 * t626 + 0.137975e0 * t629;
  t633 = t290 * t631 * t297;
  t635 = 0.5848223622634646207e0 * t311 * t633;
  t636 = t268 * t129;
  t637 = t636 * t313;
  t639 = t103 * t103;
  t640 = 0.1e1 / t639;
  t641 = t166 * t166;
  t644 = 0.2e1 * t508;
  t648 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t641 + 0.4e1 / 0.3e1 * t103 * t644);
  t649 = t107 * t107;
  t650 = 0.1e1 / t649;
  t651 = t263 * t263;
  t654 = -t644;
  t658 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t651 + 0.4e1 / 0.3e1 * t107 * t654);
  t660 = (t648 + t658) * t113;
  t664 = t232 * t615 * t138;
  t666 = 0.24415263074675393405e-3 * t306 * t664;
  t670 = t70 * t72;
  t671 = t222 * t275;
  t675 = t274 * t121;
  t676 = 0.1e1 / t675;
  t677 = t116 * t676;
  t678 = t281 * t281;
  t679 = t678 * t282;
  t688 = -0.78438333333333333333e0 * t612 + 0.15687666666666666667e1 * t617 + 0.68863333333333333333e0 * t620 + 0.14025833333333333333e0 * t624 + 0.28051666666666666667e0 * t626 + 0.17365833333333333333e0 * t629;
  t689 = t688 * t282;
  t692 = t274 * t274;
  t693 = 0.1e1 / t692;
  t694 = t116 * t693;
  t695 = t124 * t124;
  t696 = 0.1e1 / t695;
  t697 = t678 * t696;
  t702 = 0.14764627977777777777e-2 * t70 * t619 * t94;
  t703 = t222 * t228;
  t706 = 0.35616666666666666666e-1 * t670 * t703 * t249;
  t707 = t227 * t90;
  t708 = 0.1e1 / t707;
  t709 = t77 * t708;
  t710 = t247 * t247;
  t711 = t710 * t248;
  t713 = 0.2e1 * t709 * t711;
  t720 = -0.42198333333333333333e0 * t612 + 0.84396666666666666666e0 * t617 + 0.39862222222222222223e0 * t620 + 0.68258333333333333333e-1 * t624 + 0.13651666666666666667e0 * t626 + 0.13692777777777777778e0 * t629;
  t721 = t720 * t248;
  t723 = 0.1e1 * t229 * t721;
  t724 = t227 * t227;
  t725 = 0.1e1 / t724;
  t726 = t77 * t725;
  t727 = t93 * t93;
  t728 = 0.1e1 / t727;
  t729 = t710 * t728;
  t731 = 0.16081979498692535067e2 * t726 * t729;
  t735 = t222 * t290;
  t739 = t289 * t134;
  t740 = 0.1e1 / t739;
  t741 = t129 * t740;
  t742 = t600 * t297;
  t745 = t631 * t297;
  t748 = t129 * t599;
  t749 = t600 * t603;
  t752 = -0.70983522622222222221e-3 * t70 * t619 * t125 - 0.34246666666666666666e-1 * t670 * t671 * t283 - 0.2e1 * t677 * t679 + 0.1e1 * t276 * t689 + 0.32163958997385070134e2 * t694 * t697 + t702 + t706 + t713 - t723 - t731 - 0.24415263074675393405e-3 * t70 * t619 * t138 - 0.10843581300301739842e-1 * t670 * t735 * t298 - 0.11696447245269292414e1 * t741 * t742 + 0.5848223622634646207e0 * t291 * t745 + 0.17315859105681463759e2 * t748 * t749;
  t753 = t114 * t752;
  t754 = t99 * t753;
  t755 = t660 * t141;
  t757 = t268 * t301;
  t758 = t99 * t757;
  t760 = t257 * t269;
  t763 = 0.8e1 * t257 * t302;
  t764 = t253 * t269;
  t766 = -t606 - t635 - 0.11696447245269292414e1 * t637 + 0.19751673498613801407e-1 * t660 * t139 + t666 + t754 + t99 * t755 + 0.2e1 * t758 - 0.8e1 * t760 - t763 + 0.8e1 * t764;
  t768 = 0.8e1 * t253 * t302;
  t769 = 0.1e1 / t562;
  t770 = t97 * t769;
  t772 = 0.2e2 * t770 * t142;
  t773 = t62 * t98;
  t775 = 0.12e2 * t773 * t142;
  t776 = t252 * t256;
  t778 = 0.32e2 * t776 * t142;
  t779 = t114 * t70;
  t780 = t223 * t313;
  t782 = 0.10843581300301739842e-1 * t779 * t780;
  t783 = t268 * t67;
  t784 = t783 * t308;
  t787 = t740 * t600 * t297;
  t789 = 0.11696447245269292414e1 * t311 * t787;
  t790 = t768 - t713 + t772 + t775 - t778 - t702 + t723 + t731 + t782 - 0.36622894612013090108e-3 * t784 + t789 - t706;
  t791 = t766 + t790;
  t792 = t66 * t791;
  t793 = t55 * t792;
  t794 = t46 * t793;
  t795 = 0.5e1 / 0.9e1 * t794;
  t796 = t523 * t40;
  t797 = t796 * t153;
  t799 = t528 * t185;
  t800 = t187 * t47;
  t801 = t192 * params->c;
  t802 = t800 * t801;
  t805 = t39 * t539;
  t806 = t541 * t544;
  t807 = t806 * t527;
  t810 = params->c * t522;
  t811 = t325 * t810;
  t814 = -0.5e1 / 0.9e1 * t797 + 0.1e3 / 0.81e2 * t799 * t802 - 0.2e4 / 0.243e3 * t805 * t807 + 0.5e2 / 0.81e2 * t324 * t811;
  t815 = t814 * t146;
  t816 = t330 * t316;
  t817 = 0.2e1 * t816;
  t818 = t156 * t791;
  t819 = t526 - t533 + t535 + t537 + t548 - t552 - t557 - t561 + t593 + t597 + t795 + t815 + t817 + t818;
  tv2rho20 = 0.1e2 / 0.9e1 * t183 - 0.1e3 / 0.81e2 * t197 + 0.1e2 / 0.9e1 * t219 + 0.1e2 / 0.9e1 * t319 + 0.2e1 * t331 + 0.2e1 * t332 + t9 * t819;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t822 = 0.25e2 / 0.9e1 * t161 * t337;
  t823 = t501 * t336;
  t824 = t823 * t167;
  t826 = 0.1e2 / 0.9e1 * t7 * t824;
  t827 = t15 * t8;
  t828 = t827 * t506;
  t830 = 0.5e1 / 0.3e1 * t7 * t828;
  t832 = 0.25e2 / 0.9e1 * t343 * t172;
  t833 = t512 * t346;
  t834 = t833 * t171;
  t836 = 0.1e2 / 0.9e1 * t22 * t834;
  t837 = t26 * t8;
  t838 = t837 * t506;
  t840 = 0.5e1 / 0.3e1 * t22 * t838;
  t841 = -t822 + t826 + t830 - t832 + t836 - t840 - t521;
  t842 = t2 * t841;
  t843 = t842 * t45;
  t844 = t843 * t148;
  t846 = t351 * t189;
  t847 = t846 * t196;
  t849 = t352 * t218;
  t851 = t352 * t318;
  t853 = t544 * t350;
  t854 = t853 * t180;
  t855 = t147 * t854;
  t856 = t543 * t855;
  t858 = t549 * t355;
  t859 = t190 * t858;
  t861 = t553 * t350;
  t862 = t193 * t861;
  t863 = t190 * t862;
  t865 = t194 * t841;
  t866 = t193 * t865;
  t867 = t190 * t866;
  t869 = t182 * t366;
  t871 = t192 * t364;
  t872 = t871 * t195;
  t873 = t190 * t872;
  t876 = t202 * t361;
  t878 = t59 * t573;
  t879 = t62 * t360;
  t880 = t879 * t209;
  t883 = t579 * t360;
  t884 = t59 * t883;
  t886 = -t822 + t826 + t830 - t832 + t836 - t840;
  t887 = t207 * t886;
  t891 = -t567 - 0.7e1 / 0.12e2 * t568 - 0.7e1 / 0.12e2 * t876 - t878 * t880 / 0.4e1 + t884 / 0.4e1 + t59 * t887 / 0.8e1 - t581 / 0.4e1 + t588;
  t892 = t891 * t146;
  t893 = t55 * t892;
  t894 = t46 * t893;
  t896 = t364 * t316;
  t897 = t55 * t896;
  t898 = t46 * t897;
  t900 = t182 * t384;
  t902 = t382 * params->c;
  t903 = t902 * t180;
  t904 = t193 * t903;
  t905 = t190 * t904;
  t907 = t216 * t382;
  t908 = t55 * t907;
  t909 = t46 * t908;
  t911 = t377 * t129;
  t912 = t911 * t313;
  t915 = t377 * t67;
  t916 = t915 * t308;
  t919 = -0.5848223622634646207e0 * t912 + t789 - t635 - 0.5848223622634646207e0 * t637 + t772 - t775 - t606 + t782 + t731 - 0.18311447306006545054e-3 * t916 - t763 - 0.4e1 * t764 + t666;
  t921 = t253 * t378;
  t923 = t257 * t378;
  t925 = t640 * t335;
  t928 = t103 * t8;
  t932 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t925 * t166 + 0.8e1 / 0.3e1 * t928 * t506);
  t933 = t650 * t372;
  t936 = t107 * t8;
  t940 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t933 * t263 - 0.8e1 / 0.3e1 * t936 * t506);
  t942 = (t932 + t940) * t113;
  t943 = t942 * t141;
  t945 = t377 * t301;
  t946 = t99 * t945;
  t950 = -t706 - 0.18311447306006545054e-3 * t784 + 0.4e1 * t921 - 0.4e1 * t923 + t99 * t943 + t946 + t758 - 0.4e1 * t760 - t713 + t723 + 0.19751673498613801407e-1 * t942 * t139 + t754 - t702;
  t951 = t919 + t950;
  t952 = t66 * t951;
  t953 = t55 * t952;
  t954 = t46 * t953;
  t956 = t842 * t40;
  t957 = t956 * t153;
  t959 = t351 * t188;
  t962 = t350 * t180;
  t963 = t806 * t962;
  t966 = params->c * t841;
  t967 = t325 * t966;
  t970 = -0.5e1 / 0.9e1 * t957 + 0.1e3 / 0.81e2 * t959 * t327 - 0.2e4 / 0.243e3 * t805 * t963 + 0.5e2 / 0.81e2 * t324 * t967;
  t971 = t970 * t146;
  t972 = t394 * t316;
  t973 = t330 * t382;
  t974 = t156 * t951;
  t975 = 0.5e1 / 0.9e1 * t844 - 0.1e3 / 0.81e2 * t847 + 0.5e1 / 0.9e1 * t849 + 0.5e1 / 0.9e1 * t851 + 0.2e4 / 0.243e3 * t856 - 0.5e2 / 0.81e2 * t859 - 0.5e2 / 0.81e2 * t863 - 0.5e2 / 0.81e2 * t867 + 0.5e1 / 0.9e1 * t869 - 0.5e2 / 0.81e2 * t873 + 0.5e1 / 0.9e1 * t894 + 0.5e1 / 0.9e1 * t898 + 0.5e1 / 0.9e1 * t900 - 0.5e2 / 0.81e2 * t905 + 0.5e1 / 0.9e1 * t909 + 0.5e1 / 0.9e1 * t954 + t971 + t972 + t973 + t974;
  tv2rho21 = t9 * t975 + t184 - t198 + t220 + t320 + t331 + t332 + t354 - t358 + t368 + t386 + t395 + t396;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t983 = t336 * t336;
  t984 = t501 * t983;
  t986 = 0.1e2 / 0.9e1 * t7 * t984;
  t987 = t164 + t507;
  t988 = t15 * t987;
  t990 = 0.5e1 / 0.3e1 * t7 * t988;
  t991 = t340 * rho[1];
  t993 = 0.1e1 / t19 / t991;
  t994 = tau[1] * t993;
  t996 = 0.4e2 / 0.9e1 * t994 * t27;
  t998 = 0.5e2 / 0.9e1 * t343 * t347;
  t999 = t346 * t346;
  t1000 = t512 * t999;
  t1002 = 0.1e2 / 0.9e1 * t22 * t1000;
  t1003 = -t987;
  t1004 = t26 * t1003;
  t1006 = 0.5e1 / 0.3e1 * t22 * t1004;
  t1007 = t986 + t990 + t996 - t998 + t1002 + t1006 - t521;
  t1008 = t2 * t1007;
  t1009 = t1008 * t45;
  t1010 = t1009 * t148;
  t1011 = 0.5e1 / 0.9e1 * t1010;
  t1012 = t350 * t350;
  t1013 = t2 * t1012;
  t1014 = t1013 * t188;
  t1015 = t1014 * t531;
  t1016 = 0.1e3 / 0.81e2 * t1015;
  t1017 = t352 * t366;
  t1018 = 0.1e2 / 0.9e1 * t1017;
  t1019 = t352 * t384;
  t1020 = 0.1e2 / 0.9e1 * t1019;
  t1021 = t544 * t1012;
  t1022 = t147 * t1021;
  t1023 = t543 * t1022;
  t1024 = 0.2e4 / 0.243e3 * t1023;
  t1025 = t871 * t355;
  t1026 = t190 * t1025;
  t1027 = 0.1e3 / 0.81e2 * t1026;
  t1028 = t902 * t350;
  t1029 = t193 * t1028;
  t1030 = t190 * t1029;
  t1031 = 0.1e3 / 0.81e2 * t1030;
  t1032 = t194 * t1007;
  t1033 = t193 * t1032;
  t1034 = t190 * t1033;
  t1035 = 0.5e2 / 0.81e2 * t1034;
  t1037 = t360 * t360;
  t1038 = t574 * t1037;
  t1042 = t986 + t990 + t996 - t998 + t1002 + t1006;
  t1043 = t207 * t1042;
  t1046 = -t567 - 0.7e1 / 0.6e1 * t876 - t571 - t59 * t1038 / 0.4e1 - t884 / 0.2e1 + t59 * t1043 / 0.8e1 - t588;
  t1047 = t1046 * t146;
  t1048 = t55 * t1047;
  t1049 = t46 * t1048;
  t1050 = 0.5e1 / 0.9e1 * t1049;
  t1051 = t364 * t382;
  t1052 = t55 * t1051;
  t1053 = t46 * t1052;
  t1054 = 0.1e2 / 0.9e1 * t1053;
  t1055 = t335 * t335;
  t1058 = 0.2e1 * t987;
  t1062 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t1055 + 0.4e1 / 0.3e1 * t103 * t1058);
  t1063 = t372 * t372;
  t1066 = -t1058;
  t1070 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t1063 + 0.4e1 / 0.3e1 * t107 * t1066);
  t1072 = (t1062 + t1070) * t113;
  t1073 = t1072 * t141;
  t1081 = t99 * t1073 + 0.19751673498613801407e-1 * t1072 * t139 - 0.11696447245269292414e1 * t912 - 0.8e1 * t921 - 0.8e1 * t923 + 0.2e1 * t946 - t606 - t635 + t666 + t754 - t763;
  t1083 = -t768 - t713 + t772 + t775 + t778 - t702 + t723 + t731 + t782 - 0.36622894612013090108e-3 * t916 + t789 - t706;
  t1084 = t1081 + t1083;
  t1085 = t66 * t1084;
  t1086 = t55 * t1085;
  t1087 = t46 * t1086;
  t1088 = 0.5e1 / 0.9e1 * t1087;
  t1089 = t1008 * t40;
  t1090 = t1089 * t153;
  t1092 = t1013 * t185;
  t1095 = t806 * t1012;
  t1098 = params->c * t1007;
  t1099 = t325 * t1098;
  t1102 = -0.5e1 / 0.9e1 * t1090 + 0.1e3 / 0.81e2 * t1092 * t802 - 0.2e4 / 0.243e3 * t805 * t1095 + 0.5e2 / 0.81e2 * t324 * t1099;
  t1103 = t1102 * t146;
  t1104 = t394 * t382;
  t1105 = 0.2e1 * t1104;
  t1106 = t156 * t1084;
  t1107 = t1011 - t1016 + t1018 + t1020 + t1024 - t1027 - t1031 - t1035 + t1050 + t1054 + t1088 + t1103 + t1105 + t1106;
  tv2rho22 = 0.1e2 / 0.9e1 * t353 - 0.1e3 / 0.81e2 * t357 + 0.1e2 / 0.9e1 * t367 + 0.1e2 / 0.9e1 * t385 + 0.2e1 * t395 + 0.2e1 * t396 + t9 * t1107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t1109 = t2 * t177;
  t1110 = t1109 * t45;
  t1111 = t1110 * t148;
  t1112 = 0.5e1 / 0.27e2 * t1111;
  t1113 = t399 * t189;
  t1114 = t1113 * t196;
  t1115 = 0.25e2 / 0.162e3 * t1114;
  t1116 = t400 * t218;
  t1117 = 0.5e1 / 0.72e2 * t1116;
  t1118 = t400 * t318;
  t1119 = 0.5e1 / 0.72e2 * t1118;
  t1120 = t544 * t35;
  t1121 = t1120 * t180;
  t1122 = t147 * t1121;
  t1123 = t543 * t1122;
  t1124 = 0.25e3 / 0.243e3 * t1123;
  t1126 = t190 * t549 * t403;
  t1127 = 0.25e2 / 0.324e3 * t1126;
  t1128 = t553 * t35;
  t1130 = t190 * t193 * t1128;
  t1131 = 0.25e2 / 0.324e3 * t1130;
  t1132 = t194 * t177;
  t1134 = t190 * t193 * t1132;
  t1135 = 0.5e2 / 0.243e3 * t1134;
  t1136 = t181 * t50;
  t1137 = t1136 * t410;
  t1138 = 0.5e1 / 0.72e2 * t1137;
  t1139 = t39 * t185;
  t1140 = t800 * t192;
  t1141 = t1139 * t1140;
  t1142 = t58 * t61;
  t1143 = t1142 * t62;
  t1144 = t1143 * t195;
  t1145 = t1141 * t1144;
  t1146 = 0.25e2 / 0.324e3 * t1145;
  t1147 = t54 * t201;
  t1148 = t1147 * t409;
  t1149 = t407 * t1148;
  t1150 = 0.35e2 / 0.108e3 * t1149;
  t1151 = t408 * t206;
  t1152 = t62 * t146;
  t1153 = t1152 * t209;
  t1154 = t1151 * t1153;
  t1155 = t407 * t1154;
  t1156 = 0.5e1 / 0.72e2 * t1155;
  t1157 = t213 * t146;
  t1158 = t408 * t1157;
  t1159 = t407 * t1158;
  t1160 = 0.5e1 / 0.36e2 * t1159;
  t1161 = t63 * t316;
  t1162 = t408 * t1161;
  t1163 = t407 * t1162;
  t1164 = 0.5e1 / 0.72e2 * t1163;
  t1166 = t1109 * t40 * t153;
  t1167 = 0.5e1 / 0.27e2 * t1166;
  t1168 = t399 * t188;
  t1169 = t1168 * t327;
  t1171 = t35 * t180;
  t1172 = t806 * t1171;
  t1173 = t805 * t1172;
  t1175 = params->c * t177;
  t1177 = t324 * t325 * t1175;
  t1178 = 0.5e2 / 0.243e3 * t1177;
  t1179 = -t1167 - 0.25e2 / 0.162e3 * t1169 + 0.25e3 / 0.243e3 * t1173 + t1178;
  t1180 = t1179 * t146;
  t1181 = t420 * t316;
  t1182 = t1112 + t1115 - t1117 - t1119 - t1124 + t1127 + t1131 - t1135 - t1138 + t1146 + t1150 + t1156 - t1160 - t1164 + t1180 + t1181;
  tv2rhosigma0 = t1182 * t9 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t1184 = 0.1e2 / 0.27e2 * t1111;
  t1185 = 0.25e2 / 0.81e2 * t1114;
  t1186 = 0.5e1 / 0.36e2 * t1116;
  t1187 = 0.5e1 / 0.36e2 * t1118;
  t1188 = 0.5e3 / 0.243e3 * t1123;
  t1189 = 0.25e2 / 0.162e3 * t1126;
  t1190 = 0.25e2 / 0.162e3 * t1130;
  t1191 = 0.1e3 / 0.243e3 * t1134;
  t1192 = 0.5e1 / 0.36e2 * t1137;
  t1193 = 0.25e2 / 0.162e3 * t1145;
  t1194 = 0.35e2 / 0.54e2 * t1149;
  t1195 = 0.5e1 / 0.36e2 * t1155;
  t1196 = 0.5e1 / 0.18e2 * t1159;
  t1197 = 0.5e1 / 0.36e2 * t1163;
  t1198 = 0.1e2 / 0.27e2 * t1166;
  t1201 = 0.1e3 / 0.243e3 * t1177;
  t1202 = -t1198 - 0.25e2 / 0.81e2 * t1169 + 0.5e3 / 0.243e3 * t1173 + t1201;
  t1203 = t1202 * t146;
  t1204 = t428 * t316;
  t1205 = t1184 + t1185 - t1186 - t1187 - t1188 + t1189 + t1190 - t1191 - t1192 + t1193 + t1194 + t1195 - t1196 - t1197 + t1203 + t1204;
  tv2rhosigma1 = t1205 * t9 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1207 = t1113 * t356;
  t1208 = 0.25e2 / 0.162e3 * t1207;
  t1209 = t400 * t366;
  t1210 = 0.5e1 / 0.72e2 * t1209;
  t1211 = t400 * t384;
  t1212 = 0.5e1 / 0.72e2 * t1211;
  t1213 = t1120 * t350;
  t1214 = t147 * t1213;
  t1215 = t543 * t1214;
  t1216 = 0.25e3 / 0.243e3 * t1215;
  t1218 = t190 * t871 * t403;
  t1219 = 0.25e2 / 0.324e3 * t1218;
  t1220 = t902 * t35;
  t1222 = t190 * t193 * t1220;
  t1223 = 0.25e2 / 0.324e3 * t1222;
  t1224 = t351 * t50;
  t1225 = t1224 * t410;
  t1226 = 0.5e1 / 0.72e2 * t1225;
  t1227 = t1143 * t355;
  t1228 = t1141 * t1227;
  t1229 = 0.25e2 / 0.324e3 * t1228;
  t1230 = t1152 * t360;
  t1231 = t1151 * t1230;
  t1232 = t407 * t1231;
  t1233 = 0.5e1 / 0.72e2 * t1232;
  t1234 = t63 * t382;
  t1235 = t408 * t1234;
  t1236 = t407 * t1235;
  t1237 = 0.5e1 / 0.72e2 * t1236;
  t1238 = t1168 * t391;
  t1240 = t35 * t350;
  t1241 = t806 * t1240;
  t1242 = t805 * t1241;
  t1244 = -t1167 - 0.25e2 / 0.162e3 * t1238 + 0.25e3 / 0.243e3 * t1242 + t1178;
  t1245 = t1244 * t146;
  t1246 = t420 * t382;
  t1247 = t1112 + t1208 - t1210 - t1212 - t1216 + t1219 + t1223 - t1135 - t1226 + t1229 + t1150 + t1233 + t1160 - t1237 + t1245 + t1246;
  tv2rhosigma3 = t1247 * t9 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t1249 = 0.25e2 / 0.81e2 * t1207;
  t1250 = 0.5e1 / 0.36e2 * t1209;
  t1251 = 0.5e1 / 0.36e2 * t1211;
  t1252 = 0.5e3 / 0.243e3 * t1215;
  t1253 = 0.25e2 / 0.162e3 * t1218;
  t1254 = 0.25e2 / 0.162e3 * t1222;
  t1255 = 0.5e1 / 0.36e2 * t1225;
  t1256 = 0.25e2 / 0.162e3 * t1228;
  t1257 = 0.5e1 / 0.36e2 * t1232;
  t1258 = 0.5e1 / 0.36e2 * t1236;
  t1261 = -t1198 - 0.25e2 / 0.81e2 * t1238 + 0.5e3 / 0.243e3 * t1242 + t1201;
  t1262 = t1261 * t146;
  t1263 = t428 * t382;
  t1264 = t1184 + t1249 - t1250 - t1251 - t1252 + t1253 + t1254 - t1191 - t1255 + t1256 + t1194 + t1257 + t1196 - t1258 + t1262 + t1263;
  tv2rhosigma4 = t1264 * t9 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1266 = t2 * t160;
  t1267 = t1266 * t432;
  t1268 = t1267 * t436;
  t1269 = 0.25e2 / 0.27e2 * t1268;
  t1270 = t15 * t40;
  t1271 = t1270 * t44;
  t1272 = t431 * t1271;
  t1274 = t55 * t147 * t167;
  t1275 = t1272 * t1274;
  t1276 = 0.25e2 / 0.27e2 * t1275;
  t1277 = t16 * t185;
  t1278 = t1277 * t187;
  t1279 = t431 * t1278;
  t1280 = t325 * t66;
  t1281 = t1280 * t195;
  t1282 = t1279 * t1281;
  t1283 = 0.1e3 / 0.81e2 * t1282;
  t1284 = t54 * t216;
  t1286 = t152 * t1284 * t146;
  t1287 = t433 * t1286;
  t1288 = 0.5e1 / 0.9e1 * t1287;
  t1290 = t152 * t434 * t316;
  t1291 = t433 * t1290;
  t1292 = 0.5e1 / 0.9e1 * t1291;
  t1293 = t542 * t66;
  t1294 = t39 * t1293;
  t1295 = t146 * t544;
  t1296 = t6 * t16;
  t1297 = t1296 * t180;
  t1298 = t1295 * t1297;
  t1299 = t1294 * t1298;
  t1300 = 0.2e4 / 0.243e3 * t1299;
  t1301 = t549 * t146;
  t1302 = t1301 * t441;
  t1303 = t190 * t1302;
  t1304 = 0.5e2 / 0.81e2 * t1303;
  t1305 = t193 * t316;
  t1306 = t1305 * t441;
  t1307 = t190 * t1306;
  t1308 = 0.5e2 / 0.81e2 * t1307;
  t1309 = params->c * t160;
  t1310 = t1309 * t16;
  t1311 = t439 * t1310;
  t1312 = t190 * t1311;
  t1313 = 0.25e3 / 0.243e3 * t1312;
  t1314 = t6 * t15;
  t1315 = t1314 * t167;
  t1317 = t1141 * t530 * t1315;
  t1318 = 0.25e3 / 0.243e3 * t1317;
  t1319 = t322 * t449;
  t1320 = 0.5e1 / 0.72e2 * t1319;
  t1321 = t192 * t30;
  t1322 = t800 * t1321;
  t1323 = t1139 * t1322;
  t1324 = t58 * t206;
  t1325 = t1324 * t446;
  t1326 = t447 * t326;
  t1327 = t1325 * t1326;
  t1328 = t1323 * t1327;
  t1329 = 0.25e2 / 0.324e3 * t1328;
  t1330 = t202 * t206;
  t1331 = t1330 * t448;
  t1332 = t154 * t1331;
  t1333 = 0.35e2 / 0.108e3 * t1332;
  t1334 = t54 * t30;
  t1335 = t152 * t1334;
  t1336 = t151 * t1335;
  t1337 = t58 * t573;
  t1338 = t1337 * t62;
  t1339 = t146 * t209;
  t1340 = t1296 * t1339;
  t1341 = t1338 * t1340;
  t1342 = t1336 * t1341;
  t1343 = 0.5e1 / 0.36e2 * t1342;
  t1344 = t8 * t6;
  t1345 = t1344 * t447;
  t1346 = t445 * t1345;
  t1347 = t154 * t1346;
  t1348 = 0.5e1 / 0.36e2 * t1347;
  t1349 = t62 * t160;
  t1350 = t1349 * t447;
  t1351 = t445 * t1350;
  t1352 = t154 * t1351;
  t1353 = 0.25e2 / 0.216e3 * t1352;
  t1354 = t1324 * t62;
  t1355 = t146 * t167;
  t1356 = t1314 * t1355;
  t1357 = t1354 * t1356;
  t1358 = t1336 * t1357;
  t1359 = 0.25e2 / 0.216e3 * t1358;
  t1360 = t16 * t316;
  t1361 = t446 * t1360;
  t1362 = t445 * t1361;
  t1363 = t154 * t1362;
  t1364 = 0.5e1 / 0.72e2 * t1363;
  t1365 = t1266 * t16;
  t1368 = t431 * t1270;
  t1369 = t54 * t167;
  t1370 = t152 * t1369;
  t1373 = t431 * t1277;
  t1375 = t800 * t801 * t180;
  t1378 = t544 * t6;
  t1379 = t16 * t180;
  t1380 = t1378 * t1379;
  t1383 = t325 * t1310;
  t1389 = 0.25e2 / 0.27e2 * t1365 * t453 - 0.25e2 / 0.27e2 * t1368 * t1370 + 0.1e3 / 0.81e2 * t1373 * t1375 - 0.2e4 / 0.243e3 * t543 * t1380 - 0.25e3 / 0.243e3 * t324 * t1383 + 0.25e3 / 0.243e3 * t190 * t801 * t1315;
  t1390 = t1389 * t146;
  t1391 = t459 * t316;
  t1392 = -t1269 + t1276 - t1283 + t1288 + t1292 + t1300 - t1304 - t1308 + t1313 - t1318 + t1320 - t1329 - t1333 - t1343 + t1348 - t1353 + t1359 + t1364 + t1390 + t1391;
  tv2rhotau0 = t1392 * t9 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1394 = t26 * t40;
  t1395 = t1394 * t44;
  t1396 = t462 * t1395;
  t1398 = t55 * t147 * t171;
  t1399 = t1396 * t1398;
  t1400 = 0.25e2 / 0.27e2 * t1399;
  t1401 = t27 * t185;
  t1402 = t1401 * t187;
  t1403 = t462 * t1402;
  t1404 = t1403 * t1281;
  t1405 = 0.1e3 / 0.81e2 * t1404;
  t1406 = t464 * t1286;
  t1407 = 0.5e1 / 0.9e1 * t1406;
  t1408 = t464 * t1290;
  t1409 = 0.5e1 / 0.9e1 * t1408;
  t1410 = t21 * t27;
  t1411 = t1410 * t180;
  t1412 = t1295 * t1411;
  t1413 = t1294 * t1412;
  t1414 = 0.2e4 / 0.243e3 * t1413;
  t1416 = t190 * t1301 * t468;
  t1417 = 0.5e2 / 0.81e2 * t1416;
  t1419 = t190 * t1305 * t468;
  t1420 = 0.5e2 / 0.81e2 * t1419;
  t1421 = t21 * t26;
  t1422 = t1421 * t171;
  t1424 = t1141 * t530 * t1422;
  t1425 = 0.25e3 / 0.243e3 * t1424;
  t1426 = t322 * t475;
  t1427 = 0.5e1 / 0.72e2 * t1426;
  t1428 = t1324 * t472;
  t1429 = t473 * t326;
  t1430 = t1428 * t1429;
  t1431 = t1323 * t1430;
  t1432 = 0.25e2 / 0.324e3 * t1431;
  t1433 = t1330 * t474;
  t1434 = t154 * t1433;
  t1435 = 0.35e2 / 0.108e3 * t1434;
  t1436 = t1410 * t1339;
  t1437 = t1338 * t1436;
  t1438 = t1336 * t1437;
  t1439 = 0.5e1 / 0.36e2 * t1438;
  t1440 = t8 * t21;
  t1441 = t1440 * t473;
  t1442 = t445 * t1441;
  t1443 = t154 * t1442;
  t1444 = 0.5e1 / 0.36e2 * t1443;
  t1445 = t146 * t171;
  t1446 = t1421 * t1445;
  t1447 = t1354 * t1446;
  t1448 = t1336 * t1447;
  t1449 = 0.25e2 / 0.216e3 * t1448;
  t1450 = t27 * t316;
  t1451 = t472 * t1450;
  t1452 = t445 * t1451;
  t1453 = t154 * t1452;
  t1454 = 0.5e1 / 0.72e2 * t1453;
  t1455 = t462 * t1394;
  t1456 = t54 * t171;
  t1457 = t152 * t1456;
  t1460 = t462 * t1401;
  t1463 = t544 * t21;
  t1464 = t27 * t180;
  t1465 = t1463 * t1464;
  t1471 = -0.25e2 / 0.27e2 * t1455 * t1457 + 0.1e3 / 0.81e2 * t1460 * t1375 - 0.2e4 / 0.243e3 * t543 * t1465 + 0.25e3 / 0.243e3 * t190 * t801 * t1422;
  t1472 = t1471 * t146;
  t1473 = t484 * t316;
  t1474 = t1400 - t1405 + t1407 + t1409 + t1414 - t1417 - t1420 - t1425 + t1427 - t1432 - t1435 - t1439 + t1444 + t1449 + t1454 + t1472 + t1473;
  tv2rhotau1 = t1474 * t9 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1477 = t55 * t147 * t336;
  t1478 = t1272 * t1477;
  t1479 = 0.25e2 / 0.27e2 * t1478;
  t1480 = t1280 * t355;
  t1481 = t1279 * t1480;
  t1482 = 0.1e3 / 0.81e2 * t1481;
  t1483 = t54 * t364;
  t1485 = t152 * t1483 * t146;
  t1486 = t433 * t1485;
  t1487 = 0.5e1 / 0.9e1 * t1486;
  t1489 = t152 * t434 * t382;
  t1490 = t433 * t1489;
  t1491 = 0.5e1 / 0.9e1 * t1490;
  t1492 = t1296 * t350;
  t1493 = t1295 * t1492;
  t1494 = t1294 * t1493;
  t1495 = 0.2e4 / 0.243e3 * t1494;
  t1496 = t871 * t146;
  t1497 = t1496 * t441;
  t1498 = t190 * t1497;
  t1499 = 0.5e2 / 0.81e2 * t1498;
  t1500 = t193 * t382;
  t1501 = t1500 * t441;
  t1502 = t190 * t1501;
  t1503 = 0.5e2 / 0.81e2 * t1502;
  t1504 = t1314 * t336;
  t1506 = t1141 * t530 * t1504;
  t1507 = 0.25e3 / 0.243e3 * t1506;
  t1508 = t388 * t449;
  t1509 = 0.5e1 / 0.72e2 * t1508;
  t1510 = t447 * t390;
  t1511 = t1325 * t1510;
  t1512 = t1323 * t1511;
  t1513 = 0.25e2 / 0.324e3 * t1512;
  t1514 = t146 * t360;
  t1515 = t1296 * t1514;
  t1516 = t1338 * t1515;
  t1517 = t1336 * t1516;
  t1518 = 0.5e1 / 0.36e2 * t1517;
  t1519 = t146 * t336;
  t1520 = t1314 * t1519;
  t1521 = t1354 * t1520;
  t1522 = t1336 * t1521;
  t1523 = 0.25e2 / 0.216e3 * t1522;
  t1524 = t16 * t382;
  t1525 = t446 * t1524;
  t1526 = t445 * t1525;
  t1527 = t154 * t1526;
  t1528 = 0.5e1 / 0.72e2 * t1527;
  t1529 = t54 * t336;
  t1530 = t152 * t1529;
  t1534 = t800 * t801 * t350;
  t1537 = t16 * t350;
  t1538 = t1378 * t1537;
  t1544 = -0.25e2 / 0.27e2 * t1368 * t1530 + 0.1e3 / 0.81e2 * t1373 * t1534 - 0.2e4 / 0.243e3 * t543 * t1538 + 0.25e3 / 0.243e3 * t190 * t801 * t1504;
  t1545 = t1544 * t146;
  t1546 = t459 * t382;
  t1547 = t1479 - t1482 + t1487 + t1491 + t1495 - t1499 - t1503 - t1507 + t1509 - t1513 - t1333 - t1518 - t1348 + t1523 + t1528 + t1545 + t1546;
  tv2rhotau2 = t1547 * t9 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1549 = t2 * t342;
  t1550 = t1549 * t463;
  t1551 = t1550 * t436;
  t1552 = 0.25e2 / 0.27e2 * t1551;
  t1554 = t55 * t147 * t346;
  t1555 = t1396 * t1554;
  t1556 = 0.25e2 / 0.27e2 * t1555;
  t1557 = t1403 * t1480;
  t1558 = 0.1e3 / 0.81e2 * t1557;
  t1559 = t464 * t1485;
  t1560 = 0.5e1 / 0.9e1 * t1559;
  t1561 = t464 * t1489;
  t1562 = 0.5e1 / 0.9e1 * t1561;
  t1563 = t1410 * t350;
  t1564 = t1295 * t1563;
  t1565 = t1294 * t1564;
  t1566 = 0.2e4 / 0.243e3 * t1565;
  t1568 = t190 * t1496 * t468;
  t1569 = 0.5e2 / 0.81e2 * t1568;
  t1571 = t190 * t1500 * t468;
  t1572 = 0.5e2 / 0.81e2 * t1571;
  t1573 = params->c * t342;
  t1574 = t1573 * t27;
  t1576 = t190 * t439 * t1574;
  t1577 = 0.25e3 / 0.243e3 * t1576;
  t1578 = t1421 * t346;
  t1580 = t1141 * t530 * t1578;
  t1581 = 0.25e3 / 0.243e3 * t1580;
  t1582 = t388 * t475;
  t1583 = 0.5e1 / 0.72e2 * t1582;
  t1584 = t473 * t390;
  t1586 = t1323 * t1428 * t1584;
  t1587 = 0.25e2 / 0.324e3 * t1586;
  t1588 = t1410 * t1514;
  t1589 = t1338 * t1588;
  t1590 = t1336 * t1589;
  t1591 = 0.5e1 / 0.36e2 * t1590;
  t1592 = t62 * t342;
  t1593 = t1592 * t473;
  t1594 = t445 * t1593;
  t1595 = t154 * t1594;
  t1596 = 0.25e2 / 0.216e3 * t1595;
  t1597 = t146 * t346;
  t1598 = t1421 * t1597;
  t1599 = t1354 * t1598;
  t1600 = t1336 * t1599;
  t1601 = 0.25e2 / 0.216e3 * t1600;
  t1602 = t27 * t382;
  t1603 = t472 * t1602;
  t1604 = t445 * t1603;
  t1605 = t154 * t1604;
  t1606 = 0.5e1 / 0.72e2 * t1605;
  t1607 = t1549 * t27;
  t1608 = t1607 * t453;
  t1610 = t54 * t346;
  t1611 = t152 * t1610;
  t1616 = t27 * t350;
  t1617 = t1463 * t1616;
  t1626 = 0.25e2 / 0.27e2 * t1608 - 0.25e2 / 0.27e2 * t1455 * t1611 + 0.1e3 / 0.81e2 * t1460 * t1534 - 0.2e4 / 0.243e3 * t543 * t1617 - 0.25e3 / 0.243e3 * t324 * t325 * t1574 + 0.25e3 / 0.243e3 * t190 * t801 * t1578;
  t1627 = t1626 * t146;
  t1628 = t484 * t382;
  t1629 = -t1552 + t1556 - t1558 + t1560 + t1562 + t1566 - t1569 - t1572 + t1577 - t1581 + t1583 - t1587 - t1435 - t1591 - t1444 - t1596 + t1601 + t1606 + t1627 + t1628;
  tv2rhotau3 = t1629 * t9 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1632 = 0.1e1 / t32 / t199;
  t1633 = t2 * t1632;
  t1634 = t1633 * t188;
  t1635 = t1634 * t531;
  t1636 = 0.25e2 / 0.1296e4 * t1635;
  t1637 = t56 * t175;
  t1639 = 0.1e1 / t32 / t1637;
  t1640 = t2 * t1639;
  t1641 = t1640 * t45;
  t1642 = t55 * t409;
  t1643 = t1641 * t1642;
  t1644 = 0.5e1 / 0.288e3 * t1643;
  t1645 = t544 * t1632;
  t1647 = t543 * t147 * t1645;
  t1648 = 0.125e3 / 0.972e3 * t1647;
  t1649 = t192 * t1639;
  t1650 = t1649 * t61;
  t1651 = t1152 * params->c;
  t1652 = t1650 * t1651;
  t1653 = t190 * t1652;
  t1654 = 0.25e2 / 0.1296e4 * t1653;
  t1656 = t1633 * t185 * t802;
  t1659 = t805 * t806 * t1632;
  t1661 = 0.25e2 / 0.1296e4 * t1656 - 0.125e3 / 0.972e3 * t1659;
  t1662 = t1661 * t146;
  tv2sigma20 = t9 * (-t1636 + t1644 + t1648 - t1654 + t1662);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t1664 = 0.25e2 / 0.648e3 * t1635;
  t1665 = 0.5e1 / 0.144e3 * t1643;
  t1666 = 0.125e3 / 0.486e3 * t1647;
  t1667 = 0.25e2 / 0.648e3 * t1653;
  t1670 = 0.25e2 / 0.648e3 * t1656 - 0.125e3 / 0.486e3 * t1659;
  t1671 = t1670 * t146;
  tv2sigma21 = t9 * (-t1664 + t1665 + t1666 - t1667 + t1671);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  t1673 = 0.25e2 / 0.324e3 * t1635;
  t1674 = 0.5e1 / 0.72e2 * t1643;
  t1675 = 0.125e3 / 0.243e3 * t1647;
  t1676 = 0.25e2 / 0.324e3 * t1653;
  t1679 = 0.25e2 / 0.324e3 * t1656 - 0.125e3 / 0.243e3 * t1659;
  t1680 = t1679 * t146;
  tv2sigma23 = t9 * (-t1673 + t1674 + t1675 - t1676 + t1680);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1682 = t1280 * t403;
  t1683 = t1279 * t1682;
  t1684 = 0.25e2 / 0.162e3 * t1683;
  t1685 = t432 * t44;
  t1686 = t431 * t1685;
  t1687 = t55 * t58;
  t1688 = t1687 * t409;
  t1689 = t1686 * t1688;
  t1690 = 0.5e1 / 0.72e2 * t1689;
  t1691 = t1296 * t35;
  t1692 = t1295 * t1691;
  t1693 = t1294 * t1692;
  t1694 = 0.25e3 / 0.243e3 * t1693;
  t1695 = t194 * t1296;
  t1696 = t1143 * t1695;
  t1697 = t1141 * t1696;
  t1698 = 0.25e2 / 0.324e3 * t1697;
  t1699 = t1640 * t40;
  t1700 = t1699 * t153;
  t1701 = t30 * t206;
  t1702 = t1701 * t62;
  t1703 = t1296 * t146;
  t1704 = t1702 * t1703;
  t1705 = t1700 * t1704;
  t1706 = 0.5e1 / 0.576e3 * t1705;
  t1707 = t1639 * t206;
  t1708 = t1707 * t62;
  t1709 = t1708 * t1695;
  t1710 = t1323 * t1709;
  t1711 = 0.25e2 / 0.2592e4 * t1710;
  t1712 = t1354 * t1703;
  t1713 = t154 * t1712;
  t1714 = 0.5e1 / 0.72e2 * t1713;
  t1716 = t800 * t801 * t35;
  t1717 = t1373 * t1716;
  t1719 = t16 * t35;
  t1721 = t543 * t1378 * t1719;
  t1723 = -0.25e2 / 0.162e3 * t1717 + 0.25e3 / 0.243e3 * t1721;
  t1724 = t1723 * t146;
  tv2sigmatau0 = t9 * (t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t1726 = t1403 * t1682;
  t1727 = 0.25e2 / 0.162e3 * t1726;
  t1728 = t463 * t44;
  t1729 = t462 * t1728;
  t1730 = t1729 * t1688;
  t1731 = 0.5e1 / 0.72e2 * t1730;
  t1732 = t1410 * t35;
  t1733 = t1295 * t1732;
  t1734 = t1294 * t1733;
  t1735 = 0.25e3 / 0.243e3 * t1734;
  t1736 = t194 * t1410;
  t1738 = t1141 * t1143 * t1736;
  t1739 = 0.25e2 / 0.324e3 * t1738;
  t1740 = t1410 * t146;
  t1741 = t1702 * t1740;
  t1742 = t1700 * t1741;
  t1743 = 0.5e1 / 0.576e3 * t1742;
  t1744 = t1708 * t1736;
  t1745 = t1323 * t1744;
  t1746 = 0.25e2 / 0.2592e4 * t1745;
  t1747 = t1354 * t1740;
  t1748 = t154 * t1747;
  t1749 = 0.5e1 / 0.72e2 * t1748;
  t1750 = t1460 * t1716;
  t1752 = t27 * t35;
  t1754 = t543 * t1463 * t1752;
  t1756 = -0.25e2 / 0.162e3 * t1750 + 0.25e3 / 0.243e3 * t1754;
  t1757 = t1756 * t146;
  tv2sigmatau1 = t9 * (t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  t1759 = 0.25e2 / 0.81e2 * t1683;
  t1760 = 0.5e1 / 0.36e2 * t1689;
  t1761 = 0.5e3 / 0.243e3 * t1693;
  t1762 = 0.25e2 / 0.162e3 * t1697;
  t1763 = 0.5e1 / 0.288e3 * t1705;
  t1764 = 0.25e2 / 0.1296e4 * t1710;
  t1765 = 0.5e1 / 0.36e2 * t1713;
  t1768 = -0.25e2 / 0.81e2 * t1717 + 0.5e3 / 0.243e3 * t1721;
  t1769 = t1768 * t146;
  tv2sigmatau2 = t9 * (t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  t1771 = 0.25e2 / 0.81e2 * t1726;
  t1772 = 0.5e1 / 0.36e2 * t1730;
  t1773 = 0.5e3 / 0.243e3 * t1734;
  t1774 = 0.25e2 / 0.162e3 * t1738;
  t1775 = 0.5e1 / 0.288e3 * t1742;
  t1776 = 0.25e2 / 0.1296e4 * t1745;
  t1777 = 0.5e1 / 0.36e2 * t1748;
  t1780 = -0.25e2 / 0.81e2 * t1750 + 0.5e3 / 0.243e3 * t1754;
  t1781 = t1780 * t146;
  tv2sigmatau3 = t9 * (t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = tv2sigmatau0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = tv2sigmatau1;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1784 = 0.1e1 / t3 / t493;
  t1785 = t2 * t1784;
  t1786 = t13 * t13;
  t1788 = t14 * t1786 * t13;
  t1789 = t1788 * t185;
  t1790 = t1789 * t187;
  t1791 = t1785 * t1790;
  t1793 = 0.1e3 / 0.81e2 * t1791 * t531;
  t1794 = t1785 * t1788;
  t1795 = t1794 * t50;
  t1796 = t1334 * t58;
  t1797 = t207 * t146;
  t1798 = t1796 * t1797;
  t1800 = 0.5e1 / 0.36e2 * t1795 * t1798;
  t1801 = t544 * t1784;
  t1802 = t1801 * t1788;
  t1803 = t147 * t1802;
  t1805 = 0.2e4 / 0.243e3 * t543 * t1803;
  t1806 = t1784 * t1788;
  t1807 = t1806 * t194;
  t1808 = t1354 * t1807;
  t1810 = 0.25e2 / 0.162e3 * t1323 * t1808;
  t1811 = t62 * t1784;
  t1812 = t1788 * t146;
  t1813 = t1811 * t1812;
  t1814 = t878 * t1813;
  t1816 = 0.5e1 / 0.36e2 * t154 * t1814;
  t1820 = t806 * t1806;
  t1823 = 0.1e3 / 0.81e2 * t1785 * t1789 * t802 - 0.2e4 / 0.243e3 * t805 * t1820;
  t1824 = t1823 * t146;
  tv2tau20 = t9 * (-t1793 + t1800 + t1805 - t1810 - t1816 + t1824);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t1826 = t478 * t189;
  t1828 = 0.1e3 / 0.81e2 * t1826 * t442;
  t1830 = 0.5e1 / 0.36e2 * t479 * t449;
  t1831 = t1295 * t21;
  t1832 = t27 * t6;
  t1833 = t1832 * t16;
  t1834 = t1831 * t1833;
  t1836 = 0.2e4 / 0.243e3 * t1294 * t1834;
  t1837 = t325 * t59;
  t1838 = t324 * t1837;
  t1839 = t207 * t1296;
  t1840 = t1839 * t1736;
  t1842 = 0.25e2 / 0.162e3 * t1838 * t1840;
  t1843 = t1337 * t472;
  t1844 = t473 * t1296;
  t1845 = t1843 * t1844;
  t1847 = 0.5e1 / 0.36e2 * t1336 * t1845;
  t1853 = 0.1e3 / 0.81e2 * t1403 * t456 - 0.2e4 / 0.243e3 * t543 * t1463 * t1833;
  t1854 = t1853 * t146;
  tv2tau21 = t9 * (-t1828 + t1830 + t1836 - t1842 - t1847 + t1854);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1857 = 0.1e1 / t18 / t991;
  t1858 = t2 * t1857;
  t1859 = t24 * t24;
  t1861 = t25 * t1859 * t24;
  t1862 = t1861 * t185;
  t1863 = t1862 * t187;
  t1864 = t1858 * t1863;
  t1866 = 0.1e3 / 0.81e2 * t1864 * t531;
  t1867 = t1858 * t1861;
  t1868 = t1867 * t50;
  t1870 = 0.5e1 / 0.36e2 * t1868 * t1798;
  t1871 = t544 * t1857;
  t1872 = t1871 * t1861;
  t1875 = 0.2e4 / 0.243e3 * t543 * t147 * t1872;
  t1876 = t1857 * t1861;
  t1877 = t1876 * t194;
  t1878 = t1354 * t1877;
  t1880 = 0.25e2 / 0.162e3 * t1323 * t1878;
  t1881 = t62 * t1857;
  t1882 = t1861 * t146;
  t1883 = t1881 * t1882;
  t1884 = t878 * t1883;
  t1886 = 0.5e1 / 0.36e2 * t154 * t1884;
  t1887 = t1858 * t1862;
  t1893 = 0.1e3 / 0.81e2 * t1887 * t802 - 0.2e4 / 0.243e3 * t805 * t806 * t1876;
  t1894 = t1893 * t146;
  tv2tau22 = t9 * (-t1866 + t1870 + t1875 - t1880 - t1886 + t1894);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t26, t27;
  double t28, t30, t31, t32, t33, t35, t38, t39;
  double t40, t41, t42, t43, t44, t45, t46, t47;
  double t48, t50, t53, t54, t55, t56, t58, t59;
  double t60, t61, t62, t63, t66, t67, t68, t69;
  double t70, t71, t72, t75, t77, t78, t81, t83;
  double t84, t85, t88, t90, t93, t94, t96, t97;
  double t98, t99, t100, t101, t102, t103, t105, t106;
  double t107, t109, t110, t113, t114, t116, t121, t124;
  double t125, t129, t134, t137, t138, t139, t141, t142;
  double t146, t147, t148, t150, t151, t152, t153, t154;
  double t156, t157, tzk0;

  double t158, t160, t161, t162, t164, t165, t166, t167;
  double t168, t169, t171, t172, t173, t175, t177, t179;
  double t180, t181, t182, t183, t184, t185, t187, t188;
  double t189, t190, t191, t192, t193, t194, t195, t196;
  double t197, t198, t199, t201, t202, t204, t205, t206;
  double t207, t209, t210, t213, t215, t216, t217, t218;
  double t219, t220, t222, t223, t226, t227, t228, t229;
  double t231, t232, t233, t234, t236, t238, t239, t240;
  double t245, t247, t248, t249, t251, t252, t253, t255;
  double t256, t257, t259, t262, t263, t266, t268, t269;
  double t274, t275, t276, t281, t282, t283, t289, t290;
  double t291, t296, t297, t298, t301, t302, t303, t306;
  double t308, t310, t311, t313, t315, t316, t317, t318;
  double t319, t320, t321, t322, t324, t325, t326, t327;
  double t330, t331, t332, tvrho0, t335, t336, t337, t338;
  double t340, t342, t343, t344, t346, t347, t348, t350;
  double t351, t352, t353, t354, t355, t356, t357, t358;
  double t360, t361, t364, t365, t366, t367, t368, t371;
  double t372, t375, t377, t378, t382, t383, t384, t385;
  double t386, t387, t388, t390, t391, t394, t395, t396;
  double tvrho1, t399, t400, t401, t402, t403, t405, t406;
  double t407, t408, t409, t410, t411, t412, t414, t416;
  double t418, t420, t421, tvsigma0, t423, t424, t425, t428;
  double t429, tvsigma1, tvsigma2, tvlapl0, tvlapl1, t431, t432, t433;
  double t434, t435, t436, t438, t439, t440, t441, t442;
  double t444, t445, t446, t447, t448, t449, t451, t452;
  double t453, t456, t459, t460, tvtau0, t462, t463, t464;
  double t466, t467, t468, t471, t472, t473, t474, t475;
  double t477, t478, t479, t484, t485, tvtau1;

  double t493, t495, t496, t498, t500, t501, t502, t503;
  double t505, t506, t507, t508, t509, t511, t512, t513;
  double t514, t516, t517, t518, t520, t521, t522, t523;
  double t524, t525, t526, t527, t528, t529, t530, t531;
  double t532, t533, t534, t535, t536, t537, t538, t539;
  double t541, t542, t543, t544, t545, t546, t547, t548;
  double t549, t550, t551, t552, t553, t554, t555, t556;
  double t557, t558, t559, t560, t561, t562, t564, t565;
  double t567, t568, t571, t573, t574, t575, t576, t579;
  double t580, t581, t583, t584, t588, t589, t590, t591;
  double t592, t593, t594, t595, t596, t597, t598, t599;
  double t600, t601, t602, t603, t604, t606, t609, t610;
  double t611, t612, t615, t616, t617, t619, t620, t622;
  double t623, t624, t626, t629, t631, t633, t635, t636;
  double t637, t639, t640, t641, t644, t648, t649, t650;
  double t651, t654, t658, t660, t664, t666, t670, t671;
  double t675, t676, t677, t678, t679, t688, t689, t692;
  double t693, t694, t695, t696, t697, t702, t703, t706;
  double t707, t708, t709, t710, t711, t713, t720, t721;
  double t723, t724, t725, t726, t727, t728, t729, t731;
  double t735, t739, t740, t741, t742, t745, t748, t749;
  double t752, t753, t754, t755, t757, t758, t760, t763;
  double t764, t766, t768, t769, t770, t772, t773, t775;
  double t776, t778, t779, t780, t782, t783, t784, t787;
  double t789, t790, t791, t792, t793, t794, t795, t796;
  double t797, t799, t800, t801, t802, t805, t806, t807;
  double t810, t811, t814, t815, t816, t817, t818, t819;
  double tv2rho20, t822, t823, t824, t826, t827, t828, t830;
  double t832, t833, t834, t836, t837, t838, t840, t841;
  double t842, t843, t844, t846, t847, t849, t851, t853;
  double t854, t855, t856, t858, t859, t861, t862, t863;
  double t865, t866, t867, t869, t871, t872, t873, t876;
  double t878, t879, t880, t883, t884, t886, t887, t891;
  double t892, t893, t894, t896, t897, t898, t900, t902;
  double t903, t904, t905, t907, t908, t909, t911, t912;
  double t915, t916, t919, t921, t923, t925, t928, t932;
  double t933, t936, t940, t942, t943, t945, t946, t950;
  double t951, t952, t953, t954, t956, t957, t959, t962;
  double t963, t966, t967, t970, t971, t972, t973, t974;
  double t975, tv2rho21, t983, t984, t986, t987, t988, t990;
  double t991, t993, t994, t996, t998, t999, t1000, t1002;
  double t1003, t1004, t1006, t1007, t1008, t1009, t1010, t1011;
  double t1012, t1013, t1014, t1015, t1016, t1017, t1018, t1019;
  double t1020, t1021, t1022, t1023, t1024, t1025, t1026, t1027;
  double t1028, t1029, t1030, t1031, t1032, t1033, t1034, t1035;
  double t1037, t1038, t1042, t1043, t1046, t1047, t1048, t1049;
  double t1050, t1051, t1052, t1053, t1054, t1055, t1058, t1062;
  double t1063, t1066, t1070, t1072, t1073, t1081, t1083, t1084;
  double t1085, t1086, t1087, t1088, t1089, t1090, t1092, t1095;
  double t1098, t1099, t1102, t1103, t1104, t1105, t1106, t1107;
  double tv2rho22, t1109, t1110, t1111, t1112, t1113, t1114, t1115;
  double t1116, t1117, t1118, t1119, t1120, t1121, t1122, t1123;
  double t1124, t1126, t1127, t1128, t1130, t1131, t1132, t1134;
  double t1135, t1136, t1137, t1138, t1139, t1140, t1141, t1142;
  double t1143, t1144, t1145, t1146, t1147, t1148, t1149, t1150;
  double t1151, t1152, t1153, t1154, t1155, t1156, t1157, t1158;
  double t1159, t1160, t1161, t1162, t1163, t1164, t1166, t1167;
  double t1168, t1169, t1171, t1172, t1173, t1175, t1177, t1178;
  double t1179, t1180, t1181, t1182, tv2rhosigma0, t1184, t1185, t1186;
  double t1187, t1188, t1189, t1190, t1191, t1192, t1193, t1194;
  double t1195, t1196, t1197, t1198, t1201, t1202, t1203, t1204;
  double t1205, tv2rhosigma1, tv2rhosigma2, t1207, t1208, t1209, t1210, t1211;
  double t1212, t1213, t1214, t1215, t1216, t1218, t1219, t1220;
  double t1222, t1223, t1224, t1225, t1226, t1227, t1228, t1229;
  double t1230, t1231, t1232, t1233, t1234, t1235, t1236, t1237;
  double t1238, t1240, t1241, t1242, t1244, t1245, t1246, t1247;
  double tv2rhosigma3, t1249, t1250, t1251, t1252, t1253, t1254, t1255;
  double t1256, t1257, t1258, t1261, t1262, t1263, t1264, tv2rhosigma4;
  double tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t1266, t1267, t1268;
  double t1269, t1270, t1271, t1272, t1274, t1275, t1276, t1277;
  double t1278, t1279, t1280, t1281, t1282, t1283, t1284, t1286;
  double t1287, t1288, t1290, t1291, t1292, t1293, t1294, t1295;
  double t1296, t1297, t1298, t1299, t1300, t1301, t1302, t1303;
  double t1304, t1305, t1306, t1307, t1308, t1309, t1310, t1311;
  double t1312, t1313, t1314, t1315, t1317, t1318, t1319, t1320;
  double t1321, t1322, t1323, t1324, t1325, t1326, t1327, t1328;
  double t1329, t1330, t1331, t1332, t1333, t1334, t1335, t1336;
  double t1337, t1338, t1339, t1340, t1341, t1342, t1343, t1344;
  double t1345, t1346, t1347, t1348, t1349, t1350, t1351, t1352;
  double t1353, t1354, t1355, t1356, t1357, t1358, t1359, t1360;
  double t1361, t1362, t1363, t1364, t1365, t1368, t1369, t1370;
  double t1373, t1375, t1378, t1379, t1380, t1383, t1389, t1390;
  double t1391, t1392, tv2rhotau0, t1394, t1395, t1396, t1398, t1399;
  double t1400, t1401, t1402, t1403, t1404, t1405, t1406, t1407;
  double t1408, t1409, t1410, t1411, t1412, t1413, t1414, t1416;
  double t1417, t1419, t1420, t1421, t1422, t1424, t1425, t1426;
  double t1427, t1428, t1429, t1430, t1431, t1432, t1433, t1434;
  double t1435, t1436, t1437, t1438, t1439, t1440, t1441, t1442;
  double t1443, t1444, t1445, t1446, t1447, t1448, t1449, t1450;
  double t1451, t1452, t1453, t1454, t1455, t1456, t1457, t1460;
  double t1463, t1464, t1465, t1471, t1472, t1473, t1474, tv2rhotau1;
  double t1477, t1478, t1479, t1480, t1481, t1482, t1483, t1485;
  double t1486, t1487, t1489, t1490, t1491, t1492, t1493, t1494;
  double t1495, t1496, t1497, t1498, t1499, t1500, t1501, t1502;
  double t1503, t1504, t1506, t1507, t1508, t1509, t1510, t1511;
  double t1512, t1513, t1514, t1515, t1516, t1517, t1518, t1519;
  double t1520, t1521, t1522, t1523, t1524, t1525, t1526, t1527;
  double t1528, t1529, t1530, t1534, t1537, t1538, t1544, t1545;
  double t1546, t1547, tv2rhotau2, t1549, t1550, t1551, t1552, t1554;
  double t1555, t1556, t1557, t1558, t1559, t1560, t1561, t1562;
  double t1563, t1564, t1565, t1566, t1568, t1569, t1571, t1572;
  double t1573, t1574, t1576, t1577, t1578, t1580, t1581, t1582;
  double t1583, t1584, t1586, t1587, t1588, t1589, t1590, t1591;
  double t1592, t1593, t1594, t1595, t1596, t1597, t1598, t1599;
  double t1600, t1601, t1602, t1603, t1604, t1605, t1606, t1607;
  double t1608, t1610, t1611, t1616, t1617, t1626, t1627, t1628;
  double t1629, tv2rhotau3, t1632, t1633, t1634, t1635, t1636, t1637;
  double t1639, t1640, t1641, t1642, t1643, t1644, t1645, t1647;
  double t1648, t1649, t1650, t1651, t1652, t1653, t1654, t1656;
  double t1659, t1661, t1662, tv2sigma20, t1664, t1665, t1666, t1667;
  double t1670, t1671, tv2sigma21, tv2sigma22, t1673, t1674, t1675, t1676;
  double t1679, t1680, tv2sigma23, tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1682, t1683, t1684, t1685, t1686;
  double t1687, t1688, t1689, t1690, t1691, t1692, t1693, t1694;
  double t1695, t1696, t1697, t1698, t1699, t1700, t1701, t1702;
  double t1703, t1704, t1705, t1706, t1707, t1708, t1709, t1710;
  double t1711, t1712, t1713, t1714, t1716, t1717, t1719, t1721;
  double t1723, t1724, tv2sigmatau0, t1726, t1727, t1728, t1729, t1730;
  double t1731, t1732, t1733, t1734, t1735, t1736, t1738, t1739;
  double t1740, t1741, t1742, t1743, t1744, t1745, t1746, t1747;
  double t1748, t1749, t1750, t1752, t1754, t1756, t1757, tv2sigmatau1;
  double t1759, t1760, t1761, t1762, t1763, t1764, t1765, t1768;
  double t1769, tv2sigmatau2, t1771, t1772, t1773, t1774, t1775, t1776;
  double t1777, t1780, t1781, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, tv2lapl20, tv2lapl21;
  double tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, t1784, t1785, t1786;
  double t1788, t1789, t1790, t1791, t1793, t1794, t1795, t1796;
  double t1797, t1798, t1800, t1801, t1802, t1803, t1805, t1806;
  double t1807, t1808, t1810, t1811, t1812, t1813, t1814, t1816;
  double t1820, t1823, t1824, tv2tau20, t1826, t1828, t1830, t1831;
  double t1832, t1833, t1834, t1836, t1837, t1838, t1839, t1840;
  double t1842, t1843, t1844, t1845, t1847, t1853, t1854, tv2tau21;
  double t1857, t1858, t1859, t1861, t1862, t1863, t1864, t1866;
  double t1867, t1868, t1870, t1871, t1872, t1875, t1876, t1877;
  double t1878, t1880, t1881, t1882, t1883, t1884, t1886, t1887;
  double t1893, t1894, tv2tau22;

  double t1896, t1897, t1898, t1899, t1900, t1901, t1902, t1903;
  double t1904, t1905, t1906, t1907, t1908, t1909, t1910, t1911;
  double t1914, t1917, t1918, t1921, t1923, t1925, t1927, t1928;
  double t1929, t1931, t1934, t1935, t1937, t1939, t1941, t1942;
  double t1944, t1945, t1947, t1948, t1950, t1951, t1952, t1954;
  double t1955, t1957, t1961, t1962, t1964, t1965, t1967, t1968;
  double t1970, t1971, t1973, t1974, t1975, t1977, t1979, t1982;
  double t1984, t1985, t1987, t1991, t1993, t1994, t1997, t2000;
  double t2001, t2002, t2006, t2008, t2009, t2012, t2015, t2019;
  double t2021, t2024, t2025, t2027, t2030, t2031, t2034, t2035;
  double t2037, t2038, t2041, t2043, t2044, t2045, t2047, t2049;
  double t2050, t2052, t2053, t2055, t2056, t2059, t2061, t2063;
  double t2064, t2066, t2067, t2069, t2076, t2080, t2084, t2091;
  double t2092, t2096, t2097, t2098, t2099, t2110, t2111, t2118;
  double t2122, t2123, t2134, t2135, t2138, t2139, t2151, t2155;
  double t2158, t2163, t2166, t2167, t2170, t2171, t2175, t2176;
  double t2178, t2179, t2183, t2184, t2185, t2187, t2188, t2189;
  double t2190, t2191, t2193, t2194, t2195, t2196, t2198, t2200;
  double t2202, t2204, t2205, t2206, t2207, t2209, t2212, t2213;
  double t2214, t2215, t2217, t2218, t2221, t2222, t2223, t2224;
  double t2225, t2226, t2227, t2228, t2229, t2231, t2232, t2235;
  double t2237, t2238, t2240, t2242, t2243, t2244, t2246, t2247;
  double t2249, t2250, t2252, t2253, t2254, t2256, t2258, t2260;
  double t2261, t2262, t2263, t2264, t2265, t2266, t2269, t2270;
  double t2271, t2273, t2274, t2277, t2278, t2280, t2281, t2283;
  double t2285, t2286, t2288, t2290, t2292, t2294, t2295, t2296;
  double t2297, t2298, t2300, t2301, t2302, t2304, t2305, t2306;
  double t2308, t2309, t2310, t2311, t2312, t2314, t2315, t2316;
  double t2318, t2319, t2320, t2322, t2323, t2324, t2327, t2329;
  double t2330, t2331, t2333, t2334, t2335, t2336, t2337, t2338;
  double t2339, t2340, t2342, t2347, t2348, t2349, t2352, t2353;
  double t2354, t2355, t2356, t2358, t2361, t2362, t2365, t2366;
  double t2369, t2370, t2371, t2372, t2373, t2374, t2375, t2376;
  double t2377, t2378, t2380, t2381, t2382, t2383, t2384, t2385;
  double t2386, t2387, t2388, t2389, t2390, t2391, t2392, t2393;
  double t2394, t2395, t2396, t2397, t2398, t2399, t2400, t2401;
  double t2402, t2403, t2404, t2405, t2406, t2407, t2408, t2409;
  double t2411, t2412, t2414, t2415, t2416, t2417, t2418, t2419;
  double t2420, t2422, t2423, t2424, t2425, t2426, t2427, t2428;
  double t2429, t2431, t2432, t2433, t2434, tv3rho30, t2451, t2452;
  double t2453, t2454, t2455, t2456, t2457, t2458, t2459, t2460;
  double t2461, t2462, t2463, t2464, t2467, t2469, t2470, t2471;
  double t2472, t2474, t2475, t2476, t2478, t2479, t2480, t2483;
  double t2485, t2486, t2488, t2491, t2493, t2494, t2496, t2497;
  double t2498, t2501, t2503, t2505, t2507, t2509, t2510, t2511;
  double t2513, t2514, t2516, t2517, t2519, t2520, t2522, t2524;
  double t2526, t2528, t2530, t2531, t2532, t2534, t2535, t2537;
  double t2538, t2540, t2541, t2543, t2544, t2545, t2546, t2547;
  double t2549, t2551, t2553, t2554, t2555, t2557, t2558, t2560;
  double t2561, t2563, t2564, t2565, t2567, t2569, t2571, t2573;
  double t2575, t2576, t2577, t2579, t2581, t2583, t2584, t2586;
  double t2588, t2590, t2592, t2593, t2596, t2597, t2599, t2601;
  double t2603, t2605, t2607, t2609, t2611, t2612, t2614, t2616;
  double t2618, t2619, t2621, t2622, t2625, t2628, t2629, t2633;
  double t2634, t2635, t2637, t2639, t2640, t2641, t2644, t2645;
  double t2646, t2650, t2654, t2655, t2657, t2658, t2660, t2662;
  double t2663, t2668, t2672, t2674, t2677, t2678, t2681, t2692;
  double t2693, t2696, t2707, t2709, t2712, t2714, t2716, t2718;
  double t2720, t2722, t2724, t2726, t2727, t2728, t2730, t2731;
  double t2734, t2736, t2737, t2739, t2741, t2743, t2744, t2748;
  double t2750, t2752, t2753, t2754, t2756, t2758, t2759, t2761;
  double t2763, t2764, t2767, t2768, t2770, t2771, t2774, t2776;
  double t2779, t2784, t2785, t2787, t2790, t2791, t2794, t2795;
  double t2798, t2799, t2802, t2803, t2804, t2805, t2806, t2807;
  double t2810, t2812, t2813, t2814, t2815, t2817, t2818, t2820;
  double t2822, t2824, t2825, t2827, t2828, t2830, t2834, t2835;
  double t2836, t2837, t2838, t2839, t2840, t2841, t2842, t2843;
  double t2844, tv3rho31, t2845, t2847, t2849, t2852, t2857, t2862;
  double t2866, t2867, t2872, t2875, t2879, t2881, t2882, t2884;
  double t2885, t2886, t2888, t2889, t2894, t2895, t2899, t2909;
  double t2915, t2917, t2919, t2920, t2922, t2923, t2925, t2927;
  double t2928, t2930, t2931, t2933, t2934, t2936, t2938, t2940;
  double t2944, t2946, t2947, t2950, t2951, t2953, t2957, t2959;
  double t2960, t2963, t2964, t2967, t2968, t2969, t2971, t2972;
  double t2973, t2975, t2977, t2978, t2979, t2981, t2983, t2984;
  double t2986, t2988, t2990, t2992, t2993, t2994, t2996, t2997;
  double t2998, t3000, t3001, t3002, t3004, t3005, t3006, t3008;
  double t3009, t3010, t3014, t3016, t3017, t3020, t3021, t3023;
  double t3025, t3027, t3028, t3031, t3032, t3034, t3036, t3037;
  double t3038, t3039, t3041, t3043, t3045, t3046, t3047, t3049;
  double t3051, t3053, t3055, t3057, t3059, t3061, t3063, t3064;
  double t3066, t3067, t3069, t3071, t3073, t3074, t3076, t3079;
  double t3081, t3086, t3087, t3091, t3094, t3095, t3098, t3099;
  double t3102, t3103, t3106, t3107, t3108, t3110, t3111, t3113;
  double t3114, t3115, t3116, t3118, t3119, t3120, t3122, t3123;
  double t3125, t3127, t3128, t3131, t3132, t3134, t3135, t3136;
  double t3137, t3138, t3139, t3141, t3142, t3143, t3145, t3146;
  double t3147, t3149, t3150, t3151, t3153, t3154, t3156, t3157;
  double t3159, t3160, t3162, t3163, t3164, t3166, t3167, t3168;
  double t3170, t3174, tv3rho32, t3175, t3176, t3177, t3178, t3179;
  double t3180, t3181, t3182, t3187, t3188, t3192, t3193, t3198;
  double t3202, t3204, t3211, t3216, t3218, t3227, t3229, t3231;
  double t3232, t3234, t3235, t3236, t3237, t3238, t3239, t3240;
  double t3242, t3243, t3245, t3246, t3247, t3249, t3250, t3252;
  double t3253, t3255, t3257, t3259, t3261, t3262, t3263, t3265;
  double t3266, t3268, t3269, t3270, t3272, t3273, t3274, t3276;
  double t3283, t3286, t3287, t3290, t3291, t3294, t3295, t3296;
  double t3297, t3298, t3299, t3300, t3301, t3302, t3303, t3304;
  double t3305, t3306, t3307, t3308, t3309, t3310, t3311, t3312;
  double t3313, t3314, t3315, t3317, t3318, t3319, t3324, t3325;
  double t3329, t3334, t3335, t3338, t3340, t3341, t3342, t3344;
  double t3345, t3346, t3348, t3349, t3350, t3351, t3352, t3353;
  double t3354, t3355, t3356, t3357, t3358, t3359, t3360, t3362;
  double t3363, t3364, t3365, t3366, t3367, t3369, t3370, t3372;
  double t3373, t3374, t3375, t3376, t3377, t3378, t3379, t3380;
  double t3381, t3382, tv3rho33, t3399, t3400, t3401, t3402, t3403;
  double t3404, t3405, t3406, t3407, t3408, t3409, t3410, t3411;
  double t3412, t3413, t3414, t3415, t3416, t3417, t3418, t3419;
  double t3420, t3421, t3422, t3423, t3424, t3425, t3426, t3427;
  double t3428, t3430, t3431, t3432, t3433, t3434, t3435, t3436;
  double t3437, t3438, t3440, t3441, t3442, t3444, t3445, t3446;
  double t3447, t3448, t3449, t3450, t3451, t3452, t3453, t3454;
  double t3455, t3456, t3457, t3458, t3459, t3460, t3461, t3462;
  double t3463, t3464, t3465, t3466, t3467, t3468, t3469, t3470;
  double t3471, t3472, t3473, t3474, t3475, t3476, t3477, t3478;
  double t3479, t3480, t3481, t3482, t3483, t3485, t3486, t3487;
  double t3488, t3489, t3490, t3491, t3492, t3493, t3494, t3495;
  double t3496, t3497, t3498, t3499, t3500, t3501, t3502, t3503;
  double t3504, t3505, t3506, t3507, t3508, t3509, t3510, t3511;
  double t3512, t3513, t3514, t3515, t3516, t3517, t3518, t3519;
  double t3520, t3521, t3522, t3523, t3525, t3526, t3527, t3528;
  double t3529, t3530, t3531, t3533, t3537, t3540, t3541, t3542;
  double t3544, t3545, t3549, t3550, t3551, t3552, t3553, t3554;
  double t3555, t3556, t3557, t3558, t3559, t3560, t3561, t3562;
  double t3563, t3564, t3565, t3566, t3567, t3568, t3569, t3570;
  double t3571, t3573, t3574, t3575, t3576, t3577, t3578, t3579;
  double t3580, t3581, t3582, t3584, t3585, t3586, t3588, t3589;
  double t3590, tv3rho2sigma0, t3596, t3597, t3598, t3599, t3600, t3601;
  double t3602, t3603, t3604, t3605, t3606, t3607, t3608, t3609;
  double t3610, t3611, t3612, t3613, t3620, t3621, t3622, t3623;
  double t3624, t3625, t3626, t3627, t3628, t3629, t3630, t3631;
  double t3633, t3634, t3635, t3636, t3637, t3638, t3639, t3640;
  double t3641, t3642, t3643, t3644, t3645, t3646, t3647, t3648;
  double t3649, t3650, t3651, t3652, t3653, t3654, t3655, t3656;
  double t3657, t3658, t3664, t3665, t3667, t3672, tv3rho2sigma1, tv3rho2sigma2;
  double t3678, t3680, t3681, t3683, t3684, t3686, t3687, t3688;
  double t3690, t3691, t3693, t3694, t3696, t3698, t3699, t3701;
  double t3702, t3703, t3705, t3707, t3709, t3711, t3712, t3714;
  double t3716, t3718, t3720, t3721, t3723, t3726, t3728, t3730;
  double t3732, t3734, t3735, t3736, t3738, t3739, t3741, t3742;
  double t3744, t3745, t3746, t3748, t3749, t3751, t3755, t3756;
  double t3757, t3760, t3762, t3763, t3765, t3766, t3767, t3769;
  double t3771, t3772, t3774, t3775, t3777, t3778, t3782, t3787;
  double t3788, t3790, t3791, t3792, t3794, t3795, t3796, t3797;
  double t3799, t3801, t3802, t3804, t3806, t3807, t3808, t3810;
  double t3811, t3812, t3814, t3815, t3817, t3819, t3821, t3824;
  double t3825, t3827, t3828, t3829, t3831, t3832, t3833, t3836;
  double t3837, t3838, t3840, t3842, t3844, t3846, t3853, t3854;
  double t3855, t3857, t3858, t3859, t3861, t3863, t3864, t3865;
  double t3867, t3868, t3869, t3870, t3872, t3874, t3878, t3879;
  double tv3rho2sigma3, t3880, t3881, t3882, t3883, t3884, t3885, t3886;
  double t3887, t3888, t3889, t3890, t3891, t3892, t3893, t3894;
  double t3895, t3896, t3897, t3898, t3899, t3900, t3901, t3902;
  double t3903, t3904, t3905, t3906, t3907, t3908, t3909, t3910;
  double t3911, t3912, t3913, t3915, t3916, t3917, t3918, t3922;
  double t3924, t3925, t3926, t3927, t3928, t3929, t3930, t3931;
  double t3932, t3933, t3934, t3935, t3936, t3937, t3938, t3939;
  double t3940, t3941, t3942, t3943, t3944, t3945, t3946, t3947;
  double t3951, tv3rho2sigma4, tv3rho2sigma5, t3952, t3953, t3954, t3955, t3957;
  double t3958, t3960, t3961, t3962, t3964, t3965, t3966, t3967;
  double t3968, t3969, t3970, t3971, t3972, t3973, t3974, t3975;
  double t3976, t3977, t3978, t3979, t3980, t3981, t3982, t3983;
  double t3984, t3985, t3986, t3987, t3988, t3989, t3990, t3991;
  double t3992, t3993, t3994, t3995, t3996, t3997, t3998, t4000;
  double t4001, t4002, t4003, t4004, t4005, t4006, t4007, t4008;
  double t4009, t4010, t4011, t4012, t4013, t4014, t4015, t4016;
  double t4017, t4018, t4019, t4020, t4021, t4022, t4023, t4024;
  double t4025, t4026, t4027, t4028, t4029, t4030, t4031, t4032;
  double t4034, t4036, t4038, t4040, t4041, t4042, t4044, t4045;
  double t4046, t4047, t4048, t4049, t4050, t4051, t4052, tv3rho2sigma6;
  double t4058, t4059, t4066, t4067, t4068, t4069, t4070, t4071;
  double t4072, t4073, t4074, t4075, t4076, t4077, t4078, t4079;
  double t4080, t4081, t4082, t4083, t4084, t4085, t4086, t4087;
  double t4088, t4089, t4091, t4092, t4093, t4094, t4095, t4096;
  double t4097, t4098, t4099, t4100, t4101, t4102, t4103, t4104;
  double t4105, t4106, t4107, t4108, t4109, t4110, t4111, t4112;
  double t4113, tv3rho2sigma7, tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4;
  double tv3rho2lapl5, t4129, t4130, t4131, t4132, t4133, t4134, t4135;
  double t4136, t4138, t4139, t4140, t4141, t4142, t4143, t4145;
  double t4146, t4147, t4149, t4150, t4151, t4153, t4154, t4155;
  double t4156, t4157, t4158, t4159, t4160, t4161, t4163, t4164;
  double t4165, t4166, t4167, t4168, t4169, t4170, t4171, t4172;
  double t4173, t4174, t4175, t4176, t4177, t4178, t4179, t4180;
  double t4181, t4182, t4183, t4184, t4185, t4186, t4187, t4188;
  double t4189, t4190, t4191, t4192, t4193, t4194, t4195, t4196;
  double t4197, t4199, t4200, t4201, t4203, t4204, t4205, t4206;
  double t4207, t4208, t4209, t4210, t4211, t4212, t4213, t4214;
  double t4215, t4216, t4217, t4218, t4219, t4220, t4222, t4223;
  double t4224, t4225, t4226, t4227, t4228, t4229, t4230, t4231;
  double t4232, t4233, t4234, t4235, t4236, t4237, t4238, t4239;
  double t4240, t4241, t4242, t4243, t4244, t4245, t4246, t4247;
  double t4248, t4249, t4250, t4251, t4252, t4253, t4254, t4255;
  double t4256, t4257, t4258, t4259, t4260, t4261, t4262, t4263;
  double t4264, t4265, t4266, t4267, t4268, t4269, t4270, t4271;
  double t4272, t4273, t4274, t4275, t4276, t4277, t4278, t4279;
  double t4280, t4281, t4282, t4283, t4284, t4285, t4286, t4288;
  double t4289, t4290, t4291, t4292, t4293, t4294, t4295, t4296;
  double t4297, t4298, t4299, t4300, t4301, t4302, t4303, t4304;
  double t4305, t4306, t4307, t4308, t4309, t4310, t4311, t4312;
  double t4313, t4314, t4316, t4317, t4318, t4319, t4320, t4321;
  double t4323, t4324, t4325, t4326, t4327, t4328, t4329, t4330;
  double t4331, t4332, t4333, t4334, t4335, t4336, t4337, t4338;
  double t4339, t4340, t4341, t4342, t4343, t4344, t4345, t4346;
  double t4347, t4348, t4349, t4350, t4351, t4352, t4353, t4354;
  double t4355, t4356, t4357, t4358, t4359, t4360, t4361, t4362;
  double t4363, t4364, t4365, t4366, t4367, t4368, t4369, t4370;
  double t4371, t4372, t4373, t4374, t4375, t4376, t4377, t4378;
  double t4379, t4380, t4381, t4382, t4383, t4384, t4385, t4386;
  double t4387, t4388, t4389, t4390, t4391, t4392, t4393, t4394;
  double t4395, t4396, t4397, t4398, t4399, t4400, t4401, t4402;
  double t4403, t4404, t4405, t4406, t4407, t4408, t4409, t4410;
  double t4411, t4412, t4413, t4414, t4415, t4416, t4417, t4418;
  double t4419, t4420, t4421, t4422, t4423, t4424, t4425, t4426;
  double t4427, t4430, t4433, t4436, t4440, t4441, t4448, t4451;
  double t4453, t4457, t4460, t4464, t4468, t4474, t4478, t4481;
  double t4485, t4486, t4487, t4488, t4489, t4490, t4491, t4492;
  double t4493, t4494, t4495, t4496, t4497, t4498, t4518, t4520;
  double t4523, tv3rho2tau0, t4524, t4525, t4526, t4527, t4528, t4530;
  double t4533, t4534, t4535, t4536, t4537, t4538, t4542, t4554;
  double t4558, t4559, t4562, t4563, t4567, t4571, t4572, t4573;
  double t4574, t4575, t4576, t4577, t4578, t4579, t4580, t4581;
  double t4582, t4583, t4584, t4585, t4586, t4587, t4588, t4589;
  double t4591, t4592, t4594, t4595, t4596, t4597, t4598, t4599;
  double t4600, t4601, t4602, t4603, t4604, t4605, t4606, t4607;
  double t4608, t4609, t4610, t4611, t4612, t4613, t4614, t4615;
  double t4616, t4617, t4618, t4619, t4620, t4621, t4622, t4623;
  double t4624, t4625, t4626, t4627, t4628, t4629, t4630, t4631;
  double t4632, t4633, t4634, t4635, t4636, t4637, t4638, t4639;
  double t4640, t4641, t4642, t4643, t4644, t4645, t4646, t4647;
  double t4648, t4649, t4650, t4652, t4653, t4655, t4656, t4657;
  double t4658, t4659, t4660, t4661, t4662, t4664, t4665, t4666;
  double t4667, t4668, t4669, t4670, t4671, t4672, t4673, t4674;
  double t4675, t4676, t4677, t4678, t4679, t4680, t4681, t4682;
  double t4683, t4684, t4685, t4686, t4687, t4688, t4689, t4690;
  double t4691, t4692, t4693, t4694, t4695, t4696, t4697, t4698;
  double t4699, t4700, t4701, t4702, t4703, t4704, t4705, t4706;
  double t4707, t4708, t4709, t4710, t4711, t4713, t4714, t4715;
  double t4716, t4717, t4718, t4719, t4720, t4721, t4722, t4723;
  double t4724, t4725, t4726, t4727, t4728, t4729, t4730, t4731;
  double t4732, t4733, t4734, t4735, t4736, t4737, t4738, t4739;
  double t4740, t4741, t4742, t4743, t4745, t4746, t4747, t4749;
  double t4750, t4751, t4753, t4754, t4755, t4756, t4757, t4758;
  double t4759, t4760, t4761, t4762, t4763, t4764, t4765, t4766;
  double t4783, t4785, tv3rho2tau1, t4787, t4788, t4789, t4791, t4792;
  double t4794, t4795, t4797, t4798, t4801, t4802, t4805, t4806;
  double t4808, t4809, t4810, t4813, t4814, t4817, t4818, t4820;
  double t4821, t4822, t4824, t4826, t4828, t4829, t4831, t4833;
  double t4834, t4835, t4836, t4838, t4839, t4840, t4841, t4843;
  double t4844, t4845, t4846, t4848, t4849, t4851, t4852, t4853;
  double t4855, t4856, t4857, t4859, t4860, t4861, t4863, t4864;
  double t4865, t4867, t4868, t4869, t4870, t4872, t4873, t4875;
  double t4876, t4878, t4880, t4881, t4883, t4884, t4885, t4887;
  double t4888, t4890, t4891, t4893, t4894, t4896, t4898, t4899;
  double t4900, t4901, t4903, t4904, t4905, t4907, t4908, t4909;
  double t4911, t4912, t4913, t4914, t4915, t4917, t4918, t4919;
  double t4921, t4922, t4924, t4925, t4926, t4928, t4929, t4930;
  double t4931, t4932, t4934, t4935, t4936, t4937, t4939, t4941;
  double t4942, t4943, t4944, t4946, t4948, t4950, t4951, t4954;
  double t4955, t4956, t4957, t4959, t4960, t4961, t4962, t4963;
  double t4965, t4967, t4969, t4970, t4971, t4973, t4975, t4976;
  double t4977, t4978, t4980, t4983, t4984, t4985, t4987, t4988;
  double t4989, t4991, t4993, t4995, t4996, t4998, t4999, t5000;
  double t5007, t5012, t5013, t5014, t5015, t5017, t5018, t5020;
  double t5021, t5023, t5024, t5025, t5027, t5028, t5030, t5034;
  double t5037, t5038, t5039, t5042, t5044, t5049, t5050, t5056;
  double t5059, t5061, t5063, t5069, t5072, t5076, t5082, t5083;
  double t5086, t5089, t5090, t5091, t5092, t5093, t5095, t5096;
  double t5098, t5100, t5101, t5102, t5104, t5105, t5106, t5108;
  double t5109, t5110, t5114, t5115, t5116, t5117, t5118, t5120;
  double t5121, t5122, t5123, t5125, t5126, t5129, t5132, t5135;
  double t5138, t5140, t5141, t5143, t5144, t5145, t5148, t5149;
  double t5152, t5153, t5155, t5157, t5159, t5161, t5162, t5165;
  double t5166, t5168, t5169, t5171, t5173, t5174, t5175, t5176;
  double t5177, t5178, t5180, t5182, t5183, t5185, t5186, t5191;
  double t5192, tv3rho2tau2, t5193, t5194, t5195, t5196, t5197, t5198;
  double t5200, t5202, t5203, t5205, t5207, t5209, t5211, t5213;
  double t5215, t5217, t5219, t5220, t5221, t5223, t5224, t5226;
  double t5227, t5228, t5230, t5232, t5233, t5235, t5237, t5240;
  double t5243, t5246, t5249, t5251, t5252, t5253, t5256, t5257;
  double t5259, t5260, t5261, t5262, t5264, t5265, t5267, t5268;
  double t5269, t5271, t5273, t5275, t5277, t5278, t5279, t5280;
  double t5283, t5286, t5288, t5289, t5292, t5293, t5296, t5297;
  double t5299, t5300, t5301, t5304, t5305, t5308, t5309, t5311;
  double t5312, t5313, t5315, t5316, t5319, t5323, t5326, t5327;
  double t5333, t5334, t5342, t5344, t5350, t5351, t5354, t5355;
  double t5358, t5359, t5366, t5373, t5374, t5380, t5382, t5384;
  double t5386, t5388, t5391, t5393, t5396, t5399, t5402, t5405;
  double t5408, t5411, t5413, t5414, t5415, t5416, t5418, t5419;
  double t5420, t5421, t5423, t5424, t5425, t5427, t5428, t5429;
  double t5430, t5432, t5433, t5434, t5435, t5437, t5438, t5440;
  double t5442, t5444, t5445, t5446, t5452, t5453, t5455, t5456;
  double t5458, t5459, t5461, t5462, t5463, t5464, t5466, t5467;
  double t5469, t5470, t5472, t5474, t5475, t5476, t5477, t5479;
  double t5481, t5482, t5484, t5485, t5486, t5488, t5489, t5490;
  double t5492, t5493, t5494, t5495, t5497, t5499, t5500, t5501;
  double t5503, t5504, t5506, t5507, t5510, t5512, t5513, t5515;
  double t5516, t5518, t5519, t5520, t5522, t5524, t5526, t5527;
  double t5528, t5530, t5532, t5533, t5534, t5536, t5537, t5538;
  double t5540, t5541, t5542, t5544, t5545, t5546, t5548, t5550;
  double t5551, t5552, t5553, t5555, t5556, t5557, t5559, t5560;
  double t5561, t5562, t5564, t5569, tv3rho2tau3, t5570, t5571, t5572;
  double t5573, t5574, t5575, t5576, t5577, t5578, t5579, t5580;
  double t5581, t5582, t5583, t5584, t5585, t5586, t5587, t5589;
  double t5590, t5591, t5593, t5594, t5595, t5597, t5598, t5599;
  double t5600, t5601, t5602, t5603, t5605, t5606, t5607, t5608;
  double t5609, t5610, t5611, t5612, t5613, t5614, t5615, t5616;
  double t5617, t5618, t5619, t5620, t5621, t5622, t5623, t5624;
  double t5625, t5626, t5627, t5628, t5629, t5630, t5631, t5632;
  double t5633, t5634, t5635, t5636, t5637, t5638, t5639, t5640;
  double t5641, t5642, t5643, t5644, t5645, t5646, t5647, t5648;
  double t5649, t5651, t5652, t5653, t5654, t5656, t5657, t5658;
  double t5660, t5661, t5662, t5664, t5665, t5666, t5667, t5668;
  double t5669, t5670, t5672, t5673, t5675, t5676, t5678, t5679;
  double t5680, t5681, t5682, t5683, t5684, t5685, t5686, t5687;
  double t5690, t5693, t5694, t5697, t5701, t5704, t5705, t5708;
  double t5709, t5712, t5716, t5723, t5724, t5725, t5726, t5727;
  double t5728, t5729, t5730, t5731, t5732, t5733, t5734, t5735;
  double t5736, t5737, t5738, t5739, t5740, t5741, t5742, t5743;
  double t5744, t5745, t5746, t5747, t5748, t5749, t5750, t5751;
  double t5752, t5753, t5754, t5755, t5756, t5757, t5758, t5759;
  double t5760, t5761, t5762, t5763, t5764, t5765, t5766, t5767;
  double t5768, t5769, t5770, t5771, t5772, t5773, t5774, t5775;
  double t5776, t5777, t5778, t5779, t5780, t5781, t5782, t5783;
  double t5784, tv3rho2tau4, t5803, t5804, t5805, t5806, t5808, t5809;
  double t5810, t5811, t5812, t5814, t5815, t5816, t5818, t5819;
  double t5820, t5821, t5822, t5823, t5824, t5826, t5827, t5829;
  double t5830, t5831, t5832, t5833, t5834, t5835, t5836, t5837;
  double t5838, t5839, t5840, t5841, t5842, t5843, t5844, t5845;
  double t5846, t5847, t5848, t5849, t5850, t5851, t5852, t5853;
  double t5854, t5855, t5856, t5857, t5858, t5860, t5861, t5862;
  double t5863, t5864, t5865, t5866, t5867, t5869, t5870, t5871;
  double t5872, t5873, t5874, t5875, t5876, t5877, t5878, t5879;
  double t5880, t5881, t5882, t5883, t5884, t5885, t5886, t5887;
  double t5888, t5889, t5890, t5891, t5892, t5893, t5894, t5895;
  double t5896, t5897, t5898, t5899, t5900, t5901, t5903, t5904;
  double t5905, t5907, t5908, t5909, t5911, t5912, t5913, t5914;
  double t5916, t5917, t5918, t5919, t5920, t5921, t5922, t5923;
  double t5924, t5925, t5926, t5927, t5928, t5929, t5930, t5931;
  double t5932, t5933, t5934, t5935, t5936, t5937, t5938, t5939;
  double t5940, t5941, t5942, t5943, t5944, t5945, t5946, t5947;
  double t5948, t5949, t5950, t5951, t5952, t5953, t5954, t5955;
  double t5956, t5958, t5959, t5960, t5961, t5962, t5963, t5964;
  double t5965, t5966, t5967, t5968, t5969, t5971, t5972, t5973;
  double t5975, t5976, t5977, t5978, t5979, t5980, t5981, t5982;
  double t5984, t5985, t5988, t5991, t5999, t6000, t6003, t6004;
  double t6008, t6009, t6012, t6015, t6021, t6022, t6027, t6033;
  double t6034, t6035, t6036, t6037, t6038, t6039, t6040, t6041;
  double t6042, t6043, t6044, t6045, t6046, t6047, t6048, t6049;
  double t6050, t6051, t6053, t6054, t6056, t6057, t6059, t6060;
  double t6061, t6062, t6063, t6064, t6065, t6088, tv3rho2tau5, t6090;
  double t6091, t6092, t6093, t6094, t6095, t6096, t6097, t6098;
  double t6099, t6100, t6101, t6102, t6104, t6105, t6106, t6107;
  double t6108, t6109, t6110, t6111, t6112, t6113, t6114, t6115;
  double t6116, t6117, t6118, t6119, t6120, t6121, t6122, t6123;
  double t6124, t6125, t6126, t6128, t6129, t6130, t6132, t6133;
  double t6135, t6136, t6137, t6139, t6140, t6141, t6142, t6143;
  double t6144, t6145, t6146, t6148, t6149, t6150, t6151, t6152;
  double t6154, t6155, t6156, t6157, t6158, t6159, t6160, t6161;
  double t6162, t6163, t6165, t6166, t6167, t6168, t6172, t6175;
  double t6176, t6177, t6178, t6179, t6180, tv3rhosigma20, t6182, t6183;
  double t6184, t6185, t6186, t6187, t6188, t6189, t6190, t6191;
  double t6192, t6193, t6194, t6195, t6196, t6197, t6198, t6199;
  double t6200, t6203, t6204, t6205, t6206, t6207, tv3rhosigma21, tv3rhosigma22;
  double t6209, t6210, t6211, t6212, t6213, t6214, t6215, t6216;
  double t6217, t6218, t6219, t6220, t6221, t6222, t6223, t6224;
  double t6225, t6226, t6227, t6230, t6231, t6232, t6233, t6234;
  double tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, t6236, t6237, t6238, t6239, t6240;
  double t6241, t6242, t6243, t6244, t6245, t6246, t6247, t6248;
  double t6249, t6250, t6251, t6253, t6254, t6255, t6257, t6258;
  double t6260, t6261, t6262, t6263, t6264, t6265, t6266, t6268;
  double t6269, t6270, t6271, t6272, t6273, t6274, t6275, t6277;
  double t6279, t6281, t6282, t6283, t6284, tv3rhosigma26, t6286, t6287;
  double t6288, t6289, t6290, t6291, t6292, t6293, t6294, t6295;
  double t6296, t6297, t6300, t6301, t6302, t6303, tv3rhosigma27, tv3rhosigma28;
  double t6305, t6306, t6307, t6308, t6309, t6310, t6311, t6312;
  double t6313, t6314, t6315, t6316, t6319, t6320, t6321, t6322;
  double tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4;
  double tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t6324;
  double t6325, t6326, t6327, t6328, t6329, t6330, t6331, t6332;
  double t6333, t6334, t6335, t6336, t6337, t6338, t6339, t6340;
  double t6341, t6342, t6343, t6344, t6345, t6346, t6347, t6348;
  double t6349, t6350, t6351, t6352, t6353, t6354, t6355, t6356;
  double t6357, t6358, t6359, t6360, t6361, t6362, t6363, t6364;
  double t6365, t6366, t6367, t6368, t6369, t6370, t6371, t6372;
  double t6373, t6374, t6375, t6376, t6377, t6378, t6379, t6380;
  double t6381, t6382, t6383, t6384, t6385, t6386, t6387, t6388;
  double t6389, t6390, t6391, t6392, t6393, t6394, t6395, t6396;
  double t6397, t6398, t6399, t6400, t6401, t6402, t6403, t6404;
  double t6405, t6406, t6407, t6408, t6409, t6410, t6411, t6412;
  double t6413, t6414, t6415, t6416, t6417, t6418, t6420, t6421;
  double t6422, t6423, t6424, t6425, t6426, t6427, t6428, t6429;
  double t6430, t6431, t6432, t6433, t6435, t6436, t6438, t6441;
  double t6442, t6443, t6445, t6446, t6449, t6451, t6452, t6454;
  double t6456, t6457, t6458, t6459, t6460, t6461, t6462, t6463;
  double t6464, t6465, t6466, t6467, t6468, t6469, t6470, t6471;
  double t6472, t6473, t6474, t6475, t6476, t6477, t6478, t6479;
  double t6480, t6481, t6482, t6483, t6484, t6485, t6486, t6487;
  double t6488, t6489, t6490, t6491, t6492, t6493, t6494, t6495;
  double t6496, t6497, t6498, t6499, t6500, t6501, t6502, t6503;
  double t6504, t6505, t6506, t6507, t6508, t6509, t6510, t6511;
  double t6512, t6513, t6514, t6515, t6516, t6517, t6518, t6519;
  double t6520, t6521, t6522, t6523, t6524, t6525, t6526, t6527;
  double t6528, t6529, t6530, t6531, t6532, t6533, t6534, t6535;
  double tv3rhosigmatau0, t6539, t6540, t6541, t6542, t6543, t6544, t6545;
  double t6546, t6547, t6548, t6549, t6550, t6551, t6552, t6553;
  double t6554, t6555, t6556, t6557, t6558, t6559, t6560, t6561;
  double t6562, t6563, t6564, t6565, t6566, t6567, t6568, t6569;
  double t6571, t6572, t6573, t6574, t6575, t6576, t6577, t6578;
  double t6579, t6580, t6581, t6582, t6583, t6584, t6585, t6586;
  double t6587, t6588, t6589, t6590, t6591, t6592, t6593, t6594;
  double t6595, t6596, t6597, t6598, t6599, t6600, t6601, t6602;
  double t6603, t6604, t6605, t6607, t6608, t6609, t6610, t6611;
  double t6612, t6613, t6614, t6615, t6616, t6617, t6618, t6619;
  double t6620, t6621, t6622, t6623, t6624, t6625, t6626, t6627;
  double t6628, t6630, t6631, t6632, t6633, t6635, t6636, t6637;
  double t6638, t6639, t6640, t6641, t6642, t6643, t6644, t6645;
  double t6646, t6647, t6649, t6650, t6651, t6652, t6653, t6654;
  double t6655, t6656, t6658, t6659, t6661, t6662, t6663, t6664;
  double t6665, t6667, t6669, t6670, t6672, t6673, t6676, t6678;
  double t6680, t6681, t6682, t6683, t6684, t6685, t6686, t6687;
  double t6688, t6689, tv3rhosigmatau1, t6693, t6697, t6701, t6702, t6703;
  double t6704, t6705, t6706, t6707, t6708, t6709, t6710, t6711;
  double t6712, t6713, t6714, t6715, t6716, t6717, t6718, t6719;
  double t6720, t6721, t6722, t6723, t6724, t6725, t6726, t6727;
  double t6728, t6730, t6731, t6732, t6733, t6734, t6735, t6736;
  double t6737, t6738, t6739, t6740, t6741, t6742, t6743, t6744;
  double t6745, t6746, t6747, t6748, t6749, t6750, t6751, t6752;
  double t6753, t6754, t6755, t6756, tv3rhosigmatau2, t6760, t6761, t6762;
  double t6763, t6764, t6765, t6766, t6767, t6768, t6769, t6771;
  double t6772, t6773, t6774, t6775, t6776, t6777, t6778, t6779;
  double t6780, t6781, t6782, t6784, t6785, t6786, t6787, t6788;
  double t6789, t6790, t6791, t6792, t6793, t6794, t6795, t6796;
  double t6797, t6798, t6799, t6800, t6801, t6802, t6803, t6806;
  double t6809, t6810, t6811, t6812, t6813, t6814, tv3rhosigmatau3, tv3rhosigmatau4;
  double tv3rhosigmatau5, t6818, t6819, t6820, t6821, t6822, t6823, t6824;
  double t6825, t6826, t6827, t6828, t6829, t6830, t6831, t6832;
  double t6833, t6834, t6835, t6836, t6837, t6838, t6839, t6840;
  double t6841, t6842, t6843, t6844, t6845, t6846, t6847, t6849;
  double t6850, t6851, t6852, t6853, t6854, t6855, t6856, t6857;
  double t6858, t6859, t6860, t6861, t6862, t6863, t6864, t6865;
  double t6867, t6869, t6870, t6871, t6873, t6874, t6875, t6877;
  double t6878, t6879, t6881, t6882, t6883, t6884, t6885, t6886;
  double t6887, t6888, t6889, t6890, t6891, t6892, t6893, t6894;
  double t6895, t6896, t6897, t6898, t6899, t6900, t6901, t6902;
  double t6903, t6904, t6905, t6906, t6907, t6908, t6909, t6910;
  double t6911, t6912, t6913, t6914, t6915, t6916, t6917, t6919;
  double t6920, t6921, t6922, t6923, t6924, t6925, t6926, t6927;
  double t6928, t6929, t6930, t6931, t6932, tv3rhosigmatau6, t6936, t6937;
  double t6938, t6939, t6940, t6941, t6942, t6943, t6944, t6945;
  double t6946, t6947, t6948, t6949, t6950, t6951, t6952, t6953;
  double t6954, t6955, t6956, t6957, t6958, t6959, t6960, t6961;
  double t6962, t6963, t6964, t6965, t6966, t6967, t6968, t6969;
  double t6970, t6971, t6972, t6973, t6974, t6976, t6977, t6978;
  double t6980, t6981, t6982, t6983, t6984, t6985, t6986, t6987;
  double t6988, t6990, t6991, t6992, t6993, t6994, t6995, t6996;
  double t6997, t6998, t6999, t7000, t7001, t7002, t7003, t7004;
  double t7005, t7006, t7007, t7008, t7009, t7010, t7011, t7012;
  double t7013, t7014, t7015, t7016, t7017, t7018, t7019, t7020;
  double t7021, t7022, t7023, t7024, t7025, t7026, t7027, t7028;
  double t7029, t7030, t7031, t7032, t7033, t7034, t7035, t7036;
  double t7038, t7039, t7041, t7043, t7044, t7045, t7048, t7051;
  double t7053, t7054, t7055, t7056, t7057, t7058, t7059, t7060;
  double t7061, t7062, t7063, t7064, t7065, t7066, t7067, t7068;
  double t7069, t7070, tv3rhosigmatau7, t7074, t7075, t7076, t7077, t7078;
  double t7079, t7080, t7081, t7082, t7083, t7085, t7086, t7087;
  double t7088, t7089, t7090, t7091, t7093, t7094, t7095, t7096;
  double t7097, t7098, t7099, t7100, t7101, t7102, t7103, t7104;
  double t7109, t7110, t7111, t7112, t7113, t7114, tv3rhosigmatau8, t7118;
  double t7119, t7120, t7121, t7122, t7123, t7124, t7125, t7126;
  double t7127, t7128, t7129, t7130, t7131, t7132, t7134, t7141;
  double t7142, t7143, t7144, t7145, t7146, t7147, t7148, t7149;
  double t7150, t7151, t7152, t7153, t7154, t7155, t7156, t7157;
  double t7158, t7159, t7160, t7161, t7162, t7163, t7164, t7165;
  double t7166, t7167, tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22;
  double tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4;
  double tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t7171, t7173, t7174, t7175, t7176;
  double t7177, t7178, t7179, t7180, t7181, t7182, t7183, t7184;
  double t7185, t7186, t7187, t7191, t7192, t7194, t7197, t7201;
  double t7204, t7205, t7208, t7212, t7213, t7214, t7215, t7216;
  double t7217, t7218, t7219, t7220, t7221, t7222, t7223, t7224;
  double t7225, t7226, t7227, t7228, t7229, t7230, t7231, t7232;
  double t7233, t7234, t7235, t7236, t7237, t7238, t7239, t7240;
  double t7241, t7243, t7244, t7245, t7246, t7247, t7248, t7249;
  double t7250, t7251, t7252, t7253, t7254, t7255, t7256, t7257;
  double t7258, t7259, t7260, t7261, t7262, t7263, t7264, t7265;
  double t7266, t7267, t7268, t7269, t7270, t7271, t7272, t7273;
  double t7274, t7275, t7276, t7277, t7278, t7279, t7280, t7281;
  double t7282, t7283, t7284, t7285, t7286, t7287, t7288, t7289;
  double t7290, t7291, t7292, t7293, t7294, t7295, t7296, t7297;
  double t7298, t7299, t7300, t7301, t7302, t7303, t7304, t7305;
  double t7306, t7307, t7308, t7309, t7310, t7311, t7312, t7313;
  double t7314, t7315, t7316, t7317, t7318, t7319, t7320, t7321;
  double t7322, t7323, t7324, t7325, t7326, t7327, t7328, t7329;
  double t7330, t7331, t7332, t7333, t7334, t7335, tv3rhotau20, t7338;
  double t7339, t7340, t7341, t7342, t7343, t7344, t7345, t7346;
  double t7347, t7348, t7349, t7350, t7351, t7352, t7353, t7354;
  double t7355, t7356, t7357, t7358, t7359, t7360, t7361, t7362;
  double t7363, t7364, t7365, t7366, t7367, t7368, t7369, t7370;
  double t7371, t7372, t7373, t7374, t7375, t7376, t7377, t7378;
  double t7379, t7380, t7381, t7382, t7383, t7384, t7385, t7388;
  double t7393, t7396, t7399, t7404, t7411, t7412, t7413, t7414;
  double t7415, t7416, t7417, t7418, t7419, t7421, t7422, t7423;
  double t7424, t7425, t7426, t7427, t7428, t7429, t7430, t7431;
  double t7432, t7433, t7434, t7435, t7436, t7437, t7438, t7439;
  double t7440, t7441, t7442, t7443, t7444, t7445, t7446, t7447;
  double t7448, t7449, t7450, t7451, t7452, t7453, t7454, t7455;
  double t7456, t7457, t7458, t7459, t7460, t7461, t7462, t7463;
  double t7464, t7465, t7466, t7467, t7468, t7469, t7470, t7471;
  double t7472, t7473, t7474, t7475, t7477, t7478, t7479, t7480;
  double t7481, t7482, t7483, t7484, t7485, t7486, t7487, t7488;
  double t7489, t7490, t7491, t7492, t7493, t7494, t7495, t7496;
  double t7497, t7498, t7499, t7500, t7501, t7502, t7503, t7504;
  double t7505, tv3rhotau21, t7508, t7509, t7510, t7511, t7513, t7514;
  double t7515, t7516, t7517, t7518, t7519, t7520, t7522, t7523;
  double t7524, t7525, t7526, t7527, t7529, t7530, t7532, t7533;
  double t7534, t7535, t7536, t7537, t7538, t7539, t7540, t7541;
  double t7543, t7552, t7553, t7556, t7557, t7558, t7559, t7560;
  double t7561, t7562, t7563, t7564, t7565, t7566, t7567, t7568;
  double t7569, t7570, t7571, t7572, t7573, t7574, t7575, t7576;
  double t7577, t7578, t7579, t7580, t7581, t7582, t7583, t7584;
  double t7585, t7586, t7587, t7588, t7589, t7590, t7591, t7592;
  double t7593, t7594, t7595, t7596, t7597, t7598, t7599, t7600;
  double t7601, t7602, t7603, t7604, t7605, t7606, t7607, t7608;
  double t7609, t7610, t7611, t7612, t7613, t7614, t7615, t7616;
  double t7617, t7618, t7619, t7620, t7621, t7622, t7623, t7624;
  double t7625, t7626, t7627, t7628, t7629, tv3rhotau22, t7632, t7633;
  double t7634, t7635, t7636, t7637, t7638, t7639, t7640, t7641;
  double t7642, t7643, t7644, t7645, t7646, t7647, t7648, t7649;
  double t7650, t7651, t7652, t7653, t7654, t7655, t7656, t7657;
  double t7658, t7659, t7660, t7661, t7662, t7663, t7664, t7665;
  double t7666, t7667, t7668, t7669, t7670, t7671, t7672, t7673;
  double t7674, t7675, t7676, t7677, t7678, t7679, t7680, t7681;
  double t7682, t7683, t7684, t7685, t7686, t7687, t7688, t7689;
  double t7690, t7691, t7692, t7693, t7694, t7695, t7696, t7697;
  double t7698, t7699, t7700, t7701, t7702, t7703, t7704, t7705;
  double t7706, t7708, t7711, t7714, t7715, t7718, t7722, t7723;
  double t7724, t7725, tv3rhotau23, t7728, t7729, t7730, t7731, t7732;
  double t7733, t7734, t7735, t7736, t7737, t7738, t7739, t7740;
  double t7741, t7742, t7743, t7744, t7745, t7746, t7747, t7748;
  double t7749, t7750, t7751, t7752, t7753, t7754, t7755, t7756;
  double t7757, t7758, t7759, t7760, t7761, t7762, t7763, t7764;
  double t7765, t7766, t7767, t7768, t7769, t7770, t7771, t7772;
  double t7773, t7774, t7775, t7776, t7777, t7778, t7779, t7780;
  double t7781, t7782, t7783, t7784, t7785, t7786, t7787, t7788;
  double t7789, t7790, t7791, t7792, t7793, t7794, t7795, t7796;
  double t7797, t7798, t7799, t7800, t7801, t7802, t7803, t7804;
  double t7805, t7806, t7807, t7808, t7809, t7810, t7811, t7812;
  double t7813, t7814, t7815, t7816, t7817, t7818, t7821, t7822;
  double t7825, t7828, t7831, t7843, t7844, t7845, t7846, t7847;
  double t7848, t7849, t7850, t7851, t7852, t7853, t7854, t7855;
  double t7856, tv3rhotau24, t7859, t7860, t7861, t7862, t7863, t7864;
  double t7865, t7866, t7867, t7868, t7869, t7871, t7872, t7873;
  double t7874, t7875, t7876, t7877, t7878, t7879, t7880, t7881;
  double t7882, t7883, t7884, t7885, t7886, t7888, t7889, t7890;
  double t7892, t7893, t7894, t7896, t7897, t7898, t7899, t7904;
  double t7909, t7913, t7917, t7918, t7921, t7922, t7923, t7924;
  double t7925, t7926, t7927, t7928, t7929, t7930, t7931, t7932;
  double t7933, t7934, t7935, t7936, t7937, t7938, t7939, t7940;
  double t7941, t7942, t7943, t7944, t7945, t7946, t7947, t7948;
  double t7949, t7950, t7952, t7953, t7955, t7956, t7957, t7958;
  double t7959, t7960, t7961, t7962, t7963, t7964, t7965, t7966;
  double t7967, t7968, t7969, t7970, t7971, t7972, t7973, t7974;
  double t7975, t7976, tv3rhotau25, t7979, t7980, t7981, t7982, t7983;
  double t7984, t7985, t7986, t7987, t7988, t7989, t7990, t7992;
  double t7993, t7994, t7995, t7996, t7997, t7998, t7999, t8002;
  double t8003, t8005, t8006, tv3sigma30, t8008, t8009, t8010, t8011;
  double t8014, t8015, tv3sigma31, tv3sigma32, t8017, t8018, t8019, t8020;
  double t8023, t8024, tv3sigma33, tv3sigma34, tv3sigma35, t8026, t8027, t8028;
  double t8029, t8032, t8033, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39, tv3sigma2lapl0;
  double tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8;
  double tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, t8035, t8036, t8037, t8038, t8039;
  double t8040, t8042, t8043, t8044, t8045, t8046, t8047, t8048;
  double t8049, t8050, t8051, t8052, t8053, t8054, t8055, t8056;
  double t8057, t8058, t8060, t8061, t8062, t8063, t8064, t8065;
  double t8066, t8067, t8068, t8070, t8071, t8072, t8074, t8075;
  double tv3sigma2tau0, t8077, t8078, t8079, t8080, t8081, t8082, t8083;
  double t8084, t8085, t8086, t8087, t8088, t8089, t8090, t8091;
  double t8092, t8093, t8094, t8095, t8096, t8097, t8098, t8099;
  double t8101, t8103, t8105, t8106, tv3sigma2tau1, t8108, t8109, t8110;
  double t8111, t8112, t8113, t8114, t8115, t8118, t8119, tv3sigma2tau2;
  double t8121, t8122, t8123, t8124, t8125, t8126, t8127, t8128;
  double t8131, t8132, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, t8134, t8135, t8136;
  double t8137, t8138, t8139, t8140, t8141, t8144, t8145, tv3sigma2tau6;
  double t8147, t8148, t8149, t8150, t8151, t8152, t8153, t8154;
  double t8157, t8158, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, tv3sigmalapl20;
  double tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, t8160, t8161, t8162, t8163;
  double t8164, t8165, t8166, t8167, t8168, t8169, t8170, t8171;
  double t8172, t8173, t8174, t8175, t8176, t8177, t8179, t8180;
  double t8181, t8182, t8183, t8184, t8185, t8186, t8187, t8188;
  double t8189, t8190, t8191, t8192, t8193, t8194, t8195, t8196;
  double t8197, t8198, t8199, t8200, t8201, t8202, t8203, t8204;
  double t8206, t8207, t8208, t8210, t8211, t8212, tv3sigmatau20, t8213;
  double t8214, t8215, t8216, t8217, t8218, t8219, t8220, t8221;
  double t8222, t8223, t8224, t8225, t8226, t8227, t8228, t8229;
  double t8230, t8231, t8232, t8234, t8235, t8236, t8237, t8238;
  double t8239, t8240, t8241, t8242, t8243, t8245, t8246, t8247;
  double t8248, t8249, t8250, t8251, t8252, t8253, t8254, t8256;
  double t8257, t8259, t8260, t8261, tv3sigmatau21, t8262, t8263, t8264;
  double t8265, t8266, t8267, t8268, t8269, t8270, t8271, t8272;
  double t8273, t8274, t8275, t8276, t8277, t8278, t8279, t8280;
  double t8281, t8282, t8283, t8284, t8285, t8286, t8287, t8288;
  double t8289, t8290, t8291, t8292, t8293, t8294, t8295, t8296;
  double t8298, t8300, t8302, t8303, t8304, tv3sigmatau22, t8305, t8306;
  double t8307, t8308, t8309, t8310, t8311, t8312, t8313, t8314;
  double t8315, t8318, t8319, t8320, tv3sigmatau23, t8321, t8322, t8323;
  double t8324, t8325, t8326, t8327, t8328, t8329, t8330, t8331;
  double t8334, t8335, t8336, tv3sigmatau24, t8337, t8338, t8339, t8340;
  double t8341, t8342, t8343, t8344, t8345, t8346, t8347, t8350;
  double t8351, t8352, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, tv3lapl30, tv3lapl31;
  double tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5;
  double tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, t8353, t8354;
  double t8355, t8356, t8357, t8358, t8359, t8361, t8362, t8363;
  double t8364, t8365, t8367, t8368, t8369, t8370, t8372, t8373;
  double t8375, t8377, t8378, t8379, t8380, t8381, t8383, t8384;
  double t8385, t8386, t8388, t8389, t8390, t8391, t8393, t8399;
  double t8400, tv3tau30, t8403, t8404, t8406, t8408, t8410, t8411;
  double t8413, t8414, t8415, t8416, t8418, t8419, t8420, t8422;
  double t8423, t8424, t8426, t8429, t8430, t8431, t8434, t8435;
  double tv3tau31, t8437, t8438, t8439, t8441, t8442, t8444, t8445;
  double t8446, t8448, t8450, t8451, t8453, t8454, t8455, t8457;
  double t8458, t8459, t8461, t8462, t8463, t8464, t8466, t8467;
  double t8471, t8472, t8473, t8474, t8477, t8478, tv3tau32, t8480;
  double t8481, t8482, t8483, t8484, t8485, t8486, t8488, t8489;
  double t8490, t8492, t8493, t8495, t8496, t8498, t8500, t8501;
  double t8502, t8503, t8504, t8506, t8507, t8508, t8509, t8511;
  double t8512, t8513, t8514, t8516, t8519, t8522, t8523, tv3tau33;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t7 = tau[0] * t6;
  t8 = rho[0] - rho[1];
  t9 = rho[0] + rho[1];
  t10 = 0.1e1 / t9;
  t11 = t8 * t10;
  t12 = 0.1e1 + t11;
  t13 = t12 / 0.2e1;
  t14 = POW_1_3(t13);
  t15 = t14 * t14;
  t16 = t15 * t13;
  t17 = t7 * t16;
  t18 = POW_1_3(rho[1]);
  t19 = t18 * t18;
  t21 = 0.1e1 / t19 / rho[1];
  t22 = tau[1] * t21;
  t23 = 0.1e1 - t11;
  t24 = t23 / 0.2e1;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = t26 * t24;
  t28 = t22 * t27;
  t30 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t31 = t9 * t9;
  t32 = POW_1_3(t9);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / t31;
  t38 = t17 + t28 - t30 * t35 / 0.8e1;
  t39 = t2 * t38;
  t40 = M_CBRT6;
  t41 = M_PI * M_PI;
  t42 = POW_1_3(t41);
  t43 = t42 * t42;
  t44 = 0.1e1 / t43;
  t45 = t40 * t44;
  t46 = t39 * t45;
  t47 = M_CBRT2;
  t48 = t47 * t47;
  t50 = t45 * t48;
  t53 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t38 * t50;
  t54 = 0.1e1 / t53;
  t55 = t48 * t54;
  t56 = t31 * t31;
  t58 = 0.1e1 / t33 / t56;
  t59 = t30 * t58;
  t60 = t17 + t28;
  t61 = 0.1e1 / t60;
  t62 = t8 * t8;
  t63 = t61 * t62;
  t66 = 0.1e1 - t59 * t63 / 0.8e1;
  t67 = M_CBRT3;
  t68 = 0.1e1 / M_PI;
  t69 = POW_1_3(t68);
  t70 = t67 * t69;
  t71 = M_CBRT4;
  t72 = t71 * t71;
  t75 = t70 * t72 / t32;
  t77 = 0.1e1 + 0.53425e-1 * t75;
  t78 = sqrt(t75);
  t81 = POW_3_2(t75);
  t83 = t67 * t67;
  t84 = t69 * t69;
  t85 = t83 * t84;
  t88 = t85 * t71 / t33;
  t90 = 0.379785e1 * t78 + 0.8969e0 * t75 + 0.204775e0 * t81 + 0.123235e0 * t88;
  t93 = 0.1e1 + 0.16081979498692535067e2 / t90;
  t94 = log(t93);
  t96 = 0.621814e-1 * t77 * t94;
  t97 = t62 * t62;
  t98 = 0.1e1 / t56;
  t99 = t97 * t98;
  t100 = t12 <= p->zeta_threshold;
  t101 = POW_1_3(p->zeta_threshold);
  t102 = t101 * p->zeta_threshold;
  t103 = POW_1_3(t12);
  t105 = my_piecewise3(t100, t102, t103 * t12);
  t106 = t23 <= p->zeta_threshold;
  t107 = POW_1_3(t23);
  t109 = my_piecewise3(t106, t102, t107 * t23);
  t110 = t105 + t109 - 0.2e1;
  t113 = 0.1e1 / (0.2e1 * t47 - 0.2e1);
  t114 = t110 * t113;
  t116 = 0.1e1 + 0.5137e-1 * t75;
  t121 = 0.705945e1 * t78 + 0.1549425e1 * t75 + 0.420775e0 * t81 + 0.1562925e0 * t88;
  t124 = 0.1e1 + 0.32163958997385070134e2 / t121;
  t125 = log(t124);
  t129 = 0.1e1 + 0.278125e-1 * t75;
  t134 = 0.51785e1 * t78 + 0.905775e0 * t75 + 0.1100325e0 * t81 + 0.1241775e0 * t88;
  t137 = 0.1e1 + 0.29608749977793437516e2 / t134;
  t138 = log(t137);
  t139 = t129 * t138;
  t141 = -0.310907e-1 * t116 * t125 + t96 - 0.19751673498613801407e-1 * t139;
  t142 = t114 * t141;
  t146 = -t96 + t99 * t142 + 0.19751673498613801407e-1 * t114 * t139;
  t147 = t66 * t146;
  t148 = t55 * t147;
  t150 = 0.5e1 / 0.9e1 * t46 * t148;
  t151 = t39 * t40;
  t152 = t44 * t48;
  t153 = t152 * t54;
  t154 = t151 * t153;
  t156 = 0.1e1 - 0.5e1 / 0.9e1 * t154;
  t157 = t156 * t146;
  tzk0 = t150 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = rho[0] * rho[0];
  t160 = 0.1e1 / t4 / t158;
  t161 = tau[0] * t160;
  t162 = t161 * t16;
  t164 = 0.1e1 / t31;
  t165 = t8 * t164;
  t166 = t10 - t165;
  t167 = t166 / 0.2e1;
  t168 = t15 * t167;
  t169 = t7 * t168;
  t171 = -t167;
  t172 = t26 * t171;
  t173 = t22 * t172;
  t175 = t31 * t9;
  t177 = 0.1e1 / t33 / t175;
  t179 = t30 * t177 / 0.3e1;
  t180 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173 + t179;
  t181 = t2 * t180;
  t182 = t181 * t45;
  t183 = t182 * t148;
  t184 = 0.5e1 / 0.9e1 * t183;
  t185 = t40 * t40;
  t187 = 0.1e1 / t42 / t41;
  t188 = t185 * t187;
  t189 = t188 * t47;
  t190 = t39 * t189;
  t191 = t53 * t53;
  t192 = 0.1e1 / t191;
  t193 = t192 * t66;
  t194 = t146 * params->c;
  t195 = t194 * t180;
  t196 = t193 * t195;
  t197 = t190 * t196;
  t198 = 0.5e2 / 0.81e2 * t197;
  t199 = t56 * t9;
  t201 = 0.1e1 / t33 / t199;
  t202 = t30 * t201;
  t204 = 0.7e1 / 0.12e2 * t202 * t63;
  t205 = t60 * t60;
  t206 = 0.1e1 / t205;
  t207 = t206 * t62;
  t209 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173;
  t210 = t207 * t209;
  t213 = t61 * t8;
  t215 = t59 * t213 / 0.4e1;
  t216 = t204 + t59 * t210 / 0.8e1 - t215;
  t217 = t216 * t146;
  t218 = t55 * t217;
  t219 = t46 * t218;
  t220 = 0.5e1 / 0.9e1 * t219;
  t222 = 0.1e1 / t32 / t9;
  t223 = t72 * t222;
  t226 = 0.11073470983333333333e-2 * t70 * t223 * t94;
  t227 = t90 * t90;
  t228 = 0.1e1 / t227;
  t229 = t77 * t228;
  t231 = 0.1e1 / t78 * t67;
  t232 = t69 * t72;
  t233 = t232 * t222;
  t234 = t231 * t233;
  t236 = t70 * t223;
  t238 = sqrt(t75);
  t239 = t238 * t67;
  t240 = t239 * t233;
  t245 = t85 * t71 / t33 / t9;
  t247 = -0.632975e0 * t234 - 0.29896666666666666667e0 * t236 - 0.1023875e0 * t240 - 0.82156666666666666667e-1 * t245;
  t248 = 0.1e1 / t93;
  t249 = t247 * t248;
  t251 = 0.1e1 * t229 * t249;
  t252 = t62 * t8;
  t253 = t252 * t98;
  t255 = 0.4e1 * t253 * t142;
  t256 = 0.1e1 / t199;
  t257 = t97 * t256;
  t259 = 0.4e1 * t257 * t142;
  t262 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t166);
  t263 = -t166;
  t266 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t263);
  t268 = (t262 + t266) * t113;
  t269 = t268 * t141;
  t274 = t121 * t121;
  t275 = 0.1e1 / t274;
  t276 = t116 * t275;
  t281 = -0.1176575e1 * t234 - 0.516475e0 * t236 - 0.2103875e0 * t240 - 0.104195e0 * t245;
  t282 = 0.1e1 / t124;
  t283 = t281 * t282;
  t289 = t134 * t134;
  t290 = 0.1e1 / t289;
  t291 = t129 * t290;
  t296 = -0.86308333333333333334e0 * t234 - 0.301925e0 * t236 - 0.5501625e-1 * t240 - 0.82785e-1 * t245;
  t297 = 0.1e1 / t137;
  t298 = t296 * t297;
  t301 = 0.53237641966666666666e-3 * t70 * t223 * t125 + 0.1e1 * t276 * t283 - t226 - t251 + 0.18311447306006545054e-3 * t70 * t223 * t138 + 0.5848223622634646207e0 * t291 * t298;
  t302 = t114 * t301;
  t303 = t99 * t302;
  t306 = t114 * t67;
  t308 = t232 * t222 * t138;
  t310 = 0.18311447306006545054e-3 * t306 * t308;
  t311 = t114 * t129;
  t313 = t290 * t296 * t297;
  t315 = 0.5848223622634646207e0 * t311 * t313;
  t316 = t226 + t251 + t255 - t259 + t99 * t269 + t303 + 0.19751673498613801407e-1 * t268 * t139 - t310 - t315;
  t317 = t66 * t316;
  t318 = t55 * t317;
  t319 = t46 * t318;
  t320 = 0.5e1 / 0.9e1 * t319;
  t321 = t181 * t40;
  t322 = t321 * t153;
  t324 = t39 * t188;
  t325 = t47 * t192;
  t326 = params->c * t180;
  t327 = t325 * t326;
  t330 = -0.5e1 / 0.9e1 * t322 + 0.5e2 / 0.81e2 * t324 * t327;
  t331 = t330 * t146;
  t332 = t156 * t316;
  tvrho0 = t150 + t157 + t9 * (t184 - t198 + t220 + t320 + t331 + t332);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t335 = -t10 - t165;
  t336 = t335 / 0.2e1;
  t337 = t15 * t336;
  t338 = t7 * t337;
  t340 = rho[1] * rho[1];
  t342 = 0.1e1 / t19 / t340;
  t343 = tau[1] * t342;
  t344 = t343 * t27;
  t346 = -t336;
  t347 = t26 * t346;
  t348 = t22 * t347;
  t350 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348 + t179;
  t351 = t2 * t350;
  t352 = t351 * t45;
  t353 = t352 * t148;
  t354 = 0.5e1 / 0.9e1 * t353;
  t355 = t194 * t350;
  t356 = t193 * t355;
  t357 = t190 * t356;
  t358 = 0.5e2 / 0.81e2 * t357;
  t360 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348;
  t361 = t207 * t360;
  t364 = t204 + t59 * t361 / 0.8e1 + t215;
  t365 = t364 * t146;
  t366 = t55 * t365;
  t367 = t46 * t366;
  t368 = 0.5e1 / 0.9e1 * t367;
  t371 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t335);
  t372 = -t335;
  t375 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t372);
  t377 = (t371 + t375) * t113;
  t378 = t377 * t141;
  t382 = t226 + t251 - t255 - t259 + t99 * t378 + t303 + 0.19751673498613801407e-1 * t377 * t139 - t310 - t315;
  t383 = t66 * t382;
  t384 = t55 * t383;
  t385 = t46 * t384;
  t386 = 0.5e1 / 0.9e1 * t385;
  t387 = t351 * t40;
  t388 = t387 * t153;
  t390 = params->c * t350;
  t391 = t325 * t390;
  t394 = -0.5e1 / 0.9e1 * t388 + 0.5e2 / 0.81e2 * t324 * t391;
  t395 = t394 * t146;
  t396 = t156 * t382;
  tvrho1 = t150 + t157 + t9 * (t354 - t358 + t368 + t386 + t395 + t396);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t399 = t2 * t35;
  t400 = t399 * t45;
  t401 = t400 * t148;
  t402 = 0.5e1 / 0.72e2 * t401;
  t403 = t194 * t35;
  t405 = t190 * t193 * t403;
  t406 = 0.25e2 / 0.324e3 * t405;
  t407 = t39 * t50;
  t408 = t54 * t58;
  t409 = t63 * t146;
  t410 = t408 * t409;
  t411 = t407 * t410;
  t412 = 0.5e1 / 0.72e2 * t411;
  t414 = t399 * t40 * t153;
  t416 = params->c * t35;
  t418 = t324 * t325 * t416;
  t420 = 0.5e1 / 0.72e2 * t414 - 0.25e2 / 0.324e3 * t418;
  t421 = t420 * t146;
  tvsigma0 = t9 * (-t402 + t406 - t412 + t421);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t423 = 0.5e1 / 0.36e2 * t401;
  t424 = 0.25e2 / 0.162e3 * t405;
  t425 = 0.5e1 / 0.36e2 * t411;
  t428 = 0.5e1 / 0.36e2 * t414 - 0.25e2 / 0.162e3 * t418;
  t429 = t428 * t146;
  tvsigma1 = t9 * (-t423 + t424 - t425 + t429);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t431 = t2 * t6;
  t432 = t16 * t40;
  t433 = t431 * t432;
  t434 = t54 * t66;
  t435 = t434 * t146;
  t436 = t152 * t435;
  t438 = 0.5e1 / 0.9e1 * t433 * t436;
  t439 = t193 * t146;
  t440 = params->c * t6;
  t441 = t440 * t16;
  t442 = t439 * t441;
  t444 = 0.5e2 / 0.81e2 * t190 * t442;
  t445 = t59 * t206;
  t446 = t62 * t6;
  t447 = t16 * t146;
  t448 = t446 * t447;
  t449 = t445 * t448;
  t451 = 0.5e1 / 0.72e2 * t154 * t449;
  t452 = t431 * t16;
  t453 = t45 * t55;
  t456 = t325 * t441;
  t459 = -0.5e1 / 0.9e1 * t452 * t453 + 0.5e2 / 0.81e2 * t324 * t456;
  t460 = t459 * t146;
  tvtau0 = t9 * (t438 - t444 + t451 + t460);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t462 = t2 * t21;
  t463 = t27 * t40;
  t464 = t462 * t463;
  t466 = 0.5e1 / 0.9e1 * t464 * t436;
  t467 = params->c * t21;
  t468 = t467 * t27;
  t471 = 0.5e2 / 0.81e2 * t190 * t439 * t468;
  t472 = t62 * t21;
  t473 = t27 * t146;
  t474 = t472 * t473;
  t475 = t445 * t474;
  t477 = 0.5e1 / 0.72e2 * t154 * t475;
  t478 = t462 * t27;
  t479 = t478 * t453;
  t484 = -0.5e1 / 0.9e1 * t479 + 0.5e2 / 0.81e2 * t324 * t325 * t468;
  t485 = t484 * t146;
  tvtau1 = t9 * (t466 - t471 + t477 + t485);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t493 = t158 * rho[0];
  t495 = 0.1e1 / t4 / t493;
  t496 = tau[0] * t495;
  t498 = 0.4e2 / 0.9e1 * t496 * t16;
  t500 = 0.5e2 / 0.9e1 * t161 * t168;
  t501 = 0.1e1 / t14;
  t502 = t167 * t167;
  t503 = t501 * t502;
  t505 = 0.1e2 / 0.9e1 * t7 * t503;
  t506 = 0.1e1 / t175;
  t507 = t8 * t506;
  t508 = -t164 + t507;
  t509 = t15 * t508;
  t511 = 0.5e1 / 0.3e1 * t7 * t509;
  t512 = 0.1e1 / t25;
  t513 = t171 * t171;
  t514 = t512 * t513;
  t516 = 0.1e2 / 0.9e1 * t22 * t514;
  t517 = -t508;
  t518 = t26 * t517;
  t520 = 0.5e1 / 0.3e1 * t22 * t518;
  t521 = 0.11e2 / 0.9e1 * t59;
  t522 = t498 - t500 + t505 + t511 + t516 + t520 - t521;
  t523 = t2 * t522;
  t524 = t523 * t45;
  t525 = t524 * t148;
  t526 = 0.5e1 / 0.9e1 * t525;
  t527 = t180 * t180;
  t528 = t2 * t527;
  t529 = t528 * t188;
  t530 = t147 * params->c;
  t531 = t325 * t530;
  t532 = t529 * t531;
  t533 = 0.1e3 / 0.81e2 * t532;
  t534 = t182 * t218;
  t535 = 0.1e2 / 0.9e1 * t534;
  t536 = t182 * t318;
  t537 = 0.1e2 / 0.9e1 * t536;
  t538 = t41 * t41;
  t539 = 0.1e1 / t538;
  t541 = 0.1e1 / t191 / t53;
  t542 = t539 * t541;
  t543 = t39 * t542;
  t544 = params->c * params->c;
  t545 = t544 * t527;
  t546 = t147 * t545;
  t547 = t543 * t546;
  t548 = 0.2e4 / 0.243e3 * t547;
  t549 = t192 * t216;
  t550 = t549 * t195;
  t551 = t190 * t550;
  t552 = 0.1e3 / 0.81e2 * t551;
  t553 = t316 * params->c;
  t554 = t553 * t180;
  t555 = t193 * t554;
  t556 = t190 * t555;
  t557 = 0.1e3 / 0.81e2 * t556;
  t558 = t194 * t522;
  t559 = t193 * t558;
  t560 = t190 * t559;
  t561 = 0.5e2 / 0.81e2 * t560;
  t562 = t56 * t31;
  t564 = 0.1e1 / t33 / t562;
  t565 = t30 * t564;
  t567 = 0.119e3 / 0.36e2 * t565 * t63;
  t568 = t202 * t210;
  t571 = 0.7e1 / 0.3e1 * t202 * t213;
  t573 = 0.1e1 / t205 / t60;
  t574 = t573 * t62;
  t575 = t209 * t209;
  t576 = t574 * t575;
  t579 = t206 * t8;
  t580 = t579 * t209;
  t581 = t59 * t580;
  t583 = t498 - t500 + t505 + t511 + t516 + t520;
  t584 = t207 * t583;
  t588 = t59 * t61 / 0.4e1;
  t589 = -t567 - 0.7e1 / 0.6e1 * t568 + t571 - t59 * t576 / 0.4e1 + t581 / 0.2e1 + t59 * t584 / 0.8e1 - t588;
  t590 = t589 * t146;
  t591 = t55 * t590;
  t592 = t46 * t591;
  t593 = 0.5e1 / 0.9e1 * t592;
  t594 = t216 * t316;
  t595 = t55 * t594;
  t596 = t46 * t595;
  t597 = 0.1e2 / 0.9e1 * t596;
  t598 = t289 * t289;
  t599 = 0.1e1 / t598;
  t600 = t296 * t296;
  t601 = t599 * t600;
  t602 = t137 * t137;
  t603 = 0.1e1 / t602;
  t604 = t601 * t603;
  t606 = 0.17315859105681463759e2 * t311 * t604;
  t609 = 0.1e1 / t78 / t75 * t83;
  t610 = t84 * t71;
  t611 = t610 * t35;
  t612 = t609 * t611;
  t615 = 0.1e1 / t32 / t31;
  t616 = t232 * t615;
  t617 = t231 * t616;
  t619 = t72 * t615;
  t620 = t70 * t619;
  t622 = 0.1e1/sqrt(t75);
  t623 = t622 * t83;
  t624 = t623 * t611;
  t626 = t239 * t616;
  t629 = t85 * t71 * t35;
  t631 = -0.57538888888888888889e0 * t612 + 0.11507777777777777778e1 * t617 + 0.40256666666666666667e0 * t620 + 0.366775e-1 * t624 + 0.73355e-1 * t626 + 0.137975e0 * t629;
  t633 = t290 * t631 * t297;
  t635 = 0.5848223622634646207e0 * t311 * t633;
  t636 = t268 * t129;
  t637 = t636 * t313;
  t639 = t103 * t103;
  t640 = 0.1e1 / t639;
  t641 = t166 * t166;
  t644 = 0.2e1 * t508;
  t648 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t641 + 0.4e1 / 0.3e1 * t103 * t644);
  t649 = t107 * t107;
  t650 = 0.1e1 / t649;
  t651 = t263 * t263;
  t654 = -t644;
  t658 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t651 + 0.4e1 / 0.3e1 * t107 * t654);
  t660 = (t648 + t658) * t113;
  t664 = t232 * t615 * t138;
  t666 = 0.24415263074675393405e-3 * t306 * t664;
  t670 = t70 * t72;
  t671 = t222 * t275;
  t675 = t274 * t121;
  t676 = 0.1e1 / t675;
  t677 = t116 * t676;
  t678 = t281 * t281;
  t679 = t678 * t282;
  t688 = -0.78438333333333333333e0 * t612 + 0.15687666666666666667e1 * t617 + 0.68863333333333333333e0 * t620 + 0.14025833333333333333e0 * t624 + 0.28051666666666666667e0 * t626 + 0.17365833333333333333e0 * t629;
  t689 = t688 * t282;
  t692 = t274 * t274;
  t693 = 0.1e1 / t692;
  t694 = t116 * t693;
  t695 = t124 * t124;
  t696 = 0.1e1 / t695;
  t697 = t678 * t696;
  t702 = 0.14764627977777777777e-2 * t70 * t619 * t94;
  t703 = t222 * t228;
  t706 = 0.35616666666666666666e-1 * t670 * t703 * t249;
  t707 = t227 * t90;
  t708 = 0.1e1 / t707;
  t709 = t77 * t708;
  t710 = t247 * t247;
  t711 = t710 * t248;
  t713 = 0.2e1 * t709 * t711;
  t720 = -0.42198333333333333333e0 * t612 + 0.84396666666666666666e0 * t617 + 0.39862222222222222223e0 * t620 + 0.68258333333333333333e-1 * t624 + 0.13651666666666666667e0 * t626 + 0.13692777777777777778e0 * t629;
  t721 = t720 * t248;
  t723 = 0.1e1 * t229 * t721;
  t724 = t227 * t227;
  t725 = 0.1e1 / t724;
  t726 = t77 * t725;
  t727 = t93 * t93;
  t728 = 0.1e1 / t727;
  t729 = t710 * t728;
  t731 = 0.16081979498692535067e2 * t726 * t729;
  t735 = t222 * t290;
  t739 = t289 * t134;
  t740 = 0.1e1 / t739;
  t741 = t129 * t740;
  t742 = t600 * t297;
  t745 = t631 * t297;
  t748 = t129 * t599;
  t749 = t600 * t603;
  t752 = -0.70983522622222222221e-3 * t70 * t619 * t125 - 0.34246666666666666666e-1 * t670 * t671 * t283 - 0.2e1 * t677 * t679 + 0.1e1 * t276 * t689 + 0.32163958997385070134e2 * t694 * t697 + t702 + t706 + t713 - t723 - t731 - 0.24415263074675393405e-3 * t70 * t619 * t138 - 0.10843581300301739842e-1 * t670 * t735 * t298 - 0.11696447245269292414e1 * t741 * t742 + 0.5848223622634646207e0 * t291 * t745 + 0.17315859105681463759e2 * t748 * t749;
  t753 = t114 * t752;
  t754 = t99 * t753;
  t755 = t660 * t141;
  t757 = t268 * t301;
  t758 = t99 * t757;
  t760 = t257 * t269;
  t763 = 0.8e1 * t257 * t302;
  t764 = t253 * t269;
  t766 = -t606 - t635 - 0.11696447245269292414e1 * t637 + 0.19751673498613801407e-1 * t660 * t139 + t666 + t754 + t99 * t755 + 0.2e1 * t758 - 0.8e1 * t760 - t763 + 0.8e1 * t764;
  t768 = 0.8e1 * t253 * t302;
  t769 = 0.1e1 / t562;
  t770 = t97 * t769;
  t772 = 0.2e2 * t770 * t142;
  t773 = t62 * t98;
  t775 = 0.12e2 * t773 * t142;
  t776 = t252 * t256;
  t778 = 0.32e2 * t776 * t142;
  t779 = t114 * t70;
  t780 = t223 * t313;
  t782 = 0.10843581300301739842e-1 * t779 * t780;
  t783 = t268 * t67;
  t784 = t783 * t308;
  t787 = t740 * t600 * t297;
  t789 = 0.11696447245269292414e1 * t311 * t787;
  t790 = t768 - t713 + t772 + t775 - t778 - t702 + t723 + t731 + t782 - 0.36622894612013090108e-3 * t784 + t789 - t706;
  t791 = t766 + t790;
  t792 = t66 * t791;
  t793 = t55 * t792;
  t794 = t46 * t793;
  t795 = 0.5e1 / 0.9e1 * t794;
  t796 = t523 * t40;
  t797 = t796 * t153;
  t799 = t528 * t185;
  t800 = t187 * t47;
  t801 = t192 * params->c;
  t802 = t800 * t801;
  t805 = t39 * t539;
  t806 = t541 * t544;
  t807 = t806 * t527;
  t810 = params->c * t522;
  t811 = t325 * t810;
  t814 = -0.5e1 / 0.9e1 * t797 + 0.1e3 / 0.81e2 * t799 * t802 - 0.2e4 / 0.243e3 * t805 * t807 + 0.5e2 / 0.81e2 * t324 * t811;
  t815 = t814 * t146;
  t816 = t330 * t316;
  t817 = 0.2e1 * t816;
  t818 = t156 * t791;
  t819 = t526 - t533 + t535 + t537 + t548 - t552 - t557 - t561 + t593 + t597 + t795 + t815 + t817 + t818;
  tv2rho20 = 0.1e2 / 0.9e1 * t183 - 0.1e3 / 0.81e2 * t197 + 0.1e2 / 0.9e1 * t219 + 0.1e2 / 0.9e1 * t319 + 0.2e1 * t331 + 0.2e1 * t332 + t9 * t819;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t822 = 0.25e2 / 0.9e1 * t161 * t337;
  t823 = t501 * t336;
  t824 = t823 * t167;
  t826 = 0.1e2 / 0.9e1 * t7 * t824;
  t827 = t15 * t8;
  t828 = t827 * t506;
  t830 = 0.5e1 / 0.3e1 * t7 * t828;
  t832 = 0.25e2 / 0.9e1 * t343 * t172;
  t833 = t512 * t346;
  t834 = t833 * t171;
  t836 = 0.1e2 / 0.9e1 * t22 * t834;
  t837 = t26 * t8;
  t838 = t837 * t506;
  t840 = 0.5e1 / 0.3e1 * t22 * t838;
  t841 = -t822 + t826 + t830 - t832 + t836 - t840 - t521;
  t842 = t2 * t841;
  t843 = t842 * t45;
  t844 = t843 * t148;
  t846 = t351 * t189;
  t847 = t846 * t196;
  t849 = t352 * t218;
  t851 = t352 * t318;
  t853 = t544 * t350;
  t854 = t853 * t180;
  t855 = t147 * t854;
  t856 = t543 * t855;
  t858 = t549 * t355;
  t859 = t190 * t858;
  t861 = t553 * t350;
  t862 = t193 * t861;
  t863 = t190 * t862;
  t865 = t194 * t841;
  t866 = t193 * t865;
  t867 = t190 * t866;
  t869 = t182 * t366;
  t871 = t192 * t364;
  t872 = t871 * t195;
  t873 = t190 * t872;
  t876 = t202 * t361;
  t878 = t59 * t573;
  t879 = t62 * t360;
  t880 = t879 * t209;
  t883 = t579 * t360;
  t884 = t59 * t883;
  t886 = -t822 + t826 + t830 - t832 + t836 - t840;
  t887 = t207 * t886;
  t891 = -t567 - 0.7e1 / 0.12e2 * t568 - 0.7e1 / 0.12e2 * t876 - t878 * t880 / 0.4e1 + t884 / 0.4e1 + t59 * t887 / 0.8e1 - t581 / 0.4e1 + t588;
  t892 = t891 * t146;
  t893 = t55 * t892;
  t894 = t46 * t893;
  t896 = t364 * t316;
  t897 = t55 * t896;
  t898 = t46 * t897;
  t900 = t182 * t384;
  t902 = t382 * params->c;
  t903 = t902 * t180;
  t904 = t193 * t903;
  t905 = t190 * t904;
  t907 = t216 * t382;
  t908 = t55 * t907;
  t909 = t46 * t908;
  t911 = t377 * t129;
  t912 = t911 * t313;
  t915 = t377 * t67;
  t916 = t915 * t308;
  t919 = -0.5848223622634646207e0 * t912 + t789 - t635 - 0.5848223622634646207e0 * t637 + t772 - t775 - t606 + t782 + t731 - 0.18311447306006545054e-3 * t916 - t763 - 0.4e1 * t764 + t666;
  t921 = t253 * t378;
  t923 = t257 * t378;
  t925 = t640 * t335;
  t928 = t103 * t8;
  t932 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t925 * t166 + 0.8e1 / 0.3e1 * t928 * t506);
  t933 = t650 * t372;
  t936 = t107 * t8;
  t940 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t933 * t263 - 0.8e1 / 0.3e1 * t936 * t506);
  t942 = (t932 + t940) * t113;
  t943 = t942 * t141;
  t945 = t377 * t301;
  t946 = t99 * t945;
  t950 = -t706 - 0.18311447306006545054e-3 * t784 + 0.4e1 * t921 - 0.4e1 * t923 + t99 * t943 + t946 + t758 - 0.4e1 * t760 - t713 + t723 + 0.19751673498613801407e-1 * t942 * t139 + t754 - t702;
  t951 = t919 + t950;
  t952 = t66 * t951;
  t953 = t55 * t952;
  t954 = t46 * t953;
  t956 = t842 * t40;
  t957 = t956 * t153;
  t959 = t351 * t188;
  t962 = t350 * t180;
  t963 = t806 * t962;
  t966 = params->c * t841;
  t967 = t325 * t966;
  t970 = -0.5e1 / 0.9e1 * t957 + 0.1e3 / 0.81e2 * t959 * t327 - 0.2e4 / 0.243e3 * t805 * t963 + 0.5e2 / 0.81e2 * t324 * t967;
  t971 = t970 * t146;
  t972 = t394 * t316;
  t973 = t330 * t382;
  t974 = t156 * t951;
  t975 = 0.5e1 / 0.9e1 * t844 - 0.1e3 / 0.81e2 * t847 + 0.5e1 / 0.9e1 * t849 + 0.5e1 / 0.9e1 * t851 + 0.2e4 / 0.243e3 * t856 - 0.5e2 / 0.81e2 * t859 - 0.5e2 / 0.81e2 * t863 - 0.5e2 / 0.81e2 * t867 + 0.5e1 / 0.9e1 * t869 - 0.5e2 / 0.81e2 * t873 + 0.5e1 / 0.9e1 * t894 + 0.5e1 / 0.9e1 * t898 + 0.5e1 / 0.9e1 * t900 - 0.5e2 / 0.81e2 * t905 + 0.5e1 / 0.9e1 * t909 + 0.5e1 / 0.9e1 * t954 + t971 + t972 + t973 + t974;
  tv2rho21 = t9 * t975 + t184 - t198 + t220 + t320 + t331 + t332 + t354 - t358 + t368 + t386 + t395 + t396;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t983 = t336 * t336;
  t984 = t501 * t983;
  t986 = 0.1e2 / 0.9e1 * t7 * t984;
  t987 = t164 + t507;
  t988 = t15 * t987;
  t990 = 0.5e1 / 0.3e1 * t7 * t988;
  t991 = t340 * rho[1];
  t993 = 0.1e1 / t19 / t991;
  t994 = tau[1] * t993;
  t996 = 0.4e2 / 0.9e1 * t994 * t27;
  t998 = 0.5e2 / 0.9e1 * t343 * t347;
  t999 = t346 * t346;
  t1000 = t512 * t999;
  t1002 = 0.1e2 / 0.9e1 * t22 * t1000;
  t1003 = -t987;
  t1004 = t26 * t1003;
  t1006 = 0.5e1 / 0.3e1 * t22 * t1004;
  t1007 = t986 + t990 + t996 - t998 + t1002 + t1006 - t521;
  t1008 = t2 * t1007;
  t1009 = t1008 * t45;
  t1010 = t1009 * t148;
  t1011 = 0.5e1 / 0.9e1 * t1010;
  t1012 = t350 * t350;
  t1013 = t2 * t1012;
  t1014 = t1013 * t188;
  t1015 = t1014 * t531;
  t1016 = 0.1e3 / 0.81e2 * t1015;
  t1017 = t352 * t366;
  t1018 = 0.1e2 / 0.9e1 * t1017;
  t1019 = t352 * t384;
  t1020 = 0.1e2 / 0.9e1 * t1019;
  t1021 = t544 * t1012;
  t1022 = t147 * t1021;
  t1023 = t543 * t1022;
  t1024 = 0.2e4 / 0.243e3 * t1023;
  t1025 = t871 * t355;
  t1026 = t190 * t1025;
  t1027 = 0.1e3 / 0.81e2 * t1026;
  t1028 = t902 * t350;
  t1029 = t193 * t1028;
  t1030 = t190 * t1029;
  t1031 = 0.1e3 / 0.81e2 * t1030;
  t1032 = t194 * t1007;
  t1033 = t193 * t1032;
  t1034 = t190 * t1033;
  t1035 = 0.5e2 / 0.81e2 * t1034;
  t1037 = t360 * t360;
  t1038 = t574 * t1037;
  t1042 = t986 + t990 + t996 - t998 + t1002 + t1006;
  t1043 = t207 * t1042;
  t1046 = -t567 - 0.7e1 / 0.6e1 * t876 - t571 - t59 * t1038 / 0.4e1 - t884 / 0.2e1 + t59 * t1043 / 0.8e1 - t588;
  t1047 = t1046 * t146;
  t1048 = t55 * t1047;
  t1049 = t46 * t1048;
  t1050 = 0.5e1 / 0.9e1 * t1049;
  t1051 = t364 * t382;
  t1052 = t55 * t1051;
  t1053 = t46 * t1052;
  t1054 = 0.1e2 / 0.9e1 * t1053;
  t1055 = t335 * t335;
  t1058 = 0.2e1 * t987;
  t1062 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t1055 + 0.4e1 / 0.3e1 * t103 * t1058);
  t1063 = t372 * t372;
  t1066 = -t1058;
  t1070 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t1063 + 0.4e1 / 0.3e1 * t107 * t1066);
  t1072 = (t1062 + t1070) * t113;
  t1073 = t1072 * t141;
  t1081 = t99 * t1073 + 0.19751673498613801407e-1 * t1072 * t139 - 0.11696447245269292414e1 * t912 - 0.8e1 * t921 - 0.8e1 * t923 + 0.2e1 * t946 - t606 - t635 + t666 + t754 - t763;
  t1083 = -t768 - t713 + t772 + t775 + t778 - t702 + t723 + t731 + t782 - 0.36622894612013090108e-3 * t916 + t789 - t706;
  t1084 = t1081 + t1083;
  t1085 = t66 * t1084;
  t1086 = t55 * t1085;
  t1087 = t46 * t1086;
  t1088 = 0.5e1 / 0.9e1 * t1087;
  t1089 = t1008 * t40;
  t1090 = t1089 * t153;
  t1092 = t1013 * t185;
  t1095 = t806 * t1012;
  t1098 = params->c * t1007;
  t1099 = t325 * t1098;
  t1102 = -0.5e1 / 0.9e1 * t1090 + 0.1e3 / 0.81e2 * t1092 * t802 - 0.2e4 / 0.243e3 * t805 * t1095 + 0.5e2 / 0.81e2 * t324 * t1099;
  t1103 = t1102 * t146;
  t1104 = t394 * t382;
  t1105 = 0.2e1 * t1104;
  t1106 = t156 * t1084;
  t1107 = t1011 - t1016 + t1018 + t1020 + t1024 - t1027 - t1031 - t1035 + t1050 + t1054 + t1088 + t1103 + t1105 + t1106;
  tv2rho22 = 0.1e2 / 0.9e1 * t353 - 0.1e3 / 0.81e2 * t357 + 0.1e2 / 0.9e1 * t367 + 0.1e2 / 0.9e1 * t385 + 0.2e1 * t395 + 0.2e1 * t396 + t9 * t1107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t1109 = t2 * t177;
  t1110 = t1109 * t45;
  t1111 = t1110 * t148;
  t1112 = 0.5e1 / 0.27e2 * t1111;
  t1113 = t399 * t189;
  t1114 = t1113 * t196;
  t1115 = 0.25e2 / 0.162e3 * t1114;
  t1116 = t400 * t218;
  t1117 = 0.5e1 / 0.72e2 * t1116;
  t1118 = t400 * t318;
  t1119 = 0.5e1 / 0.72e2 * t1118;
  t1120 = t544 * t35;
  t1121 = t1120 * t180;
  t1122 = t147 * t1121;
  t1123 = t543 * t1122;
  t1124 = 0.25e3 / 0.243e3 * t1123;
  t1126 = t190 * t549 * t403;
  t1127 = 0.25e2 / 0.324e3 * t1126;
  t1128 = t553 * t35;
  t1130 = t190 * t193 * t1128;
  t1131 = 0.25e2 / 0.324e3 * t1130;
  t1132 = t194 * t177;
  t1134 = t190 * t193 * t1132;
  t1135 = 0.5e2 / 0.243e3 * t1134;
  t1136 = t181 * t50;
  t1137 = t1136 * t410;
  t1138 = 0.5e1 / 0.72e2 * t1137;
  t1139 = t39 * t185;
  t1140 = t800 * t192;
  t1141 = t1139 * t1140;
  t1142 = t58 * t61;
  t1143 = t1142 * t62;
  t1144 = t1143 * t195;
  t1145 = t1141 * t1144;
  t1146 = 0.25e2 / 0.324e3 * t1145;
  t1147 = t54 * t201;
  t1148 = t1147 * t409;
  t1149 = t407 * t1148;
  t1150 = 0.35e2 / 0.108e3 * t1149;
  t1151 = t408 * t206;
  t1152 = t62 * t146;
  t1153 = t1152 * t209;
  t1154 = t1151 * t1153;
  t1155 = t407 * t1154;
  t1156 = 0.5e1 / 0.72e2 * t1155;
  t1157 = t213 * t146;
  t1158 = t408 * t1157;
  t1159 = t407 * t1158;
  t1160 = 0.5e1 / 0.36e2 * t1159;
  t1161 = t63 * t316;
  t1162 = t408 * t1161;
  t1163 = t407 * t1162;
  t1164 = 0.5e1 / 0.72e2 * t1163;
  t1166 = t1109 * t40 * t153;
  t1167 = 0.5e1 / 0.27e2 * t1166;
  t1168 = t399 * t188;
  t1169 = t1168 * t327;
  t1171 = t35 * t180;
  t1172 = t806 * t1171;
  t1173 = t805 * t1172;
  t1175 = params->c * t177;
  t1177 = t324 * t325 * t1175;
  t1178 = 0.5e2 / 0.243e3 * t1177;
  t1179 = -t1167 - 0.25e2 / 0.162e3 * t1169 + 0.25e3 / 0.243e3 * t1173 + t1178;
  t1180 = t1179 * t146;
  t1181 = t420 * t316;
  t1182 = t1112 + t1115 - t1117 - t1119 - t1124 + t1127 + t1131 - t1135 - t1138 + t1146 + t1150 + t1156 - t1160 - t1164 + t1180 + t1181;
  tv2rhosigma0 = t1182 * t9 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t1184 = 0.1e2 / 0.27e2 * t1111;
  t1185 = 0.25e2 / 0.81e2 * t1114;
  t1186 = 0.5e1 / 0.36e2 * t1116;
  t1187 = 0.5e1 / 0.36e2 * t1118;
  t1188 = 0.5e3 / 0.243e3 * t1123;
  t1189 = 0.25e2 / 0.162e3 * t1126;
  t1190 = 0.25e2 / 0.162e3 * t1130;
  t1191 = 0.1e3 / 0.243e3 * t1134;
  t1192 = 0.5e1 / 0.36e2 * t1137;
  t1193 = 0.25e2 / 0.162e3 * t1145;
  t1194 = 0.35e2 / 0.54e2 * t1149;
  t1195 = 0.5e1 / 0.36e2 * t1155;
  t1196 = 0.5e1 / 0.18e2 * t1159;
  t1197 = 0.5e1 / 0.36e2 * t1163;
  t1198 = 0.1e2 / 0.27e2 * t1166;
  t1201 = 0.1e3 / 0.243e3 * t1177;
  t1202 = -t1198 - 0.25e2 / 0.81e2 * t1169 + 0.5e3 / 0.243e3 * t1173 + t1201;
  t1203 = t1202 * t146;
  t1204 = t428 * t316;
  t1205 = t1184 + t1185 - t1186 - t1187 - t1188 + t1189 + t1190 - t1191 - t1192 + t1193 + t1194 + t1195 - t1196 - t1197 + t1203 + t1204;
  tv2rhosigma1 = t1205 * t9 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1207 = t1113 * t356;
  t1208 = 0.25e2 / 0.162e3 * t1207;
  t1209 = t400 * t366;
  t1210 = 0.5e1 / 0.72e2 * t1209;
  t1211 = t400 * t384;
  t1212 = 0.5e1 / 0.72e2 * t1211;
  t1213 = t1120 * t350;
  t1214 = t147 * t1213;
  t1215 = t543 * t1214;
  t1216 = 0.25e3 / 0.243e3 * t1215;
  t1218 = t190 * t871 * t403;
  t1219 = 0.25e2 / 0.324e3 * t1218;
  t1220 = t902 * t35;
  t1222 = t190 * t193 * t1220;
  t1223 = 0.25e2 / 0.324e3 * t1222;
  t1224 = t351 * t50;
  t1225 = t1224 * t410;
  t1226 = 0.5e1 / 0.72e2 * t1225;
  t1227 = t1143 * t355;
  t1228 = t1141 * t1227;
  t1229 = 0.25e2 / 0.324e3 * t1228;
  t1230 = t1152 * t360;
  t1231 = t1151 * t1230;
  t1232 = t407 * t1231;
  t1233 = 0.5e1 / 0.72e2 * t1232;
  t1234 = t63 * t382;
  t1235 = t408 * t1234;
  t1236 = t407 * t1235;
  t1237 = 0.5e1 / 0.72e2 * t1236;
  t1238 = t1168 * t391;
  t1240 = t35 * t350;
  t1241 = t806 * t1240;
  t1242 = t805 * t1241;
  t1244 = -t1167 - 0.25e2 / 0.162e3 * t1238 + 0.25e3 / 0.243e3 * t1242 + t1178;
  t1245 = t1244 * t146;
  t1246 = t420 * t382;
  t1247 = t1112 + t1208 - t1210 - t1212 - t1216 + t1219 + t1223 - t1135 - t1226 + t1229 + t1150 + t1233 + t1160 - t1237 + t1245 + t1246;
  tv2rhosigma3 = t1247 * t9 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t1249 = 0.25e2 / 0.81e2 * t1207;
  t1250 = 0.5e1 / 0.36e2 * t1209;
  t1251 = 0.5e1 / 0.36e2 * t1211;
  t1252 = 0.5e3 / 0.243e3 * t1215;
  t1253 = 0.25e2 / 0.162e3 * t1218;
  t1254 = 0.25e2 / 0.162e3 * t1222;
  t1255 = 0.5e1 / 0.36e2 * t1225;
  t1256 = 0.25e2 / 0.162e3 * t1228;
  t1257 = 0.5e1 / 0.36e2 * t1232;
  t1258 = 0.5e1 / 0.36e2 * t1236;
  t1261 = -t1198 - 0.25e2 / 0.81e2 * t1238 + 0.5e3 / 0.243e3 * t1242 + t1201;
  t1262 = t1261 * t146;
  t1263 = t428 * t382;
  t1264 = t1184 + t1249 - t1250 - t1251 - t1252 + t1253 + t1254 - t1191 - t1255 + t1256 + t1194 + t1257 + t1196 - t1258 + t1262 + t1263;
  tv2rhosigma4 = t1264 * t9 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1266 = t2 * t160;
  t1267 = t1266 * t432;
  t1268 = t1267 * t436;
  t1269 = 0.25e2 / 0.27e2 * t1268;
  t1270 = t15 * t40;
  t1271 = t1270 * t44;
  t1272 = t431 * t1271;
  t1274 = t55 * t147 * t167;
  t1275 = t1272 * t1274;
  t1276 = 0.25e2 / 0.27e2 * t1275;
  t1277 = t16 * t185;
  t1278 = t1277 * t187;
  t1279 = t431 * t1278;
  t1280 = t325 * t66;
  t1281 = t1280 * t195;
  t1282 = t1279 * t1281;
  t1283 = 0.1e3 / 0.81e2 * t1282;
  t1284 = t54 * t216;
  t1286 = t152 * t1284 * t146;
  t1287 = t433 * t1286;
  t1288 = 0.5e1 / 0.9e1 * t1287;
  t1290 = t152 * t434 * t316;
  t1291 = t433 * t1290;
  t1292 = 0.5e1 / 0.9e1 * t1291;
  t1293 = t542 * t66;
  t1294 = t39 * t1293;
  t1295 = t146 * t544;
  t1296 = t6 * t16;
  t1297 = t1296 * t180;
  t1298 = t1295 * t1297;
  t1299 = t1294 * t1298;
  t1300 = 0.2e4 / 0.243e3 * t1299;
  t1301 = t549 * t146;
  t1302 = t1301 * t441;
  t1303 = t190 * t1302;
  t1304 = 0.5e2 / 0.81e2 * t1303;
  t1305 = t193 * t316;
  t1306 = t1305 * t441;
  t1307 = t190 * t1306;
  t1308 = 0.5e2 / 0.81e2 * t1307;
  t1309 = params->c * t160;
  t1310 = t1309 * t16;
  t1311 = t439 * t1310;
  t1312 = t190 * t1311;
  t1313 = 0.25e3 / 0.243e3 * t1312;
  t1314 = t6 * t15;
  t1315 = t1314 * t167;
  t1317 = t1141 * t530 * t1315;
  t1318 = 0.25e3 / 0.243e3 * t1317;
  t1319 = t322 * t449;
  t1320 = 0.5e1 / 0.72e2 * t1319;
  t1321 = t192 * t30;
  t1322 = t800 * t1321;
  t1323 = t1139 * t1322;
  t1324 = t58 * t206;
  t1325 = t1324 * t446;
  t1326 = t447 * t326;
  t1327 = t1325 * t1326;
  t1328 = t1323 * t1327;
  t1329 = 0.25e2 / 0.324e3 * t1328;
  t1330 = t202 * t206;
  t1331 = t1330 * t448;
  t1332 = t154 * t1331;
  t1333 = 0.35e2 / 0.108e3 * t1332;
  t1334 = t54 * t30;
  t1335 = t152 * t1334;
  t1336 = t151 * t1335;
  t1337 = t58 * t573;
  t1338 = t1337 * t62;
  t1339 = t146 * t209;
  t1340 = t1296 * t1339;
  t1341 = t1338 * t1340;
  t1342 = t1336 * t1341;
  t1343 = 0.5e1 / 0.36e2 * t1342;
  t1344 = t8 * t6;
  t1345 = t1344 * t447;
  t1346 = t445 * t1345;
  t1347 = t154 * t1346;
  t1348 = 0.5e1 / 0.36e2 * t1347;
  t1349 = t62 * t160;
  t1350 = t1349 * t447;
  t1351 = t445 * t1350;
  t1352 = t154 * t1351;
  t1353 = 0.25e2 / 0.216e3 * t1352;
  t1354 = t1324 * t62;
  t1355 = t146 * t167;
  t1356 = t1314 * t1355;
  t1357 = t1354 * t1356;
  t1358 = t1336 * t1357;
  t1359 = 0.25e2 / 0.216e3 * t1358;
  t1360 = t16 * t316;
  t1361 = t446 * t1360;
  t1362 = t445 * t1361;
  t1363 = t154 * t1362;
  t1364 = 0.5e1 / 0.72e2 * t1363;
  t1365 = t1266 * t16;
  t1368 = t431 * t1270;
  t1369 = t54 * t167;
  t1370 = t152 * t1369;
  t1373 = t431 * t1277;
  t1375 = t800 * t801 * t180;
  t1378 = t544 * t6;
  t1379 = t16 * t180;
  t1380 = t1378 * t1379;
  t1383 = t325 * t1310;
  t1389 = 0.25e2 / 0.27e2 * t1365 * t453 - 0.25e2 / 0.27e2 * t1368 * t1370 + 0.1e3 / 0.81e2 * t1373 * t1375 - 0.2e4 / 0.243e3 * t543 * t1380 - 0.25e3 / 0.243e3 * t324 * t1383 + 0.25e3 / 0.243e3 * t190 * t801 * t1315;
  t1390 = t1389 * t146;
  t1391 = t459 * t316;
  t1392 = -t1269 + t1276 - t1283 + t1288 + t1292 + t1300 - t1304 - t1308 + t1313 - t1318 + t1320 - t1329 - t1333 - t1343 + t1348 - t1353 + t1359 + t1364 + t1390 + t1391;
  tv2rhotau0 = t1392 * t9 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1394 = t26 * t40;
  t1395 = t1394 * t44;
  t1396 = t462 * t1395;
  t1398 = t55 * t147 * t171;
  t1399 = t1396 * t1398;
  t1400 = 0.25e2 / 0.27e2 * t1399;
  t1401 = t27 * t185;
  t1402 = t1401 * t187;
  t1403 = t462 * t1402;
  t1404 = t1403 * t1281;
  t1405 = 0.1e3 / 0.81e2 * t1404;
  t1406 = t464 * t1286;
  t1407 = 0.5e1 / 0.9e1 * t1406;
  t1408 = t464 * t1290;
  t1409 = 0.5e1 / 0.9e1 * t1408;
  t1410 = t21 * t27;
  t1411 = t1410 * t180;
  t1412 = t1295 * t1411;
  t1413 = t1294 * t1412;
  t1414 = 0.2e4 / 0.243e3 * t1413;
  t1416 = t190 * t1301 * t468;
  t1417 = 0.5e2 / 0.81e2 * t1416;
  t1419 = t190 * t1305 * t468;
  t1420 = 0.5e2 / 0.81e2 * t1419;
  t1421 = t21 * t26;
  t1422 = t1421 * t171;
  t1424 = t1141 * t530 * t1422;
  t1425 = 0.25e3 / 0.243e3 * t1424;
  t1426 = t322 * t475;
  t1427 = 0.5e1 / 0.72e2 * t1426;
  t1428 = t1324 * t472;
  t1429 = t473 * t326;
  t1430 = t1428 * t1429;
  t1431 = t1323 * t1430;
  t1432 = 0.25e2 / 0.324e3 * t1431;
  t1433 = t1330 * t474;
  t1434 = t154 * t1433;
  t1435 = 0.35e2 / 0.108e3 * t1434;
  t1436 = t1410 * t1339;
  t1437 = t1338 * t1436;
  t1438 = t1336 * t1437;
  t1439 = 0.5e1 / 0.36e2 * t1438;
  t1440 = t8 * t21;
  t1441 = t1440 * t473;
  t1442 = t445 * t1441;
  t1443 = t154 * t1442;
  t1444 = 0.5e1 / 0.36e2 * t1443;
  t1445 = t146 * t171;
  t1446 = t1421 * t1445;
  t1447 = t1354 * t1446;
  t1448 = t1336 * t1447;
  t1449 = 0.25e2 / 0.216e3 * t1448;
  t1450 = t27 * t316;
  t1451 = t472 * t1450;
  t1452 = t445 * t1451;
  t1453 = t154 * t1452;
  t1454 = 0.5e1 / 0.72e2 * t1453;
  t1455 = t462 * t1394;
  t1456 = t54 * t171;
  t1457 = t152 * t1456;
  t1460 = t462 * t1401;
  t1463 = t544 * t21;
  t1464 = t27 * t180;
  t1465 = t1463 * t1464;
  t1471 = -0.25e2 / 0.27e2 * t1455 * t1457 + 0.1e3 / 0.81e2 * t1460 * t1375 - 0.2e4 / 0.243e3 * t543 * t1465 + 0.25e3 / 0.243e3 * t190 * t801 * t1422;
  t1472 = t1471 * t146;
  t1473 = t484 * t316;
  t1474 = t1400 - t1405 + t1407 + t1409 + t1414 - t1417 - t1420 - t1425 + t1427 - t1432 - t1435 - t1439 + t1444 + t1449 + t1454 + t1472 + t1473;
  tv2rhotau1 = t1474 * t9 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1477 = t55 * t147 * t336;
  t1478 = t1272 * t1477;
  t1479 = 0.25e2 / 0.27e2 * t1478;
  t1480 = t1280 * t355;
  t1481 = t1279 * t1480;
  t1482 = 0.1e3 / 0.81e2 * t1481;
  t1483 = t54 * t364;
  t1485 = t152 * t1483 * t146;
  t1486 = t433 * t1485;
  t1487 = 0.5e1 / 0.9e1 * t1486;
  t1489 = t152 * t434 * t382;
  t1490 = t433 * t1489;
  t1491 = 0.5e1 / 0.9e1 * t1490;
  t1492 = t1296 * t350;
  t1493 = t1295 * t1492;
  t1494 = t1294 * t1493;
  t1495 = 0.2e4 / 0.243e3 * t1494;
  t1496 = t871 * t146;
  t1497 = t1496 * t441;
  t1498 = t190 * t1497;
  t1499 = 0.5e2 / 0.81e2 * t1498;
  t1500 = t193 * t382;
  t1501 = t1500 * t441;
  t1502 = t190 * t1501;
  t1503 = 0.5e2 / 0.81e2 * t1502;
  t1504 = t1314 * t336;
  t1506 = t1141 * t530 * t1504;
  t1507 = 0.25e3 / 0.243e3 * t1506;
  t1508 = t388 * t449;
  t1509 = 0.5e1 / 0.72e2 * t1508;
  t1510 = t447 * t390;
  t1511 = t1325 * t1510;
  t1512 = t1323 * t1511;
  t1513 = 0.25e2 / 0.324e3 * t1512;
  t1514 = t146 * t360;
  t1515 = t1296 * t1514;
  t1516 = t1338 * t1515;
  t1517 = t1336 * t1516;
  t1518 = 0.5e1 / 0.36e2 * t1517;
  t1519 = t146 * t336;
  t1520 = t1314 * t1519;
  t1521 = t1354 * t1520;
  t1522 = t1336 * t1521;
  t1523 = 0.25e2 / 0.216e3 * t1522;
  t1524 = t16 * t382;
  t1525 = t446 * t1524;
  t1526 = t445 * t1525;
  t1527 = t154 * t1526;
  t1528 = 0.5e1 / 0.72e2 * t1527;
  t1529 = t54 * t336;
  t1530 = t152 * t1529;
  t1534 = t800 * t801 * t350;
  t1537 = t16 * t350;
  t1538 = t1378 * t1537;
  t1544 = -0.25e2 / 0.27e2 * t1368 * t1530 + 0.1e3 / 0.81e2 * t1373 * t1534 - 0.2e4 / 0.243e3 * t543 * t1538 + 0.25e3 / 0.243e3 * t190 * t801 * t1504;
  t1545 = t1544 * t146;
  t1546 = t459 * t382;
  t1547 = t1479 - t1482 + t1487 + t1491 + t1495 - t1499 - t1503 - t1507 + t1509 - t1513 - t1333 - t1518 - t1348 + t1523 + t1528 + t1545 + t1546;
  tv2rhotau2 = t1547 * t9 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1549 = t2 * t342;
  t1550 = t1549 * t463;
  t1551 = t1550 * t436;
  t1552 = 0.25e2 / 0.27e2 * t1551;
  t1554 = t55 * t147 * t346;
  t1555 = t1396 * t1554;
  t1556 = 0.25e2 / 0.27e2 * t1555;
  t1557 = t1403 * t1480;
  t1558 = 0.1e3 / 0.81e2 * t1557;
  t1559 = t464 * t1485;
  t1560 = 0.5e1 / 0.9e1 * t1559;
  t1561 = t464 * t1489;
  t1562 = 0.5e1 / 0.9e1 * t1561;
  t1563 = t1410 * t350;
  t1564 = t1295 * t1563;
  t1565 = t1294 * t1564;
  t1566 = 0.2e4 / 0.243e3 * t1565;
  t1568 = t190 * t1496 * t468;
  t1569 = 0.5e2 / 0.81e2 * t1568;
  t1571 = t190 * t1500 * t468;
  t1572 = 0.5e2 / 0.81e2 * t1571;
  t1573 = params->c * t342;
  t1574 = t1573 * t27;
  t1576 = t190 * t439 * t1574;
  t1577 = 0.25e3 / 0.243e3 * t1576;
  t1578 = t1421 * t346;
  t1580 = t1141 * t530 * t1578;
  t1581 = 0.25e3 / 0.243e3 * t1580;
  t1582 = t388 * t475;
  t1583 = 0.5e1 / 0.72e2 * t1582;
  t1584 = t473 * t390;
  t1586 = t1323 * t1428 * t1584;
  t1587 = 0.25e2 / 0.324e3 * t1586;
  t1588 = t1410 * t1514;
  t1589 = t1338 * t1588;
  t1590 = t1336 * t1589;
  t1591 = 0.5e1 / 0.36e2 * t1590;
  t1592 = t62 * t342;
  t1593 = t1592 * t473;
  t1594 = t445 * t1593;
  t1595 = t154 * t1594;
  t1596 = 0.25e2 / 0.216e3 * t1595;
  t1597 = t146 * t346;
  t1598 = t1421 * t1597;
  t1599 = t1354 * t1598;
  t1600 = t1336 * t1599;
  t1601 = 0.25e2 / 0.216e3 * t1600;
  t1602 = t27 * t382;
  t1603 = t472 * t1602;
  t1604 = t445 * t1603;
  t1605 = t154 * t1604;
  t1606 = 0.5e1 / 0.72e2 * t1605;
  t1607 = t1549 * t27;
  t1608 = t1607 * t453;
  t1610 = t54 * t346;
  t1611 = t152 * t1610;
  t1616 = t27 * t350;
  t1617 = t1463 * t1616;
  t1626 = 0.25e2 / 0.27e2 * t1608 - 0.25e2 / 0.27e2 * t1455 * t1611 + 0.1e3 / 0.81e2 * t1460 * t1534 - 0.2e4 / 0.243e3 * t543 * t1617 - 0.25e3 / 0.243e3 * t324 * t325 * t1574 + 0.25e3 / 0.243e3 * t190 * t801 * t1578;
  t1627 = t1626 * t146;
  t1628 = t484 * t382;
  t1629 = -t1552 + t1556 - t1558 + t1560 + t1562 + t1566 - t1569 - t1572 + t1577 - t1581 + t1583 - t1587 - t1435 - t1591 - t1444 - t1596 + t1601 + t1606 + t1627 + t1628;
  tv2rhotau3 = t1629 * t9 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1632 = 0.1e1 / t32 / t199;
  t1633 = t2 * t1632;
  t1634 = t1633 * t188;
  t1635 = t1634 * t531;
  t1636 = 0.25e2 / 0.1296e4 * t1635;
  t1637 = t56 * t175;
  t1639 = 0.1e1 / t32 / t1637;
  t1640 = t2 * t1639;
  t1641 = t1640 * t45;
  t1642 = t55 * t409;
  t1643 = t1641 * t1642;
  t1644 = 0.5e1 / 0.288e3 * t1643;
  t1645 = t544 * t1632;
  t1647 = t543 * t147 * t1645;
  t1648 = 0.125e3 / 0.972e3 * t1647;
  t1649 = t192 * t1639;
  t1650 = t1649 * t61;
  t1651 = t1152 * params->c;
  t1652 = t1650 * t1651;
  t1653 = t190 * t1652;
  t1654 = 0.25e2 / 0.1296e4 * t1653;
  t1656 = t1633 * t185 * t802;
  t1659 = t805 * t806 * t1632;
  t1661 = 0.25e2 / 0.1296e4 * t1656 - 0.125e3 / 0.972e3 * t1659;
  t1662 = t1661 * t146;
  tv2sigma20 = t9 * (-t1636 + t1644 + t1648 - t1654 + t1662);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t1664 = 0.25e2 / 0.648e3 * t1635;
  t1665 = 0.5e1 / 0.144e3 * t1643;
  t1666 = 0.125e3 / 0.486e3 * t1647;
  t1667 = 0.25e2 / 0.648e3 * t1653;
  t1670 = 0.25e2 / 0.648e3 * t1656 - 0.125e3 / 0.486e3 * t1659;
  t1671 = t1670 * t146;
  tv2sigma21 = t9 * (-t1664 + t1665 + t1666 - t1667 + t1671);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  t1673 = 0.25e2 / 0.324e3 * t1635;
  t1674 = 0.5e1 / 0.72e2 * t1643;
  t1675 = 0.125e3 / 0.243e3 * t1647;
  t1676 = 0.25e2 / 0.324e3 * t1653;
  t1679 = 0.25e2 / 0.324e3 * t1656 - 0.125e3 / 0.243e3 * t1659;
  t1680 = t1679 * t146;
  tv2sigma23 = t9 * (-t1673 + t1674 + t1675 - t1676 + t1680);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1682 = t1280 * t403;
  t1683 = t1279 * t1682;
  t1684 = 0.25e2 / 0.162e3 * t1683;
  t1685 = t432 * t44;
  t1686 = t431 * t1685;
  t1687 = t55 * t58;
  t1688 = t1687 * t409;
  t1689 = t1686 * t1688;
  t1690 = 0.5e1 / 0.72e2 * t1689;
  t1691 = t1296 * t35;
  t1692 = t1295 * t1691;
  t1693 = t1294 * t1692;
  t1694 = 0.25e3 / 0.243e3 * t1693;
  t1695 = t194 * t1296;
  t1696 = t1143 * t1695;
  t1697 = t1141 * t1696;
  t1698 = 0.25e2 / 0.324e3 * t1697;
  t1699 = t1640 * t40;
  t1700 = t1699 * t153;
  t1701 = t30 * t206;
  t1702 = t1701 * t62;
  t1703 = t1296 * t146;
  t1704 = t1702 * t1703;
  t1705 = t1700 * t1704;
  t1706 = 0.5e1 / 0.576e3 * t1705;
  t1707 = t1639 * t206;
  t1708 = t1707 * t62;
  t1709 = t1708 * t1695;
  t1710 = t1323 * t1709;
  t1711 = 0.25e2 / 0.2592e4 * t1710;
  t1712 = t1354 * t1703;
  t1713 = t154 * t1712;
  t1714 = 0.5e1 / 0.72e2 * t1713;
  t1716 = t800 * t801 * t35;
  t1717 = t1373 * t1716;
  t1719 = t16 * t35;
  t1721 = t543 * t1378 * t1719;
  t1723 = -0.25e2 / 0.162e3 * t1717 + 0.25e3 / 0.243e3 * t1721;
  t1724 = t1723 * t146;
  tv2sigmatau0 = t9 * (t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t1726 = t1403 * t1682;
  t1727 = 0.25e2 / 0.162e3 * t1726;
  t1728 = t463 * t44;
  t1729 = t462 * t1728;
  t1730 = t1729 * t1688;
  t1731 = 0.5e1 / 0.72e2 * t1730;
  t1732 = t1410 * t35;
  t1733 = t1295 * t1732;
  t1734 = t1294 * t1733;
  t1735 = 0.25e3 / 0.243e3 * t1734;
  t1736 = t194 * t1410;
  t1738 = t1141 * t1143 * t1736;
  t1739 = 0.25e2 / 0.324e3 * t1738;
  t1740 = t1410 * t146;
  t1741 = t1702 * t1740;
  t1742 = t1700 * t1741;
  t1743 = 0.5e1 / 0.576e3 * t1742;
  t1744 = t1708 * t1736;
  t1745 = t1323 * t1744;
  t1746 = 0.25e2 / 0.2592e4 * t1745;
  t1747 = t1354 * t1740;
  t1748 = t154 * t1747;
  t1749 = 0.5e1 / 0.72e2 * t1748;
  t1750 = t1460 * t1716;
  t1752 = t27 * t35;
  t1754 = t543 * t1463 * t1752;
  t1756 = -0.25e2 / 0.162e3 * t1750 + 0.25e3 / 0.243e3 * t1754;
  t1757 = t1756 * t146;
  tv2sigmatau1 = t9 * (t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  t1759 = 0.25e2 / 0.81e2 * t1683;
  t1760 = 0.5e1 / 0.36e2 * t1689;
  t1761 = 0.5e3 / 0.243e3 * t1693;
  t1762 = 0.25e2 / 0.162e3 * t1697;
  t1763 = 0.5e1 / 0.288e3 * t1705;
  t1764 = 0.25e2 / 0.1296e4 * t1710;
  t1765 = 0.5e1 / 0.36e2 * t1713;
  t1768 = -0.25e2 / 0.81e2 * t1717 + 0.5e3 / 0.243e3 * t1721;
  t1769 = t1768 * t146;
  tv2sigmatau2 = t9 * (t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  t1771 = 0.25e2 / 0.81e2 * t1726;
  t1772 = 0.5e1 / 0.36e2 * t1730;
  t1773 = 0.5e3 / 0.243e3 * t1734;
  t1774 = 0.25e2 / 0.162e3 * t1738;
  t1775 = 0.5e1 / 0.288e3 * t1742;
  t1776 = 0.25e2 / 0.1296e4 * t1745;
  t1777 = 0.5e1 / 0.36e2 * t1748;
  t1780 = -0.25e2 / 0.81e2 * t1750 + 0.5e3 / 0.243e3 * t1754;
  t1781 = t1780 * t146;
  tv2sigmatau3 = t9 * (t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = tv2sigmatau0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = tv2sigmatau1;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1784 = 0.1e1 / t3 / t493;
  t1785 = t2 * t1784;
  t1786 = t13 * t13;
  t1788 = t14 * t1786 * t13;
  t1789 = t1788 * t185;
  t1790 = t1789 * t187;
  t1791 = t1785 * t1790;
  t1793 = 0.1e3 / 0.81e2 * t1791 * t531;
  t1794 = t1785 * t1788;
  t1795 = t1794 * t50;
  t1796 = t1334 * t58;
  t1797 = t207 * t146;
  t1798 = t1796 * t1797;
  t1800 = 0.5e1 / 0.36e2 * t1795 * t1798;
  t1801 = t544 * t1784;
  t1802 = t1801 * t1788;
  t1803 = t147 * t1802;
  t1805 = 0.2e4 / 0.243e3 * t543 * t1803;
  t1806 = t1784 * t1788;
  t1807 = t1806 * t194;
  t1808 = t1354 * t1807;
  t1810 = 0.25e2 / 0.162e3 * t1323 * t1808;
  t1811 = t62 * t1784;
  t1812 = t1788 * t146;
  t1813 = t1811 * t1812;
  t1814 = t878 * t1813;
  t1816 = 0.5e1 / 0.36e2 * t154 * t1814;
  t1820 = t806 * t1806;
  t1823 = 0.1e3 / 0.81e2 * t1785 * t1789 * t802 - 0.2e4 / 0.243e3 * t805 * t1820;
  t1824 = t1823 * t146;
  tv2tau20 = t9 * (-t1793 + t1800 + t1805 - t1810 - t1816 + t1824);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t1826 = t478 * t189;
  t1828 = 0.1e3 / 0.81e2 * t1826 * t442;
  t1830 = 0.5e1 / 0.36e2 * t479 * t449;
  t1831 = t1295 * t21;
  t1832 = t27 * t6;
  t1833 = t1832 * t16;
  t1834 = t1831 * t1833;
  t1836 = 0.2e4 / 0.243e3 * t1294 * t1834;
  t1837 = t325 * t59;
  t1838 = t324 * t1837;
  t1839 = t207 * t1296;
  t1840 = t1839 * t1736;
  t1842 = 0.25e2 / 0.162e3 * t1838 * t1840;
  t1843 = t1337 * t472;
  t1844 = t473 * t1296;
  t1845 = t1843 * t1844;
  t1847 = 0.5e1 / 0.36e2 * t1336 * t1845;
  t1853 = 0.1e3 / 0.81e2 * t1403 * t456 - 0.2e4 / 0.243e3 * t543 * t1463 * t1833;
  t1854 = t1853 * t146;
  tv2tau21 = t9 * (-t1828 + t1830 + t1836 - t1842 - t1847 + t1854);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1857 = 0.1e1 / t18 / t991;
  t1858 = t2 * t1857;
  t1859 = t24 * t24;
  t1861 = t25 * t1859 * t24;
  t1862 = t1861 * t185;
  t1863 = t1862 * t187;
  t1864 = t1858 * t1863;
  t1866 = 0.1e3 / 0.81e2 * t1864 * t531;
  t1867 = t1858 * t1861;
  t1868 = t1867 * t50;
  t1870 = 0.5e1 / 0.36e2 * t1868 * t1798;
  t1871 = t544 * t1857;
  t1872 = t1871 * t1861;
  t1875 = 0.2e4 / 0.243e3 * t543 * t147 * t1872;
  t1876 = t1857 * t1861;
  t1877 = t1876 * t194;
  t1878 = t1354 * t1877;
  t1880 = 0.25e2 / 0.162e3 * t1323 * t1878;
  t1881 = t62 * t1857;
  t1882 = t1861 * t146;
  t1883 = t1881 * t1882;
  t1884 = t878 * t1883;
  t1886 = 0.5e1 / 0.36e2 * t154 * t1884;
  t1887 = t1858 * t1862;
  t1893 = 0.1e3 / 0.81e2 * t1887 * t802 - 0.2e4 / 0.243e3 * t805 * t806 * t1876;
  t1894 = t1893 * t146;
  tv2tau22 = t9 * (-t1866 + t1870 + t1875 - t1880 - t1886 + t1894);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1896 = t544 * t180;
  t1897 = t1896 * t522;
  t1898 = t147 * t1897;
  t1899 = t543 * t1898;
  t1900 = 0.2e4 / 0.81e2 * t1899;
  t1901 = t217 * params->c;
  t1902 = t325 * t1901;
  t1903 = t529 * t1902;
  t1904 = 0.1e3 / 0.27e2 * t1903;
  t1905 = t317 * params->c;
  t1906 = t325 * t1905;
  t1907 = t529 * t1906;
  t1908 = 0.1e3 / 0.27e2 * t1907;
  t1909 = t330 * t791;
  t1910 = 0.3e1 * t1909;
  t1911 = t615 * t228;
  t1914 = 0.71233333333333333332e-1 * t670 * t1911 * t249;
  t1917 = 0.53424999999999999999e-1 * t670 * t703 * t721;
  t1918 = t222 * t725;
  t1921 = 0.85917975471764868594e0 * t670 * t1918 * t729;
  t1923 = 0.1e1 / t32 / t175;
  t1925 = t232 * t1923 * t138;
  t1927 = 0.56968947174242584612e-3 * t306 * t1925;
  t1928 = t660 * t67;
  t1929 = t1928 * t308;
  t1931 = t783 * t664;
  t1934 = t603 * t631;
  t1935 = t599 * t296 * t1934;
  t1937 = 0.51947577317044391277e2 * t311 * t1935;
  t1939 = t740 * t631 * t298;
  t1941 = 0.35089341735807877242e1 * t311 * t1939;
  t1942 = t223 * t787;
  t1944 = 0.32530743900905219526e-1 * t779 * t1942;
  t1945 = t223 * t604;
  t1947 = 0.48159733137676571078e0 * t779 * t1945;
  t1948 = t223 * t633;
  t1950 = 0.16265371950452609763e-1 * t779 * t1948;
  t1951 = t268 * t70;
  t1952 = t1951 * t780;
  t1954 = t1914 - t1917 - t1921 - t1927 - 0.54934341918019635162e-3 * t1929 + 0.73245789224026180216e-3 * t1931 - t1937 + t1941 - t1944 + t1947 + t1950 + 0.32530743900905219526e-1 * t1952;
  t1955 = t619 * t313;
  t1957 = 0.21687162600603479684e-1 * t779 * t1955;
  t1961 = 0.1e1 / t78 / t88 * t68 / 0.4e1;
  t1962 = t1961 * t98;
  t1964 = t610 * t177;
  t1965 = t609 * t1964;
  t1967 = t232 * t1923;
  t1968 = t231 * t1967;
  t1970 = t72 * t1923;
  t1971 = t70 * t1970;
  t1973 = 0.1e1/POW_3_2(t75);
  t1974 = t1973 * t68;
  t1975 = t1974 * t98;
  t1977 = t623 * t1964;
  t1979 = t239 * t1967;
  t1982 = t85 * t71 * t177;
  t1984 = -0.25319e1 * t1962 + 0.16879333333333333333e1 * t1965 - 0.19692555555555555555e1 * t1968 - 0.93011851851851851854e0 * t1971 + 0.13651666666666666667e0 * t1975 - 0.27303333333333333333e0 * t1977 - 0.3185388888888888889e0 * t1979 - 0.36514074074074074075e0 * t1982;
  t1985 = t1984 * t248;
  t1987 = 0.1e1 * t229 * t1985;
  t1991 = 0.10685e0 * t670 * t222 * t708 * t711;
  t1993 = 0.1e1 / t639 / t12;
  t1994 = t641 * t166;
  t1997 = t640 * t166;
  t2000 = t8 * t98;
  t2001 = t506 - t2000;
  t2002 = 0.6e1 * t2001;
  t2006 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t1993 * t1994 + 0.4e1 / 0.3e1 * t1997 * t644 + 0.4e1 / 0.3e1 * t103 * t2002);
  t2008 = 0.1e1 / t649 / t23;
  t2009 = t651 * t263;
  t2012 = t650 * t263;
  t2015 = -t2002;
  t2019 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2008 * t2009 + 0.4e1 / 0.3e1 * t2012 * t654 + 0.4e1 / 0.3e1 * t107 * t2015);
  t2021 = (t2006 + t2019) * t113;
  t2024 = t660 * t129;
  t2025 = t2024 * t313;
  t2027 = t636 * t633;
  t2030 = 0.1e1 / t598 / t289;
  t2031 = t600 * t296;
  t2034 = 0.1e1 / t602 / t137;
  t2035 = t2030 * t2031 * t2034;
  t2037 = 0.10254018858216406658e4 * t311 * t2035;
  t2038 = t636 * t604;
  t2041 = t599 * t2031 * t297;
  t2043 = 0.35089341735807877242e1 * t311 * t2041;
  t2044 = t710 * t247;
  t2045 = t2044 * t248;
  t2047 = 0.6e1 * t726 * t2045;
  t2049 = 0.1e1 / t724 / t227;
  t2050 = t77 * t2049;
  t2052 = 0.1e1 / t727 / t93;
  t2053 = t2044 * t2052;
  t2055 = 0.51726012919273400301e3 * t2050 * t2053;
  t2056 = t636 * t787;
  t2059 = 0.1e1 / t598 / t134;
  t2061 = t2059 * t2031 * t603;
  t2063 = 0.10389515463408878255e3 * t311 * t2061;
  t2064 = -t1957 + t1987 + t1991 + 0.19751673498613801407e-1 * t2021 * t139 - 0.17544670867903938621e1 * t2025 - 0.17544670867903938621e1 * t2027 - t2037 - 0.51947577317044391276e2 * t2038 - t2043 + t2047 + t2055 + 0.35089341735807877242e1 * t2056 + t2063;
  t2066 = t268 * t752;
  t2067 = t99 * t2066;
  t2069 = t615 * t290;
  t2076 = t222 * t599;
  t2080 = t222 * t693;
  t2084 = t615 * t275;
  t2091 = t129 * t2059;
  t2092 = t2031 * t603;
  t2096 = 0.1e1 / t692 / t121;
  t2097 = t116 * t2096;
  t2098 = t678 * t281;
  t2099 = t2098 * t696;
  t2110 = -0.47063e1 * t1962 + 0.31375333333333333334e1 * t1965 - 0.36604555555555555556e1 * t1968 - 0.16068111111111111111e1 * t1971 + 0.28051666666666666666e0 * t1975 - 0.56103333333333333332e0 * t1977 - 0.6545388888888888889e0 * t1979 - 0.46308888888888888888e0 * t1982;
  t2111 = t2110 * t282;
  t2118 = t222 * t740;
  t2122 = 0.21687162600603479684e-1 * t670 * t2069 * t298 - 0.16265371950452609763e-1 * t670 * t735 * t745 - 0.48159733137676571078e0 * t670 * t2076 * t749 - t1914 + t1917 + t1921 - 0.16522625736956710527e1 * t670 * t2080 * t697 + 0.68493333333333333332e-1 * t670 * t2084 * t283 - 0.51369999999999999999e-1 * t670 * t671 * t689 - 0.10389515463408878255e3 * t2091 * t2092 - t1987 - 0.19298375398431042081e3 * t2097 * t2099 + 0.1e1 * t276 * t2111 + 0.10274e0 * t670 * t222 * t676 * t679 - t1991 + 0.32530743900905219526e-1 * t670 * t2118 * t742;
  t2123 = t2098 * t282;
  t2134 = -0.34523333333333333333e1 * t1962 + 0.23015555555555555556e1 * t1965 - 0.26851481481481481482e1 * t1968 - 0.93932222222222222223e0 * t1971 + 0.73355e-1 * t1975 - 0.14671e0 * t1977 - 0.17116166666666666667e0 * t1979 - 0.36793333333333333333e0 * t1982;
  t2135 = t2134 * t297;
  t2138 = t129 * t2030;
  t2139 = t2031 * t2034;
  t2151 = t688 * t696;
  t2155 = t1934 * t296;
  t2158 = t298 * t631;
  t2163 = 0.6e1 * t709 * t249 * t720;
  t2166 = 0.34450798614814814813e-2 * t70 * t1970 * t94;
  t2167 = t720 * t728;
  t2170 = 0.48245938496077605201e2 * t726 * t2167 * t247;
  t2171 = t2031 * t297;
  t2175 = 0.1e1 / t692 / t274;
  t2176 = t116 * t2175;
  t2178 = 0.1e1 / t695 / t124;
  t2179 = t2098 * t2178;
  t2183 = 0.1e1 / t724 / t90;
  t2184 = t77 * t2183;
  t2185 = t2044 * t728;
  t2187 = 0.96491876992155210402e2 * t2184 * t2185;
  t2188 = -t2047 - t2055 + 0.6e1 * t694 * t2123 + 0.5848223622634646207e0 * t291 * t2135 + 0.10254018858216406658e4 * t2138 * t2139 - 0.6e1 * t677 * t283 * t688 + 0.56968947174242584612e-3 * t70 * t1970 * t138 + 0.16562821945185185185e-2 * t70 * t1970 * t125 + 0.96491876992155210402e2 * t694 * t2151 * t281 + 0.51947577317044391277e2 * t748 * t2155 - 0.35089341735807877242e1 * t741 * t2158 + t2163 - t2166 - t2170 + 0.35089341735807877242e1 * t748 * t2171 + 0.2069040516770936012e4 * t2176 * t2179 + t2187;
  t2189 = t2122 + t2188;
  t2190 = t114 * t2189;
  t2191 = t99 * t2190;
  t2193 = 0.12e2 * t257 * t753;
  t2194 = t253 * t753;
  t2195 = 0.12e2 * t2194;
  t2196 = t253 * t755;
  t2198 = t257 * t755;
  t2200 = t253 * t757;
  t2202 = t257 * t757;
  t2204 = t776 * t302;
  t2205 = 0.96e2 * t2204;
  t2206 = 0.3e1 * t2067 + t2191 - t2193 + t2195 - t2163 + t2166 + 0.12e2 * t2196 - 0.12e2 * t2198 + t2170 + 0.24e2 * t2200 - 0.24e2 * t2202 - t2205;
  t2207 = t776 * t269;
  t2209 = t770 * t269;
  t2212 = 0.6e2 * t770 * t302;
  t2213 = t773 * t302;
  t2214 = 0.36e2 * t2213;
  t2215 = t773 * t269;
  t2217 = t660 * t301;
  t2218 = t99 * t2217;
  t2221 = 0.24e2 * t2000 * t142;
  t2222 = t62 * t256;
  t2223 = t2222 * t142;
  t2224 = 0.144e3 * t2223;
  t2225 = t252 * t769;
  t2226 = t2225 * t142;
  t2227 = 0.24e3 * t2226;
  t2228 = 0.1e1 / t1637;
  t2229 = t97 * t2228;
  t2231 = 0.12e3 * t2229 * t142;
  t2232 = t2021 * t141;
  t2235 = t290 * t2134 * t297;
  t2237 = 0.5848223622634646207e0 * t311 * t2235;
  t2238 = t2232 * t99 - t2187 - 0.96e2 * t2207 + 0.6e2 * t2209 + t2212 + t2214 + 0.36e2 * t2215 + 0.3e1 * t2218 + t2221 - t2224 + t2227 - t2231 - t2237;
  t2240 = t1954 + t2064 + t2206 + t2238;
  t2242 = t55 * t66 * t2240;
  t2243 = t46 * t2242;
  t2244 = 0.5e1 / 0.9e1 * t2243;
  t2246 = 0.1e1 / t33 / t1637;
  t2247 = t30 * t2246;
  t2249 = 0.595e3 / 0.27e2 * t2247 * t63;
  t2250 = t565 * t210;
  t2252 = t565 * t213;
  t2253 = 0.119e3 / 0.6e1 * t2252;
  t2254 = t202 * t576;
  t2256 = t202 * t580;
  t2258 = t202 * t584;
  t2260 = t202 * t61;
  t2261 = 0.7e1 / 0.2e1 * t2260;
  t2262 = t205 * t205;
  t2263 = 0.1e1 / t2262;
  t2264 = t2263 * t62;
  t2265 = t575 * t209;
  t2266 = t2264 * t2265;
  t2269 = t573 * t8;
  t2270 = t2269 * t575;
  t2271 = t59 * t2270;
  t2273 = t62 * t209;
  t2274 = t2273 * t583;
  t2277 = t206 * t209;
  t2278 = t59 * t2277;
  t2280 = t579 * t583;
  t2281 = t59 * t2280;
  t2283 = t158 * t158;
  t2285 = 0.1e1 / t4 / t2283;
  t2286 = tau[0] * t2285;
  t2288 = 0.44e3 / 0.27e2 * t2286 * t16;
  t2290 = 0.2e3 / 0.9e1 * t496 * t168;
  t2292 = 0.5e2 / 0.9e1 * t161 * t503;
  t2294 = 0.25e2 / 0.3e1 * t161 * t509;
  t2295 = t14 * t13;
  t2296 = 0.1e1 / t2295;
  t2297 = t502 * t167;
  t2298 = t2296 * t2297;
  t2300 = 0.1e2 / 0.27e2 * t7 * t2298;
  t2301 = t501 * t167;
  t2302 = t2301 * t508;
  t2304 = 0.1e2 / 0.3e1 * t7 * t2302;
  t2305 = 0.3e1 * t2001;
  t2306 = t15 * t2305;
  t2308 = 0.5e1 / 0.3e1 * t7 * t2306;
  t2309 = t25 * t24;
  t2310 = 0.1e1 / t2309;
  t2311 = t513 * t171;
  t2312 = t2310 * t2311;
  t2314 = 0.1e2 / 0.27e2 * t22 * t2312;
  t2315 = t512 * t171;
  t2316 = t2315 * t517;
  t2318 = 0.1e2 / 0.3e1 * t22 * t2316;
  t2319 = -t2305;
  t2320 = t26 * t2319;
  t2322 = 0.5e1 / 0.3e1 * t22 * t2320;
  t2323 = -t2288 + t2290 - t2292 - t2294 - t2300 + t2304 + t2308 - t2314 + t2318 + t2322;
  t2324 = t207 * t2323;
  t2327 = t2249 + 0.119e3 / 0.12e2 * t2250 - t2253 + 0.7e1 / 0.2e1 * t2254 - 0.7e1 * t2256 - 0.7e1 / 0.4e1 * t2258 + t2261 + 0.3e1 / 0.4e1 * t59 * t2266 - 0.3e1 / 0.2e1 * t2271 - 0.3e1 / 0.4e1 * t878 * t2274 + 0.3e1 / 0.4e1 * t2278 + 0.3e1 / 0.4e1 * t2281 + t59 * t2324 / 0.8e1;
  t2329 = t55 * t2327 * t146;
  t2330 = t46 * t2329;
  t2331 = 0.5e1 / 0.9e1 * t2330;
  t2333 = t55 * t589 * t316;
  t2334 = t46 * t2333;
  t2335 = 0.5e1 / 0.3e1 * t2334;
  t2336 = t814 * t316;
  t2337 = 0.3e1 * t2336;
  t2338 = 0.154e3 / 0.27e2 * t202;
  t2339 = -t2288 + t2290 - t2292 - t2294 - t2300 + t2304 + t2308 - t2314 + t2318 + t2322 + t2338;
  t2340 = t2 * t2339;
  t2342 = t2340 * t40 * t153;
  t2347 = t527 * t180;
  t2348 = t2 * t2347;
  t2349 = t542 * t544;
  t2352 = t191 * t191;
  t2353 = 0.1e1 / t2352;
  t2354 = t539 * t2353;
  t2355 = t39 * t2354;
  t2356 = t544 * params->c;
  t2358 = t2356 * t2347 * t50;
  t2361 = t180 * t522;
  t2362 = t806 * t2361;
  t2365 = params->c * t2339;
  t2366 = t325 * t2365;
  t2369 = -0.5e1 / 0.9e1 * t2342 + 0.1e3 / 0.27e2 * t523 * t188 * t327 - 0.2e4 / 0.81e2 * t2348 * t2349 + 0.1e5 / 0.729e3 * t2355 * t2358 - 0.2e4 / 0.81e2 * t805 * t2362 + 0.5e2 / 0.81e2 * t324 * t2366;
  t2370 = t2369 * t146;
  t2371 = t2348 * t539;
  t2372 = t541 * t66;
  t2373 = t2372 * t1295;
  t2374 = t2371 * t2373;
  t2375 = 0.2e4 / 0.81e2 * t2374;
  t2376 = t156 * t2240;
  t2377 = t182 * t793;
  t2378 = 0.5e1 / 0.3e1 * t2377;
  t2380 = t55 * t216 * t791;
  t2381 = t46 * t2380;
  t2382 = 0.5e1 / 0.3e1 * t2381;
  t2383 = t217 * t545;
  t2384 = t543 * t2383;
  t2385 = 0.2e4 / 0.81e2 * t2384;
  t2386 = t1900 - t1904 - t1908 + t1910 + t2244 + t2331 + t2335 + t2337 + t2370 + t2375 + t2376 + t2378 + t2382 + t2385;
  t2387 = t317 * t545;
  t2388 = t543 * t2387;
  t2389 = 0.2e4 / 0.81e2 * t2388;
  t2390 = t2340 * t45;
  t2391 = t2390 * t148;
  t2392 = 0.5e1 / 0.9e1 * t2391;
  t2393 = t524 * t218;
  t2394 = 0.5e1 / 0.3e1 * t2393;
  t2395 = t524 * t318;
  t2396 = 0.5e1 / 0.3e1 * t2395;
  t2397 = t182 * t591;
  t2398 = 0.5e1 / 0.3e1 * t2397;
  t2399 = t182 * t595;
  t2400 = 0.1e2 / 0.3e1 * t2399;
  t2401 = t553 * t522;
  t2402 = t193 * t2401;
  t2403 = t190 * t2402;
  t2404 = 0.5e2 / 0.27e2 * t2403;
  t2405 = t194 * t2339;
  t2406 = t193 * t2405;
  t2407 = t190 * t2406;
  t2408 = 0.5e2 / 0.81e2 * t2407;
  t2409 = t192 * t589;
  t2411 = t190 * t2409 * t195;
  t2412 = 0.5e2 / 0.27e2 * t2411;
  t2414 = t190 * t549 * t554;
  t2415 = 0.1e3 / 0.27e2 * t2414;
  t2416 = t549 * t558;
  t2417 = t190 * t2416;
  t2418 = 0.5e2 / 0.27e2 * t2417;
  t2419 = t791 * params->c;
  t2420 = t2419 * t180;
  t2422 = t190 * t193 * t2420;
  t2423 = 0.5e2 / 0.27e2 * t2422;
  t2424 = t523 * t189;
  t2425 = t2424 * t196;
  t2426 = 0.1e3 / 0.27e2 * t2425;
  t2427 = t2354 * t66;
  t2428 = t39 * t2427;
  t2429 = t146 * t2356;
  t2431 = t2429 * t2347 * t50;
  t2432 = t2428 * t2431;
  t2433 = 0.1e5 / 0.729e3 * t2432;
  t2434 = t2389 + t2392 + t2394 + t2396 + t2398 + t2400 - t2404 - t2408 - t2412 - t2415 - t2418 - t2423 - t2426 - t2433;
  tv3rho30 = t9 * (t2386 + t2434) + 0.3e1 * t818 + 0.5e1 / 0.3e1 * t794 + 0.3e1 * t815 + 0.6e1 * t816 - 0.1e3 / 0.27e2 * t532 - 0.1e3 / 0.27e2 * t551 - 0.1e3 / 0.27e2 * t556 - 0.5e2 / 0.27e2 * t560 + 0.5e1 / 0.3e1 * t525 + 0.1e2 / 0.3e1 * t534 + 0.1e2 / 0.3e1 * t536 + 0.2e4 / 0.81e2 * t547 + 0.5e1 / 0.3e1 * t592 + 0.1e2 / 0.3e1 * t596;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t2451 = 0.2e1 * t973;
  t2452 = 0.1e3 / 0.81e2 * t859;
  t2453 = 0.1e3 / 0.81e2 * t863;
  t2454 = 0.1e3 / 0.81e2 * t867;
  t2455 = 0.1e3 / 0.81e2 * t873;
  t2456 = 0.1e3 / 0.81e2 * t905;
  t2457 = 0.2e3 / 0.81e2 * t847;
  t2458 = 0.4e4 / 0.243e3 * t856;
  t2459 = 0.2e1 * t972;
  t2460 = 0.2e1 * t971;
  t2461 = t2451 - t2452 - t2453 - t2454 - t2455 - t2456 - t552 - t557 - t561 - t2457 + t2458 + t2459 + t817 + t818 - t533 + t2460 + t815;
  t2462 = t383 * params->c;
  t2463 = t325 * t2462;
  t2464 = t529 * t2463;
  t2467 = t543 * t317 * t854;
  t2469 = t544 * t841;
  t2470 = t2469 * t180;
  t2471 = t147 * t2470;
  t2472 = t543 * t2471;
  t2474 = t853 * t522;
  t2475 = t147 * t2474;
  t2476 = t543 * t2475;
  t2478 = t365 * params->c;
  t2479 = t325 * t2478;
  t2480 = t529 * t2479;
  t2483 = t543 * t217 * t854;
  t2485 = t951 * params->c;
  t2486 = t2485 * t180;
  t2488 = t190 * t193 * t2486;
  t2491 = t190 * t871 * t554;
  t2493 = t871 * t558;
  t2494 = t190 * t2493;
  t2496 = t553 * t841;
  t2497 = t193 * t2496;
  t2498 = t190 * t2497;
  t2501 = 0.2e3 / 0.27e2 * t496 * t337;
  t2503 = 0.1e3 / 0.27e2 * t161 * t824;
  t2505 = 0.5e2 / 0.9e1 * t161 * t828;
  t2507 = t2296 * t336 * t502;
  t2509 = 0.1e2 / 0.27e2 * t7 * t2507;
  t2510 = t7 * t501;
  t2511 = t507 * t167;
  t2513 = 0.2e2 / 0.9e1 * t2510 * t2511;
  t2514 = t823 * t508;
  t2516 = 0.1e2 / 0.9e1 * t7 * t2514;
  t2517 = t15 * t506;
  t2519 = 0.5e1 / 0.3e1 * t7 * t2517;
  t2520 = t827 * t98;
  t2522 = 0.5e1 * t7 * t2520;
  t2524 = 0.5e2 / 0.27e2 * t343 * t514;
  t2526 = 0.25e2 / 0.9e1 * t343 * t518;
  t2528 = t2310 * t346 * t513;
  t2530 = 0.1e2 / 0.27e2 * t22 * t2528;
  t2531 = t22 * t512;
  t2532 = t507 * t171;
  t2534 = 0.2e2 / 0.9e1 * t2531 * t2532;
  t2535 = t833 * t517;
  t2537 = 0.1e2 / 0.9e1 * t22 * t2535;
  t2538 = t26 * t506;
  t2540 = 0.5e1 / 0.3e1 * t22 * t2538;
  t2541 = t837 * t98;
  t2543 = 0.5e1 * t22 * t2541;
  t2544 = t2501 - t2503 - t2505 - t2509 + t2513 + t2516 + t2519 - t2522 - t2524 - t2526 - t2530 - t2534 + t2537 - t2540 + t2543 + t2338;
  t2545 = t194 * t2544;
  t2546 = t193 * t2545;
  t2547 = t190 * t2546;
  t2549 = t192 * t891;
  t2551 = t190 * t2549 * t195;
  t2553 = -0.1e3 / 0.81e2 * t2464 + 0.4e4 / 0.243e3 * t2467 + 0.4e4 / 0.243e3 * t2472 + 0.2e4 / 0.243e3 * t2476 - 0.1e3 / 0.81e2 * t2480 + 0.4e4 / 0.243e3 * t2483 - 0.1e3 / 0.81e2 * t2488 - 0.1e3 / 0.81e2 * t2491 - 0.5e2 / 0.81e2 * t2494 - 0.1e3 / 0.81e2 * t2498 - 0.5e2 / 0.81e2 * t2547 - 0.1e3 / 0.81e2 * t2551;
  t2554 = t2409 * t355;
  t2555 = t190 * t2554;
  t2557 = t549 * t861;
  t2558 = t190 * t2557;
  t2560 = t549 * t865;
  t2561 = t190 * t2560;
  t2563 = t2419 * t350;
  t2564 = t193 * t2563;
  t2565 = t190 * t2564;
  t2567 = t846 * t550;
  t2569 = t846 * t555;
  t2571 = t846 * t559;
  t2573 = t352 * t793;
  t2575 = t2 * t2544;
  t2576 = t2575 * t45;
  t2577 = t2576 * t148;
  t2579 = t843 * t218;
  t2581 = t843 * t318;
  t2583 = t351 * t542;
  t2584 = t2583 * t546;
  t2586 = t352 * t591;
  t2588 = -0.5e2 / 0.81e2 * t2555 - 0.1e3 / 0.81e2 * t2558 - 0.1e3 / 0.81e2 * t2561 - 0.5e2 / 0.81e2 * t2565 - 0.2e3 / 0.81e2 * t2567 - 0.2e3 / 0.81e2 * t2569 - 0.1e3 / 0.81e2 * t2571 + 0.5e1 / 0.9e1 * t2573 + 0.5e1 / 0.9e1 * t2577 + 0.1e2 / 0.9e1 * t2579 + 0.1e2 / 0.9e1 * t2581 + 0.2e4 / 0.81e2 * t2584 + 0.5e1 / 0.9e1 * t2586;
  t2590 = t352 * t595;
  t2592 = t383 * t545;
  t2593 = t543 * t2592;
  t2596 = t55 * t364 * t791;
  t2597 = t46 * t2596;
  t2599 = t524 * t384;
  t2601 = t182 * t908;
  t2603 = t182 * t953;
  t2605 = t524 * t366;
  t2607 = t182 * t893;
  t2609 = t182 * t897;
  t2611 = t365 * t545;
  t2612 = t543 * t2611;
  t2614 = t565 * t361;
  t2616 = t202 * t573;
  t2618 = 0.7e1 / 0.3e1 * t2616 * t880;
  t2619 = t202 * t883;
  t2621 = t62 * t886;
  t2622 = t2621 * t209;
  t2625 = t879 * t583;
  t2628 = t2501 - t2503 - t2505 - t2509 + t2513 + t2516 + t2519 - t2522 - t2524 - t2526 - t2530 - t2534 + t2537 - t2540 + t2543;
  t2629 = t207 * t2628;
  t2633 = 0.7e1 / 0.6e1 * t202 * t887;
  t2634 = t206 * t360;
  t2635 = t59 * t2634;
  t2637 = t579 * t886;
  t2639 = t59 * t2637 / 0.2e1;
  t2640 = t59 * t2263;
  t2641 = t879 * t575;
  t2644 = t8 * t360;
  t2645 = t2644 * t209;
  t2646 = t878 * t2645;
  t2650 = 0.119e3 / 0.18e2 * t2252;
  t2654 = 0.7e1 / 0.6e1 * t2260;
  t2655 = 0.119e3 / 0.36e2 * t2614 + t2618 - 0.7e1 / 0.3e1 * t2619 - t878 * t2622 / 0.2e1 - t878 * t2625 / 0.4e1 + t59 * t2629 / 0.8e1 - t2633 + t2635 / 0.4e1 + t2639 + 0.3e1 / 0.4e1 * t2640 * t2641 - t2646 + 0.7e1 / 0.6e1 * t2254 + t2271 / 0.2e1 + t2249 + 0.119e3 / 0.18e2 * t2250 - t2650 - 0.7e1 / 0.12e2 * t2258 - t2278 / 0.2e1 - t2281 / 0.4e1 - t2654;
  t2657 = t55 * t2655 * t146;
  t2658 = t46 * t2657;
  t2660 = t942 * t67;
  t2662 = 0.36622894612013090108e-3 * t2660 * t308;
  t2663 = t915 * t664;
  t2668 = -t2662 + 0.24415263074675393405e-3 * t2663 + t1914 - t1917 - t1921 - t1927 - 0.18311447306006545054e-3 * t1929 + 0.4883052614935078681e-3 * t1931 - t1937 + t1941 - t1944 + t1947 + t1950 + 0.21687162600603479684e-1 * t1952 - t1957 + t1987;
  t2672 = t253 * t945;
  t2674 = t257 * t945;
  t2677 = 0.8e1 * t253 * t943;
  t2678 = t1993 * t335;
  t2681 = t640 * t8;
  t2692 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2678 * t641 + 0.16e2 / 0.9e1 * t2681 * t506 * t166 + 0.4e1 / 0.9e1 * t925 * t644 + 0.8e1 / 0.3e1 * t103 * t506 - 0.8e1 * t928 * t98);
  t2693 = t2008 * t372;
  t2696 = t650 * t8;
  t2707 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2693 * t651 - 0.16e2 / 0.9e1 * t2696 * t506 * t263 + 0.4e1 / 0.9e1 * t933 * t654 - 0.8e1 / 0.3e1 * t107 * t506 + 0.8e1 * t936 * t98);
  t2709 = (t2692 + t2707) * t113;
  t2712 = t942 * t301;
  t2714 = 0.2e1 * t99 * t2712;
  t2716 = 0.8e1 * t257 * t943;
  t2718 = t1991 - 0.5848223622634646207e0 * t2025 - 0.11696447245269292414e1 * t2027 - t2037 - 0.34631718211362927518e2 * t2038 - t2043 + 0.8e1 * t2672 - 0.8e1 * t2674 + t2677 + t2047 + t2055 + 0.19751673498613801407e-1 * t2709 * t139 + t2714 - t2716 + 0.23392894490538584828e1 * t2056 + t2063;
  t2720 = t2709 * t141;
  t2722 = t773 * t378;
  t2724 = t776 * t378;
  t2726 = t377 * t752;
  t2727 = t99 * t2726;
  t2728 = t770 * t378;
  t2730 = t377 * t70;
  t2731 = t2730 * t780;
  t2734 = t911 * t787;
  t2736 = 0.4e1 * t2194;
  t2737 = t911 * t633;
  t2739 = t911 * t604;
  t2741 = t942 * t129;
  t2743 = 0.11696447245269292414e1 * t2741 * t313;
  t2744 = t99 * t2720 + 0.12e2 * t2722 - 0.32e2 * t2724 + t2727 + 0.2e2 * t2728 + 0.10843581300301739842e-1 * t2731 + 0.2e1 * t2067 + t2191 - t2193 + 0.11696447245269292414e1 * t2734 + t2736 - 0.5848223622634646207e0 * t2737 - 0.17315859105681463759e2 * t2739 - t2743 - t2163 + t2166;
  t2748 = 0.32e2 * t2204;
  t2750 = 0.12e2 * t2213;
  t2752 = 0.48e2 * t2223;
  t2753 = 0.8e2 * t2226;
  t2754 = -0.4e1 * t2196 - 0.4e1 * t2198 + t2170 - 0.16e2 * t2202 - t2748 + 0.4e2 * t2209 + t2212 - t2750 - 0.24e2 * t2215 + t2218 - t2221 + t2752 + t2753 - t2231 - t2187 - t2237;
  t2756 = t2668 + t2718 + t2744 + t2754;
  t2758 = t55 * t66 * t2756;
  t2759 = t46 * t2758;
  t2761 = 0.1e2 / 0.9e1 * t2590 + 0.2e4 / 0.243e3 * t2593 + 0.5e1 / 0.9e1 * t2597 + 0.5e1 / 0.9e1 * t2599 + 0.1e2 / 0.9e1 * t2601 + 0.1e2 / 0.9e1 * t2603 + 0.5e1 / 0.9e1 * t2605 + 0.1e2 / 0.9e1 * t2607 + 0.1e2 / 0.9e1 * t2609 + 0.2e4 / 0.243e3 * t2612 + 0.5e1 / 0.9e1 * t2658 + 0.5e1 / 0.9e1 * t2759;
  t2763 = t55 * t589 * t382;
  t2764 = t46 * t2763;
  t2767 = t55 * t216 * t951;
  t2768 = t46 * t2767;
  t2770 = t814 * t382;
  t2771 = t970 * t316;
  t2774 = t2575 * t40 * t153;
  t2776 = t842 * t188;
  t2779 = t351 * t539;
  t2784 = t2354 * t2356;
  t2785 = t39 * t2784;
  t2787 = t350 * t527 * t50;
  t2790 = t841 * t180;
  t2791 = t806 * t2790;
  t2794 = t350 * t522;
  t2795 = t806 * t2794;
  t2798 = params->c * t2544;
  t2799 = t325 * t2798;
  t2802 = -0.5e1 / 0.9e1 * t2774 + 0.2e3 / 0.81e2 * t2776 * t327 - 0.2e4 / 0.81e2 * t2779 * t807 + 0.1e3 / 0.81e2 * t959 * t811 + 0.1e5 / 0.729e3 * t2785 * t2787 - 0.4e4 / 0.243e3 * t805 * t2791 - 0.2e4 / 0.243e3 * t805 * t2795 + 0.5e2 / 0.81e2 * t324 * t2799;
  t2803 = t2802 * t146;
  t2804 = t156 * t2756;
  t2805 = t902 * t522;
  t2806 = t193 * t2805;
  t2807 = t190 * t2806;
  t2810 = t190 * t549 * t903;
  t2812 = t2353 * t66;
  t2813 = t2812 * t146;
  t2814 = t805 * t2813;
  t2815 = t2356 * t350;
  t2817 = t2815 * t527 * t50;
  t2818 = t2814 * t2817;
  t2820 = t330 * t951;
  t2822 = t394 * t791;
  t2824 = t55 * t891 * t316;
  t2825 = t46 * t2824;
  t2827 = t842 * t189;
  t2828 = t2827 * t196;
  t2830 = 0.5e1 / 0.9e1 * t2764 + 0.1e2 / 0.9e1 * t2768 + t2770 + 0.2e1 * t2771 + t2803 + t2804 - 0.5e2 / 0.81e2 * t2807 - 0.1e3 / 0.81e2 * t2810 - 0.1e5 / 0.729e3 * t2818 + 0.2e1 * t2820 + t2822 + 0.1e2 / 0.9e1 * t2825 - 0.2e3 / 0.81e2 * t2828;
  t2834 = 0.1e2 / 0.9e1 * t954;
  t2835 = 0.1e2 / 0.9e1 * t844;
  t2836 = 0.1e2 / 0.9e1 * t849;
  t2837 = 0.1e2 / 0.9e1 * t851;
  t2838 = 0.1e2 / 0.9e1 * t869;
  t2839 = 0.1e2 / 0.9e1 * t894;
  t2840 = 0.1e2 / 0.9e1 * t898;
  t2841 = 0.1e2 / 0.9e1 * t900;
  t2842 = 0.1e2 / 0.9e1 * t909;
  t2843 = 0.2e1 * t974;
  t2844 = t9 * (t2553 + t2588 + t2761 + t2830) + t2834 + t2835 + t2836 + t2837 + t2838 + t2839 + t2840 + t2841 + t2842 + t537 + t548 + t593 + t597 + t795 + t526 + t535 + t2843;
  tv3rho31 = t2461 + t2844;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t2845 = t2451 - t1027 - t1031 - t1035 - t2452 - t2453 - t2454 - t2455 - t2456 - t2457 - t1016 + t2458 + t1105 + t1106 + t2459 + t1103 + t1050;
  t2847 = t253 * t1073;
  t2849 = t257 * t1073;
  t2852 = t1993 * t1055;
  t2857 = t640 * t1058;
  t2862 = -0.2e1 * t506 - 0.6e1 * t2000;
  t2866 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2852 * t166 + 0.16e2 / 0.9e1 * t925 * t507 + 0.4e1 / 0.9e1 * t2857 * t166 + 0.4e1 / 0.3e1 * t103 * t2862);
  t2867 = t2008 * t1063;
  t2872 = t650 * t1066;
  t2875 = -t2862;
  t2879 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2867 * t263 - 0.16e2 / 0.9e1 * t933 * t507 + 0.4e1 / 0.9e1 * t2872 * t263 + 0.4e1 / 0.3e1 * t107 * t2875);
  t2881 = (t2866 + t2879) * t113;
  t2882 = t2881 * t141;
  t2884 = t1072 * t301;
  t2885 = t99 * t2884;
  t2886 = -t2662 + 0.48830526149350786811e-3 * t2663 + 0.4e1 * t2847 - 0.4e1 * t2849 + t1914 - t1917 - t1921 - t1927 + 0.24415263074675393405e-3 * t1931 - t1937 + t1941 + t99 * t2882 + t2885 - t1944 + t1947 + t1950;
  t2888 = t1072 * t67;
  t2889 = t2888 * t308;
  t2894 = t1072 * t129;
  t2895 = t2894 * t313;
  t2899 = 0.10843581300301739842e-1 * t1952 - t1957 + t1987 + t1991 - 0.18311447306006545054e-3 * t2889 + 0.19751673498613801407e-1 * t2881 * t139 - 0.5848223622634646207e0 * t2027 - 0.5848223622634646207e0 * t2895 - t2037 - 0.17315859105681463759e2 * t2038 - t2043 - 0.16e2 * t2674 - t2677 + t2047 + t2055 + t2714;
  t2909 = -t2716 + 0.11696447245269292414e1 * t2056 + t2063 - 0.24e2 * t2722 + 0.2e1 * t2727 + 0.4e2 * t2728 + 0.21687162600603479684e-1 * t2731 + t2067 + t2191 - t2193 + 0.23392894490538584828e1 * t2734 - t2736 - 0.11696447245269292414e1 * t2737 - 0.34631718211362927517e2 * t2739 - t2743 - t2163;
  t2915 = t2166 + t2170 - 0.8e1 * t2200 - 0.8e1 * t2202 + t2748 + 0.32e2 * t2207 + 0.2e2 * t2209 + t2212 - t2750 + 0.12e2 * t2215 + t2221 + t2752 - t2753 - t2231 - t2187 - t2237;
  t2917 = t2886 + t2899 + t2909 + t2915;
  t2919 = t55 * t66 * t2917;
  t2920 = t46 * t2919;
  t2922 = t549 * t1032;
  t2923 = t190 * t2922;
  t2925 = t846 * t904;
  t2927 = t2549 * t355;
  t2928 = t190 * t2927;
  t2930 = t871 * t861;
  t2931 = t190 * t2930;
  t2933 = t1008 * t189;
  t2934 = t2933 * t196;
  t2936 = t846 * t866;
  t2938 = t846 * t872;
  t2940 = t1102 * t316;
  t2944 = t202 * t1038;
  t2946 = t62 * t1037;
  t2947 = t2946 * t209;
  t2950 = t2269 * t1037;
  t2951 = t59 * t2950;
  t2953 = t879 * t886;
  t2957 = t202 * t1043;
  t2959 = t62 * t1042;
  t2960 = t2959 * t209;
  t2963 = t579 * t1042;
  t2964 = t59 * t2963;
  t2967 = 0.5e2 / 0.27e2 * t161 * t984;
  t2968 = t2296 * t983;
  t2969 = t2968 * t167;
  t2971 = 0.1e2 / 0.27e2 * t7 * t2969;
  t2972 = t336 * t8;
  t2973 = t2972 * t506;
  t2975 = 0.2e2 / 0.9e1 * t2510 * t2973;
  t2977 = 0.25e2 / 0.9e1 * t161 * t988;
  t2978 = t501 * t987;
  t2979 = t2978 * t167;
  t2981 = 0.1e2 / 0.9e1 * t7 * t2979;
  t2983 = -t506 - 0.3e1 * t2000;
  t2984 = t15 * t2983;
  t2986 = 0.5e1 / 0.3e1 * t7 * t2984;
  t2988 = 0.2e3 / 0.27e2 * t994 * t172;
  t2990 = 0.1e3 / 0.27e2 * t343 * t834;
  t2992 = 0.5e2 / 0.9e1 * t343 * t838;
  t2993 = t2310 * t999;
  t2994 = t2993 * t171;
  t2996 = 0.1e2 / 0.27e2 * t22 * t2994;
  t2997 = t346 * t8;
  t2998 = t2997 * t506;
  t3000 = 0.2e2 / 0.9e1 * t2531 * t2998;
  t3001 = t512 * t1003;
  t3002 = t3001 * t171;
  t3004 = 0.1e2 / 0.9e1 * t22 * t3002;
  t3005 = -t2983;
  t3006 = t26 * t3005;
  t3008 = 0.5e1 / 0.3e1 * t22 * t3006;
  t3009 = -t2967 - t2971 + t2975 - t2977 + t2981 + t2986 + t2988 - t2990 + t2992 - t2996 - t3000 + t3004 + t3008;
  t3010 = t207 * t3009;
  t3014 = t2249 + 0.119e3 / 0.36e2 * t2250 + t2650 + 0.119e3 / 0.18e2 * t2614 + t2618 - t2633 + 0.7e1 / 0.3e1 * t2256 - t2654 + 0.7e1 / 0.6e1 * t2944 + 0.3e1 / 0.4e1 * t2640 * t2947 - t2951 / 0.2e1 - t878 * t2953 / 0.2e1 + t2646 - t2635 / 0.2e1 - t2639 - 0.7e1 / 0.12e2 * t2957 - t878 * t2960 / 0.4e1 + t2964 / 0.4e1 + t59 * t3010 / 0.8e1 + t2278 / 0.4e1;
  t3016 = t55 * t3014 * t146;
  t3017 = t46 * t3016;
  t3020 = t55 * t1046 * t316;
  t3021 = t46 * t3020;
  t3023 = t182 * t1052;
  t3025 = 0.5e1 / 0.9e1 * t2920 - 0.5e2 / 0.81e2 * t2923 - 0.2e3 / 0.81e2 * t2925 - 0.1e3 / 0.81e2 * t2928 - 0.1e3 / 0.81e2 * t2931 - 0.1e3 / 0.81e2 * t2934 - 0.2e3 / 0.81e2 * t2936 - 0.2e3 / 0.81e2 * t2938 + t2940 + 0.5e1 / 0.9e1 * t3017 + 0.5e1 / 0.9e1 * t3021 + 0.1e2 / 0.9e1 * t3023;
  t3027 = t55 * t891 * t382;
  t3028 = t46 * t3027;
  t3031 = t55 * t364 * t951;
  t3032 = t46 * t3031;
  t3034 = t182 * t1086;
  t3036 = -t2967 - t2971 + t2975 - t2977 + t2981 + t2986 + t2988 - t2990 + t2992 - t2996 - t3000 + t3004 + t3008 + t2338;
  t3037 = t2 * t3036;
  t3038 = t3037 * t45;
  t3039 = t3038 * t148;
  t3041 = t1009 * t218;
  t3043 = t1009 * t318;
  t3045 = t1013 * t542;
  t3046 = t147 * t1896;
  t3047 = t3045 * t3046;
  t3049 = t843 * t366;
  t3051 = t352 * t893;
  t3053 = t352 * t897;
  t3055 = t843 * t384;
  t3057 = t352 * t908;
  t3059 = t352 * t953;
  t3061 = 0.1e2 / 0.9e1 * t3028 + 0.1e2 / 0.9e1 * t3032 + 0.5e1 / 0.9e1 * t3034 + 0.5e1 / 0.9e1 * t3039 + 0.5e1 / 0.9e1 * t3041 + 0.5e1 / 0.9e1 * t3043 + 0.2e4 / 0.81e2 * t3047 + 0.1e2 / 0.9e1 * t3049 + 0.1e2 / 0.9e1 * t3051 + 0.1e2 / 0.9e1 * t3053 + 0.1e2 / 0.9e1 * t3055 + 0.1e2 / 0.9e1 * t3057 + 0.1e2 / 0.9e1 * t3059;
  t3063 = t217 * t1021;
  t3064 = t543 * t3063;
  t3066 = t317 * t1021;
  t3067 = t543 * t3066;
  t3069 = t182 * t1048;
  t3071 = t2356 * t1012;
  t3073 = t3071 * t180 * t50;
  t3074 = t2814 * t3073;
  t3076 = t970 * t382;
  t3079 = t3037 * t40 * t153;
  t3081 = t1008 * t188;
  t3086 = t1013 * t539;
  t3087 = t806 * t180;
  t3091 = t1012 * t180 * t50;
  t3094 = t350 * t841;
  t3095 = t806 * t3094;
  t3098 = t1007 * t180;
  t3099 = t806 * t3098;
  t3102 = params->c * t3036;
  t3103 = t325 * t3102;
  t3106 = -0.5e1 / 0.9e1 * t3079 + 0.1e3 / 0.81e2 * t3081 * t327 + 0.2e3 / 0.81e2 * t959 * t967 - 0.2e4 / 0.81e2 * t3086 * t3087 + 0.1e5 / 0.729e3 * t2785 * t3091 - 0.4e4 / 0.243e3 * t805 * t3095 - 0.2e4 / 0.243e3 * t805 * t3099 + 0.5e2 / 0.81e2 * t324 * t3103;
  t3107 = t3106 * t146;
  t3108 = t394 * t951;
  t3110 = t383 * t854;
  t3111 = t543 * t3110;
  t3113 = t544 * t1007;
  t3114 = t3113 * t180;
  t3115 = t147 * t3114;
  t3116 = t543 * t3115;
  t3118 = t853 * t841;
  t3119 = t147 * t3118;
  t3120 = t543 * t3119;
  t3122 = t365 * t854;
  t3123 = t543 * t3122;
  t3125 = t1014 * t1902;
  t3127 = 0.2e4 / 0.243e3 * t3064 + 0.2e4 / 0.243e3 * t3067 + 0.5e1 / 0.9e1 * t3069 - 0.1e5 / 0.729e3 * t3074 + 0.2e1 * t3076 + t3107 + 0.2e1 * t3108 + 0.4e4 / 0.243e3 * t3111 + 0.2e4 / 0.243e3 * t3116 + 0.4e4 / 0.243e3 * t3120 + 0.4e4 / 0.243e3 * t3123 - 0.1e3 / 0.81e2 * t3125;
  t3128 = t1014 * t1906;
  t3131 = t55 * t216 * t1084;
  t3132 = t46 * t3131;
  t3134 = t156 * t2917;
  t3135 = t330 * t1084;
  t3136 = t1084 * params->c;
  t3137 = t3136 * t180;
  t3138 = t193 * t3137;
  t3139 = t190 * t3138;
  t3141 = t553 * t1007;
  t3142 = t193 * t3141;
  t3143 = t190 * t3142;
  t3145 = t194 * t3036;
  t3146 = t193 * t3145;
  t3147 = t190 * t3146;
  t3149 = t192 * t1046;
  t3150 = t3149 * t195;
  t3151 = t190 * t3150;
  t3153 = t871 * t903;
  t3154 = t190 * t3153;
  t3156 = t871 * t865;
  t3157 = t190 * t3156;
  t3159 = t549 * t1028;
  t3160 = t190 * t3159;
  t3162 = t2485 * t350;
  t3163 = t193 * t3162;
  t3164 = t190 * t3163;
  t3166 = t902 * t841;
  t3167 = t193 * t3166;
  t3168 = t190 * t3167;
  t3170 = -0.1e3 / 0.81e2 * t3128 + 0.5e1 / 0.9e1 * t3132 + t3134 + t3135 - 0.5e2 / 0.81e2 * t3139 - 0.5e2 / 0.81e2 * t3143 - 0.5e2 / 0.81e2 * t3147 - 0.5e2 / 0.81e2 * t3151 - 0.1e3 / 0.81e2 * t3154 - 0.1e3 / 0.81e2 * t3157 - 0.1e3 / 0.81e2 * t3160 - 0.1e3 / 0.81e2 * t3164 - 0.1e3 / 0.81e2 * t3168;
  t3174 = t1054 + t1088 + t2460 + t9 * (t3025 + t3061 + t3127 + t3170) + t1011 + t1018 + t1020 + t1024 + t2834 + t2835 + t2836 + t2837 + t2838 + t2839 + t2840 + t2841 + t2842 + t2843;
  tv3rho32 = t2845 + t3174;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t3175 = t1012 * t350;
  t3176 = t2 * t3175;
  t3177 = t3176 * t539;
  t3178 = t3177 * t2373;
  t3179 = 0.2e4 / 0.81e2 * t3178;
  t3180 = t394 * t1084;
  t3181 = 0.3e1 * t3180;
  t3182 = t1055 * t335;
  t3187 = -t506 - t2000;
  t3188 = 0.6e1 * t3187;
  t3192 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t1993 * t3182 + 0.4e1 / 0.3e1 * t925 * t1058 + 0.4e1 / 0.3e1 * t103 * t3188);
  t3193 = t1063 * t372;
  t3198 = -t3188;
  t3202 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2008 * t3193 + 0.4e1 / 0.3e1 * t933 * t1066 + 0.4e1 / 0.3e1 * t107 * t3198);
  t3204 = (t3192 + t3202) * t113;
  t3211 = 0.19751673498613801407e-1 * t3204 * t139 + 0.73245789224026180216e-3 * t2663 - 0.12e2 * t2847 - 0.12e2 * t2849 + t1914 - t1917 - t1921 - t1927 - t1937 + t1941 + 0.3e1 * t2885 - t1944;
  t3216 = t1947 + t1950 - t1957 + t1987 + t1991 - 0.54934341918019635162e-3 * t2889 - 0.17544670867903938621e1 * t2895 - t2037 - t2043 - 0.24e2 * t2672 - 0.24e2 * t2674 + t2047 + t2055;
  t3218 = t3204 * t141;
  t3227 = t2063 + t99 * t3218 + 0.36e2 * t2722 + 0.96e2 * t2724 + 0.3e1 * t2727 + 0.6e2 * t2728 + 0.32530743900905219526e-1 * t2731 + t2191 - t2193 + 0.35089341735807877242e1 * t2734 - t2195 - 0.17544670867903938621e1 * t2737;
  t3229 = -0.51947577317044391276e2 * t2739 - t2163 + t2166 + t2170 + t2205 + t2212 + t2214 - t2221 - t2224 - t2227 - t2231 - t2187 - t2237;
  t3231 = t3211 + t3216 + t3227 + t3229;
  t3232 = t156 * t3231;
  t3234 = t2429 * t3175 * t50;
  t3235 = t2428 * t3234;
  t3236 = 0.1e5 / 0.729e3 * t3235;
  t3237 = t1102 * t382;
  t3238 = 0.3e1 * t3237;
  t3239 = t983 * t336;
  t3240 = t2296 * t3239;
  t3242 = 0.1e2 / 0.27e2 * t7 * t3240;
  t3243 = t823 * t987;
  t3245 = 0.1e2 / 0.3e1 * t7 * t3243;
  t3246 = 0.3e1 * t3187;
  t3247 = t15 * t3246;
  t3249 = 0.5e1 / 0.3e1 * t7 * t3247;
  t3250 = t340 * t340;
  t3252 = 0.1e1 / t19 / t3250;
  t3253 = tau[1] * t3252;
  t3255 = 0.44e3 / 0.27e2 * t3253 * t27;
  t3257 = 0.2e3 / 0.9e1 * t994 * t347;
  t3259 = 0.5e2 / 0.9e1 * t343 * t1000;
  t3261 = 0.25e2 / 0.3e1 * t343 * t1004;
  t3262 = t999 * t346;
  t3263 = t2310 * t3262;
  t3265 = 0.1e2 / 0.27e2 * t22 * t3263;
  t3266 = t833 * t1003;
  t3268 = 0.1e2 / 0.3e1 * t22 * t3266;
  t3269 = -t3246;
  t3270 = t26 * t3269;
  t3272 = 0.5e1 / 0.3e1 * t22 * t3270;
  t3273 = -t3242 + t3245 + t3249 - t3255 + t3257 - t3259 - t3261 - t3265 + t3268 + t3272 + t2338;
  t3274 = t2 * t3273;
  t3276 = t3274 * t40 * t153;
  t3283 = t2356 * t3175 * t50;
  t3286 = t350 * t1007;
  t3287 = t806 * t3286;
  t3290 = params->c * t3273;
  t3291 = t325 * t3290;
  t3294 = -0.5e1 / 0.9e1 * t3276 + 0.1e3 / 0.27e2 * t3081 * t391 - 0.2e4 / 0.81e2 * t3176 * t2349 + 0.1e5 / 0.729e3 * t2355 * t3283 - 0.2e4 / 0.81e2 * t805 * t3287 + 0.5e2 / 0.81e2 * t324 * t3291;
  t3295 = t3294 * t146;
  t3296 = t365 * t1021;
  t3297 = t543 * t3296;
  t3298 = 0.2e4 / 0.81e2 * t3297;
  t3299 = t383 * t1021;
  t3300 = t543 * t3299;
  t3301 = 0.2e4 / 0.81e2 * t3300;
  t3302 = t352 * t1048;
  t3303 = 0.5e1 / 0.3e1 * t3302;
  t3304 = t352 * t1052;
  t3305 = 0.1e2 / 0.3e1 * t3304;
  t3306 = t352 * t1086;
  t3307 = 0.5e1 / 0.3e1 * t3306;
  t3308 = t3274 * t45;
  t3309 = t3308 * t148;
  t3310 = 0.5e1 / 0.9e1 * t3309;
  t3311 = t1009 * t366;
  t3312 = 0.5e1 / 0.3e1 * t3311;
  t3313 = t1009 * t384;
  t3314 = 0.5e1 / 0.3e1 * t3313;
  t3315 = t3179 + t3181 + t3232 - t3236 + t3238 + t3295 + t3298 + t3301 + t3303 + t3305 + t3307 + t3310 + t3312 + t3314;
  t3317 = t55 * t66 * t3231;
  t3318 = t46 * t3317;
  t3319 = 0.5e1 / 0.9e1 * t3318;
  t3324 = t1037 * t360;
  t3325 = t2264 * t3324;
  t3329 = t879 * t1042;
  t3334 = -t3242 + t3245 + t3249 - t3255 + t3257 - t3259 - t3261 - t3265 + t3268 + t3272;
  t3335 = t207 * t3334;
  t3338 = t2249 + 0.119e3 / 0.12e2 * t2614 + t2253 + 0.7e1 / 0.2e1 * t2944 + 0.7e1 * t2619 - 0.7e1 / 0.4e1 * t2957 + t2261 + 0.3e1 / 0.4e1 * t59 * t3325 + 0.3e1 / 0.2e1 * t2951 - 0.3e1 / 0.4e1 * t878 * t3329 + 0.3e1 / 0.4e1 * t2635 - 0.3e1 / 0.4e1 * t2964 + t59 * t3335 / 0.8e1;
  t3340 = t55 * t3338 * t146;
  t3341 = t46 * t3340;
  t3342 = 0.5e1 / 0.9e1 * t3341;
  t3344 = t55 * t1046 * t382;
  t3345 = t46 * t3344;
  t3346 = 0.5e1 / 0.3e1 * t3345;
  t3348 = t55 * t364 * t1084;
  t3349 = t46 * t3348;
  t3350 = 0.5e1 / 0.3e1 * t3349;
  t3351 = t2933 * t356;
  t3352 = 0.1e3 / 0.27e2 * t3351;
  t3353 = t902 * t1007;
  t3354 = t193 * t3353;
  t3355 = t190 * t3354;
  t3356 = 0.5e2 / 0.27e2 * t3355;
  t3357 = t194 * t3273;
  t3358 = t193 * t3357;
  t3359 = t190 * t3358;
  t3360 = 0.5e2 / 0.81e2 * t3359;
  t3362 = t190 * t871 * t1028;
  t3363 = 0.1e3 / 0.27e2 * t3362;
  t3364 = t871 * t1032;
  t3365 = t190 * t3364;
  t3366 = 0.5e2 / 0.27e2 * t3365;
  t3367 = t3136 * t350;
  t3369 = t190 * t193 * t3367;
  t3370 = 0.5e2 / 0.27e2 * t3369;
  t3372 = t190 * t3149 * t355;
  t3373 = 0.5e2 / 0.27e2 * t3372;
  t3374 = t853 * t1007;
  t3375 = t147 * t3374;
  t3376 = t543 * t3375;
  t3377 = 0.2e4 / 0.81e2 * t3376;
  t3378 = t1014 * t2479;
  t3379 = 0.1e3 / 0.27e2 * t3378;
  t3380 = t1014 * t2463;
  t3381 = 0.1e3 / 0.27e2 * t3380;
  t3382 = t3319 + t3342 + t3346 + t3350 - t3352 - t3356 - t3360 - t3363 - t3366 - t3370 - t3373 + t3377 - t3379 - t3381;
  tv3rho33 = t9 * (t3315 + t3382) + 0.3e1 * t1106 + 0.3e1 * t1103 + 0.6e1 * t1104 + 0.5e1 / 0.3e1 * t1087 + 0.5e1 / 0.3e1 * t1010 + 0.1e2 / 0.3e1 * t1017 + 0.1e2 / 0.3e1 * t1019 + 0.2e4 / 0.81e2 * t1023 + 0.5e1 / 0.3e1 * t1049 + 0.1e2 / 0.3e1 * t1053 - 0.1e3 / 0.27e2 * t1015 - 0.1e3 / 0.27e2 * t1026 - 0.1e3 / 0.27e2 * t1030 - 0.5e2 / 0.27e2 * t1034;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t3399 = t399 * t542;
  t3400 = t3399 * t546;
  t3401 = 0.25e3 / 0.81e2 * t3400;
  t3402 = t400 * t591;
  t3403 = 0.5e1 / 0.72e2 * t3402;
  t3404 = t400 * t595;
  t3405 = 0.5e1 / 0.36e2 * t3404;
  t3406 = t1142 * t146;
  t3407 = t55 * t3406;
  t3408 = t46 * t3407;
  t3409 = 0.5e1 / 0.36e2 * t3408;
  t3410 = t544 * t177;
  t3411 = t3410 * t180;
  t3412 = t147 * t3411;
  t3413 = t543 * t3412;
  t3414 = 0.4e4 / 0.729e3 * t3413;
  t3415 = t400 * t793;
  t3416 = 0.5e1 / 0.72e2 * t3415;
  t3417 = t1110 * t218;
  t3418 = 0.1e2 / 0.27e2 * t3417;
  t3419 = t1110 * t318;
  t3420 = 0.1e2 / 0.27e2 * t3419;
  t3421 = t2 * t58;
  t3422 = t3421 * t45;
  t3423 = t3422 * t148;
  t3424 = 0.55e2 / 0.81e2 * t3423;
  t3425 = t1143 * t558;
  t3426 = t1141 * t3425;
  t3427 = 0.25e2 / 0.324e3 * t3426;
  t3428 = t2356 * t35;
  t3430 = t3428 * t527 * t50;
  t3431 = t2814 * t3430;
  t3432 = 0.125e4 / 0.729e3 * t3431;
  t3433 = t1143 * t554;
  t3434 = t1141 * t3433;
  t3435 = 0.25e2 / 0.162e3 * t3434;
  t3436 = -t3401 - t3403 - t3405 - t3409 + t3414 - t3416 + t3418 + t3420 - t3424 + t3427 + t3432 + t3435;
  t3437 = t201 * t61;
  t3438 = t3437 * t62;
  t3440 = t1141 * t3438 * t195;
  t3441 = 0.175e3 / 0.243e3 * t3440;
  t3442 = t1142 * t8;
  t3444 = t1141 * t3442 * t195;
  t3445 = 0.25e2 / 0.81e2 * t3444;
  t3446 = t1147 * t1161;
  t3447 = t407 * t3446;
  t3448 = 0.35e2 / 0.54e2 * t3447;
  t3449 = t213 * t316;
  t3450 = t408 * t3449;
  t3451 = t407 * t3450;
  t3452 = 0.5e1 / 0.18e2 * t3451;
  t3453 = t63 * t791;
  t3454 = t408 * t3453;
  t3455 = t407 * t3454;
  t3456 = 0.5e1 / 0.72e2 * t3455;
  t3457 = t523 * t50;
  t3458 = t3457 * t410;
  t3459 = 0.5e1 / 0.72e2 * t3458;
  t3460 = t1136 * t1162;
  t3461 = 0.5e1 / 0.36e2 * t3460;
  t3462 = t542 * t58;
  t3463 = t39 * t3462;
  t3464 = t1295 * t527;
  t3465 = t63 * t3464;
  t3466 = t3463 * t3465;
  t3467 = 0.25e3 / 0.243e3 * t3466;
  t3468 = t2409 * t403;
  t3469 = t190 * t3468;
  t3470 = 0.25e2 / 0.324e3 * t3469;
  t3471 = t549 * t1128;
  t3472 = t190 * t3471;
  t3473 = 0.25e2 / 0.162e3 * t3472;
  t3474 = t1147 * t206;
  t3475 = t3474 * t1153;
  t3476 = t407 * t3475;
  t3477 = 0.35e2 / 0.54e2 * t3476;
  t3478 = t408 * t573;
  t3479 = t1152 * t575;
  t3480 = t3478 * t3479;
  t3481 = t407 * t3480;
  t3482 = 0.5e1 / 0.36e2 * t3481;
  t3483 = -t3441 + t3445 + t3448 - t3452 - t3456 - t3459 - t3461 - t3467 + t3470 + t3473 - t3477 - t3482;
  t3485 = t8 * t146;
  t3486 = t3485 * t209;
  t3487 = t1151 * t3486;
  t3488 = t407 * t3487;
  t3489 = 0.5e1 / 0.18e2 * t3488;
  t3490 = t62 * t316;
  t3491 = t3490 * t209;
  t3492 = t1151 * t3491;
  t3493 = t407 * t3492;
  t3494 = 0.5e1 / 0.36e2 * t3493;
  t3495 = t1152 * t583;
  t3496 = t1151 * t3495;
  t3497 = t407 * t3496;
  t3498 = 0.5e1 / 0.72e2 * t3497;
  t3499 = t1136 * t1154;
  t3500 = 0.5e1 / 0.36e2 * t3499;
  t3501 = t528 * t189;
  t3502 = t192 * t58;
  t3503 = t3502 * t61;
  t3504 = t3503 * t1651;
  t3505 = t3501 * t3504;
  t3506 = 0.25e2 / 0.162e3 * t3505;
  t3507 = t180 * t209;
  t3508 = t194 * t3507;
  t3509 = t1354 * t3508;
  t3510 = t1141 * t3509;
  t3511 = 0.25e2 / 0.162e3 * t3510;
  t3512 = t217 * t1121;
  t3513 = t543 * t3512;
  t3514 = 0.5e3 / 0.243e3 * t3513;
  t3515 = t317 * t1121;
  t3516 = t543 * t3515;
  t3517 = 0.5e3 / 0.243e3 * t3516;
  t3518 = t1120 * t522;
  t3519 = t147 * t3518;
  t3520 = t543 * t3519;
  t3521 = 0.25e3 / 0.243e3 * t3520;
  t3522 = t1179 * t316;
  t3523 = 0.2e1 * t3522;
  t3525 = t3421 * t40 * t153;
  t3526 = 0.55e2 / 0.81e2 * t3525;
  t3527 = t1109 * t188;
  t3528 = t3527 * t327;
  t3529 = 0.2e3 / 0.243e3 * t3528;
  t3530 = t399 * t539;
  t3531 = t3530 * t807;
  t3533 = t1168 * t811;
  t3537 = t2785 * t35 * t527 * t50;
  t3540 = t806 * t177 * t180;
  t3541 = t805 * t3540;
  t3542 = 0.4e4 / 0.729e3 * t3541;
  t3544 = t806 * t35 * t522;
  t3545 = t805 * t3544;
  t3549 = t324 * t325 * params->c * t58;
  t3550 = 0.55e3 / 0.729e3 * t3549;
  t3551 = t3526 + t3529 + 0.25e3 / 0.81e2 * t3531 - 0.25e2 / 0.162e3 * t3533 - 0.125e4 / 0.729e3 * t3537 - t3542 + 0.25e3 / 0.243e3 * t3545 - t3550;
  t3552 = t3551 * t146;
  t3553 = t420 * t791;
  t3554 = t3489 + t3494 + t3498 + t3500 + t3506 - t3511 - t3514 - t3517 - t3521 + t3523 + t3552 + t3553;
  t3555 = t2419 * t35;
  t3556 = t193 * t3555;
  t3557 = t190 * t3556;
  t3558 = 0.25e2 / 0.324e3 * t3557;
  t3559 = t1113 * t550;
  t3560 = 0.25e2 / 0.81e2 * t3559;
  t3561 = t1113 * t555;
  t3562 = 0.25e2 / 0.81e2 * t3561;
  t3563 = t1113 * t559;
  t3564 = 0.25e2 / 0.162e3 * t3563;
  t3565 = t1109 * t189;
  t3566 = t3565 * t196;
  t3567 = 0.2e3 / 0.243e3 * t3566;
  t3568 = t1147 * t1157;
  t3569 = t407 * t3568;
  t3570 = 0.35e2 / 0.27e2 * t3569;
  t3571 = t194 * t58;
  t3573 = t190 * t193 * t3571;
  t3574 = 0.55e3 / 0.729e3 * t3573;
  t3575 = t1136 * t1148;
  t3576 = 0.35e2 / 0.54e2 * t3575;
  t3577 = t1136 * t1158;
  t3578 = 0.5e1 / 0.18e2 * t3577;
  t3579 = t54 * t564;
  t3580 = t3579 * t409;
  t3581 = t407 * t3580;
  t3582 = 0.595e3 / 0.324e3 * t3581;
  t3584 = t190 * t549 * t1132;
  t3585 = 0.1e3 / 0.243e3 * t3584;
  t3586 = t553 * t177;
  t3588 = t190 * t193 * t3586;
  t3589 = 0.1e3 / 0.243e3 * t3588;
  t3590 = t3558 + t3560 + t3562 + t3564 - t3567 + t3570 + t3574 + t3576 - t3578 - t3582 - t3585 - t3589;
  tv3rho2sigma0 = t9 * (t3436 + t3483 + t3554 + t3590) + 0.2e1 * t1180 + 0.2e1 * t1181 - t1191 + t1194 + t1195 - t1196 + t1193 - t1186 - t1187 - t1188 + t1184 + t1185 + t1189 + t1190 - t1192 - t1197;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t3596 = 0.5e3 / 0.81e2 * t3400;
  t3597 = 0.5e1 / 0.36e2 * t3402;
  t3598 = 0.5e1 / 0.18e2 * t3404;
  t3599 = 0.5e1 / 0.18e2 * t3408;
  t3600 = 0.8e4 / 0.729e3 * t3413;
  t3601 = 0.5e1 / 0.36e2 * t3415;
  t3602 = 0.2e2 / 0.27e2 * t3417;
  t3603 = 0.2e2 / 0.27e2 * t3419;
  t3604 = 0.11e3 / 0.81e2 * t3423;
  t3605 = 0.25e2 / 0.162e3 * t3426;
  t3606 = 0.25e4 / 0.729e3 * t3431;
  t3607 = 0.25e2 / 0.81e2 * t3434;
  t3608 = -t3596 - t3597 - t3598 - t3599 + t3600 - t3601 + t3602 + t3603 - t3604 + t3605 + t3606 + t3607;
  t3609 = 0.35e3 / 0.243e3 * t3440;
  t3610 = 0.5e2 / 0.81e2 * t3444;
  t3611 = t1202 * t316;
  t3612 = 0.2e1 * t3611;
  t3613 = 0.11e3 / 0.81e2 * t3525;
  t3620 = 0.11e4 / 0.729e3 * t3549;
  t3621 = t3613 + 0.4e3 / 0.243e3 * t3528 + 0.5e3 / 0.81e2 * t3531 - 0.25e2 / 0.81e2 * t3533 - 0.25e4 / 0.729e3 * t3537 - 0.8e4 / 0.729e3 * t3541 + 0.5e3 / 0.243e3 * t3545 - t3620;
  t3622 = t3621 * t146;
  t3623 = 0.35e2 / 0.27e2 * t3447;
  t3624 = 0.5e1 / 0.9e1 * t3451;
  t3625 = 0.5e1 / 0.36e2 * t3455;
  t3626 = 0.5e1 / 0.36e2 * t3458;
  t3627 = 0.5e1 / 0.18e2 * t3460;
  t3628 = 0.5e3 / 0.243e3 * t3466;
  t3629 = 0.25e2 / 0.162e3 * t3469;
  t3630 = 0.25e2 / 0.81e2 * t3472;
  t3631 = -t3609 + t3610 + t3612 + t3622 + t3623 - t3624 - t3625 - t3626 - t3627 - t3628 + t3629 + t3630;
  t3633 = t428 * t791;
  t3634 = 0.35e2 / 0.27e2 * t3476;
  t3635 = 0.5e1 / 0.18e2 * t3481;
  t3636 = 0.5e1 / 0.9e1 * t3488;
  t3637 = 0.5e1 / 0.18e2 * t3493;
  t3638 = 0.5e1 / 0.36e2 * t3497;
  t3639 = 0.5e1 / 0.18e2 * t3499;
  t3640 = 0.25e2 / 0.81e2 * t3505;
  t3641 = 0.25e2 / 0.81e2 * t3510;
  t3642 = 0.1e4 / 0.243e3 * t3513;
  t3643 = 0.1e4 / 0.243e3 * t3516;
  t3644 = 0.5e3 / 0.243e3 * t3520;
  t3645 = t3633 - t3634 - t3635 + t3636 + t3637 + t3638 + t3639 + t3640 - t3641 - t3642 - t3643 - t3644;
  t3646 = 0.25e2 / 0.162e3 * t3557;
  t3647 = 0.5e2 / 0.81e2 * t3559;
  t3648 = 0.5e2 / 0.81e2 * t3561;
  t3649 = 0.25e2 / 0.81e2 * t3563;
  t3650 = 0.4e3 / 0.243e3 * t3566;
  t3651 = 0.7e2 / 0.27e2 * t3569;
  t3652 = 0.11e4 / 0.729e3 * t3573;
  t3653 = 0.35e2 / 0.27e2 * t3575;
  t3654 = 0.5e1 / 0.9e1 * t3577;
  t3655 = 0.595e3 / 0.162e3 * t3581;
  t3656 = 0.2e3 / 0.243e3 * t3584;
  t3657 = 0.2e3 / 0.243e3 * t3588;
  t3658 = t3646 + t3647 + t3648 + t3649 - t3650 + t3651 + t3652 + t3653 - t3654 - t3655 - t3656 - t3657;
  t3664 = 0.2e3 / 0.243e3 * t1134;
  t3665 = 0.35e2 / 0.27e2 * t1149;
  t3667 = 0.5e1 / 0.9e1 * t1159;
  t3672 = 0.2e2 / 0.27e2 * t1111;
  tv3rho2sigma1 = t9 * (t3608 + t3631 + t3645 + t3658) + 0.2e1 * t1204 + 0.2e1 * t1203 - t3664 + t3665 + 0.5e1 / 0.18e2 * t1155 - t3667 + 0.25e2 / 0.81e2 * t1145 - 0.5e1 / 0.18e2 * t1116 - 0.5e1 / 0.18e2 * t1118 - 0.1e4 / 0.243e3 * t1123 + t3672 + 0.5e2 / 0.81e2 * t1114 + 0.25e2 / 0.81e2 * t1126 + 0.25e2 / 0.81e2 * t1130 - 0.5e1 / 0.18e2 * t1137 - 0.5e1 / 0.18e2 * t1163;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t3678 = t1179 * t382;
  t3680 = t217 * t1213;
  t3681 = t543 * t3680;
  t3683 = t317 * t1213;
  t3684 = t543 * t3683;
  t3686 = t1120 * t841;
  t3687 = t147 * t3686;
  t3688 = t543 * t3687;
  t3690 = t365 * t1121;
  t3691 = t543 * t3690;
  t3693 = t383 * t1121;
  t3694 = t543 * t3693;
  t3696 = t3399 * t855;
  t3698 = t1147 * t1234;
  t3699 = t407 * t3698;
  t3701 = t213 * t382;
  t3702 = t408 * t3701;
  t3703 = t407 * t3702;
  t3705 = t1224 * t1148;
  t3707 = t1224 * t1158;
  t3709 = t1113 * t904;
  t3711 = t2549 * t403;
  t3712 = t190 * t3711;
  t3714 = t1113 * t858;
  t3716 = t1113 * t862;
  t3718 = t1113 * t866;
  t3720 = t3678 + t3409 + 0.2e4 / 0.729e3 * t3413 - 0.25e3 / 0.243e3 * t3681 - 0.25e3 / 0.243e3 * t3684 - 0.25e3 / 0.243e3 * t3688 - 0.25e3 / 0.243e3 * t3691 - 0.25e3 / 0.243e3 * t3694 - 0.25e3 / 0.81e2 * t3696 + 0.35e2 / 0.108e3 * t3699 - 0.5e1 / 0.36e2 * t3703 + 0.35e2 / 0.108e3 * t3705 - 0.5e1 / 0.36e2 * t3707 + 0.25e2 / 0.162e3 * t3709 + 0.25e2 / 0.324e3 * t3712 + 0.25e2 / 0.162e3 * t3714 + 0.25e2 / 0.162e3 * t3716 + 0.25e2 / 0.162e3 * t3718;
  t3721 = t1113 * t872;
  t3723 = t3565 * t356;
  t3726 = t190 * t871 * t1132;
  t3728 = t902 * t177;
  t3730 = t190 * t193 * t3728;
  t3732 = t1136 * t1235;
  t3734 = t63 * t951;
  t3735 = t408 * t3734;
  t3736 = t407 * t3735;
  t3738 = t871 * t1128;
  t3739 = t190 * t3738;
  t3741 = t549 * t1220;
  t3742 = t190 * t3741;
  t3744 = t2485 * t35;
  t3745 = t193 * t3744;
  t3746 = t190 * t3745;
  t3748 = t842 * t50;
  t3749 = t3748 * t410;
  t3751 = t1224 * t1162;
  t3755 = t351 * t185;
  t3756 = t3755 * t1140;
  t3757 = t3756 * t1144;
  t3760 = t1141 * t1143 * t861;
  t3762 = t1143 * t865;
  t3763 = t1141 * t3762;
  t3765 = t1514 * t209;
  t3766 = t1338 * t3765;
  t3767 = t154 * t3766;
  t3769 = 0.25e2 / 0.162e3 * t3721 - 0.1e3 / 0.243e3 * t3723 - 0.5e2 / 0.243e3 * t3726 - 0.5e2 / 0.243e3 * t3730 - 0.5e1 / 0.72e2 * t3732 - 0.5e1 / 0.72e2 * t3736 + 0.25e2 / 0.324e3 * t3739 + 0.25e2 / 0.324e3 * t3742 + 0.25e2 / 0.324e3 * t3746 - 0.5e1 / 0.72e2 * t3749 - 0.5e1 / 0.72e2 * t3751 + 0.5e1 / 0.27e2 * t3417 + 0.5e1 / 0.27e2 * t3419 - t3424 + 0.25e2 / 0.162e3 * t3757 + 0.25e2 / 0.324e3 * t3760 + 0.25e2 / 0.324e3 * t3763 - 0.5e1 / 0.36e2 * t3767;
  t3771 = t1143 * t903;
  t3772 = t1141 * t3771;
  t3774 = t3438 * t355;
  t3775 = t1141 * t3774;
  t3777 = t3442 * t355;
  t3778 = t1141 * t3777;
  t3782 = t420 * t951;
  t3787 = t3474 * t1230;
  t3788 = t407 * t3787;
  t3790 = t3485 * t360;
  t3791 = t1151 * t3790;
  t3792 = t407 * t3791;
  t3794 = t62 * t382;
  t3795 = t3794 * t209;
  t3796 = t1151 * t3795;
  t3797 = t407 * t3796;
  t3799 = t1224 * t1154;
  t3801 = t409 * t854;
  t3802 = t3463 * t3801;
  t3804 = t1136 * t1231;
  t3806 = t3490 * t360;
  t3807 = t1151 * t3806;
  t3808 = t407 * t3807;
  t3810 = t1152 * t886;
  t3811 = t1151 * t3810;
  t3812 = t407 * t3811;
  t3814 = 0.25e2 / 0.324e3 * t3772 - 0.175e3 / 0.486e3 * t3775 + 0.25e2 / 0.162e3 * t3778 - 0.175e3 / 0.486e3 * t3440 - 0.25e2 / 0.162e3 * t3444 + t3782 + 0.35e2 / 0.108e3 * t3447 + 0.5e1 / 0.36e2 * t3451 - 0.35e2 / 0.108e3 * t3476 - 0.5e1 / 0.36e2 * t3488 - 0.35e2 / 0.108e3 * t3788 + 0.5e1 / 0.36e2 * t3792 + 0.5e1 / 0.72e2 * t3797 + 0.5e1 / 0.72e2 * t3799 - 0.25e3 / 0.243e3 * t3802 + 0.5e1 / 0.72e2 * t3804 + 0.5e1 / 0.72e2 * t3808 + 0.5e1 / 0.72e2 * t3812;
  t3815 = t1244 * t316;
  t3817 = t3527 * t391;
  t3819 = t3530 * t963;
  t3821 = t1168 * t967;
  t3824 = t1240 * t180 * t50;
  t3825 = t2785 * t3824;
  t3827 = t177 * t350;
  t3828 = t806 * t3827;
  t3829 = t805 * t3828;
  t3831 = t35 * t841;
  t3832 = t806 * t3831;
  t3833 = t805 * t3832;
  t3836 = t3526 + 0.1e3 / 0.243e3 * t3528 + 0.1e3 / 0.243e3 * t3817 + 0.25e3 / 0.81e2 * t3819 - 0.25e2 / 0.162e3 * t3821 - 0.125e4 / 0.729e3 * t3825 - 0.2e4 / 0.729e3 * t3829 + 0.25e3 / 0.243e3 * t3833 - 0.2e4 / 0.729e3 * t3541 - t3550;
  t3837 = t3836 * t146;
  t3838 = t1110 * t366;
  t3840 = t1110 * t384;
  t3842 = t400 * t893;
  t3844 = t400 * t897;
  t3846 = t400 * t908;
  t3853 = t3410 * t350;
  t3854 = t147 * t3853;
  t3855 = t543 * t3854;
  t3857 = t1514 * t326;
  t3858 = t1354 * t3857;
  t3859 = t1141 * t3858;
  t3861 = t3428 * t350;
  t3863 = t180 * t40 * t152;
  t3864 = t3861 * t3863;
  t3865 = t2814 * t3864;
  t3867 = t350 * t209;
  t3868 = t194 * t3867;
  t3869 = t1354 * t3868;
  t3870 = t1141 * t3869;
  t3872 = t400 * t953;
  t3874 = t3815 + t3837 + 0.5e1 / 0.27e2 * t3838 + 0.5e1 / 0.27e2 * t3840 - 0.5e1 / 0.72e2 * t3842 - 0.5e1 / 0.72e2 * t3844 - 0.5e1 / 0.72e2 * t3846 - 0.1e3 / 0.243e3 * t3566 + t3574 + 0.35e2 / 0.108e3 * t3575 + 0.5e1 / 0.36e2 * t3577 - t3582 - 0.5e2 / 0.243e3 * t3584 - 0.5e2 / 0.243e3 * t3588 + 0.2e4 / 0.729e3 * t3855 - 0.25e2 / 0.324e3 * t3859 + 0.125e4 / 0.729e3 * t3865 - 0.25e2 / 0.324e3 * t3870 - 0.5e1 / 0.72e2 * t3872;
  t3878 = t1208 + t1219 + t1223 - t1226 - t1237 - t1164 + t1115 + t1127 + t1131 - t1191 - t1138 + t1194 + t9 * (t3720 + t3769 + t3814 + t3874) + t1180;
  t3879 = t1181 - t1216 - t1124 - t1210 - t1212 + t1184 - t1117 - t1119 + t1233 + t1156 + t1246 + t1245 + t1229 + t1146;
  tv3rho2sigma3 = t3878 + t3879;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t3880 = t1249 + t1253 + t1254 - t1255 - t1258 - t1197 + t1185 + t1189 + t1190 - t3664 - t1192 + t3665 - t1252 - t1188;
  t3881 = 0.5e3 / 0.243e3 * t3681;
  t3882 = 0.5e3 / 0.243e3 * t3684;
  t3883 = 0.5e3 / 0.243e3 * t3688;
  t3884 = 0.5e3 / 0.243e3 * t3691;
  t3885 = 0.5e3 / 0.243e3 * t3694;
  t3886 = 0.5e3 / 0.81e2 * t3696;
  t3887 = 0.35e2 / 0.54e2 * t3699;
  t3888 = 0.5e1 / 0.18e2 * t3703;
  t3889 = 0.35e2 / 0.54e2 * t3705;
  t3890 = 0.5e1 / 0.18e2 * t3707;
  t3891 = 0.25e2 / 0.81e2 * t3709;
  t3892 = 0.25e2 / 0.162e3 * t3712;
  t3893 = 0.25e2 / 0.81e2 * t3714;
  t3894 = 0.25e2 / 0.81e2 * t3716;
  t3895 = 0.25e2 / 0.81e2 * t3718;
  t3896 = 0.25e2 / 0.81e2 * t3721;
  t3897 = t3599 + t3414 - t3881 - t3882 - t3883 - t3884 - t3885 - t3886 + t3887 - t3888 + t3889 - t3890 + t3891 + t3892 + t3893 + t3894 + t3895 + t3896;
  t3898 = 0.2e3 / 0.243e3 * t3723;
  t3899 = 0.1e3 / 0.243e3 * t3726;
  t3900 = 0.1e3 / 0.243e3 * t3730;
  t3901 = 0.5e1 / 0.36e2 * t3732;
  t3902 = 0.5e1 / 0.36e2 * t3736;
  t3903 = 0.25e2 / 0.162e3 * t3739;
  t3904 = 0.25e2 / 0.162e3 * t3742;
  t3905 = 0.25e2 / 0.162e3 * t3746;
  t3906 = 0.5e1 / 0.36e2 * t3749;
  t3907 = 0.5e1 / 0.36e2 * t3751;
  t3908 = 0.25e2 / 0.81e2 * t3757;
  t3909 = 0.25e2 / 0.162e3 * t3760;
  t3910 = 0.25e2 / 0.162e3 * t3763;
  t3911 = 0.5e1 / 0.18e2 * t3767;
  t3912 = 0.25e2 / 0.162e3 * t3772;
  t3913 = -t3898 - t3899 - t3900 - t3901 - t3902 + t3903 + t3904 + t3905 - t3906 - t3907 + t3418 + t3420 - t3604 + t3908 + t3909 + t3910 - t3911 + t3912;
  t3915 = 0.175e3 / 0.243e3 * t3775;
  t3916 = 0.25e2 / 0.81e2 * t3778;
  t3917 = t1261 * t316;
  t3918 = 0.2e3 / 0.243e3 * t3817;
  t3922 = 0.4e4 / 0.729e3 * t3829;
  t3924 = t3613 + t3529 + t3918 + 0.5e3 / 0.81e2 * t3819 - 0.25e2 / 0.81e2 * t3821 - 0.25e4 / 0.729e3 * t3825 - t3922 + 0.5e3 / 0.243e3 * t3833 - t3542 - t3620;
  t3925 = t3924 * t146;
  t3926 = 0.35e2 / 0.54e2 * t3788;
  t3927 = 0.5e1 / 0.18e2 * t3792;
  t3928 = 0.5e1 / 0.36e2 * t3797;
  t3929 = 0.5e1 / 0.36e2 * t3799;
  t3930 = 0.5e3 / 0.243e3 * t3802;
  t3931 = 0.5e1 / 0.36e2 * t3804;
  t3932 = 0.5e1 / 0.36e2 * t3808;
  t3933 = 0.5e1 / 0.36e2 * t3812;
  t3934 = -t3915 + t3916 - t3441 - t3445 + t3448 + t3452 + t3917 + t3925 - t3477 - t3489 - t3926 + t3927 + t3928 + t3929 - t3930 + t3931 + t3932 + t3933;
  t3935 = t428 * t951;
  t3936 = t1202 * t382;
  t3937 = 0.1e2 / 0.27e2 * t3838;
  t3938 = 0.1e2 / 0.27e2 * t3840;
  t3939 = 0.5e1 / 0.36e2 * t3842;
  t3940 = 0.5e1 / 0.36e2 * t3844;
  t3941 = 0.5e1 / 0.36e2 * t3846;
  t3942 = 0.4e4 / 0.729e3 * t3855;
  t3943 = 0.25e2 / 0.162e3 * t3859;
  t3944 = 0.25e4 / 0.729e3 * t3865;
  t3945 = 0.25e2 / 0.162e3 * t3870;
  t3946 = 0.5e1 / 0.36e2 * t3872;
  t3947 = t3935 + t3936 + t3937 + t3938 - t3939 - t3940 - t3941 - t3567 + t3652 + t3576 + t3578 - t3655 - t3585 - t3589 + t3942 - t3943 + t3944 - t3945 - t3946;
  t3951 = -t1250 - t1251 + t3672 - t1186 - t1187 + t1204 + t1257 + t1195 + t1256 + t1193 + t9 * (t3897 + t3913 + t3934 + t3947) + t1262 + t1263 + t1203;
  tv3rho2sigma4 = t3880 + t3951;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t3952 = t1152 * t1037;
  t3953 = t3478 * t3952;
  t3954 = t407 * t3953;
  t3955 = 0.5e1 / 0.36e2 * t3954;
  t3957 = t1141 * t1143 * t1032;
  t3958 = 0.25e2 / 0.324e3 * t3957;
  t3960 = t3428 * t1012 * t50;
  t3961 = t2814 * t3960;
  t3962 = 0.125e4 / 0.729e3 * t3961;
  t3964 = t1141 * t1143 * t1028;
  t3965 = 0.25e2 / 0.162e3 * t3964;
  t3966 = -t3409 - t3955 + t3958 + t3962 + t3965 + t3887 + t3888 + t3889 + t3890 - t3898 - t3899 - t3900;
  t3967 = t1224 * t1231;
  t3968 = 0.5e1 / 0.36e2 * t3967;
  t3969 = t1013 * t189;
  t3970 = t3969 * t3504;
  t3971 = 0.25e2 / 0.162e3 * t3970;
  t3972 = t3794 * t360;
  t3973 = t1151 * t3972;
  t3974 = t407 * t3973;
  t3975 = 0.5e1 / 0.36e2 * t3974;
  t3976 = t1152 * t1042;
  t3977 = t1151 * t3976;
  t3978 = t407 * t3977;
  t3979 = 0.5e1 / 0.72e2 * t3978;
  t3980 = t400 * t1086;
  t3981 = 0.5e1 / 0.72e2 * t3980;
  t3982 = t3399 * t1022;
  t3983 = 0.25e3 / 0.81e2 * t3982;
  t3984 = t400 * t1048;
  t3985 = 0.5e1 / 0.72e2 * t3984;
  t3986 = t400 * t1052;
  t3987 = 0.5e1 / 0.36e2 * t3986;
  t3988 = t383 * t1213;
  t3989 = t543 * t3988;
  t3990 = 0.5e3 / 0.243e3 * t3989;
  t3991 = t1120 * t1007;
  t3992 = t147 * t3991;
  t3993 = t543 * t3992;
  t3994 = 0.25e3 / 0.243e3 * t3993;
  t3995 = t365 * t1213;
  t3996 = t543 * t3995;
  t3997 = 0.5e3 / 0.243e3 * t3996;
  t3998 = t3968 + t3971 + t3975 + t3979 - t3981 - t3983 - t3985 - t3987 - t3424 - t3990 - t3994 - t3997;
  t4000 = t871 * t1220;
  t4001 = t190 * t4000;
  t4002 = 0.25e2 / 0.162e3 * t4001;
  t4003 = t3136 * t35;
  t4004 = t193 * t4003;
  t4005 = t190 * t4004;
  t4006 = 0.25e2 / 0.324e3 * t4005;
  t4007 = t1113 * t1025;
  t4008 = 0.25e2 / 0.81e2 * t4007;
  t4009 = t1113 * t1029;
  t4010 = 0.25e2 / 0.81e2 * t4009;
  t4011 = t1113 * t1033;
  t4012 = 0.25e2 / 0.162e3 * t4011;
  t4013 = t63 * t1084;
  t4014 = t408 * t4013;
  t4015 = t407 * t4014;
  t4016 = 0.5e1 / 0.72e2 * t4015;
  t4017 = t1008 * t50;
  t4018 = t4017 * t410;
  t4019 = 0.5e1 / 0.72e2 * t4018;
  t4020 = t1224 * t1235;
  t4021 = 0.5e1 / 0.36e2 * t4020;
  t4022 = t1295 * t1012;
  t4023 = t63 * t4022;
  t4024 = t3463 * t4023;
  t4025 = 0.25e3 / 0.243e3 * t4024;
  t4026 = t3149 * t403;
  t4027 = t190 * t4026;
  t4028 = 0.25e2 / 0.324e3 * t4027;
  t4029 = -t3915 - t3916 + t4002 + t4006 + t4008 + t4010 + t4012 - t4016 - t4019 - t4021 - t4025 + t4028;
  t4030 = t1244 * t382;
  t4031 = 0.2e1 * t4030;
  t4032 = t3530 * t1095;
  t4034 = t1168 * t1099;
  t4036 = t35 * t1012;
  t4038 = t2785 * t4036 * t50;
  t4040 = t35 * t1007;
  t4041 = t806 * t4040;
  t4042 = t805 * t4041;
  t4044 = t3526 + t3918 + 0.25e3 / 0.81e2 * t4032 - 0.25e2 / 0.162e3 * t4034 - 0.125e4 / 0.729e3 * t4038 - t3922 + 0.25e3 / 0.243e3 * t4042 - t3550;
  t4045 = t4044 * t146;
  t4046 = t350 * t360;
  t4047 = t194 * t4046;
  t4048 = t1354 * t4047;
  t4049 = t1141 * t4048;
  t4050 = 0.25e2 / 0.162e3 * t4049;
  t4051 = t420 * t1084;
  t4052 = t4031 + t4045 - t4050 - t3926 - t3927 + t4051 + t3937 + t3938 - t3570 + t3574 - t3582 + t3942;
  tv3rho2sigma6 = t9 * (t3966 + t3998 + t4029 + t4052) + 0.2e1 * t1245 + 0.2e1 * t1246 + t1257 - t1191 + t1194 + t1196 + t1256 - t1250 - t1251 - t1252 + t1184 + t1249 + t1253 + t1254 - t1255 - t1258;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  t4058 = t1261 * t382;
  t4059 = 0.2e1 * t4058;
  t4066 = t3613 + 0.4e3 / 0.243e3 * t3817 + 0.5e3 / 0.81e2 * t4032 - 0.25e2 / 0.81e2 * t4034 - 0.25e4 / 0.729e3 * t4038 - 0.8e4 / 0.729e3 * t3829 + 0.5e3 / 0.243e3 * t4042 - t3620;
  t4067 = t4066 * t146;
  t4068 = 0.5e1 / 0.18e2 * t3954;
  t4069 = 0.25e2 / 0.162e3 * t3957;
  t4070 = 0.25e4 / 0.729e3 * t3961;
  t4071 = 0.25e2 / 0.81e2 * t3964;
  t4072 = 0.35e2 / 0.27e2 * t3699;
  t4073 = 0.5e1 / 0.9e1 * t3703;
  t4074 = 0.35e2 / 0.27e2 * t3705;
  t4075 = 0.5e1 / 0.9e1 * t3707;
  t4076 = 0.4e3 / 0.243e3 * t3723;
  t4077 = -t3599 + t4059 + t4067 - t4068 + t4069 + t4070 + t4071 + t4072 + t4073 + t4074 + t4075 - t4076;
  t4078 = 0.2e3 / 0.243e3 * t3726;
  t4079 = 0.2e3 / 0.243e3 * t3730;
  t4080 = 0.5e1 / 0.18e2 * t3967;
  t4081 = 0.25e2 / 0.81e2 * t3970;
  t4082 = 0.5e1 / 0.18e2 * t3974;
  t4083 = 0.5e1 / 0.36e2 * t3978;
  t4084 = 0.5e1 / 0.36e2 * t3980;
  t4085 = 0.5e3 / 0.81e2 * t3982;
  t4086 = 0.5e1 / 0.36e2 * t3984;
  t4087 = 0.5e1 / 0.18e2 * t3986;
  t4088 = 0.1e4 / 0.243e3 * t3989;
  t4089 = -t4078 - t4079 + t4080 + t4081 + t4082 + t4083 - t4084 - t4085 - t4086 - t4087 - t3604 - t4088;
  t4091 = 0.5e3 / 0.243e3 * t3993;
  t4092 = 0.1e4 / 0.243e3 * t3996;
  t4093 = 0.35e3 / 0.243e3 * t3775;
  t4094 = 0.5e2 / 0.81e2 * t3778;
  t4095 = 0.25e2 / 0.81e2 * t4001;
  t4096 = 0.25e2 / 0.162e3 * t4005;
  t4097 = 0.5e2 / 0.81e2 * t4007;
  t4098 = 0.5e2 / 0.81e2 * t4009;
  t4099 = 0.25e2 / 0.81e2 * t4011;
  t4100 = 0.5e1 / 0.36e2 * t4015;
  t4101 = 0.5e1 / 0.36e2 * t4018;
  t4102 = 0.5e1 / 0.18e2 * t4020;
  t4103 = -t4091 - t4092 - t4093 - t4094 + t4095 + t4096 + t4097 + t4098 + t4099 - t4100 - t4101 - t4102;
  t4104 = 0.5e3 / 0.243e3 * t4024;
  t4105 = 0.25e2 / 0.162e3 * t4027;
  t4106 = 0.25e2 / 0.81e2 * t4049;
  t4107 = 0.35e2 / 0.27e2 * t3788;
  t4108 = 0.5e1 / 0.9e1 * t3792;
  t4109 = t428 * t1084;
  t4110 = 0.2e2 / 0.27e2 * t3838;
  t4111 = 0.2e2 / 0.27e2 * t3840;
  t4112 = 0.8e4 / 0.729e3 * t3855;
  t4113 = -t4104 + t4105 - t4106 - t4107 - t4108 + t4109 + t4110 + t4111 - t3651 + t3652 - t3655 + t4112;
  tv3rho2sigma7 = t9 * (t4077 + t4089 + t4103 + t4113) + 0.2e1 * t1262 + 0.2e1 * t1263 + 0.5e1 / 0.18e2 * t1232 - t3664 + t3665 + t3667 + 0.25e2 / 0.81e2 * t1228 - 0.5e1 / 0.18e2 * t1209 - 0.5e1 / 0.18e2 * t1211 - 0.1e4 / 0.243e3 * t1215 + t3672 + 0.5e2 / 0.81e2 * t1207 + 0.25e2 / 0.81e2 * t1218 + 0.25e2 / 0.81e2 * t1222 - 0.5e1 / 0.18e2 * t1225 - 0.5e1 / 0.18e2 * t1236;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t4129 = t160 * t16;
  t4130 = t4129 * t180;
  t4131 = t1295 * t4130;
  t4132 = t1294 * t4131;
  t4133 = 0.2e5 / 0.729e3 * t4132;
  t4134 = t501 * t40;
  t4135 = t4134 * t44;
  t4136 = t431 * t4135;
  t4138 = t55 * t147 * t502;
  t4139 = t4136 * t4138;
  t4140 = 0.5e2 / 0.81e2 * t4139;
  t4141 = t1266 * t1271;
  t4142 = t4141 * t1274;
  t4143 = 0.25e3 / 0.81e2 * t4142;
  t4145 = t55 * t217 * t167;
  t4146 = t1272 * t4145;
  t4147 = 0.5e2 / 0.27e2 * t4146;
  t4149 = t55 * t317 * t167;
  t4150 = t1272 * t4149;
  t4151 = 0.5e2 / 0.27e2 * t4150;
  t4153 = t55 * t147 * t508;
  t4154 = t1272 * t4153;
  t4155 = 0.25e2 / 0.27e2 * t4154;
  t4156 = t1301 * t1310;
  t4157 = t190 * t4156;
  t4158 = 0.5e3 / 0.243e3 * t4157;
  t4159 = t1305 * t1310;
  t4160 = t190 * t4159;
  t4161 = 0.5e3 / 0.243e3 * t4160;
  t4163 = params->c * t495 * t16;
  t4164 = t439 * t4163;
  t4165 = t190 * t4164;
  t4166 = 0.2e4 / 0.729e3 * t4165;
  t4167 = t1295 * t6;
  t4168 = t15 * t180;
  t4169 = t4168 * t167;
  t4170 = t4167 * t4169;
  t4171 = t1294 * t4170;
  t4172 = 0.2e5 / 0.729e3 * t4171;
  t4173 = t2409 * t146;
  t4174 = t4173 * t441;
  t4175 = t190 * t4174;
  t4176 = 0.5e2 / 0.81e2 * t4175;
  t4177 = t549 * t316;
  t4178 = t4177 * t441;
  t4179 = t190 * t4178;
  t4180 = 0.1e3 / 0.81e2 * t4179;
  t4181 = t193 * t791;
  t4182 = t4181 * t441;
  t4183 = t190 * t4182;
  t4184 = 0.5e2 / 0.81e2 * t4183;
  t4185 = t1266 * t1278;
  t4186 = t4185 * t1281;
  t4187 = 0.1e4 / 0.243e3 * t4186;
  t4188 = t325 * t216;
  t4189 = t4188 * t195;
  t4190 = t1279 * t4189;
  t4191 = 0.2e3 / 0.81e2 * t4190;
  t4192 = t1280 * t554;
  t4193 = t1279 * t4192;
  t4194 = 0.2e3 / 0.81e2 * t4193;
  t4195 = t1280 * t558;
  t4196 = t1279 * t4195;
  t4197 = 0.1e3 / 0.81e2 * t4196;
  t4199 = t152 * t1284 * t316;
  t4200 = t433 * t4199;
  t4201 = 0.1e2 / 0.9e1 * t4200;
  t4203 = t152 * t434 * t791;
  t4204 = t433 * t4203;
  t4205 = 0.5e1 / 0.9e1 * t4204;
  t4206 = -t4133 + t4140 - t4143 + t4147 + t4151 + t4155 + t4158 + t4161 - t4166 + t4172 - t4176 - t4180 - t4184 + t4187 - t4191 - t4194 - t4197 + t4201 + t4205;
  t4207 = t2 * t495;
  t4208 = t4207 * t432;
  t4209 = t4208 * t436;
  t4210 = 0.2e3 / 0.81e2 * t4209;
  t4211 = t1267 * t1286;
  t4212 = 0.5e2 / 0.27e2 * t4211;
  t4213 = t1267 * t1290;
  t4214 = 0.5e2 / 0.27e2 * t4213;
  t4215 = t16 * t539;
  t4216 = t431 * t4215;
  t4217 = t2372 * t3464;
  t4218 = t4216 * t4217;
  t4219 = 0.2e4 / 0.81e2 * t4218;
  t4220 = t54 * t589;
  t4222 = t152 * t4220 * t146;
  t4223 = t433 * t4222;
  t4224 = 0.5e1 / 0.9e1 * t4223;
  t4225 = t1337 * t446;
  t4226 = t15 * t146;
  t4227 = t209 * t167;
  t4228 = t4226 * t4227;
  t4229 = t4225 * t4228;
  t4230 = t1336 * t4229;
  t4231 = 0.25e2 / 0.54e2 * t4230;
  t4232 = t1360 * t326;
  t4233 = t1325 * t4232;
  t4234 = t1323 * t4233;
  t4235 = 0.25e2 / 0.162e3 * t4234;
  t4236 = t447 * t810;
  t4237 = t1325 * t4236;
  t4238 = t1323 * t4237;
  t4239 = 0.25e2 / 0.324e3 * t4238;
  t4240 = t321 * t1335;
  t4241 = t4240 * t1341;
  t4242 = 0.5e1 / 0.18e2 * t4241;
  t4243 = t4240 * t1357;
  t4244 = 0.25e2 / 0.108e3 * t4243;
  t4245 = t6 * t501;
  t4246 = t146 * t502;
  t4247 = t4245 * t4246;
  t4248 = t1354 * t4247;
  t4249 = t1336 * t4248;
  t4250 = 0.25e2 / 0.324e3 * t4249;
  t4251 = t58 * t2263;
  t4252 = t4251 * t62;
  t4253 = t146 * t575;
  t4254 = t1296 * t4253;
  t4255 = t4252 * t4254;
  t4256 = t1336 * t4255;
  t4257 = 0.5e1 / 0.12e2 * t4256;
  t4258 = t1337 * t8;
  t4259 = t4258 * t1340;
  t4260 = t1336 * t4259;
  t4261 = 0.5e1 / 0.9e1 * t4260;
  t4262 = t4129 * t1339;
  t4263 = t1338 * t4262;
  t4264 = t1336 * t4263;
  t4265 = 0.25e2 / 0.54e2 * t4264;
  t4266 = t8 * t160;
  t4267 = t4266 * t447;
  t4268 = t445 * t4267;
  t4269 = t154 * t4268;
  t4270 = 0.25e2 / 0.54e2 * t4269;
  t4271 = t62 * t495;
  t4272 = t4271 * t447;
  t4273 = t445 * t4272;
  t4274 = t154 * t4273;
  t4275 = 0.25e2 / 0.81e2 * t4274;
  t4276 = t565 * t206;
  t4277 = t4276 * t448;
  t4278 = t154 * t4277;
  t4279 = 0.595e3 / 0.324e3 * t4278;
  t4280 = t1330 * t1345;
  t4281 = t154 * t4280;
  t4282 = 0.35e2 / 0.27e2 * t4281;
  t4283 = t1330 * t1350;
  t4284 = t154 * t4283;
  t4285 = 0.175e3 / 0.162e3 * t4284;
  t4286 = t4210 - t4212 - t4214 + t4219 + t4224 - t4231 - t4235 - t4239 - t4242 + t4244 + t4250 + t4257 - t4261 + t4265 - t4270 + t4275 + t4279 - t4282 + t4285;
  t4288 = t322 * t1331;
  t4289 = 0.35e2 / 0.54e2 * t4288;
  t4290 = t322 * t1346;
  t4291 = 0.5e1 / 0.18e2 * t4290;
  t4292 = t322 * t1351;
  t4293 = 0.25e2 / 0.108e3 * t4292;
  t4294 = t1296 * t522;
  t4295 = t1295 * t4294;
  t4296 = t1294 * t4295;
  t4297 = 0.2e4 / 0.243e3 * t4296;
  t4298 = t542 * t216;
  t4299 = t39 * t4298;
  t4300 = t4299 * t1298;
  t4301 = 0.4e4 / 0.243e3 * t4300;
  t4302 = t316 * t544;
  t4303 = t4302 * t1297;
  t4304 = t1294 * t4303;
  t4305 = 0.4e4 / 0.243e3 * t4304;
  t4306 = t160 * t15;
  t4307 = t4306 * t167;
  t4308 = t530 * t4307;
  t4309 = t1141 * t4308;
  t4310 = 0.25e4 / 0.729e3 * t4309;
  t4311 = t431 * t15;
  t4312 = t4311 * t189;
  t4313 = t167 * params->c;
  t4314 = t4313 * t180;
  t4316 = t4312 * t439 * t4314;
  t4317 = 0.1e4 / 0.243e3 * t4316;
  t4318 = t445 * t1703;
  t4319 = t154 * t4318;
  t4320 = 0.5e1 / 0.36e2 * t4319;
  t4321 = t4245 * t502;
  t4323 = t1141 * t530 * t4321;
  t4324 = 0.5e3 / 0.729e3 * t4323;
  t4325 = t1314 * t508;
  t4326 = t530 * t4325;
  t4327 = t1141 * t4326;
  t4328 = 0.25e3 / 0.243e3 * t4327;
  t4329 = t1901 * t1315;
  t4330 = t1141 * t4329;
  t4331 = 0.5e3 / 0.243e3 * t4330;
  t4332 = t1905 * t1315;
  t4333 = t1141 * t4332;
  t4334 = 0.5e3 / 0.243e3 * t4333;
  t4335 = t316 * t167;
  t4336 = t1314 * t4335;
  t4337 = t1354 * t4336;
  t4338 = t1336 * t4337;
  t4339 = 0.25e2 / 0.108e3 * t4338;
  t4340 = t146 * t508;
  t4341 = t1314 * t4340;
  t4342 = t1354 * t4341;
  t4343 = t1336 * t4342;
  t4344 = 0.25e2 / 0.216e3 * t4343;
  t4345 = t1324 * t8;
  t4346 = t4345 * t1356;
  t4347 = t1336 * t4346;
  t4348 = 0.25e2 / 0.54e2 * t4347;
  t4349 = t4306 * t1355;
  t4350 = t1354 * t4349;
  t4351 = t1336 * t4350;
  t4352 = 0.125e3 / 0.324e3 * t4351;
  t4353 = t799 * t1322;
  t4354 = t1354 * t1695;
  t4355 = t4353 * t4354;
  t4356 = 0.25e2 / 0.162e3 * t4355;
  t4357 = t201 * t573;
  t4358 = t4357 * t62;
  t4359 = t4358 * t1340;
  t4360 = t1336 * t4359;
  t4361 = 0.35e2 / 0.27e2 * t4360;
  t4362 = -t4289 + t4291 - t4293 + t4297 + t4301 + t4305 + t4310 - t4317 + t4320 - t4324 - t4328 - t4331 - t4334 + t4339 + t4344 + t4348 - t4352 - t4356 + t4361;
  t4363 = t201 * t206;
  t4364 = t4363 * t62;
  t4365 = t4364 * t1356;
  t4366 = t1336 * t4365;
  t4367 = 0.175e3 / 0.162e3 * t4366;
  t4368 = t316 * t209;
  t4369 = t1296 * t4368;
  t4370 = t1338 * t4369;
  t4371 = t1336 * t4370;
  t4372 = 0.5e1 / 0.18e2 * t4371;
  t4373 = t146 * t583;
  t4374 = t1296 * t4373;
  t4375 = t1338 * t4374;
  t4376 = t1336 * t4375;
  t4377 = 0.5e1 / 0.36e2 * t4376;
  t4378 = t4363 * t446;
  t4379 = t4378 * t1326;
  t4380 = t1323 * t4379;
  t4381 = 0.175e3 / 0.243e3 * t4380;
  t4382 = t1324 * t1344;
  t4383 = t4382 * t1326;
  t4384 = t1323 * t4383;
  t4385 = 0.25e2 / 0.81e2 * t4384;
  t4386 = t1324 * t1349;
  t4387 = t4386 * t1326;
  t4388 = t1323 * t4387;
  t4389 = 0.125e3 / 0.486e3 * t4388;
  t4390 = t1344 * t1360;
  t4391 = t445 * t4390;
  t4392 = t154 * t4391;
  t4393 = 0.5e1 / 0.18e2 * t4392;
  t4394 = t1349 * t1360;
  t4395 = t445 * t4394;
  t4396 = t154 * t4395;
  t4397 = 0.25e2 / 0.108e3 * t4396;
  t4398 = t16 * t791;
  t4399 = t446 * t4398;
  t4400 = t445 * t4399;
  t4401 = t154 * t4400;
  t4402 = 0.5e1 / 0.72e2 * t4401;
  t4403 = t797 * t449;
  t4404 = 0.5e1 / 0.72e2 * t4403;
  t4405 = t322 * t1362;
  t4406 = 0.5e1 / 0.36e2 * t4405;
  t4407 = t541 * t30;
  t4408 = t4407 * t58;
  t4409 = t805 * t4408;
  t4410 = t207 * t6;
  t4411 = t447 * t545;
  t4412 = t4410 * t4411;
  t4413 = t4409 * t4412;
  t4414 = 0.25e3 / 0.243e3 * t4413;
  t4415 = t1330 * t1361;
  t4416 = t154 * t4415;
  t4417 = 0.35e2 / 0.54e2 * t4416;
  t4418 = t2356 * t6;
  t4419 = t4418 * t16;
  t4420 = t527 * t40;
  t4421 = t4420 * t152;
  t4422 = t4419 * t4421;
  t4423 = t2814 * t4422;
  t4424 = 0.1e5 / 0.729e3 * t4423;
  t4425 = t1389 * t316;
  t4426 = 0.2e1 * t4425;
  t4427 = t542 * t545;
  t4430 = t325 * t4163;
  t4433 = t801 * t4307;
  t4436 = t801 * t4325;
  t4440 = t15 * t185 * t187;
  t4441 = t431 * t4440;
  t4448 = t1266 * t1277;
  t4451 = t431 * t4134;
  t4453 = t152 * t54 * t502;
  t4457 = t800 * t801 * t522;
  t4460 = t544 * t160;
  t4464 = t1378 * t4169;
  t4468 = t1296 * t527 * t50;
  t4474 = t1266 * t1270;
  t4478 = t152 * t54 * t508;
  t4481 = t16 * t522;
  t4485 = -0.2e4 / 0.81e2 * t452 * t4427 + 0.2e4 / 0.729e3 * t324 * t4430 - 0.25e4 / 0.729e3 * t190 * t4433 + 0.25e3 / 0.243e3 * t190 * t4436 + 0.1e4 / 0.243e3 * t4441 * t325 * t4314 + 0.5e3 / 0.729e3 * t190 * t801 * t4321 - 0.1e4 / 0.243e3 * t4448 * t1375 - 0.5e2 / 0.81e2 * t4451 * t4453 + 0.1e3 / 0.81e2 * t1373 * t4457 + 0.2e5 / 0.729e3 * t543 * t4460 * t1379 - 0.2e5 / 0.729e3 * t543 * t4464 + 0.1e5 / 0.729e3 * t2785 * t4468 - 0.2e3 / 0.81e2 * t4207 * t16 * t453 + 0.25e3 / 0.81e2 * t4474 * t1370 - 0.25e2 / 0.27e2 * t1368 * t4478 - 0.2e4 / 0.243e3 * t543 * t1378 * t4481;
  t4486 = t4485 * t146;
  t4487 = t459 * t791;
  t4488 = t574 * t1296;
  t4489 = t4488 * t3508;
  t4490 = t1838 * t4489;
  t4491 = 0.25e2 / 0.81e2 * t4490;
  t4492 = t207 * t1314;
  t4493 = t180 * t167;
  t4494 = t194 * t4493;
  t4495 = t4492 * t4494;
  t4496 = t1838 * t4495;
  t4497 = 0.125e3 / 0.486e3 * t4496;
  t4498 = -t4367 - t4372 - t4377 + t4381 - t4385 + t4389 + t4393 - t4397 + t4402 + t4404 + t4406 + t4414 - t4417 - t4424 + t4426 + t4486 + t4487 + t4491 - t4497;
  t4518 = 0.35e2 / 0.54e2 * t1332;
  t4520 = 0.5e1 / 0.18e2 * t1347;
  t4523 = 0.1e2 / 0.9e1 * t1287 + 0.1e2 / 0.9e1 * t1291 - 0.5e2 / 0.27e2 * t1268 + 0.5e2 / 0.27e2 * t1275 + 0.4e4 / 0.243e3 * t1299 - 0.25e2 / 0.162e3 * t1328 - t4518 - 0.5e1 / 0.18e2 * t1342 + t4520 - 0.25e2 / 0.108e3 * t1352 + 0.25e2 / 0.108e3 * t1358;
  tv3rho2tau0 = t9 * (t4206 + t4286 + t4362 + t4498) + 0.5e1 / 0.36e2 * t1319 + 0.5e1 / 0.36e2 * t1363 + 0.2e1 * t1390 + 0.2e1 * t1391 - 0.1e3 / 0.81e2 * t1303 - 0.1e3 / 0.81e2 * t1307 - 0.2e3 / 0.81e2 * t1282 + 0.5e3 / 0.243e3 * t1312 - 0.5e3 / 0.243e3 * t1317 + t4523;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t4524 = t484 * t791;
  t4525 = t1471 * t316;
  t4526 = 0.2e1 * t4525;
  t4527 = t512 * t40;
  t4528 = t462 * t4527;
  t4530 = t152 * t54 * t513;
  t4533 = t26 * t185;
  t4534 = t4533 * t187;
  t4535 = t462 * t4534;
  t4536 = t171 * params->c;
  t4537 = t4536 * t180;
  t4538 = t325 * t4537;
  t4542 = t152 * t54 * t517;
  t4554 = t26 * t180 * t171;
  t4558 = t27 * t522;
  t4559 = t1463 * t4558;
  t4562 = t21 * t512;
  t4563 = t4562 * t513;
  t4567 = t1421 * t517;
  t4571 = -0.5e2 / 0.81e2 * t4528 * t4530 + 0.1e4 / 0.243e3 * t4535 * t4538 - 0.25e2 / 0.27e2 * t1455 * t4542 - 0.2e4 / 0.81e2 * t478 * t4427 + 0.1e3 / 0.81e2 * t1460 * t4457 + 0.1e5 / 0.729e3 * t2785 * t1410 * t527 * t50 - 0.2e5 / 0.729e3 * t543 * t1463 * t4554 - 0.2e4 / 0.243e3 * t543 * t4559 + 0.5e3 / 0.729e3 * t190 * t801 * t4563 + 0.25e3 / 0.243e3 * t190 * t801 * t4567;
  t4572 = t4571 * t146;
  t4573 = t797 * t475;
  t4574 = 0.5e1 / 0.72e2 * t4573;
  t4575 = t322 * t1452;
  t4576 = 0.5e1 / 0.36e2 * t4575;
  t4577 = t207 * t21;
  t4578 = t473 * t545;
  t4579 = t4577 * t4578;
  t4580 = t4409 * t4579;
  t4581 = 0.25e3 / 0.243e3 * t4580;
  t4582 = t1330 * t1451;
  t4583 = t154 * t4582;
  t4584 = 0.35e2 / 0.54e2 * t4583;
  t4585 = t2356 * t21;
  t4586 = t4585 * t27;
  t4587 = t4586 * t4421;
  t4588 = t2814 * t4587;
  t4589 = 0.1e5 / 0.729e3 * t4588;
  t4591 = t1141 * t1901 * t1422;
  t4592 = 0.5e3 / 0.243e3 * t4591;
  t4594 = t1141 * t530 * t4563;
  t4595 = 0.5e3 / 0.729e3 * t4594;
  t4596 = t445 * t1740;
  t4597 = t154 * t4596;
  t4598 = 0.5e1 / 0.36e2 * t4597;
  t4599 = t464 * t4199;
  t4600 = 0.1e2 / 0.9e1 * t4599;
  t4601 = t464 * t4203;
  t4602 = 0.5e1 / 0.9e1 * t4601;
  t4603 = t27 * t539;
  t4604 = t462 * t4603;
  t4605 = t4604 * t4217;
  t4606 = 0.2e4 / 0.81e2 * t4605;
  t4607 = t4524 + t4526 + t4572 + t4574 + t4576 + t4581 - t4584 - t4589 - t4592 - t4595 + t4598 + t4600 + t4602 + t4606;
  t4608 = t464 * t4222;
  t4609 = 0.5e1 / 0.9e1 * t4608;
  t4610 = t26 * t146;
  t4611 = t209 * t171;
  t4612 = t4610 * t4611;
  t4613 = t1843 * t4612;
  t4614 = t1336 * t4613;
  t4615 = 0.25e2 / 0.54e2 * t4614;
  t4616 = t1450 * t326;
  t4617 = t1428 * t4616;
  t4618 = t1323 * t4617;
  t4619 = 0.25e2 / 0.162e3 * t4618;
  t4620 = t473 * t810;
  t4621 = t1428 * t4620;
  t4622 = t1323 * t4621;
  t4623 = 0.25e2 / 0.324e3 * t4622;
  t4624 = t4363 * t472;
  t4625 = t4624 * t1429;
  t4626 = t1323 * t4625;
  t4627 = 0.175e3 / 0.243e3 * t4626;
  t4628 = t1324 * t1440;
  t4629 = t4628 * t1429;
  t4630 = t1323 * t4629;
  t4631 = 0.25e2 / 0.81e2 * t4630;
  t4632 = t4276 * t474;
  t4633 = t154 * t4632;
  t4634 = 0.595e3 / 0.324e3 * t4633;
  t4635 = t1330 * t1441;
  t4636 = t154 * t4635;
  t4637 = 0.35e2 / 0.27e2 * t4636;
  t4638 = t322 * t1433;
  t4639 = 0.35e2 / 0.54e2 * t4638;
  t4640 = t322 * t1442;
  t4641 = 0.5e1 / 0.18e2 * t4640;
  t4642 = t1440 * t1450;
  t4643 = t445 * t4642;
  t4644 = t154 * t4643;
  t4645 = 0.5e1 / 0.18e2 * t4644;
  t4646 = t27 * t791;
  t4647 = t472 * t4646;
  t4648 = t445 * t4647;
  t4649 = t154 * t4648;
  t4650 = 0.5e1 / 0.72e2 * t4649;
  t4652 = t1141 * t1905 * t1422;
  t4653 = 0.5e3 / 0.243e3 * t4652;
  t4655 = t1141 * t530 * t4567;
  t4656 = 0.25e3 / 0.243e3 * t4655;
  t4657 = t462 * t26;
  t4658 = t4657 * t189;
  t4659 = t439 * t4537;
  t4660 = t4658 * t4659;
  t4661 = 0.1e4 / 0.243e3 * t4660;
  t4662 = t4609 - t4615 - t4619 - t4623 + t4627 - t4631 + t4634 - t4637 - t4639 + t4641 + t4645 + t4650 - t4653 - t4656 - t4661;
  t4664 = t4364 * t1446;
  t4665 = t1336 * t4664;
  t4666 = 0.175e3 / 0.162e3 * t4665;
  t4667 = t1410 * t4368;
  t4668 = t1338 * t4667;
  t4669 = t1336 * t4668;
  t4670 = 0.5e1 / 0.18e2 * t4669;
  t4671 = t1410 * t4373;
  t4672 = t1338 * t4671;
  t4673 = t1336 * t4672;
  t4674 = 0.5e1 / 0.36e2 * t4673;
  t4675 = t4240 * t1437;
  t4676 = 0.5e1 / 0.18e2 * t4675;
  t4677 = t4240 * t1447;
  t4678 = 0.25e2 / 0.108e3 * t4677;
  t4679 = t1354 * t1736;
  t4680 = t4353 * t4679;
  t4681 = 0.25e2 / 0.162e3 * t4680;
  t4682 = t146 * t513;
  t4683 = t4562 * t4682;
  t4684 = t1354 * t4683;
  t4685 = t1336 * t4684;
  t4686 = 0.25e2 / 0.324e3 * t4685;
  t4687 = t1410 * t4253;
  t4688 = t4252 * t4687;
  t4689 = t1336 * t4688;
  t4690 = 0.5e1 / 0.12e2 * t4689;
  t4691 = t4258 * t1436;
  t4692 = t1336 * t4691;
  t4693 = 0.5e1 / 0.9e1 * t4692;
  t4694 = t4345 * t1446;
  t4695 = t1336 * t4694;
  t4696 = 0.25e2 / 0.54e2 * t4695;
  t4697 = t316 * t171;
  t4698 = t1421 * t4697;
  t4699 = t1354 * t4698;
  t4700 = t1336 * t4699;
  t4701 = 0.25e2 / 0.108e3 * t4700;
  t4702 = t146 * t517;
  t4703 = t1421 * t4702;
  t4704 = t1354 * t4703;
  t4705 = t1336 * t4704;
  t4706 = 0.25e2 / 0.216e3 * t4705;
  t4707 = t4358 * t1436;
  t4708 = t1336 * t4707;
  t4709 = 0.35e2 / 0.27e2 * t4708;
  t4710 = t4527 * t44;
  t4711 = t462 * t4710;
  t4713 = t55 * t147 * t513;
  t4714 = t4711 * t4713;
  t4715 = 0.5e2 / 0.81e2 * t4714;
  t4716 = -t4666 - t4670 - t4674 - t4676 + t4678 - t4681 + t4686 + t4690 - t4693 + t4696 + t4701 + t4706 + t4709 + t4715;
  t4717 = t4173 * t468;
  t4718 = t190 * t4717;
  t4719 = 0.5e2 / 0.81e2 * t4718;
  t4720 = t4177 * t468;
  t4721 = t190 * t4720;
  t4722 = 0.1e3 / 0.81e2 * t4721;
  t4723 = t4181 * t468;
  t4724 = t190 * t4723;
  t4725 = 0.5e2 / 0.81e2 * t4724;
  t4726 = t1403 * t4189;
  t4727 = 0.2e3 / 0.81e2 * t4726;
  t4728 = t1403 * t4192;
  t4729 = 0.2e3 / 0.81e2 * t4728;
  t4730 = t1403 * t4195;
  t4731 = 0.1e3 / 0.81e2 * t4730;
  t4732 = t1831 * t4554;
  t4733 = t1294 * t4732;
  t4734 = 0.2e5 / 0.729e3 * t4733;
  t4735 = t4299 * t1412;
  t4736 = 0.4e4 / 0.243e3 * t4735;
  t4737 = t4302 * t1411;
  t4738 = t1294 * t4737;
  t4739 = 0.4e4 / 0.243e3 * t4738;
  t4740 = t1410 * t522;
  t4741 = t1295 * t4740;
  t4742 = t1294 * t4741;
  t4743 = 0.2e4 / 0.243e3 * t4742;
  t4745 = t55 * t217 * t171;
  t4746 = t1396 * t4745;
  t4747 = 0.5e2 / 0.27e2 * t4746;
  t4749 = t55 * t317 * t171;
  t4750 = t1396 * t4749;
  t4751 = 0.5e2 / 0.27e2 * t4750;
  t4753 = t55 * t147 * t517;
  t4754 = t1396 * t4753;
  t4755 = 0.25e2 / 0.27e2 * t4754;
  t4756 = t574 * t1410;
  t4757 = t4756 * t3508;
  t4758 = t1838 * t4757;
  t4759 = 0.25e2 / 0.81e2 * t4758;
  t4760 = t207 * t1421;
  t4761 = t180 * t171;
  t4762 = t194 * t4761;
  t4763 = t4760 * t4762;
  t4764 = t1838 * t4763;
  t4765 = 0.125e3 / 0.486e3 * t4764;
  t4766 = -t4719 - t4722 - t4725 - t4727 - t4729 - t4731 + t4734 + t4736 + t4739 + t4743 + t4747 + t4751 + t4755 + t4759 - t4765;
  t4783 = 0.35e2 / 0.54e2 * t1434;
  t4785 = 0.5e1 / 0.18e2 * t1443;
  tv3rho2tau1 = t9 * (t4607 + t4662 + t4716 + t4766) - 0.25e2 / 0.162e3 * t1431 + 0.2e1 * t1472 + 0.2e1 * t1473 + 0.5e1 / 0.36e2 * t1453 + 0.5e1 / 0.36e2 * t1426 - 0.2e3 / 0.81e2 * t1404 - 0.1e3 / 0.81e2 * t1416 - 0.1e3 / 0.81e2 * t1419 - 0.5e3 / 0.243e3 * t1424 + 0.1e2 / 0.9e1 * t1406 + 0.1e2 / 0.9e1 * t1408 + 0.5e2 / 0.27e2 * t1399 + 0.4e4 / 0.243e3 * t1413 - t4783 - 0.5e1 / 0.18e2 * t1438 + t4785 + 0.25e2 / 0.108e3 * t1448;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t4787 = t1360 * t390;
  t4788 = t1325 * t4787;
  t4789 = t1323 * t4788;
  t4791 = t4378 * t1510;
  t4792 = t1323 * t4791;
  t4794 = t4382 * t1510;
  t4795 = t1323 * t4794;
  t4797 = t459 * t951;
  t4798 = t4299 * t1493;
  t4801 = t55 * t217 * t336;
  t4802 = t1272 * t4801;
  t4805 = t55 * t317 * t336;
  t4806 = t1272 * t4805;
  t4808 = t4215 * t541;
  t4809 = t431 * t4808;
  t4810 = t4809 * t855;
  t4813 = t55 * t365 * t167;
  t4814 = t1272 * t4813;
  t4817 = t55 * t383 * t167;
  t4818 = t1272 * t4817;
  t4820 = t4129 * t350;
  t4821 = t1295 * t4820;
  t4822 = t1294 * t4821;
  t4824 = t4141 * t1477;
  t4826 = t388 * t1346;
  t4828 = -0.25e2 / 0.324e3 * t4789 + 0.175e3 / 0.486e3 * t4792 - 0.25e2 / 0.162e3 * t4795 + t4797 + 0.2e4 / 0.243e3 * t4798 + 0.25e2 / 0.27e2 * t4802 + 0.25e2 / 0.27e2 * t4806 + 0.2e4 / 0.81e2 * t4810 + 0.25e2 / 0.27e2 * t4814 + 0.25e2 / 0.27e2 * t4818 - 0.1e5 / 0.729e3 * t4822 - 0.125e3 / 0.81e2 * t4824 + 0.5e1 / 0.36e2 * t4826;
  t4829 = t388 * t1351;
  t4831 = t388 * t1331;
  t4833 = t382 * t209;
  t4834 = t1296 * t4833;
  t4835 = t1338 * t4834;
  t4836 = t1336 * t4835;
  t4838 = t382 * t167;
  t4839 = t1314 * t4838;
  t4840 = t1354 * t4839;
  t4841 = t1336 * t4840;
  t4843 = t350 * t167;
  t4844 = t194 * t4843;
  t4845 = t4492 * t4844;
  t4846 = t1838 * t4845;
  t4848 = t4488 * t3857;
  t4849 = t1838 * t4848;
  t4851 = t1519 * t326;
  t4852 = t4492 * t4851;
  t4853 = t1838 * t4852;
  t4855 = t549 * t382;
  t4856 = t4855 * t441;
  t4857 = t190 * t4856;
  t4859 = t193 * t951;
  t4860 = t4859 * t441;
  t4861 = t190 * t4860;
  t4863 = t337 * t180;
  t4864 = t4167 * t4863;
  t4865 = t1294 * t4864;
  t4867 = t55 * t66;
  t4868 = t3485 * t506;
  t4869 = t4867 * t4868;
  t4870 = t1272 * t4869;
  t4872 = t4188 * t355;
  t4873 = t1279 * t4872;
  t4875 = t1280 * t861;
  t4876 = t1279 * t4875;
  t4878 = -0.25e2 / 0.216e3 * t4829 - 0.35e2 / 0.108e3 * t4831 - 0.5e1 / 0.36e2 * t4836 + 0.25e2 / 0.216e3 * t4841 - 0.125e3 / 0.972e3 * t4846 + 0.25e2 / 0.162e3 * t4849 - 0.125e3 / 0.972e3 * t4853 - 0.5e2 / 0.81e2 * t4857 - 0.5e2 / 0.81e2 * t4861 + 0.1e5 / 0.729e3 * t4865 + 0.25e2 / 0.27e2 * t4870 - 0.1e3 / 0.81e2 * t4873 - 0.1e3 / 0.81e2 * t4876;
  t4880 = t1280 * t865;
  t4881 = t1279 * t4880;
  t4883 = t325 * t364;
  t4884 = t4883 * t195;
  t4885 = t1279 * t4884;
  t4887 = t1280 * t903;
  t4888 = t1279 * t4887;
  t4890 = t1496 * t1310;
  t4891 = t190 * t4890;
  t4893 = t1500 * t1310;
  t4894 = t190 * t4893;
  t4896 = t4185 * t1480;
  t4898 = t15 * t350;
  t4899 = t4898 * t167;
  t4900 = t4167 * t4899;
  t4901 = t1294 * t4900;
  t4903 = t2549 * t146;
  t4904 = t4903 * t441;
  t4905 = t190 * t4904;
  t4907 = t871 * t316;
  t4908 = t4907 * t441;
  t4909 = t190 * t4908;
  t4911 = t2247 * t206;
  t4912 = t252 * t6;
  t4913 = t4912 * t4226;
  t4914 = t4911 * t4913;
  t4915 = t154 * t4914;
  t4917 = t1519 * t167;
  t4918 = t4867 * t4917;
  t4919 = t4136 * t4918;
  t4921 = t4258 * t1515;
  t4922 = t1336 * t4921;
  t4924 = t4129 * t1514;
  t4925 = t1338 * t4924;
  t4926 = t1336 * t4925;
  t4928 = -0.1e3 / 0.81e2 * t4881 - 0.1e3 / 0.81e2 * t4885 - 0.1e3 / 0.81e2 * t4888 + 0.25e3 / 0.243e3 * t4891 + 0.25e3 / 0.243e3 * t4894 + 0.5e3 / 0.243e3 * t4896 + 0.1e5 / 0.729e3 * t4901 - 0.5e2 / 0.81e2 * t4905 - 0.5e2 / 0.81e2 * t4909 + 0.25e2 / 0.216e3 * t4915 + 0.5e2 / 0.81e2 * t4919 - 0.5e1 / 0.18e2 * t4922 + 0.25e2 / 0.108e3 * t4926;
  t4929 = t316 * t360;
  t4930 = t1296 * t4929;
  t4931 = t1338 * t4930;
  t4932 = t1336 * t4931;
  t4934 = t146 * t886;
  t4935 = t1296 * t4934;
  t4936 = t1338 * t4935;
  t4937 = t1336 * t4936;
  t4939 = t4240 * t1521;
  t4941 = t316 * t336;
  t4942 = t1314 * t4941;
  t4943 = t1354 * t4942;
  t4944 = t1336 * t4943;
  t4946 = t4306 * t336;
  t4948 = t1141 * t530 * t4946;
  t4950 = t4386 * t1510;
  t4951 = t1323 * t4950;
  t4954 = t336 * t209;
  t4955 = t4226 * t4954;
  t4956 = t4225 * t4955;
  t4957 = t1336 * t4956;
  t4959 = t501 * t146;
  t4960 = t336 * t167;
  t4961 = t4959 * t4960;
  t4962 = t1325 * t4961;
  t4963 = t1336 * t4962;
  t4965 = t1524 * t326;
  t4967 = t1323 * t1325 * t4965;
  t4969 = t447 * t966;
  t4970 = t1325 * t4969;
  t4971 = t1323 * t4970;
  t4973 = t322 * t1526;
  t4975 = t16 * t951;
  t4976 = t446 * t4975;
  t4977 = t445 * t4976;
  t4978 = t154 * t4977;
  t4980 = -0.5e1 / 0.36e2 * t4932 - 0.5e1 / 0.36e2 * t4937 + 0.25e2 / 0.216e3 * t4939 + 0.25e2 / 0.216e3 * t4944 + 0.125e4 / 0.729e3 * t4948 + 0.125e3 / 0.972e3 * t4951 + 0.5e1 / 0.18e2 * t4260 - 0.25e2 / 0.108e3 * t4957 + 0.25e2 / 0.324e3 * t4963 - 0.25e2 / 0.324e3 * t4967 - 0.25e2 / 0.324e3 * t4971 + 0.5e1 / 0.72e2 * t4973 + 0.5e1 / 0.72e2 * t4978;
  t4983 = t4245 * t4960;
  t4984 = t530 * t4983;
  t4985 = t1141 * t4984;
  t4987 = t1314 * t507;
  t4988 = t530 * t4987;
  t4989 = t1141 * t4988;
  t4991 = t957 * t449;
  t4993 = t388 * t1362;
  t4995 = t1330 * t1525;
  t4996 = t154 * t4995;
  t4998 = t1344 * t1524;
  t4999 = t445 * t4998;
  t5000 = t154 * t4999;
  t5007 = -0.5e3 / 0.729e3 * t4985 - 0.25e3 / 0.243e3 * t4989 + 0.5e1 / 0.72e2 * t4991 + 0.5e1 / 0.72e2 * t4993 - 0.35e2 / 0.108e3 * t4996 + 0.5e1 / 0.36e2 * t5000 + 0.25e2 / 0.108e3 * t4269 + t4279 + 0.175e3 / 0.324e3 * t4284 - 0.35e2 / 0.108e3 * t4288 - 0.5e1 / 0.36e2 * t4290 - t4320 - 0.25e2 / 0.108e3 * t4347;
  t5012 = t2812 * t2429;
  t5013 = t805 * t5012;
  t5014 = t1492 * t3863;
  t5015 = t5013 * t5014;
  t5017 = t4364 * t1520;
  t5018 = t1336 * t5017;
  t5020 = t4345 * t1520;
  t5021 = t1336 * t5020;
  t5023 = t4306 * t1519;
  t5024 = t1354 * t5023;
  t5025 = t1336 * t5024;
  t5027 = t4358 * t1515;
  t5028 = t1336 * t5027;
  t5030 = t1544 * t316;
  t5034 = t152 * t1529 * t167;
  t5037 = t336 * params->c;
  t5038 = t5037 * t180;
  t5039 = t325 * t5038;
  t5042 = t54 * t8;
  t5044 = t152 * t5042 * t506;
  t5049 = t390 * t167;
  t5050 = t325 * t5049;
  t5056 = t800 * t801 * t841;
  t5059 = t2353 * t2356;
  t5061 = t805 * t5059 * t6;
  t5063 = t1537 * t180 * t50;
  t5069 = t1378 * t4899;
  t5072 = t16 * t841;
  t5076 = t1378 * t4863;
  t5082 = t801 * t6;
  t5083 = t5082 * t824;
  t5086 = t5082 * t828;
  t5089 = 0.125e3 / 0.81e2 * t4474 * t1530 - 0.5e2 / 0.81e2 * t4451 * t5034 + 0.5e3 / 0.243e3 * t4441 * t5039 - 0.25e2 / 0.27e2 * t1368 * t5044 - 0.5e3 / 0.243e3 * t4448 * t1534 + 0.5e3 / 0.243e3 * t4441 * t5050 - 0.2e4 / 0.81e2 * t4216 * t963 + 0.1e3 / 0.81e2 * t1373 * t5056 + 0.1e5 / 0.729e3 * t5061 * t5063 + 0.1e5 / 0.729e3 * t543 * t4460 * t1537 - 0.1e5 / 0.729e3 * t543 * t5069 - 0.2e4 / 0.243e3 * t543 * t1378 * t5072 - 0.1e5 / 0.729e3 * t543 * t5076 - 0.125e4 / 0.729e3 * t190 * t801 * t4946 + 0.5e3 / 0.729e3 * t190 * t5083 + 0.25e3 / 0.243e3 * t190 * t5086;
  t5090 = t5089 * t146;
  t5091 = t1349 * t1524;
  t5092 = t445 * t5091;
  t5093 = t154 * t5092;
  t5095 = t4302 * t1492;
  t5096 = t1294 * t5095;
  t5098 = 0.35e2 / 0.54e2 * t4360 - 0.175e3 / 0.324e3 * t4366 + 0.175e3 / 0.486e3 * t4380 + 0.25e2 / 0.162e3 * t4384 - 0.1e5 / 0.729e3 * t5015 - 0.175e3 / 0.324e3 * t5018 + 0.25e2 / 0.108e3 * t5021 - 0.125e3 / 0.648e3 * t5025 + 0.35e2 / 0.54e2 * t5028 + t5030 + t5090 - 0.25e2 / 0.216e3 * t5093 + 0.2e4 / 0.243e3 * t5096;
  t5100 = t1296 * t841;
  t5101 = t1295 * t5100;
  t5102 = t1294 * t5101;
  t5104 = t542 * t364;
  t5105 = t39 * t5104;
  t5106 = t5105 * t1298;
  t5108 = t382 * t544;
  t5109 = t5108 * t1297;
  t5110 = t1294 * t5109;
  t5114 = t4251 * t446;
  t5115 = t360 * t209;
  t5116 = t447 * t5115;
  t5117 = t5114 * t5116;
  t5118 = t1336 * t5117;
  t5120 = t360 * t167;
  t5121 = t4226 * t5120;
  t5122 = t4225 * t5121;
  t5123 = t1336 * t5122;
  t5125 = t3755 * t1322;
  t5126 = t5125 * t1327;
  t5129 = t1141 * t2478 * t1315;
  t5132 = t1141 * t2462 * t1315;
  t5135 = t1141 * t1901 * t1504;
  t5138 = t1141 * t1905 * t1504;
  t5140 = t439 * t5038;
  t5141 = t4312 * t5140;
  t5143 = 0.2e4 / 0.243e3 * t5102 + 0.2e4 / 0.243e3 * t5106 + 0.2e4 / 0.243e3 * t5110 - 0.5e1 / 0.36e2 * t4392 - 0.35e2 / 0.108e3 * t4416 + 0.5e1 / 0.12e2 * t5118 - 0.25e2 / 0.108e3 * t5123 - 0.25e2 / 0.162e3 * t5126 - 0.25e3 / 0.243e3 * t5129 - 0.25e3 / 0.243e3 * t5132 - 0.25e3 / 0.243e3 * t5135 - 0.25e3 / 0.243e3 * t5138 - 0.5e3 / 0.243e3 * t5141;
  t5144 = t439 * t5049;
  t5145 = t4312 * t5144;
  t5148 = t152 * t1284 * t382;
  t5149 = t433 * t5148;
  t5152 = t152 * t434 * t951;
  t5153 = t433 * t5152;
  t5155 = t1267 * t1485;
  t5157 = t1267 * t1489;
  t5159 = t54 * t891;
  t5161 = t152 * t5159 * t146;
  t5162 = t433 * t5161;
  t5165 = t152 * t1483 * t316;
  t5166 = t433 * t5165;
  t5168 = t387 * t1335;
  t5169 = t5168 * t1341;
  t5171 = t5168 * t1357;
  t5173 = t4407 * t1324;
  t5174 = t805 * t5173;
  t5175 = t446 * t16;
  t5176 = t1295 * t962;
  t5177 = t5175 * t5176;
  t5178 = t5174 * t5177;
  t5180 = t4240 * t1516;
  t5182 = t4488 * t3868;
  t5183 = t1838 * t5182;
  t5185 = t1389 * t382;
  t5186 = -0.5e3 / 0.243e3 * t5145 + 0.5e1 / 0.9e1 * t5149 + 0.5e1 / 0.9e1 * t5153 - 0.25e2 / 0.27e2 * t5155 - 0.25e2 / 0.27e2 * t5157 + 0.5e1 / 0.9e1 * t5162 + 0.5e1 / 0.9e1 * t5166 - 0.5e1 / 0.36e2 * t5169 + 0.25e2 / 0.216e3 * t5171 + 0.25e3 / 0.243e3 * t5178 - 0.5e1 / 0.36e2 * t5180 + 0.25e2 / 0.162e3 * t5183 + t5185;
  t5191 = t9 * (t4828 + t4878 + t4928 + t4980 + t5007 + t5098 + t5143 + t5186) + t1528 - t1329 - t1482 - t1499 - t1503 + t1320 - t4518 - t1353 + t1364 + t1523 + t1479 + t1495 + t1276 + t1300 - t1283 - t1304;
  t5192 = -t1308 + t1313 - t1513 - t1343 + t1359 - t1518 - t1269 + t1288 + t1292 + t1509 + t1546 - t1507 + t1545 + t1487 + t1491 - t1318 + t1391 + t1390;
  tv3rho2tau2 = t5191 + t5192;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t5193 = t1628 + t1566 + t1556 + t1583 - t1596 + t1606 + t1627 - t1558 - t1569 - t1572 + t1577 - t1417 - t1420 + t1427 - t1552 + t1560 + t1562;
  t5194 = t1626 * t316;
  t5195 = t27 * t951;
  t5196 = t472 * t5195;
  t5197 = t445 * t5196;
  t5198 = t154 * t5197;
  t5200 = t322 * t1594;
  t5202 = t346 * t171;
  t5203 = t4562 * t5202;
  t5205 = t1141 * t530 * t5203;
  t5207 = t1421 * t507;
  t5209 = t1141 * t530 * t5207;
  t5211 = t957 * t475;
  t5213 = t388 * t1452;
  t5215 = t388 * t1433;
  t5217 = t388 * t1442;
  t5219 = t1597 * t326;
  t5220 = t4760 * t5219;
  t5221 = t1838 * t5220;
  t5223 = t1549 * t1402;
  t5224 = t5223 * t1281;
  t5226 = t1597 * t171;
  t5227 = t4867 * t5226;
  t5228 = t4711 * t5227;
  t5230 = t1396 * t4869;
  t5232 = t5194 + 0.5e1 / 0.72e2 * t5198 - 0.25e2 / 0.216e3 * t5200 - 0.5e3 / 0.729e3 * t5205 + 0.25e3 / 0.243e3 * t5209 + 0.5e1 / 0.72e2 * t5211 + 0.5e1 / 0.72e2 * t5213 - 0.35e2 / 0.108e3 * t5215 + 0.5e1 / 0.36e2 * t5217 - 0.125e3 / 0.972e3 * t5221 + 0.5e3 / 0.243e3 * t5224 + 0.5e2 / 0.81e2 * t5228 - 0.25e2 / 0.27e2 * t5230;
  t5233 = t1403 * t4872;
  t5235 = t1403 * t4875;
  t5237 = t1403 * t4880;
  t5240 = t190 * t4855 * t468;
  t5243 = t190 * t4859 * t468;
  t5246 = t190 * t1301 * t1574;
  t5249 = t190 * t1305 * t1574;
  t5251 = t347 * t180;
  t5252 = t1831 * t5251;
  t5253 = t1294 * t5252;
  t5256 = t1330 * t1593;
  t5257 = t154 * t5256;
  t5259 = t8 * t342;
  t5260 = t5259 * t473;
  t5261 = t445 * t5260;
  t5262 = t154 * t5261;
  t5264 = t1330 * t1603;
  t5265 = t154 * t5264;
  t5267 = t1440 * t1602;
  t5268 = t445 * t5267;
  t5269 = t154 * t5268;
  t5271 = -0.1e3 / 0.81e2 * t5233 - 0.1e3 / 0.81e2 * t5235 - 0.1e3 / 0.81e2 * t5237 - 0.5e2 / 0.81e2 * t5240 - 0.5e2 / 0.81e2 * t5243 + 0.25e3 / 0.243e3 * t5246 + 0.25e3 / 0.243e3 * t5249 + 0.1e5 / 0.729e3 * t5253 - 0.35e2 / 0.108e3 * t4583 + 0.175e3 / 0.324e3 * t5257 - 0.25e2 / 0.108e3 * t5262 - 0.35e2 / 0.108e3 * t5265 + 0.5e1 / 0.36e2 * t5269;
  t5273 = t1403 * t4884;
  t5275 = t1403 * t4887;
  t5277 = t26 * t350;
  t5278 = t5277 * t171;
  t5279 = t1831 * t5278;
  t5280 = t1294 * t5279;
  t5283 = t190 * t4903 * t468;
  t5286 = t190 * t4907 * t468;
  t5288 = t484 * t951;
  t5289 = t5105 * t1412;
  t5292 = t55 * t217 * t346;
  t5293 = t1396 * t5292;
  t5296 = t55 * t317 * t346;
  t5297 = t1396 * t5296;
  t5299 = t4603 * t541;
  t5300 = t462 * t5299;
  t5301 = t5300 * t855;
  t5304 = t55 * t365 * t171;
  t5305 = t1396 * t5304;
  t5308 = t55 * t383 * t171;
  t5309 = t1396 * t5308;
  t5311 = -t4598 - 0.1e3 / 0.81e2 * t5273 - 0.1e3 / 0.81e2 * t5275 + 0.1e5 / 0.729e3 * t5280 - 0.5e2 / 0.81e2 * t5283 - 0.5e2 / 0.81e2 * t5286 + t5288 + 0.2e4 / 0.243e3 * t5289 + 0.25e2 / 0.27e2 * t5293 + 0.25e2 / 0.27e2 * t5297 + 0.2e4 / 0.81e2 * t5301 + 0.25e2 / 0.27e2 * t5305 + 0.25e2 / 0.27e2 * t5309;
  t5312 = t1549 * t1395;
  t5313 = t5312 * t1398;
  t5315 = t1471 * t382;
  t5316 = t1549 * t1394;
  t5319 = t1549 * t1401;
  t5323 = t152 * t1610 * t171;
  t5326 = t346 * params->c;
  t5327 = t5326 * t180;
  t5333 = t390 * t171;
  t5334 = t325 * t5333;
  t5342 = t805 * t5059 * t21;
  t5344 = t1616 * t180 * t50;
  t5350 = t27 * t841;
  t5351 = t1463 * t5350;
  t5354 = t544 * t342;
  t5355 = t5354 * t1464;
  t5358 = t342 * t26;
  t5359 = t5358 * t171;
  t5366 = t801 * t21;
  t5373 = 0.125e3 / 0.81e2 * t5316 * t1457 - 0.5e3 / 0.243e3 * t5319 * t1375 - 0.5e2 / 0.81e2 * t4528 * t5323 + 0.5e3 / 0.243e3 * t4535 * t325 * t5327 + 0.25e2 / 0.27e2 * t1455 * t5044 + 0.5e3 / 0.243e3 * t4535 * t5334 - 0.2e4 / 0.81e2 * t4604 * t963 + 0.1e3 / 0.81e2 * t1460 * t5056 + 0.1e5 / 0.729e3 * t5342 * t5344 - 0.1e5 / 0.729e3 * t543 * t1463 * t5278 - 0.2e4 / 0.243e3 * t543 * t5351 + 0.1e5 / 0.729e3 * t543 * t5355 - 0.125e4 / 0.729e3 * t190 * t801 * t5359 - 0.1e5 / 0.729e3 * t543 * t1463 * t5251 + 0.5e3 / 0.729e3 * t190 * t5366 * t834 - 0.25e3 / 0.243e3 * t190 * t5366 * t838;
  t5374 = t5373 * t146;
  t5380 = t464 * t5148;
  t5382 = t464 * t5152;
  t5384 = t1550 * t1286;
  t5386 = t1550 * t1290;
  t5388 = -0.125e3 / 0.81e2 * t5313 + t5315 + t5374 + 0.175e3 / 0.486e3 * t4626 + 0.25e2 / 0.162e3 * t4630 + t4634 - 0.35e2 / 0.108e3 * t4638 - 0.5e1 / 0.36e2 * t4640 - 0.5e1 / 0.36e2 * t4644 + 0.5e1 / 0.9e1 * t5380 + 0.5e1 / 0.9e1 * t5382 - 0.25e2 / 0.27e2 * t5384 - 0.25e2 / 0.27e2 * t5386;
  t5391 = t464 * t5161;
  t5393 = t464 * t5165;
  t5396 = t1141 * t530 * t5359;
  t5399 = t1141 * t1901 * t1578;
  t5402 = t1141 * t1905 * t1578;
  t5405 = t1141 * t2478 * t1422;
  t5408 = t1323 * t4624 * t1584;
  t5411 = t1323 * t4628 * t1584;
  t5413 = t346 * t209;
  t5414 = t4610 * t5413;
  t5415 = t1843 * t5414;
  t5416 = t1336 * t5415;
  t5418 = t512 * t146;
  t5419 = t5418 * t5202;
  t5420 = t1428 * t5419;
  t5421 = t1336 * t5420;
  t5423 = t1602 * t326;
  t5424 = t1428 * t5423;
  t5425 = t1323 * t5424;
  t5427 = t4251 * t472;
  t5428 = t473 * t5115;
  t5429 = t5427 * t5428;
  t5430 = t1336 * t5429;
  t5432 = t360 * t171;
  t5433 = t4610 * t5432;
  t5434 = t1843 * t5433;
  t5435 = t1336 * t5434;
  t5437 = 0.5e1 / 0.9e1 * t5391 + 0.5e1 / 0.9e1 * t5393 + 0.125e4 / 0.729e3 * t5396 - 0.25e3 / 0.243e3 * t5399 - 0.25e3 / 0.243e3 * t5402 - 0.25e3 / 0.243e3 * t5405 + 0.175e3 / 0.486e3 * t5408 - 0.25e2 / 0.162e3 * t5411 - 0.25e2 / 0.108e3 * t5416 + 0.25e2 / 0.324e3 * t5421 - 0.25e2 / 0.324e3 * t5425 + 0.5e1 / 0.12e2 * t5430 - 0.25e2 / 0.108e3 * t5435;
  t5438 = t5125 * t1430;
  t5440 = t1450 * t390;
  t5442 = t1323 * t1428 * t5440;
  t5444 = t473 * t966;
  t5445 = t1428 * t5444;
  t5446 = t1323 * t5445;
  t5452 = t439 * t5327;
  t5453 = t4658 * t5452;
  t5455 = t439 * t5333;
  t5456 = t4658 * t5455;
  t5458 = t4756 * t3868;
  t5459 = t1838 * t5458;
  t5461 = t350 * t171;
  t5462 = t194 * t5461;
  t5463 = t4760 * t5462;
  t5464 = t1838 * t5463;
  t5466 = t4756 * t3857;
  t5467 = t1838 * t5466;
  t5469 = t5108 * t1411;
  t5470 = t1294 * t5469;
  t5472 = -0.25e2 / 0.162e3 * t5438 - 0.25e2 / 0.324e3 * t5442 - 0.25e2 / 0.324e3 * t5446 - 0.175e3 / 0.324e3 * t4665 + 0.5e1 / 0.18e2 * t4692 - 0.25e2 / 0.108e3 * t4695 + 0.35e2 / 0.54e2 * t4708 - 0.5e3 / 0.243e3 * t5453 - 0.5e3 / 0.243e3 * t5456 + 0.25e2 / 0.162e3 * t5459 - 0.125e3 / 0.972e3 * t5464 + 0.25e2 / 0.162e3 * t5467 + 0.2e4 / 0.243e3 * t5470;
  t5474 = t342 * t27;
  t5475 = t5474 * t180;
  t5476 = t1295 * t5475;
  t5477 = t1294 * t5476;
  t5479 = t4299 * t1564;
  t5481 = t4302 * t1563;
  t5482 = t1294 * t5481;
  t5484 = t1410 * t841;
  t5485 = t1295 * t5484;
  t5486 = t1294 * t5485;
  t5488 = t1592 * t1450;
  t5489 = t445 * t5488;
  t5490 = t154 * t5489;
  t5492 = t252 * t21;
  t5493 = t5492 * t4610;
  t5494 = t4911 * t5493;
  t5495 = t154 * t5494;
  t5497 = t322 * t1604;
  t5499 = t1324 * t1592;
  t5500 = t5499 * t1429;
  t5501 = t1323 * t5500;
  t5503 = t4364 * t1598;
  t5504 = t1336 * t5503;
  t5506 = t4345 * t1598;
  t5507 = t1336 * t5506;
  t5510 = t1141 * t2462 * t1422;
  t5512 = t4358 * t1588;
  t5513 = t1336 * t5512;
  t5515 = t4258 * t1588;
  t5516 = t1336 * t5515;
  t5518 = -0.1e5 / 0.729e3 * t5477 + 0.2e4 / 0.243e3 * t5479 + 0.2e4 / 0.243e3 * t5482 + 0.2e4 / 0.243e3 * t5486 - 0.25e2 / 0.216e3 * t5490 - 0.25e2 / 0.216e3 * t5495 + 0.5e1 / 0.72e2 * t5497 + 0.125e3 / 0.972e3 * t5501 - 0.175e3 / 0.324e3 * t5504 + 0.25e2 / 0.108e3 * t5507 - 0.25e3 / 0.243e3 * t5510 + 0.35e2 / 0.54e2 * t5513 - 0.5e1 / 0.18e2 * t5516;
  t5519 = t1563 * t3863;
  t5520 = t5013 * t5519;
  t5522 = t5168 * t1437;
  t5524 = t5168 * t1447;
  t5526 = t472 * t27;
  t5527 = t5526 * t5176;
  t5528 = t5174 * t5527;
  t5530 = t4240 * t1589;
  t5532 = t1410 * t4929;
  t5533 = t1338 * t5532;
  t5534 = t1336 * t5533;
  t5536 = t1410 * t4934;
  t5537 = t1338 * t5536;
  t5538 = t1336 * t5537;
  t5540 = t5474 * t1339;
  t5541 = t1338 * t5540;
  t5542 = t1336 * t5541;
  t5544 = t5358 * t1445;
  t5545 = t1354 * t5544;
  t5546 = t1336 * t5545;
  t5548 = t4240 * t1599;
  t5550 = t316 * t346;
  t5551 = t1421 * t5550;
  t5552 = t1354 * t5551;
  t5553 = t1336 * t5552;
  t5555 = t1410 * t4833;
  t5556 = t1338 * t5555;
  t5557 = t1336 * t5556;
  t5559 = t382 * t171;
  t5560 = t1421 * t5559;
  t5561 = t1354 * t5560;
  t5562 = t1336 * t5561;
  t5564 = -0.1e5 / 0.729e3 * t5520 - 0.5e1 / 0.36e2 * t5522 + 0.25e2 / 0.216e3 * t5524 + 0.25e3 / 0.243e3 * t5528 - 0.5e1 / 0.36e2 * t5530 - 0.5e1 / 0.36e2 * t5534 - 0.5e1 / 0.36e2 * t5538 + 0.25e2 / 0.108e3 * t5542 - 0.125e3 / 0.648e3 * t5546 + 0.25e2 / 0.216e3 * t5548 + 0.25e2 / 0.216e3 * t5553 - 0.5e1 / 0.36e2 * t5557 + 0.25e2 / 0.216e3 * t5562;
  t5569 = -t1591 + t1601 + t1414 + t1400 - t1405 - t1432 - t1587 - t1439 + t1449 + t1407 + t9 * (t5232 + t5271 + t5311 + t5388 + t5437 + t5472 + t5518 + t5564) - t4783 + t1454 - t1581 - t1425 + t1409 + t1473 + t1472;
  tv3rho2tau3 = t5193 + t5569;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t5570 = 0.175e3 / 0.243e3 * t4792;
  t5571 = 0.25e2 / 0.81e2 * t4795;
  t5572 = t4488 * t4047;
  t5573 = t1838 * t5572;
  t5574 = 0.25e2 / 0.81e2 * t5573;
  t5575 = t350 * t336;
  t5576 = t194 * t5575;
  t5577 = t4492 * t5576;
  t5578 = t1838 * t5577;
  t5579 = 0.125e3 / 0.486e3 * t5578;
  t5580 = 0.5e1 / 0.18e2 * t4826;
  t5581 = 0.35e2 / 0.54e2 * t4831;
  t5582 = t459 * t1084;
  t5583 = 0.5e1 / 0.9e1 * t4922;
  t5584 = t2372 * t4022;
  t5585 = t4216 * t5584;
  t5586 = 0.2e4 / 0.81e2 * t5585;
  t5587 = t54 * t1046;
  t5589 = t152 * t5587 * t146;
  t5590 = t433 * t5589;
  t5591 = 0.5e1 / 0.9e1 * t5590;
  t5593 = t152 * t1483 * t382;
  t5594 = t433 * t5593;
  t5595 = 0.1e2 / 0.9e1 * t5594;
  t5597 = t152 * t434 * t1084;
  t5598 = t433 * t5597;
  t5599 = 0.5e1 / 0.9e1 * t5598;
  t5600 = t447 * t1098;
  t5601 = t1325 * t5600;
  t5602 = t1323 * t5601;
  t5603 = 0.25e2 / 0.324e3 * t5602;
  t5605 = t55 * t147 * t983;
  t5606 = t4136 * t5605;
  t5607 = 0.5e2 / 0.81e2 * t5606;
  t5608 = t5570 + t5571 + t5574 - t5579 - t5580 - t5581 + t5582 + t5583 + t5586 + t5591 + t5595 + t5599 - t5603 + t5607;
  t5609 = t382 * t336;
  t5610 = t1314 * t5609;
  t5611 = t1354 * t5610;
  t5612 = t1336 * t5611;
  t5613 = 0.25e2 / 0.108e3 * t5612;
  t5614 = t382 * t360;
  t5615 = t1296 * t5614;
  t5616 = t1338 * t5615;
  t5617 = t1336 * t5616;
  t5618 = 0.5e1 / 0.18e2 * t5617;
  t5619 = t146 * t1042;
  t5620 = t1296 * t5619;
  t5621 = t1338 * t5620;
  t5622 = t1336 * t5621;
  t5623 = 0.5e1 / 0.36e2 * t5622;
  t5624 = t16 * t1084;
  t5625 = t446 * t5624;
  t5626 = t445 * t5625;
  t5627 = t154 * t5626;
  t5628 = 0.5e1 / 0.72e2 * t5627;
  t5629 = t1090 * t449;
  t5630 = 0.5e1 / 0.72e2 * t5629;
  t5631 = t388 * t1526;
  t5632 = 0.5e1 / 0.36e2 * t5631;
  t5633 = t447 * t1021;
  t5634 = t4410 * t5633;
  t5635 = t4409 * t5634;
  t5636 = 0.25e3 / 0.243e3 * t5635;
  t5637 = t1012 * t40;
  t5638 = t5637 * t152;
  t5639 = t4419 * t5638;
  t5640 = t2814 * t5639;
  t5641 = 0.1e5 / 0.729e3 * t5640;
  t5642 = 0.35e2 / 0.54e2 * t4996;
  t5643 = 0.5e1 / 0.18e2 * t5000;
  t5644 = t5105 * t1493;
  t5645 = 0.4e4 / 0.243e3 * t5644;
  t5646 = t5108 * t1492;
  t5647 = t1294 * t5646;
  t5648 = 0.4e4 / 0.243e3 * t5647;
  t5649 = t5613 - t5618 - t5623 + t5628 + t5630 + t5632 + t5636 - t5641 - t5642 - t5643 + t4279 + t4282 + t4320 + t5645 + t5648;
  t5651 = t1296 * t1007;
  t5652 = t1295 * t5651;
  t5653 = t1294 * t5652;
  t5654 = 0.2e4 / 0.243e3 * t5653;
  t5656 = t55 * t365 * t336;
  t5657 = t1272 * t5656;
  t5658 = 0.5e2 / 0.27e2 * t5657;
  t5660 = t55 * t383 * t336;
  t5661 = t1272 * t5660;
  t5662 = 0.5e2 / 0.27e2 * t5661;
  t5664 = t55 * t147 * t987;
  t5665 = t1272 * t5664;
  t5666 = 0.25e2 / 0.27e2 * t5665;
  t5667 = 0.175e3 / 0.162e3 * t5018;
  t5668 = 0.25e2 / 0.54e2 * t5021;
  t5669 = 0.35e2 / 0.27e2 * t5028;
  t5670 = t1314 * t987;
  t5672 = t1141 * t530 * t5670;
  t5673 = 0.25e3 / 0.243e3 * t5672;
  t5675 = t1141 * t2478 * t1504;
  t5676 = 0.5e3 / 0.243e3 * t5675;
  t5678 = t1141 * t2462 * t1504;
  t5679 = 0.5e3 / 0.243e3 * t5678;
  t5680 = t5037 * t350;
  t5681 = t439 * t5680;
  t5682 = t4312 * t5681;
  t5683 = 0.1e4 / 0.243e3 * t5682;
  t5684 = t1544 * t382;
  t5685 = 0.2e1 * t5684;
  t5686 = t54 * t983;
  t5687 = t152 * t5686;
  t5690 = t325 * t5680;
  t5693 = t54 * t987;
  t5694 = t152 * t5693;
  t5697 = t542 * t1021;
  t5701 = t800 * t801 * t1007;
  t5704 = t1296 * t1012;
  t5705 = t5704 * t50;
  t5708 = t4898 * t336;
  t5709 = t1378 * t5708;
  t5712 = t16 * t1007;
  t5716 = t4245 * t983;
  t5723 = -0.5e2 / 0.81e2 * t4451 * t5687 + 0.1e4 / 0.243e3 * t4441 * t5690 - 0.25e2 / 0.27e2 * t1368 * t5694 - 0.2e4 / 0.81e2 * t452 * t5697 + 0.1e3 / 0.81e2 * t1373 * t5701 + 0.1e5 / 0.729e3 * t2785 * t5705 - 0.2e5 / 0.729e3 * t543 * t5709 - 0.2e4 / 0.243e3 * t543 * t1378 * t5712 + 0.5e3 / 0.729e3 * t190 * t801 * t5716 + 0.25e3 / 0.243e3 * t190 * t801 * t5670;
  t5724 = t5723 * t146;
  t5725 = t3149 * t146;
  t5726 = t5725 * t441;
  t5727 = t190 * t5726;
  t5728 = 0.5e2 / 0.81e2 * t5727;
  t5729 = t5654 + t5658 + t5662 + t5666 - t5667 - t5668 + t5669 - t5673 - t5676 - t5679 - t5683 + t5685 + t5724 - t5728;
  t5730 = t871 * t382;
  t5731 = t5730 * t441;
  t5732 = t190 * t5731;
  t5733 = 0.1e3 / 0.81e2 * t5732;
  t5734 = t193 * t1084;
  t5735 = t5734 * t441;
  t5736 = t190 * t5735;
  t5737 = 0.5e2 / 0.81e2 * t5736;
  t5738 = t4883 * t355;
  t5739 = t1279 * t5738;
  t5740 = 0.2e3 / 0.81e2 * t5739;
  t5741 = t1280 * t1028;
  t5742 = t1279 * t5741;
  t5743 = 0.2e3 / 0.81e2 * t5742;
  t5744 = t1280 * t1032;
  t5745 = t1279 * t5744;
  t5746 = 0.1e3 / 0.81e2 * t5745;
  t5747 = t4167 * t5708;
  t5748 = t1294 * t5747;
  t5749 = 0.2e5 / 0.729e3 * t5748;
  t5750 = t360 * t336;
  t5751 = t4226 * t5750;
  t5752 = t4225 * t5751;
  t5753 = t1336 * t5752;
  t5754 = 0.25e2 / 0.54e2 * t5753;
  t5755 = t1524 * t390;
  t5756 = t1325 * t5755;
  t5757 = t1323 * t5756;
  t5758 = 0.25e2 / 0.162e3 * t5757;
  t5759 = t530 * t5716;
  t5760 = t1141 * t5759;
  t5761 = 0.5e3 / 0.729e3 * t5760;
  t5762 = t5168 * t1516;
  t5763 = 0.5e1 / 0.18e2 * t5762;
  t5764 = t5168 * t1521;
  t5765 = 0.25e2 / 0.108e3 * t5764;
  t5766 = t1092 * t1322;
  t5767 = t5766 * t4354;
  t5768 = 0.25e2 / 0.162e3 * t5767;
  t5769 = t146 * t987;
  t5770 = t1314 * t5769;
  t5771 = t1354 * t5770;
  t5772 = t1336 * t5771;
  t5773 = 0.25e2 / 0.216e3 * t5772;
  t5774 = t146 * t983;
  t5775 = t4245 * t5774;
  t5776 = t1354 * t5775;
  t5777 = t1336 * t5776;
  t5778 = 0.25e2 / 0.324e3 * t5777;
  t5779 = t146 * t1037;
  t5780 = t1296 * t5779;
  t5781 = t4252 * t5780;
  t5782 = t1336 * t5781;
  t5783 = 0.5e1 / 0.12e2 * t5782;
  t5784 = -t5733 - t5737 - t5740 - t5743 - t5746 + t5749 - t5754 - t5758 - t5761 - t5763 + t5765 - t5768 + t5773 + t5778 + t5783;
  tv3rho2tau4 = t9 * (t5608 + t5649 + t5729 + t5784) + 0.2e1 * t1545 + 0.2e1 * t1546 - 0.25e2 / 0.162e3 * t1512 + 0.5e1 / 0.36e2 * t1508 + 0.5e1 / 0.36e2 * t1527 - 0.2e3 / 0.81e2 * t1481 - 0.1e3 / 0.81e2 * t1498 - 0.1e3 / 0.81e2 * t1502 - 0.5e3 / 0.243e3 * t1506 + 0.1e2 / 0.9e1 * t1486 + 0.1e2 / 0.9e1 * t1490 + 0.5e2 / 0.27e2 * t1478 + 0.4e4 / 0.243e3 * t1494 - t4518 - t4520 - 0.5e1 / 0.18e2 * t1517 + 0.25e2 / 0.108e3 * t1522;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t5803 = t5474 * t350;
  t5804 = t1295 * t5803;
  t5805 = t1294 * t5804;
  t5806 = 0.2e5 / 0.729e3 * t5805;
  t5808 = t55 * t147 * t999;
  t5809 = t4711 * t5808;
  t5810 = 0.5e2 / 0.81e2 * t5809;
  t5811 = 0.35e2 / 0.54e2 * t5215;
  t5812 = 0.5e1 / 0.18e2 * t5217;
  t5814 = t1141 * t2462 * t1578;
  t5815 = 0.5e3 / 0.243e3 * t5814;
  t5816 = t5358 * t346;
  t5818 = t1141 * t530 * t5816;
  t5819 = 0.25e4 / 0.729e3 * t5818;
  t5820 = t5326 * t350;
  t5821 = t439 * t5820;
  t5822 = t4658 * t5821;
  t5823 = 0.1e4 / 0.243e3 * t5822;
  t5824 = t1421 * t1003;
  t5826 = t1141 * t530 * t5824;
  t5827 = 0.25e3 / 0.243e3 * t5826;
  t5829 = t1141 * t2478 * t1578;
  t5830 = 0.5e3 / 0.243e3 * t5829;
  t5831 = 0.175e3 / 0.162e3 * t5257;
  t5832 = 0.25e2 / 0.54e2 * t5262;
  t5833 = 0.35e2 / 0.54e2 * t5265;
  t5834 = 0.5e1 / 0.18e2 * t5269;
  t5835 = t62 * t993;
  t5836 = t5835 * t473;
  t5837 = t445 * t5836;
  t5838 = t154 * t5837;
  t5839 = 0.25e2 / 0.81e2 * t5838;
  t5840 = t388 * t1594;
  t5841 = 0.25e2 / 0.108e3 * t5840;
  t5842 = t1592 * t1602;
  t5843 = t445 * t5842;
  t5844 = t154 * t5843;
  t5845 = 0.25e2 / 0.108e3 * t5844;
  t5846 = t4756 * t4047;
  t5847 = t1838 * t5846;
  t5848 = 0.25e2 / 0.81e2 * t5847;
  t5849 = t350 * t346;
  t5850 = t194 * t5849;
  t5851 = t4760 * t5850;
  t5852 = t1838 * t5851;
  t5853 = 0.125e3 / 0.486e3 * t5852;
  t5854 = -t5806 + t5810 - t5811 - t5812 - t5815 + t5819 - t5823 - t5827 - t5830 + t5831 + t5832 - t5833 - t5834 + t5839 - t5841 - t5845 + t5848 - t5853 + t4598;
  t5855 = t4562 * t999;
  t5856 = t530 * t5855;
  t5857 = t1141 * t5856;
  t5858 = 0.5e3 / 0.729e3 * t5857;
  t5860 = t1323 * t5499 * t1584;
  t5861 = 0.125e3 / 0.486e3 * t5860;
  t5862 = t360 * t346;
  t5863 = t4610 * t5862;
  t5864 = t1843 * t5863;
  t5865 = t1336 * t5864;
  t5866 = 0.25e2 / 0.54e2 * t5865;
  t5867 = t1602 * t390;
  t5869 = t1323 * t1428 * t5867;
  t5870 = 0.25e2 / 0.162e3 * t5869;
  t5871 = t473 * t1098;
  t5872 = t1428 * t5871;
  t5873 = t1323 * t5872;
  t5874 = 0.25e2 / 0.324e3 * t5873;
  t5875 = t1550 * t1485;
  t5876 = 0.5e2 / 0.27e2 * t5875;
  t5877 = t1550 * t1489;
  t5878 = 0.5e2 / 0.27e2 * t5877;
  t5879 = t4604 * t5584;
  t5880 = 0.2e4 / 0.81e2 * t5879;
  t5881 = t464 * t5589;
  t5882 = 0.5e1 / 0.9e1 * t5881;
  t5883 = t464 * t5593;
  t5884 = 0.1e2 / 0.9e1 * t5883;
  t5885 = t464 * t5597;
  t5886 = 0.5e1 / 0.9e1 * t5885;
  t5887 = t2 * t993;
  t5888 = t5887 * t463;
  t5889 = t5888 * t436;
  t5890 = 0.2e3 / 0.81e2 * t5889;
  t5891 = t5105 * t1564;
  t5892 = 0.4e4 / 0.243e3 * t5891;
  t5893 = t5108 * t1563;
  t5894 = t1294 * t5893;
  t5895 = 0.4e4 / 0.243e3 * t5894;
  t5896 = t1410 * t1007;
  t5897 = t1295 * t5896;
  t5898 = t1294 * t5897;
  t5899 = 0.2e4 / 0.243e3 * t5898;
  t5900 = t5312 * t1554;
  t5901 = 0.25e3 / 0.81e2 * t5900;
  t5903 = t55 * t365 * t346;
  t5904 = t1396 * t5903;
  t5905 = 0.5e2 / 0.27e2 * t5904;
  t5907 = t55 * t383 * t346;
  t5908 = t1396 * t5907;
  t5909 = 0.5e2 / 0.27e2 * t5908;
  t5911 = t55 * t147 * t1003;
  t5912 = t1396 * t5911;
  t5913 = 0.25e2 / 0.27e2 * t5912;
  t5914 = -t5858 + t5861 - t5866 - t5870 - t5874 - t5876 - t5878 + t5880 + t5882 + t5884 + t5886 + t5890 + t5892 + t5895 + t5899 - t5901 + t5905 + t5909 + t5913;
  t5916 = t5766 * t4679;
  t5917 = 0.25e2 / 0.162e3 * t5916;
  t5918 = t382 * t346;
  t5919 = t1421 * t5918;
  t5920 = t1354 * t5919;
  t5921 = t1336 * t5920;
  t5922 = 0.25e2 / 0.108e3 * t5921;
  t5923 = t1410 * t5614;
  t5924 = t1338 * t5923;
  t5925 = t1336 * t5924;
  t5926 = 0.5e1 / 0.18e2 * t5925;
  t5927 = t1410 * t5619;
  t5928 = t1338 * t5927;
  t5929 = t1336 * t5928;
  t5930 = 0.5e1 / 0.36e2 * t5929;
  t5931 = t5168 * t1589;
  t5932 = 0.5e1 / 0.18e2 * t5931;
  t5933 = t5168 * t1599;
  t5934 = 0.25e2 / 0.108e3 * t5933;
  t5935 = t146 * t1003;
  t5936 = t1421 * t5935;
  t5937 = t1354 * t5936;
  t5938 = t1336 * t5937;
  t5939 = 0.25e2 / 0.216e3 * t5938;
  t5940 = t5358 * t1597;
  t5941 = t1354 * t5940;
  t5942 = t1336 * t5941;
  t5943 = 0.125e3 / 0.324e3 * t5942;
  t5944 = t146 * t999;
  t5945 = t4562 * t5944;
  t5946 = t1354 * t5945;
  t5947 = t1336 * t5946;
  t5948 = 0.25e2 / 0.324e3 * t5947;
  t5949 = t1410 * t5779;
  t5950 = t4252 * t5949;
  t5951 = t1336 * t5950;
  t5952 = 0.5e1 / 0.12e2 * t5951;
  t5953 = t5474 * t1514;
  t5954 = t1338 * t5953;
  t5955 = t1336 * t5954;
  t5956 = 0.25e2 / 0.54e2 * t5955;
  t5958 = t190 * t5734 * t468;
  t5959 = 0.5e2 / 0.81e2 * t5958;
  t5960 = t1403 * t5738;
  t5961 = 0.2e3 / 0.81e2 * t5960;
  t5962 = t1403 * t5741;
  t5963 = 0.2e3 / 0.81e2 * t5962;
  t5964 = t1403 * t5744;
  t5965 = 0.1e3 / 0.81e2 * t5964;
  t5966 = t5277 * t346;
  t5967 = t1831 * t5966;
  t5968 = t1294 * t5967;
  t5969 = 0.2e5 / 0.729e3 * t5968;
  t5971 = t190 * t5725 * t468;
  t5972 = 0.5e2 / 0.81e2 * t5971;
  t5973 = -t5917 + t5922 - t5926 - t5930 - t5932 + t5934 + t5939 - t5943 + t5948 + t5952 + t5956 + t4634 + t4637 - t5959 - t5961 - t5963 - t5965 + t5969 - t5972;
  t5975 = t190 * t5730 * t468;
  t5976 = 0.1e3 / 0.81e2 * t5975;
  t5977 = t5223 * t1480;
  t5978 = 0.1e4 / 0.243e3 * t5977;
  t5979 = 0.175e3 / 0.243e3 * t5408;
  t5980 = 0.25e2 / 0.81e2 * t5411;
  t5981 = t1626 * t382;
  t5982 = 0.2e1 * t5981;
  t5984 = params->c * t993 * t27;
  t5985 = t325 * t5984;
  t5988 = t801 * t5816;
  t5991 = t801 * t5824;
  t5999 = t27 * t1007;
  t6000 = t1463 * t5999;
  t6003 = t5887 * t27;
  t6004 = t6003 * t453;
  t6008 = t54 * t1003;
  t6009 = t152 * t6008;
  t6012 = t801 * t5855;
  t6015 = t1410 * t1012;
  t6021 = t54 * t999;
  t6022 = t152 * t6021;
  t6027 = t5354 * t1616;
  t6033 = 0.2e4 / 0.729e3 * t324 * t5985 - 0.25e4 / 0.729e3 * t190 * t5988 + 0.25e3 / 0.243e3 * t190 * t5991 + 0.1e4 / 0.243e3 * t4535 * t325 * t5820 - 0.2e4 / 0.81e2 * t478 * t5697 - 0.2e4 / 0.243e3 * t543 * t6000 - 0.2e3 / 0.81e2 * t6004 + 0.25e3 / 0.81e2 * t5316 * t1611 - 0.25e2 / 0.27e2 * t1455 * t6009 + 0.5e3 / 0.729e3 * t190 * t6012 + 0.1e5 / 0.729e3 * t2785 * t6015 * t50 - 0.1e4 / 0.243e3 * t5319 * t1534 - 0.5e2 / 0.81e2 * t4528 * t6022 + 0.1e3 / 0.81e2 * t1460 * t5701 + 0.2e5 / 0.729e3 * t543 * t6027 - 0.2e5 / 0.729e3 * t543 * t1463 * t5966;
  t6034 = t6033 * t146;
  t6035 = t27 * t1084;
  t6036 = t472 * t6035;
  t6037 = t445 * t6036;
  t6038 = t154 * t6037;
  t6039 = 0.5e1 / 0.72e2 * t6038;
  t6040 = t1090 * t475;
  t6041 = 0.5e1 / 0.72e2 * t6040;
  t6042 = t388 * t1604;
  t6043 = 0.5e1 / 0.36e2 * t6042;
  t6044 = t473 * t1021;
  t6045 = t4577 * t6044;
  t6046 = t4409 * t6045;
  t6047 = 0.25e3 / 0.243e3 * t6046;
  t6048 = t4586 * t5638;
  t6049 = t2814 * t6048;
  t6050 = 0.1e5 / 0.729e3 * t6049;
  t6051 = t484 * t1084;
  t6053 = t190 * t1496 * t1574;
  t6054 = 0.5e3 / 0.243e3 * t6053;
  t6056 = t190 * t1500 * t1574;
  t6057 = 0.5e3 / 0.243e3 * t6056;
  t6059 = t190 * t439 * t5984;
  t6060 = 0.2e4 / 0.729e3 * t6059;
  t6061 = 0.175e3 / 0.162e3 * t5504;
  t6062 = 0.25e2 / 0.54e2 * t5507;
  t6063 = 0.35e2 / 0.27e2 * t5513;
  t6064 = 0.5e1 / 0.9e1 * t5516;
  t6065 = -t5976 + t5978 + t5979 + t5980 + t5982 + t6034 + t6039 + t6041 + t6043 + t6047 - t6050 + t6051 + t6054 + t6057 - t6060 - t6061 - t6062 + t6063 + t6064;
  t6088 = -0.5e3 / 0.243e3 * t1580 + 0.1e2 / 0.9e1 * t1559 + 0.1e2 / 0.9e1 * t1561 - 0.5e2 / 0.27e2 * t1551 + 0.5e2 / 0.27e2 * t1555 + 0.4e4 / 0.243e3 * t1565 - t4783 - t4785 - 0.5e1 / 0.18e2 * t1590 - 0.25e2 / 0.108e3 * t1595 + 0.25e2 / 0.108e3 * t1600;
  tv3rho2tau5 = t9 * (t5854 + t5914 + t5973 + t6065) + 0.2e1 * t1628 + 0.2e1 * t1627 - 0.25e2 / 0.162e3 * t1586 + 0.5e1 / 0.36e2 * t1582 + 0.5e1 / 0.36e2 * t1605 - 0.2e3 / 0.81e2 * t1557 - 0.1e3 / 0.81e2 * t1568 - 0.1e3 / 0.81e2 * t1571 + 0.5e3 / 0.243e3 * t1576 + t6088;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t6090 = 0.1e1 / t32 / t562;
  t6091 = t2 * t6090;
  t6092 = t6091 * t188;
  t6093 = t6092 * t531;
  t6094 = 0.25e2 / 0.243e3 * t6093;
  t6095 = t1633 * t542;
  t6096 = t6095 * t3046;
  t6097 = 0.125e3 / 0.324e3 * t6096;
  t6098 = t1634 * t1902;
  t6099 = 0.25e2 / 0.1296e4 * t6098;
  t6100 = t1634 * t1906;
  t6101 = 0.25e2 / 0.1296e4 * t6100;
  t6102 = t56 * t56;
  t6104 = 0.1e1 / t32 / t6102;
  t6105 = t2 * t6104;
  t6106 = t6105 * t45;
  t6107 = t6106 * t1642;
  t6108 = 0.55e2 / 0.432e3 * t6107;
  t6109 = t1640 * t189;
  t6110 = t192 * t61;
  t6111 = t6110 * t62;
  t6112 = t6111 * t195;
  t6113 = t6109 * t6112;
  t6114 = 0.25e2 / 0.648e3 * t6113;
  t6115 = t1640 * t50;
  t6116 = t54 * t206;
  t6117 = t6116 * t1153;
  t6118 = t6115 * t6117;
  t6119 = 0.5e1 / 0.288e3 * t6118;
  t6120 = t55 * t1157;
  t6121 = t1641 * t6120;
  t6122 = 0.5e1 / 0.144e3 * t6121;
  t6123 = t55 * t1161;
  t6124 = t1641 * t6123;
  t6125 = 0.5e1 / 0.288e3 * t6124;
  t6126 = t2356 * t1632;
  t6128 = t6126 * t180 * t50;
  t6129 = t2814 * t6128;
  t6130 = 0.625e3 / 0.2916e4 * t6129;
  t6132 = t543 * t217 * t1645;
  t6133 = 0.125e3 / 0.972e3 * t6132;
  t6135 = t543 * t317 * t1645;
  t6136 = 0.125e3 / 0.972e3 * t6135;
  t6137 = t544 * t6090;
  t6139 = t543 * t147 * t6137;
  t6140 = 0.5e3 / 0.729e3 * t6139;
  t6141 = t542 * t1639;
  t6142 = t39 * t6141;
  t6143 = t1295 * t180;
  t6144 = t63 * t6143;
  t6145 = t6142 * t6144;
  t6146 = 0.125e3 / 0.486e3 * t6145;
  t6148 = t192 * t6104 * t61;
  t6149 = t6148 * t1651;
  t6150 = t190 * t6149;
  t6151 = 0.275e3 / 0.1944e4 * t6150;
  t6152 = t194 * t209;
  t6154 = t1141 * t1708 * t6152;
  t6155 = 0.25e2 / 0.1296e4 * t6154;
  t6156 = t3485 * params->c;
  t6157 = t1650 * t6156;
  t6158 = t190 * t6157;
  t6159 = 0.25e2 / 0.648e3 * t6158;
  t6160 = t3490 * params->c;
  t6161 = t1650 * t6160;
  t6162 = t190 * t6161;
  t6163 = 0.25e2 / 0.1296e4 * t6162;
  t6165 = t6091 * t185 * t802;
  t6166 = 0.25e2 / 0.243e3 * t6165;
  t6167 = t1633 * t539;
  t6168 = t6167 * t3087;
  t6172 = t2785 * t1632 * t180 * t50;
  t6175 = t805 * t806 * t6090;
  t6176 = 0.5e3 / 0.729e3 * t6175;
  t6177 = -t6166 - 0.125e3 / 0.324e3 * t6168 + 0.625e3 / 0.2916e4 * t6172 + t6176;
  t6178 = t6177 * t146;
  t6179 = t1661 * t316;
  t6180 = t6094 + t6097 - t6099 - t6101 - t6108 - t6114 - t6119 + t6122 + t6125 - t6130 + t6133 + t6136 - t6140 + t6146 + t6151 + t6155 - t6159 - t6163 + t6178 + t6179;
  tv3rhosigma20 = t6180 * t9 - t1636 + t1644 + t1648 - t1654 + t1662;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t6182 = 0.5e2 / 0.243e3 * t6093;
  t6183 = 0.125e3 / 0.162e3 * t6096;
  t6184 = 0.25e2 / 0.648e3 * t6098;
  t6185 = 0.25e2 / 0.648e3 * t6100;
  t6186 = 0.55e2 / 0.216e3 * t6107;
  t6187 = 0.25e2 / 0.324e3 * t6113;
  t6188 = 0.5e1 / 0.144e3 * t6118;
  t6189 = 0.5e1 / 0.72e2 * t6121;
  t6190 = 0.5e1 / 0.144e3 * t6124;
  t6191 = 0.625e3 / 0.1458e4 * t6129;
  t6192 = 0.125e3 / 0.486e3 * t6132;
  t6193 = 0.125e3 / 0.486e3 * t6135;
  t6194 = 0.1e4 / 0.729e3 * t6139;
  t6195 = 0.125e3 / 0.243e3 * t6145;
  t6196 = 0.275e3 / 0.972e3 * t6150;
  t6197 = 0.25e2 / 0.648e3 * t6154;
  t6198 = 0.25e2 / 0.324e3 * t6158;
  t6199 = 0.25e2 / 0.648e3 * t6162;
  t6200 = 0.5e2 / 0.243e3 * t6165;
  t6203 = 0.1e4 / 0.729e3 * t6175;
  t6204 = -t6200 - 0.125e3 / 0.162e3 * t6168 + 0.625e3 / 0.1458e4 * t6172 + t6203;
  t6205 = t6204 * t146;
  t6206 = t1670 * t316;
  t6207 = t6182 + t6183 - t6184 - t6185 - t6186 - t6187 - t6188 + t6189 + t6190 - t6191 + t6192 + t6193 - t6194 + t6195 + t6196 + t6197 - t6198 - t6199 + t6205 + t6206;
  tv3rhosigma21 = t6207 * t9 - t1664 + t1665 + t1666 - t1667 + t1671;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = tv3rhosigma20;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  t6209 = 0.1e3 / 0.243e3 * t6093;
  t6210 = 0.125e3 / 0.81e2 * t6096;
  t6211 = 0.25e2 / 0.324e3 * t6098;
  t6212 = 0.25e2 / 0.324e3 * t6100;
  t6213 = 0.55e2 / 0.108e3 * t6107;
  t6214 = 0.25e2 / 0.162e3 * t6113;
  t6215 = 0.5e1 / 0.72e2 * t6118;
  t6216 = 0.5e1 / 0.36e2 * t6121;
  t6217 = 0.5e1 / 0.72e2 * t6124;
  t6218 = 0.625e3 / 0.729e3 * t6129;
  t6219 = 0.125e3 / 0.243e3 * t6132;
  t6220 = 0.125e3 / 0.243e3 * t6135;
  t6221 = 0.2e4 / 0.729e3 * t6139;
  t6222 = 0.25e3 / 0.243e3 * t6145;
  t6223 = 0.275e3 / 0.486e3 * t6150;
  t6224 = 0.25e2 / 0.324e3 * t6154;
  t6225 = 0.25e2 / 0.162e3 * t6158;
  t6226 = 0.25e2 / 0.324e3 * t6162;
  t6227 = 0.1e3 / 0.243e3 * t6165;
  t6230 = 0.2e4 / 0.729e3 * t6175;
  t6231 = -t6227 - 0.125e3 / 0.81e2 * t6168 + 0.625e3 / 0.729e3 * t6172 + t6230;
  t6232 = t6231 * t146;
  t6233 = t1679 * t316;
  t6234 = t6209 + t6210 - t6211 - t6212 - t6213 - t6214 - t6215 + t6216 + t6217 - t6218 + t6219 + t6220 - t6221 + t6222 + t6223 + t6224 - t6225 - t6226 + t6232 + t6233;
  tv3rhosigma23 = t6234 * t9 - t1673 + t1674 + t1675 - t1676 + t1680;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = tv3rhosigma21;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = tv3rhosigma22;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t6236 = t147 * t853;
  t6237 = t6095 * t6236;
  t6238 = 0.125e3 / 0.324e3 * t6237;
  t6239 = t1634 * t2479;
  t6240 = 0.25e2 / 0.1296e4 * t6239;
  t6241 = t1634 * t2463;
  t6242 = 0.25e2 / 0.1296e4 * t6241;
  t6243 = t6111 * t355;
  t6244 = t6109 * t6243;
  t6245 = 0.25e2 / 0.648e3 * t6244;
  t6246 = t6116 * t1230;
  t6247 = t6115 * t6246;
  t6248 = 0.5e1 / 0.288e3 * t6247;
  t6249 = t55 * t1234;
  t6250 = t1641 * t6249;
  t6251 = 0.5e1 / 0.288e3 * t6250;
  t6253 = t6126 * t350 * t50;
  t6254 = t2814 * t6253;
  t6255 = 0.625e3 / 0.2916e4 * t6254;
  t6257 = t543 * t365 * t1645;
  t6258 = 0.125e3 / 0.972e3 * t6257;
  t6260 = t543 * t383 * t1645;
  t6261 = 0.125e3 / 0.972e3 * t6260;
  t6262 = t1295 * t350;
  t6263 = t63 * t6262;
  t6264 = t6142 * t6263;
  t6265 = 0.125e3 / 0.486e3 * t6264;
  t6266 = t194 * t360;
  t6268 = t1141 * t1708 * t6266;
  t6269 = 0.25e2 / 0.1296e4 * t6268;
  t6270 = t3794 * params->c;
  t6271 = t1650 * t6270;
  t6272 = t190 * t6271;
  t6273 = 0.25e2 / 0.1296e4 * t6272;
  t6274 = t806 * t350;
  t6275 = t6167 * t6274;
  t6277 = t1632 * t350;
  t6279 = t2785 * t6277 * t50;
  t6281 = -t6166 - 0.125e3 / 0.324e3 * t6275 + 0.625e3 / 0.2916e4 * t6279 + t6176;
  t6282 = t6281 * t146;
  t6283 = t1661 * t382;
  t6284 = t6094 + t6238 - t6240 - t6242 - t6108 - t6245 - t6248 - t6122 + t6251 - t6255 + t6258 + t6261 - t6140 + t6265 + t6151 + t6269 + t6159 - t6273 + t6282 + t6283;
  tv3rhosigma26 = t6284 * t9 - t1636 + t1644 + t1648 - t1654 + t1662;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  t6286 = 0.125e3 / 0.162e3 * t6237;
  t6287 = 0.25e2 / 0.648e3 * t6239;
  t6288 = 0.25e2 / 0.648e3 * t6241;
  t6289 = 0.25e2 / 0.324e3 * t6244;
  t6290 = 0.5e1 / 0.144e3 * t6247;
  t6291 = 0.5e1 / 0.144e3 * t6250;
  t6292 = 0.625e3 / 0.1458e4 * t6254;
  t6293 = 0.125e3 / 0.486e3 * t6257;
  t6294 = 0.125e3 / 0.486e3 * t6260;
  t6295 = 0.125e3 / 0.243e3 * t6264;
  t6296 = 0.25e2 / 0.648e3 * t6268;
  t6297 = 0.25e2 / 0.648e3 * t6272;
  t6300 = -t6200 - 0.125e3 / 0.162e3 * t6275 + 0.625e3 / 0.1458e4 * t6279 + t6203;
  t6301 = t6300 * t146;
  t6302 = t1670 * t382;
  t6303 = t6182 + t6286 - t6287 - t6288 - t6186 - t6289 - t6290 - t6189 + t6291 - t6292 + t6293 + t6294 - t6194 + t6295 + t6196 + t6296 + t6198 - t6297 + t6301 + t6302;
  tv3rhosigma27 = t6303 * t9 - t1664 + t1665 + t1666 - t1667 + t1671;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = tv3rhosigma26;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  t6305 = 0.125e3 / 0.81e2 * t6237;
  t6306 = 0.25e2 / 0.324e3 * t6239;
  t6307 = 0.25e2 / 0.324e3 * t6241;
  t6308 = 0.25e2 / 0.162e3 * t6244;
  t6309 = 0.5e1 / 0.72e2 * t6247;
  t6310 = 0.5e1 / 0.72e2 * t6250;
  t6311 = 0.625e3 / 0.729e3 * t6254;
  t6312 = 0.125e3 / 0.243e3 * t6257;
  t6313 = 0.125e3 / 0.243e3 * t6260;
  t6314 = 0.25e3 / 0.243e3 * t6264;
  t6315 = 0.25e2 / 0.324e3 * t6268;
  t6316 = 0.25e2 / 0.324e3 * t6272;
  t6319 = -t6227 - 0.125e3 / 0.81e2 * t6275 + 0.625e3 / 0.729e3 * t6279 + t6230;
  t6320 = t6319 * t146;
  t6321 = t1679 * t382;
  t6322 = t6209 + t6305 - t6306 - t6307 - t6213 - t6308 - t6309 - t6216 + t6310 - t6311 + t6312 + t6313 - t6221 + t6314 + t6223 + t6315 + t6225 - t6316 + t6320 + t6321;
  tv3rhosigma29 = t6322 * t9 - t1673 + t1674 + t1675 - t1676 + t1680;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = tv3rhosigma27;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = tv3rhosigma28;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t6324 = t15 * t35;
  t6325 = t6324 * t167;
  t6326 = t4167 * t6325;
  t6327 = t1294 * t6326;
  t6328 = 0.125e4 / 0.729e3 * t6327;
  t6329 = t4299 * t1692;
  t6330 = 0.25e3 / 0.243e3 * t6329;
  t6331 = t154 * t1357;
  t6332 = 0.25e2 / 0.216e3 * t6331;
  t6333 = t30 * t573;
  t6334 = t6333 * t62;
  t6335 = t6334 * t1340;
  t6336 = t1700 * t6335;
  t6337 = 0.5e1 / 0.288e3 * t6336;
  t6338 = t4129 * t35;
  t6339 = t1295 * t6338;
  t6340 = t1294 * t6339;
  t6341 = 0.125e4 / 0.729e3 * t6340;
  t6342 = t1296 * t177;
  t6343 = t1295 * t6342;
  t6344 = t1294 * t6343;
  t6345 = 0.2e4 / 0.729e3 * t6344;
  t6346 = t4302 * t1691;
  t6347 = t1294 * t6346;
  t6348 = 0.25e3 / 0.243e3 * t6347;
  t6349 = t4809 * t1122;
  t6350 = 0.25e3 / 0.81e2 * t6349;
  t6351 = t6104 * t206;
  t6352 = t6351 * t62;
  t6353 = t6352 * t1695;
  t6354 = t1323 * t6353;
  t6355 = 0.275e3 / 0.3888e4 * t6354;
  t6356 = t1707 * t8;
  t6357 = t6356 * t1695;
  t6358 = t1323 * t6357;
  t6359 = 0.25e2 / 0.1296e4 * t6358;
  t6360 = t4129 * t194;
  t6361 = t1708 * t6360;
  t6362 = t1323 * t6361;
  t6363 = 0.125e3 / 0.7776e4 * t6362;
  t6364 = t800 * t3502;
  t6365 = t1139 * t6364;
  t6366 = t440 * t168;
  t6367 = t409 * t6366;
  t6368 = t6365 * t6367;
  t6369 = 0.125e3 / 0.972e3 * t6368;
  t6370 = -t6328 - t6330 + t6332 + t6337 + t6341 + t6345 - t6348 - t6350 - t6355 + t6359 - t6363 + t6369;
  t6371 = t1640 * t185;
  t6372 = t6371 * t1322;
  t6373 = t4410 * t1326;
  t6374 = t6372 * t6373;
  t6375 = 0.25e2 / 0.1296e4 * t6374;
  t6376 = t1296 * t553;
  t6377 = t1708 * t6376;
  t6378 = t1323 * t6377;
  t6379 = 0.25e2 / 0.2592e4 * t6378;
  t6380 = t6365 * t6373;
  t6381 = 0.25e2 / 0.324e3 * t6380;
  t6382 = t1691 * t3863;
  t6383 = t5013 * t6382;
  t6384 = 0.125e4 / 0.729e3 * t6383;
  t6385 = t16 * t209;
  t6386 = t440 * t6385;
  t6387 = t1797 * t6386;
  t6388 = t6365 * t6387;
  t6389 = 0.25e2 / 0.324e3 * t6388;
  t6390 = t1702 * t1356;
  t6391 = t1700 * t6390;
  t6392 = 0.25e2 / 0.1728e4 * t6391;
  t6393 = t4407 * t1639;
  t6394 = t805 * t6393;
  t6395 = t447 * t1896;
  t6396 = t4410 * t6395;
  t6397 = t6394 * t6396;
  t6398 = 0.125e3 / 0.972e3 * t6397;
  t6399 = t154 * t1341;
  t6400 = 0.5e1 / 0.36e2 * t6399;
  t6401 = t3438 * t1695;
  t6402 = t1141 * t6401;
  t6403 = 0.175e3 / 0.486e3 * t6402;
  t6404 = t3442 * t1695;
  t6405 = t1141 * t6404;
  t6406 = 0.25e2 / 0.162e3 * t6405;
  t6407 = t1143 * t6360;
  t6408 = t1141 * t6407;
  t6409 = 0.125e3 / 0.972e3 * t6408;
  t6410 = t452 * t189;
  t6411 = t1152 * t326;
  t6412 = t3503 * t6411;
  t6413 = t6410 * t6412;
  t6414 = 0.25e2 / 0.162e3 * t6413;
  t6415 = t1143 * t6376;
  t6416 = t1141 * t6415;
  t6417 = 0.25e2 / 0.324e3 * t6416;
  t6418 = t6375 + t6379 - t6381 + t6384 - t6389 - t6392 - t6398 - t6400 - t6403 + t6406 - t6409 + t6414 + t6417;
  t6420 = t1296 * t316;
  t6421 = t1702 * t6420;
  t6422 = t1700 * t6421;
  t6423 = 0.5e1 / 0.576e3 * t6422;
  t6424 = t322 * t1712;
  t6425 = 0.5e1 / 0.72e2 * t6424;
  t6426 = t1354 * t6420;
  t6427 = t154 * t6426;
  t6428 = 0.5e1 / 0.72e2 * t6427;
  t6429 = t416 * t167;
  t6430 = t439 * t6429;
  t6431 = t4312 * t6430;
  t6432 = 0.125e3 / 0.486e3 * t6431;
  t6433 = t4448 * t1716;
  t6435 = t325 * t6429;
  t6436 = t4441 * t6435;
  t6438 = t4216 * t1172;
  t6441 = t800 * t801 * t177;
  t6442 = t1373 * t6441;
  t6443 = 0.1e3 / 0.243e3 * t6442;
  t6445 = t1719 * t180 * t50;
  t6446 = t5061 * t6445;
  t6449 = t543 * t4460 * t1719;
  t6451 = t1378 * t6325;
  t6452 = t543 * t6451;
  t6454 = t16 * t177;
  t6456 = t543 * t1378 * t6454;
  t6457 = 0.2e4 / 0.729e3 * t6456;
  t6458 = 0.125e3 / 0.486e3 * t6433 - 0.125e3 / 0.486e3 * t6436 + 0.25e3 / 0.81e2 * t6438 + t6443 - 0.125e4 / 0.729e3 * t6446 - 0.125e4 / 0.729e3 * t6449 + 0.125e4 / 0.729e3 * t6452 - t6457;
  t6459 = t6458 * t146;
  t6460 = t1639 * t573;
  t6461 = t6460 * t446;
  t6462 = params->c * t209;
  t6463 = t447 * t6462;
  t6464 = t6461 * t6463;
  t6465 = t1323 * t6464;
  t6466 = 0.25e2 / 0.1296e4 * t6465;
  t6467 = t1707 * t446;
  t6468 = t4226 * t4313;
  t6469 = t6467 * t6468;
  t6470 = t1323 * t6469;
  t6471 = 0.125e3 / 0.7776e4 * t6470;
  t6472 = t4345 * t1703;
  t6473 = t154 * t6472;
  t6474 = 0.5e1 / 0.36e2 * t6473;
  t6475 = t4129 * t146;
  t6476 = t1354 * t6475;
  t6477 = t154 * t6476;
  t6478 = 0.25e2 / 0.216e3 * t6477;
  t6479 = t4311 * t50;
  t6480 = t408 * t61;
  t6481 = t1152 * t167;
  t6482 = t6480 * t6481;
  t6483 = t6479 * t6482;
  t6484 = 0.25e2 / 0.216e3 * t6483;
  t6485 = t452 * t50;
  t6486 = t6485 * t1154;
  t6487 = 0.5e1 / 0.72e2 * t6486;
  t6488 = t541 * t58;
  t6489 = t6488 * t61;
  t6490 = t805 * t6489;
  t6491 = t1152 * t544;
  t6492 = t6491 * t1297;
  t6493 = t6490 * t6492;
  t6494 = 0.25e3 / 0.243e3 * t6493;
  t6495 = -t6423 + t6425 + t6428 + t6432 + t6459 - t6466 + t6471 + t6474 - t6478 - t6484 + t6487 - t6494;
  t6496 = t6105 * t40;
  t6497 = t6496 * t153;
  t6498 = t6497 * t1704;
  t6499 = 0.55e2 / 0.864e3 * t6498;
  t6500 = t1701 * t8;
  t6501 = t6500 * t1703;
  t6502 = t1700 * t6501;
  t6503 = 0.5e1 / 0.288e3 * t6502;
  t6504 = t1702 * t6475;
  t6505 = t1700 * t6504;
  t6506 = 0.25e2 / 0.1728e4 * t6505;
  t6507 = t4364 * t1703;
  t6508 = t154 * t6507;
  t6509 = 0.35e2 / 0.108e3 * t6508;
  t6510 = t1723 * t316;
  t6511 = t1280 * t1132;
  t6512 = t1279 * t6511;
  t6513 = 0.1e3 / 0.243e3 * t6512;
  t6514 = t1266 * t1685;
  t6515 = t6514 * t1688;
  t6516 = 0.25e2 / 0.216e3 * t6515;
  t6517 = t55 * t201;
  t6518 = t6517 * t409;
  t6519 = t1686 * t6518;
  t6520 = 0.35e2 / 0.108e3 * t6519;
  t6521 = t1687 * t1157;
  t6522 = t1686 * t6521;
  t6523 = 0.5e1 / 0.36e2 * t6522;
  t6524 = t4185 * t1682;
  t6525 = 0.125e3 / 0.486e3 * t6524;
  t6526 = t4188 * t403;
  t6527 = t1279 * t6526;
  t6528 = 0.25e2 / 0.162e3 * t6527;
  t6529 = t1280 * t1128;
  t6530 = t1279 * t6529;
  t6531 = 0.25e2 / 0.162e3 * t6530;
  t6532 = t1687 * t1161;
  t6533 = t1686 * t6532;
  t6534 = 0.5e1 / 0.72e2 * t6533;
  t6535 = t6499 - t6503 + t6506 - t6509 + t6510 - t6513 + t6516 + t6520 - t6523 - t6525 + t6528 + t6531 - t6534;
  tv3rhosigmatau0 = t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724 + t9 * (t6370 + t6418 + t6495 + t6535);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t6539 = t4657 * t50;
  t6540 = t1152 * t171;
  t6541 = t6480 * t6540;
  t6542 = t6539 * t6541;
  t6543 = 0.25e2 / 0.216e3 * t6542;
  t6544 = t478 * t50;
  t6545 = t6544 * t1154;
  t6546 = 0.5e1 / 0.72e2 * t6545;
  t6547 = t6491 * t1411;
  t6548 = t6490 * t6547;
  t6549 = 0.25e3 / 0.243e3 * t6548;
  t6550 = t1410 * t316;
  t6551 = t1702 * t6550;
  t6552 = t1700 * t6551;
  t6553 = 0.5e1 / 0.576e3 * t6552;
  t6554 = t416 * t171;
  t6555 = t439 * t6554;
  t6556 = t4658 * t6555;
  t6557 = 0.125e3 / 0.486e3 * t6556;
  t6558 = t4364 * t1740;
  t6559 = t154 * t6558;
  t6560 = 0.35e2 / 0.108e3 * t6559;
  t6561 = t4345 * t1740;
  t6562 = t154 * t6561;
  t6563 = 0.5e1 / 0.36e2 * t6562;
  t6564 = t6497 * t1741;
  t6565 = 0.55e2 / 0.864e3 * t6564;
  t6566 = t1403 * t6511;
  t6567 = 0.1e3 / 0.243e3 * t6566;
  t6568 = t1729 * t6518;
  t6569 = 0.35e2 / 0.108e3 * t6568;
  t6571 = t1729 * t6521;
  t6572 = 0.5e1 / 0.36e2 * t6571;
  t6573 = t26 * t35;
  t6574 = t6573 * t171;
  t6575 = t1831 * t6574;
  t6576 = t1294 * t6575;
  t6577 = 0.125e4 / 0.729e3 * t6576;
  t6578 = t1403 * t6526;
  t6579 = 0.25e2 / 0.162e3 * t6578;
  t6580 = t1403 * t6529;
  t6581 = 0.25e2 / 0.162e3 * t6580;
  t6582 = t1729 * t6532;
  t6583 = 0.5e1 / 0.72e2 * t6582;
  t6584 = t467 * t172;
  t6585 = t409 * t6584;
  t6586 = t6365 * t6585;
  t6587 = 0.125e3 / 0.972e3 * t6586;
  t6588 = t4577 * t1429;
  t6589 = t6372 * t6588;
  t6590 = 0.25e2 / 0.1296e4 * t6589;
  t6591 = t1410 * t553;
  t6592 = t1708 * t6591;
  t6593 = t1323 * t6592;
  t6594 = 0.25e2 / 0.2592e4 * t6593;
  t6595 = t6365 * t6588;
  t6596 = 0.25e2 / 0.324e3 * t6595;
  t6597 = t1732 * t3863;
  t6598 = t5013 * t6597;
  t6599 = 0.125e4 / 0.729e3 * t6598;
  t6600 = t27 * t209;
  t6601 = t467 * t6600;
  t6602 = t1797 * t6601;
  t6603 = t6365 * t6602;
  t6604 = 0.25e2 / 0.324e3 * t6603;
  t6605 = -t6572 - t6577 + t6579 + t6581 - t6583 + t6587 + t6590 + t6594 - t6596 + t6599 - t6604;
  t6607 = t6352 * t1736;
  t6608 = t1323 * t6607;
  t6609 = 0.275e3 / 0.3888e4 * t6608;
  t6610 = t6356 * t1736;
  t6611 = t1323 * t6610;
  t6612 = 0.25e2 / 0.1296e4 * t6611;
  t6613 = t6500 * t1740;
  t6614 = t1700 * t6613;
  t6615 = 0.5e1 / 0.288e3 * t6614;
  t6616 = t1410 * t177;
  t6617 = t1295 * t6616;
  t6618 = t1294 * t6617;
  t6619 = 0.2e4 / 0.729e3 * t6618;
  t6620 = t5300 * t1122;
  t6621 = 0.25e3 / 0.81e2 * t6620;
  t6622 = t4299 * t1733;
  t6623 = 0.25e3 / 0.243e3 * t6622;
  t6624 = t4302 * t1732;
  t6625 = t1294 * t6624;
  t6626 = 0.25e3 / 0.243e3 * t6625;
  t6627 = t1707 * t472;
  t6628 = t4610 * t4536;
  t6630 = t1323 * t6627 * t6628;
  t6631 = 0.125e3 / 0.7776e4 * t6630;
  t6632 = t6460 * t472;
  t6633 = t473 * t6462;
  t6635 = t1323 * t6632 * t6633;
  t6636 = 0.25e2 / 0.1296e4 * t6635;
  t6637 = t473 * t1896;
  t6638 = t4577 * t6637;
  t6639 = t6394 * t6638;
  t6640 = 0.125e3 / 0.972e3 * t6639;
  t6641 = t154 * t1437;
  t6642 = 0.5e1 / 0.36e2 * t6641;
  t6643 = -t6609 + t6612 - t6615 + t6619 - t6621 - t6623 - t6626 + t6631 - t6636 - t6640 - t6642;
  t6644 = t154 * t1447;
  t6645 = 0.25e2 / 0.216e3 * t6644;
  t6646 = t1826 * t6412;
  t6647 = 0.25e2 / 0.162e3 * t6646;
  t6649 = t1141 * t1143 * t6591;
  t6650 = 0.25e2 / 0.324e3 * t6649;
  t6651 = t6334 * t1436;
  t6652 = t1700 * t6651;
  t6653 = 0.5e1 / 0.288e3 * t6652;
  t6654 = t1702 * t1446;
  t6655 = t1700 * t6654;
  t6656 = 0.25e2 / 0.1728e4 * t6655;
  t6658 = t1141 * t3442 * t1736;
  t6659 = 0.25e2 / 0.162e3 * t6658;
  t6661 = t1141 * t3438 * t1736;
  t6662 = 0.175e3 / 0.486e3 * t6661;
  t6663 = t1756 * t316;
  t6664 = t325 * t6554;
  t6665 = t4535 * t6664;
  t6667 = t4604 * t1172;
  t6669 = t1460 * t6441;
  t6670 = 0.1e3 / 0.243e3 * t6669;
  t6672 = t1752 * t180 * t50;
  t6673 = t5342 * t6672;
  t6676 = t543 * t1463 * t6574;
  t6678 = t27 * t177;
  t6680 = t543 * t1463 * t6678;
  t6681 = 0.2e4 / 0.729e3 * t6680;
  t6682 = -0.125e3 / 0.486e3 * t6665 + 0.25e3 / 0.81e2 * t6667 + t6670 - 0.125e4 / 0.729e3 * t6673 + 0.125e4 / 0.729e3 * t6676 - t6681;
  t6683 = t6682 * t146;
  t6684 = t322 * t1747;
  t6685 = 0.5e1 / 0.72e2 * t6684;
  t6686 = t1354 * t6550;
  t6687 = t154 * t6686;
  t6688 = 0.5e1 / 0.72e2 * t6687;
  t6689 = t6645 + t6647 + t6650 + t6653 - t6656 + t6659 - t6662 + t6663 + t6683 + t6685 + t6688;
  tv3rhosigmatau1 = t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757 + t9 * (-t6543 + t6546 - t6549 - t6553 + t6557 - t6560 + t6563 + t6565 - t6567 + t6569 + t6605 + t6643 + t6689);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  t6693 = 0.25e4 / 0.729e3 * t6327;
  t6697 = 0.2e3 / 0.243e3 * t6442;
  t6701 = 0.4e4 / 0.729e3 * t6456;
  t6702 = 0.125e3 / 0.243e3 * t6433 - 0.125e3 / 0.243e3 * t6436 + 0.5e3 / 0.81e2 * t6438 + t6697 - 0.25e4 / 0.729e3 * t6446 - 0.25e4 / 0.729e3 * t6449 + 0.25e4 / 0.729e3 * t6452 - t6701;
  t6703 = t6702 * t146;
  t6704 = 0.5e3 / 0.243e3 * t6329;
  t6705 = 0.25e2 / 0.108e3 * t6331;
  t6706 = 0.5e1 / 0.144e3 * t6336;
  t6707 = 0.25e4 / 0.729e3 * t6340;
  t6708 = 0.4e4 / 0.729e3 * t6344;
  t6709 = 0.5e3 / 0.243e3 * t6347;
  t6710 = 0.5e3 / 0.81e2 * t6349;
  t6711 = 0.275e3 / 0.1944e4 * t6354;
  t6712 = 0.25e2 / 0.648e3 * t6358;
  t6713 = 0.125e3 / 0.3888e4 * t6362;
  t6714 = -t6693 + t6703 - t6704 + t6705 + t6706 + t6707 + t6708 - t6709 - t6710 - t6711 + t6712 - t6713;
  t6715 = 0.125e3 / 0.486e3 * t6368;
  t6716 = 0.25e2 / 0.648e3 * t6374;
  t6717 = 0.25e2 / 0.1296e4 * t6378;
  t6718 = 0.25e2 / 0.162e3 * t6380;
  t6719 = 0.25e4 / 0.729e3 * t6383;
  t6720 = 0.25e2 / 0.162e3 * t6388;
  t6721 = 0.25e2 / 0.864e3 * t6391;
  t6722 = 0.125e3 / 0.486e3 * t6397;
  t6723 = 0.5e1 / 0.18e2 * t6399;
  t6724 = 0.175e3 / 0.243e3 * t6402;
  t6725 = 0.25e2 / 0.81e2 * t6405;
  t6726 = 0.125e3 / 0.486e3 * t6408;
  t6727 = 0.25e2 / 0.81e2 * t6413;
  t6728 = t6715 + t6716 + t6717 - t6718 + t6719 - t6720 - t6721 - t6722 - t6723 - t6724 + t6725 - t6726 + t6727;
  t6730 = 0.25e2 / 0.162e3 * t6416;
  t6731 = 0.5e1 / 0.288e3 * t6422;
  t6732 = 0.5e1 / 0.36e2 * t6424;
  t6733 = 0.5e1 / 0.36e2 * t6427;
  t6734 = 0.125e3 / 0.243e3 * t6431;
  t6735 = 0.25e2 / 0.648e3 * t6465;
  t6736 = 0.125e3 / 0.3888e4 * t6470;
  t6737 = t1768 * t316;
  t6738 = 0.5e1 / 0.18e2 * t6473;
  t6739 = 0.25e2 / 0.108e3 * t6477;
  t6740 = 0.25e2 / 0.108e3 * t6483;
  t6741 = 0.5e1 / 0.36e2 * t6486;
  t6742 = t6730 - t6731 + t6732 + t6733 + t6734 - t6735 + t6736 + t6737 + t6738 - t6739 - t6740 + t6741;
  t6743 = 0.5e3 / 0.243e3 * t6493;
  t6744 = 0.55e2 / 0.432e3 * t6498;
  t6745 = 0.5e1 / 0.144e3 * t6502;
  t6746 = 0.25e2 / 0.864e3 * t6505;
  t6747 = 0.35e2 / 0.54e2 * t6508;
  t6748 = 0.2e3 / 0.243e3 * t6512;
  t6749 = 0.25e2 / 0.108e3 * t6515;
  t6750 = 0.35e2 / 0.54e2 * t6519;
  t6751 = 0.5e1 / 0.18e2 * t6522;
  t6752 = 0.125e3 / 0.243e3 * t6524;
  t6753 = 0.25e2 / 0.81e2 * t6527;
  t6754 = 0.25e2 / 0.81e2 * t6530;
  t6755 = 0.5e1 / 0.36e2 * t6533;
  t6756 = -t6743 + t6744 - t6745 + t6746 - t6747 - t6748 + t6749 + t6750 - t6751 - t6752 + t6753 + t6754 - t6755;
  tv3rhosigmatau2 = t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769 + t9 * (t6714 + t6728 + t6742 + t6756);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  t6760 = 0.25e2 / 0.108e3 * t6542;
  t6761 = 0.5e1 / 0.36e2 * t6545;
  t6762 = 0.5e3 / 0.243e3 * t6548;
  t6763 = 0.5e1 / 0.288e3 * t6552;
  t6764 = 0.125e3 / 0.243e3 * t6556;
  t6765 = 0.35e2 / 0.54e2 * t6559;
  t6766 = 0.5e1 / 0.18e2 * t6562;
  t6767 = 0.55e2 / 0.432e3 * t6564;
  t6768 = 0.2e3 / 0.243e3 * t6566;
  t6769 = 0.35e2 / 0.54e2 * t6568;
  t6771 = 0.5e1 / 0.18e2 * t6571;
  t6772 = 0.25e4 / 0.729e3 * t6576;
  t6773 = 0.25e2 / 0.81e2 * t6578;
  t6774 = 0.25e2 / 0.81e2 * t6580;
  t6775 = 0.5e1 / 0.36e2 * t6582;
  t6776 = 0.125e3 / 0.486e3 * t6586;
  t6777 = 0.25e2 / 0.648e3 * t6589;
  t6778 = 0.25e2 / 0.1296e4 * t6593;
  t6779 = 0.25e2 / 0.162e3 * t6595;
  t6780 = 0.25e4 / 0.729e3 * t6598;
  t6781 = 0.25e2 / 0.162e3 * t6603;
  t6782 = -t6771 - t6772 + t6773 + t6774 - t6775 + t6776 + t6777 + t6778 - t6779 + t6780 - t6781;
  t6784 = 0.275e3 / 0.1944e4 * t6608;
  t6785 = 0.25e2 / 0.648e3 * t6611;
  t6786 = 0.5e1 / 0.144e3 * t6614;
  t6787 = 0.4e4 / 0.729e3 * t6618;
  t6788 = 0.5e3 / 0.81e2 * t6620;
  t6789 = 0.5e3 / 0.243e3 * t6622;
  t6790 = 0.5e3 / 0.243e3 * t6625;
  t6791 = t1780 * t316;
  t6792 = 0.125e3 / 0.3888e4 * t6630;
  t6793 = 0.25e2 / 0.648e3 * t6635;
  t6794 = 0.125e3 / 0.486e3 * t6639;
  t6795 = -t6784 + t6785 - t6786 + t6787 - t6788 - t6789 - t6790 + t6791 + t6792 - t6793 - t6794;
  t6796 = 0.5e1 / 0.18e2 * t6641;
  t6797 = 0.25e2 / 0.108e3 * t6644;
  t6798 = 0.25e2 / 0.81e2 * t6646;
  t6799 = 0.25e2 / 0.162e3 * t6649;
  t6800 = 0.5e1 / 0.144e3 * t6652;
  t6801 = 0.25e2 / 0.864e3 * t6655;
  t6802 = 0.25e2 / 0.81e2 * t6658;
  t6803 = 0.175e3 / 0.243e3 * t6661;
  t6806 = 0.2e3 / 0.243e3 * t6669;
  t6809 = 0.4e4 / 0.729e3 * t6680;
  t6810 = -0.125e3 / 0.243e3 * t6665 + 0.5e3 / 0.81e2 * t6667 + t6806 - 0.25e4 / 0.729e3 * t6673 + 0.25e4 / 0.729e3 * t6676 - t6809;
  t6811 = t6810 * t146;
  t6812 = 0.5e1 / 0.36e2 * t6684;
  t6813 = 0.5e1 / 0.36e2 * t6687;
  t6814 = -t6796 + t6797 + t6798 + t6799 + t6800 - t6801 + t6802 - t6803 + t6811 + t6812 + t6813;
  tv3rhosigmatau3 = t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781 + t9 * (-t6760 + t6761 - t6762 - t6763 + t6764 - t6765 + t6766 + t6767 - t6768 + t6769 + t6782 + t6795 + t6814);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = tv3rhosigmatau0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = tv3rhosigmatau1;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t6818 = t154 * t1521;
  t6819 = 0.25e2 / 0.216e3 * t6818;
  t6820 = t1702 * t1520;
  t6821 = t1700 * t6820;
  t6822 = 0.25e2 / 0.1728e4 * t6821;
  t6823 = t447 * t853;
  t6824 = t4410 * t6823;
  t6825 = t6394 * t6824;
  t6826 = 0.125e3 / 0.972e3 * t6825;
  t6827 = t154 * t1516;
  t6828 = 0.5e1 / 0.36e2 * t6827;
  t6829 = t902 * t1296;
  t6830 = t1143 * t6829;
  t6831 = t1141 * t6830;
  t6832 = 0.25e2 / 0.324e3 * t6831;
  t6833 = t6334 * t1515;
  t6834 = t1700 * t6833;
  t6835 = 0.5e1 / 0.288e3 * t6834;
  t6836 = t1152 * t390;
  t6837 = t3503 * t6836;
  t6838 = t6410 * t6837;
  t6839 = 0.25e2 / 0.162e3 * t6838;
  t6840 = t1723 * t382;
  t6841 = t6491 * t1492;
  t6842 = t6490 * t6841;
  t6843 = 0.25e3 / 0.243e3 * t6842;
  t6844 = t1296 * t382;
  t6845 = t1702 * t6844;
  t6846 = t1700 * t6845;
  t6847 = 0.5e1 / 0.576e3 * t6846;
  t6849 = t388 * t1712;
  t6850 = 0.5e1 / 0.72e2 * t6849;
  t6851 = t1354 * t6844;
  t6852 = t154 * t6851;
  t6853 = 0.5e1 / 0.72e2 * t6852;
  t6854 = t416 * t336;
  t6855 = t439 * t6854;
  t6856 = t4312 * t6855;
  t6857 = 0.125e3 / 0.486e3 * t6856;
  t6858 = t1152 * t336;
  t6859 = t6480 * t6858;
  t6860 = t6479 * t6859;
  t6861 = 0.25e2 / 0.216e3 * t6860;
  t6862 = t6485 * t1231;
  t6863 = 0.5e1 / 0.72e2 * t6862;
  t6864 = t325 * t6854;
  t6865 = t4441 * t6864;
  t6867 = t4216 * t1241;
  t6869 = t1719 * t350;
  t6870 = t6869 * t50;
  t6871 = t5061 * t6870;
  t6873 = t6324 * t336;
  t6874 = t1378 * t6873;
  t6875 = t543 * t6874;
  t6877 = -0.125e3 / 0.486e3 * t6865 + 0.25e3 / 0.81e2 * t6867 + t6443 - 0.125e4 / 0.729e3 * t6871 + 0.125e4 / 0.729e3 * t6875 - t6457;
  t6878 = t6877 * t146;
  t6879 = t6850 + t6853 + t6857 - t6861 + t6863 + t6345 - t6355 - t6359 - t6403 - t6406 + t6878;
  t6881 = t4410 * t1510;
  t6882 = t6365 * t6881;
  t6883 = 0.25e2 / 0.324e3 * t6882;
  t6884 = t16 * t360;
  t6885 = t440 * t6884;
  t6886 = t1797 * t6885;
  t6887 = t6365 * t6886;
  t6888 = 0.25e2 / 0.324e3 * t6887;
  t6889 = t440 * t337;
  t6890 = t409 * t6889;
  t6891 = t6365 * t6890;
  t6892 = 0.125e3 / 0.972e3 * t6891;
  t6893 = t4167 * t6873;
  t6894 = t1294 * t6893;
  t6895 = 0.125e4 / 0.729e3 * t6894;
  t6896 = t4883 * t403;
  t6897 = t1279 * t6896;
  t6898 = 0.25e2 / 0.162e3 * t6897;
  t6899 = t1280 * t1220;
  t6900 = t1279 * t6899;
  t6901 = 0.25e2 / 0.162e3 * t6900;
  t6902 = t1687 * t1234;
  t6903 = t1686 * t6902;
  t6904 = 0.5e1 / 0.72e2 * t6903;
  t6905 = t4809 * t1214;
  t6906 = 0.25e3 / 0.81e2 * t6905;
  t6907 = t5105 * t1692;
  t6908 = 0.25e3 / 0.243e3 * t6907;
  t6909 = t5108 * t1691;
  t6910 = t1294 * t6909;
  t6911 = 0.25e3 / 0.243e3 * t6910;
  t6912 = t6372 * t6881;
  t6913 = 0.25e2 / 0.1296e4 * t6912;
  t6914 = -t6883 - t6888 + t6892 - t6895 + t6898 + t6901 - t6904 - t6906 - t6908 - t6911 + t6913;
  t6915 = t1708 * t6829;
  t6916 = t1323 * t6915;
  t6917 = 0.25e2 / 0.2592e4 * t6916;
  t6919 = t350 * t40 * t152;
  t6920 = t1691 * t6919;
  t6921 = t5013 * t6920;
  t6922 = 0.125e4 / 0.729e3 * t6921;
  t6923 = t4226 * t5037;
  t6924 = t6467 * t6923;
  t6925 = t1323 * t6924;
  t6926 = 0.125e3 / 0.7776e4 * t6925;
  t6927 = params->c * t360;
  t6928 = t447 * t6927;
  t6929 = t6461 * t6928;
  t6930 = t1323 * t6929;
  t6931 = 0.25e2 / 0.1296e4 * t6930;
  t6932 = t6917 + t6922 - t6474 + t6499 + t6503 - t6509 + t6926 - t6931 - t6513 + t6520 + t6523;
  tv3rhosigmatau6 = t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724 + t9 * (t6819 - t6822 - t6826 - t6828 + t6832 + t6835 + t6839 + t6840 - t6843 - t6847 + t6879 + t6914 + t6932);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  t6936 = t1410 * t902;
  t6937 = t1708 * t6936;
  t6938 = t1323 * t6937;
  t6939 = 0.25e2 / 0.2592e4 * t6938;
  t6940 = t4577 * t1584;
  t6941 = t6365 * t6940;
  t6942 = 0.25e2 / 0.324e3 * t6941;
  t6943 = t1732 * t6919;
  t6944 = t5013 * t6943;
  t6945 = 0.125e4 / 0.729e3 * t6944;
  t6946 = -t6560 - t6563 + t6565 - t6567 + t6569 + t6572 + t6939 - t6942 + t6945 - t6609 - t6612 + t6615;
  t6947 = t416 * t346;
  t6948 = t439 * t6947;
  t6949 = t4658 * t6948;
  t6950 = 0.125e3 / 0.486e3 * t6949;
  t6951 = t1152 * t346;
  t6952 = t6480 * t6951;
  t6953 = t6539 * t6952;
  t6954 = 0.25e2 / 0.216e3 * t6953;
  t6955 = t6544 * t1231;
  t6956 = 0.5e1 / 0.72e2 * t6955;
  t6957 = t6491 * t1563;
  t6958 = t6490 * t6957;
  t6959 = 0.25e3 / 0.243e3 * t6958;
  t6960 = t4610 * t5326;
  t6961 = t6627 * t6960;
  t6962 = t1323 * t6961;
  t6963 = 0.125e3 / 0.7776e4 * t6962;
  t6964 = t1702 * t1598;
  t6965 = t1700 * t6964;
  t6966 = 0.25e2 / 0.1728e4 * t6965;
  t6967 = t473 * t853;
  t6968 = t4577 * t6967;
  t6969 = t6394 * t6968;
  t6970 = 0.125e3 / 0.972e3 * t6969;
  t6971 = t154 * t1589;
  t6972 = 0.5e1 / 0.36e2 * t6971;
  t6973 = t1826 * t6837;
  t6974 = 0.25e2 / 0.162e3 * t6973;
  t6976 = t1141 * t1143 * t6936;
  t6977 = 0.25e2 / 0.324e3 * t6976;
  t6978 = t6950 - t6954 + t6956 - t6959 + t6963 + t6619 - t6659 - t6662 - t6966 - t6970 - t6972 + t6974 + t6977;
  t6980 = t1756 * t382;
  t6981 = t5474 * t146;
  t6982 = t1354 * t6981;
  t6983 = t154 * t6982;
  t6984 = 0.25e2 / 0.216e3 * t6983;
  t6985 = t1702 * t6981;
  t6986 = t1700 * t6985;
  t6987 = 0.25e2 / 0.1728e4 * t6986;
  t6988 = t194 * t5474;
  t6990 = t1141 * t1143 * t6988;
  t6991 = 0.125e3 / 0.972e3 * t6990;
  t6992 = t154 * t1599;
  t6993 = 0.25e2 / 0.216e3 * t6992;
  t6994 = t6334 * t1588;
  t6995 = t1700 * t6994;
  t6996 = 0.5e1 / 0.288e3 * t6995;
  t6997 = t1410 * t382;
  t6998 = t1702 * t6997;
  t6999 = t1700 * t6998;
  t7000 = 0.5e1 / 0.576e3 * t6999;
  t7001 = t388 * t1747;
  t7002 = 0.5e1 / 0.72e2 * t7001;
  t7003 = t1354 * t6997;
  t7004 = t154 * t7003;
  t7005 = 0.5e1 / 0.72e2 * t7004;
  t7006 = t5223 * t1682;
  t7007 = 0.125e3 / 0.486e3 * t7006;
  t7008 = t1549 * t1728;
  t7009 = t7008 * t1688;
  t7010 = 0.25e2 / 0.216e3 * t7009;
  t7011 = t1403 * t6896;
  t7012 = 0.25e2 / 0.162e3 * t7011;
  t7013 = t6980 - t6984 + t6987 - t6991 + t6993 + t6996 - t7000 + t7002 + t7005 - t7007 + t7010 + t7012;
  t7014 = t1403 * t6899;
  t7015 = 0.25e2 / 0.162e3 * t7014;
  t7016 = t1729 * t6902;
  t7017 = 0.5e1 / 0.72e2 * t7016;
  t7018 = t6573 * t346;
  t7019 = t1831 * t7018;
  t7020 = t1294 * t7019;
  t7021 = 0.125e4 / 0.729e3 * t7020;
  t7022 = t27 * t360;
  t7023 = t467 * t7022;
  t7024 = t1797 * t7023;
  t7025 = t6365 * t7024;
  t7026 = 0.25e2 / 0.324e3 * t7025;
  t7027 = t467 * t347;
  t7028 = t409 * t7027;
  t7029 = t6365 * t7028;
  t7030 = 0.125e3 / 0.972e3 * t7029;
  t7031 = t6372 * t6940;
  t7032 = 0.25e2 / 0.1296e4 * t7031;
  t7033 = t1708 * t6988;
  t7034 = t1323 * t7033;
  t7035 = 0.125e3 / 0.7776e4 * t7034;
  t7036 = t5319 * t1716;
  t7038 = t325 * t6947;
  t7039 = t4535 * t7038;
  t7041 = t4604 * t1241;
  t7043 = t1752 * t350;
  t7044 = t7043 * t50;
  t7045 = t5342 * t7044;
  t7048 = t543 * t5354 * t1752;
  t7051 = t543 * t1463 * t7018;
  t7053 = 0.125e3 / 0.486e3 * t7036 - 0.125e3 / 0.486e3 * t7039 + 0.25e3 / 0.81e2 * t7041 + t6670 - 0.125e4 / 0.729e3 * t7045 - 0.125e4 / 0.729e3 * t7048 + 0.125e4 / 0.729e3 * t7051 - t6681;
  t7054 = t7053 * t146;
  t7055 = t473 * t6927;
  t7056 = t6632 * t7055;
  t7057 = t1323 * t7056;
  t7058 = 0.25e2 / 0.1296e4 * t7057;
  t7059 = t5474 * t35;
  t7060 = t1295 * t7059;
  t7061 = t1294 * t7060;
  t7062 = 0.125e4 / 0.729e3 * t7061;
  t7063 = t5105 * t1733;
  t7064 = 0.25e3 / 0.243e3 * t7063;
  t7065 = t5108 * t1732;
  t7066 = t1294 * t7065;
  t7067 = 0.25e3 / 0.243e3 * t7066;
  t7068 = t5300 * t1214;
  t7069 = 0.25e3 / 0.81e2 * t7068;
  t7070 = t7015 - t7017 - t7021 - t7026 + t7030 + t7032 - t7035 + t7054 - t7058 + t7062 - t7064 - t7067 - t7069;
  tv3rhosigmatau7 = t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757 + t9 * (t6946 + t6978 + t7013 + t7070);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  t7074 = 0.25e2 / 0.108e3 * t6818;
  t7075 = 0.25e2 / 0.864e3 * t6821;
  t7076 = 0.125e3 / 0.486e3 * t6825;
  t7077 = 0.5e1 / 0.18e2 * t6827;
  t7078 = 0.25e2 / 0.162e3 * t6831;
  t7079 = 0.5e1 / 0.144e3 * t6834;
  t7080 = 0.25e2 / 0.81e2 * t6838;
  t7081 = 0.5e3 / 0.243e3 * t6842;
  t7082 = 0.5e1 / 0.288e3 * t6846;
  t7083 = 0.5e1 / 0.36e2 * t6849;
  t7085 = 0.5e1 / 0.36e2 * t6852;
  t7086 = 0.125e3 / 0.243e3 * t6856;
  t7087 = 0.25e2 / 0.108e3 * t6860;
  t7088 = 0.5e1 / 0.36e2 * t6862;
  t7089 = 0.25e2 / 0.162e3 * t6882;
  t7090 = 0.25e2 / 0.162e3 * t6887;
  t7091 = t7085 + t7086 - t7087 + t7088 + t6708 - t6711 - t6712 - t6724 - t6725 - t7089 - t7090;
  t7093 = 0.125e3 / 0.486e3 * t6891;
  t7094 = 0.25e4 / 0.729e3 * t6894;
  t7095 = 0.25e2 / 0.81e2 * t6897;
  t7096 = 0.25e2 / 0.81e2 * t6900;
  t7097 = 0.5e1 / 0.36e2 * t6903;
  t7098 = 0.5e3 / 0.81e2 * t6905;
  t7099 = 0.5e3 / 0.243e3 * t6907;
  t7100 = 0.5e3 / 0.243e3 * t6910;
  t7101 = 0.25e2 / 0.648e3 * t6912;
  t7102 = 0.25e2 / 0.1296e4 * t6916;
  t7103 = 0.25e4 / 0.729e3 * t6921;
  t7104 = t7093 - t7094 + t7095 + t7096 - t7097 - t7098 - t7099 - t7100 + t7101 + t7102 + t7103;
  t7109 = -0.125e3 / 0.243e3 * t6865 + 0.5e3 / 0.81e2 * t6867 + t6697 - 0.25e4 / 0.729e3 * t6871 + 0.25e4 / 0.729e3 * t6875 - t6701;
  t7110 = t7109 * t146;
  t7111 = t1768 * t382;
  t7112 = 0.125e3 / 0.3888e4 * t6925;
  t7113 = 0.25e2 / 0.648e3 * t6930;
  t7114 = -t6738 + t6744 + t6745 - t6747 + t7110 + t7111 + t7112 - t7113 - t6748 + t6750 + t6751;
  tv3rhosigmatau8 = t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769 + t9 * (t7074 - t7075 - t7076 - t7077 + t7078 + t7079 + t7080 - t7081 - t7082 + t7083 + t7091 + t7104 + t7114);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  t7118 = 0.25e2 / 0.1296e4 * t6938;
  t7119 = 0.25e2 / 0.162e3 * t6941;
  t7120 = 0.25e4 / 0.729e3 * t6944;
  t7121 = -t6765 - t6766 + t6767 - t6768 + t6769 + t6771 + t7118 - t7119 + t7120 - t6784 - t6785 + t6786;
  t7122 = 0.125e3 / 0.243e3 * t6949;
  t7123 = 0.25e2 / 0.108e3 * t6953;
  t7124 = 0.5e1 / 0.36e2 * t6955;
  t7125 = 0.5e3 / 0.243e3 * t6958;
  t7126 = 0.125e3 / 0.3888e4 * t6962;
  t7127 = 0.25e2 / 0.864e3 * t6965;
  t7128 = 0.125e3 / 0.486e3 * t6969;
  t7129 = 0.5e1 / 0.18e2 * t6971;
  t7130 = 0.25e2 / 0.81e2 * t6973;
  t7131 = 0.25e2 / 0.162e3 * t6976;
  t7132 = t7122 - t7123 + t7124 - t7125 + t7126 + t6787 - t6802 - t6803 - t7127 - t7128 - t7129 + t7130 + t7131;
  t7134 = t1780 * t382;
  t7141 = 0.125e3 / 0.243e3 * t7036 - 0.125e3 / 0.243e3 * t7039 + 0.5e3 / 0.81e2 * t7041 + t6806 - 0.25e4 / 0.729e3 * t7045 - 0.25e4 / 0.729e3 * t7048 + 0.25e4 / 0.729e3 * t7051 - t6809;
  t7142 = t7141 * t146;
  t7143 = 0.25e2 / 0.108e3 * t6983;
  t7144 = 0.25e2 / 0.864e3 * t6986;
  t7145 = 0.125e3 / 0.486e3 * t6990;
  t7146 = 0.25e2 / 0.108e3 * t6992;
  t7147 = 0.5e1 / 0.144e3 * t6995;
  t7148 = 0.5e1 / 0.288e3 * t6999;
  t7149 = 0.5e1 / 0.36e2 * t7001;
  t7150 = 0.5e1 / 0.36e2 * t7004;
  t7151 = 0.125e3 / 0.243e3 * t7006;
  t7152 = 0.25e2 / 0.108e3 * t7009;
  t7153 = t7134 + t7142 - t7143 + t7144 - t7145 + t7146 + t7147 - t7148 + t7149 + t7150 - t7151 + t7152;
  t7154 = 0.25e2 / 0.81e2 * t7011;
  t7155 = 0.25e2 / 0.81e2 * t7014;
  t7156 = 0.5e1 / 0.36e2 * t7016;
  t7157 = 0.25e4 / 0.729e3 * t7020;
  t7158 = 0.25e2 / 0.162e3 * t7025;
  t7159 = 0.125e3 / 0.486e3 * t7029;
  t7160 = 0.25e2 / 0.648e3 * t7031;
  t7161 = 0.125e3 / 0.3888e4 * t7034;
  t7162 = 0.25e2 / 0.648e3 * t7057;
  t7163 = 0.25e4 / 0.729e3 * t7061;
  t7164 = 0.5e3 / 0.243e3 * t7063;
  t7165 = 0.5e3 / 0.243e3 * t7066;
  t7166 = 0.5e3 / 0.81e2 * t7068;
  t7167 = t7154 + t7155 - t7156 - t7157 - t7158 + t7159 + t7160 - t7161 - t7162 + t7163 - t7164 - t7165 - t7166;
  tv3rhosigmatau9 = t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781 + t9 * (t7121 + t7132 + t7153 + t7167);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = tv3rhosigmatau6;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = tv3rhosigmatau7;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t7171 = t1823 * t316;
  t7173 = 0.1e1 / t3 / t2283;
  t7174 = t2 * t7173;
  t7175 = t7174 * t1790;
  t7176 = t7175 * t531;
  t7177 = 0.1e4 / 0.243e3 * t7176;
  t7178 = t1791 * t1906;
  t7179 = 0.1e3 / 0.81e2 * t7178;
  t7180 = t14 * t1786;
  t7181 = t1784 * t7180;
  t7182 = t7181 * t167;
  t7183 = t1295 * t7182;
  t7184 = t1294 * t7183;
  t7185 = 0.2e5 / 0.729e3 * t7184;
  t7186 = t1791 * t1902;
  t7187 = 0.1e3 / 0.81e2 * t7186;
  t7191 = t7180 * t185;
  t7192 = t1785 * t7191;
  t7194 = t800 * t801 * t167;
  t7197 = t542 * t1896;
  t7201 = t1806 * t180 * t50;
  t7204 = t7173 * t1788;
  t7205 = t806 * t7204;
  t7208 = t7180 * t167;
  t7212 = -0.1e4 / 0.243e3 * t7174 * t1789 * t802 + 0.1e4 / 0.243e3 * t7192 * t7194 - 0.2e4 / 0.81e2 * t1794 * t7197 + 0.1e5 / 0.729e3 * t2785 * t7201 + 0.2e5 / 0.729e3 * t805 * t7205 - 0.2e5 / 0.729e3 * t543 * t1801 * t7208;
  t7213 = t7212 * t146;
  t7214 = t8 * t1784;
  t7215 = t7214 * t1812;
  t7216 = t878 * t7215;
  t7217 = t154 * t7216;
  t7218 = 0.5e1 / 0.18e2 * t7217;
  t7219 = t62 * t7173;
  t7220 = t7219 * t1812;
  t7221 = t878 * t7220;
  t7222 = t154 * t7221;
  t7223 = 0.25e2 / 0.54e2 * t7222;
  t7224 = t2616 * t1813;
  t7225 = t154 * t7224;
  t7226 = 0.35e2 / 0.54e2 * t7225;
  t7227 = t1788 * t316;
  t7228 = t1811 * t7227;
  t7229 = t878 * t7228;
  t7230 = t154 * t7229;
  t7231 = 0.5e1 / 0.36e2 * t7230;
  t7232 = t1785 * t7180;
  t7233 = t7232 * t50;
  t7234 = t207 * t1355;
  t7235 = t1796 * t7234;
  t7236 = t7233 * t7235;
  t7237 = 0.25e2 / 0.54e2 * t7236;
  t7238 = t574 * t1339;
  t7239 = t1796 * t7238;
  t7240 = t1795 * t7239;
  t7241 = 0.5e1 / 0.18e2 * t7240;
  t7243 = t2356 * t1784 * t1788;
  t7244 = t7243 * t3863;
  t7245 = t2814 * t7244;
  t7246 = 0.1e5 / 0.729e3 * t7245;
  t7247 = t207 * t1784;
  t7248 = t1812 * t1896;
  t7249 = t7247 * t7248;
  t7250 = t4409 * t7249;
  t7251 = 0.5e3 / 0.243e3 * t7250;
  t7252 = t4364 * t1807;
  t7253 = t1323 * t7252;
  t7254 = 0.175e3 / 0.243e3 * t7253;
  t7255 = t4345 * t1807;
  t7256 = t1323 * t7255;
  t7257 = 0.25e2 / 0.81e2 * t7256;
  t7258 = t7204 * t194;
  t7259 = t1354 * t7258;
  t7260 = t1323 * t7259;
  t7261 = 0.125e3 / 0.243e3 * t7260;
  t7262 = t7171 + t7177 - t7179 + t7185 - t7187 + t7213 - t7218 + t7223 + t7226 - t7231 + t7237 - t7241 - t7246 + t7251 + t7254 - t7257 + t7261;
  t7263 = t1324 * t1811;
  t7264 = t7180 * t146;
  t7265 = t7264 * t4313;
  t7266 = t7263 * t7265;
  t7267 = t1323 * t7266;
  t7268 = 0.125e3 / 0.243e3 * t7267;
  t7269 = t1337 * t1811;
  t7270 = t1812 * t326;
  t7271 = t7269 * t7270;
  t7272 = t1323 * t7271;
  t7273 = 0.25e2 / 0.162e3 * t7272;
  t7274 = t1812 * t6462;
  t7275 = t7269 * t7274;
  t7276 = t1323 * t7275;
  t7277 = 0.25e2 / 0.81e2 * t7276;
  t7278 = t544 * t7173;
  t7279 = t7278 * t1788;
  t7280 = t147 * t7279;
  t7281 = t543 * t7280;
  t7282 = 0.2e5 / 0.729e3 * t7281;
  t7283 = t1788 * t539;
  t7284 = t1785 * t7283;
  t7285 = t2372 * t6143;
  t7286 = t7284 * t7285;
  t7287 = 0.2e4 / 0.81e2 * t7286;
  t7288 = t217 * t1802;
  t7289 = t543 * t7288;
  t7290 = 0.2e4 / 0.243e3 * t7289;
  t7291 = t317 * t1802;
  t7292 = t543 * t7291;
  t7293 = 0.2e4 / 0.243e3 * t7292;
  t7294 = t7174 * t1788;
  t7295 = t7294 * t50;
  t7296 = t7295 * t1798;
  t7297 = 0.25e2 / 0.54e2 * t7296;
  t7298 = t1334 * t201;
  t7299 = t7298 * t1797;
  t7300 = t1795 * t7299;
  t7301 = 0.35e2 / 0.54e2 * t7300;
  t7302 = t579 * t146;
  t7303 = t1796 * t7302;
  t7304 = t1795 * t7303;
  t7305 = 0.5e1 / 0.18e2 * t7304;
  t7306 = t207 * t316;
  t7307 = t1796 * t7306;
  t7308 = t1795 * t7307;
  t7309 = 0.5e1 / 0.36e2 * t7308;
  t7310 = t1806 * t1339;
  t7311 = t4252 * t7310;
  t7312 = t1336 * t7311;
  t7313 = 0.5e1 / 0.12e2 * t7312;
  t7314 = t7181 * t1355;
  t7315 = t1338 * t7314;
  t7316 = t1336 * t7315;
  t7317 = 0.25e2 / 0.54e2 * t7316;
  t7318 = t188 * t325;
  t7319 = t1794 * t7318;
  t7320 = t445 * t6411;
  t7321 = t7319 * t7320;
  t7322 = 0.25e2 / 0.81e2 * t7321;
  t7323 = t1806 * t553;
  t7324 = t1354 * t7323;
  t7325 = t1323 * t7324;
  t7326 = 0.25e2 / 0.162e3 * t7325;
  t7327 = t7191 * t187;
  t7328 = t1785 * t7327;
  t7329 = t194 * t167;
  t7330 = t1280 * t7329;
  t7331 = t7328 * t7330;
  t7332 = 0.1e4 / 0.243e3 * t7331;
  t7333 = t322 * t1814;
  t7334 = 0.5e1 / 0.36e2 * t7333;
  t7335 = -t7268 + t7273 + t7277 - t7282 + t7287 + t7290 + t7293 - t7297 - t7301 + t7305 + t7309 + t7313 - t7317 - t7322 - t7326 - t7332 - t7334;
  tv3rhotau20 = -t1793 + t1800 + t1805 - t1810 - t1816 + t1824 + t9 * (t7262 + t7335);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t7338 = t1337 * t1440;
  t7339 = t7338 * t1844;
  t7340 = t1336 * t7339;
  t7341 = 0.5e1 / 0.18e2 * t7340;
  t7342 = t473 * t4129;
  t7343 = t1843 * t7342;
  t7344 = t1336 * t7343;
  t7345 = 0.25e2 / 0.108e3 * t7344;
  t7346 = t4357 * t472;
  t7347 = t7346 * t1844;
  t7348 = t1336 * t7347;
  t7349 = 0.35e2 / 0.54e2 * t7348;
  t7350 = t1450 * t1296;
  t7351 = t1843 * t7350;
  t7352 = t1336 * t7351;
  t7353 = 0.5e1 / 0.36e2 * t7352;
  t7354 = t59 * t574;
  t7355 = t7354 * t1340;
  t7356 = t479 * t7355;
  t7357 = 0.5e1 / 0.18e2 * t7356;
  t7358 = t59 * t207;
  t7359 = t7358 * t1356;
  t7360 = t479 * t7359;
  t7361 = 0.25e2 / 0.108e3 * t7360;
  t7362 = t1410 * t1296;
  t7363 = t7362 * t3863;
  t7364 = t5013 * t7363;
  t7365 = 0.1e5 / 0.729e3 * t7364;
  t7366 = t448 * t1465;
  t7367 = t5174 * t7366;
  t7368 = 0.5e3 / 0.243e3 * t7367;
  t7369 = t4240 * t1845;
  t7370 = 0.5e1 / 0.36e2 * t7369;
  t7371 = t4657 * t453;
  t7372 = t1296 * t1445;
  t7373 = t7358 * t7372;
  t7374 = t7371 * t7373;
  t7375 = 0.25e2 / 0.108e3 * t7374;
  t7376 = t146 * t6;
  t7377 = t16 * params->c;
  t7378 = t7377 * t180;
  t7379 = t7376 * t7378;
  t7380 = t4756 * t7379;
  t7381 = t1838 * t7380;
  t7382 = 0.25e2 / 0.162e3 * t7381;
  t7383 = t325 * params->c;
  t7384 = t1296 * t171;
  t7385 = t7383 * t7384;
  t7388 = t806 * t1297;
  t7393 = t7383 * t1315;
  t7396 = t1833 * t3863;
  t7399 = t39 * t2349;
  t7404 = t27 * t160 * t16;
  t7411 = 0.5e3 / 0.243e3 * t4535 * t7385 - 0.2e4 / 0.81e2 * t4604 * t7388 - 0.5e3 / 0.243e3 * t1403 * t1383 + 0.5e3 / 0.243e3 * t1403 * t7393 + 0.1e5 / 0.729e3 * t5342 * t7396 - 0.1e5 / 0.729e3 * t7399 * t1421 * t7384 + 0.1e5 / 0.729e3 * t543 * t1463 * t7404 - 0.1e5 / 0.729e3 * t7399 * t1410 * t1315;
  t7412 = t7411 * t146;
  t7413 = t1853 * t316;
  t7414 = t1826 * t1311;
  t7415 = 0.5e3 / 0.243e3 * t7414;
  t7416 = t1826 * t1302;
  t7417 = 0.1e3 / 0.81e2 * t7416;
  t7418 = t1826 * t1306;
  t7419 = 0.1e3 / 0.81e2 * t7418;
  t7421 = t805 * t2372 * t146;
  t7422 = t1463 * t26;
  t7423 = t7422 * t7384;
  t7424 = t7421 * t7423;
  t7425 = 0.1e5 / 0.729e3 * t7424;
  t7426 = t1463 * t27;
  t7427 = t7426 * t1315;
  t7428 = t7421 * t7427;
  t7429 = 0.1e5 / 0.729e3 * t7428;
  t7430 = t1410 * t167;
  t7431 = t194 * t7430;
  t7432 = t4492 * t7431;
  t7433 = t1838 * t7432;
  t7434 = 0.125e3 / 0.486e3 * t7433;
  t7435 = -t7341 + t7345 + t7349 - t7353 - t7357 + t7361 - t7365 + t7368 - t7370 + t7375 + t7382 + t7412 + t7413 + t7415 - t7417 - t7419 + t7425 + t7429 - t7434;
  t7436 = t194 * t1422;
  t7437 = t1839 * t7436;
  t7438 = t1838 * t7437;
  t7439 = 0.125e3 / 0.486e3 * t7438;
  t7440 = t4302 * t21;
  t7441 = t7440 * t1833;
  t7442 = t1294 * t7441;
  t7443 = 0.2e4 / 0.243e3 * t7442;
  t7444 = t1831 * t7404;
  t7445 = t1294 * t7444;
  t7446 = 0.1e5 / 0.729e3 * t7445;
  t7447 = t4299 * t1834;
  t7448 = 0.2e4 / 0.243e3 * t7447;
  t7449 = t207 * t4129;
  t7450 = t7449 * t1736;
  t7451 = t1838 * t7450;
  t7452 = 0.125e3 / 0.486e3 * t7451;
  t7453 = t55 * t59;
  t7454 = t46 * t7453;
  t7455 = t2264 * t1410;
  t7456 = t7455 * t1340;
  t7457 = t7454 * t7456;
  t7458 = 0.5e1 / 0.12e2 * t7457;
  t7459 = t147 * t544;
  t7460 = t7459 * t1297;
  t7461 = t5300 * t7460;
  t7462 = 0.2e4 / 0.81e2 * t7461;
  t7463 = t574 * t1421;
  t7464 = t7463 * t7372;
  t7465 = t7454 * t7464;
  t7466 = 0.25e2 / 0.108e3 * t7465;
  t7467 = t4756 * t1356;
  t7468 = t7454 * t7467;
  t7469 = 0.25e2 / 0.108e3 * t7468;
  t7470 = t1460 * t1322;
  t7471 = t7470 * t1327;
  t7472 = 0.25e2 / 0.81e2 * t7471;
  t7473 = t1839 * t6591;
  t7474 = t1838 * t7473;
  t7475 = 0.25e2 / 0.162e3 * t7474;
  t7477 = t324 * t325 * t202;
  t7478 = t7477 * t1840;
  t7479 = 0.175e3 / 0.243e3 * t7478;
  t7480 = t579 * t1296;
  t7481 = t7480 * t1736;
  t7482 = t1838 * t7481;
  t7483 = 0.25e2 / 0.81e2 * t7482;
  t7484 = t479 * t1362;
  t7485 = 0.5e1 / 0.36e2 * t7484;
  t7486 = t479 * t1331;
  t7487 = 0.35e2 / 0.54e2 * t7486;
  t7488 = t479 * t1346;
  t7489 = 0.5e1 / 0.18e2 * t7488;
  t7490 = t479 * t1351;
  t7491 = 0.25e2 / 0.108e3 * t7490;
  t7492 = t439 * t6366;
  t7493 = t1826 * t7492;
  t7494 = 0.5e3 / 0.243e3 * t7493;
  t7495 = t16 * t171;
  t7496 = t440 * t7495;
  t7497 = t439 * t7496;
  t7498 = t4658 * t7497;
  t7499 = 0.5e3 / 0.243e3 * t7498;
  t7500 = t1410 * t209;
  t7501 = t194 * t7500;
  t7502 = t4488 * t7501;
  t7503 = t1838 * t7502;
  t7504 = 0.25e2 / 0.81e2 * t7503;
  t7505 = -t7439 + t7443 - t7446 + t7448 + t7452 + t7458 + t7462 - t7466 - t7469 - t7472 - t7475 + t7479 - t7483 + t7485 - t7487 + t7489 - t7491 - t7494 - t7499 + t7504;
  tv3rhotau21 = -t1828 + t1830 + t1836 - t1842 - t1847 + t1854 + t9 * (t7435 + t7505);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t7508 = t1324 * t1881;
  t7509 = t25 * t1859;
  t7510 = t7509 * t146;
  t7511 = t7510 * t4536;
  t7513 = t1323 * t7508 * t7511;
  t7514 = 0.125e3 / 0.243e3 * t7513;
  t7515 = t1337 * t1881;
  t7516 = t1882 * t326;
  t7517 = t7515 * t7516;
  t7518 = t1323 * t7517;
  t7519 = 0.25e2 / 0.162e3 * t7518;
  t7520 = t1882 * t6462;
  t7522 = t1323 * t7515 * t7520;
  t7523 = 0.25e2 / 0.81e2 * t7522;
  t7524 = t1861 * t539;
  t7525 = t1858 * t7524;
  t7526 = t7525 * t7285;
  t7527 = 0.2e4 / 0.81e2 * t7526;
  t7529 = t543 * t217 * t1872;
  t7530 = 0.2e4 / 0.243e3 * t7529;
  t7532 = t543 * t317 * t1872;
  t7533 = 0.2e4 / 0.243e3 * t7532;
  t7534 = t1868 * t7307;
  t7535 = 0.5e1 / 0.36e2 * t7534;
  t7536 = t1868 * t7299;
  t7537 = 0.35e2 / 0.54e2 * t7536;
  t7538 = t1868 * t7303;
  t7539 = 0.5e1 / 0.18e2 * t7538;
  t7540 = t7509 * t185;
  t7541 = t1858 * t7540;
  t7543 = t800 * t801 * t171;
  t7552 = t7509 * t171;
  t7553 = t1871 * t7552;
  t7556 = 0.1e4 / 0.243e3 * t7541 * t7543 - 0.2e4 / 0.81e2 * t1867 * t7197 + 0.1e5 / 0.729e3 * t2785 * t1876 * t180 * t50 - 0.2e5 / 0.729e3 * t543 * t7553;
  t7557 = t7556 * t146;
  t7558 = t1857 * t7509;
  t7559 = t7558 * t171;
  t7560 = t1295 * t7559;
  t7561 = t1294 * t7560;
  t7562 = 0.2e5 / 0.729e3 * t7561;
  t7563 = t1864 * t1902;
  t7564 = 0.1e3 / 0.81e2 * t7563;
  t7565 = t1864 * t1906;
  t7566 = 0.1e3 / 0.81e2 * t7565;
  t7567 = t1876 * t1339;
  t7568 = t4252 * t7567;
  t7569 = t1336 * t7568;
  t7570 = 0.5e1 / 0.12e2 * t7569;
  t7571 = -t7514 + t7519 + t7523 + t7527 + t7530 + t7533 + t7535 - t7537 + t7539 + t7557 + t7562 - t7564 - t7566 + t7570;
  t7572 = t7558 * t1445;
  t7573 = t1338 * t7572;
  t7574 = t1336 * t7573;
  t7575 = 0.25e2 / 0.54e2 * t7574;
  t7576 = t1867 * t7318;
  t7577 = t7576 * t7320;
  t7578 = 0.25e2 / 0.81e2 * t7577;
  t7579 = t1876 * t553;
  t7580 = t1354 * t7579;
  t7581 = t1323 * t7580;
  t7582 = 0.25e2 / 0.162e3 * t7581;
  t7583 = t4345 * t1877;
  t7584 = t1323 * t7583;
  t7585 = 0.25e2 / 0.81e2 * t7584;
  t7586 = t4364 * t1877;
  t7587 = t1323 * t7586;
  t7588 = 0.175e3 / 0.243e3 * t7587;
  t7589 = t7540 * t187;
  t7590 = t1858 * t7589;
  t7591 = t194 * t171;
  t7592 = t1280 * t7591;
  t7593 = t7590 * t7592;
  t7594 = 0.1e4 / 0.243e3 * t7593;
  t7595 = t1893 * t316;
  t7596 = t207 * t1857;
  t7597 = t1882 * t1896;
  t7598 = t7596 * t7597;
  t7599 = t4409 * t7598;
  t7600 = 0.5e3 / 0.243e3 * t7599;
  t7601 = t322 * t1884;
  t7602 = 0.5e1 / 0.36e2 * t7601;
  t7603 = t1861 * t316;
  t7604 = t1881 * t7603;
  t7605 = t878 * t7604;
  t7606 = t154 * t7605;
  t7607 = 0.5e1 / 0.36e2 * t7606;
  t7608 = t1858 * t7509;
  t7609 = t7608 * t50;
  t7610 = t207 * t1445;
  t7611 = t1796 * t7610;
  t7612 = t7609 * t7611;
  t7613 = 0.25e2 / 0.54e2 * t7612;
  t7614 = t2616 * t1883;
  t7615 = t154 * t7614;
  t7616 = 0.35e2 / 0.54e2 * t7615;
  t7617 = t8 * t1857;
  t7618 = t7617 * t1882;
  t7619 = t878 * t7618;
  t7620 = t154 * t7619;
  t7621 = 0.5e1 / 0.18e2 * t7620;
  t7622 = t1868 * t7239;
  t7623 = 0.5e1 / 0.18e2 * t7622;
  t7624 = t2356 * t1857;
  t7625 = t7624 * t1861;
  t7626 = t7625 * t3863;
  t7627 = t2814 * t7626;
  t7628 = 0.1e5 / 0.729e3 * t7627;
  t7629 = -t7575 - t7578 - t7582 - t7585 + t7588 - t7594 + t7595 + t7600 - t7602 - t7607 + t7613 + t7616 - t7621 - t7623 - t7628;
  tv3rhotau22 = -t1866 + t1870 + t1875 - t1880 - t1886 + t1894 + t9 * (t7571 + t7629);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t7632 = t1806 * t902;
  t7633 = t1354 * t7632;
  t7634 = t1323 * t7633;
  t7635 = 0.25e2 / 0.162e3 * t7634;
  t7636 = t1806 * t1514;
  t7637 = t4252 * t7636;
  t7638 = t1336 * t7637;
  t7639 = 0.5e1 / 0.12e2 * t7638;
  t7640 = t1812 * t6927;
  t7641 = t7269 * t7640;
  t7642 = t1323 * t7641;
  t7643 = 0.25e2 / 0.81e2 * t7642;
  t7644 = t7264 * t5037;
  t7645 = t7263 * t7644;
  t7646 = t1323 * t7645;
  t7647 = 0.125e3 / 0.243e3 * t7646;
  t7648 = t1812 * t390;
  t7649 = t7269 * t7648;
  t7650 = t1323 * t7649;
  t7651 = 0.25e2 / 0.162e3 * t7650;
  t7652 = t445 * t6836;
  t7653 = t7319 * t7652;
  t7654 = 0.25e2 / 0.81e2 * t7653;
  t7655 = t7181 * t1519;
  t7656 = t1338 * t7655;
  t7657 = t1336 * t7656;
  t7658 = 0.25e2 / 0.54e2 * t7657;
  t7659 = t207 * t382;
  t7660 = t1796 * t7659;
  t7661 = t1795 * t7660;
  t7662 = 0.5e1 / 0.36e2 * t7661;
  t7663 = t1791 * t2479;
  t7664 = 0.1e3 / 0.81e2 * t7663;
  t7665 = t1791 * t2463;
  t7666 = 0.1e3 / 0.81e2 * t7665;
  t7667 = -t7635 + t7639 + t7643 - t7647 + t7651 + t7218 + t7226 + t7254 + t7257 - t7654 - t7658 + t7662 - t7664 - t7666;
  t7668 = t194 * t336;
  t7669 = t1280 * t7668;
  t7670 = t7328 * t7669;
  t7671 = 0.1e4 / 0.243e3 * t7670;
  t7672 = t2372 * t6262;
  t7673 = t7284 * t7672;
  t7674 = 0.2e4 / 0.81e2 * t7673;
  t7675 = t365 * t1802;
  t7676 = t543 * t7675;
  t7677 = 0.2e4 / 0.243e3 * t7676;
  t7678 = t383 * t1802;
  t7679 = t543 * t7678;
  t7680 = 0.2e4 / 0.243e3 * t7679;
  t7681 = t207 * t1519;
  t7682 = t1796 * t7681;
  t7683 = t7233 * t7682;
  t7684 = 0.25e2 / 0.54e2 * t7683;
  t7685 = t574 * t1514;
  t7686 = t1796 * t7685;
  t7687 = t1795 * t7686;
  t7688 = 0.5e1 / 0.18e2 * t7687;
  t7689 = t7243 * t6919;
  t7690 = t2814 * t7689;
  t7691 = 0.1e5 / 0.729e3 * t7690;
  t7692 = t1812 * t853;
  t7693 = t7247 * t7692;
  t7694 = t4409 * t7693;
  t7695 = 0.5e3 / 0.243e3 * t7694;
  t7696 = t388 * t1814;
  t7697 = 0.5e1 / 0.36e2 * t7696;
  t7698 = t1788 * t382;
  t7699 = t1811 * t7698;
  t7700 = t878 * t7699;
  t7701 = t154 * t7700;
  t7702 = 0.5e1 / 0.36e2 * t7701;
  t7703 = t7181 * t336;
  t7704 = t1295 * t7703;
  t7705 = t1294 * t7704;
  t7706 = 0.2e5 / 0.729e3 * t7705;
  t7708 = t800 * t801 * t336;
  t7711 = t542 * t853;
  t7714 = t1806 * t350;
  t7715 = t7714 * t50;
  t7718 = t7180 * t336;
  t7722 = 0.1e4 / 0.243e3 * t7192 * t7708 - 0.2e4 / 0.81e2 * t1794 * t7711 + 0.1e5 / 0.729e3 * t2785 * t7715 - 0.2e5 / 0.729e3 * t543 * t1801 * t7718;
  t7723 = t7722 * t146;
  t7724 = t1823 * t382;
  t7725 = -t7301 - t7305 - t7671 + t7674 + t7677 + t7680 + t7684 - t7688 - t7691 + t7695 - t7697 - t7702 + t7706 + t7723 + t7724;
  tv3rhotau23 = -t1793 + t1800 + t1805 - t1810 - t1816 + t1824 + t9 * (t7667 + t7725);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  t7728 = t1608 * t449;
  t7729 = 0.25e2 / 0.108e3 * t7728;
  t7730 = t479 * t1526;
  t7731 = 0.5e1 / 0.36e2 * t7730;
  t7732 = t439 * t6889;
  t7733 = t1826 * t7732;
  t7734 = 0.5e3 / 0.243e3 * t7733;
  t7735 = t16 * t346;
  t7736 = t440 * t7735;
  t7737 = t439 * t7736;
  t7738 = t4658 * t7737;
  t7739 = 0.5e3 / 0.243e3 * t7738;
  t7740 = t1839 * t6936;
  t7741 = t1838 * t7740;
  t7742 = 0.25e2 / 0.162e3 * t7741;
  t7743 = t7455 * t1515;
  t7744 = t7454 * t7743;
  t7745 = 0.5e1 / 0.12e2 * t7744;
  t7746 = t1839 * t6988;
  t7747 = t1838 * t7746;
  t7748 = 0.125e3 / 0.486e3 * t7747;
  t7749 = t1337 * t1592;
  t7750 = t7749 * t1844;
  t7751 = t1336 * t7750;
  t7752 = 0.25e2 / 0.108e3 * t7751;
  t7753 = t7358 * t1520;
  t7754 = t479 * t7753;
  t7755 = 0.25e2 / 0.108e3 * t7754;
  t7756 = t7362 * t6919;
  t7757 = t5013 * t7756;
  t7758 = 0.1e5 / 0.729e3 * t7757;
  t7759 = t448 * t1617;
  t7760 = t5174 * t7759;
  t7761 = 0.5e3 / 0.243e3 * t7760;
  t7762 = t5168 * t1845;
  t7763 = 0.5e1 / 0.36e2 * t7762;
  t7764 = t1602 * t1296;
  t7765 = t1843 * t7764;
  t7766 = t1336 * t7765;
  t7767 = 0.5e1 / 0.36e2 * t7766;
  t7768 = t1296 * t1597;
  t7769 = t7358 * t7768;
  t7770 = t7371 * t7769;
  t7771 = 0.25e2 / 0.108e3 * t7770;
  t7772 = t7354 * t1515;
  t7773 = t479 * t7772;
  t7774 = 0.5e1 / 0.18e2 * t7773;
  t7775 = t1607 * t189;
  t7776 = t7775 * t442;
  t7777 = 0.5e3 / 0.243e3 * t7776;
  t7778 = t1410 * t336;
  t7779 = t194 * t7778;
  t7780 = t4492 * t7779;
  t7781 = t1838 * t7780;
  t7782 = 0.125e3 / 0.486e3 * t7781;
  t7783 = -t7729 + t7731 + t7341 + t7349 - t7734 - t7739 - t7742 + t7745 + t7748 + t7752 + t7755 - t7758 + t7761 - t7763 - t7767 + t7771 - t7774 + t7777 - t7782;
  t7784 = t194 * t1578;
  t7785 = t1839 * t7784;
  t7786 = t1838 * t7785;
  t7787 = 0.125e3 / 0.486e3 * t7786;
  t7788 = t7377 * t350;
  t7789 = t7376 * t7788;
  t7790 = t4756 * t7789;
  t7791 = t1838 * t7790;
  t7792 = 0.25e2 / 0.162e3 * t7791;
  t7793 = t1410 * t360;
  t7794 = t194 * t7793;
  t7795 = t4488 * t7794;
  t7796 = t1838 * t7795;
  t7797 = 0.25e2 / 0.81e2 * t7796;
  t7798 = t7463 * t7768;
  t7799 = t7454 * t7798;
  t7800 = 0.25e2 / 0.108e3 * t7799;
  t7801 = t4756 * t1520;
  t7802 = t7454 * t7801;
  t7803 = 0.25e2 / 0.108e3 * t7802;
  t7804 = t7470 * t1511;
  t7805 = 0.25e2 / 0.81e2 * t7804;
  t7806 = t5105 * t1834;
  t7807 = 0.2e4 / 0.243e3 * t7806;
  t7808 = t5108 * t21;
  t7809 = t7808 * t1833;
  t7810 = t1294 * t7809;
  t7811 = 0.2e4 / 0.243e3 * t7810;
  t7812 = t7459 * t1492;
  t7813 = t5300 * t7812;
  t7814 = 0.2e4 / 0.81e2 * t7813;
  t7815 = t1295 * t342;
  t7816 = t7815 * t1833;
  t7817 = t1294 * t7816;
  t7818 = 0.1e5 / 0.729e3 * t7817;
  t7821 = t1296 * t346;
  t7822 = t7383 * t7821;
  t7825 = t806 * t1492;
  t7828 = t7383 * t1504;
  t7831 = t1833 * t6919;
  t7843 = -0.5e3 / 0.243e3 * t5223 * t456 + 0.5e3 / 0.243e3 * t4535 * t7822 - 0.2e4 / 0.81e2 * t4604 * t7825 + 0.5e3 / 0.243e3 * t1403 * t7828 + 0.1e5 / 0.729e3 * t5342 * t7831 + 0.1e5 / 0.729e3 * t543 * t5354 * t1833 - 0.1e5 / 0.729e3 * t7399 * t1421 * t7821 - 0.1e5 / 0.729e3 * t7399 * t1410 * t1504;
  t7844 = t7843 * t146;
  t7845 = t1853 * t382;
  t7846 = t1826 * t1501;
  t7847 = 0.1e3 / 0.81e2 * t7846;
  t7848 = t7422 * t7821;
  t7849 = t7421 * t7848;
  t7850 = 0.1e5 / 0.729e3 * t7849;
  t7851 = t7426 * t1504;
  t7852 = t7421 * t7851;
  t7853 = 0.1e5 / 0.729e3 * t7852;
  t7854 = t1826 * t1497;
  t7855 = 0.1e3 / 0.81e2 * t7854;
  t7856 = -t7787 + t7792 + t7797 - t7800 - t7803 - t7805 + t7807 + t7811 + t7814 - t7818 + t7844 + t7479 + t7483 + t7845 - t7487 - t7489 - t7847 + t7850 + t7853 - t7855;
  tv3rhotau24 = -t1828 + t1830 + t1836 - t1842 - t1847 + t1854 + t9 * (t7783 + t7856);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t7859 = t388 * t1884;
  t7860 = 0.5e1 / 0.36e2 * t7859;
  t7861 = t1861 * t382;
  t7862 = t1881 * t7861;
  t7863 = t878 * t7862;
  t7864 = t154 * t7863;
  t7865 = 0.5e1 / 0.36e2 * t7864;
  t7866 = t207 * t1597;
  t7867 = t1796 * t7866;
  t7868 = t7609 * t7867;
  t7869 = 0.25e2 / 0.54e2 * t7868;
  t7871 = 0.1e1 / t18 / t3250;
  t7872 = t62 * t7871;
  t7873 = t7872 * t1882;
  t7874 = t878 * t7873;
  t7875 = t154 * t7874;
  t7876 = 0.25e2 / 0.54e2 * t7875;
  t7877 = t1868 * t7686;
  t7878 = 0.5e1 / 0.18e2 * t7877;
  t7879 = t7625 * t6919;
  t7880 = t2814 * t7879;
  t7881 = 0.1e5 / 0.729e3 * t7880;
  t7882 = t1882 * t853;
  t7883 = t7596 * t7882;
  t7884 = t4409 * t7883;
  t7885 = 0.5e3 / 0.243e3 * t7884;
  t7886 = t1882 * t6927;
  t7888 = t1323 * t7515 * t7886;
  t7889 = 0.25e2 / 0.81e2 * t7888;
  t7890 = t7510 * t5326;
  t7892 = t1323 * t7508 * t7890;
  t7893 = 0.125e3 / 0.243e3 * t7892;
  t7894 = t1882 * t390;
  t7896 = t1323 * t7515 * t7894;
  t7897 = 0.25e2 / 0.162e3 * t7896;
  t7898 = t1893 * t382;
  t7899 = t2 * t7871;
  t7904 = t800 * t801 * t346;
  t7909 = t1876 * t350;
  t7913 = t7871 * t1861;
  t7917 = t7509 * t346;
  t7918 = t1871 * t7917;
  t7921 = -0.1e4 / 0.243e3 * t7899 * t1862 * t802 + 0.1e4 / 0.243e3 * t7541 * t7904 - 0.2e4 / 0.81e2 * t1867 * t7711 + 0.1e5 / 0.729e3 * t2785 * t7909 * t50 + 0.2e5 / 0.729e3 * t805 * t806 * t7913 - 0.2e5 / 0.729e3 * t543 * t7918;
  t7922 = t7921 * t146;
  t7923 = t7913 * t194;
  t7924 = t1354 * t7923;
  t7925 = t1323 * t7924;
  t7926 = 0.125e3 / 0.243e3 * t7925;
  t7927 = -t7860 - t7865 + t7869 + t7876 - t7878 - t7881 + t7885 + t7889 - t7893 + t7897 - t7537 - t7539 + t7898 + t7922 + t7926 + t7585 + t7588;
  t7928 = t194 * t346;
  t7929 = t1280 * t7928;
  t7930 = t7590 * t7929;
  t7931 = 0.1e4 / 0.243e3 * t7930;
  t7932 = t7576 * t7652;
  t7933 = 0.25e2 / 0.81e2 * t7932;
  t7934 = t7558 * t1597;
  t7935 = t1338 * t7934;
  t7936 = t1336 * t7935;
  t7937 = 0.25e2 / 0.54e2 * t7936;
  t7938 = t1876 * t902;
  t7939 = t1354 * t7938;
  t7940 = t1323 * t7939;
  t7941 = 0.25e2 / 0.162e3 * t7940;
  t7942 = t1876 * t1514;
  t7943 = t4252 * t7942;
  t7944 = t1336 * t7943;
  t7945 = 0.5e1 / 0.12e2 * t7944;
  t7946 = t544 * t7871;
  t7947 = t7946 * t1861;
  t7948 = t147 * t7947;
  t7949 = t543 * t7948;
  t7950 = 0.2e5 / 0.729e3 * t7949;
  t7952 = t543 * t365 * t1872;
  t7953 = 0.2e4 / 0.243e3 * t7952;
  t7955 = t543 * t383 * t1872;
  t7956 = 0.2e4 / 0.243e3 * t7955;
  t7957 = t7525 * t7672;
  t7958 = 0.2e4 / 0.81e2 * t7957;
  t7959 = t1864 * t2463;
  t7960 = 0.1e3 / 0.81e2 * t7959;
  t7961 = t7558 * t346;
  t7962 = t1295 * t7961;
  t7963 = t1294 * t7962;
  t7964 = 0.2e5 / 0.729e3 * t7963;
  t7965 = t7899 * t1863;
  t7966 = t7965 * t531;
  t7967 = 0.1e4 / 0.243e3 * t7966;
  t7968 = t1864 * t2479;
  t7969 = 0.1e3 / 0.81e2 * t7968;
  t7970 = t7899 * t1861;
  t7971 = t7970 * t50;
  t7972 = t7971 * t1798;
  t7973 = 0.25e2 / 0.54e2 * t7972;
  t7974 = t1868 * t7660;
  t7975 = 0.5e1 / 0.36e2 * t7974;
  t7976 = -t7931 - t7933 - t7937 - t7941 + t7945 - t7950 + t7953 + t7956 + t7958 - t7960 + t7964 + t7967 + t7616 + t7621 - t7969 - t7973 + t7975;
  tv3rhotau25 = -t1866 + t1870 + t1875 - t1880 - t1886 + t1894 + t9 * (t7927 + t7976);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t7979 = 0.1e1 / t6102;
  t7980 = t2 * t7979;
  t7981 = t7980 * t539;
  t7982 = t7981 * t2373;
  t7983 = 0.125e3 / 0.2592e4 * t7982;
  t7984 = t6102 * t31;
  t7985 = 0.1e1 / t7984;
  t7986 = t2 * t7985;
  t7987 = t7986 * t189;
  t7988 = t6110 * t1651;
  t7989 = t7987 * t7988;
  t7990 = 0.25e2 / 0.3456e4 * t7989;
  t7992 = t2429 * t7979 * t50;
  t7993 = t2428 * t7992;
  t7994 = 0.625e3 / 0.23328e5 * t7993;
  t7995 = t7985 * t61;
  t7996 = t7995 * t6491;
  t7997 = t543 * t7996;
  t7998 = 0.125e3 / 0.2592e4 * t7997;
  t7999 = t7980 * t2349;
  t8002 = t2356 * t7979 * t50;
  t8003 = t2355 * t8002;
  t8005 = 0.125e3 / 0.2592e4 * t7999 - 0.625e3 / 0.23328e5 * t8003;
  t8006 = t8005 * t146;
  tv3sigma30 = t9 * (-t7983 + t7990 + t7994 - t7998 + t8006);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t8008 = 0.125e3 / 0.1296e4 * t7982;
  t8009 = 0.25e2 / 0.1728e4 * t7989;
  t8010 = 0.625e3 / 0.11664e5 * t7993;
  t8011 = 0.125e3 / 0.1296e4 * t7997;
  t8014 = 0.125e3 / 0.1296e4 * t7999 - 0.625e3 / 0.11664e5 * t8003;
  t8015 = t8014 * t146;
  tv3sigma31 = t9 * (-t8008 + t8009 + t8010 - t8011 + t8015);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = tv3sigma30;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  t8017 = 0.125e3 / 0.648e3 * t7982;
  t8018 = 0.25e2 / 0.864e3 * t7989;
  t8019 = 0.625e3 / 0.5832e4 * t7993;
  t8020 = 0.125e3 / 0.648e3 * t7997;
  t8023 = 0.125e3 / 0.648e3 * t7999 - 0.625e3 / 0.5832e4 * t8003;
  t8024 = t8023 * t146;
  tv3sigma33 = t9 * (-t8017 + t8018 + t8019 - t8020 + t8024);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = tv3sigma31;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = tv3sigma32;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  t8026 = 0.125e3 / 0.324e3 * t7982;
  t8027 = 0.25e2 / 0.432e3 * t7989;
  t8028 = 0.625e3 / 0.2916e4 * t7993;
  t8029 = 0.125e3 / 0.324e3 * t7997;
  t8032 = 0.125e3 / 0.324e3 * t7999 - 0.625e3 / 0.2916e4 * t8003;
  t8033 = t8032 * t146;
  tv3sigma36 = t9 * (-t8026 + t8027 + t8028 - t8029 + t8033);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = tv3sigma33;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = tv3sigma34;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = tv3sigma35;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t8035 = t1295 * t1632;
  t8036 = t2372 * t8035;
  t8037 = t4216 * t8036;
  t8038 = 0.125e3 / 0.324e3 * t8037;
  t8039 = t6410 * t1652;
  t8040 = 0.25e2 / 0.648e3 * t8039;
  t8042 = t1632 * t40 * t152;
  t8043 = t4419 * t8042;
  t8044 = t2814 * t8043;
  t8045 = 0.625e3 / 0.2916e4 * t8044;
  t8046 = t1378 * t16;
  t8047 = t409 * t8046;
  t8048 = t6142 * t8047;
  t8049 = 0.125e3 / 0.486e3 * t8048;
  t8050 = t7986 * t185;
  t8051 = t8050 * t1140;
  t8052 = t1702 * t1695;
  t8053 = t8051 * t8052;
  t8054 = 0.25e2 / 0.10368e5 * t8053;
  t8055 = t6116 * t62;
  t8056 = t8055 * t1703;
  t8057 = t6115 * t8056;
  t8058 = 0.5e1 / 0.288e3 * t8057;
  t8060 = t805 * t4407 * t7985;
  t8061 = t447 * t544;
  t8062 = t4410 * t8061;
  t8063 = t8060 * t8062;
  t8064 = 0.125e3 / 0.7776e4 * t8063;
  t8065 = t1141 * t1709;
  t8066 = 0.25e2 / 0.1296e4 * t8065;
  t8067 = t542 * t1645;
  t8068 = t452 * t8067;
  t8070 = t1296 * t1632;
  t8071 = t8070 * t50;
  t8072 = t2785 * t8071;
  t8074 = -0.125e3 / 0.324e3 * t8068 + 0.625e3 / 0.2916e4 * t8072;
  t8075 = t8074 * t146;
  tv3sigma2tau0 = t9 * (t8038 - t8040 - t8045 + t8049 - t8054 - t8058 + t8064 + t8066 + t8075);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t8077 = t4604 * t8036;
  t8078 = 0.125e3 / 0.324e3 * t8077;
  t8079 = t1826 * t1652;
  t8080 = 0.25e2 / 0.648e3 * t8079;
  t8081 = t4586 * t8042;
  t8082 = t2814 * t8081;
  t8083 = 0.625e3 / 0.2916e4 * t8082;
  t8084 = t409 * t7426;
  t8085 = t6142 * t8084;
  t8086 = 0.125e3 / 0.486e3 * t8085;
  t8087 = t1702 * t1736;
  t8088 = t8051 * t8087;
  t8089 = 0.25e2 / 0.10368e5 * t8088;
  t8090 = t8055 * t1740;
  t8091 = t6115 * t8090;
  t8092 = 0.5e1 / 0.288e3 * t8091;
  t8093 = t473 * t544;
  t8094 = t4577 * t8093;
  t8095 = t8060 * t8094;
  t8096 = 0.125e3 / 0.7776e4 * t8095;
  t8097 = t1141 * t1744;
  t8098 = 0.25e2 / 0.1296e4 * t8097;
  t8099 = t478 * t8067;
  t8101 = t1410 * t1632;
  t8103 = t2785 * t8101 * t50;
  t8105 = -0.125e3 / 0.324e3 * t8099 + 0.625e3 / 0.2916e4 * t8103;
  t8106 = t8105 * t146;
  tv3sigma2tau1 = t9 * (t8078 - t8080 - t8083 + t8086 - t8089 - t8092 + t8096 + t8098 + t8106);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  t8108 = 0.125e3 / 0.162e3 * t8037;
  t8109 = 0.25e2 / 0.324e3 * t8039;
  t8110 = 0.625e3 / 0.1458e4 * t8044;
  t8111 = 0.125e3 / 0.243e3 * t8048;
  t8112 = 0.25e2 / 0.5184e4 * t8053;
  t8113 = 0.5e1 / 0.144e3 * t8057;
  t8114 = 0.125e3 / 0.3888e4 * t8063;
  t8115 = 0.25e2 / 0.648e3 * t8065;
  t8118 = -0.125e3 / 0.162e3 * t8068 + 0.625e3 / 0.1458e4 * t8072;
  t8119 = t8118 * t146;
  tv3sigma2tau2 = t9 * (t8108 - t8109 - t8110 + t8111 - t8112 - t8113 + t8114 + t8115 + t8119);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  t8121 = 0.125e3 / 0.162e3 * t8077;
  t8122 = 0.25e2 / 0.324e3 * t8079;
  t8123 = 0.625e3 / 0.1458e4 * t8082;
  t8124 = 0.125e3 / 0.243e3 * t8085;
  t8125 = 0.25e2 / 0.5184e4 * t8088;
  t8126 = 0.5e1 / 0.144e3 * t8091;
  t8127 = 0.125e3 / 0.3888e4 * t8095;
  t8128 = 0.25e2 / 0.648e3 * t8097;
  t8131 = -0.125e3 / 0.162e3 * t8099 + 0.625e3 / 0.1458e4 * t8103;
  t8132 = t8131 * t146;
  tv3sigma2tau3 = t9 * (t8121 - t8122 - t8123 + t8124 - t8125 - t8126 + t8127 + t8128 + t8132);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = tv3sigma2tau0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = tv3sigma2tau1;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  t8134 = 0.125e3 / 0.81e2 * t8037;
  t8135 = 0.25e2 / 0.162e3 * t8039;
  t8136 = 0.625e3 / 0.729e3 * t8044;
  t8137 = 0.25e3 / 0.243e3 * t8048;
  t8138 = 0.25e2 / 0.2592e4 * t8053;
  t8139 = 0.5e1 / 0.72e2 * t8057;
  t8140 = 0.125e3 / 0.1944e4 * t8063;
  t8141 = 0.25e2 / 0.324e3 * t8065;
  t8144 = -0.125e3 / 0.81e2 * t8068 + 0.625e3 / 0.729e3 * t8072;
  t8145 = t8144 * t146;
  tv3sigma2tau6 = t9 * (t8134 - t8135 - t8136 + t8137 - t8138 - t8139 + t8140 + t8141 + t8145);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  t8147 = 0.125e3 / 0.81e2 * t8077;
  t8148 = 0.25e2 / 0.162e3 * t8079;
  t8149 = 0.625e3 / 0.729e3 * t8082;
  t8150 = 0.25e3 / 0.243e3 * t8085;
  t8151 = 0.25e2 / 0.2592e4 * t8088;
  t8152 = 0.5e1 / 0.72e2 * t8091;
  t8153 = 0.125e3 / 0.1944e4 * t8095;
  t8154 = 0.25e2 / 0.324e3 * t8097;
  t8157 = -0.125e3 / 0.81e2 * t8099 + 0.625e3 / 0.729e3 * t8103;
  t8158 = t8157 * t146;
  tv3sigma2tau7 = t9 * (t8147 - t8148 - t8149 + t8150 - t8151 - t8152 + t8153 + t8154 + t8158);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = tv3sigma2tau2;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = tv3sigma2tau3;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = tv3sigma2tau4;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = tv3sigma2tau5;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t8160 = t1295 * t35;
  t8161 = t2372 * t8160;
  t8162 = t7284 * t8161;
  t8163 = 0.25e3 / 0.81e2 * t8162;
  t8164 = t1794 * t189;
  t8165 = t8164 * t3504;
  t8166 = 0.25e2 / 0.162e3 * t8165;
  t8167 = t1321 * t1639;
  t8168 = t207 * t194;
  t8169 = t8167 * t8168;
  t8170 = t8164 * t8169;
  t8171 = 0.25e2 / 0.648e3 * t8170;
  t8172 = t1788 * t40;
  t8173 = t8172 * t44;
  t8174 = t1785 * t8173;
  t8175 = t1687 * t1797;
  t8176 = t8174 * t8175;
  t8177 = 0.5e1 / 0.36e2 * t8176;
  t8179 = t35 * t40 * t152;
  t8180 = t7243 * t8179;
  t8181 = t2814 * t8180;
  t8182 = 0.125e4 / 0.729e3 * t8181;
  t8183 = t409 * t1802;
  t8184 = t3463 * t8183;
  t8185 = 0.25e3 / 0.243e3 * t8184;
  t8186 = t1812 * t544;
  t8187 = t7247 * t8186;
  t8188 = t6394 * t8187;
  t8189 = 0.125e3 / 0.486e3 * t8188;
  t8190 = t1141 * t1808;
  t8191 = 0.25e2 / 0.162e3 * t8190;
  t8192 = t1806 * t146;
  t8193 = t6334 * t8192;
  t8194 = t1700 * t8193;
  t8195 = 0.5e1 / 0.288e3 * t8194;
  t8196 = t6460 * t62;
  t8197 = t8196 * t1807;
  t8198 = t1323 * t8197;
  t8199 = 0.25e2 / 0.1296e4 * t8198;
  t8200 = t1338 * t8192;
  t8201 = t154 * t8200;
  t8202 = 0.5e1 / 0.36e2 * t8201;
  t8203 = t542 * t1120;
  t8204 = t1794 * t8203;
  t8206 = t1806 * t35;
  t8207 = t8206 * t50;
  t8208 = t2785 * t8207;
  t8210 = 0.25e3 / 0.81e2 * t8204 - 0.125e4 / 0.729e3 * t8208;
  t8211 = t8210 * t146;
  t8212 = -t8163 + t8166 + t8171 + t8177 + t8182 - t8185 - t8189 - t8191 + t8195 - t8199 - t8202 + t8211;
  tv3sigmatau20 = t9 * t8212;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t8213 = t7459 * t1691;
  t8214 = t5300 * t8213;
  t8215 = 0.25e3 / 0.81e2 * t8214;
  t8216 = t478 * t7318;
  t8217 = t8216 * t1696;
  t8218 = 0.25e2 / 0.162e3 * t8217;
  t8219 = t30 * t1639;
  t8220 = t8219 * t207;
  t8221 = t8220 * t1695;
  t8222 = t8216 * t8221;
  t8223 = 0.25e2 / 0.648e3 * t8222;
  t8224 = t1151 * t448;
  t8225 = t6544 * t8224;
  t8226 = 0.5e1 / 0.36e2 * t8225;
  t8227 = t7362 * t8179;
  t8228 = t5013 * t8227;
  t8229 = 0.125e4 / 0.729e3 * t8228;
  t8230 = t6491 * t7362;
  t8231 = t6490 * t8230;
  t8232 = 0.25e3 / 0.243e3 * t8231;
  t8234 = t805 * t4407 * t1707;
  t8235 = t8234 * t8230;
  t8236 = 0.125e3 / 0.486e3 * t8235;
  t8237 = t6365 * t1840;
  t8238 = 0.25e2 / 0.162e3 * t8237;
  t8239 = t1699 * t1335;
  t8240 = t574 * t21;
  t8241 = t8240 * t1844;
  t8242 = t8239 * t8241;
  t8243 = 0.5e1 / 0.288e3 * t8242;
  t8245 = t324 * t325 * t8219;
  t8246 = t4756 * t1695;
  t8247 = t8245 * t8246;
  t8248 = 0.25e2 / 0.1296e4 * t8247;
  t8249 = t152 * t408;
  t8250 = t151 * t8249;
  t8251 = t8250 * t8241;
  t8252 = 0.5e1 / 0.36e2 * t8251;
  t8253 = t806 * t1691;
  t8254 = t4604 * t8253;
  t8256 = t1833 * t8179;
  t8257 = t5342 * t8256;
  t8259 = 0.25e3 / 0.81e2 * t8254 - 0.125e4 / 0.729e3 * t8257;
  t8260 = t8259 * t146;
  t8261 = -t8215 + t8218 + t8223 + t8226 + t8229 - t8232 - t8236 - t8238 + t8243 - t8248 - t8252 + t8260;
  tv3sigmatau21 = t9 * t8261;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  t8262 = t7525 * t8161;
  t8263 = 0.25e3 / 0.81e2 * t8262;
  t8264 = t1867 * t189;
  t8265 = t8264 * t3504;
  t8266 = 0.25e2 / 0.162e3 * t8265;
  t8267 = t8264 * t8169;
  t8268 = 0.25e2 / 0.648e3 * t8267;
  t8269 = t1861 * t40;
  t8270 = t8269 * t44;
  t8271 = t1858 * t8270;
  t8272 = t8271 * t8175;
  t8273 = 0.5e1 / 0.36e2 * t8272;
  t8274 = t7625 * t8179;
  t8275 = t2814 * t8274;
  t8276 = 0.125e4 / 0.729e3 * t8275;
  t8277 = t409 * t1872;
  t8278 = t3463 * t8277;
  t8279 = 0.25e3 / 0.243e3 * t8278;
  t8280 = t1882 * t544;
  t8281 = t7596 * t8280;
  t8282 = t6394 * t8281;
  t8283 = 0.125e3 / 0.486e3 * t8282;
  t8284 = t1141 * t1878;
  t8285 = 0.25e2 / 0.162e3 * t8284;
  t8286 = t1876 * t146;
  t8287 = t6334 * t8286;
  t8288 = t1700 * t8287;
  t8289 = 0.5e1 / 0.288e3 * t8288;
  t8290 = t8196 * t1877;
  t8291 = t1323 * t8290;
  t8292 = 0.25e2 / 0.1296e4 * t8291;
  t8293 = t1338 * t8286;
  t8294 = t154 * t8293;
  t8295 = 0.5e1 / 0.36e2 * t8294;
  t8296 = t1867 * t8203;
  t8298 = t1876 * t35;
  t8300 = t2785 * t8298 * t50;
  t8302 = 0.25e3 / 0.81e2 * t8296 - 0.125e4 / 0.729e3 * t8300;
  t8303 = t8302 * t146;
  t8304 = -t8263 + t8266 + t8268 + t8273 + t8276 - t8279 - t8283 - t8285 + t8289 - t8292 - t8295 + t8303;
  tv3sigmatau22 = t9 * t8304;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  t8305 = 0.5e3 / 0.81e2 * t8162;
  t8306 = 0.25e2 / 0.81e2 * t8165;
  t8307 = 0.25e2 / 0.324e3 * t8170;
  t8308 = 0.5e1 / 0.18e2 * t8176;
  t8309 = 0.25e4 / 0.729e3 * t8181;
  t8310 = 0.5e3 / 0.243e3 * t8184;
  t8311 = 0.125e3 / 0.243e3 * t8188;
  t8312 = 0.25e2 / 0.81e2 * t8190;
  t8313 = 0.5e1 / 0.144e3 * t8194;
  t8314 = 0.25e2 / 0.648e3 * t8198;
  t8315 = 0.5e1 / 0.18e2 * t8201;
  t8318 = 0.5e3 / 0.81e2 * t8204 - 0.25e4 / 0.729e3 * t8208;
  t8319 = t8318 * t146;
  t8320 = -t8305 + t8306 + t8307 + t8308 + t8309 - t8310 - t8311 - t8312 + t8313 - t8314 - t8315 + t8319;
  tv3sigmatau23 = t9 * t8320;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  t8321 = 0.5e3 / 0.81e2 * t8214;
  t8322 = 0.25e2 / 0.81e2 * t8217;
  t8323 = 0.25e2 / 0.324e3 * t8222;
  t8324 = 0.5e1 / 0.18e2 * t8225;
  t8325 = 0.25e4 / 0.729e3 * t8228;
  t8326 = 0.5e3 / 0.243e3 * t8231;
  t8327 = 0.125e3 / 0.243e3 * t8235;
  t8328 = 0.25e2 / 0.81e2 * t8237;
  t8329 = 0.5e1 / 0.144e3 * t8242;
  t8330 = 0.25e2 / 0.648e3 * t8247;
  t8331 = 0.5e1 / 0.18e2 * t8251;
  t8334 = 0.5e3 / 0.81e2 * t8254 - 0.25e4 / 0.729e3 * t8257;
  t8335 = t8334 * t146;
  t8336 = -t8321 + t8322 + t8323 + t8324 + t8325 - t8326 - t8327 - t8328 + t8329 - t8330 - t8331 + t8335;
  tv3sigmatau24 = t9 * t8336;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  t8337 = 0.5e3 / 0.81e2 * t8262;
  t8338 = 0.25e2 / 0.81e2 * t8265;
  t8339 = 0.25e2 / 0.324e3 * t8267;
  t8340 = 0.5e1 / 0.18e2 * t8272;
  t8341 = 0.25e4 / 0.729e3 * t8275;
  t8342 = 0.5e3 / 0.243e3 * t8278;
  t8343 = 0.125e3 / 0.243e3 * t8282;
  t8344 = 0.25e2 / 0.81e2 * t8284;
  t8345 = 0.5e1 / 0.144e3 * t8288;
  t8346 = 0.25e2 / 0.648e3 * t8291;
  t8347 = 0.5e1 / 0.18e2 * t8294;
  t8350 = 0.5e3 / 0.81e2 * t8296 - 0.25e4 / 0.729e3 * t8300;
  t8351 = t8350 * t146;
  t8352 = -t8337 + t8338 + t8339 + t8340 + t8341 - t8342 - t8343 - t8344 + t8345 - t8346 - t8347 + t8351;
  tv3sigmatau25 = t9 * t8352;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = tv3sigmatau20;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = tv3sigmatau21;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = tv3sigmatau22;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t8353 = t2283 * rho[0];
  t8354 = 0.1e1 / t8353;
  t8355 = t2 * t8354;
  t8356 = t1786 * t1786;
  t8357 = t8356 * t13;
  t8358 = t8357 * t539;
  t8359 = t8355 * t8358;
  t8361 = 0.2e4 / 0.81e2 * t8359 * t2373;
  t8362 = t8355 * t8357;
  t8363 = t8362 * t189;
  t8364 = t1321 * t58;
  t8365 = t8364 * t8168;
  t8367 = 0.25e2 / 0.54e2 * t8363 * t8365;
  t8368 = t8362 * t50;
  t8369 = t574 * t146;
  t8370 = t1796 * t8369;
  t8372 = 0.5e1 / 0.12e2 * t8368 * t8370;
  t8373 = t2356 * t8354;
  t8375 = t8373 * t8357 * t50;
  t8377 = 0.1e5 / 0.729e3 * t2814 * t8375;
  t8378 = t207 * t8354;
  t8379 = t8357 * t146;
  t8380 = t8379 * t544;
  t8381 = t8378 * t8380;
  t8383 = 0.25e3 / 0.81e2 * t4409 * t8381;
  t8384 = t8354 * t8357;
  t8385 = t8384 * t194;
  t8386 = t1338 * t8385;
  t8388 = 0.25e2 / 0.54e2 * t1323 * t8386;
  t8389 = t62 * t8354;
  t8390 = t8389 * t8379;
  t8391 = t2640 * t8390;
  t8393 = 0.5e1 / 0.12e2 * t154 * t8391;
  t8399 = -0.2e4 / 0.81e2 * t8362 * t2349 + 0.1e5 / 0.729e3 * t2785 * t8384 * t50;
  t8400 = t8399 * t146;
  tv3tau30 = t9 * (t8361 - t8367 - t8372 - t8377 + t8383 + t8388 + t8393 + t8400);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t8403 = 0.2e4 / 0.81e2 * t5300 * t1803;
  t8404 = t7358 * t1807;
  t8406 = 0.25e2 / 0.54e2 * t8216 * t8404;
  t8408 = 0.5e1 / 0.12e2 * t479 * t1814;
  t8410 = t8172 * t152;
  t8411 = t1410 * t1784 * t8410;
  t8413 = 0.1e5 / 0.729e3 * t5013 * t8411;
  t8414 = t1811 * t1788;
  t8415 = t1295 * t1410;
  t8416 = t8414 * t8415;
  t8418 = 0.25e3 / 0.81e2 * t5174 * t8416;
  t8419 = t574 * t1806;
  t8420 = t8419 * t1736;
  t8422 = 0.25e2 / 0.54e2 * t1838 * t8420;
  t8423 = t473 * t1806;
  t8424 = t5427 * t8423;
  t8426 = 0.5e1 / 0.12e2 * t1336 * t8424;
  t8429 = t27 * t1784;
  t8430 = t8429 * t1788;
  t8431 = t8430 * t50;
  t8434 = -0.2e4 / 0.81e2 * t4604 * t1820 + 0.1e5 / 0.729e3 * t5342 * t8431;
  t8435 = t8434 * t146;
  tv3tau31 = t9 * (t8403 - t8406 - t8408 - t8413 + t8418 + t8422 + t8426 + t8435);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  t8437 = t7524 * t541;
  t8438 = t1858 * t8437;
  t8439 = t147 * t8046;
  t8441 = 0.2e4 / 0.81e2 * t8438 * t8439;
  t8442 = t7358 * t1695;
  t8444 = 0.25e2 / 0.54e2 * t7576 * t8442;
  t8445 = t1867 * t453;
  t8446 = t878 * t448;
  t8448 = 0.5e1 / 0.12e2 * t8445 * t8446;
  t8450 = t432 * t152;
  t8451 = t1876 * t6 * t8450;
  t8453 = 0.1e5 / 0.729e3 * t5013 * t8451;
  t8454 = t1295 * t1876;
  t8455 = t5175 * t8454;
  t8457 = 0.25e3 / 0.81e2 * t5174 * t8455;
  t8458 = t574 * t1876;
  t8459 = t8458 * t1695;
  t8461 = 0.25e2 / 0.54e2 * t1838 * t8459;
  t8462 = t4251 * t1881;
  t8463 = t1882 * t1296;
  t8464 = t8462 * t8463;
  t8466 = 0.5e1 / 0.12e2 * t1336 * t8464;
  t8467 = t806 * t1296;
  t8471 = t805 * t5059 * t1857;
  t8472 = t1861 * t6;
  t8473 = t8472 * t16;
  t8474 = t8473 * t50;
  t8477 = -0.2e4 / 0.81e2 * t7525 * t8467 + 0.1e5 / 0.729e3 * t8471 * t8474;
  t8478 = t8477 * t146;
  tv3tau32 = t9 * (t8441 - t8444 - t8448 - t8453 + t8457 + t8461 + t8466 + t8478);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t8480 = t3250 * rho[1];
  t8481 = 0.1e1 / t8480;
  t8482 = t2 * t8481;
  t8483 = t1859 * t1859;
  t8484 = t8483 * t24;
  t8485 = t8484 * t539;
  t8486 = t8482 * t8485;
  t8488 = 0.2e4 / 0.81e2 * t8486 * t2373;
  t8489 = t8482 * t8484;
  t8490 = t8489 * t189;
  t8492 = 0.25e2 / 0.54e2 * t8490 * t8365;
  t8493 = t8489 * t50;
  t8495 = 0.5e1 / 0.12e2 * t8493 * t8370;
  t8496 = t2356 * t8481;
  t8498 = t8496 * t8484 * t50;
  t8500 = 0.1e5 / 0.729e3 * t2814 * t8498;
  t8501 = t207 * t8481;
  t8502 = t8484 * t146;
  t8503 = t8502 * t544;
  t8504 = t8501 * t8503;
  t8506 = 0.25e3 / 0.81e2 * t4409 * t8504;
  t8507 = t8481 * t8484;
  t8508 = t8507 * t194;
  t8509 = t1338 * t8508;
  t8511 = 0.25e2 / 0.54e2 * t1323 * t8509;
  t8512 = t62 * t8481;
  t8513 = t8512 * t8502;
  t8514 = t2640 * t8513;
  t8516 = 0.5e1 / 0.12e2 * t154 * t8514;
  t8519 = t8507 * t50;
  t8522 = -0.2e4 / 0.81e2 * t8489 * t2349 + 0.1e5 / 0.729e3 * t2785 * t8519;
  t8523 = t8522 * t146;
  tv3tau33 = t9 * (t8488 - t8492 - t8495 - t8500 + t8506 + t8511 + t8516 + t8523);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t26, t27;
  double t28, t30, t31, t32, t33, t35, t38, t39;
  double t40, t41, t42, t43, t44, t45, t46, t47;
  double t48, t50, t53, t54, t55, t56, t58, t59;
  double t60, t61, t62, t63, t66, t67, t68, t69;
  double t70, t71, t72, t75, t77, t78, t81, t83;
  double t84, t85, t88, t90, t93, t94, t96, t97;
  double t98, t99, t100, t101, t102, t103, t105, t106;
  double t107, t109, t110, t113, t114, t116, t121, t124;
  double t125, t129, t134, t137, t138, t139, t141, t142;
  double t146, t147, t148, t150, t151, t152, t153, t154;
  double t156, t157, tzk0;

  double t158, t160, t161, t162, t164, t165, t166, t167;
  double t168, t169, t171, t172, t173, t175, t177, t179;
  double t180, t181, t182, t183, t184, t185, t187, t188;
  double t189, t190, t191, t192, t193, t194, t195, t196;
  double t197, t198, t199, t201, t202, t204, t205, t206;
  double t207, t209, t210, t213, t215, t216, t217, t218;
  double t219, t220, t222, t223, t226, t227, t228, t229;
  double t231, t232, t233, t234, t236, t238, t239, t240;
  double t245, t247, t248, t249, t251, t252, t253, t255;
  double t256, t257, t259, t262, t263, t266, t268, t269;
  double t274, t275, t276, t281, t282, t283, t289, t290;
  double t291, t296, t297, t298, t301, t302, t303, t306;
  double t308, t310, t311, t313, t315, t316, t317, t318;
  double t319, t320, t321, t322, t324, t325, t326, t327;
  double t330, t331, t332, tvrho0, t335, t336, t337, t338;
  double t340, t342, t343, t344, t346, t347, t348, t350;
  double t351, t352, t353, t354, t355, t356, t357, t358;
  double t360, t361, t364, t365, t366, t367, t368, t371;
  double t372, t375, t377, t378, t382, t383, t384, t385;
  double t386, t387, t388, t390, t391, t394, t395, t396;
  double tvrho1, t399, t400, t401, t402, t403, t405, t406;
  double t407, t408, t409, t410, t411, t412, t414, t416;
  double t418, t420, t421, tvsigma0, t423, t424, t425, t428;
  double t429, tvsigma1, tvsigma2, tvlapl0, tvlapl1, t431, t432, t433;
  double t434, t435, t436, t438, t439, t440, t441, t442;
  double t444, t445, t446, t447, t448, t449, t451, t452;
  double t453, t456, t459, t460, tvtau0, t462, t463, t464;
  double t466, t467, t468, t471, t472, t473, t474, t475;
  double t477, t478, t479, t484, t485, tvtau1;

  double t493, t495, t496, t498, t500, t501, t502, t503;
  double t505, t506, t507, t508, t509, t511, t512, t513;
  double t514, t516, t517, t518, t520, t521, t522, t523;
  double t524, t525, t526, t527, t528, t529, t530, t531;
  double t532, t533, t534, t535, t536, t537, t538, t539;
  double t541, t542, t543, t544, t545, t546, t547, t548;
  double t549, t550, t551, t552, t553, t554, t555, t556;
  double t557, t558, t559, t560, t561, t562, t564, t565;
  double t567, t568, t571, t573, t574, t575, t576, t579;
  double t580, t581, t583, t584, t588, t589, t590, t591;
  double t592, t593, t594, t595, t596, t597, t598, t599;
  double t600, t601, t602, t603, t604, t606, t609, t610;
  double t611, t612, t615, t616, t617, t619, t620, t622;
  double t623, t624, t626, t629, t631, t633, t635, t636;
  double t637, t639, t640, t641, t644, t648, t649, t650;
  double t651, t654, t658, t660, t664, t666, t670, t671;
  double t675, t676, t677, t678, t679, t688, t689, t692;
  double t693, t694, t695, t696, t697, t702, t703, t706;
  double t707, t708, t709, t710, t711, t713, t720, t721;
  double t723, t724, t725, t726, t727, t728, t729, t731;
  double t735, t739, t740, t741, t742, t745, t748, t749;
  double t752, t753, t754, t755, t757, t758, t760, t763;
  double t764, t766, t768, t769, t770, t772, t773, t775;
  double t776, t778, t779, t780, t782, t783, t784, t787;
  double t789, t790, t791, t792, t793, t794, t795, t796;
  double t797, t799, t800, t801, t802, t805, t806, t807;
  double t810, t811, t814, t815, t816, t817, t818, t819;
  double tv2rho20, t822, t823, t824, t826, t827, t828, t830;
  double t832, t833, t834, t836, t837, t838, t840, t841;
  double t842, t843, t844, t846, t847, t849, t851, t853;
  double t854, t855, t856, t858, t859, t861, t862, t863;
  double t865, t866, t867, t869, t871, t872, t873, t876;
  double t878, t879, t880, t883, t884, t886, t887, t891;
  double t892, t893, t894, t896, t897, t898, t900, t902;
  double t903, t904, t905, t907, t908, t909, t911, t912;
  double t915, t916, t919, t921, t923, t925, t928, t932;
  double t933, t936, t940, t942, t943, t945, t946, t950;
  double t951, t952, t953, t954, t956, t957, t959, t962;
  double t963, t966, t967, t970, t971, t972, t973, t974;
  double t975, tv2rho21, t983, t984, t986, t987, t988, t990;
  double t991, t993, t994, t996, t998, t999, t1000, t1002;
  double t1003, t1004, t1006, t1007, t1008, t1009, t1010, t1011;
  double t1012, t1013, t1014, t1015, t1016, t1017, t1018, t1019;
  double t1020, t1021, t1022, t1023, t1024, t1025, t1026, t1027;
  double t1028, t1029, t1030, t1031, t1032, t1033, t1034, t1035;
  double t1037, t1038, t1042, t1043, t1046, t1047, t1048, t1049;
  double t1050, t1051, t1052, t1053, t1054, t1055, t1058, t1062;
  double t1063, t1066, t1070, t1072, t1073, t1081, t1083, t1084;
  double t1085, t1086, t1087, t1088, t1089, t1090, t1092, t1095;
  double t1098, t1099, t1102, t1103, t1104, t1105, t1106, t1107;
  double tv2rho22, t1109, t1110, t1111, t1112, t1113, t1114, t1115;
  double t1116, t1117, t1118, t1119, t1120, t1121, t1122, t1123;
  double t1124, t1126, t1127, t1128, t1130, t1131, t1132, t1134;
  double t1135, t1136, t1137, t1138, t1139, t1140, t1141, t1142;
  double t1143, t1144, t1145, t1146, t1147, t1148, t1149, t1150;
  double t1151, t1152, t1153, t1154, t1155, t1156, t1157, t1158;
  double t1159, t1160, t1161, t1162, t1163, t1164, t1166, t1167;
  double t1168, t1169, t1171, t1172, t1173, t1175, t1177, t1178;
  double t1179, t1180, t1181, t1182, tv2rhosigma0, t1184, t1185, t1186;
  double t1187, t1188, t1189, t1190, t1191, t1192, t1193, t1194;
  double t1195, t1196, t1197, t1198, t1201, t1202, t1203, t1204;
  double t1205, tv2rhosigma1, tv2rhosigma2, t1207, t1208, t1209, t1210, t1211;
  double t1212, t1213, t1214, t1215, t1216, t1218, t1219, t1220;
  double t1222, t1223, t1224, t1225, t1226, t1227, t1228, t1229;
  double t1230, t1231, t1232, t1233, t1234, t1235, t1236, t1237;
  double t1238, t1240, t1241, t1242, t1244, t1245, t1246, t1247;
  double tv2rhosigma3, t1249, t1250, t1251, t1252, t1253, t1254, t1255;
  double t1256, t1257, t1258, t1261, t1262, t1263, t1264, tv2rhosigma4;
  double tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t1266, t1267, t1268;
  double t1269, t1270, t1271, t1272, t1274, t1275, t1276, t1277;
  double t1278, t1279, t1280, t1281, t1282, t1283, t1284, t1286;
  double t1287, t1288, t1290, t1291, t1292, t1293, t1294, t1295;
  double t1296, t1297, t1298, t1299, t1300, t1301, t1302, t1303;
  double t1304, t1305, t1306, t1307, t1308, t1309, t1310, t1311;
  double t1312, t1313, t1314, t1315, t1317, t1318, t1319, t1320;
  double t1321, t1322, t1323, t1324, t1325, t1326, t1327, t1328;
  double t1329, t1330, t1331, t1332, t1333, t1334, t1335, t1336;
  double t1337, t1338, t1339, t1340, t1341, t1342, t1343, t1344;
  double t1345, t1346, t1347, t1348, t1349, t1350, t1351, t1352;
  double t1353, t1354, t1355, t1356, t1357, t1358, t1359, t1360;
  double t1361, t1362, t1363, t1364, t1365, t1368, t1369, t1370;
  double t1373, t1375, t1378, t1379, t1380, t1383, t1389, t1390;
  double t1391, t1392, tv2rhotau0, t1394, t1395, t1396, t1398, t1399;
  double t1400, t1401, t1402, t1403, t1404, t1405, t1406, t1407;
  double t1408, t1409, t1410, t1411, t1412, t1413, t1414, t1416;
  double t1417, t1419, t1420, t1421, t1422, t1424, t1425, t1426;
  double t1427, t1428, t1429, t1430, t1431, t1432, t1433, t1434;
  double t1435, t1436, t1437, t1438, t1439, t1440, t1441, t1442;
  double t1443, t1444, t1445, t1446, t1447, t1448, t1449, t1450;
  double t1451, t1452, t1453, t1454, t1455, t1456, t1457, t1460;
  double t1463, t1464, t1465, t1471, t1472, t1473, t1474, tv2rhotau1;
  double t1477, t1478, t1479, t1480, t1481, t1482, t1483, t1485;
  double t1486, t1487, t1489, t1490, t1491, t1492, t1493, t1494;
  double t1495, t1496, t1497, t1498, t1499, t1500, t1501, t1502;
  double t1503, t1504, t1506, t1507, t1508, t1509, t1510, t1511;
  double t1512, t1513, t1514, t1515, t1516, t1517, t1518, t1519;
  double t1520, t1521, t1522, t1523, t1524, t1525, t1526, t1527;
  double t1528, t1529, t1530, t1534, t1537, t1538, t1544, t1545;
  double t1546, t1547, tv2rhotau2, t1549, t1550, t1551, t1552, t1554;
  double t1555, t1556, t1557, t1558, t1559, t1560, t1561, t1562;
  double t1563, t1564, t1565, t1566, t1568, t1569, t1571, t1572;
  double t1573, t1574, t1576, t1577, t1578, t1580, t1581, t1582;
  double t1583, t1584, t1586, t1587, t1588, t1589, t1590, t1591;
  double t1592, t1593, t1594, t1595, t1596, t1597, t1598, t1599;
  double t1600, t1601, t1602, t1603, t1604, t1605, t1606, t1607;
  double t1608, t1610, t1611, t1616, t1617, t1626, t1627, t1628;
  double t1629, tv2rhotau3, t1632, t1633, t1634, t1635, t1636, t1637;
  double t1639, t1640, t1641, t1642, t1643, t1644, t1645, t1647;
  double t1648, t1649, t1650, t1651, t1652, t1653, t1654, t1656;
  double t1659, t1661, t1662, tv2sigma20, t1664, t1665, t1666, t1667;
  double t1670, t1671, tv2sigma21, tv2sigma22, t1673, t1674, t1675, t1676;
  double t1679, t1680, tv2sigma23, tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1682, t1683, t1684, t1685, t1686;
  double t1687, t1688, t1689, t1690, t1691, t1692, t1693, t1694;
  double t1695, t1696, t1697, t1698, t1699, t1700, t1701, t1702;
  double t1703, t1704, t1705, t1706, t1707, t1708, t1709, t1710;
  double t1711, t1712, t1713, t1714, t1716, t1717, t1719, t1721;
  double t1723, t1724, tv2sigmatau0, t1726, t1727, t1728, t1729, t1730;
  double t1731, t1732, t1733, t1734, t1735, t1736, t1738, t1739;
  double t1740, t1741, t1742, t1743, t1744, t1745, t1746, t1747;
  double t1748, t1749, t1750, t1752, t1754, t1756, t1757, tv2sigmatau1;
  double t1759, t1760, t1761, t1762, t1763, t1764, t1765, t1768;
  double t1769, tv2sigmatau2, t1771, t1772, t1773, t1774, t1775, t1776;
  double t1777, t1780, t1781, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, tv2lapl20, tv2lapl21;
  double tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, t1784, t1785, t1786;
  double t1788, t1789, t1790, t1791, t1793, t1794, t1795, t1796;
  double t1797, t1798, t1800, t1801, t1802, t1803, t1805, t1806;
  double t1807, t1808, t1810, t1811, t1812, t1813, t1814, t1816;
  double t1820, t1823, t1824, tv2tau20, t1826, t1828, t1830, t1831;
  double t1832, t1833, t1834, t1836, t1837, t1838, t1839, t1840;
  double t1842, t1843, t1844, t1845, t1847, t1853, t1854, tv2tau21;
  double t1857, t1858, t1859, t1861, t1862, t1863, t1864, t1866;
  double t1867, t1868, t1870, t1871, t1872, t1875, t1876, t1877;
  double t1878, t1880, t1881, t1882, t1883, t1884, t1886, t1887;
  double t1893, t1894, tv2tau22;

  double t1896, t1897, t1898, t1899, t1900, t1901, t1902, t1903;
  double t1904, t1905, t1906, t1907, t1908, t1909, t1910, t1911;
  double t1914, t1917, t1918, t1921, t1923, t1925, t1927, t1928;
  double t1929, t1931, t1934, t1935, t1937, t1939, t1941, t1942;
  double t1944, t1945, t1947, t1948, t1950, t1951, t1952, t1954;
  double t1955, t1957, t1961, t1962, t1964, t1965, t1967, t1968;
  double t1970, t1971, t1973, t1974, t1975, t1977, t1979, t1982;
  double t1984, t1985, t1987, t1991, t1993, t1994, t1997, t2000;
  double t2001, t2002, t2006, t2008, t2009, t2012, t2015, t2019;
  double t2021, t2024, t2025, t2027, t2030, t2031, t2034, t2035;
  double t2037, t2038, t2041, t2043, t2044, t2045, t2047, t2049;
  double t2050, t2052, t2053, t2055, t2056, t2059, t2061, t2063;
  double t2064, t2066, t2067, t2069, t2076, t2080, t2084, t2091;
  double t2092, t2096, t2097, t2098, t2099, t2110, t2111, t2118;
  double t2122, t2123, t2134, t2135, t2138, t2139, t2151, t2155;
  double t2158, t2163, t2166, t2167, t2170, t2171, t2175, t2176;
  double t2178, t2179, t2183, t2184, t2185, t2187, t2188, t2189;
  double t2190, t2191, t2193, t2194, t2195, t2196, t2198, t2200;
  double t2202, t2204, t2205, t2206, t2207, t2209, t2212, t2213;
  double t2214, t2215, t2217, t2218, t2221, t2222, t2223, t2224;
  double t2225, t2226, t2227, t2228, t2229, t2231, t2232, t2235;
  double t2237, t2238, t2240, t2242, t2243, t2244, t2246, t2247;
  double t2249, t2250, t2252, t2253, t2254, t2256, t2258, t2260;
  double t2261, t2262, t2263, t2264, t2265, t2266, t2269, t2270;
  double t2271, t2273, t2274, t2277, t2278, t2280, t2281, t2283;
  double t2285, t2286, t2288, t2290, t2292, t2294, t2295, t2296;
  double t2297, t2298, t2300, t2301, t2302, t2304, t2305, t2306;
  double t2308, t2309, t2310, t2311, t2312, t2314, t2315, t2316;
  double t2318, t2319, t2320, t2322, t2323, t2324, t2327, t2329;
  double t2330, t2331, t2333, t2334, t2335, t2336, t2337, t2338;
  double t2339, t2340, t2342, t2347, t2348, t2349, t2352, t2353;
  double t2354, t2355, t2356, t2358, t2361, t2362, t2365, t2366;
  double t2369, t2370, t2371, t2372, t2373, t2374, t2375, t2376;
  double t2377, t2378, t2380, t2381, t2382, t2383, t2384, t2385;
  double t2386, t2387, t2388, t2389, t2390, t2391, t2392, t2393;
  double t2394, t2395, t2396, t2397, t2398, t2399, t2400, t2401;
  double t2402, t2403, t2404, t2405, t2406, t2407, t2408, t2409;
  double t2411, t2412, t2414, t2415, t2416, t2417, t2418, t2419;
  double t2420, t2422, t2423, t2424, t2425, t2426, t2427, t2428;
  double t2429, t2431, t2432, t2433, t2434, tv3rho30, t2451, t2452;
  double t2453, t2454, t2455, t2456, t2457, t2458, t2459, t2460;
  double t2461, t2462, t2463, t2464, t2467, t2469, t2470, t2471;
  double t2472, t2474, t2475, t2476, t2478, t2479, t2480, t2483;
  double t2485, t2486, t2488, t2491, t2493, t2494, t2496, t2497;
  double t2498, t2501, t2503, t2505, t2507, t2509, t2510, t2511;
  double t2513, t2514, t2516, t2517, t2519, t2520, t2522, t2524;
  double t2526, t2528, t2530, t2531, t2532, t2534, t2535, t2537;
  double t2538, t2540, t2541, t2543, t2544, t2545, t2546, t2547;
  double t2549, t2551, t2553, t2554, t2555, t2557, t2558, t2560;
  double t2561, t2563, t2564, t2565, t2567, t2569, t2571, t2573;
  double t2575, t2576, t2577, t2579, t2581, t2583, t2584, t2586;
  double t2588, t2590, t2592, t2593, t2596, t2597, t2599, t2601;
  double t2603, t2605, t2607, t2609, t2611, t2612, t2614, t2616;
  double t2618, t2619, t2621, t2622, t2625, t2628, t2629, t2633;
  double t2634, t2635, t2637, t2639, t2640, t2641, t2644, t2645;
  double t2646, t2650, t2654, t2655, t2657, t2658, t2660, t2662;
  double t2663, t2668, t2672, t2674, t2677, t2678, t2681, t2692;
  double t2693, t2696, t2707, t2709, t2712, t2714, t2716, t2718;
  double t2720, t2722, t2724, t2726, t2727, t2728, t2730, t2731;
  double t2734, t2736, t2737, t2739, t2741, t2743, t2744, t2748;
  double t2750, t2752, t2753, t2754, t2756, t2758, t2759, t2761;
  double t2763, t2764, t2767, t2768, t2770, t2771, t2774, t2776;
  double t2779, t2784, t2785, t2787, t2790, t2791, t2794, t2795;
  double t2798, t2799, t2802, t2803, t2804, t2805, t2806, t2807;
  double t2810, t2812, t2813, t2814, t2815, t2817, t2818, t2820;
  double t2822, t2824, t2825, t2827, t2828, t2830, t2834, t2835;
  double t2836, t2837, t2838, t2839, t2840, t2841, t2842, t2843;
  double t2844, tv3rho31, t2845, t2847, t2849, t2852, t2857, t2862;
  double t2866, t2867, t2872, t2875, t2879, t2881, t2882, t2884;
  double t2885, t2886, t2888, t2889, t2894, t2895, t2899, t2909;
  double t2915, t2917, t2919, t2920, t2922, t2923, t2925, t2927;
  double t2928, t2930, t2931, t2933, t2934, t2936, t2938, t2940;
  double t2944, t2946, t2947, t2950, t2951, t2953, t2957, t2959;
  double t2960, t2963, t2964, t2967, t2968, t2969, t2971, t2972;
  double t2973, t2975, t2977, t2978, t2979, t2981, t2983, t2984;
  double t2986, t2988, t2990, t2992, t2993, t2994, t2996, t2997;
  double t2998, t3000, t3001, t3002, t3004, t3005, t3006, t3008;
  double t3009, t3010, t3014, t3016, t3017, t3020, t3021, t3023;
  double t3025, t3027, t3028, t3031, t3032, t3034, t3036, t3037;
  double t3038, t3039, t3041, t3043, t3045, t3046, t3047, t3049;
  double t3051, t3053, t3055, t3057, t3059, t3061, t3063, t3064;
  double t3066, t3067, t3069, t3071, t3073, t3074, t3076, t3079;
  double t3081, t3086, t3087, t3091, t3094, t3095, t3098, t3099;
  double t3102, t3103, t3106, t3107, t3108, t3110, t3111, t3113;
  double t3114, t3115, t3116, t3118, t3119, t3120, t3122, t3123;
  double t3125, t3127, t3128, t3131, t3132, t3134, t3135, t3136;
  double t3137, t3138, t3139, t3141, t3142, t3143, t3145, t3146;
  double t3147, t3149, t3150, t3151, t3153, t3154, t3156, t3157;
  double t3159, t3160, t3162, t3163, t3164, t3166, t3167, t3168;
  double t3170, t3174, tv3rho32, t3175, t3176, t3177, t3178, t3179;
  double t3180, t3181, t3182, t3187, t3188, t3192, t3193, t3198;
  double t3202, t3204, t3211, t3216, t3218, t3227, t3229, t3231;
  double t3232, t3234, t3235, t3236, t3237, t3238, t3239, t3240;
  double t3242, t3243, t3245, t3246, t3247, t3249, t3250, t3252;
  double t3253, t3255, t3257, t3259, t3261, t3262, t3263, t3265;
  double t3266, t3268, t3269, t3270, t3272, t3273, t3274, t3276;
  double t3283, t3286, t3287, t3290, t3291, t3294, t3295, t3296;
  double t3297, t3298, t3299, t3300, t3301, t3302, t3303, t3304;
  double t3305, t3306, t3307, t3308, t3309, t3310, t3311, t3312;
  double t3313, t3314, t3315, t3317, t3318, t3319, t3324, t3325;
  double t3329, t3334, t3335, t3338, t3340, t3341, t3342, t3344;
  double t3345, t3346, t3348, t3349, t3350, t3351, t3352, t3353;
  double t3354, t3355, t3356, t3357, t3358, t3359, t3360, t3362;
  double t3363, t3364, t3365, t3366, t3367, t3369, t3370, t3372;
  double t3373, t3374, t3375, t3376, t3377, t3378, t3379, t3380;
  double t3381, t3382, tv3rho33, t3399, t3400, t3401, t3402, t3403;
  double t3404, t3405, t3406, t3407, t3408, t3409, t3410, t3411;
  double t3412, t3413, t3414, t3415, t3416, t3417, t3418, t3419;
  double t3420, t3421, t3422, t3423, t3424, t3425, t3426, t3427;
  double t3428, t3430, t3431, t3432, t3433, t3434, t3435, t3436;
  double t3437, t3438, t3440, t3441, t3442, t3444, t3445, t3446;
  double t3447, t3448, t3449, t3450, t3451, t3452, t3453, t3454;
  double t3455, t3456, t3457, t3458, t3459, t3460, t3461, t3462;
  double t3463, t3464, t3465, t3466, t3467, t3468, t3469, t3470;
  double t3471, t3472, t3473, t3474, t3475, t3476, t3477, t3478;
  double t3479, t3480, t3481, t3482, t3483, t3485, t3486, t3487;
  double t3488, t3489, t3490, t3491, t3492, t3493, t3494, t3495;
  double t3496, t3497, t3498, t3499, t3500, t3501, t3502, t3503;
  double t3504, t3505, t3506, t3507, t3508, t3509, t3510, t3511;
  double t3512, t3513, t3514, t3515, t3516, t3517, t3518, t3519;
  double t3520, t3521, t3522, t3523, t3525, t3526, t3527, t3528;
  double t3529, t3530, t3531, t3533, t3537, t3540, t3541, t3542;
  double t3544, t3545, t3549, t3550, t3551, t3552, t3553, t3554;
  double t3555, t3556, t3557, t3558, t3559, t3560, t3561, t3562;
  double t3563, t3564, t3565, t3566, t3567, t3568, t3569, t3570;
  double t3571, t3573, t3574, t3575, t3576, t3577, t3578, t3579;
  double t3580, t3581, t3582, t3584, t3585, t3586, t3588, t3589;
  double t3590, tv3rho2sigma0, t3596, t3597, t3598, t3599, t3600, t3601;
  double t3602, t3603, t3604, t3605, t3606, t3607, t3608, t3609;
  double t3610, t3611, t3612, t3613, t3620, t3621, t3622, t3623;
  double t3624, t3625, t3626, t3627, t3628, t3629, t3630, t3631;
  double t3633, t3634, t3635, t3636, t3637, t3638, t3639, t3640;
  double t3641, t3642, t3643, t3644, t3645, t3646, t3647, t3648;
  double t3649, t3650, t3651, t3652, t3653, t3654, t3655, t3656;
  double t3657, t3658, t3664, t3665, t3667, t3672, tv3rho2sigma1, tv3rho2sigma2;
  double t3678, t3680, t3681, t3683, t3684, t3686, t3687, t3688;
  double t3690, t3691, t3693, t3694, t3696, t3698, t3699, t3701;
  double t3702, t3703, t3705, t3707, t3709, t3711, t3712, t3714;
  double t3716, t3718, t3720, t3721, t3723, t3726, t3728, t3730;
  double t3732, t3734, t3735, t3736, t3738, t3739, t3741, t3742;
  double t3744, t3745, t3746, t3748, t3749, t3751, t3755, t3756;
  double t3757, t3760, t3762, t3763, t3765, t3766, t3767, t3769;
  double t3771, t3772, t3774, t3775, t3777, t3778, t3782, t3787;
  double t3788, t3790, t3791, t3792, t3794, t3795, t3796, t3797;
  double t3799, t3801, t3802, t3804, t3806, t3807, t3808, t3810;
  double t3811, t3812, t3814, t3815, t3817, t3819, t3821, t3824;
  double t3825, t3827, t3828, t3829, t3831, t3832, t3833, t3836;
  double t3837, t3838, t3840, t3842, t3844, t3846, t3853, t3854;
  double t3855, t3857, t3858, t3859, t3861, t3863, t3864, t3865;
  double t3867, t3868, t3869, t3870, t3872, t3874, t3878, t3879;
  double tv3rho2sigma3, t3880, t3881, t3882, t3883, t3884, t3885, t3886;
  double t3887, t3888, t3889, t3890, t3891, t3892, t3893, t3894;
  double t3895, t3896, t3897, t3898, t3899, t3900, t3901, t3902;
  double t3903, t3904, t3905, t3906, t3907, t3908, t3909, t3910;
  double t3911, t3912, t3913, t3915, t3916, t3917, t3918, t3922;
  double t3924, t3925, t3926, t3927, t3928, t3929, t3930, t3931;
  double t3932, t3933, t3934, t3935, t3936, t3937, t3938, t3939;
  double t3940, t3941, t3942, t3943, t3944, t3945, t3946, t3947;
  double t3951, tv3rho2sigma4, tv3rho2sigma5, t3952, t3953, t3954, t3955, t3957;
  double t3958, t3960, t3961, t3962, t3964, t3965, t3966, t3967;
  double t3968, t3969, t3970, t3971, t3972, t3973, t3974, t3975;
  double t3976, t3977, t3978, t3979, t3980, t3981, t3982, t3983;
  double t3984, t3985, t3986, t3987, t3988, t3989, t3990, t3991;
  double t3992, t3993, t3994, t3995, t3996, t3997, t3998, t4000;
  double t4001, t4002, t4003, t4004, t4005, t4006, t4007, t4008;
  double t4009, t4010, t4011, t4012, t4013, t4014, t4015, t4016;
  double t4017, t4018, t4019, t4020, t4021, t4022, t4023, t4024;
  double t4025, t4026, t4027, t4028, t4029, t4030, t4031, t4032;
  double t4034, t4036, t4038, t4040, t4041, t4042, t4044, t4045;
  double t4046, t4047, t4048, t4049, t4050, t4051, t4052, tv3rho2sigma6;
  double t4058, t4059, t4066, t4067, t4068, t4069, t4070, t4071;
  double t4072, t4073, t4074, t4075, t4076, t4077, t4078, t4079;
  double t4080, t4081, t4082, t4083, t4084, t4085, t4086, t4087;
  double t4088, t4089, t4091, t4092, t4093, t4094, t4095, t4096;
  double t4097, t4098, t4099, t4100, t4101, t4102, t4103, t4104;
  double t4105, t4106, t4107, t4108, t4109, t4110, t4111, t4112;
  double t4113, tv3rho2sigma7, tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4;
  double tv3rho2lapl5, t4129, t4130, t4131, t4132, t4133, t4134, t4135;
  double t4136, t4138, t4139, t4140, t4141, t4142, t4143, t4145;
  double t4146, t4147, t4149, t4150, t4151, t4153, t4154, t4155;
  double t4156, t4157, t4158, t4159, t4160, t4161, t4163, t4164;
  double t4165, t4166, t4167, t4168, t4169, t4170, t4171, t4172;
  double t4173, t4174, t4175, t4176, t4177, t4178, t4179, t4180;
  double t4181, t4182, t4183, t4184, t4185, t4186, t4187, t4188;
  double t4189, t4190, t4191, t4192, t4193, t4194, t4195, t4196;
  double t4197, t4199, t4200, t4201, t4203, t4204, t4205, t4206;
  double t4207, t4208, t4209, t4210, t4211, t4212, t4213, t4214;
  double t4215, t4216, t4217, t4218, t4219, t4220, t4222, t4223;
  double t4224, t4225, t4226, t4227, t4228, t4229, t4230, t4231;
  double t4232, t4233, t4234, t4235, t4236, t4237, t4238, t4239;
  double t4240, t4241, t4242, t4243, t4244, t4245, t4246, t4247;
  double t4248, t4249, t4250, t4251, t4252, t4253, t4254, t4255;
  double t4256, t4257, t4258, t4259, t4260, t4261, t4262, t4263;
  double t4264, t4265, t4266, t4267, t4268, t4269, t4270, t4271;
  double t4272, t4273, t4274, t4275, t4276, t4277, t4278, t4279;
  double t4280, t4281, t4282, t4283, t4284, t4285, t4286, t4288;
  double t4289, t4290, t4291, t4292, t4293, t4294, t4295, t4296;
  double t4297, t4298, t4299, t4300, t4301, t4302, t4303, t4304;
  double t4305, t4306, t4307, t4308, t4309, t4310, t4311, t4312;
  double t4313, t4314, t4316, t4317, t4318, t4319, t4320, t4321;
  double t4323, t4324, t4325, t4326, t4327, t4328, t4329, t4330;
  double t4331, t4332, t4333, t4334, t4335, t4336, t4337, t4338;
  double t4339, t4340, t4341, t4342, t4343, t4344, t4345, t4346;
  double t4347, t4348, t4349, t4350, t4351, t4352, t4353, t4354;
  double t4355, t4356, t4357, t4358, t4359, t4360, t4361, t4362;
  double t4363, t4364, t4365, t4366, t4367, t4368, t4369, t4370;
  double t4371, t4372, t4373, t4374, t4375, t4376, t4377, t4378;
  double t4379, t4380, t4381, t4382, t4383, t4384, t4385, t4386;
  double t4387, t4388, t4389, t4390, t4391, t4392, t4393, t4394;
  double t4395, t4396, t4397, t4398, t4399, t4400, t4401, t4402;
  double t4403, t4404, t4405, t4406, t4407, t4408, t4409, t4410;
  double t4411, t4412, t4413, t4414, t4415, t4416, t4417, t4418;
  double t4419, t4420, t4421, t4422, t4423, t4424, t4425, t4426;
  double t4427, t4430, t4433, t4436, t4440, t4441, t4448, t4451;
  double t4453, t4457, t4460, t4464, t4468, t4474, t4478, t4481;
  double t4485, t4486, t4487, t4488, t4489, t4490, t4491, t4492;
  double t4493, t4494, t4495, t4496, t4497, t4498, t4518, t4520;
  double t4523, tv3rho2tau0, t4524, t4525, t4526, t4527, t4528, t4530;
  double t4533, t4534, t4535, t4536, t4537, t4538, t4542, t4554;
  double t4558, t4559, t4562, t4563, t4567, t4571, t4572, t4573;
  double t4574, t4575, t4576, t4577, t4578, t4579, t4580, t4581;
  double t4582, t4583, t4584, t4585, t4586, t4587, t4588, t4589;
  double t4591, t4592, t4594, t4595, t4596, t4597, t4598, t4599;
  double t4600, t4601, t4602, t4603, t4604, t4605, t4606, t4607;
  double t4608, t4609, t4610, t4611, t4612, t4613, t4614, t4615;
  double t4616, t4617, t4618, t4619, t4620, t4621, t4622, t4623;
  double t4624, t4625, t4626, t4627, t4628, t4629, t4630, t4631;
  double t4632, t4633, t4634, t4635, t4636, t4637, t4638, t4639;
  double t4640, t4641, t4642, t4643, t4644, t4645, t4646, t4647;
  double t4648, t4649, t4650, t4652, t4653, t4655, t4656, t4657;
  double t4658, t4659, t4660, t4661, t4662, t4664, t4665, t4666;
  double t4667, t4668, t4669, t4670, t4671, t4672, t4673, t4674;
  double t4675, t4676, t4677, t4678, t4679, t4680, t4681, t4682;
  double t4683, t4684, t4685, t4686, t4687, t4688, t4689, t4690;
  double t4691, t4692, t4693, t4694, t4695, t4696, t4697, t4698;
  double t4699, t4700, t4701, t4702, t4703, t4704, t4705, t4706;
  double t4707, t4708, t4709, t4710, t4711, t4713, t4714, t4715;
  double t4716, t4717, t4718, t4719, t4720, t4721, t4722, t4723;
  double t4724, t4725, t4726, t4727, t4728, t4729, t4730, t4731;
  double t4732, t4733, t4734, t4735, t4736, t4737, t4738, t4739;
  double t4740, t4741, t4742, t4743, t4745, t4746, t4747, t4749;
  double t4750, t4751, t4753, t4754, t4755, t4756, t4757, t4758;
  double t4759, t4760, t4761, t4762, t4763, t4764, t4765, t4766;
  double t4783, t4785, tv3rho2tau1, t4787, t4788, t4789, t4791, t4792;
  double t4794, t4795, t4797, t4798, t4801, t4802, t4805, t4806;
  double t4808, t4809, t4810, t4813, t4814, t4817, t4818, t4820;
  double t4821, t4822, t4824, t4826, t4828, t4829, t4831, t4833;
  double t4834, t4835, t4836, t4838, t4839, t4840, t4841, t4843;
  double t4844, t4845, t4846, t4848, t4849, t4851, t4852, t4853;
  double t4855, t4856, t4857, t4859, t4860, t4861, t4863, t4864;
  double t4865, t4867, t4868, t4869, t4870, t4872, t4873, t4875;
  double t4876, t4878, t4880, t4881, t4883, t4884, t4885, t4887;
  double t4888, t4890, t4891, t4893, t4894, t4896, t4898, t4899;
  double t4900, t4901, t4903, t4904, t4905, t4907, t4908, t4909;
  double t4911, t4912, t4913, t4914, t4915, t4917, t4918, t4919;
  double t4921, t4922, t4924, t4925, t4926, t4928, t4929, t4930;
  double t4931, t4932, t4934, t4935, t4936, t4937, t4939, t4941;
  double t4942, t4943, t4944, t4946, t4948, t4950, t4951, t4954;
  double t4955, t4956, t4957, t4959, t4960, t4961, t4962, t4963;
  double t4965, t4967, t4969, t4970, t4971, t4973, t4975, t4976;
  double t4977, t4978, t4980, t4983, t4984, t4985, t4987, t4988;
  double t4989, t4991, t4993, t4995, t4996, t4998, t4999, t5000;
  double t5007, t5012, t5013, t5014, t5015, t5017, t5018, t5020;
  double t5021, t5023, t5024, t5025, t5027, t5028, t5030, t5034;
  double t5037, t5038, t5039, t5042, t5044, t5049, t5050, t5056;
  double t5059, t5061, t5063, t5069, t5072, t5076, t5082, t5083;
  double t5086, t5089, t5090, t5091, t5092, t5093, t5095, t5096;
  double t5098, t5100, t5101, t5102, t5104, t5105, t5106, t5108;
  double t5109, t5110, t5114, t5115, t5116, t5117, t5118, t5120;
  double t5121, t5122, t5123, t5125, t5126, t5129, t5132, t5135;
  double t5138, t5140, t5141, t5143, t5144, t5145, t5148, t5149;
  double t5152, t5153, t5155, t5157, t5159, t5161, t5162, t5165;
  double t5166, t5168, t5169, t5171, t5173, t5174, t5175, t5176;
  double t5177, t5178, t5180, t5182, t5183, t5185, t5186, t5191;
  double t5192, tv3rho2tau2, t5193, t5194, t5195, t5196, t5197, t5198;
  double t5200, t5202, t5203, t5205, t5207, t5209, t5211, t5213;
  double t5215, t5217, t5219, t5220, t5221, t5223, t5224, t5226;
  double t5227, t5228, t5230, t5232, t5233, t5235, t5237, t5240;
  double t5243, t5246, t5249, t5251, t5252, t5253, t5256, t5257;
  double t5259, t5260, t5261, t5262, t5264, t5265, t5267, t5268;
  double t5269, t5271, t5273, t5275, t5277, t5278, t5279, t5280;
  double t5283, t5286, t5288, t5289, t5292, t5293, t5296, t5297;
  double t5299, t5300, t5301, t5304, t5305, t5308, t5309, t5311;
  double t5312, t5313, t5315, t5316, t5319, t5323, t5326, t5327;
  double t5333, t5334, t5342, t5344, t5350, t5351, t5354, t5355;
  double t5358, t5359, t5366, t5373, t5374, t5380, t5382, t5384;
  double t5386, t5388, t5391, t5393, t5396, t5399, t5402, t5405;
  double t5408, t5411, t5413, t5414, t5415, t5416, t5418, t5419;
  double t5420, t5421, t5423, t5424, t5425, t5427, t5428, t5429;
  double t5430, t5432, t5433, t5434, t5435, t5437, t5438, t5440;
  double t5442, t5444, t5445, t5446, t5452, t5453, t5455, t5456;
  double t5458, t5459, t5461, t5462, t5463, t5464, t5466, t5467;
  double t5469, t5470, t5472, t5474, t5475, t5476, t5477, t5479;
  double t5481, t5482, t5484, t5485, t5486, t5488, t5489, t5490;
  double t5492, t5493, t5494, t5495, t5497, t5499, t5500, t5501;
  double t5503, t5504, t5506, t5507, t5510, t5512, t5513, t5515;
  double t5516, t5518, t5519, t5520, t5522, t5524, t5526, t5527;
  double t5528, t5530, t5532, t5533, t5534, t5536, t5537, t5538;
  double t5540, t5541, t5542, t5544, t5545, t5546, t5548, t5550;
  double t5551, t5552, t5553, t5555, t5556, t5557, t5559, t5560;
  double t5561, t5562, t5564, t5569, tv3rho2tau3, t5570, t5571, t5572;
  double t5573, t5574, t5575, t5576, t5577, t5578, t5579, t5580;
  double t5581, t5582, t5583, t5584, t5585, t5586, t5587, t5589;
  double t5590, t5591, t5593, t5594, t5595, t5597, t5598, t5599;
  double t5600, t5601, t5602, t5603, t5605, t5606, t5607, t5608;
  double t5609, t5610, t5611, t5612, t5613, t5614, t5615, t5616;
  double t5617, t5618, t5619, t5620, t5621, t5622, t5623, t5624;
  double t5625, t5626, t5627, t5628, t5629, t5630, t5631, t5632;
  double t5633, t5634, t5635, t5636, t5637, t5638, t5639, t5640;
  double t5641, t5642, t5643, t5644, t5645, t5646, t5647, t5648;
  double t5649, t5651, t5652, t5653, t5654, t5656, t5657, t5658;
  double t5660, t5661, t5662, t5664, t5665, t5666, t5667, t5668;
  double t5669, t5670, t5672, t5673, t5675, t5676, t5678, t5679;
  double t5680, t5681, t5682, t5683, t5684, t5685, t5686, t5687;
  double t5690, t5693, t5694, t5697, t5701, t5704, t5705, t5708;
  double t5709, t5712, t5716, t5723, t5724, t5725, t5726, t5727;
  double t5728, t5729, t5730, t5731, t5732, t5733, t5734, t5735;
  double t5736, t5737, t5738, t5739, t5740, t5741, t5742, t5743;
  double t5744, t5745, t5746, t5747, t5748, t5749, t5750, t5751;
  double t5752, t5753, t5754, t5755, t5756, t5757, t5758, t5759;
  double t5760, t5761, t5762, t5763, t5764, t5765, t5766, t5767;
  double t5768, t5769, t5770, t5771, t5772, t5773, t5774, t5775;
  double t5776, t5777, t5778, t5779, t5780, t5781, t5782, t5783;
  double t5784, tv3rho2tau4, t5803, t5804, t5805, t5806, t5808, t5809;
  double t5810, t5811, t5812, t5814, t5815, t5816, t5818, t5819;
  double t5820, t5821, t5822, t5823, t5824, t5826, t5827, t5829;
  double t5830, t5831, t5832, t5833, t5834, t5835, t5836, t5837;
  double t5838, t5839, t5840, t5841, t5842, t5843, t5844, t5845;
  double t5846, t5847, t5848, t5849, t5850, t5851, t5852, t5853;
  double t5854, t5855, t5856, t5857, t5858, t5860, t5861, t5862;
  double t5863, t5864, t5865, t5866, t5867, t5869, t5870, t5871;
  double t5872, t5873, t5874, t5875, t5876, t5877, t5878, t5879;
  double t5880, t5881, t5882, t5883, t5884, t5885, t5886, t5887;
  double t5888, t5889, t5890, t5891, t5892, t5893, t5894, t5895;
  double t5896, t5897, t5898, t5899, t5900, t5901, t5903, t5904;
  double t5905, t5907, t5908, t5909, t5911, t5912, t5913, t5914;
  double t5916, t5917, t5918, t5919, t5920, t5921, t5922, t5923;
  double t5924, t5925, t5926, t5927, t5928, t5929, t5930, t5931;
  double t5932, t5933, t5934, t5935, t5936, t5937, t5938, t5939;
  double t5940, t5941, t5942, t5943, t5944, t5945, t5946, t5947;
  double t5948, t5949, t5950, t5951, t5952, t5953, t5954, t5955;
  double t5956, t5958, t5959, t5960, t5961, t5962, t5963, t5964;
  double t5965, t5966, t5967, t5968, t5969, t5971, t5972, t5973;
  double t5975, t5976, t5977, t5978, t5979, t5980, t5981, t5982;
  double t5984, t5985, t5988, t5991, t5999, t6000, t6003, t6004;
  double t6008, t6009, t6012, t6015, t6021, t6022, t6027, t6033;
  double t6034, t6035, t6036, t6037, t6038, t6039, t6040, t6041;
  double t6042, t6043, t6044, t6045, t6046, t6047, t6048, t6049;
  double t6050, t6051, t6053, t6054, t6056, t6057, t6059, t6060;
  double t6061, t6062, t6063, t6064, t6065, t6088, tv3rho2tau5, t6090;
  double t6091, t6092, t6093, t6094, t6095, t6096, t6097, t6098;
  double t6099, t6100, t6101, t6102, t6104, t6105, t6106, t6107;
  double t6108, t6109, t6110, t6111, t6112, t6113, t6114, t6115;
  double t6116, t6117, t6118, t6119, t6120, t6121, t6122, t6123;
  double t6124, t6125, t6126, t6128, t6129, t6130, t6132, t6133;
  double t6135, t6136, t6137, t6139, t6140, t6141, t6142, t6143;
  double t6144, t6145, t6146, t6148, t6149, t6150, t6151, t6152;
  double t6154, t6155, t6156, t6157, t6158, t6159, t6160, t6161;
  double t6162, t6163, t6165, t6166, t6167, t6168, t6172, t6175;
  double t6176, t6177, t6178, t6179, t6180, tv3rhosigma20, t6182, t6183;
  double t6184, t6185, t6186, t6187, t6188, t6189, t6190, t6191;
  double t6192, t6193, t6194, t6195, t6196, t6197, t6198, t6199;
  double t6200, t6203, t6204, t6205, t6206, t6207, tv3rhosigma21, tv3rhosigma22;
  double t6209, t6210, t6211, t6212, t6213, t6214, t6215, t6216;
  double t6217, t6218, t6219, t6220, t6221, t6222, t6223, t6224;
  double t6225, t6226, t6227, t6230, t6231, t6232, t6233, t6234;
  double tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, t6236, t6237, t6238, t6239, t6240;
  double t6241, t6242, t6243, t6244, t6245, t6246, t6247, t6248;
  double t6249, t6250, t6251, t6253, t6254, t6255, t6257, t6258;
  double t6260, t6261, t6262, t6263, t6264, t6265, t6266, t6268;
  double t6269, t6270, t6271, t6272, t6273, t6274, t6275, t6277;
  double t6279, t6281, t6282, t6283, t6284, tv3rhosigma26, t6286, t6287;
  double t6288, t6289, t6290, t6291, t6292, t6293, t6294, t6295;
  double t6296, t6297, t6300, t6301, t6302, t6303, tv3rhosigma27, tv3rhosigma28;
  double t6305, t6306, t6307, t6308, t6309, t6310, t6311, t6312;
  double t6313, t6314, t6315, t6316, t6319, t6320, t6321, t6322;
  double tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4;
  double tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t6324;
  double t6325, t6326, t6327, t6328, t6329, t6330, t6331, t6332;
  double t6333, t6334, t6335, t6336, t6337, t6338, t6339, t6340;
  double t6341, t6342, t6343, t6344, t6345, t6346, t6347, t6348;
  double t6349, t6350, t6351, t6352, t6353, t6354, t6355, t6356;
  double t6357, t6358, t6359, t6360, t6361, t6362, t6363, t6364;
  double t6365, t6366, t6367, t6368, t6369, t6370, t6371, t6372;
  double t6373, t6374, t6375, t6376, t6377, t6378, t6379, t6380;
  double t6381, t6382, t6383, t6384, t6385, t6386, t6387, t6388;
  double t6389, t6390, t6391, t6392, t6393, t6394, t6395, t6396;
  double t6397, t6398, t6399, t6400, t6401, t6402, t6403, t6404;
  double t6405, t6406, t6407, t6408, t6409, t6410, t6411, t6412;
  double t6413, t6414, t6415, t6416, t6417, t6418, t6420, t6421;
  double t6422, t6423, t6424, t6425, t6426, t6427, t6428, t6429;
  double t6430, t6431, t6432, t6433, t6435, t6436, t6438, t6441;
  double t6442, t6443, t6445, t6446, t6449, t6451, t6452, t6454;
  double t6456, t6457, t6458, t6459, t6460, t6461, t6462, t6463;
  double t6464, t6465, t6466, t6467, t6468, t6469, t6470, t6471;
  double t6472, t6473, t6474, t6475, t6476, t6477, t6478, t6479;
  double t6480, t6481, t6482, t6483, t6484, t6485, t6486, t6487;
  double t6488, t6489, t6490, t6491, t6492, t6493, t6494, t6495;
  double t6496, t6497, t6498, t6499, t6500, t6501, t6502, t6503;
  double t6504, t6505, t6506, t6507, t6508, t6509, t6510, t6511;
  double t6512, t6513, t6514, t6515, t6516, t6517, t6518, t6519;
  double t6520, t6521, t6522, t6523, t6524, t6525, t6526, t6527;
  double t6528, t6529, t6530, t6531, t6532, t6533, t6534, t6535;
  double tv3rhosigmatau0, t6539, t6540, t6541, t6542, t6543, t6544, t6545;
  double t6546, t6547, t6548, t6549, t6550, t6551, t6552, t6553;
  double t6554, t6555, t6556, t6557, t6558, t6559, t6560, t6561;
  double t6562, t6563, t6564, t6565, t6566, t6567, t6568, t6569;
  double t6571, t6572, t6573, t6574, t6575, t6576, t6577, t6578;
  double t6579, t6580, t6581, t6582, t6583, t6584, t6585, t6586;
  double t6587, t6588, t6589, t6590, t6591, t6592, t6593, t6594;
  double t6595, t6596, t6597, t6598, t6599, t6600, t6601, t6602;
  double t6603, t6604, t6605, t6607, t6608, t6609, t6610, t6611;
  double t6612, t6613, t6614, t6615, t6616, t6617, t6618, t6619;
  double t6620, t6621, t6622, t6623, t6624, t6625, t6626, t6627;
  double t6628, t6630, t6631, t6632, t6633, t6635, t6636, t6637;
  double t6638, t6639, t6640, t6641, t6642, t6643, t6644, t6645;
  double t6646, t6647, t6649, t6650, t6651, t6652, t6653, t6654;
  double t6655, t6656, t6658, t6659, t6661, t6662, t6663, t6664;
  double t6665, t6667, t6669, t6670, t6672, t6673, t6676, t6678;
  double t6680, t6681, t6682, t6683, t6684, t6685, t6686, t6687;
  double t6688, t6689, tv3rhosigmatau1, t6693, t6697, t6701, t6702, t6703;
  double t6704, t6705, t6706, t6707, t6708, t6709, t6710, t6711;
  double t6712, t6713, t6714, t6715, t6716, t6717, t6718, t6719;
  double t6720, t6721, t6722, t6723, t6724, t6725, t6726, t6727;
  double t6728, t6730, t6731, t6732, t6733, t6734, t6735, t6736;
  double t6737, t6738, t6739, t6740, t6741, t6742, t6743, t6744;
  double t6745, t6746, t6747, t6748, t6749, t6750, t6751, t6752;
  double t6753, t6754, t6755, t6756, tv3rhosigmatau2, t6760, t6761, t6762;
  double t6763, t6764, t6765, t6766, t6767, t6768, t6769, t6771;
  double t6772, t6773, t6774, t6775, t6776, t6777, t6778, t6779;
  double t6780, t6781, t6782, t6784, t6785, t6786, t6787, t6788;
  double t6789, t6790, t6791, t6792, t6793, t6794, t6795, t6796;
  double t6797, t6798, t6799, t6800, t6801, t6802, t6803, t6806;
  double t6809, t6810, t6811, t6812, t6813, t6814, tv3rhosigmatau3, tv3rhosigmatau4;
  double tv3rhosigmatau5, t6818, t6819, t6820, t6821, t6822, t6823, t6824;
  double t6825, t6826, t6827, t6828, t6829, t6830, t6831, t6832;
  double t6833, t6834, t6835, t6836, t6837, t6838, t6839, t6840;
  double t6841, t6842, t6843, t6844, t6845, t6846, t6847, t6849;
  double t6850, t6851, t6852, t6853, t6854, t6855, t6856, t6857;
  double t6858, t6859, t6860, t6861, t6862, t6863, t6864, t6865;
  double t6867, t6869, t6870, t6871, t6873, t6874, t6875, t6877;
  double t6878, t6879, t6881, t6882, t6883, t6884, t6885, t6886;
  double t6887, t6888, t6889, t6890, t6891, t6892, t6893, t6894;
  double t6895, t6896, t6897, t6898, t6899, t6900, t6901, t6902;
  double t6903, t6904, t6905, t6906, t6907, t6908, t6909, t6910;
  double t6911, t6912, t6913, t6914, t6915, t6916, t6917, t6919;
  double t6920, t6921, t6922, t6923, t6924, t6925, t6926, t6927;
  double t6928, t6929, t6930, t6931, t6932, tv3rhosigmatau6, t6936, t6937;
  double t6938, t6939, t6940, t6941, t6942, t6943, t6944, t6945;
  double t6946, t6947, t6948, t6949, t6950, t6951, t6952, t6953;
  double t6954, t6955, t6956, t6957, t6958, t6959, t6960, t6961;
  double t6962, t6963, t6964, t6965, t6966, t6967, t6968, t6969;
  double t6970, t6971, t6972, t6973, t6974, t6976, t6977, t6978;
  double t6980, t6981, t6982, t6983, t6984, t6985, t6986, t6987;
  double t6988, t6990, t6991, t6992, t6993, t6994, t6995, t6996;
  double t6997, t6998, t6999, t7000, t7001, t7002, t7003, t7004;
  double t7005, t7006, t7007, t7008, t7009, t7010, t7011, t7012;
  double t7013, t7014, t7015, t7016, t7017, t7018, t7019, t7020;
  double t7021, t7022, t7023, t7024, t7025, t7026, t7027, t7028;
  double t7029, t7030, t7031, t7032, t7033, t7034, t7035, t7036;
  double t7038, t7039, t7041, t7043, t7044, t7045, t7048, t7051;
  double t7053, t7054, t7055, t7056, t7057, t7058, t7059, t7060;
  double t7061, t7062, t7063, t7064, t7065, t7066, t7067, t7068;
  double t7069, t7070, tv3rhosigmatau7, t7074, t7075, t7076, t7077, t7078;
  double t7079, t7080, t7081, t7082, t7083, t7085, t7086, t7087;
  double t7088, t7089, t7090, t7091, t7093, t7094, t7095, t7096;
  double t7097, t7098, t7099, t7100, t7101, t7102, t7103, t7104;
  double t7109, t7110, t7111, t7112, t7113, t7114, tv3rhosigmatau8, t7118;
  double t7119, t7120, t7121, t7122, t7123, t7124, t7125, t7126;
  double t7127, t7128, t7129, t7130, t7131, t7132, t7134, t7141;
  double t7142, t7143, t7144, t7145, t7146, t7147, t7148, t7149;
  double t7150, t7151, t7152, t7153, t7154, t7155, t7156, t7157;
  double t7158, t7159, t7160, t7161, t7162, t7163, t7164, t7165;
  double t7166, t7167, tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22;
  double tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4;
  double tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t7171, t7173, t7174, t7175, t7176;
  double t7177, t7178, t7179, t7180, t7181, t7182, t7183, t7184;
  double t7185, t7186, t7187, t7191, t7192, t7194, t7197, t7201;
  double t7204, t7205, t7208, t7212, t7213, t7214, t7215, t7216;
  double t7217, t7218, t7219, t7220, t7221, t7222, t7223, t7224;
  double t7225, t7226, t7227, t7228, t7229, t7230, t7231, t7232;
  double t7233, t7234, t7235, t7236, t7237, t7238, t7239, t7240;
  double t7241, t7243, t7244, t7245, t7246, t7247, t7248, t7249;
  double t7250, t7251, t7252, t7253, t7254, t7255, t7256, t7257;
  double t7258, t7259, t7260, t7261, t7262, t7263, t7264, t7265;
  double t7266, t7267, t7268, t7269, t7270, t7271, t7272, t7273;
  double t7274, t7275, t7276, t7277, t7278, t7279, t7280, t7281;
  double t7282, t7283, t7284, t7285, t7286, t7287, t7288, t7289;
  double t7290, t7291, t7292, t7293, t7294, t7295, t7296, t7297;
  double t7298, t7299, t7300, t7301, t7302, t7303, t7304, t7305;
  double t7306, t7307, t7308, t7309, t7310, t7311, t7312, t7313;
  double t7314, t7315, t7316, t7317, t7318, t7319, t7320, t7321;
  double t7322, t7323, t7324, t7325, t7326, t7327, t7328, t7329;
  double t7330, t7331, t7332, t7333, t7334, t7335, tv3rhotau20, t7338;
  double t7339, t7340, t7341, t7342, t7343, t7344, t7345, t7346;
  double t7347, t7348, t7349, t7350, t7351, t7352, t7353, t7354;
  double t7355, t7356, t7357, t7358, t7359, t7360, t7361, t7362;
  double t7363, t7364, t7365, t7366, t7367, t7368, t7369, t7370;
  double t7371, t7372, t7373, t7374, t7375, t7376, t7377, t7378;
  double t7379, t7380, t7381, t7382, t7383, t7384, t7385, t7388;
  double t7393, t7396, t7399, t7404, t7411, t7412, t7413, t7414;
  double t7415, t7416, t7417, t7418, t7419, t7421, t7422, t7423;
  double t7424, t7425, t7426, t7427, t7428, t7429, t7430, t7431;
  double t7432, t7433, t7434, t7435, t7436, t7437, t7438, t7439;
  double t7440, t7441, t7442, t7443, t7444, t7445, t7446, t7447;
  double t7448, t7449, t7450, t7451, t7452, t7453, t7454, t7455;
  double t7456, t7457, t7458, t7459, t7460, t7461, t7462, t7463;
  double t7464, t7465, t7466, t7467, t7468, t7469, t7470, t7471;
  double t7472, t7473, t7474, t7475, t7477, t7478, t7479, t7480;
  double t7481, t7482, t7483, t7484, t7485, t7486, t7487, t7488;
  double t7489, t7490, t7491, t7492, t7493, t7494, t7495, t7496;
  double t7497, t7498, t7499, t7500, t7501, t7502, t7503, t7504;
  double t7505, tv3rhotau21, t7508, t7509, t7510, t7511, t7513, t7514;
  double t7515, t7516, t7517, t7518, t7519, t7520, t7522, t7523;
  double t7524, t7525, t7526, t7527, t7529, t7530, t7532, t7533;
  double t7534, t7535, t7536, t7537, t7538, t7539, t7540, t7541;
  double t7543, t7552, t7553, t7556, t7557, t7558, t7559, t7560;
  double t7561, t7562, t7563, t7564, t7565, t7566, t7567, t7568;
  double t7569, t7570, t7571, t7572, t7573, t7574, t7575, t7576;
  double t7577, t7578, t7579, t7580, t7581, t7582, t7583, t7584;
  double t7585, t7586, t7587, t7588, t7589, t7590, t7591, t7592;
  double t7593, t7594, t7595, t7596, t7597, t7598, t7599, t7600;
  double t7601, t7602, t7603, t7604, t7605, t7606, t7607, t7608;
  double t7609, t7610, t7611, t7612, t7613, t7614, t7615, t7616;
  double t7617, t7618, t7619, t7620, t7621, t7622, t7623, t7624;
  double t7625, t7626, t7627, t7628, t7629, tv3rhotau22, t7632, t7633;
  double t7634, t7635, t7636, t7637, t7638, t7639, t7640, t7641;
  double t7642, t7643, t7644, t7645, t7646, t7647, t7648, t7649;
  double t7650, t7651, t7652, t7653, t7654, t7655, t7656, t7657;
  double t7658, t7659, t7660, t7661, t7662, t7663, t7664, t7665;
  double t7666, t7667, t7668, t7669, t7670, t7671, t7672, t7673;
  double t7674, t7675, t7676, t7677, t7678, t7679, t7680, t7681;
  double t7682, t7683, t7684, t7685, t7686, t7687, t7688, t7689;
  double t7690, t7691, t7692, t7693, t7694, t7695, t7696, t7697;
  double t7698, t7699, t7700, t7701, t7702, t7703, t7704, t7705;
  double t7706, t7708, t7711, t7714, t7715, t7718, t7722, t7723;
  double t7724, t7725, tv3rhotau23, t7728, t7729, t7730, t7731, t7732;
  double t7733, t7734, t7735, t7736, t7737, t7738, t7739, t7740;
  double t7741, t7742, t7743, t7744, t7745, t7746, t7747, t7748;
  double t7749, t7750, t7751, t7752, t7753, t7754, t7755, t7756;
  double t7757, t7758, t7759, t7760, t7761, t7762, t7763, t7764;
  double t7765, t7766, t7767, t7768, t7769, t7770, t7771, t7772;
  double t7773, t7774, t7775, t7776, t7777, t7778, t7779, t7780;
  double t7781, t7782, t7783, t7784, t7785, t7786, t7787, t7788;
  double t7789, t7790, t7791, t7792, t7793, t7794, t7795, t7796;
  double t7797, t7798, t7799, t7800, t7801, t7802, t7803, t7804;
  double t7805, t7806, t7807, t7808, t7809, t7810, t7811, t7812;
  double t7813, t7814, t7815, t7816, t7817, t7818, t7821, t7822;
  double t7825, t7828, t7831, t7843, t7844, t7845, t7846, t7847;
  double t7848, t7849, t7850, t7851, t7852, t7853, t7854, t7855;
  double t7856, tv3rhotau24, t7859, t7860, t7861, t7862, t7863, t7864;
  double t7865, t7866, t7867, t7868, t7869, t7871, t7872, t7873;
  double t7874, t7875, t7876, t7877, t7878, t7879, t7880, t7881;
  double t7882, t7883, t7884, t7885, t7886, t7888, t7889, t7890;
  double t7892, t7893, t7894, t7896, t7897, t7898, t7899, t7904;
  double t7909, t7913, t7917, t7918, t7921, t7922, t7923, t7924;
  double t7925, t7926, t7927, t7928, t7929, t7930, t7931, t7932;
  double t7933, t7934, t7935, t7936, t7937, t7938, t7939, t7940;
  double t7941, t7942, t7943, t7944, t7945, t7946, t7947, t7948;
  double t7949, t7950, t7952, t7953, t7955, t7956, t7957, t7958;
  double t7959, t7960, t7961, t7962, t7963, t7964, t7965, t7966;
  double t7967, t7968, t7969, t7970, t7971, t7972, t7973, t7974;
  double t7975, t7976, tv3rhotau25, t7979, t7980, t7981, t7982, t7983;
  double t7984, t7985, t7986, t7987, t7988, t7989, t7990, t7992;
  double t7993, t7994, t7995, t7996, t7997, t7998, t7999, t8002;
  double t8003, t8005, t8006, tv3sigma30, t8008, t8009, t8010, t8011;
  double t8014, t8015, tv3sigma31, tv3sigma32, t8017, t8018, t8019, t8020;
  double t8023, t8024, tv3sigma33, tv3sigma34, tv3sigma35, t8026, t8027, t8028;
  double t8029, t8032, t8033, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39, tv3sigma2lapl0;
  double tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8;
  double tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, t8035, t8036, t8037, t8038, t8039;
  double t8040, t8042, t8043, t8044, t8045, t8046, t8047, t8048;
  double t8049, t8050, t8051, t8052, t8053, t8054, t8055, t8056;
  double t8057, t8058, t8060, t8061, t8062, t8063, t8064, t8065;
  double t8066, t8067, t8068, t8070, t8071, t8072, t8074, t8075;
  double tv3sigma2tau0, t8077, t8078, t8079, t8080, t8081, t8082, t8083;
  double t8084, t8085, t8086, t8087, t8088, t8089, t8090, t8091;
  double t8092, t8093, t8094, t8095, t8096, t8097, t8098, t8099;
  double t8101, t8103, t8105, t8106, tv3sigma2tau1, t8108, t8109, t8110;
  double t8111, t8112, t8113, t8114, t8115, t8118, t8119, tv3sigma2tau2;
  double t8121, t8122, t8123, t8124, t8125, t8126, t8127, t8128;
  double t8131, t8132, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, t8134, t8135, t8136;
  double t8137, t8138, t8139, t8140, t8141, t8144, t8145, tv3sigma2tau6;
  double t8147, t8148, t8149, t8150, t8151, t8152, t8153, t8154;
  double t8157, t8158, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, tv3sigmalapl20;
  double tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, t8160, t8161, t8162, t8163;
  double t8164, t8165, t8166, t8167, t8168, t8169, t8170, t8171;
  double t8172, t8173, t8174, t8175, t8176, t8177, t8179, t8180;
  double t8181, t8182, t8183, t8184, t8185, t8186, t8187, t8188;
  double t8189, t8190, t8191, t8192, t8193, t8194, t8195, t8196;
  double t8197, t8198, t8199, t8200, t8201, t8202, t8203, t8204;
  double t8206, t8207, t8208, t8210, t8211, t8212, tv3sigmatau20, t8213;
  double t8214, t8215, t8216, t8217, t8218, t8219, t8220, t8221;
  double t8222, t8223, t8224, t8225, t8226, t8227, t8228, t8229;
  double t8230, t8231, t8232, t8234, t8235, t8236, t8237, t8238;
  double t8239, t8240, t8241, t8242, t8243, t8245, t8246, t8247;
  double t8248, t8249, t8250, t8251, t8252, t8253, t8254, t8256;
  double t8257, t8259, t8260, t8261, tv3sigmatau21, t8262, t8263, t8264;
  double t8265, t8266, t8267, t8268, t8269, t8270, t8271, t8272;
  double t8273, t8274, t8275, t8276, t8277, t8278, t8279, t8280;
  double t8281, t8282, t8283, t8284, t8285, t8286, t8287, t8288;
  double t8289, t8290, t8291, t8292, t8293, t8294, t8295, t8296;
  double t8298, t8300, t8302, t8303, t8304, tv3sigmatau22, t8305, t8306;
  double t8307, t8308, t8309, t8310, t8311, t8312, t8313, t8314;
  double t8315, t8318, t8319, t8320, tv3sigmatau23, t8321, t8322, t8323;
  double t8324, t8325, t8326, t8327, t8328, t8329, t8330, t8331;
  double t8334, t8335, t8336, tv3sigmatau24, t8337, t8338, t8339, t8340;
  double t8341, t8342, t8343, t8344, t8345, t8346, t8347, t8350;
  double t8351, t8352, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, tv3lapl30, tv3lapl31;
  double tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5;
  double tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, t8353, t8354;
  double t8355, t8356, t8357, t8358, t8359, t8361, t8362, t8363;
  double t8364, t8365, t8367, t8368, t8369, t8370, t8372, t8373;
  double t8375, t8377, t8378, t8379, t8380, t8381, t8383, t8384;
  double t8385, t8386, t8388, t8389, t8390, t8391, t8393, t8399;
  double t8400, tv3tau30, t8403, t8404, t8406, t8408, t8410, t8411;
  double t8413, t8414, t8415, t8416, t8418, t8419, t8420, t8422;
  double t8423, t8424, t8426, t8429, t8430, t8431, t8434, t8435;
  double tv3tau31, t8437, t8438, t8439, t8441, t8442, t8444, t8445;
  double t8446, t8448, t8450, t8451, t8453, t8454, t8455, t8457;
  double t8458, t8459, t8461, t8462, t8463, t8464, t8466, t8467;
  double t8471, t8472, t8473, t8474, t8477, t8478, tv3tau32, t8480;
  double t8481, t8482, t8483, t8484, t8485, t8486, t8488, t8489;
  double t8490, t8492, t8493, t8495, t8496, t8498, t8500, t8501;
  double t8502, t8503, t8504, t8506, t8507, t8508, t8509, t8511;
  double t8512, t8513, t8514, t8516, t8519, t8522, t8523, tv3tau33;

  double t8539, t8556, t8559, t8560, t8563, t8566, t8569, t8573;
  double t8575, t8579, t8583, t8586, t8587, t8591, t8592, t8594;
  double t8596, t8598, t8601, t8602, t8606, t8607, t8609, t8610;
  double t8611, t8612, t8614, t8620, t8624, t8625, t8630, t8634;
  double t8638, t8639, t8644, t8649, t8650, t8652, t8654, t8659;
  double t8663, t8667, t8669, t8671, t8674, t8677, t8678, t8682;
  double t8683, t8686, t8690, t8693, t8700, t8717, t8721, t8722;
  double t8724, t8725, t8739, t8741, t8743, t8744, t8746, t8747;
  double t8749, t8750, t8752, t8755, t8757, t8759, t8761, t8764;
  double t8766, t8773, t8831, t8835, t8838, t8842, t8845, t8862;
  double t8901, t8902, t8905, t8909, t8925, t8942, t8945, t8946;
  double t8949, t8954, t8957, t8960, t8963, t8970, t8974, t8975;
  double t8976, t8978, t8984, t8986, t8991, t8992, t8997, t8999;
  double t9000, t9002, t9005, t9006, t9007, t9008, t9009, t9011;
  double t9012, t9014, t9015, t9017, t9020, t9022, t9026, t9028;
  double t9029, t9030, t9032, t9033, t9034, t9035, t9036, t9037;
  double t9039, t9040, t9046, t9051, t9052, t9056, t9057, t9059;
  double t9060, t9066, t9075, t9077, t9081, t9083, t9085, t9087;
  double t9089, t9091, t9093, t9095, t9096, t9097, t9100, t9104;
  double t9105, t9112, t9113, t9114, t9118, t9121, t9122, t9126;
  double t9128, t9130, t9134, t9137, t9140, t9143, t9146, t9147;
  double t9148, t9149, t9152, t9157, t9162, t9175, t9189, t9193;
  double t9196, t9200, t9205, t9207, t9209, t9211, t9212, t9214;
  double t9216, t9218, t9219, t9220, t9223, t9227, t9228, t9231;
  double t9234, t9235, t9236, t9239, t9243, t9244, t9247, t9250;
  double t9251, t9252, t9265, t9266, t9269, t9273, t9274, t9275;
  double t9276, t9281, t9299, t9300, t9305, t9306, t9309, t9310;
  double t9313, t9314, t9321, t9323, t9325, t9327, t9329, t9332;
  double t9333, t9334, t9338, t9340, t9348, t9350, t9356, t9358;
  double t9360, t9361, t9364, t9366, t9367, t9369, t9370, t9371;
  double t9373, t9375, t9377, t9380, t9383, t9384, t9388, t9404;
  double t9407, t9410, t9437, t9442, t9446, t9451, t9482, t9483;
  double t9484, t9487, t9492, tv4rho40, t9502, t9506, t9524, t9526;
  double t9529, t9531, t9533, t9536, t9539, t9542, t9543, t9545;
  double t9546, t9549, t9552, t9555, t9556, t9559, t9562, t9563;
  double t9593, t9604, t9607, t9608, t9616, t9631, t9637, t9640;
  double t9642, t9643, t9644, t9645, t9647, t9648, t9649, t9651;
  double t9653, t9654, t9655, t9659, t9662, t9664, t9665, t9667;
  double t9669, t9671, t9672, t9673, t9674, t9675, t9676, t9677;
  double t9678, t9680, t9682, t9683, t9685, t9687, t9690, t9691;
  double t9693, t9694, t9695, t9698, t9725, t9727, t9752, t9754;
  double t9756, t9759, t9763, t9764, t9766, t9767, t9770, t9774;
  double t9775, t9776, t9777, t9778, t9779, t9781, t9782, t9784;
  double t9786, t9788, t9791, t9793, t9794, t9799, t9800, t9802;
  double t9803, t9804, t9806, t9807, t9808, t9812, t9817, t9818;
  double t9821, t9826, t9835, t9836, t9839, t9845, t9846, t9847;
  double t9852, t9853, t9857, t9859, t9861, t9863, t9864, t9865;
  double t9866, t9868, t9870, t9875, t9877, t9878, t9881, t9895;
  double t9896, t9897, t9900, t9902, t9904, t9909, t9910, t9912;
  double t9915, t9916, t9917, t9939, t9945, t9948, t9951, t9952;
  double t9958, t9959, t9965, t9966, t9969, t9970, t9981, t10019;
  double t10059, t10060, t10061, t10085, t10104, t10131, t10139, t10146;
  double t10161, t10163, t10169, t10174, t10176, t10183, t10191, t10193;
  double t10196, t10201, t10234, t10254, t10274, t10285, t10293, tv4rho41;
  double t10307, t10321, t10335, t10359, t10361, t10363, t10366, t10369;
  double t10371, t10373, t10375, t10377, t10379, t10381, t10384, t10387;
  double t10389, t10393, t10396, t10400, t10401, t10449, t10450, t10451;
  double t10461, t10471, t10472, t10510, t10512, t10513, t10552, t10585;
  double t10611, t10613, t10617, t10625, t10627, t10630, t10635, t10638;
  double t10645, t10654, t10657, t10659, t10664, t10666, t10677, t10682;
  double t10691, t10693, t10695, t10697, t10708, t10711, t10722, t10725;
  double t10728, t10733, t10736, t10738, t10743, t10744, t10758, t10763;
  double t10765, t10791, t10802, t10806, t10807, t10846, t10866, t10888;
  double t10891, t10898, t10901, t10943, t10948, t10952, t10967, t10970;
  double t10992, t11028, t11044, t11046, t11048, t11055, t11062, t11063;
  double t11071, t11075, t11077, t11079, t11081, t11084, t11086, t11091;
  double t11093, t11095, t11104, t11117, t11120, t11122, t11138, t11152;
  double t11166, t11181, t11195, t11210, t11224, tv4rho42, t11239, t11242;
  double t11246, t11247, t11250, t11253, t11255, t11259, t11260, t11263;
  double t11266, t11268, t11272, t11275, t11276, t11280, t11282, t11284;
  double t11286, t11288, t11292, t11295, t11299, t11301, t11303, t11307;
  double t11309, t11311, t11312, t11313, t11314, t11334, t11363, t11367;
  double t11388, t11390, t11394, t11402, t11410, t11414, t11421, t11426;
  double t11428, t11433, t11438, t11442, t11447, t11452, t11456, t11459;
  double t11489, t11514, t11521, t11529, t11558, t11566, t11585, t11597;
  double t11599, t11602, t11604, t11606, t11607, t11612, t11615, t11621;
  double t11642, t11658, t11662, t11665, t11707, t11729, t11738, t11743;
  double t11746, t11773, t11794, t11835, t11851, t11868, t11875, t11893;
  double tv4rho43, t11909, t11934, t11935, t11936, t11939, t11943, t11948;
  double t11950, t11952, t11954, t11955, t11958, t11961, t11963, t11965;
  double t11967, t11968, t11971, t11974, t11975, t11978, t11981, t11982;
  double t11985, t11988, t11989, t11995, t12001, t12010, t12049, t12053;
  double t12054, t12058, t12063, t12069, t12073, t12074, t12079, t12088;
  double t12090, t12098, t12103, t12115, t12120, t12129, t12133, t12142;
  double t12143, t12146, t12157, t12178, t12180, t12181, t12192, t12200;
  double t12249, t12274, t12288, t12292, tv4rho44, t12296, t12298, t12300;
  double t12303, t12306, t12308, t12310, t12313, t12314, t12317, t12320;
  double t12323, t12325, t12327, t12330, t12332, t12336, t12338, t12339;
  double t12342, t12346, t12348, t12351, t12353, t12357, t12361, t12362;
  double t12363, t12366, t12370, t12372, t12376, t12377, t12378, t12381;
  double t12382, t12383, t12384, t12386, t12390, t12392, t12395, t12397;
  double t12400, t12403, t12406, t12409, t12411, t12413, t12415, t12417;
  double t12418, t12419, t12423, t12426, t12429, t12431, t12433, t12437;
  double t12439, t12440, t12443, t12446, t12449, t12451, t12453, t12455;
  double t12456, t12459, t12461, t12464, t12467, t12469, t12471, t12473;
  double t12474, t12478, t12481, t12483, t12486, t12488, t12493, t12495;
  double t12499, t12501, t12504, t12506, t12507, t12511, t12513, t12514;
  double t12516, t12518, t12522, t12525, t12527, t12530, t12532, t12534;
  double t12536, t12538, t12539, t12541, t12543, t12545, t12547, t12549;
  double t12551, t12555, t12557, t12560, t12563, t12566, t12568, t12571;
  double t12573, t12579, t12581, t12584, t12586, t12587, t12588, t12589;
  double t12591, t12592, t12594, t12597, t12600, t12602, t12604, t12607;
  double t12610, t12611, t12615, t12619, t12620, t12622, t12626, t12629;
  double t12632, t12634, t12636, t12638, t12641, t12644, t12646, t12649;
  double t12653, t12655, t12657, t12659, t12662, t12666, t12668, t12670;
  double t12674, t12676, t12678, t12682, t12684, t12685, t12687, t12688;
  double t12690, t12692, t12696, t12698, t12700, t12701, t12702, t12703;
  double t12707, t12711, t12715, t12719, t12722, t12723, t12724, t12726;
  double t12728, t12730, t12733, t12735, t12737, t12745, t12748, t12761;
  double t12775, t12782, t12783, t12786, t12789, tv4rho3sigma0, t12809, t12816;
  double t12821, t12823, t12825, t12843, t12849, t12860, t12879, t12895;
  double t12906, t12912, t12934, t12940, t12942, t12944, t12949, t12954;
  double t12957, t12970, t12984, t12991, t12992, t12995, t12998, tv4rho3sigma1;
  double tv4rho3sigma2, t13000, t13002, t13004, t13007, t13009, t13010, t13020;
  double t13021, t13023, t13025, t13026, t13027, t13028, t13029, t13032;
  double t13034, t13035, t13038, t13040, t13043, t13044, t13047, t13049;
  double t13053, t13057, t13060, t13062, t13064, t13066, t13068, t13071;
  double t13074, t13078, t13079, t13081, t13082, t13085, t13086, t13088;
  double t13089, t13091, t13092, t13094, t13095, t13096, t13098, t13102;
  double t13104, t13106, t13107, t13108, t13109, t13110, t13111, t13113;
  double t13116, t13120, t13122, t13124, t13126, t13128, t13131, t13135;
  double t13137, t13140, t13141, t13142, t13143, t13145, t13147, t13148;
  double t13149, t13155, t13156, t13159, t13162, t13164, t13166, t13167;
  double t13169, t13170, t13171, t13172, t13173, t13174, t13176, t13177;
  double t13179, t13180, t13182, t13185, t13187, t13188, t13190, t13191;
  double t13193, t13194, t13196, t13198, t13200, t13202, t13206, t13207;
  double t13208, t13210, t13212, t13214, t13217, t13219, t13222, t13224;
  double t13226, t13228, t13231, t13233, t13236, t13237, t13239, t13240;
  double t13242, t13243, t13244, t13246, t13250, t13253, t13255, t13259;
  double t13262, t13265, t13267, t13269, t13272, t13275, t13279, t13281;
  double t13285, t13289, t13290, t13293, t13295, t13297, t13299, t13301;
  double t13303, t13305, t13308, t13310, t13313, t13315, t13317, t13321;
  double t13323, t13325, t13327, t13329, t13332, t13334, t13336, t13338;
  double t13339, t13342, t13345, t13346, t13347, t13348, t13349, t13351;
  double t13352, t13355, t13356, t13357, t13359, t13360, t13362, t13363;
  double t13365, t13367, t13369, t13371, t13373, t13375, t13378, t13381;
  double t13384, t13386, t13389, t13391, t13395, t13397, t13406, t13408;
  double t13410, t13412, t13414, t13416, t13419, t13422, t13425, t13426;
  double t13427, t13428, t13432, t13434, t13437, t13439, t13442, t13444;
  double t13446, t13449, t13452, t13455, t13457, t13459, t13462, t13464;
  double t13465, t13466, t13469, t13471, t13473, t13474, t13475, t13476;
  double t13477, t13478, t13479, t13480, t13483, t13486, t13489, t13490;
  double t13491, t13492, t13494, t13495, t13497, t13498, t13499, t13500;
  double t13503, t13504, t13507, t13508, t13509, t13511, t13513, t13514;
  double t13515, t13516, t13517, t13518, t13522, t13523, t13524, t13526;
  double t13528, t13533, t13534, t13537, t13539, t13540, t13544, t13545;
  double t13548, t13550, t13553, t13554, t13555, t13556, t13560, t13564;
  double t13568, t13573, t13574, t13575, t13579, t13581, t13582, t13583;
  double t13586, t13589, t13592, t13593, t13594, t13598, t13602, t13605;
  double t13608, t13610, t13611, t13613, t13614, t13616, t13617, t13618;
  double t13621, t13622, t13626, t13629, t13630, t13632, t13635, t13637;
  double t13638, t13640, t13642, t13644, t13645, t13649, t13652, t13658;
  double t13659, t13661, t13662, t13663, t13666, t13667, t13669, t13670;
  double t13671, t13672, tv4rho3sigma3, t13676, t13677, t13678, t13679, t13680;
  double t13681, t13682, t13683, t13684, t13685, t13686, t13687, t13688;
  double t13689, t13690, t13692, t13693, t13694, t13695, t13696, t13697;
  double t13700, t13714, t13719, t13724, t13726, t13728, t13737, t13739;
  double t13740, t13741, t13742, t13743, t13744, t13745, t13746, t13747;
  double t13748, t13749, t13750, t13751, t13752, t13754, t13761, t13764;
  double t13765, t13767, t13778, t13779, t13780, t13781, t13782, t13783;
  double t13785, t13786, t13787, t13799, t13801, t13803, t13804, t13810;
  double t13812, t13813, t13814, t13817, t13818, t13826, t13827, t13828;
  double t13832, t13836, t13845, t13852, t13866, t13867, t13868, t13869;
  double t13870, t13871, t13872, t13873, t13874, t13886, t13897, t13898;
  double t13903, t13907, t13918, t13919, t13922, t13924, t13925, t13926;
  double t13927, t13930, t13931, t13932, t13933, t13934, t13935, t13936;
  double t13937, t13939, t13940, t13941, t13945, t13953, t13956, t13962;
  double t13963, t13966, t13970, t13973, t13974, t13986, t13992, t13993;
  double t13994, t13995, t13996, t13997, t14000, t14003, t14004, t14006;
  double t14007, t14008, t14009, t14010, t14011, t14012, t14013, t14014;
  double t14015, t14017, t14018, t14019, t14020, t14025, t14026, t14027;
  double t14028, t14029, tv4rho3sigma4, tv4rho3sigma5, t14032, t14033, t14035, t14036;
  double t14039, t14043, t14050, t14053, t14055, t14057, t14060, t14062;
  double t14064, t14067, t14069, t14073, t14075, t14076, t14080, t14081;
  double t14083, t14085, t14087, t14090, t14093, t14096, t14098, t14101;
  double t14103, t14105, t14108, t14112, t14116, t14118, t14122, t14124;
  double t14127, t14129, t14131, t14134, t14136, t14138, t14142, t14145;
  double t14148, t14151, t14154, t14158, t14161, t14164, t14166, t14168;
  double t14170, t14171, t14174, t14176, t14179, t14181, t14184, t14186;
  double t14188, t14190, t14192, t14194, t14196, t14198, t14200, t14203;
  double t14205, t14209, t14211, t14212, t14216, t14218, t14221, t14225;
  double t14228, t14231, t14235, t14237, t14243, t14246, t14248, t14251;
  double t14254, t14256, t14259, t14262, t14264, t14268, t14270, t14272;
  double t14274, t14276, t14280, t14284, t14287, t14289, t14291, t14293;
  double t14295, t14297, t14299, t14303, t14306, t14308, t14312, t14314;
  double t14316, t14318, t14320, t14322, t14324, t14326, t14328, t14330;
  double t14333, t14336, t14339, t14341, t14344, t14347, t14350, t14353;
  double t14356, t14359, t14362, t14366, t14369, t14371, t14375, t14377;
  double t14379, t14381, t14384, t14388, t14392, t14395, t14397, t14399;
  double t14401, t14403, t14407, t14411, t14413, t14416, t14418, t14419;
  double t14420, t14422, t14424, t14428, t14430, t14432, t14436, t14438;
  double t14439, t14443, t14445, t14447, t14451, t14455, t14457, t14461;
  double t14463, t14466, t14468, t14470, t14472, t14474, t14476, t14479;
  double t14482, t14484, t14486, t14488, t14492, t14496, t14501, t14503;
  double t14505, t14507, t14509, t14512, t14516, t14519, t14523, t14525;
  double t14527, t14529, t14531, t14533, t14537, t14543, t14545, t14546;
  double tv4rho3sigma6, t14549, t14555, t14557, t14558, t14562, t14568, t14573;
  double t14586, t14594, t14608, t14617, t14624, t14640, t14655, t14664;
  double t14682, t14697, t14709, t14720, t14734, t14748, t14758, t14773;
  double t14780, t14784, t14786, tv4rho3sigma7, tv4rho3sigma8, t14800, t14812, t14826;
  double t14839, t14841, t14843, t14845, t14847, t14853, t14862, t14865;
  double t14867, t14869, t14873, t14879, t14881, t14884, t14887, t14889;
  double t14897, t14899, t14902, t14904, t14907, t14913, t14918, t14922;
  double t14936, t14941, t14943, t14946, t14948, t14951, t14953, t14956;
  double t14958, t14960, t14962, t14970, t14972, t14973, t14977, t14979;
  double t14981, t14985, t14988, t14990, t14992, t14996, t15000, t15005;
  double t15007, t15010, t15013, t15015, t15021, t15024, t15028, t15032;
  double t15034, t15037, t15039, t15042, t15044, t15047, t15050, t15057;
  double t15063, t15070, t15072, t15076, t15080, t15082, t15085, t15087;
  double t15090, t15093, t15095, t15097, t15099, t15101, t15106, tv4rho3sigma9;
  double t15119, t15131, t15145, t15169, t15174, t15190, t15208, t15225;
  double t15243, t15259, t15275, t15292, t15303, tv4rho3sigma10, tv4rho3sigma11, tv4rho3lapl0;
  double tv4rho3lapl1, tv4rho3lapl2, tv4rho3lapl3, tv4rho3lapl4, tv4rho3lapl5, tv4rho3lapl6, tv4rho3lapl7, t15324;
  double t15338, t15340, t15344, t15347, t15360, t15363, t15365, t15379;
  double t15383, t15391, t15401, t15405, t15409, t15410, t15416, t15423;
  double t15426, t15437, t15453, t15457, t15463, t15467, t15468, t15485;
  double t15486, t15492, t15493, t15494, t15498, t15499, t15503, t15506;
  double t15507, t15522, t15523, t15524, t15530, t15537, t15540, t15547;
  double t15550, t15556, t15559, t15561, t15563, t15573, t15579, t15600;
  double t15605, t15610, t15614, t15633, t15656, t15657, t15658, t15663;
  double t15665, t15675, t15680, t15685, t15690, t15700, t15701, t15703;
  double t15704, t15706, t15708, t15711, t15716, t15728, t15729, t15734;
  double t15738, t15742, t15744, t15746, t15760, t15766, t15769, t15770;
  double t15772, t15774, t15775, t15777, t15779, t15780, t15782, t15784;
  double t15787, t15790, t15798, t15802, t15804, t15827, t15829, t15835;
  double t15841, t15843, t15846, t15849, t15851, t15855, t15856, t15872;
  double t15873, t15883, t15886, t15887, t15888, t15896, t15899, t15903;
  double t15906, t15908, t15912, t15914, t15916, t15928, t15931, t15933;
  double t15936, t15938, t15941, t15943, t15944, t15954, t15956, t15959;
  double t15960, t15964, t15970, t15974, t15984, t15988, t15998, t16000;
  double t16001, t16003, t16007, t16013, t16018, t16026, t16033, t16038;
  double t16042, t16049, t16051, t16070, t16073, t16076, t16079, t16087;
  double t16088, t16092, t16097, t16100, t16102, t16105, t16107, t16119;
  double t16122, t16129, t16132, t16145, t16148, t16150, t16153, t16158;
  double t16161, t16163, t16165, t16184, t16187, t16190, t16192, t16194;
  double t16196, t16198, t16200, t16202, t16209, t16213, t16215, t16217;
  double t16225, t16230, t16234, t16236, t16238, t16243, t16244, t16247;
  double t16258, t16262, t16264, t16266, t16268, t16272, t16290, t16296;
  double t16310, t16313, t16316, t16333, t16334, t16335, t16346, t16356;
  double t16377, tv4rho3tau0, t16389, t16393, t16398, t16419, t16420, t16429;
  double t16431, t16454, t16456, t16457, t16473, t16475, t16481, t16483;
  double t16485, t16487, t16489, t16491, t16493, t16495, t16498, t16501;
  double t16504, t16507, t16510, t16512, t16516, t16518, t16527, t16540;
  double t16546, t16555, t16570, t16573, t16576, t16580, t16583, t16585;
  double t16587, t16598, t16600, t16603, t16619, t16621, t16627, t16630;
  double t16632, t16650, t16654, t16657, t16660, t16663, t16666, t16669;
  double t16672, t16687, t16697, t16709, t16716, t16717, t16721, t16726;
  double t16732, t16733, t16744, t16756, t16757, t16766, t16767, t16768;
  double t16772, t16776, t16778, t16781, t16784, t16792, t16794, t16805;
  double t16807, t16815, t16816, t16818, t16819, t16837, t16842, t16845;
  double t16847, t16873, t16881, t16885, t16886, t16903, t16906, t16922;
  double t16929, t16931, t16935, t16942, t16957, t16960, t16966, t16969;
  double t16983, t17015, t17034, t17039, t17040, t17044, t17047, t17048;
  double t17049, t17057, t17058, t17065, t17082, t17098, tv4rho3tau1, t17100;
  double t17103, t17105, t17106, t17121, t17123, t17132, t17133, t17136;
  double t17156, t17160, t17170, t17199, t17220, t17225, t17226, t17259;
  double t17260, t17264, t17265, t17269, t17272, t17278, t17284, t17287;
  double t17293, t17301, t17308, t17315, t17316, t17332, t17333, t17342;
  double t17345, t17347, t17354, t17356, t17363, t17364, t17377, t17382;
  double t17392, t17395, t17399, t17400, t17408, t17411, t17414, t17419;
  double t17420, t17424, t17428, t17433, t17447, t17455, t17462, t17480;
  double t17484, t17494, t17495, t17497, t17502, t17503, t17518, t17520;
  double t17529, t17532, t17536, t17548, t17552, t17557, t17559, t17561;
  double t17563, t17564, t17565, t17568, t17572, t17575, t17582, t17591;
  double t17595, t17596, t17600, t17618, t17622, t17626, t17630, t17638;
  double t17641, t17649, t17651, t17653, t17655, t17658, t17661, t17673;
  double t17691, t17698, t17702, t17706, t17715, t17717, t17731, t17735;
  double t17740, t17744, t17748, t17755, t17763, t17766, t17771, t17774;
  double t17782, t17791, t17804, t17811, t17813, t17816, t17820, t17823;
  double t17824, t17829, t17837, t17841, t17848, t17861, t17862, t17868;
  double t17874, t17875, t17882, t17886, t17889, t17891, t17894, t17896;
  double t17901, t17904, t17912, t17916, t17918, t17920, t17921, t17922;
  double t17926, t17929, t17946, t17958, t17963, t17992, t17998, t18024;
  double t18038, t18042, t18050, t18059, t18062, t18065, t18066, t18071;
  double t18075, t18084, t18089, t18099, t18106, t18110, t18115, t18118;
  double t18121, t18124, t18135, t18139, t18141, t18144, t18145, t18148;
  double t18158, t18163, t18181, t18191, t18208, t18221, t18229, t18230;
  double t18231, t18239, t18254, t18256, t18258, t18263, t18270, t18274;
  double t18284, t18288, t18296, t18300, t18305, t18331, t18338, t18344;
  double t18348, t18359, t18363, t18366, t18385, t18388, t18424, t18427;
  double t18436, t18441, t18444, t18447, t18450, t18456, t18469, t18473;
  double t18483, t18484, t18489, t18516, t18518, t18527, t18537, t18542;
  double t18545, t18554, t18557, t18561, t18565, t18567, t18572, t18587;
  double t18594, t18600, t18604, t18610, t18613, t18615, t18622, t18623;
  double t18624, t18625, t18626, t18627, t18628, t18629, t18630, t18631;
  double t18632, t18633, t18634, t18635, t18636, t18637, t18638, t18639;
  double t18640, t18642, t18643, t18644, t18645, t18646, t18647, t18648;
  double t18649, t18650, t18651, t18652, t18653, t18654, t18655, t18656;
  double t18657, t18658, t18659, t18660, t18661, t18662, t18663, t18664;
  double t18665, t18666, t18667, t18670, t18671, t18672, t18673, t18674;
  double t18675, t18676, t18677, t18680, t18684, t18685, t18686, t18688;
  double t18689, t18690, t18691, t18692, t18693, t18694, t18696, t18697;
  double t18698, t18699, t18700, t18701, t18702, t18703, t18704, t18705;
  double t18706, t18707, t18708, t18709, t18710, t18711, t18713, t18714;
  double t18715, t18716, t18717, t18718, t18719, tv4rho3tau2, t18723, t18724;
  double t18725, t18726, t18727, t18728, t18729, t18730, t18731, t18732;
  double t18733, t18734, t18735, t18736, t18737, t18738, t18739, t18740;
  double t18741, t18742, t18744, t18746, t18747, t18748, t18749, t18750;
  double t18751, t18752, t18753, t18754, t18755, t18756, t18757, t18758;
  double t18759, t18760, t18761, t18764, t18765, t18766, t18767, t18768;
  double t18769, t18770, t18771, t18772, t18773, t18774, t18777, t18778;
  double t18779, t18780, t18781, t18782, t18783, t18784, t18786, t18788;
  double t18789, t18790, t18791, t18792, t18793, t18795, t18796, t18797;
  double t18798, t18799, t18800, t18801, t18802, t18821, t18822, t18826;
  double t18836, t18843, t18848, t18856, t18874, t18880, t18896, t18918;
  double t18946, t18957, t18958, t18963, t18964, t18965, t18969, t18973;
  double t18977, t18991, t18999, t19004, t19017, t19029, t19032, t19036;
  double t19040, t19044, t19046, t19047, t19054, t19075, t19082, t19091;
  double t19116, t19130, t19139, t19142, t19151, t19180, t19185, t19188;
  double t19191, t19194, t19195, t19197, t19198, t19207, t19211, t19214;
  double t19218, t19226, t19236, t19264, t19273, t19278, t19283, t19286;
  double t19290, t19297, t19304, t19308, t19313, t19314, t19316, t19318;
  double t19320, t19322, t19324, t19354, t19369, t19370, t19373, t19384;
  double t19387, t19398, t19410, t19422, t19424, t19426, t19447, t19451;
  double t19464, t19473, t19488, t19492, t19503, t19506, t19508, t19515;
  double t19525, t19531, t19535, t19538, t19541, t19544, t19547, t19557;
  double t19564, t19572, t19575, t19577, t19580, t19583, t19586, t19592;
  double t19595, t19596, t19597, t19603, t19606, t19628, t19642, t19645;
  double t19648, t19650, t19653, t19657, t19659, t19662, t19665, t19666;
  double t19684, t19706, t19741, t19748, t19751, t19754, t19755, t19758;
  double t19766, t19775, t19804, t19826, t19829, t19831, t19842, t19853;
  double t19856, t19873, t19885, t19903, t19909, t19928, t19942, t19944;
  double t19953, t19956, t19959, t19961, t19963, t19978, t19998, t20001;
  double t20015, t20016, t20023, t20027, t20045, t20046, t20051, t20055;
  double t20058, t20081, t20085, t20094, t20099, t20103, t20104, t20117;
  double t20118, t20125, t20126, t20127, t20128, t20129, t20130, t20131;
  double t20132, t20133, t20134, t20135, t20136, t20137, t20138, t20139;
  double t20140, t20141, tv4rho3tau3, t20146, t20147, t20149, t20151, t20155;
  double t20158, t20180, t20208, t20215, t20227, t20237, t20246, t20249;
  double t20251, t20253, t20255, t20283, t20310, t20320, t20325, t20332;
  double t20337, t20353, t20363, t20367, t20371, t20373, t20390, t20393;
  double t20394, t20397, t20410, t20414, t20418, t20424, t20433, t20436;
  double t20440, t20443, t20456, t20459, t20462, t20463, t20467, t20471;
  double t20478, t20479, t20480, t20509, t20532, t20541, t20546, t20550;
  double t20554, t20559, t20561, t20567, t20574, t20577, t20580, t20588;
  double t20591, t20594, t20599, t20603, t20606, t20608, t20612, t20649;
  double t20674, t20679, t20680, t20684, t20695, t20709, t20711, t20716;
  double t20721, t20723, t20725, t20729, t20731, t20737, t20740, t20758;
  double t20780, t20788, t20795, t20799, t20807, t20818, t20822, t20836;
  double t20837, t20841, t20880, t20884, t20902, t20905, t20921, t20923;
  double t20927, t20930, t20935, t20937, t20963, t20973, t20989, t20996;
  double t20999, t21001, t21006, t21022, t21024, t21034, t21042, t21048;
  double t21050, t21053, t21056, t21076, t21079, t21085, t21087, t21103;
  double t21112, t21116, t21117, t21120, t21131, t21135, t21140, t21167;
  double t21171, t21181, t21185, t21191, t21193, t21198, t21208, t21224;
  double t21259, t21265, t21272, t21295, t21299, t21307, t21314, t21317;
  double t21324, t21327, t21334, t21355, t21362, t21365, t21367, t21368;
  double tv4rho3tau4, t21376, t21406, t21441, t21446, t21448, t21476, t21483;
  double t21502, t21525, t21540, t21565, t21573, t21584, t21587, t21590;
  double t21606, t21627, t21630, t21633, t21635, t21648, t21667, t21677;
  double t21679, t21681, t21683, t21685, t21687, t21689, t21692, t21695;
  double t21698, t21700, t21705, t21708, t21711, t21714, t21717, t21720;
  double t21722, t21732, t21740, t21741, t21755, t21760, t21765, t21768;
  double t21771, t21774, t21777, t21818, t21845, t21879, t21884, t21929;
  double t21970, t21989, t21991, t21994, t21996, t22002, t22025, t22045;
  double t22083, t22092, t22095, t22097, t22099, t22101, t22103, t22112;
  double t22114, t22116, t22119, t22122, t22126, t22129, t22131, t22143;
  double t22144, t22148, t22170, t22186, t22196, t22209, t22232, t22234;
  double t22258, t22263, t22278, t22290, t22303, t22313, t22330, t22345;
  double t22376, t22425, t22442, t22455, t22462, t22491, t22506, t22513;
  double t22521, t22532, t22548, t22566, t22570, t22603, t22609, t22643;
  double t22646, t22648, t22656, t22659, t22661, t22662, t22665, t22667;
  double t22669, t22673, tv4rho3tau5, t22691, t22704, t22721, t22731, t22737;
  double t22745, t22756, t22762, t22770, t22774, t22785, t22796, t22816;
  double t22832, t22865, t22888, t22902, t22907, t22927, t22933, t22996;
  double t23028, t23034, t23040, t23045, t23050, t23062, t23080, t23083;
  double t23086, t23089, t23096, t23104, t23117, t23151, t23155, t23159;
  double t23162, t23165, t23168, t23180, t23218, t23221, t23226, t23230;
  double t23234, t23246, t23256, t23272, t23285, tv4rho3tau6, t23340, t23372;
  double t23387, t23402, t23409, t23423, t23430, t23449, t23475, t23503;
  double t23514, t23530, t23541, t23549, t23560, t23569, t23573, t23579;
  double t23583, t23617, t23620, t23634, t23662, t23692, t23751, t23787;
  double t23832, t23853, t23897, t23940, t23989, t24030, t24054, t24073;
  double t24092, t24113, tv4rho3tau7, t24118, t24119, t24120, t24121, t24122;
  double t24123, t24124, t24126, t24130, t24134, t24135, t24138, t24141;
  double t24142, t24145, t24147, t24149, t24152, t24153, t24156, t24157;
  double t24160, t24162, t24164, t24165, t24168, t24172, t24174, t24176;
  double t24180, t24182, t24185, t24187, t24189, t24193, t24195, t24197;
  double t24198, t24200, t24201, t24204, t24206, t24209, t24210, t24211;
  double t24213, t24216, t24217, t24219, t24220, t24221, t24223, t24224;
  double t24225, t24227, t24229, t24231, t24234, t24237, t24239, t24240;
  double t24241, t24242, t24245, t24246, t24248, t24250, t24252, t24254;
  double t24256, t24258, t24259, t24260, t24261, t24262, t24263, t24264;
  double t24265, t24268, t24269, t24270, t24272, t24273, t24275, t24276;
  double t24277, t24278, t24279, t24280, t24281, t24284, t24287, t24289;
  double t24290, t24291, t24293, t24295, t24297, t24300, t24301, t24305;
  double t24306, t24309, t24310, t24313, t24314, t24316, t24317, t24319;
  double t24320, t24322, t24325, t24328, t24330, t24331, t24332, t24333;
  double t24335, t24337, t24339, t24343, tv4rho2sigma20, t24344, t24345, t24349;
  double t24351, t24355, t24356, t24358, t24367, t24368, t24369, t24371;
  double t24373, t24374, t24375, t24380, t24384, t24386, t24391, t24392;
  double t24393, t24395, t24396, t24397, t24398, t24400, t24401, t24404;
  double t24405, t24406, t24407, t24408, t24409, t24413, t24417, t24424;
  double tv4rho2sigma21, tv4rho2sigma22, t24425, t24426, t24428, t24437, t24444, t24451;
  double t24466, t24472, t24482, t24494, t24495, t24496, t24499, t24502;
  double t24503, t24505, t24507, t24515, t24519, t24521, t24523, tv4rho2sigma23;
  double tv4rho2sigma24, tv4rho2sigma25, t24526, t24530, t24534, t24537, t24540, t24541;
  double t24543, t24547, t24551, t24555, t24562, t24563, t24565, t24567;
  double t24569, t24571, t24573, t24575, t24579, t24581, t24583, t24584;
  double t24586, t24588, t24592, t24595, t24598, t24600, t24602, t24605;
  double t24610, t24613, t24617, t24619, t24622, t24625, t24627, t24629;
  double t24631, t24633, t24635, t24637, t24639, t24641, t24644, t24646;
  double t24647, t24649, t24652, t24655, t24657, t24659, t24661, t24663;
  double t24671, t24679, t24682, t24684, t24686, t24689, t24691, t24693;
  double t24696, t24699, t24702, t24705, t24707, t24711, t24715, t24718;
  double t24722, t24726, t24728, t24730, t24733, t24736, t24739, t24747;
  double t24749, t24751, t24754, t24756, t24758, t24765, t24770, t24771;
  double tv4rho2sigma26, t24773, t24776, t24780, t24790, t24796, t24797, t24798;
  double t24800, t24801, t24802, t24807, t24812, t24813, t24815, t24816;
  double t24817, t24818, t24824, t24831, t24838, t24839, t24842, t24845;
  double t24846, t24847, t24848, t24849, t24854, t24859, t24860, tv4rho2sigma27;
  double tv4rho2sigma28, t24861, t24862, t24873, t24876, t24877, t24878, t24879;
  double t24880, t24883, t24887, t24892, t24894, t24899, t24900, t24902;
  double t24903, t24904, t24905, t24911, t24921, t24927, t24928, t24932;
  double t24934, t24935, t24936, t24937, t24939, t24944, t24949, tv4rho2sigma29;
  double tv4rho2sigma210, tv4rho2sigma211, t24954, t24958, t24961, t24963, t24964, t24968;
  double t24972, t24973, t24976, t24980, t24984, t24989, t24992, t24994;
  double t24997, t25000, t25003, t25006, t25008, t25012, t25016, t25020;
  double t25022, t25024, t25028, t25032, t25034, t25036, t25040, t25042;
  double t25044, t25045, t25047, t25050, t25052, t25055, t25058, t25060;
  double t25062, t25064, t25066, t25068, t25072, tv4rho2sigma212, t25077, t25086;
  double t25101, t25116, t25123, tv4rho2sigma213, tv4rho2sigma214, t25153, t25176, t25193;
  double t25202, t25206, tv4rho2sigma215, tv4rho2sigma216, tv4rho2sigma217, tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2;
  double tv4rho2sigmalapl3, tv4rho2sigmalapl4, tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10;
  double tv4rho2sigmalapl11, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, tv4rho2sigmalapl17, t25207;
  double t25208, t25211, t25212, t25213, t25215, t25218, t25219, t25220;
  double t25221, t25222, t25223, t25225, t25226, t25229, t25232, t25233;
  double t25234, t25236, t25239, t25240, t25241, t25243, t25244, t25245;
  double t25246, t25247, t25249, t25251, t25252, t25254, t25256, t25257;
  double t25259, t25260, t25261, t25262, t25263, t25266, t25268, t25270;
  double t25272, t25273, t25275, t25276, t25278, t25279, t25281, t25282;
  double t25285, t25288, t25290, t25294, t25296, t25297, t25298, t25299;
  double t25301, t25302, t25305, t25306, t25307, t25309, t25312, t25314;
  double t25316, t25318, t25319, t25320, t25321, t25323, t25325, t25328;
  double t25329, t25330, t25331, t25332, t25333, t25336, t25337, t25338;
  double t25339, t25341, t25342, t25343, t25345, t25346, t25347, t25348;
  double t25349, t25350, t25351, t25354, t25357, t25360, t25361, t25362;
  double t25364, t25365, t25366, t25367, t25368, t25370, t25373, t25374;
  double t25375, t25379, t25380, t25381, t25382, t25383, t25385, t25386;
  double t25388, t25389, t25390, t25392, t25394, t25395, t25396, t25399;
  double t25402, t25403, t25404, t25406, t25407, t25409, t25412, t25414;
  double t25415, t25416, t25417, t25419, t25424, t25428, t25432, t25434;
  double t25436, t25438, t25439, t25440, t25443, t25446, t25447, t25448;
  double t25451, t25453, t25455, t25457, t25458, t25459, t25462, t25466;
  double t25468, t25470, t25472, t25474, t25477, t25479, t25481, t25483;
  double t25484, t25487, t25491, t25493, t25496, t25497, t25498, t25499;
  double t25502, t25503, t25505, t25506, t25507, t25509, t25510, t25511;
  double t25513, t25516, t25517, t25519, t25520, t25521, t25522, t25523;
  double t25524, t25525, t25528, t25529, t25532, t25533, t25534, t25535;
  double t25537, t25538, t25541, t25545, t25547, t25548, t25549, t25551;
  double t25553, t25557, t25559, t25561, t25563, t25565, t25567, t25568;
  double t25570, t25571, t25573, t25574, t25575, t25577, t25580, t25581;
  double t25582, t25586, t25587, t25590, t25594, t25595, t25596, t25599;
  double t25601, t25603, t25605, t25607, t25609, t25611, t25612, t25613;
  double t25614, t25616, t25618, t25619, t25621, t25626, t25628, t25630;
  double t25631, t25632, t25633, t25635, t25636, t25638, t25640, t25641;
  double t25642, t25643, t25644, t25646, t25648, t25650, t25651, t25652;
  double t25655, t25658, t25659, t25661, t25663, t25664, t25665, t25668;
  double t25669, t25670, t25671, t25672, t25673, t25675, t25677, t25679;
  double t25680, t25681, t25684, t25686, t25688, t25690, t25691, t25692;
  double t25694, t25696, t25698, t25700, t25701, t25704, t25706, t25708;
  double t25709, t25712, t25714, t25716, t25717, t25718, t25720, t25721;
  double t25722, t25724, t25726, t25729, t25731, t25734, t25735, t25737;
  double t25739, t25740, t25742, t25743, t25745, t25746, t25747, t25749;
  double t25750, t25751, t25752, t25754, t25755, t25756, t25757, t25759;
  double t25761, t25762, t25763, t25764, t25766, t25768, t25769, t25770;
  double t25771, t25773, t25774, t25775, t25776, t25781, t25782, t25783;
  double t25784, t25786, t25788, t25789, t25790, t25791, t25794, t25796;
  double t25798, t25800, t25802, t25804, t25807, t25810, t25813, t25815;
  double t25818, t25820, t25823, t25825, t25826, t25828, t25829, t25830;
  double t25831, t25832, t25835, t25837, t25839, t25841, t25842, t25843;
  double t25845, t25847, t25848, t25850, t25853, t25856, t25859, t25860;
  double t25862, t25863, t25865, t25866, t25867, t25869, t25870, t25872;
  double t25873, t25875, t25878, t25880, t25882, t25884, t25885, t25886;
  double t25890, t25894, t25895, t25897, t25898, t25899, t25902, t25905;
  double t25906, t25907, t25909, t25912, t25913, t25914, t25915, t25917;
  double t25919, t25921, t25922, t25926, t25927, t25929, t25932, t25935;
  double t25936, t25938, t25941, t25943, t25944, t25947, t25951, t25953;
  double t25955, t25957, t25960, t25967, tv4rho2sigmatau0, t25969, t25970, t25972;
  double t25974, t25976, t25978, t25979, t25981, t25982, t25983, t25984;
  double t25985, t25988, t25991, t25993, t25995, t25997, t25999, t26001;
  double t26003, t26004, t26005, t26006, t26007, t26008, t26010, t26013;
  double t26015, t26017, t26021, t26023, t26026, t26028, t26029, t26030;
  double t26032, t26034, t26036, t26038, t26039, t26040, t26043, t26046;
  double t26047, t26048, t26050, t26052, t26053, t26056, t26058, t26059;
  double t26060, t26061, t26063, t26064, t26065, t26067, t26068, t26070;
  double t26071, t26073, t26074, t26076, t26077, t26079, t26080, t26083;
  double t26085, t26086, t26088, t26091, t26093, t26095, t26099, t26103;
  double t26105, t26106, t26107, t26108, t26109, t26111, t26112, t26113;
  double t26114, t26116, t26118, t26120, t26122, t26125, t26128, t26130;
  double t26131, t26132, t26133, t26135, t26136, t26137, t26139, t26141;
  double t26143, t26144, t26145, t26146, t26147, t26149, t26150, t26151;
  double t26152, t26153, t26154, t26156, t26157, t26159, t26160, t26161;
  double t26162, t26163, t26164, t26166, t26169, t26173, t26175, t26176;
  double t26178, t26179, t26181, t26182, t26184, t26185, t26186, t26187;
  double t26189, t26191, t26194, t26195, t26197, t26198, t26202, t26204;
  double t26206, t26207, t26208, t26212, t26214, t26217, t26221, t26225;
  double t26227, t26230, t26234, t26236, t26238, t26239, t26241, t26242;
  double t26244, t26245, t26247, t26250, t26251, t26253, t26255, t26257;
  double t26260, t26262, t26263, t26265, t26268, t26269, t26270, t26271;
  double t26274, t26275, t26276, t26277, t26280, t26281, t26283, t26284;
  double t26287, t26289, t26291, t26292, t26294, t26295, t26296, t26297;
  double t26298, t26300, t26302, t26305, t26306, t26307, t26308, t26312;
  double t26314, t26316, t26317, t26318, t26320, t26322, t26323, t26325;
  double t26326, t26327, t26329, t26330, t26331, t26334, t26335, t26338;
  double t26339, t26340, t26341, t26342, t26343, t26344, t26346, t26348;
  double t26350, t26352, t26354, t26356, t26357, t26359, t26362, t26363;
  double t26364, t26365, t26368, t26369, t26372, t26376, t26378, t26381;
  double t26384, t26386, t26387, t26389, t26392, t26393, t26394, t26397;
  double t26401, t26405, t26406, t26407, t26411, t26413, t26414, t26418;
  double t26420, t26422, t26423, t26424, t26427, t26430, t26431, t26432;
  double t26433, t26435, t26436, t26437, t26438, t26441, t26443, t26445;
  double t26446, t26447, t26449, t26451, t26453, t26455, t26456, t26458;
  double t26462, t26465, t26466, t26470, t26471, t26472, t26476, t26478;
  double t26480, t26482, t26486, t26488, t26491, t26493, t26495, t26497;
  double t26503, t26506, tv4rho2sigmatau1, t26514, t26517, t26518, t26520, t26530;
  double t26531, t26534, t26544, t26549, t26550, t26551, t26553, t26554;
  double t26556, t26557, t26564, t26565, t26573, t26575, t26589, t26595;
  double t26599, t26604, t26619, t26625, t26627, t26638, t26647, t26663;
  double t26665, t26677, t26692, t26693, t26694, t26698, t26699, t26707;
  double t26715, t26722, t26724, t26738, t26753, t26768, t26776, t26777;
  double t26784, t26798, t26806, t26813, t26819, t26820, t26828, t26834;
  double tv4rho2sigmatau2, t26841, t26842, t26843, t26844, t26845, t26846, t26847;
  double t26858, t26859, t26861, t26862, t26863, t26872, t26878, t26879;
  double t26886, t26895, t26896, t26897, t26903, t26911, t26919, t26920;
  double t26926, t26949, t26956, t26957, t26963, t26964, t26967, t26968;
  double t26972, t26995, t26996, t27009, t27013, t27014, t27016, t27037;
  double t27041, t27042, t27060, t27083, t27089, tv4rho2sigmatau3, tv4rho2sigmatau4, tv4rho2sigmatau5;
  double t27091, t27092, t27095, t27097, t27098, t27099, t27101, t27102;
  double t27103, t27109, t27111, t27113, t27115, t27116, t27118, t27119;
  double t27121, t27123, t27126, t27128, t27130, t27132, t27133, t27135;
  double t27137, t27138, t27140, t27141, t27143, t27144, t27145, t27147;
  double t27149, t27151, t27154, t27157, t27159, t27162, t27164, t27166;
  double t27168, t27170, t27172, t27175, t27178, t27182, t27183, t27185;
  double t27188, t27189, t27192, t27193, t27195, t27198, t27199, t27200;
  double t27204, t27208, t27210, t27212, t27214, t27216, t27218, t27220;
  double t27222, t27225, t27228, t27230, t27232, t27234, t27237, t27238;
  double t27241, t27244, t27248, t27249, t27250, t27252, t27255, t27258;
  double t27261, t27263, t27264, t27267, t27270, t27273, t27276, t27279;
  double t27280, t27282, t27286, t27288, t27290, t27294, t27296, t27297;
  double t27299, t27300, t27302, t27304, t27306, t27309, t27312, t27314;
  double t27316, t27318, t27322, t27324, t27327, t27330, t27333, t27334;
  double t27336, t27338, t27340, t27342, t27344, t27346, t27348, t27349;
  double t27350, t27352, t27355, t27357, t27360, t27362, t27364, t27367;
  double t27371, t27374, t27377, t27380, t27382, t27384, t27386, t27388;
  double t27391, t27394, t27398, t27402, t27404, t27406, t27408, t27410;
  double t27412, t27415, t27418, t27429, t27431, t27433, t27434, t27435;
  double t27438, t27441, t27443, t27446, t27449, t27451, t27453, t27455;
  double t27458, t27462, t27464, t27466, t27468, t27470, t27475, t27480;
  double t27483, t27485, t27489, t27491, t27493, t27494, t27496, t27497;
  double t27498, t27501, t27503, t27505, t27507, t27509, t27511, t27513;
  double t27515, t27517, t27519, t27522, t27526, t27528, t27529, t27531;
  double t27532, t27534, t27537, t27546, t27549, t27550, t27552, t27561;
  double t27562, t27564, t27565, t27567, t27568, t27570, t27571, t27573;
  double t27576, t27579, t27585, t27587, t27588, t27590, t27592, t27594;
  double t27596, t27598, t27601, t27604, t27606, t27608, t27612, t27614;
  double t27618, t27621, t27623, t27625, t27628, t27631, t27634, t27637;
  double t27642, t27645, t27647, t27649, t27650, t27651, t27653, t27655;
  double t27658, t27660, t27663, t27665, t27667, t27669, t27672, t27674;
  double t27676, t27680, t27683, t27686, t27688, t27690, t27692, t27695;
  double t27698, t27699, t27701, t27703, t27704, t27707, t27710, t27717;
  double t27719, t27722, t27725, t27729, t27731, t27734, t27737, t27739;
  double t27743, t27745, t27748, t27752, t27758, t27762, t27764, t27766;
  double t27768, t27772, t27777, t27781, t27784, t27787, t27789, t27794;
  double t27796, t27800, t27802, t27805, t27807, t27808, t27810, t27811;
  double t27816, t27818, t27822, t27824, t27826, t27828, t27830, t27832;
  double t27834, t27836, t27838, t27840, t27842, t27845, t27848, t27849;
  double t27851, t27853, t27856, t27858, t27860, t27862, t27864, t27865;
  double t27866, t27868, t27869, t27872, t27875, t27877, t27879, t27881;
  double t27883, t27885, t27888, t27897, t27899, t27905, t27906, tv4rho2sigmatau6;
  double t27908, t27909, t27912, t27914, t27916, t27918, t27920, t27921;
  double t27922, t27924, t27927, t27929, t27931, t27932, t27935, t27937;
  double t27939, t27941, t27943, t27945, t27947, t27949, t27952, t27954;
  double t27956, t27958, t27961, t27963, t27965, t27967, t27970, t27973;
  double t27975, t27977, t27979, t27981, t27984, t27987, t27991, t27995;
  double t27999, t28001, t28003, t28004, t28005, t28007, t28009, t28012;
  double t28014, t28017, t28019, t28021, t28023, t28024, t28028, t28032;
  double t28035, t28043, t28045, t28049, t28052, t28054, t28057, t28059;
  double t28063, t28065, t28068, t28070, t28073, t28075, t28079, t28081;
  double t28083, t28084, t28086, t28090, t28095, t28099, t28101, t28102;
  double t28104, t28108, t28112, t28115, t28127, t28129, t28133, t28137;
  double t28139, t28141, t28145, t28147, t28149, t28151, t28153, t28157;
  double t28159, t28161, t28163, t28166, t28169, t28171, t28174, t28177;
  double t28179, t28183, t28187, t28189, t28191, t28192, t28195, t28197;
  double t28204, t28205, t28207, t28208, t28211, t28213, t28214, t28217;
  double t28219, t28221, t28222, t28223, t28225, t28226, t28227, t28229;
  double t28232, t28234, t28236, t28238, t28240, t28242, t28245, t28247;
  double t28249, t28251, t28254, t28256, t28258, t28260, t28262, t28266;
  double t28268, t28272, t28274, t28276, t28278, t28281, t28283, t28285;
  double t28286, t28287, t28293, t28296, t28298, t28300, t28304, t28307;
  double t28310, t28313, t28316, t28318, t28320, t28323, t28325, t28327;
  double t28329, t28331, t28333, t28335, t28337, t28340, t28342, t28344;
  double t28346, t28348, t28350, t28357, t28360, t28362, t28364, t28366;
  double t28369, t28371, t28373, t28375, t28382, t28384, t28388, t28392;
  double t28395, t28397, t28398, t28399, t28402, t28404, t28406, t28409;
  double t28411, t28413, t28416, t28419, t28421, t28423, t28425, t28427;
  double t28429, t28431, t28433, t28435, t28437, t28441, t28443, t28447;
  double t28451, t28454, t28457, t28462, t28465, t28467, t28469, t28472;
  double t28474, t28476, t28477, t28480, t28483, t28485, t28487, t28490;
  double t28493, t28497, t28500, t28503, t28505, t28507, t28510, t28513;
  double t28517, t28520, t28522, t28524, t28527, t28530, t28532, t28534;
  double t28537, t28540, t28543, t28546, t28549, t28551, t28553, t28555;
  double t28556, t28560, t28562, t28565, t28571, t28573, t28575, t28577;
  double t28579, t28582, t28584, t28586, t28588, t28590, t28593, t28595;
  double t28597, t28600, t28603, t28605, t28607, t28609, t28612, t28614;
  double t28616, t28619, t28621, t28623, t28624, t28626, t28627, t28629;
  double t28631, t28633, t28635, t28637, t28640, t28643, t28645, t28647;
  double t28651, t28653, t28656, t28658, t28661, t28663, t28666, t28668;
  double t28670, t28672, t28674, t28676, t28678, t28680, t28682, t28685;
  double t28688, t28691, t28693, t28695, t28701, t28702, tv4rho2sigmatau7, t28704;
  double t28705, t28712, t28713, t28714, t28717, t28719, t28721, t28724;
  double t28725, t28727, t28728, t28730, t28731, t28733, t28734, t28739;
  double t28747, t28748, t28749, t28751, t28752, t28757, t28763, t28764;
  double t28774, t28775, t28778, t28788, t28789, t28790, t28793, t28794;
  double t28795, t28800, t28801, t28804, t28806, t28807, t28812, t28821;
  double t28824, t28825, t28827, t28828, t28836, t28838, t28842, t28843;
  double t28858, t28865, t28874, t28881, t28891, t28893, t28895, t28909;
  double t28911, t28912, t28919, t28920, t28924, t28927, t28932, t28936;
  double t28941, t28943, t28947, t28967, t28972, t28973, t28975, t28976;
  double t28978, t28984, t28985, tv4rho2sigmatau8, t28995, t29003, t29006, t29007;
  double t29008, t29009, t29011, t29012, t29013, t29014, t29018, t29023;
  double t29024, t29025, t29031, t29034, t29035, t29036, t29037, t29038;
  double t29039, t29040, t29043, t29044, t29045, t29047, t29056, t29063;
  double t29074, t29076, t29077, t29078, t29088, t29101, t29102, t29103;
  double t29104, t29108, t29116, t29117, t29123, t29124, t29125, t29126;
  double t29127, t29128, t29129, t29142, t29143, t29154, t29155, t29156;
  double t29161, t29162, t29165, t29168, t29181, t29195, t29200, t29205;
  double t29206, t29208, t29209, t29210, t29211, t29215, t29220, t29221;
  double t29227, t29228, t29229, t29230, t29231, t29234, t29239, t29240;
  double t29241, t29242, t29252, t29258, t29267, t29268, t29269, t29270;
  double t29271, t29272, t29278, t29279, t29281, t29282, tv4rho2sigmatau9, tv4rho2sigmatau10;
  double tv4rho2sigmatau11, t29285, t29286, t29287, t29289, t29290, t29292, t29294;
  double t29296, t29297, t29299, t29300, t29302, t29304, t29307, t29309;
  double t29311, t29315, t29318, t29319, t29322, t29324, t29326, t29328;
  double t29330, t29332, t29336, t29339, t29341, t29343, t29347, t29351;
  double t29353, t29354, t29356, t29361, t29364, t29366, t29367, t29369;
  double t29370, t29375, t29377, t29379, t29381, t29383, t29386, t29391;
  double t29393, t29396, t29398, t29400, t29402, t29404, t29406, t29408;
  double t29414, t29417, t29419, t29421, t29424, t29427, t29430, t29433;
  double t29435, t29437, t29439, t29443, t29445, t29447, t29449, t29450;
  double t29452, t29454, t29456, t29458, t29460, t29462, t29464, t29466;
  double t29467, t29471, t29473, t29475, t29477, t29481, t29486, t29488;
  double t29490, t29493, t29496, t29499, t29501, t29503, t29506, t29509;
  double t29514, t29516, t29518, t29520, t29523, t29527, t29531, t29534;
  double t29537, t29540, t29542, t29544, t29548, t29551, t29553, t29554;
  double t29556, t29557, t29559, t29560, t29562, t29564, t29566, t29569;
  double t29571, t29574, t29576, t29577, t29578, t29580, t29581, t29582;
  double t29584, t29585, t29586, t29587, t29589, t29591, t29594, t29596;
  double t29599, t29601, t29603, t29605, t29608, t29611, t29613, t29616;
  double t29618, t29619, t29620, t29622, t29629, t29631, t29632, tv4rho2sigmatau12;
  double t29634, t29637, t29639, t29640, t29642, t29644, t29647, t29649;
  double t29651, t29653, t29655, t29656, t29659, t29661, t29664, t29667;
  double t29669, t29671, t29673, t29676, t29678, t29680, t29682, t29684;
  double t29686, t29687, t29689, t29693, t29695, t29696, t29698, t29700;
  double t29702, t29704, t29706, t29707, t29709, t29711, t29712, t29714;
  double t29716, t29718, t29720, t29722, t29724, t29728, t29732, t29736;
  double t29741, t29745, t29747, t29749, t29751, t29753, t29755, t29757;
  double t29759, t29762, t29764, t29765, t29767, t29768, t29769, t29771;
  double t29775, t29777, t29780, t29782, t29784, t29786, t29789, t29792;
  double t29794, t29796, t29799, t29802, t29804, t29806, t29808, t29810;
  double t29812, t29814, t29816, t29818, t29821, t29823, t29827, t29829;
  double t29831, t29833, t29837, t29839, t29841, t29844, t29848, t29852;
  double t29855, t29858, t29861, t29864, t29866, t29867, t29869, t29871;
  double t29874, t29877, t29879, t29882, t29884, t29887, t29889, t29891;
  double t29893, t29896, t29898, t29902, t29904, t29907, t29909, t29911;
  double t29915, t29917, t29920, t29922, t29924, t29925, t29927, t29930;
  double t29933, t29935, t29937, t29940, t29942, t29944, t29946, t29949;
  double t29951, t29955, t29958, t29960, t29961, t29964, t29966, t29968;
  double t29971, t29974, t29977, t29981, t29983, t29985, t29987, t29989;
  double t29992, t29994, t29997, t30000, t30005, t30007, t30009, t30011;
  double t30014, t30017, t30021, t30023, t30024, t30026, t30029, t30031;
  double t30035, t30037, t30040, t30042, t30045, t30048, t30053, t30055;
  double t30057, t30058, t30060, t30062, t30066, t30068, t30071, t30075;
  double t30079, t30081, t30087, t30088, t30091, t30093, tv4rho2sigmatau13, t30106;
  double t30113, t30142, t30163, t30186, t30209, t30227, t30248, t30271;
  double t30290, t30306, t30312, t30317, tv4rho2sigmatau14, t30322, t30333, t30354;
  double t30368, t30380, t30392, t30408, t30418, t30431, t30446, t30464;
  double t30476, t30491, t30504, t30522, t30535, t30545, t30559, t30574;
  double t30589, t30600, t30614, tv4rho2sigmatau15, tv4rho2sigmatau16, tv4rho2sigmatau17, tv4rho2lapl20, tv4rho2lapl21;
  double tv4rho2lapl22, tv4rho2lapl23, tv4rho2lapl24, tv4rho2lapl25, tv4rho2lapl26, tv4rho2lapl27, tv4rho2lapl28, tv4rho2lapltau0;
  double tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8;
  double tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, t30622, t30624, t30630, t30631, t30633;
  double t30642, t30643, t30645, t30651, t30657, t30673, t30674, t30680;
  double t30681, t30685, t30690, t30691, t30697, t30700, t30716, t30734;
  double t30738, t30745, t30747, t30758, t30763, t30765, t30767, t30768;
  double t30772, t30778, t30780, t30781, t30783, t30784, t30794, t30804;
  double t30808, t30809, t30810, t30815, t30819, t30824, t30827, t30830;
  double t30835, t30843, t30847, t30851, t30858, t30860, t30862, t30867;
  double t30870, t30874, t30877, t30879, t30882, t30888, t30889, t30891;
  double t30895, t30896, t30901, t30903, t30905, t30907, t30909, t30915;
  double t30917, t30924, t30927, t30932, t30934, t30960, t30982, t30985;
  double t30989, t30990, t30994, t30995, t30997, t31001, t31005, t31007;
  double t31008, t31021, t31022, t31024, t31028, t31030, t31032, t31034;
  double t31036, t31041, t31045, t31046, t31059, t31071, t31078, t31080;
  double t31088, t31092, t31100, t31104, t31118, t31121, t31126, t31135;
  double t31138, t31145, t31148, t31151, t31162, t31170, t31174, t31175;
  double t31178, t31182, t31194, t31200, t31211, tv4rho2tau20, t31212, t31214;
  double t31224, t31225, t31232, t31233, t31238, t31243, t31264, t31269;
  double t31270, t31272, t31274, t31276, t31278, t31283, t31285, t31293;
  double t31294, t31296, t31300, t31301, t31308, t31310, t31311, t31313;
  double t31318, t31325, t31342, t31343, t31349, t31351, t31359, t31361;
  double t31364, t31402, t31409, t31420, t31423, t31433, t31434, t31436;
  double t31438, t31440, t31446, t31451, t31455, t31458, t31460, t31462;
  double t31471, t31473, t31478, t31499, t31507, t31511, t31512, t31520;
  double t31525, t31527, t31546, t31548, t31553, t31557, t31559, t31562;
  double t31564, t31578, t31581, t31590, t31605, t31607, t31613, t31614;
  double t31617, t31618, t31621, t31625, t31628, t31629, t31633, t31638;
  double t31647, t31663, t31668, t31673, t31678, t31683, t31689, t31696;
  double t31731, t31735, t31747, t31753, t31761, t31768, t31769, t31774;
  double t31778, t31787, t31789, t31791, t31795, t31797, t31803, t31823;
  double t31840, t31857, t31859, t31861, t31871, t31873, t31878, t31882;
  double t31884, t31897, t31899, t31905, t31911, t31912, t31915, t31941;
  double t31954, t31966, t31967, t31969, t31970, t31975, tv4rho2tau21, t31983;
  double t31984, t31991, t31994, t31995, t32002, t32003, t32010, t32011;
  double t32020, t32022, t32023, t32030, t32032, t32042, t32043, t32045;
  double t32047, t32059, t32060, t32063, t32067, t32069, t32070, t32077;
  double t32080, t32082, t32084, t32086, t32088, t32090, t32092, t32094;
  double t32097, t32103, t32112, t32114, t32116, t32118, t32120, t32127;
  double t32129, t32130, t32132, t32135, t32141, t32145, t32153, t32162;
  double t32165, t32175, t32205, t32211, t32217, t32218, t32223, t32239;
  double t32242, t32250, t32257, t32261, t32263, t32265, t32269, t32275;
  double t32277, t32301, t32305, t32323, t32336, t32338, t32343, t32351;
  double t32356, t32357, t32366, t32394, t32399, tv4rho2tau22, t32435, t32460;
  double t32466, t32470, t32472, t32497, t32512, t32525, t32528, t32537;
  double t32540, t32544, t32555, t32556, t32558, t32559, t32562, t32565;
  double t32571, t32574, t32579, t32581, t32584, t32596, t32599, t32611;
  double t32616, t32628, t32641, t32672, t32689, t32691, t32696, t32703;
  double t32712, t32715, t32731, t32739, t32740, t32750, t32754, t32765;
  double t32786, t32790, t32801, t32804, t32811, t32816, t32827, t32829;
  double t32832, t32847, t32854, t32873, t32877, t32879, t32881, t32886;
  double t32890, t32891, t32894, t32895, t32903, t32907, t32915, t32921;
  double t32922, t32926, t32928, t32931, t32932, t32935, t32936, t32939;
  double t32943, t32949, t32952, t32960, t32962, t32965, t32985, t32996;
  double t33002, t33003, t33005, t33006, tv4rho2tau23, t33019, t33026, t33039;
  double t33042, t33046, t33050, t33059, t33060, t33067, t33070, t33075;
  double t33083, t33086, t33094, t33100, t33105, t33107, t33127, t33137;
  double t33147, t33149, t33155, t33160, t33169, t33173, t33176, t33184;
  double t33186, t33191, t33193, t33196, t33207, t33221, t33222, t33226;
  double t33230, t33231, t33266, t33283, t33285, t33316, t33324, t33334;
  double t33342, t33374, t33382, t33407, t33425, t33431, t33439, t33463;
  double t33467, t33490, t33507, t33520, t33523, t33536, t33541, t33542;
  double t33547, t33550, t33552, t33589, t33601, t33604, t33610, t33612;
  double t33614, t33655, t33674, t33676, t33681, t33684, t33690, t33697;
  double t33700, t33707, t33767, t33771, t33783, t33792, t33796, t33798;
  double t33804, t33845, t33857, t33875, t33882, t33915, t33922, t33924;
  double t33951, t33954, t33960, t33978, t33984, t33985, t33987, t33988;
  double tv4rho2tau24, t33990, t33992, t34000, t34005, t34008, t34011, t34025;
  double t34044, t34061, t34066, t34075, t34078, t34081, t34084, t34087;
  double t34089, t34093, t34101, t34113, t34120, t34126, t34128, t34134;
  double t34148, t34152, t34163, t34175, t34180, t34197, t34198, t34204;
  double t34224, t34229, t34233, t34245, t34248, t34261, t34272, t34294;
  double t34297, t34308, t34342, t34372, t34381, t34383, t34397, t34406;
  double t34408, t34425, t34430, t34442, t34459, t34467, t34476, t34479;
  double t34482, t34487, t34489, t34491, t34497, t34503, t34513, t34516;
  double t34534, t34535, t34539, t34546, t34549, t34553, t34556, t34570;
  double t34576, t34578, t34579, tv4rho2tau25, t34591, t34611, t34642, t34659;
  double t34686, t34693, t34697, t34714, t34717, t34720, t34721, t34757;
  double t34782, t34800, t34809, t34838, t34847, t34879, t34903, t34910;
  double tv4rho2tau26, t34929, t34944, t34951, t34952, t34962, t34969, t34985;
  double t35001, t35036, t35037, t35044, t35065, t35077, t35091, t35117;
  double t35121, t35130, t35155, t35161, t35178, t35211, t35235, t35268;
  double t35303, t35331, t35361, t35398, t35431, t35468, t35500, t35512;
  double tv4rho2tau27, t35526, t35561, t35572, t35612, t35649, t35705, t35731;
  double t35769, t35780, t35802, t35830, t35867, t35924, t35939, tv4rho2tau28;
  double t35940, t35941, t35943, t35944, t35945, t35947, t35948, t35950;
  double t35952, t35955, t35956, t35958, t35959, t35960, t35961, t35964;
  double t35966, t35969, t35970, t35972, t35975, t35977, t35979, t35983;
  double t35987, t35988, t35989, t35991, t35993, t35997, t35998, t36000;
  double t36003, t36006, t36007, t36009, t36011, t36012, t36013, t36014;
  double t36016, t36018, t36022, t36023, t36027, tv4rhosigma30, t36029, t36033;
  double t36036, t36041, t36043, t36045, t36047, t36050, t36054, tv4rhosigma31;
  double tv4rhosigma32, t36056, t36060, t36063, t36068, t36070, t36072, t36074;
  double t36077, t36081, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, t36083, t36087, t36090;
  double t36095, t36097, t36099, t36101, t36104, t36108, tv4rhosigma36, tv4rhosigma37;
  double tv4rhosigma38, tv4rhosigma39, t36110, t36111, t36113, t36115, t36117, t36120;
  double t36123, t36125, t36127, t36129, t36133, t36136, t36140, t36143;
  double t36145, t36146, t36149, t36154, tv4rhosigma310, t36173, tv4rhosigma311, tv4rhosigma312;
  double t36192, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, t36211, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318;
  double tv4rhosigma319, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6;
  double tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, tv4rhosigma2lapl11, tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14;
  double tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22;
  double tv4rhosigma2lapl23, t36214, t36217, t36219, t36221, t36222, t36224, t36226;
  double t36227, t36229, t36230, t36231, t36233, t36235, t36236, t36237;
  double t36238, t36241, t36244, t36246, t36247, t36249, t36251, t36252;
  double t36253, t36254, t36255, t36256, t36258, t36260, t36261, t36265;
  double t36267, t36269, t36270, t36272, t36274, t36278, t36282, t36286;
  double t36288, t36289, t36290, t36292, t36294, t36296, t36297, t36298;
  double t36299, t36301, t36303, t36306, t36308, t36310, t36313, t36314;
  double t36317, t36320, t36321, t36323, t36324, t36325, t36326, t36327;
  double t36328, t36329, t36330, t36331, t36332, t36336, t36338, t36341;
  double t36343, t36344, t36347, t36348, t36350, t36354, t36356, t36357;
  double t36358, t36359, t36361, t36362, t36363, t36366, t36367, t36369;
  double t36372, t36373, t36374, t36376, t36377, t36378, t36380, t36381;
  double t36382, t36385, t36387, t36391, t36393, t36395, t36396, t36397;
  double t36399, t36401, t36405, t36408, t36410, t36414, t36415, t36419;
  double t36422, t36424, t36426, t36428, tv4rhosigma2tau0, t36432, t36433, t36436;
  double t36437, t36438, t36439, t36441, t36443, t36445, t36446, t36448;
  double t36449, t36450, t36451, t36453, t36454, t36456, t36458, t36460;
  double t36462, t36464, t36465, t36468, t36470, t36474, t36476, t36480;
  double t36482, t36484, t36485, t36487, t36489, t36492, t36494, t36498;
  double t36499, t36502, t36503, t36506, t36508, t36509, t36513, t36516;
  double t36518, t36521, t36523, t36525, t36527, t36530, t36531, t36532;
  double t36533, t36534, t36535, t36538, t36540, t36543, t36547, t36549;
  double t36551, t36554, t36556, t36558, t36560, t36562, t36563, t36565;
  double t36566, t36567, t36568, t36569, t36570, t36571, t36572, t36574;
  double t36576, t36578, t36581, t36583, tv4rhosigma2tau1, t36589, t36591, t36592;
  double t36594, t36599, t36603, t36607, t36609, t36610, t36611, t36625;
  double t36630, t36631, t36632, t36633, t36641, t36646, t36647, t36648;
  double t36656, tv4rhosigma2tau2, t36661, t36662, t36665, t36666, t36667, t36668;
  double t36672, t36680, t36683, t36686, t36692, t36697, t36698, t36699;
  double t36706, t36710, t36711, t36712, t36713, t36719, tv4rhosigma2tau3, tv4rhosigma2tau4;
  double tv4rhosigma2tau5, t36725, t36727, t36728, t36730, t36735, t36739, t36743;
  double t36745, t36746, t36747, t36761, t36767, t36768, t36769, t36770;
  double t36777, t36783, t36784, t36785, t36792, tv4rhosigma2tau6, t36797, t36798;
  double t36801, t36802, t36803, t36804, t36808, t36814, t36817, t36822;
  double t36828, t36834, t36835, t36836, t36842, t36846, t36847, t36848;
  double t36849, t36855, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, tv4rhosigma2tau11, t36860;
  double t36862, t36863, t36865, t36866, t36869, t36871, t36873, t36875;
  double t36877, t36878, t36880, t36881, t36883, t36886, t36890, t36892;
  double t36895, t36898, t36903, t36907, t36909, t36913, t36915, t36917;
  double t36919, t36921, t36922, t36923, t36925, t36927, t36929, t36932;
  double t36934, t36938, t36940, t36944, t36946, t36947, t36950, t36952;
  double t36953, t36956, t36957, t36959, t36960, t36964, t36966, t36970;
  double t36974, t36976, tv4rhosigma2tau12, t36981, t36984, t36986, t36987, t36989;
  double t36990, t36992, t36994, t36996, t36997, t37000, t37003, t37005;
  double t37008, t37010, t37011, t37013, t37015, t37018, t37020, t37022;
  double t37024, t37028, t37030, t37033, t37035, t37038, t37040, t37043;
  double t37045, t37049, t37053, t37057, t37059, t37063, t37066, t37068;
  double t37071, t37074, t37076, t37078, t37079, t37081, t37083, t37085;
  double t37089, t37091, t37093, t37097, t37099, t37102, t37106, t37109;
  double t37114, tv4rhosigma2tau13, t37126, t37132, t37150, t37161, tv4rhosigma2tau14, t37176;
  double t37188, t37210, t37218, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, t37230, t37236;
  double t37248, t37265, tv4rhosigma2tau18, t37280, t37292, t37306, t37322, tv4rhosigma2tau19;
  double tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, tv4rhosigma2tau23, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23;
  double tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, tv4rhosigmalapl28, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211;
  double tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1;
  double tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9;
  double tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17;
  double tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, t37327, t37329;
  double t37330, t37333, t37336, t37338, t37340, t37343, t37345, t37346;
  double t37348, t37350, t37351, t37353, t37354, t37355, t37357, t37358;
  double t37361, t37362, t37365, t37366, t37367, t37368, t37370, t37372;
  double t37374, t37376, t37377, t37378, t37379, t37381, t37383, t37386;
  double t37388, t37389, t37390, t37392, t37393, t37394, t37396, t37398;
  double t37400, t37401, t37404, t37405, t37406, t37407, t37408, t37409;
  double t37410, t37412, t37415, t37417, t37418, t37421, t37423, t37427;
  double t37429, t37430, t37432, t37434, t37437, t37439, t37440, t37442;
  double t37443, t37444, t37445, t37446, t37448, t37450, t37453, t37455;
  double t37458, t37461, t37462, t37464, t37465, t37466, t37468, t37470;
  double t37474, t37477, t37479, t37483, t37484, t37488, t37490, t37492;
  double t37493, t37496, t37498, t37499, t37503, t37506, t37508, t37509;
  double t37511, t37512, t37513, t37514, t37515, t37516, t37518, t37522;
  double t37525, t37528, t37530, t37533, t37535, t37537, t37538, t37539;
  double t37541, t37544, t37545, t37547, t37548, t37550, t37552, t37554;
  double t37556, t37558, t37561, t37562, t37564, t37567, t37568, t37569;
  double t37571, t37572, t37575, t37578, t37580, t37581, t37582, t37583;
  double t37584, t37585, t37586, t37587, t37589, t37591, t37592, t37593;
  double t37595, t37597, tv4rhosigmatau20, t37601, t37602, t37603, t37606, t37608;
  double t37611, t37612, t37613, t37614, t37615, t37618, t37620, t37622;
  double t37626, t37629, t37632, t37636, t37638, t37640, t37641, t37643;
  double t37645, t37648, t37650, t37653, t37654, t37656, t37659, t37662;
  double t37664, t37666, t37669, t37670, t37673, t37675, t37677, t37680;
  double t37681, t37683, t37685, t37688, t37689, t37691, t37694, t37695;
  double t37697, t37700, t37702, t37704, t37706, t37707, t37708, t37709;
  double t37711, t37712, t37715, t37716, t37717, t37718, t37720, t37721;
  double t37722, t37726, t37727, t37728, t37730, t37732, t37735, t37736;
  double t37738, t37739, t37740, t37742, t37744, t37745, t37746, t37749;
  double t37750, t37752, t37754, t37757, t37759, t37761, t37763, t37765;
  double t37769, t37772, t37773, t37774, t37775, t37777, t37779, t37781;
  double t37784, t37786, t37787, t37788, t37790, t37793, t37796, t37799;
  double t37802, t37804, t37806, t37807, t37808, t37809, t37812, t37813;
  double t37814, t37817, t37818, t37821, t37823, t37824, t37825, t37826;
  double t37827, t37831, t37832, t37835, t37836, t37837, t37840, t37843;
  double t37844, t37847, t37850, t37852, t37854, t37857, t37859, t37861;
  double t37864, t37866, t37868, t37870, t37872, t37874, t37876, t37878;
  double t37880, t37881, t37883, t37885, t37887, t37888, t37889, t37891;
  double t37893, t37895, t37897, t37899, t37902, t37904, t37906, t37908;
  double t37910, t37913, t37915, t37918, t37920, t37922, tv4rhosigmatau21, t37928;
  double t37931, t37934, t37936, t37937, t37940, t37942, t37944, t37946;
  double t37949, t37950, t37952, t37953, t37955, t37957, t37959, t37960;
  double t37961, t37962, t37963, t37965, t37968, t37970, t37971, t37972;
  double t37973, t37975, t37976, t37979, t37982, t37984, t37986, t37989;
  double t37990, t37991, t37992, t37996, t37999, t38002, t38004, t38006;
  double t38009, t38010, t38012, t38013, t38016, t38020, t38022, t38024;
  double t38025, t38026, t38027, t38028, t38029, t38032, t38034, t38037;
  double t38040, t38042, t38043, t38045, t38046, t38047, t38048, t38049;
  double t38051, t38052, t38054, t38055, t38056, t38057, t38058, t38059;
  double t38060, t38061, t38062, t38064, t38065, t38066, t38067, t38069;
  double t38071, t38073, t38075, t38077, t38080, t38081, t38082, t38084;
  double t38086, t38088, t38090, t38092, t38095, t38099, t38103, t38106;
  double t38108, t38110, t38111, t38113, t38115, t38118, t38120, t38124;
  double t38125, t38129, tv4rhosigmatau22, t38142, t38143, t38147, t38152, t38158;
  double t38160, t38161, t38163, t38173, t38177, t38181, t38182, t38184;
  double t38195, t38196, t38197, t38198, t38203, t38205, t38207, t38208;
  double t38212, t38218, t38219, t38220, t38224, tv4rhosigmatau23, t38230, t38239;
  double t38242, t38244, t38249, t38251, t38253, t38255, t38257, t38261;
  double t38262, t38264, t38266, t38268, t38275, t38280, t38287, t38295;
  double t38301, t38302, t38303, t38304, t38308, t38309, t38311, t38312;
  double t38313, t38326, t38330, t38339, tv4rhosigmatau24, t38351, t38352, t38356;
  double t38357, t38360, t38362, t38368, t38375, t38376, t38378, t38381;
  double t38382, t38385, t38388, t38396, t38397, t38398, t38400, t38401;
  double t38402, t38403, t38404, t38405, t38407, t38412, t38422, tv4rhosigmatau25;
  double tv4rhosigmatau26, tv4rhosigmatau27, tv4rhosigmatau28, t38427, t38430, t38432, t38433, t38436;
  double t38439, t38441, t38442, t38445, t38449, t38452, t38455, t38457;
  double t38459, t38462, t38465, t38466, t38468, t38469, t38470, t38473;
  double t38475, t38477, t38478, t38480, t38482, t38485, t38487, t38488;
  double t38490, t38491, t38492, t38495, t38497, t38499, t38500, t38504;
  double t38507, t38509, t38511, t38513, t38516, t38518, t38520, t38521;
  double t38525, t38528, t38530, t38531, t38534, t38537, t38540, t38542;
  double t38543, t38545, t38546, t38547, t38549, t38550, t38554, t38556;
  double t38560, t38564, t38566, t38567, t38570, t38573, t38577, t38579;
  double tv4rhosigmatau29, t38583, t38586, t38587, t38589, t38591, t38594, t38596;
  double t38598, t38599, t38600, t38603, t38606, t38608, t38609, t38611;
  double t38613, t38615, t38618, t38621, t38623, t38624, t38627, t38629;
  double t38632, t38634, t38636, t38638, t38640, t38641, t38642, t38644;
  double t38646, t38648, t38650, t38652, t38655, t38657, t38660, t38663;
  double t38668, t38670, t38672, t38674, t38676, t38679, t38681, t38685;
  double t38687, t38689, t38691, t38694, t38696, t38698, t38700, t38702;
  double t38705, t38707, t38709, t38711, t38714, t38717, t38720, t38722;
  double t38726, t38728, t38732, t38734, t38735, t38737, t38739, t38741;
  double t38743, t38746, t38749, t38752, t38755, t38757, t38759, t38761;
  double t38763, t38766, t38769, t38771, t38774, t38776, t38779, t38782;
  double t38784, t38785, t38787, t38789, t38793, t38795, t38798, t38800;
  double t38801, t38804, t38806, t38809, t38811, tv4rhosigmatau210, t38817, t38820;
  double t38822, t38823, t38826, t38829, t38832, t38834, t38836, t38839;
  double t38841, t38843, t38846, t38849, t38851, t38853, t38855, t38858;
  double t38860, t38862, t38865, t38867, t38870, t38872, t38876, t38878;
  double t38879, t38881, t38883, t38885, t38886, t38888, t38889, t38891;
  double t38894, t38896, t38899, t38902, t38904, t38906, t38908, t38911;
  double t38913, t38916, t38920, t38923, t38928, t38932, t38934, t38937;
  double t38940, t38941, t38945, t38948, t38950, t38952, t38955, t38958;
  double t38960, t38962, t38965, t38967, t38969, t38973, t38975, t38977;
  double t38980, t38982, t38984, t38988, t38991, t38993, tv4rhosigmatau211, t39011;
  double t39028, t39046, t39053, tv4rhosigmatau212, t39066, t39074, t39082, t39093;
  double t39107, t39114, t39124, t39146, tv4rhosigmatau213, t39171, t39188, t39200;
  double t39220, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, tv4rhosigmatau217, tv4rholapl30, tv4rholapl31, tv4rholapl32;
  double tv4rholapl33, tv4rholapl34, tv4rholapl35, tv4rholapl36, tv4rholapl37, tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2;
  double tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10;
  double tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, tv4rholapltau25, tv4rholapltau26;
  double tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, t39226, t39229, t39230;
  double t39231, t39232, t39237, t39238, t39248, t39250, t39255, t39262;
  double t39264, t39267, t39268, t39269, t39272, t39273, t39276, t39281;
  double t39282, t39292, t39295, t39302, t39308, t39311, t39316, t39321;
  double t39328, t39333, t39336, t39337, t39340, t39345, t39347, t39349;
  double t39351, t39353, t39357, t39363, t39379, t39382, t39392, t39396;
  double t39401, t39404, t39414, t39419, t39431, tv4rhotau30, t39446, t39453;
  double t39458, t39462, t39470, t39486, t39501, t39510, t39517, t39518;
  double t39525, t39535, t39536, t39545, t39555, t39563, t39570, t39574;
  double t39584, t39589, t39595, t39598, t39607, t39618, t39621, t39632;
  double tv4rhotau31, t39650, t39654, t39665, t39669, t39679, t39686, t39689;
  double t39700, t39702, t39703, t39711, t39726, t39737, t39744, t39748;
  double t39752, t39756, t39761, t39772, t39775, t39789, t39796, t39803;
  double t39807, t39816, t39830, t39839, t39846, tv4rhotau32, t39850, t39857;
  double t39860, t39865, t39870, t39871, t39879, t39884, t39889, t39894;
  double t39895, t39904, t39909, t39916, t39925, t39930, t39933, t39937;
  double t39943, t39962, t39967, t39969, t39971, t39974, t39979, t39983;
  double t39993, t39995, t39996, t39999, t40004, tv4rhotau33, t40023, t40026;
  double t40036, t40043, t40047, t40051, t40054, t40065, t40121, tv4rhotau34;
  double t40148, t40157, t40160, t40217, t40251, t40277, tv4rhotau35, t40319;
  double t40349, t40379, t40442, tv4rhotau36, t40446, t40447, t40448, t40459;
  double t40464, t40465, t40501, t40542, t40566, t40590, tv4rhotau37, t40595;
  double t40596, t40598, t40602, t40603, t40606, t40610, t40616, t40619;
  double t40623, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46;
  double tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, tv4sigma414;
  double tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7;
  double tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15;
  double tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, tv4sigma3lapl19, t40664, t40666, t40668, t40670;
  double t40673, t40675, t40676, t40678, t40679, t40683, t40685, t40688;
  double t40690, t40692, t40694, t40698, tv4sigma3tau0, t40703, t40705, t40708;
  double t40713, t40715, t40719, t40722, t40724, t40726, t40730, tv4sigma3tau1;
  double tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9;
  double tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17;
  double tv4sigma3tau18, tv4sigma3tau19, tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25;
  double tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213;
  double tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3;
  double tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11;
  double tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19;
  double tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23, t40813, t40814, t40816, t40817;
  double t40820, t40821, t40823, t40824, t40827, t40829, t40832, t40833;
  double t40835, t40837, t40839, t40841, t40844, t40847, t40850, t40852;
  double t40854, t40855, t40859, t40863, tv4sigma2tau20, t40864, t40867, t40869;
  double t40872, t40874, t40877, t40882, t40884, t40886, t40888, t40890;
  double t40892, t40897, t40899, t40901, t40904, t40908, tv4sigma2tau21, t40909;
  double t40911, t40913, t40915, t40918, t40923, t40926, t40928, t40931;
  double t40934, t40937, t40939, t40941, t40945, t40949, tv4sigma2tau22, t40966;
  double tv4sigma2tau23, t40983, tv4sigma2tau24, t41000, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28;
  double t41017, tv4sigma2tau29, t41034, tv4sigma2tau210, t41051, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213;
  double tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216, tv4sigma2tau217, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33;
  double tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, tv4sigmalapl311;
  double tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7;
  double tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15;
  double tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25;
  double tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213;
  double tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, t41052, t41053, t41056, t41057;
  double t41059, t41060, t41062, t41063, t41065, t41066, t41068, t41071;
  double t41072, t41075, t41077, t41081, t41082, t41085, t41087, t41089;
  double t41092, t41094, t41096, t41098, t41100, t41102, t41105, t41107;
  double t41108, t41110, t41112, t41116, tv4sigmatau30, t41117, t41119, t41121;
  double t41123, t41125, t41127, t41129, t41132, t41135, t41139, t41142;
  double t41144, t41146, t41148, t41150, t41151, t41154, t41156, t41158;
  double t41161, t41165, tv4sigmatau31, t41166, t41169, t41172, t41174, t41177;
  double t41180, t41183, t41187, t41189, t41191, t41193, t41195, t41197;
  double t41200, t41201, t41204, t41206, t41209, t41212, t41216, tv4sigmatau32;
  double t41217, t41220, t41221, t41223, t41225, t41227, t41229, t41232;
  double t41235, t41240, t41243, t41245, t41248, t41250, t41252, t41254;
  double t41257, t41260, t41262, t41265, t41269, tv4sigmatau33, t41289, tv4sigmatau34;
  double t41309, tv4sigmatau35, t41329, tv4sigmatau36, t41349, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39;
  double tv4sigmatau310, tv4sigmatau311, tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, tv4lapl44, tv4lapl3tau0;
  double tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20;
  double tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28;
  double tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36, tv4lapltau37;
  double t41351, t41352, t41354, t41355, t41359, t41364, t41367, t41369;
  double t41374, t41383, t41385, t41386, t41395, t41404, tv4tau40, tv4tau41;
  double tv4tau42, tv4tau43, t41541, t41542, t41544, t41545, t41554, t41567;
  double t41568, t41577, tv4tau44;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t7 = tau[0] * t6;
  t8 = rho[0] - rho[1];
  t9 = rho[0] + rho[1];
  t10 = 0.1e1 / t9;
  t11 = t8 * t10;
  t12 = 0.1e1 + t11;
  t13 = t12 / 0.2e1;
  t14 = POW_1_3(t13);
  t15 = t14 * t14;
  t16 = t15 * t13;
  t17 = t7 * t16;
  t18 = POW_1_3(rho[1]);
  t19 = t18 * t18;
  t21 = 0.1e1 / t19 / rho[1];
  t22 = tau[1] * t21;
  t23 = 0.1e1 - t11;
  t24 = t23 / 0.2e1;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = t26 * t24;
  t28 = t22 * t27;
  t30 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t31 = t9 * t9;
  t32 = POW_1_3(t9);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / t31;
  t38 = t17 + t28 - t30 * t35 / 0.8e1;
  t39 = t2 * t38;
  t40 = M_CBRT6;
  t41 = M_PI * M_PI;
  t42 = POW_1_3(t41);
  t43 = t42 * t42;
  t44 = 0.1e1 / t43;
  t45 = t40 * t44;
  t46 = t39 * t45;
  t47 = M_CBRT2;
  t48 = t47 * t47;
  t50 = t45 * t48;
  t53 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t38 * t50;
  t54 = 0.1e1 / t53;
  t55 = t48 * t54;
  t56 = t31 * t31;
  t58 = 0.1e1 / t33 / t56;
  t59 = t30 * t58;
  t60 = t17 + t28;
  t61 = 0.1e1 / t60;
  t62 = t8 * t8;
  t63 = t61 * t62;
  t66 = 0.1e1 - t59 * t63 / 0.8e1;
  t67 = M_CBRT3;
  t68 = 0.1e1 / M_PI;
  t69 = POW_1_3(t68);
  t70 = t67 * t69;
  t71 = M_CBRT4;
  t72 = t71 * t71;
  t75 = t70 * t72 / t32;
  t77 = 0.1e1 + 0.53425e-1 * t75;
  t78 = sqrt(t75);
  t81 = POW_3_2(t75);
  t83 = t67 * t67;
  t84 = t69 * t69;
  t85 = t83 * t84;
  t88 = t85 * t71 / t33;
  t90 = 0.379785e1 * t78 + 0.8969e0 * t75 + 0.204775e0 * t81 + 0.123235e0 * t88;
  t93 = 0.1e1 + 0.16081979498692535067e2 / t90;
  t94 = log(t93);
  t96 = 0.621814e-1 * t77 * t94;
  t97 = t62 * t62;
  t98 = 0.1e1 / t56;
  t99 = t97 * t98;
  t100 = t12 <= p->zeta_threshold;
  t101 = POW_1_3(p->zeta_threshold);
  t102 = t101 * p->zeta_threshold;
  t103 = POW_1_3(t12);
  t105 = my_piecewise3(t100, t102, t103 * t12);
  t106 = t23 <= p->zeta_threshold;
  t107 = POW_1_3(t23);
  t109 = my_piecewise3(t106, t102, t107 * t23);
  t110 = t105 + t109 - 0.2e1;
  t113 = 0.1e1 / (0.2e1 * t47 - 0.2e1);
  t114 = t110 * t113;
  t116 = 0.1e1 + 0.5137e-1 * t75;
  t121 = 0.705945e1 * t78 + 0.1549425e1 * t75 + 0.420775e0 * t81 + 0.1562925e0 * t88;
  t124 = 0.1e1 + 0.32163958997385070134e2 / t121;
  t125 = log(t124);
  t129 = 0.1e1 + 0.278125e-1 * t75;
  t134 = 0.51785e1 * t78 + 0.905775e0 * t75 + 0.1100325e0 * t81 + 0.1241775e0 * t88;
  t137 = 0.1e1 + 0.29608749977793437516e2 / t134;
  t138 = log(t137);
  t139 = t129 * t138;
  t141 = -0.310907e-1 * t116 * t125 + t96 - 0.19751673498613801407e-1 * t139;
  t142 = t114 * t141;
  t146 = -t96 + t99 * t142 + 0.19751673498613801407e-1 * t114 * t139;
  t147 = t66 * t146;
  t148 = t55 * t147;
  t150 = 0.5e1 / 0.9e1 * t46 * t148;
  t151 = t39 * t40;
  t152 = t44 * t48;
  t153 = t152 * t54;
  t154 = t151 * t153;
  t156 = 0.1e1 - 0.5e1 / 0.9e1 * t154;
  t157 = t156 * t146;
  tzk0 = t150 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = rho[0] * rho[0];
  t160 = 0.1e1 / t4 / t158;
  t161 = tau[0] * t160;
  t162 = t161 * t16;
  t164 = 0.1e1 / t31;
  t165 = t8 * t164;
  t166 = t10 - t165;
  t167 = t166 / 0.2e1;
  t168 = t15 * t167;
  t169 = t7 * t168;
  t171 = -t167;
  t172 = t26 * t171;
  t173 = t22 * t172;
  t175 = t31 * t9;
  t177 = 0.1e1 / t33 / t175;
  t179 = t30 * t177 / 0.3e1;
  t180 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173 + t179;
  t181 = t2 * t180;
  t182 = t181 * t45;
  t183 = t182 * t148;
  t184 = 0.5e1 / 0.9e1 * t183;
  t185 = t40 * t40;
  t187 = 0.1e1 / t42 / t41;
  t188 = t185 * t187;
  t189 = t188 * t47;
  t190 = t39 * t189;
  t191 = t53 * t53;
  t192 = 0.1e1 / t191;
  t193 = t192 * t66;
  t194 = t146 * params->c;
  t195 = t194 * t180;
  t196 = t193 * t195;
  t197 = t190 * t196;
  t198 = 0.5e2 / 0.81e2 * t197;
  t199 = t56 * t9;
  t201 = 0.1e1 / t33 / t199;
  t202 = t30 * t201;
  t204 = 0.7e1 / 0.12e2 * t202 * t63;
  t205 = t60 * t60;
  t206 = 0.1e1 / t205;
  t207 = t206 * t62;
  t209 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173;
  t210 = t207 * t209;
  t213 = t61 * t8;
  t215 = t59 * t213 / 0.4e1;
  t216 = t204 + t59 * t210 / 0.8e1 - t215;
  t217 = t216 * t146;
  t218 = t55 * t217;
  t219 = t46 * t218;
  t220 = 0.5e1 / 0.9e1 * t219;
  t222 = 0.1e1 / t32 / t9;
  t223 = t72 * t222;
  t226 = 0.11073470983333333333e-2 * t70 * t223 * t94;
  t227 = t90 * t90;
  t228 = 0.1e1 / t227;
  t229 = t77 * t228;
  t231 = 0.1e1 / t78 * t67;
  t232 = t69 * t72;
  t233 = t232 * t222;
  t234 = t231 * t233;
  t236 = t70 * t223;
  t238 = sqrt(t75);
  t239 = t238 * t67;
  t240 = t239 * t233;
  t245 = t85 * t71 / t33 / t9;
  t247 = -0.632975e0 * t234 - 0.29896666666666666667e0 * t236 - 0.1023875e0 * t240 - 0.82156666666666666667e-1 * t245;
  t248 = 0.1e1 / t93;
  t249 = t247 * t248;
  t251 = 0.1e1 * t229 * t249;
  t252 = t62 * t8;
  t253 = t252 * t98;
  t255 = 0.4e1 * t253 * t142;
  t256 = 0.1e1 / t199;
  t257 = t97 * t256;
  t259 = 0.4e1 * t257 * t142;
  t262 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t166);
  t263 = -t166;
  t266 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t263);
  t268 = (t262 + t266) * t113;
  t269 = t268 * t141;
  t274 = t121 * t121;
  t275 = 0.1e1 / t274;
  t276 = t116 * t275;
  t281 = -0.1176575e1 * t234 - 0.516475e0 * t236 - 0.2103875e0 * t240 - 0.104195e0 * t245;
  t282 = 0.1e1 / t124;
  t283 = t281 * t282;
  t289 = t134 * t134;
  t290 = 0.1e1 / t289;
  t291 = t129 * t290;
  t296 = -0.86308333333333333334e0 * t234 - 0.301925e0 * t236 - 0.5501625e-1 * t240 - 0.82785e-1 * t245;
  t297 = 0.1e1 / t137;
  t298 = t296 * t297;
  t301 = 0.53237641966666666666e-3 * t70 * t223 * t125 + 0.1e1 * t276 * t283 - t226 - t251 + 0.18311447306006545054e-3 * t70 * t223 * t138 + 0.5848223622634646207e0 * t291 * t298;
  t302 = t114 * t301;
  t303 = t99 * t302;
  t306 = t114 * t67;
  t308 = t232 * t222 * t138;
  t310 = 0.18311447306006545054e-3 * t306 * t308;
  t311 = t114 * t129;
  t313 = t290 * t296 * t297;
  t315 = 0.5848223622634646207e0 * t311 * t313;
  t316 = t226 + t251 + t255 - t259 + t99 * t269 + t303 + 0.19751673498613801407e-1 * t268 * t139 - t310 - t315;
  t317 = t66 * t316;
  t318 = t55 * t317;
  t319 = t46 * t318;
  t320 = 0.5e1 / 0.9e1 * t319;
  t321 = t181 * t40;
  t322 = t321 * t153;
  t324 = t39 * t188;
  t325 = t47 * t192;
  t326 = params->c * t180;
  t327 = t325 * t326;
  t330 = -0.5e1 / 0.9e1 * t322 + 0.5e2 / 0.81e2 * t324 * t327;
  t331 = t330 * t146;
  t332 = t156 * t316;
  tvrho0 = t150 + t157 + t9 * (t184 - t198 + t220 + t320 + t331 + t332);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t335 = -t10 - t165;
  t336 = t335 / 0.2e1;
  t337 = t15 * t336;
  t338 = t7 * t337;
  t340 = rho[1] * rho[1];
  t342 = 0.1e1 / t19 / t340;
  t343 = tau[1] * t342;
  t344 = t343 * t27;
  t346 = -t336;
  t347 = t26 * t346;
  t348 = t22 * t347;
  t350 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348 + t179;
  t351 = t2 * t350;
  t352 = t351 * t45;
  t353 = t352 * t148;
  t354 = 0.5e1 / 0.9e1 * t353;
  t355 = t194 * t350;
  t356 = t193 * t355;
  t357 = t190 * t356;
  t358 = 0.5e2 / 0.81e2 * t357;
  t360 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348;
  t361 = t207 * t360;
  t364 = t204 + t59 * t361 / 0.8e1 + t215;
  t365 = t364 * t146;
  t366 = t55 * t365;
  t367 = t46 * t366;
  t368 = 0.5e1 / 0.9e1 * t367;
  t371 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t335);
  t372 = -t335;
  t375 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t372);
  t377 = (t371 + t375) * t113;
  t378 = t377 * t141;
  t382 = t226 + t251 - t255 - t259 + t99 * t378 + t303 + 0.19751673498613801407e-1 * t377 * t139 - t310 - t315;
  t383 = t66 * t382;
  t384 = t55 * t383;
  t385 = t46 * t384;
  t386 = 0.5e1 / 0.9e1 * t385;
  t387 = t351 * t40;
  t388 = t387 * t153;
  t390 = params->c * t350;
  t391 = t325 * t390;
  t394 = -0.5e1 / 0.9e1 * t388 + 0.5e2 / 0.81e2 * t324 * t391;
  t395 = t394 * t146;
  t396 = t156 * t382;
  tvrho1 = t150 + t157 + t9 * (t354 - t358 + t368 + t386 + t395 + t396);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t399 = t2 * t35;
  t400 = t399 * t45;
  t401 = t400 * t148;
  t402 = 0.5e1 / 0.72e2 * t401;
  t403 = t194 * t35;
  t405 = t190 * t193 * t403;
  t406 = 0.25e2 / 0.324e3 * t405;
  t407 = t39 * t50;
  t408 = t54 * t58;
  t409 = t63 * t146;
  t410 = t408 * t409;
  t411 = t407 * t410;
  t412 = 0.5e1 / 0.72e2 * t411;
  t414 = t399 * t40 * t153;
  t416 = params->c * t35;
  t418 = t324 * t325 * t416;
  t420 = 0.5e1 / 0.72e2 * t414 - 0.25e2 / 0.324e3 * t418;
  t421 = t420 * t146;
  tvsigma0 = t9 * (-t402 + t406 - t412 + t421);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t423 = 0.5e1 / 0.36e2 * t401;
  t424 = 0.25e2 / 0.162e3 * t405;
  t425 = 0.5e1 / 0.36e2 * t411;
  t428 = 0.5e1 / 0.36e2 * t414 - 0.25e2 / 0.162e3 * t418;
  t429 = t428 * t146;
  tvsigma1 = t9 * (-t423 + t424 - t425 + t429);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t431 = t2 * t6;
  t432 = t16 * t40;
  t433 = t431 * t432;
  t434 = t54 * t66;
  t435 = t434 * t146;
  t436 = t152 * t435;
  t438 = 0.5e1 / 0.9e1 * t433 * t436;
  t439 = t193 * t146;
  t440 = params->c * t6;
  t441 = t440 * t16;
  t442 = t439 * t441;
  t444 = 0.5e2 / 0.81e2 * t190 * t442;
  t445 = t59 * t206;
  t446 = t62 * t6;
  t447 = t16 * t146;
  t448 = t446 * t447;
  t449 = t445 * t448;
  t451 = 0.5e1 / 0.72e2 * t154 * t449;
  t452 = t431 * t16;
  t453 = t45 * t55;
  t456 = t325 * t441;
  t459 = -0.5e1 / 0.9e1 * t452 * t453 + 0.5e2 / 0.81e2 * t324 * t456;
  t460 = t459 * t146;
  tvtau0 = t9 * (t438 - t444 + t451 + t460);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t462 = t2 * t21;
  t463 = t27 * t40;
  t464 = t462 * t463;
  t466 = 0.5e1 / 0.9e1 * t464 * t436;
  t467 = params->c * t21;
  t468 = t467 * t27;
  t471 = 0.5e2 / 0.81e2 * t190 * t439 * t468;
  t472 = t62 * t21;
  t473 = t27 * t146;
  t474 = t472 * t473;
  t475 = t445 * t474;
  t477 = 0.5e1 / 0.72e2 * t154 * t475;
  t478 = t462 * t27;
  t479 = t478 * t453;
  t484 = -0.5e1 / 0.9e1 * t479 + 0.5e2 / 0.81e2 * t324 * t325 * t468;
  t485 = t484 * t146;
  tvtau1 = t9 * (t466 - t471 + t477 + t485);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t493 = t158 * rho[0];
  t495 = 0.1e1 / t4 / t493;
  t496 = tau[0] * t495;
  t498 = 0.4e2 / 0.9e1 * t496 * t16;
  t500 = 0.5e2 / 0.9e1 * t161 * t168;
  t501 = 0.1e1 / t14;
  t502 = t167 * t167;
  t503 = t501 * t502;
  t505 = 0.1e2 / 0.9e1 * t7 * t503;
  t506 = 0.1e1 / t175;
  t507 = t8 * t506;
  t508 = -t164 + t507;
  t509 = t15 * t508;
  t511 = 0.5e1 / 0.3e1 * t7 * t509;
  t512 = 0.1e1 / t25;
  t513 = t171 * t171;
  t514 = t512 * t513;
  t516 = 0.1e2 / 0.9e1 * t22 * t514;
  t517 = -t508;
  t518 = t26 * t517;
  t520 = 0.5e1 / 0.3e1 * t22 * t518;
  t521 = 0.11e2 / 0.9e1 * t59;
  t522 = t498 - t500 + t505 + t511 + t516 + t520 - t521;
  t523 = t2 * t522;
  t524 = t523 * t45;
  t525 = t524 * t148;
  t526 = 0.5e1 / 0.9e1 * t525;
  t527 = t180 * t180;
  t528 = t2 * t527;
  t529 = t528 * t188;
  t530 = t147 * params->c;
  t531 = t325 * t530;
  t532 = t529 * t531;
  t533 = 0.1e3 / 0.81e2 * t532;
  t534 = t182 * t218;
  t535 = 0.1e2 / 0.9e1 * t534;
  t536 = t182 * t318;
  t537 = 0.1e2 / 0.9e1 * t536;
  t538 = t41 * t41;
  t539 = 0.1e1 / t538;
  t541 = 0.1e1 / t191 / t53;
  t542 = t539 * t541;
  t543 = t39 * t542;
  t544 = params->c * params->c;
  t545 = t544 * t527;
  t546 = t147 * t545;
  t547 = t543 * t546;
  t548 = 0.2e4 / 0.243e3 * t547;
  t549 = t192 * t216;
  t550 = t549 * t195;
  t551 = t190 * t550;
  t552 = 0.1e3 / 0.81e2 * t551;
  t553 = t316 * params->c;
  t554 = t553 * t180;
  t555 = t193 * t554;
  t556 = t190 * t555;
  t557 = 0.1e3 / 0.81e2 * t556;
  t558 = t194 * t522;
  t559 = t193 * t558;
  t560 = t190 * t559;
  t561 = 0.5e2 / 0.81e2 * t560;
  t562 = t56 * t31;
  t564 = 0.1e1 / t33 / t562;
  t565 = t30 * t564;
  t567 = 0.119e3 / 0.36e2 * t565 * t63;
  t568 = t202 * t210;
  t571 = 0.7e1 / 0.3e1 * t202 * t213;
  t573 = 0.1e1 / t205 / t60;
  t574 = t573 * t62;
  t575 = t209 * t209;
  t576 = t574 * t575;
  t579 = t206 * t8;
  t580 = t579 * t209;
  t581 = t59 * t580;
  t583 = t498 - t500 + t505 + t511 + t516 + t520;
  t584 = t207 * t583;
  t588 = t59 * t61 / 0.4e1;
  t589 = -t567 - 0.7e1 / 0.6e1 * t568 + t571 - t59 * t576 / 0.4e1 + t581 / 0.2e1 + t59 * t584 / 0.8e1 - t588;
  t590 = t589 * t146;
  t591 = t55 * t590;
  t592 = t46 * t591;
  t593 = 0.5e1 / 0.9e1 * t592;
  t594 = t216 * t316;
  t595 = t55 * t594;
  t596 = t46 * t595;
  t597 = 0.1e2 / 0.9e1 * t596;
  t598 = t289 * t289;
  t599 = 0.1e1 / t598;
  t600 = t296 * t296;
  t601 = t599 * t600;
  t602 = t137 * t137;
  t603 = 0.1e1 / t602;
  t604 = t601 * t603;
  t606 = 0.17315859105681463759e2 * t311 * t604;
  t609 = 0.1e1 / t78 / t75 * t83;
  t610 = t84 * t71;
  t611 = t610 * t35;
  t612 = t609 * t611;
  t615 = 0.1e1 / t32 / t31;
  t616 = t232 * t615;
  t617 = t231 * t616;
  t619 = t72 * t615;
  t620 = t70 * t619;
  t622 = 0.1e1/sqrt(t75);
  t623 = t622 * t83;
  t624 = t623 * t611;
  t626 = t239 * t616;
  t629 = t85 * t71 * t35;
  t631 = -0.57538888888888888889e0 * t612 + 0.11507777777777777778e1 * t617 + 0.40256666666666666667e0 * t620 + 0.366775e-1 * t624 + 0.73355e-1 * t626 + 0.137975e0 * t629;
  t633 = t290 * t631 * t297;
  t635 = 0.5848223622634646207e0 * t311 * t633;
  t636 = t268 * t129;
  t637 = t636 * t313;
  t639 = t103 * t103;
  t640 = 0.1e1 / t639;
  t641 = t166 * t166;
  t644 = 0.2e1 * t508;
  t648 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t641 + 0.4e1 / 0.3e1 * t103 * t644);
  t649 = t107 * t107;
  t650 = 0.1e1 / t649;
  t651 = t263 * t263;
  t654 = -t644;
  t658 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t651 + 0.4e1 / 0.3e1 * t107 * t654);
  t660 = (t648 + t658) * t113;
  t664 = t232 * t615 * t138;
  t666 = 0.24415263074675393405e-3 * t306 * t664;
  t670 = t70 * t72;
  t671 = t222 * t275;
  t675 = t274 * t121;
  t676 = 0.1e1 / t675;
  t677 = t116 * t676;
  t678 = t281 * t281;
  t679 = t678 * t282;
  t688 = -0.78438333333333333333e0 * t612 + 0.15687666666666666667e1 * t617 + 0.68863333333333333333e0 * t620 + 0.14025833333333333333e0 * t624 + 0.28051666666666666667e0 * t626 + 0.17365833333333333333e0 * t629;
  t689 = t688 * t282;
  t692 = t274 * t274;
  t693 = 0.1e1 / t692;
  t694 = t116 * t693;
  t695 = t124 * t124;
  t696 = 0.1e1 / t695;
  t697 = t678 * t696;
  t702 = 0.14764627977777777777e-2 * t70 * t619 * t94;
  t703 = t222 * t228;
  t706 = 0.35616666666666666666e-1 * t670 * t703 * t249;
  t707 = t227 * t90;
  t708 = 0.1e1 / t707;
  t709 = t77 * t708;
  t710 = t247 * t247;
  t711 = t710 * t248;
  t713 = 0.2e1 * t709 * t711;
  t720 = -0.42198333333333333333e0 * t612 + 0.84396666666666666666e0 * t617 + 0.39862222222222222223e0 * t620 + 0.68258333333333333333e-1 * t624 + 0.13651666666666666667e0 * t626 + 0.13692777777777777778e0 * t629;
  t721 = t720 * t248;
  t723 = 0.1e1 * t229 * t721;
  t724 = t227 * t227;
  t725 = 0.1e1 / t724;
  t726 = t77 * t725;
  t727 = t93 * t93;
  t728 = 0.1e1 / t727;
  t729 = t710 * t728;
  t731 = 0.16081979498692535067e2 * t726 * t729;
  t735 = t222 * t290;
  t739 = t289 * t134;
  t740 = 0.1e1 / t739;
  t741 = t129 * t740;
  t742 = t600 * t297;
  t745 = t631 * t297;
  t748 = t129 * t599;
  t749 = t600 * t603;
  t752 = -0.70983522622222222221e-3 * t70 * t619 * t125 - 0.34246666666666666666e-1 * t670 * t671 * t283 - 0.2e1 * t677 * t679 + 0.1e1 * t276 * t689 + 0.32163958997385070134e2 * t694 * t697 + t702 + t706 + t713 - t723 - t731 - 0.24415263074675393405e-3 * t70 * t619 * t138 - 0.10843581300301739842e-1 * t670 * t735 * t298 - 0.11696447245269292414e1 * t741 * t742 + 0.5848223622634646207e0 * t291 * t745 + 0.17315859105681463759e2 * t748 * t749;
  t753 = t114 * t752;
  t754 = t99 * t753;
  t755 = t660 * t141;
  t757 = t268 * t301;
  t758 = t99 * t757;
  t760 = t257 * t269;
  t763 = 0.8e1 * t257 * t302;
  t764 = t253 * t269;
  t766 = -t606 - t635 - 0.11696447245269292414e1 * t637 + 0.19751673498613801407e-1 * t660 * t139 + t666 + t754 + t99 * t755 + 0.2e1 * t758 - 0.8e1 * t760 - t763 + 0.8e1 * t764;
  t768 = 0.8e1 * t253 * t302;
  t769 = 0.1e1 / t562;
  t770 = t97 * t769;
  t772 = 0.2e2 * t770 * t142;
  t773 = t62 * t98;
  t775 = 0.12e2 * t773 * t142;
  t776 = t252 * t256;
  t778 = 0.32e2 * t776 * t142;
  t779 = t114 * t70;
  t780 = t223 * t313;
  t782 = 0.10843581300301739842e-1 * t779 * t780;
  t783 = t268 * t67;
  t784 = t783 * t308;
  t787 = t740 * t600 * t297;
  t789 = 0.11696447245269292414e1 * t311 * t787;
  t790 = t768 - t713 + t772 + t775 - t778 - t702 + t723 + t731 + t782 - 0.36622894612013090108e-3 * t784 + t789 - t706;
  t791 = t766 + t790;
  t792 = t66 * t791;
  t793 = t55 * t792;
  t794 = t46 * t793;
  t795 = 0.5e1 / 0.9e1 * t794;
  t796 = t523 * t40;
  t797 = t796 * t153;
  t799 = t528 * t185;
  t800 = t187 * t47;
  t801 = t192 * params->c;
  t802 = t800 * t801;
  t805 = t39 * t539;
  t806 = t541 * t544;
  t807 = t806 * t527;
  t810 = params->c * t522;
  t811 = t325 * t810;
  t814 = -0.5e1 / 0.9e1 * t797 + 0.1e3 / 0.81e2 * t799 * t802 - 0.2e4 / 0.243e3 * t805 * t807 + 0.5e2 / 0.81e2 * t324 * t811;
  t815 = t814 * t146;
  t816 = t330 * t316;
  t817 = 0.2e1 * t816;
  t818 = t156 * t791;
  t819 = t526 - t533 + t535 + t537 + t548 - t552 - t557 - t561 + t593 + t597 + t795 + t815 + t817 + t818;
  tv2rho20 = 0.1e2 / 0.9e1 * t183 - 0.1e3 / 0.81e2 * t197 + 0.1e2 / 0.9e1 * t219 + 0.1e2 / 0.9e1 * t319 + 0.2e1 * t331 + 0.2e1 * t332 + t9 * t819;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t822 = 0.25e2 / 0.9e1 * t161 * t337;
  t823 = t501 * t336;
  t824 = t823 * t167;
  t826 = 0.1e2 / 0.9e1 * t7 * t824;
  t827 = t15 * t8;
  t828 = t827 * t506;
  t830 = 0.5e1 / 0.3e1 * t7 * t828;
  t832 = 0.25e2 / 0.9e1 * t343 * t172;
  t833 = t512 * t346;
  t834 = t833 * t171;
  t836 = 0.1e2 / 0.9e1 * t22 * t834;
  t837 = t26 * t8;
  t838 = t837 * t506;
  t840 = 0.5e1 / 0.3e1 * t22 * t838;
  t841 = -t822 + t826 + t830 - t832 + t836 - t840 - t521;
  t842 = t2 * t841;
  t843 = t842 * t45;
  t844 = t843 * t148;
  t846 = t351 * t189;
  t847 = t846 * t196;
  t849 = t352 * t218;
  t851 = t352 * t318;
  t853 = t544 * t350;
  t854 = t853 * t180;
  t855 = t147 * t854;
  t856 = t543 * t855;
  t858 = t549 * t355;
  t859 = t190 * t858;
  t861 = t553 * t350;
  t862 = t193 * t861;
  t863 = t190 * t862;
  t865 = t194 * t841;
  t866 = t193 * t865;
  t867 = t190 * t866;
  t869 = t182 * t366;
  t871 = t192 * t364;
  t872 = t871 * t195;
  t873 = t190 * t872;
  t876 = t202 * t361;
  t878 = t59 * t573;
  t879 = t62 * t360;
  t880 = t879 * t209;
  t883 = t579 * t360;
  t884 = t59 * t883;
  t886 = -t822 + t826 + t830 - t832 + t836 - t840;
  t887 = t207 * t886;
  t891 = -t567 - 0.7e1 / 0.12e2 * t568 - 0.7e1 / 0.12e2 * t876 - t878 * t880 / 0.4e1 + t884 / 0.4e1 + t59 * t887 / 0.8e1 - t581 / 0.4e1 + t588;
  t892 = t891 * t146;
  t893 = t55 * t892;
  t894 = t46 * t893;
  t896 = t364 * t316;
  t897 = t55 * t896;
  t898 = t46 * t897;
  t900 = t182 * t384;
  t902 = t382 * params->c;
  t903 = t902 * t180;
  t904 = t193 * t903;
  t905 = t190 * t904;
  t907 = t216 * t382;
  t908 = t55 * t907;
  t909 = t46 * t908;
  t911 = t377 * t129;
  t912 = t911 * t313;
  t915 = t377 * t67;
  t916 = t915 * t308;
  t919 = -0.5848223622634646207e0 * t912 + t789 - t635 - 0.5848223622634646207e0 * t637 + t772 - t775 - t606 + t782 + t731 - 0.18311447306006545054e-3 * t916 - t763 - 0.4e1 * t764 + t666;
  t921 = t253 * t378;
  t923 = t257 * t378;
  t925 = t640 * t335;
  t928 = t103 * t8;
  t932 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t925 * t166 + 0.8e1 / 0.3e1 * t928 * t506);
  t933 = t650 * t372;
  t936 = t107 * t8;
  t940 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t933 * t263 - 0.8e1 / 0.3e1 * t936 * t506);
  t942 = (t932 + t940) * t113;
  t943 = t942 * t141;
  t945 = t377 * t301;
  t946 = t99 * t945;
  t950 = -t706 - 0.18311447306006545054e-3 * t784 + 0.4e1 * t921 - 0.4e1 * t923 + t99 * t943 + t946 + t758 - 0.4e1 * t760 - t713 + t723 + 0.19751673498613801407e-1 * t942 * t139 + t754 - t702;
  t951 = t919 + t950;
  t952 = t66 * t951;
  t953 = t55 * t952;
  t954 = t46 * t953;
  t956 = t842 * t40;
  t957 = t956 * t153;
  t959 = t351 * t188;
  t962 = t350 * t180;
  t963 = t806 * t962;
  t966 = params->c * t841;
  t967 = t325 * t966;
  t970 = -0.5e1 / 0.9e1 * t957 + 0.1e3 / 0.81e2 * t959 * t327 - 0.2e4 / 0.243e3 * t805 * t963 + 0.5e2 / 0.81e2 * t324 * t967;
  t971 = t970 * t146;
  t972 = t394 * t316;
  t973 = t330 * t382;
  t974 = t156 * t951;
  t975 = 0.5e1 / 0.9e1 * t844 - 0.1e3 / 0.81e2 * t847 + 0.5e1 / 0.9e1 * t849 + 0.5e1 / 0.9e1 * t851 + 0.2e4 / 0.243e3 * t856 - 0.5e2 / 0.81e2 * t859 - 0.5e2 / 0.81e2 * t863 - 0.5e2 / 0.81e2 * t867 + 0.5e1 / 0.9e1 * t869 - 0.5e2 / 0.81e2 * t873 + 0.5e1 / 0.9e1 * t894 + 0.5e1 / 0.9e1 * t898 + 0.5e1 / 0.9e1 * t900 - 0.5e2 / 0.81e2 * t905 + 0.5e1 / 0.9e1 * t909 + 0.5e1 / 0.9e1 * t954 + t971 + t972 + t973 + t974;
  tv2rho21 = t9 * t975 + t184 - t198 + t220 + t320 + t331 + t332 + t354 - t358 + t368 + t386 + t395 + t396;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t983 = t336 * t336;
  t984 = t501 * t983;
  t986 = 0.1e2 / 0.9e1 * t7 * t984;
  t987 = t164 + t507;
  t988 = t15 * t987;
  t990 = 0.5e1 / 0.3e1 * t7 * t988;
  t991 = t340 * rho[1];
  t993 = 0.1e1 / t19 / t991;
  t994 = tau[1] * t993;
  t996 = 0.4e2 / 0.9e1 * t994 * t27;
  t998 = 0.5e2 / 0.9e1 * t343 * t347;
  t999 = t346 * t346;
  t1000 = t512 * t999;
  t1002 = 0.1e2 / 0.9e1 * t22 * t1000;
  t1003 = -t987;
  t1004 = t26 * t1003;
  t1006 = 0.5e1 / 0.3e1 * t22 * t1004;
  t1007 = t986 + t990 + t996 - t998 + t1002 + t1006 - t521;
  t1008 = t2 * t1007;
  t1009 = t1008 * t45;
  t1010 = t1009 * t148;
  t1011 = 0.5e1 / 0.9e1 * t1010;
  t1012 = t350 * t350;
  t1013 = t2 * t1012;
  t1014 = t1013 * t188;
  t1015 = t1014 * t531;
  t1016 = 0.1e3 / 0.81e2 * t1015;
  t1017 = t352 * t366;
  t1018 = 0.1e2 / 0.9e1 * t1017;
  t1019 = t352 * t384;
  t1020 = 0.1e2 / 0.9e1 * t1019;
  t1021 = t544 * t1012;
  t1022 = t147 * t1021;
  t1023 = t543 * t1022;
  t1024 = 0.2e4 / 0.243e3 * t1023;
  t1025 = t871 * t355;
  t1026 = t190 * t1025;
  t1027 = 0.1e3 / 0.81e2 * t1026;
  t1028 = t902 * t350;
  t1029 = t193 * t1028;
  t1030 = t190 * t1029;
  t1031 = 0.1e3 / 0.81e2 * t1030;
  t1032 = t194 * t1007;
  t1033 = t193 * t1032;
  t1034 = t190 * t1033;
  t1035 = 0.5e2 / 0.81e2 * t1034;
  t1037 = t360 * t360;
  t1038 = t574 * t1037;
  t1042 = t986 + t990 + t996 - t998 + t1002 + t1006;
  t1043 = t207 * t1042;
  t1046 = -t567 - 0.7e1 / 0.6e1 * t876 - t571 - t59 * t1038 / 0.4e1 - t884 / 0.2e1 + t59 * t1043 / 0.8e1 - t588;
  t1047 = t1046 * t146;
  t1048 = t55 * t1047;
  t1049 = t46 * t1048;
  t1050 = 0.5e1 / 0.9e1 * t1049;
  t1051 = t364 * t382;
  t1052 = t55 * t1051;
  t1053 = t46 * t1052;
  t1054 = 0.1e2 / 0.9e1 * t1053;
  t1055 = t335 * t335;
  t1058 = 0.2e1 * t987;
  t1062 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t1055 + 0.4e1 / 0.3e1 * t103 * t1058);
  t1063 = t372 * t372;
  t1066 = -t1058;
  t1070 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t1063 + 0.4e1 / 0.3e1 * t107 * t1066);
  t1072 = (t1062 + t1070) * t113;
  t1073 = t1072 * t141;
  t1081 = t99 * t1073 + 0.19751673498613801407e-1 * t1072 * t139 - 0.11696447245269292414e1 * t912 - 0.8e1 * t921 - 0.8e1 * t923 + 0.2e1 * t946 - t606 - t635 + t666 + t754 - t763;
  t1083 = -t768 - t713 + t772 + t775 + t778 - t702 + t723 + t731 + t782 - 0.36622894612013090108e-3 * t916 + t789 - t706;
  t1084 = t1081 + t1083;
  t1085 = t66 * t1084;
  t1086 = t55 * t1085;
  t1087 = t46 * t1086;
  t1088 = 0.5e1 / 0.9e1 * t1087;
  t1089 = t1008 * t40;
  t1090 = t1089 * t153;
  t1092 = t1013 * t185;
  t1095 = t806 * t1012;
  t1098 = params->c * t1007;
  t1099 = t325 * t1098;
  t1102 = -0.5e1 / 0.9e1 * t1090 + 0.1e3 / 0.81e2 * t1092 * t802 - 0.2e4 / 0.243e3 * t805 * t1095 + 0.5e2 / 0.81e2 * t324 * t1099;
  t1103 = t1102 * t146;
  t1104 = t394 * t382;
  t1105 = 0.2e1 * t1104;
  t1106 = t156 * t1084;
  t1107 = t1011 - t1016 + t1018 + t1020 + t1024 - t1027 - t1031 - t1035 + t1050 + t1054 + t1088 + t1103 + t1105 + t1106;
  tv2rho22 = 0.1e2 / 0.9e1 * t353 - 0.1e3 / 0.81e2 * t357 + 0.1e2 / 0.9e1 * t367 + 0.1e2 / 0.9e1 * t385 + 0.2e1 * t395 + 0.2e1 * t396 + t9 * t1107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t1109 = t2 * t177;
  t1110 = t1109 * t45;
  t1111 = t1110 * t148;
  t1112 = 0.5e1 / 0.27e2 * t1111;
  t1113 = t399 * t189;
  t1114 = t1113 * t196;
  t1115 = 0.25e2 / 0.162e3 * t1114;
  t1116 = t400 * t218;
  t1117 = 0.5e1 / 0.72e2 * t1116;
  t1118 = t400 * t318;
  t1119 = 0.5e1 / 0.72e2 * t1118;
  t1120 = t544 * t35;
  t1121 = t1120 * t180;
  t1122 = t147 * t1121;
  t1123 = t543 * t1122;
  t1124 = 0.25e3 / 0.243e3 * t1123;
  t1126 = t190 * t549 * t403;
  t1127 = 0.25e2 / 0.324e3 * t1126;
  t1128 = t553 * t35;
  t1130 = t190 * t193 * t1128;
  t1131 = 0.25e2 / 0.324e3 * t1130;
  t1132 = t194 * t177;
  t1134 = t190 * t193 * t1132;
  t1135 = 0.5e2 / 0.243e3 * t1134;
  t1136 = t181 * t50;
  t1137 = t1136 * t410;
  t1138 = 0.5e1 / 0.72e2 * t1137;
  t1139 = t39 * t185;
  t1140 = t800 * t192;
  t1141 = t1139 * t1140;
  t1142 = t58 * t61;
  t1143 = t1142 * t62;
  t1144 = t1143 * t195;
  t1145 = t1141 * t1144;
  t1146 = 0.25e2 / 0.324e3 * t1145;
  t1147 = t54 * t201;
  t1148 = t1147 * t409;
  t1149 = t407 * t1148;
  t1150 = 0.35e2 / 0.108e3 * t1149;
  t1151 = t408 * t206;
  t1152 = t62 * t146;
  t1153 = t1152 * t209;
  t1154 = t1151 * t1153;
  t1155 = t407 * t1154;
  t1156 = 0.5e1 / 0.72e2 * t1155;
  t1157 = t213 * t146;
  t1158 = t408 * t1157;
  t1159 = t407 * t1158;
  t1160 = 0.5e1 / 0.36e2 * t1159;
  t1161 = t63 * t316;
  t1162 = t408 * t1161;
  t1163 = t407 * t1162;
  t1164 = 0.5e1 / 0.72e2 * t1163;
  t1166 = t1109 * t40 * t153;
  t1167 = 0.5e1 / 0.27e2 * t1166;
  t1168 = t399 * t188;
  t1169 = t1168 * t327;
  t1171 = t35 * t180;
  t1172 = t806 * t1171;
  t1173 = t805 * t1172;
  t1175 = params->c * t177;
  t1177 = t324 * t325 * t1175;
  t1178 = 0.5e2 / 0.243e3 * t1177;
  t1179 = -t1167 - 0.25e2 / 0.162e3 * t1169 + 0.25e3 / 0.243e3 * t1173 + t1178;
  t1180 = t1179 * t146;
  t1181 = t420 * t316;
  t1182 = t1112 + t1115 - t1117 - t1119 - t1124 + t1127 + t1131 - t1135 - t1138 + t1146 + t1150 + t1156 - t1160 - t1164 + t1180 + t1181;
  tv2rhosigma0 = t1182 * t9 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t1184 = 0.1e2 / 0.27e2 * t1111;
  t1185 = 0.25e2 / 0.81e2 * t1114;
  t1186 = 0.5e1 / 0.36e2 * t1116;
  t1187 = 0.5e1 / 0.36e2 * t1118;
  t1188 = 0.5e3 / 0.243e3 * t1123;
  t1189 = 0.25e2 / 0.162e3 * t1126;
  t1190 = 0.25e2 / 0.162e3 * t1130;
  t1191 = 0.1e3 / 0.243e3 * t1134;
  t1192 = 0.5e1 / 0.36e2 * t1137;
  t1193 = 0.25e2 / 0.162e3 * t1145;
  t1194 = 0.35e2 / 0.54e2 * t1149;
  t1195 = 0.5e1 / 0.36e2 * t1155;
  t1196 = 0.5e1 / 0.18e2 * t1159;
  t1197 = 0.5e1 / 0.36e2 * t1163;
  t1198 = 0.1e2 / 0.27e2 * t1166;
  t1201 = 0.1e3 / 0.243e3 * t1177;
  t1202 = -t1198 - 0.25e2 / 0.81e2 * t1169 + 0.5e3 / 0.243e3 * t1173 + t1201;
  t1203 = t1202 * t146;
  t1204 = t428 * t316;
  t1205 = t1184 + t1185 - t1186 - t1187 - t1188 + t1189 + t1190 - t1191 - t1192 + t1193 + t1194 + t1195 - t1196 - t1197 + t1203 + t1204;
  tv2rhosigma1 = t1205 * t9 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1207 = t1113 * t356;
  t1208 = 0.25e2 / 0.162e3 * t1207;
  t1209 = t400 * t366;
  t1210 = 0.5e1 / 0.72e2 * t1209;
  t1211 = t400 * t384;
  t1212 = 0.5e1 / 0.72e2 * t1211;
  t1213 = t1120 * t350;
  t1214 = t147 * t1213;
  t1215 = t543 * t1214;
  t1216 = 0.25e3 / 0.243e3 * t1215;
  t1218 = t190 * t871 * t403;
  t1219 = 0.25e2 / 0.324e3 * t1218;
  t1220 = t902 * t35;
  t1222 = t190 * t193 * t1220;
  t1223 = 0.25e2 / 0.324e3 * t1222;
  t1224 = t351 * t50;
  t1225 = t1224 * t410;
  t1226 = 0.5e1 / 0.72e2 * t1225;
  t1227 = t1143 * t355;
  t1228 = t1141 * t1227;
  t1229 = 0.25e2 / 0.324e3 * t1228;
  t1230 = t1152 * t360;
  t1231 = t1151 * t1230;
  t1232 = t407 * t1231;
  t1233 = 0.5e1 / 0.72e2 * t1232;
  t1234 = t63 * t382;
  t1235 = t408 * t1234;
  t1236 = t407 * t1235;
  t1237 = 0.5e1 / 0.72e2 * t1236;
  t1238 = t1168 * t391;
  t1240 = t35 * t350;
  t1241 = t806 * t1240;
  t1242 = t805 * t1241;
  t1244 = -t1167 - 0.25e2 / 0.162e3 * t1238 + 0.25e3 / 0.243e3 * t1242 + t1178;
  t1245 = t1244 * t146;
  t1246 = t420 * t382;
  t1247 = t1112 + t1208 - t1210 - t1212 - t1216 + t1219 + t1223 - t1135 - t1226 + t1229 + t1150 + t1233 + t1160 - t1237 + t1245 + t1246;
  tv2rhosigma3 = t1247 * t9 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t1249 = 0.25e2 / 0.81e2 * t1207;
  t1250 = 0.5e1 / 0.36e2 * t1209;
  t1251 = 0.5e1 / 0.36e2 * t1211;
  t1252 = 0.5e3 / 0.243e3 * t1215;
  t1253 = 0.25e2 / 0.162e3 * t1218;
  t1254 = 0.25e2 / 0.162e3 * t1222;
  t1255 = 0.5e1 / 0.36e2 * t1225;
  t1256 = 0.25e2 / 0.162e3 * t1228;
  t1257 = 0.5e1 / 0.36e2 * t1232;
  t1258 = 0.5e1 / 0.36e2 * t1236;
  t1261 = -t1198 - 0.25e2 / 0.81e2 * t1238 + 0.5e3 / 0.243e3 * t1242 + t1201;
  t1262 = t1261 * t146;
  t1263 = t428 * t382;
  t1264 = t1184 + t1249 - t1250 - t1251 - t1252 + t1253 + t1254 - t1191 - t1255 + t1256 + t1194 + t1257 + t1196 - t1258 + t1262 + t1263;
  tv2rhosigma4 = t1264 * t9 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1266 = t2 * t160;
  t1267 = t1266 * t432;
  t1268 = t1267 * t436;
  t1269 = 0.25e2 / 0.27e2 * t1268;
  t1270 = t15 * t40;
  t1271 = t1270 * t44;
  t1272 = t431 * t1271;
  t1274 = t55 * t147 * t167;
  t1275 = t1272 * t1274;
  t1276 = 0.25e2 / 0.27e2 * t1275;
  t1277 = t16 * t185;
  t1278 = t1277 * t187;
  t1279 = t431 * t1278;
  t1280 = t325 * t66;
  t1281 = t1280 * t195;
  t1282 = t1279 * t1281;
  t1283 = 0.1e3 / 0.81e2 * t1282;
  t1284 = t54 * t216;
  t1286 = t152 * t1284 * t146;
  t1287 = t433 * t1286;
  t1288 = 0.5e1 / 0.9e1 * t1287;
  t1290 = t152 * t434 * t316;
  t1291 = t433 * t1290;
  t1292 = 0.5e1 / 0.9e1 * t1291;
  t1293 = t542 * t66;
  t1294 = t39 * t1293;
  t1295 = t146 * t544;
  t1296 = t6 * t16;
  t1297 = t1296 * t180;
  t1298 = t1295 * t1297;
  t1299 = t1294 * t1298;
  t1300 = 0.2e4 / 0.243e3 * t1299;
  t1301 = t549 * t146;
  t1302 = t1301 * t441;
  t1303 = t190 * t1302;
  t1304 = 0.5e2 / 0.81e2 * t1303;
  t1305 = t193 * t316;
  t1306 = t1305 * t441;
  t1307 = t190 * t1306;
  t1308 = 0.5e2 / 0.81e2 * t1307;
  t1309 = params->c * t160;
  t1310 = t1309 * t16;
  t1311 = t439 * t1310;
  t1312 = t190 * t1311;
  t1313 = 0.25e3 / 0.243e3 * t1312;
  t1314 = t6 * t15;
  t1315 = t1314 * t167;
  t1317 = t1141 * t530 * t1315;
  t1318 = 0.25e3 / 0.243e3 * t1317;
  t1319 = t322 * t449;
  t1320 = 0.5e1 / 0.72e2 * t1319;
  t1321 = t192 * t30;
  t1322 = t800 * t1321;
  t1323 = t1139 * t1322;
  t1324 = t58 * t206;
  t1325 = t1324 * t446;
  t1326 = t447 * t326;
  t1327 = t1325 * t1326;
  t1328 = t1323 * t1327;
  t1329 = 0.25e2 / 0.324e3 * t1328;
  t1330 = t202 * t206;
  t1331 = t1330 * t448;
  t1332 = t154 * t1331;
  t1333 = 0.35e2 / 0.108e3 * t1332;
  t1334 = t54 * t30;
  t1335 = t152 * t1334;
  t1336 = t151 * t1335;
  t1337 = t58 * t573;
  t1338 = t1337 * t62;
  t1339 = t146 * t209;
  t1340 = t1296 * t1339;
  t1341 = t1338 * t1340;
  t1342 = t1336 * t1341;
  t1343 = 0.5e1 / 0.36e2 * t1342;
  t1344 = t8 * t6;
  t1345 = t1344 * t447;
  t1346 = t445 * t1345;
  t1347 = t154 * t1346;
  t1348 = 0.5e1 / 0.36e2 * t1347;
  t1349 = t62 * t160;
  t1350 = t1349 * t447;
  t1351 = t445 * t1350;
  t1352 = t154 * t1351;
  t1353 = 0.25e2 / 0.216e3 * t1352;
  t1354 = t1324 * t62;
  t1355 = t146 * t167;
  t1356 = t1314 * t1355;
  t1357 = t1354 * t1356;
  t1358 = t1336 * t1357;
  t1359 = 0.25e2 / 0.216e3 * t1358;
  t1360 = t16 * t316;
  t1361 = t446 * t1360;
  t1362 = t445 * t1361;
  t1363 = t154 * t1362;
  t1364 = 0.5e1 / 0.72e2 * t1363;
  t1365 = t1266 * t16;
  t1368 = t431 * t1270;
  t1369 = t54 * t167;
  t1370 = t152 * t1369;
  t1373 = t431 * t1277;
  t1375 = t800 * t801 * t180;
  t1378 = t544 * t6;
  t1379 = t16 * t180;
  t1380 = t1378 * t1379;
  t1383 = t325 * t1310;
  t1389 = 0.25e2 / 0.27e2 * t1365 * t453 - 0.25e2 / 0.27e2 * t1368 * t1370 + 0.1e3 / 0.81e2 * t1373 * t1375 - 0.2e4 / 0.243e3 * t543 * t1380 - 0.25e3 / 0.243e3 * t324 * t1383 + 0.25e3 / 0.243e3 * t190 * t801 * t1315;
  t1390 = t1389 * t146;
  t1391 = t459 * t316;
  t1392 = -t1269 + t1276 - t1283 + t1288 + t1292 + t1300 - t1304 - t1308 + t1313 - t1318 + t1320 - t1329 - t1333 - t1343 + t1348 - t1353 + t1359 + t1364 + t1390 + t1391;
  tv2rhotau0 = t1392 * t9 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1394 = t26 * t40;
  t1395 = t1394 * t44;
  t1396 = t462 * t1395;
  t1398 = t55 * t147 * t171;
  t1399 = t1396 * t1398;
  t1400 = 0.25e2 / 0.27e2 * t1399;
  t1401 = t27 * t185;
  t1402 = t1401 * t187;
  t1403 = t462 * t1402;
  t1404 = t1403 * t1281;
  t1405 = 0.1e3 / 0.81e2 * t1404;
  t1406 = t464 * t1286;
  t1407 = 0.5e1 / 0.9e1 * t1406;
  t1408 = t464 * t1290;
  t1409 = 0.5e1 / 0.9e1 * t1408;
  t1410 = t21 * t27;
  t1411 = t1410 * t180;
  t1412 = t1295 * t1411;
  t1413 = t1294 * t1412;
  t1414 = 0.2e4 / 0.243e3 * t1413;
  t1416 = t190 * t1301 * t468;
  t1417 = 0.5e2 / 0.81e2 * t1416;
  t1419 = t190 * t1305 * t468;
  t1420 = 0.5e2 / 0.81e2 * t1419;
  t1421 = t21 * t26;
  t1422 = t1421 * t171;
  t1424 = t1141 * t530 * t1422;
  t1425 = 0.25e3 / 0.243e3 * t1424;
  t1426 = t322 * t475;
  t1427 = 0.5e1 / 0.72e2 * t1426;
  t1428 = t1324 * t472;
  t1429 = t473 * t326;
  t1430 = t1428 * t1429;
  t1431 = t1323 * t1430;
  t1432 = 0.25e2 / 0.324e3 * t1431;
  t1433 = t1330 * t474;
  t1434 = t154 * t1433;
  t1435 = 0.35e2 / 0.108e3 * t1434;
  t1436 = t1410 * t1339;
  t1437 = t1338 * t1436;
  t1438 = t1336 * t1437;
  t1439 = 0.5e1 / 0.36e2 * t1438;
  t1440 = t8 * t21;
  t1441 = t1440 * t473;
  t1442 = t445 * t1441;
  t1443 = t154 * t1442;
  t1444 = 0.5e1 / 0.36e2 * t1443;
  t1445 = t146 * t171;
  t1446 = t1421 * t1445;
  t1447 = t1354 * t1446;
  t1448 = t1336 * t1447;
  t1449 = 0.25e2 / 0.216e3 * t1448;
  t1450 = t27 * t316;
  t1451 = t472 * t1450;
  t1452 = t445 * t1451;
  t1453 = t154 * t1452;
  t1454 = 0.5e1 / 0.72e2 * t1453;
  t1455 = t462 * t1394;
  t1456 = t54 * t171;
  t1457 = t152 * t1456;
  t1460 = t462 * t1401;
  t1463 = t544 * t21;
  t1464 = t27 * t180;
  t1465 = t1463 * t1464;
  t1471 = -0.25e2 / 0.27e2 * t1455 * t1457 + 0.1e3 / 0.81e2 * t1460 * t1375 - 0.2e4 / 0.243e3 * t543 * t1465 + 0.25e3 / 0.243e3 * t190 * t801 * t1422;
  t1472 = t1471 * t146;
  t1473 = t484 * t316;
  t1474 = t1400 - t1405 + t1407 + t1409 + t1414 - t1417 - t1420 - t1425 + t1427 - t1432 - t1435 - t1439 + t1444 + t1449 + t1454 + t1472 + t1473;
  tv2rhotau1 = t1474 * t9 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1477 = t55 * t147 * t336;
  t1478 = t1272 * t1477;
  t1479 = 0.25e2 / 0.27e2 * t1478;
  t1480 = t1280 * t355;
  t1481 = t1279 * t1480;
  t1482 = 0.1e3 / 0.81e2 * t1481;
  t1483 = t54 * t364;
  t1485 = t152 * t1483 * t146;
  t1486 = t433 * t1485;
  t1487 = 0.5e1 / 0.9e1 * t1486;
  t1489 = t152 * t434 * t382;
  t1490 = t433 * t1489;
  t1491 = 0.5e1 / 0.9e1 * t1490;
  t1492 = t1296 * t350;
  t1493 = t1295 * t1492;
  t1494 = t1294 * t1493;
  t1495 = 0.2e4 / 0.243e3 * t1494;
  t1496 = t871 * t146;
  t1497 = t1496 * t441;
  t1498 = t190 * t1497;
  t1499 = 0.5e2 / 0.81e2 * t1498;
  t1500 = t193 * t382;
  t1501 = t1500 * t441;
  t1502 = t190 * t1501;
  t1503 = 0.5e2 / 0.81e2 * t1502;
  t1504 = t1314 * t336;
  t1506 = t1141 * t530 * t1504;
  t1507 = 0.25e3 / 0.243e3 * t1506;
  t1508 = t388 * t449;
  t1509 = 0.5e1 / 0.72e2 * t1508;
  t1510 = t447 * t390;
  t1511 = t1325 * t1510;
  t1512 = t1323 * t1511;
  t1513 = 0.25e2 / 0.324e3 * t1512;
  t1514 = t146 * t360;
  t1515 = t1296 * t1514;
  t1516 = t1338 * t1515;
  t1517 = t1336 * t1516;
  t1518 = 0.5e1 / 0.36e2 * t1517;
  t1519 = t146 * t336;
  t1520 = t1314 * t1519;
  t1521 = t1354 * t1520;
  t1522 = t1336 * t1521;
  t1523 = 0.25e2 / 0.216e3 * t1522;
  t1524 = t16 * t382;
  t1525 = t446 * t1524;
  t1526 = t445 * t1525;
  t1527 = t154 * t1526;
  t1528 = 0.5e1 / 0.72e2 * t1527;
  t1529 = t54 * t336;
  t1530 = t152 * t1529;
  t1534 = t800 * t801 * t350;
  t1537 = t16 * t350;
  t1538 = t1378 * t1537;
  t1544 = -0.25e2 / 0.27e2 * t1368 * t1530 + 0.1e3 / 0.81e2 * t1373 * t1534 - 0.2e4 / 0.243e3 * t543 * t1538 + 0.25e3 / 0.243e3 * t190 * t801 * t1504;
  t1545 = t1544 * t146;
  t1546 = t459 * t382;
  t1547 = t1479 - t1482 + t1487 + t1491 + t1495 - t1499 - t1503 - t1507 + t1509 - t1513 - t1333 - t1518 - t1348 + t1523 + t1528 + t1545 + t1546;
  tv2rhotau2 = t1547 * t9 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1549 = t2 * t342;
  t1550 = t1549 * t463;
  t1551 = t1550 * t436;
  t1552 = 0.25e2 / 0.27e2 * t1551;
  t1554 = t55 * t147 * t346;
  t1555 = t1396 * t1554;
  t1556 = 0.25e2 / 0.27e2 * t1555;
  t1557 = t1403 * t1480;
  t1558 = 0.1e3 / 0.81e2 * t1557;
  t1559 = t464 * t1485;
  t1560 = 0.5e1 / 0.9e1 * t1559;
  t1561 = t464 * t1489;
  t1562 = 0.5e1 / 0.9e1 * t1561;
  t1563 = t1410 * t350;
  t1564 = t1295 * t1563;
  t1565 = t1294 * t1564;
  t1566 = 0.2e4 / 0.243e3 * t1565;
  t1568 = t190 * t1496 * t468;
  t1569 = 0.5e2 / 0.81e2 * t1568;
  t1571 = t190 * t1500 * t468;
  t1572 = 0.5e2 / 0.81e2 * t1571;
  t1573 = params->c * t342;
  t1574 = t1573 * t27;
  t1576 = t190 * t439 * t1574;
  t1577 = 0.25e3 / 0.243e3 * t1576;
  t1578 = t1421 * t346;
  t1580 = t1141 * t530 * t1578;
  t1581 = 0.25e3 / 0.243e3 * t1580;
  t1582 = t388 * t475;
  t1583 = 0.5e1 / 0.72e2 * t1582;
  t1584 = t473 * t390;
  t1586 = t1323 * t1428 * t1584;
  t1587 = 0.25e2 / 0.324e3 * t1586;
  t1588 = t1410 * t1514;
  t1589 = t1338 * t1588;
  t1590 = t1336 * t1589;
  t1591 = 0.5e1 / 0.36e2 * t1590;
  t1592 = t62 * t342;
  t1593 = t1592 * t473;
  t1594 = t445 * t1593;
  t1595 = t154 * t1594;
  t1596 = 0.25e2 / 0.216e3 * t1595;
  t1597 = t146 * t346;
  t1598 = t1421 * t1597;
  t1599 = t1354 * t1598;
  t1600 = t1336 * t1599;
  t1601 = 0.25e2 / 0.216e3 * t1600;
  t1602 = t27 * t382;
  t1603 = t472 * t1602;
  t1604 = t445 * t1603;
  t1605 = t154 * t1604;
  t1606 = 0.5e1 / 0.72e2 * t1605;
  t1607 = t1549 * t27;
  t1608 = t1607 * t453;
  t1610 = t54 * t346;
  t1611 = t152 * t1610;
  t1616 = t27 * t350;
  t1617 = t1463 * t1616;
  t1626 = 0.25e2 / 0.27e2 * t1608 - 0.25e2 / 0.27e2 * t1455 * t1611 + 0.1e3 / 0.81e2 * t1460 * t1534 - 0.2e4 / 0.243e3 * t543 * t1617 - 0.25e3 / 0.243e3 * t324 * t325 * t1574 + 0.25e3 / 0.243e3 * t190 * t801 * t1578;
  t1627 = t1626 * t146;
  t1628 = t484 * t382;
  t1629 = -t1552 + t1556 - t1558 + t1560 + t1562 + t1566 - t1569 - t1572 + t1577 - t1581 + t1583 - t1587 - t1435 - t1591 - t1444 - t1596 + t1601 + t1606 + t1627 + t1628;
  tv2rhotau3 = t1629 * t9 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1632 = 0.1e1 / t32 / t199;
  t1633 = t2 * t1632;
  t1634 = t1633 * t188;
  t1635 = t1634 * t531;
  t1636 = 0.25e2 / 0.1296e4 * t1635;
  t1637 = t56 * t175;
  t1639 = 0.1e1 / t32 / t1637;
  t1640 = t2 * t1639;
  t1641 = t1640 * t45;
  t1642 = t55 * t409;
  t1643 = t1641 * t1642;
  t1644 = 0.5e1 / 0.288e3 * t1643;
  t1645 = t544 * t1632;
  t1647 = t543 * t147 * t1645;
  t1648 = 0.125e3 / 0.972e3 * t1647;
  t1649 = t192 * t1639;
  t1650 = t1649 * t61;
  t1651 = t1152 * params->c;
  t1652 = t1650 * t1651;
  t1653 = t190 * t1652;
  t1654 = 0.25e2 / 0.1296e4 * t1653;
  t1656 = t1633 * t185 * t802;
  t1659 = t805 * t806 * t1632;
  t1661 = 0.25e2 / 0.1296e4 * t1656 - 0.125e3 / 0.972e3 * t1659;
  t1662 = t1661 * t146;
  tv2sigma20 = t9 * (-t1636 + t1644 + t1648 - t1654 + t1662);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t1664 = 0.25e2 / 0.648e3 * t1635;
  t1665 = 0.5e1 / 0.144e3 * t1643;
  t1666 = 0.125e3 / 0.486e3 * t1647;
  t1667 = 0.25e2 / 0.648e3 * t1653;
  t1670 = 0.25e2 / 0.648e3 * t1656 - 0.125e3 / 0.486e3 * t1659;
  t1671 = t1670 * t146;
  tv2sigma21 = t9 * (-t1664 + t1665 + t1666 - t1667 + t1671);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  t1673 = 0.25e2 / 0.324e3 * t1635;
  t1674 = 0.5e1 / 0.72e2 * t1643;
  t1675 = 0.125e3 / 0.243e3 * t1647;
  t1676 = 0.25e2 / 0.324e3 * t1653;
  t1679 = 0.25e2 / 0.324e3 * t1656 - 0.125e3 / 0.243e3 * t1659;
  t1680 = t1679 * t146;
  tv2sigma23 = t9 * (-t1673 + t1674 + t1675 - t1676 + t1680);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1682 = t1280 * t403;
  t1683 = t1279 * t1682;
  t1684 = 0.25e2 / 0.162e3 * t1683;
  t1685 = t432 * t44;
  t1686 = t431 * t1685;
  t1687 = t55 * t58;
  t1688 = t1687 * t409;
  t1689 = t1686 * t1688;
  t1690 = 0.5e1 / 0.72e2 * t1689;
  t1691 = t1296 * t35;
  t1692 = t1295 * t1691;
  t1693 = t1294 * t1692;
  t1694 = 0.25e3 / 0.243e3 * t1693;
  t1695 = t194 * t1296;
  t1696 = t1143 * t1695;
  t1697 = t1141 * t1696;
  t1698 = 0.25e2 / 0.324e3 * t1697;
  t1699 = t1640 * t40;
  t1700 = t1699 * t153;
  t1701 = t30 * t206;
  t1702 = t1701 * t62;
  t1703 = t1296 * t146;
  t1704 = t1702 * t1703;
  t1705 = t1700 * t1704;
  t1706 = 0.5e1 / 0.576e3 * t1705;
  t1707 = t1639 * t206;
  t1708 = t1707 * t62;
  t1709 = t1708 * t1695;
  t1710 = t1323 * t1709;
  t1711 = 0.25e2 / 0.2592e4 * t1710;
  t1712 = t1354 * t1703;
  t1713 = t154 * t1712;
  t1714 = 0.5e1 / 0.72e2 * t1713;
  t1716 = t800 * t801 * t35;
  t1717 = t1373 * t1716;
  t1719 = t16 * t35;
  t1721 = t543 * t1378 * t1719;
  t1723 = -0.25e2 / 0.162e3 * t1717 + 0.25e3 / 0.243e3 * t1721;
  t1724 = t1723 * t146;
  tv2sigmatau0 = t9 * (t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t1726 = t1403 * t1682;
  t1727 = 0.25e2 / 0.162e3 * t1726;
  t1728 = t463 * t44;
  t1729 = t462 * t1728;
  t1730 = t1729 * t1688;
  t1731 = 0.5e1 / 0.72e2 * t1730;
  t1732 = t1410 * t35;
  t1733 = t1295 * t1732;
  t1734 = t1294 * t1733;
  t1735 = 0.25e3 / 0.243e3 * t1734;
  t1736 = t194 * t1410;
  t1738 = t1141 * t1143 * t1736;
  t1739 = 0.25e2 / 0.324e3 * t1738;
  t1740 = t1410 * t146;
  t1741 = t1702 * t1740;
  t1742 = t1700 * t1741;
  t1743 = 0.5e1 / 0.576e3 * t1742;
  t1744 = t1708 * t1736;
  t1745 = t1323 * t1744;
  t1746 = 0.25e2 / 0.2592e4 * t1745;
  t1747 = t1354 * t1740;
  t1748 = t154 * t1747;
  t1749 = 0.5e1 / 0.72e2 * t1748;
  t1750 = t1460 * t1716;
  t1752 = t27 * t35;
  t1754 = t543 * t1463 * t1752;
  t1756 = -0.25e2 / 0.162e3 * t1750 + 0.25e3 / 0.243e3 * t1754;
  t1757 = t1756 * t146;
  tv2sigmatau1 = t9 * (t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  t1759 = 0.25e2 / 0.81e2 * t1683;
  t1760 = 0.5e1 / 0.36e2 * t1689;
  t1761 = 0.5e3 / 0.243e3 * t1693;
  t1762 = 0.25e2 / 0.162e3 * t1697;
  t1763 = 0.5e1 / 0.288e3 * t1705;
  t1764 = 0.25e2 / 0.1296e4 * t1710;
  t1765 = 0.5e1 / 0.36e2 * t1713;
  t1768 = -0.25e2 / 0.81e2 * t1717 + 0.5e3 / 0.243e3 * t1721;
  t1769 = t1768 * t146;
  tv2sigmatau2 = t9 * (t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  t1771 = 0.25e2 / 0.81e2 * t1726;
  t1772 = 0.5e1 / 0.36e2 * t1730;
  t1773 = 0.5e3 / 0.243e3 * t1734;
  t1774 = 0.25e2 / 0.162e3 * t1738;
  t1775 = 0.5e1 / 0.288e3 * t1742;
  t1776 = 0.25e2 / 0.1296e4 * t1745;
  t1777 = 0.5e1 / 0.36e2 * t1748;
  t1780 = -0.25e2 / 0.81e2 * t1750 + 0.5e3 / 0.243e3 * t1754;
  t1781 = t1780 * t146;
  tv2sigmatau3 = t9 * (t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = tv2sigmatau0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = tv2sigmatau1;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1784 = 0.1e1 / t3 / t493;
  t1785 = t2 * t1784;
  t1786 = t13 * t13;
  t1788 = t14 * t1786 * t13;
  t1789 = t1788 * t185;
  t1790 = t1789 * t187;
  t1791 = t1785 * t1790;
  t1793 = 0.1e3 / 0.81e2 * t1791 * t531;
  t1794 = t1785 * t1788;
  t1795 = t1794 * t50;
  t1796 = t1334 * t58;
  t1797 = t207 * t146;
  t1798 = t1796 * t1797;
  t1800 = 0.5e1 / 0.36e2 * t1795 * t1798;
  t1801 = t544 * t1784;
  t1802 = t1801 * t1788;
  t1803 = t147 * t1802;
  t1805 = 0.2e4 / 0.243e3 * t543 * t1803;
  t1806 = t1784 * t1788;
  t1807 = t1806 * t194;
  t1808 = t1354 * t1807;
  t1810 = 0.25e2 / 0.162e3 * t1323 * t1808;
  t1811 = t62 * t1784;
  t1812 = t1788 * t146;
  t1813 = t1811 * t1812;
  t1814 = t878 * t1813;
  t1816 = 0.5e1 / 0.36e2 * t154 * t1814;
  t1820 = t806 * t1806;
  t1823 = 0.1e3 / 0.81e2 * t1785 * t1789 * t802 - 0.2e4 / 0.243e3 * t805 * t1820;
  t1824 = t1823 * t146;
  tv2tau20 = t9 * (-t1793 + t1800 + t1805 - t1810 - t1816 + t1824);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t1826 = t478 * t189;
  t1828 = 0.1e3 / 0.81e2 * t1826 * t442;
  t1830 = 0.5e1 / 0.36e2 * t479 * t449;
  t1831 = t1295 * t21;
  t1832 = t27 * t6;
  t1833 = t1832 * t16;
  t1834 = t1831 * t1833;
  t1836 = 0.2e4 / 0.243e3 * t1294 * t1834;
  t1837 = t325 * t59;
  t1838 = t324 * t1837;
  t1839 = t207 * t1296;
  t1840 = t1839 * t1736;
  t1842 = 0.25e2 / 0.162e3 * t1838 * t1840;
  t1843 = t1337 * t472;
  t1844 = t473 * t1296;
  t1845 = t1843 * t1844;
  t1847 = 0.5e1 / 0.36e2 * t1336 * t1845;
  t1853 = 0.1e3 / 0.81e2 * t1403 * t456 - 0.2e4 / 0.243e3 * t543 * t1463 * t1833;
  t1854 = t1853 * t146;
  tv2tau21 = t9 * (-t1828 + t1830 + t1836 - t1842 - t1847 + t1854);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1857 = 0.1e1 / t18 / t991;
  t1858 = t2 * t1857;
  t1859 = t24 * t24;
  t1861 = t25 * t1859 * t24;
  t1862 = t1861 * t185;
  t1863 = t1862 * t187;
  t1864 = t1858 * t1863;
  t1866 = 0.1e3 / 0.81e2 * t1864 * t531;
  t1867 = t1858 * t1861;
  t1868 = t1867 * t50;
  t1870 = 0.5e1 / 0.36e2 * t1868 * t1798;
  t1871 = t544 * t1857;
  t1872 = t1871 * t1861;
  t1875 = 0.2e4 / 0.243e3 * t543 * t147 * t1872;
  t1876 = t1857 * t1861;
  t1877 = t1876 * t194;
  t1878 = t1354 * t1877;
  t1880 = 0.25e2 / 0.162e3 * t1323 * t1878;
  t1881 = t62 * t1857;
  t1882 = t1861 * t146;
  t1883 = t1881 * t1882;
  t1884 = t878 * t1883;
  t1886 = 0.5e1 / 0.36e2 * t154 * t1884;
  t1887 = t1858 * t1862;
  t1893 = 0.1e3 / 0.81e2 * t1887 * t802 - 0.2e4 / 0.243e3 * t805 * t806 * t1876;
  t1894 = t1893 * t146;
  tv2tau22 = t9 * (-t1866 + t1870 + t1875 - t1880 - t1886 + t1894);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1896 = t544 * t180;
  t1897 = t1896 * t522;
  t1898 = t147 * t1897;
  t1899 = t543 * t1898;
  t1900 = 0.2e4 / 0.81e2 * t1899;
  t1901 = t217 * params->c;
  t1902 = t325 * t1901;
  t1903 = t529 * t1902;
  t1904 = 0.1e3 / 0.27e2 * t1903;
  t1905 = t317 * params->c;
  t1906 = t325 * t1905;
  t1907 = t529 * t1906;
  t1908 = 0.1e3 / 0.27e2 * t1907;
  t1909 = t330 * t791;
  t1910 = 0.3e1 * t1909;
  t1911 = t615 * t228;
  t1914 = 0.71233333333333333332e-1 * t670 * t1911 * t249;
  t1917 = 0.53424999999999999999e-1 * t670 * t703 * t721;
  t1918 = t222 * t725;
  t1921 = 0.85917975471764868594e0 * t670 * t1918 * t729;
  t1923 = 0.1e1 / t32 / t175;
  t1925 = t232 * t1923 * t138;
  t1927 = 0.56968947174242584612e-3 * t306 * t1925;
  t1928 = t660 * t67;
  t1929 = t1928 * t308;
  t1931 = t783 * t664;
  t1934 = t603 * t631;
  t1935 = t599 * t296 * t1934;
  t1937 = 0.51947577317044391277e2 * t311 * t1935;
  t1939 = t740 * t631 * t298;
  t1941 = 0.35089341735807877242e1 * t311 * t1939;
  t1942 = t223 * t787;
  t1944 = 0.32530743900905219526e-1 * t779 * t1942;
  t1945 = t223 * t604;
  t1947 = 0.48159733137676571078e0 * t779 * t1945;
  t1948 = t223 * t633;
  t1950 = 0.16265371950452609763e-1 * t779 * t1948;
  t1951 = t268 * t70;
  t1952 = t1951 * t780;
  t1954 = t1914 - t1917 - t1921 - t1927 - 0.54934341918019635162e-3 * t1929 + 0.73245789224026180216e-3 * t1931 - t1937 + t1941 - t1944 + t1947 + t1950 + 0.32530743900905219526e-1 * t1952;
  t1955 = t619 * t313;
  t1957 = 0.21687162600603479684e-1 * t779 * t1955;
  t1961 = 0.1e1 / t78 / t88 * t68 / 0.4e1;
  t1962 = t1961 * t98;
  t1964 = t610 * t177;
  t1965 = t609 * t1964;
  t1967 = t232 * t1923;
  t1968 = t231 * t1967;
  t1970 = t72 * t1923;
  t1971 = t70 * t1970;
  t1973 = 0.1e1/POW_3_2(t75);
  t1974 = t1973 * t68;
  t1975 = t1974 * t98;
  t1977 = t623 * t1964;
  t1979 = t239 * t1967;
  t1982 = t85 * t71 * t177;
  t1984 = -0.25319e1 * t1962 + 0.16879333333333333333e1 * t1965 - 0.19692555555555555555e1 * t1968 - 0.93011851851851851854e0 * t1971 + 0.13651666666666666667e0 * t1975 - 0.27303333333333333333e0 * t1977 - 0.3185388888888888889e0 * t1979 - 0.36514074074074074075e0 * t1982;
  t1985 = t1984 * t248;
  t1987 = 0.1e1 * t229 * t1985;
  t1991 = 0.10685e0 * t670 * t222 * t708 * t711;
  t1993 = 0.1e1 / t639 / t12;
  t1994 = t641 * t166;
  t1997 = t640 * t166;
  t2000 = t8 * t98;
  t2001 = t506 - t2000;
  t2002 = 0.6e1 * t2001;
  t2006 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t1993 * t1994 + 0.4e1 / 0.3e1 * t1997 * t644 + 0.4e1 / 0.3e1 * t103 * t2002);
  t2008 = 0.1e1 / t649 / t23;
  t2009 = t651 * t263;
  t2012 = t650 * t263;
  t2015 = -t2002;
  t2019 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2008 * t2009 + 0.4e1 / 0.3e1 * t2012 * t654 + 0.4e1 / 0.3e1 * t107 * t2015);
  t2021 = (t2006 + t2019) * t113;
  t2024 = t660 * t129;
  t2025 = t2024 * t313;
  t2027 = t636 * t633;
  t2030 = 0.1e1 / t598 / t289;
  t2031 = t600 * t296;
  t2034 = 0.1e1 / t602 / t137;
  t2035 = t2030 * t2031 * t2034;
  t2037 = 0.10254018858216406658e4 * t311 * t2035;
  t2038 = t636 * t604;
  t2041 = t599 * t2031 * t297;
  t2043 = 0.35089341735807877242e1 * t311 * t2041;
  t2044 = t710 * t247;
  t2045 = t2044 * t248;
  t2047 = 0.6e1 * t726 * t2045;
  t2049 = 0.1e1 / t724 / t227;
  t2050 = t77 * t2049;
  t2052 = 0.1e1 / t727 / t93;
  t2053 = t2044 * t2052;
  t2055 = 0.51726012919273400301e3 * t2050 * t2053;
  t2056 = t636 * t787;
  t2059 = 0.1e1 / t598 / t134;
  t2061 = t2059 * t2031 * t603;
  t2063 = 0.10389515463408878255e3 * t311 * t2061;
  t2064 = -t1957 + t1987 + t1991 + 0.19751673498613801407e-1 * t2021 * t139 - 0.17544670867903938621e1 * t2025 - 0.17544670867903938621e1 * t2027 - t2037 - 0.51947577317044391276e2 * t2038 - t2043 + t2047 + t2055 + 0.35089341735807877242e1 * t2056 + t2063;
  t2066 = t268 * t752;
  t2067 = t99 * t2066;
  t2069 = t615 * t290;
  t2076 = t222 * t599;
  t2080 = t222 * t693;
  t2084 = t615 * t275;
  t2091 = t129 * t2059;
  t2092 = t2031 * t603;
  t2096 = 0.1e1 / t692 / t121;
  t2097 = t116 * t2096;
  t2098 = t678 * t281;
  t2099 = t2098 * t696;
  t2110 = -0.47063e1 * t1962 + 0.31375333333333333334e1 * t1965 - 0.36604555555555555556e1 * t1968 - 0.16068111111111111111e1 * t1971 + 0.28051666666666666666e0 * t1975 - 0.56103333333333333332e0 * t1977 - 0.6545388888888888889e0 * t1979 - 0.46308888888888888888e0 * t1982;
  t2111 = t2110 * t282;
  t2118 = t222 * t740;
  t2122 = 0.21687162600603479684e-1 * t670 * t2069 * t298 - 0.16265371950452609763e-1 * t670 * t735 * t745 - 0.48159733137676571078e0 * t670 * t2076 * t749 - t1914 + t1917 + t1921 - 0.16522625736956710527e1 * t670 * t2080 * t697 + 0.68493333333333333332e-1 * t670 * t2084 * t283 - 0.51369999999999999999e-1 * t670 * t671 * t689 - 0.10389515463408878255e3 * t2091 * t2092 - t1987 - 0.19298375398431042081e3 * t2097 * t2099 + 0.1e1 * t276 * t2111 + 0.10274e0 * t670 * t222 * t676 * t679 - t1991 + 0.32530743900905219526e-1 * t670 * t2118 * t742;
  t2123 = t2098 * t282;
  t2134 = -0.34523333333333333333e1 * t1962 + 0.23015555555555555556e1 * t1965 - 0.26851481481481481482e1 * t1968 - 0.93932222222222222223e0 * t1971 + 0.73355e-1 * t1975 - 0.14671e0 * t1977 - 0.17116166666666666667e0 * t1979 - 0.36793333333333333333e0 * t1982;
  t2135 = t2134 * t297;
  t2138 = t129 * t2030;
  t2139 = t2031 * t2034;
  t2151 = t688 * t696;
  t2155 = t1934 * t296;
  t2158 = t298 * t631;
  t2163 = 0.6e1 * t709 * t249 * t720;
  t2166 = 0.34450798614814814813e-2 * t70 * t1970 * t94;
  t2167 = t720 * t728;
  t2170 = 0.48245938496077605201e2 * t726 * t2167 * t247;
  t2171 = t2031 * t297;
  t2175 = 0.1e1 / t692 / t274;
  t2176 = t116 * t2175;
  t2178 = 0.1e1 / t695 / t124;
  t2179 = t2098 * t2178;
  t2183 = 0.1e1 / t724 / t90;
  t2184 = t77 * t2183;
  t2185 = t2044 * t728;
  t2187 = 0.96491876992155210402e2 * t2184 * t2185;
  t2188 = -t2047 - t2055 + 0.6e1 * t694 * t2123 + 0.5848223622634646207e0 * t291 * t2135 + 0.10254018858216406658e4 * t2138 * t2139 - 0.6e1 * t677 * t283 * t688 + 0.56968947174242584612e-3 * t70 * t1970 * t138 + 0.16562821945185185185e-2 * t70 * t1970 * t125 + 0.96491876992155210402e2 * t694 * t2151 * t281 + 0.51947577317044391277e2 * t748 * t2155 - 0.35089341735807877242e1 * t741 * t2158 + t2163 - t2166 - t2170 + 0.35089341735807877242e1 * t748 * t2171 + 0.2069040516770936012e4 * t2176 * t2179 + t2187;
  t2189 = t2122 + t2188;
  t2190 = t114 * t2189;
  t2191 = t99 * t2190;
  t2193 = 0.12e2 * t257 * t753;
  t2194 = t253 * t753;
  t2195 = 0.12e2 * t2194;
  t2196 = t253 * t755;
  t2198 = t257 * t755;
  t2200 = t253 * t757;
  t2202 = t257 * t757;
  t2204 = t776 * t302;
  t2205 = 0.96e2 * t2204;
  t2206 = 0.3e1 * t2067 + t2191 - t2193 + t2195 - t2163 + t2166 + 0.12e2 * t2196 - 0.12e2 * t2198 + t2170 + 0.24e2 * t2200 - 0.24e2 * t2202 - t2205;
  t2207 = t776 * t269;
  t2209 = t770 * t269;
  t2212 = 0.6e2 * t770 * t302;
  t2213 = t773 * t302;
  t2214 = 0.36e2 * t2213;
  t2215 = t773 * t269;
  t2217 = t660 * t301;
  t2218 = t99 * t2217;
  t2221 = 0.24e2 * t2000 * t142;
  t2222 = t62 * t256;
  t2223 = t2222 * t142;
  t2224 = 0.144e3 * t2223;
  t2225 = t252 * t769;
  t2226 = t2225 * t142;
  t2227 = 0.24e3 * t2226;
  t2228 = 0.1e1 / t1637;
  t2229 = t97 * t2228;
  t2231 = 0.12e3 * t2229 * t142;
  t2232 = t2021 * t141;
  t2235 = t290 * t2134 * t297;
  t2237 = 0.5848223622634646207e0 * t311 * t2235;
  t2238 = t2232 * t99 - t2187 - 0.96e2 * t2207 + 0.6e2 * t2209 + t2212 + t2214 + 0.36e2 * t2215 + 0.3e1 * t2218 + t2221 - t2224 + t2227 - t2231 - t2237;
  t2240 = t1954 + t2064 + t2206 + t2238;
  t2242 = t55 * t66 * t2240;
  t2243 = t46 * t2242;
  t2244 = 0.5e1 / 0.9e1 * t2243;
  t2246 = 0.1e1 / t33 / t1637;
  t2247 = t30 * t2246;
  t2249 = 0.595e3 / 0.27e2 * t2247 * t63;
  t2250 = t565 * t210;
  t2252 = t565 * t213;
  t2253 = 0.119e3 / 0.6e1 * t2252;
  t2254 = t202 * t576;
  t2256 = t202 * t580;
  t2258 = t202 * t584;
  t2260 = t202 * t61;
  t2261 = 0.7e1 / 0.2e1 * t2260;
  t2262 = t205 * t205;
  t2263 = 0.1e1 / t2262;
  t2264 = t2263 * t62;
  t2265 = t575 * t209;
  t2266 = t2264 * t2265;
  t2269 = t573 * t8;
  t2270 = t2269 * t575;
  t2271 = t59 * t2270;
  t2273 = t62 * t209;
  t2274 = t2273 * t583;
  t2277 = t206 * t209;
  t2278 = t59 * t2277;
  t2280 = t579 * t583;
  t2281 = t59 * t2280;
  t2283 = t158 * t158;
  t2285 = 0.1e1 / t4 / t2283;
  t2286 = tau[0] * t2285;
  t2288 = 0.44e3 / 0.27e2 * t2286 * t16;
  t2290 = 0.2e3 / 0.9e1 * t496 * t168;
  t2292 = 0.5e2 / 0.9e1 * t161 * t503;
  t2294 = 0.25e2 / 0.3e1 * t161 * t509;
  t2295 = t14 * t13;
  t2296 = 0.1e1 / t2295;
  t2297 = t502 * t167;
  t2298 = t2296 * t2297;
  t2300 = 0.1e2 / 0.27e2 * t7 * t2298;
  t2301 = t501 * t167;
  t2302 = t2301 * t508;
  t2304 = 0.1e2 / 0.3e1 * t7 * t2302;
  t2305 = 0.3e1 * t2001;
  t2306 = t15 * t2305;
  t2308 = 0.5e1 / 0.3e1 * t7 * t2306;
  t2309 = t25 * t24;
  t2310 = 0.1e1 / t2309;
  t2311 = t513 * t171;
  t2312 = t2310 * t2311;
  t2314 = 0.1e2 / 0.27e2 * t22 * t2312;
  t2315 = t512 * t171;
  t2316 = t2315 * t517;
  t2318 = 0.1e2 / 0.3e1 * t22 * t2316;
  t2319 = -t2305;
  t2320 = t26 * t2319;
  t2322 = 0.5e1 / 0.3e1 * t22 * t2320;
  t2323 = -t2288 + t2290 - t2292 - t2294 - t2300 + t2304 + t2308 - t2314 + t2318 + t2322;
  t2324 = t207 * t2323;
  t2327 = t2249 + 0.119e3 / 0.12e2 * t2250 - t2253 + 0.7e1 / 0.2e1 * t2254 - 0.7e1 * t2256 - 0.7e1 / 0.4e1 * t2258 + t2261 + 0.3e1 / 0.4e1 * t59 * t2266 - 0.3e1 / 0.2e1 * t2271 - 0.3e1 / 0.4e1 * t878 * t2274 + 0.3e1 / 0.4e1 * t2278 + 0.3e1 / 0.4e1 * t2281 + t59 * t2324 / 0.8e1;
  t2329 = t55 * t2327 * t146;
  t2330 = t46 * t2329;
  t2331 = 0.5e1 / 0.9e1 * t2330;
  t2333 = t55 * t589 * t316;
  t2334 = t46 * t2333;
  t2335 = 0.5e1 / 0.3e1 * t2334;
  t2336 = t814 * t316;
  t2337 = 0.3e1 * t2336;
  t2338 = 0.154e3 / 0.27e2 * t202;
  t2339 = -t2288 + t2290 - t2292 - t2294 - t2300 + t2304 + t2308 - t2314 + t2318 + t2322 + t2338;
  t2340 = t2 * t2339;
  t2342 = t2340 * t40 * t153;
  t2347 = t527 * t180;
  t2348 = t2 * t2347;
  t2349 = t542 * t544;
  t2352 = t191 * t191;
  t2353 = 0.1e1 / t2352;
  t2354 = t539 * t2353;
  t2355 = t39 * t2354;
  t2356 = t544 * params->c;
  t2358 = t2356 * t2347 * t50;
  t2361 = t180 * t522;
  t2362 = t806 * t2361;
  t2365 = params->c * t2339;
  t2366 = t325 * t2365;
  t2369 = -0.5e1 / 0.9e1 * t2342 + 0.1e3 / 0.27e2 * t523 * t188 * t327 - 0.2e4 / 0.81e2 * t2348 * t2349 + 0.1e5 / 0.729e3 * t2355 * t2358 - 0.2e4 / 0.81e2 * t805 * t2362 + 0.5e2 / 0.81e2 * t324 * t2366;
  t2370 = t2369 * t146;
  t2371 = t2348 * t539;
  t2372 = t541 * t66;
  t2373 = t2372 * t1295;
  t2374 = t2371 * t2373;
  t2375 = 0.2e4 / 0.81e2 * t2374;
  t2376 = t156 * t2240;
  t2377 = t182 * t793;
  t2378 = 0.5e1 / 0.3e1 * t2377;
  t2380 = t55 * t216 * t791;
  t2381 = t46 * t2380;
  t2382 = 0.5e1 / 0.3e1 * t2381;
  t2383 = t217 * t545;
  t2384 = t543 * t2383;
  t2385 = 0.2e4 / 0.81e2 * t2384;
  t2386 = t1900 - t1904 - t1908 + t1910 + t2244 + t2331 + t2335 + t2337 + t2370 + t2375 + t2376 + t2378 + t2382 + t2385;
  t2387 = t317 * t545;
  t2388 = t543 * t2387;
  t2389 = 0.2e4 / 0.81e2 * t2388;
  t2390 = t2340 * t45;
  t2391 = t2390 * t148;
  t2392 = 0.5e1 / 0.9e1 * t2391;
  t2393 = t524 * t218;
  t2394 = 0.5e1 / 0.3e1 * t2393;
  t2395 = t524 * t318;
  t2396 = 0.5e1 / 0.3e1 * t2395;
  t2397 = t182 * t591;
  t2398 = 0.5e1 / 0.3e1 * t2397;
  t2399 = t182 * t595;
  t2400 = 0.1e2 / 0.3e1 * t2399;
  t2401 = t553 * t522;
  t2402 = t193 * t2401;
  t2403 = t190 * t2402;
  t2404 = 0.5e2 / 0.27e2 * t2403;
  t2405 = t194 * t2339;
  t2406 = t193 * t2405;
  t2407 = t190 * t2406;
  t2408 = 0.5e2 / 0.81e2 * t2407;
  t2409 = t192 * t589;
  t2411 = t190 * t2409 * t195;
  t2412 = 0.5e2 / 0.27e2 * t2411;
  t2414 = t190 * t549 * t554;
  t2415 = 0.1e3 / 0.27e2 * t2414;
  t2416 = t549 * t558;
  t2417 = t190 * t2416;
  t2418 = 0.5e2 / 0.27e2 * t2417;
  t2419 = t791 * params->c;
  t2420 = t2419 * t180;
  t2422 = t190 * t193 * t2420;
  t2423 = 0.5e2 / 0.27e2 * t2422;
  t2424 = t523 * t189;
  t2425 = t2424 * t196;
  t2426 = 0.1e3 / 0.27e2 * t2425;
  t2427 = t2354 * t66;
  t2428 = t39 * t2427;
  t2429 = t146 * t2356;
  t2431 = t2429 * t2347 * t50;
  t2432 = t2428 * t2431;
  t2433 = 0.1e5 / 0.729e3 * t2432;
  t2434 = t2389 + t2392 + t2394 + t2396 + t2398 + t2400 - t2404 - t2408 - t2412 - t2415 - t2418 - t2423 - t2426 - t2433;
  tv3rho30 = t9 * (t2386 + t2434) + 0.3e1 * t818 + 0.5e1 / 0.3e1 * t794 + 0.3e1 * t815 + 0.6e1 * t816 - 0.1e3 / 0.27e2 * t532 - 0.1e3 / 0.27e2 * t551 - 0.1e3 / 0.27e2 * t556 - 0.5e2 / 0.27e2 * t560 + 0.5e1 / 0.3e1 * t525 + 0.1e2 / 0.3e1 * t534 + 0.1e2 / 0.3e1 * t536 + 0.2e4 / 0.81e2 * t547 + 0.5e1 / 0.3e1 * t592 + 0.1e2 / 0.3e1 * t596;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t2451 = 0.2e1 * t973;
  t2452 = 0.1e3 / 0.81e2 * t859;
  t2453 = 0.1e3 / 0.81e2 * t863;
  t2454 = 0.1e3 / 0.81e2 * t867;
  t2455 = 0.1e3 / 0.81e2 * t873;
  t2456 = 0.1e3 / 0.81e2 * t905;
  t2457 = 0.2e3 / 0.81e2 * t847;
  t2458 = 0.4e4 / 0.243e3 * t856;
  t2459 = 0.2e1 * t972;
  t2460 = 0.2e1 * t971;
  t2461 = t2451 - t2452 - t2453 - t2454 - t2455 - t2456 - t552 - t557 - t561 - t2457 + t2458 + t2459 + t817 + t818 - t533 + t2460 + t815;
  t2462 = t383 * params->c;
  t2463 = t325 * t2462;
  t2464 = t529 * t2463;
  t2467 = t543 * t317 * t854;
  t2469 = t544 * t841;
  t2470 = t2469 * t180;
  t2471 = t147 * t2470;
  t2472 = t543 * t2471;
  t2474 = t853 * t522;
  t2475 = t147 * t2474;
  t2476 = t543 * t2475;
  t2478 = t365 * params->c;
  t2479 = t325 * t2478;
  t2480 = t529 * t2479;
  t2483 = t543 * t217 * t854;
  t2485 = t951 * params->c;
  t2486 = t2485 * t180;
  t2488 = t190 * t193 * t2486;
  t2491 = t190 * t871 * t554;
  t2493 = t871 * t558;
  t2494 = t190 * t2493;
  t2496 = t553 * t841;
  t2497 = t193 * t2496;
  t2498 = t190 * t2497;
  t2501 = 0.2e3 / 0.27e2 * t496 * t337;
  t2503 = 0.1e3 / 0.27e2 * t161 * t824;
  t2505 = 0.5e2 / 0.9e1 * t161 * t828;
  t2507 = t2296 * t336 * t502;
  t2509 = 0.1e2 / 0.27e2 * t7 * t2507;
  t2510 = t7 * t501;
  t2511 = t507 * t167;
  t2513 = 0.2e2 / 0.9e1 * t2510 * t2511;
  t2514 = t823 * t508;
  t2516 = 0.1e2 / 0.9e1 * t7 * t2514;
  t2517 = t15 * t506;
  t2519 = 0.5e1 / 0.3e1 * t7 * t2517;
  t2520 = t827 * t98;
  t2522 = 0.5e1 * t7 * t2520;
  t2524 = 0.5e2 / 0.27e2 * t343 * t514;
  t2526 = 0.25e2 / 0.9e1 * t343 * t518;
  t2528 = t2310 * t346 * t513;
  t2530 = 0.1e2 / 0.27e2 * t22 * t2528;
  t2531 = t22 * t512;
  t2532 = t507 * t171;
  t2534 = 0.2e2 / 0.9e1 * t2531 * t2532;
  t2535 = t833 * t517;
  t2537 = 0.1e2 / 0.9e1 * t22 * t2535;
  t2538 = t26 * t506;
  t2540 = 0.5e1 / 0.3e1 * t22 * t2538;
  t2541 = t837 * t98;
  t2543 = 0.5e1 * t22 * t2541;
  t2544 = t2501 - t2503 - t2505 - t2509 + t2513 + t2516 + t2519 - t2522 - t2524 - t2526 - t2530 - t2534 + t2537 - t2540 + t2543 + t2338;
  t2545 = t194 * t2544;
  t2546 = t193 * t2545;
  t2547 = t190 * t2546;
  t2549 = t192 * t891;
  t2551 = t190 * t2549 * t195;
  t2553 = -0.1e3 / 0.81e2 * t2464 + 0.4e4 / 0.243e3 * t2467 + 0.4e4 / 0.243e3 * t2472 + 0.2e4 / 0.243e3 * t2476 - 0.1e3 / 0.81e2 * t2480 + 0.4e4 / 0.243e3 * t2483 - 0.1e3 / 0.81e2 * t2488 - 0.1e3 / 0.81e2 * t2491 - 0.5e2 / 0.81e2 * t2494 - 0.1e3 / 0.81e2 * t2498 - 0.5e2 / 0.81e2 * t2547 - 0.1e3 / 0.81e2 * t2551;
  t2554 = t2409 * t355;
  t2555 = t190 * t2554;
  t2557 = t549 * t861;
  t2558 = t190 * t2557;
  t2560 = t549 * t865;
  t2561 = t190 * t2560;
  t2563 = t2419 * t350;
  t2564 = t193 * t2563;
  t2565 = t190 * t2564;
  t2567 = t846 * t550;
  t2569 = t846 * t555;
  t2571 = t846 * t559;
  t2573 = t352 * t793;
  t2575 = t2 * t2544;
  t2576 = t2575 * t45;
  t2577 = t2576 * t148;
  t2579 = t843 * t218;
  t2581 = t843 * t318;
  t2583 = t351 * t542;
  t2584 = t2583 * t546;
  t2586 = t352 * t591;
  t2588 = -0.5e2 / 0.81e2 * t2555 - 0.1e3 / 0.81e2 * t2558 - 0.1e3 / 0.81e2 * t2561 - 0.5e2 / 0.81e2 * t2565 - 0.2e3 / 0.81e2 * t2567 - 0.2e3 / 0.81e2 * t2569 - 0.1e3 / 0.81e2 * t2571 + 0.5e1 / 0.9e1 * t2573 + 0.5e1 / 0.9e1 * t2577 + 0.1e2 / 0.9e1 * t2579 + 0.1e2 / 0.9e1 * t2581 + 0.2e4 / 0.81e2 * t2584 + 0.5e1 / 0.9e1 * t2586;
  t2590 = t352 * t595;
  t2592 = t383 * t545;
  t2593 = t543 * t2592;
  t2596 = t55 * t364 * t791;
  t2597 = t46 * t2596;
  t2599 = t524 * t384;
  t2601 = t182 * t908;
  t2603 = t182 * t953;
  t2605 = t524 * t366;
  t2607 = t182 * t893;
  t2609 = t182 * t897;
  t2611 = t365 * t545;
  t2612 = t543 * t2611;
  t2614 = t565 * t361;
  t2616 = t202 * t573;
  t2618 = 0.7e1 / 0.3e1 * t2616 * t880;
  t2619 = t202 * t883;
  t2621 = t62 * t886;
  t2622 = t2621 * t209;
  t2625 = t879 * t583;
  t2628 = t2501 - t2503 - t2505 - t2509 + t2513 + t2516 + t2519 - t2522 - t2524 - t2526 - t2530 - t2534 + t2537 - t2540 + t2543;
  t2629 = t207 * t2628;
  t2633 = 0.7e1 / 0.6e1 * t202 * t887;
  t2634 = t206 * t360;
  t2635 = t59 * t2634;
  t2637 = t579 * t886;
  t2639 = t59 * t2637 / 0.2e1;
  t2640 = t59 * t2263;
  t2641 = t879 * t575;
  t2644 = t8 * t360;
  t2645 = t2644 * t209;
  t2646 = t878 * t2645;
  t2650 = 0.119e3 / 0.18e2 * t2252;
  t2654 = 0.7e1 / 0.6e1 * t2260;
  t2655 = 0.119e3 / 0.36e2 * t2614 + t2618 - 0.7e1 / 0.3e1 * t2619 - t878 * t2622 / 0.2e1 - t878 * t2625 / 0.4e1 + t59 * t2629 / 0.8e1 - t2633 + t2635 / 0.4e1 + t2639 + 0.3e1 / 0.4e1 * t2640 * t2641 - t2646 + 0.7e1 / 0.6e1 * t2254 + t2271 / 0.2e1 + t2249 + 0.119e3 / 0.18e2 * t2250 - t2650 - 0.7e1 / 0.12e2 * t2258 - t2278 / 0.2e1 - t2281 / 0.4e1 - t2654;
  t2657 = t55 * t2655 * t146;
  t2658 = t46 * t2657;
  t2660 = t942 * t67;
  t2662 = 0.36622894612013090108e-3 * t2660 * t308;
  t2663 = t915 * t664;
  t2668 = -t2662 + 0.24415263074675393405e-3 * t2663 + t1914 - t1917 - t1921 - t1927 - 0.18311447306006545054e-3 * t1929 + 0.4883052614935078681e-3 * t1931 - t1937 + t1941 - t1944 + t1947 + t1950 + 0.21687162600603479684e-1 * t1952 - t1957 + t1987;
  t2672 = t253 * t945;
  t2674 = t257 * t945;
  t2677 = 0.8e1 * t253 * t943;
  t2678 = t1993 * t335;
  t2681 = t640 * t8;
  t2692 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2678 * t641 + 0.16e2 / 0.9e1 * t2681 * t506 * t166 + 0.4e1 / 0.9e1 * t925 * t644 + 0.8e1 / 0.3e1 * t103 * t506 - 0.8e1 * t928 * t98);
  t2693 = t2008 * t372;
  t2696 = t650 * t8;
  t2707 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2693 * t651 - 0.16e2 / 0.9e1 * t2696 * t506 * t263 + 0.4e1 / 0.9e1 * t933 * t654 - 0.8e1 / 0.3e1 * t107 * t506 + 0.8e1 * t936 * t98);
  t2709 = (t2692 + t2707) * t113;
  t2712 = t942 * t301;
  t2714 = 0.2e1 * t99 * t2712;
  t2716 = 0.8e1 * t257 * t943;
  t2718 = t1991 - 0.5848223622634646207e0 * t2025 - 0.11696447245269292414e1 * t2027 - t2037 - 0.34631718211362927518e2 * t2038 - t2043 + 0.8e1 * t2672 - 0.8e1 * t2674 + t2677 + t2047 + t2055 + 0.19751673498613801407e-1 * t2709 * t139 + t2714 - t2716 + 0.23392894490538584828e1 * t2056 + t2063;
  t2720 = t2709 * t141;
  t2722 = t773 * t378;
  t2724 = t776 * t378;
  t2726 = t377 * t752;
  t2727 = t99 * t2726;
  t2728 = t770 * t378;
  t2730 = t377 * t70;
  t2731 = t2730 * t780;
  t2734 = t911 * t787;
  t2736 = 0.4e1 * t2194;
  t2737 = t911 * t633;
  t2739 = t911 * t604;
  t2741 = t942 * t129;
  t2743 = 0.11696447245269292414e1 * t2741 * t313;
  t2744 = t99 * t2720 + 0.12e2 * t2722 - 0.32e2 * t2724 + t2727 + 0.2e2 * t2728 + 0.10843581300301739842e-1 * t2731 + 0.2e1 * t2067 + t2191 - t2193 + 0.11696447245269292414e1 * t2734 + t2736 - 0.5848223622634646207e0 * t2737 - 0.17315859105681463759e2 * t2739 - t2743 - t2163 + t2166;
  t2748 = 0.32e2 * t2204;
  t2750 = 0.12e2 * t2213;
  t2752 = 0.48e2 * t2223;
  t2753 = 0.8e2 * t2226;
  t2754 = -0.4e1 * t2196 - 0.4e1 * t2198 + t2170 - 0.16e2 * t2202 - t2748 + 0.4e2 * t2209 + t2212 - t2750 - 0.24e2 * t2215 + t2218 - t2221 + t2752 + t2753 - t2231 - t2187 - t2237;
  t2756 = t2668 + t2718 + t2744 + t2754;
  t2758 = t55 * t66 * t2756;
  t2759 = t46 * t2758;
  t2761 = 0.1e2 / 0.9e1 * t2590 + 0.2e4 / 0.243e3 * t2593 + 0.5e1 / 0.9e1 * t2597 + 0.5e1 / 0.9e1 * t2599 + 0.1e2 / 0.9e1 * t2601 + 0.1e2 / 0.9e1 * t2603 + 0.5e1 / 0.9e1 * t2605 + 0.1e2 / 0.9e1 * t2607 + 0.1e2 / 0.9e1 * t2609 + 0.2e4 / 0.243e3 * t2612 + 0.5e1 / 0.9e1 * t2658 + 0.5e1 / 0.9e1 * t2759;
  t2763 = t55 * t589 * t382;
  t2764 = t46 * t2763;
  t2767 = t55 * t216 * t951;
  t2768 = t46 * t2767;
  t2770 = t814 * t382;
  t2771 = t970 * t316;
  t2774 = t2575 * t40 * t153;
  t2776 = t842 * t188;
  t2779 = t351 * t539;
  t2784 = t2354 * t2356;
  t2785 = t39 * t2784;
  t2787 = t350 * t527 * t50;
  t2790 = t841 * t180;
  t2791 = t806 * t2790;
  t2794 = t350 * t522;
  t2795 = t806 * t2794;
  t2798 = params->c * t2544;
  t2799 = t325 * t2798;
  t2802 = -0.5e1 / 0.9e1 * t2774 + 0.2e3 / 0.81e2 * t2776 * t327 - 0.2e4 / 0.81e2 * t2779 * t807 + 0.1e3 / 0.81e2 * t959 * t811 + 0.1e5 / 0.729e3 * t2785 * t2787 - 0.4e4 / 0.243e3 * t805 * t2791 - 0.2e4 / 0.243e3 * t805 * t2795 + 0.5e2 / 0.81e2 * t324 * t2799;
  t2803 = t2802 * t146;
  t2804 = t156 * t2756;
  t2805 = t902 * t522;
  t2806 = t193 * t2805;
  t2807 = t190 * t2806;
  t2810 = t190 * t549 * t903;
  t2812 = t2353 * t66;
  t2813 = t2812 * t146;
  t2814 = t805 * t2813;
  t2815 = t2356 * t350;
  t2817 = t2815 * t527 * t50;
  t2818 = t2814 * t2817;
  t2820 = t330 * t951;
  t2822 = t394 * t791;
  t2824 = t55 * t891 * t316;
  t2825 = t46 * t2824;
  t2827 = t842 * t189;
  t2828 = t2827 * t196;
  t2830 = 0.5e1 / 0.9e1 * t2764 + 0.1e2 / 0.9e1 * t2768 + t2770 + 0.2e1 * t2771 + t2803 + t2804 - 0.5e2 / 0.81e2 * t2807 - 0.1e3 / 0.81e2 * t2810 - 0.1e5 / 0.729e3 * t2818 + 0.2e1 * t2820 + t2822 + 0.1e2 / 0.9e1 * t2825 - 0.2e3 / 0.81e2 * t2828;
  t2834 = 0.1e2 / 0.9e1 * t954;
  t2835 = 0.1e2 / 0.9e1 * t844;
  t2836 = 0.1e2 / 0.9e1 * t849;
  t2837 = 0.1e2 / 0.9e1 * t851;
  t2838 = 0.1e2 / 0.9e1 * t869;
  t2839 = 0.1e2 / 0.9e1 * t894;
  t2840 = 0.1e2 / 0.9e1 * t898;
  t2841 = 0.1e2 / 0.9e1 * t900;
  t2842 = 0.1e2 / 0.9e1 * t909;
  t2843 = 0.2e1 * t974;
  t2844 = t9 * (t2553 + t2588 + t2761 + t2830) + t2834 + t2835 + t2836 + t2837 + t2838 + t2839 + t2840 + t2841 + t2842 + t537 + t548 + t593 + t597 + t795 + t526 + t535 + t2843;
  tv3rho31 = t2461 + t2844;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t2845 = t2451 - t1027 - t1031 - t1035 - t2452 - t2453 - t2454 - t2455 - t2456 - t2457 - t1016 + t2458 + t1105 + t1106 + t2459 + t1103 + t1050;
  t2847 = t253 * t1073;
  t2849 = t257 * t1073;
  t2852 = t1993 * t1055;
  t2857 = t640 * t1058;
  t2862 = -0.2e1 * t506 - 0.6e1 * t2000;
  t2866 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2852 * t166 + 0.16e2 / 0.9e1 * t925 * t507 + 0.4e1 / 0.9e1 * t2857 * t166 + 0.4e1 / 0.3e1 * t103 * t2862);
  t2867 = t2008 * t1063;
  t2872 = t650 * t1066;
  t2875 = -t2862;
  t2879 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2867 * t263 - 0.16e2 / 0.9e1 * t933 * t507 + 0.4e1 / 0.9e1 * t2872 * t263 + 0.4e1 / 0.3e1 * t107 * t2875);
  t2881 = (t2866 + t2879) * t113;
  t2882 = t2881 * t141;
  t2884 = t1072 * t301;
  t2885 = t99 * t2884;
  t2886 = -t2662 + 0.48830526149350786811e-3 * t2663 + 0.4e1 * t2847 - 0.4e1 * t2849 + t1914 - t1917 - t1921 - t1927 + 0.24415263074675393405e-3 * t1931 - t1937 + t1941 + t99 * t2882 + t2885 - t1944 + t1947 + t1950;
  t2888 = t1072 * t67;
  t2889 = t2888 * t308;
  t2894 = t1072 * t129;
  t2895 = t2894 * t313;
  t2899 = 0.10843581300301739842e-1 * t1952 - t1957 + t1987 + t1991 - 0.18311447306006545054e-3 * t2889 + 0.19751673498613801407e-1 * t2881 * t139 - 0.5848223622634646207e0 * t2027 - 0.5848223622634646207e0 * t2895 - t2037 - 0.17315859105681463759e2 * t2038 - t2043 - 0.16e2 * t2674 - t2677 + t2047 + t2055 + t2714;
  t2909 = -t2716 + 0.11696447245269292414e1 * t2056 + t2063 - 0.24e2 * t2722 + 0.2e1 * t2727 + 0.4e2 * t2728 + 0.21687162600603479684e-1 * t2731 + t2067 + t2191 - t2193 + 0.23392894490538584828e1 * t2734 - t2736 - 0.11696447245269292414e1 * t2737 - 0.34631718211362927517e2 * t2739 - t2743 - t2163;
  t2915 = t2166 + t2170 - 0.8e1 * t2200 - 0.8e1 * t2202 + t2748 + 0.32e2 * t2207 + 0.2e2 * t2209 + t2212 - t2750 + 0.12e2 * t2215 + t2221 + t2752 - t2753 - t2231 - t2187 - t2237;
  t2917 = t2886 + t2899 + t2909 + t2915;
  t2919 = t55 * t66 * t2917;
  t2920 = t46 * t2919;
  t2922 = t549 * t1032;
  t2923 = t190 * t2922;
  t2925 = t846 * t904;
  t2927 = t2549 * t355;
  t2928 = t190 * t2927;
  t2930 = t871 * t861;
  t2931 = t190 * t2930;
  t2933 = t1008 * t189;
  t2934 = t2933 * t196;
  t2936 = t846 * t866;
  t2938 = t846 * t872;
  t2940 = t1102 * t316;
  t2944 = t202 * t1038;
  t2946 = t62 * t1037;
  t2947 = t2946 * t209;
  t2950 = t2269 * t1037;
  t2951 = t59 * t2950;
  t2953 = t879 * t886;
  t2957 = t202 * t1043;
  t2959 = t62 * t1042;
  t2960 = t2959 * t209;
  t2963 = t579 * t1042;
  t2964 = t59 * t2963;
  t2967 = 0.5e2 / 0.27e2 * t161 * t984;
  t2968 = t2296 * t983;
  t2969 = t2968 * t167;
  t2971 = 0.1e2 / 0.27e2 * t7 * t2969;
  t2972 = t336 * t8;
  t2973 = t2972 * t506;
  t2975 = 0.2e2 / 0.9e1 * t2510 * t2973;
  t2977 = 0.25e2 / 0.9e1 * t161 * t988;
  t2978 = t501 * t987;
  t2979 = t2978 * t167;
  t2981 = 0.1e2 / 0.9e1 * t7 * t2979;
  t2983 = -t506 - 0.3e1 * t2000;
  t2984 = t15 * t2983;
  t2986 = 0.5e1 / 0.3e1 * t7 * t2984;
  t2988 = 0.2e3 / 0.27e2 * t994 * t172;
  t2990 = 0.1e3 / 0.27e2 * t343 * t834;
  t2992 = 0.5e2 / 0.9e1 * t343 * t838;
  t2993 = t2310 * t999;
  t2994 = t2993 * t171;
  t2996 = 0.1e2 / 0.27e2 * t22 * t2994;
  t2997 = t346 * t8;
  t2998 = t2997 * t506;
  t3000 = 0.2e2 / 0.9e1 * t2531 * t2998;
  t3001 = t512 * t1003;
  t3002 = t3001 * t171;
  t3004 = 0.1e2 / 0.9e1 * t22 * t3002;
  t3005 = -t2983;
  t3006 = t26 * t3005;
  t3008 = 0.5e1 / 0.3e1 * t22 * t3006;
  t3009 = -t2967 - t2971 + t2975 - t2977 + t2981 + t2986 + t2988 - t2990 + t2992 - t2996 - t3000 + t3004 + t3008;
  t3010 = t207 * t3009;
  t3014 = t2249 + 0.119e3 / 0.36e2 * t2250 + t2650 + 0.119e3 / 0.18e2 * t2614 + t2618 - t2633 + 0.7e1 / 0.3e1 * t2256 - t2654 + 0.7e1 / 0.6e1 * t2944 + 0.3e1 / 0.4e1 * t2640 * t2947 - t2951 / 0.2e1 - t878 * t2953 / 0.2e1 + t2646 - t2635 / 0.2e1 - t2639 - 0.7e1 / 0.12e2 * t2957 - t878 * t2960 / 0.4e1 + t2964 / 0.4e1 + t59 * t3010 / 0.8e1 + t2278 / 0.4e1;
  t3016 = t55 * t3014 * t146;
  t3017 = t46 * t3016;
  t3020 = t55 * t1046 * t316;
  t3021 = t46 * t3020;
  t3023 = t182 * t1052;
  t3025 = 0.5e1 / 0.9e1 * t2920 - 0.5e2 / 0.81e2 * t2923 - 0.2e3 / 0.81e2 * t2925 - 0.1e3 / 0.81e2 * t2928 - 0.1e3 / 0.81e2 * t2931 - 0.1e3 / 0.81e2 * t2934 - 0.2e3 / 0.81e2 * t2936 - 0.2e3 / 0.81e2 * t2938 + t2940 + 0.5e1 / 0.9e1 * t3017 + 0.5e1 / 0.9e1 * t3021 + 0.1e2 / 0.9e1 * t3023;
  t3027 = t55 * t891 * t382;
  t3028 = t46 * t3027;
  t3031 = t55 * t364 * t951;
  t3032 = t46 * t3031;
  t3034 = t182 * t1086;
  t3036 = -t2967 - t2971 + t2975 - t2977 + t2981 + t2986 + t2988 - t2990 + t2992 - t2996 - t3000 + t3004 + t3008 + t2338;
  t3037 = t2 * t3036;
  t3038 = t3037 * t45;
  t3039 = t3038 * t148;
  t3041 = t1009 * t218;
  t3043 = t1009 * t318;
  t3045 = t1013 * t542;
  t3046 = t147 * t1896;
  t3047 = t3045 * t3046;
  t3049 = t843 * t366;
  t3051 = t352 * t893;
  t3053 = t352 * t897;
  t3055 = t843 * t384;
  t3057 = t352 * t908;
  t3059 = t352 * t953;
  t3061 = 0.1e2 / 0.9e1 * t3028 + 0.1e2 / 0.9e1 * t3032 + 0.5e1 / 0.9e1 * t3034 + 0.5e1 / 0.9e1 * t3039 + 0.5e1 / 0.9e1 * t3041 + 0.5e1 / 0.9e1 * t3043 + 0.2e4 / 0.81e2 * t3047 + 0.1e2 / 0.9e1 * t3049 + 0.1e2 / 0.9e1 * t3051 + 0.1e2 / 0.9e1 * t3053 + 0.1e2 / 0.9e1 * t3055 + 0.1e2 / 0.9e1 * t3057 + 0.1e2 / 0.9e1 * t3059;
  t3063 = t217 * t1021;
  t3064 = t543 * t3063;
  t3066 = t317 * t1021;
  t3067 = t543 * t3066;
  t3069 = t182 * t1048;
  t3071 = t2356 * t1012;
  t3073 = t3071 * t180 * t50;
  t3074 = t2814 * t3073;
  t3076 = t970 * t382;
  t3079 = t3037 * t40 * t153;
  t3081 = t1008 * t188;
  t3086 = t1013 * t539;
  t3087 = t806 * t180;
  t3091 = t1012 * t180 * t50;
  t3094 = t350 * t841;
  t3095 = t806 * t3094;
  t3098 = t1007 * t180;
  t3099 = t806 * t3098;
  t3102 = params->c * t3036;
  t3103 = t325 * t3102;
  t3106 = -0.5e1 / 0.9e1 * t3079 + 0.1e3 / 0.81e2 * t3081 * t327 + 0.2e3 / 0.81e2 * t959 * t967 - 0.2e4 / 0.81e2 * t3086 * t3087 + 0.1e5 / 0.729e3 * t2785 * t3091 - 0.4e4 / 0.243e3 * t805 * t3095 - 0.2e4 / 0.243e3 * t805 * t3099 + 0.5e2 / 0.81e2 * t324 * t3103;
  t3107 = t3106 * t146;
  t3108 = t394 * t951;
  t3110 = t383 * t854;
  t3111 = t543 * t3110;
  t3113 = t544 * t1007;
  t3114 = t3113 * t180;
  t3115 = t147 * t3114;
  t3116 = t543 * t3115;
  t3118 = t853 * t841;
  t3119 = t147 * t3118;
  t3120 = t543 * t3119;
  t3122 = t365 * t854;
  t3123 = t543 * t3122;
  t3125 = t1014 * t1902;
  t3127 = 0.2e4 / 0.243e3 * t3064 + 0.2e4 / 0.243e3 * t3067 + 0.5e1 / 0.9e1 * t3069 - 0.1e5 / 0.729e3 * t3074 + 0.2e1 * t3076 + t3107 + 0.2e1 * t3108 + 0.4e4 / 0.243e3 * t3111 + 0.2e4 / 0.243e3 * t3116 + 0.4e4 / 0.243e3 * t3120 + 0.4e4 / 0.243e3 * t3123 - 0.1e3 / 0.81e2 * t3125;
  t3128 = t1014 * t1906;
  t3131 = t55 * t216 * t1084;
  t3132 = t46 * t3131;
  t3134 = t156 * t2917;
  t3135 = t330 * t1084;
  t3136 = t1084 * params->c;
  t3137 = t3136 * t180;
  t3138 = t193 * t3137;
  t3139 = t190 * t3138;
  t3141 = t553 * t1007;
  t3142 = t193 * t3141;
  t3143 = t190 * t3142;
  t3145 = t194 * t3036;
  t3146 = t193 * t3145;
  t3147 = t190 * t3146;
  t3149 = t192 * t1046;
  t3150 = t3149 * t195;
  t3151 = t190 * t3150;
  t3153 = t871 * t903;
  t3154 = t190 * t3153;
  t3156 = t871 * t865;
  t3157 = t190 * t3156;
  t3159 = t549 * t1028;
  t3160 = t190 * t3159;
  t3162 = t2485 * t350;
  t3163 = t193 * t3162;
  t3164 = t190 * t3163;
  t3166 = t902 * t841;
  t3167 = t193 * t3166;
  t3168 = t190 * t3167;
  t3170 = -0.1e3 / 0.81e2 * t3128 + 0.5e1 / 0.9e1 * t3132 + t3134 + t3135 - 0.5e2 / 0.81e2 * t3139 - 0.5e2 / 0.81e2 * t3143 - 0.5e2 / 0.81e2 * t3147 - 0.5e2 / 0.81e2 * t3151 - 0.1e3 / 0.81e2 * t3154 - 0.1e3 / 0.81e2 * t3157 - 0.1e3 / 0.81e2 * t3160 - 0.1e3 / 0.81e2 * t3164 - 0.1e3 / 0.81e2 * t3168;
  t3174 = t1054 + t1088 + t2460 + t9 * (t3025 + t3061 + t3127 + t3170) + t1011 + t1018 + t1020 + t1024 + t2834 + t2835 + t2836 + t2837 + t2838 + t2839 + t2840 + t2841 + t2842 + t2843;
  tv3rho32 = t2845 + t3174;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t3175 = t1012 * t350;
  t3176 = t2 * t3175;
  t3177 = t3176 * t539;
  t3178 = t3177 * t2373;
  t3179 = 0.2e4 / 0.81e2 * t3178;
  t3180 = t394 * t1084;
  t3181 = 0.3e1 * t3180;
  t3182 = t1055 * t335;
  t3187 = -t506 - t2000;
  t3188 = 0.6e1 * t3187;
  t3192 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t1993 * t3182 + 0.4e1 / 0.3e1 * t925 * t1058 + 0.4e1 / 0.3e1 * t103 * t3188);
  t3193 = t1063 * t372;
  t3198 = -t3188;
  t3202 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2008 * t3193 + 0.4e1 / 0.3e1 * t933 * t1066 + 0.4e1 / 0.3e1 * t107 * t3198);
  t3204 = (t3192 + t3202) * t113;
  t3211 = 0.19751673498613801407e-1 * t3204 * t139 + 0.73245789224026180216e-3 * t2663 - 0.12e2 * t2847 - 0.12e2 * t2849 + t1914 - t1917 - t1921 - t1927 - t1937 + t1941 + 0.3e1 * t2885 - t1944;
  t3216 = t1947 + t1950 - t1957 + t1987 + t1991 - 0.54934341918019635162e-3 * t2889 - 0.17544670867903938621e1 * t2895 - t2037 - t2043 - 0.24e2 * t2672 - 0.24e2 * t2674 + t2047 + t2055;
  t3218 = t3204 * t141;
  t3227 = t2063 + t99 * t3218 + 0.36e2 * t2722 + 0.96e2 * t2724 + 0.3e1 * t2727 + 0.6e2 * t2728 + 0.32530743900905219526e-1 * t2731 + t2191 - t2193 + 0.35089341735807877242e1 * t2734 - t2195 - 0.17544670867903938621e1 * t2737;
  t3229 = -0.51947577317044391276e2 * t2739 - t2163 + t2166 + t2170 + t2205 + t2212 + t2214 - t2221 - t2224 - t2227 - t2231 - t2187 - t2237;
  t3231 = t3211 + t3216 + t3227 + t3229;
  t3232 = t156 * t3231;
  t3234 = t2429 * t3175 * t50;
  t3235 = t2428 * t3234;
  t3236 = 0.1e5 / 0.729e3 * t3235;
  t3237 = t1102 * t382;
  t3238 = 0.3e1 * t3237;
  t3239 = t983 * t336;
  t3240 = t2296 * t3239;
  t3242 = 0.1e2 / 0.27e2 * t7 * t3240;
  t3243 = t823 * t987;
  t3245 = 0.1e2 / 0.3e1 * t7 * t3243;
  t3246 = 0.3e1 * t3187;
  t3247 = t15 * t3246;
  t3249 = 0.5e1 / 0.3e1 * t7 * t3247;
  t3250 = t340 * t340;
  t3252 = 0.1e1 / t19 / t3250;
  t3253 = tau[1] * t3252;
  t3255 = 0.44e3 / 0.27e2 * t3253 * t27;
  t3257 = 0.2e3 / 0.9e1 * t994 * t347;
  t3259 = 0.5e2 / 0.9e1 * t343 * t1000;
  t3261 = 0.25e2 / 0.3e1 * t343 * t1004;
  t3262 = t999 * t346;
  t3263 = t2310 * t3262;
  t3265 = 0.1e2 / 0.27e2 * t22 * t3263;
  t3266 = t833 * t1003;
  t3268 = 0.1e2 / 0.3e1 * t22 * t3266;
  t3269 = -t3246;
  t3270 = t26 * t3269;
  t3272 = 0.5e1 / 0.3e1 * t22 * t3270;
  t3273 = -t3242 + t3245 + t3249 - t3255 + t3257 - t3259 - t3261 - t3265 + t3268 + t3272 + t2338;
  t3274 = t2 * t3273;
  t3276 = t3274 * t40 * t153;
  t3283 = t2356 * t3175 * t50;
  t3286 = t350 * t1007;
  t3287 = t806 * t3286;
  t3290 = params->c * t3273;
  t3291 = t325 * t3290;
  t3294 = -0.5e1 / 0.9e1 * t3276 + 0.1e3 / 0.27e2 * t3081 * t391 - 0.2e4 / 0.81e2 * t3176 * t2349 + 0.1e5 / 0.729e3 * t2355 * t3283 - 0.2e4 / 0.81e2 * t805 * t3287 + 0.5e2 / 0.81e2 * t324 * t3291;
  t3295 = t3294 * t146;
  t3296 = t365 * t1021;
  t3297 = t543 * t3296;
  t3298 = 0.2e4 / 0.81e2 * t3297;
  t3299 = t383 * t1021;
  t3300 = t543 * t3299;
  t3301 = 0.2e4 / 0.81e2 * t3300;
  t3302 = t352 * t1048;
  t3303 = 0.5e1 / 0.3e1 * t3302;
  t3304 = t352 * t1052;
  t3305 = 0.1e2 / 0.3e1 * t3304;
  t3306 = t352 * t1086;
  t3307 = 0.5e1 / 0.3e1 * t3306;
  t3308 = t3274 * t45;
  t3309 = t3308 * t148;
  t3310 = 0.5e1 / 0.9e1 * t3309;
  t3311 = t1009 * t366;
  t3312 = 0.5e1 / 0.3e1 * t3311;
  t3313 = t1009 * t384;
  t3314 = 0.5e1 / 0.3e1 * t3313;
  t3315 = t3179 + t3181 + t3232 - t3236 + t3238 + t3295 + t3298 + t3301 + t3303 + t3305 + t3307 + t3310 + t3312 + t3314;
  t3317 = t55 * t66 * t3231;
  t3318 = t46 * t3317;
  t3319 = 0.5e1 / 0.9e1 * t3318;
  t3324 = t1037 * t360;
  t3325 = t2264 * t3324;
  t3329 = t879 * t1042;
  t3334 = -t3242 + t3245 + t3249 - t3255 + t3257 - t3259 - t3261 - t3265 + t3268 + t3272;
  t3335 = t207 * t3334;
  t3338 = t2249 + 0.119e3 / 0.12e2 * t2614 + t2253 + 0.7e1 / 0.2e1 * t2944 + 0.7e1 * t2619 - 0.7e1 / 0.4e1 * t2957 + t2261 + 0.3e1 / 0.4e1 * t59 * t3325 + 0.3e1 / 0.2e1 * t2951 - 0.3e1 / 0.4e1 * t878 * t3329 + 0.3e1 / 0.4e1 * t2635 - 0.3e1 / 0.4e1 * t2964 + t59 * t3335 / 0.8e1;
  t3340 = t55 * t3338 * t146;
  t3341 = t46 * t3340;
  t3342 = 0.5e1 / 0.9e1 * t3341;
  t3344 = t55 * t1046 * t382;
  t3345 = t46 * t3344;
  t3346 = 0.5e1 / 0.3e1 * t3345;
  t3348 = t55 * t364 * t1084;
  t3349 = t46 * t3348;
  t3350 = 0.5e1 / 0.3e1 * t3349;
  t3351 = t2933 * t356;
  t3352 = 0.1e3 / 0.27e2 * t3351;
  t3353 = t902 * t1007;
  t3354 = t193 * t3353;
  t3355 = t190 * t3354;
  t3356 = 0.5e2 / 0.27e2 * t3355;
  t3357 = t194 * t3273;
  t3358 = t193 * t3357;
  t3359 = t190 * t3358;
  t3360 = 0.5e2 / 0.81e2 * t3359;
  t3362 = t190 * t871 * t1028;
  t3363 = 0.1e3 / 0.27e2 * t3362;
  t3364 = t871 * t1032;
  t3365 = t190 * t3364;
  t3366 = 0.5e2 / 0.27e2 * t3365;
  t3367 = t3136 * t350;
  t3369 = t190 * t193 * t3367;
  t3370 = 0.5e2 / 0.27e2 * t3369;
  t3372 = t190 * t3149 * t355;
  t3373 = 0.5e2 / 0.27e2 * t3372;
  t3374 = t853 * t1007;
  t3375 = t147 * t3374;
  t3376 = t543 * t3375;
  t3377 = 0.2e4 / 0.81e2 * t3376;
  t3378 = t1014 * t2479;
  t3379 = 0.1e3 / 0.27e2 * t3378;
  t3380 = t1014 * t2463;
  t3381 = 0.1e3 / 0.27e2 * t3380;
  t3382 = t3319 + t3342 + t3346 + t3350 - t3352 - t3356 - t3360 - t3363 - t3366 - t3370 - t3373 + t3377 - t3379 - t3381;
  tv3rho33 = t9 * (t3315 + t3382) + 0.3e1 * t1106 + 0.3e1 * t1103 + 0.6e1 * t1104 + 0.5e1 / 0.3e1 * t1087 + 0.5e1 / 0.3e1 * t1010 + 0.1e2 / 0.3e1 * t1017 + 0.1e2 / 0.3e1 * t1019 + 0.2e4 / 0.81e2 * t1023 + 0.5e1 / 0.3e1 * t1049 + 0.1e2 / 0.3e1 * t1053 - 0.1e3 / 0.27e2 * t1015 - 0.1e3 / 0.27e2 * t1026 - 0.1e3 / 0.27e2 * t1030 - 0.5e2 / 0.27e2 * t1034;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t3399 = t399 * t542;
  t3400 = t3399 * t546;
  t3401 = 0.25e3 / 0.81e2 * t3400;
  t3402 = t400 * t591;
  t3403 = 0.5e1 / 0.72e2 * t3402;
  t3404 = t400 * t595;
  t3405 = 0.5e1 / 0.36e2 * t3404;
  t3406 = t1142 * t146;
  t3407 = t55 * t3406;
  t3408 = t46 * t3407;
  t3409 = 0.5e1 / 0.36e2 * t3408;
  t3410 = t544 * t177;
  t3411 = t3410 * t180;
  t3412 = t147 * t3411;
  t3413 = t543 * t3412;
  t3414 = 0.4e4 / 0.729e3 * t3413;
  t3415 = t400 * t793;
  t3416 = 0.5e1 / 0.72e2 * t3415;
  t3417 = t1110 * t218;
  t3418 = 0.1e2 / 0.27e2 * t3417;
  t3419 = t1110 * t318;
  t3420 = 0.1e2 / 0.27e2 * t3419;
  t3421 = t2 * t58;
  t3422 = t3421 * t45;
  t3423 = t3422 * t148;
  t3424 = 0.55e2 / 0.81e2 * t3423;
  t3425 = t1143 * t558;
  t3426 = t1141 * t3425;
  t3427 = 0.25e2 / 0.324e3 * t3426;
  t3428 = t2356 * t35;
  t3430 = t3428 * t527 * t50;
  t3431 = t2814 * t3430;
  t3432 = 0.125e4 / 0.729e3 * t3431;
  t3433 = t1143 * t554;
  t3434 = t1141 * t3433;
  t3435 = 0.25e2 / 0.162e3 * t3434;
  t3436 = -t3401 - t3403 - t3405 - t3409 + t3414 - t3416 + t3418 + t3420 - t3424 + t3427 + t3432 + t3435;
  t3437 = t201 * t61;
  t3438 = t3437 * t62;
  t3440 = t1141 * t3438 * t195;
  t3441 = 0.175e3 / 0.243e3 * t3440;
  t3442 = t1142 * t8;
  t3444 = t1141 * t3442 * t195;
  t3445 = 0.25e2 / 0.81e2 * t3444;
  t3446 = t1147 * t1161;
  t3447 = t407 * t3446;
  t3448 = 0.35e2 / 0.54e2 * t3447;
  t3449 = t213 * t316;
  t3450 = t408 * t3449;
  t3451 = t407 * t3450;
  t3452 = 0.5e1 / 0.18e2 * t3451;
  t3453 = t63 * t791;
  t3454 = t408 * t3453;
  t3455 = t407 * t3454;
  t3456 = 0.5e1 / 0.72e2 * t3455;
  t3457 = t523 * t50;
  t3458 = t3457 * t410;
  t3459 = 0.5e1 / 0.72e2 * t3458;
  t3460 = t1136 * t1162;
  t3461 = 0.5e1 / 0.36e2 * t3460;
  t3462 = t542 * t58;
  t3463 = t39 * t3462;
  t3464 = t1295 * t527;
  t3465 = t63 * t3464;
  t3466 = t3463 * t3465;
  t3467 = 0.25e3 / 0.243e3 * t3466;
  t3468 = t2409 * t403;
  t3469 = t190 * t3468;
  t3470 = 0.25e2 / 0.324e3 * t3469;
  t3471 = t549 * t1128;
  t3472 = t190 * t3471;
  t3473 = 0.25e2 / 0.162e3 * t3472;
  t3474 = t1147 * t206;
  t3475 = t3474 * t1153;
  t3476 = t407 * t3475;
  t3477 = 0.35e2 / 0.54e2 * t3476;
  t3478 = t408 * t573;
  t3479 = t1152 * t575;
  t3480 = t3478 * t3479;
  t3481 = t407 * t3480;
  t3482 = 0.5e1 / 0.36e2 * t3481;
  t3483 = -t3441 + t3445 + t3448 - t3452 - t3456 - t3459 - t3461 - t3467 + t3470 + t3473 - t3477 - t3482;
  t3485 = t8 * t146;
  t3486 = t3485 * t209;
  t3487 = t1151 * t3486;
  t3488 = t407 * t3487;
  t3489 = 0.5e1 / 0.18e2 * t3488;
  t3490 = t62 * t316;
  t3491 = t3490 * t209;
  t3492 = t1151 * t3491;
  t3493 = t407 * t3492;
  t3494 = 0.5e1 / 0.36e2 * t3493;
  t3495 = t1152 * t583;
  t3496 = t1151 * t3495;
  t3497 = t407 * t3496;
  t3498 = 0.5e1 / 0.72e2 * t3497;
  t3499 = t1136 * t1154;
  t3500 = 0.5e1 / 0.36e2 * t3499;
  t3501 = t528 * t189;
  t3502 = t192 * t58;
  t3503 = t3502 * t61;
  t3504 = t3503 * t1651;
  t3505 = t3501 * t3504;
  t3506 = 0.25e2 / 0.162e3 * t3505;
  t3507 = t180 * t209;
  t3508 = t194 * t3507;
  t3509 = t1354 * t3508;
  t3510 = t1141 * t3509;
  t3511 = 0.25e2 / 0.162e3 * t3510;
  t3512 = t217 * t1121;
  t3513 = t543 * t3512;
  t3514 = 0.5e3 / 0.243e3 * t3513;
  t3515 = t317 * t1121;
  t3516 = t543 * t3515;
  t3517 = 0.5e3 / 0.243e3 * t3516;
  t3518 = t1120 * t522;
  t3519 = t147 * t3518;
  t3520 = t543 * t3519;
  t3521 = 0.25e3 / 0.243e3 * t3520;
  t3522 = t1179 * t316;
  t3523 = 0.2e1 * t3522;
  t3525 = t3421 * t40 * t153;
  t3526 = 0.55e2 / 0.81e2 * t3525;
  t3527 = t1109 * t188;
  t3528 = t3527 * t327;
  t3529 = 0.2e3 / 0.243e3 * t3528;
  t3530 = t399 * t539;
  t3531 = t3530 * t807;
  t3533 = t1168 * t811;
  t3537 = t2785 * t35 * t527 * t50;
  t3540 = t806 * t177 * t180;
  t3541 = t805 * t3540;
  t3542 = 0.4e4 / 0.729e3 * t3541;
  t3544 = t806 * t35 * t522;
  t3545 = t805 * t3544;
  t3549 = t324 * t325 * params->c * t58;
  t3550 = 0.55e3 / 0.729e3 * t3549;
  t3551 = t3526 + t3529 + 0.25e3 / 0.81e2 * t3531 - 0.25e2 / 0.162e3 * t3533 - 0.125e4 / 0.729e3 * t3537 - t3542 + 0.25e3 / 0.243e3 * t3545 - t3550;
  t3552 = t3551 * t146;
  t3553 = t420 * t791;
  t3554 = t3489 + t3494 + t3498 + t3500 + t3506 - t3511 - t3514 - t3517 - t3521 + t3523 + t3552 + t3553;
  t3555 = t2419 * t35;
  t3556 = t193 * t3555;
  t3557 = t190 * t3556;
  t3558 = 0.25e2 / 0.324e3 * t3557;
  t3559 = t1113 * t550;
  t3560 = 0.25e2 / 0.81e2 * t3559;
  t3561 = t1113 * t555;
  t3562 = 0.25e2 / 0.81e2 * t3561;
  t3563 = t1113 * t559;
  t3564 = 0.25e2 / 0.162e3 * t3563;
  t3565 = t1109 * t189;
  t3566 = t3565 * t196;
  t3567 = 0.2e3 / 0.243e3 * t3566;
  t3568 = t1147 * t1157;
  t3569 = t407 * t3568;
  t3570 = 0.35e2 / 0.27e2 * t3569;
  t3571 = t194 * t58;
  t3573 = t190 * t193 * t3571;
  t3574 = 0.55e3 / 0.729e3 * t3573;
  t3575 = t1136 * t1148;
  t3576 = 0.35e2 / 0.54e2 * t3575;
  t3577 = t1136 * t1158;
  t3578 = 0.5e1 / 0.18e2 * t3577;
  t3579 = t54 * t564;
  t3580 = t3579 * t409;
  t3581 = t407 * t3580;
  t3582 = 0.595e3 / 0.324e3 * t3581;
  t3584 = t190 * t549 * t1132;
  t3585 = 0.1e3 / 0.243e3 * t3584;
  t3586 = t553 * t177;
  t3588 = t190 * t193 * t3586;
  t3589 = 0.1e3 / 0.243e3 * t3588;
  t3590 = t3558 + t3560 + t3562 + t3564 - t3567 + t3570 + t3574 + t3576 - t3578 - t3582 - t3585 - t3589;
  tv3rho2sigma0 = t9 * (t3436 + t3483 + t3554 + t3590) + 0.2e1 * t1180 + 0.2e1 * t1181 - t1191 + t1194 + t1195 - t1196 + t1193 - t1186 - t1187 - t1188 + t1184 + t1185 + t1189 + t1190 - t1192 - t1197;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t3596 = 0.5e3 / 0.81e2 * t3400;
  t3597 = 0.5e1 / 0.36e2 * t3402;
  t3598 = 0.5e1 / 0.18e2 * t3404;
  t3599 = 0.5e1 / 0.18e2 * t3408;
  t3600 = 0.8e4 / 0.729e3 * t3413;
  t3601 = 0.5e1 / 0.36e2 * t3415;
  t3602 = 0.2e2 / 0.27e2 * t3417;
  t3603 = 0.2e2 / 0.27e2 * t3419;
  t3604 = 0.11e3 / 0.81e2 * t3423;
  t3605 = 0.25e2 / 0.162e3 * t3426;
  t3606 = 0.25e4 / 0.729e3 * t3431;
  t3607 = 0.25e2 / 0.81e2 * t3434;
  t3608 = -t3596 - t3597 - t3598 - t3599 + t3600 - t3601 + t3602 + t3603 - t3604 + t3605 + t3606 + t3607;
  t3609 = 0.35e3 / 0.243e3 * t3440;
  t3610 = 0.5e2 / 0.81e2 * t3444;
  t3611 = t1202 * t316;
  t3612 = 0.2e1 * t3611;
  t3613 = 0.11e3 / 0.81e2 * t3525;
  t3620 = 0.11e4 / 0.729e3 * t3549;
  t3621 = t3613 + 0.4e3 / 0.243e3 * t3528 + 0.5e3 / 0.81e2 * t3531 - 0.25e2 / 0.81e2 * t3533 - 0.25e4 / 0.729e3 * t3537 - 0.8e4 / 0.729e3 * t3541 + 0.5e3 / 0.243e3 * t3545 - t3620;
  t3622 = t3621 * t146;
  t3623 = 0.35e2 / 0.27e2 * t3447;
  t3624 = 0.5e1 / 0.9e1 * t3451;
  t3625 = 0.5e1 / 0.36e2 * t3455;
  t3626 = 0.5e1 / 0.36e2 * t3458;
  t3627 = 0.5e1 / 0.18e2 * t3460;
  t3628 = 0.5e3 / 0.243e3 * t3466;
  t3629 = 0.25e2 / 0.162e3 * t3469;
  t3630 = 0.25e2 / 0.81e2 * t3472;
  t3631 = -t3609 + t3610 + t3612 + t3622 + t3623 - t3624 - t3625 - t3626 - t3627 - t3628 + t3629 + t3630;
  t3633 = t428 * t791;
  t3634 = 0.35e2 / 0.27e2 * t3476;
  t3635 = 0.5e1 / 0.18e2 * t3481;
  t3636 = 0.5e1 / 0.9e1 * t3488;
  t3637 = 0.5e1 / 0.18e2 * t3493;
  t3638 = 0.5e1 / 0.36e2 * t3497;
  t3639 = 0.5e1 / 0.18e2 * t3499;
  t3640 = 0.25e2 / 0.81e2 * t3505;
  t3641 = 0.25e2 / 0.81e2 * t3510;
  t3642 = 0.1e4 / 0.243e3 * t3513;
  t3643 = 0.1e4 / 0.243e3 * t3516;
  t3644 = 0.5e3 / 0.243e3 * t3520;
  t3645 = t3633 - t3634 - t3635 + t3636 + t3637 + t3638 + t3639 + t3640 - t3641 - t3642 - t3643 - t3644;
  t3646 = 0.25e2 / 0.162e3 * t3557;
  t3647 = 0.5e2 / 0.81e2 * t3559;
  t3648 = 0.5e2 / 0.81e2 * t3561;
  t3649 = 0.25e2 / 0.81e2 * t3563;
  t3650 = 0.4e3 / 0.243e3 * t3566;
  t3651 = 0.7e2 / 0.27e2 * t3569;
  t3652 = 0.11e4 / 0.729e3 * t3573;
  t3653 = 0.35e2 / 0.27e2 * t3575;
  t3654 = 0.5e1 / 0.9e1 * t3577;
  t3655 = 0.595e3 / 0.162e3 * t3581;
  t3656 = 0.2e3 / 0.243e3 * t3584;
  t3657 = 0.2e3 / 0.243e3 * t3588;
  t3658 = t3646 + t3647 + t3648 + t3649 - t3650 + t3651 + t3652 + t3653 - t3654 - t3655 - t3656 - t3657;
  t3664 = 0.2e3 / 0.243e3 * t1134;
  t3665 = 0.35e2 / 0.27e2 * t1149;
  t3667 = 0.5e1 / 0.9e1 * t1159;
  t3672 = 0.2e2 / 0.27e2 * t1111;
  tv3rho2sigma1 = t9 * (t3608 + t3631 + t3645 + t3658) + 0.2e1 * t1204 + 0.2e1 * t1203 - t3664 + t3665 + 0.5e1 / 0.18e2 * t1155 - t3667 + 0.25e2 / 0.81e2 * t1145 - 0.5e1 / 0.18e2 * t1116 - 0.5e1 / 0.18e2 * t1118 - 0.1e4 / 0.243e3 * t1123 + t3672 + 0.5e2 / 0.81e2 * t1114 + 0.25e2 / 0.81e2 * t1126 + 0.25e2 / 0.81e2 * t1130 - 0.5e1 / 0.18e2 * t1137 - 0.5e1 / 0.18e2 * t1163;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t3678 = t1179 * t382;
  t3680 = t217 * t1213;
  t3681 = t543 * t3680;
  t3683 = t317 * t1213;
  t3684 = t543 * t3683;
  t3686 = t1120 * t841;
  t3687 = t147 * t3686;
  t3688 = t543 * t3687;
  t3690 = t365 * t1121;
  t3691 = t543 * t3690;
  t3693 = t383 * t1121;
  t3694 = t543 * t3693;
  t3696 = t3399 * t855;
  t3698 = t1147 * t1234;
  t3699 = t407 * t3698;
  t3701 = t213 * t382;
  t3702 = t408 * t3701;
  t3703 = t407 * t3702;
  t3705 = t1224 * t1148;
  t3707 = t1224 * t1158;
  t3709 = t1113 * t904;
  t3711 = t2549 * t403;
  t3712 = t190 * t3711;
  t3714 = t1113 * t858;
  t3716 = t1113 * t862;
  t3718 = t1113 * t866;
  t3720 = t3678 + t3409 + 0.2e4 / 0.729e3 * t3413 - 0.25e3 / 0.243e3 * t3681 - 0.25e3 / 0.243e3 * t3684 - 0.25e3 / 0.243e3 * t3688 - 0.25e3 / 0.243e3 * t3691 - 0.25e3 / 0.243e3 * t3694 - 0.25e3 / 0.81e2 * t3696 + 0.35e2 / 0.108e3 * t3699 - 0.5e1 / 0.36e2 * t3703 + 0.35e2 / 0.108e3 * t3705 - 0.5e1 / 0.36e2 * t3707 + 0.25e2 / 0.162e3 * t3709 + 0.25e2 / 0.324e3 * t3712 + 0.25e2 / 0.162e3 * t3714 + 0.25e2 / 0.162e3 * t3716 + 0.25e2 / 0.162e3 * t3718;
  t3721 = t1113 * t872;
  t3723 = t3565 * t356;
  t3726 = t190 * t871 * t1132;
  t3728 = t902 * t177;
  t3730 = t190 * t193 * t3728;
  t3732 = t1136 * t1235;
  t3734 = t63 * t951;
  t3735 = t408 * t3734;
  t3736 = t407 * t3735;
  t3738 = t871 * t1128;
  t3739 = t190 * t3738;
  t3741 = t549 * t1220;
  t3742 = t190 * t3741;
  t3744 = t2485 * t35;
  t3745 = t193 * t3744;
  t3746 = t190 * t3745;
  t3748 = t842 * t50;
  t3749 = t3748 * t410;
  t3751 = t1224 * t1162;
  t3755 = t351 * t185;
  t3756 = t3755 * t1140;
  t3757 = t3756 * t1144;
  t3760 = t1141 * t1143 * t861;
  t3762 = t1143 * t865;
  t3763 = t1141 * t3762;
  t3765 = t1514 * t209;
  t3766 = t1338 * t3765;
  t3767 = t154 * t3766;
  t3769 = 0.25e2 / 0.162e3 * t3721 - 0.1e3 / 0.243e3 * t3723 - 0.5e2 / 0.243e3 * t3726 - 0.5e2 / 0.243e3 * t3730 - 0.5e1 / 0.72e2 * t3732 - 0.5e1 / 0.72e2 * t3736 + 0.25e2 / 0.324e3 * t3739 + 0.25e2 / 0.324e3 * t3742 + 0.25e2 / 0.324e3 * t3746 - 0.5e1 / 0.72e2 * t3749 - 0.5e1 / 0.72e2 * t3751 + 0.5e1 / 0.27e2 * t3417 + 0.5e1 / 0.27e2 * t3419 - t3424 + 0.25e2 / 0.162e3 * t3757 + 0.25e2 / 0.324e3 * t3760 + 0.25e2 / 0.324e3 * t3763 - 0.5e1 / 0.36e2 * t3767;
  t3771 = t1143 * t903;
  t3772 = t1141 * t3771;
  t3774 = t3438 * t355;
  t3775 = t1141 * t3774;
  t3777 = t3442 * t355;
  t3778 = t1141 * t3777;
  t3782 = t420 * t951;
  t3787 = t3474 * t1230;
  t3788 = t407 * t3787;
  t3790 = t3485 * t360;
  t3791 = t1151 * t3790;
  t3792 = t407 * t3791;
  t3794 = t62 * t382;
  t3795 = t3794 * t209;
  t3796 = t1151 * t3795;
  t3797 = t407 * t3796;
  t3799 = t1224 * t1154;
  t3801 = t409 * t854;
  t3802 = t3463 * t3801;
  t3804 = t1136 * t1231;
  t3806 = t3490 * t360;
  t3807 = t1151 * t3806;
  t3808 = t407 * t3807;
  t3810 = t1152 * t886;
  t3811 = t1151 * t3810;
  t3812 = t407 * t3811;
  t3814 = 0.25e2 / 0.324e3 * t3772 - 0.175e3 / 0.486e3 * t3775 + 0.25e2 / 0.162e3 * t3778 - 0.175e3 / 0.486e3 * t3440 - 0.25e2 / 0.162e3 * t3444 + t3782 + 0.35e2 / 0.108e3 * t3447 + 0.5e1 / 0.36e2 * t3451 - 0.35e2 / 0.108e3 * t3476 - 0.5e1 / 0.36e2 * t3488 - 0.35e2 / 0.108e3 * t3788 + 0.5e1 / 0.36e2 * t3792 + 0.5e1 / 0.72e2 * t3797 + 0.5e1 / 0.72e2 * t3799 - 0.25e3 / 0.243e3 * t3802 + 0.5e1 / 0.72e2 * t3804 + 0.5e1 / 0.72e2 * t3808 + 0.5e1 / 0.72e2 * t3812;
  t3815 = t1244 * t316;
  t3817 = t3527 * t391;
  t3819 = t3530 * t963;
  t3821 = t1168 * t967;
  t3824 = t1240 * t180 * t50;
  t3825 = t2785 * t3824;
  t3827 = t177 * t350;
  t3828 = t806 * t3827;
  t3829 = t805 * t3828;
  t3831 = t35 * t841;
  t3832 = t806 * t3831;
  t3833 = t805 * t3832;
  t3836 = t3526 + 0.1e3 / 0.243e3 * t3528 + 0.1e3 / 0.243e3 * t3817 + 0.25e3 / 0.81e2 * t3819 - 0.25e2 / 0.162e3 * t3821 - 0.125e4 / 0.729e3 * t3825 - 0.2e4 / 0.729e3 * t3829 + 0.25e3 / 0.243e3 * t3833 - 0.2e4 / 0.729e3 * t3541 - t3550;
  t3837 = t3836 * t146;
  t3838 = t1110 * t366;
  t3840 = t1110 * t384;
  t3842 = t400 * t893;
  t3844 = t400 * t897;
  t3846 = t400 * t908;
  t3853 = t3410 * t350;
  t3854 = t147 * t3853;
  t3855 = t543 * t3854;
  t3857 = t1514 * t326;
  t3858 = t1354 * t3857;
  t3859 = t1141 * t3858;
  t3861 = t3428 * t350;
  t3863 = t180 * t40 * t152;
  t3864 = t3861 * t3863;
  t3865 = t2814 * t3864;
  t3867 = t350 * t209;
  t3868 = t194 * t3867;
  t3869 = t1354 * t3868;
  t3870 = t1141 * t3869;
  t3872 = t400 * t953;
  t3874 = t3815 + t3837 + 0.5e1 / 0.27e2 * t3838 + 0.5e1 / 0.27e2 * t3840 - 0.5e1 / 0.72e2 * t3842 - 0.5e1 / 0.72e2 * t3844 - 0.5e1 / 0.72e2 * t3846 - 0.1e3 / 0.243e3 * t3566 + t3574 + 0.35e2 / 0.108e3 * t3575 + 0.5e1 / 0.36e2 * t3577 - t3582 - 0.5e2 / 0.243e3 * t3584 - 0.5e2 / 0.243e3 * t3588 + 0.2e4 / 0.729e3 * t3855 - 0.25e2 / 0.324e3 * t3859 + 0.125e4 / 0.729e3 * t3865 - 0.25e2 / 0.324e3 * t3870 - 0.5e1 / 0.72e2 * t3872;
  t3878 = t1208 + t1219 + t1223 - t1226 - t1237 - t1164 + t1115 + t1127 + t1131 - t1191 - t1138 + t1194 + t9 * (t3720 + t3769 + t3814 + t3874) + t1180;
  t3879 = t1181 - t1216 - t1124 - t1210 - t1212 + t1184 - t1117 - t1119 + t1233 + t1156 + t1246 + t1245 + t1229 + t1146;
  tv3rho2sigma3 = t3878 + t3879;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t3880 = t1249 + t1253 + t1254 - t1255 - t1258 - t1197 + t1185 + t1189 + t1190 - t3664 - t1192 + t3665 - t1252 - t1188;
  t3881 = 0.5e3 / 0.243e3 * t3681;
  t3882 = 0.5e3 / 0.243e3 * t3684;
  t3883 = 0.5e3 / 0.243e3 * t3688;
  t3884 = 0.5e3 / 0.243e3 * t3691;
  t3885 = 0.5e3 / 0.243e3 * t3694;
  t3886 = 0.5e3 / 0.81e2 * t3696;
  t3887 = 0.35e2 / 0.54e2 * t3699;
  t3888 = 0.5e1 / 0.18e2 * t3703;
  t3889 = 0.35e2 / 0.54e2 * t3705;
  t3890 = 0.5e1 / 0.18e2 * t3707;
  t3891 = 0.25e2 / 0.81e2 * t3709;
  t3892 = 0.25e2 / 0.162e3 * t3712;
  t3893 = 0.25e2 / 0.81e2 * t3714;
  t3894 = 0.25e2 / 0.81e2 * t3716;
  t3895 = 0.25e2 / 0.81e2 * t3718;
  t3896 = 0.25e2 / 0.81e2 * t3721;
  t3897 = t3599 + t3414 - t3881 - t3882 - t3883 - t3884 - t3885 - t3886 + t3887 - t3888 + t3889 - t3890 + t3891 + t3892 + t3893 + t3894 + t3895 + t3896;
  t3898 = 0.2e3 / 0.243e3 * t3723;
  t3899 = 0.1e3 / 0.243e3 * t3726;
  t3900 = 0.1e3 / 0.243e3 * t3730;
  t3901 = 0.5e1 / 0.36e2 * t3732;
  t3902 = 0.5e1 / 0.36e2 * t3736;
  t3903 = 0.25e2 / 0.162e3 * t3739;
  t3904 = 0.25e2 / 0.162e3 * t3742;
  t3905 = 0.25e2 / 0.162e3 * t3746;
  t3906 = 0.5e1 / 0.36e2 * t3749;
  t3907 = 0.5e1 / 0.36e2 * t3751;
  t3908 = 0.25e2 / 0.81e2 * t3757;
  t3909 = 0.25e2 / 0.162e3 * t3760;
  t3910 = 0.25e2 / 0.162e3 * t3763;
  t3911 = 0.5e1 / 0.18e2 * t3767;
  t3912 = 0.25e2 / 0.162e3 * t3772;
  t3913 = -t3898 - t3899 - t3900 - t3901 - t3902 + t3903 + t3904 + t3905 - t3906 - t3907 + t3418 + t3420 - t3604 + t3908 + t3909 + t3910 - t3911 + t3912;
  t3915 = 0.175e3 / 0.243e3 * t3775;
  t3916 = 0.25e2 / 0.81e2 * t3778;
  t3917 = t1261 * t316;
  t3918 = 0.2e3 / 0.243e3 * t3817;
  t3922 = 0.4e4 / 0.729e3 * t3829;
  t3924 = t3613 + t3529 + t3918 + 0.5e3 / 0.81e2 * t3819 - 0.25e2 / 0.81e2 * t3821 - 0.25e4 / 0.729e3 * t3825 - t3922 + 0.5e3 / 0.243e3 * t3833 - t3542 - t3620;
  t3925 = t3924 * t146;
  t3926 = 0.35e2 / 0.54e2 * t3788;
  t3927 = 0.5e1 / 0.18e2 * t3792;
  t3928 = 0.5e1 / 0.36e2 * t3797;
  t3929 = 0.5e1 / 0.36e2 * t3799;
  t3930 = 0.5e3 / 0.243e3 * t3802;
  t3931 = 0.5e1 / 0.36e2 * t3804;
  t3932 = 0.5e1 / 0.36e2 * t3808;
  t3933 = 0.5e1 / 0.36e2 * t3812;
  t3934 = -t3915 + t3916 - t3441 - t3445 + t3448 + t3452 + t3917 + t3925 - t3477 - t3489 - t3926 + t3927 + t3928 + t3929 - t3930 + t3931 + t3932 + t3933;
  t3935 = t428 * t951;
  t3936 = t1202 * t382;
  t3937 = 0.1e2 / 0.27e2 * t3838;
  t3938 = 0.1e2 / 0.27e2 * t3840;
  t3939 = 0.5e1 / 0.36e2 * t3842;
  t3940 = 0.5e1 / 0.36e2 * t3844;
  t3941 = 0.5e1 / 0.36e2 * t3846;
  t3942 = 0.4e4 / 0.729e3 * t3855;
  t3943 = 0.25e2 / 0.162e3 * t3859;
  t3944 = 0.25e4 / 0.729e3 * t3865;
  t3945 = 0.25e2 / 0.162e3 * t3870;
  t3946 = 0.5e1 / 0.36e2 * t3872;
  t3947 = t3935 + t3936 + t3937 + t3938 - t3939 - t3940 - t3941 - t3567 + t3652 + t3576 + t3578 - t3655 - t3585 - t3589 + t3942 - t3943 + t3944 - t3945 - t3946;
  t3951 = -t1250 - t1251 + t3672 - t1186 - t1187 + t1204 + t1257 + t1195 + t1256 + t1193 + t9 * (t3897 + t3913 + t3934 + t3947) + t1262 + t1263 + t1203;
  tv3rho2sigma4 = t3880 + t3951;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t3952 = t1152 * t1037;
  t3953 = t3478 * t3952;
  t3954 = t407 * t3953;
  t3955 = 0.5e1 / 0.36e2 * t3954;
  t3957 = t1141 * t1143 * t1032;
  t3958 = 0.25e2 / 0.324e3 * t3957;
  t3960 = t3428 * t1012 * t50;
  t3961 = t2814 * t3960;
  t3962 = 0.125e4 / 0.729e3 * t3961;
  t3964 = t1141 * t1143 * t1028;
  t3965 = 0.25e2 / 0.162e3 * t3964;
  t3966 = -t3409 - t3955 + t3958 + t3962 + t3965 + t3887 + t3888 + t3889 + t3890 - t3898 - t3899 - t3900;
  t3967 = t1224 * t1231;
  t3968 = 0.5e1 / 0.36e2 * t3967;
  t3969 = t1013 * t189;
  t3970 = t3969 * t3504;
  t3971 = 0.25e2 / 0.162e3 * t3970;
  t3972 = t3794 * t360;
  t3973 = t1151 * t3972;
  t3974 = t407 * t3973;
  t3975 = 0.5e1 / 0.36e2 * t3974;
  t3976 = t1152 * t1042;
  t3977 = t1151 * t3976;
  t3978 = t407 * t3977;
  t3979 = 0.5e1 / 0.72e2 * t3978;
  t3980 = t400 * t1086;
  t3981 = 0.5e1 / 0.72e2 * t3980;
  t3982 = t3399 * t1022;
  t3983 = 0.25e3 / 0.81e2 * t3982;
  t3984 = t400 * t1048;
  t3985 = 0.5e1 / 0.72e2 * t3984;
  t3986 = t400 * t1052;
  t3987 = 0.5e1 / 0.36e2 * t3986;
  t3988 = t383 * t1213;
  t3989 = t543 * t3988;
  t3990 = 0.5e3 / 0.243e3 * t3989;
  t3991 = t1120 * t1007;
  t3992 = t147 * t3991;
  t3993 = t543 * t3992;
  t3994 = 0.25e3 / 0.243e3 * t3993;
  t3995 = t365 * t1213;
  t3996 = t543 * t3995;
  t3997 = 0.5e3 / 0.243e3 * t3996;
  t3998 = t3968 + t3971 + t3975 + t3979 - t3981 - t3983 - t3985 - t3987 - t3424 - t3990 - t3994 - t3997;
  t4000 = t871 * t1220;
  t4001 = t190 * t4000;
  t4002 = 0.25e2 / 0.162e3 * t4001;
  t4003 = t3136 * t35;
  t4004 = t193 * t4003;
  t4005 = t190 * t4004;
  t4006 = 0.25e2 / 0.324e3 * t4005;
  t4007 = t1113 * t1025;
  t4008 = 0.25e2 / 0.81e2 * t4007;
  t4009 = t1113 * t1029;
  t4010 = 0.25e2 / 0.81e2 * t4009;
  t4011 = t1113 * t1033;
  t4012 = 0.25e2 / 0.162e3 * t4011;
  t4013 = t63 * t1084;
  t4014 = t408 * t4013;
  t4015 = t407 * t4014;
  t4016 = 0.5e1 / 0.72e2 * t4015;
  t4017 = t1008 * t50;
  t4018 = t4017 * t410;
  t4019 = 0.5e1 / 0.72e2 * t4018;
  t4020 = t1224 * t1235;
  t4021 = 0.5e1 / 0.36e2 * t4020;
  t4022 = t1295 * t1012;
  t4023 = t63 * t4022;
  t4024 = t3463 * t4023;
  t4025 = 0.25e3 / 0.243e3 * t4024;
  t4026 = t3149 * t403;
  t4027 = t190 * t4026;
  t4028 = 0.25e2 / 0.324e3 * t4027;
  t4029 = -t3915 - t3916 + t4002 + t4006 + t4008 + t4010 + t4012 - t4016 - t4019 - t4021 - t4025 + t4028;
  t4030 = t1244 * t382;
  t4031 = 0.2e1 * t4030;
  t4032 = t3530 * t1095;
  t4034 = t1168 * t1099;
  t4036 = t35 * t1012;
  t4038 = t2785 * t4036 * t50;
  t4040 = t35 * t1007;
  t4041 = t806 * t4040;
  t4042 = t805 * t4041;
  t4044 = t3526 + t3918 + 0.25e3 / 0.81e2 * t4032 - 0.25e2 / 0.162e3 * t4034 - 0.125e4 / 0.729e3 * t4038 - t3922 + 0.25e3 / 0.243e3 * t4042 - t3550;
  t4045 = t4044 * t146;
  t4046 = t350 * t360;
  t4047 = t194 * t4046;
  t4048 = t1354 * t4047;
  t4049 = t1141 * t4048;
  t4050 = 0.25e2 / 0.162e3 * t4049;
  t4051 = t420 * t1084;
  t4052 = t4031 + t4045 - t4050 - t3926 - t3927 + t4051 + t3937 + t3938 - t3570 + t3574 - t3582 + t3942;
  tv3rho2sigma6 = t9 * (t3966 + t3998 + t4029 + t4052) + 0.2e1 * t1245 + 0.2e1 * t1246 + t1257 - t1191 + t1194 + t1196 + t1256 - t1250 - t1251 - t1252 + t1184 + t1249 + t1253 + t1254 - t1255 - t1258;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  t4058 = t1261 * t382;
  t4059 = 0.2e1 * t4058;
  t4066 = t3613 + 0.4e3 / 0.243e3 * t3817 + 0.5e3 / 0.81e2 * t4032 - 0.25e2 / 0.81e2 * t4034 - 0.25e4 / 0.729e3 * t4038 - 0.8e4 / 0.729e3 * t3829 + 0.5e3 / 0.243e3 * t4042 - t3620;
  t4067 = t4066 * t146;
  t4068 = 0.5e1 / 0.18e2 * t3954;
  t4069 = 0.25e2 / 0.162e3 * t3957;
  t4070 = 0.25e4 / 0.729e3 * t3961;
  t4071 = 0.25e2 / 0.81e2 * t3964;
  t4072 = 0.35e2 / 0.27e2 * t3699;
  t4073 = 0.5e1 / 0.9e1 * t3703;
  t4074 = 0.35e2 / 0.27e2 * t3705;
  t4075 = 0.5e1 / 0.9e1 * t3707;
  t4076 = 0.4e3 / 0.243e3 * t3723;
  t4077 = -t3599 + t4059 + t4067 - t4068 + t4069 + t4070 + t4071 + t4072 + t4073 + t4074 + t4075 - t4076;
  t4078 = 0.2e3 / 0.243e3 * t3726;
  t4079 = 0.2e3 / 0.243e3 * t3730;
  t4080 = 0.5e1 / 0.18e2 * t3967;
  t4081 = 0.25e2 / 0.81e2 * t3970;
  t4082 = 0.5e1 / 0.18e2 * t3974;
  t4083 = 0.5e1 / 0.36e2 * t3978;
  t4084 = 0.5e1 / 0.36e2 * t3980;
  t4085 = 0.5e3 / 0.81e2 * t3982;
  t4086 = 0.5e1 / 0.36e2 * t3984;
  t4087 = 0.5e1 / 0.18e2 * t3986;
  t4088 = 0.1e4 / 0.243e3 * t3989;
  t4089 = -t4078 - t4079 + t4080 + t4081 + t4082 + t4083 - t4084 - t4085 - t4086 - t4087 - t3604 - t4088;
  t4091 = 0.5e3 / 0.243e3 * t3993;
  t4092 = 0.1e4 / 0.243e3 * t3996;
  t4093 = 0.35e3 / 0.243e3 * t3775;
  t4094 = 0.5e2 / 0.81e2 * t3778;
  t4095 = 0.25e2 / 0.81e2 * t4001;
  t4096 = 0.25e2 / 0.162e3 * t4005;
  t4097 = 0.5e2 / 0.81e2 * t4007;
  t4098 = 0.5e2 / 0.81e2 * t4009;
  t4099 = 0.25e2 / 0.81e2 * t4011;
  t4100 = 0.5e1 / 0.36e2 * t4015;
  t4101 = 0.5e1 / 0.36e2 * t4018;
  t4102 = 0.5e1 / 0.18e2 * t4020;
  t4103 = -t4091 - t4092 - t4093 - t4094 + t4095 + t4096 + t4097 + t4098 + t4099 - t4100 - t4101 - t4102;
  t4104 = 0.5e3 / 0.243e3 * t4024;
  t4105 = 0.25e2 / 0.162e3 * t4027;
  t4106 = 0.25e2 / 0.81e2 * t4049;
  t4107 = 0.35e2 / 0.27e2 * t3788;
  t4108 = 0.5e1 / 0.9e1 * t3792;
  t4109 = t428 * t1084;
  t4110 = 0.2e2 / 0.27e2 * t3838;
  t4111 = 0.2e2 / 0.27e2 * t3840;
  t4112 = 0.8e4 / 0.729e3 * t3855;
  t4113 = -t4104 + t4105 - t4106 - t4107 - t4108 + t4109 + t4110 + t4111 - t3651 + t3652 - t3655 + t4112;
  tv3rho2sigma7 = t9 * (t4077 + t4089 + t4103 + t4113) + 0.2e1 * t1262 + 0.2e1 * t1263 + 0.5e1 / 0.18e2 * t1232 - t3664 + t3665 + t3667 + 0.25e2 / 0.81e2 * t1228 - 0.5e1 / 0.18e2 * t1209 - 0.5e1 / 0.18e2 * t1211 - 0.1e4 / 0.243e3 * t1215 + t3672 + 0.5e2 / 0.81e2 * t1207 + 0.25e2 / 0.81e2 * t1218 + 0.25e2 / 0.81e2 * t1222 - 0.5e1 / 0.18e2 * t1225 - 0.5e1 / 0.18e2 * t1236;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t4129 = t160 * t16;
  t4130 = t4129 * t180;
  t4131 = t1295 * t4130;
  t4132 = t1294 * t4131;
  t4133 = 0.2e5 / 0.729e3 * t4132;
  t4134 = t501 * t40;
  t4135 = t4134 * t44;
  t4136 = t431 * t4135;
  t4138 = t55 * t147 * t502;
  t4139 = t4136 * t4138;
  t4140 = 0.5e2 / 0.81e2 * t4139;
  t4141 = t1266 * t1271;
  t4142 = t4141 * t1274;
  t4143 = 0.25e3 / 0.81e2 * t4142;
  t4145 = t55 * t217 * t167;
  t4146 = t1272 * t4145;
  t4147 = 0.5e2 / 0.27e2 * t4146;
  t4149 = t55 * t317 * t167;
  t4150 = t1272 * t4149;
  t4151 = 0.5e2 / 0.27e2 * t4150;
  t4153 = t55 * t147 * t508;
  t4154 = t1272 * t4153;
  t4155 = 0.25e2 / 0.27e2 * t4154;
  t4156 = t1301 * t1310;
  t4157 = t190 * t4156;
  t4158 = 0.5e3 / 0.243e3 * t4157;
  t4159 = t1305 * t1310;
  t4160 = t190 * t4159;
  t4161 = 0.5e3 / 0.243e3 * t4160;
  t4163 = params->c * t495 * t16;
  t4164 = t439 * t4163;
  t4165 = t190 * t4164;
  t4166 = 0.2e4 / 0.729e3 * t4165;
  t4167 = t1295 * t6;
  t4168 = t15 * t180;
  t4169 = t4168 * t167;
  t4170 = t4167 * t4169;
  t4171 = t1294 * t4170;
  t4172 = 0.2e5 / 0.729e3 * t4171;
  t4173 = t2409 * t146;
  t4174 = t4173 * t441;
  t4175 = t190 * t4174;
  t4176 = 0.5e2 / 0.81e2 * t4175;
  t4177 = t549 * t316;
  t4178 = t4177 * t441;
  t4179 = t190 * t4178;
  t4180 = 0.1e3 / 0.81e2 * t4179;
  t4181 = t193 * t791;
  t4182 = t4181 * t441;
  t4183 = t190 * t4182;
  t4184 = 0.5e2 / 0.81e2 * t4183;
  t4185 = t1266 * t1278;
  t4186 = t4185 * t1281;
  t4187 = 0.1e4 / 0.243e3 * t4186;
  t4188 = t325 * t216;
  t4189 = t4188 * t195;
  t4190 = t1279 * t4189;
  t4191 = 0.2e3 / 0.81e2 * t4190;
  t4192 = t1280 * t554;
  t4193 = t1279 * t4192;
  t4194 = 0.2e3 / 0.81e2 * t4193;
  t4195 = t1280 * t558;
  t4196 = t1279 * t4195;
  t4197 = 0.1e3 / 0.81e2 * t4196;
  t4199 = t152 * t1284 * t316;
  t4200 = t433 * t4199;
  t4201 = 0.1e2 / 0.9e1 * t4200;
  t4203 = t152 * t434 * t791;
  t4204 = t433 * t4203;
  t4205 = 0.5e1 / 0.9e1 * t4204;
  t4206 = -t4133 + t4140 - t4143 + t4147 + t4151 + t4155 + t4158 + t4161 - t4166 + t4172 - t4176 - t4180 - t4184 + t4187 - t4191 - t4194 - t4197 + t4201 + t4205;
  t4207 = t2 * t495;
  t4208 = t4207 * t432;
  t4209 = t4208 * t436;
  t4210 = 0.2e3 / 0.81e2 * t4209;
  t4211 = t1267 * t1286;
  t4212 = 0.5e2 / 0.27e2 * t4211;
  t4213 = t1267 * t1290;
  t4214 = 0.5e2 / 0.27e2 * t4213;
  t4215 = t16 * t539;
  t4216 = t431 * t4215;
  t4217 = t2372 * t3464;
  t4218 = t4216 * t4217;
  t4219 = 0.2e4 / 0.81e2 * t4218;
  t4220 = t54 * t589;
  t4222 = t152 * t4220 * t146;
  t4223 = t433 * t4222;
  t4224 = 0.5e1 / 0.9e1 * t4223;
  t4225 = t1337 * t446;
  t4226 = t15 * t146;
  t4227 = t209 * t167;
  t4228 = t4226 * t4227;
  t4229 = t4225 * t4228;
  t4230 = t1336 * t4229;
  t4231 = 0.25e2 / 0.54e2 * t4230;
  t4232 = t1360 * t326;
  t4233 = t1325 * t4232;
  t4234 = t1323 * t4233;
  t4235 = 0.25e2 / 0.162e3 * t4234;
  t4236 = t447 * t810;
  t4237 = t1325 * t4236;
  t4238 = t1323 * t4237;
  t4239 = 0.25e2 / 0.324e3 * t4238;
  t4240 = t321 * t1335;
  t4241 = t4240 * t1341;
  t4242 = 0.5e1 / 0.18e2 * t4241;
  t4243 = t4240 * t1357;
  t4244 = 0.25e2 / 0.108e3 * t4243;
  t4245 = t6 * t501;
  t4246 = t146 * t502;
  t4247 = t4245 * t4246;
  t4248 = t1354 * t4247;
  t4249 = t1336 * t4248;
  t4250 = 0.25e2 / 0.324e3 * t4249;
  t4251 = t58 * t2263;
  t4252 = t4251 * t62;
  t4253 = t146 * t575;
  t4254 = t1296 * t4253;
  t4255 = t4252 * t4254;
  t4256 = t1336 * t4255;
  t4257 = 0.5e1 / 0.12e2 * t4256;
  t4258 = t1337 * t8;
  t4259 = t4258 * t1340;
  t4260 = t1336 * t4259;
  t4261 = 0.5e1 / 0.9e1 * t4260;
  t4262 = t4129 * t1339;
  t4263 = t1338 * t4262;
  t4264 = t1336 * t4263;
  t4265 = 0.25e2 / 0.54e2 * t4264;
  t4266 = t8 * t160;
  t4267 = t4266 * t447;
  t4268 = t445 * t4267;
  t4269 = t154 * t4268;
  t4270 = 0.25e2 / 0.54e2 * t4269;
  t4271 = t62 * t495;
  t4272 = t4271 * t447;
  t4273 = t445 * t4272;
  t4274 = t154 * t4273;
  t4275 = 0.25e2 / 0.81e2 * t4274;
  t4276 = t565 * t206;
  t4277 = t4276 * t448;
  t4278 = t154 * t4277;
  t4279 = 0.595e3 / 0.324e3 * t4278;
  t4280 = t1330 * t1345;
  t4281 = t154 * t4280;
  t4282 = 0.35e2 / 0.27e2 * t4281;
  t4283 = t1330 * t1350;
  t4284 = t154 * t4283;
  t4285 = 0.175e3 / 0.162e3 * t4284;
  t4286 = t4210 - t4212 - t4214 + t4219 + t4224 - t4231 - t4235 - t4239 - t4242 + t4244 + t4250 + t4257 - t4261 + t4265 - t4270 + t4275 + t4279 - t4282 + t4285;
  t4288 = t322 * t1331;
  t4289 = 0.35e2 / 0.54e2 * t4288;
  t4290 = t322 * t1346;
  t4291 = 0.5e1 / 0.18e2 * t4290;
  t4292 = t322 * t1351;
  t4293 = 0.25e2 / 0.108e3 * t4292;
  t4294 = t1296 * t522;
  t4295 = t1295 * t4294;
  t4296 = t1294 * t4295;
  t4297 = 0.2e4 / 0.243e3 * t4296;
  t4298 = t542 * t216;
  t4299 = t39 * t4298;
  t4300 = t4299 * t1298;
  t4301 = 0.4e4 / 0.243e3 * t4300;
  t4302 = t316 * t544;
  t4303 = t4302 * t1297;
  t4304 = t1294 * t4303;
  t4305 = 0.4e4 / 0.243e3 * t4304;
  t4306 = t160 * t15;
  t4307 = t4306 * t167;
  t4308 = t530 * t4307;
  t4309 = t1141 * t4308;
  t4310 = 0.25e4 / 0.729e3 * t4309;
  t4311 = t431 * t15;
  t4312 = t4311 * t189;
  t4313 = t167 * params->c;
  t4314 = t4313 * t180;
  t4316 = t4312 * t439 * t4314;
  t4317 = 0.1e4 / 0.243e3 * t4316;
  t4318 = t445 * t1703;
  t4319 = t154 * t4318;
  t4320 = 0.5e1 / 0.36e2 * t4319;
  t4321 = t4245 * t502;
  t4323 = t1141 * t530 * t4321;
  t4324 = 0.5e3 / 0.729e3 * t4323;
  t4325 = t1314 * t508;
  t4326 = t530 * t4325;
  t4327 = t1141 * t4326;
  t4328 = 0.25e3 / 0.243e3 * t4327;
  t4329 = t1901 * t1315;
  t4330 = t1141 * t4329;
  t4331 = 0.5e3 / 0.243e3 * t4330;
  t4332 = t1905 * t1315;
  t4333 = t1141 * t4332;
  t4334 = 0.5e3 / 0.243e3 * t4333;
  t4335 = t316 * t167;
  t4336 = t1314 * t4335;
  t4337 = t1354 * t4336;
  t4338 = t1336 * t4337;
  t4339 = 0.25e2 / 0.108e3 * t4338;
  t4340 = t146 * t508;
  t4341 = t1314 * t4340;
  t4342 = t1354 * t4341;
  t4343 = t1336 * t4342;
  t4344 = 0.25e2 / 0.216e3 * t4343;
  t4345 = t1324 * t8;
  t4346 = t4345 * t1356;
  t4347 = t1336 * t4346;
  t4348 = 0.25e2 / 0.54e2 * t4347;
  t4349 = t4306 * t1355;
  t4350 = t1354 * t4349;
  t4351 = t1336 * t4350;
  t4352 = 0.125e3 / 0.324e3 * t4351;
  t4353 = t799 * t1322;
  t4354 = t1354 * t1695;
  t4355 = t4353 * t4354;
  t4356 = 0.25e2 / 0.162e3 * t4355;
  t4357 = t201 * t573;
  t4358 = t4357 * t62;
  t4359 = t4358 * t1340;
  t4360 = t1336 * t4359;
  t4361 = 0.35e2 / 0.27e2 * t4360;
  t4362 = -t4289 + t4291 - t4293 + t4297 + t4301 + t4305 + t4310 - t4317 + t4320 - t4324 - t4328 - t4331 - t4334 + t4339 + t4344 + t4348 - t4352 - t4356 + t4361;
  t4363 = t201 * t206;
  t4364 = t4363 * t62;
  t4365 = t4364 * t1356;
  t4366 = t1336 * t4365;
  t4367 = 0.175e3 / 0.162e3 * t4366;
  t4368 = t316 * t209;
  t4369 = t1296 * t4368;
  t4370 = t1338 * t4369;
  t4371 = t1336 * t4370;
  t4372 = 0.5e1 / 0.18e2 * t4371;
  t4373 = t146 * t583;
  t4374 = t1296 * t4373;
  t4375 = t1338 * t4374;
  t4376 = t1336 * t4375;
  t4377 = 0.5e1 / 0.36e2 * t4376;
  t4378 = t4363 * t446;
  t4379 = t4378 * t1326;
  t4380 = t1323 * t4379;
  t4381 = 0.175e3 / 0.243e3 * t4380;
  t4382 = t1324 * t1344;
  t4383 = t4382 * t1326;
  t4384 = t1323 * t4383;
  t4385 = 0.25e2 / 0.81e2 * t4384;
  t4386 = t1324 * t1349;
  t4387 = t4386 * t1326;
  t4388 = t1323 * t4387;
  t4389 = 0.125e3 / 0.486e3 * t4388;
  t4390 = t1344 * t1360;
  t4391 = t445 * t4390;
  t4392 = t154 * t4391;
  t4393 = 0.5e1 / 0.18e2 * t4392;
  t4394 = t1349 * t1360;
  t4395 = t445 * t4394;
  t4396 = t154 * t4395;
  t4397 = 0.25e2 / 0.108e3 * t4396;
  t4398 = t16 * t791;
  t4399 = t446 * t4398;
  t4400 = t445 * t4399;
  t4401 = t154 * t4400;
  t4402 = 0.5e1 / 0.72e2 * t4401;
  t4403 = t797 * t449;
  t4404 = 0.5e1 / 0.72e2 * t4403;
  t4405 = t322 * t1362;
  t4406 = 0.5e1 / 0.36e2 * t4405;
  t4407 = t541 * t30;
  t4408 = t4407 * t58;
  t4409 = t805 * t4408;
  t4410 = t207 * t6;
  t4411 = t447 * t545;
  t4412 = t4410 * t4411;
  t4413 = t4409 * t4412;
  t4414 = 0.25e3 / 0.243e3 * t4413;
  t4415 = t1330 * t1361;
  t4416 = t154 * t4415;
  t4417 = 0.35e2 / 0.54e2 * t4416;
  t4418 = t2356 * t6;
  t4419 = t4418 * t16;
  t4420 = t527 * t40;
  t4421 = t4420 * t152;
  t4422 = t4419 * t4421;
  t4423 = t2814 * t4422;
  t4424 = 0.1e5 / 0.729e3 * t4423;
  t4425 = t1389 * t316;
  t4426 = 0.2e1 * t4425;
  t4427 = t542 * t545;
  t4430 = t325 * t4163;
  t4433 = t801 * t4307;
  t4436 = t801 * t4325;
  t4440 = t15 * t185 * t187;
  t4441 = t431 * t4440;
  t4448 = t1266 * t1277;
  t4451 = t431 * t4134;
  t4453 = t152 * t54 * t502;
  t4457 = t800 * t801 * t522;
  t4460 = t544 * t160;
  t4464 = t1378 * t4169;
  t4468 = t1296 * t527 * t50;
  t4474 = t1266 * t1270;
  t4478 = t152 * t54 * t508;
  t4481 = t16 * t522;
  t4485 = -0.2e4 / 0.81e2 * t452 * t4427 + 0.2e4 / 0.729e3 * t324 * t4430 - 0.25e4 / 0.729e3 * t190 * t4433 + 0.25e3 / 0.243e3 * t190 * t4436 + 0.1e4 / 0.243e3 * t4441 * t325 * t4314 + 0.5e3 / 0.729e3 * t190 * t801 * t4321 - 0.1e4 / 0.243e3 * t4448 * t1375 - 0.5e2 / 0.81e2 * t4451 * t4453 + 0.1e3 / 0.81e2 * t1373 * t4457 + 0.2e5 / 0.729e3 * t543 * t4460 * t1379 - 0.2e5 / 0.729e3 * t543 * t4464 + 0.1e5 / 0.729e3 * t2785 * t4468 - 0.2e3 / 0.81e2 * t4207 * t16 * t453 + 0.25e3 / 0.81e2 * t4474 * t1370 - 0.25e2 / 0.27e2 * t1368 * t4478 - 0.2e4 / 0.243e3 * t543 * t1378 * t4481;
  t4486 = t4485 * t146;
  t4487 = t459 * t791;
  t4488 = t574 * t1296;
  t4489 = t4488 * t3508;
  t4490 = t1838 * t4489;
  t4491 = 0.25e2 / 0.81e2 * t4490;
  t4492 = t207 * t1314;
  t4493 = t180 * t167;
  t4494 = t194 * t4493;
  t4495 = t4492 * t4494;
  t4496 = t1838 * t4495;
  t4497 = 0.125e3 / 0.486e3 * t4496;
  t4498 = -t4367 - t4372 - t4377 + t4381 - t4385 + t4389 + t4393 - t4397 + t4402 + t4404 + t4406 + t4414 - t4417 - t4424 + t4426 + t4486 + t4487 + t4491 - t4497;
  t4518 = 0.35e2 / 0.54e2 * t1332;
  t4520 = 0.5e1 / 0.18e2 * t1347;
  t4523 = 0.1e2 / 0.9e1 * t1287 + 0.1e2 / 0.9e1 * t1291 - 0.5e2 / 0.27e2 * t1268 + 0.5e2 / 0.27e2 * t1275 + 0.4e4 / 0.243e3 * t1299 - 0.25e2 / 0.162e3 * t1328 - t4518 - 0.5e1 / 0.18e2 * t1342 + t4520 - 0.25e2 / 0.108e3 * t1352 + 0.25e2 / 0.108e3 * t1358;
  tv3rho2tau0 = t9 * (t4206 + t4286 + t4362 + t4498) + 0.5e1 / 0.36e2 * t1319 + 0.5e1 / 0.36e2 * t1363 + 0.2e1 * t1390 + 0.2e1 * t1391 - 0.1e3 / 0.81e2 * t1303 - 0.1e3 / 0.81e2 * t1307 - 0.2e3 / 0.81e2 * t1282 + 0.5e3 / 0.243e3 * t1312 - 0.5e3 / 0.243e3 * t1317 + t4523;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t4524 = t484 * t791;
  t4525 = t1471 * t316;
  t4526 = 0.2e1 * t4525;
  t4527 = t512 * t40;
  t4528 = t462 * t4527;
  t4530 = t152 * t54 * t513;
  t4533 = t26 * t185;
  t4534 = t4533 * t187;
  t4535 = t462 * t4534;
  t4536 = t171 * params->c;
  t4537 = t4536 * t180;
  t4538 = t325 * t4537;
  t4542 = t152 * t54 * t517;
  t4554 = t26 * t180 * t171;
  t4558 = t27 * t522;
  t4559 = t1463 * t4558;
  t4562 = t21 * t512;
  t4563 = t4562 * t513;
  t4567 = t1421 * t517;
  t4571 = -0.5e2 / 0.81e2 * t4528 * t4530 + 0.1e4 / 0.243e3 * t4535 * t4538 - 0.25e2 / 0.27e2 * t1455 * t4542 - 0.2e4 / 0.81e2 * t478 * t4427 + 0.1e3 / 0.81e2 * t1460 * t4457 + 0.1e5 / 0.729e3 * t2785 * t1410 * t527 * t50 - 0.2e5 / 0.729e3 * t543 * t1463 * t4554 - 0.2e4 / 0.243e3 * t543 * t4559 + 0.5e3 / 0.729e3 * t190 * t801 * t4563 + 0.25e3 / 0.243e3 * t190 * t801 * t4567;
  t4572 = t4571 * t146;
  t4573 = t797 * t475;
  t4574 = 0.5e1 / 0.72e2 * t4573;
  t4575 = t322 * t1452;
  t4576 = 0.5e1 / 0.36e2 * t4575;
  t4577 = t207 * t21;
  t4578 = t473 * t545;
  t4579 = t4577 * t4578;
  t4580 = t4409 * t4579;
  t4581 = 0.25e3 / 0.243e3 * t4580;
  t4582 = t1330 * t1451;
  t4583 = t154 * t4582;
  t4584 = 0.35e2 / 0.54e2 * t4583;
  t4585 = t2356 * t21;
  t4586 = t4585 * t27;
  t4587 = t4586 * t4421;
  t4588 = t2814 * t4587;
  t4589 = 0.1e5 / 0.729e3 * t4588;
  t4591 = t1141 * t1901 * t1422;
  t4592 = 0.5e3 / 0.243e3 * t4591;
  t4594 = t1141 * t530 * t4563;
  t4595 = 0.5e3 / 0.729e3 * t4594;
  t4596 = t445 * t1740;
  t4597 = t154 * t4596;
  t4598 = 0.5e1 / 0.36e2 * t4597;
  t4599 = t464 * t4199;
  t4600 = 0.1e2 / 0.9e1 * t4599;
  t4601 = t464 * t4203;
  t4602 = 0.5e1 / 0.9e1 * t4601;
  t4603 = t27 * t539;
  t4604 = t462 * t4603;
  t4605 = t4604 * t4217;
  t4606 = 0.2e4 / 0.81e2 * t4605;
  t4607 = t4524 + t4526 + t4572 + t4574 + t4576 + t4581 - t4584 - t4589 - t4592 - t4595 + t4598 + t4600 + t4602 + t4606;
  t4608 = t464 * t4222;
  t4609 = 0.5e1 / 0.9e1 * t4608;
  t4610 = t26 * t146;
  t4611 = t209 * t171;
  t4612 = t4610 * t4611;
  t4613 = t1843 * t4612;
  t4614 = t1336 * t4613;
  t4615 = 0.25e2 / 0.54e2 * t4614;
  t4616 = t1450 * t326;
  t4617 = t1428 * t4616;
  t4618 = t1323 * t4617;
  t4619 = 0.25e2 / 0.162e3 * t4618;
  t4620 = t473 * t810;
  t4621 = t1428 * t4620;
  t4622 = t1323 * t4621;
  t4623 = 0.25e2 / 0.324e3 * t4622;
  t4624 = t4363 * t472;
  t4625 = t4624 * t1429;
  t4626 = t1323 * t4625;
  t4627 = 0.175e3 / 0.243e3 * t4626;
  t4628 = t1324 * t1440;
  t4629 = t4628 * t1429;
  t4630 = t1323 * t4629;
  t4631 = 0.25e2 / 0.81e2 * t4630;
  t4632 = t4276 * t474;
  t4633 = t154 * t4632;
  t4634 = 0.595e3 / 0.324e3 * t4633;
  t4635 = t1330 * t1441;
  t4636 = t154 * t4635;
  t4637 = 0.35e2 / 0.27e2 * t4636;
  t4638 = t322 * t1433;
  t4639 = 0.35e2 / 0.54e2 * t4638;
  t4640 = t322 * t1442;
  t4641 = 0.5e1 / 0.18e2 * t4640;
  t4642 = t1440 * t1450;
  t4643 = t445 * t4642;
  t4644 = t154 * t4643;
  t4645 = 0.5e1 / 0.18e2 * t4644;
  t4646 = t27 * t791;
  t4647 = t472 * t4646;
  t4648 = t445 * t4647;
  t4649 = t154 * t4648;
  t4650 = 0.5e1 / 0.72e2 * t4649;
  t4652 = t1141 * t1905 * t1422;
  t4653 = 0.5e3 / 0.243e3 * t4652;
  t4655 = t1141 * t530 * t4567;
  t4656 = 0.25e3 / 0.243e3 * t4655;
  t4657 = t462 * t26;
  t4658 = t4657 * t189;
  t4659 = t439 * t4537;
  t4660 = t4658 * t4659;
  t4661 = 0.1e4 / 0.243e3 * t4660;
  t4662 = t4609 - t4615 - t4619 - t4623 + t4627 - t4631 + t4634 - t4637 - t4639 + t4641 + t4645 + t4650 - t4653 - t4656 - t4661;
  t4664 = t4364 * t1446;
  t4665 = t1336 * t4664;
  t4666 = 0.175e3 / 0.162e3 * t4665;
  t4667 = t1410 * t4368;
  t4668 = t1338 * t4667;
  t4669 = t1336 * t4668;
  t4670 = 0.5e1 / 0.18e2 * t4669;
  t4671 = t1410 * t4373;
  t4672 = t1338 * t4671;
  t4673 = t1336 * t4672;
  t4674 = 0.5e1 / 0.36e2 * t4673;
  t4675 = t4240 * t1437;
  t4676 = 0.5e1 / 0.18e2 * t4675;
  t4677 = t4240 * t1447;
  t4678 = 0.25e2 / 0.108e3 * t4677;
  t4679 = t1354 * t1736;
  t4680 = t4353 * t4679;
  t4681 = 0.25e2 / 0.162e3 * t4680;
  t4682 = t146 * t513;
  t4683 = t4562 * t4682;
  t4684 = t1354 * t4683;
  t4685 = t1336 * t4684;
  t4686 = 0.25e2 / 0.324e3 * t4685;
  t4687 = t1410 * t4253;
  t4688 = t4252 * t4687;
  t4689 = t1336 * t4688;
  t4690 = 0.5e1 / 0.12e2 * t4689;
  t4691 = t4258 * t1436;
  t4692 = t1336 * t4691;
  t4693 = 0.5e1 / 0.9e1 * t4692;
  t4694 = t4345 * t1446;
  t4695 = t1336 * t4694;
  t4696 = 0.25e2 / 0.54e2 * t4695;
  t4697 = t316 * t171;
  t4698 = t1421 * t4697;
  t4699 = t1354 * t4698;
  t4700 = t1336 * t4699;
  t4701 = 0.25e2 / 0.108e3 * t4700;
  t4702 = t146 * t517;
  t4703 = t1421 * t4702;
  t4704 = t1354 * t4703;
  t4705 = t1336 * t4704;
  t4706 = 0.25e2 / 0.216e3 * t4705;
  t4707 = t4358 * t1436;
  t4708 = t1336 * t4707;
  t4709 = 0.35e2 / 0.27e2 * t4708;
  t4710 = t4527 * t44;
  t4711 = t462 * t4710;
  t4713 = t55 * t147 * t513;
  t4714 = t4711 * t4713;
  t4715 = 0.5e2 / 0.81e2 * t4714;
  t4716 = -t4666 - t4670 - t4674 - t4676 + t4678 - t4681 + t4686 + t4690 - t4693 + t4696 + t4701 + t4706 + t4709 + t4715;
  t4717 = t4173 * t468;
  t4718 = t190 * t4717;
  t4719 = 0.5e2 / 0.81e2 * t4718;
  t4720 = t4177 * t468;
  t4721 = t190 * t4720;
  t4722 = 0.1e3 / 0.81e2 * t4721;
  t4723 = t4181 * t468;
  t4724 = t190 * t4723;
  t4725 = 0.5e2 / 0.81e2 * t4724;
  t4726 = t1403 * t4189;
  t4727 = 0.2e3 / 0.81e2 * t4726;
  t4728 = t1403 * t4192;
  t4729 = 0.2e3 / 0.81e2 * t4728;
  t4730 = t1403 * t4195;
  t4731 = 0.1e3 / 0.81e2 * t4730;
  t4732 = t1831 * t4554;
  t4733 = t1294 * t4732;
  t4734 = 0.2e5 / 0.729e3 * t4733;
  t4735 = t4299 * t1412;
  t4736 = 0.4e4 / 0.243e3 * t4735;
  t4737 = t4302 * t1411;
  t4738 = t1294 * t4737;
  t4739 = 0.4e4 / 0.243e3 * t4738;
  t4740 = t1410 * t522;
  t4741 = t1295 * t4740;
  t4742 = t1294 * t4741;
  t4743 = 0.2e4 / 0.243e3 * t4742;
  t4745 = t55 * t217 * t171;
  t4746 = t1396 * t4745;
  t4747 = 0.5e2 / 0.27e2 * t4746;
  t4749 = t55 * t317 * t171;
  t4750 = t1396 * t4749;
  t4751 = 0.5e2 / 0.27e2 * t4750;
  t4753 = t55 * t147 * t517;
  t4754 = t1396 * t4753;
  t4755 = 0.25e2 / 0.27e2 * t4754;
  t4756 = t574 * t1410;
  t4757 = t4756 * t3508;
  t4758 = t1838 * t4757;
  t4759 = 0.25e2 / 0.81e2 * t4758;
  t4760 = t207 * t1421;
  t4761 = t180 * t171;
  t4762 = t194 * t4761;
  t4763 = t4760 * t4762;
  t4764 = t1838 * t4763;
  t4765 = 0.125e3 / 0.486e3 * t4764;
  t4766 = -t4719 - t4722 - t4725 - t4727 - t4729 - t4731 + t4734 + t4736 + t4739 + t4743 + t4747 + t4751 + t4755 + t4759 - t4765;
  t4783 = 0.35e2 / 0.54e2 * t1434;
  t4785 = 0.5e1 / 0.18e2 * t1443;
  tv3rho2tau1 = t9 * (t4607 + t4662 + t4716 + t4766) - 0.25e2 / 0.162e3 * t1431 + 0.2e1 * t1472 + 0.2e1 * t1473 + 0.5e1 / 0.36e2 * t1453 + 0.5e1 / 0.36e2 * t1426 - 0.2e3 / 0.81e2 * t1404 - 0.1e3 / 0.81e2 * t1416 - 0.1e3 / 0.81e2 * t1419 - 0.5e3 / 0.243e3 * t1424 + 0.1e2 / 0.9e1 * t1406 + 0.1e2 / 0.9e1 * t1408 + 0.5e2 / 0.27e2 * t1399 + 0.4e4 / 0.243e3 * t1413 - t4783 - 0.5e1 / 0.18e2 * t1438 + t4785 + 0.25e2 / 0.108e3 * t1448;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t4787 = t1360 * t390;
  t4788 = t1325 * t4787;
  t4789 = t1323 * t4788;
  t4791 = t4378 * t1510;
  t4792 = t1323 * t4791;
  t4794 = t4382 * t1510;
  t4795 = t1323 * t4794;
  t4797 = t459 * t951;
  t4798 = t4299 * t1493;
  t4801 = t55 * t217 * t336;
  t4802 = t1272 * t4801;
  t4805 = t55 * t317 * t336;
  t4806 = t1272 * t4805;
  t4808 = t4215 * t541;
  t4809 = t431 * t4808;
  t4810 = t4809 * t855;
  t4813 = t55 * t365 * t167;
  t4814 = t1272 * t4813;
  t4817 = t55 * t383 * t167;
  t4818 = t1272 * t4817;
  t4820 = t4129 * t350;
  t4821 = t1295 * t4820;
  t4822 = t1294 * t4821;
  t4824 = t4141 * t1477;
  t4826 = t388 * t1346;
  t4828 = -0.25e2 / 0.324e3 * t4789 + 0.175e3 / 0.486e3 * t4792 - 0.25e2 / 0.162e3 * t4795 + t4797 + 0.2e4 / 0.243e3 * t4798 + 0.25e2 / 0.27e2 * t4802 + 0.25e2 / 0.27e2 * t4806 + 0.2e4 / 0.81e2 * t4810 + 0.25e2 / 0.27e2 * t4814 + 0.25e2 / 0.27e2 * t4818 - 0.1e5 / 0.729e3 * t4822 - 0.125e3 / 0.81e2 * t4824 + 0.5e1 / 0.36e2 * t4826;
  t4829 = t388 * t1351;
  t4831 = t388 * t1331;
  t4833 = t382 * t209;
  t4834 = t1296 * t4833;
  t4835 = t1338 * t4834;
  t4836 = t1336 * t4835;
  t4838 = t382 * t167;
  t4839 = t1314 * t4838;
  t4840 = t1354 * t4839;
  t4841 = t1336 * t4840;
  t4843 = t350 * t167;
  t4844 = t194 * t4843;
  t4845 = t4492 * t4844;
  t4846 = t1838 * t4845;
  t4848 = t4488 * t3857;
  t4849 = t1838 * t4848;
  t4851 = t1519 * t326;
  t4852 = t4492 * t4851;
  t4853 = t1838 * t4852;
  t4855 = t549 * t382;
  t4856 = t4855 * t441;
  t4857 = t190 * t4856;
  t4859 = t193 * t951;
  t4860 = t4859 * t441;
  t4861 = t190 * t4860;
  t4863 = t337 * t180;
  t4864 = t4167 * t4863;
  t4865 = t1294 * t4864;
  t4867 = t55 * t66;
  t4868 = t3485 * t506;
  t4869 = t4867 * t4868;
  t4870 = t1272 * t4869;
  t4872 = t4188 * t355;
  t4873 = t1279 * t4872;
  t4875 = t1280 * t861;
  t4876 = t1279 * t4875;
  t4878 = -0.25e2 / 0.216e3 * t4829 - 0.35e2 / 0.108e3 * t4831 - 0.5e1 / 0.36e2 * t4836 + 0.25e2 / 0.216e3 * t4841 - 0.125e3 / 0.972e3 * t4846 + 0.25e2 / 0.162e3 * t4849 - 0.125e3 / 0.972e3 * t4853 - 0.5e2 / 0.81e2 * t4857 - 0.5e2 / 0.81e2 * t4861 + 0.1e5 / 0.729e3 * t4865 + 0.25e2 / 0.27e2 * t4870 - 0.1e3 / 0.81e2 * t4873 - 0.1e3 / 0.81e2 * t4876;
  t4880 = t1280 * t865;
  t4881 = t1279 * t4880;
  t4883 = t325 * t364;
  t4884 = t4883 * t195;
  t4885 = t1279 * t4884;
  t4887 = t1280 * t903;
  t4888 = t1279 * t4887;
  t4890 = t1496 * t1310;
  t4891 = t190 * t4890;
  t4893 = t1500 * t1310;
  t4894 = t190 * t4893;
  t4896 = t4185 * t1480;
  t4898 = t15 * t350;
  t4899 = t4898 * t167;
  t4900 = t4167 * t4899;
  t4901 = t1294 * t4900;
  t4903 = t2549 * t146;
  t4904 = t4903 * t441;
  t4905 = t190 * t4904;
  t4907 = t871 * t316;
  t4908 = t4907 * t441;
  t4909 = t190 * t4908;
  t4911 = t2247 * t206;
  t4912 = t252 * t6;
  t4913 = t4912 * t4226;
  t4914 = t4911 * t4913;
  t4915 = t154 * t4914;
  t4917 = t1519 * t167;
  t4918 = t4867 * t4917;
  t4919 = t4136 * t4918;
  t4921 = t4258 * t1515;
  t4922 = t1336 * t4921;
  t4924 = t4129 * t1514;
  t4925 = t1338 * t4924;
  t4926 = t1336 * t4925;
  t4928 = -0.1e3 / 0.81e2 * t4881 - 0.1e3 / 0.81e2 * t4885 - 0.1e3 / 0.81e2 * t4888 + 0.25e3 / 0.243e3 * t4891 + 0.25e3 / 0.243e3 * t4894 + 0.5e3 / 0.243e3 * t4896 + 0.1e5 / 0.729e3 * t4901 - 0.5e2 / 0.81e2 * t4905 - 0.5e2 / 0.81e2 * t4909 + 0.25e2 / 0.216e3 * t4915 + 0.5e2 / 0.81e2 * t4919 - 0.5e1 / 0.18e2 * t4922 + 0.25e2 / 0.108e3 * t4926;
  t4929 = t316 * t360;
  t4930 = t1296 * t4929;
  t4931 = t1338 * t4930;
  t4932 = t1336 * t4931;
  t4934 = t146 * t886;
  t4935 = t1296 * t4934;
  t4936 = t1338 * t4935;
  t4937 = t1336 * t4936;
  t4939 = t4240 * t1521;
  t4941 = t316 * t336;
  t4942 = t1314 * t4941;
  t4943 = t1354 * t4942;
  t4944 = t1336 * t4943;
  t4946 = t4306 * t336;
  t4948 = t1141 * t530 * t4946;
  t4950 = t4386 * t1510;
  t4951 = t1323 * t4950;
  t4954 = t336 * t209;
  t4955 = t4226 * t4954;
  t4956 = t4225 * t4955;
  t4957 = t1336 * t4956;
  t4959 = t501 * t146;
  t4960 = t336 * t167;
  t4961 = t4959 * t4960;
  t4962 = t1325 * t4961;
  t4963 = t1336 * t4962;
  t4965 = t1524 * t326;
  t4967 = t1323 * t1325 * t4965;
  t4969 = t447 * t966;
  t4970 = t1325 * t4969;
  t4971 = t1323 * t4970;
  t4973 = t322 * t1526;
  t4975 = t16 * t951;
  t4976 = t446 * t4975;
  t4977 = t445 * t4976;
  t4978 = t154 * t4977;
  t4980 = -0.5e1 / 0.36e2 * t4932 - 0.5e1 / 0.36e2 * t4937 + 0.25e2 / 0.216e3 * t4939 + 0.25e2 / 0.216e3 * t4944 + 0.125e4 / 0.729e3 * t4948 + 0.125e3 / 0.972e3 * t4951 + 0.5e1 / 0.18e2 * t4260 - 0.25e2 / 0.108e3 * t4957 + 0.25e2 / 0.324e3 * t4963 - 0.25e2 / 0.324e3 * t4967 - 0.25e2 / 0.324e3 * t4971 + 0.5e1 / 0.72e2 * t4973 + 0.5e1 / 0.72e2 * t4978;
  t4983 = t4245 * t4960;
  t4984 = t530 * t4983;
  t4985 = t1141 * t4984;
  t4987 = t1314 * t507;
  t4988 = t530 * t4987;
  t4989 = t1141 * t4988;
  t4991 = t957 * t449;
  t4993 = t388 * t1362;
  t4995 = t1330 * t1525;
  t4996 = t154 * t4995;
  t4998 = t1344 * t1524;
  t4999 = t445 * t4998;
  t5000 = t154 * t4999;
  t5007 = -0.5e3 / 0.729e3 * t4985 - 0.25e3 / 0.243e3 * t4989 + 0.5e1 / 0.72e2 * t4991 + 0.5e1 / 0.72e2 * t4993 - 0.35e2 / 0.108e3 * t4996 + 0.5e1 / 0.36e2 * t5000 + 0.25e2 / 0.108e3 * t4269 + t4279 + 0.175e3 / 0.324e3 * t4284 - 0.35e2 / 0.108e3 * t4288 - 0.5e1 / 0.36e2 * t4290 - t4320 - 0.25e2 / 0.108e3 * t4347;
  t5012 = t2812 * t2429;
  t5013 = t805 * t5012;
  t5014 = t1492 * t3863;
  t5015 = t5013 * t5014;
  t5017 = t4364 * t1520;
  t5018 = t1336 * t5017;
  t5020 = t4345 * t1520;
  t5021 = t1336 * t5020;
  t5023 = t4306 * t1519;
  t5024 = t1354 * t5023;
  t5025 = t1336 * t5024;
  t5027 = t4358 * t1515;
  t5028 = t1336 * t5027;
  t5030 = t1544 * t316;
  t5034 = t152 * t1529 * t167;
  t5037 = t336 * params->c;
  t5038 = t5037 * t180;
  t5039 = t325 * t5038;
  t5042 = t54 * t8;
  t5044 = t152 * t5042 * t506;
  t5049 = t390 * t167;
  t5050 = t325 * t5049;
  t5056 = t800 * t801 * t841;
  t5059 = t2353 * t2356;
  t5061 = t805 * t5059 * t6;
  t5063 = t1537 * t180 * t50;
  t5069 = t1378 * t4899;
  t5072 = t16 * t841;
  t5076 = t1378 * t4863;
  t5082 = t801 * t6;
  t5083 = t5082 * t824;
  t5086 = t5082 * t828;
  t5089 = 0.125e3 / 0.81e2 * t4474 * t1530 - 0.5e2 / 0.81e2 * t4451 * t5034 + 0.5e3 / 0.243e3 * t4441 * t5039 - 0.25e2 / 0.27e2 * t1368 * t5044 - 0.5e3 / 0.243e3 * t4448 * t1534 + 0.5e3 / 0.243e3 * t4441 * t5050 - 0.2e4 / 0.81e2 * t4216 * t963 + 0.1e3 / 0.81e2 * t1373 * t5056 + 0.1e5 / 0.729e3 * t5061 * t5063 + 0.1e5 / 0.729e3 * t543 * t4460 * t1537 - 0.1e5 / 0.729e3 * t543 * t5069 - 0.2e4 / 0.243e3 * t543 * t1378 * t5072 - 0.1e5 / 0.729e3 * t543 * t5076 - 0.125e4 / 0.729e3 * t190 * t801 * t4946 + 0.5e3 / 0.729e3 * t190 * t5083 + 0.25e3 / 0.243e3 * t190 * t5086;
  t5090 = t5089 * t146;
  t5091 = t1349 * t1524;
  t5092 = t445 * t5091;
  t5093 = t154 * t5092;
  t5095 = t4302 * t1492;
  t5096 = t1294 * t5095;
  t5098 = 0.35e2 / 0.54e2 * t4360 - 0.175e3 / 0.324e3 * t4366 + 0.175e3 / 0.486e3 * t4380 + 0.25e2 / 0.162e3 * t4384 - 0.1e5 / 0.729e3 * t5015 - 0.175e3 / 0.324e3 * t5018 + 0.25e2 / 0.108e3 * t5021 - 0.125e3 / 0.648e3 * t5025 + 0.35e2 / 0.54e2 * t5028 + t5030 + t5090 - 0.25e2 / 0.216e3 * t5093 + 0.2e4 / 0.243e3 * t5096;
  t5100 = t1296 * t841;
  t5101 = t1295 * t5100;
  t5102 = t1294 * t5101;
  t5104 = t542 * t364;
  t5105 = t39 * t5104;
  t5106 = t5105 * t1298;
  t5108 = t382 * t544;
  t5109 = t5108 * t1297;
  t5110 = t1294 * t5109;
  t5114 = t4251 * t446;
  t5115 = t360 * t209;
  t5116 = t447 * t5115;
  t5117 = t5114 * t5116;
  t5118 = t1336 * t5117;
  t5120 = t360 * t167;
  t5121 = t4226 * t5120;
  t5122 = t4225 * t5121;
  t5123 = t1336 * t5122;
  t5125 = t3755 * t1322;
  t5126 = t5125 * t1327;
  t5129 = t1141 * t2478 * t1315;
  t5132 = t1141 * t2462 * t1315;
  t5135 = t1141 * t1901 * t1504;
  t5138 = t1141 * t1905 * t1504;
  t5140 = t439 * t5038;
  t5141 = t4312 * t5140;
  t5143 = 0.2e4 / 0.243e3 * t5102 + 0.2e4 / 0.243e3 * t5106 + 0.2e4 / 0.243e3 * t5110 - 0.5e1 / 0.36e2 * t4392 - 0.35e2 / 0.108e3 * t4416 + 0.5e1 / 0.12e2 * t5118 - 0.25e2 / 0.108e3 * t5123 - 0.25e2 / 0.162e3 * t5126 - 0.25e3 / 0.243e3 * t5129 - 0.25e3 / 0.243e3 * t5132 - 0.25e3 / 0.243e3 * t5135 - 0.25e3 / 0.243e3 * t5138 - 0.5e3 / 0.243e3 * t5141;
  t5144 = t439 * t5049;
  t5145 = t4312 * t5144;
  t5148 = t152 * t1284 * t382;
  t5149 = t433 * t5148;
  t5152 = t152 * t434 * t951;
  t5153 = t433 * t5152;
  t5155 = t1267 * t1485;
  t5157 = t1267 * t1489;
  t5159 = t54 * t891;
  t5161 = t152 * t5159 * t146;
  t5162 = t433 * t5161;
  t5165 = t152 * t1483 * t316;
  t5166 = t433 * t5165;
  t5168 = t387 * t1335;
  t5169 = t5168 * t1341;
  t5171 = t5168 * t1357;
  t5173 = t4407 * t1324;
  t5174 = t805 * t5173;
  t5175 = t446 * t16;
  t5176 = t1295 * t962;
  t5177 = t5175 * t5176;
  t5178 = t5174 * t5177;
  t5180 = t4240 * t1516;
  t5182 = t4488 * t3868;
  t5183 = t1838 * t5182;
  t5185 = t1389 * t382;
  t5186 = -0.5e3 / 0.243e3 * t5145 + 0.5e1 / 0.9e1 * t5149 + 0.5e1 / 0.9e1 * t5153 - 0.25e2 / 0.27e2 * t5155 - 0.25e2 / 0.27e2 * t5157 + 0.5e1 / 0.9e1 * t5162 + 0.5e1 / 0.9e1 * t5166 - 0.5e1 / 0.36e2 * t5169 + 0.25e2 / 0.216e3 * t5171 + 0.25e3 / 0.243e3 * t5178 - 0.5e1 / 0.36e2 * t5180 + 0.25e2 / 0.162e3 * t5183 + t5185;
  t5191 = t9 * (t4828 + t4878 + t4928 + t4980 + t5007 + t5098 + t5143 + t5186) + t1528 - t1329 - t1482 - t1499 - t1503 + t1320 - t4518 - t1353 + t1364 + t1523 + t1479 + t1495 + t1276 + t1300 - t1283 - t1304;
  t5192 = -t1308 + t1313 - t1513 - t1343 + t1359 - t1518 - t1269 + t1288 + t1292 + t1509 + t1546 - t1507 + t1545 + t1487 + t1491 - t1318 + t1391 + t1390;
  tv3rho2tau2 = t5191 + t5192;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t5193 = t1628 + t1566 + t1556 + t1583 - t1596 + t1606 + t1627 - t1558 - t1569 - t1572 + t1577 - t1417 - t1420 + t1427 - t1552 + t1560 + t1562;
  t5194 = t1626 * t316;
  t5195 = t27 * t951;
  t5196 = t472 * t5195;
  t5197 = t445 * t5196;
  t5198 = t154 * t5197;
  t5200 = t322 * t1594;
  t5202 = t346 * t171;
  t5203 = t4562 * t5202;
  t5205 = t1141 * t530 * t5203;
  t5207 = t1421 * t507;
  t5209 = t1141 * t530 * t5207;
  t5211 = t957 * t475;
  t5213 = t388 * t1452;
  t5215 = t388 * t1433;
  t5217 = t388 * t1442;
  t5219 = t1597 * t326;
  t5220 = t4760 * t5219;
  t5221 = t1838 * t5220;
  t5223 = t1549 * t1402;
  t5224 = t5223 * t1281;
  t5226 = t1597 * t171;
  t5227 = t4867 * t5226;
  t5228 = t4711 * t5227;
  t5230 = t1396 * t4869;
  t5232 = t5194 + 0.5e1 / 0.72e2 * t5198 - 0.25e2 / 0.216e3 * t5200 - 0.5e3 / 0.729e3 * t5205 + 0.25e3 / 0.243e3 * t5209 + 0.5e1 / 0.72e2 * t5211 + 0.5e1 / 0.72e2 * t5213 - 0.35e2 / 0.108e3 * t5215 + 0.5e1 / 0.36e2 * t5217 - 0.125e3 / 0.972e3 * t5221 + 0.5e3 / 0.243e3 * t5224 + 0.5e2 / 0.81e2 * t5228 - 0.25e2 / 0.27e2 * t5230;
  t5233 = t1403 * t4872;
  t5235 = t1403 * t4875;
  t5237 = t1403 * t4880;
  t5240 = t190 * t4855 * t468;
  t5243 = t190 * t4859 * t468;
  t5246 = t190 * t1301 * t1574;
  t5249 = t190 * t1305 * t1574;
  t5251 = t347 * t180;
  t5252 = t1831 * t5251;
  t5253 = t1294 * t5252;
  t5256 = t1330 * t1593;
  t5257 = t154 * t5256;
  t5259 = t8 * t342;
  t5260 = t5259 * t473;
  t5261 = t445 * t5260;
  t5262 = t154 * t5261;
  t5264 = t1330 * t1603;
  t5265 = t154 * t5264;
  t5267 = t1440 * t1602;
  t5268 = t445 * t5267;
  t5269 = t154 * t5268;
  t5271 = -0.1e3 / 0.81e2 * t5233 - 0.1e3 / 0.81e2 * t5235 - 0.1e3 / 0.81e2 * t5237 - 0.5e2 / 0.81e2 * t5240 - 0.5e2 / 0.81e2 * t5243 + 0.25e3 / 0.243e3 * t5246 + 0.25e3 / 0.243e3 * t5249 + 0.1e5 / 0.729e3 * t5253 - 0.35e2 / 0.108e3 * t4583 + 0.175e3 / 0.324e3 * t5257 - 0.25e2 / 0.108e3 * t5262 - 0.35e2 / 0.108e3 * t5265 + 0.5e1 / 0.36e2 * t5269;
  t5273 = t1403 * t4884;
  t5275 = t1403 * t4887;
  t5277 = t26 * t350;
  t5278 = t5277 * t171;
  t5279 = t1831 * t5278;
  t5280 = t1294 * t5279;
  t5283 = t190 * t4903 * t468;
  t5286 = t190 * t4907 * t468;
  t5288 = t484 * t951;
  t5289 = t5105 * t1412;
  t5292 = t55 * t217 * t346;
  t5293 = t1396 * t5292;
  t5296 = t55 * t317 * t346;
  t5297 = t1396 * t5296;
  t5299 = t4603 * t541;
  t5300 = t462 * t5299;
  t5301 = t5300 * t855;
  t5304 = t55 * t365 * t171;
  t5305 = t1396 * t5304;
  t5308 = t55 * t383 * t171;
  t5309 = t1396 * t5308;
  t5311 = -t4598 - 0.1e3 / 0.81e2 * t5273 - 0.1e3 / 0.81e2 * t5275 + 0.1e5 / 0.729e3 * t5280 - 0.5e2 / 0.81e2 * t5283 - 0.5e2 / 0.81e2 * t5286 + t5288 + 0.2e4 / 0.243e3 * t5289 + 0.25e2 / 0.27e2 * t5293 + 0.25e2 / 0.27e2 * t5297 + 0.2e4 / 0.81e2 * t5301 + 0.25e2 / 0.27e2 * t5305 + 0.25e2 / 0.27e2 * t5309;
  t5312 = t1549 * t1395;
  t5313 = t5312 * t1398;
  t5315 = t1471 * t382;
  t5316 = t1549 * t1394;
  t5319 = t1549 * t1401;
  t5323 = t152 * t1610 * t171;
  t5326 = t346 * params->c;
  t5327 = t5326 * t180;
  t5333 = t390 * t171;
  t5334 = t325 * t5333;
  t5342 = t805 * t5059 * t21;
  t5344 = t1616 * t180 * t50;
  t5350 = t27 * t841;
  t5351 = t1463 * t5350;
  t5354 = t544 * t342;
  t5355 = t5354 * t1464;
  t5358 = t342 * t26;
  t5359 = t5358 * t171;
  t5366 = t801 * t21;
  t5373 = 0.125e3 / 0.81e2 * t5316 * t1457 - 0.5e3 / 0.243e3 * t5319 * t1375 - 0.5e2 / 0.81e2 * t4528 * t5323 + 0.5e3 / 0.243e3 * t4535 * t325 * t5327 + 0.25e2 / 0.27e2 * t1455 * t5044 + 0.5e3 / 0.243e3 * t4535 * t5334 - 0.2e4 / 0.81e2 * t4604 * t963 + 0.1e3 / 0.81e2 * t1460 * t5056 + 0.1e5 / 0.729e3 * t5342 * t5344 - 0.1e5 / 0.729e3 * t543 * t1463 * t5278 - 0.2e4 / 0.243e3 * t543 * t5351 + 0.1e5 / 0.729e3 * t543 * t5355 - 0.125e4 / 0.729e3 * t190 * t801 * t5359 - 0.1e5 / 0.729e3 * t543 * t1463 * t5251 + 0.5e3 / 0.729e3 * t190 * t5366 * t834 - 0.25e3 / 0.243e3 * t190 * t5366 * t838;
  t5374 = t5373 * t146;
  t5380 = t464 * t5148;
  t5382 = t464 * t5152;
  t5384 = t1550 * t1286;
  t5386 = t1550 * t1290;
  t5388 = -0.125e3 / 0.81e2 * t5313 + t5315 + t5374 + 0.175e3 / 0.486e3 * t4626 + 0.25e2 / 0.162e3 * t4630 + t4634 - 0.35e2 / 0.108e3 * t4638 - 0.5e1 / 0.36e2 * t4640 - 0.5e1 / 0.36e2 * t4644 + 0.5e1 / 0.9e1 * t5380 + 0.5e1 / 0.9e1 * t5382 - 0.25e2 / 0.27e2 * t5384 - 0.25e2 / 0.27e2 * t5386;
  t5391 = t464 * t5161;
  t5393 = t464 * t5165;
  t5396 = t1141 * t530 * t5359;
  t5399 = t1141 * t1901 * t1578;
  t5402 = t1141 * t1905 * t1578;
  t5405 = t1141 * t2478 * t1422;
  t5408 = t1323 * t4624 * t1584;
  t5411 = t1323 * t4628 * t1584;
  t5413 = t346 * t209;
  t5414 = t4610 * t5413;
  t5415 = t1843 * t5414;
  t5416 = t1336 * t5415;
  t5418 = t512 * t146;
  t5419 = t5418 * t5202;
  t5420 = t1428 * t5419;
  t5421 = t1336 * t5420;
  t5423 = t1602 * t326;
  t5424 = t1428 * t5423;
  t5425 = t1323 * t5424;
  t5427 = t4251 * t472;
  t5428 = t473 * t5115;
  t5429 = t5427 * t5428;
  t5430 = t1336 * t5429;
  t5432 = t360 * t171;
  t5433 = t4610 * t5432;
  t5434 = t1843 * t5433;
  t5435 = t1336 * t5434;
  t5437 = 0.5e1 / 0.9e1 * t5391 + 0.5e1 / 0.9e1 * t5393 + 0.125e4 / 0.729e3 * t5396 - 0.25e3 / 0.243e3 * t5399 - 0.25e3 / 0.243e3 * t5402 - 0.25e3 / 0.243e3 * t5405 + 0.175e3 / 0.486e3 * t5408 - 0.25e2 / 0.162e3 * t5411 - 0.25e2 / 0.108e3 * t5416 + 0.25e2 / 0.324e3 * t5421 - 0.25e2 / 0.324e3 * t5425 + 0.5e1 / 0.12e2 * t5430 - 0.25e2 / 0.108e3 * t5435;
  t5438 = t5125 * t1430;
  t5440 = t1450 * t390;
  t5442 = t1323 * t1428 * t5440;
  t5444 = t473 * t966;
  t5445 = t1428 * t5444;
  t5446 = t1323 * t5445;
  t5452 = t439 * t5327;
  t5453 = t4658 * t5452;
  t5455 = t439 * t5333;
  t5456 = t4658 * t5455;
  t5458 = t4756 * t3868;
  t5459 = t1838 * t5458;
  t5461 = t350 * t171;
  t5462 = t194 * t5461;
  t5463 = t4760 * t5462;
  t5464 = t1838 * t5463;
  t5466 = t4756 * t3857;
  t5467 = t1838 * t5466;
  t5469 = t5108 * t1411;
  t5470 = t1294 * t5469;
  t5472 = -0.25e2 / 0.162e3 * t5438 - 0.25e2 / 0.324e3 * t5442 - 0.25e2 / 0.324e3 * t5446 - 0.175e3 / 0.324e3 * t4665 + 0.5e1 / 0.18e2 * t4692 - 0.25e2 / 0.108e3 * t4695 + 0.35e2 / 0.54e2 * t4708 - 0.5e3 / 0.243e3 * t5453 - 0.5e3 / 0.243e3 * t5456 + 0.25e2 / 0.162e3 * t5459 - 0.125e3 / 0.972e3 * t5464 + 0.25e2 / 0.162e3 * t5467 + 0.2e4 / 0.243e3 * t5470;
  t5474 = t342 * t27;
  t5475 = t5474 * t180;
  t5476 = t1295 * t5475;
  t5477 = t1294 * t5476;
  t5479 = t4299 * t1564;
  t5481 = t4302 * t1563;
  t5482 = t1294 * t5481;
  t5484 = t1410 * t841;
  t5485 = t1295 * t5484;
  t5486 = t1294 * t5485;
  t5488 = t1592 * t1450;
  t5489 = t445 * t5488;
  t5490 = t154 * t5489;
  t5492 = t252 * t21;
  t5493 = t5492 * t4610;
  t5494 = t4911 * t5493;
  t5495 = t154 * t5494;
  t5497 = t322 * t1604;
  t5499 = t1324 * t1592;
  t5500 = t5499 * t1429;
  t5501 = t1323 * t5500;
  t5503 = t4364 * t1598;
  t5504 = t1336 * t5503;
  t5506 = t4345 * t1598;
  t5507 = t1336 * t5506;
  t5510 = t1141 * t2462 * t1422;
  t5512 = t4358 * t1588;
  t5513 = t1336 * t5512;
  t5515 = t4258 * t1588;
  t5516 = t1336 * t5515;
  t5518 = -0.1e5 / 0.729e3 * t5477 + 0.2e4 / 0.243e3 * t5479 + 0.2e4 / 0.243e3 * t5482 + 0.2e4 / 0.243e3 * t5486 - 0.25e2 / 0.216e3 * t5490 - 0.25e2 / 0.216e3 * t5495 + 0.5e1 / 0.72e2 * t5497 + 0.125e3 / 0.972e3 * t5501 - 0.175e3 / 0.324e3 * t5504 + 0.25e2 / 0.108e3 * t5507 - 0.25e3 / 0.243e3 * t5510 + 0.35e2 / 0.54e2 * t5513 - 0.5e1 / 0.18e2 * t5516;
  t5519 = t1563 * t3863;
  t5520 = t5013 * t5519;
  t5522 = t5168 * t1437;
  t5524 = t5168 * t1447;
  t5526 = t472 * t27;
  t5527 = t5526 * t5176;
  t5528 = t5174 * t5527;
  t5530 = t4240 * t1589;
  t5532 = t1410 * t4929;
  t5533 = t1338 * t5532;
  t5534 = t1336 * t5533;
  t5536 = t1410 * t4934;
  t5537 = t1338 * t5536;
  t5538 = t1336 * t5537;
  t5540 = t5474 * t1339;
  t5541 = t1338 * t5540;
  t5542 = t1336 * t5541;
  t5544 = t5358 * t1445;
  t5545 = t1354 * t5544;
  t5546 = t1336 * t5545;
  t5548 = t4240 * t1599;
  t5550 = t316 * t346;
  t5551 = t1421 * t5550;
  t5552 = t1354 * t5551;
  t5553 = t1336 * t5552;
  t5555 = t1410 * t4833;
  t5556 = t1338 * t5555;
  t5557 = t1336 * t5556;
  t5559 = t382 * t171;
  t5560 = t1421 * t5559;
  t5561 = t1354 * t5560;
  t5562 = t1336 * t5561;
  t5564 = -0.1e5 / 0.729e3 * t5520 - 0.5e1 / 0.36e2 * t5522 + 0.25e2 / 0.216e3 * t5524 + 0.25e3 / 0.243e3 * t5528 - 0.5e1 / 0.36e2 * t5530 - 0.5e1 / 0.36e2 * t5534 - 0.5e1 / 0.36e2 * t5538 + 0.25e2 / 0.108e3 * t5542 - 0.125e3 / 0.648e3 * t5546 + 0.25e2 / 0.216e3 * t5548 + 0.25e2 / 0.216e3 * t5553 - 0.5e1 / 0.36e2 * t5557 + 0.25e2 / 0.216e3 * t5562;
  t5569 = -t1591 + t1601 + t1414 + t1400 - t1405 - t1432 - t1587 - t1439 + t1449 + t1407 + t9 * (t5232 + t5271 + t5311 + t5388 + t5437 + t5472 + t5518 + t5564) - t4783 + t1454 - t1581 - t1425 + t1409 + t1473 + t1472;
  tv3rho2tau3 = t5193 + t5569;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t5570 = 0.175e3 / 0.243e3 * t4792;
  t5571 = 0.25e2 / 0.81e2 * t4795;
  t5572 = t4488 * t4047;
  t5573 = t1838 * t5572;
  t5574 = 0.25e2 / 0.81e2 * t5573;
  t5575 = t350 * t336;
  t5576 = t194 * t5575;
  t5577 = t4492 * t5576;
  t5578 = t1838 * t5577;
  t5579 = 0.125e3 / 0.486e3 * t5578;
  t5580 = 0.5e1 / 0.18e2 * t4826;
  t5581 = 0.35e2 / 0.54e2 * t4831;
  t5582 = t459 * t1084;
  t5583 = 0.5e1 / 0.9e1 * t4922;
  t5584 = t2372 * t4022;
  t5585 = t4216 * t5584;
  t5586 = 0.2e4 / 0.81e2 * t5585;
  t5587 = t54 * t1046;
  t5589 = t152 * t5587 * t146;
  t5590 = t433 * t5589;
  t5591 = 0.5e1 / 0.9e1 * t5590;
  t5593 = t152 * t1483 * t382;
  t5594 = t433 * t5593;
  t5595 = 0.1e2 / 0.9e1 * t5594;
  t5597 = t152 * t434 * t1084;
  t5598 = t433 * t5597;
  t5599 = 0.5e1 / 0.9e1 * t5598;
  t5600 = t447 * t1098;
  t5601 = t1325 * t5600;
  t5602 = t1323 * t5601;
  t5603 = 0.25e2 / 0.324e3 * t5602;
  t5605 = t55 * t147 * t983;
  t5606 = t4136 * t5605;
  t5607 = 0.5e2 / 0.81e2 * t5606;
  t5608 = t5570 + t5571 + t5574 - t5579 - t5580 - t5581 + t5582 + t5583 + t5586 + t5591 + t5595 + t5599 - t5603 + t5607;
  t5609 = t382 * t336;
  t5610 = t1314 * t5609;
  t5611 = t1354 * t5610;
  t5612 = t1336 * t5611;
  t5613 = 0.25e2 / 0.108e3 * t5612;
  t5614 = t382 * t360;
  t5615 = t1296 * t5614;
  t5616 = t1338 * t5615;
  t5617 = t1336 * t5616;
  t5618 = 0.5e1 / 0.18e2 * t5617;
  t5619 = t146 * t1042;
  t5620 = t1296 * t5619;
  t5621 = t1338 * t5620;
  t5622 = t1336 * t5621;
  t5623 = 0.5e1 / 0.36e2 * t5622;
  t5624 = t16 * t1084;
  t5625 = t446 * t5624;
  t5626 = t445 * t5625;
  t5627 = t154 * t5626;
  t5628 = 0.5e1 / 0.72e2 * t5627;
  t5629 = t1090 * t449;
  t5630 = 0.5e1 / 0.72e2 * t5629;
  t5631 = t388 * t1526;
  t5632 = 0.5e1 / 0.36e2 * t5631;
  t5633 = t447 * t1021;
  t5634 = t4410 * t5633;
  t5635 = t4409 * t5634;
  t5636 = 0.25e3 / 0.243e3 * t5635;
  t5637 = t1012 * t40;
  t5638 = t5637 * t152;
  t5639 = t4419 * t5638;
  t5640 = t2814 * t5639;
  t5641 = 0.1e5 / 0.729e3 * t5640;
  t5642 = 0.35e2 / 0.54e2 * t4996;
  t5643 = 0.5e1 / 0.18e2 * t5000;
  t5644 = t5105 * t1493;
  t5645 = 0.4e4 / 0.243e3 * t5644;
  t5646 = t5108 * t1492;
  t5647 = t1294 * t5646;
  t5648 = 0.4e4 / 0.243e3 * t5647;
  t5649 = t5613 - t5618 - t5623 + t5628 + t5630 + t5632 + t5636 - t5641 - t5642 - t5643 + t4279 + t4282 + t4320 + t5645 + t5648;
  t5651 = t1296 * t1007;
  t5652 = t1295 * t5651;
  t5653 = t1294 * t5652;
  t5654 = 0.2e4 / 0.243e3 * t5653;
  t5656 = t55 * t365 * t336;
  t5657 = t1272 * t5656;
  t5658 = 0.5e2 / 0.27e2 * t5657;
  t5660 = t55 * t383 * t336;
  t5661 = t1272 * t5660;
  t5662 = 0.5e2 / 0.27e2 * t5661;
  t5664 = t55 * t147 * t987;
  t5665 = t1272 * t5664;
  t5666 = 0.25e2 / 0.27e2 * t5665;
  t5667 = 0.175e3 / 0.162e3 * t5018;
  t5668 = 0.25e2 / 0.54e2 * t5021;
  t5669 = 0.35e2 / 0.27e2 * t5028;
  t5670 = t1314 * t987;
  t5672 = t1141 * t530 * t5670;
  t5673 = 0.25e3 / 0.243e3 * t5672;
  t5675 = t1141 * t2478 * t1504;
  t5676 = 0.5e3 / 0.243e3 * t5675;
  t5678 = t1141 * t2462 * t1504;
  t5679 = 0.5e3 / 0.243e3 * t5678;
  t5680 = t5037 * t350;
  t5681 = t439 * t5680;
  t5682 = t4312 * t5681;
  t5683 = 0.1e4 / 0.243e3 * t5682;
  t5684 = t1544 * t382;
  t5685 = 0.2e1 * t5684;
  t5686 = t54 * t983;
  t5687 = t152 * t5686;
  t5690 = t325 * t5680;
  t5693 = t54 * t987;
  t5694 = t152 * t5693;
  t5697 = t542 * t1021;
  t5701 = t800 * t801 * t1007;
  t5704 = t1296 * t1012;
  t5705 = t5704 * t50;
  t5708 = t4898 * t336;
  t5709 = t1378 * t5708;
  t5712 = t16 * t1007;
  t5716 = t4245 * t983;
  t5723 = -0.5e2 / 0.81e2 * t4451 * t5687 + 0.1e4 / 0.243e3 * t4441 * t5690 - 0.25e2 / 0.27e2 * t1368 * t5694 - 0.2e4 / 0.81e2 * t452 * t5697 + 0.1e3 / 0.81e2 * t1373 * t5701 + 0.1e5 / 0.729e3 * t2785 * t5705 - 0.2e5 / 0.729e3 * t543 * t5709 - 0.2e4 / 0.243e3 * t543 * t1378 * t5712 + 0.5e3 / 0.729e3 * t190 * t801 * t5716 + 0.25e3 / 0.243e3 * t190 * t801 * t5670;
  t5724 = t5723 * t146;
  t5725 = t3149 * t146;
  t5726 = t5725 * t441;
  t5727 = t190 * t5726;
  t5728 = 0.5e2 / 0.81e2 * t5727;
  t5729 = t5654 + t5658 + t5662 + t5666 - t5667 - t5668 + t5669 - t5673 - t5676 - t5679 - t5683 + t5685 + t5724 - t5728;
  t5730 = t871 * t382;
  t5731 = t5730 * t441;
  t5732 = t190 * t5731;
  t5733 = 0.1e3 / 0.81e2 * t5732;
  t5734 = t193 * t1084;
  t5735 = t5734 * t441;
  t5736 = t190 * t5735;
  t5737 = 0.5e2 / 0.81e2 * t5736;
  t5738 = t4883 * t355;
  t5739 = t1279 * t5738;
  t5740 = 0.2e3 / 0.81e2 * t5739;
  t5741 = t1280 * t1028;
  t5742 = t1279 * t5741;
  t5743 = 0.2e3 / 0.81e2 * t5742;
  t5744 = t1280 * t1032;
  t5745 = t1279 * t5744;
  t5746 = 0.1e3 / 0.81e2 * t5745;
  t5747 = t4167 * t5708;
  t5748 = t1294 * t5747;
  t5749 = 0.2e5 / 0.729e3 * t5748;
  t5750 = t360 * t336;
  t5751 = t4226 * t5750;
  t5752 = t4225 * t5751;
  t5753 = t1336 * t5752;
  t5754 = 0.25e2 / 0.54e2 * t5753;
  t5755 = t1524 * t390;
  t5756 = t1325 * t5755;
  t5757 = t1323 * t5756;
  t5758 = 0.25e2 / 0.162e3 * t5757;
  t5759 = t530 * t5716;
  t5760 = t1141 * t5759;
  t5761 = 0.5e3 / 0.729e3 * t5760;
  t5762 = t5168 * t1516;
  t5763 = 0.5e1 / 0.18e2 * t5762;
  t5764 = t5168 * t1521;
  t5765 = 0.25e2 / 0.108e3 * t5764;
  t5766 = t1092 * t1322;
  t5767 = t5766 * t4354;
  t5768 = 0.25e2 / 0.162e3 * t5767;
  t5769 = t146 * t987;
  t5770 = t1314 * t5769;
  t5771 = t1354 * t5770;
  t5772 = t1336 * t5771;
  t5773 = 0.25e2 / 0.216e3 * t5772;
  t5774 = t146 * t983;
  t5775 = t4245 * t5774;
  t5776 = t1354 * t5775;
  t5777 = t1336 * t5776;
  t5778 = 0.25e2 / 0.324e3 * t5777;
  t5779 = t146 * t1037;
  t5780 = t1296 * t5779;
  t5781 = t4252 * t5780;
  t5782 = t1336 * t5781;
  t5783 = 0.5e1 / 0.12e2 * t5782;
  t5784 = -t5733 - t5737 - t5740 - t5743 - t5746 + t5749 - t5754 - t5758 - t5761 - t5763 + t5765 - t5768 + t5773 + t5778 + t5783;
  tv3rho2tau4 = t9 * (t5608 + t5649 + t5729 + t5784) + 0.2e1 * t1545 + 0.2e1 * t1546 - 0.25e2 / 0.162e3 * t1512 + 0.5e1 / 0.36e2 * t1508 + 0.5e1 / 0.36e2 * t1527 - 0.2e3 / 0.81e2 * t1481 - 0.1e3 / 0.81e2 * t1498 - 0.1e3 / 0.81e2 * t1502 - 0.5e3 / 0.243e3 * t1506 + 0.1e2 / 0.9e1 * t1486 + 0.1e2 / 0.9e1 * t1490 + 0.5e2 / 0.27e2 * t1478 + 0.4e4 / 0.243e3 * t1494 - t4518 - t4520 - 0.5e1 / 0.18e2 * t1517 + 0.25e2 / 0.108e3 * t1522;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t5803 = t5474 * t350;
  t5804 = t1295 * t5803;
  t5805 = t1294 * t5804;
  t5806 = 0.2e5 / 0.729e3 * t5805;
  t5808 = t55 * t147 * t999;
  t5809 = t4711 * t5808;
  t5810 = 0.5e2 / 0.81e2 * t5809;
  t5811 = 0.35e2 / 0.54e2 * t5215;
  t5812 = 0.5e1 / 0.18e2 * t5217;
  t5814 = t1141 * t2462 * t1578;
  t5815 = 0.5e3 / 0.243e3 * t5814;
  t5816 = t5358 * t346;
  t5818 = t1141 * t530 * t5816;
  t5819 = 0.25e4 / 0.729e3 * t5818;
  t5820 = t5326 * t350;
  t5821 = t439 * t5820;
  t5822 = t4658 * t5821;
  t5823 = 0.1e4 / 0.243e3 * t5822;
  t5824 = t1421 * t1003;
  t5826 = t1141 * t530 * t5824;
  t5827 = 0.25e3 / 0.243e3 * t5826;
  t5829 = t1141 * t2478 * t1578;
  t5830 = 0.5e3 / 0.243e3 * t5829;
  t5831 = 0.175e3 / 0.162e3 * t5257;
  t5832 = 0.25e2 / 0.54e2 * t5262;
  t5833 = 0.35e2 / 0.54e2 * t5265;
  t5834 = 0.5e1 / 0.18e2 * t5269;
  t5835 = t62 * t993;
  t5836 = t5835 * t473;
  t5837 = t445 * t5836;
  t5838 = t154 * t5837;
  t5839 = 0.25e2 / 0.81e2 * t5838;
  t5840 = t388 * t1594;
  t5841 = 0.25e2 / 0.108e3 * t5840;
  t5842 = t1592 * t1602;
  t5843 = t445 * t5842;
  t5844 = t154 * t5843;
  t5845 = 0.25e2 / 0.108e3 * t5844;
  t5846 = t4756 * t4047;
  t5847 = t1838 * t5846;
  t5848 = 0.25e2 / 0.81e2 * t5847;
  t5849 = t350 * t346;
  t5850 = t194 * t5849;
  t5851 = t4760 * t5850;
  t5852 = t1838 * t5851;
  t5853 = 0.125e3 / 0.486e3 * t5852;
  t5854 = -t5806 + t5810 - t5811 - t5812 - t5815 + t5819 - t5823 - t5827 - t5830 + t5831 + t5832 - t5833 - t5834 + t5839 - t5841 - t5845 + t5848 - t5853 + t4598;
  t5855 = t4562 * t999;
  t5856 = t530 * t5855;
  t5857 = t1141 * t5856;
  t5858 = 0.5e3 / 0.729e3 * t5857;
  t5860 = t1323 * t5499 * t1584;
  t5861 = 0.125e3 / 0.486e3 * t5860;
  t5862 = t360 * t346;
  t5863 = t4610 * t5862;
  t5864 = t1843 * t5863;
  t5865 = t1336 * t5864;
  t5866 = 0.25e2 / 0.54e2 * t5865;
  t5867 = t1602 * t390;
  t5869 = t1323 * t1428 * t5867;
  t5870 = 0.25e2 / 0.162e3 * t5869;
  t5871 = t473 * t1098;
  t5872 = t1428 * t5871;
  t5873 = t1323 * t5872;
  t5874 = 0.25e2 / 0.324e3 * t5873;
  t5875 = t1550 * t1485;
  t5876 = 0.5e2 / 0.27e2 * t5875;
  t5877 = t1550 * t1489;
  t5878 = 0.5e2 / 0.27e2 * t5877;
  t5879 = t4604 * t5584;
  t5880 = 0.2e4 / 0.81e2 * t5879;
  t5881 = t464 * t5589;
  t5882 = 0.5e1 / 0.9e1 * t5881;
  t5883 = t464 * t5593;
  t5884 = 0.1e2 / 0.9e1 * t5883;
  t5885 = t464 * t5597;
  t5886 = 0.5e1 / 0.9e1 * t5885;
  t5887 = t2 * t993;
  t5888 = t5887 * t463;
  t5889 = t5888 * t436;
  t5890 = 0.2e3 / 0.81e2 * t5889;
  t5891 = t5105 * t1564;
  t5892 = 0.4e4 / 0.243e3 * t5891;
  t5893 = t5108 * t1563;
  t5894 = t1294 * t5893;
  t5895 = 0.4e4 / 0.243e3 * t5894;
  t5896 = t1410 * t1007;
  t5897 = t1295 * t5896;
  t5898 = t1294 * t5897;
  t5899 = 0.2e4 / 0.243e3 * t5898;
  t5900 = t5312 * t1554;
  t5901 = 0.25e3 / 0.81e2 * t5900;
  t5903 = t55 * t365 * t346;
  t5904 = t1396 * t5903;
  t5905 = 0.5e2 / 0.27e2 * t5904;
  t5907 = t55 * t383 * t346;
  t5908 = t1396 * t5907;
  t5909 = 0.5e2 / 0.27e2 * t5908;
  t5911 = t55 * t147 * t1003;
  t5912 = t1396 * t5911;
  t5913 = 0.25e2 / 0.27e2 * t5912;
  t5914 = -t5858 + t5861 - t5866 - t5870 - t5874 - t5876 - t5878 + t5880 + t5882 + t5884 + t5886 + t5890 + t5892 + t5895 + t5899 - t5901 + t5905 + t5909 + t5913;
  t5916 = t5766 * t4679;
  t5917 = 0.25e2 / 0.162e3 * t5916;
  t5918 = t382 * t346;
  t5919 = t1421 * t5918;
  t5920 = t1354 * t5919;
  t5921 = t1336 * t5920;
  t5922 = 0.25e2 / 0.108e3 * t5921;
  t5923 = t1410 * t5614;
  t5924 = t1338 * t5923;
  t5925 = t1336 * t5924;
  t5926 = 0.5e1 / 0.18e2 * t5925;
  t5927 = t1410 * t5619;
  t5928 = t1338 * t5927;
  t5929 = t1336 * t5928;
  t5930 = 0.5e1 / 0.36e2 * t5929;
  t5931 = t5168 * t1589;
  t5932 = 0.5e1 / 0.18e2 * t5931;
  t5933 = t5168 * t1599;
  t5934 = 0.25e2 / 0.108e3 * t5933;
  t5935 = t146 * t1003;
  t5936 = t1421 * t5935;
  t5937 = t1354 * t5936;
  t5938 = t1336 * t5937;
  t5939 = 0.25e2 / 0.216e3 * t5938;
  t5940 = t5358 * t1597;
  t5941 = t1354 * t5940;
  t5942 = t1336 * t5941;
  t5943 = 0.125e3 / 0.324e3 * t5942;
  t5944 = t146 * t999;
  t5945 = t4562 * t5944;
  t5946 = t1354 * t5945;
  t5947 = t1336 * t5946;
  t5948 = 0.25e2 / 0.324e3 * t5947;
  t5949 = t1410 * t5779;
  t5950 = t4252 * t5949;
  t5951 = t1336 * t5950;
  t5952 = 0.5e1 / 0.12e2 * t5951;
  t5953 = t5474 * t1514;
  t5954 = t1338 * t5953;
  t5955 = t1336 * t5954;
  t5956 = 0.25e2 / 0.54e2 * t5955;
  t5958 = t190 * t5734 * t468;
  t5959 = 0.5e2 / 0.81e2 * t5958;
  t5960 = t1403 * t5738;
  t5961 = 0.2e3 / 0.81e2 * t5960;
  t5962 = t1403 * t5741;
  t5963 = 0.2e3 / 0.81e2 * t5962;
  t5964 = t1403 * t5744;
  t5965 = 0.1e3 / 0.81e2 * t5964;
  t5966 = t5277 * t346;
  t5967 = t1831 * t5966;
  t5968 = t1294 * t5967;
  t5969 = 0.2e5 / 0.729e3 * t5968;
  t5971 = t190 * t5725 * t468;
  t5972 = 0.5e2 / 0.81e2 * t5971;
  t5973 = -t5917 + t5922 - t5926 - t5930 - t5932 + t5934 + t5939 - t5943 + t5948 + t5952 + t5956 + t4634 + t4637 - t5959 - t5961 - t5963 - t5965 + t5969 - t5972;
  t5975 = t190 * t5730 * t468;
  t5976 = 0.1e3 / 0.81e2 * t5975;
  t5977 = t5223 * t1480;
  t5978 = 0.1e4 / 0.243e3 * t5977;
  t5979 = 0.175e3 / 0.243e3 * t5408;
  t5980 = 0.25e2 / 0.81e2 * t5411;
  t5981 = t1626 * t382;
  t5982 = 0.2e1 * t5981;
  t5984 = params->c * t993 * t27;
  t5985 = t325 * t5984;
  t5988 = t801 * t5816;
  t5991 = t801 * t5824;
  t5999 = t27 * t1007;
  t6000 = t1463 * t5999;
  t6003 = t5887 * t27;
  t6004 = t6003 * t453;
  t6008 = t54 * t1003;
  t6009 = t152 * t6008;
  t6012 = t801 * t5855;
  t6015 = t1410 * t1012;
  t6021 = t54 * t999;
  t6022 = t152 * t6021;
  t6027 = t5354 * t1616;
  t6033 = 0.2e4 / 0.729e3 * t324 * t5985 - 0.25e4 / 0.729e3 * t190 * t5988 + 0.25e3 / 0.243e3 * t190 * t5991 + 0.1e4 / 0.243e3 * t4535 * t325 * t5820 - 0.2e4 / 0.81e2 * t478 * t5697 - 0.2e4 / 0.243e3 * t543 * t6000 - 0.2e3 / 0.81e2 * t6004 + 0.25e3 / 0.81e2 * t5316 * t1611 - 0.25e2 / 0.27e2 * t1455 * t6009 + 0.5e3 / 0.729e3 * t190 * t6012 + 0.1e5 / 0.729e3 * t2785 * t6015 * t50 - 0.1e4 / 0.243e3 * t5319 * t1534 - 0.5e2 / 0.81e2 * t4528 * t6022 + 0.1e3 / 0.81e2 * t1460 * t5701 + 0.2e5 / 0.729e3 * t543 * t6027 - 0.2e5 / 0.729e3 * t543 * t1463 * t5966;
  t6034 = t6033 * t146;
  t6035 = t27 * t1084;
  t6036 = t472 * t6035;
  t6037 = t445 * t6036;
  t6038 = t154 * t6037;
  t6039 = 0.5e1 / 0.72e2 * t6038;
  t6040 = t1090 * t475;
  t6041 = 0.5e1 / 0.72e2 * t6040;
  t6042 = t388 * t1604;
  t6043 = 0.5e1 / 0.36e2 * t6042;
  t6044 = t473 * t1021;
  t6045 = t4577 * t6044;
  t6046 = t4409 * t6045;
  t6047 = 0.25e3 / 0.243e3 * t6046;
  t6048 = t4586 * t5638;
  t6049 = t2814 * t6048;
  t6050 = 0.1e5 / 0.729e3 * t6049;
  t6051 = t484 * t1084;
  t6053 = t190 * t1496 * t1574;
  t6054 = 0.5e3 / 0.243e3 * t6053;
  t6056 = t190 * t1500 * t1574;
  t6057 = 0.5e3 / 0.243e3 * t6056;
  t6059 = t190 * t439 * t5984;
  t6060 = 0.2e4 / 0.729e3 * t6059;
  t6061 = 0.175e3 / 0.162e3 * t5504;
  t6062 = 0.25e2 / 0.54e2 * t5507;
  t6063 = 0.35e2 / 0.27e2 * t5513;
  t6064 = 0.5e1 / 0.9e1 * t5516;
  t6065 = -t5976 + t5978 + t5979 + t5980 + t5982 + t6034 + t6039 + t6041 + t6043 + t6047 - t6050 + t6051 + t6054 + t6057 - t6060 - t6061 - t6062 + t6063 + t6064;
  t6088 = -0.5e3 / 0.243e3 * t1580 + 0.1e2 / 0.9e1 * t1559 + 0.1e2 / 0.9e1 * t1561 - 0.5e2 / 0.27e2 * t1551 + 0.5e2 / 0.27e2 * t1555 + 0.4e4 / 0.243e3 * t1565 - t4783 - t4785 - 0.5e1 / 0.18e2 * t1590 - 0.25e2 / 0.108e3 * t1595 + 0.25e2 / 0.108e3 * t1600;
  tv3rho2tau5 = t9 * (t5854 + t5914 + t5973 + t6065) + 0.2e1 * t1628 + 0.2e1 * t1627 - 0.25e2 / 0.162e3 * t1586 + 0.5e1 / 0.36e2 * t1582 + 0.5e1 / 0.36e2 * t1605 - 0.2e3 / 0.81e2 * t1557 - 0.1e3 / 0.81e2 * t1568 - 0.1e3 / 0.81e2 * t1571 + 0.5e3 / 0.243e3 * t1576 + t6088;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t6090 = 0.1e1 / t32 / t562;
  t6091 = t2 * t6090;
  t6092 = t6091 * t188;
  t6093 = t6092 * t531;
  t6094 = 0.25e2 / 0.243e3 * t6093;
  t6095 = t1633 * t542;
  t6096 = t6095 * t3046;
  t6097 = 0.125e3 / 0.324e3 * t6096;
  t6098 = t1634 * t1902;
  t6099 = 0.25e2 / 0.1296e4 * t6098;
  t6100 = t1634 * t1906;
  t6101 = 0.25e2 / 0.1296e4 * t6100;
  t6102 = t56 * t56;
  t6104 = 0.1e1 / t32 / t6102;
  t6105 = t2 * t6104;
  t6106 = t6105 * t45;
  t6107 = t6106 * t1642;
  t6108 = 0.55e2 / 0.432e3 * t6107;
  t6109 = t1640 * t189;
  t6110 = t192 * t61;
  t6111 = t6110 * t62;
  t6112 = t6111 * t195;
  t6113 = t6109 * t6112;
  t6114 = 0.25e2 / 0.648e3 * t6113;
  t6115 = t1640 * t50;
  t6116 = t54 * t206;
  t6117 = t6116 * t1153;
  t6118 = t6115 * t6117;
  t6119 = 0.5e1 / 0.288e3 * t6118;
  t6120 = t55 * t1157;
  t6121 = t1641 * t6120;
  t6122 = 0.5e1 / 0.144e3 * t6121;
  t6123 = t55 * t1161;
  t6124 = t1641 * t6123;
  t6125 = 0.5e1 / 0.288e3 * t6124;
  t6126 = t2356 * t1632;
  t6128 = t6126 * t180 * t50;
  t6129 = t2814 * t6128;
  t6130 = 0.625e3 / 0.2916e4 * t6129;
  t6132 = t543 * t217 * t1645;
  t6133 = 0.125e3 / 0.972e3 * t6132;
  t6135 = t543 * t317 * t1645;
  t6136 = 0.125e3 / 0.972e3 * t6135;
  t6137 = t544 * t6090;
  t6139 = t543 * t147 * t6137;
  t6140 = 0.5e3 / 0.729e3 * t6139;
  t6141 = t542 * t1639;
  t6142 = t39 * t6141;
  t6143 = t1295 * t180;
  t6144 = t63 * t6143;
  t6145 = t6142 * t6144;
  t6146 = 0.125e3 / 0.486e3 * t6145;
  t6148 = t192 * t6104 * t61;
  t6149 = t6148 * t1651;
  t6150 = t190 * t6149;
  t6151 = 0.275e3 / 0.1944e4 * t6150;
  t6152 = t194 * t209;
  t6154 = t1141 * t1708 * t6152;
  t6155 = 0.25e2 / 0.1296e4 * t6154;
  t6156 = t3485 * params->c;
  t6157 = t1650 * t6156;
  t6158 = t190 * t6157;
  t6159 = 0.25e2 / 0.648e3 * t6158;
  t6160 = t3490 * params->c;
  t6161 = t1650 * t6160;
  t6162 = t190 * t6161;
  t6163 = 0.25e2 / 0.1296e4 * t6162;
  t6165 = t6091 * t185 * t802;
  t6166 = 0.25e2 / 0.243e3 * t6165;
  t6167 = t1633 * t539;
  t6168 = t6167 * t3087;
  t6172 = t2785 * t1632 * t180 * t50;
  t6175 = t805 * t806 * t6090;
  t6176 = 0.5e3 / 0.729e3 * t6175;
  t6177 = -t6166 - 0.125e3 / 0.324e3 * t6168 + 0.625e3 / 0.2916e4 * t6172 + t6176;
  t6178 = t6177 * t146;
  t6179 = t1661 * t316;
  t6180 = t6094 + t6097 - t6099 - t6101 - t6108 - t6114 - t6119 + t6122 + t6125 - t6130 + t6133 + t6136 - t6140 + t6146 + t6151 + t6155 - t6159 - t6163 + t6178 + t6179;
  tv3rhosigma20 = t6180 * t9 - t1636 + t1644 + t1648 - t1654 + t1662;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t6182 = 0.5e2 / 0.243e3 * t6093;
  t6183 = 0.125e3 / 0.162e3 * t6096;
  t6184 = 0.25e2 / 0.648e3 * t6098;
  t6185 = 0.25e2 / 0.648e3 * t6100;
  t6186 = 0.55e2 / 0.216e3 * t6107;
  t6187 = 0.25e2 / 0.324e3 * t6113;
  t6188 = 0.5e1 / 0.144e3 * t6118;
  t6189 = 0.5e1 / 0.72e2 * t6121;
  t6190 = 0.5e1 / 0.144e3 * t6124;
  t6191 = 0.625e3 / 0.1458e4 * t6129;
  t6192 = 0.125e3 / 0.486e3 * t6132;
  t6193 = 0.125e3 / 0.486e3 * t6135;
  t6194 = 0.1e4 / 0.729e3 * t6139;
  t6195 = 0.125e3 / 0.243e3 * t6145;
  t6196 = 0.275e3 / 0.972e3 * t6150;
  t6197 = 0.25e2 / 0.648e3 * t6154;
  t6198 = 0.25e2 / 0.324e3 * t6158;
  t6199 = 0.25e2 / 0.648e3 * t6162;
  t6200 = 0.5e2 / 0.243e3 * t6165;
  t6203 = 0.1e4 / 0.729e3 * t6175;
  t6204 = -t6200 - 0.125e3 / 0.162e3 * t6168 + 0.625e3 / 0.1458e4 * t6172 + t6203;
  t6205 = t6204 * t146;
  t6206 = t1670 * t316;
  t6207 = t6182 + t6183 - t6184 - t6185 - t6186 - t6187 - t6188 + t6189 + t6190 - t6191 + t6192 + t6193 - t6194 + t6195 + t6196 + t6197 - t6198 - t6199 + t6205 + t6206;
  tv3rhosigma21 = t6207 * t9 - t1664 + t1665 + t1666 - t1667 + t1671;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = tv3rhosigma20;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  t6209 = 0.1e3 / 0.243e3 * t6093;
  t6210 = 0.125e3 / 0.81e2 * t6096;
  t6211 = 0.25e2 / 0.324e3 * t6098;
  t6212 = 0.25e2 / 0.324e3 * t6100;
  t6213 = 0.55e2 / 0.108e3 * t6107;
  t6214 = 0.25e2 / 0.162e3 * t6113;
  t6215 = 0.5e1 / 0.72e2 * t6118;
  t6216 = 0.5e1 / 0.36e2 * t6121;
  t6217 = 0.5e1 / 0.72e2 * t6124;
  t6218 = 0.625e3 / 0.729e3 * t6129;
  t6219 = 0.125e3 / 0.243e3 * t6132;
  t6220 = 0.125e3 / 0.243e3 * t6135;
  t6221 = 0.2e4 / 0.729e3 * t6139;
  t6222 = 0.25e3 / 0.243e3 * t6145;
  t6223 = 0.275e3 / 0.486e3 * t6150;
  t6224 = 0.25e2 / 0.324e3 * t6154;
  t6225 = 0.25e2 / 0.162e3 * t6158;
  t6226 = 0.25e2 / 0.324e3 * t6162;
  t6227 = 0.1e3 / 0.243e3 * t6165;
  t6230 = 0.2e4 / 0.729e3 * t6175;
  t6231 = -t6227 - 0.125e3 / 0.81e2 * t6168 + 0.625e3 / 0.729e3 * t6172 + t6230;
  t6232 = t6231 * t146;
  t6233 = t1679 * t316;
  t6234 = t6209 + t6210 - t6211 - t6212 - t6213 - t6214 - t6215 + t6216 + t6217 - t6218 + t6219 + t6220 - t6221 + t6222 + t6223 + t6224 - t6225 - t6226 + t6232 + t6233;
  tv3rhosigma23 = t6234 * t9 - t1673 + t1674 + t1675 - t1676 + t1680;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = tv3rhosigma21;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = tv3rhosigma22;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t6236 = t147 * t853;
  t6237 = t6095 * t6236;
  t6238 = 0.125e3 / 0.324e3 * t6237;
  t6239 = t1634 * t2479;
  t6240 = 0.25e2 / 0.1296e4 * t6239;
  t6241 = t1634 * t2463;
  t6242 = 0.25e2 / 0.1296e4 * t6241;
  t6243 = t6111 * t355;
  t6244 = t6109 * t6243;
  t6245 = 0.25e2 / 0.648e3 * t6244;
  t6246 = t6116 * t1230;
  t6247 = t6115 * t6246;
  t6248 = 0.5e1 / 0.288e3 * t6247;
  t6249 = t55 * t1234;
  t6250 = t1641 * t6249;
  t6251 = 0.5e1 / 0.288e3 * t6250;
  t6253 = t6126 * t350 * t50;
  t6254 = t2814 * t6253;
  t6255 = 0.625e3 / 0.2916e4 * t6254;
  t6257 = t543 * t365 * t1645;
  t6258 = 0.125e3 / 0.972e3 * t6257;
  t6260 = t543 * t383 * t1645;
  t6261 = 0.125e3 / 0.972e3 * t6260;
  t6262 = t1295 * t350;
  t6263 = t63 * t6262;
  t6264 = t6142 * t6263;
  t6265 = 0.125e3 / 0.486e3 * t6264;
  t6266 = t194 * t360;
  t6268 = t1141 * t1708 * t6266;
  t6269 = 0.25e2 / 0.1296e4 * t6268;
  t6270 = t3794 * params->c;
  t6271 = t1650 * t6270;
  t6272 = t190 * t6271;
  t6273 = 0.25e2 / 0.1296e4 * t6272;
  t6274 = t806 * t350;
  t6275 = t6167 * t6274;
  t6277 = t1632 * t350;
  t6279 = t2785 * t6277 * t50;
  t6281 = -t6166 - 0.125e3 / 0.324e3 * t6275 + 0.625e3 / 0.2916e4 * t6279 + t6176;
  t6282 = t6281 * t146;
  t6283 = t1661 * t382;
  t6284 = t6094 + t6238 - t6240 - t6242 - t6108 - t6245 - t6248 - t6122 + t6251 - t6255 + t6258 + t6261 - t6140 + t6265 + t6151 + t6269 + t6159 - t6273 + t6282 + t6283;
  tv3rhosigma26 = t6284 * t9 - t1636 + t1644 + t1648 - t1654 + t1662;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  t6286 = 0.125e3 / 0.162e3 * t6237;
  t6287 = 0.25e2 / 0.648e3 * t6239;
  t6288 = 0.25e2 / 0.648e3 * t6241;
  t6289 = 0.25e2 / 0.324e3 * t6244;
  t6290 = 0.5e1 / 0.144e3 * t6247;
  t6291 = 0.5e1 / 0.144e3 * t6250;
  t6292 = 0.625e3 / 0.1458e4 * t6254;
  t6293 = 0.125e3 / 0.486e3 * t6257;
  t6294 = 0.125e3 / 0.486e3 * t6260;
  t6295 = 0.125e3 / 0.243e3 * t6264;
  t6296 = 0.25e2 / 0.648e3 * t6268;
  t6297 = 0.25e2 / 0.648e3 * t6272;
  t6300 = -t6200 - 0.125e3 / 0.162e3 * t6275 + 0.625e3 / 0.1458e4 * t6279 + t6203;
  t6301 = t6300 * t146;
  t6302 = t1670 * t382;
  t6303 = t6182 + t6286 - t6287 - t6288 - t6186 - t6289 - t6290 - t6189 + t6291 - t6292 + t6293 + t6294 - t6194 + t6295 + t6196 + t6296 + t6198 - t6297 + t6301 + t6302;
  tv3rhosigma27 = t6303 * t9 - t1664 + t1665 + t1666 - t1667 + t1671;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = tv3rhosigma26;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  t6305 = 0.125e3 / 0.81e2 * t6237;
  t6306 = 0.25e2 / 0.324e3 * t6239;
  t6307 = 0.25e2 / 0.324e3 * t6241;
  t6308 = 0.25e2 / 0.162e3 * t6244;
  t6309 = 0.5e1 / 0.72e2 * t6247;
  t6310 = 0.5e1 / 0.72e2 * t6250;
  t6311 = 0.625e3 / 0.729e3 * t6254;
  t6312 = 0.125e3 / 0.243e3 * t6257;
  t6313 = 0.125e3 / 0.243e3 * t6260;
  t6314 = 0.25e3 / 0.243e3 * t6264;
  t6315 = 0.25e2 / 0.324e3 * t6268;
  t6316 = 0.25e2 / 0.324e3 * t6272;
  t6319 = -t6227 - 0.125e3 / 0.81e2 * t6275 + 0.625e3 / 0.729e3 * t6279 + t6230;
  t6320 = t6319 * t146;
  t6321 = t1679 * t382;
  t6322 = t6209 + t6305 - t6306 - t6307 - t6213 - t6308 - t6309 - t6216 + t6310 - t6311 + t6312 + t6313 - t6221 + t6314 + t6223 + t6315 + t6225 - t6316 + t6320 + t6321;
  tv3rhosigma29 = t6322 * t9 - t1673 + t1674 + t1675 - t1676 + t1680;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = tv3rhosigma27;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = tv3rhosigma28;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t6324 = t15 * t35;
  t6325 = t6324 * t167;
  t6326 = t4167 * t6325;
  t6327 = t1294 * t6326;
  t6328 = 0.125e4 / 0.729e3 * t6327;
  t6329 = t4299 * t1692;
  t6330 = 0.25e3 / 0.243e3 * t6329;
  t6331 = t154 * t1357;
  t6332 = 0.25e2 / 0.216e3 * t6331;
  t6333 = t30 * t573;
  t6334 = t6333 * t62;
  t6335 = t6334 * t1340;
  t6336 = t1700 * t6335;
  t6337 = 0.5e1 / 0.288e3 * t6336;
  t6338 = t4129 * t35;
  t6339 = t1295 * t6338;
  t6340 = t1294 * t6339;
  t6341 = 0.125e4 / 0.729e3 * t6340;
  t6342 = t1296 * t177;
  t6343 = t1295 * t6342;
  t6344 = t1294 * t6343;
  t6345 = 0.2e4 / 0.729e3 * t6344;
  t6346 = t4302 * t1691;
  t6347 = t1294 * t6346;
  t6348 = 0.25e3 / 0.243e3 * t6347;
  t6349 = t4809 * t1122;
  t6350 = 0.25e3 / 0.81e2 * t6349;
  t6351 = t6104 * t206;
  t6352 = t6351 * t62;
  t6353 = t6352 * t1695;
  t6354 = t1323 * t6353;
  t6355 = 0.275e3 / 0.3888e4 * t6354;
  t6356 = t1707 * t8;
  t6357 = t6356 * t1695;
  t6358 = t1323 * t6357;
  t6359 = 0.25e2 / 0.1296e4 * t6358;
  t6360 = t4129 * t194;
  t6361 = t1708 * t6360;
  t6362 = t1323 * t6361;
  t6363 = 0.125e3 / 0.7776e4 * t6362;
  t6364 = t800 * t3502;
  t6365 = t1139 * t6364;
  t6366 = t440 * t168;
  t6367 = t409 * t6366;
  t6368 = t6365 * t6367;
  t6369 = 0.125e3 / 0.972e3 * t6368;
  t6370 = -t6328 - t6330 + t6332 + t6337 + t6341 + t6345 - t6348 - t6350 - t6355 + t6359 - t6363 + t6369;
  t6371 = t1640 * t185;
  t6372 = t6371 * t1322;
  t6373 = t4410 * t1326;
  t6374 = t6372 * t6373;
  t6375 = 0.25e2 / 0.1296e4 * t6374;
  t6376 = t1296 * t553;
  t6377 = t1708 * t6376;
  t6378 = t1323 * t6377;
  t6379 = 0.25e2 / 0.2592e4 * t6378;
  t6380 = t6365 * t6373;
  t6381 = 0.25e2 / 0.324e3 * t6380;
  t6382 = t1691 * t3863;
  t6383 = t5013 * t6382;
  t6384 = 0.125e4 / 0.729e3 * t6383;
  t6385 = t16 * t209;
  t6386 = t440 * t6385;
  t6387 = t1797 * t6386;
  t6388 = t6365 * t6387;
  t6389 = 0.25e2 / 0.324e3 * t6388;
  t6390 = t1702 * t1356;
  t6391 = t1700 * t6390;
  t6392 = 0.25e2 / 0.1728e4 * t6391;
  t6393 = t4407 * t1639;
  t6394 = t805 * t6393;
  t6395 = t447 * t1896;
  t6396 = t4410 * t6395;
  t6397 = t6394 * t6396;
  t6398 = 0.125e3 / 0.972e3 * t6397;
  t6399 = t154 * t1341;
  t6400 = 0.5e1 / 0.36e2 * t6399;
  t6401 = t3438 * t1695;
  t6402 = t1141 * t6401;
  t6403 = 0.175e3 / 0.486e3 * t6402;
  t6404 = t3442 * t1695;
  t6405 = t1141 * t6404;
  t6406 = 0.25e2 / 0.162e3 * t6405;
  t6407 = t1143 * t6360;
  t6408 = t1141 * t6407;
  t6409 = 0.125e3 / 0.972e3 * t6408;
  t6410 = t452 * t189;
  t6411 = t1152 * t326;
  t6412 = t3503 * t6411;
  t6413 = t6410 * t6412;
  t6414 = 0.25e2 / 0.162e3 * t6413;
  t6415 = t1143 * t6376;
  t6416 = t1141 * t6415;
  t6417 = 0.25e2 / 0.324e3 * t6416;
  t6418 = t6375 + t6379 - t6381 + t6384 - t6389 - t6392 - t6398 - t6400 - t6403 + t6406 - t6409 + t6414 + t6417;
  t6420 = t1296 * t316;
  t6421 = t1702 * t6420;
  t6422 = t1700 * t6421;
  t6423 = 0.5e1 / 0.576e3 * t6422;
  t6424 = t322 * t1712;
  t6425 = 0.5e1 / 0.72e2 * t6424;
  t6426 = t1354 * t6420;
  t6427 = t154 * t6426;
  t6428 = 0.5e1 / 0.72e2 * t6427;
  t6429 = t416 * t167;
  t6430 = t439 * t6429;
  t6431 = t4312 * t6430;
  t6432 = 0.125e3 / 0.486e3 * t6431;
  t6433 = t4448 * t1716;
  t6435 = t325 * t6429;
  t6436 = t4441 * t6435;
  t6438 = t4216 * t1172;
  t6441 = t800 * t801 * t177;
  t6442 = t1373 * t6441;
  t6443 = 0.1e3 / 0.243e3 * t6442;
  t6445 = t1719 * t180 * t50;
  t6446 = t5061 * t6445;
  t6449 = t543 * t4460 * t1719;
  t6451 = t1378 * t6325;
  t6452 = t543 * t6451;
  t6454 = t16 * t177;
  t6456 = t543 * t1378 * t6454;
  t6457 = 0.2e4 / 0.729e3 * t6456;
  t6458 = 0.125e3 / 0.486e3 * t6433 - 0.125e3 / 0.486e3 * t6436 + 0.25e3 / 0.81e2 * t6438 + t6443 - 0.125e4 / 0.729e3 * t6446 - 0.125e4 / 0.729e3 * t6449 + 0.125e4 / 0.729e3 * t6452 - t6457;
  t6459 = t6458 * t146;
  t6460 = t1639 * t573;
  t6461 = t6460 * t446;
  t6462 = params->c * t209;
  t6463 = t447 * t6462;
  t6464 = t6461 * t6463;
  t6465 = t1323 * t6464;
  t6466 = 0.25e2 / 0.1296e4 * t6465;
  t6467 = t1707 * t446;
  t6468 = t4226 * t4313;
  t6469 = t6467 * t6468;
  t6470 = t1323 * t6469;
  t6471 = 0.125e3 / 0.7776e4 * t6470;
  t6472 = t4345 * t1703;
  t6473 = t154 * t6472;
  t6474 = 0.5e1 / 0.36e2 * t6473;
  t6475 = t4129 * t146;
  t6476 = t1354 * t6475;
  t6477 = t154 * t6476;
  t6478 = 0.25e2 / 0.216e3 * t6477;
  t6479 = t4311 * t50;
  t6480 = t408 * t61;
  t6481 = t1152 * t167;
  t6482 = t6480 * t6481;
  t6483 = t6479 * t6482;
  t6484 = 0.25e2 / 0.216e3 * t6483;
  t6485 = t452 * t50;
  t6486 = t6485 * t1154;
  t6487 = 0.5e1 / 0.72e2 * t6486;
  t6488 = t541 * t58;
  t6489 = t6488 * t61;
  t6490 = t805 * t6489;
  t6491 = t1152 * t544;
  t6492 = t6491 * t1297;
  t6493 = t6490 * t6492;
  t6494 = 0.25e3 / 0.243e3 * t6493;
  t6495 = -t6423 + t6425 + t6428 + t6432 + t6459 - t6466 + t6471 + t6474 - t6478 - t6484 + t6487 - t6494;
  t6496 = t6105 * t40;
  t6497 = t6496 * t153;
  t6498 = t6497 * t1704;
  t6499 = 0.55e2 / 0.864e3 * t6498;
  t6500 = t1701 * t8;
  t6501 = t6500 * t1703;
  t6502 = t1700 * t6501;
  t6503 = 0.5e1 / 0.288e3 * t6502;
  t6504 = t1702 * t6475;
  t6505 = t1700 * t6504;
  t6506 = 0.25e2 / 0.1728e4 * t6505;
  t6507 = t4364 * t1703;
  t6508 = t154 * t6507;
  t6509 = 0.35e2 / 0.108e3 * t6508;
  t6510 = t1723 * t316;
  t6511 = t1280 * t1132;
  t6512 = t1279 * t6511;
  t6513 = 0.1e3 / 0.243e3 * t6512;
  t6514 = t1266 * t1685;
  t6515 = t6514 * t1688;
  t6516 = 0.25e2 / 0.216e3 * t6515;
  t6517 = t55 * t201;
  t6518 = t6517 * t409;
  t6519 = t1686 * t6518;
  t6520 = 0.35e2 / 0.108e3 * t6519;
  t6521 = t1687 * t1157;
  t6522 = t1686 * t6521;
  t6523 = 0.5e1 / 0.36e2 * t6522;
  t6524 = t4185 * t1682;
  t6525 = 0.125e3 / 0.486e3 * t6524;
  t6526 = t4188 * t403;
  t6527 = t1279 * t6526;
  t6528 = 0.25e2 / 0.162e3 * t6527;
  t6529 = t1280 * t1128;
  t6530 = t1279 * t6529;
  t6531 = 0.25e2 / 0.162e3 * t6530;
  t6532 = t1687 * t1161;
  t6533 = t1686 * t6532;
  t6534 = 0.5e1 / 0.72e2 * t6533;
  t6535 = t6499 - t6503 + t6506 - t6509 + t6510 - t6513 + t6516 + t6520 - t6523 - t6525 + t6528 + t6531 - t6534;
  tv3rhosigmatau0 = t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724 + t9 * (t6370 + t6418 + t6495 + t6535);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t6539 = t4657 * t50;
  t6540 = t1152 * t171;
  t6541 = t6480 * t6540;
  t6542 = t6539 * t6541;
  t6543 = 0.25e2 / 0.216e3 * t6542;
  t6544 = t478 * t50;
  t6545 = t6544 * t1154;
  t6546 = 0.5e1 / 0.72e2 * t6545;
  t6547 = t6491 * t1411;
  t6548 = t6490 * t6547;
  t6549 = 0.25e3 / 0.243e3 * t6548;
  t6550 = t1410 * t316;
  t6551 = t1702 * t6550;
  t6552 = t1700 * t6551;
  t6553 = 0.5e1 / 0.576e3 * t6552;
  t6554 = t416 * t171;
  t6555 = t439 * t6554;
  t6556 = t4658 * t6555;
  t6557 = 0.125e3 / 0.486e3 * t6556;
  t6558 = t4364 * t1740;
  t6559 = t154 * t6558;
  t6560 = 0.35e2 / 0.108e3 * t6559;
  t6561 = t4345 * t1740;
  t6562 = t154 * t6561;
  t6563 = 0.5e1 / 0.36e2 * t6562;
  t6564 = t6497 * t1741;
  t6565 = 0.55e2 / 0.864e3 * t6564;
  t6566 = t1403 * t6511;
  t6567 = 0.1e3 / 0.243e3 * t6566;
  t6568 = t1729 * t6518;
  t6569 = 0.35e2 / 0.108e3 * t6568;
  t6571 = t1729 * t6521;
  t6572 = 0.5e1 / 0.36e2 * t6571;
  t6573 = t26 * t35;
  t6574 = t6573 * t171;
  t6575 = t1831 * t6574;
  t6576 = t1294 * t6575;
  t6577 = 0.125e4 / 0.729e3 * t6576;
  t6578 = t1403 * t6526;
  t6579 = 0.25e2 / 0.162e3 * t6578;
  t6580 = t1403 * t6529;
  t6581 = 0.25e2 / 0.162e3 * t6580;
  t6582 = t1729 * t6532;
  t6583 = 0.5e1 / 0.72e2 * t6582;
  t6584 = t467 * t172;
  t6585 = t409 * t6584;
  t6586 = t6365 * t6585;
  t6587 = 0.125e3 / 0.972e3 * t6586;
  t6588 = t4577 * t1429;
  t6589 = t6372 * t6588;
  t6590 = 0.25e2 / 0.1296e4 * t6589;
  t6591 = t1410 * t553;
  t6592 = t1708 * t6591;
  t6593 = t1323 * t6592;
  t6594 = 0.25e2 / 0.2592e4 * t6593;
  t6595 = t6365 * t6588;
  t6596 = 0.25e2 / 0.324e3 * t6595;
  t6597 = t1732 * t3863;
  t6598 = t5013 * t6597;
  t6599 = 0.125e4 / 0.729e3 * t6598;
  t6600 = t27 * t209;
  t6601 = t467 * t6600;
  t6602 = t1797 * t6601;
  t6603 = t6365 * t6602;
  t6604 = 0.25e2 / 0.324e3 * t6603;
  t6605 = -t6572 - t6577 + t6579 + t6581 - t6583 + t6587 + t6590 + t6594 - t6596 + t6599 - t6604;
  t6607 = t6352 * t1736;
  t6608 = t1323 * t6607;
  t6609 = 0.275e3 / 0.3888e4 * t6608;
  t6610 = t6356 * t1736;
  t6611 = t1323 * t6610;
  t6612 = 0.25e2 / 0.1296e4 * t6611;
  t6613 = t6500 * t1740;
  t6614 = t1700 * t6613;
  t6615 = 0.5e1 / 0.288e3 * t6614;
  t6616 = t1410 * t177;
  t6617 = t1295 * t6616;
  t6618 = t1294 * t6617;
  t6619 = 0.2e4 / 0.729e3 * t6618;
  t6620 = t5300 * t1122;
  t6621 = 0.25e3 / 0.81e2 * t6620;
  t6622 = t4299 * t1733;
  t6623 = 0.25e3 / 0.243e3 * t6622;
  t6624 = t4302 * t1732;
  t6625 = t1294 * t6624;
  t6626 = 0.25e3 / 0.243e3 * t6625;
  t6627 = t1707 * t472;
  t6628 = t4610 * t4536;
  t6630 = t1323 * t6627 * t6628;
  t6631 = 0.125e3 / 0.7776e4 * t6630;
  t6632 = t6460 * t472;
  t6633 = t473 * t6462;
  t6635 = t1323 * t6632 * t6633;
  t6636 = 0.25e2 / 0.1296e4 * t6635;
  t6637 = t473 * t1896;
  t6638 = t4577 * t6637;
  t6639 = t6394 * t6638;
  t6640 = 0.125e3 / 0.972e3 * t6639;
  t6641 = t154 * t1437;
  t6642 = 0.5e1 / 0.36e2 * t6641;
  t6643 = -t6609 + t6612 - t6615 + t6619 - t6621 - t6623 - t6626 + t6631 - t6636 - t6640 - t6642;
  t6644 = t154 * t1447;
  t6645 = 0.25e2 / 0.216e3 * t6644;
  t6646 = t1826 * t6412;
  t6647 = 0.25e2 / 0.162e3 * t6646;
  t6649 = t1141 * t1143 * t6591;
  t6650 = 0.25e2 / 0.324e3 * t6649;
  t6651 = t6334 * t1436;
  t6652 = t1700 * t6651;
  t6653 = 0.5e1 / 0.288e3 * t6652;
  t6654 = t1702 * t1446;
  t6655 = t1700 * t6654;
  t6656 = 0.25e2 / 0.1728e4 * t6655;
  t6658 = t1141 * t3442 * t1736;
  t6659 = 0.25e2 / 0.162e3 * t6658;
  t6661 = t1141 * t3438 * t1736;
  t6662 = 0.175e3 / 0.486e3 * t6661;
  t6663 = t1756 * t316;
  t6664 = t325 * t6554;
  t6665 = t4535 * t6664;
  t6667 = t4604 * t1172;
  t6669 = t1460 * t6441;
  t6670 = 0.1e3 / 0.243e3 * t6669;
  t6672 = t1752 * t180 * t50;
  t6673 = t5342 * t6672;
  t6676 = t543 * t1463 * t6574;
  t6678 = t27 * t177;
  t6680 = t543 * t1463 * t6678;
  t6681 = 0.2e4 / 0.729e3 * t6680;
  t6682 = -0.125e3 / 0.486e3 * t6665 + 0.25e3 / 0.81e2 * t6667 + t6670 - 0.125e4 / 0.729e3 * t6673 + 0.125e4 / 0.729e3 * t6676 - t6681;
  t6683 = t6682 * t146;
  t6684 = t322 * t1747;
  t6685 = 0.5e1 / 0.72e2 * t6684;
  t6686 = t1354 * t6550;
  t6687 = t154 * t6686;
  t6688 = 0.5e1 / 0.72e2 * t6687;
  t6689 = t6645 + t6647 + t6650 + t6653 - t6656 + t6659 - t6662 + t6663 + t6683 + t6685 + t6688;
  tv3rhosigmatau1 = t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757 + t9 * (-t6543 + t6546 - t6549 - t6553 + t6557 - t6560 + t6563 + t6565 - t6567 + t6569 + t6605 + t6643 + t6689);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  t6693 = 0.25e4 / 0.729e3 * t6327;
  t6697 = 0.2e3 / 0.243e3 * t6442;
  t6701 = 0.4e4 / 0.729e3 * t6456;
  t6702 = 0.125e3 / 0.243e3 * t6433 - 0.125e3 / 0.243e3 * t6436 + 0.5e3 / 0.81e2 * t6438 + t6697 - 0.25e4 / 0.729e3 * t6446 - 0.25e4 / 0.729e3 * t6449 + 0.25e4 / 0.729e3 * t6452 - t6701;
  t6703 = t6702 * t146;
  t6704 = 0.5e3 / 0.243e3 * t6329;
  t6705 = 0.25e2 / 0.108e3 * t6331;
  t6706 = 0.5e1 / 0.144e3 * t6336;
  t6707 = 0.25e4 / 0.729e3 * t6340;
  t6708 = 0.4e4 / 0.729e3 * t6344;
  t6709 = 0.5e3 / 0.243e3 * t6347;
  t6710 = 0.5e3 / 0.81e2 * t6349;
  t6711 = 0.275e3 / 0.1944e4 * t6354;
  t6712 = 0.25e2 / 0.648e3 * t6358;
  t6713 = 0.125e3 / 0.3888e4 * t6362;
  t6714 = -t6693 + t6703 - t6704 + t6705 + t6706 + t6707 + t6708 - t6709 - t6710 - t6711 + t6712 - t6713;
  t6715 = 0.125e3 / 0.486e3 * t6368;
  t6716 = 0.25e2 / 0.648e3 * t6374;
  t6717 = 0.25e2 / 0.1296e4 * t6378;
  t6718 = 0.25e2 / 0.162e3 * t6380;
  t6719 = 0.25e4 / 0.729e3 * t6383;
  t6720 = 0.25e2 / 0.162e3 * t6388;
  t6721 = 0.25e2 / 0.864e3 * t6391;
  t6722 = 0.125e3 / 0.486e3 * t6397;
  t6723 = 0.5e1 / 0.18e2 * t6399;
  t6724 = 0.175e3 / 0.243e3 * t6402;
  t6725 = 0.25e2 / 0.81e2 * t6405;
  t6726 = 0.125e3 / 0.486e3 * t6408;
  t6727 = 0.25e2 / 0.81e2 * t6413;
  t6728 = t6715 + t6716 + t6717 - t6718 + t6719 - t6720 - t6721 - t6722 - t6723 - t6724 + t6725 - t6726 + t6727;
  t6730 = 0.25e2 / 0.162e3 * t6416;
  t6731 = 0.5e1 / 0.288e3 * t6422;
  t6732 = 0.5e1 / 0.36e2 * t6424;
  t6733 = 0.5e1 / 0.36e2 * t6427;
  t6734 = 0.125e3 / 0.243e3 * t6431;
  t6735 = 0.25e2 / 0.648e3 * t6465;
  t6736 = 0.125e3 / 0.3888e4 * t6470;
  t6737 = t1768 * t316;
  t6738 = 0.5e1 / 0.18e2 * t6473;
  t6739 = 0.25e2 / 0.108e3 * t6477;
  t6740 = 0.25e2 / 0.108e3 * t6483;
  t6741 = 0.5e1 / 0.36e2 * t6486;
  t6742 = t6730 - t6731 + t6732 + t6733 + t6734 - t6735 + t6736 + t6737 + t6738 - t6739 - t6740 + t6741;
  t6743 = 0.5e3 / 0.243e3 * t6493;
  t6744 = 0.55e2 / 0.432e3 * t6498;
  t6745 = 0.5e1 / 0.144e3 * t6502;
  t6746 = 0.25e2 / 0.864e3 * t6505;
  t6747 = 0.35e2 / 0.54e2 * t6508;
  t6748 = 0.2e3 / 0.243e3 * t6512;
  t6749 = 0.25e2 / 0.108e3 * t6515;
  t6750 = 0.35e2 / 0.54e2 * t6519;
  t6751 = 0.5e1 / 0.18e2 * t6522;
  t6752 = 0.125e3 / 0.243e3 * t6524;
  t6753 = 0.25e2 / 0.81e2 * t6527;
  t6754 = 0.25e2 / 0.81e2 * t6530;
  t6755 = 0.5e1 / 0.36e2 * t6533;
  t6756 = -t6743 + t6744 - t6745 + t6746 - t6747 - t6748 + t6749 + t6750 - t6751 - t6752 + t6753 + t6754 - t6755;
  tv3rhosigmatau2 = t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769 + t9 * (t6714 + t6728 + t6742 + t6756);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  t6760 = 0.25e2 / 0.108e3 * t6542;
  t6761 = 0.5e1 / 0.36e2 * t6545;
  t6762 = 0.5e3 / 0.243e3 * t6548;
  t6763 = 0.5e1 / 0.288e3 * t6552;
  t6764 = 0.125e3 / 0.243e3 * t6556;
  t6765 = 0.35e2 / 0.54e2 * t6559;
  t6766 = 0.5e1 / 0.18e2 * t6562;
  t6767 = 0.55e2 / 0.432e3 * t6564;
  t6768 = 0.2e3 / 0.243e3 * t6566;
  t6769 = 0.35e2 / 0.54e2 * t6568;
  t6771 = 0.5e1 / 0.18e2 * t6571;
  t6772 = 0.25e4 / 0.729e3 * t6576;
  t6773 = 0.25e2 / 0.81e2 * t6578;
  t6774 = 0.25e2 / 0.81e2 * t6580;
  t6775 = 0.5e1 / 0.36e2 * t6582;
  t6776 = 0.125e3 / 0.486e3 * t6586;
  t6777 = 0.25e2 / 0.648e3 * t6589;
  t6778 = 0.25e2 / 0.1296e4 * t6593;
  t6779 = 0.25e2 / 0.162e3 * t6595;
  t6780 = 0.25e4 / 0.729e3 * t6598;
  t6781 = 0.25e2 / 0.162e3 * t6603;
  t6782 = -t6771 - t6772 + t6773 + t6774 - t6775 + t6776 + t6777 + t6778 - t6779 + t6780 - t6781;
  t6784 = 0.275e3 / 0.1944e4 * t6608;
  t6785 = 0.25e2 / 0.648e3 * t6611;
  t6786 = 0.5e1 / 0.144e3 * t6614;
  t6787 = 0.4e4 / 0.729e3 * t6618;
  t6788 = 0.5e3 / 0.81e2 * t6620;
  t6789 = 0.5e3 / 0.243e3 * t6622;
  t6790 = 0.5e3 / 0.243e3 * t6625;
  t6791 = t1780 * t316;
  t6792 = 0.125e3 / 0.3888e4 * t6630;
  t6793 = 0.25e2 / 0.648e3 * t6635;
  t6794 = 0.125e3 / 0.486e3 * t6639;
  t6795 = -t6784 + t6785 - t6786 + t6787 - t6788 - t6789 - t6790 + t6791 + t6792 - t6793 - t6794;
  t6796 = 0.5e1 / 0.18e2 * t6641;
  t6797 = 0.25e2 / 0.108e3 * t6644;
  t6798 = 0.25e2 / 0.81e2 * t6646;
  t6799 = 0.25e2 / 0.162e3 * t6649;
  t6800 = 0.5e1 / 0.144e3 * t6652;
  t6801 = 0.25e2 / 0.864e3 * t6655;
  t6802 = 0.25e2 / 0.81e2 * t6658;
  t6803 = 0.175e3 / 0.243e3 * t6661;
  t6806 = 0.2e3 / 0.243e3 * t6669;
  t6809 = 0.4e4 / 0.729e3 * t6680;
  t6810 = -0.125e3 / 0.243e3 * t6665 + 0.5e3 / 0.81e2 * t6667 + t6806 - 0.25e4 / 0.729e3 * t6673 + 0.25e4 / 0.729e3 * t6676 - t6809;
  t6811 = t6810 * t146;
  t6812 = 0.5e1 / 0.36e2 * t6684;
  t6813 = 0.5e1 / 0.36e2 * t6687;
  t6814 = -t6796 + t6797 + t6798 + t6799 + t6800 - t6801 + t6802 - t6803 + t6811 + t6812 + t6813;
  tv3rhosigmatau3 = t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781 + t9 * (-t6760 + t6761 - t6762 - t6763 + t6764 - t6765 + t6766 + t6767 - t6768 + t6769 + t6782 + t6795 + t6814);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = tv3rhosigmatau0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = tv3rhosigmatau1;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t6818 = t154 * t1521;
  t6819 = 0.25e2 / 0.216e3 * t6818;
  t6820 = t1702 * t1520;
  t6821 = t1700 * t6820;
  t6822 = 0.25e2 / 0.1728e4 * t6821;
  t6823 = t447 * t853;
  t6824 = t4410 * t6823;
  t6825 = t6394 * t6824;
  t6826 = 0.125e3 / 0.972e3 * t6825;
  t6827 = t154 * t1516;
  t6828 = 0.5e1 / 0.36e2 * t6827;
  t6829 = t902 * t1296;
  t6830 = t1143 * t6829;
  t6831 = t1141 * t6830;
  t6832 = 0.25e2 / 0.324e3 * t6831;
  t6833 = t6334 * t1515;
  t6834 = t1700 * t6833;
  t6835 = 0.5e1 / 0.288e3 * t6834;
  t6836 = t1152 * t390;
  t6837 = t3503 * t6836;
  t6838 = t6410 * t6837;
  t6839 = 0.25e2 / 0.162e3 * t6838;
  t6840 = t1723 * t382;
  t6841 = t6491 * t1492;
  t6842 = t6490 * t6841;
  t6843 = 0.25e3 / 0.243e3 * t6842;
  t6844 = t1296 * t382;
  t6845 = t1702 * t6844;
  t6846 = t1700 * t6845;
  t6847 = 0.5e1 / 0.576e3 * t6846;
  t6849 = t388 * t1712;
  t6850 = 0.5e1 / 0.72e2 * t6849;
  t6851 = t1354 * t6844;
  t6852 = t154 * t6851;
  t6853 = 0.5e1 / 0.72e2 * t6852;
  t6854 = t416 * t336;
  t6855 = t439 * t6854;
  t6856 = t4312 * t6855;
  t6857 = 0.125e3 / 0.486e3 * t6856;
  t6858 = t1152 * t336;
  t6859 = t6480 * t6858;
  t6860 = t6479 * t6859;
  t6861 = 0.25e2 / 0.216e3 * t6860;
  t6862 = t6485 * t1231;
  t6863 = 0.5e1 / 0.72e2 * t6862;
  t6864 = t325 * t6854;
  t6865 = t4441 * t6864;
  t6867 = t4216 * t1241;
  t6869 = t1719 * t350;
  t6870 = t6869 * t50;
  t6871 = t5061 * t6870;
  t6873 = t6324 * t336;
  t6874 = t1378 * t6873;
  t6875 = t543 * t6874;
  t6877 = -0.125e3 / 0.486e3 * t6865 + 0.25e3 / 0.81e2 * t6867 + t6443 - 0.125e4 / 0.729e3 * t6871 + 0.125e4 / 0.729e3 * t6875 - t6457;
  t6878 = t6877 * t146;
  t6879 = t6850 + t6853 + t6857 - t6861 + t6863 + t6345 - t6355 - t6359 - t6403 - t6406 + t6878;
  t6881 = t4410 * t1510;
  t6882 = t6365 * t6881;
  t6883 = 0.25e2 / 0.324e3 * t6882;
  t6884 = t16 * t360;
  t6885 = t440 * t6884;
  t6886 = t1797 * t6885;
  t6887 = t6365 * t6886;
  t6888 = 0.25e2 / 0.324e3 * t6887;
  t6889 = t440 * t337;
  t6890 = t409 * t6889;
  t6891 = t6365 * t6890;
  t6892 = 0.125e3 / 0.972e3 * t6891;
  t6893 = t4167 * t6873;
  t6894 = t1294 * t6893;
  t6895 = 0.125e4 / 0.729e3 * t6894;
  t6896 = t4883 * t403;
  t6897 = t1279 * t6896;
  t6898 = 0.25e2 / 0.162e3 * t6897;
  t6899 = t1280 * t1220;
  t6900 = t1279 * t6899;
  t6901 = 0.25e2 / 0.162e3 * t6900;
  t6902 = t1687 * t1234;
  t6903 = t1686 * t6902;
  t6904 = 0.5e1 / 0.72e2 * t6903;
  t6905 = t4809 * t1214;
  t6906 = 0.25e3 / 0.81e2 * t6905;
  t6907 = t5105 * t1692;
  t6908 = 0.25e3 / 0.243e3 * t6907;
  t6909 = t5108 * t1691;
  t6910 = t1294 * t6909;
  t6911 = 0.25e3 / 0.243e3 * t6910;
  t6912 = t6372 * t6881;
  t6913 = 0.25e2 / 0.1296e4 * t6912;
  t6914 = -t6883 - t6888 + t6892 - t6895 + t6898 + t6901 - t6904 - t6906 - t6908 - t6911 + t6913;
  t6915 = t1708 * t6829;
  t6916 = t1323 * t6915;
  t6917 = 0.25e2 / 0.2592e4 * t6916;
  t6919 = t350 * t40 * t152;
  t6920 = t1691 * t6919;
  t6921 = t5013 * t6920;
  t6922 = 0.125e4 / 0.729e3 * t6921;
  t6923 = t4226 * t5037;
  t6924 = t6467 * t6923;
  t6925 = t1323 * t6924;
  t6926 = 0.125e3 / 0.7776e4 * t6925;
  t6927 = params->c * t360;
  t6928 = t447 * t6927;
  t6929 = t6461 * t6928;
  t6930 = t1323 * t6929;
  t6931 = 0.25e2 / 0.1296e4 * t6930;
  t6932 = t6917 + t6922 - t6474 + t6499 + t6503 - t6509 + t6926 - t6931 - t6513 + t6520 + t6523;
  tv3rhosigmatau6 = t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724 + t9 * (t6819 - t6822 - t6826 - t6828 + t6832 + t6835 + t6839 + t6840 - t6843 - t6847 + t6879 + t6914 + t6932);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  t6936 = t1410 * t902;
  t6937 = t1708 * t6936;
  t6938 = t1323 * t6937;
  t6939 = 0.25e2 / 0.2592e4 * t6938;
  t6940 = t4577 * t1584;
  t6941 = t6365 * t6940;
  t6942 = 0.25e2 / 0.324e3 * t6941;
  t6943 = t1732 * t6919;
  t6944 = t5013 * t6943;
  t6945 = 0.125e4 / 0.729e3 * t6944;
  t6946 = -t6560 - t6563 + t6565 - t6567 + t6569 + t6572 + t6939 - t6942 + t6945 - t6609 - t6612 + t6615;
  t6947 = t416 * t346;
  t6948 = t439 * t6947;
  t6949 = t4658 * t6948;
  t6950 = 0.125e3 / 0.486e3 * t6949;
  t6951 = t1152 * t346;
  t6952 = t6480 * t6951;
  t6953 = t6539 * t6952;
  t6954 = 0.25e2 / 0.216e3 * t6953;
  t6955 = t6544 * t1231;
  t6956 = 0.5e1 / 0.72e2 * t6955;
  t6957 = t6491 * t1563;
  t6958 = t6490 * t6957;
  t6959 = 0.25e3 / 0.243e3 * t6958;
  t6960 = t4610 * t5326;
  t6961 = t6627 * t6960;
  t6962 = t1323 * t6961;
  t6963 = 0.125e3 / 0.7776e4 * t6962;
  t6964 = t1702 * t1598;
  t6965 = t1700 * t6964;
  t6966 = 0.25e2 / 0.1728e4 * t6965;
  t6967 = t473 * t853;
  t6968 = t4577 * t6967;
  t6969 = t6394 * t6968;
  t6970 = 0.125e3 / 0.972e3 * t6969;
  t6971 = t154 * t1589;
  t6972 = 0.5e1 / 0.36e2 * t6971;
  t6973 = t1826 * t6837;
  t6974 = 0.25e2 / 0.162e3 * t6973;
  t6976 = t1141 * t1143 * t6936;
  t6977 = 0.25e2 / 0.324e3 * t6976;
  t6978 = t6950 - t6954 + t6956 - t6959 + t6963 + t6619 - t6659 - t6662 - t6966 - t6970 - t6972 + t6974 + t6977;
  t6980 = t1756 * t382;
  t6981 = t5474 * t146;
  t6982 = t1354 * t6981;
  t6983 = t154 * t6982;
  t6984 = 0.25e2 / 0.216e3 * t6983;
  t6985 = t1702 * t6981;
  t6986 = t1700 * t6985;
  t6987 = 0.25e2 / 0.1728e4 * t6986;
  t6988 = t194 * t5474;
  t6990 = t1141 * t1143 * t6988;
  t6991 = 0.125e3 / 0.972e3 * t6990;
  t6992 = t154 * t1599;
  t6993 = 0.25e2 / 0.216e3 * t6992;
  t6994 = t6334 * t1588;
  t6995 = t1700 * t6994;
  t6996 = 0.5e1 / 0.288e3 * t6995;
  t6997 = t1410 * t382;
  t6998 = t1702 * t6997;
  t6999 = t1700 * t6998;
  t7000 = 0.5e1 / 0.576e3 * t6999;
  t7001 = t388 * t1747;
  t7002 = 0.5e1 / 0.72e2 * t7001;
  t7003 = t1354 * t6997;
  t7004 = t154 * t7003;
  t7005 = 0.5e1 / 0.72e2 * t7004;
  t7006 = t5223 * t1682;
  t7007 = 0.125e3 / 0.486e3 * t7006;
  t7008 = t1549 * t1728;
  t7009 = t7008 * t1688;
  t7010 = 0.25e2 / 0.216e3 * t7009;
  t7011 = t1403 * t6896;
  t7012 = 0.25e2 / 0.162e3 * t7011;
  t7013 = t6980 - t6984 + t6987 - t6991 + t6993 + t6996 - t7000 + t7002 + t7005 - t7007 + t7010 + t7012;
  t7014 = t1403 * t6899;
  t7015 = 0.25e2 / 0.162e3 * t7014;
  t7016 = t1729 * t6902;
  t7017 = 0.5e1 / 0.72e2 * t7016;
  t7018 = t6573 * t346;
  t7019 = t1831 * t7018;
  t7020 = t1294 * t7019;
  t7021 = 0.125e4 / 0.729e3 * t7020;
  t7022 = t27 * t360;
  t7023 = t467 * t7022;
  t7024 = t1797 * t7023;
  t7025 = t6365 * t7024;
  t7026 = 0.25e2 / 0.324e3 * t7025;
  t7027 = t467 * t347;
  t7028 = t409 * t7027;
  t7029 = t6365 * t7028;
  t7030 = 0.125e3 / 0.972e3 * t7029;
  t7031 = t6372 * t6940;
  t7032 = 0.25e2 / 0.1296e4 * t7031;
  t7033 = t1708 * t6988;
  t7034 = t1323 * t7033;
  t7035 = 0.125e3 / 0.7776e4 * t7034;
  t7036 = t5319 * t1716;
  t7038 = t325 * t6947;
  t7039 = t4535 * t7038;
  t7041 = t4604 * t1241;
  t7043 = t1752 * t350;
  t7044 = t7043 * t50;
  t7045 = t5342 * t7044;
  t7048 = t543 * t5354 * t1752;
  t7051 = t543 * t1463 * t7018;
  t7053 = 0.125e3 / 0.486e3 * t7036 - 0.125e3 / 0.486e3 * t7039 + 0.25e3 / 0.81e2 * t7041 + t6670 - 0.125e4 / 0.729e3 * t7045 - 0.125e4 / 0.729e3 * t7048 + 0.125e4 / 0.729e3 * t7051 - t6681;
  t7054 = t7053 * t146;
  t7055 = t473 * t6927;
  t7056 = t6632 * t7055;
  t7057 = t1323 * t7056;
  t7058 = 0.25e2 / 0.1296e4 * t7057;
  t7059 = t5474 * t35;
  t7060 = t1295 * t7059;
  t7061 = t1294 * t7060;
  t7062 = 0.125e4 / 0.729e3 * t7061;
  t7063 = t5105 * t1733;
  t7064 = 0.25e3 / 0.243e3 * t7063;
  t7065 = t5108 * t1732;
  t7066 = t1294 * t7065;
  t7067 = 0.25e3 / 0.243e3 * t7066;
  t7068 = t5300 * t1214;
  t7069 = 0.25e3 / 0.81e2 * t7068;
  t7070 = t7015 - t7017 - t7021 - t7026 + t7030 + t7032 - t7035 + t7054 - t7058 + t7062 - t7064 - t7067 - t7069;
  tv3rhosigmatau7 = t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757 + t9 * (t6946 + t6978 + t7013 + t7070);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  t7074 = 0.25e2 / 0.108e3 * t6818;
  t7075 = 0.25e2 / 0.864e3 * t6821;
  t7076 = 0.125e3 / 0.486e3 * t6825;
  t7077 = 0.5e1 / 0.18e2 * t6827;
  t7078 = 0.25e2 / 0.162e3 * t6831;
  t7079 = 0.5e1 / 0.144e3 * t6834;
  t7080 = 0.25e2 / 0.81e2 * t6838;
  t7081 = 0.5e3 / 0.243e3 * t6842;
  t7082 = 0.5e1 / 0.288e3 * t6846;
  t7083 = 0.5e1 / 0.36e2 * t6849;
  t7085 = 0.5e1 / 0.36e2 * t6852;
  t7086 = 0.125e3 / 0.243e3 * t6856;
  t7087 = 0.25e2 / 0.108e3 * t6860;
  t7088 = 0.5e1 / 0.36e2 * t6862;
  t7089 = 0.25e2 / 0.162e3 * t6882;
  t7090 = 0.25e2 / 0.162e3 * t6887;
  t7091 = t7085 + t7086 - t7087 + t7088 + t6708 - t6711 - t6712 - t6724 - t6725 - t7089 - t7090;
  t7093 = 0.125e3 / 0.486e3 * t6891;
  t7094 = 0.25e4 / 0.729e3 * t6894;
  t7095 = 0.25e2 / 0.81e2 * t6897;
  t7096 = 0.25e2 / 0.81e2 * t6900;
  t7097 = 0.5e1 / 0.36e2 * t6903;
  t7098 = 0.5e3 / 0.81e2 * t6905;
  t7099 = 0.5e3 / 0.243e3 * t6907;
  t7100 = 0.5e3 / 0.243e3 * t6910;
  t7101 = 0.25e2 / 0.648e3 * t6912;
  t7102 = 0.25e2 / 0.1296e4 * t6916;
  t7103 = 0.25e4 / 0.729e3 * t6921;
  t7104 = t7093 - t7094 + t7095 + t7096 - t7097 - t7098 - t7099 - t7100 + t7101 + t7102 + t7103;
  t7109 = -0.125e3 / 0.243e3 * t6865 + 0.5e3 / 0.81e2 * t6867 + t6697 - 0.25e4 / 0.729e3 * t6871 + 0.25e4 / 0.729e3 * t6875 - t6701;
  t7110 = t7109 * t146;
  t7111 = t1768 * t382;
  t7112 = 0.125e3 / 0.3888e4 * t6925;
  t7113 = 0.25e2 / 0.648e3 * t6930;
  t7114 = -t6738 + t6744 + t6745 - t6747 + t7110 + t7111 + t7112 - t7113 - t6748 + t6750 + t6751;
  tv3rhosigmatau8 = t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769 + t9 * (t7074 - t7075 - t7076 - t7077 + t7078 + t7079 + t7080 - t7081 - t7082 + t7083 + t7091 + t7104 + t7114);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  t7118 = 0.25e2 / 0.1296e4 * t6938;
  t7119 = 0.25e2 / 0.162e3 * t6941;
  t7120 = 0.25e4 / 0.729e3 * t6944;
  t7121 = -t6765 - t6766 + t6767 - t6768 + t6769 + t6771 + t7118 - t7119 + t7120 - t6784 - t6785 + t6786;
  t7122 = 0.125e3 / 0.243e3 * t6949;
  t7123 = 0.25e2 / 0.108e3 * t6953;
  t7124 = 0.5e1 / 0.36e2 * t6955;
  t7125 = 0.5e3 / 0.243e3 * t6958;
  t7126 = 0.125e3 / 0.3888e4 * t6962;
  t7127 = 0.25e2 / 0.864e3 * t6965;
  t7128 = 0.125e3 / 0.486e3 * t6969;
  t7129 = 0.5e1 / 0.18e2 * t6971;
  t7130 = 0.25e2 / 0.81e2 * t6973;
  t7131 = 0.25e2 / 0.162e3 * t6976;
  t7132 = t7122 - t7123 + t7124 - t7125 + t7126 + t6787 - t6802 - t6803 - t7127 - t7128 - t7129 + t7130 + t7131;
  t7134 = t1780 * t382;
  t7141 = 0.125e3 / 0.243e3 * t7036 - 0.125e3 / 0.243e3 * t7039 + 0.5e3 / 0.81e2 * t7041 + t6806 - 0.25e4 / 0.729e3 * t7045 - 0.25e4 / 0.729e3 * t7048 + 0.25e4 / 0.729e3 * t7051 - t6809;
  t7142 = t7141 * t146;
  t7143 = 0.25e2 / 0.108e3 * t6983;
  t7144 = 0.25e2 / 0.864e3 * t6986;
  t7145 = 0.125e3 / 0.486e3 * t6990;
  t7146 = 0.25e2 / 0.108e3 * t6992;
  t7147 = 0.5e1 / 0.144e3 * t6995;
  t7148 = 0.5e1 / 0.288e3 * t6999;
  t7149 = 0.5e1 / 0.36e2 * t7001;
  t7150 = 0.5e1 / 0.36e2 * t7004;
  t7151 = 0.125e3 / 0.243e3 * t7006;
  t7152 = 0.25e2 / 0.108e3 * t7009;
  t7153 = t7134 + t7142 - t7143 + t7144 - t7145 + t7146 + t7147 - t7148 + t7149 + t7150 - t7151 + t7152;
  t7154 = 0.25e2 / 0.81e2 * t7011;
  t7155 = 0.25e2 / 0.81e2 * t7014;
  t7156 = 0.5e1 / 0.36e2 * t7016;
  t7157 = 0.25e4 / 0.729e3 * t7020;
  t7158 = 0.25e2 / 0.162e3 * t7025;
  t7159 = 0.125e3 / 0.486e3 * t7029;
  t7160 = 0.25e2 / 0.648e3 * t7031;
  t7161 = 0.125e3 / 0.3888e4 * t7034;
  t7162 = 0.25e2 / 0.648e3 * t7057;
  t7163 = 0.25e4 / 0.729e3 * t7061;
  t7164 = 0.5e3 / 0.243e3 * t7063;
  t7165 = 0.5e3 / 0.243e3 * t7066;
  t7166 = 0.5e3 / 0.81e2 * t7068;
  t7167 = t7154 + t7155 - t7156 - t7157 - t7158 + t7159 + t7160 - t7161 - t7162 + t7163 - t7164 - t7165 - t7166;
  tv3rhosigmatau9 = t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781 + t9 * (t7121 + t7132 + t7153 + t7167);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = tv3rhosigmatau6;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = tv3rhosigmatau7;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t7171 = t1823 * t316;
  t7173 = 0.1e1 / t3 / t2283;
  t7174 = t2 * t7173;
  t7175 = t7174 * t1790;
  t7176 = t7175 * t531;
  t7177 = 0.1e4 / 0.243e3 * t7176;
  t7178 = t1791 * t1906;
  t7179 = 0.1e3 / 0.81e2 * t7178;
  t7180 = t14 * t1786;
  t7181 = t1784 * t7180;
  t7182 = t7181 * t167;
  t7183 = t1295 * t7182;
  t7184 = t1294 * t7183;
  t7185 = 0.2e5 / 0.729e3 * t7184;
  t7186 = t1791 * t1902;
  t7187 = 0.1e3 / 0.81e2 * t7186;
  t7191 = t7180 * t185;
  t7192 = t1785 * t7191;
  t7194 = t800 * t801 * t167;
  t7197 = t542 * t1896;
  t7201 = t1806 * t180 * t50;
  t7204 = t7173 * t1788;
  t7205 = t806 * t7204;
  t7208 = t7180 * t167;
  t7212 = -0.1e4 / 0.243e3 * t7174 * t1789 * t802 + 0.1e4 / 0.243e3 * t7192 * t7194 - 0.2e4 / 0.81e2 * t1794 * t7197 + 0.1e5 / 0.729e3 * t2785 * t7201 + 0.2e5 / 0.729e3 * t805 * t7205 - 0.2e5 / 0.729e3 * t543 * t1801 * t7208;
  t7213 = t7212 * t146;
  t7214 = t8 * t1784;
  t7215 = t7214 * t1812;
  t7216 = t878 * t7215;
  t7217 = t154 * t7216;
  t7218 = 0.5e1 / 0.18e2 * t7217;
  t7219 = t62 * t7173;
  t7220 = t7219 * t1812;
  t7221 = t878 * t7220;
  t7222 = t154 * t7221;
  t7223 = 0.25e2 / 0.54e2 * t7222;
  t7224 = t2616 * t1813;
  t7225 = t154 * t7224;
  t7226 = 0.35e2 / 0.54e2 * t7225;
  t7227 = t1788 * t316;
  t7228 = t1811 * t7227;
  t7229 = t878 * t7228;
  t7230 = t154 * t7229;
  t7231 = 0.5e1 / 0.36e2 * t7230;
  t7232 = t1785 * t7180;
  t7233 = t7232 * t50;
  t7234 = t207 * t1355;
  t7235 = t1796 * t7234;
  t7236 = t7233 * t7235;
  t7237 = 0.25e2 / 0.54e2 * t7236;
  t7238 = t574 * t1339;
  t7239 = t1796 * t7238;
  t7240 = t1795 * t7239;
  t7241 = 0.5e1 / 0.18e2 * t7240;
  t7243 = t2356 * t1784 * t1788;
  t7244 = t7243 * t3863;
  t7245 = t2814 * t7244;
  t7246 = 0.1e5 / 0.729e3 * t7245;
  t7247 = t207 * t1784;
  t7248 = t1812 * t1896;
  t7249 = t7247 * t7248;
  t7250 = t4409 * t7249;
  t7251 = 0.5e3 / 0.243e3 * t7250;
  t7252 = t4364 * t1807;
  t7253 = t1323 * t7252;
  t7254 = 0.175e3 / 0.243e3 * t7253;
  t7255 = t4345 * t1807;
  t7256 = t1323 * t7255;
  t7257 = 0.25e2 / 0.81e2 * t7256;
  t7258 = t7204 * t194;
  t7259 = t1354 * t7258;
  t7260 = t1323 * t7259;
  t7261 = 0.125e3 / 0.243e3 * t7260;
  t7262 = t7171 + t7177 - t7179 + t7185 - t7187 + t7213 - t7218 + t7223 + t7226 - t7231 + t7237 - t7241 - t7246 + t7251 + t7254 - t7257 + t7261;
  t7263 = t1324 * t1811;
  t7264 = t7180 * t146;
  t7265 = t7264 * t4313;
  t7266 = t7263 * t7265;
  t7267 = t1323 * t7266;
  t7268 = 0.125e3 / 0.243e3 * t7267;
  t7269 = t1337 * t1811;
  t7270 = t1812 * t326;
  t7271 = t7269 * t7270;
  t7272 = t1323 * t7271;
  t7273 = 0.25e2 / 0.162e3 * t7272;
  t7274 = t1812 * t6462;
  t7275 = t7269 * t7274;
  t7276 = t1323 * t7275;
  t7277 = 0.25e2 / 0.81e2 * t7276;
  t7278 = t544 * t7173;
  t7279 = t7278 * t1788;
  t7280 = t147 * t7279;
  t7281 = t543 * t7280;
  t7282 = 0.2e5 / 0.729e3 * t7281;
  t7283 = t1788 * t539;
  t7284 = t1785 * t7283;
  t7285 = t2372 * t6143;
  t7286 = t7284 * t7285;
  t7287 = 0.2e4 / 0.81e2 * t7286;
  t7288 = t217 * t1802;
  t7289 = t543 * t7288;
  t7290 = 0.2e4 / 0.243e3 * t7289;
  t7291 = t317 * t1802;
  t7292 = t543 * t7291;
  t7293 = 0.2e4 / 0.243e3 * t7292;
  t7294 = t7174 * t1788;
  t7295 = t7294 * t50;
  t7296 = t7295 * t1798;
  t7297 = 0.25e2 / 0.54e2 * t7296;
  t7298 = t1334 * t201;
  t7299 = t7298 * t1797;
  t7300 = t1795 * t7299;
  t7301 = 0.35e2 / 0.54e2 * t7300;
  t7302 = t579 * t146;
  t7303 = t1796 * t7302;
  t7304 = t1795 * t7303;
  t7305 = 0.5e1 / 0.18e2 * t7304;
  t7306 = t207 * t316;
  t7307 = t1796 * t7306;
  t7308 = t1795 * t7307;
  t7309 = 0.5e1 / 0.36e2 * t7308;
  t7310 = t1806 * t1339;
  t7311 = t4252 * t7310;
  t7312 = t1336 * t7311;
  t7313 = 0.5e1 / 0.12e2 * t7312;
  t7314 = t7181 * t1355;
  t7315 = t1338 * t7314;
  t7316 = t1336 * t7315;
  t7317 = 0.25e2 / 0.54e2 * t7316;
  t7318 = t188 * t325;
  t7319 = t1794 * t7318;
  t7320 = t445 * t6411;
  t7321 = t7319 * t7320;
  t7322 = 0.25e2 / 0.81e2 * t7321;
  t7323 = t1806 * t553;
  t7324 = t1354 * t7323;
  t7325 = t1323 * t7324;
  t7326 = 0.25e2 / 0.162e3 * t7325;
  t7327 = t7191 * t187;
  t7328 = t1785 * t7327;
  t7329 = t194 * t167;
  t7330 = t1280 * t7329;
  t7331 = t7328 * t7330;
  t7332 = 0.1e4 / 0.243e3 * t7331;
  t7333 = t322 * t1814;
  t7334 = 0.5e1 / 0.36e2 * t7333;
  t7335 = -t7268 + t7273 + t7277 - t7282 + t7287 + t7290 + t7293 - t7297 - t7301 + t7305 + t7309 + t7313 - t7317 - t7322 - t7326 - t7332 - t7334;
  tv3rhotau20 = -t1793 + t1800 + t1805 - t1810 - t1816 + t1824 + t9 * (t7262 + t7335);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t7338 = t1337 * t1440;
  t7339 = t7338 * t1844;
  t7340 = t1336 * t7339;
  t7341 = 0.5e1 / 0.18e2 * t7340;
  t7342 = t473 * t4129;
  t7343 = t1843 * t7342;
  t7344 = t1336 * t7343;
  t7345 = 0.25e2 / 0.108e3 * t7344;
  t7346 = t4357 * t472;
  t7347 = t7346 * t1844;
  t7348 = t1336 * t7347;
  t7349 = 0.35e2 / 0.54e2 * t7348;
  t7350 = t1450 * t1296;
  t7351 = t1843 * t7350;
  t7352 = t1336 * t7351;
  t7353 = 0.5e1 / 0.36e2 * t7352;
  t7354 = t59 * t574;
  t7355 = t7354 * t1340;
  t7356 = t479 * t7355;
  t7357 = 0.5e1 / 0.18e2 * t7356;
  t7358 = t59 * t207;
  t7359 = t7358 * t1356;
  t7360 = t479 * t7359;
  t7361 = 0.25e2 / 0.108e3 * t7360;
  t7362 = t1410 * t1296;
  t7363 = t7362 * t3863;
  t7364 = t5013 * t7363;
  t7365 = 0.1e5 / 0.729e3 * t7364;
  t7366 = t448 * t1465;
  t7367 = t5174 * t7366;
  t7368 = 0.5e3 / 0.243e3 * t7367;
  t7369 = t4240 * t1845;
  t7370 = 0.5e1 / 0.36e2 * t7369;
  t7371 = t4657 * t453;
  t7372 = t1296 * t1445;
  t7373 = t7358 * t7372;
  t7374 = t7371 * t7373;
  t7375 = 0.25e2 / 0.108e3 * t7374;
  t7376 = t146 * t6;
  t7377 = t16 * params->c;
  t7378 = t7377 * t180;
  t7379 = t7376 * t7378;
  t7380 = t4756 * t7379;
  t7381 = t1838 * t7380;
  t7382 = 0.25e2 / 0.162e3 * t7381;
  t7383 = t325 * params->c;
  t7384 = t1296 * t171;
  t7385 = t7383 * t7384;
  t7388 = t806 * t1297;
  t7393 = t7383 * t1315;
  t7396 = t1833 * t3863;
  t7399 = t39 * t2349;
  t7404 = t27 * t160 * t16;
  t7411 = 0.5e3 / 0.243e3 * t4535 * t7385 - 0.2e4 / 0.81e2 * t4604 * t7388 - 0.5e3 / 0.243e3 * t1403 * t1383 + 0.5e3 / 0.243e3 * t1403 * t7393 + 0.1e5 / 0.729e3 * t5342 * t7396 - 0.1e5 / 0.729e3 * t7399 * t1421 * t7384 + 0.1e5 / 0.729e3 * t543 * t1463 * t7404 - 0.1e5 / 0.729e3 * t7399 * t1410 * t1315;
  t7412 = t7411 * t146;
  t7413 = t1853 * t316;
  t7414 = t1826 * t1311;
  t7415 = 0.5e3 / 0.243e3 * t7414;
  t7416 = t1826 * t1302;
  t7417 = 0.1e3 / 0.81e2 * t7416;
  t7418 = t1826 * t1306;
  t7419 = 0.1e3 / 0.81e2 * t7418;
  t7421 = t805 * t2372 * t146;
  t7422 = t1463 * t26;
  t7423 = t7422 * t7384;
  t7424 = t7421 * t7423;
  t7425 = 0.1e5 / 0.729e3 * t7424;
  t7426 = t1463 * t27;
  t7427 = t7426 * t1315;
  t7428 = t7421 * t7427;
  t7429 = 0.1e5 / 0.729e3 * t7428;
  t7430 = t1410 * t167;
  t7431 = t194 * t7430;
  t7432 = t4492 * t7431;
  t7433 = t1838 * t7432;
  t7434 = 0.125e3 / 0.486e3 * t7433;
  t7435 = -t7341 + t7345 + t7349 - t7353 - t7357 + t7361 - t7365 + t7368 - t7370 + t7375 + t7382 + t7412 + t7413 + t7415 - t7417 - t7419 + t7425 + t7429 - t7434;
  t7436 = t194 * t1422;
  t7437 = t1839 * t7436;
  t7438 = t1838 * t7437;
  t7439 = 0.125e3 / 0.486e3 * t7438;
  t7440 = t4302 * t21;
  t7441 = t7440 * t1833;
  t7442 = t1294 * t7441;
  t7443 = 0.2e4 / 0.243e3 * t7442;
  t7444 = t1831 * t7404;
  t7445 = t1294 * t7444;
  t7446 = 0.1e5 / 0.729e3 * t7445;
  t7447 = t4299 * t1834;
  t7448 = 0.2e4 / 0.243e3 * t7447;
  t7449 = t207 * t4129;
  t7450 = t7449 * t1736;
  t7451 = t1838 * t7450;
  t7452 = 0.125e3 / 0.486e3 * t7451;
  t7453 = t55 * t59;
  t7454 = t46 * t7453;
  t7455 = t2264 * t1410;
  t7456 = t7455 * t1340;
  t7457 = t7454 * t7456;
  t7458 = 0.5e1 / 0.12e2 * t7457;
  t7459 = t147 * t544;
  t7460 = t7459 * t1297;
  t7461 = t5300 * t7460;
  t7462 = 0.2e4 / 0.81e2 * t7461;
  t7463 = t574 * t1421;
  t7464 = t7463 * t7372;
  t7465 = t7454 * t7464;
  t7466 = 0.25e2 / 0.108e3 * t7465;
  t7467 = t4756 * t1356;
  t7468 = t7454 * t7467;
  t7469 = 0.25e2 / 0.108e3 * t7468;
  t7470 = t1460 * t1322;
  t7471 = t7470 * t1327;
  t7472 = 0.25e2 / 0.81e2 * t7471;
  t7473 = t1839 * t6591;
  t7474 = t1838 * t7473;
  t7475 = 0.25e2 / 0.162e3 * t7474;
  t7477 = t324 * t325 * t202;
  t7478 = t7477 * t1840;
  t7479 = 0.175e3 / 0.243e3 * t7478;
  t7480 = t579 * t1296;
  t7481 = t7480 * t1736;
  t7482 = t1838 * t7481;
  t7483 = 0.25e2 / 0.81e2 * t7482;
  t7484 = t479 * t1362;
  t7485 = 0.5e1 / 0.36e2 * t7484;
  t7486 = t479 * t1331;
  t7487 = 0.35e2 / 0.54e2 * t7486;
  t7488 = t479 * t1346;
  t7489 = 0.5e1 / 0.18e2 * t7488;
  t7490 = t479 * t1351;
  t7491 = 0.25e2 / 0.108e3 * t7490;
  t7492 = t439 * t6366;
  t7493 = t1826 * t7492;
  t7494 = 0.5e3 / 0.243e3 * t7493;
  t7495 = t16 * t171;
  t7496 = t440 * t7495;
  t7497 = t439 * t7496;
  t7498 = t4658 * t7497;
  t7499 = 0.5e3 / 0.243e3 * t7498;
  t7500 = t1410 * t209;
  t7501 = t194 * t7500;
  t7502 = t4488 * t7501;
  t7503 = t1838 * t7502;
  t7504 = 0.25e2 / 0.81e2 * t7503;
  t7505 = -t7439 + t7443 - t7446 + t7448 + t7452 + t7458 + t7462 - t7466 - t7469 - t7472 - t7475 + t7479 - t7483 + t7485 - t7487 + t7489 - t7491 - t7494 - t7499 + t7504;
  tv3rhotau21 = -t1828 + t1830 + t1836 - t1842 - t1847 + t1854 + t9 * (t7435 + t7505);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t7508 = t1324 * t1881;
  t7509 = t25 * t1859;
  t7510 = t7509 * t146;
  t7511 = t7510 * t4536;
  t7513 = t1323 * t7508 * t7511;
  t7514 = 0.125e3 / 0.243e3 * t7513;
  t7515 = t1337 * t1881;
  t7516 = t1882 * t326;
  t7517 = t7515 * t7516;
  t7518 = t1323 * t7517;
  t7519 = 0.25e2 / 0.162e3 * t7518;
  t7520 = t1882 * t6462;
  t7522 = t1323 * t7515 * t7520;
  t7523 = 0.25e2 / 0.81e2 * t7522;
  t7524 = t1861 * t539;
  t7525 = t1858 * t7524;
  t7526 = t7525 * t7285;
  t7527 = 0.2e4 / 0.81e2 * t7526;
  t7529 = t543 * t217 * t1872;
  t7530 = 0.2e4 / 0.243e3 * t7529;
  t7532 = t543 * t317 * t1872;
  t7533 = 0.2e4 / 0.243e3 * t7532;
  t7534 = t1868 * t7307;
  t7535 = 0.5e1 / 0.36e2 * t7534;
  t7536 = t1868 * t7299;
  t7537 = 0.35e2 / 0.54e2 * t7536;
  t7538 = t1868 * t7303;
  t7539 = 0.5e1 / 0.18e2 * t7538;
  t7540 = t7509 * t185;
  t7541 = t1858 * t7540;
  t7543 = t800 * t801 * t171;
  t7552 = t7509 * t171;
  t7553 = t1871 * t7552;
  t7556 = 0.1e4 / 0.243e3 * t7541 * t7543 - 0.2e4 / 0.81e2 * t1867 * t7197 + 0.1e5 / 0.729e3 * t2785 * t1876 * t180 * t50 - 0.2e5 / 0.729e3 * t543 * t7553;
  t7557 = t7556 * t146;
  t7558 = t1857 * t7509;
  t7559 = t7558 * t171;
  t7560 = t1295 * t7559;
  t7561 = t1294 * t7560;
  t7562 = 0.2e5 / 0.729e3 * t7561;
  t7563 = t1864 * t1902;
  t7564 = 0.1e3 / 0.81e2 * t7563;
  t7565 = t1864 * t1906;
  t7566 = 0.1e3 / 0.81e2 * t7565;
  t7567 = t1876 * t1339;
  t7568 = t4252 * t7567;
  t7569 = t1336 * t7568;
  t7570 = 0.5e1 / 0.12e2 * t7569;
  t7571 = -t7514 + t7519 + t7523 + t7527 + t7530 + t7533 + t7535 - t7537 + t7539 + t7557 + t7562 - t7564 - t7566 + t7570;
  t7572 = t7558 * t1445;
  t7573 = t1338 * t7572;
  t7574 = t1336 * t7573;
  t7575 = 0.25e2 / 0.54e2 * t7574;
  t7576 = t1867 * t7318;
  t7577 = t7576 * t7320;
  t7578 = 0.25e2 / 0.81e2 * t7577;
  t7579 = t1876 * t553;
  t7580 = t1354 * t7579;
  t7581 = t1323 * t7580;
  t7582 = 0.25e2 / 0.162e3 * t7581;
  t7583 = t4345 * t1877;
  t7584 = t1323 * t7583;
  t7585 = 0.25e2 / 0.81e2 * t7584;
  t7586 = t4364 * t1877;
  t7587 = t1323 * t7586;
  t7588 = 0.175e3 / 0.243e3 * t7587;
  t7589 = t7540 * t187;
  t7590 = t1858 * t7589;
  t7591 = t194 * t171;
  t7592 = t1280 * t7591;
  t7593 = t7590 * t7592;
  t7594 = 0.1e4 / 0.243e3 * t7593;
  t7595 = t1893 * t316;
  t7596 = t207 * t1857;
  t7597 = t1882 * t1896;
  t7598 = t7596 * t7597;
  t7599 = t4409 * t7598;
  t7600 = 0.5e3 / 0.243e3 * t7599;
  t7601 = t322 * t1884;
  t7602 = 0.5e1 / 0.36e2 * t7601;
  t7603 = t1861 * t316;
  t7604 = t1881 * t7603;
  t7605 = t878 * t7604;
  t7606 = t154 * t7605;
  t7607 = 0.5e1 / 0.36e2 * t7606;
  t7608 = t1858 * t7509;
  t7609 = t7608 * t50;
  t7610 = t207 * t1445;
  t7611 = t1796 * t7610;
  t7612 = t7609 * t7611;
  t7613 = 0.25e2 / 0.54e2 * t7612;
  t7614 = t2616 * t1883;
  t7615 = t154 * t7614;
  t7616 = 0.35e2 / 0.54e2 * t7615;
  t7617 = t8 * t1857;
  t7618 = t7617 * t1882;
  t7619 = t878 * t7618;
  t7620 = t154 * t7619;
  t7621 = 0.5e1 / 0.18e2 * t7620;
  t7622 = t1868 * t7239;
  t7623 = 0.5e1 / 0.18e2 * t7622;
  t7624 = t2356 * t1857;
  t7625 = t7624 * t1861;
  t7626 = t7625 * t3863;
  t7627 = t2814 * t7626;
  t7628 = 0.1e5 / 0.729e3 * t7627;
  t7629 = -t7575 - t7578 - t7582 - t7585 + t7588 - t7594 + t7595 + t7600 - t7602 - t7607 + t7613 + t7616 - t7621 - t7623 - t7628;
  tv3rhotau22 = -t1866 + t1870 + t1875 - t1880 - t1886 + t1894 + t9 * (t7571 + t7629);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t7632 = t1806 * t902;
  t7633 = t1354 * t7632;
  t7634 = t1323 * t7633;
  t7635 = 0.25e2 / 0.162e3 * t7634;
  t7636 = t1806 * t1514;
  t7637 = t4252 * t7636;
  t7638 = t1336 * t7637;
  t7639 = 0.5e1 / 0.12e2 * t7638;
  t7640 = t1812 * t6927;
  t7641 = t7269 * t7640;
  t7642 = t1323 * t7641;
  t7643 = 0.25e2 / 0.81e2 * t7642;
  t7644 = t7264 * t5037;
  t7645 = t7263 * t7644;
  t7646 = t1323 * t7645;
  t7647 = 0.125e3 / 0.243e3 * t7646;
  t7648 = t1812 * t390;
  t7649 = t7269 * t7648;
  t7650 = t1323 * t7649;
  t7651 = 0.25e2 / 0.162e3 * t7650;
  t7652 = t445 * t6836;
  t7653 = t7319 * t7652;
  t7654 = 0.25e2 / 0.81e2 * t7653;
  t7655 = t7181 * t1519;
  t7656 = t1338 * t7655;
  t7657 = t1336 * t7656;
  t7658 = 0.25e2 / 0.54e2 * t7657;
  t7659 = t207 * t382;
  t7660 = t1796 * t7659;
  t7661 = t1795 * t7660;
  t7662 = 0.5e1 / 0.36e2 * t7661;
  t7663 = t1791 * t2479;
  t7664 = 0.1e3 / 0.81e2 * t7663;
  t7665 = t1791 * t2463;
  t7666 = 0.1e3 / 0.81e2 * t7665;
  t7667 = -t7635 + t7639 + t7643 - t7647 + t7651 + t7218 + t7226 + t7254 + t7257 - t7654 - t7658 + t7662 - t7664 - t7666;
  t7668 = t194 * t336;
  t7669 = t1280 * t7668;
  t7670 = t7328 * t7669;
  t7671 = 0.1e4 / 0.243e3 * t7670;
  t7672 = t2372 * t6262;
  t7673 = t7284 * t7672;
  t7674 = 0.2e4 / 0.81e2 * t7673;
  t7675 = t365 * t1802;
  t7676 = t543 * t7675;
  t7677 = 0.2e4 / 0.243e3 * t7676;
  t7678 = t383 * t1802;
  t7679 = t543 * t7678;
  t7680 = 0.2e4 / 0.243e3 * t7679;
  t7681 = t207 * t1519;
  t7682 = t1796 * t7681;
  t7683 = t7233 * t7682;
  t7684 = 0.25e2 / 0.54e2 * t7683;
  t7685 = t574 * t1514;
  t7686 = t1796 * t7685;
  t7687 = t1795 * t7686;
  t7688 = 0.5e1 / 0.18e2 * t7687;
  t7689 = t7243 * t6919;
  t7690 = t2814 * t7689;
  t7691 = 0.1e5 / 0.729e3 * t7690;
  t7692 = t1812 * t853;
  t7693 = t7247 * t7692;
  t7694 = t4409 * t7693;
  t7695 = 0.5e3 / 0.243e3 * t7694;
  t7696 = t388 * t1814;
  t7697 = 0.5e1 / 0.36e2 * t7696;
  t7698 = t1788 * t382;
  t7699 = t1811 * t7698;
  t7700 = t878 * t7699;
  t7701 = t154 * t7700;
  t7702 = 0.5e1 / 0.36e2 * t7701;
  t7703 = t7181 * t336;
  t7704 = t1295 * t7703;
  t7705 = t1294 * t7704;
  t7706 = 0.2e5 / 0.729e3 * t7705;
  t7708 = t800 * t801 * t336;
  t7711 = t542 * t853;
  t7714 = t1806 * t350;
  t7715 = t7714 * t50;
  t7718 = t7180 * t336;
  t7722 = 0.1e4 / 0.243e3 * t7192 * t7708 - 0.2e4 / 0.81e2 * t1794 * t7711 + 0.1e5 / 0.729e3 * t2785 * t7715 - 0.2e5 / 0.729e3 * t543 * t1801 * t7718;
  t7723 = t7722 * t146;
  t7724 = t1823 * t382;
  t7725 = -t7301 - t7305 - t7671 + t7674 + t7677 + t7680 + t7684 - t7688 - t7691 + t7695 - t7697 - t7702 + t7706 + t7723 + t7724;
  tv3rhotau23 = -t1793 + t1800 + t1805 - t1810 - t1816 + t1824 + t9 * (t7667 + t7725);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  t7728 = t1608 * t449;
  t7729 = 0.25e2 / 0.108e3 * t7728;
  t7730 = t479 * t1526;
  t7731 = 0.5e1 / 0.36e2 * t7730;
  t7732 = t439 * t6889;
  t7733 = t1826 * t7732;
  t7734 = 0.5e3 / 0.243e3 * t7733;
  t7735 = t16 * t346;
  t7736 = t440 * t7735;
  t7737 = t439 * t7736;
  t7738 = t4658 * t7737;
  t7739 = 0.5e3 / 0.243e3 * t7738;
  t7740 = t1839 * t6936;
  t7741 = t1838 * t7740;
  t7742 = 0.25e2 / 0.162e3 * t7741;
  t7743 = t7455 * t1515;
  t7744 = t7454 * t7743;
  t7745 = 0.5e1 / 0.12e2 * t7744;
  t7746 = t1839 * t6988;
  t7747 = t1838 * t7746;
  t7748 = 0.125e3 / 0.486e3 * t7747;
  t7749 = t1337 * t1592;
  t7750 = t7749 * t1844;
  t7751 = t1336 * t7750;
  t7752 = 0.25e2 / 0.108e3 * t7751;
  t7753 = t7358 * t1520;
  t7754 = t479 * t7753;
  t7755 = 0.25e2 / 0.108e3 * t7754;
  t7756 = t7362 * t6919;
  t7757 = t5013 * t7756;
  t7758 = 0.1e5 / 0.729e3 * t7757;
  t7759 = t448 * t1617;
  t7760 = t5174 * t7759;
  t7761 = 0.5e3 / 0.243e3 * t7760;
  t7762 = t5168 * t1845;
  t7763 = 0.5e1 / 0.36e2 * t7762;
  t7764 = t1602 * t1296;
  t7765 = t1843 * t7764;
  t7766 = t1336 * t7765;
  t7767 = 0.5e1 / 0.36e2 * t7766;
  t7768 = t1296 * t1597;
  t7769 = t7358 * t7768;
  t7770 = t7371 * t7769;
  t7771 = 0.25e2 / 0.108e3 * t7770;
  t7772 = t7354 * t1515;
  t7773 = t479 * t7772;
  t7774 = 0.5e1 / 0.18e2 * t7773;
  t7775 = t1607 * t189;
  t7776 = t7775 * t442;
  t7777 = 0.5e3 / 0.243e3 * t7776;
  t7778 = t1410 * t336;
  t7779 = t194 * t7778;
  t7780 = t4492 * t7779;
  t7781 = t1838 * t7780;
  t7782 = 0.125e3 / 0.486e3 * t7781;
  t7783 = -t7729 + t7731 + t7341 + t7349 - t7734 - t7739 - t7742 + t7745 + t7748 + t7752 + t7755 - t7758 + t7761 - t7763 - t7767 + t7771 - t7774 + t7777 - t7782;
  t7784 = t194 * t1578;
  t7785 = t1839 * t7784;
  t7786 = t1838 * t7785;
  t7787 = 0.125e3 / 0.486e3 * t7786;
  t7788 = t7377 * t350;
  t7789 = t7376 * t7788;
  t7790 = t4756 * t7789;
  t7791 = t1838 * t7790;
  t7792 = 0.25e2 / 0.162e3 * t7791;
  t7793 = t1410 * t360;
  t7794 = t194 * t7793;
  t7795 = t4488 * t7794;
  t7796 = t1838 * t7795;
  t7797 = 0.25e2 / 0.81e2 * t7796;
  t7798 = t7463 * t7768;
  t7799 = t7454 * t7798;
  t7800 = 0.25e2 / 0.108e3 * t7799;
  t7801 = t4756 * t1520;
  t7802 = t7454 * t7801;
  t7803 = 0.25e2 / 0.108e3 * t7802;
  t7804 = t7470 * t1511;
  t7805 = 0.25e2 / 0.81e2 * t7804;
  t7806 = t5105 * t1834;
  t7807 = 0.2e4 / 0.243e3 * t7806;
  t7808 = t5108 * t21;
  t7809 = t7808 * t1833;
  t7810 = t1294 * t7809;
  t7811 = 0.2e4 / 0.243e3 * t7810;
  t7812 = t7459 * t1492;
  t7813 = t5300 * t7812;
  t7814 = 0.2e4 / 0.81e2 * t7813;
  t7815 = t1295 * t342;
  t7816 = t7815 * t1833;
  t7817 = t1294 * t7816;
  t7818 = 0.1e5 / 0.729e3 * t7817;
  t7821 = t1296 * t346;
  t7822 = t7383 * t7821;
  t7825 = t806 * t1492;
  t7828 = t7383 * t1504;
  t7831 = t1833 * t6919;
  t7843 = -0.5e3 / 0.243e3 * t5223 * t456 + 0.5e3 / 0.243e3 * t4535 * t7822 - 0.2e4 / 0.81e2 * t4604 * t7825 + 0.5e3 / 0.243e3 * t1403 * t7828 + 0.1e5 / 0.729e3 * t5342 * t7831 + 0.1e5 / 0.729e3 * t543 * t5354 * t1833 - 0.1e5 / 0.729e3 * t7399 * t1421 * t7821 - 0.1e5 / 0.729e3 * t7399 * t1410 * t1504;
  t7844 = t7843 * t146;
  t7845 = t1853 * t382;
  t7846 = t1826 * t1501;
  t7847 = 0.1e3 / 0.81e2 * t7846;
  t7848 = t7422 * t7821;
  t7849 = t7421 * t7848;
  t7850 = 0.1e5 / 0.729e3 * t7849;
  t7851 = t7426 * t1504;
  t7852 = t7421 * t7851;
  t7853 = 0.1e5 / 0.729e3 * t7852;
  t7854 = t1826 * t1497;
  t7855 = 0.1e3 / 0.81e2 * t7854;
  t7856 = -t7787 + t7792 + t7797 - t7800 - t7803 - t7805 + t7807 + t7811 + t7814 - t7818 + t7844 + t7479 + t7483 + t7845 - t7487 - t7489 - t7847 + t7850 + t7853 - t7855;
  tv3rhotau24 = -t1828 + t1830 + t1836 - t1842 - t1847 + t1854 + t9 * (t7783 + t7856);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t7859 = t388 * t1884;
  t7860 = 0.5e1 / 0.36e2 * t7859;
  t7861 = t1861 * t382;
  t7862 = t1881 * t7861;
  t7863 = t878 * t7862;
  t7864 = t154 * t7863;
  t7865 = 0.5e1 / 0.36e2 * t7864;
  t7866 = t207 * t1597;
  t7867 = t1796 * t7866;
  t7868 = t7609 * t7867;
  t7869 = 0.25e2 / 0.54e2 * t7868;
  t7871 = 0.1e1 / t18 / t3250;
  t7872 = t62 * t7871;
  t7873 = t7872 * t1882;
  t7874 = t878 * t7873;
  t7875 = t154 * t7874;
  t7876 = 0.25e2 / 0.54e2 * t7875;
  t7877 = t1868 * t7686;
  t7878 = 0.5e1 / 0.18e2 * t7877;
  t7879 = t7625 * t6919;
  t7880 = t2814 * t7879;
  t7881 = 0.1e5 / 0.729e3 * t7880;
  t7882 = t1882 * t853;
  t7883 = t7596 * t7882;
  t7884 = t4409 * t7883;
  t7885 = 0.5e3 / 0.243e3 * t7884;
  t7886 = t1882 * t6927;
  t7888 = t1323 * t7515 * t7886;
  t7889 = 0.25e2 / 0.81e2 * t7888;
  t7890 = t7510 * t5326;
  t7892 = t1323 * t7508 * t7890;
  t7893 = 0.125e3 / 0.243e3 * t7892;
  t7894 = t1882 * t390;
  t7896 = t1323 * t7515 * t7894;
  t7897 = 0.25e2 / 0.162e3 * t7896;
  t7898 = t1893 * t382;
  t7899 = t2 * t7871;
  t7904 = t800 * t801 * t346;
  t7909 = t1876 * t350;
  t7913 = t7871 * t1861;
  t7917 = t7509 * t346;
  t7918 = t1871 * t7917;
  t7921 = -0.1e4 / 0.243e3 * t7899 * t1862 * t802 + 0.1e4 / 0.243e3 * t7541 * t7904 - 0.2e4 / 0.81e2 * t1867 * t7711 + 0.1e5 / 0.729e3 * t2785 * t7909 * t50 + 0.2e5 / 0.729e3 * t805 * t806 * t7913 - 0.2e5 / 0.729e3 * t543 * t7918;
  t7922 = t7921 * t146;
  t7923 = t7913 * t194;
  t7924 = t1354 * t7923;
  t7925 = t1323 * t7924;
  t7926 = 0.125e3 / 0.243e3 * t7925;
  t7927 = -t7860 - t7865 + t7869 + t7876 - t7878 - t7881 + t7885 + t7889 - t7893 + t7897 - t7537 - t7539 + t7898 + t7922 + t7926 + t7585 + t7588;
  t7928 = t194 * t346;
  t7929 = t1280 * t7928;
  t7930 = t7590 * t7929;
  t7931 = 0.1e4 / 0.243e3 * t7930;
  t7932 = t7576 * t7652;
  t7933 = 0.25e2 / 0.81e2 * t7932;
  t7934 = t7558 * t1597;
  t7935 = t1338 * t7934;
  t7936 = t1336 * t7935;
  t7937 = 0.25e2 / 0.54e2 * t7936;
  t7938 = t1876 * t902;
  t7939 = t1354 * t7938;
  t7940 = t1323 * t7939;
  t7941 = 0.25e2 / 0.162e3 * t7940;
  t7942 = t1876 * t1514;
  t7943 = t4252 * t7942;
  t7944 = t1336 * t7943;
  t7945 = 0.5e1 / 0.12e2 * t7944;
  t7946 = t544 * t7871;
  t7947 = t7946 * t1861;
  t7948 = t147 * t7947;
  t7949 = t543 * t7948;
  t7950 = 0.2e5 / 0.729e3 * t7949;
  t7952 = t543 * t365 * t1872;
  t7953 = 0.2e4 / 0.243e3 * t7952;
  t7955 = t543 * t383 * t1872;
  t7956 = 0.2e4 / 0.243e3 * t7955;
  t7957 = t7525 * t7672;
  t7958 = 0.2e4 / 0.81e2 * t7957;
  t7959 = t1864 * t2463;
  t7960 = 0.1e3 / 0.81e2 * t7959;
  t7961 = t7558 * t346;
  t7962 = t1295 * t7961;
  t7963 = t1294 * t7962;
  t7964 = 0.2e5 / 0.729e3 * t7963;
  t7965 = t7899 * t1863;
  t7966 = t7965 * t531;
  t7967 = 0.1e4 / 0.243e3 * t7966;
  t7968 = t1864 * t2479;
  t7969 = 0.1e3 / 0.81e2 * t7968;
  t7970 = t7899 * t1861;
  t7971 = t7970 * t50;
  t7972 = t7971 * t1798;
  t7973 = 0.25e2 / 0.54e2 * t7972;
  t7974 = t1868 * t7660;
  t7975 = 0.5e1 / 0.36e2 * t7974;
  t7976 = -t7931 - t7933 - t7937 - t7941 + t7945 - t7950 + t7953 + t7956 + t7958 - t7960 + t7964 + t7967 + t7616 + t7621 - t7969 - t7973 + t7975;
  tv3rhotau25 = -t1866 + t1870 + t1875 - t1880 - t1886 + t1894 + t9 * (t7927 + t7976);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t7979 = 0.1e1 / t6102;
  t7980 = t2 * t7979;
  t7981 = t7980 * t539;
  t7982 = t7981 * t2373;
  t7983 = 0.125e3 / 0.2592e4 * t7982;
  t7984 = t6102 * t31;
  t7985 = 0.1e1 / t7984;
  t7986 = t2 * t7985;
  t7987 = t7986 * t189;
  t7988 = t6110 * t1651;
  t7989 = t7987 * t7988;
  t7990 = 0.25e2 / 0.3456e4 * t7989;
  t7992 = t2429 * t7979 * t50;
  t7993 = t2428 * t7992;
  t7994 = 0.625e3 / 0.23328e5 * t7993;
  t7995 = t7985 * t61;
  t7996 = t7995 * t6491;
  t7997 = t543 * t7996;
  t7998 = 0.125e3 / 0.2592e4 * t7997;
  t7999 = t7980 * t2349;
  t8002 = t2356 * t7979 * t50;
  t8003 = t2355 * t8002;
  t8005 = 0.125e3 / 0.2592e4 * t7999 - 0.625e3 / 0.23328e5 * t8003;
  t8006 = t8005 * t146;
  tv3sigma30 = t9 * (-t7983 + t7990 + t7994 - t7998 + t8006);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t8008 = 0.125e3 / 0.1296e4 * t7982;
  t8009 = 0.25e2 / 0.1728e4 * t7989;
  t8010 = 0.625e3 / 0.11664e5 * t7993;
  t8011 = 0.125e3 / 0.1296e4 * t7997;
  t8014 = 0.125e3 / 0.1296e4 * t7999 - 0.625e3 / 0.11664e5 * t8003;
  t8015 = t8014 * t146;
  tv3sigma31 = t9 * (-t8008 + t8009 + t8010 - t8011 + t8015);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = tv3sigma30;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  t8017 = 0.125e3 / 0.648e3 * t7982;
  t8018 = 0.25e2 / 0.864e3 * t7989;
  t8019 = 0.625e3 / 0.5832e4 * t7993;
  t8020 = 0.125e3 / 0.648e3 * t7997;
  t8023 = 0.125e3 / 0.648e3 * t7999 - 0.625e3 / 0.5832e4 * t8003;
  t8024 = t8023 * t146;
  tv3sigma33 = t9 * (-t8017 + t8018 + t8019 - t8020 + t8024);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = tv3sigma31;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = tv3sigma32;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  t8026 = 0.125e3 / 0.324e3 * t7982;
  t8027 = 0.25e2 / 0.432e3 * t7989;
  t8028 = 0.625e3 / 0.2916e4 * t7993;
  t8029 = 0.125e3 / 0.324e3 * t7997;
  t8032 = 0.125e3 / 0.324e3 * t7999 - 0.625e3 / 0.2916e4 * t8003;
  t8033 = t8032 * t146;
  tv3sigma36 = t9 * (-t8026 + t8027 + t8028 - t8029 + t8033);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = tv3sigma33;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = tv3sigma34;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = tv3sigma35;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t8035 = t1295 * t1632;
  t8036 = t2372 * t8035;
  t8037 = t4216 * t8036;
  t8038 = 0.125e3 / 0.324e3 * t8037;
  t8039 = t6410 * t1652;
  t8040 = 0.25e2 / 0.648e3 * t8039;
  t8042 = t1632 * t40 * t152;
  t8043 = t4419 * t8042;
  t8044 = t2814 * t8043;
  t8045 = 0.625e3 / 0.2916e4 * t8044;
  t8046 = t1378 * t16;
  t8047 = t409 * t8046;
  t8048 = t6142 * t8047;
  t8049 = 0.125e3 / 0.486e3 * t8048;
  t8050 = t7986 * t185;
  t8051 = t8050 * t1140;
  t8052 = t1702 * t1695;
  t8053 = t8051 * t8052;
  t8054 = 0.25e2 / 0.10368e5 * t8053;
  t8055 = t6116 * t62;
  t8056 = t8055 * t1703;
  t8057 = t6115 * t8056;
  t8058 = 0.5e1 / 0.288e3 * t8057;
  t8060 = t805 * t4407 * t7985;
  t8061 = t447 * t544;
  t8062 = t4410 * t8061;
  t8063 = t8060 * t8062;
  t8064 = 0.125e3 / 0.7776e4 * t8063;
  t8065 = t1141 * t1709;
  t8066 = 0.25e2 / 0.1296e4 * t8065;
  t8067 = t542 * t1645;
  t8068 = t452 * t8067;
  t8070 = t1296 * t1632;
  t8071 = t8070 * t50;
  t8072 = t2785 * t8071;
  t8074 = -0.125e3 / 0.324e3 * t8068 + 0.625e3 / 0.2916e4 * t8072;
  t8075 = t8074 * t146;
  tv3sigma2tau0 = t9 * (t8038 - t8040 - t8045 + t8049 - t8054 - t8058 + t8064 + t8066 + t8075);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t8077 = t4604 * t8036;
  t8078 = 0.125e3 / 0.324e3 * t8077;
  t8079 = t1826 * t1652;
  t8080 = 0.25e2 / 0.648e3 * t8079;
  t8081 = t4586 * t8042;
  t8082 = t2814 * t8081;
  t8083 = 0.625e3 / 0.2916e4 * t8082;
  t8084 = t409 * t7426;
  t8085 = t6142 * t8084;
  t8086 = 0.125e3 / 0.486e3 * t8085;
  t8087 = t1702 * t1736;
  t8088 = t8051 * t8087;
  t8089 = 0.25e2 / 0.10368e5 * t8088;
  t8090 = t8055 * t1740;
  t8091 = t6115 * t8090;
  t8092 = 0.5e1 / 0.288e3 * t8091;
  t8093 = t473 * t544;
  t8094 = t4577 * t8093;
  t8095 = t8060 * t8094;
  t8096 = 0.125e3 / 0.7776e4 * t8095;
  t8097 = t1141 * t1744;
  t8098 = 0.25e2 / 0.1296e4 * t8097;
  t8099 = t478 * t8067;
  t8101 = t1410 * t1632;
  t8103 = t2785 * t8101 * t50;
  t8105 = -0.125e3 / 0.324e3 * t8099 + 0.625e3 / 0.2916e4 * t8103;
  t8106 = t8105 * t146;
  tv3sigma2tau1 = t9 * (t8078 - t8080 - t8083 + t8086 - t8089 - t8092 + t8096 + t8098 + t8106);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  t8108 = 0.125e3 / 0.162e3 * t8037;
  t8109 = 0.25e2 / 0.324e3 * t8039;
  t8110 = 0.625e3 / 0.1458e4 * t8044;
  t8111 = 0.125e3 / 0.243e3 * t8048;
  t8112 = 0.25e2 / 0.5184e4 * t8053;
  t8113 = 0.5e1 / 0.144e3 * t8057;
  t8114 = 0.125e3 / 0.3888e4 * t8063;
  t8115 = 0.25e2 / 0.648e3 * t8065;
  t8118 = -0.125e3 / 0.162e3 * t8068 + 0.625e3 / 0.1458e4 * t8072;
  t8119 = t8118 * t146;
  tv3sigma2tau2 = t9 * (t8108 - t8109 - t8110 + t8111 - t8112 - t8113 + t8114 + t8115 + t8119);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  t8121 = 0.125e3 / 0.162e3 * t8077;
  t8122 = 0.25e2 / 0.324e3 * t8079;
  t8123 = 0.625e3 / 0.1458e4 * t8082;
  t8124 = 0.125e3 / 0.243e3 * t8085;
  t8125 = 0.25e2 / 0.5184e4 * t8088;
  t8126 = 0.5e1 / 0.144e3 * t8091;
  t8127 = 0.125e3 / 0.3888e4 * t8095;
  t8128 = 0.25e2 / 0.648e3 * t8097;
  t8131 = -0.125e3 / 0.162e3 * t8099 + 0.625e3 / 0.1458e4 * t8103;
  t8132 = t8131 * t146;
  tv3sigma2tau3 = t9 * (t8121 - t8122 - t8123 + t8124 - t8125 - t8126 + t8127 + t8128 + t8132);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = tv3sigma2tau0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = tv3sigma2tau1;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  t8134 = 0.125e3 / 0.81e2 * t8037;
  t8135 = 0.25e2 / 0.162e3 * t8039;
  t8136 = 0.625e3 / 0.729e3 * t8044;
  t8137 = 0.25e3 / 0.243e3 * t8048;
  t8138 = 0.25e2 / 0.2592e4 * t8053;
  t8139 = 0.5e1 / 0.72e2 * t8057;
  t8140 = 0.125e3 / 0.1944e4 * t8063;
  t8141 = 0.25e2 / 0.324e3 * t8065;
  t8144 = -0.125e3 / 0.81e2 * t8068 + 0.625e3 / 0.729e3 * t8072;
  t8145 = t8144 * t146;
  tv3sigma2tau6 = t9 * (t8134 - t8135 - t8136 + t8137 - t8138 - t8139 + t8140 + t8141 + t8145);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  t8147 = 0.125e3 / 0.81e2 * t8077;
  t8148 = 0.25e2 / 0.162e3 * t8079;
  t8149 = 0.625e3 / 0.729e3 * t8082;
  t8150 = 0.25e3 / 0.243e3 * t8085;
  t8151 = 0.25e2 / 0.2592e4 * t8088;
  t8152 = 0.5e1 / 0.72e2 * t8091;
  t8153 = 0.125e3 / 0.1944e4 * t8095;
  t8154 = 0.25e2 / 0.324e3 * t8097;
  t8157 = -0.125e3 / 0.81e2 * t8099 + 0.625e3 / 0.729e3 * t8103;
  t8158 = t8157 * t146;
  tv3sigma2tau7 = t9 * (t8147 - t8148 - t8149 + t8150 - t8151 - t8152 + t8153 + t8154 + t8158);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = tv3sigma2tau2;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = tv3sigma2tau3;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = tv3sigma2tau4;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = tv3sigma2tau5;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t8160 = t1295 * t35;
  t8161 = t2372 * t8160;
  t8162 = t7284 * t8161;
  t8163 = 0.25e3 / 0.81e2 * t8162;
  t8164 = t1794 * t189;
  t8165 = t8164 * t3504;
  t8166 = 0.25e2 / 0.162e3 * t8165;
  t8167 = t1321 * t1639;
  t8168 = t207 * t194;
  t8169 = t8167 * t8168;
  t8170 = t8164 * t8169;
  t8171 = 0.25e2 / 0.648e3 * t8170;
  t8172 = t1788 * t40;
  t8173 = t8172 * t44;
  t8174 = t1785 * t8173;
  t8175 = t1687 * t1797;
  t8176 = t8174 * t8175;
  t8177 = 0.5e1 / 0.36e2 * t8176;
  t8179 = t35 * t40 * t152;
  t8180 = t7243 * t8179;
  t8181 = t2814 * t8180;
  t8182 = 0.125e4 / 0.729e3 * t8181;
  t8183 = t409 * t1802;
  t8184 = t3463 * t8183;
  t8185 = 0.25e3 / 0.243e3 * t8184;
  t8186 = t1812 * t544;
  t8187 = t7247 * t8186;
  t8188 = t6394 * t8187;
  t8189 = 0.125e3 / 0.486e3 * t8188;
  t8190 = t1141 * t1808;
  t8191 = 0.25e2 / 0.162e3 * t8190;
  t8192 = t1806 * t146;
  t8193 = t6334 * t8192;
  t8194 = t1700 * t8193;
  t8195 = 0.5e1 / 0.288e3 * t8194;
  t8196 = t6460 * t62;
  t8197 = t8196 * t1807;
  t8198 = t1323 * t8197;
  t8199 = 0.25e2 / 0.1296e4 * t8198;
  t8200 = t1338 * t8192;
  t8201 = t154 * t8200;
  t8202 = 0.5e1 / 0.36e2 * t8201;
  t8203 = t542 * t1120;
  t8204 = t1794 * t8203;
  t8206 = t1806 * t35;
  t8207 = t8206 * t50;
  t8208 = t2785 * t8207;
  t8210 = 0.25e3 / 0.81e2 * t8204 - 0.125e4 / 0.729e3 * t8208;
  t8211 = t8210 * t146;
  t8212 = -t8163 + t8166 + t8171 + t8177 + t8182 - t8185 - t8189 - t8191 + t8195 - t8199 - t8202 + t8211;
  tv3sigmatau20 = t9 * t8212;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t8213 = t7459 * t1691;
  t8214 = t5300 * t8213;
  t8215 = 0.25e3 / 0.81e2 * t8214;
  t8216 = t478 * t7318;
  t8217 = t8216 * t1696;
  t8218 = 0.25e2 / 0.162e3 * t8217;
  t8219 = t30 * t1639;
  t8220 = t8219 * t207;
  t8221 = t8220 * t1695;
  t8222 = t8216 * t8221;
  t8223 = 0.25e2 / 0.648e3 * t8222;
  t8224 = t1151 * t448;
  t8225 = t6544 * t8224;
  t8226 = 0.5e1 / 0.36e2 * t8225;
  t8227 = t7362 * t8179;
  t8228 = t5013 * t8227;
  t8229 = 0.125e4 / 0.729e3 * t8228;
  t8230 = t6491 * t7362;
  t8231 = t6490 * t8230;
  t8232 = 0.25e3 / 0.243e3 * t8231;
  t8234 = t805 * t4407 * t1707;
  t8235 = t8234 * t8230;
  t8236 = 0.125e3 / 0.486e3 * t8235;
  t8237 = t6365 * t1840;
  t8238 = 0.25e2 / 0.162e3 * t8237;
  t8239 = t1699 * t1335;
  t8240 = t574 * t21;
  t8241 = t8240 * t1844;
  t8242 = t8239 * t8241;
  t8243 = 0.5e1 / 0.288e3 * t8242;
  t8245 = t324 * t325 * t8219;
  t8246 = t4756 * t1695;
  t8247 = t8245 * t8246;
  t8248 = 0.25e2 / 0.1296e4 * t8247;
  t8249 = t152 * t408;
  t8250 = t151 * t8249;
  t8251 = t8250 * t8241;
  t8252 = 0.5e1 / 0.36e2 * t8251;
  t8253 = t806 * t1691;
  t8254 = t4604 * t8253;
  t8256 = t1833 * t8179;
  t8257 = t5342 * t8256;
  t8259 = 0.25e3 / 0.81e2 * t8254 - 0.125e4 / 0.729e3 * t8257;
  t8260 = t8259 * t146;
  t8261 = -t8215 + t8218 + t8223 + t8226 + t8229 - t8232 - t8236 - t8238 + t8243 - t8248 - t8252 + t8260;
  tv3sigmatau21 = t9 * t8261;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  t8262 = t7525 * t8161;
  t8263 = 0.25e3 / 0.81e2 * t8262;
  t8264 = t1867 * t189;
  t8265 = t8264 * t3504;
  t8266 = 0.25e2 / 0.162e3 * t8265;
  t8267 = t8264 * t8169;
  t8268 = 0.25e2 / 0.648e3 * t8267;
  t8269 = t1861 * t40;
  t8270 = t8269 * t44;
  t8271 = t1858 * t8270;
  t8272 = t8271 * t8175;
  t8273 = 0.5e1 / 0.36e2 * t8272;
  t8274 = t7625 * t8179;
  t8275 = t2814 * t8274;
  t8276 = 0.125e4 / 0.729e3 * t8275;
  t8277 = t409 * t1872;
  t8278 = t3463 * t8277;
  t8279 = 0.25e3 / 0.243e3 * t8278;
  t8280 = t1882 * t544;
  t8281 = t7596 * t8280;
  t8282 = t6394 * t8281;
  t8283 = 0.125e3 / 0.486e3 * t8282;
  t8284 = t1141 * t1878;
  t8285 = 0.25e2 / 0.162e3 * t8284;
  t8286 = t1876 * t146;
  t8287 = t6334 * t8286;
  t8288 = t1700 * t8287;
  t8289 = 0.5e1 / 0.288e3 * t8288;
  t8290 = t8196 * t1877;
  t8291 = t1323 * t8290;
  t8292 = 0.25e2 / 0.1296e4 * t8291;
  t8293 = t1338 * t8286;
  t8294 = t154 * t8293;
  t8295 = 0.5e1 / 0.36e2 * t8294;
  t8296 = t1867 * t8203;
  t8298 = t1876 * t35;
  t8300 = t2785 * t8298 * t50;
  t8302 = 0.25e3 / 0.81e2 * t8296 - 0.125e4 / 0.729e3 * t8300;
  t8303 = t8302 * t146;
  t8304 = -t8263 + t8266 + t8268 + t8273 + t8276 - t8279 - t8283 - t8285 + t8289 - t8292 - t8295 + t8303;
  tv3sigmatau22 = t9 * t8304;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  t8305 = 0.5e3 / 0.81e2 * t8162;
  t8306 = 0.25e2 / 0.81e2 * t8165;
  t8307 = 0.25e2 / 0.324e3 * t8170;
  t8308 = 0.5e1 / 0.18e2 * t8176;
  t8309 = 0.25e4 / 0.729e3 * t8181;
  t8310 = 0.5e3 / 0.243e3 * t8184;
  t8311 = 0.125e3 / 0.243e3 * t8188;
  t8312 = 0.25e2 / 0.81e2 * t8190;
  t8313 = 0.5e1 / 0.144e3 * t8194;
  t8314 = 0.25e2 / 0.648e3 * t8198;
  t8315 = 0.5e1 / 0.18e2 * t8201;
  t8318 = 0.5e3 / 0.81e2 * t8204 - 0.25e4 / 0.729e3 * t8208;
  t8319 = t8318 * t146;
  t8320 = -t8305 + t8306 + t8307 + t8308 + t8309 - t8310 - t8311 - t8312 + t8313 - t8314 - t8315 + t8319;
  tv3sigmatau23 = t9 * t8320;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  t8321 = 0.5e3 / 0.81e2 * t8214;
  t8322 = 0.25e2 / 0.81e2 * t8217;
  t8323 = 0.25e2 / 0.324e3 * t8222;
  t8324 = 0.5e1 / 0.18e2 * t8225;
  t8325 = 0.25e4 / 0.729e3 * t8228;
  t8326 = 0.5e3 / 0.243e3 * t8231;
  t8327 = 0.125e3 / 0.243e3 * t8235;
  t8328 = 0.25e2 / 0.81e2 * t8237;
  t8329 = 0.5e1 / 0.144e3 * t8242;
  t8330 = 0.25e2 / 0.648e3 * t8247;
  t8331 = 0.5e1 / 0.18e2 * t8251;
  t8334 = 0.5e3 / 0.81e2 * t8254 - 0.25e4 / 0.729e3 * t8257;
  t8335 = t8334 * t146;
  t8336 = -t8321 + t8322 + t8323 + t8324 + t8325 - t8326 - t8327 - t8328 + t8329 - t8330 - t8331 + t8335;
  tv3sigmatau24 = t9 * t8336;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  t8337 = 0.5e3 / 0.81e2 * t8262;
  t8338 = 0.25e2 / 0.81e2 * t8265;
  t8339 = 0.25e2 / 0.324e3 * t8267;
  t8340 = 0.5e1 / 0.18e2 * t8272;
  t8341 = 0.25e4 / 0.729e3 * t8275;
  t8342 = 0.5e3 / 0.243e3 * t8278;
  t8343 = 0.125e3 / 0.243e3 * t8282;
  t8344 = 0.25e2 / 0.81e2 * t8284;
  t8345 = 0.5e1 / 0.144e3 * t8288;
  t8346 = 0.25e2 / 0.648e3 * t8291;
  t8347 = 0.5e1 / 0.18e2 * t8294;
  t8350 = 0.5e3 / 0.81e2 * t8296 - 0.25e4 / 0.729e3 * t8300;
  t8351 = t8350 * t146;
  t8352 = -t8337 + t8338 + t8339 + t8340 + t8341 - t8342 - t8343 - t8344 + t8345 - t8346 - t8347 + t8351;
  tv3sigmatau25 = t9 * t8352;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = tv3sigmatau20;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = tv3sigmatau21;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = tv3sigmatau22;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t8353 = t2283 * rho[0];
  t8354 = 0.1e1 / t8353;
  t8355 = t2 * t8354;
  t8356 = t1786 * t1786;
  t8357 = t8356 * t13;
  t8358 = t8357 * t539;
  t8359 = t8355 * t8358;
  t8361 = 0.2e4 / 0.81e2 * t8359 * t2373;
  t8362 = t8355 * t8357;
  t8363 = t8362 * t189;
  t8364 = t1321 * t58;
  t8365 = t8364 * t8168;
  t8367 = 0.25e2 / 0.54e2 * t8363 * t8365;
  t8368 = t8362 * t50;
  t8369 = t574 * t146;
  t8370 = t1796 * t8369;
  t8372 = 0.5e1 / 0.12e2 * t8368 * t8370;
  t8373 = t2356 * t8354;
  t8375 = t8373 * t8357 * t50;
  t8377 = 0.1e5 / 0.729e3 * t2814 * t8375;
  t8378 = t207 * t8354;
  t8379 = t8357 * t146;
  t8380 = t8379 * t544;
  t8381 = t8378 * t8380;
  t8383 = 0.25e3 / 0.81e2 * t4409 * t8381;
  t8384 = t8354 * t8357;
  t8385 = t8384 * t194;
  t8386 = t1338 * t8385;
  t8388 = 0.25e2 / 0.54e2 * t1323 * t8386;
  t8389 = t62 * t8354;
  t8390 = t8389 * t8379;
  t8391 = t2640 * t8390;
  t8393 = 0.5e1 / 0.12e2 * t154 * t8391;
  t8399 = -0.2e4 / 0.81e2 * t8362 * t2349 + 0.1e5 / 0.729e3 * t2785 * t8384 * t50;
  t8400 = t8399 * t146;
  tv3tau30 = t9 * (t8361 - t8367 - t8372 - t8377 + t8383 + t8388 + t8393 + t8400);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t8403 = 0.2e4 / 0.81e2 * t5300 * t1803;
  t8404 = t7358 * t1807;
  t8406 = 0.25e2 / 0.54e2 * t8216 * t8404;
  t8408 = 0.5e1 / 0.12e2 * t479 * t1814;
  t8410 = t8172 * t152;
  t8411 = t1410 * t1784 * t8410;
  t8413 = 0.1e5 / 0.729e3 * t5013 * t8411;
  t8414 = t1811 * t1788;
  t8415 = t1295 * t1410;
  t8416 = t8414 * t8415;
  t8418 = 0.25e3 / 0.81e2 * t5174 * t8416;
  t8419 = t574 * t1806;
  t8420 = t8419 * t1736;
  t8422 = 0.25e2 / 0.54e2 * t1838 * t8420;
  t8423 = t473 * t1806;
  t8424 = t5427 * t8423;
  t8426 = 0.5e1 / 0.12e2 * t1336 * t8424;
  t8429 = t27 * t1784;
  t8430 = t8429 * t1788;
  t8431 = t8430 * t50;
  t8434 = -0.2e4 / 0.81e2 * t4604 * t1820 + 0.1e5 / 0.729e3 * t5342 * t8431;
  t8435 = t8434 * t146;
  tv3tau31 = t9 * (t8403 - t8406 - t8408 - t8413 + t8418 + t8422 + t8426 + t8435);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  t8437 = t7524 * t541;
  t8438 = t1858 * t8437;
  t8439 = t147 * t8046;
  t8441 = 0.2e4 / 0.81e2 * t8438 * t8439;
  t8442 = t7358 * t1695;
  t8444 = 0.25e2 / 0.54e2 * t7576 * t8442;
  t8445 = t1867 * t453;
  t8446 = t878 * t448;
  t8448 = 0.5e1 / 0.12e2 * t8445 * t8446;
  t8450 = t432 * t152;
  t8451 = t1876 * t6 * t8450;
  t8453 = 0.1e5 / 0.729e3 * t5013 * t8451;
  t8454 = t1295 * t1876;
  t8455 = t5175 * t8454;
  t8457 = 0.25e3 / 0.81e2 * t5174 * t8455;
  t8458 = t574 * t1876;
  t8459 = t8458 * t1695;
  t8461 = 0.25e2 / 0.54e2 * t1838 * t8459;
  t8462 = t4251 * t1881;
  t8463 = t1882 * t1296;
  t8464 = t8462 * t8463;
  t8466 = 0.5e1 / 0.12e2 * t1336 * t8464;
  t8467 = t806 * t1296;
  t8471 = t805 * t5059 * t1857;
  t8472 = t1861 * t6;
  t8473 = t8472 * t16;
  t8474 = t8473 * t50;
  t8477 = -0.2e4 / 0.81e2 * t7525 * t8467 + 0.1e5 / 0.729e3 * t8471 * t8474;
  t8478 = t8477 * t146;
  tv3tau32 = t9 * (t8441 - t8444 - t8448 - t8453 + t8457 + t8461 + t8466 + t8478);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t8480 = t3250 * rho[1];
  t8481 = 0.1e1 / t8480;
  t8482 = t2 * t8481;
  t8483 = t1859 * t1859;
  t8484 = t8483 * t24;
  t8485 = t8484 * t539;
  t8486 = t8482 * t8485;
  t8488 = 0.2e4 / 0.81e2 * t8486 * t2373;
  t8489 = t8482 * t8484;
  t8490 = t8489 * t189;
  t8492 = 0.25e2 / 0.54e2 * t8490 * t8365;
  t8493 = t8489 * t50;
  t8495 = 0.5e1 / 0.12e2 * t8493 * t8370;
  t8496 = t2356 * t8481;
  t8498 = t8496 * t8484 * t50;
  t8500 = 0.1e5 / 0.729e3 * t2814 * t8498;
  t8501 = t207 * t8481;
  t8502 = t8484 * t146;
  t8503 = t8502 * t544;
  t8504 = t8501 * t8503;
  t8506 = 0.25e3 / 0.81e2 * t4409 * t8504;
  t8507 = t8481 * t8484;
  t8508 = t8507 * t194;
  t8509 = t1338 * t8508;
  t8511 = 0.25e2 / 0.54e2 * t1323 * t8509;
  t8512 = t62 * t8481;
  t8513 = t8512 * t8502;
  t8514 = t2640 * t8513;
  t8516 = 0.5e1 / 0.12e2 * t154 * t8514;
  t8519 = t8507 * t50;
  t8522 = -0.2e4 / 0.81e2 * t8489 * t2349 + 0.1e5 / 0.729e3 * t2785 * t8519;
  t8523 = t8522 * t146;
  tv3tau33 = t9 * (t8488 - t8492 - t8495 - t8500 + t8506 + t8511 + t8516 + t8523);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t8539 = 0.8e4 / 0.81e2 * t1899 - 0.4e3 / 0.27e2 * t1903 - 0.4e3 / 0.27e2 * t1907 + 0.12e2 * t1909 + 0.2e2 / 0.9e1 * t2243 + 0.2e2 / 0.9e1 * t2330 + 0.2e2 / 0.3e1 * t2334 + 0.12e2 * t2336 + 0.4e1 * t2370 + 0.8e4 / 0.81e2 * t2374 + 0.4e1 * t2376 + 0.2e2 / 0.3e1 * t2377 + 0.2e2 / 0.3e1 * t2381 + 0.8e4 / 0.81e2 * t2384;
  t8556 = t39 * t2354 * t216;
  t8559 = t541 * t216;
  t8560 = t8559 * t1295;
  t8563 = t2372 * t4302;
  t8566 = t1928 * t664;
  t8569 = t2021 * t67 * t308;
  t8573 = 0.21053605041484726346e2 * t311 * t601 * t745;
  t8575 = 0.1e1 / t32 / t56;
  t8579 = 0.18989649058080861537e-2 * t306 * t232 * t8575 * t138;
  t8583 = t710 * t710;
  t8586 = 0.62071215503128080361e4 * t77 / t724 / t707 * t8583 * t2052;
  t8587 = t631 * t631;
  t8591 = 0.35089341735807877242e1 * t311 * t740 * t8587 * t297;
  t8592 = t636 * t2235;
  t8594 = t2024 * t633;
  t8596 = t2024 * t604;
  t8598 = t636 * t2035;
  t8601 = 0.1e1 / t598 / t739;
  t8602 = t600 * t600;
  t8606 = 0.12304822629859687989e5 * t311 * t8601 * t8602 * t2034;
  t8607 = t636 * t2061;
  t8609 = 0.14649157844805236043e-2 * t8566 - 0.73245789224026180216e-3 * t8569 - t8573 + t8579 - t8586 + t8591 - 0.23392894490538584828e1 * t8592 - 0.35089341735807877242e1 * t8594 - 0.10389515463408878255e3 * t8596 - 0.4101607543286562663e4 * t8598 + t8606 + 0.4155806185363551302e3 * t8607;
  t8610 = t776 * t753;
  t8611 = 0.192e3 * t8610;
  t8612 = t770 * t755;
  t8614 = t776 * t757;
  t8620 = 0.34367190188705947438e1 * t236 * t725 * t720 * t728 * t247;
  t8624 = 0.4274e0 * t236 * t708 * t247 * t721;
  t8625 = t1951 * t1942;
  t8630 = 0.64327917994770140268e2 * t726 * t1984 * t728 * t247;
  t8634 = 0.3103560775156404018e4 * t2050 * t710 * t2052 * t720;
  t8638 = 0.6233709278045326953e3 * t311 * t2030 * t8602 * t603;
  t8639 = t636 * t2041;
  t8644 = 0.46785788981077169656e1 * t311 * t740 * t2134 * t298;
  t8649 = 0.69263436422725855036e2 * t311 * t599 * t2134 * t603 * t296;
  t8650 = t636 * t1939;
  t8652 = -t8611 + 0.12e3 * t8612 - 0.384e3 * t8614 - t8620 + t8624 - 0.1301229756036208781e0 * t8625 + t8630 + t8634 - t8638 - 0.14035736694323150897e2 * t8639 + t8644 - t8649 + 0.14035736694323150897e2 * t8650;
  t8654 = t636 * t1935;
  t8659 = 0.62337092780453269531e3 * t311 * t2059 * t600 * t1934;
  t8663 = 0.68734380377411894876e1 * t670 * t222 * t2183 * t2185;
  t8667 = 0.14035736694323150897e2 * t311 * t2059 * t8602 * t297;
  t8669 = t2021 * t129 * t313;
  t8671 = t114 * t670;
  t8674 = 0.19263893255070628432e1 * t8671 * t2076 * t2155;
  t8677 = 0.1301229756036208781e0 * t8671 * t2118 * t2158;
  t8678 = t773 * t755;
  t8682 = 0.57895126195293126241e3 * t2050 * t8583 * t728;
  t8683 = t724 * t724;
  t8686 = t727 * t727;
  t8690 = 0.24955700379505800916e5 * t77 / t8683 * t8583 / t8686;
  t8693 = 0.57895126195293126241e3 * t2184 * t2167 * t710;
  t8700 = t678 * t678;
  t8717 = t688 * t688;
  t8721 = t598 * t598;
  t8722 = 0.1e1 / t8721;
  t8724 = t602 * t602;
  t8725 = 0.1e1 / t8724;
  t8739 = 0.1e1 / t78 / t10 * t1632 * t670 / 0.48e2;
  t8741 = t1961 * t256;
  t8743 = t610 * t58;
  t8744 = t609 * t8743;
  t8746 = t232 * t8575;
  t8747 = t231 * t8746;
  t8749 = t72 * t8575;
  t8750 = t70 * t8749;
  t8752 = pow(t75, -0.25e1);
  t8755 = t8752 * t68 * t1632 * t670;
  t8757 = t1974 * t256;
  t8759 = t623 * t8743;
  t8761 = t239 * t8746;
  t8764 = t85 * t71 * t58;
  t8766 = -0.28769444444444444444e1 * t8739 + 0.27618666666666666667e2 * t8741 - 0.10229135802469135803e2 * t8744 + 0.89504938271604938273e1 * t8747 + 0.31310740740740740741e1 * t8750 + 0.366775e-1 * t8755 - 0.58684e0 * t8757 + 0.65204444444444444445e0 * t8759 + 0.5705388888888888889e0 * t8761 + 0.13490888888888888889e1 * t8764;
  t8773 = t8586 - 0.35089341735807877242e1 * t741 * t8587 * t297 - 0.24828486201251232145e5 * t116 / t692 / t675 * t8700 * t2178 + t8620 - t8624 - 0.19263893255070628431e1 * t236 * t1935 + 0.1301229756036208781e0 * t236 * t1939 - 0.6609050294782684211e1 * t236 * t693 * t688 * t696 * t281 + 0.41096e0 * t236 * t676 * t281 * t689 - 0.6e1 * t677 * t8717 * t282 - t8630 - t8634 + 0.91082604192152556044e5 * t129 * t8722 * t8602 * t8725 - 0.12304822629859687989e5 * t129 * t8601 * t8602 * t2034 + 0.5848223622634646207e0 * t291 * t8766 * t297 - t8663 + 0.13698666666666666666e0 * t670 * t2084 * t689;
  t8831 = 0.21053605041484726346e2 * t748 * t742 * t631 - 0.62337092780453269531e3 * t2091 * t749 * t631 - 0.11579025239058625248e4 * t2097 * t2151 * t678 + 0.61524113149298439947e4 * t2138 * t600 * t2034 * t631 + 0.69263436422725855036e2 * t748 * t2134 * t603 * t296 - 0.46785788981077169656e1 * t741 * t2135 * t296 + 0.12865583598954028054e3 * t694 * t2110 * t696 * t281 - 0.18989649058080861537e-2 * t70 * t8749 * t138 - 0.55209406483950617283e-2 * t70 * t8749 * t125 + 0.12414243100625616072e5 * t2176 * t688 * t2178 * t678 + 0.36e2 * t694 * t679 * t688 - 0.8e1 * t677 * t283 * t2110 + 0.1e1 * t276 * (-0.39219166666666666667e1 * t8739 + 0.376504e2 * t8741 - 0.13944592592592592593e2 * t8744 + 0.12201518518518518519e2 * t8747 + 0.5356037037037037037e1 * t8750 + 0.14025833333333333333e0 * t8755 - 0.22441333333333333332e1 * t8757 + 0.24934814814814814815e1 * t8759 + 0.21817962962962962963e1 * t8761 + 0.16979925925925925926e1 * t8764) * t282 - t8682 - t8690 + 0.11579025239058625248e4 * t2176 * t8700 * t696 + t8693;
  t8835 = 0.11483599538271604938e-1 * t70 * t8749 * t94;
  t8838 = 0.14246666666666666666e0 * t670 * t1911 * t721;
  t8842 = 0.22911460125803964958e1 * t670 * t615 * t725 * t729;
  t8845 = 0.71233333333333333332e-1 * t670 * t703 * t1985;
  t8862 = 0.1e1 * t229 * (-0.21099166666666666667e1 * t8739 + 0.202552e2 * t8741 - 0.75019259259259259258e1 * t8744 + 0.6564185185185185185e1 * t8747 + 0.31003950617283950618e1 * t8750 + 0.68258333333333333335e-1 * t8755 - 0.10921333333333333333e1 * t8757 + 0.12134814814814814815e1 * t8759 + 0.10617962962962962963e1 * t8761 + 0.13388493827160493828e1 * t8764) * t248;
  t8901 = 0.22161481481481481481e0 * t670 * t1923 * t228 * t249;
  t8902 = t8835 - t8838 - t8842 + t8845 + 0.6233709278045326953e3 * t2138 * t8602 * t603 - t8862 - 0.1301229756036208781e0 * t670 * t2076 * t2171 - 0.38025319932552508021e2 * t670 * t222 * t2030 * t2139 + 0.38527786510141256862e1 * t670 * t222 * t2059 * t2092 - 0.21687162600603479684e-1 * t670 * t735 * t2135 - 0.68493333333333333332e-1 * t670 * t671 * t2111 + 0.43374325201206959368e-1 * t670 * t2069 * t745 - 0.41096e0 * t670 * t2080 * t2123 - 0.67471172535210825684e-1 * t670 * t1923 * t290 * t298 - 0.21309037037037037036e0 * t670 * t1923 * t275 * t283 + 0.13218100589565368422e2 * t670 * t222 * t2096 * t2099 + t8901;
  t8905 = 0.4274e0 * t670 * t1918 * t2045;
  t8909 = 0.3684616320282908548e2 * t670 * t222 * t2049 * t2053;
  t8925 = 0.28493333333333333333e0 * t670 * t615 * t708 * t711;
  t8942 = 0.36e2 * t726 * t711 * t720;
  t8945 = 0.8e1 * t709 * t249 * t1984;
  t8946 = t692 * t692;
  t8949 = t695 * t695;
  t8954 = t720 * t720;
  t8957 = 0.6e1 * t709 * t8954 * t248;
  t8960 = 0.24e2 * t2184 * t8583 * t248;
  t8963 = 0.48245938496077605201e2 * t726 * t8954 * t728;
  t8970 = t8905 + t8909 - 0.14171548179536397724e3 * t670 * t222 * t2175 * t2179 + 0.12842595503380418954e1 * t670 * t615 * t599 * t749 - 0.27397333333333333333e0 * t670 * t615 * t676 * t679 + t8925 - 0.86748650402413918736e-1 * t670 * t615 * t740 * t742 + 0.44060335298551228073e1 * t670 * t615 * t693 * t697 + 0.96491876992155210402e2 * t694 * t8717 * t696 - 0.24e2 * t2097 * t8700 * t282 - t8942 + t8945 + 0.19964560303604640732e6 * t116 / t8946 * t8700 / t8949 + t8957 + t8960 - t8963 + 0.51947577317044391277e2 * t748 * t8587 * t603 - 0.14035736694323150897e2 * t2091 * t8602 * t297;
  t8974 = t99 * t114 * (t8773 + t8831 + t8902 + t8970);
  t8975 = -0.20779030926817756511e3 * t8654 + t8659 + t8663 + t8667 - 0.23392894490538584828e1 * t8669 + t8674 - t8677 + 0.72e2 * t8678 + t8682 + t8690 - t8693 + t8974;
  t8976 = t257 * t2066;
  t8978 = t776 * t755;
  t8984 = 0.61524113149298439947e4 * t311 * t2030 * t600 * t2034 * t631;
  t8986 = t99 * t268 * t2189;
  t8991 = 0.91082604192152556044e5 * t311 * t8722 * t8602 * t8725;
  t8992 = t2024 * t787;
  t8997 = 0.51947577317044391277e2 * t311 * t599 * t8587 * t603;
  t8999 = 0.16e2 * t257 * t2190;
  t9000 = t2000 * t269;
  t9002 = -0.48e2 * t8976 - t8835 - 0.192e3 * t8978 - t8984 + t8838 + t8842 - t8845 + 0.4e1 * t8986 - t8991 + 0.70178683471615754484e1 * t8992 - t8997 - t8999 + 0.96e2 * t9000;
  t9005 = t2000 * t302;
  t9006 = 0.96e2 * t9005;
  t9007 = t2225 * t302;
  t9008 = 0.96e3 * t9007;
  t9009 = t2222 * t269;
  t9011 = t2222 * t302;
  t9012 = 0.576e3 * t9011;
  t9014 = 0.48e3 * t2229 * t302;
  t9015 = t2225 * t269;
  t9017 = t253 * t2066;
  t9020 = t99 * t2021 * t301;
  t9022 = t2229 * t269;
  t9026 = 0.84e3 * t97 * t7979 * t142;
  t9028 = t252 * t2228 * t142;
  t9029 = 0.192e4 * t9028;
  t9030 = t9006 + t9008 - 0.576e3 * t9009 - t9012 + t8862 - t9014 + 0.96e3 * t9015 + 0.48e2 * t9017 + 0.4e1 * t9020 - 0.48e3 * t9022 + t9026 - t9029;
  t9032 = t62 * t769 * t142;
  t9033 = 0.144e4 * t9032;
  t9034 = t8 * t256;
  t9035 = t9034 * t142;
  t9036 = 0.384e3 * t9035;
  t9037 = t12 * t12;
  t9039 = 0.1e1 / t639 / t9037;
  t9040 = t641 * t641;
  t9046 = t644 * t644;
  t9051 = -t98 + t9034;
  t9052 = 0.24e2 * t9051;
  t9056 = my_piecewise3(t100, 0, 0.4e2 / 0.81e2 * t9039 * t9040 - 0.16e2 / 0.9e1 * t1993 * t641 * t644 + 0.4e1 / 0.3e1 * t640 * t9046 + 0.16e2 / 0.9e1 * t1997 * t2002 + 0.4e1 / 0.3e1 * t103 * t9052);
  t9057 = t23 * t23;
  t9059 = 0.1e1 / t649 / t9057;
  t9060 = t651 * t651;
  t9066 = t654 * t654;
  t9075 = my_piecewise3(t106, 0, 0.4e2 / 0.81e2 * t9059 * t9060 - 0.16e2 / 0.9e1 * t2008 * t651 * t654 + 0.4e1 / 0.3e1 * t650 * t9066 + 0.16e2 / 0.9e1 * t2012 * t2015 - 0.4e1 / 0.3e1 * t107 * t9052);
  t9077 = (t9056 + t9075) * t113;
  t9081 = t99 * t660 * t752;
  t9083 = t783 * t1925;
  t9085 = t253 * t2217;
  t9087 = t257 * t2217;
  t9089 = t253 * t2232;
  t9091 = t257 * t2232;
  t9093 = t9033 - t9036 + t99 * t9077 * t141 + 0.6e1 * t9081 - t8901 - t8905 - t8909 - t8925 - 0.22787578869697033845e-2 * t9083 + 0.48e2 * t9085 - 0.48e2 * t9087 + 0.16e2 * t9089 - 0.16e2 * t9091;
  t9095 = t773 * t753;
  t9096 = 0.72e2 * t9095;
  t9097 = t773 * t757;
  t9100 = 0.12e3 * t770 * t753;
  t9104 = 0.24e2 * t98 * t110 * t113 * t141;
  t9105 = t770 * t757;
  t9112 = 0.5848223622634646207e0 * t311 * t290 * t8766 * t297;
  t9113 = t9096 + 0.144e3 * t9097 + t9100 + t9104 + 0.24e3 * t9105 + t8942 - t8945 + 0.19751673498613801407e-1 * t9077 * t139 - t8957 - t8960 + t8963 - t9112;
  t9114 = t1951 * t1955;
  t9118 = 0.38527786510141256862e1 * t779 * t223 * t2061;
  t9121 = 0.38025319932552508021e2 * t779 * t223 * t2035;
  t9122 = t1951 * t1945;
  t9126 = 0.67471172535210825684e-1 * t779 * t1970 * t313;
  t9128 = t660 * t70 * t780;
  t9130 = t1951 * t1948;
  t9134 = 0.21687162600603479684e-1 * t779 * t223 * t2235;
  t9137 = 0.1301229756036208781e0 * t779 * t223 * t2041;
  t9140 = 0.12842595503380418954e1 * t779 * t619 * t604;
  t9143 = 0.43374325201206959368e-1 * t779 * t619 * t633;
  t9146 = 0.86748650402413918736e-1 * t779 * t619 * t787;
  t9147 = t253 * t2190;
  t9148 = 0.16e2 * t9147;
  t9149 = -0.86748650402413918736e-1 * t9114 - t9118 + t9121 + 0.19263893255070628431e1 * t9122 + t9126 + 0.65061487801810439052e-1 * t9128 + 0.65061487801810439052e-1 * t9130 + t9134 + t9137 - t9140 - t9143 + t9146 + t9148;
  t9152 = t8609 + t8652 + t8975 + t9002 + t9030 + t9093 + t9113 + t9149;
  t9157 = t522 * t522;
  t9162 = t2 * t9157;
  t9175 = t316 * t2356;
  t9189 = 0.6e1 * t814 * t791 - 0.4e5 / 0.729e3 * t8556 * t2431 + 0.8e4 / 0.81e2 * t2371 * t8560 + 0.8e4 / 0.81e2 * t2371 * t8563 + 0.5e1 / 0.9e1 * t46 * t55 * t66 * t9152 + 0.2e4 / 0.81e2 * t543 * t147 * t544 * t9157 - 0.1e3 / 0.27e2 * t9162 * t188 * t531 + 0.2e2 / 0.9e1 * t46 * t55 * t216 * t2240 + 0.8e4 / 0.243e3 * t543 * t147 * t544 * t2339 * t180 - 0.4e5 / 0.729e3 * t2428 * t9175 * t2347 * t50 - 0.2e3 / 0.27e2 * t190 * t549 * t2401 - 0.1e3 / 0.27e2 * t190 * t193 * t2419 * t522 + 0.2e2 / 0.9e1 * t182 * t2242;
  t9193 = 0.12e2 * t9051;
  t9196 = 0.5e1 / 0.3e1 * t7 * t15 * t9193;
  t9200 = -0.5e1 / 0.3e1 * t22 * t26 * t9193;
  t9205 = 0.616e4 / 0.81e2 * tau[0] / t4 / t8353 * t16;
  t9207 = 0.88e4 / 0.81e2 * t2286 * t168;
  t9209 = 0.4e3 / 0.9e1 * t496 * t509;
  t9211 = 0.1e3 / 0.9e1 * t161 * t2306;
  t9212 = 0.2618e4 / 0.81e2 * t565;
  t9214 = 0.8e3 / 0.27e2 * t496 * t503;
  t9216 = 0.2e3 / 0.81e2 * t161 * t2298;
  t9218 = 0.2e3 / 0.9e1 * t161 * t2302;
  t9219 = 0.1e1 / t7180;
  t9220 = t502 * t502;
  t9223 = 0.4e2 / 0.81e2 * t7 * t9219 * t9220;
  t9227 = 0.2e2 / 0.9e1 * t7 * t2296 * t502 * t508;
  t9228 = t508 * t508;
  t9231 = 0.1e2 / 0.3e1 * t7 * t501 * t9228;
  t9234 = 0.4e2 / 0.9e1 * t7 * t2301 * t2305;
  t9235 = 0.1e1 / t7509;
  t9236 = t513 * t513;
  t9239 = 0.4e2 / 0.81e2 * t22 * t9235 * t9236;
  t9243 = 0.2e2 / 0.9e1 * t22 * t2310 * t513 * t517;
  t9244 = t517 * t517;
  t9247 = 0.1e2 / 0.3e1 * t22 * t512 * t9244;
  t9250 = 0.4e2 / 0.9e1 * t22 * t2315 * t2319;
  t9251 = t9196 + t9200 + t9205 - t9207 + t9209 - t9211 - t9212 + t9214 + t9216 - t9218 + t9223 - t9227 + t9231 + t9234 + t9239 - t9243 + t9247 + t9250;
  t9252 = t2 * t9251;
  t9265 = t527 * t527;
  t9266 = t2 * t9265;
  t9269 = t2356 * t40 * t152;
  t9273 = 0.1e1 / t2352 / t53;
  t9274 = t539 * t9273;
  t9275 = t39 * t9274;
  t9276 = t544 * t544;
  t9281 = t152 * t522;
  t9299 = t39 * t9274 * t66;
  t9300 = t146 * t9276;
  t9305 = t792 * params->c;
  t9306 = t325 * t9305;
  t9309 = t590 * params->c;
  t9310 = t325 * t9309;
  t9313 = t594 * params->c;
  t9314 = t325 * t9313;
  t9321 = t565 * t576;
  t9323 = t565 * t580;
  t9325 = t202 * t2266;
  t9327 = t202 * t2270;
  t9329 = t2616 * t2274;
  t9332 = 0.1e1 / t2262 / t60;
  t9333 = t9332 * t62;
  t9334 = t575 * t575;
  t9338 = t2263 * t8;
  t9340 = t59 * t9338 * t2265;
  t9348 = t878 * t8 * t209 * t583;
  t9350 = t583 * t583;
  t9356 = -0.119e3 / 0.3e1 * t9321 + 0.238e3 / 0.3e1 * t9323 - 0.14e2 * t9325 + 0.28e2 * t9327 + 0.14e2 * t9329 - 0.3e1 * t59 * t9333 * t9334 + 0.6e1 * t9340 + 0.9e1 / 0.2e1 * t2640 * t62 * t575 * t583 - 0.6e1 * t9348 - 0.3e1 / 0.4e1 * t59 * t574 * t9350 - t878 * t2273 * t2323;
  t9358 = t59 * t206 * t583;
  t9360 = t565 * t61;
  t9361 = 0.119e3 / 0.3e1 * t9360;
  t9364 = t30 / t33 / t6102;
  t9366 = 0.13685e5 / 0.81e2 * t9364 * t63;
  t9367 = t2247 * t210;
  t9369 = t2247 * t213;
  t9370 = 0.476e4 / 0.27e2 * t9369;
  t9371 = t565 * t584;
  t9373 = t202 * t2277;
  t9375 = t202 * t2280;
  t9377 = t202 * t2324;
  t9380 = t59 * t573 * t575;
  t9383 = t59 * t579 * t2323;
  t9384 = t9196 + t9200 + t9205 - t9207 + t9209 - t9211 + t9214 + t9216 - t9218 + t9223 - t9227 + t9231 + t9234 + t9239 - t9243 + t9247 + t9250;
  t9388 = 0.3e1 / 0.2e1 * t9358 - t9361 - t9366 - 0.238e4 / 0.27e2 * t9367 + t9370 + 0.119e3 / 0.6e1 * t9371 - 0.14e2 * t9373 - 0.14e2 * t9375 - 0.7e1 / 0.3e1 * t9377 - 0.3e1 * t9380 + t9383 + t59 * t207 * t9384 / 0.8e1;
  t9404 = 0.4e1 * t330 * t2240 + t156 * t9152 + (-0.5e1 / 0.9e1 * t9252 * t40 * t153 + 0.4e3 / 0.81e2 * t2340 * t188 * t327 - 0.4e4 / 0.27e2 * t523 * t539 * t807 + 0.1e3 / 0.27e2 * t9162 * t185 * t802 + 0.4e5 / 0.729e3 * t9266 * t2354 * t9269 - 0.4e6 / 0.6561e4 * t9275 * t9276 * t9265 * t189 + 0.2e5 / 0.243e3 * t2785 * t4420 * t9281 - 0.2e4 / 0.81e2 * t805 * t806 * t9157 - 0.8e4 / 0.243e3 * t805 * t806 * t180 * t2339 + 0.5e2 / 0.81e2 * t324 * t325 * params->c * t9251) * t146 + 0.4e6 / 0.6561e4 * t9299 * t9300 * t9265 * t189 - 0.2e3 / 0.27e2 * t529 * t9306 - 0.2e3 / 0.27e2 * t529 * t9310 - 0.4e3 / 0.27e2 * t529 * t9314 + 0.2e2 / 0.3e1 * t182 * t2380 + 0.2e2 / 0.9e1 * t182 * t2329 + 0.5e1 / 0.9e1 * t46 * t55 * (t9356 + t9388) * t146 + 0.2e2 / 0.9e1 * t46 * t55 * t2327 * t316 + 0.2e2 / 0.3e1 * t182 * t2333 + 0.1e2 / 0.3e1 * t46 * t55 * t589 * t791;
  t9407 = t2429 * t50;
  t9410 = t181 * t189;
  t9437 = t2240 * params->c;
  t9442 = t192 * t2327;
  t9446 = t2356 * t527;
  t9451 = -0.4e5 / 0.729e3 * t9266 * t2427 * t9407 - 0.4e3 / 0.27e2 * t9410 * t2402 - 0.4e3 / 0.81e2 * t9410 * t2406 - 0.2e3 / 0.81e2 * t190 * t549 * t2405 - 0.5e2 / 0.81e2 * t190 * t193 * t194 * t9251 - 0.1e3 / 0.27e2 * t190 * t2409 * t558 - 0.2e3 / 0.27e2 * t190 * t549 * t2420 - 0.4e3 / 0.27e2 * t9410 * t2416 - 0.2e3 / 0.81e2 * t190 * t193 * t553 * t2339 - 0.2e3 / 0.27e2 * t190 * t2409 * t554 - 0.2e3 / 0.81e2 * t190 * t193 * t9437 * t180 - 0.2e3 / 0.81e2 * t190 * t9442 * t195 - 0.2e5 / 0.243e3 * t2814 * t9446 * t522 * t50;
  t9482 = t528 * t542;
  t9483 = t544 * t522;
  t9484 = t147 * t9483;
  t9487 = 0.4e1 * t2369 * t316 + 0.8e4 / 0.81e2 * t543 * t217 * t1897 + 0.8e4 / 0.81e2 * t543 * t317 * t1897 + 0.5e1 / 0.9e1 * t9252 * t45 * t148 + 0.2e2 / 0.9e1 * t2390 * t218 + 0.2e2 / 0.9e1 * t2390 * t318 + 0.1e2 / 0.3e1 * t524 * t591 + 0.2e2 / 0.3e1 * t524 * t595 + 0.1e2 / 0.3e1 * t524 * t793 + 0.4e4 / 0.81e2 * t543 * t792 * t545 + 0.8e4 / 0.81e2 * t543 * t594 * t545 + 0.4e4 / 0.81e2 * t543 * t590 * t545 + 0.4e4 / 0.27e2 * t9482 * t9484;
  t9492 = 0.8e4 / 0.81e2 * t2388 + 0.2e2 / 0.9e1 * t2391 + 0.2e2 / 0.3e1 * t2393 + 0.2e2 / 0.3e1 * t2395 + 0.2e2 / 0.3e1 * t2397 + 0.4e2 / 0.3e1 * t2399 - 0.2e3 / 0.27e2 * t2403 - 0.2e3 / 0.81e2 * t2407 - 0.2e3 / 0.27e2 * t2411 - 0.4e3 / 0.27e2 * t2414 - 0.2e3 / 0.27e2 * t2417 - 0.2e3 / 0.27e2 * t2422 - 0.4e3 / 0.27e2 * t2425 + t9 * (t9189 + t9404 + t9451 + t9487) - 0.4e5 / 0.729e3 * t2432;
  tv4rho40 = t8539 + t9492;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t9502 = t192 * t2655;
  t9506 = t2756 * params->c;
  t9524 = 0.22e4 / 0.81e2 * t2286 * t337;
  t9526 = 0.25e2 / 0.3e1 * t161 * t2517;
  t9529 = 0.1e2 * t7 * t15 * t98;
  t9531 = 0.5e2 / 0.81e2 * t343 * t2312;
  t9533 = 0.25e2 / 0.9e1 * t343 * t2320;
  t9536 = 0.1e2 * t22 * t26 * t98;
  t9539 = 0.1e2 * t2510 * t2000 * t167;
  t9542 = 0.1e2 * t2531 * t2000 * t171;
  t9543 = t161 * t501;
  t9545 = 0.1e3 / 0.9e1 * t9543 * t2511;
  t9546 = t7 * t2296;
  t9549 = 0.1e2 / 0.9e1 * t9546 * t4960 * t508;
  t9552 = 0.1e2 / 0.9e1 * t9546 * t507 * t502;
  t9555 = 0.1e2 / 0.3e1 * t2510 * t507 * t508;
  t9556 = t22 * t2310;
  t9559 = 0.1e2 / 0.9e1 * t9556 * t5202 * t517;
  t9562 = 0.1e2 / 0.9e1 * t9556 * t507 * t513;
  t9563 = -t9212 - t9524 - t9526 - t9529 + t9531 - t9533 + t9536 - t9539 + t9542 - t9545 - t9549 - t9552 + t9555 - t9559 + t9562;
  t9593 = 0.2e2 * t7 * t827 * t256;
  t9604 = 0.2e2 * t22 * t837 * t256;
  t9607 = -0.1e2 / 0.3e1 * t2531 * t507 * t517 + 0.1e2 / 0.9e1 * t22 * t833 * t2319 + 0.4e3 / 0.27e2 * t496 * t824 + 0.2e3 / 0.9e1 * t496 * t828 - 0.5e2 / 0.9e1 * t161 * t2514 + 0.1e2 / 0.9e1 * t7 * t823 * t2305 + 0.5e2 / 0.27e2 * t161 * t2507 + 0.25e2 * t161 * t2520 + 0.4e2 / 0.81e2 * t7 * t9219 * t336 * t2297 + 0.1e2 / 0.3e1 * t7 * t501 * t506 * t167 + t9593 + 0.4e2 / 0.81e2 * t22 * t9235 * t346 * t2311 - 0.1e2 / 0.3e1 * t22 * t512 * t506 * t171 - t9604 - 0.5e2 / 0.9e1 * t343 * t2316;
  t9608 = t9563 + t9607;
  t9616 = 0.5e1 / 0.3e1 * t524 * t953 + 0.5e1 / 0.9e1 * t2390 * t384 + 0.5e1 / 0.3e1 * t524 * t908 - 0.1e3 / 0.27e2 * t190 * t2549 * t554 - 0.5e2 / 0.27e2 * t190 * t9502 * t195 - 0.5e2 / 0.27e2 * t190 * t193 * t9506 * t180 - 0.5e2 / 0.27e2 * t190 * t2409 * t903 - 0.5e2 / 0.27e2 * t190 * t193 * t553 * t2544 - 0.1e3 / 0.27e2 * t9410 * t2546 - 0.5e2 / 0.27e2 * t190 * t549 * t2545 - 0.5e2 / 0.81e2 * t190 * t193 * t194 * t9608 + 0.3e1 * t970 * t791 + t394 * t2240;
  t9631 = t2709 * t67 * t308;
  t9637 = t911 * t2041;
  t9640 = 0.96e2 * t8610;
  t9642 = 0.73245789224026180215e-3 * t8566 - 0.18311447306006545054e-3 * t8569 - t8573 + t8579 - t8586 + t8591 - 0.54934341918019635162e-3 * t9631 - 0.17544670867903938621e1 * t8592 - 0.17544670867903938621e1 * t8594 - 0.51947577317044391277e2 * t8596 - 0.30762056574649219973e4 * t8598 - 0.35089341735807877242e1 * t9637 + t8606 + 0.31168546390226634765e3 * t8607 - t9640 + 0.6e2 * t8612;
  t9643 = t2225 * t378;
  t9644 = 0.24e3 * t9643;
  t9645 = t2229 * t378;
  t9647 = t770 * t943;
  t9648 = 0.6e2 * t9647;
  t9649 = 0.96e2 * t8614;
  t9651 = t911 * t2061;
  t9653 = t2741 * t787;
  t9654 = 0.35089341735807877242e1 * t9653;
  t9655 = t770 * t945;
  t9659 = t9644 - 0.12e3 * t9645 + t9648 - t9649 - t8620 + t8624 - 0.97592231702715658578e-1 * t8625 + t8630 + t8634 + 0.10389515463408878255e3 * t9651 + t9654 + 0.6e2 * t9655 - t8638 - 0.10526802520742363173e2 * t8639 + t8644 - t8649 + 0.10526802520742363173e2 * t8650;
  t9662 = t911 * t2235;
  t9664 = t2741 * t633;
  t9665 = 0.17544670867903938621e1 * t9664;
  t9667 = t2709 * t129 * t313;
  t9669 = t911 * t2035;
  t9671 = t2741 * t604;
  t9672 = 0.51947577317044391276e2 * t9671;
  t9673 = t773 * t945;
  t9674 = 0.36e2 * t9673;
  t9675 = t776 * t945;
  t9676 = 0.96e2 * t9675;
  t9677 = t773 * t943;
  t9678 = 0.36e2 * t9677;
  t9680 = t2730 * t1942;
  t9682 = -0.15584273195113317383e3 * t8654 + t8659 + t8663 - 0.5848223622634646207e0 * t9662 - t9665 - 0.17544670867903938621e1 * t9667 - 0.10254018858216406658e4 * t9669 - t9672 + t9674 - t9676 + t9678 + t8667 - 0.5848223622634646207e0 * t8669 + t8674 - t8677 - 0.32530743900905219526e-1 * t9680;
  t9683 = t2730 * t1955;
  t9685 = t2730 * t1948;
  t9687 = t2730 * t1945;
  t9690 = t942 * t70 * t780;
  t9691 = 0.32530743900905219526e-1 * t9690;
  t9693 = t2660 * t664;
  t9694 = 0.73245789224026180216e-3 * t9693;
  t9695 = t915 * t1925;
  t9698 = t99 * t2709 * t301;
  t9725 = 0.32e2 * t928 * t256;
  t9727 = my_piecewise3(t100, 0, 0.4e2 / 0.81e2 * t9039 * t335 * t1994 - 0.16e2 / 0.9e1 * t1993 * t8 * t506 * t641 - 0.8e1 / 0.9e1 * t2678 * t166 * t644 + 0.8e1 / 0.3e1 * t640 * t506 * t166 - 0.8e1 * t2681 * t98 * t166 + 0.8e1 / 0.3e1 * t2681 * t506 * t644 + 0.4e1 / 0.9e1 * t925 * t2002 - 0.16e2 * t103 * t98 + t9725);
  t9752 = 0.32e2 * t936 * t256;
  t9754 = my_piecewise3(t106, 0, 0.4e2 / 0.81e2 * t9059 * t372 * t2009 + 0.16e2 / 0.9e1 * t2008 * t8 * t506 * t651 - 0.8e1 / 0.9e1 * t2693 * t263 * t654 - 0.8e1 / 0.3e1 * t650 * t506 * t263 + 0.8e1 * t2696 * t98 * t263 - 0.8e1 / 0.3e1 * t2696 * t506 * t654 + 0.4e1 / 0.9e1 * t933 * t2015 + 0.16e2 * t107 * t98 - t9752);
  t9756 = (t9727 + t9754) * t113;
  t9759 = -0.21687162600603479684e-1 * t9683 + 0.16265371950452609763e-1 * t9685 + 0.48159733137676571078e0 * t9687 + t9691 - 0.36e2 * t8678 + t9694 - 0.56968947174242584612e-3 * t9695 + t8682 + t8690 - t8693 + t8974 + 0.3e1 * t9698 - 0.36e2 * t8976 - t8835 + t99 * t9756 * t141 - t8984 + t8838;
  t9763 = t99 * t942 * t752;
  t9764 = 0.3e1 * t9763;
  t9766 = t99 * t377 * t2189;
  t9767 = t257 * t2720;
  t9770 = 0.96e2 * t776 * t943;
  t9774 = 0.48e2 * t9005;
  t9775 = 0.48e3 * t9007;
  t9776 = 0.144e3 * t9009;
  t9777 = t8842 - t8845 + t9764 + t9766 - 0.12e2 * t9767 - t9770 + 0.3e1 * t8986 - t8991 + 0.35089341735807877242e1 * t8992 - t8997 - t8999 - 0.72e2 * t9000 - t9774 + t9775 + t9776 + t8862;
  t9778 = 0.24e3 * t9015;
  t9779 = 0.12e2 * t9017;
  t9781 = 0.96e3 * t9028;
  t9782 = 0.192e3 * t9035;
  t9784 = t253 * t2720;
  t9786 = t911 * t1935;
  t9788 = t911 * t1939;
  t9791 = -t9014 + t9778 + t9779 + t9020 - 0.36e3 * t9022 + t9026 - t9781 + t9782 + 0.3e1 * t9081 + 0.12e2 * t9784 - 0.51947577317044391277e2 * t9786 + 0.35089341735807877242e1 * t9788 - t8901 - t8905 - t8909 - t8925 - 0.17090684152272775383e-2 * t9083;
  t9793 = t257 * t2712;
  t9794 = 0.24e2 * t9793;
  t9799 = 0.24e2 * t253 * t2712;
  t9800 = t2000 * t378;
  t9802 = t2222 * t378;
  t9803 = 0.144e3 * t9802;
  t9804 = t257 * t2726;
  t9806 = t253 * t2726;
  t9807 = 0.12e2 * t9806;
  t9808 = 0.36e2 * t9097;
  t9812 = -t9794 - 0.24e2 * t9087 - 0.4e1 * t9089 - 0.4e1 * t9091 + t9799 + 0.24e2 * t9800 - t9803 - 0.12e2 * t9804 + t9807 - t9808 + t9100 + 0.19751673498613801407e-1 * t9756 * t139 - t9104 + 0.18e3 * t9105 + t8942 - t8945;
  t9817 = 0.8e1 * t9147;
  t9818 = -t8957 - t8960 + t8963 - t9112 - 0.65061487801810439052e-1 * t9114 - t9118 + t9121 + 0.14447919941302971323e1 * t9122 + t9126 + 0.32530743900905219526e-1 * t9128 + 0.48796115851357829289e-1 * t9130 + t9134 + t9137 - t9140 - t9143 + t9146 + t9817;
  t9821 = t9642 + t9659 + t9682 + t9759 + t9777 + t9791 + t9812 + t9818;
  t9826 = t317 * t853;
  t9835 = t59 * t206 * t886;
  t9836 = 0.3e1 / 0.4e1 * t9835;
  t9839 = 0.119e3 / 0.6e1 * t9323;
  t9845 = t202 * t2634;
  t9846 = 0.7e1 / 0.2e1 * t9845;
  t9847 = t583 * t209;
  t9852 = 0.238e4 / 0.27e2 * t9369;
  t9853 = 0.7e1 / 0.2e1 * t9373;
  t9857 = t878 * t8 * t886 * t209;
  t9859 = 0.7e1 / 0.2e1 * t9329 + 0.3e1 / 0.2e1 * t9348 + t9836 + 0.119e3 / 0.12e2 * t9371 - 0.119e3 / 0.6e1 * t9321 + t9839 - 0.7e1 / 0.2e1 * t9325 - 0.3e1 / 0.2e1 * t9340 - 0.595e3 / 0.9e1 * t9367 - 0.7e1 / 0.12e2 * t9377 - t9383 / 0.4e1 - t9846 + 0.9e1 / 0.4e1 * t2640 * t879 * t9847 - 0.3e1 / 0.4e1 * t9358 - t9366 + t9852 + t9853 + 0.3e1 / 0.2e1 * t9380 - 0.3e1 * t9857;
  t9861 = t878 * t2644 * t583;
  t9863 = t565 * t573;
  t9864 = t9863 * t880;
  t9865 = 0.119e3 / 0.6e1 * t9864;
  t9866 = t2616 * t2622;
  t9868 = t2616 * t2625;
  t9870 = t59 * t9332;
  t9875 = t2640 * t2644 * t575;
  t9877 = t202 * t2263;
  t9878 = t9877 * t2641;
  t9881 = 0.14e2 * t2616 * t2645;
  t9895 = t565 * t883;
  t9896 = 0.119e3 / 0.6e1 * t9895;
  t9897 = t202 * t2629;
  t9900 = t59 * t579 * t2628;
  t9902 = t2247 * t361;
  t9904 = -t9524 - t9526 - t9529 + t9531 - t9533 + t9536 - t9539 + t9542 - t9545 - t9549 - t9552 + t9555 - t9559 + t9562;
  t9909 = t565 * t887;
  t9910 = 0.119e3 / 0.12e2 * t9909;
  t9912 = 0.7e1 * t202 * t2637;
  t9915 = t59 * t573 * t360 * t209;
  t9916 = 0.3e1 / 0.2e1 * t9915;
  t9917 = -0.3e1 / 0.2e1 * t9861 - t9865 + 0.7e1 * t9866 + 0.7e1 / 0.2e1 * t9868 - 0.3e1 * t9870 * t879 * t2265 + 0.9e1 / 0.2e1 * t9875 - 0.21e2 / 0.2e1 * t9878 + t9881 + 0.9e1 / 0.4e1 * t2640 * t2621 * t575 - 0.3e1 / 0.4e1 * t878 * t62 * t2628 * t209 - 0.3e1 / 0.4e1 * t878 * t2621 * t583 - t878 * t879 * t2323 / 0.4e1 + t9896 - 0.7e1 / 0.4e1 * t9897 + 0.3e1 / 0.4e1 * t9900 - 0.595e3 / 0.27e2 * t9902 + t59 * t207 * (t9904 + t9607) / 0.8e1 + t9910 - t9912 - t9916;
  t9939 = -0.5e2 / 0.27e2 * t190 * t549 * t2805 - 0.5e2 / 0.27e2 * t190 * t193 * t2485 * t522 - 0.5e2 / 0.81e2 * t190 * t193 * t902 * t2339 + 0.5e1 / 0.9e1 * t46 * t55 * t66 * t9821 + 0.2e4 / 0.27e2 * t9482 * t9826 - 0.4e5 / 0.729e3 * t351 * t2427 * t2431 + 0.5e1 / 0.9e1 * t46 * t55 * (t9859 + t9917) * t146 + 0.5e1 / 0.3e1 * t46 * t55 * t2655 * t316 + 0.2e4 / 0.81e2 * t543 * t892 * t545 + 0.2e4 / 0.81e2 * t543 * t896 * t545 + 0.5e1 / 0.9e1 * t2390 * t366 + 0.5e1 / 0.3e1 * t524 * t893 + 0.5e1 / 0.3e1 * t524 * t897;
  t9945 = t2372 * t5108;
  t9948 = t217 * t853;
  t9951 = t907 * params->c;
  t9952 = t325 * t9951;
  t9958 = t896 * params->c;
  t9959 = t325 * t9958;
  t9965 = t892 * params->c;
  t9966 = t325 * t9965;
  t9969 = t952 * params->c;
  t9970 = t325 * t9969;
  t9981 = 0.5e1 / 0.3e1 * t182 * t2657 + 0.1e2 / 0.3e1 * t182 * t2824 + 0.2e4 / 0.81e2 * t2371 * t9945 + 0.2e4 / 0.27e2 * t9482 * t9948 - 0.1e3 / 0.27e2 * t529 * t9952 + 0.2e4 / 0.81e2 * t543 * t383 * t1897 - 0.1e3 / 0.27e2 * t529 * t9959 + 0.2e4 / 0.81e2 * t543 * t365 * t1897 - 0.1e3 / 0.27e2 * t529 * t9966 - 0.1e3 / 0.27e2 * t529 * t9970 - 0.5e2 / 0.81e2 * t190 * t193 * t9437 * t350 - 0.1e3 / 0.27e2 * t2827 * t559 - 0.1e3 / 0.81e2 * t846 * t2406;
  t10019 = -0.1e3 / 0.27e2 * t846 * t2416 - 0.2e3 / 0.27e2 * t9410 * t2560 - 0.1e3 / 0.27e2 * t9410 * t2564 - 0.5e2 / 0.81e2 * t190 * t871 * t2405 - 0.2e3 / 0.27e2 * t9410 * t2497 - 0.1e3 / 0.27e2 * t190 * t549 * t2496 - 0.5e2 / 0.27e2 * t190 * t193 * t2419 * t841 - 0.1e3 / 0.27e2 * t190 * t549 * t2486 - 0.1e3 / 0.27e2 * t846 * t2402 - 0.5e2 / 0.27e2 * t190 * t871 * t2401 - 0.5e2 / 0.27e2 * t190 * t2549 * t558 + 0.5e1 / 0.3e1 * t182 * t2758 - 0.5e2 / 0.27e2 * t190 * t2409 * t861 - 0.5e2 / 0.27e2 * t190 * t2409 * t865;
  t10059 = -0.2e3 / 0.27e2 * t9410 * t2557 - 0.5e2 / 0.27e2 * t190 * t549 * t2563 - 0.1e3 / 0.27e2 * t9410 * t2554 - 0.5e2 / 0.81e2 * t190 * t9442 * t355 + 0.3e1 * t330 * t2756 + t156 * t9821 + 0.5e1 / 0.3e1 * t46 * t55 * t216 * t2756 + 0.5e1 / 0.3e1 * t46 * t55 * t589 * t951 + 0.1e2 / 0.3e1 * t182 * t2767 + 0.5e1 / 0.3e1 * t182 * t2763 + 0.5e1 / 0.9e1 * t46 * t55 * t2327 * t382 + 0.5e1 / 0.9e1 * t46 * t55 * t364 * t2240 - 0.1e5 / 0.243e3 * t2814 * t2815 * t522 * t3863;
  t10060 = t541 * t364;
  t10061 = t10060 * t1295;
  t10085 = t181 * t542;
  t10104 = 0.2e4 / 0.81e2 * t2371 * t10061 + 0.4e4 / 0.81e2 * t543 * t594 * t854 + 0.2e4 / 0.81e2 * t543 * t792 * t854 + 0.2e4 / 0.81e2 * t543 * t317 * t2474 + 0.4e4 / 0.81e2 * t543 * t217 * t2470 + 0.2e4 / 0.81e2 * t543 * t147 * t544 * t2544 * t180 + 0.2e4 / 0.81e2 * t543 * t147 * t2469 * t522 + 0.2e4 / 0.27e2 * t10085 * t2475 + 0.2e4 / 0.81e2 * t543 * t217 * t2474 + 0.2e4 / 0.243e3 * t543 * t147 * t853 * t2339 + 0.2e4 / 0.81e2 * t543 * t590 * t854 + 0.4e4 / 0.81e2 * t543 * t317 * t2470 - 0.5e2 / 0.27e2 * t190 * t871 * t2420;
  t10131 = t39 * t9274 * t9276;
  t10139 = t2 * t9608;
  t10146 = t962 * t40;
  t10161 = -0.2e4 / 0.243e3 * t805 * t806 * t350 * t2339 - 0.2e4 / 0.27e2 * t2779 * t2362 - 0.2e4 / 0.81e2 * t805 * t806 * t2544 * t180 - 0.2e4 / 0.81e2 * t805 * t806 * t841 * t522 + 0.1e5 / 0.243e3 * t2785 * t841 * t527 * t50 - 0.4e6 / 0.6561e4 * t10131 * t350 * t2347 * t189 + 0.4e5 / 0.729e3 * t351 * t2354 * t2358 - 0.5e1 / 0.9e1 * t10139 * t40 * t153 - 0.2e4 / 0.27e2 * t842 * t539 * t807 + 0.1e5 / 0.243e3 * t2785 * t10146 * t9281 + 0.1e3 / 0.27e2 * t2575 * t188 * t327 + 0.1e3 / 0.27e2 * t2776 * t811 + 0.1e3 / 0.81e2 * t959 * t2366 + 0.5e2 / 0.81e2 * t324 * t325 * params->c * t9608;
  t10163 = t382 * t2356;
  t10169 = t39 * t2354 * t364;
  t10174 = t9273 * t66;
  t10176 = t805 * t10174 * t146;
  t10183 = t805 * t2812 * t316;
  t10191 = t2353 * t216;
  t10193 = t805 * t10191 * t146;
  t10196 = t147 * t2469;
  t10201 = -0.1e3 / 0.27e2 * t2424 * t904 - 0.1e3 / 0.27e2 * t2424 * t872 + 0.3e1 * t2802 * t316 + t10161 * t146 - 0.1e5 / 0.729e3 * t2428 * t10163 * t2347 * t50 - 0.1e5 / 0.729e3 * t10169 * t2431 + 0.5e1 / 0.3e1 * t843 * t793 + 0.4e6 / 0.6561e4 * t10176 * t9276 * t350 * t2347 * t189 - 0.1e5 / 0.243e3 * t10183 * t2817 - 0.1e5 / 0.243e3 * t2814 * t2356 * t841 * t527 * t50 - 0.1e5 / 0.243e3 * t10193 * t2817 + 0.2e4 / 0.27e2 * t9482 * t10196 + 0.5e1 / 0.9e1 * t352 * t2329;
  t10234 = 0.5e1 / 0.3e1 * t352 * t2333 + 0.2e4 / 0.81e2 * t543 * t907 * t545 + 0.2e4 / 0.81e2 * t543 * t952 * t545 + 0.5e1 / 0.3e1 * t182 * t2596 + 0.5e1 / 0.3e1 * t46 * t55 * t891 * t791 + 0.5e1 / 0.9e1 * t10139 * t45 * t148 + 0.5e1 / 0.3e1 * t2576 * t218 + 0.5e1 / 0.3e1 * t2576 * t318 + 0.5e1 / 0.3e1 * t843 * t591 + 0.1e2 / 0.3e1 * t843 * t595 + 0.5e1 / 0.3e1 * t352 * t2380 + 0.5e1 / 0.9e1 * t352 * t2242 + 0.3e1 * t814 * t951 + t2369 * t382;
  t10254 = t9 * (t9616 + t9939 + t9981 + t10019 + t10059 + t10104 + t10201 + t10234) - 0.1e3 / 0.27e2 * t2464 + 0.4e4 / 0.81e2 * t2467 + 0.4e4 / 0.81e2 * t2472 + 0.2e4 / 0.81e2 * t2476 - 0.1e3 / 0.27e2 * t2480 + 0.4e4 / 0.81e2 * t2483 + t1900 - t1904 - t1908 - 0.1e3 / 0.27e2 * t2488 - 0.1e3 / 0.27e2 * t2491 - 0.5e2 / 0.27e2 * t2494 - 0.1e3 / 0.27e2 * t2498 - 0.5e2 / 0.27e2 * t2547 - 0.1e3 / 0.27e2 * t2551 - 0.5e2 / 0.27e2 * t2555 - 0.1e3 / 0.27e2 * t2558 - 0.1e3 / 0.27e2 * t2561;
  t10274 = -0.5e2 / 0.27e2 * t2565 - 0.2e3 / 0.27e2 * t2567 - 0.2e3 / 0.27e2 * t2569 - 0.1e3 / 0.27e2 * t2571 + 0.5e1 / 0.3e1 * t2573 + 0.5e1 / 0.3e1 * t2577 + 0.1e2 / 0.3e1 * t2579 + 0.1e2 / 0.3e1 * t2581 + 0.2e4 / 0.27e2 * t2584 + 0.5e1 / 0.3e1 * t2586 + 0.1e2 / 0.3e1 * t2590 + t1910 + 0.2e4 / 0.81e2 * t2593 + 0.5e1 / 0.3e1 * t2597 + 0.5e1 / 0.3e1 * t2599 + 0.1e2 / 0.3e1 * t2601 + 0.1e2 / 0.3e1 * t2603 + 0.5e1 / 0.3e1 * t2605 + 0.1e2 / 0.3e1 * t2607 + 0.1e2 / 0.3e1 * t2609;
  t10285 = 0.2e4 / 0.81e2 * t2612 + 0.5e1 / 0.3e1 * t2658 + 0.5e1 / 0.3e1 * t2759 + t2244 + t2331 + t2335 + 0.5e1 / 0.3e1 * t2764 + 0.1e2 / 0.3e1 * t2768 + t2337 + t2370 + t2375 + 0.3e1 * t2770 + 0.6e1 * t2771 + 0.3e1 * t2803 + t2376 + 0.3e1 * t2804 + t2378 + t2382 + t2385 + t2389;
  t10293 = t2392 + t2394 + t2396 + t2398 + t2400 - 0.5e2 / 0.27e2 * t2807 - 0.1e3 / 0.27e2 * t2810 - t2404 - t2408 - t2412 - t2415 - t2418 - t2423 - t2426 - 0.1e5 / 0.243e3 * t2818 - t2433 + 0.6e1 * t2820 + 0.3e1 * t2822 + 0.1e2 / 0.3e1 * t2825 - 0.2e3 / 0.27e2 * t2828;
  tv4rho41 = t10254 + t10274 + t10285 + t10293;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t10307 = -0.2e3 / 0.81e2 * t2464 + 0.8e4 / 0.243e3 * t2467 + 0.8e4 / 0.243e3 * t2472 + 0.4e4 / 0.243e3 * t2476 - 0.2e3 / 0.81e2 * t2480 + 0.8e4 / 0.243e3 * t2483 + 0.1e2 / 0.9e1 * t2920 - 0.2e3 / 0.81e2 * t2488 - 0.2e3 / 0.81e2 * t2491 - 0.1e3 / 0.81e2 * t2494 - 0.2e3 / 0.81e2 * t2498 - 0.1e3 / 0.81e2 * t2547;
  t10321 = -0.2e3 / 0.81e2 * t2551 - 0.1e3 / 0.81e2 * t2555 - 0.2e3 / 0.81e2 * t2558 - 0.2e3 / 0.81e2 * t2561 - 0.1e3 / 0.81e2 * t2565 - 0.4e3 / 0.81e2 * t2567 - 0.4e3 / 0.81e2 * t2569 - 0.2e3 / 0.81e2 * t2571 + 0.1e2 / 0.9e1 * t2573 + 0.1e2 / 0.9e1 * t2577 + 0.2e2 / 0.9e1 * t2579 + 0.2e2 / 0.9e1 * t2581 + 0.4e4 / 0.81e2 * t2584;
  t10335 = t841 * t841;
  t10359 = t343 * t512;
  t10361 = 0.2e3 / 0.27e2 * t10359 * t2532;
  t10363 = 0.2e3 / 0.27e2 * t9543 * t2973;
  t10366 = 0.2e2 / 0.3e1 * t2510 * t2972 * t98;
  t10369 = 0.2e2 / 0.3e1 * t2531 * t2997 * t98;
  t10371 = 0.5e2 / 0.9e1 * t161 * t2984;
  t10373 = 0.2e3 / 0.27e2 * t994 * t518;
  t10375 = 0.4e3 / 0.81e2 * t994 * t514;
  t10377 = 0.5e2 / 0.9e1 * t343 * t2538;
  t10379 = 0.4e3 / 0.81e2 * t496 * t984;
  t10381 = 0.2e3 / 0.27e2 * t496 * t988;
  t10384 = 0.4e2 / 0.27e2 * t9546 * t4960 * t507;
  t10387 = 0.4e2 / 0.27e2 * t9556 * t5202 * t507;
  t10389 = 0.5e2 / 0.3e1 * t343 * t2541;
  t10393 = 0.4e2 / 0.81e2 * t22 * t9235 * t999 * t513;
  t10396 = 0.2e2 / 0.9e1 * t22 * t833 * t506;
  t10400 = 0.1e2 / 0.27e2 * t22 * t2310 * t1003 * t513;
  t10401 = t10361 - t10363 - t10366 + t10369 - t10371 + t10373 + t10375 + t10377 + t10379 + t10381 - t10384 + t10387 - t9212 - t10389 + t10393 - t10396 - t10400;
  t10449 = 0.4e2 / 0.81e2 * t7 * t9219 * t983 * t502 - 0.1e3 / 0.27e2 * t161 * t2979 + 0.2e2 / 0.9e1 * t7 * t501 * t2983 * t167 + 0.1e2 / 0.9e1 * t7 * t2978 * t508 - 0.1e3 / 0.27e2 * t343 * t2535 - 0.1e2 / 0.27e2 * t22 * t2993 * t517 + 0.2e2 / 0.9e1 * t22 * t512 * t62 * t769 + 0.2e2 / 0.9e1 * t22 * t512 * t3005 * t171 + 0.1e2 / 0.9e1 * t22 * t3001 * t517 + 0.1e3 / 0.81e2 * t161 * t2969 - 0.1e2 / 0.27e2 * t7 * t2968 * t508 + 0.2e2 / 0.9e1 * t7 * t501 * t62 * t769 + 0.2e2 / 0.9e1 * t7 * t823 * t506 - 0.1e2 / 0.27e2 * t7 * t2296 * t987 * t502 + 0.1e3 / 0.81e2 * t343 * t2528 + t9593 - t9604;
  t10450 = t10401 + t10449;
  t10451 = t2 * t10450;
  t10461 = -0.2e3 / 0.81e2 * t190 * t193 * t2485 * t841 - 0.4e3 / 0.81e2 * t9410 * t3167 - 0.1e3 / 0.81e2 * t190 * t193 * t902 * t2544 + 0.4e4 / 0.243e3 * t543 * t147 * t544 * t10335 + 0.4e4 / 0.243e3 * t543 * t1051 * t545 + 0.2e4 / 0.243e3 * t543 * t1085 * t545 + 0.1e2 / 0.9e1 * t1009 * t595 + 0.5e1 / 0.9e1 * t1009 * t793 + 0.2e4 / 0.243e3 * t543 * t1047 * t545 + 0.2e2 / 0.9e1 * t352 * t2824 + 0.1e2 / 0.9e1 * t352 * t2596 + 0.2e4 / 0.81e2 * t3045 * t9484 + 0.5e1 / 0.9e1 * t10451 * t45 * t148 + 0.1e2 / 0.9e1 * t3038 * t218 + 0.1e2 / 0.9e1 * t3038 * t318 + 0.5e1 / 0.9e1 * t1009 * t591;
  t10471 = t2429 * t1012;
  t10472 = t10471 * t50;
  t10510 = 0.1e2 / 0.9e1 * t2576 * t366 + 0.2e2 / 0.9e1 * t843 * t893 + 0.2e2 / 0.9e1 * t843 * t897 + 0.1e2 / 0.9e1 * t352 * t2657 - 0.4e5 / 0.729e3 * t528 * t2427 * t10472 - 0.1e3 / 0.81e2 * t190 * t871 * t2805 - 0.4e3 / 0.81e2 * t9410 * t3156 - 0.2e3 / 0.81e2 * t190 * t2549 * t865 - 0.2e3 / 0.81e2 * t190 * t871 * t2496 - 0.1e3 / 0.81e2 * t190 * t871 * t2545 - 0.4e3 / 0.81e2 * t9410 * t3159 - 0.1e3 / 0.81e2 * t190 * t2409 * t1028 - 0.2e3 / 0.81e2 * t190 * t549 * t3162 - 0.5e2 / 0.81e2 * t190 * t193 * t3136 * t522 - 0.2e3 / 0.81e2 * t9410 * t3142 - 0.1e3 / 0.81e2 * t190 * t549 * t3141 - 0.5e2 / 0.81e2 * t190 * t193 * t2419 * t1007;
  t10512 = t1085 * params->c;
  t10513 = t325 * t10512;
  t10552 = t192 * t3014;
  t10585 = my_piecewise3(t100, 0, 0.4e2 / 0.81e2 * t9039 * t1055 * t641 - 0.64e2 / 0.27e2 * t2678 * t166 * t8 * t506 - 0.8e1 / 0.27e2 * t2852 * t644 + 0.32e2 / 0.9e1 * t640 * t62 * t769 + 0.16e2 / 0.9e1 * t925 * t506 - 0.16e2 / 0.3e1 * t925 * t2000 - 0.8e1 / 0.27e2 * t1993 * t1058 * t641 + 0.8e1 / 0.9e1 * t640 * t2862 * t166 + 0.4e1 / 0.9e1 * t2857 * t644 + t9725);
  t10611 = my_piecewise3(t106, 0, 0.4e2 / 0.81e2 * t9059 * t1063 * t651 + 0.64e2 / 0.27e2 * t2693 * t263 * t8 * t506 - 0.8e1 / 0.27e2 * t2867 * t654 + 0.32e2 / 0.9e1 * t650 * t62 * t769 - 0.16e2 / 0.9e1 * t933 * t506 + 0.16e2 / 0.3e1 * t933 * t2000 - 0.8e1 / 0.27e2 * t2008 * t1066 * t651 + 0.8e1 / 0.9e1 * t650 * t2875 * t263 + 0.4e1 / 0.9e1 * t2872 * t654 - t9752);
  t10613 = (t10585 + t10611) * t113;
  t10617 = t99 * t1072 * t752;
  t10625 = t2881 * t129 * t313;
  t10627 = t2894 * t633;
  t10630 = 0.24415263074675393405e-3 * t8566 - t8573 + t8579 - t8586 + 0.19751673498613801407e-1 * t10613 * t139 + t10617 + t8591 - 0.36622894612013090108e-3 * t9631 - 0.11696447245269292414e1 * t8592 - 0.5848223622634646207e0 * t8594 - 0.17315859105681463759e2 * t8596 - 0.20508037716432813316e4 * t8598 - 0.70178683471615754484e1 * t9637 + t8606 - 0.11696447245269292414e1 * t10625 - 0.5848223622634646207e0 * t10627 + 0.2077903092681775651e3 * t8607;
  t10635 = t257 * t2884;
  t10638 = t253 * t2884;
  t10645 = 0.2e2 * t8612 + 0.16e3 * t9643 - 0.24e3 * t9645 + 0.8e2 * t9647 - 0.8e1 * t10635 + 0.64e2 * t8614 + 0.8e1 * t10638 - t8620 + t8624 - 0.65061487801810439052e-1 * t8625 + t8630 + t8634 + 0.2077903092681775651e3 * t9651 + 0.46785788981077169656e1 * t9653 + 0.12e3 * t9655 - t8638 - 0.70178683471615754484e1 * t8639 + t8644;
  t10654 = t2894 * t604;
  t10657 = t253 * t2882;
  t10659 = t257 * t2882;
  t10664 = t1072 * t70 * t780;
  t10666 = -t8649 + 0.70178683471615754484e1 * t8650 - 0.10389515463408878255e3 * t8654 + t8659 + t8663 - 0.11696447245269292414e1 * t9662 - 0.23392894490538584828e1 * t9664 - 0.11696447245269292414e1 * t9667 - 0.20508037716432813315e4 * t9669 - 0.69263436422725855034e2 * t9671 - 0.17315859105681463759e2 * t10654 - 0.24e2 * t9673 + 0.8e1 * t10657 - 0.8e1 * t10659 - 0.64e2 * t9675 - 0.48e2 * t9677 + 0.10843581300301739842e-1 * t10664;
  t10677 = t8667 + t8674 - t8677 - 0.65061487801810439052e-1 * t9680 - 0.43374325201206959368e-1 * t9683 + 0.32530743900905219526e-1 * t9685 + 0.96319466275353142155e0 * t9687 + 0.43374325201206959368e-1 * t9690 + 0.12e2 * t8678 + 0.97661052298701573622e-3 * t9693 - 0.11393789434848516923e-2 * t9695 + t8682 + t8690 - t8693 + t8974 + 0.2e1 * t9698 - 0.24e2 * t8976 - t8835;
  t10682 = t99 * t2881 * t301;
  t10691 = t770 * t1073;
  t10693 = t773 * t1073;
  t10695 = t776 * t1073;
  t10697 = 0.32e2 * t8978 - t8984 + t8838 + t8842 - t8845 + 0.2e1 * t10682 + 0.4e1 * t9763 + 0.2e1 * t9766 - 0.8e1 * t9767 + 0.2e1 * t8986 - t8991 + t99 * t10613 * t141 + 0.11696447245269292414e1 * t8992 - t8997 + 0.2e2 * t10691 + 0.12e2 * t10693 - 0.32e2 * t10695;
  t10708 = -t8999 + 0.48e2 * t9000 + 0.96e2 * t9009 + 0.192e3 * t9011 + t8862 - t9014 - 0.16e3 * t9015 - 0.8e1 * t9017 - 0.24e3 * t9022 + t9026 - 0.48e3 * t9032 + t9081 - 0.8e1 * t9784 - 0.10389515463408878255e3 * t9786 + 0.70178683471615754484e1 * t9788 - t8901 - t8905 - t8909;
  t10711 = t2894 * t787;
  t10722 = t2888 * t664;
  t10725 = t2881 * t67 * t308;
  t10728 = -t8925 - 0.11393789434848516922e-2 * t9083 + 0.11696447245269292414e1 * t10711 - 0.8e1 * t9085 - 0.32e2 * t9793 - 0.8e1 * t9087 - 0.48e2 * t9800 + 0.96e2 * t9802 - 0.24e2 * t9804 - 0.24e2 * t9095 + 0.8e1 * t9806 - 0.24e2 * t9097 + t9100 + t9104 + 0.24415263074675393405e-3 * t10722 - 0.36622894612013090108e-3 * t10725 + 0.12e3 * t9105;
  t10733 = t8942 - t8945 - t8957 - t8960 + t8963 - t9112 - 0.43374325201206959368e-1 * t9114 - t9118 + t9121 + 0.96319466275353142156e0 * t9122 + t9126 + 0.10843581300301739842e-1 * t9128 + 0.32530743900905219526e-1 * t9130 + t9134 + t9137 - t9140 - t9143 + t9146;
  t10736 = t10630 + t10645 + t10666 + t10677 + t10697 + t10708 + t10728 + t10733;
  t10738 = -0.1e3 / 0.81e2 * t529 * t10513 + 0.1e2 / 0.9e1 * t46 * t55 * t364 * t2756 + 0.1e2 / 0.9e1 * t46 * t55 * t2655 * t382 + 0.2e2 / 0.9e1 * t46 * t55 * t891 * t951 + 0.1e2 / 0.9e1 * t524 * t1052 + 0.4e4 / 0.243e3 * t543 * t365 * t2474 - 0.1e3 / 0.81e2 * t1014 * t9310 - 0.2e3 / 0.81e2 * t1014 * t9314 - 0.1e3 / 0.81e2 * t1014 * t9306 - 0.1e3 / 0.81e2 * t190 * t193 * t553 * t3036 - 0.2e3 / 0.81e2 * t9410 * t3146 - 0.1e3 / 0.81e2 * t190 * t549 * t3145 - 0.5e2 / 0.81e2 * t190 * t193 * t194 * t10450 - 0.1e3 / 0.81e2 * t190 * t10552 * t195 - 0.1e3 / 0.81e2 * t190 * t3149 * t554 + t156 * t10736;
  t10743 = t1047 * params->c;
  t10744 = t325 * t10743;
  t10758 = t2917 * params->c;
  t10763 = t2353 * t364;
  t10765 = t805 * t10763 * t146;
  t10791 = 0.2e1 * t394 * t2756 + 0.2e1 * t2802 * t382 - 0.1e3 / 0.81e2 * t529 * t10744 + 0.5e1 / 0.9e1 * t524 * t1086 + 0.1e2 / 0.9e1 * t182 * t3131 + 0.1e2 / 0.9e1 * t46 * t55 * t216 * t2917 - 0.1e3 / 0.81e2 * t190 * t549 * t3137 - 0.1e3 / 0.81e2 * t190 * t193 * t10758 * t180 - 0.2e5 / 0.729e3 * t10765 * t2817 + 0.2e2 / 0.9e1 * t843 * t953 + 0.8e4 / 0.243e3 * t543 * t383 * t2470 + 0.4e4 / 0.243e3 * t543 * t217 * t3114 + 0.8e4 / 0.243e3 * t543 * t892 * t854 + 0.8e4 / 0.243e3 * t543 * t896 * t854 + 0.8e4 / 0.243e3 * t543 * t952 * t854 + 0.8e4 / 0.243e3 * t543 * t907 * t854 + 0.4e4 / 0.243e3 * t543 * t317 * t3114;
  t10802 = t2 * t10335;
  t10806 = t1051 * params->c;
  t10807 = t325 * t10806;
  t10846 = 0.4e4 / 0.243e3 * t543 * t147 * t544 * t3036 * t180 + 0.8e4 / 0.243e3 * t543 * t365 * t2470 - 0.2e3 / 0.81e2 * t10802 * t188 * t531 - 0.2e3 / 0.81e2 * t529 * t10807 + 0.8e4 / 0.243e3 * t543 * t217 * t3118 + 0.8e4 / 0.243e3 * t543 * t317 * t3118 + 0.4e4 / 0.243e3 * t543 * t147 * t853 * t2544 + 0.8e4 / 0.81e2 * t2583 * t2471 + 0.4e4 / 0.243e3 * t543 * t383 * t2474 + 0.2e4 / 0.243e3 * t543 * t147 * t3113 * t522 - 0.4e5 / 0.729e3 * t2814 * t2815 * t841 * t3863 + 0.2e1 * t3106 * t316 + 0.4e1 * t970 * t951 - 0.5e2 / 0.81e2 * t190 * t3149 * t558 - 0.2e3 / 0.81e2 * t190 * t2549 * t903 - 0.2e3 / 0.81e2 * t190 * t871 * t2486;
  t10866 = t805 * t2812 * t382;
  t10888 = t1008 * t539;
  t10891 = t806 * t522;
  t10898 = t9446 * t50;
  t10901 = t152 * t841;
  t10943 = t3037 * t188;
  t10948 = -0.2e4 / 0.81e2 * t10888 * t807 - 0.2e4 / 0.81e2 * t3086 * t10891 - 0.5e1 / 0.9e1 * t10451 * t40 * t153 + 0.4e5 / 0.729e3 * t1013 * t2354 * t10898 + 0.4e5 / 0.729e3 * t2785 * t10146 * t10901 + 0.1e5 / 0.729e3 * t2785 * t1012 * t522 * t50 - 0.4e6 / 0.6561e4 * t10131 * t1012 * t527 * t189 + 0.1e5 / 0.729e3 * t2785 * t1007 * t527 * t50 - 0.4e4 / 0.243e3 * t805 * t806 * t10335 - 0.4e4 / 0.243e3 * t805 * t806 * t350 * t2544 - 0.4e4 / 0.243e3 * t805 * t806 * t3036 * t180 - 0.2e4 / 0.243e3 * t805 * t806 * t1007 * t522 - 0.8e4 / 0.81e2 * t2779 * t2791 + 0.2e3 / 0.81e2 * t10802 * t185 * t802 + 0.2e3 / 0.81e2 * t959 * t2799 + 0.5e2 / 0.81e2 * t324 * t325 * params->c * t10450 + 0.2e3 / 0.81e2 * t10943 * t327 + 0.1e3 / 0.81e2 * t3081 * t811;
  t10952 = -0.2e3 / 0.81e2 * t846 * t2493 + t1102 * t791 + 0.1e2 / 0.9e1 * t182 * t2919 - 0.2e5 / 0.729e3 * t10193 * t3073 - 0.2e5 / 0.729e3 * t10183 * t3073 - 0.1e5 / 0.729e3 * t2814 * t3071 * t522 * t50 + 0.4e6 / 0.6561e4 * t10176 * t9276 * t1012 * t527 * t189 - 0.2e5 / 0.729e3 * t10866 * t2817 - 0.1e5 / 0.729e3 * t2814 * t2356 * t1007 * t527 * t50 + 0.1e2 / 0.9e1 * t352 * t2758 + 0.1e2 / 0.9e1 * t352 * t2763 + 0.2e2 / 0.9e1 * t352 * t2767 + 0.1e2 / 0.9e1 * t2576 * t384 + 0.2e2 / 0.9e1 * t843 * t908 + 0.5e1 / 0.9e1 * t46 * t55 * t589 * t1084 + t10948 * t146 + 0.2e1 * t330 * t2917;
  t10967 = t217 * t1896;
  t10970 = t317 * t1896;
  t10992 = t814 * t1084 + 0.2e2 / 0.9e1 * t182 * t3027 + 0.2e2 / 0.9e1 * t182 * t3031 + 0.1e2 / 0.9e1 * t46 * t55 * t3014 * t316 + 0.5e1 / 0.9e1 * t46 * t55 * t1046 * t791 + 0.4e4 / 0.81e2 * t3045 * t10967 + 0.4e4 / 0.81e2 * t3045 * t10970 + 0.2e4 / 0.81e2 * t1008 * t542 * t546 + 0.4e4 / 0.81e2 * t2583 * t2611 + 0.4e4 / 0.81e2 * t2583 * t2592 - 0.1e3 / 0.81e2 * t2933 * t559 - 0.4e3 / 0.81e2 * t846 * t2560 - 0.4e3 / 0.81e2 * t846 * t2497 - 0.2e3 / 0.81e2 * t846 * t2546 - 0.2e3 / 0.81e2 * t846 * t2806 - 0.4e3 / 0.81e2 * t9410 * t2927;
  t11028 = t2616 * t2960;
  t11044 = t878 * t2644 * t886;
  t11046 = t9877 * t2947;
  t11048 = t2616 * t2953;
  t11055 = t2640 * t8 * t1037 * t209;
  t11062 = t878 * t8 * t1042 * t209;
  t11063 = 0.7e1 / 0.3e1 * t11028 - t878 * t62 * t3009 * t209 / 0.2e1 - t878 * t2959 * t583 / 0.4e1 - t878 * t879 * t2628 / 0.2e1 + 0.3e1 / 0.4e1 * t2640 * t2946 * t583 - 0.2e1 * t11044 - 0.7e1 * t11046 + 0.14e2 / 0.3e1 * t11048 - 0.3e1 * t9870 * t2946 * t575 + 0.3e1 * t11055 + 0.3e1 / 0.4e1 * t2640 * t2959 * t575 - t11062;
  t11071 = t209 * t886;
  t11075 = t202 * t2963;
  t11077 = t565 * t1043;
  t11079 = t202 * t3010;
  t11081 = -t9835 + 0.119e3 / 0.36e2 * t9371 - 0.119e3 / 0.18e2 * t9321 - 0.119e3 / 0.9e1 * t9323 - 0.14e2 / 0.3e1 * t9327 - 0.119e4 / 0.27e2 * t9367 + 0.7e1 / 0.3e1 * t9375 + 0.7e1 / 0.3e1 * t9845 + 0.3e1 * t2640 * t879 * t11071 - 0.7e1 / 0.3e1 * t11075 + 0.119e3 / 0.36e2 * t11077 - 0.7e1 / 0.6e1 * t11079;
  t11084 = t59 * t579 * t3009;
  t11086 = t10361 - t10363 - t10366 + t10369 - t10371 + t10373 + t10375 + t10377 + t10379 + t10381 - t10384 + t10387 - t10389 + t10393 - t10396 - t10400;
  t11091 = t565 * t1038;
  t11093 = t202 * t2950;
  t11095 = t886 * t886;
  t11104 = t11084 / 0.2e1 + t59 * t207 * (t11086 + t10449) / 0.8e1 - 0.119e3 / 0.18e2 * t11091 + 0.14e2 / 0.3e1 * t11093 - t59 * t574 * t11095 / 0.2e1 + t9358 / 0.4e1 - t9366 + 0.7e1 / 0.3e1 * t9373 - t9380 / 0.2e1 + 0.2e1 * t9857 + t9861 - 0.238e3 / 0.9e1 * t9864;
  t11117 = t59 * t206 * t1042;
  t11120 = t59 * t573 * t1037;
  t11122 = 0.14e2 / 0.3e1 * t9866 + 0.7e1 / 0.3e1 * t9868 - 0.3e1 * t9875 - 0.7e1 * t9878 + 0.119e3 / 0.9e1 * t9360 + 0.119e3 / 0.9e1 * t9895 - 0.7e1 / 0.6e1 * t9897 - t9900 / 0.2e1 - 0.119e4 / 0.27e2 * t9902 + 0.119e3 / 0.9e1 * t9909 + 0.2e1 * t9915 + t11117 / 0.4e1 - t11120 / 0.2e1;
  t11138 = -0.1e3 / 0.81e2 * t190 * t9502 * t355 - 0.2e3 / 0.81e2 * t190 * t2549 * t861 - 0.4e3 / 0.81e2 * t9410 * t2930 - 0.1e3 / 0.81e2 * t190 * t871 * t2563 - 0.2e3 / 0.81e2 * t9410 * t2922 - 0.5e2 / 0.81e2 * t190 * t2409 * t1032 - 0.2e3 / 0.81e2 * t190 * t549 * t3166 - 0.4e3 / 0.81e2 * t9410 * t3163 - 0.1e3 / 0.81e2 * t190 * t193 * t9506 * t350 + 0.5e1 / 0.9e1 * t46 * t55 * t66 * t10736 + 0.5e1 / 0.9e1 * t524 * t1048 + 0.1e2 / 0.9e1 * t182 * t3016 + 0.1e2 / 0.9e1 * t182 * t3020 + 0.5e1 / 0.9e1 * t46 * t55 * (t11063 + t11081 + t11104 + t11122) * t146 + 0.2e4 / 0.243e3 * t543 * t590 * t1021 + 0.4e4 / 0.243e3 * t543 * t594 * t1021 + 0.2e4 / 0.243e3 * t543 * t792 * t1021;
  t11152 = 0.1e2 / 0.9e1 * t2586 + 0.2e2 / 0.9e1 * t2590 + t9 * (t10461 + t10510 + t10738 + t10791 + t10846 + t10952 + t10992 + t11138) + 0.4e4 / 0.243e3 * t2593 + 0.1e2 / 0.9e1 * t2597 + 0.1e2 / 0.9e1 * t2599 + 0.2e2 / 0.9e1 * t2601 + 0.2e2 / 0.9e1 * t2603 + 0.1e2 / 0.9e1 * t2605 + 0.2e2 / 0.9e1 * t2607 + 0.2e2 / 0.9e1 * t2609 + 0.4e4 / 0.243e3 * t2612;
  t11166 = 0.1e2 / 0.9e1 * t2658 + 0.1e2 / 0.9e1 * t2759 + 0.1e2 / 0.9e1 * t2764 + 0.2e2 / 0.9e1 * t2768 - 0.1e3 / 0.81e2 * t2923 - 0.4e3 / 0.81e2 * t2925 - 0.2e3 / 0.81e2 * t2928 - 0.2e3 / 0.81e2 * t2931 - 0.2e3 / 0.81e2 * t2934 - 0.4e3 / 0.81e2 * t2936 - 0.4e3 / 0.81e2 * t2938 + 0.2e1 * t2770 + 0.4e1 * t2771;
  t11181 = 0.2e1 * t2803 + 0.2e1 * t2940 + 0.1e2 / 0.9e1 * t3017 + 0.1e2 / 0.9e1 * t3021 + 0.2e2 / 0.9e1 * t3023 + 0.2e2 / 0.9e1 * t3028 + 0.2e2 / 0.9e1 * t3032 + 0.1e2 / 0.9e1 * t3034 + 0.1e2 / 0.9e1 * t3039 + 0.1e2 / 0.9e1 * t3041 + 0.1e2 / 0.9e1 * t3043 + 0.4e4 / 0.81e2 * t3047;
  t11195 = 0.2e2 / 0.9e1 * t3049 + 0.2e2 / 0.9e1 * t3051 + 0.2e2 / 0.9e1 * t3053 + 0.2e2 / 0.9e1 * t3055 + 0.2e2 / 0.9e1 * t3057 + 0.2e2 / 0.9e1 * t3059 + 0.4e4 / 0.243e3 * t3064 + 0.4e4 / 0.243e3 * t3067 + 0.1e2 / 0.9e1 * t3069 + 0.2e1 * t2804 - 0.1e3 / 0.81e2 * t2807 - 0.2e3 / 0.81e2 * t2810 - 0.2e5 / 0.729e3 * t2818;
  t11210 = -0.2e5 / 0.729e3 * t3074 + 0.4e1 * t3076 + 0.2e1 * t3107 + 0.4e1 * t3108 + 0.4e1 * t2820 + 0.2e1 * t2822 + 0.8e4 / 0.243e3 * t3111 + 0.4e4 / 0.243e3 * t3116 + 0.8e4 / 0.243e3 * t3120 + 0.8e4 / 0.243e3 * t3123 - 0.2e3 / 0.81e2 * t3125 - 0.2e3 / 0.81e2 * t3128 + 0.1e2 / 0.9e1 * t3132;
  t11224 = 0.2e1 * t3134 + 0.2e1 * t3135 + 0.2e2 / 0.9e1 * t2825 - 0.4e3 / 0.81e2 * t2828 - 0.1e3 / 0.81e2 * t3139 - 0.1e3 / 0.81e2 * t3143 - 0.1e3 / 0.81e2 * t3147 - 0.1e3 / 0.81e2 * t3151 - 0.2e3 / 0.81e2 * t3154 - 0.2e3 / 0.81e2 * t3157 - 0.2e3 / 0.81e2 * t3160 - 0.2e3 / 0.81e2 * t3164 - 0.2e3 / 0.81e2 * t3168;
  tv4rho42 = t10307 + t10321 + t11152 + t11166 + t11181 + t11195 + t11210 + t11224;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t11239 = 0.6e1 * t98 + 0.12e2 * t9034;
  t11242 = 0.5e1 / 0.3e1 * t7 * t15 * t11239;
  t11246 = 0.1e2 / 0.9e1 * t9546 * t983 * t8 * t506;
  t11247 = t336 * t987;
  t11250 = 0.1e2 / 0.9e1 * t9546 * t11247 * t167;
  t11253 = 0.1e2 / 0.3e1 * t2510 * t507 * t987;
  t11255 = 0.1e3 / 0.9e1 * t10359 * t2998;
  t11259 = 0.1e2 / 0.9e1 * t9556 * t999 * t8 * t506;
  t11260 = t346 * t1003;
  t11263 = 0.1e2 / 0.9e1 * t9556 * t11260 * t171;
  t11266 = 0.1e2 / 0.3e1 * t2531 * t507 * t1003;
  t11268 = 0.5e2 / 0.9e1 * t161 * t3243;
  t11272 = 0.4e2 / 0.81e2 * t7 * t9219 * t3239 * t167;
  t11275 = 0.1e2 / 0.3e1 * t7 * t823 * t2983;
  t11276 = t11242 - t9212 - t11246 - t11250 + t11253 + t11255 + t11259 - t11263 - t11266 - t11268 + t11272 + t11275;
  t11280 = 0.1e2 / 0.9e1 * t7 * t501 * t3246 * t167;
  t11282 = 0.4e3 / 0.27e2 * t994 * t834;
  t11284 = 0.2e3 / 0.9e1 * t994 * t838;
  t11286 = 0.5e2 / 0.27e2 * t343 * t2994;
  t11288 = 0.5e2 / 0.9e1 * t343 * t3002;
  t11292 = 0.4e2 / 0.81e2 * t22 * t9235 * t3262 * t171;
  t11295 = 0.1e2 / 0.3e1 * t22 * t833 * t3005;
  t11299 = 0.1e2 / 0.9e1 * t22 * t512 * t3269 * t171;
  t11301 = 0.22e4 / 0.81e2 * t3253 * t172;
  t11303 = 0.25e2 / 0.3e1 * t343 * t3006;
  t11307 = -0.5e1 / 0.3e1 * t22 * t26 * t11239;
  t11309 = 0.5e2 / 0.81e2 * t161 * t3240;
  t11311 = 0.25e2 / 0.9e1 * t161 * t3247;
  t11312 = t11280 + t11282 - t11284 + t11286 - t11288 + t11292 + t11295 + t11299 - t11301 - t11303 + t11307 + t11309 - t11311;
  t11313 = t11276 + t11312;
  t11314 = t2 * t11313;
  t11334 = -0.1e5 / 0.243e3 * t2814 * t2815 * t1007 * t3863 + 0.2e4 / 0.81e2 * t3177 * t8560 + t330 * t3231 + 0.5e1 / 0.3e1 * t352 * t2919 + 0.5e1 / 0.9e1 * t11314 * t45 * t148 + 0.5e1 / 0.9e1 * t3308 * t218 + 0.5e1 / 0.9e1 * t3308 * t318 + 0.5e1 / 0.3e1 * t3038 * t366 + 0.5e1 / 0.3e1 * t1009 * t893 + 0.1e2 / 0.3e1 * t352 * t3031 + 0.5e1 / 0.3e1 * t843 * t1086 + 0.5e1 / 0.3e1 * t352 * t3131 + 0.1e2 / 0.3e1 * t843 * t1052;
  t11363 = 0.12e2 * t98 + 0.24e2 * t9034;
  t11367 = my_piecewise3(t100, 0, 0.4e2 / 0.81e2 * t9039 * t3182 * t166 - 0.16e2 / 0.9e1 * t2852 * t507 - 0.8e1 / 0.9e1 * t2678 * t1058 * t166 + 0.8e1 / 0.3e1 * t2681 * t506 * t1058 + 0.4e1 / 0.3e1 * t925 * t2862 + 0.4e1 / 0.9e1 * t640 * t3188 * t166 + 0.4e1 / 0.3e1 * t103 * t11363);
  t11388 = my_piecewise3(t106, 0, 0.4e2 / 0.81e2 * t9059 * t3193 * t263 + 0.16e2 / 0.9e1 * t2867 * t507 - 0.8e1 / 0.9e1 * t2693 * t1066 * t263 - 0.8e1 / 0.3e1 * t2696 * t506 * t1066 + 0.4e1 / 0.3e1 * t933 * t2875 + 0.4e1 / 0.9e1 * t650 * t3198 * t263 - 0.4e1 / 0.3e1 * t107 * t11363);
  t11390 = (t11367 + t11388) * t113;
  t11394 = -t8573 + t8579 - t8586 + 0.3e1 * t10617 + t8591 - 0.5848223622634646207e0 * t8592 - 0.10254018858216406658e4 * t8598 - 0.10526802520742363173e2 * t9637 + t8606 - 0.17544670867903938621e1 * t10625 - 0.17544670867903938621e1 * t10627 + 0.10389515463408878255e3 * t8607 + t9640 + 0.19751673498613801407e-1 * t11390 * t139 - t9644 - 0.36e3 * t9645;
  t11402 = t9648 - 0.24e2 * t10635 + t9649 - t8620 + t8624 - 0.32530743900905219526e-1 * t8625 + t8630 + t8634 + 0.31168546390226634765e3 * t9651 + t9654 + 0.18e3 * t9655 - t8638 - 0.35089341735807877242e1 * t8639 + t8644 - t8649 + 0.35089341735807877242e1 * t8650 - 0.51947577317044391277e2 * t8654;
  t11410 = t99 * t3204 * t301;
  t11414 = t8659 + t8663 - 0.17544670867903938621e1 * t9662 - t9665 - 0.30762056574649219972e4 * t9669 - t9672 - 0.51947577317044391276e2 * t10654 + t99 * t11390 * t141 + t11410 - t9674 - 0.12e2 * t10657 - 0.12e2 * t10659 + t9676 + t9678 + 0.32530743900905219526e-1 * t10664 + t8667;
  t11421 = t8674 - t8677 - 0.97592231702715658578e-1 * t9680 - 0.65061487801810439052e-1 * t9683 + 0.48796115851357829289e-1 * t9685 + 0.14447919941302971323e1 * t9687 + t9691 + t9694 - 0.17090684152272775384e-2 * t9695 + t8682 + t8690 - t8693 + t8974 - 0.12e2 * t8976 - t8835 - t8984 + t8838;
  t11426 = t253 * t3218;
  t11428 = t257 * t3218;
  t11433 = t8842 - t8845 + 0.3e1 * t10682 + t9764 + 0.3e1 * t9766 + t9770 + t8986 - t8991 - t8997 + 0.4e1 * t11426 - 0.4e1 * t11428 + 0.6e2 * t10691 - 0.36e2 * t10693 - t8999 - 0.24e2 * t9000 + t9774;
  t11438 = -t9775 - t9776 + t8862 - t9014 - t9778 - t9779 - 0.12e3 * t9022 + t9026 + t9781 - t9782 - 0.15584273195113317383e3 * t9786 + 0.10526802520742363173e2 * t9788 - t8901 - t8905 - t8909 - t8925 - 0.56968947174242584612e-3 * t9083;
  t11442 = t3204 * t129 * t313;
  t11447 = t3204 * t67 * t308;
  t11452 = 0.35089341735807877242e1 * t10711 - t9794 - t9799 - 0.5848223622634646207e0 * t11442 + 0.72e2 * t9800 + t9803 - 0.36e2 * t9804 - t9807 + t9808 + t9100 - 0.18311447306006545054e-3 * t11447 - t9104 + 0.73245789224026180216e-3 * t10722 - 0.54934341918019635162e-3 * t10725 + 0.6e2 * t9105 + t8942;
  t11456 = -t8945 - t8957 - t8960 + t8963 - t9112 - 0.21687162600603479684e-1 * t9114 - t9118 + t9121 + 0.48159733137676571078e0 * t9122 + t9126 + 0.16265371950452609763e-1 * t9130 + t9134 + t9137 - t9140 - t9143 + t9146 - t9817;
  t11459 = t11394 + t11402 + t11414 + t11421 + t11433 + t11438 + t11452 + t11456;
  t11489 = 0.1e2 / 0.3e1 * t352 * t3027 + t3294 * t316 + 0.5e1 / 0.9e1 * t46 * t55 * t66 * t11459 + t156 * t11459 + 0.5e1 / 0.3e1 * t46 * t55 * t3014 * t382 + 0.2e4 / 0.81e2 * t543 * t892 * t1021 + 0.2e4 / 0.81e2 * t543 * t896 * t1021 + 0.2e4 / 0.27e2 * t10085 * t3299 + 0.2e4 / 0.81e2 * t543 * t907 * t1021 + 0.2e4 / 0.81e2 * t543 * t952 * t1021 + 0.5e1 / 0.3e1 * t843 * t1048 + 0.5e1 / 0.3e1 * t352 * t3016 + 0.5e1 / 0.3e1 * t352 * t3020;
  t11514 = t192 * t3338;
  t11521 = t3231 * params->c;
  t11529 = 0.5e1 / 0.3e1 * t46 * t55 * t364 * t2917 + 0.2e4 / 0.27e2 * t10085 * t3296 + 0.5e1 / 0.3e1 * t182 * t3348 + 0.5e1 / 0.3e1 * t46 * t55 * t891 * t1084 + 0.2e4 / 0.27e2 * t3045 * t10196 + 0.2e4 / 0.81e2 * t3177 * t8563 - 0.1e3 / 0.27e2 * t846 * t3150 - 0.2e3 / 0.27e2 * t846 * t3153 - 0.5e2 / 0.27e2 * t190 * t871 * t3137 - 0.5e2 / 0.81e2 * t190 * t11514 * t195 - 0.5e2 / 0.27e2 * t190 * t3149 * t903 - 0.5e2 / 0.81e2 * t190 * t193 * t11521 * t180 - 0.1e3 / 0.27e2 * t3037 * t189 * t356;
  t11558 = t3274 * t189;
  t11566 = -0.1e3 / 0.27e2 * t2933 * t858 - 0.1e3 / 0.27e2 * t2933 * t862 - 0.1e3 / 0.27e2 * t2933 * t866 - 0.5e2 / 0.27e2 * t190 * t193 * t2485 * t1007 - 0.5e2 / 0.27e2 * t190 * t193 * t902 * t3036 - 0.5e2 / 0.81e2 * t190 * t549 * t3357 - 0.5e2 / 0.27e2 * t190 * t549 * t3353 - 0.1e3 / 0.27e2 * t2933 * t904 - 0.2e3 / 0.27e2 * t846 * t3156 - 0.2e3 / 0.27e2 * t846 * t3167 - 0.1e3 / 0.27e2 * t846 * t3138 - 0.1e3 / 0.81e2 * t11558 * t196 - 0.1e3 / 0.27e2 * t2933 * t872 - 0.5e2 / 0.27e2 * t190 * t3149 * t861;
  t11585 = t1042 * t209;
  t11597 = t59 * t579 * t3334;
  t11599 = t202 * t3325;
  t11602 = t59 * t9338 * t3324;
  t11604 = t202 * t3335;
  t11606 = t11309 + t11272 - t11246 - t11268 - t11250 + t11253 + t11275 - t11311 + t11280 + t11242 - t11301 + t11282;
  t11607 = -t11284 + t11286 + t11255 - t11288 - t11303 + t11292 + t11259 - t11263 - t11266 + t11295 + t11299 + t11307;
  t11612 = t2616 * t3329;
  t11615 = t878 * t2644 * t1042;
  t11621 = 0.9e1 / 0.4e1 * t2640 * t879 * t11585 + 0.7e1 / 0.2e1 * t11028 + 0.3e1 * t11044 - 0.21e2 / 0.2e1 * t11046 + 0.7e1 * t11048 - 0.9e1 / 0.2e1 * t11055 + 0.3e1 / 0.2e1 * t11062 + t9836 - t9839 - 0.595e3 / 0.27e2 * t9367 + t9846 + t11597 / 0.4e1 - 0.7e1 / 0.2e1 * t11599 + 0.3e1 / 0.2e1 * t11602 - 0.7e1 / 0.12e2 * t11604 + t59 * t207 * (t11606 + t11607) / 0.8e1 + 0.7e1 / 0.2e1 * t11612 - 0.3e1 / 0.2e1 * t11615 - t878 * t62 * t3334 * t209 / 0.4e1;
  t11642 = -0.3e1 * t9870 * t62 * t3324 * t209 + 0.9e1 / 0.4e1 * t2640 * t2946 * t886 - 0.3e1 / 0.4e1 * t878 * t2621 * t1042 - 0.3e1 / 0.4e1 * t878 * t879 * t3009 + 0.119e3 / 0.12e2 * t11077 - 0.7e1 / 0.4e1 * t11079 - 0.3e1 / 0.4e1 * t11084 - 0.119e3 / 0.6e1 * t11091 - t9366 - t9852 - t9853 - t9865 - t9881 - t9896 - 0.595e3 / 0.9e1 * t9902 + t9910 + t9912 - t9916 - 0.3e1 / 0.4e1 * t11117 + 0.3e1 / 0.2e1 * t11120;
  t11658 = t3071 * t40;
  t11662 = -0.5e2 / 0.27e2 * t190 * t3149 * t865 - 0.4e5 / 0.729e3 * t181 * t2427 * t3234 + 0.5e1 / 0.3e1 * t1009 * t953 + 0.5e1 / 0.3e1 * t1009 * t897 + 0.5e1 / 0.3e1 * t3038 * t384 + 0.5e1 / 0.3e1 * t1009 * t908 + 0.5e1 / 0.9e1 * t182 * t3340 + 0.5e1 / 0.9e1 * t46 * t55 * (t11621 + t11642) * t146 + 0.5e1 / 0.9e1 * t46 * t55 * t3338 * t316 + 0.5e1 / 0.3e1 * t182 * t3344 - 0.1e5 / 0.243e3 * t10765 * t3073 - 0.1e5 / 0.243e3 * t10866 * t3073 - 0.1e5 / 0.243e3 * t2814 * t11658 * t10901;
  t11665 = t800 * t180;
  t11707 = 0.4e6 / 0.6561e4 * t10176 * t9276 * t3175 * t185 * t11665 + 0.5e1 / 0.9e1 * t182 * t3317 - 0.1e5 / 0.729e3 * t8556 * t3234 - 0.1e5 / 0.729e3 * t2428 * t9175 * t3175 * t50 + 0.2e4 / 0.81e2 * t543 * t1085 * t854 + 0.2e4 / 0.81e2 * t543 * t1047 * t854 + 0.2e4 / 0.243e3 * t543 * t147 * t544 * t3273 * t180 + 0.4e4 / 0.81e2 * t543 * t1051 * t854 + 0.2e4 / 0.81e2 * t543 * t365 * t3114 - 0.1e3 / 0.27e2 * t1014 * t9966 - 0.1e3 / 0.27e2 * t190 * t871 * t3162 - 0.5e2 / 0.27e2 * t190 * t193 * t10758 * t350 - 0.5e2 / 0.81e2 * t190 * t193 * t553 * t3273;
  t11729 = t3274 * t188;
  t11738 = t806 * t841;
  t11743 = t2356 * t180 * t50;
  t11746 = t3175 * t185;
  t11773 = -0.5e1 / 0.9e1 * t11314 * t40 * t153 + 0.1e3 / 0.81e2 * t11729 * t327 + 0.1e3 / 0.27e2 * t10943 * t391 - 0.2e4 / 0.27e2 * t10888 * t963 + 0.1e3 / 0.27e2 * t3081 * t967 - 0.2e4 / 0.27e2 * t3086 * t11738 + 0.4e5 / 0.729e3 * t3176 * t2354 * t11743 - 0.4e6 / 0.6561e4 * t10131 * t11746 * t11665 + 0.1e5 / 0.243e3 * t2785 * t5637 * t10901 + 0.1e5 / 0.243e3 * t2785 * t3286 * t180 * t50 - 0.2e4 / 0.81e2 * t805 * t806 * t841 * t1007 - 0.2e4 / 0.81e2 * t805 * t806 * t350 * t3036 - 0.2e4 / 0.243e3 * t805 * t806 * t3273 * t180 + 0.5e2 / 0.81e2 * t324 * t325 * params->c * t11313;
  t11794 = -0.5e2 / 0.81e2 * t190 * t193 * t194 * t11313 - 0.1e3 / 0.27e2 * t190 * t2549 * t1028 + 0.3e1 * t1102 * t951 + 0.3e1 * t3106 * t382 + 0.5e1 / 0.9e1 * t46 * t55 * t216 * t3231 + 0.3e1 * t970 * t1084 + t11773 * t146 + 0.3e1 * t394 * t2917 + 0.5e1 / 0.3e1 * t46 * t55 * t1046 * t951 - 0.5e2 / 0.27e2 * t190 * t193 * t3136 * t841 - 0.5e2 / 0.27e2 * t190 * t10552 * t355 - 0.1e3 / 0.27e2 * t190 * t871 * t3166 - 0.5e2 / 0.27e2 * t190 * t2549 * t1032;
  t11835 = -0.5e2 / 0.27e2 * t190 * t871 * t3141 - 0.5e2 / 0.27e2 * t190 * t871 * t3145 - 0.5e2 / 0.27e2 * t190 * t549 * t3367 - 0.1e3 / 0.27e2 * t1014 * t9959 - 0.1e3 / 0.27e2 * t1014 * t9952 - 0.1e3 / 0.27e2 * t1014 * t9970 + 0.2e4 / 0.81e2 * t543 * t383 * t3114 + 0.2e4 / 0.27e2 * t10085 * t3375 + 0.2e4 / 0.81e2 * t543 * t217 * t3374 + 0.2e4 / 0.81e2 * t543 * t317 * t3374 + 0.2e4 / 0.81e2 * t543 * t147 * t2469 * t1007 + 0.2e4 / 0.81e2 * t543 * t147 * t853 * t3036 + 0.4e4 / 0.81e2 * t543 * t365 * t3118 + 0.4e4 / 0.81e2 * t543 * t383 * t3118;
  t11851 = 0.5e1 / 0.3e1 * t2920 + t3179 + t3181 + t9 * (t11334 + t11489 + t11529 + t11566 + t11662 + t11707 + t11794 + t11835) - 0.5e2 / 0.27e2 * t2923 - 0.2e3 / 0.27e2 * t2925 - 0.1e3 / 0.27e2 * t2928 - 0.1e3 / 0.27e2 * t2931 - 0.1e3 / 0.27e2 * t2934 - 0.2e3 / 0.27e2 * t2936 - 0.2e3 / 0.27e2 * t2938 + t3232 - t3236 + 0.3e1 * t2940 + t3238 + t3295 + 0.5e1 / 0.3e1 * t3017 + 0.5e1 / 0.3e1 * t3021 + 0.1e2 / 0.3e1 * t3023;
  t11868 = 0.1e2 / 0.3e1 * t3028 + 0.1e2 / 0.3e1 * t3032 + 0.5e1 / 0.3e1 * t3034 + 0.5e1 / 0.3e1 * t3039 + 0.5e1 / 0.3e1 * t3041 + 0.5e1 / 0.3e1 * t3043 + 0.2e4 / 0.27e2 * t3047 + 0.1e2 / 0.3e1 * t3049 + 0.1e2 / 0.3e1 * t3051 + 0.1e2 / 0.3e1 * t3053 + 0.1e2 / 0.3e1 * t3055 + 0.1e2 / 0.3e1 * t3057 + 0.1e2 / 0.3e1 * t3059 + 0.2e4 / 0.81e2 * t3064 + 0.2e4 / 0.81e2 * t3067 + 0.5e1 / 0.3e1 * t3069 + t3298 + t3301 + t3303 + t3305;
  t11875 = t3307 + t3310 + t3312 + t3314 + t3319 + t3342 + t3346 + t3350 - 0.1e5 / 0.243e3 * t3074 + 0.6e1 * t3076 + 0.3e1 * t3107 + 0.6e1 * t3108 - t3352 - t3356 - t3360 - t3363 - t3366 - t3370 - t3373 + 0.4e4 / 0.81e2 * t3111;
  t11893 = 0.2e4 / 0.81e2 * t3116 + 0.4e4 / 0.81e2 * t3120 + 0.4e4 / 0.81e2 * t3123 - 0.1e3 / 0.27e2 * t3125 - 0.1e3 / 0.27e2 * t3128 + 0.5e1 / 0.3e1 * t3132 + t3377 - t3379 - t3381 + 0.3e1 * t3134 + 0.3e1 * t3135 - 0.5e2 / 0.27e2 * t3139 - 0.5e2 / 0.27e2 * t3143 - 0.5e2 / 0.27e2 * t3147 - 0.5e2 / 0.27e2 * t3151 - 0.1e3 / 0.27e2 * t3154 - 0.1e3 / 0.27e2 * t3157 - 0.1e3 / 0.27e2 * t3160 - 0.1e3 / 0.27e2 * t3164 - 0.1e3 / 0.27e2 * t3168;
  tv4rho43 = t11851 + t11868 + t11875 + t11893;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t11909 = 0.8e4 / 0.81e2 * t3178 + 0.12e2 * t3180 + 0.4e1 * t3232 - 0.4e5 / 0.729e3 * t3235 + 0.12e2 * t3237 + 0.4e1 * t3295 + 0.8e4 / 0.81e2 * t3297 + 0.8e4 / 0.81e2 * t3300 + 0.2e2 / 0.3e1 * t3302 + 0.4e2 / 0.3e1 * t3304 + 0.2e2 / 0.3e1 * t3306 + 0.2e2 / 0.9e1 * t3309 + 0.2e2 / 0.3e1 * t3311 + 0.2e2 / 0.3e1 * t3313;
  t11934 = -0.14e2 * t9845 - 0.238e4 / 0.27e2 * t9902 - 0.238e3 / 0.3e1 * t9895 - 0.119e3 / 0.3e1 * t11091 - 0.28e2 * t11093 - 0.7e1 / 0.3e1 * t11604 - t11597 - 0.14e2 * t11599 - 0.6e1 * t11602 + 0.3e1 / 0.2e1 * t11117 - 0.3e1 * t11120;
  t11935 = -t98 - t9034;
  t11936 = 0.12e2 * t11935;
  t11939 = 0.5e1 / 0.3e1 * t22 * t26 * t11936;
  t11943 = -0.5e1 / 0.3e1 * t7 * t15 * t11936;
  t11948 = 0.616e4 / 0.81e2 * tau[1] / t19 / t8480 * t27;
  t11950 = 0.88e4 / 0.81e2 * t3253 * t347;
  t11952 = 0.4e3 / 0.9e1 * t994 * t1004;
  t11954 = 0.1e3 / 0.9e1 * t343 * t3270;
  t11955 = t987 * t987;
  t11958 = 0.1e2 / 0.3e1 * t7 * t501 * t11955;
  t11961 = 0.4e2 / 0.9e1 * t7 * t823 * t3246;
  t11963 = 0.8e3 / 0.27e2 * t994 * t1000;
  t11965 = 0.2e3 / 0.81e2 * t343 * t3263;
  t11967 = 0.2e3 / 0.9e1 * t343 * t3266;
  t11968 = t999 * t999;
  t11971 = 0.4e2 / 0.81e2 * t22 * t9235 * t11968;
  t11974 = 0.2e2 / 0.9e1 * t22 * t2993 * t1003;
  t11975 = t1003 * t1003;
  t11978 = 0.1e2 / 0.3e1 * t22 * t512 * t11975;
  t11981 = 0.4e2 / 0.9e1 * t22 * t833 * t3269;
  t11982 = t983 * t983;
  t11985 = 0.4e2 / 0.81e2 * t7 * t9219 * t11982;
  t11988 = 0.2e2 / 0.9e1 * t7 * t2968 * t987;
  t11989 = t11939 + t11943 + t11948 - t11950 + t11952 - t11954 + t11958 + t11961 + t11963 + t11965 - t11967 + t11971 - t11974 + t11978 + t11981 + t11985 - t11988;
  t11995 = t1042 * t1042;
  t12001 = t1037 * t1037;
  t12010 = t59 * t207 * t11989 / 0.8e1 - t9361 + 0.14e2 * t11612 + 0.6e1 * t11615 - 0.3e1 / 0.4e1 * t59 * t574 * t11995 - t878 * t879 * t3334 - 0.3e1 * t59 * t9333 * t12001 + 0.9e1 / 0.2e1 * t2640 * t2946 * t1042 + 0.119e3 / 0.6e1 * t11077 + 0.14e2 * t11075 - t9366 - t9370;
  t12049 = 0.5e1 / 0.9e1 * t46 * t55 * (t11934 + t12010) * t146 + 0.2e2 / 0.9e1 * t46 * t55 * t3338 * t382 + 0.2e2 / 0.3e1 * t352 * t3344 + 0.1e2 / 0.3e1 * t46 * t55 * t1046 * t1084 + 0.2e2 / 0.3e1 * t352 * t3348 + 0.2e2 / 0.9e1 * t352 * t3340 - 0.2e3 / 0.81e2 * t190 * t193 * t11521 * t350 - 0.2e3 / 0.81e2 * t190 * t11514 * t355 - 0.2e3 / 0.27e2 * t190 * t3149 * t1028 - 0.2e3 / 0.27e2 * t1014 * t10513 - 0.2e3 / 0.27e2 * t1014 * t10744 - 0.4e3 / 0.27e2 * t1014 * t10807 + 0.8e4 / 0.81e2 * t543 * t365 * t3374;
  t12053 = t1007 * t1007;
  t12054 = t2 * t12053;
  t12058 = t1055 * t1055;
  t12063 = t1058 * t1058;
  t12069 = -0.24e2 * t11935;
  t12073 = my_piecewise3(t100, 0, 0.4e2 / 0.81e2 * t9039 * t12058 - 0.16e2 / 0.9e1 * t2852 * t1058 + 0.4e1 / 0.3e1 * t640 * t12063 + 0.16e2 / 0.9e1 * t925 * t3188 + 0.4e1 / 0.3e1 * t103 * t12069);
  t12074 = t1063 * t1063;
  t12079 = t1066 * t1066;
  t12088 = my_piecewise3(t106, 0, 0.4e2 / 0.81e2 * t9059 * t12074 - 0.16e2 / 0.9e1 * t2867 * t1066 + 0.4e1 / 0.3e1 * t650 * t12079 + 0.16e2 / 0.9e1 * t933 * t3198 - 0.4e1 / 0.3e1 * t107 * t12069);
  t12090 = (t12073 + t12088) * t113;
  t12098 = -t8573 + t8579 + t99 * t12090 * t141 - t8586 + 0.6e1 * t10617 + t8591 - 0.14035736694323150897e2 * t9637 + t8606 - 0.35089341735807877242e1 * t10627 + t8611 - 0.96e3 * t9643 - 0.48e3 * t9645;
  t12103 = -0.48e2 * t10635 - 0.48e2 * t10638 - t8620 + t8624 + t8630 + t8634 + 0.4155806185363551302e3 * t9651 + 0.24e3 * t9655 - t8638 + t8644 - t8649 + t8659 + t8663;
  t12115 = -0.23392894490538584828e1 * t9662 - 0.4101607543286562663e4 * t9669 - 0.10389515463408878255e3 * t10654 + 0.19751673498613801407e-1 * t12090 * t139 + 0.4e1 * t11410 + 0.144e3 * t9673 + 0.384e3 * t9675 + 0.65061487801810439052e-1 * t10664 + t8667 + t8674 - t8677 - 0.1301229756036208781e0 * t9680;
  t12120 = -0.86748650402413918736e-1 * t9683 + 0.65061487801810439052e-1 * t9685 + 0.19263893255070628431e1 * t9687 - 0.22787578869697033845e-2 * t9695 + t8682 + t8690 - t8693 + t8974 - t8835 - t8984 + t8838 + t8842 - t8845;
  t12129 = 0.4e1 * t9766 - t8991 - t8997 - 0.16e2 * t11426 - 0.16e2 * t11428 + 0.12e3 * t10691 + 0.72e2 * t10693 + 0.192e3 * t10695 - t8999 - t9006 - t9008 - t9012;
  t12133 = t8862 - t9014 + t9026 + t9029 + t9033 + t9036 - 0.20779030926817756511e3 * t9786 + 0.14035736694323150897e2 * t9788 - t8901 - t8905 - t8909 - t8925 + 0.70178683471615754484e1 * t10711;
  t12142 = -0.23392894490538584828e1 * t11442 - 0.96e2 * t9800 - 0.576e3 * t9802 - 0.48e2 * t9804 + t9096 - 0.48e2 * t9806 + t9100 - 0.73245789224026180216e-3 * t11447 + t9104 + 0.14649157844805236043e-2 * t10722 + t8942 - t8945;
  t12143 = -t8957 - t8960 + t8963 - t9112 - t9118 + t9121 + t9126 + t9134 + t9137 - t9140 - t9143 + t9146 - t9148;
  t12146 = t12098 + t12103 + t12115 + t12120 + t12129 + t12133 + t12142 + t12143;
  t12157 = t1012 * t1012;
  t12178 = 0.8e4 / 0.81e2 * t543 * t383 * t3374 - 0.1e3 / 0.27e2 * t12054 * t188 * t531 + 0.5e1 / 0.9e1 * t46 * t55 * t66 * t12146 - 0.4e5 / 0.729e3 * t10169 * t3234 - 0.4e5 / 0.729e3 * t2428 * t10163 * t3175 * t50 + 0.4e6 / 0.6561e4 * t9299 * t9300 * t12157 * t189 - 0.1e3 / 0.27e2 * t190 * t3149 * t1032 + 0.8e4 / 0.81e2 * t3177 * t10061 + 0.8e4 / 0.81e2 * t3177 * t9945 - 0.4e3 / 0.27e2 * t2933 * t1029 - 0.4e3 / 0.81e2 * t11558 * t356 - 0.4e3 / 0.27e2 * t2933 * t1025 - 0.2e3 / 0.27e2 * t190 * t871 * t3367;
  t12180 = t11939 + t11943 + t11948 - t11950 + t11952 - t11954 + t11958 + t11961 + t11963 + t11965 - t11967 + t11971 - t11974 + t11978 + t11981 - t9212 + t11985 - t11988;
  t12181 = t2 * t12180;
  t12192 = t2 * t12157;
  t12200 = t152 * t1007;
  t12249 = (-0.5e1 / 0.9e1 * t12181 * t40 * t153 + 0.4e3 / 0.81e2 * t11729 * t391 - 0.4e4 / 0.27e2 * t10888 * t1095 + 0.1e3 / 0.27e2 * t12054 * t185 * t802 + 0.4e5 / 0.729e3 * t12192 * t2354 * t9269 - 0.4e6 / 0.6561e4 * t9275 * t9276 * t12157 * t189 + 0.2e5 / 0.243e3 * t2785 * t5637 * t12200 - 0.2e4 / 0.81e2 * t805 * t806 * t12053 - 0.8e4 / 0.243e3 * t805 * t806 * t350 * t3273 + 0.5e2 / 0.81e2 * t324 * t325 * params->c * t12180) * t146 + 0.4e1 * t394 * t3231 + t156 * t12146 - 0.2e5 / 0.243e3 * t2814 * t11658 * t12200 + 0.2e2 / 0.9e1 * t352 * t3317 + 0.2e4 / 0.81e2 * t543 * t147 * t544 * t12053 + 0.1e2 / 0.3e1 * t1009 * t1048 + 0.2e2 / 0.3e1 * t1009 * t1052 + 0.4e4 / 0.81e2 * t543 * t1047 * t1021 + 0.8e4 / 0.81e2 * t543 * t1051 * t1021 + 0.4e4 / 0.81e2 * t543 * t1085 * t1021 - 0.2e3 / 0.81e2 * t190 * t193 * t902 * t3273 - 0.2e3 / 0.81e2 * t190 * t871 * t3357;
  t12274 = t147 * t3113;
  t12288 = -0.5e2 / 0.81e2 * t190 * t193 * t194 * t12180 - 0.2e3 / 0.27e2 * t190 * t871 * t3353 - 0.1e3 / 0.27e2 * t190 * t193 * t3136 * t1007 - 0.4e5 / 0.729e3 * t12192 * t2427 * t9407 + 0.6e1 * t1102 * t1084 + 0.8e4 / 0.243e3 * t543 * t147 * t853 * t3273 + 0.2e2 / 0.9e1 * t46 * t55 * t364 * t3231 + 0.4e4 / 0.27e2 * t3045 * t12274 + 0.4e1 * t3294 * t382 + 0.1e2 / 0.3e1 * t1009 * t1086 + 0.5e1 / 0.9e1 * t12181 * t45 * t148 + 0.2e2 / 0.9e1 * t3308 * t366 + 0.2e2 / 0.9e1 * t3308 * t384;
  t12292 = 0.2e2 / 0.9e1 * t3318 + 0.2e2 / 0.9e1 * t3341 + 0.2e2 / 0.3e1 * t3345 + 0.2e2 / 0.3e1 * t3349 - 0.4e3 / 0.27e2 * t3351 - 0.2e3 / 0.27e2 * t3355 - 0.2e3 / 0.81e2 * t3359 - 0.4e3 / 0.27e2 * t3362 - 0.2e3 / 0.27e2 * t3365 - 0.2e3 / 0.27e2 * t3369 - 0.2e3 / 0.27e2 * t3372 + 0.8e4 / 0.81e2 * t3376 - 0.4e3 / 0.27e2 * t3378 - 0.4e3 / 0.27e2 * t3380 + t9 * (t12049 + t12178 + t12249 + t12288);
  tv4rho44 = t11909 + t12292;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t12296 = 0.5e1 / 0.12e2 * t3408;
  t12298 = t3565 * t555;
  t12300 = t3565 * t559;
  t12303 = t190 * t2409 * t1132;
  t12306 = t190 * t549 * t3586;
  t12308 = t3457 * t1148;
  t12310 = t3457 * t1158;
  t12313 = t39 * t542 * t201;
  t12314 = t12313 * t3465;
  t12317 = t3463 * t213 * t3464;
  t12320 = t407 * t3579 * t1161;
  t12323 = t407 * t1147 * t3449;
  t12325 = t1113 * t2402;
  t12327 = t1113 * t2406;
  t12330 = t2340 * t50 * t410;
  t12332 = t3457 * t1162;
  t12336 = t3463 * t63 * t4302 * t527;
  t12338 = -0.2e3 / 0.81e2 * t12298 - 0.1e3 / 0.81e2 * t12300 - 0.5e2 / 0.81e2 * t12303 - 0.1e3 / 0.81e2 * t12306 + 0.35e2 / 0.36e2 * t12308 - 0.5e1 / 0.12e2 * t12310 + 0.35e4 / 0.243e3 * t12314 - 0.5e3 / 0.81e2 * t12317 - 0.595e3 / 0.108e3 * t12320 + 0.35e2 / 0.9e1 * t12323 + 0.25e2 / 0.54e2 * t12325 + 0.25e2 / 0.162e3 * t12327 - 0.5e1 / 0.72e2 * t12330 - 0.5e1 / 0.24e2 * t12332 - 0.25e3 / 0.81e2 * t12336;
  t12339 = t9410 * t3468;
  t12342 = t190 * t9442 * t403;
  t12346 = t407 * t408 * t63 * t2240;
  t12348 = t206 * t146;
  t12351 = t407 * t408 * t12348 * t209;
  t12353 = t1136 * t3450;
  t12357 = t407 * t408 * t213 * t791;
  t12361 = t407 * t54 * t2246 * t409;
  t12362 = 0.2975e4 / 0.243e3 * t12361;
  t12363 = t1113 * t2416;
  t12366 = t190 * t549 * t3571;
  t12370 = t190 * t193 * t553 * t58;
  t12372 = t1136 * t3568;
  t12376 = t190 * t193 * t194 * t201;
  t12377 = 0.77e4 / 0.2187e4 * t12376;
  t12378 = t1136 * t3580;
  t12381 = t407 * t3579 * t1157;
  t12382 = 0.595e3 / 0.54e2 * t12381;
  t12383 = t3421 * t189;
  t12384 = t12383 * t196;
  t12386 = 0.25e2 / 0.54e2 * t12339 + 0.25e2 / 0.324e3 * t12342 - 0.5e1 / 0.72e2 * t12346 + 0.5e1 / 0.12e2 * t12351 - 0.5e1 / 0.6e1 * t12353 - 0.5e1 / 0.12e2 * t12357 + t12362 + 0.25e2 / 0.54e2 * t12363 + 0.55e3 / 0.243e3 * t12366 + 0.55e3 / 0.243e3 * t12370 + 0.35e2 / 0.9e1 * t12372 - t12377 - 0.595e3 / 0.108e3 * t12378 - t12382 + 0.11e4 / 0.243e3 * t12384;
  t12390 = t190 * t193 * t2419 * t177;
  t12392 = t3565 * t550;
  t12395 = t1141 * t1143 * t2420;
  t12397 = t9276 * t35;
  t12400 = t10176 * t12397 * t2347 * t189;
  t12403 = t1141 * t1143 * t2401;
  t12406 = t1141 * t1143 * t2405;
  t12409 = t564 * t61 * t62;
  t12411 = t1141 * t12409 * t195;
  t12413 = t3437 * t8;
  t12415 = t1141 * t12413 * t195;
  t12417 = t799 * t1140;
  t12418 = t1354 * t6152;
  t12419 = t12417 * t12418;
  t12423 = t154 * t1338 * t4373 * t209;
  t12426 = t1141 * t3442 * t558;
  t12429 = t1141 * t3438 * t558;
  t12431 = t10193 * t3430;
  t12433 = t10183 * t3430;
  t12437 = t523 * t185 * t1140 * t1144;
  t12439 = -0.5e2 / 0.81e2 * t12390 - 0.2e3 / 0.81e2 * t12392 + 0.25e2 / 0.108e3 * t12395 - 0.5e5 / 0.6561e4 * t12400 + 0.25e2 / 0.108e3 * t12403 + 0.25e2 / 0.324e3 * t12406 + 0.2975e4 / 0.486e3 * t12411 - 0.35e3 / 0.81e2 * t12415 - 0.25e2 / 0.54e2 * t12419 - 0.5e1 / 0.12e2 * t12423 + 0.25e2 / 0.54e2 * t12426 - 0.175e3 / 0.162e3 * t12429 + 0.125e4 / 0.243e3 * t12431 + 0.125e4 / 0.243e3 * t12433 + 0.25e2 / 0.54e2 * t12437;
  t12440 = t2356 * t177;
  t12443 = t2814 * t12440 * t527 * t50;
  t12446 = t1141 * t3438 * t554;
  t12449 = t1141 * t3442 * t554;
  t12451 = t3422 * t318;
  t12453 = t2 * t201;
  t12455 = t12453 * t45 * t148;
  t12456 = 0.77e3 / 0.243e3 * t12455;
  t12459 = t190 * t2409 * t1128;
  t12461 = t9410 * t3471;
  t12464 = t190 * t549 * t3555;
  t12467 = t3463 * t409 * t1897;
  t12469 = t3457 * t1154;
  t12471 = t1136 * t3492;
  t12473 = t3503 * t6160;
  t12474 = t3501 * t12473;
  t12478 = t3463 * t1797 * t545 * t209;
  t12481 = t190 * t3503 * t195;
  t12483 = t8 * t316;
  t12486 = t407 * t1151 * t12483 * t209;
  t12488 = -0.1e5 / 0.729e3 * t12443 - 0.175e3 / 0.81e2 * t12446 + 0.25e2 / 0.27e2 * t12449 - 0.55e2 / 0.27e2 * t12451 + t12456 + t420 * t2240 + 0.25e2 / 0.108e3 * t12459 + 0.25e2 / 0.27e2 * t12461 + 0.25e2 / 0.108e3 * t12464 - 0.25e3 / 0.81e2 * t12467 + 0.5e1 / 0.24e2 * t12469 + 0.5e1 / 0.12e2 * t12471 + 0.25e2 / 0.54e2 * t12474 + 0.25e3 / 0.81e2 * t12478 + 0.25e2 / 0.54e2 * t12481 + 0.5e1 / 0.6e1 * t12486;
  t12493 = t407 * t1151 * t3490 * t583;
  t12495 = t1136 * t3496;
  t12499 = t407 * t1151 * t1152 * t2323;
  t12501 = t1136 * t3475;
  t12504 = t407 * t3474 * t3486;
  t12506 = t399 * t2427;
  t12507 = t12506 * t2431;
  t12511 = t2353 * t58;
  t12513 = t805 * t12511 * t61;
  t12514 = t1152 * t2356;
  t12516 = t2347 * t40 * t152;
  t12518 = t12513 * t12514 * t12516;
  t12522 = t2814 * t3428 * t522 * t3863;
  t12525 = t1141 * t4364 * t3508;
  t12527 = t1110 * t595;
  t12530 = t9482 * t147 * t3410;
  t12532 = t400 * t2329;
  t12534 = t400 * t2333;
  t12536 = t400 * t2380;
  t12538 = 0.5e1 / 0.24e2 * t12493 + 0.5e1 / 0.24e2 * t12495 + 0.5e1 / 0.72e2 * t12499 - 0.35e2 / 0.18e2 * t12501 - 0.35e2 / 0.9e1 * t12504 + 0.5e4 / 0.729e3 * t12507 + 0.3e1 * t3551 * t316 + 0.125e4 / 0.729e3 * t12518 + 0.125e4 / 0.243e3 * t12522 + 0.175e3 / 0.81e2 * t12525 + 0.1e2 / 0.9e1 * t12527 + 0.2e4 / 0.81e2 * t12530 - 0.5e1 / 0.72e2 * t12532 - 0.5e1 / 0.24e2 * t12534 - 0.5e1 / 0.24e2 * t12536;
  t12539 = t3399 * t2387;
  t12541 = t3399 * t2383;
  t12543 = t3422 * t218;
  t12545 = t1110 * t793;
  t12547 = t1110 * t591;
  t12549 = t400 * t2242;
  t12551 = t9410 * t3556;
  t12555 = t190 * t193 * t9437 * t35;
  t12557 = t1136 * t3446;
  t12560 = t407 * t1147 * t3453;
  t12563 = t1141 * t4345 * t3508;
  t12566 = t194 * t180 * t575;
  t12568 = t1141 * t1338 * t12566;
  t12571 = t194 * t180 * t583;
  t12573 = t1141 * t1354 * t12571;
  t12579 = t407 * t3478 * t3490 * t575;
  t12581 = -0.25e3 / 0.27e2 * t12539 - 0.25e3 / 0.27e2 * t12541 - 0.55e2 / 0.27e2 * t12543 + 0.5e1 / 0.9e1 * t12545 + 0.5e1 / 0.9e1 * t12547 - 0.5e1 / 0.72e2 * t12549 + 0.25e2 / 0.54e2 * t12551 + 0.25e2 / 0.324e3 * t12555 + 0.35e2 / 0.18e2 * t12557 + 0.35e2 / 0.36e2 * t12560 - 0.25e2 / 0.27e2 * t12563 + 0.25e2 / 0.54e2 * t12568 - 0.25e2 / 0.108e3 * t12573 + 0.3e1 * t1179 * t791 - 0.5e1 / 0.12e2 * t12579;
  t12584 = t407 * t3474 * t3495;
  t12586 = t192 * t201;
  t12587 = t12586 * t61;
  t12588 = t12587 * t1651;
  t12589 = t3501 * t12588;
  t12591 = t3503 * t6156;
  t12592 = t3501 * t12591;
  t12594 = t62 * t791;
  t12597 = t407 * t1151 * t12594 * t209;
  t12600 = t407 * t3474 * t3491;
  t12602 = t1136 * t3454;
  t12604 = t544 * t58;
  t12607 = t543 * t147 * t12604 * t180;
  t12610 = t1142 * t6491;
  t12611 = t2348 * t542 * t12610;
  t12615 = t46 * t55 * t1142 * t316;
  t12619 = t46 * t55 * t3437 * t146;
  t12620 = 0.35e2 / 0.18e2 * t12619;
  t12622 = t543 * t317 * t3411;
  t12626 = t543 * t147 * t3410 * t522;
  t12629 = t543 * t590 * t1121;
  t12632 = t543 * t594 * t1121;
  t12634 = t182 * t3407;
  t12636 = -0.35e2 / 0.36e2 * t12584 - 0.175e3 / 0.81e2 * t12589 + 0.25e2 / 0.27e2 * t12592 + 0.5e1 / 0.24e2 * t12597 - 0.35e2 / 0.18e2 * t12600 - 0.5e1 / 0.24e2 * t12602 - 0.22e5 / 0.729e3 * t12607 - 0.25e3 / 0.81e2 * t12611 - 0.5e1 / 0.12e2 * t12615 + t12620 + 0.4e4 / 0.243e3 * t12622 + 0.2e4 / 0.243e3 * t12626 - 0.25e3 / 0.81e2 * t12629 - 0.5e3 / 0.81e2 * t12632 - 0.5e1 / 0.12e2 * t12634;
  t12638 = t543 * t217 * t3518;
  t12641 = t543 * t317 * t3518;
  t12644 = t543 * t792 * t1121;
  t12646 = t3399 * t1898;
  t12649 = t543 * t217 * t3411;
  t12653 = t543 * t147 * t1120 * t2339;
  t12655 = t1147 * t573;
  t12657 = t407 * t12655 * t3479;
  t12659 = t408 * t2263;
  t12662 = t407 * t12659 * t1152 * t2265;
  t12666 = t407 * t3478 * t3485 * t575;
  t12668 = t3579 * t206;
  t12670 = t407 * t12668 * t1153;
  t12674 = t407 * t1151 * t3485 * t583;
  t12676 = t1136 * t3480;
  t12678 = t1136 * t3487;
  t12682 = t10131 * t35 * t2347 * t189;
  t12684 = t1109 * t539;
  t12685 = t12684 * t807;
  t12687 = t3421 * t188;
  t12688 = t12687 * t327;
  t12690 = t3527 * t811;
  t12692 = t1168 * t2366;
  t12696 = t805 * t806 * t58 * t180;
  t12698 = params->c * t201;
  t12700 = t324 * t325 * t12698;
  t12701 = 0.77e4 / 0.2187e4 * t12700;
  t12702 = t399 * t2354;
  t12703 = t12702 * t2358;
  t12707 = t805 * t806 * t177 * t522;
  t12711 = t805 * t806 * t35 * t2339;
  t12715 = t2785 * t177 * t527 * t50;
  t12719 = t2785 * t1171 * t40 * t9281;
  t12722 = t12453 * t40 * t153;
  t12723 = 0.77e3 / 0.243e3 * t12722;
  t12724 = t3530 * t2362;
  t12726 = 0.5e5 / 0.6561e4 * t12682 - 0.2e4 / 0.81e2 * t12685 - 0.11e4 / 0.243e3 * t12688 + 0.1e3 / 0.81e2 * t12690 - 0.25e2 / 0.162e3 * t12692 + 0.22e5 / 0.729e3 * t12696 + t12701 - 0.5e4 / 0.729e3 * t12703 - 0.2e4 / 0.243e3 * t12707 + 0.25e3 / 0.243e3 * t12711 + 0.1e5 / 0.729e3 * t12715 - 0.125e4 / 0.243e3 * t12719 - t12723 + 0.25e3 / 0.27e2 * t12724;
  t12728 = t553 * t3507;
  t12730 = t1141 * t1354 * t12728;
  t12733 = t194 * t522 * t209;
  t12735 = t1141 * t1354 * t12733;
  t12737 = -0.25e3 / 0.81e2 * t12638 - 0.25e3 / 0.81e2 * t12641 - 0.25e3 / 0.81e2 * t12644 - 0.25e3 / 0.27e2 * t12646 + 0.4e4 / 0.243e3 * t12649 - 0.25e3 / 0.243e3 * t12653 + 0.35e2 / 0.18e2 * t12657 + 0.5e1 / 0.12e2 * t12662 - 0.5e1 / 0.6e1 * t12666 + 0.595e3 / 0.108e3 * t12670 + 0.5e1 / 0.12e2 * t12674 - 0.5e1 / 0.12e2 * t12676 + 0.5e1 / 0.6e1 * t12678 + t12726 * t146 - 0.25e2 / 0.54e2 * t12730 - 0.25e2 / 0.108e3 * t12735;
  t12745 = 0.55e2 / 0.27e2 * t3423;
  t12748 = -0.25e3 / 0.27e2 * t3400 - 0.5e1 / 0.24e2 * t3402 - 0.5e1 / 0.12e2 * t3404 - t12296 + 0.4e4 / 0.243e3 * t3413 + t9 * (t12338 + t12386 + t12439 + t12488 + t12538 + t12581 + t12636 + t12737) - 0.5e1 / 0.24e2 * t3415 + 0.1e2 / 0.9e1 * t3417 + 0.1e2 / 0.9e1 * t3419 - t12745 + 0.25e2 / 0.108e3 * t3426 + 0.125e4 / 0.243e3 * t3431;
  t12761 = 0.25e2 / 0.54e2 * t3434 - 0.175e3 / 0.81e2 * t3440 + 0.25e2 / 0.27e2 * t3444 + 0.35e2 / 0.18e2 * t3447 - 0.5e1 / 0.6e1 * t3451 - 0.5e1 / 0.24e2 * t3455 - 0.5e1 / 0.24e2 * t3458 - 0.5e1 / 0.12e2 * t3460 - 0.25e3 / 0.81e2 * t3466 + 0.25e2 / 0.108e3 * t3469 + 0.25e2 / 0.54e2 * t3472 - 0.35e2 / 0.18e2 * t3476;
  t12775 = -0.5e1 / 0.12e2 * t3481 + 0.5e1 / 0.6e1 * t3488 + 0.5e1 / 0.12e2 * t3493 + 0.5e1 / 0.24e2 * t3497 + 0.5e1 / 0.12e2 * t3499 + 0.25e2 / 0.54e2 * t3505 - 0.25e2 / 0.54e2 * t3510 - 0.5e3 / 0.81e2 * t3513 - 0.5e3 / 0.81e2 * t3516 - 0.25e3 / 0.81e2 * t3520 + 0.6e1 * t3522 + 0.3e1 * t3552;
  t12782 = 0.35e2 / 0.9e1 * t3569;
  t12783 = 0.55e3 / 0.243e3 * t3573;
  t12786 = 0.595e3 / 0.108e3 * t3581;
  t12789 = 0.3e1 * t3553 + 0.25e2 / 0.108e3 * t3557 + 0.25e2 / 0.27e2 * t3559 + 0.25e2 / 0.27e2 * t3561 + 0.25e2 / 0.54e2 * t3563 - 0.2e3 / 0.81e2 * t3566 + t12782 + t12783 + 0.35e2 / 0.18e2 * t3575 - 0.5e1 / 0.6e1 * t3577 - t12786 - 0.1e3 / 0.81e2 * t3584 - 0.1e3 / 0.81e2 * t3588;
  tv4rho3sigma0 = t12748 + t12761 + t12775 + t12789;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t12809 = -0.4e3 / 0.81e2 * t12298 - 0.2e3 / 0.81e2 * t12300 - 0.1e3 / 0.81e2 * t12303 - 0.2e3 / 0.81e2 * t12306 + 0.35e2 / 0.18e2 * t12308 - 0.5e1 / 0.6e1 * t12310 + 0.7e4 / 0.243e3 * t12314 - 0.1e4 / 0.81e2 * t12317 - 0.595e3 / 0.54e2 * t12320 + 0.7e2 / 0.9e1 * t12323 + 0.25e2 / 0.27e2 * t12325 + 0.25e2 / 0.81e2 * t12327 - 0.5e1 / 0.36e2 * t12330 - 0.5e1 / 0.12e2 * t12332 - 0.5e3 / 0.81e2 * t12336;
  t12816 = 0.595e4 / 0.243e3 * t12361;
  t12821 = 0.154e5 / 0.2187e4 * t12376;
  t12823 = 0.595e3 / 0.27e2 * t12381;
  t12825 = 0.25e2 / 0.27e2 * t12339 + 0.25e2 / 0.162e3 * t12342 - 0.5e1 / 0.36e2 * t12346 + 0.5e1 / 0.6e1 * t12351 - 0.5e1 / 0.3e1 * t12353 - 0.5e1 / 0.6e1 * t12357 + t12816 + 0.25e2 / 0.27e2 * t12363 + 0.11e4 / 0.243e3 * t12366 + 0.11e4 / 0.243e3 * t12370 + 0.7e2 / 0.9e1 * t12372 - t12821 - 0.595e3 / 0.54e2 * t12378 - t12823 + 0.22e4 / 0.243e3 * t12384;
  t12843 = -0.1e3 / 0.81e2 * t12390 - 0.4e3 / 0.81e2 * t12392 + 0.3e1 * t1202 * t791 + 0.25e2 / 0.54e2 * t12395 - 0.1e6 / 0.6561e4 * t12400 + 0.25e2 / 0.54e2 * t12403 + 0.25e2 / 0.162e3 * t12406 + 0.2975e4 / 0.243e3 * t12411 - 0.7e3 / 0.81e2 * t12415 - 0.25e2 / 0.27e2 * t12419 - 0.5e1 / 0.6e1 * t12423 + 0.25e2 / 0.27e2 * t12426 - 0.175e3 / 0.81e2 * t12429 + 0.25e4 / 0.243e3 * t12431 + 0.25e4 / 0.243e3 * t12433;
  t12849 = 0.154e4 / 0.243e3 * t12455;
  t12860 = 0.25e2 / 0.27e2 * t12437 - 0.2e5 / 0.729e3 * t12443 - 0.35e3 / 0.81e2 * t12446 + 0.5e2 / 0.27e2 * t12449 - 0.11e3 / 0.27e2 * t12451 + t12849 + 0.25e2 / 0.54e2 * t12459 + 0.5e2 / 0.27e2 * t12461 + 0.25e2 / 0.54e2 * t12464 - 0.5e3 / 0.81e2 * t12467 + 0.5e1 / 0.12e2 * t12469 + 0.5e1 / 0.6e1 * t12471 + 0.25e2 / 0.27e2 * t12474 + 0.5e3 / 0.81e2 * t12478 + 0.25e2 / 0.27e2 * t12481 + 0.5e1 / 0.3e1 * t12486;
  t12879 = 0.5e1 / 0.12e2 * t12493 + 0.5e1 / 0.12e2 * t12495 + 0.5e1 / 0.36e2 * t12499 - 0.35e2 / 0.9e1 * t12501 - 0.7e2 / 0.9e1 * t12504 + 0.1e5 / 0.729e3 * t12507 + 0.3e1 * t3621 * t316 + 0.25e4 / 0.729e3 * t12518 + 0.25e4 / 0.243e3 * t12522 + 0.35e3 / 0.81e2 * t12525 + 0.2e2 / 0.9e1 * t12527 + 0.4e4 / 0.81e2 * t12530 - 0.5e1 / 0.36e2 * t12532 - 0.5e1 / 0.12e2 * t12534 - 0.5e1 / 0.12e2 * t12536;
  t12895 = -0.5e3 / 0.27e2 * t12539 - 0.5e3 / 0.27e2 * t12541 - 0.11e3 / 0.27e2 * t12543 + 0.1e2 / 0.9e1 * t12545 + 0.1e2 / 0.9e1 * t12547 + t428 * t2240 - 0.5e1 / 0.36e2 * t12549 + 0.25e2 / 0.27e2 * t12551 + 0.25e2 / 0.162e3 * t12555 + 0.35e2 / 0.9e1 * t12557 + 0.35e2 / 0.18e2 * t12560 - 0.5e2 / 0.27e2 * t12563 + 0.25e2 / 0.27e2 * t12568 - 0.25e2 / 0.54e2 * t12573 - 0.5e1 / 0.6e1 * t12579;
  t12906 = 0.35e2 / 0.9e1 * t12619;
  t12912 = -0.35e2 / 0.18e2 * t12584 - 0.35e3 / 0.81e2 * t12589 + 0.5e2 / 0.27e2 * t12592 + 0.5e1 / 0.12e2 * t12597 - 0.35e2 / 0.9e1 * t12600 - 0.5e1 / 0.12e2 * t12602 - 0.44e5 / 0.729e3 * t12607 - 0.5e3 / 0.81e2 * t12611 - 0.5e1 / 0.6e1 * t12615 + t12906 + 0.8e4 / 0.243e3 * t12622 + 0.4e4 / 0.243e3 * t12626 - 0.5e3 / 0.81e2 * t12629 - 0.1e4 / 0.81e2 * t12632 - 0.5e1 / 0.6e1 * t12634;
  t12934 = 0.154e5 / 0.2187e4 * t12700;
  t12940 = 0.154e4 / 0.243e3 * t12722;
  t12942 = 0.1e6 / 0.6561e4 * t12682 - 0.4e4 / 0.81e2 * t12685 - 0.22e4 / 0.243e3 * t12688 + 0.2e3 / 0.81e2 * t12690 - 0.25e2 / 0.81e2 * t12692 + 0.44e5 / 0.729e3 * t12696 + t12934 - 0.1e5 / 0.729e3 * t12703 - 0.4e4 / 0.243e3 * t12707 + 0.5e3 / 0.243e3 * t12711 + 0.2e5 / 0.729e3 * t12715 - 0.25e4 / 0.243e3 * t12719 - t12940 + 0.5e3 / 0.27e2 * t12724;
  t12944 = -0.5e3 / 0.81e2 * t12638 - 0.5e3 / 0.81e2 * t12641 - 0.5e3 / 0.81e2 * t12644 - 0.5e3 / 0.27e2 * t12646 + 0.8e4 / 0.243e3 * t12649 - 0.5e3 / 0.243e3 * t12653 + 0.35e2 / 0.9e1 * t12657 + 0.5e1 / 0.6e1 * t12662 - 0.5e1 / 0.3e1 * t12666 + 0.595e3 / 0.54e2 * t12670 + 0.5e1 / 0.6e1 * t12674 - 0.5e1 / 0.6e1 * t12676 + 0.5e1 / 0.3e1 * t12678 - 0.25e2 / 0.27e2 * t12730 - 0.25e2 / 0.54e2 * t12735 + t12942 * t146;
  t12949 = 0.5e1 / 0.6e1 * t3408;
  t12954 = 0.11e3 / 0.27e2 * t3423;
  t12957 = -0.5e3 / 0.27e2 * t3400 - 0.5e1 / 0.12e2 * t3402 - 0.5e1 / 0.6e1 * t3404 + t9 * (t12809 + t12825 + t12843 + t12860 + t12879 + t12895 + t12912 + t12944) - t12949 + 0.8e4 / 0.243e3 * t3413 - 0.5e1 / 0.12e2 * t3415 + 0.2e2 / 0.9e1 * t3417 + 0.2e2 / 0.9e1 * t3419 - t12954 + 0.25e2 / 0.54e2 * t3426 + 0.25e4 / 0.243e3 * t3431;
  t12970 = 0.25e2 / 0.27e2 * t3434 - 0.35e3 / 0.81e2 * t3440 + 0.5e2 / 0.27e2 * t3444 + 0.6e1 * t3611 + 0.3e1 * t3622 + 0.35e2 / 0.9e1 * t3447 - 0.5e1 / 0.3e1 * t3451 - 0.5e1 / 0.12e2 * t3455 - 0.5e1 / 0.12e2 * t3458 - 0.5e1 / 0.6e1 * t3460 - 0.5e3 / 0.81e2 * t3466 + 0.25e2 / 0.54e2 * t3469;
  t12984 = 0.25e2 / 0.27e2 * t3472 + 0.3e1 * t3633 - 0.35e2 / 0.9e1 * t3476 - 0.5e1 / 0.6e1 * t3481 + 0.5e1 / 0.3e1 * t3488 + 0.5e1 / 0.6e1 * t3493 + 0.5e1 / 0.12e2 * t3497 + 0.5e1 / 0.6e1 * t3499 + 0.25e2 / 0.27e2 * t3505 - 0.25e2 / 0.27e2 * t3510 - 0.1e4 / 0.81e2 * t3513 - 0.1e4 / 0.81e2 * t3516;
  t12991 = 0.7e2 / 0.9e1 * t3569;
  t12992 = 0.11e4 / 0.243e3 * t3573;
  t12995 = 0.595e3 / 0.54e2 * t3581;
  t12998 = -0.5e3 / 0.81e2 * t3520 + 0.25e2 / 0.54e2 * t3557 + 0.5e2 / 0.27e2 * t3559 + 0.5e2 / 0.27e2 * t3561 + 0.25e2 / 0.27e2 * t3563 - 0.4e3 / 0.81e2 * t3566 + t12991 + t12992 + 0.35e2 / 0.9e1 * t3575 - 0.5e1 / 0.3e1 * t3577 - t12995 - 0.2e3 / 0.81e2 * t3584 - 0.2e3 / 0.81e2 * t3588;
  tv4rho3sigma1 = t12957 + t12970 + t12984 + t12998;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  tv4rho3sigma2 = tv4rho3sigma0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t13000 = 0.2e1 * t3678;
  t13002 = t190 * t3503 * t355;
  t13004 = t62 * t951;
  t13007 = t407 * t1151 * t13004 * t209;
  t13009 = t3503 * t6270;
  t13010 = t3501 * t13009;
  t13020 = 0.595e3 / 0.162e3 * t12320;
  t13021 = 0.5e1 / 0.18e2 * t12351;
  t13023 = 0.25e2 / 0.162e3 * t13002 + 0.5e1 / 0.36e2 * t13007 + 0.25e2 / 0.162e3 * t13010 - 0.2e3 / 0.243e3 * t12298 - 0.1e3 / 0.243e3 * t12300 - 0.5e2 / 0.243e3 * t12303 - 0.1e3 / 0.243e3 * t12306 + 0.35e2 / 0.108e3 * t12308 + 0.5e1 / 0.36e2 * t12310 + 0.35e4 / 0.729e3 * t12314 + 0.5e3 / 0.243e3 * t12317 - t13020 - t13021 + 0.5e1 / 0.18e2 * t12353;
  t13025 = 0.11e4 / 0.729e3 * t12366;
  t13026 = 0.11e4 / 0.729e3 * t12370;
  t13027 = 0.595e3 / 0.162e3 * t12378;
  t13028 = 0.595e3 / 0.162e3 * t12381;
  t13029 = 0.22e4 / 0.729e3 * t12384;
  t13032 = t1224 * t3480;
  t13034 = t1224 * t3487;
  t13035 = 0.5e1 / 0.18e2 * t13034;
  t13038 = t407 * t3478 * t3794 * t575;
  t13040 = t8 * t382;
  t13043 = t407 * t1151 * t13040 * t209;
  t13044 = 0.5e1 / 0.18e2 * t13043;
  t13047 = t407 * t1151 * t12594 * t360;
  t13049 = 0.5e1 / 0.36e2 * t12357 + t12362 + t13025 + t13026 - t12377 - t13027 - t13028 + t13029 - 0.5e2 / 0.243e3 * t12390 - 0.2e3 / 0.243e3 * t12392 - 0.5e1 / 0.36e2 * t13032 + t13035 - 0.5e1 / 0.36e2 * t13038 + t13044 + 0.5e1 / 0.72e2 * t13047;
  t13053 = t407 * t1151 * t3490 * t886;
  t13057 = t407 * t1151 * t1152 * t2628;
  t13060 = t3463 * t409 * t2474;
  t13062 = t3457 * t1231;
  t13064 = t1136 * t3807;
  t13066 = t1136 * t3811;
  t13068 = t1136 * t3796;
  t13071 = t407 * t12668 * t1230;
  t13074 = t407 * t3474 * t3790;
  t13078 = t190 * t193 * t2485 * t177;
  t13079 = 0.1e3 / 0.243e3 * t13078;
  t13081 = t190 * t2549 * t1132;
  t13082 = 0.1e3 / 0.243e3 * t13081;
  t13085 = t407 * t408 * t213 * t951;
  t13086 = 0.5e1 / 0.18e2 * t13085;
  t13088 = t190 * t871 * t3586;
  t13089 = 0.1e3 / 0.243e3 * t13088;
  t13091 = t190 * t549 * t3728;
  t13092 = 0.1e3 / 0.243e3 * t13091;
  t13094 = t407 * t1147 * t3734;
  t13095 = 0.35e2 / 0.54e2 * t13094;
  t13096 = 0.5e1 / 0.36e2 * t13053 + 0.5e1 / 0.72e2 * t13057 - 0.25e3 / 0.243e3 * t13060 + 0.5e1 / 0.72e2 * t13062 + 0.5e1 / 0.36e2 * t13064 + 0.5e1 / 0.36e2 * t13066 + 0.5e1 / 0.36e2 * t13068 + 0.595e3 / 0.324e3 * t13071 - 0.35e2 / 0.27e2 * t13074 - t13079 - t13082 - t13086 - t13089 - t13092 + t13095;
  t13098 = t190 * t871 * t3571;
  t13102 = t190 * t193 * t902 * t58;
  t13104 = t12383 * t356;
  t13106 = t3565 * t858;
  t13107 = 0.2e3 / 0.243e3 * t13106;
  t13108 = t3565 * t862;
  t13109 = 0.2e3 / 0.243e3 * t13108;
  t13110 = t3565 * t866;
  t13111 = 0.2e3 / 0.243e3 * t13110;
  t13113 = t407 * t3579 * t1234;
  t13116 = t407 * t1147 * t3701;
  t13120 = t407 * t408 * t12348 * t360;
  t13122 = t1136 * t3735;
  t13124 = t3748 * t1162;
  t13126 = t1224 * t3454;
  t13128 = t3457 * t1235;
  t13131 = t2575 * t50 * t410;
  t13135 = t407 * t408 * t63 * t2756;
  t13137 = 0.55e3 / 0.729e3 * t13098 + 0.55e3 / 0.729e3 * t13102 + 0.11e4 / 0.729e3 * t13104 - t13107 - t13109 - t13111 - 0.595e3 / 0.324e3 * t13113 + 0.35e2 / 0.27e2 * t13116 + 0.5e1 / 0.36e2 * t13120 - 0.5e1 / 0.36e2 * t13122 - 0.5e1 / 0.36e2 * t13124 - 0.5e1 / 0.72e2 * t13126 - 0.5e1 / 0.72e2 * t13128 - 0.5e1 / 0.72e2 * t13131 - 0.5e1 / 0.72e2 * t13135;
  t13140 = t1136 * t3702;
  t13141 = 0.5e1 / 0.18e2 * t13140;
  t13142 = t1136 * t3698;
  t13143 = 0.35e2 / 0.54e2 * t13142;
  t13145 = t190 * t871 * t3555;
  t13147 = t1110 * t908;
  t13148 = 0.1e2 / 0.27e2 * t13147;
  t13149 = 0.2975e4 / 0.729e3 * t12411;
  t13155 = 0.11e3 / 0.81e2 * t12451;
  t13156 = t10085 * t3680;
  t13159 = t543 * t590 * t1213;
  t13162 = t543 * t594 * t1213;
  t13164 = -t13141 + t13143 + 0.25e2 / 0.324e3 * t13145 + t13148 + t13149 - 0.25e2 / 0.162e3 * t12426 - 0.175e3 / 0.486e3 * t12429 - 0.1e5 / 0.2187e4 * t12443 - 0.175e3 / 0.243e3 * t12446 - 0.25e2 / 0.81e2 * t12449 - t13155 + t12456 - 0.5e3 / 0.81e2 * t13156 - 0.25e3 / 0.243e3 * t13159 - 0.5e3 / 0.243e3 * t13162;
  t13166 = t1141 * t3438 * t903;
  t13167 = 0.175e3 / 0.243e3 * t13166;
  t13169 = t1141 * t3442 * t903;
  t13170 = 0.25e2 / 0.81e2 * t13169;
  t13171 = t181 * t185;
  t13172 = t13171 * t1140;
  t13173 = t13172 * t3774;
  t13174 = 0.35e3 / 0.243e3 * t13173;
  t13176 = t1141 * t3438 * t861;
  t13177 = 0.175e3 / 0.243e3 * t13176;
  t13179 = t1141 * t3438 * t865;
  t13180 = 0.175e3 / 0.243e3 * t13179;
  t13182 = t805 * t6488 * t206;
  t13185 = t13182 * t6491 * t3867 * t180;
  t13187 = t13172 * t3777;
  t13188 = 0.5e2 / 0.81e2 * t13187;
  t13190 = t1141 * t3442 * t861;
  t13191 = 0.25e2 / 0.81e2 * t13190;
  t13193 = t1141 * t3442 * t865;
  t13194 = 0.25e2 / 0.81e2 * t13193;
  t13196 = t1141 * t1143 * t2486;
  t13198 = t842 * t185;
  t13200 = t13198 * t1140 * t1144;
  t13202 = t3756 * t3433;
  t13206 = t1141 * t4364 * t3868;
  t13207 = 0.175e3 / 0.243e3 * t13206;
  t13208 = t13172 * t3869;
  t13210 = -t13167 + t13170 - t13174 - t13177 - t13180 + 0.5e3 / 0.243e3 * t13185 + t13188 + t13191 + t13194 + 0.25e2 / 0.162e3 * t13196 + 0.25e2 / 0.81e2 * t13200 + 0.25e2 / 0.81e2 * t13202 + t1244 * t791 + t13207 - 0.25e2 / 0.81e2 * t13208;
  t13212 = t553 * t3867;
  t13214 = t1141 * t1354 * t13212;
  t13217 = t194 * t841 * t209;
  t13219 = t1141 * t1354 * t13217;
  t13222 = t194 * t350 * t583;
  t13224 = t1141 * t1354 * t13222;
  t13226 = t4929 * t326;
  t13228 = t1141 * t1354 * t13226;
  t13231 = t194 * t350 * t575;
  t13233 = t1141 * t1338 * t13231;
  t13236 = t1141 * t4345 * t3868;
  t13237 = 0.25e2 / 0.81e2 * t13236;
  t13239 = t1141 * t4364 * t3857;
  t13240 = 0.175e3 / 0.243e3 * t13239;
  t13242 = t1141 * t4345 * t3857;
  t13243 = 0.25e2 / 0.81e2 * t13242;
  t13244 = t902 * t3507;
  t13246 = t1141 * t1354 * t13244;
  t13250 = t543 * t147 * t12604 * t350;
  t13253 = t543 * t317 * t3686;
  t13255 = t10085 * t3687;
  t13259 = t543 * t147 * t1120 * t2544;
  t13262 = t543 * t892 * t1121;
  t13265 = t543 * t896 * t1121;
  t13267 = -0.25e2 / 0.162e3 * t13214 - 0.25e2 / 0.162e3 * t13219 - 0.25e2 / 0.324e3 * t13224 - 0.25e2 / 0.162e3 * t13228 + 0.25e2 / 0.162e3 * t13233 - t13237 + t13240 - t13243 - 0.25e2 / 0.162e3 * t13246 - 0.22e5 / 0.2187e4 * t13250 - 0.5e3 / 0.243e3 * t13253 - 0.5e3 / 0.81e2 * t13255 - 0.25e3 / 0.243e3 * t13259 - 0.5e3 / 0.243e3 * t13262 - 0.5e3 / 0.243e3 * t13265;
  t13269 = t543 * t365 * t3518;
  t13272 = t543 * t907 * t1121;
  t13275 = t543 * t952 * t1121;
  t13279 = t154 * t1338 * t1514 * t583;
  t13281 = t10183 * t3864;
  t13285 = t2814 * t3428 * t841 * t3863;
  t13289 = t2814 * t12440 * t350 * t3863;
  t13290 = 0.2e5 / 0.2187e4 * t13289;
  t13293 = t527 * t185 * t800;
  t13295 = t10176 * t12397 * t350 * t13293;
  t13297 = t10193 * t3864;
  t13299 = t4934 * t326;
  t13301 = t1141 * t1354 * t13299;
  t13303 = t1514 * t810;
  t13305 = t1141 * t1354 * t13303;
  t13308 = t522 * t40 * t152;
  t13310 = t2814 * t3861 * t13308;
  t13313 = t1113 * t2806;
  t13315 = t1113 * t2554;
  t13317 = -0.25e3 / 0.243e3 * t13269 - 0.5e3 / 0.243e3 * t13272 - 0.5e3 / 0.243e3 * t13275 - 0.5e1 / 0.36e2 * t13279 + 0.25e4 / 0.729e3 * t13281 + 0.25e4 / 0.729e3 * t13285 - t13290 - 0.5e5 / 0.6561e4 * t13295 + 0.25e4 / 0.729e3 * t13297 - 0.25e2 / 0.162e3 * t13301 - 0.25e2 / 0.324e3 * t13305 + 0.125e4 / 0.729e3 * t13310 + t420 * t2756 + 0.25e2 / 0.162e3 * t13313 + 0.25e2 / 0.162e3 * t13315;
  t13321 = t1113 * t2557;
  t13323 = t1113 * t2560;
  t13325 = t1113 * t2564;
  t13327 = t1113 * t2546;
  t13329 = t9410 * t3711;
  t13332 = t190 * t9502 * t403;
  t13334 = t1113 * t2493;
  t13336 = t1113 * t2497;
  t13338 = t3565 * t872;
  t13339 = 0.2e3 / 0.243e3 * t13338;
  t13342 = t46 * t55 * t1142 * t382;
  t13345 = t543 * t383 * t3411;
  t13346 = 0.4e4 / 0.729e3 * t13345;
  t13347 = t1109 * t542;
  t13348 = t13347 * t855;
  t13349 = 0.4e4 / 0.243e3 * t13348;
  t13351 = t543 * t317 * t3853;
  t13352 = 0.4e4 / 0.729e3 * t13351;
  t13355 = t543 * t147 * t3410 * t841;
  t13356 = 0.4e4 / 0.729e3 * t13355;
  t13357 = 0.25e2 / 0.81e2 * t13321 + 0.25e2 / 0.81e2 * t13323 + 0.25e2 / 0.162e3 * t13325 + 0.25e2 / 0.162e3 * t13327 + 0.25e2 / 0.81e2 * t13329 + 0.25e2 / 0.324e3 * t13332 + 0.25e2 / 0.162e3 * t13334 + 0.25e2 / 0.81e2 * t13336 - t13339 - 0.5e1 / 0.36e2 * t13342 + t13346 + t13349 + t13352 + t13356;
  t13359 = t543 * t365 * t3411;
  t13360 = 0.4e4 / 0.729e3 * t13359;
  t13362 = t543 * t217 * t3853;
  t13363 = 0.4e4 / 0.729e3 * t13362;
  t13365 = t543 * t383 * t3518;
  t13367 = t3399 * t2475;
  t13369 = t400 * t2596;
  t13371 = t400 * t2657;
  t13373 = t400 * t2824;
  t13375 = 0.25e2 / 0.81e2 * t12481;
  t13378 = t9410 * t3741;
  t13381 = t190 * t2409 * t1220;
  t13384 = t190 * t549 * t3744;
  t13386 = t9410 * t3738;
  t13389 = t190 * t2549 * t1128;
  t13391 = t13360 + t13363 - 0.25e3 / 0.243e3 * t13365 - 0.25e3 / 0.81e2 * t13367 - 0.5e1 / 0.72e2 * t13369 - 0.5e1 / 0.72e2 * t13371 - 0.5e1 / 0.36e2 * t13373 - t13375 - 0.5e1 / 0.18e2 * t12486 - 0.35e2 / 0.54e2 * t12501 + 0.25e2 / 0.81e2 * t13378 + 0.25e2 / 0.324e3 * t13381 + 0.25e2 / 0.162e3 * t13384 + 0.25e2 / 0.81e2 * t13386 + 0.25e2 / 0.162e3 * t13389;
  t13395 = t190 * t193 * t9506 * t35;
  t13397 = t9410 * t3745;
  t13406 = t400 * t2763;
  t13408 = t400 * t2767;
  t13410 = t3422 * t366;
  t13412 = t3422 * t384;
  t13414 = 0.11e3 / 0.81e2 * t12543;
  t13416 = t9482 * t365 * t1120;
  t13419 = t9482 * t383 * t1120;
  t13422 = 0.25e2 / 0.324e3 * t13395 + 0.25e2 / 0.81e2 * t13397 + 0.2e1 * t3836 * t316 + 0.2e1 * t1179 * t951 + 0.175e3 / 0.243e3 * t12525 + 0.1e2 / 0.27e2 * t12527 + 0.2e4 / 0.243e3 * t12530 - 0.5e1 / 0.72e2 * t13406 - 0.5e1 / 0.36e2 * t13408 - 0.55e2 / 0.81e2 * t13410 - 0.55e2 / 0.81e2 * t13412 - t13414 - 0.25e3 / 0.81e2 * t13416 - 0.25e3 / 0.81e2 * t13419 + 0.5e1 / 0.27e2 * t12545;
  t13425 = t805 * t12511 * t63;
  t13426 = t2429 * t350;
  t13427 = t13426 * t4421;
  t13428 = t13425 * t13427;
  t13432 = t6365 * t8369 * t6927 * t3507;
  t13434 = t352 * t3407;
  t13437 = t543 * t217 * t3686;
  t13439 = t10085 * t3683;
  t13442 = t543 * t792 * t1213;
  t13444 = t400 * t2758;
  t13446 = t3756 * t3425;
  t13449 = t1141 * t1143 * t2563;
  t13452 = t1141 * t1143 * t2496;
  t13455 = t1141 * t1143 * t2545;
  t13457 = t5108 * t527;
  t13459 = t3463 * t63 * t13457;
  t13462 = t351 * t3462 * t3465;
  t13464 = t3565 * t904;
  t13465 = 0.2e3 / 0.243e3 * t13464;
  t13466 = 0.5e1 / 0.27e2 * t12547 + 0.125e4 / 0.729e3 * t13428 + 0.25e2 / 0.81e2 * t13432 - 0.5e1 / 0.36e2 * t13434 - 0.5e3 / 0.243e3 * t13437 - 0.5e3 / 0.81e2 * t13439 - 0.25e3 / 0.243e3 * t13442 - 0.5e1 / 0.72e2 * t13444 + 0.25e2 / 0.162e3 * t13446 + 0.25e2 / 0.324e3 * t13449 + 0.25e2 / 0.162e3 * t13452 + 0.25e2 / 0.324e3 * t13455 - 0.25e3 / 0.243e3 * t13459 - 0.25e3 / 0.81e2 * t13462 - t13465;
  t13469 = t1224 * t3580;
  t13471 = t1224 * t3568;
  t13473 = t3748 * t1148;
  t13474 = 0.35e2 / 0.54e2 * t13473;
  t13475 = t3748 * t1158;
  t13476 = 0.5e1 / 0.18e2 * t13475;
  t13477 = t1224 * t3446;
  t13478 = 0.35e2 / 0.54e2 * t13477;
  t13479 = t1224 * t3450;
  t13480 = 0.5e1 / 0.18e2 * t13479;
  t13483 = t407 * t1151 * t3794 * t583;
  t13486 = t3463 * t409 * t2470;
  t13489 = t407 * t3474 * t3795;
  t13490 = 0.35e2 / 0.54e2 * t13489;
  t13491 = t1136 * t3787;
  t13492 = 0.35e2 / 0.54e2 * t13491;
  t13494 = t407 * t3474 * t3806;
  t13495 = 0.35e2 / 0.54e2 * t13494;
  t13497 = t407 * t3474 * t3810;
  t13498 = 0.35e2 / 0.54e2 * t13497;
  t13499 = t1136 * t3791;
  t13500 = 0.5e1 / 0.18e2 * t13499;
  t13503 = t407 * t1151 * t12483 * t360;
  t13504 = 0.5e1 / 0.18e2 * t13503;
  t13507 = t407 * t1151 * t3485 * t886;
  t13508 = 0.5e1 / 0.18e2 * t13507;
  t13509 = -0.595e3 / 0.324e3 * t13469 + 0.35e2 / 0.27e2 * t13471 + t13474 - t13476 + t13478 - t13480 + 0.5e1 / 0.72e2 * t13483 - 0.5e3 / 0.243e3 * t13486 - t13490 - t13492 - t13495 - t13498 + t13500 + t13504 + t13508;
  t13511 = t3463 * t1161 * t854;
  t13513 = t1110 * t953;
  t13514 = 0.1e2 / 0.27e2 * t13513;
  t13515 = t1110 * t893;
  t13516 = 0.1e2 / 0.27e2 * t13515;
  t13517 = t1110 * t897;
  t13518 = 0.1e2 / 0.27e2 * t13517;
  t13522 = t1224 * t3475;
  t13523 = 0.35e2 / 0.54e2 * t13522;
  t13524 = t1224 * t3496;
  t13526 = t3748 * t1154;
  t13528 = t1224 * t3492;
  t13533 = t399 * t2784;
  t13534 = t13533 * t2787;
  t13537 = 0.22e4 / 0.729e3 * t12688;
  t13539 = 0.44e5 / 0.2187e4 * t12696;
  t13540 = t3530 * t2795;
  t13544 = t805 * t806 * t177 * t841;
  t13545 = 0.4e4 / 0.729e3 * t13544;
  t13548 = t805 * t806 * t35 * t2544;
  t13550 = t12687 * t391;
  t13553 = -0.5e4 / 0.729e3 * t13534 - 0.2e4 / 0.243e3 * t12685 - t13537 + 0.1e3 / 0.243e3 * t12690 + t13539 + t12701 + 0.25e3 / 0.81e2 * t13540 - t13545 + 0.25e3 / 0.243e3 * t13548 - 0.11e4 / 0.729e3 * t13550 - 0.2e4 / 0.729e3 * t12707;
  t13554 = t12684 * t963;
  t13555 = 0.4e4 / 0.243e3 * t13554;
  t13556 = t3530 * t2791;
  t13560 = t2785 * t3831 * t180 * t50;
  t13564 = t2785 * t1240 * t522 * t50;
  t13568 = t10131 * t1240 * t527 * t189;
  t13573 = t2785 * t3827 * t180 * t50;
  t13574 = 0.2e5 / 0.2187e4 * t13573;
  t13575 = t1168 * t2799;
  t13579 = t805 * t806 * t58 * t350;
  t13581 = t3527 * t967;
  t13582 = 0.2e3 / 0.243e3 * t13581;
  t13583 = -t13555 + 0.5e3 / 0.81e2 * t13556 - 0.25e4 / 0.729e3 * t13560 - 0.125e4 / 0.729e3 * t13564 + 0.5e5 / 0.6561e4 * t13568 + 0.1e5 / 0.2187e4 * t12715 + t13574 - 0.25e2 / 0.162e3 * t13575 + 0.22e5 / 0.2187e4 * t13579 + t13582 - t12723;
  t13586 = -0.5e3 / 0.243e3 * t13511 + t13514 + t13516 + t13518 + 0.35e2 / 0.54e2 * t12557 + 0.35e2 / 0.108e3 * t12560 + 0.25e2 / 0.81e2 * t12563 - t13523 + 0.5e1 / 0.72e2 * t13524 + 0.5e1 / 0.36e2 * t13526 + 0.5e1 / 0.36e2 * t13528 - 0.35e2 / 0.108e3 * t12584 - 0.175e3 / 0.243e3 * t12589 - 0.25e2 / 0.81e2 * t12592 + (t13553 + t13583) * t146;
  t13589 = t1141 * t1143 * t2805;
  t13592 = t154 * t4358 * t3765;
  t13593 = 0.35e2 / 0.27e2 * t13592;
  t13594 = t322 * t3766;
  t13598 = t154 * t1338 * t4929 * t209;
  t13602 = t154 * t1338 * t4934 * t209;
  t13605 = t360 * t544;
  t13608 = t3463 * t1797 * t13605 * t527;
  t13610 = t12313 * t3801;
  t13611 = 0.7e4 / 0.729e3 * t13610;
  t13613 = t3463 * t1157 * t854;
  t13614 = 0.1e4 / 0.243e3 * t13613;
  t13616 = 0.44e5 / 0.2187e4 * t12607;
  t13617 = 0.5e1 / 0.18e2 * t12615;
  t13618 = 0.35e2 / 0.54e2 * t12619;
  t13621 = 0.25e2 / 0.324e3 * t13589 + t13593 - 0.5e1 / 0.18e2 * t13594 - 0.5e1 / 0.18e2 * t13598 - 0.5e1 / 0.18e2 * t13602 - 0.35e2 / 0.54e2 * t12600 + 0.25e3 / 0.243e3 * t13608 + t13611 - t13614 + t3551 * t382 - t13616 + t13617 - t13618 + 0.4e4 / 0.729e3 * t12622 + 0.2e4 / 0.729e3 * t12626;
  t13622 = 0.5e1 / 0.18e2 * t12634;
  t13626 = t154 * t4252 * t1514 * t575;
  t13629 = t154 * t4258 * t3765;
  t13630 = 0.5e1 / 0.9e1 * t13629;
  t13632 = t1141 * t12409 * t355;
  t13635 = t1141 * t12413 * t355;
  t13637 = t1354 * t6266;
  t13638 = t12417 * t13637;
  t13640 = t10765 * t3430;
  t13642 = t10866 * t3430;
  t13644 = t3530 * t2813;
  t13645 = t13644 * t2817;
  t13649 = 0.595e3 / 0.162e3 * t12670;
  t13652 = t13622 + 0.4e4 / 0.729e3 * t12649 + 0.5e1 / 0.12e2 * t13626 - t13630 + 0.2975e4 / 0.1458e4 * t13632 - 0.35e3 / 0.243e3 * t13635 - 0.25e2 / 0.162e3 * t13638 + 0.125e4 / 0.729e3 * t13640 + 0.125e4 / 0.729e3 * t13642 + 0.5e4 / 0.729e3 * t13645 + 0.35e2 / 0.54e2 * t12657 + 0.5e1 / 0.18e2 * t12666 + t13649 - 0.5e1 / 0.36e2 * t12674 - 0.5e1 / 0.18e2 * t12678;
  t13658 = t13000 - t3401 - t3403 - t3405 + t3409 + t3600 + t9 * (t13023 + t13049 + t13096 + t13137 + t13164 + t13210 + t13267 + t13317 + t13357 + t13391 + t13422 + t13466 + t13509 + t13586 + t13621 + t13652) - t3881 - t3882 - t3883 - t3884 - t3885;
  t13659 = -t3886 + t3887 - t3888 + t3889 - t3890 + t3891 + t3892 + t3893 + t3894 + t3895 + t3896 - t3898 - t3899;
  t13661 = -t3900 - t3901 - t3902 + t3903 + t3904 + t3905 - t3906 - t3907 - t3416 + t3602 + t3603 - t12745;
  t13662 = 0.2e1 * t3782;
  t13663 = t3908 + t3909 + t3910 - t3911 + t3912 - t3915 + t3916 + t3427 + t3432 + t3435 - t3609 + t13662 + t3623;
  t13666 = -t3456 - t3459 - t3461 - t3467 + t3470 + t3473 - t3634 - t3482 + t3494 + t3498 + t3500 + t3506;
  t13667 = -t3926 + t3927 + t3928 + t3929 - t3930 + t3931 + t3932 + t3933 - t3511 - t3514 - t3517 - t3521 + t3523;
  t13669 = 0.2e1 * t3815;
  t13670 = 0.2e1 * t3837;
  t13671 = t3552 + t3553 + t13669 + t13670 + t3937 + t3938 - t3939 - t3940 - t3941 + t3558 + t3560 + t3562;
  t13672 = t3564 - t3650 + t3570 + t12783 + t3653 - t12786 - t3656 - t3657 + t3942 - t3943 + t3944 - t3945 - t3946;
  tv4rho3sigma3 = t13658 + t13659 + t13661 + t13663 + t13666 + t13667 + t13671 + t13672;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  t13676 = 0.1e4 / 0.243e3 * t3681;
  t13677 = 0.1e4 / 0.243e3 * t3684;
  t13678 = 0.1e4 / 0.243e3 * t3688;
  t13679 = 0.1e4 / 0.243e3 * t3691;
  t13680 = 0.1e4 / 0.243e3 * t3694;
  t13681 = 0.1e4 / 0.81e2 * t3696;
  t13682 = -t3596 - t3597 - t3598 + t3599 + 0.16e5 / 0.729e3 * t3413 - t13676 - t13677 - t13678 - t13679 - t13680 - t13681 + t4072;
  t13683 = 0.5e2 / 0.81e2 * t3709;
  t13684 = 0.25e2 / 0.81e2 * t3712;
  t13685 = 0.5e2 / 0.81e2 * t3714;
  t13686 = 0.5e2 / 0.81e2 * t3716;
  t13687 = 0.5e2 / 0.81e2 * t3718;
  t13688 = 0.5e2 / 0.81e2 * t3721;
  t13689 = 0.5e1 / 0.18e2 * t3732;
  t13690 = -t4073 + t4074 - t4075 + t13683 + t13684 + t13685 + t13686 + t13687 + t13688 - t4076 - t4078 - t4079 - t13689;
  t13692 = 0.5e1 / 0.18e2 * t3736;
  t13693 = 0.25e2 / 0.81e2 * t3739;
  t13694 = 0.25e2 / 0.81e2 * t3742;
  t13695 = 0.25e2 / 0.81e2 * t3746;
  t13696 = 0.5e1 / 0.18e2 * t3749;
  t13697 = 0.5e1 / 0.18e2 * t3751;
  t13700 = 0.25e2 / 0.81e2 * t13002;
  t13714 = t13700 + 0.5e1 / 0.18e2 * t13007 + 0.25e2 / 0.81e2 * t13010 - 0.4e3 / 0.243e3 * t12298 - 0.2e3 / 0.243e3 * t12300 - 0.1e3 / 0.243e3 * t12303 - 0.2e3 / 0.243e3 * t12306 + 0.35e2 / 0.54e2 * t12308 + 0.5e1 / 0.18e2 * t12310 + 0.7e4 / 0.729e3 * t12314 + 0.1e4 / 0.243e3 * t12317 - 0.595e3 / 0.81e2 * t12320 - 0.5e1 / 0.9e1 * t12351 + 0.5e1 / 0.9e1 * t12353;
  t13719 = 0.595e3 / 0.81e2 * t12381;
  t13724 = 0.5e1 / 0.9e1 * t13034;
  t13726 = 0.5e1 / 0.9e1 * t13043;
  t13728 = 0.5e1 / 0.18e2 * t12357 + t12816 + 0.22e4 / 0.729e3 * t12366 + 0.22e4 / 0.729e3 * t12370 - t12821 - 0.595e3 / 0.81e2 * t12378 - t13719 + 0.44e4 / 0.729e3 * t12384 - 0.1e3 / 0.243e3 * t12390 - 0.4e3 / 0.243e3 * t12392 - 0.5e1 / 0.18e2 * t13032 + t13724 - 0.5e1 / 0.18e2 * t13038 + t13726 + 0.5e1 / 0.36e2 * t13047;
  t13737 = 0.595e3 / 0.162e3 * t13071;
  t13739 = 0.2e3 / 0.243e3 * t13078;
  t13740 = 0.2e3 / 0.243e3 * t13081;
  t13741 = 0.5e1 / 0.9e1 * t13085;
  t13742 = 0.2e3 / 0.243e3 * t13088;
  t13743 = 0.2e3 / 0.243e3 * t13091;
  t13744 = 0.35e2 / 0.27e2 * t13094;
  t13745 = 0.5e1 / 0.18e2 * t13053 + 0.5e1 / 0.36e2 * t13057 - 0.5e3 / 0.243e3 * t13060 + 0.5e1 / 0.36e2 * t13062 + 0.5e1 / 0.18e2 * t13064 + 0.5e1 / 0.18e2 * t13066 + 0.5e1 / 0.18e2 * t13068 + t13737 - 0.7e2 / 0.27e2 * t13074 - t13739 - t13740 - t13741 - t13742 - t13743 + t13744;
  t13746 = 0.11e4 / 0.729