/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/lda_exc/lda_c_1d_csc.mpl
  Type of functional: lda_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t13;
  double t14, t15, t16, t17, t18, t21, t24, t25;
  double t26, t29, t30, t31, t33, t34, tzk0;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = 0.1e1 / rho[0];
  t2 = t1 / 0.2e1;
  t3 = params->para[4];
  t4 = rho[0] * rho[0];
  t5 = 0.1e1 / t4;
  t8 = t2 + t3 * t5 / 0.4e1;
  t9 = params->para[7];
  t13 = params->para[9];
  t14 = pow(t2, t13);
  t15 = params->para[8] * t14;
  t16 = 0.1e1 + t9 * t1 / 0.2e1 + t15;
  t17 = log(t16);
  t18 = t8 * t17;
  t21 = params->para[1];
  t24 = params->para[5];
  t25 = pow(t2, t24);
  t26 = params->para[2] * t25;
  t29 = params->para[6];
  t30 = pow(t2, t29);
  t31 = params->para[3] * t30;
  t33 = t21 * t1 + 0.2e1 * t26 + 0.2e1 * t31 + 0.2e1 * params->para[0];
  t34 = 0.1e1 / t33;
  tzk0 = -t18 * t34;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t13;
  double t14, t15, t16, t17, t18, t21, t24, t25;
  double t26, t29, t30, t31, t33, t34, tzk0;

  double t37, t40, t41, t42, t44, t49, t50, t52;
  double t54, t55, t56, t64, t65, tvrho0;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = 0.1e1 / rho[0];
  t2 = t1 / 0.2e1;
  t3 = params->para[4];
  t4 = rho[0] * rho[0];
  t5 = 0.1e1 / t4;
  t8 = t2 + t3 * t5 / 0.4e1;
  t9 = params->para[7];
  t13 = params->para[9];
  t14 = pow(t2, t13);
  t15 = params->para[8] * t14;
  t16 = 0.1e1 + t9 * t1 / 0.2e1 + t15;
  t17 = log(t16);
  t18 = t8 * t17;
  t21 = params->para[1];
  t24 = params->para[5];
  t25 = pow(t2, t24);
  t26 = params->para[2] * t25;
  t29 = params->para[6];
  t30 = pow(t2, t29);
  t31 = params->para[3] * t30;
  t33 = t21 * t1 + 0.2e1 * t26 + 0.2e1 * t31 + 0.2e1 * params->para[0];
  t34 = 0.1e1 / t33;
  tzk0 = -t18 * t34;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t37 = 0.1e1 / t4 / rho[0];
  t40 = -t3 * t37 / 0.2e1 - t5 / 0.2e1;
  t41 = rho[0] * t40;
  t42 = t17 * t34;
  t44 = rho[0] * t8;
  t49 = -t9 * t5 / 0.2e1 - t15 * t13 * t1;
  t50 = 0.1e1 / t16;
  t52 = t49 * t50 * t34;
  t54 = t33 * t33;
  t55 = 0.1e1 / t54;
  t56 = t17 * t55;
  t64 = -0.2e1 * t26 * t24 * t1 - 0.2e1 * t31 * t29 * t1 - t21 * t5;
  t65 = t56 * t64;
  tvrho0 = -t41 * t42 - t44 * t52 + t44 * t65 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t13;
  double t14, t15, t16, t17, t18, t21, t24, t25;
  double t26, t29, t30, t31, t33, t34, tzk0;

  double t37, t40, t41, t42, t44, t49, t50, t52;
  double t54, t55, t56, t64, t65, tvrho0;

  double t67, t70, t71, t74, t77, t78, t81, t82;
  double t89, t94, t96, t98, t99, t100, t102, t104;
  double t105, t106, t110, t111, t112, t113, t117, t122;
  double t128, t129, tv2rho20;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = 0.1e1 / rho[0];
  t2 = t1 / 0.2e1;
  t3 = params->para[4];
  t4 = rho[0] * rho[0];
  t5 = 0.1e1 / t4;
  t8 = t2 + t3 * t5 / 0.4e1;
  t9 = params->para[7];
  t13 = params->para[9];
  t14 = pow(t2, t13);
  t15 = params->para[8] * t14;
  t16 = 0.1e1 + t9 * t1 / 0.2e1 + t15;
  t17 = log(t16);
  t18 = t8 * t17;
  t21 = params->para[1];
  t24 = params->para[5];
  t25 = pow(t2, t24);
  t26 = params->para[2] * t25;
  t29 = params->para[6];
  t30 = pow(t2, t29);
  t31 = params->para[3] * t30;
  t33 = t21 * t1 + 0.2e1 * t26 + 0.2e1 * t31 + 0.2e1 * params->para[0];
  t34 = 0.1e1 / t33;
  tzk0 = -t18 * t34;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t37 = 0.1e1 / t4 / rho[0];
  t40 = -t3 * t37 / 0.2e1 - t5 / 0.2e1;
  t41 = rho[0] * t40;
  t42 = t17 * t34;
  t44 = rho[0] * t8;
  t49 = -t9 * t5 / 0.2e1 - t15 * t13 * t1;
  t50 = 0.1e1 / t16;
  t52 = t49 * t50 * t34;
  t54 = t33 * t33;
  t55 = 0.1e1 / t54;
  t56 = t17 * t55;
  t64 = -0.2e1 * t26 * t24 * t1 - 0.2e1 * t31 * t29 * t1 - t21 * t5;
  t65 = t56 * t64;
  tvrho0 = -t41 * t42 - t44 * t52 + t44 * t65 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t67 = t40 * t17;
  t70 = t8 * t49;
  t71 = t50 * t34;
  t74 = t55 * t64;
  t77 = t4 * t4;
  t78 = 0.1e1 / t77;
  t81 = t37 + 0.3e1 / 0.2e1 * t3 * t78;
  t82 = rho[0] * t81;
  t89 = t13 * t13;
  t94 = t15 * t13 * t5 + t15 * t89 * t5 + t9 * t37;
  t96 = t94 * t50 * t34;
  t98 = t49 * t49;
  t99 = t16 * t16;
  t100 = 0.1e1 / t99;
  t102 = t98 * t100 * t34;
  t104 = t44 * t49;
  t105 = t50 * t55;
  t106 = t105 * t64;
  t110 = 0.1e1 / t54 / t33;
  t111 = t17 * t110;
  t112 = t64 * t64;
  t113 = t111 * t112;
  t117 = t24 * t24;
  t122 = t29 * t29;
  t128 = 0.2e1 * t26 * t117 * t5 + 0.2e1 * t31 * t122 * t5 + 0.2e1 * t26 * t24 * t5 + 0.2e1 * t31 * t29 * t5 + 0.2e1 * t21 * t37;
  t129 = t56 * t128;
  tv2rho20 = t44 * t102 + 0.2e1 * t104 * t106 - 0.2e1 * t44 * t113 + t44 * t129 + 0.2e1 * t18 * t74 - 0.2e1 * t67 * t34 - 0.2e1 * t41 * t52 + 0.2e1 * t41 * t65 - t82 * t42 - t44 * t96 - 0.2e1 * t70 * t71;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t13;
  double t14, t15, t16, t17, t18, t21, t24, t25;
  double t26, t29, t30, t31, t33, t34, tzk0;

  double t37, t40, t41, t42, t44, t49, t50, t52;
  double t54, t55, t56, t64, t65, tvrho0;

  double t67, t70, t71, t74, t77, t78, t81, t82;
  double t89, t94, t96, t98, t99, t100, t102, t104;
  double t105, t106, t110, t111, t112, t113, t117, t122;
  double t128, t129, tv2rho20;

  double t131, t132, t134, t135, t150, t159, t161, t165;
  double t175, t185, t186, t192, t194, t196, t199, t200;
  double t203, t206, t209, t212, t215, t220, t223, t224;
  double t226, t229, t230, t235, t236, t237, t240, t243;
  double t244, t245, t248, t249, t252, t255, tv3rho30;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = 0.1e1 / rho[0];
  t2 = t1 / 0.2e1;
  t3 = params->para[4];
  t4 = rho[0] * rho[0];
  t5 = 0.1e1 / t4;
  t8 = t2 + t3 * t5 / 0.4e1;
  t9 = params->para[7];
  t13 = params->para[9];
  t14 = pow(t2, t13);
  t15 = params->para[8] * t14;
  t16 = 0.1e1 + t9 * t1 / 0.2e1 + t15;
  t17 = log(t16);
  t18 = t8 * t17;
  t21 = params->para[1];
  t24 = params->para[5];
  t25 = pow(t2, t24);
  t26 = params->para[2] * t25;
  t29 = params->para[6];
  t30 = pow(t2, t29);
  t31 = params->para[3] * t30;
  t33 = t21 * t1 + 0.2e1 * t26 + 0.2e1 * t31 + 0.2e1 * params->para[0];
  t34 = 0.1e1 / t33;
  tzk0 = -t18 * t34;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t37 = 0.1e1 / t4 / rho[0];
  t40 = -t3 * t37 / 0.2e1 - t5 / 0.2e1;
  t41 = rho[0] * t40;
  t42 = t17 * t34;
  t44 = rho[0] * t8;
  t49 = -t9 * t5 / 0.2e1 - t15 * t13 * t1;
  t50 = 0.1e1 / t16;
  t52 = t49 * t50 * t34;
  t54 = t33 * t33;
  t55 = 0.1e1 / t54;
  t56 = t17 * t55;
  t64 = -0.2e1 * t26 * t24 * t1 - 0.2e1 * t31 * t29 * t1 - t21 * t5;
  t65 = t56 * t64;
  tvrho0 = -t41 * t42 - t44 * t52 + t44 * t65 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t67 = t40 * t17;
  t70 = t8 * t49;
  t71 = t50 * t34;
  t74 = t55 * t64;
  t77 = t4 * t4;
  t78 = 0.1e1 / t77;
  t81 = t37 + 0.3e1 / 0.2e1 * t3 * t78;
  t82 = rho[0] * t81;
  t89 = t13 * t13;
  t94 = t15 * t13 * t5 + t15 * t89 * t5 + t9 * t37;
  t96 = t94 * t50 * t34;
  t98 = t49 * t49;
  t99 = t16 * t16;
  t100 = 0.1e1 / t99;
  t102 = t98 * t100 * t34;
  t104 = t44 * t49;
  t105 = t50 * t55;
  t106 = t105 * t64;
  t110 = 0.1e1 / t54 / t33;
  t111 = t17 * t110;
  t112 = t64 * t64;
  t113 = t111 * t112;
  t117 = t24 * t24;
  t122 = t29 * t29;
  t128 = 0.2e1 * t26 * t117 * t5 + 0.2e1 * t31 * t122 * t5 + 0.2e1 * t26 * t24 * t5 + 0.2e1 * t31 * t29 * t5 + 0.2e1 * t21 * t37;
  t129 = t56 * t128;
  tv2rho20 = t44 * t102 + 0.2e1 * t104 * t106 - 0.2e1 * t44 * t113 + t44 * t129 + 0.2e1 * t18 * t74 - 0.2e1 * t67 * t34 - 0.2e1 * t41 * t52 + 0.2e1 * t41 * t65 - t82 * t42 - t44 * t96 - 0.2e1 * t70 * t71;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t131 = t54 * t54;
  t132 = 0.1e1 / t131;
  t134 = t112 * t64;
  t135 = t17 * t132 * t134;
  t150 = t89 * t13;
  t159 = -0.2e1 * t15 * t13 * t37 - t15 * t150 * t37 - 0.3e1 * t15 * t89 * t37 - 0.3e1 * t9 * t78;
  t161 = t159 * t50 * t34;
  t165 = t117 * t24;
  t175 = t122 * t29;
  t185 = -0.6e1 * t26 * t117 * t37 - 0.6e1 * t31 * t122 * t37 - 0.2e1 * t26 * t165 * t37 - 0.2e1 * t31 * t175 * t37 - 0.4e1 * t26 * t24 * t37 - 0.4e1 * t31 * t29 * t37 - 0.6e1 * t21 * t78;
  t186 = t56 * t185;
  t192 = t98 * t49;
  t194 = 0.1e1 / t99 / t16;
  t196 = t192 * t194 * t34;
  t199 = t8 * t98;
  t200 = t100 * t34;
  t203 = t110 * t112;
  t206 = 0.3e1 * t41 * t102 + 0.6e1 * t70 * t106 - 0.6e1 * t41 * t113 + 0.3e1 * t41 * t129 + 0.6e1 * t44 * t135 - t44 * t161 - 0.6e1 * t18 * t203 + t44 * t186 - 0.2e1 * t44 * t196 + 0.3e1 * t199 * t200 - 0.3e1 * t41 * t96 - 0.3e1 * t82 * t52 + 0.3e1 * t82 * t65;
  t209 = t40 * t49;
  t212 = t8 * t94;
  t215 = t55 * t128;
  t220 = 0.1e1 / t77 / rho[0];
  t223 = -0.6e1 * t3 * t220 - 0.3e1 * t78;
  t224 = rho[0] * t223;
  t226 = t41 * t49;
  t229 = t44 * t94;
  t230 = t200 * t49;
  t235 = t44 * t98;
  t236 = t100 * t55;
  t237 = t236 * t64;
  t240 = t105 * t128;
  t243 = t44 * t17;
  t244 = t110 * t64;
  t245 = t244 * t128;
  t248 = t50 * t110;
  t249 = t248 * t112;
  t252 = t81 * t17;
  t255 = 0.3e1 * t104 * t240 - 0.6e1 * t104 * t249 + 0.6e1 * t226 * t106 + 0.3e1 * t229 * t106 + 0.3e1 * t18 * t215 - 0.6e1 * t209 * t71 - 0.3e1 * t212 * t71 - t224 * t42 + 0.3e1 * t229 * t230 - 0.3e1 * t235 * t237 - 0.6e1 * t243 * t245 - 0.3e1 * t252 * t34 + 0.6e1 * t67 * t74;
  tv3rho30 = t206 + t255;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t13;
  double t14, t15, t16, t17, t18, t21, t24, t25;
  double t26, t29, t30, t31, t33, t34, tzk0;

  double t37, t40, t41, t42, t44, t49, t50, t52;
  double t54, t55, t56, t64, t65, tvrho0;

  double t67, t70, t71, t74, t77, t78, t81, t82;
  double t89, t94, t96, t98, t99, t100, t102, t104;
  double t105, t106, t110, t111, t112, t113, t117, t122;
  double t128, t129, tv2rho20;

  double t131, t132, t134, t135, t150, t159, t161, t165;
  double t175, t185, t186, t192, t194, t196, t199, t200;
  double t203, t206, t209, t212, t215, t220, t223, t224;
  double t226, t229, t230, t235, t236, t237, t240, t243;
  double t244, t245, t248, t249, t252, t255, tv3rho30;

  double t262, t268, t276, t283, t284, t300, t305, t323;
  double t336, t372, t378, t423, t433, t470, tv4rho40;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = 0.1e1 / rho[0];
  t2 = t1 / 0.2e1;
  t3 = params->para[4];
  t4 = rho[0] * rho[0];
  t5 = 0.1e1 / t4;
  t8 = t2 + t3 * t5 / 0.4e1;
  t9 = params->para[7];
  t13 = params->para[9];
  t14 = pow(t2, t13);
  t15 = params->para[8] * t14;
  t16 = 0.1e1 + t9 * t1 / 0.2e1 + t15;
  t17 = log(t16);
  t18 = t8 * t17;
  t21 = params->para[1];
  t24 = params->para[5];
  t25 = pow(t2, t24);
  t26 = params->para[2] * t25;
  t29 = params->para[6];
  t30 = pow(t2, t29);
  t31 = params->para[3] * t30;
  t33 = t21 * t1 + 0.2e1 * t26 + 0.2e1 * t31 + 0.2e1 * params->para[0];
  t34 = 0.1e1 / t33;
  tzk0 = -t18 * t34;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t37 = 0.1e1 / t4 / rho[0];
  t40 = -t3 * t37 / 0.2e1 - t5 / 0.2e1;
  t41 = rho[0] * t40;
  t42 = t17 * t34;
  t44 = rho[0] * t8;
  t49 = -t9 * t5 / 0.2e1 - t15 * t13 * t1;
  t50 = 0.1e1 / t16;
  t52 = t49 * t50 * t34;
  t54 = t33 * t33;
  t55 = 0.1e1 / t54;
  t56 = t17 * t55;
  t64 = -0.2e1 * t26 * t24 * t1 - 0.2e1 * t31 * t29 * t1 - t21 * t5;
  t65 = t56 * t64;
  tvrho0 = -t41 * t42 - t44 * t52 + t44 * t65 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t67 = t40 * t17;
  t70 = t8 * t49;
  t71 = t50 * t34;
  t74 = t55 * t64;
  t77 = t4 * t4;
  t78 = 0.1e1 / t77;
  t81 = t37 + 0.3e1 / 0.2e1 * t3 * t78;
  t82 = rho[0] * t81;
  t89 = t13 * t13;
  t94 = t15 * t13 * t5 + t15 * t89 * t5 + t9 * t37;
  t96 = t94 * t50 * t34;
  t98 = t49 * t49;
  t99 = t16 * t16;
  t100 = 0.1e1 / t99;
  t102 = t98 * t100 * t34;
  t104 = t44 * t49;
  t105 = t50 * t55;
  t106 = t105 * t64;
  t110 = 0.1e1 / t54 / t33;
  t111 = t17 * t110;
  t112 = t64 * t64;
  t113 = t111 * t112;
  t117 = t24 * t24;
  t122 = t29 * t29;
  t128 = 0.2e1 * t26 * t117 * t5 + 0.2e1 * t31 * t122 * t5 + 0.2e1 * t26 * t24 * t5 + 0.2e1 * t31 * t29 * t5 + 0.2e1 * t21 * t37;
  t129 = t56 * t128;
  tv2rho20 = t44 * t102 + 0.2e1 * t104 * t106 - 0.2e1 * t44 * t113 + t44 * t129 + 0.2e1 * t18 * t74 - 0.2e1 * t67 * t34 - 0.2e1 * t41 * t52 + 0.2e1 * t41 * t65 - t82 * t42 - t44 * t96 - 0.2e1 * t70 * t71;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t131 = t54 * t54;
  t132 = 0.1e1 / t131;
  t134 = t112 * t64;
  t135 = t17 * t132 * t134;
  t150 = t89 * t13;
  t159 = -0.2e1 * t15 * t13 * t37 - t15 * t150 * t37 - 0.3e1 * t15 * t89 * t37 - 0.3e1 * t9 * t78;
  t161 = t159 * t50 * t34;
  t165 = t117 * t24;
  t175 = t122 * t29;
  t185 = -0.6e1 * t26 * t117 * t37 - 0.6e1 * t31 * t122 * t37 - 0.2e1 * t26 * t165 * t37 - 0.2e1 * t31 * t175 * t37 - 0.4e1 * t26 * t24 * t37 - 0.4e1 * t31 * t29 * t37 - 0.6e1 * t21 * t78;
  t186 = t56 * t185;
  t192 = t98 * t49;
  t194 = 0.1e1 / t99 / t16;
  t196 = t192 * t194 * t34;
  t199 = t8 * t98;
  t200 = t100 * t34;
  t203 = t110 * t112;
  t206 = 0.3e1 * t41 * t102 + 0.6e1 * t70 * t106 - 0.6e1 * t41 * t113 + 0.3e1 * t41 * t129 + 0.6e1 * t44 * t135 - t44 * t161 - 0.6e1 * t18 * t203 + t44 * t186 - 0.2e1 * t44 * t196 + 0.3e1 * t199 * t200 - 0.3e1 * t41 * t96 - 0.3e1 * t82 * t52 + 0.3e1 * t82 * t65;
  t209 = t40 * t49;
  t212 = t8 * t94;
  t215 = t55 * t128;
  t220 = 0.1e1 / t77 / rho[0];
  t223 = -0.6e1 * t3 * t220 - 0.3e1 * t78;
  t224 = rho[0] * t223;
  t226 = t41 * t49;
  t229 = t44 * t94;
  t230 = t200 * t49;
  t235 = t44 * t98;
  t236 = t100 * t55;
  t237 = t236 * t64;
  t240 = t105 * t128;
  t243 = t44 * t17;
  t244 = t110 * t64;
  t245 = t244 * t128;
  t248 = t50 * t110;
  t249 = t248 * t112;
  t252 = t81 * t17;
  t255 = 0.3e1 * t104 * t240 - 0.6e1 * t104 * t249 + 0.6e1 * t226 * t106 + 0.3e1 * t229 * t106 + 0.3e1 * t18 * t215 - 0.6e1 * t209 * t71 - 0.3e1 * t212 * t71 - t224 * t42 + 0.3e1 * t229 * t230 - 0.3e1 * t235 * t237 - 0.6e1 * t243 * t245 - 0.3e1 * t252 * t34 + 0.6e1 * t67 * t74;
  tv3rho30 = t206 + t255;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t262 = t112 * t112;
  t268 = t128 * t128;
  t276 = t94 * t94;
  t283 = t98 * t98;
  t284 = t99 * t99;
  t300 = -0.4e1 * t223 * t17 * t34 - 0.24e2 * t44 * t17 / t131 / t33 * t262 - 0.24e2 * t18 * t245 - 0.6e1 * t44 * t111 * t268 - 0.24e2 * t70 * t249 + 0.12e2 * t212 * t230 + 0.3e1 * t44 * t276 * t100 * t34 + 0.12e2 * t212 * t106 + 0.6e1 * t44 * t283 / t284 * t34 - 0.12e2 * t199 * t237 + 0.12e2 * t70 * t240 - 0.4e1 * t224 * t52 - 0.6e1 * t82 * t96 - 0.4e1 * t41 * t161;
  t305 = t89 * t89;
  t323 = t117 * t117;
  t336 = t122 * t122;
  t372 = t194 * t34;
  t378 = 0.4e1 * t41 * t186 - t44 * (0.6e1 * t15 * t13 * t78 + 0.6e1 * t15 * t150 * t78 + t15 * t305 * t78 + 0.11e2 * t15 * t89 * t78 + 0.12e2 * t9 * t220) * t50 * t34 + t44 * t56 * (0.22e2 * t26 * t117 * t78 + 0.22e2 * t31 * t122 * t78 + 0.12e2 * t26 * t165 * t78 + 0.12e2 * t31 * t175 * t78 + 0.12e2 * t26 * t24 * t78 + 0.2e1 * t26 * t323 * t78 + 0.12e2 * t31 * t29 * t78 + 0.2e1 * t31 * t336 * t78 + 0.24e2 * t21 * t220) + 0.6e1 * t82 * t102 - 0.12e2 * t82 * t113 + 0.4e1 * t224 * t65 + 0.6e1 * t82 * t129 - 0.8e1 * t41 * t196 + 0.24e2 * t209 * t106 + 0.24e2 * t41 * t135 + 0.12e2 * t40 * t98 * t200 - 0.24e2 * t67 * t203 - 0.8e1 * t8 * t192 * t372 + 0.24e2 * t18 * t132 * t134;
  t423 = 0.12e2 * t252 * t74 - 0.12e2 * t81 * t49 * t71 - 0.12e2 * t40 * t94 * t71 + 0.12e2 * t67 * t215 - 0.4e1 * t8 * t159 * t71 + 0.4e1 * t18 * t55 * t185 - rho[0] * (0.12e2 * t220 + 0.3e2 * t3 / t77 / t4) * t42 + 0.12e2 * t226 * t200 * t94 - 0.12e2 * t41 * t98 * t237 + 0.12e2 * t82 * t49 * t106 + 0.12e2 * t41 * t94 * t106 + 0.12e2 * t226 * t240 - 0.24e2 * t41 * t17 * t245 - 0.24e2 * t226 * t249;
  t433 = t44 * t159;
  t470 = 0.8e1 * t44 * t192 * t194 * t55 * t64 + 0.12e2 * t235 * t100 * t110 * t112 - 0.24e2 * t104 * t248 * t128 * t64 + 0.24e2 * t104 * t50 * t132 * t134 + 0.36e2 * t243 * t132 * t112 * t128 - 0.12e2 * t229 * t236 * t49 * t64 + 0.4e1 * t104 * t105 * t185 - 0.6e1 * t235 * t236 * t128 - 0.8e1 * t243 * t244 * t185 - 0.12e2 * t229 * t372 * t98 + 0.4e1 * t433 * t106 + 0.6e1 * t229 * t240 - 0.12e2 * t229 * t249 + 0.4e1 * t433 * t230;
  tv4rho40 = t300 + t378 + t423 + t470;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t9, t10;
  double t14, t15, t16, t17, t18, t19, t22, t25;
  double t26, t27, t30, t31, t32, t34, t35, t36;
  double t37, t40, t41, t45, t46, t47, t48, t49;
  double t50, t53, t56, t57, t58, t61, t62, t63;
  double t65, t66, t68, t69, t70, t71, t72, tzk0;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = 0.1e1 / t1;
  t3 = t2 / 0.2e1;
  t4 = params->para[4];
  t5 = t1 * t1;
  t6 = 0.1e1 / t5;
  t9 = t3 + t4 * t6 / 0.4e1;
  t10 = params->para[7];
  t14 = params->para[9];
  t15 = pow(t3, t14);
  t16 = params->para[8] * t15;
  t17 = 0.1e1 + t10 * t2 / 0.2e1 + t16;
  t18 = log(t17);
  t19 = t9 * t18;
  t22 = params->para[1];
  t25 = params->para[5];
  t26 = pow(t3, t25);
  t27 = params->para[2] * t26;
  t30 = params->para[6];
  t31 = pow(t3, t30);
  t32 = params->para[3] * t31;
  t34 = t22 * t2 + 0.2e1 * t27 + 0.2e1 * t32 + 0.2e1 * params->para[0];
  t35 = 0.1e1 / t34;
  t36 = t19 * t35;
  t37 = params->ferro[4];
  t40 = t3 + t37 * t6 / 0.4e1;
  t41 = params->ferro[7];
  t45 = params->ferro[9];
  t46 = pow(t3, t45);
  t47 = params->ferro[8] * t46;
  t48 = 0.1e1 + t41 * t2 / 0.2e1 + t47;
  t49 = log(t48);
  t50 = t40 * t49;
  t53 = params->ferro[1];
  t56 = params->ferro[5];
  t57 = pow(t3, t56);
  t58 = params->ferro[2] * t57;
  t61 = params->ferro[6];
  t62 = pow(t3, t61);
  t63 = params->ferro[3] * t62;
  t65 = t53 * t2 + 0.2e1 * t58 + 0.2e1 * t63 + 0.2e1 * params->ferro[0];
  t66 = 0.1e1 / t65;
  t68 = -t50 * t66 + t36;
  t69 = rho[0] - rho[1];
  t70 = t69 * t69;
  t71 = t68 * t70;
  t72 = t71 * t6;
  tzk0 = -t36 + t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t9, t10;
  double t14, t15, t16, t17, t18, t19, t22, t25;
  double t26, t27, t30, t31, t32, t34, t35, t36;
  double t37, t40, t41, t45, t46, t47, t48, t49;
  double t50, t53, t56, t57, t58, t61, t62, t63;
  double t65, t66, t68, t69, t70, t71, t72, tzk0;

  double t74, t77, t78, t79, t84, t85, t86, t87;
  double t88, t89, t90, t98, t99, t100, t103, t104;
  double t110, t111, t112, t113, t115, t116, t124, t125;
  double t127, t128, t129, t130, t131, t132, t133, t134;
  double tvrho0, tvrho1;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = 0.1e1 / t1;
  t3 = t2 / 0.2e1;
  t4 = params->para[4];
  t5 = t1 * t1;
  t6 = 0.1e1 / t5;
  t9 = t3 + t4 * t6 / 0.4e1;
  t10 = params->para[7];
  t14 = params->para[9];
  t15 = pow(t3, t14);
  t16 = params->para[8] * t15;
  t17 = 0.1e1 + t10 * t2 / 0.2e1 + t16;
  t18 = log(t17);
  t19 = t9 * t18;
  t22 = params->para[1];
  t25 = params->para[5];
  t26 = pow(t3, t25);
  t27 = params->para[2] * t26;
  t30 = params->para[6];
  t31 = pow(t3, t30);
  t32 = params->para[3] * t31;
  t34 = t22 * t2 + 0.2e1 * t27 + 0.2e1 * t32 + 0.2e1 * params->para[0];
  t35 = 0.1e1 / t34;
  t36 = t19 * t35;
  t37 = params->ferro[4];
  t40 = t3 + t37 * t6 / 0.4e1;
  t41 = params->ferro[7];
  t45 = params->ferro[9];
  t46 = pow(t3, t45);
  t47 = params->ferro[8] * t46;
  t48 = 0.1e1 + t41 * t2 / 0.2e1 + t47;
  t49 = log(t48);
  t50 = t40 * t49;
  t53 = params->ferro[1];
  t56 = params->ferro[5];
  t57 = pow(t3, t56);
  t58 = params->ferro[2] * t57;
  t61 = params->ferro[6];
  t62 = pow(t3, t61);
  t63 = params->ferro[3] * t62;
  t65 = t53 * t2 + 0.2e1 * t58 + 0.2e1 * t63 + 0.2e1 * params->ferro[0];
  t66 = 0.1e1 / t65;
  t68 = -t50 * t66 + t36;
  t69 = rho[0] - rho[1];
  t70 = t69 * t69;
  t71 = t68 * t70;
  t72 = t71 * t6;
  tzk0 = -t36 + t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = 0.1e1 / t5 / t1;
  t77 = -t4 * t74 / 0.2e1 - t6 / 0.2e1;
  t78 = t77 * t18;
  t79 = t78 * t35;
  t84 = -t10 * t6 / 0.2e1 - t16 * t14 * t2;
  t85 = t9 * t84;
  t86 = 0.1e1 / t17;
  t87 = t86 * t35;
  t88 = t85 * t87;
  t89 = t34 * t34;
  t90 = 0.1e1 / t89;
  t98 = -0.2e1 * t27 * t25 * t2 - 0.2e1 * t32 * t30 * t2 - t22 * t6;
  t99 = t90 * t98;
  t100 = t19 * t99;
  t103 = -t37 * t74 / 0.2e1 - t6 / 0.2e1;
  t104 = t103 * t49;
  t110 = -t41 * t6 / 0.2e1 - t47 * t45 * t2;
  t111 = t40 * t110;
  t112 = 0.1e1 / t48;
  t113 = t112 * t66;
  t115 = t65 * t65;
  t116 = 0.1e1 / t115;
  t124 = -0.2e1 * t58 * t56 * t2 - 0.2e1 * t63 * t61 * t2 - t53 * t6;
  t125 = t116 * t124;
  t127 = -t104 * t66 - t111 * t113 + t50 * t125 - t100 + t79 + t88;
  t128 = t127 * t70;
  t129 = t128 * t6;
  t130 = t68 * t69;
  t131 = t130 * t6;
  t132 = 0.2e1 * t131;
  t133 = t71 * t74;
  t134 = 0.2e1 * t133;
  tvrho0 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 + t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 - t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t9, t10;
  double t14, t15, t16, t17, t18, t19, t22, t25;
  double t26, t27, t30, t31, t32, t34, t35, t36;
  double t37, t40, t41, t45, t46, t47, t48, t49;
  double t50, t53, t56, t57, t58, t61, t62, t63;
  double t65, t66, t68, t69, t70, t71, t72, tzk0;

  double t74, t77, t78, t79, t84, t85, t86, t87;
  double t88, t89, t90, t98, t99, t100, t103, t104;
  double t110, t111, t112, t113, t115, t116, t124, t125;
  double t127, t128, t129, t130, t131, t132, t133, t134;
  double tvrho0, tvrho1;

  double t139, t140, t141, t142, t143, t144, t145, t146;
  double t149, t150, t151, t152, t153, t154, t155, t156;
  double t158, t163, t164, t165, t166, t167, t168, t169;
  double t170, t171, t172, t173, t174, t175, t177, t178;
  double t179, t180, t181, t183, t188, t194, t195, t196;
  double t199, t200, t202, t208, t213, t214, t216, t217;
  double t218, t219, t220, t222, t223, t227, t228, t229;
  double t233, t238, t244, t245, t247, t248, t249, t250;
  double t251, t252, t253, t254, t255, t256, t257, t258;
  double t259, t260, t261, tv2rho20, t263, tv2rho21, t265, tv2rho22;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = 0.1e1 / t1;
  t3 = t2 / 0.2e1;
  t4 = params->para[4];
  t5 = t1 * t1;
  t6 = 0.1e1 / t5;
  t9 = t3 + t4 * t6 / 0.4e1;
  t10 = params->para[7];
  t14 = params->para[9];
  t15 = pow(t3, t14);
  t16 = params->para[8] * t15;
  t17 = 0.1e1 + t10 * t2 / 0.2e1 + t16;
  t18 = log(t17);
  t19 = t9 * t18;
  t22 = params->para[1];
  t25 = params->para[5];
  t26 = pow(t3, t25);
  t27 = params->para[2] * t26;
  t30 = params->para[6];
  t31 = pow(t3, t30);
  t32 = params->para[3] * t31;
  t34 = t22 * t2 + 0.2e1 * t27 + 0.2e1 * t32 + 0.2e1 * params->para[0];
  t35 = 0.1e1 / t34;
  t36 = t19 * t35;
  t37 = params->ferro[4];
  t40 = t3 + t37 * t6 / 0.4e1;
  t41 = params->ferro[7];
  t45 = params->ferro[9];
  t46 = pow(t3, t45);
  t47 = params->ferro[8] * t46;
  t48 = 0.1e1 + t41 * t2 / 0.2e1 + t47;
  t49 = log(t48);
  t50 = t40 * t49;
  t53 = params->ferro[1];
  t56 = params->ferro[5];
  t57 = pow(t3, t56);
  t58 = params->ferro[2] * t57;
  t61 = params->ferro[6];
  t62 = pow(t3, t61);
  t63 = params->ferro[3] * t62;
  t65 = t53 * t2 + 0.2e1 * t58 + 0.2e1 * t63 + 0.2e1 * params->ferro[0];
  t66 = 0.1e1 / t65;
  t68 = -t50 * t66 + t36;
  t69 = rho[0] - rho[1];
  t70 = t69 * t69;
  t71 = t68 * t70;
  t72 = t71 * t6;
  tzk0 = -t36 + t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = 0.1e1 / t5 / t1;
  t77 = -t4 * t74 / 0.2e1 - t6 / 0.2e1;
  t78 = t77 * t18;
  t79 = t78 * t35;
  t84 = -t10 * t6 / 0.2e1 - t16 * t14 * t2;
  t85 = t9 * t84;
  t86 = 0.1e1 / t17;
  t87 = t86 * t35;
  t88 = t85 * t87;
  t89 = t34 * t34;
  t90 = 0.1e1 / t89;
  t98 = -0.2e1 * t27 * t25 * t2 - 0.2e1 * t32 * t30 * t2 - t22 * t6;
  t99 = t90 * t98;
  t100 = t19 * t99;
  t103 = -t37 * t74 / 0.2e1 - t6 / 0.2e1;
  t104 = t103 * t49;
  t110 = -t41 * t6 / 0.2e1 - t47 * t45 * t2;
  t111 = t40 * t110;
  t112 = 0.1e1 / t48;
  t113 = t112 * t66;
  t115 = t65 * t65;
  t116 = 0.1e1 / t115;
  t124 = -0.2e1 * t58 * t56 * t2 - 0.2e1 * t63 * t61 * t2 - t53 * t6;
  t125 = t116 * t124;
  t127 = -t104 * t66 - t111 * t113 + t50 * t125 - t100 + t79 + t88;
  t128 = t127 * t70;
  t129 = t128 * t6;
  t130 = t68 * t69;
  t131 = t130 * t6;
  t132 = 0.2e1 * t131;
  t133 = t71 * t74;
  t134 = 0.2e1 * t133;
  tvrho0 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 + t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 - t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t139 = 0.2e1 * t79;
  t140 = 0.2e1 * t88;
  t141 = 0.2e1 * t100;
  t142 = 0.2e1 * t129;
  t143 = 0.4e1 * t131;
  t144 = 0.4e1 * t133;
  t145 = t5 * t5;
  t146 = 0.1e1 / t145;
  t149 = t74 + 0.3e1 / 0.2e1 * t4 * t146;
  t150 = t149 * t18;
  t151 = t150 * t35;
  t152 = t77 * t84;
  t153 = t152 * t87;
  t154 = 0.2e1 * t153;
  t155 = t78 * t99;
  t156 = 0.2e1 * t155;
  t158 = t14 * t14;
  t163 = t16 * t14 * t6 + t16 * t158 * t6 + t10 * t74;
  t164 = t9 * t163;
  t165 = t164 * t87;
  t166 = t84 * t84;
  t167 = t9 * t166;
  t168 = t17 * t17;
  t169 = 0.1e1 / t168;
  t170 = t169 * t35;
  t171 = t167 * t170;
  t172 = t86 * t90;
  t173 = t172 * t98;
  t174 = t85 * t173;
  t175 = 0.2e1 * t174;
  t177 = 0.1e1 / t89 / t34;
  t178 = t98 * t98;
  t179 = t177 * t178;
  t180 = t19 * t179;
  t181 = 0.2e1 * t180;
  t183 = t25 * t25;
  t188 = t30 * t30;
  t194 = 0.2e1 * t27 * t183 * t6 + 0.2e1 * t32 * t188 * t6 + 0.2e1 * t27 * t25 * t6 + 0.2e1 * t32 * t30 * t6 + 0.2e1 * t22 * t74;
  t195 = t90 * t194;
  t196 = t19 * t195;
  t199 = t74 + 0.3e1 / 0.2e1 * t37 * t146;
  t200 = t199 * t49;
  t202 = t103 * t110;
  t208 = t45 * t45;
  t213 = t47 * t208 * t6 + t47 * t45 * t6 + t41 * t74;
  t214 = t40 * t213;
  t216 = t110 * t110;
  t217 = t40 * t216;
  t218 = t48 * t48;
  t219 = 0.1e1 / t218;
  t220 = t219 * t66;
  t222 = t112 * t116;
  t223 = t222 * t124;
  t227 = 0.1e1 / t115 / t65;
  t228 = t124 * t124;
  t229 = t227 * t228;
  t233 = t56 * t56;
  t238 = t61 * t61;
  t244 = 0.2e1 * t58 * t233 * t6 + 0.2e1 * t63 * t238 * t6 + 0.2e1 * t58 * t56 * t6 + 0.2e1 * t63 * t61 * t6 + 0.2e1 * t53 * t74;
  t245 = t116 * t244;
  t247 = 0.2e1 * t104 * t125 + 0.2e1 * t111 * t223 - 0.2e1 * t202 * t113 - t214 * t113 - t200 * t66 + t217 * t220 - 0.2e1 * t50 * t229 + t50 * t245 + t151 + t154 - t156 + t165 - t171 - t175 + t181 - t196;
  t248 = t247 * t70;
  t249 = t248 * t6;
  t250 = t127 * t69;
  t251 = t250 * t6;
  t252 = 0.4e1 * t251;
  t253 = t128 * t74;
  t254 = 0.4e1 * t253;
  t255 = t68 * t6;
  t256 = 0.2e1 * t255;
  t257 = t130 * t74;
  t258 = 0.8e1 * t257;
  t259 = t71 * t146;
  t260 = 0.6e1 * t259;
  t261 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 + t252 - t254 + t256 - t258 + t260;
  tv2rho20 = t1 * t261 - t139 - t140 + t141 + t142 + t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t263 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t254 - t256 + t260;
  tv2rho21 = t1 * t263 - t139 - t140 + t141 + t142 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t265 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t252 - t254 + t256 + t258 + t260;
  tv2rho22 = t1 * t265 - t139 - t140 + t141 + t142 - t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t9, t10;
  double t14, t15, t16, t17, t18, t19, t22, t25;
  double t26, t27, t30, t31, t32, t34, t35, t36;
  double t37, t40, t41, t45, t46, t47, t48, t49;
  double t50, t53, t56, t57, t58, t61, t62, t63;
  double t65, t66, t68, t69, t70, t71, t72, tzk0;

  double t74, t77, t78, t79, t84, t85, t86, t87;
  double t88, t89, t90, t98, t99, t100, t103, t104;
  double t110, t111, t112, t113, t115, t116, t124, t125;
  double t127, t128, t129, t130, t131, t132, t133, t134;
  double tvrho0, tvrho1;

  double t139, t140, t141, t142, t143, t144, t145, t146;
  double t149, t150, t151, t152, t153, t154, t155, t156;
  double t158, t163, t164, t165, t166, t167, t168, t169;
  double t170, t171, t172, t173, t174, t175, t177, t178;
  double t179, t180, t181, t183, t188, t194, t195, t196;
  double t199, t200, t202, t208, t213, t214, t216, t217;
  double t218, t219, t220, t222, t223, t227, t228, t229;
  double t233, t238, t244, t245, t247, t248, t249, t250;
  double t251, t252, t253, t254, t255, t256, t257, t258;
  double t259, t260, t261, tv2rho20, t263, tv2rho21, t265, tv2rho22;

  double t267, t268, t269, t270, t271, t272, t273, t274;
  double t275, t276, t277, t278, t279, t280, t281, t283;
  double t285, t286, t287, t288, t290, t291, t292, t293;
  double t294, t295, t296, t297, t298, t299, t300, t301;
  double t302, t303, t304, t305, t306, t307, t308, t309;
  double t310, t311, t312, t313, t314, t315, t316, t317;
  double t320, t329, t330, t331, t334, t344, t354, t355;
  double t356, t357, t358, t359, t360, t361, t362, t363;
  double t364, t365, t366, t367, t369, t370, t371, t372;
  double t375, t376, t377, t378, t379, t382, t385, t386;
  double t391, t397, t400, t401, t406, t407, t409, t410;
  double t413, t414, t415, t416, t421, t424, t431, t440;
  double t441, t445, t455, t465, t466, t470, t471, t473;
  double t474, t475, t476, t477, t478, t479, t481, t482;
  double t483, t484, t485, t486, t487, t488, t489, t490;
  double t491, t492, t493, t494, t495, tv3rho30, t500, t501;
  double t502, t503, t504, tv3rho31, t507, tv3rho32, t510, tv3rho33;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = 0.1e1 / t1;
  t3 = t2 / 0.2e1;
  t4 = params->para[4];
  t5 = t1 * t1;
  t6 = 0.1e1 / t5;
  t9 = t3 + t4 * t6 / 0.4e1;
  t10 = params->para[7];
  t14 = params->para[9];
  t15 = pow(t3, t14);
  t16 = params->para[8] * t15;
  t17 = 0.1e1 + t10 * t2 / 0.2e1 + t16;
  t18 = log(t17);
  t19 = t9 * t18;
  t22 = params->para[1];
  t25 = params->para[5];
  t26 = pow(t3, t25);
  t27 = params->para[2] * t26;
  t30 = params->para[6];
  t31 = pow(t3, t30);
  t32 = params->para[3] * t31;
  t34 = t22 * t2 + 0.2e1 * t27 + 0.2e1 * t32 + 0.2e1 * params->para[0];
  t35 = 0.1e1 / t34;
  t36 = t19 * t35;
  t37 = params->ferro[4];
  t40 = t3 + t37 * t6 / 0.4e1;
  t41 = params->ferro[7];
  t45 = params->ferro[9];
  t46 = pow(t3, t45);
  t47 = params->ferro[8] * t46;
  t48 = 0.1e1 + t41 * t2 / 0.2e1 + t47;
  t49 = log(t48);
  t50 = t40 * t49;
  t53 = params->ferro[1];
  t56 = params->ferro[5];
  t57 = pow(t3, t56);
  t58 = params->ferro[2] * t57;
  t61 = params->ferro[6];
  t62 = pow(t3, t61);
  t63 = params->ferro[3] * t62;
  t65 = t53 * t2 + 0.2e1 * t58 + 0.2e1 * t63 + 0.2e1 * params->ferro[0];
  t66 = 0.1e1 / t65;
  t68 = -t50 * t66 + t36;
  t69 = rho[0] - rho[1];
  t70 = t69 * t69;
  t71 = t68 * t70;
  t72 = t71 * t6;
  tzk0 = -t36 + t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = 0.1e1 / t5 / t1;
  t77 = -t4 * t74 / 0.2e1 - t6 / 0.2e1;
  t78 = t77 * t18;
  t79 = t78 * t35;
  t84 = -t10 * t6 / 0.2e1 - t16 * t14 * t2;
  t85 = t9 * t84;
  t86 = 0.1e1 / t17;
  t87 = t86 * t35;
  t88 = t85 * t87;
  t89 = t34 * t34;
  t90 = 0.1e1 / t89;
  t98 = -0.2e1 * t27 * t25 * t2 - 0.2e1 * t32 * t30 * t2 - t22 * t6;
  t99 = t90 * t98;
  t100 = t19 * t99;
  t103 = -t37 * t74 / 0.2e1 - t6 / 0.2e1;
  t104 = t103 * t49;
  t110 = -t41 * t6 / 0.2e1 - t47 * t45 * t2;
  t111 = t40 * t110;
  t112 = 0.1e1 / t48;
  t113 = t112 * t66;
  t115 = t65 * t65;
  t116 = 0.1e1 / t115;
  t124 = -0.2e1 * t58 * t56 * t2 - 0.2e1 * t63 * t61 * t2 - t53 * t6;
  t125 = t116 * t124;
  t127 = -t104 * t66 - t111 * t113 + t50 * t125 - t100 + t79 + t88;
  t128 = t127 * t70;
  t129 = t128 * t6;
  t130 = t68 * t69;
  t131 = t130 * t6;
  t132 = 0.2e1 * t131;
  t133 = t71 * t74;
  t134 = 0.2e1 * t133;
  tvrho0 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 + t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 - t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t139 = 0.2e1 * t79;
  t140 = 0.2e1 * t88;
  t141 = 0.2e1 * t100;
  t142 = 0.2e1 * t129;
  t143 = 0.4e1 * t131;
  t144 = 0.4e1 * t133;
  t145 = t5 * t5;
  t146 = 0.1e1 / t145;
  t149 = t74 + 0.3e1 / 0.2e1 * t4 * t146;
  t150 = t149 * t18;
  t151 = t150 * t35;
  t152 = t77 * t84;
  t153 = t152 * t87;
  t154 = 0.2e1 * t153;
  t155 = t78 * t99;
  t156 = 0.2e1 * t155;
  t158 = t14 * t14;
  t163 = t16 * t14 * t6 + t16 * t158 * t6 + t10 * t74;
  t164 = t9 * t163;
  t165 = t164 * t87;
  t166 = t84 * t84;
  t167 = t9 * t166;
  t168 = t17 * t17;
  t169 = 0.1e1 / t168;
  t170 = t169 * t35;
  t171 = t167 * t170;
  t172 = t86 * t90;
  t173 = t172 * t98;
  t174 = t85 * t173;
  t175 = 0.2e1 * t174;
  t177 = 0.1e1 / t89 / t34;
  t178 = t98 * t98;
  t179 = t177 * t178;
  t180 = t19 * t179;
  t181 = 0.2e1 * t180;
  t183 = t25 * t25;
  t188 = t30 * t30;
  t194 = 0.2e1 * t27 * t183 * t6 + 0.2e1 * t32 * t188 * t6 + 0.2e1 * t27 * t25 * t6 + 0.2e1 * t32 * t30 * t6 + 0.2e1 * t22 * t74;
  t195 = t90 * t194;
  t196 = t19 * t195;
  t199 = t74 + 0.3e1 / 0.2e1 * t37 * t146;
  t200 = t199 * t49;
  t202 = t103 * t110;
  t208 = t45 * t45;
  t213 = t47 * t208 * t6 + t47 * t45 * t6 + t41 * t74;
  t214 = t40 * t213;
  t216 = t110 * t110;
  t217 = t40 * t216;
  t218 = t48 * t48;
  t219 = 0.1e1 / t218;
  t220 = t219 * t66;
  t222 = t112 * t116;
  t223 = t222 * t124;
  t227 = 0.1e1 / t115 / t65;
  t228 = t124 * t124;
  t229 = t227 * t228;
  t233 = t56 * t56;
  t238 = t61 * t61;
  t244 = 0.2e1 * t58 * t233 * t6 + 0.2e1 * t63 * t238 * t6 + 0.2e1 * t58 * t56 * t6 + 0.2e1 * t63 * t61 * t6 + 0.2e1 * t53 * t74;
  t245 = t116 * t244;
  t247 = 0.2e1 * t104 * t125 + 0.2e1 * t111 * t223 - 0.2e1 * t202 * t113 - t214 * t113 - t200 * t66 + t217 * t220 - 0.2e1 * t50 * t229 + t50 * t245 + t151 + t154 - t156 + t165 - t171 - t175 + t181 - t196;
  t248 = t247 * t70;
  t249 = t248 * t6;
  t250 = t127 * t69;
  t251 = t250 * t6;
  t252 = 0.4e1 * t251;
  t253 = t128 * t74;
  t254 = 0.4e1 * t253;
  t255 = t68 * t6;
  t256 = 0.2e1 * t255;
  t257 = t130 * t74;
  t258 = 0.8e1 * t257;
  t259 = t71 * t146;
  t260 = 0.6e1 * t259;
  t261 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 + t252 - t254 + t256 - t258 + t260;
  tv2rho20 = t1 * t261 - t139 - t140 + t141 + t142 + t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t263 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t254 - t256 + t260;
  tv2rho21 = t1 * t263 - t139 - t140 + t141 + t142 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t265 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t252 - t254 + t256 + t258 + t260;
  tv2rho22 = t1 * t265 - t139 - t140 + t141 + t142 - t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t267 = 0.3e1 * t171;
  t268 = 0.6e1 * t174;
  t269 = 0.6e1 * t180;
  t270 = 0.6e1 * t155;
  t271 = 0.6e1 * t153;
  t272 = 0.3e1 * t165;
  t273 = 0.3e1 * t196;
  t274 = 0.12e2 * t251;
  t275 = 0.12e2 * t253;
  t276 = 0.24e2 * t257;
  t277 = 0.18e2 * t259;
  t278 = 0.3e1 * t151;
  t279 = 0.3e1 * t249;
  t280 = 0.6e1 * t255;
  t281 = t127 * t6;
  t283 = t68 * t74;
  t285 = t177 * t98;
  t286 = t285 * t194;
  t287 = t19 * t286;
  t288 = 0.6e1 * t287;
  t290 = t86 * t177 * t178;
  t291 = t85 * t290;
  t292 = 0.6e1 * t291;
  t293 = t152 * t173;
  t294 = 0.6e1 * t293;
  t295 = t170 * t84;
  t296 = t164 * t295;
  t297 = 0.3e1 * t296;
  t298 = t164 * t173;
  t299 = 0.3e1 * t298;
  t300 = t169 * t90;
  t301 = t300 * t98;
  t302 = t167 * t301;
  t303 = 0.3e1 * t302;
  t304 = t172 * t194;
  t305 = t85 * t304;
  t306 = 0.3e1 * t305;
  t307 = t150 * t99;
  t308 = 0.3e1 * t307;
  t309 = t149 * t84;
  t310 = t309 * t87;
  t311 = 0.3e1 * t310;
  t312 = t77 * t163;
  t313 = t312 * t87;
  t314 = 0.3e1 * t313;
  t315 = t78 * t195;
  t316 = 0.3e1 * t315;
  t317 = 0.6e1 * t281 - 0.12e2 * t283 - t288 - t292 + t294 + t297 + t299 - t303 + t306 + t308 - t311 - t314 + t316;
  t320 = t158 * t14;
  t329 = -0.2e1 * t16 * t14 * t74 - 0.3e1 * t16 * t158 * t74 - t16 * t320 * t74 - 0.3e1 * t10 * t146;
  t330 = t9 * t329;
  t331 = t330 * t87;
  t334 = t183 * t25;
  t344 = t188 * t30;
  t354 = -0.6e1 * t27 * t183 * t74 - 0.6e1 * t32 * t188 * t74 - 0.4e1 * t27 * t25 * t74 - 0.2e1 * t27 * t334 * t74 - 0.4e1 * t32 * t30 * t74 - 0.2e1 * t32 * t344 * t74 - 0.6e1 * t22 * t146;
  t355 = t90 * t354;
  t356 = t19 * t355;
  t357 = t247 * t69;
  t358 = t357 * t6;
  t359 = 0.6e1 * t358;
  t360 = t248 * t74;
  t361 = 0.6e1 * t360;
  t362 = t250 * t74;
  t363 = 0.24e2 * t362;
  t364 = t128 * t146;
  t365 = 0.18e2 * t364;
  t366 = t130 * t146;
  t367 = 0.36e2 * t366;
  t369 = 0.1e1 / t145 / t1;
  t370 = t71 * t369;
  t371 = 0.24e2 * t370;
  t372 = 0.3e1 * t146;
  t375 = -0.6e1 * t4 * t369 - t372;
  t376 = t375 * t18;
  t377 = t376 * t35;
  t378 = t219 * t116;
  t379 = t378 * t124;
  t382 = t222 * t244;
  t385 = t227 * t124;
  t386 = t385 * t244;
  t391 = t220 * t110;
  t397 = t112 * t227 * t228;
  t400 = 0.3e1 * t111 * t382 - 0.6e1 * t111 * t397 + 0.6e1 * t202 * t223 + 0.3e1 * t214 * t223 + 0.3e1 * t214 * t391 - 0.3e1 * t217 * t379 - 0.6e1 * t50 * t386 + t288 + t292 - t294 - t297 - t299 + t303 - t306 - t308 + t311 + t314 - t316;
  t401 = t103 * t216;
  t406 = t216 * t110;
  t407 = t40 * t406;
  t409 = 0.1e1 / t218 / t48;
  t410 = t409 * t66;
  t413 = t115 * t115;
  t414 = 0.1e1 / t413;
  t415 = t228 * t124;
  t416 = t414 * t415;
  t421 = t199 * t110;
  t424 = t103 * t213;
  t431 = t208 * t45;
  t440 = -0.3e1 * t47 * t208 * t74 - t47 * t431 * t74 - 0.2e1 * t47 * t45 * t74 - 0.3e1 * t41 * t146;
  t441 = t40 * t440;
  t445 = t233 * t56;
  t455 = t238 * t61;
  t465 = -0.6e1 * t58 * t233 * t74 - 0.6e1 * t63 * t238 * t74 - 0.2e1 * t58 * t445 * t74 - 0.2e1 * t63 * t455 * t74 - 0.4e1 * t58 * t56 * t74 - 0.4e1 * t63 * t61 * t74 - 0.6e1 * t53 * t146;
  t466 = t116 * t465;
  t470 = -0.6e1 * t37 * t369 - t372;
  t471 = t470 * t49;
  t473 = t77 * t166;
  t474 = t473 * t170;
  t475 = 0.3e1 * t474;
  t476 = t78 * t179;
  t477 = 0.6e1 * t476;
  t478 = t166 * t84;
  t479 = t9 * t478;
  t481 = 0.1e1 / t168 / t17;
  t482 = t481 * t35;
  t483 = t479 * t482;
  t484 = 0.2e1 * t483;
  t485 = t89 * t89;
  t486 = 0.1e1 / t485;
  t487 = t178 * t98;
  t488 = t486 * t487;
  t489 = t19 * t488;
  t490 = 0.6e1 * t489;
  t491 = -0.6e1 * t104 * t229 + 0.3e1 * t104 * t245 - 0.3e1 * t421 * t113 - 0.3e1 * t424 * t113 - t441 * t113 + 0.3e1 * t200 * t125 + 0.3e1 * t401 * t220 - 0.2e1 * t407 * t410 + 0.6e1 * t50 * t416 + t50 * t466 - t471 * t66 + t331 - t356 + t377 - t475 + t477 + t484 - t490;
  t492 = t400 + t491;
  t493 = t492 * t70;
  t494 = t493 * t6;
  t495 = -t331 + t356 + t359 - t361 - t363 + t365 + t367 - t371 - t377 + t494 + t475 - t477 - t484 + t490;
  tv3rho30 = t267 + t268 - t269 + t270 - t271 - t272 + t273 + t274 - t275 - t276 + t277 - t278 + t279 + t280 + t1 * (t317 + t495);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t500 = -0.2e1 * t281 + 0.4e1 * t283 - t288 - t292 + t294 + t297 + t299 - t303 + t306 + t308 - t311 - t314 + t316;
  t501 = 0.2e1 * t358;
  t502 = 0.8e1 * t362;
  t503 = 0.12e2 * t366;
  t504 = -t331 + t356 + t501 - t361 - t502 + t365 + t503 - t371 - t377 + t494 + t475 - t477 - t484 + t490;
  tv3rho31 = t267 + t268 - t269 + t270 - t271 - t272 + t273 + t252 - t275 - t258 + t277 - t278 + t279 - t256 + t1 * (t500 + t504);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t507 = -t331 + t356 - t501 - t361 + t502 + t365 - t503 - t371 - t377 + t494 + t475 - t477 - t484 + t490;
  tv3rho32 = t267 + t268 - t269 + t270 - t271 - t272 + t273 - t252 - t275 + t258 + t277 - t278 + t279 - t256 + t1 * (t500 + t507);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t510 = -t331 + t356 - t359 - t361 + t363 + t365 - t367 - t371 - t377 + t494 + t475 - t477 - t484 + t490;
  tv3rho33 = t267 + t268 - t269 + t270 - t271 - t272 + t273 - t274 - t275 + t276 + t277 - t278 + t279 + t280 + t1 * (t317 + t510);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t9, t10;
  double t14, t15, t16, t17, t18, t19, t22, t25;
  double t26, t27, t30, t31, t32, t34, t35, t36;
  double t37, t40, t41, t45, t46, t47, t48, t49;
  double t50, t53, t56, t57, t58, t61, t62, t63;
  double t65, t66, t68, t69, t70, t71, t72, tzk0;

  double t74, t77, t78, t79, t84, t85, t86, t87;
  double t88, t89, t90, t98, t99, t100, t103, t104;
  double t110, t111, t112, t113, t115, t116, t124, t125;
  double t127, t128, t129, t130, t131, t132, t133, t134;
  double tvrho0, tvrho1;

  double t139, t140, t141, t142, t143, t144, t145, t146;
  double t149, t150, t151, t152, t153, t154, t155, t156;
  double t158, t163, t164, t165, t166, t167, t168, t169;
  double t170, t171, t172, t173, t174, t175, t177, t178;
  double t179, t180, t181, t183, t188, t194, t195, t196;
  double t199, t200, t202, t208, t213, t214, t216, t217;
  double t218, t219, t220, t222, t223, t227, t228, t229;
  double t233, t238, t244, t245, t247, t248, t249, t250;
  double t251, t252, t253, t254, t255, t256, t257, t258;
  double t259, t260, t261, tv2rho20, t263, tv2rho21, t265, tv2rho22;

  double t267, t268, t269, t270, t271, t272, t273, t274;
  double t275, t276, t277, t278, t279, t280, t281, t283;
  double t285, t286, t287, t288, t290, t291, t292, t293;
  double t294, t295, t296, t297, t298, t299, t300, t301;
  double t302, t303, t304, t305, t306, t307, t308, t309;
  double t310, t311, t312, t313, t314, t315, t316, t317;
  double t320, t329, t330, t331, t334, t344, t354, t355;
  double t356, t357, t358, t359, t360, t361, t362, t363;
  double t364, t365, t366, t367, t369, t370, t371, t372;
  double t375, t376, t377, t378, t379, t382, t385, t386;
  double t391, t397, t400, t401, t406, t407, t409, t410;
  double t413, t414, t415, t416, t421, t424, t431, t440;
  double t441, t445, t455, t465, t466, t470, t471, t473;
  double t474, t475, t476, t477, t478, t479, t481, t482;
  double t483, t484, t485, t486, t487, t488, t489, t490;
  double t491, t492, t493, t494, t495, tv3rho30, t500, t501;
  double t502, t503, t504, tv3rho31, t507, tv3rho32, t510, tv3rho33;

  double t513, t514, t515, t516, t517, t518, t519, t521;
  double t526, t550, t553, t556, t560, t563, t565, t567;
  double t569, t571, t573, t574, t576, t578, t582, t586;
  double t589, t591, t593, t596, t598, t600, t603, t617;
  double t620, t633, t648, t651, t654, t655, t658, t661;
  double t663, t665, t667, t670, t671, t675, t678, t680;
  double t681, t684, t685, t687, t691, t694, t722, t727;
  double t738, t770, t787, t800, t816, t820, t824, t826;
  double t833, t842, t846, t848, t850, t851, t852, t853;
  double t855, t856, t857, t859, t861, t862, t863, t865;
  double t866, t867, t868, t872, t873, t874, t875, t876;
  double t877, t878, t879, t880, t881, t882, t883, t884;
  double t885, t886, t887, t888, t889, t890, t891, t892;
  double t893, t894, t895, t896, t897, t898, t899, t900;
  double tv4rho40, t901, t902, t903, t904, t905, t907, t908;
  double t909, t913, t914, t915, t916, t917, tv4rho41, t923;
  double t925, t926, t930, t931, tv4rho42, t932, t934, t938;
  double t939, tv4rho43, t940, t942, t946, t947, tv4rho44;

  lda_c_1d_csc_params *params;

  assert(p->params != NULL);
  params = (lda_c_1d_csc_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = 0.1e1 / t1;
  t3 = t2 / 0.2e1;
  t4 = params->para[4];
  t5 = t1 * t1;
  t6 = 0.1e1 / t5;
  t9 = t3 + t4 * t6 / 0.4e1;
  t10 = params->para[7];
  t14 = params->para[9];
  t15 = pow(t3, t14);
  t16 = params->para[8] * t15;
  t17 = 0.1e1 + t10 * t2 / 0.2e1 + t16;
  t18 = log(t17);
  t19 = t9 * t18;
  t22 = params->para[1];
  t25 = params->para[5];
  t26 = pow(t3, t25);
  t27 = params->para[2] * t26;
  t30 = params->para[6];
  t31 = pow(t3, t30);
  t32 = params->para[3] * t31;
  t34 = t22 * t2 + 0.2e1 * t27 + 0.2e1 * t32 + 0.2e1 * params->para[0];
  t35 = 0.1e1 / t34;
  t36 = t19 * t35;
  t37 = params->ferro[4];
  t40 = t3 + t37 * t6 / 0.4e1;
  t41 = params->ferro[7];
  t45 = params->ferro[9];
  t46 = pow(t3, t45);
  t47 = params->ferro[8] * t46;
  t48 = 0.1e1 + t41 * t2 / 0.2e1 + t47;
  t49 = log(t48);
  t50 = t40 * t49;
  t53 = params->ferro[1];
  t56 = params->ferro[5];
  t57 = pow(t3, t56);
  t58 = params->ferro[2] * t57;
  t61 = params->ferro[6];
  t62 = pow(t3, t61);
  t63 = params->ferro[3] * t62;
  t65 = t53 * t2 + 0.2e1 * t58 + 0.2e1 * t63 + 0.2e1 * params->ferro[0];
  t66 = 0.1e1 / t65;
  t68 = -t50 * t66 + t36;
  t69 = rho[0] - rho[1];
  t70 = t69 * t69;
  t71 = t68 * t70;
  t72 = t71 * t6;
  tzk0 = -t36 + t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = 0.1e1 / t5 / t1;
  t77 = -t4 * t74 / 0.2e1 - t6 / 0.2e1;
  t78 = t77 * t18;
  t79 = t78 * t35;
  t84 = -t10 * t6 / 0.2e1 - t16 * t14 * t2;
  t85 = t9 * t84;
  t86 = 0.1e1 / t17;
  t87 = t86 * t35;
  t88 = t85 * t87;
  t89 = t34 * t34;
  t90 = 0.1e1 / t89;
  t98 = -0.2e1 * t27 * t25 * t2 - 0.2e1 * t32 * t30 * t2 - t22 * t6;
  t99 = t90 * t98;
  t100 = t19 * t99;
  t103 = -t37 * t74 / 0.2e1 - t6 / 0.2e1;
  t104 = t103 * t49;
  t110 = -t41 * t6 / 0.2e1 - t47 * t45 * t2;
  t111 = t40 * t110;
  t112 = 0.1e1 / t48;
  t113 = t112 * t66;
  t115 = t65 * t65;
  t116 = 0.1e1 / t115;
  t124 = -0.2e1 * t58 * t56 * t2 - 0.2e1 * t63 * t61 * t2 - t53 * t6;
  t125 = t116 * t124;
  t127 = -t104 * t66 - t111 * t113 + t50 * t125 - t100 + t79 + t88;
  t128 = t127 * t70;
  t129 = t128 * t6;
  t130 = t68 * t69;
  t131 = t130 * t6;
  t132 = 0.2e1 * t131;
  t133 = t71 * t74;
  t134 = 0.2e1 * t133;
  tvrho0 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 + t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = -t36 + t72 + t1 * (-t79 - t88 + t100 + t129 - t132 - t134);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t139 = 0.2e1 * t79;
  t140 = 0.2e1 * t88;
  t141 = 0.2e1 * t100;
  t142 = 0.2e1 * t129;
  t143 = 0.4e1 * t131;
  t144 = 0.4e1 * t133;
  t145 = t5 * t5;
  t146 = 0.1e1 / t145;
  t149 = t74 + 0.3e1 / 0.2e1 * t4 * t146;
  t150 = t149 * t18;
  t151 = t150 * t35;
  t152 = t77 * t84;
  t153 = t152 * t87;
  t154 = 0.2e1 * t153;
  t155 = t78 * t99;
  t156 = 0.2e1 * t155;
  t158 = t14 * t14;
  t163 = t16 * t14 * t6 + t16 * t158 * t6 + t10 * t74;
  t164 = t9 * t163;
  t165 = t164 * t87;
  t166 = t84 * t84;
  t167 = t9 * t166;
  t168 = t17 * t17;
  t169 = 0.1e1 / t168;
  t170 = t169 * t35;
  t171 = t167 * t170;
  t172 = t86 * t90;
  t173 = t172 * t98;
  t174 = t85 * t173;
  t175 = 0.2e1 * t174;
  t177 = 0.1e1 / t89 / t34;
  t178 = t98 * t98;
  t179 = t177 * t178;
  t180 = t19 * t179;
  t181 = 0.2e1 * t180;
  t183 = t25 * t25;
  t188 = t30 * t30;
  t194 = 0.2e1 * t27 * t183 * t6 + 0.2e1 * t32 * t188 * t6 + 0.2e1 * t27 * t25 * t6 + 0.2e1 * t32 * t30 * t6 + 0.2e1 * t22 * t74;
  t195 = t90 * t194;
  t196 = t19 * t195;
  t199 = t74 + 0.3e1 / 0.2e1 * t37 * t146;
  t200 = t199 * t49;
  t202 = t103 * t110;
  t208 = t45 * t45;
  t213 = t47 * t208 * t6 + t47 * t45 * t6 + t41 * t74;
  t214 = t40 * t213;
  t216 = t110 * t110;
  t217 = t40 * t216;
  t218 = t48 * t48;
  t219 = 0.1e1 / t218;
  t220 = t219 * t66;
  t222 = t112 * t116;
  t223 = t222 * t124;
  t227 = 0.1e1 / t115 / t65;
  t228 = t124 * t124;
  t229 = t227 * t228;
  t233 = t56 * t56;
  t238 = t61 * t61;
  t244 = 0.2e1 * t58 * t233 * t6 + 0.2e1 * t63 * t238 * t6 + 0.2e1 * t58 * t56 * t6 + 0.2e1 * t63 * t61 * t6 + 0.2e1 * t53 * t74;
  t245 = t116 * t244;
  t247 = 0.2e1 * t104 * t125 + 0.2e1 * t111 * t223 - 0.2e1 * t202 * t113 - t214 * t113 - t200 * t66 + t217 * t220 - 0.2e1 * t50 * t229 + t50 * t245 + t151 + t154 - t156 + t165 - t171 - t175 + t181 - t196;
  t248 = t247 * t70;
  t249 = t248 * t6;
  t250 = t127 * t69;
  t251 = t250 * t6;
  t252 = 0.4e1 * t251;
  t253 = t128 * t74;
  t254 = 0.4e1 * t253;
  t255 = t68 * t6;
  t256 = 0.2e1 * t255;
  t257 = t130 * t74;
  t258 = 0.8e1 * t257;
  t259 = t71 * t146;
  t260 = 0.6e1 * t259;
  t261 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 + t252 - t254 + t256 - t258 + t260;
  tv2rho20 = t1 * t261 - t139 - t140 + t141 + t142 + t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t263 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t254 - t256 + t260;
  tv2rho21 = t1 * t263 - t139 - t140 + t141 + t142 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t265 = -t151 - t154 + t156 - t165 + t171 + t175 - t181 + t196 + t249 - t252 - t254 + t256 + t258 + t260;
  tv2rho22 = t1 * t265 - t139 - t140 + t141 + t142 - t143 - t144;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t267 = 0.3e1 * t171;
  t268 = 0.6e1 * t174;
  t269 = 0.6e1 * t180;
  t270 = 0.6e1 * t155;
  t271 = 0.6e1 * t153;
  t272 = 0.3e1 * t165;
  t273 = 0.3e1 * t196;
  t274 = 0.12e2 * t251;
  t275 = 0.12e2 * t253;
  t276 = 0.24e2 * t257;
  t277 = 0.18e2 * t259;
  t278 = 0.3e1 * t151;
  t279 = 0.3e1 * t249;
  t280 = 0.6e1 * t255;
  t281 = t127 * t6;
  t283 = t68 * t74;
  t285 = t177 * t98;
  t286 = t285 * t194;
  t287 = t19 * t286;
  t288 = 0.6e1 * t287;
  t290 = t86 * t177 * t178;
  t291 = t85 * t290;
  t292 = 0.6e1 * t291;
  t293 = t152 * t173;
  t294 = 0.6e1 * t293;
  t295 = t170 * t84;
  t296 = t164 * t295;
  t297 = 0.3e1 * t296;
  t298 = t164 * t173;
  t299 = 0.3e1 * t298;
  t300 = t169 * t90;
  t301 = t300 * t98;
  t302 = t167 * t301;
  t303 = 0.3e1 * t302;
  t304 = t172 * t194;
  t305 = t85 * t304;
  t306 = 0.3e1 * t305;
  t307 = t150 * t99;
  t308 = 0.3e1 * t307;
  t309 = t149 * t84;
  t310 = t309 * t87;
  t311 = 0.3e1 * t310;
  t312 = t77 * t163;
  t313 = t312 * t87;
  t314 = 0.3e1 * t313;
  t315 = t78 * t195;
  t316 = 0.3e1 * t315;
  t317 = 0.6e1 * t281 - 0.12e2 * t283 - t288 - t292 + t294 + t297 + t299 - t303 + t306 + t308 - t311 - t314 + t316;
  t320 = t158 * t14;
  t329 = -0.2e1 * t16 * t14 * t74 - 0.3e1 * t16 * t158 * t74 - t16 * t320 * t74 - 0.3e1 * t10 * t146;
  t330 = t9 * t329;
  t331 = t330 * t87;
  t334 = t183 * t25;
  t344 = t188 * t30;
  t354 = -0.6e1 * t27 * t183 * t74 - 0.6e1 * t32 * t188 * t74 - 0.4e1 * t27 * t25 * t74 - 0.2e1 * t27 * t334 * t74 - 0.4e1 * t32 * t30 * t74 - 0.2e1 * t32 * t344 * t74 - 0.6e1 * t22 * t146;
  t355 = t90 * t354;
  t356 = t19 * t355;
  t357 = t247 * t69;
  t358 = t357 * t6;
  t359 = 0.6e1 * t358;
  t360 = t248 * t74;
  t361 = 0.6e1 * t360;
  t362 = t250 * t74;
  t363 = 0.24e2 * t362;
  t364 = t128 * t146;
  t365 = 0.18e2 * t364;
  t366 = t130 * t146;
  t367 = 0.36e2 * t366;
  t369 = 0.1e1 / t145 / t1;
  t370 = t71 * t369;
  t371 = 0.24e2 * t370;
  t372 = 0.3e1 * t146;
  t375 = -0.6e1 * t4 * t369 - t372;
  t376 = t375 * t18;
  t377 = t376 * t35;
  t378 = t219 * t116;
  t379 = t378 * t124;
  t382 = t222 * t244;
  t385 = t227 * t124;
  t386 = t385 * t244;
  t391 = t220 * t110;
  t397 = t112 * t227 * t228;
  t400 = 0.3e1 * t111 * t382 - 0.6e1 * t111 * t397 + 0.6e1 * t202 * t223 + 0.3e1 * t214 * t223 + 0.3e1 * t214 * t391 - 0.3e1 * t217 * t379 - 0.6e1 * t50 * t386 + t288 + t292 - t294 - t297 - t299 + t303 - t306 - t308 + t311 + t314 - t316;
  t401 = t103 * t216;
  t406 = t216 * t110;
  t407 = t40 * t406;
  t409 = 0.1e1 / t218 / t48;
  t410 = t409 * t66;
  t413 = t115 * t115;
  t414 = 0.1e1 / t413;
  t415 = t228 * t124;
  t416 = t414 * t415;
  t421 = t199 * t110;
  t424 = t103 * t213;
  t431 = t208 * t45;
  t440 = -0.3e1 * t47 * t208 * t74 - t47 * t431 * t74 - 0.2e1 * t47 * t45 * t74 - 0.3e1 * t41 * t146;
  t441 = t40 * t440;
  t445 = t233 * t56;
  t455 = t238 * t61;
  t465 = -0.6e1 * t58 * t233 * t74 - 0.6e1 * t63 * t238 * t74 - 0.2e1 * t58 * t445 * t74 - 0.2e1 * t63 * t455 * t74 - 0.4e1 * t58 * t56 * t74 - 0.4e1 * t63 * t61 * t74 - 0.6e1 * t53 * t146;
  t466 = t116 * t465;
  t470 = -0.6e1 * t37 * t369 - t372;
  t471 = t470 * t49;
  t473 = t77 * t166;
  t474 = t473 * t170;
  t475 = 0.3e1 * t474;
  t476 = t78 * t179;
  t477 = 0.6e1 * t476;
  t478 = t166 * t84;
  t479 = t9 * t478;
  t481 = 0.1e1 / t168 / t17;
  t482 = t481 * t35;
  t483 = t479 * t482;
  t484 = 0.2e1 * t483;
  t485 = t89 * t89;
  t486 = 0.1e1 / t485;
  t487 = t178 * t98;
  t488 = t486 * t487;
  t489 = t19 * t488;
  t490 = 0.6e1 * t489;
  t491 = -0.6e1 * t104 * t229 + 0.3e1 * t104 * t245 - 0.3e1 * t421 * t113 - 0.3e1 * t424 * t113 - t441 * t113 + 0.3e1 * t200 * t125 + 0.3e1 * t401 * t220 - 0.2e1 * t407 * t410 + 0.6e1 * t50 * t416 + t50 * t466 - t471 * t66 + t331 - t356 + t377 - t475 + t477 + t484 - t490;
  t492 = t400 + t491;
  t493 = t492 * t70;
  t494 = t493 * t6;
  t495 = -t331 + t356 + t359 - t361 - t363 + t365 + t367 - t371 - t377 + t494 + t475 - t477 - t484 + t490;
  tv3rho30 = t267 + t268 - t269 + t270 - t271 - t272 + t273 + t274 - t275 - t276 + t277 - t278 + t279 + t280 + t1 * (t317 + t495);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t500 = -0.2e1 * t281 + 0.4e1 * t283 - t288 - t292 + t294 + t297 + t299 - t303 + t306 + t308 - t311 - t314 + t316;
  t501 = 0.2e1 * t358;
  t502 = 0.8e1 * t362;
  t503 = 0.12e2 * t366;
  t504 = -t331 + t356 + t501 - t361 - t502 + t365 + t503 - t371 - t377 + t494 + t475 - t477 - t484 + t490;
  tv3rho31 = t267 + t268 - t269 + t270 - t271 - t272 + t273 + t252 - t275 - t258 + t277 - t278 + t279 - t256 + t1 * (t500 + t504);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t507 = -t331 + t356 - t501 - t361 + t502 + t365 - t503 - t371 - t377 + t494 + t475 - t477 - t484 + t490;
  tv3rho32 = t267 + t268 - t269 + t270 - t271 - t272 + t273 - t252 - t275 + t258 + t277 - t278 + t279 - t256 + t1 * (t500 + t507);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t510 = -t331 + t356 - t359 - t361 + t363 + t365 - t367 - t371 - t377 + t494 + t475 - t477 - t484 + t490;
  tv3rho33 = t267 + t268 - t269 + t270 - t271 - t272 + t273 - t274 - t275 + t276 + t277 - t278 + t279 + t280 + t1 * (t317 + t510);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t513 = t68 * t146;
  t514 = 0.72e2 * t513;
  t515 = t127 * t74;
  t516 = 0.48e2 * t515;
  t517 = t247 * t6;
  t518 = 0.12e2 * t517;
  t519 = 0.12e2 * t369;
  t521 = 0.1e1 / t145 / t5;
  t526 = (0.3e2 * t4 * t521 + t519) * t18 * t35;
  t550 = 0.8e1 * t479 * t481 * t90 * t98;
  t553 = 0.6e1 * t167 * t300 * t194;
  t556 = 0.4e1 * t85 * t172 * t354;
  t560 = 0.36e2 * t19 * t486 * t178 * t194;
  t563 = 0.8e1 * t19 * t285 * t354;
  t565 = 0.12e2 * t309 * t173;
  t567 = 0.12e2 * t312 * t173;
  t569 = 0.12e2 * t152 * t304;
  t571 = 0.24e2 * t78 * t286;
  t573 = 0.4e1 * t330 * t295;
  t574 = -(0.3e2 * t37 * t521 + t519) * t49 * t66 + t526 - 0.24e2 * t202 * t397 - 0.12e2 * t214 * t397 + 0.12e2 * t202 * t220 * t213 - 0.12e2 * t401 * t379 + 0.12e2 * t421 * t223 + 0.12e2 * t424 * t223 + 0.12e2 * t202 * t382 - t550 + t553 - t556 - t560 + t563 - t565 - t567 - t569 + t571 - t573;
  t576 = 0.4e1 * t330 * t173;
  t578 = 0.6e1 * t164 * t304;
  t582 = 0.12e2 * t167 * t169 * t177 * t178;
  t586 = 0.24e2 * t85 * t86 * t486 * t487;
  t589 = 0.12e2 * t164 * t482 * t166;
  t591 = 0.24e2 * t152 * t290;
  t593 = 0.12e2 * t164 * t290;
  t596 = 0.12e2 * t152 * t170 * t163;
  t598 = 0.12e2 * t473 * t301;
  t600 = 0.4e1 * t78 * t355;
  t603 = t158 * t158;
  t617 = t9 * (0.6e1 * t16 * t14 * t146 + 0.11e2 * t16 * t158 * t146 + 0.6e1 * t16 * t320 * t146 + t16 * t603 * t146 + 0.12e2 * t10 * t369) * t87;
  t620 = t183 * t183;
  t633 = t188 * t188;
  t648 = t19 * t90 * (0.22e2 * t27 * t183 * t146 + 0.22e2 * t32 * t188 * t146 + 0.12e2 * t27 * t25 * t146 + 0.12e2 * t27 * t334 * t146 + 0.2e1 * t27 * t620 * t146 + 0.12e2 * t32 * t30 * t146 + 0.12e2 * t32 * t344 * t146 + 0.2e1 * t32 * t633 * t146 + 0.24e2 * t22 * t369);
  t651 = t178 * t178;
  t654 = 0.24e2 * t19 / t485 / t34 * t651;
  t655 = t194 * t194;
  t658 = 0.6e1 * t19 * t177 * t655;
  t661 = 0.6e1 * t149 * t166 * t170;
  t663 = 0.12e2 * t150 * t179;
  t665 = 0.4e1 * t376 * t99;
  t667 = 0.6e1 * t150 * t195;
  t670 = 0.4e1 * t375 * t84 * t87;
  t671 = -t576 - t578 - t582 - t586 + t589 + t591 + t593 - t596 + t598 - t600 + t617 - t648 + t654 + t658 - t661 + t663 - t665 - t667 + t670;
  t675 = 0.6e1 * t149 * t163 * t87;
  t678 = 0.4e1 * t77 * t329 * t87;
  t680 = 0.24e2 * t78 * t488;
  t681 = t163 * t163;
  t684 = 0.3e1 * t9 * t681 * t170;
  t685 = t166 * t166;
  t687 = t168 * t168;
  t691 = 0.6e1 * t9 * t685 / t687 * t35;
  t694 = 0.8e1 * t77 * t478 * t482;
  t722 = 0.24e2 * t85 * t86 * t286;
  t727 = 0.12e2 * t164 * t169 * t90 * t84 * t98;
  t738 = t675 + t678 - t680 - t684 - t691 + t694 - 0.12e2 * t214 * t410 * t216 + 0.12e2 * t217 * t219 * t227 * t228 + 0.24e2 * t111 * t112 * t414 * t415 + 0.36e2 * t50 * t414 * t228 * t244 - 0.8e1 * t50 * t385 * t465 + 0.4e1 * t111 * t222 * t465 - 0.24e2 * t104 * t386 + 0.4e1 * t441 * t391 + t722 + t727 - 0.24e2 * t111 * t112 * t386 - 0.12e2 * t214 * t219 * t116 * t110 * t124 + 0.4e1 * t441 * t223;
  t770 = t208 * t208;
  t787 = t233 * t233;
  t800 = t238 * t238;
  t816 = t244 * t244;
  t820 = t213 * t213;
  t824 = t216 * t216;
  t826 = t218 * t218;
  t833 = t228 * t228;
  t842 = 0.6e1 * t214 * t382 + 0.8e1 * t407 * t409 * t116 * t124 - 0.6e1 * t217 * t378 * t244 + 0.6e1 * t199 * t216 * t220 - 0.12e2 * t200 * t229 + 0.4e1 * t471 * t125 + 0.6e1 * t200 * t245 - 0.4e1 * t470 * t110 * t113 - 0.6e1 * t199 * t213 * t113 - 0.4e1 * t103 * t440 * t113 + 0.4e1 * t104 * t466 - t40 * (0.11e2 * t47 * t208 * t146 + 0.6e1 * t47 * t431 * t146 + 0.6e1 * t47 * t45 * t146 + t47 * t770 * t146 + 0.12e2 * t41 * t369) * t113 + t50 * t116 * (0.22e2 * t58 * t233 * t146 + 0.22e2 * t63 * t238 * t146 + 0.12e2 * t58 * t445 * t146 + 0.12e2 * t63 * t455 * t146 + 0.12e2 * t58 * t56 * t146 + 0.2e1 * t58 * t787 * t146 + 0.12e2 * t63 * t61 * t146 + 0.2e1 * t63 * t800 * t146 + 0.24e2 * t53 * t369) - 0.6e1 * t50 * t227 * t816 + 0.3e1 * t40 * t820 * t220 + 0.6e1 * t40 * t824 / t826 * t66 - 0.24e2 * t50 / t413 / t65 * t833 - 0.8e1 * t103 * t406 * t410 + 0.24e2 * t104 * t416;
  t846 = (t574 + t671 + t738 + t842) * t70 * t6;
  t848 = 0.8e1 * t493 * t74;
  t850 = t492 * t69 * t6;
  t851 = 0.8e1 * t850;
  t852 = t250 * t146;
  t853 = 0.144e3 * t852;
  t855 = 0.96e2 * t128 * t369;
  t856 = t130 * t369;
  t857 = 0.192e3 * t856;
  t859 = 0.12e3 * t71 * t521;
  t861 = 0.36e2 * t248 * t146;
  t862 = t514 - t516 + t518 - t526 + t846 - t848 + t851 + t853 - t855 - t857 + t859 + t861;
  t863 = t550 - t553 + t556 + t560 - t563 + t565 + t567 + t569 - t571 + t573 + t576 + t578 + t582;
  t865 = t586 - t589 - t591 - t593 + t596 - t598 + t600 - t617 + t648 - t654 - t658 + t661;
  t866 = t357 * t74;
  t867 = 0.48e2 * t866;
  t868 = -t663 + t665 + t667 - t670 - t675 - t678 + t680 + t684 + t691 - t694 - t867 - t722 - t727;
  t872 = 0.24e2 * t281;
  t873 = 0.48e2 * t283;
  t874 = 0.24e2 * t287;
  t875 = 0.24e2 * t291;
  t876 = 0.24e2 * t293;
  t877 = 0.12e2 * t296;
  t878 = 0.12e2 * t298;
  t879 = 0.12e2 * t302;
  t880 = 0.12e2 * t305;
  t881 = 0.12e2 * t307;
  t882 = 0.12e2 * t310;
  t883 = 0.12e2 * t313;
  t884 = 0.12e2 * t315;
  t885 = t1 * (t862 + t863 + t865 + t868) + t872 - t873 - t874 - t875 + t876 + t877 + t878 - t879 + t880 + t881 - t882 - t883 + t884;
  t886 = 0.4e1 * t331;
  t887 = 0.4e1 * t356;
  t888 = 0.24e2 * t358;
  t889 = 0.24e2 * t360;
  t890 = 0.96e2 * t362;
  t891 = 0.72e2 * t364;
  t892 = 0.144e3 * t366;
  t893 = 0.96e2 * t370;
  t894 = 0.4e1 * t377;
  t895 = 0.4e1 * t494;
  t896 = 0.12e2 * t474;
  t897 = 0.24e2 * t476;
  t898 = 0.8e1 * t483;
  t899 = 0.24e2 * t489;
  t900 = -t886 + t887 + t888 - t889 - t890 + t891 + t892 - t893 - t894 + t895 + t896 - t897 - t898 + t899;
  tv4rho40 = t885 + t900;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t901 = 0.4e1 * t850;
  t902 = 0.72e2 * t852;
  t903 = 0.96e2 * t856;
  t904 = -t526 + t846 - t848 + t901 + t902 - t855 - t903 + t859 + t861 + t550 - t553;
  t905 = t556 + t560 - t563 + t565 + t567 + t569 - t571 + t573 + t576 + t578 + t582 + t586;
  t907 = -t589 - t591 - t593 + t596 - t598 + t600 - t617 + t648 - t654 - t658 + t661 - t663;
  t908 = 0.24e2 * t866;
  t909 = t665 + t667 - t670 - t675 - t678 + t680 + t684 + t691 - t694 - t908 - t722 - t727;
  t913 = t1 * (t904 + t905 + t907 + t909) - t874 - t875 + t876 + t877 + t878 - t879 + t880 + t881 - t882 - t883 + t884 - t886;
  t914 = 0.12e2 * t358;
  t915 = 0.48e2 * t362;
  t916 = 0.72e2 * t366;
  t917 = t887 + t914 - t889 - t915 + t891 + t916 - t893 - t894 + t895 + t896 - t897 - t898 + t899;
  tv4rho41 = t913 + t917;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t923 = -0.24e2 * t513 + 0.16e2 * t515 - 0.4e1 * t517 - t526 + t846 - t848 - t855 + t859 + t861 + t550 - t553;
  t925 = -t589 - t591 - t593 + t596 - t598 + t600 - t617 + t648 - t654 - t658 + t661;
  t926 = -t663 + t665 + t667 - t670 - t675 - t678 + t680 + t684 + t691 - t694 - t722 - t727;
  t930 = -0.8e1 * t281 + 0.16e2 * t283 + t1 * (t923 + t905 + t925 + t926) - t874 - t875 + t876 + t877 + t878 - t879 + t880 + t881 - t882;
  t931 = -t883 + t884 - t886 + t887 - t889 + t891 - t893 - t894 + t895 + t896 - t897 - t898 + t899;
  tv4rho42 = t930 + t931;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t932 = -t526 + t846 - t848 - t901 - t902 - t855 + t903 + t859 + t861 + t550 - t553;
  t934 = t665 + t667 - t670 - t675 - t678 + t680 + t684 + t691 - t694 + t908 - t722 - t727;
  t938 = t1 * (t932 + t905 + t907 + t934) - t874 - t875 + t876 + t877 + t878 - t879 + t880 + t881 - t882 - t883 + t884 - t886;
  t939 = t887 - t914 - t889 + t915 + t891 - t916 - t893 - t894 + t895 + t896 - t897 - t898 + t899;
  tv4rho43 = t938 + t939;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t940 = t514 - t516 + t518 - t526 + t846 - t848 - t851 - t853 - t855 + t857 + t859 + t861;
  t942 = -t663 + t665 + t667 - t670 - t675 - t678 + t680 + t684 + t691 - t694 + t867 - t722 - t727;
  t946 = t872 + t1 * (t940 + t863 + t865 + t942) - t873 - t874 - t875 + t876 + t877 + t878 - t879 + t880 + t881 - t882 - t883 + t884;
  t947 = -t886 + t887 - t888 - t889 + t890 + t891 - t892 - t893 - t894 + t895 + t896 - t897 - t898 + t899;
  tv4rho44 = t946 + t947;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

}

#endif

