/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_c_w94.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t9, t10;
  double t11, t12, t13, t16, t17, t20, t22, t23;
  double t24, t25, t30, tzk0;


  t1 = sqrt(sigma[0]);
  t2 = t1 * sigma[0];
  t3 = rho[0] * rho[0];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = POW_1_3(rho[0]);
  t9 = 0.1e1 / t7 / rho[0];
  t10 = t1 * t9;
  t11 = pow(t10, 0.1e1 / 0.16e2);
  t12 = t11 * t11;
  t13 = t12 * t11;
  t16 = t3 * rho[0];
  t17 = 0.1e1 / t16;
  t20 = M_CBRT3;
  t22 = POW_1_3(0.1e1 / M_PI);
  t23 = t20 * t22;
  t24 = M_CBRT4;
  t25 = t24 * t24;
  t30 = 0.118e2 + 0.15067e0 * t13 * t2 * t5 + 0.1102e-1 * sigma[0] * t17 + t23 * t25 / t7 / 0.4e1;
  tzk0 = -0.1e1 / t30;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t9, t10;
  double t11, t12, t13, t16, t17, t20, t22, t23;
  double t24, t25, t30, tzk0;

  double t32, t33, t34, t35, t37, t39, t40, t42;
  double t50, tvrho0, t52, t53, t57, tvsigma0;


  t1 = sqrt(sigma[0]);
  t2 = t1 * sigma[0];
  t3 = rho[0] * rho[0];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = POW_1_3(rho[0]);
  t9 = 0.1e1 / t7 / rho[0];
  t10 = t1 * t9;
  t11 = pow(t10, 0.1e1 / 0.16e2);
  t12 = t11 * t11;
  t13 = t12 * t11;
  t16 = t3 * rho[0];
  t17 = 0.1e1 / t16;
  t20 = M_CBRT3;
  t22 = POW_1_3(0.1e1 / M_PI);
  t23 = t20 * t22;
  t24 = M_CBRT4;
  t25 = t24 * t24;
  t30 = 0.118e2 + 0.15067e0 * t13 * t2 * t5 + 0.1102e-1 * sigma[0] * t17 + t23 * t25 / t7 / 0.4e1;
  tzk0 = -0.1e1 / t30;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t32 = t30 * t30;
  t33 = 0.1e1 / t32;
  t34 = rho[0] * t33;
  t35 = t7 * t7;
  t37 = 0.1e1 / t35 / t3;
  t39 = t13 * sigma[0] * t37;
  t40 = t39 * t1;
  t42 = 0.1e1 / t7 / t3;
  t50 = -0.6403475e0 * t40 * t42 - 0.3306e-1 * sigma[0] * t5 - t23 * t25 * t9 / 0.12e2;
  tvrho0 = t34 * t50 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t52 = 0.1e1 / t1;
  t53 = t39 * t52;
  t57 = 0.2401303125e0 * t53 * t9 + 0.1102e-1 * t17;
  tvsigma0 = t34 * t57;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t9, t10;
  double t11, t12, t13, t16, t17, t20, t22, t23;
  double t24, t25, t30, tzk0;

  double t32, t33, t34, t35, t37, t39, t40, t42;
  double t50, tvrho0, t52, t53, t57, tvsigma0;

  double t61, t62, t63, t66, t67, t69, t73, t76;
  double t77, t83, tv2rho20, t86, t90, t96, tv2rhosigma0, t98;
  double t101, t102, t105, t106, t109, tv2sigma20;


  t1 = sqrt(sigma[0]);
  t2 = t1 * sigma[0];
  t3 = rho[0] * rho[0];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = POW_1_3(rho[0]);
  t9 = 0.1e1 / t7 / rho[0];
  t10 = t1 * t9;
  t11 = pow(t10, 0.1e1 / 0.16e2);
  t12 = t11 * t11;
  t13 = t12 * t11;
  t16 = t3 * rho[0];
  t17 = 0.1e1 / t16;
  t20 = M_CBRT3;
  t22 = POW_1_3(0.1e1 / M_PI);
  t23 = t20 * t22;
  t24 = M_CBRT4;
  t25 = t24 * t24;
  t30 = 0.118e2 + 0.15067e0 * t13 * t2 * t5 + 0.1102e-1 * sigma[0] * t17 + t23 * t25 / t7 / 0.4e1;
  tzk0 = -0.1e1 / t30;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t32 = t30 * t30;
  t33 = 0.1e1 / t32;
  t34 = rho[0] * t33;
  t35 = t7 * t7;
  t37 = 0.1e1 / t35 / t3;
  t39 = t13 * sigma[0] * t37;
  t40 = t39 * t1;
  t42 = 0.1e1 / t7 / t3;
  t50 = -0.6403475e0 * t40 * t42 - 0.3306e-1 * sigma[0] * t5 - t23 * t25 * t9 / 0.12e2;
  tvrho0 = t34 * t50 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t52 = 0.1e1 / t1;
  t53 = t39 * t52;
  t57 = 0.2401303125e0 * t53 * t9 + 0.1102e-1 * t17;
  tvsigma0 = t34 * t57;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t61 = 0.1e1 / t32 / t30;
  t62 = rho[0] * t61;
  t63 = t50 * t50;
  t66 = t13 * t10;
  t67 = t66 * sigma[0];
  t69 = 0.1e1 / t35 / t4;
  t73 = 0.1e1 / t7 / t16;
  t76 = t4 * rho[0];
  t77 = 0.1e1 / t76;
  t83 = 0.18676802083333333333e1 * t67 * t69 + 0.14941441666666666667e1 * t40 * t73 + 0.13224e0 * sigma[0] * t77 + t23 * t25 * t42 / 0.9e1;
  tv2rho20 = 0.2e1 * t33 * t50 + t34 * t83 - 0.2e1 * t62 * t63;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t86 = t57 * t50;
  t90 = 0.1e1 / t35 / t16;
  t96 = -0.700380078125e0 * t66 * t90 - 0.32017375e0 * t53 * t42 - 0.3306e-1 * t5;
  tv2rhosigma0 = t33 * t57 + t34 * t96 - 0.2e1 * t62 * t86;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t98 = t57 * t57;
  t101 = 0.1e1 / sigma[0];
  t102 = t66 * t101;
  t105 = 0.1e1 / t2;
  t106 = t39 * t105;
  t109 = 0.262642529296875e0 * t102 * t37 - 0.12006515625e0 * t106 * t9;
  tv2sigma20 = t34 * t109 - 0.2e1 * t62 * t98;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t9, t10;
  double t11, t12, t13, t16, t17, t20, t22, t23;
  double t24, t25, t30, tzk0;

  double t32, t33, t34, t35, t37, t39, t40, t42;
  double t50, tvrho0, t52, t53, t57, tvsigma0;

  double t61, t62, t63, t66, t67, t69, t73, t76;
  double t77, t83, tv2rho20, t86, t90, t96, tv2rhosigma0, t98;
  double t101, t102, t105, t106, t109, tv2sigma20;

  double t115, t116, t117, t118, t124, t125, t126, t130;
  double t134, t137, t138, t144, tv3rho30, t146, t168, tv3rho2sigma0;
  double t182, t189, tv3rhosigma20, t191, t194, t200, t201, t202;
  double t206, t207, t210, tv3sigma30;


  t1 = sqrt(sigma[0]);
  t2 = t1 * sigma[0];
  t3 = rho[0] * rho[0];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = POW_1_3(rho[0]);
  t9 = 0.1e1 / t7 / rho[0];
  t10 = t1 * t9;
  t11 = pow(t10, 0.1e1 / 0.16e2);
  t12 = t11 * t11;
  t13 = t12 * t11;
  t16 = t3 * rho[0];
  t17 = 0.1e1 / t16;
  t20 = M_CBRT3;
  t22 = POW_1_3(0.1e1 / M_PI);
  t23 = t20 * t22;
  t24 = M_CBRT4;
  t25 = t24 * t24;
  t30 = 0.118e2 + 0.15067e0 * t13 * t2 * t5 + 0.1102e-1 * sigma[0] * t17 + t23 * t25 / t7 / 0.4e1;
  tzk0 = -0.1e1 / t30;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t32 = t30 * t30;
  t33 = 0.1e1 / t32;
  t34 = rho[0] * t33;
  t35 = t7 * t7;
  t37 = 0.1e1 / t35 / t3;
  t39 = t13 * sigma[0] * t37;
  t40 = t39 * t1;
  t42 = 0.1e1 / t7 / t3;
  t50 = -0.6403475e0 * t40 * t42 - 0.3306e-1 * sigma[0] * t5 - t23 * t25 * t9 / 0.12e2;
  tvrho0 = t34 * t50 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t52 = 0.1e1 / t1;
  t53 = t39 * t52;
  t57 = 0.2401303125e0 * t53 * t9 + 0.1102e-1 * t17;
  tvsigma0 = t34 * t57;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t61 = 0.1e1 / t32 / t30;
  t62 = rho[0] * t61;
  t63 = t50 * t50;
  t66 = t13 * t10;
  t67 = t66 * sigma[0];
  t69 = 0.1e1 / t35 / t4;
  t73 = 0.1e1 / t7 / t16;
  t76 = t4 * rho[0];
  t77 = 0.1e1 / t76;
  t83 = 0.18676802083333333333e1 * t67 * t69 + 0.14941441666666666667e1 * t40 * t73 + 0.13224e0 * sigma[0] * t77 + t23 * t25 * t42 / 0.9e1;
  tv2rho20 = 0.2e1 * t33 * t50 + t34 * t83 - 0.2e1 * t62 * t63;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t86 = t57 * t50;
  t90 = 0.1e1 / t35 / t16;
  t96 = -0.700380078125e0 * t66 * t90 - 0.32017375e0 * t53 * t42 - 0.3306e-1 * t5;
  tv2rhosigma0 = t33 * t57 + t34 * t96 - 0.2e1 * t62 * t86;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t98 = t57 * t57;
  t101 = 0.1e1 / sigma[0];
  t102 = t66 * t101;
  t105 = 0.1e1 / t2;
  t106 = t39 * t105;
  t109 = 0.262642529296875e0 * t102 * t37 - 0.12006515625e0 * t106 * t9;
  tv2sigma20 = t34 * t109 - 0.2e1 * t62 * t98;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t115 = t32 * t32;
  t116 = 0.1e1 / t115;
  t117 = rho[0] * t116;
  t118 = t63 * t50;
  t124 = t13 * t2;
  t125 = t4 * t16;
  t126 = 0.1e1 / t125;
  t130 = 0.1e1 / t35 / t76;
  t134 = 0.1e1 / t7 / t4;
  t137 = t4 * t3;
  t138 = 0.1e1 / t137;
  t144 = -0.29571603298611111111e1 * t124 * t126 - 0.13073761458333333333e2 * t67 * t130 - 0.49804805555555555557e1 * t40 * t134 - 0.6612e0 * sigma[0] * t138 - 0.7e1 / 0.27e2 * t23 * t25 * t73;
  tv3rho30 = -0.6e1 * t62 * t50 * t83 + 0.6e1 * t117 * t118 + t34 * t144 + 0.3e1 * t33 * t83 - 0.6e1 * t61 * t63;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t146 = t61 * t57;
  t168 = 0.11089351236979166667e1 * t13 * t138 * t1 + 0.3501900390625e1 * t66 * t69 + 0.74707208333333333333e0 * t53 * t73 + 0.13224e0 * t77;
  tv3rho2sigma0 = 0.6e1 * t117 * t57 * t63 - 0.4e1 * t62 * t96 * t50 - 0.2e1 * t62 * t57 * t83 - 0.4e1 * t146 * t50 + t34 * t168 + 0.2e1 * t33 * t96;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t182 = t13 * t52;
  t189 = -0.41585067138671875e0 * t182 * t77 - 0.3501900390625e0 * t102 * t90 + 0.160086875e0 * t106 * t42;
  tv3rhosigma20 = -0.2e1 * t62 * t109 * t50 + 0.6e1 * t117 * t98 * t50 - 0.4e1 * t62 * t57 * t96 + t33 * t109 + t34 * t189 - 0.2e1 * t61 * t98;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t191 = t98 * t57;
  t194 = t57 * t109;
  t200 = sigma[0] * sigma[0];
  t201 = 0.1e1 / t200;
  t202 = t66 * t201;
  t206 = 0.1e1 / t1 / t200;
  t207 = t39 * t206;
  t210 = 0.15594400177001953125e0 * t13 * t105 * t5 - 0.3939637939453125e0 * t202 * t37 + 0.180097734375e0 * t207 * t9;
  tv3sigma30 = 0.6e1 * t117 * t191 - 0.6e1 * t62 * t194 + t34 * t210;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t9, t10;
  double t11, t12, t13, t16, t17, t20, t22, t23;
  double t24, t25, t30, tzk0;

  double t32, t33, t34, t35, t37, t39, t40, t42;
  double t50, tvrho0, t52, t53, t57, tvsigma0;

  double t61, t62, t63, t66, t67, t69, t73, t76;
  double t77, t83, tv2rho20, t86, t90, t96, tv2rhosigma0, t98;
  double t101, t102, t105, t106, t109, tv2sigma20;

  double t115, t116, t117, t118, t124, t125, t126, t130;
  double t134, t137, t138, t144, tv3rho30, t146, t168, tv3rho2sigma0;
  double t182, t189, tv3rhosigma20, t191, t194, t200, t201, t202;
  double t206, t207, t210, tv3sigma30;

  double t221, t222, t228, t234, t236, t238, t240, t254;
  double tv4rho40, tv4rho3sigma0, t321, tv4rho2sigma20, tv4rhosigma30, t387, t393, t405;
  double tv4sigma40;


  t1 = sqrt(sigma[0]);
  t2 = t1 * sigma[0];
  t3 = rho[0] * rho[0];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = POW_1_3(rho[0]);
  t9 = 0.1e1 / t7 / rho[0];
  t10 = t1 * t9;
  t11 = pow(t10, 0.1e1 / 0.16e2);
  t12 = t11 * t11;
  t13 = t12 * t11;
  t16 = t3 * rho[0];
  t17 = 0.1e1 / t16;
  t20 = M_CBRT3;
  t22 = POW_1_3(0.1e1 / M_PI);
  t23 = t20 * t22;
  t24 = M_CBRT4;
  t25 = t24 * t24;
  t30 = 0.118e2 + 0.15067e0 * t13 * t2 * t5 + 0.1102e-1 * sigma[0] * t17 + t23 * t25 / t7 / 0.4e1;
  tzk0 = -0.1e1 / t30;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t32 = t30 * t30;
  t33 = 0.1e1 / t32;
  t34 = rho[0] * t33;
  t35 = t7 * t7;
  t37 = 0.1e1 / t35 / t3;
  t39 = t13 * sigma[0] * t37;
  t40 = t39 * t1;
  t42 = 0.1e1 / t7 / t3;
  t50 = -0.6403475e0 * t40 * t42 - 0.3306e-1 * sigma[0] * t5 - t23 * t25 * t9 / 0.12e2;
  tvrho0 = t34 * t50 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t52 = 0.1e1 / t1;
  t53 = t39 * t52;
  t57 = 0.2401303125e0 * t53 * t9 + 0.1102e-1 * t17;
  tvsigma0 = t34 * t57;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t61 = 0.1e1 / t32 / t30;
  t62 = rho[0] * t61;
  t63 = t50 * t50;
  t66 = t13 * t10;
  t67 = t66 * sigma[0];
  t69 = 0.1e1 / t35 / t4;
  t73 = 0.1e1 / t7 / t16;
  t76 = t4 * rho[0];
  t77 = 0.1e1 / t76;
  t83 = 0.18676802083333333333e1 * t67 * t69 + 0.14941441666666666667e1 * t40 * t73 + 0.13224e0 * sigma[0] * t77 + t23 * t25 * t42 / 0.9e1;
  tv2rho20 = 0.2e1 * t33 * t50 + t34 * t83 - 0.2e1 * t62 * t63;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t86 = t57 * t50;
  t90 = 0.1e1 / t35 / t16;
  t96 = -0.700380078125e0 * t66 * t90 - 0.32017375e0 * t53 * t42 - 0.3306e-1 * t5;
  tv2rhosigma0 = t33 * t57 + t34 * t96 - 0.2e1 * t62 * t86;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t98 = t57 * t57;
  t101 = 0.1e1 / sigma[0];
  t102 = t66 * t101;
  t105 = 0.1e1 / t2;
  t106 = t39 * t105;
  t109 = 0.262642529296875e0 * t102 * t37 - 0.12006515625e0 * t106 * t9;
  tv2sigma20 = t34 * t109 - 0.2e1 * t62 * t98;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t115 = t32 * t32;
  t116 = 0.1e1 / t115;
  t117 = rho[0] * t116;
  t118 = t63 * t50;
  t124 = t13 * t2;
  t125 = t4 * t16;
  t126 = 0.1e1 / t125;
  t130 = 0.1e1 / t35 / t76;
  t134 = 0.1e1 / t7 / t4;
  t137 = t4 * t3;
  t138 = 0.1e1 / t137;
  t144 = -0.29571603298611111111e1 * t124 * t126 - 0.13073761458333333333e2 * t67 * t130 - 0.49804805555555555557e1 * t40 * t134 - 0.6612e0 * sigma[0] * t138 - 0.7e1 / 0.27e2 * t23 * t25 * t73;
  tv3rho30 = -0.6e1 * t62 * t50 * t83 + 0.6e1 * t117 * t118 + t34 * t144 + 0.3e1 * t33 * t83 - 0.6e1 * t61 * t63;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t146 = t61 * t57;
  t168 = 0.11089351236979166667e1 * t13 * t138 * t1 + 0.3501900390625e1 * t66 * t69 + 0.74707208333333333333e0 * t53 * t73 + 0.13224e0 * t77;
  tv3rho2sigma0 = 0.6e1 * t117 * t57 * t63 - 0.4e1 * t62 * t96 * t50 - 0.2e1 * t62 * t57 * t83 - 0.4e1 * t146 * t50 + t34 * t168 + 0.2e1 * t33 * t96;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t182 = t13 * t52;
  t189 = -0.41585067138671875e0 * t182 * t77 - 0.3501900390625e0 * t102 * t90 + 0.160086875e0 * t106 * t42;
  tv3rhosigma20 = -0.2e1 * t62 * t109 * t50 + 0.6e1 * t117 * t98 * t50 - 0.4e1 * t62 * t57 * t96 + t33 * t109 + t34 * t189 - 0.2e1 * t61 * t98;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t191 = t98 * t57;
  t194 = t57 * t109;
  t200 = sigma[0] * sigma[0];
  t201 = 0.1e1 / t200;
  t202 = t66 * t201;
  t206 = 0.1e1 / t1 / t200;
  t207 = t39 * t206;
  t210 = 0.15594400177001953125e0 * t13 * t105 * t5 - 0.3939637939453125e0 * t202 * t37 + 0.180097734375e0 * t207 * t9;
  tv3sigma30 = 0.6e1 * t117 * t191 - 0.6e1 * t62 * t194 + t34 * t210;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t221 = rho[0] / t115 / t30;
  t222 = t63 * t63;
  t228 = t83 * t83;
  t234 = t12 * t12;
  t236 = t234 * t234;
  t238 = 0.1e1 / t236 / t234 / t11;
  t240 = t4 * t4;
  t254 = 0.1e1 / t7 / t76;
  tv4rho40 = 0.24e2 * t116 * t118 - 0.24e2 * t61 * t50 * t83 + 0.4e1 * t33 * t144 - 0.24e2 * t221 * t222 + 0.36e2 * t117 * t63 * t83 - 0.6e1 * t62 * t228 - 0.8e1 * t62 * t50 * t144 + t34 * (0.73929008246527777778e0 * t238 * t200 / t7 / t240 / rho[0] + 0.41400244618055555555e2 * t124 / t240 + 0.88611049884259259258e2 * t67 / t35 / t137 + 0.21582082407407407408e2 * t40 * t254 + 0.39672e1 * sigma[0] * t126 + 0.7e2 / 0.81e2 * t23 * t25 * t134);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  tv4rho3sigma0 = 0.18e2 * t116 * t57 * t63 - 0.12e2 * t61 * t96 * t50 - 0.6e1 * t146 * t83 + 0.3e1 * t33 * t168 - 0.24e2 * t221 * t57 * t118 + 0.18e2 * t117 * t96 * t63 + 0.18e2 * t117 * t86 * t83 - 0.6e1 * t62 * t168 * t50 - 0.6e1 * t62 * t96 * t83 - 0.2e1 * t62 * t57 * t144 + t34 * (-0.27723378092447916668e0 * t238 / t7 / t240 * sigma[0] - 0.12198286360677083334e2 * t13 * t126 * t1 - 0.18521162065972222222e2 * t66 * t130 - 0.24902402777777777778e1 * t53 * t134 - 0.6612e0 * t138);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t321 = t96 * t96;
  tv4rho2sigma20 = 0.12e2 * t116 * t98 * t50 - 0.8e1 * t146 * t96 - 0.24e2 * t221 * t98 * t63 + 0.24e2 * t117 * t86 * t96 + 0.6e1 * t117 * t98 * t83 - 0.4e1 * t62 * t321 - 0.4e1 * t62 * t57 * t168 - 0.4e1 * t61 * t109 * t50 + 0.2e1 * t33 * t189 + 0.6e1 * t117 * t109 * t63 - 0.4e1 * t62 * t189 * t50 - 0.2e1 * t62 * t109 * t83 + t34 * (0.1039626678466796875e0 * t238 / t7 / t125 + 0.26337209187825520833e1 * t182 * t138 + 0.81711009114583333337e0 * t102 * t69 - 0.37353604166666666667e0 * t106 * t73);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rhosigma30 = 0.6e1 * t116 * t191 - 0.24e2 * t221 * t191 * t50 + 0.18e2 * t117 * t98 * t96 - 0.6e1 * t146 * t109 + 0.18e2 * t117 * t194 * t50 - 0.6e1 * t62 * t96 * t109 - 0.6e1 * t62 * t57 * t189 + t33 * t210 - 0.2e1 * t62 * t210 * t50 + t34 * (-0.38986000442504882812e-1 * t238 * t101 / t7 / t137 + 0.52528505859375e0 * t202 * t90 - 0.2401303125e0 * t207 * t42);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t387 = t98 * t98;
  t393 = t109 * t109;
  t405 = t200 * sigma[0];
  tv4sigma40 = -0.24e2 * t221 * t387 + 0.36e2 * t117 * t98 * t109 - 0.6e1 * t62 * t393 - 0.8e1 * t62 * t57 * t210 + t34 * (0.14619750165939331055e-1 * t238 * t201 * t254 - 0.46783200531005859376e0 * t13 * t206 * t5 + 0.98490948486328125e0 * t66 / t405 * t37 - 0.4502443359375e0 * t39 / t1 / t405 * t9);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t7, t8;
  double t9, t10, t12, t13, t15, t16, t17, t18;
  double t19, t20, t22, t24, t25, t26, t27, t28;
  double t31, t32, t35, t37, t38, t39, t40, t45;
  double t46, tzk0;


  t1 = rho[0] - rho[1];
  t2 = rho[0] + rho[1];
  t3 = 0.1e1 / t2;
  t4 = t1 * t3;
  t5 = 0.e0 < t4;
  t6 = my_piecewise3(t5, t4, -t4);
  t7 = 0.1e-9 < t6;
  t8 = my_piecewise3(t7, t6, 0.1e-9);
  t9 = POW_1_3(t8);
  t10 = t9 * t9;
  t12 = -t10 * t8 + 0.1e1;
  t13 = sqrt(t12);
  t15 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t16 = sqrt(t15);
  t17 = t16 * t15;
  t18 = t2 * t2;
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t22 = POW_1_3(t2);
  t24 = 0.1e1 / t22 / t2;
  t25 = t16 * t24;
  t26 = pow(t25, 0.1e1 / 0.16e2);
  t27 = t26 * t26;
  t28 = t27 * t26;
  t31 = t18 * t2;
  t32 = 0.1e1 / t31;
  t35 = M_CBRT3;
  t37 = POW_1_3(0.1e1 / M_PI);
  t38 = t35 * t37;
  t39 = M_CBRT4;
  t40 = t39 * t39;
  t45 = 0.118e2 + 0.15067e0 * t28 * t17 * t20 + 0.1102e-1 * t15 * t32 + t38 * t40 / t22 / 0.4e1;
  t46 = 0.1e1 / t45;
  tzk0 = -t13 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t7, t8;
  double t9, t10, t12, t13, t15, t16, t17, t18;
  double t19, t20, t22, t24, t25, t26, t27, t28;
  double t31, t32, t35, t37, t38, t39, t40, t45;
  double t46, tzk0;

  double t48, t49, t50, t51, t52, t53, t55, t56;
  double t60, t61, t62, t63, t65, t67, t68, t70;
  double t78, t80, tvrho0, t81, t83, t84, tvrho1, t88;
  double t89, t90, t93, tvsigma0, t97, tvsigma1, tvsigma2;


  t1 = rho[0] - rho[1];
  t2 = rho[0] + rho[1];
  t3 = 0.1e1 / t2;
  t4 = t1 * t3;
  t5 = 0.e0 < t4;
  t6 = my_piecewise3(t5, t4, -t4);
  t7 = 0.1e-9 < t6;
  t8 = my_piecewise3(t7, t6, 0.1e-9);
  t9 = POW_1_3(t8);
  t10 = t9 * t9;
  t12 = -t10 * t8 + 0.1e1;
  t13 = sqrt(t12);
  t15 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t16 = sqrt(t15);
  t17 = t16 * t15;
  t18 = t2 * t2;
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t22 = POW_1_3(t2);
  t24 = 0.1e1 / t22 / t2;
  t25 = t16 * t24;
  t26 = pow(t25, 0.1e1 / 0.16e2);
  t27 = t26 * t26;
  t28 = t27 * t26;
  t31 = t18 * t2;
  t32 = 0.1e1 / t31;
  t35 = M_CBRT3;
  t37 = POW_1_3(0.1e1 / M_PI);
  t38 = t35 * t37;
  t39 = M_CBRT4;
  t40 = t39 * t39;
  t45 = 0.118e2 + 0.15067e0 * t28 * t17 * t20 + 0.1102e-1 * t15 * t32 + t38 * t40 / t22 / 0.4e1;
  t46 = 0.1e1 / t45;
  tzk0 = -t13 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = 0.1e1 / t13;
  t49 = t2 * t48;
  t50 = t46 * t10;
  t51 = 0.1e1 / t18;
  t52 = t1 * t51;
  t53 = t3 - t52;
  t55 = my_piecewise3(t5, t53, -t53);
  t56 = my_piecewise3(t7, t55, 0);
  t60 = t2 * t13;
  t61 = t45 * t45;
  t62 = 0.1e1 / t61;
  t63 = t22 * t22;
  t65 = 0.1e1 / t63 / t18;
  t67 = t28 * t15 * t65;
  t68 = t67 * t16;
  t70 = 0.1e1 / t22 / t18;
  t78 = -0.6403475e0 * t68 * t70 - 0.3306e-1 * t15 * t20 - t38 * t40 * t24 / 0.12e2;
  t80 = t60 * t62 * t78;
  tvrho0 = tzk0 + 0.5e1 / 0.6e1 * t49 * t50 * t56 + t80;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t81 = -t3 - t52;
  t83 = my_piecewise3(t5, t81, -t81);
  t84 = my_piecewise3(t7, t83, 0);
  tvrho1 = tzk0 + 0.5e1 / 0.6e1 * t49 * t50 * t84 + t80;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t88 = 0.1e1 / t16;
  t89 = t67 * t88;
  t90 = t89 * t24;
  t93 = 0.2401303125e0 * t90 + 0.1102e-1 * t32;
  tvsigma0 = t60 * t62 * t93;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t97 = 0.480260625e0 * t90 + 0.2204e-1 * t32;
  tvsigma1 = t60 * t62 * t97;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t7, t8;
  double t9, t10, t12, t13, t15, t16, t17, t18;
  double t19, t20, t22, t24, t25, t26, t27, t28;
  double t31, t32, t35, t37, t38, t39, t40, t45;
  double t46, tzk0;

  double t48, t49, t50, t51, t52, t53, t55, t56;
  double t60, t61, t62, t63, t65, t67, t68, t70;
  double t78, t80, tvrho0, t81, t83, t84, tvrho1, t88;
  double t89, t90, t93, tvsigma0, t97, tvsigma1, tvsigma2;

  double t99, t100, t101, t103, t105, t107, t108, t109;
  double t110, t111, t115, t116, t117, t119, t120, t124;
  double t126, t128, t129, t134, t135, t138, t139, t140;
  double t142, t146, t149, t150, t156, t158, tv2rho20, t160;
  double t161, t163, t164, t165, t168, t169, t171, t172;
  double t173, t176, t177, t178, tv2rho21, t184, t193, t195;
  double t196, tv2rho22, t200, t201, t202, t205, t208, t210;
  double t211, t213, t216, t218, tv2rhosigma0, t219, t220, t221;
  double t224, t227, t231, t233, tv2rhosigma1, tv2rhosigma2, t234, tv2rhosigma3;
  double t237, tv2rhosigma4, tv2rhosigma5, t240, t244, t245, t246, t248;
  double t249, t250, t252, tv2sigma20, t260, tv2sigma21, tv2sigma22, t263;
  double t269, tv2sigma23, tv2sigma24, tv2sigma25;


  t1 = rho[0] - rho[1];
  t2 = rho[0] + rho[1];
  t3 = 0.1e1 / t2;
  t4 = t1 * t3;
  t5 = 0.e0 < t4;
  t6 = my_piecewise3(t5, t4, -t4);
  t7 = 0.1e-9 < t6;
  t8 = my_piecewise3(t7, t6, 0.1e-9);
  t9 = POW_1_3(t8);
  t10 = t9 * t9;
  t12 = -t10 * t8 + 0.1e1;
  t13 = sqrt(t12);
  t15 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t16 = sqrt(t15);
  t17 = t16 * t15;
  t18 = t2 * t2;
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t22 = POW_1_3(t2);
  t24 = 0.1e1 / t22 / t2;
  t25 = t16 * t24;
  t26 = pow(t25, 0.1e1 / 0.16e2);
  t27 = t26 * t26;
  t28 = t27 * t26;
  t31 = t18 * t2;
  t32 = 0.1e1 / t31;
  t35 = M_CBRT3;
  t37 = POW_1_3(0.1e1 / M_PI);
  t38 = t35 * t37;
  t39 = M_CBRT4;
  t40 = t39 * t39;
  t45 = 0.118e2 + 0.15067e0 * t28 * t17 * t20 + 0.1102e-1 * t15 * t32 + t38 * t40 / t22 / 0.4e1;
  t46 = 0.1e1 / t45;
  tzk0 = -t13 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = 0.1e1 / t13;
  t49 = t2 * t48;
  t50 = t46 * t10;
  t51 = 0.1e1 / t18;
  t52 = t1 * t51;
  t53 = t3 - t52;
  t55 = my_piecewise3(t5, t53, -t53);
  t56 = my_piecewise3(t7, t55, 0);
  t60 = t2 * t13;
  t61 = t45 * t45;
  t62 = 0.1e1 / t61;
  t63 = t22 * t22;
  t65 = 0.1e1 / t63 / t18;
  t67 = t28 * t15 * t65;
  t68 = t67 * t16;
  t70 = 0.1e1 / t22 / t18;
  t78 = -0.6403475e0 * t68 * t70 - 0.3306e-1 * t15 * t20 - t38 * t40 * t24 / 0.12e2;
  t80 = t60 * t62 * t78;
  tvrho0 = tzk0 + 0.5e1 / 0.6e1 * t49 * t50 * t56 + t80;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t81 = -t3 - t52;
  t83 = my_piecewise3(t5, t81, -t81);
  t84 = my_piecewise3(t7, t83, 0);
  tvrho1 = tzk0 + 0.5e1 / 0.6e1 * t49 * t50 * t84 + t80;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t88 = 0.1e1 / t16;
  t89 = t67 * t88;
  t90 = t89 * t24;
  t93 = 0.2401303125e0 * t90 + 0.1102e-1 * t32;
  tvsigma0 = t60 * t62 * t93;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t97 = 0.480260625e0 * t90 + 0.2204e-1 * t32;
  tvsigma1 = t60 * t62 * t97;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t99 = t48 * t46;
  t100 = t10 * t56;
  t101 = t99 * t100;
  t103 = t13 * t62;
  t105 = 0.2e1 * t103 * t78;
  t107 = 0.1e1 / t13 / t12;
  t108 = t2 * t107;
  t109 = t9 * t8;
  t110 = t46 * t109;
  t111 = t56 * t56;
  t115 = t49 * t62;
  t116 = t100 * t78;
  t117 = t115 * t116;
  t119 = 0.1e1 / t9;
  t120 = t46 * t119;
  t124 = t1 * t32;
  t126 = -0.2e1 * t51 + 0.2e1 * t124;
  t128 = my_piecewise3(t5, t126, -t126);
  t129 = my_piecewise3(t7, t128, 0);
  t134 = 0.1e1 / t61 / t45;
  t135 = t78 * t78;
  t138 = 0.2e1 * t60 * t134 * t135;
  t139 = t28 * t25;
  t140 = t139 * t15;
  t142 = 0.1e1 / t63 / t19;
  t146 = 0.1e1 / t22 / t31;
  t149 = t19 * t2;
  t150 = 0.1e1 / t149;
  t156 = 0.18676802083333333333e1 * t140 * t142 + 0.14941441666666666667e1 * t68 * t146 + 0.13224e0 * t15 * t150 + t38 * t40 * t70 / 0.9e1;
  t158 = t60 * t62 * t156;
  tv2rho20 = 0.5e1 / 0.3e1 * t101 + t105 + 0.25e2 / 0.36e2 * t108 * t110 * t111 - 0.5e1 / 0.3e1 * t117 + 0.5e1 / 0.9e1 * t49 * t120 * t111 + 0.5e1 / 0.6e1 * t49 * t50 * t129 - t138 + t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t160 = t10 * t84;
  t161 = t99 * t160;
  t163 = t108 * t46;
  t164 = t109 * t84;
  t165 = t164 * t56;
  t168 = t160 * t78;
  t169 = t115 * t168;
  t171 = t49 * t46;
  t172 = t119 * t84;
  t173 = t172 * t56;
  t176 = 0.2e1 * t124;
  t177 = my_piecewise3(t5, t176, -t176);
  t178 = my_piecewise3(t7, t177, 0);
  tv2rho21 = 0.5e1 / 0.6e1 * t101 + t105 + 0.5e1 / 0.6e1 * t161 + 0.25e2 / 0.36e2 * t163 * t165 - 0.5e1 / 0.6e1 * t169 + 0.5e1 / 0.9e1 * t171 * t173 + 0.5e1 / 0.6e1 * t49 * t50 * t178 - 0.5e1 / 0.6e1 * t117 - t138 + t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t184 = t84 * t84;
  t193 = 0.2e1 * t51 + 0.2e1 * t124;
  t195 = my_piecewise3(t5, t193, -t193);
  t196 = my_piecewise3(t7, t195, 0);
  tv2rho22 = 0.5e1 / 0.3e1 * t161 + t105 + 0.25e2 / 0.36e2 * t108 * t110 * t184 - 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.9e1 * t49 * t120 * t184 + 0.5e1 / 0.6e1 * t49 * t50 * t196 - t138 + t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t200 = t103 * t93;
  t201 = t93 * t10;
  t202 = t201 * t56;
  t205 = t134 * t93;
  t208 = 0.2e1 * t60 * t205 * t78;
  t210 = 0.1e1 / t63 / t31;
  t211 = t139 * t210;
  t213 = t89 * t70;
  t216 = -0.700380078125e0 * t211 - 0.32017375e0 * t213 - 0.3306e-1 * t20;
  t218 = t60 * t62 * t216;
  tv2rhosigma0 = t200 - 0.5e1 / 0.6e1 * t115 * t202 - t208 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t219 = t103 * t97;
  t220 = t97 * t10;
  t221 = t220 * t56;
  t224 = t134 * t97;
  t227 = 0.2e1 * t60 * t224 * t78;
  t231 = -0.140076015625e1 * t211 - 0.6403475e0 * t213 - 0.6612e-1 * t20;
  t233 = t60 * t62 * t231;
  tv2rhosigma1 = t219 - 0.5e1 / 0.6e1 * t115 * t221 - t227 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t234 = t201 * t84;
  tv2rhosigma3 = t200 - 0.5e1 / 0.6e1 * t115 * t234 - t208 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t237 = t220 * t84;
  tv2rhosigma4 = t219 - 0.5e1 / 0.6e1 * t115 * t237 - t227 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t240 = t93 * t93;
  t244 = 0.1e1 / t15;
  t245 = t139 * t244;
  t246 = t245 * t65;
  t248 = 0.1e1 / t17;
  t249 = t67 * t248;
  t250 = t249 * t24;
  t252 = 0.262642529296875e0 * t246 - 0.12006515625e0 * t250;
  tv2sigma20 = -0.2e1 * t60 * t134 * t240 + t60 * t62 * t252;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t260 = 0.52528505859375e0 * t246 - 0.2401303125e0 * t250;
  tv2sigma21 = -0.2e1 * t60 * t224 * t93 + t60 * t62 * t260;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  t263 = t97 * t97;
  t269 = 0.10505701171875e1 * t246 - 0.480260625e0 * t250;
  tv2sigma23 = -0.2e1 * t60 * t134 * t263 + t60 * t62 * t269;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t7, t8;
  double t9, t10, t12, t13, t15, t16, t17, t18;
  double t19, t20, t22, t24, t25, t26, t27, t28;
  double t31, t32, t35, t37, t38, t39, t40, t45;
  double t46, tzk0;

  double t48, t49, t50, t51, t52, t53, t55, t56;
  double t60, t61, t62, t63, t65, t67, t68, t70;
  double t78, t80, tvrho0, t81, t83, t84, tvrho1, t88;
  double t89, t90, t93, tvsigma0, t97, tvsigma1, tvsigma2;

  double t99, t100, t101, t103, t105, t107, t108, t109;
  double t110, t111, t115, t116, t117, t119, t120, t124;
  double t126, t128, t129, t134, t135, t138, t139, t140;
  double t142, t146, t149, t150, t156, t158, tv2rho20, t160;
  double t161, t163, t164, t165, t168, t169, t171, t172;
  double t173, t176, t177, t178, tv2rho21, t184, t193, t195;
  double t196, tv2rho22, t200, t201, t202, t205, t208, t210;
  double t211, t213, t216, t218, tv2rhosigma0, t219, t220, t221;
  double t224, t227, t231, t233, tv2rhosigma1, tv2rhosigma2, t234, tv2rhosigma3;
  double t237, tv2rhosigma4, tv2rhosigma5, t240, t244, t245, t246, t248;
  double t249, t250, t252, tv2sigma20, t260, tv2sigma21, tv2sigma22, t263;
  double t269, tv2sigma23, tv2sigma24, tv2sigma25;

  double t272, t273, t275, t276, t277, t279, t281, t282;
  double t283, t284, t288, t292, t295, t296, t302, t304;
  double t305, t306, t308, t309, t311, t313, t314, t315;
  double t316, t317, t321, t323, t325, t326, t330, t331;
  double t332, t335, t339, t340, t341, t342, t344, t348;
  double t349, t352, t353, t355, t356, t358, t359, t364;
  double t368, t369, t370, t371, t373, t374, tv3rho30, t376;
  double t379, t381, t382, t383, t384, t386, t387, t392;
  double t394, t398, t399, t402, t403, t404, t406, t407;
  double t415, t416, t419, t422, t423, t424, t427, t429;
  double t430, t431, t433, t434, t437, t440, t441, t443;
  double t444, t446, t447, tv3rho31, t448, t450, t451, t457;
  double t458, t460, t461, t463, t464, t467, t468, t469;
  double t471, t472, t475, t478, t479, t482, t483, t485;
  double t486, t489, t492, t493, t495, t496, t499, t500;
  double t506, tv3rho32, t511, t516, t518, t519, t530, t536;
  double tv3rho33, t540, t542, t544, t546, t547, t548, t551;
  double t552, t554, t555, t556, t558, t559, t562, t568;
  double t569, t572, t575, t577, t579, t581, t584, t586;
  double tv3rho2sigma0, t587, t589, t591, t593, t594, t595, t599;
  double t601, t602, t603, t605, t606, t609, t612, t615;
  double t616, t619, t622, t627, t629, tv3rho2sigma1, tv3rho2sigma2, t631;
  double t633, t634, t637, t638, t639, t641, t642, t644;
  double t647, tv3rho2sigma3, t653, t659, t661, t662, t667, tv3rho2sigma4;
  double tv3rho2sigma5, t673, t678, t681, tv3rho2sigma6, t685, t690, t693;
  double tv3rho2sigma7, tv3rho2sigma8, t697, t698, t699, t702, t705, t708;
  double t709, t710, t711, t714, t717, t718, t719, t721;
  double t723, t725, t727, tv3rhosigma20, t728, t730, t734, t735;
  double t737, t740, t743, t744, t745, t746, t749, t752;
  double t756, t758, tv3rhosigma21, tv3rhosigma22, t760, t761, t762, t765;
  double t768, t771, t772, t773, t774, t777, t780, t784;
  double t786, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, t787, t790, tv3rhosigma26, t796;
  double tv3rhosigma27, tv3rhosigma28, t799, t802, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, t805;
  double t813, t815, t816, t817, t818, t821, t822, t823;
  double t825, tv3sigma30, t840, tv3sigma31, tv3sigma32, t855, tv3sigma33, tv3sigma34;
  double tv3sigma35, t858, t868, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39;


  t1 = rho[0] - rho[1];
  t2 = rho[0] + rho[1];
  t3 = 0.1e1 / t2;
  t4 = t1 * t3;
  t5 = 0.e0 < t4;
  t6 = my_piecewise3(t5, t4, -t4);
  t7 = 0.1e-9 < t6;
  t8 = my_piecewise3(t7, t6, 0.1e-9);
  t9 = POW_1_3(t8);
  t10 = t9 * t9;
  t12 = -t10 * t8 + 0.1e1;
  t13 = sqrt(t12);
  t15 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t16 = sqrt(t15);
  t17 = t16 * t15;
  t18 = t2 * t2;
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t22 = POW_1_3(t2);
  t24 = 0.1e1 / t22 / t2;
  t25 = t16 * t24;
  t26 = pow(t25, 0.1e1 / 0.16e2);
  t27 = t26 * t26;
  t28 = t27 * t26;
  t31 = t18 * t2;
  t32 = 0.1e1 / t31;
  t35 = M_CBRT3;
  t37 = POW_1_3(0.1e1 / M_PI);
  t38 = t35 * t37;
  t39 = M_CBRT4;
  t40 = t39 * t39;
  t45 = 0.118e2 + 0.15067e0 * t28 * t17 * t20 + 0.1102e-1 * t15 * t32 + t38 * t40 / t22 / 0.4e1;
  t46 = 0.1e1 / t45;
  tzk0 = -t13 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = 0.1e1 / t13;
  t49 = t2 * t48;
  t50 = t46 * t10;
  t51 = 0.1e1 / t18;
  t52 = t1 * t51;
  t53 = t3 - t52;
  t55 = my_piecewise3(t5, t53, -t53);
  t56 = my_piecewise3(t7, t55, 0);
  t60 = t2 * t13;
  t61 = t45 * t45;
  t62 = 0.1e1 / t61;
  t63 = t22 * t22;
  t65 = 0.1e1 / t63 / t18;
  t67 = t28 * t15 * t65;
  t68 = t67 * t16;
  t70 = 0.1e1 / t22 / t18;
  t78 = -0.6403475e0 * t68 * t70 - 0.3306e-1 * t15 * t20 - t38 * t40 * t24 / 0.12e2;
  t80 = t60 * t62 * t78;
  tvrho0 = tzk0 + 0.5e1 / 0.6e1 * t49 * t50 * t56 + t80;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t81 = -t3 - t52;
  t83 = my_piecewise3(t5, t81, -t81);
  t84 = my_piecewise3(t7, t83, 0);
  tvrho1 = tzk0 + 0.5e1 / 0.6e1 * t49 * t50 * t84 + t80;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t88 = 0.1e1 / t16;
  t89 = t67 * t88;
  t90 = t89 * t24;
  t93 = 0.2401303125e0 * t90 + 0.1102e-1 * t32;
  tvsigma0 = t60 * t62 * t93;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t97 = 0.480260625e0 * t90 + 0.2204e-1 * t32;
  tvsigma1 = t60 * t62 * t97;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t99 = t48 * t46;
  t100 = t10 * t56;
  t101 = t99 * t100;
  t103 = t13 * t62;
  t105 = 0.2e1 * t103 * t78;
  t107 = 0.1e1 / t13 / t12;
  t108 = t2 * t107;
  t109 = t9 * t8;
  t110 = t46 * t109;
  t111 = t56 * t56;
  t115 = t49 * t62;
  t116 = t100 * t78;
  t117 = t115 * t116;
  t119 = 0.1e1 / t9;
  t120 = t46 * t119;
  t124 = t1 * t32;
  t126 = -0.2e1 * t51 + 0.2e1 * t124;
  t128 = my_piecewise3(t5, t126, -t126);
  t129 = my_piecewise3(t7, t128, 0);
  t134 = 0.1e1 / t61 / t45;
  t135 = t78 * t78;
  t138 = 0.2e1 * t60 * t134 * t135;
  t139 = t28 * t25;
  t140 = t139 * t15;
  t142 = 0.1e1 / t63 / t19;
  t146 = 0.1e1 / t22 / t31;
  t149 = t19 * t2;
  t150 = 0.1e1 / t149;
  t156 = 0.18676802083333333333e1 * t140 * t142 + 0.14941441666666666667e1 * t68 * t146 + 0.13224e0 * t15 * t150 + t38 * t40 * t70 / 0.9e1;
  t158 = t60 * t62 * t156;
  tv2rho20 = 0.5e1 / 0.3e1 * t101 + t105 + 0.25e2 / 0.36e2 * t108 * t110 * t111 - 0.5e1 / 0.3e1 * t117 + 0.5e1 / 0.9e1 * t49 * t120 * t111 + 0.5e1 / 0.6e1 * t49 * t50 * t129 - t138 + t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t160 = t10 * t84;
  t161 = t99 * t160;
  t163 = t108 * t46;
  t164 = t109 * t84;
  t165 = t164 * t56;
  t168 = t160 * t78;
  t169 = t115 * t168;
  t171 = t49 * t46;
  t172 = t119 * t84;
  t173 = t172 * t56;
  t176 = 0.2e1 * t124;
  t177 = my_piecewise3(t5, t176, -t176);
  t178 = my_piecewise3(t7, t177, 0);
  tv2rho21 = 0.5e1 / 0.6e1 * t101 + t105 + 0.5e1 / 0.6e1 * t161 + 0.25e2 / 0.36e2 * t163 * t165 - 0.5e1 / 0.6e1 * t169 + 0.5e1 / 0.9e1 * t171 * t173 + 0.5e1 / 0.6e1 * t49 * t50 * t178 - 0.5e1 / 0.6e1 * t117 - t138 + t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t184 = t84 * t84;
  t193 = 0.2e1 * t51 + 0.2e1 * t124;
  t195 = my_piecewise3(t5, t193, -t193);
  t196 = my_piecewise3(t7, t195, 0);
  tv2rho22 = 0.5e1 / 0.3e1 * t161 + t105 + 0.25e2 / 0.36e2 * t108 * t110 * t184 - 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.9e1 * t49 * t120 * t184 + 0.5e1 / 0.6e1 * t49 * t50 * t196 - t138 + t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t200 = t103 * t93;
  t201 = t93 * t10;
  t202 = t201 * t56;
  t205 = t134 * t93;
  t208 = 0.2e1 * t60 * t205 * t78;
  t210 = 0.1e1 / t63 / t31;
  t211 = t139 * t210;
  t213 = t89 * t70;
  t216 = -0.700380078125e0 * t211 - 0.32017375e0 * t213 - 0.3306e-1 * t20;
  t218 = t60 * t62 * t216;
  tv2rhosigma0 = t200 - 0.5e1 / 0.6e1 * t115 * t202 - t208 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t219 = t103 * t97;
  t220 = t97 * t10;
  t221 = t220 * t56;
  t224 = t134 * t97;
  t227 = 0.2e1 * t60 * t224 * t78;
  t231 = -0.140076015625e1 * t211 - 0.6403475e0 * t213 - 0.6612e-1 * t20;
  t233 = t60 * t62 * t231;
  tv2rhosigma1 = t219 - 0.5e1 / 0.6e1 * t115 * t221 - t227 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t234 = t201 * t84;
  tv2rhosigma3 = t200 - 0.5e1 / 0.6e1 * t115 * t234 - t208 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t237 = t220 * t84;
  tv2rhosigma4 = t219 - 0.5e1 / 0.6e1 * t115 * t237 - t227 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t240 = t93 * t93;
  t244 = 0.1e1 / t15;
  t245 = t139 * t244;
  t246 = t245 * t65;
  t248 = 0.1e1 / t17;
  t249 = t67 * t248;
  t250 = t249 * t24;
  t252 = 0.262642529296875e0 * t246 - 0.12006515625e0 * t250;
  tv2sigma20 = -0.2e1 * t60 * t134 * t240 + t60 * t62 * t252;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t260 = 0.52528505859375e0 * t246 - 0.2401303125e0 * t250;
  tv2sigma21 = -0.2e1 * t60 * t224 * t93 + t60 * t62 * t260;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  t263 = t97 * t97;
  t269 = 0.10505701171875e1 * t246 - 0.480260625e0 * t250;
  tv2sigma23 = -0.2e1 * t60 * t134 * t263 + t60 * t62 * t269;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t272 = t10 * t129;
  t273 = t99 * t272;
  t275 = t107 * t46;
  t276 = t109 * t111;
  t277 = t275 * t276;
  t279 = t13 * t134;
  t281 = 0.6e1 * t279 * t135;
  t282 = t28 * t17;
  t283 = t19 * t31;
  t284 = 0.1e1 / t283;
  t288 = 0.1e1 / t63 / t149;
  t292 = 0.1e1 / t22 / t19;
  t295 = t19 * t18;
  t296 = 0.1e1 / t295;
  t302 = -0.29571603298611111111e1 * t282 * t284 - 0.13073761458333333333e2 * t140 * t288 - 0.49804805555555555557e1 * t68 * t292 - 0.6612e0 * t15 * t296 - 0.7e1 / 0.27e2 * t38 * t40 * t146;
  t304 = t60 * t62 * t302;
  t305 = t48 * t62;
  t306 = t305 * t116;
  t308 = t119 * t111;
  t309 = t99 * t308;
  t311 = t12 * t12;
  t313 = 0.1e1 / t13 / t311;
  t314 = t2 * t313;
  t315 = t8 * t8;
  t316 = t46 * t315;
  t317 = t111 * t56;
  t321 = t1 * t20;
  t323 = 0.6e1 * t32 - 0.6e1 * t321;
  t325 = my_piecewise3(t5, t323, -t323);
  t326 = my_piecewise3(t7, t325, 0);
  t330 = t61 * t61;
  t331 = 0.1e1 / t330;
  t332 = t135 * t78;
  t335 = 0.6e1 * t60 * t331 * t332;
  t339 = 0.6e1 * t60 * t134 * t78 * t156;
  t340 = t108 * t62;
  t341 = t276 * t78;
  t342 = t340 * t341;
  t344 = t46 * t9;
  t348 = t109 * t56;
  t349 = t348 * t129;
  t352 = t272 * t78;
  t353 = t115 * t352;
  t355 = t100 * t156;
  t356 = t115 * t355;
  t358 = 0.1e1 / t109;
  t359 = t46 * t358;
  t364 = t119 * t56 * t129;
  t368 = 0.3e1 * t103 * t156;
  t369 = t49 * t134;
  t370 = t100 * t135;
  t371 = t369 * t370;
  t373 = t308 * t78;
  t374 = t115 * t373;
  tv3rho30 = 0.5e1 / 0.2e1 * t273 + 0.25e2 / 0.12e2 * t277 - t281 + t304 - 0.5e1 * t306 + 0.5e1 / 0.3e1 * t309 + 0.125e3 / 0.72e2 * t314 * t316 * t317 + 0.5e1 / 0.6e1 * t49 * t50 * t326 + t335 - t339 - 0.25e2 / 0.12e2 * t342 + 0.25e2 / 0.18e2 * t108 * t344 * t317 + 0.25e2 / 0.12e2 * t163 * t349 - 0.5e1 / 0.2e1 * t353 - 0.5e1 / 0.2e1 * t356 - 0.5e1 / 0.27e2 * t49 * t359 * t317 + 0.5e1 / 0.3e1 * t171 * t364 + t368 + 0.5e1 * t371 - 0.5e1 / 0.3e1 * t374;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t376 = t305 * t168;
  t379 = 0.1e2 / 0.9e1 * t99 * t173;
  t381 = 0.25e2 / 0.18e2 * t275 * t165;
  t382 = 0.2e1 * t32;
  t383 = 0.6e1 * t321;
  t384 = t382 - t383;
  t386 = my_piecewise3(t5, t384, -t384);
  t387 = my_piecewise3(t7, t386, 0);
  t392 = t10 * t178;
  t394 = 0.5e1 / 0.3e1 * t99 * t392;
  t398 = t9 * t84;
  t399 = t398 * t111;
  t402 = t368 - 0.5e1 / 0.3e1 * t376 + t379 + t381 + 0.5e1 / 0.6e1 * t49 * t50 * t387 - t339 - 0.1e2 / 0.3e1 * t306 - t281 + t394 + 0.5e1 / 0.6e1 * t273 + 0.25e2 / 0.36e2 * t277 + t304 + 0.5e1 / 0.9e1 * t309 + t335 + 0.25e2 / 0.18e2 * t163 * t399;
  t403 = t160 * t135;
  t404 = t369 * t403;
  t406 = t358 * t84;
  t407 = t406 * t111;
  t415 = t109 * t178;
  t416 = t415 * t56;
  t419 = t164 * t129;
  t422 = t314 * t46;
  t423 = t315 * t84;
  t424 = t423 * t111;
  t427 = t392 * t78;
  t429 = 0.5e1 / 0.3e1 * t115 * t427;
  t430 = t160 * t156;
  t431 = t115 * t430;
  t433 = t119 * t178;
  t434 = t433 * t56;
  t437 = t172 * t129;
  t440 = t56 * t78;
  t441 = t164 * t440;
  t443 = 0.25e2 / 0.18e2 * t340 * t441;
  t444 = t172 * t440;
  t446 = 0.1e2 / 0.9e1 * t115 * t444;
  t447 = 0.5e1 / 0.3e1 * t404 - 0.5e1 / 0.27e2 * t171 * t407 - 0.25e2 / 0.36e2 * t342 - 0.5e1 / 0.6e1 * t353 - 0.5e1 / 0.3e1 * t356 + 0.1e2 / 0.3e1 * t371 - 0.5e1 / 0.9e1 * t374 + 0.25e2 / 0.18e2 * t163 * t416 + 0.25e2 / 0.36e2 * t163 * t419 + 0.125e3 / 0.72e2 * t422 * t424 - t429 - 0.5e1 / 0.6e1 * t431 + 0.1e2 / 0.9e1 * t171 * t434 + 0.5e1 / 0.9e1 * t171 * t437 - t443 - t446;
  tv3rho31 = t402 + t447;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t448 = -t382 - t383;
  t450 = my_piecewise3(t5, t448, -t448);
  t451 = my_piecewise3(t7, t450, 0);
  t457 = t109 * t184;
  t458 = t275 * t457;
  t460 = t119 * t184;
  t461 = t99 * t460;
  t463 = t10 * t196;
  t464 = t99 * t463;
  t467 = t368 + 0.5e1 / 0.6e1 * t49 * t50 * t451 - 0.1e2 / 0.3e1 * t376 + t379 + t381 - t339 - 0.5e1 / 0.3e1 * t306 - t281 + 0.25e2 / 0.36e2 * t458 + 0.5e1 / 0.9e1 * t461 + 0.5e1 / 0.6e1 * t464 + t394 + t304 + t335 + 0.1e2 / 0.3e1 * t404;
  t468 = t457 * t78;
  t469 = t340 * t468;
  t471 = t9 * t184;
  t472 = t471 * t56;
  t475 = t164 * t178;
  t478 = t315 * t184;
  t479 = t478 * t56;
  t482 = t460 * t78;
  t483 = t115 * t482;
  t485 = t358 * t184;
  t486 = t485 * t56;
  t489 = t172 * t178;
  t492 = t463 * t78;
  t493 = t115 * t492;
  t495 = t119 * t196;
  t496 = t495 * t56;
  t499 = t109 * t196;
  t500 = t499 * t56;
  t506 = -0.25e2 / 0.36e2 * t469 + 0.25e2 / 0.18e2 * t163 * t472 + 0.25e2 / 0.18e2 * t163 * t475 + 0.125e3 / 0.72e2 * t422 * t479 - 0.5e1 / 0.9e1 * t483 - 0.5e1 / 0.27e2 * t171 * t486 + 0.1e2 / 0.9e1 * t171 * t489 - 0.5e1 / 0.6e1 * t493 + 0.5e1 / 0.9e1 * t171 * t496 + 0.25e2 / 0.36e2 * t163 * t500 - 0.5e1 / 0.6e1 * t356 + 0.5e1 / 0.3e1 * t371 - t429 - 0.5e1 / 0.3e1 * t431 - t443 - t446;
  tv3rho32 = t467 + t506;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t511 = t184 * t84;
  t516 = -0.6e1 * t32 - 0.6e1 * t321;
  t518 = my_piecewise3(t5, t516, -t516);
  t519 = my_piecewise3(t7, t518, 0);
  t530 = t164 * t196;
  t536 = t172 * t196;
  tv3rho33 = -t281 + t304 + t335 - t339 - 0.5e1 * t376 + 0.25e2 / 0.12e2 * t458 + 0.5e1 / 0.3e1 * t461 + 0.5e1 / 0.2e1 * t464 + 0.125e3 / 0.72e2 * t314 * t316 * t511 + 0.5e1 / 0.6e1 * t49 * t50 * t519 - 0.5e1 / 0.2e1 * t431 - 0.25e2 / 0.12e2 * t469 - 0.5e1 / 0.3e1 * t483 - 0.5e1 / 0.2e1 * t493 + 0.25e2 / 0.18e2 * t108 * t344 * t511 + 0.25e2 / 0.12e2 * t163 * t530 - 0.5e1 / 0.27e2 * t49 * t359 * t511 + 0.5e1 / 0.3e1 * t171 * t536 + t368 + 0.5e1 * t404;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t540 = t305 * t202;
  t542 = t93 * t78;
  t544 = 0.4e1 * t279 * t542;
  t546 = 0.2e1 * t103 * t216;
  t547 = t93 * t109;
  t548 = t547 * t111;
  t551 = t201 * t440;
  t552 = t369 * t551;
  t554 = t216 * t10;
  t555 = t554 * t56;
  t556 = t115 * t555;
  t558 = t93 * t119;
  t559 = t558 * t111;
  t562 = t201 * t129;
  t568 = 0.6e1 * t60 * t331 * t93 * t135;
  t569 = t134 * t216;
  t572 = 0.4e1 * t60 * t569 * t78;
  t575 = 0.2e1 * t60 * t205 * t156;
  t577 = t28 * t296 * t16;
  t579 = t139 * t142;
  t581 = t89 * t146;
  t584 = 0.11089351236979166667e1 * t577 + 0.3501900390625e1 * t579 + 0.74707208333333333333e0 * t581 + 0.13224e0 * t150;
  t586 = t60 * t62 * t584;
  tv3rho2sigma0 = -0.5e1 / 0.3e1 * t540 - t544 + t546 - 0.25e2 / 0.36e2 * t340 * t548 + 0.1e2 / 0.3e1 * t552 - 0.5e1 / 0.3e1 * t556 - 0.5e1 / 0.9e1 * t115 * t559 - 0.5e1 / 0.6e1 * t115 * t562 + t568 - t572 - t575 + t586;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t587 = t305 * t221;
  t589 = t97 * t78;
  t591 = 0.4e1 * t279 * t589;
  t593 = 0.2e1 * t103 * t231;
  t594 = t97 * t109;
  t595 = t594 * t111;
  t599 = t369 * t220 * t440;
  t601 = t231 * t10;
  t602 = t601 * t56;
  t603 = t115 * t602;
  t605 = t97 * t119;
  t606 = t605 * t111;
  t609 = t220 * t129;
  t612 = t331 * t97;
  t615 = 0.6e1 * t60 * t612 * t135;
  t616 = t134 * t231;
  t619 = 0.4e1 * t60 * t616 * t78;
  t622 = 0.2e1 * t60 * t224 * t156;
  t627 = 0.22178702473958333333e1 * t577 + 0.700380078125e1 * t579 + 0.14941441666666666667e1 * t581 + 0.26448e0 * t150;
  t629 = t60 * t62 * t627;
  tv3rho2sigma1 = -0.5e1 / 0.3e1 * t587 - t591 + t593 - 0.25e2 / 0.36e2 * t340 * t595 + 0.1e2 / 0.3e1 * t599 - 0.5e1 / 0.3e1 * t603 - 0.5e1 / 0.9e1 * t115 * t606 - 0.5e1 / 0.6e1 * t115 * t609 + t615 - t619 - t622 + t629;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t631 = t305 * t234;
  t633 = t84 * t56;
  t634 = t547 * t633;
  t637 = t84 * t78;
  t638 = t201 * t637;
  t639 = t369 * t638;
  t641 = t554 * t84;
  t642 = t115 * t641;
  t644 = t558 * t633;
  t647 = t201 * t178;
  tv3rho2sigma3 = -0.5e1 / 0.6e1 * t540 - t544 + t546 - 0.5e1 / 0.6e1 * t631 - 0.25e2 / 0.36e2 * t340 * t634 + 0.5e1 / 0.3e1 * t639 - 0.5e1 / 0.6e1 * t642 - 0.5e1 / 0.9e1 * t115 * t644 - 0.5e1 / 0.6e1 * t115 * t647 + 0.5e1 / 0.3e1 * t552 + t568 - t572 - t575 - 0.5e1 / 0.6e1 * t556 + t586;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t653 = t305 * t237;
  t659 = t369 * t220 * t637;
  t661 = t601 * t84;
  t662 = t115 * t661;
  t667 = t220 * t178;
  tv3rho2sigma4 = -0.5e1 / 0.6e1 * t587 - t591 + t593 - 0.5e1 / 0.6e1 * t653 - 0.25e2 / 0.36e2 * t340 * t594 * t633 + 0.5e1 / 0.3e1 * t659 - 0.5e1 / 0.6e1 * t662 - 0.5e1 / 0.9e1 * t115 * t605 * t633 - 0.5e1 / 0.6e1 * t115 * t667 + 0.5e1 / 0.3e1 * t599 + t615 - t619 - t622 - 0.5e1 / 0.6e1 * t603 + t629;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t673 = t547 * t184;
  t678 = t558 * t184;
  t681 = t201 * t196;
  tv3rho2sigma6 = -0.5e1 / 0.3e1 * t631 - t544 + t546 - 0.25e2 / 0.36e2 * t340 * t673 + 0.1e2 / 0.3e1 * t639 - 0.5e1 / 0.3e1 * t642 - 0.5e1 / 0.9e1 * t115 * t678 - 0.5e1 / 0.6e1 * t115 * t681 + t568 - t572 - t575 + t586;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  t685 = t594 * t184;
  t690 = t605 * t184;
  t693 = t220 * t196;
  tv3rho2sigma7 = -0.5e1 / 0.3e1 * t653 - t591 + t593 - 0.25e2 / 0.36e2 * t340 * t685 + 0.1e2 / 0.3e1 * t659 - 0.5e1 / 0.3e1 * t662 - 0.5e1 / 0.9e1 * t115 * t690 - 0.5e1 / 0.6e1 * t115 * t693 + t615 - t619 - t622 + t629;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t697 = 0.2e1 * t279 * t240;
  t698 = t240 * t10;
  t699 = t698 * t56;
  t702 = t331 * t240;
  t705 = 0.6e1 * t60 * t702 * t78;
  t708 = 0.4e1 * t60 * t205 * t216;
  t709 = t103 * t252;
  t710 = t252 * t10;
  t711 = t710 * t56;
  t714 = t134 * t252;
  t717 = 0.2e1 * t60 * t714 * t78;
  t718 = t28 * t88;
  t719 = t718 * t150;
  t721 = t245 * t210;
  t723 = t249 * t70;
  t725 = -0.41585067138671875e0 * t719 - 0.3501900390625e0 * t721 + 0.160086875e0 * t723;
  t727 = t60 * t62 * t725;
  tv3rhosigma20 = -t697 + 0.5e1 / 0.3e1 * t369 * t699 + t705 - t708 + t709 - 0.5e1 / 0.6e1 * t115 * t711 - t717 + t727;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t728 = t97 * t93;
  t730 = 0.2e1 * t279 * t728;
  t734 = t60 * t331;
  t735 = t728 * t78;
  t737 = 0.6e1 * t734 * t735;
  t740 = 0.2e1 * t60 * t616 * t93;
  t743 = 0.2e1 * t60 * t224 * t216;
  t744 = t103 * t260;
  t745 = t260 * t10;
  t746 = t745 * t56;
  t749 = t134 * t260;
  t752 = 0.2e1 * t60 * t749 * t78;
  t756 = -0.8317013427734375e0 * t719 - 0.700380078125e0 * t721 + 0.32017375e0 * t723;
  t758 = t60 * t62 * t756;
  tv3rhosigma21 = -t730 + 0.5e1 / 0.3e1 * t369 * t728 * t100 + t737 - t740 - t743 + t744 - 0.5e1 / 0.6e1 * t115 * t746 - t752 + t758;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = tv3rhosigma20;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  t760 = 0.2e1 * t279 * t263;
  t761 = t263 * t10;
  t762 = t761 * t56;
  t765 = t331 * t263;
  t768 = 0.6e1 * t60 * t765 * t78;
  t771 = 0.4e1 * t60 * t224 * t231;
  t772 = t103 * t269;
  t773 = t269 * t10;
  t774 = t773 * t56;
  t777 = t134 * t269;
  t780 = 0.2e1 * t60 * t777 * t78;
  t784 = -0.1663402685546875e1 * t719 - 0.140076015625e1 * t721 + 0.6403475e0 * t723;
  t786 = t60 * t62 * t784;
  tv3rhosigma23 = -t760 + 0.5e1 / 0.3e1 * t369 * t762 + t768 - t771 + t772 - 0.5e1 / 0.6e1 * t115 * t774 - t780 + t786;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = tv3rhosigma21;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = tv3rhosigma22;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t787 = t698 * t84;
  t790 = t710 * t84;
  tv3rhosigma26 = -t697 + 0.5e1 / 0.3e1 * t369 * t787 + t705 - t708 + t709 - 0.5e1 / 0.6e1 * t115 * t790 - t717 + t727;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  t796 = t745 * t84;
  tv3rhosigma27 = -t730 + 0.5e1 / 0.3e1 * t369 * t728 * t160 + t737 - t740 - t743 + t744 - 0.5e1 / 0.6e1 * t115 * t796 - t752 + t758;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = tv3rhosigma26;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  t799 = t761 * t84;
  t802 = t773 * t84;
  tv3rhosigma29 = -t760 + 0.5e1 / 0.3e1 * t369 * t799 + t768 - t771 + t772 - 0.5e1 / 0.6e1 * t115 * t802 - t780 + t786;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = tv3rhosigma27;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = tv3rhosigma28;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t805 = t240 * t93;
  t813 = t28 * t248 * t20;
  t815 = t15 * t15;
  t816 = 0.1e1 / t815;
  t817 = t139 * t816;
  t818 = t817 * t65;
  t821 = 0.1e1 / t16 / t815;
  t822 = t67 * t821;
  t823 = t822 * t24;
  t825 = 0.15594400177001953125e0 * t813 - 0.3939637939453125e0 * t818 + 0.180097734375e0 * t823;
  tv3sigma30 = -0.6e1 * t60 * t205 * t252 + 0.6e1 * t60 * t331 * t805 + t60 * t62 * t825;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t840 = 0.3118880035400390625e0 * t813 - 0.787927587890625e0 * t818 + 0.36019546875e0 * t823;
  tv3sigma31 = -0.2e1 * t60 * t224 * t252 + 0.6e1 * t60 * t612 * t240 + t60 * t62 * t840 - 0.4e1 * t60 * t749 * t93;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = tv3sigma30;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  t855 = 0.623776007080078125e0 * t813 - 0.157585517578125e1 * t818 + 0.7203909375e0 * t823;
  tv3sigma33 = -0.4e1 * t60 * t224 * t260 + t60 * t62 * t855 + 0.6e1 * t60 * t765 * t93 - 0.2e1 * t60 * t777 * t93;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = tv3sigma31;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = tv3sigma32;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  t858 = t263 * t97;
  t868 = 0.124755201416015625e1 * t813 - 0.31517103515625e1 * t818 + 0.1440781875e1 * t823;
  tv3sigma36 = -0.6e1 * t60 * t224 * t269 + 0.6e1 * t60 * t331 * t858 + t60 * t62 * t868;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = tv3sigma33;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = tv3sigma34;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = tv3sigma35;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t6, t7, t8;
  double t9, t10, t12, t13, t15, t16, t17, t18;
  double t19, t20, t22, t24, t25, t26, t27, t28;
  double t31, t32, t35, t37, t38, t39, t40, t45;
  double t46, tzk0;

  double t48, t49, t50, t51, t52, t53, t55, t56;
  double t60, t61, t62, t63, t65, t67, t68, t70;
  double t78, t80, tvrho0, t81, t83, t84, tvrho1, t88;
  double t89, t90, t93, tvsigma0, t97, tvsigma1, tvsigma2;

  double t99, t100, t101, t103, t105, t107, t108, t109;
  double t110, t111, t115, t116, t117, t119, t120, t124;
  double t126, t128, t129, t134, t135, t138, t139, t140;
  double t142, t146, t149, t150, t156, t158, tv2rho20, t160;
  double t161, t163, t164, t165, t168, t169, t171, t172;
  double t173, t176, t177, t178, tv2rho21, t184, t193, t195;
  double t196, tv2rho22, t200, t201, t202, t205, t208, t210;
  double t211, t213, t216, t218, tv2rhosigma0, t219, t220, t221;
  double t224, t227, t231, t233, tv2rhosigma1, tv2rhosigma2, t234, tv2rhosigma3;
  double t237, tv2rhosigma4, tv2rhosigma5, t240, t244, t245, t246, t248;
  double t249, t250, t252, tv2sigma20, t260, tv2sigma21, tv2sigma22, t263;
  double t269, tv2sigma23, tv2sigma24, tv2sigma25;

  double t272, t273, t275, t276, t277, t279, t281, t282;
  double t283, t284, t288, t292, t295, t296, t302, t304;
  double t305, t306, t308, t309, t311, t313, t314, t315;
  double t316, t317, t321, t323, t325, t326, t330, t331;
  double t332, t335, t339, t340, t341, t342, t344, t348;
  double t349, t352, t353, t355, t356, t358, t359, t364;
  double t368, t369, t370, t371, t373, t374, tv3rho30, t376;
  double t379, t381, t382, t383, t384, t386, t387, t392;
  double t394, t398, t399, t402, t403, t404, t406, t407;
  double t415, t416, t419, t422, t423, t424, t427, t429;
  double t430, t431, t433, t434, t437, t440, t441, t443;
  double t444, t446, t447, tv3rho31, t448, t450, t451, t457;
  double t458, t460, t461, t463, t464, t467, t468, t469;
  double t471, t472, t475, t478, t479, t482, t483, t485;
  double t486, t489, t492, t493, t495, t496, t499, t500;
  double t506, tv3rho32, t511, t516, t518, t519, t530, t536;
  double tv3rho33, t540, t542, t544, t546, t547, t548, t551;
  double t552, t554, t555, t556, t558, t559, t562, t568;
  double t569, t572, t575, t577, t579, t581, t584, t586;
  double tv3rho2sigma0, t587, t589, t591, t593, t594, t595, t599;
  double t601, t602, t603, t605, t606, t609, t612, t615;
  double t616, t619, t622, t627, t629, tv3rho2sigma1, tv3rho2sigma2, t631;
  double t633, t634, t637, t638, t639, t641, t642, t644;
  double t647, tv3rho2sigma3, t653, t659, t661, t662, t667, tv3rho2sigma4;
  double tv3rho2sigma5, t673, t678, t681, tv3rho2sigma6, t685, t690, t693;
  double tv3rho2sigma7, tv3rho2sigma8, t697, t698, t699, t702, t705, t708;
  double t709, t710, t711, t714, t717, t718, t719, t721;
  double t723, t725, t727, tv3rhosigma20, t728, t730, t734, t735;
  double t737, t740, t743, t744, t745, t746, t749, t752;
  double t756, t758, tv3rhosigma21, tv3rhosigma22, t760, t761, t762, t765;
  double t768, t771, t772, t773, t774, t777, t780, t784;
  double t786, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, t787, t790, tv3rhosigma26, t796;
  double tv3rhosigma27, tv3rhosigma28, t799, t802, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, t805;
  double t813, t815, t816, t817, t818, t821, t822, t823;
  double t825, tv3sigma30, t840, tv3sigma31, tv3sigma32, t855, tv3sigma33, tv3sigma34;
  double tv3sigma35, t858, t868, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39;

  double t872, t873, t876, t877, t880, t881, t883, t885;
  double t887, t901, t911, t912, t913, t915, t916, t918;
  double t919, t921, t922, t923, t925, t927, t929, t931;
  double t933, t937, t939, t941, t942, t944, t946, t947;
  double t948, t952, t959, t960, t965, t966, t967, t971;
  double t973, t975, t976, t983, t984, t986, t990, t991;
  double t995, t1000, t1002, t1004, t1006, t1007, t1009, t1010;
  double t1014, t1016, t1018, t1025, t1031, t1036, t1039, t1042;
  double t1049, t1052, t1058, t1060, t1063, t1066, t1069, t1072;
  double t1074, tv4rho40, t1076, t1077, t1084, t1087, t1089, t1091;
  double t1092, t1094, t1095, t1097, t1099, t1103, t1105, t1106;
  double t1108, t1109, t1110, t1112, t1115, t1118, t1120, t1122;
  double t1131, t1136, t1138, t1140, t1142, t1144, t1146, t1147;
  double t1148, t1150, t1151, t1155, t1156, t1157, t1159, t1161;
  double t1163, t1165, t1179, t1186, t1205, t1206, t1212, t1225;
  double t1231, t1232, t1234, t1253, t1254, t1255, t1257, t1258;
  double t1259, tv4rho41, t1263, t1264, t1267, t1270, t1273, t1275;
  double t1277, t1280, t1282, t1286, t1291, t1294, t1307, t1314;
  double t1316, t1318, t1320, t1322, t1324, t1325, t1327, t1329;
  double t1331, t1333, t1335, t1336, t1340, t1352, t1365, t1367;
  double t1374, t1381, t1392, t1408, t1411, t1431, t1437, t1448;
  double t1462, tv4rho42, t1466, t1468, t1470, t1478, t1491, t1506;
  double t1509, t1511, t1526, t1528, t1530, t1534, t1538, t1540;
  double t1556, t1558, t1567, t1583, t1585, t1587, t1589, t1591;
  double t1593, t1595, t1597, t1598, t1602, tv4rho43, t1610, t1621;
  double t1644, t1650, t1654, t1671, t1673, t1674, t1678, tv4rho44;
  double t1681, t1687, t1690, t1693, t1696, t1699, t1705, t1709;
  double t1712, t1715, t1719, t1720, t1725, t1726, t1728, t1729;
  double t1731, t1733, t1737, t1739, t1742, t1749, t1750, t1751;
  double t1753, t1755, t1757, t1761, t1763, t1765, t1772, t1775;
  double t1777, t1779, t1784, t1787, t1790, t1793, t1794, tv4rho3sigma0;
  double t1799, t1802, t1805, t1811, t1814, t1817, t1821, t1824;
  double t1832, t1835, t1837, t1838, t1841, t1842, t1845, t1848;
  double t1849, t1852, t1853, t1855, t1857, t1859, t1862, t1863;
  double t1865, t1869, t1871, t1874, t1881, t1882, t1883, t1885;
  double t1887, t1889, t1893, t1895, t1897, t1901, tv4rho3sigma1, tv4rho3sigma2;
  double t1902, t1904, t1908, t1909, t1913, t1915, t1923, t1929;
  double t1940, t1942, t1945, t1954, t1957, t1958, t1964, t1967;
  double t1970, t1975, t1979, t1983, t1987, t1990, t1991, tv4rho3sigma3;
  double t1997, t2004, t2015, t2019, t2021, t2025, t2029, t2039;
  double t2041, t2042, t2044, t2045, t2047, t2050, t2054, t2061;
  double t2065, t2068, t2070, t2074, t2078, tv4rho3sigma4, tv4rho3sigma5, t2080;
  double t2082, t2084, t2088, t2096, t2105, t2114, t2120, t2122;
  double t2124, t2126, t2132, t2136, t2139, t2145, t2147, tv4rho3sigma6;
  double t2153, t2162, t2174, t2180, t2186, t2188, t2190, t2192;
  double t2196, t2202, t2205, t2211, t2213, tv4rho3sigma7, tv4rho3sigma8, t2215;
  double t2231, t2250, tv4rho3sigma9, t2267, t2285, tv4rho3sigma10, tv4rho3sigma11, t2288;
  double t2290, t2292, t2294, t2298, t2301, t2304, t2307, t2308;
  double t2311, t2313, t2317, t2320, t2323, t2324, t2329, t2332;
  double t2333, t2334, t2338, t2342, t2346, t2349, t2350, t2352;
  double t2357, t2364, t2370, t2371, t2375, t2379, tv4rho2sigma20, t2386;
  double t2387, t2389, t2392, t2393, t2395, t2397, t2400, t2403;
  double t2415, t2416, t2417, t2419, t2422, t2425, t2426, t2429;
  double t2432, t2435, t2436, t2439, t2440, t2443, t2444, t2446;
  double t2451, t2455, t2459, t2462, t2465, t2466, t2470, t2473;
  double t2474, tv4rho2sigma21, tv4rho2sigma22, t2475, t2477, t2480, t2483, t2484;
  double t2487, t2488, t2491, t2492, t2496, t2499, t2501, t2503;
  double t2506, t2510, t2512, t2519, t2522, t2525, t2528, t2529;
  double t2532, t2536, t2542, t2543, t2545, t2550, t2554, t2558;
  double t2562, tv4rho2sigma23, tv4rho2sigma24, tv4rho2sigma25, t2566, t2568, t2572, t2575;
  double t2584, t2588, t2597, t2605, tv4rho2sigma26, t2609, t2616, t2618;
  double t2622, t2625, t2631, t2634, t2640, t2648, tv4rho2sigma27, tv4rho2sigma28;
  double t2649, t2651, t2658, t2661, t2670, t2674, t2683, t2691;
  double tv4rho2sigma29, tv4rho2sigma210, tv4rho2sigma211, t2694, t2717, tv4rho2sigma212, t2720, t2744;
  double tv4rho2sigma213, tv4rho2sigma214, t2759, t2770, tv4rho2sigma215, tv4rho2sigma216, tv4rho2sigma217, t2772;
  double t2773, t2780, t2783, t2784, t2786, t2792, t2795, t2798;
  double t2799, t2800, t2807, t2811, t2813, t2815, t2819, tv4rhosigma30;
  double t2820, t2822, t2828, t2831, t2834, t2835, t2837, t2843;
  double t2846, t2849, t2850, t2852, t2858, t2861, t2864, t2865;
  double t2866, t2870, t2873, t2879, tv4rhosigma31, tv4rhosigma32, t2880, t2882;
  double t2888, t2891, t2894, t2895, t2897, t2903, t2906, t2909;
  double t2910, t2912, t2918, t2921, t2924, t2925, t2926, t2930;
  double t2933, t2939, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, t2941, t2942, t2946;
  double t2949, t2952, t2953, t2955, t2961, t2964, t2967, t2968;
  double t2969, t2973, t2976, t2982, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, tv4rhosigma39;
  double tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317;
  double tv4rhosigma318, tv4rhosigma319, t3025, t3032, t3040, t3043, t3045, t3048;
  double t3053, tv4sigma40, tv4sigma41, tv4sigma42, t3092, tv4sigma43, tv4sigma44, tv4sigma45;
  double tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, t3140, t3147, tv4sigma410, tv4sigma411;
  double tv4sigma412, tv4sigma413, tv4sigma414;


  t1 = rho[0] - rho[1];
  t2 = rho[0] + rho[1];
  t3 = 0.1e1 / t2;
  t4 = t1 * t3;
  t5 = 0.e0 < t4;
  t6 = my_piecewise3(t5, t4, -t4);
  t7 = 0.1e-9 < t6;
  t8 = my_piecewise3(t7, t6, 0.1e-9);
  t9 = POW_1_3(t8);
  t10 = t9 * t9;
  t12 = -t10 * t8 + 0.1e1;
  t13 = sqrt(t12);
  t15 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t16 = sqrt(t15);
  t17 = t16 * t15;
  t18 = t2 * t2;
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t22 = POW_1_3(t2);
  t24 = 0.1e1 / t22 / t2;
  t25 = t16 * t24;
  t26 = pow(t25, 0.1e1 / 0.16e2);
  t27 = t26 * t26;
  t28 = t27 * t26;
  t31 = t18 * t2;
  t32 = 0.1e1 / t31;
  t35 = M_CBRT3;
  t37 = POW_1_3(0.1e1 / M_PI);
  t38 = t35 * t37;
  t39 = M_CBRT4;
  t40 = t39 * t39;
  t45 = 0.118e2 + 0.15067e0 * t28 * t17 * t20 + 0.1102e-1 * t15 * t32 + t38 * t40 / t22 / 0.4e1;
  t46 = 0.1e1 / t45;
  tzk0 = -t13 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = 0.1e1 / t13;
  t49 = t2 * t48;
  t50 = t46 * t10;
  t51 = 0.1e1 / t18;
  t52 = t1 * t51;
  t53 = t3 - t52;
  t55 = my_piecewise3(t5, t53, -t53);
  t56 = my_piecewise3(t7, t55, 0);
  t60 = t2 * t13;
  t61 = t45 * t45;
  t62 = 0.1e1 / t61;
  t63 = t22 * t22;
  t65 = 0.1e1 / t63 / t18;
  t67 = t28 * t15 * t65;
  t68 = t67 * t16;
  t70 = 0.1e1 / t22 / t18;
  t78 = -0.6403475e0 * t68 * t70 - 0.3306e-1 * t15 * t20 - t38 * t40 * t24 / 0.12e2;
  t80 = t60 * t62 * t78;
  tvrho0 = tzk0 + 0.5e1 / 0.6e1 * t49 * t50 * t56 + t80;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t81 = -t3 - t52;
  t83 = my_piecewise3(t5, t81, -t81);
  t84 = my_piecewise3(t7, t83, 0);
  tvrho1 = tzk0 + 0.5e1 / 0.6e1 * t49 * t50 * t84 + t80;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t88 = 0.1e1 / t16;
  t89 = t67 * t88;
  t90 = t89 * t24;
  t93 = 0.2401303125e0 * t90 + 0.1102e-1 * t32;
  tvsigma0 = t60 * t62 * t93;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t97 = 0.480260625e0 * t90 + 0.2204e-1 * t32;
  tvsigma1 = t60 * t62 * t97;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t99 = t48 * t46;
  t100 = t10 * t56;
  t101 = t99 * t100;
  t103 = t13 * t62;
  t105 = 0.2e1 * t103 * t78;
  t107 = 0.1e1 / t13 / t12;
  t108 = t2 * t107;
  t109 = t9 * t8;
  t110 = t46 * t109;
  t111 = t56 * t56;
  t115 = t49 * t62;
  t116 = t100 * t78;
  t117 = t115 * t116;
  t119 = 0.1e1 / t9;
  t120 = t46 * t119;
  t124 = t1 * t32;
  t126 = -0.2e1 * t51 + 0.2e1 * t124;
  t128 = my_piecewise3(t5, t126, -t126);
  t129 = my_piecewise3(t7, t128, 0);
  t134 = 0.1e1 / t61 / t45;
  t135 = t78 * t78;
  t138 = 0.2e1 * t60 * t134 * t135;
  t139 = t28 * t25;
  t140 = t139 * t15;
  t142 = 0.1e1 / t63 / t19;
  t146 = 0.1e1 / t22 / t31;
  t149 = t19 * t2;
  t150 = 0.1e1 / t149;
  t156 = 0.18676802083333333333e1 * t140 * t142 + 0.14941441666666666667e1 * t68 * t146 + 0.13224e0 * t15 * t150 + t38 * t40 * t70 / 0.9e1;
  t158 = t60 * t62 * t156;
  tv2rho20 = 0.5e1 / 0.3e1 * t101 + t105 + 0.25e2 / 0.36e2 * t108 * t110 * t111 - 0.5e1 / 0.3e1 * t117 + 0.5e1 / 0.9e1 * t49 * t120 * t111 + 0.5e1 / 0.6e1 * t49 * t50 * t129 - t138 + t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t160 = t10 * t84;
  t161 = t99 * t160;
  t163 = t108 * t46;
  t164 = t109 * t84;
  t165 = t164 * t56;
  t168 = t160 * t78;
  t169 = t115 * t168;
  t171 = t49 * t46;
  t172 = t119 * t84;
  t173 = t172 * t56;
  t176 = 0.2e1 * t124;
  t177 = my_piecewise3(t5, t176, -t176);
  t178 = my_piecewise3(t7, t177, 0);
  tv2rho21 = 0.5e1 / 0.6e1 * t101 + t105 + 0.5e1 / 0.6e1 * t161 + 0.25e2 / 0.36e2 * t163 * t165 - 0.5e1 / 0.6e1 * t169 + 0.5e1 / 0.9e1 * t171 * t173 + 0.5e1 / 0.6e1 * t49 * t50 * t178 - 0.5e1 / 0.6e1 * t117 - t138 + t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t184 = t84 * t84;
  t193 = 0.2e1 * t51 + 0.2e1 * t124;
  t195 = my_piecewise3(t5, t193, -t193);
  t196 = my_piecewise3(t7, t195, 0);
  tv2rho22 = 0.5e1 / 0.3e1 * t161 + t105 + 0.25e2 / 0.36e2 * t108 * t110 * t184 - 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.9e1 * t49 * t120 * t184 + 0.5e1 / 0.6e1 * t49 * t50 * t196 - t138 + t158;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t200 = t103 * t93;
  t201 = t93 * t10;
  t202 = t201 * t56;
  t205 = t134 * t93;
  t208 = 0.2e1 * t60 * t205 * t78;
  t210 = 0.1e1 / t63 / t31;
  t211 = t139 * t210;
  t213 = t89 * t70;
  t216 = -0.700380078125e0 * t211 - 0.32017375e0 * t213 - 0.3306e-1 * t20;
  t218 = t60 * t62 * t216;
  tv2rhosigma0 = t200 - 0.5e1 / 0.6e1 * t115 * t202 - t208 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t219 = t103 * t97;
  t220 = t97 * t10;
  t221 = t220 * t56;
  t224 = t134 * t97;
  t227 = 0.2e1 * t60 * t224 * t78;
  t231 = -0.140076015625e1 * t211 - 0.6403475e0 * t213 - 0.6612e-1 * t20;
  t233 = t60 * t62 * t231;
  tv2rhosigma1 = t219 - 0.5e1 / 0.6e1 * t115 * t221 - t227 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t234 = t201 * t84;
  tv2rhosigma3 = t200 - 0.5e1 / 0.6e1 * t115 * t234 - t208 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t237 = t220 * t84;
  tv2rhosigma4 = t219 - 0.5e1 / 0.6e1 * t115 * t237 - t227 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t240 = t93 * t93;
  t244 = 0.1e1 / t15;
  t245 = t139 * t244;
  t246 = t245 * t65;
  t248 = 0.1e1 / t17;
  t249 = t67 * t248;
  t250 = t249 * t24;
  t252 = 0.262642529296875e0 * t246 - 0.12006515625e0 * t250;
  tv2sigma20 = -0.2e1 * t60 * t134 * t240 + t60 * t62 * t252;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t260 = 0.52528505859375e0 * t246 - 0.2401303125e0 * t250;
  tv2sigma21 = -0.2e1 * t60 * t224 * t93 + t60 * t62 * t260;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  t263 = t97 * t97;
  t269 = 0.10505701171875e1 * t246 - 0.480260625e0 * t250;
  tv2sigma23 = -0.2e1 * t60 * t134 * t263 + t60 * t62 * t269;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t272 = t10 * t129;
  t273 = t99 * t272;
  t275 = t107 * t46;
  t276 = t109 * t111;
  t277 = t275 * t276;
  t279 = t13 * t134;
  t281 = 0.6e1 * t279 * t135;
  t282 = t28 * t17;
  t283 = t19 * t31;
  t284 = 0.1e1 / t283;
  t288 = 0.1e1 / t63 / t149;
  t292 = 0.1e1 / t22 / t19;
  t295 = t19 * t18;
  t296 = 0.1e1 / t295;
  t302 = -0.29571603298611111111e1 * t282 * t284 - 0.13073761458333333333e2 * t140 * t288 - 0.49804805555555555557e1 * t68 * t292 - 0.6612e0 * t15 * t296 - 0.7e1 / 0.27e2 * t38 * t40 * t146;
  t304 = t60 * t62 * t302;
  t305 = t48 * t62;
  t306 = t305 * t116;
  t308 = t119 * t111;
  t309 = t99 * t308;
  t311 = t12 * t12;
  t313 = 0.1e1 / t13 / t311;
  t314 = t2 * t313;
  t315 = t8 * t8;
  t316 = t46 * t315;
  t317 = t111 * t56;
  t321 = t1 * t20;
  t323 = 0.6e1 * t32 - 0.6e1 * t321;
  t325 = my_piecewise3(t5, t323, -t323);
  t326 = my_piecewise3(t7, t325, 0);
  t330 = t61 * t61;
  t331 = 0.1e1 / t330;
  t332 = t135 * t78;
  t335 = 0.6e1 * t60 * t331 * t332;
  t339 = 0.6e1 * t60 * t134 * t78 * t156;
  t340 = t108 * t62;
  t341 = t276 * t78;
  t342 = t340 * t341;
  t344 = t46 * t9;
  t348 = t109 * t56;
  t349 = t348 * t129;
  t352 = t272 * t78;
  t353 = t115 * t352;
  t355 = t100 * t156;
  t356 = t115 * t355;
  t358 = 0.1e1 / t109;
  t359 = t46 * t358;
  t364 = t119 * t56 * t129;
  t368 = 0.3e1 * t103 * t156;
  t369 = t49 * t134;
  t370 = t100 * t135;
  t371 = t369 * t370;
  t373 = t308 * t78;
  t374 = t115 * t373;
  tv3rho30 = 0.5e1 / 0.2e1 * t273 + 0.25e2 / 0.12e2 * t277 - t281 + t304 - 0.5e1 * t306 + 0.5e1 / 0.3e1 * t309 + 0.125e3 / 0.72e2 * t314 * t316 * t317 + 0.5e1 / 0.6e1 * t49 * t50 * t326 + t335 - t339 - 0.25e2 / 0.12e2 * t342 + 0.25e2 / 0.18e2 * t108 * t344 * t317 + 0.25e2 / 0.12e2 * t163 * t349 - 0.5e1 / 0.2e1 * t353 - 0.5e1 / 0.2e1 * t356 - 0.5e1 / 0.27e2 * t49 * t359 * t317 + 0.5e1 / 0.3e1 * t171 * t364 + t368 + 0.5e1 * t371 - 0.5e1 / 0.3e1 * t374;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t376 = t305 * t168;
  t379 = 0.1e2 / 0.9e1 * t99 * t173;
  t381 = 0.25e2 / 0.18e2 * t275 * t165;
  t382 = 0.2e1 * t32;
  t383 = 0.6e1 * t321;
  t384 = t382 - t383;
  t386 = my_piecewise3(t5, t384, -t384);
  t387 = my_piecewise3(t7, t386, 0);
  t392 = t10 * t178;
  t394 = 0.5e1 / 0.3e1 * t99 * t392;
  t398 = t9 * t84;
  t399 = t398 * t111;
  t402 = t368 - 0.5e1 / 0.3e1 * t376 + t379 + t381 + 0.5e1 / 0.6e1 * t49 * t50 * t387 - t339 - 0.1e2 / 0.3e1 * t306 - t281 + t394 + 0.5e1 / 0.6e1 * t273 + 0.25e2 / 0.36e2 * t277 + t304 + 0.5e1 / 0.9e1 * t309 + t335 + 0.25e2 / 0.18e2 * t163 * t399;
  t403 = t160 * t135;
  t404 = t369 * t403;
  t406 = t358 * t84;
  t407 = t406 * t111;
  t415 = t109 * t178;
  t416 = t415 * t56;
  t419 = t164 * t129;
  t422 = t314 * t46;
  t423 = t315 * t84;
  t424 = t423 * t111;
  t427 = t392 * t78;
  t429 = 0.5e1 / 0.3e1 * t115 * t427;
  t430 = t160 * t156;
  t431 = t115 * t430;
  t433 = t119 * t178;
  t434 = t433 * t56;
  t437 = t172 * t129;
  t440 = t56 * t78;
  t441 = t164 * t440;
  t443 = 0.25e2 / 0.18e2 * t340 * t441;
  t444 = t172 * t440;
  t446 = 0.1e2 / 0.9e1 * t115 * t444;
  t447 = 0.5e1 / 0.3e1 * t404 - 0.5e1 / 0.27e2 * t171 * t407 - 0.25e2 / 0.36e2 * t342 - 0.5e1 / 0.6e1 * t353 - 0.5e1 / 0.3e1 * t356 + 0.1e2 / 0.3e1 * t371 - 0.5e1 / 0.9e1 * t374 + 0.25e2 / 0.18e2 * t163 * t416 + 0.25e2 / 0.36e2 * t163 * t419 + 0.125e3 / 0.72e2 * t422 * t424 - t429 - 0.5e1 / 0.6e1 * t431 + 0.1e2 / 0.9e1 * t171 * t434 + 0.5e1 / 0.9e1 * t171 * t437 - t443 - t446;
  tv3rho31 = t402 + t447;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t448 = -t382 - t383;
  t450 = my_piecewise3(t5, t448, -t448);
  t451 = my_piecewise3(t7, t450, 0);
  t457 = t109 * t184;
  t458 = t275 * t457;
  t460 = t119 * t184;
  t461 = t99 * t460;
  t463 = t10 * t196;
  t464 = t99 * t463;
  t467 = t368 + 0.5e1 / 0.6e1 * t49 * t50 * t451 - 0.1e2 / 0.3e1 * t376 + t379 + t381 - t339 - 0.5e1 / 0.3e1 * t306 - t281 + 0.25e2 / 0.36e2 * t458 + 0.5e1 / 0.9e1 * t461 + 0.5e1 / 0.6e1 * t464 + t394 + t304 + t335 + 0.1e2 / 0.3e1 * t404;
  t468 = t457 * t78;
  t469 = t340 * t468;
  t471 = t9 * t184;
  t472 = t471 * t56;
  t475 = t164 * t178;
  t478 = t315 * t184;
  t479 = t478 * t56;
  t482 = t460 * t78;
  t483 = t115 * t482;
  t485 = t358 * t184;
  t486 = t485 * t56;
  t489 = t172 * t178;
  t492 = t463 * t78;
  t493 = t115 * t492;
  t495 = t119 * t196;
  t496 = t495 * t56;
  t499 = t109 * t196;
  t500 = t499 * t56;
  t506 = -0.25e2 / 0.36e2 * t469 + 0.25e2 / 0.18e2 * t163 * t472 + 0.25e2 / 0.18e2 * t163 * t475 + 0.125e3 / 0.72e2 * t422 * t479 - 0.5e1 / 0.9e1 * t483 - 0.5e1 / 0.27e2 * t171 * t486 + 0.1e2 / 0.9e1 * t171 * t489 - 0.5e1 / 0.6e1 * t493 + 0.5e1 / 0.9e1 * t171 * t496 + 0.25e2 / 0.36e2 * t163 * t500 - 0.5e1 / 0.6e1 * t356 + 0.5e1 / 0.3e1 * t371 - t429 - 0.5e1 / 0.3e1 * t431 - t443 - t446;
  tv3rho32 = t467 + t506;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t511 = t184 * t84;
  t516 = -0.6e1 * t32 - 0.6e1 * t321;
  t518 = my_piecewise3(t5, t516, -t516);
  t519 = my_piecewise3(t7, t518, 0);
  t530 = t164 * t196;
  t536 = t172 * t196;
  tv3rho33 = -t281 + t304 + t335 - t339 - 0.5e1 * t376 + 0.25e2 / 0.12e2 * t458 + 0.5e1 / 0.3e1 * t461 + 0.5e1 / 0.2e1 * t464 + 0.125e3 / 0.72e2 * t314 * t316 * t511 + 0.5e1 / 0.6e1 * t49 * t50 * t519 - 0.5e1 / 0.2e1 * t431 - 0.25e2 / 0.12e2 * t469 - 0.5e1 / 0.3e1 * t483 - 0.5e1 / 0.2e1 * t493 + 0.25e2 / 0.18e2 * t108 * t344 * t511 + 0.25e2 / 0.12e2 * t163 * t530 - 0.5e1 / 0.27e2 * t49 * t359 * t511 + 0.5e1 / 0.3e1 * t171 * t536 + t368 + 0.5e1 * t404;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t540 = t305 * t202;
  t542 = t93 * t78;
  t544 = 0.4e1 * t279 * t542;
  t546 = 0.2e1 * t103 * t216;
  t547 = t93 * t109;
  t548 = t547 * t111;
  t551 = t201 * t440;
  t552 = t369 * t551;
  t554 = t216 * t10;
  t555 = t554 * t56;
  t556 = t115 * t555;
  t558 = t93 * t119;
  t559 = t558 * t111;
  t562 = t201 * t129;
  t568 = 0.6e1 * t60 * t331 * t93 * t135;
  t569 = t134 * t216;
  t572 = 0.4e1 * t60 * t569 * t78;
  t575 = 0.2e1 * t60 * t205 * t156;
  t577 = t28 * t296 * t16;
  t579 = t139 * t142;
  t581 = t89 * t146;
  t584 = 0.11089351236979166667e1 * t577 + 0.3501900390625e1 * t579 + 0.74707208333333333333e0 * t581 + 0.13224e0 * t150;
  t586 = t60 * t62 * t584;
  tv3rho2sigma0 = -0.5e1 / 0.3e1 * t540 - t544 + t546 - 0.25e2 / 0.36e2 * t340 * t548 + 0.1e2 / 0.3e1 * t552 - 0.5e1 / 0.3e1 * t556 - 0.5e1 / 0.9e1 * t115 * t559 - 0.5e1 / 0.6e1 * t115 * t562 + t568 - t572 - t575 + t586;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t587 = t305 * t221;
  t589 = t97 * t78;
  t591 = 0.4e1 * t279 * t589;
  t593 = 0.2e1 * t103 * t231;
  t594 = t97 * t109;
  t595 = t594 * t111;
  t599 = t369 * t220 * t440;
  t601 = t231 * t10;
  t602 = t601 * t56;
  t603 = t115 * t602;
  t605 = t97 * t119;
  t606 = t605 * t111;
  t609 = t220 * t129;
  t612 = t331 * t97;
  t615 = 0.6e1 * t60 * t612 * t135;
  t616 = t134 * t231;
  t619 = 0.4e1 * t60 * t616 * t78;
  t622 = 0.2e1 * t60 * t224 * t156;
  t627 = 0.22178702473958333333e1 * t577 + 0.700380078125e1 * t579 + 0.14941441666666666667e1 * t581 + 0.26448e0 * t150;
  t629 = t60 * t62 * t627;
  tv3rho2sigma1 = -0.5e1 / 0.3e1 * t587 - t591 + t593 - 0.25e2 / 0.36e2 * t340 * t595 + 0.1e2 / 0.3e1 * t599 - 0.5e1 / 0.3e1 * t603 - 0.5e1 / 0.9e1 * t115 * t606 - 0.5e1 / 0.6e1 * t115 * t609 + t615 - t619 - t622 + t629;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t631 = t305 * t234;
  t633 = t84 * t56;
  t634 = t547 * t633;
  t637 = t84 * t78;
  t638 = t201 * t637;
  t639 = t369 * t638;
  t641 = t554 * t84;
  t642 = t115 * t641;
  t644 = t558 * t633;
  t647 = t201 * t178;
  tv3rho2sigma3 = -0.5e1 / 0.6e1 * t540 - t544 + t546 - 0.5e1 / 0.6e1 * t631 - 0.25e2 / 0.36e2 * t340 * t634 + 0.5e1 / 0.3e1 * t639 - 0.5e1 / 0.6e1 * t642 - 0.5e1 / 0.9e1 * t115 * t644 - 0.5e1 / 0.6e1 * t115 * t647 + 0.5e1 / 0.3e1 * t552 + t568 - t572 - t575 - 0.5e1 / 0.6e1 * t556 + t586;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t653 = t305 * t237;
  t659 = t369 * t220 * t637;
  t661 = t601 * t84;
  t662 = t115 * t661;
  t667 = t220 * t178;
  tv3rho2sigma4 = -0.5e1 / 0.6e1 * t587 - t591 + t593 - 0.5e1 / 0.6e1 * t653 - 0.25e2 / 0.36e2 * t340 * t594 * t633 + 0.5e1 / 0.3e1 * t659 - 0.5e1 / 0.6e1 * t662 - 0.5e1 / 0.9e1 * t115 * t605 * t633 - 0.5e1 / 0.6e1 * t115 * t667 + 0.5e1 / 0.3e1 * t599 + t615 - t619 - t622 - 0.5e1 / 0.6e1 * t603 + t629;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t673 = t547 * t184;
  t678 = t558 * t184;
  t681 = t201 * t196;
  tv3rho2sigma6 = -0.5e1 / 0.3e1 * t631 - t544 + t546 - 0.25e2 / 0.36e2 * t340 * t673 + 0.1e2 / 0.3e1 * t639 - 0.5e1 / 0.3e1 * t642 - 0.5e1 / 0.9e1 * t115 * t678 - 0.5e1 / 0.6e1 * t115 * t681 + t568 - t572 - t575 + t586;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  t685 = t594 * t184;
  t690 = t605 * t184;
  t693 = t220 * t196;
  tv3rho2sigma7 = -0.5e1 / 0.3e1 * t653 - t591 + t593 - 0.25e2 / 0.36e2 * t340 * t685 + 0.1e2 / 0.3e1 * t659 - 0.5e1 / 0.3e1 * t662 - 0.5e1 / 0.9e1 * t115 * t690 - 0.5e1 / 0.6e1 * t115 * t693 + t615 - t619 - t622 + t629;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t697 = 0.2e1 * t279 * t240;
  t698 = t240 * t10;
  t699 = t698 * t56;
  t702 = t331 * t240;
  t705 = 0.6e1 * t60 * t702 * t78;
  t708 = 0.4e1 * t60 * t205 * t216;
  t709 = t103 * t252;
  t710 = t252 * t10;
  t711 = t710 * t56;
  t714 = t134 * t252;
  t717 = 0.2e1 * t60 * t714 * t78;
  t718 = t28 * t88;
  t719 = t718 * t150;
  t721 = t245 * t210;
  t723 = t249 * t70;
  t725 = -0.41585067138671875e0 * t719 - 0.3501900390625e0 * t721 + 0.160086875e0 * t723;
  t727 = t60 * t62 * t725;
  tv3rhosigma20 = -t697 + 0.5e1 / 0.3e1 * t369 * t699 + t705 - t708 + t709 - 0.5e1 / 0.6e1 * t115 * t711 - t717 + t727;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t728 = t97 * t93;
  t730 = 0.2e1 * t279 * t728;
  t734 = t60 * t331;
  t735 = t728 * t78;
  t737 = 0.6e1 * t734 * t735;
  t740 = 0.2e1 * t60 * t616 * t93;
  t743 = 0.2e1 * t60 * t224 * t216;
  t744 = t103 * t260;
  t745 = t260 * t10;
  t746 = t745 * t56;
  t749 = t134 * t260;
  t752 = 0.2e1 * t60 * t749 * t78;
  t756 = -0.8317013427734375e0 * t719 - 0.700380078125e0 * t721 + 0.32017375e0 * t723;
  t758 = t60 * t62 * t756;
  tv3rhosigma21 = -t730 + 0.5e1 / 0.3e1 * t369 * t728 * t100 + t737 - t740 - t743 + t744 - 0.5e1 / 0.6e1 * t115 * t746 - t752 + t758;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = tv3rhosigma20;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  t760 = 0.2e1 * t279 * t263;
  t761 = t263 * t10;
  t762 = t761 * t56;
  t765 = t331 * t263;
  t768 = 0.6e1 * t60 * t765 * t78;
  t771 = 0.4e1 * t60 * t224 * t231;
  t772 = t103 * t269;
  t773 = t269 * t10;
  t774 = t773 * t56;
  t777 = t134 * t269;
  t780 = 0.2e1 * t60 * t777 * t78;
  t784 = -0.1663402685546875e1 * t719 - 0.140076015625e1 * t721 + 0.6403475e0 * t723;
  t786 = t60 * t62 * t784;
  tv3rhosigma23 = -t760 + 0.5e1 / 0.3e1 * t369 * t762 + t768 - t771 + t772 - 0.5e1 / 0.6e1 * t115 * t774 - t780 + t786;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = tv3rhosigma21;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = tv3rhosigma22;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t787 = t698 * t84;
  t790 = t710 * t84;
  tv3rhosigma26 = -t697 + 0.5e1 / 0.3e1 * t369 * t787 + t705 - t708 + t709 - 0.5e1 / 0.6e1 * t115 * t790 - t717 + t727;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  t796 = t745 * t84;
  tv3rhosigma27 = -t730 + 0.5e1 / 0.3e1 * t369 * t728 * t160 + t737 - t740 - t743 + t744 - 0.5e1 / 0.6e1 * t115 * t796 - t752 + t758;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = tv3rhosigma26;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  t799 = t761 * t84;
  t802 = t773 * t84;
  tv3rhosigma29 = -t760 + 0.5e1 / 0.3e1 * t369 * t799 + t768 - t771 + t772 - 0.5e1 / 0.6e1 * t115 * t802 - t780 + t786;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = tv3rhosigma27;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = tv3rhosigma28;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t805 = t240 * t93;
  t813 = t28 * t248 * t20;
  t815 = t15 * t15;
  t816 = 0.1e1 / t815;
  t817 = t139 * t816;
  t818 = t817 * t65;
  t821 = 0.1e1 / t16 / t815;
  t822 = t67 * t821;
  t823 = t822 * t24;
  t825 = 0.15594400177001953125e0 * t813 - 0.3939637939453125e0 * t818 + 0.180097734375e0 * t823;
  tv3sigma30 = -0.6e1 * t60 * t205 * t252 + 0.6e1 * t60 * t331 * t805 + t60 * t62 * t825;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t840 = 0.3118880035400390625e0 * t813 - 0.787927587890625e0 * t818 + 0.36019546875e0 * t823;
  tv3sigma31 = -0.2e1 * t60 * t224 * t252 + 0.6e1 * t60 * t612 * t240 + t60 * t62 * t840 - 0.4e1 * t60 * t749 * t93;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = tv3sigma30;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  t855 = 0.623776007080078125e0 * t813 - 0.157585517578125e1 * t818 + 0.7203909375e0 * t823;
  tv3sigma33 = -0.4e1 * t60 * t224 * t260 + t60 * t62 * t855 + 0.6e1 * t60 * t765 * t93 - 0.2e1 * t60 * t777 * t93;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = tv3sigma31;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = tv3sigma32;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  t858 = t263 * t97;
  t868 = 0.124755201416015625e1 * t813 - 0.31517103515625e1 * t818 + 0.1440781875e1 * t823;
  tv3sigma36 = -0.6e1 * t60 * t224 * t269 + 0.6e1 * t60 * t331 * t858 + t60 * t62 * t868;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = tv3sigma33;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = tv3sigma34;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = tv3sigma35;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t872 = 0.1e1 / t330 / t45;
  t873 = t135 * t135;
  t876 = 0.24e2 * t60 * t872 * t873;
  t877 = t156 * t156;
  t880 = 0.6e1 * t60 * t134 * t877;
  t881 = t27 * t27;
  t883 = t881 * t881;
  t885 = 0.1e1 / t883 / t881 / t26;
  t887 = t19 * t19;
  t901 = 0.1e1 / t22 / t149;
  t911 = t60 * t62 * (0.73929008246527777778e0 * t885 * t815 / t22 / t887 / t2 + 0.41400244618055555555e2 * t282 / t887 + 0.88611049884259259258e2 * t140 / t63 / t295 + 0.21582082407407407408e2 * t68 * t901 + 0.39672e1 * t15 * t284 + 0.7e2 / 0.81e2 * t38 * t40 * t292);
  t912 = t9 * t317;
  t913 = t275 * t912;
  t915 = t358 * t317;
  t916 = t99 * t915;
  t918 = t10 * t326;
  t919 = t99 * t918;
  t921 = t313 * t46;
  t922 = t315 * t317;
  t923 = t921 * t922;
  t925 = t78 * t156;
  t927 = 0.24e2 * t279 * t925;
  t929 = t369 * t925 * t100;
  t931 = t78 * t129;
  t933 = t340 * t348 * t931;
  t937 = t115 * t119 * t129 * t440;
  t939 = -t876 - t880 + t911 + 0.5e2 / 0.9e1 * t913 - 0.2e2 / 0.27e2 * t916 + 0.1e2 / 0.3e1 * t919 + 0.125e3 / 0.18e2 * t923 - t927 + 0.2e2 * t929 - 0.25e2 / 0.3e1 * t933 - 0.2e2 / 0.3e1 * t937;
  t941 = 0.4e1 * t103 * t302;
  t942 = t13 * t331;
  t944 = 0.24e2 * t942 * t332;
  t946 = 0.1e1 / t9 / t315;
  t947 = t46 * t946;
  t948 = t111 * t111;
  t952 = t129 * t129;
  t959 = 0.8e1 * t60 * t134 * t302 * t78;
  t960 = t305 * t355;
  t965 = t2 / t13 / t311 / t12;
  t966 = t10 * t315;
  t967 = t46 * t966;
  t971 = t1 * t150;
  t973 = -0.24e2 * t20 + 0.24e2 * t971;
  t975 = my_piecewise3(t5, t973, -t973);
  t976 = my_piecewise3(t7, t975, 0);
  t983 = 0.36e2 * t60 * t331 * t135 * t156;
  t984 = t305 * t373;
  t986 = t46 * t8;
  t990 = 0.1e1 / t10;
  t991 = t46 * t990;
  t995 = t941 + t944 + 0.2e2 / 0.81e2 * t49 * t947 * t948 + 0.5e1 / 0.3e1 * t49 * t120 * t952 - t959 - 0.1e2 * t960 + 0.3125e4 / 0.432e3 * t965 * t967 * t948 + 0.5e1 / 0.6e1 * t49 * t50 * t976 + t983 - 0.2e2 / 0.3e1 * t984 + 0.125e3 / 0.18e2 * t314 * t986 * t948 + 0.25e2 / 0.81e2 * t108 * t991 * t948;
  t1000 = t305 * t352;
  t1002 = t99 * t364;
  t1004 = t275 * t349;
  t1006 = t107 * t62;
  t1007 = t1006 * t341;
  t1009 = t48 * t134;
  t1010 = t1009 * t370;
  t1014 = t115 * t302 * t10 * t56;
  t1016 = t314 * t62;
  t1018 = t1016 * t922 * t78;
  t1025 = t115 * t918 * t78;
  t1031 = 0.25e2 / 0.12e2 * t108 * t110 * t952 - 0.1e2 * t1000 + 0.2e2 / 0.3e1 * t1002 + 0.25e2 / 0.3e1 * t1004 - 0.25e2 / 0.3e1 * t1007 + 0.2e2 * t1010 - 0.1e2 / 0.3e1 * t1014 - 0.125e3 / 0.18e2 * t1018 + 0.125e3 / 0.12e2 * t422 * t315 * t111 * t129 - 0.1e2 / 0.3e1 * t1025 + 0.2e2 / 0.9e1 * t171 * t119 * t326 * t56;
  t1036 = t49 * t331;
  t1039 = t1036 * t332 * t10 * t56;
  t1042 = t340 * t276 * t156;
  t1049 = t115 * t272 * t156;
  t1052 = t115 * t915 * t78;
  t1058 = t108 * t134;
  t1060 = t1058 * t276 * t135;
  t1063 = t340 * t912 * t78;
  t1066 = t369 * t272 * t135;
  t1069 = t115 * t308 * t156;
  t1072 = t369 * t308 * t135;
  t1074 = 0.25e2 / 0.9e1 * t163 * t109 * t326 * t56 - 0.2e2 * t1039 - 0.25e2 / 0.6e1 * t1042 + 0.25e2 / 0.3e1 * t163 * t9 * t111 * t129 - 0.5e1 * t1049 + 0.2e2 / 0.27e2 * t1052 - 0.1e2 / 0.9e1 * t171 * t358 * t111 * t129 + 0.25e2 / 0.3e1 * t1060 - 0.5e2 / 0.9e1 * t1063 + 0.1e2 * t1066 - 0.1e2 / 0.3e1 * t1069 + 0.2e2 / 0.3e1 * t1072;
  tv4rho40 = t939 + t995 + t1031 + t1074;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1076 = t10 * t387;
  t1077 = t99 * t1076;
  t1084 = t115 * t433 * t440;
  t1087 = t369 * t160 * t925;
  t1089 = t156 * t56;
  t1091 = t115 * t172 * t1089;
  t1092 = 0.5e1 / 0.3e1 * t1091;
  t1094 = t340 * t164 * t1089;
  t1095 = 0.25e2 / 0.12e2 * t1094;
  t1097 = t115 * t172 * t931;
  t1099 = t129 * t56;
  t1103 = t135 * t56;
  t1105 = t369 * t172 * t1103;
  t1106 = 0.1e2 / 0.3e1 * t1105;
  t1108 = t1058 * t164 * t1103;
  t1109 = 0.25e2 / 0.6e1 * t1108;
  t1110 = t111 * t78;
  t1112 = t340 * t398 * t1110;
  t1115 = t115 * t406 * t1110;
  t1118 = t340 * t415 * t440;
  t1120 = 0.5e1 / 0.2e1 * t1077 - t876 - t880 + t911 + 0.25e2 / 0.18e2 * t913 - 0.5e1 / 0.27e2 * t916 + 0.5e1 / 0.6e1 * t919 + 0.125e3 / 0.72e2 * t923 - t927 - 0.1e2 / 0.3e1 * t1084 + 0.5e1 * t1087 - t1092 - t1095 - 0.5e1 / 0.3e1 * t1097 - 0.5e1 / 0.9e1 * t171 * t406 * t1099 + t1106 + t1109 - 0.25e2 / 0.6e1 * t1112 + 0.5e1 / 0.9e1 * t1115 - 0.25e2 / 0.6e1 * t1118;
  t1122 = t340 * t164 * t931;
  t1131 = t1016 * t423 * t1110;
  t1136 = t305 * t430;
  t1138 = t99 * t437;
  t1140 = t275 * t399;
  t1142 = t275 * t419;
  t1144 = t921 * t424;
  t1146 = 0.12e2 * t20;
  t1147 = 0.24e2 * t971;
  t1148 = -t1146 + t1147;
  t1150 = my_piecewise3(t5, t1148, -t1148);
  t1151 = my_piecewise3(t7, t1150, 0);
  t1155 = t305 * t427;
  t1156 = 0.5e1 * t1155;
  t1157 = t99 * t434;
  t1159 = t275 * t416;
  t1161 = t1009 * t403;
  t1163 = t99 * t407;
  t1165 = -0.25e2 / 0.12e2 * t1122 + 0.25e2 / 0.6e1 * t163 * t398 * t1099 + 0.125e3 / 0.24e2 * t422 * t423 * t1099 - 0.125e3 / 0.24e2 * t1131 + 0.15e2 * t929 - 0.25e2 / 0.12e2 * t933 - 0.5e1 / 0.3e1 * t937 + t941 + t944 - 0.5e1 / 0.2e1 * t1136 + 0.5e1 / 0.3e1 * t1138 + 0.25e2 / 0.6e1 * t1140 + 0.25e2 / 0.12e2 * t1142 + 0.125e3 / 0.24e2 * t1144 + 0.5e1 / 0.6e1 * t49 * t50 * t1151 - t1156 + 0.1e2 / 0.3e1 * t1157 + 0.25e2 / 0.6e1 * t1159 + 0.5e1 * t1161 - 0.5e1 / 0.9e1 * t1163;
  t1179 = t1036 * t160 * t332;
  t1186 = t115 * t1076 * t78;
  t1205 = t369 * t392 * t135;
  t1206 = 0.5e1 * t1205;
  t1212 = -t959 - 0.15e2 / 0.2e1 * t960 + t983 - 0.1e2 / 0.3e1 * t984 - 0.5e1 * t1000 + 0.5e1 / 0.3e1 * t1002 + 0.25e2 / 0.12e2 * t1004 - 0.25e2 / 0.6e1 * t1007 + 0.15e2 * t1010 + 0.25e2 / 0.81e2 * t163 * t990 * t84 * t317 - 0.5e1 * t1179 + 0.2e2 / 0.81e2 * t171 * t946 * t84 * t317 - 0.5e1 / 0.2e1 * t1186 + 0.5e1 / 0.3e1 * t171 * t119 * t387 * t56 + 0.25e2 / 0.12e2 * t163 * t109 * t387 * t56 + 0.25e2 / 0.6e1 * t163 * t9 * t178 * t111 + 0.125e3 / 0.18e2 * t422 * t8 * t84 * t317 + t1206 - 0.5e1 / 0.9e1 * t171 * t358 * t178 * t111 - 0.5e1 / 0.2e1 * t1014;
  t1225 = t965 * t46;
  t1231 = t115 * t392 * t156;
  t1232 = 0.5e1 / 0.2e1 * t1231;
  t1234 = t115 * t160 * t302;
  t1253 = t637 * t56;
  t1254 = t305 * t119 * t1253;
  t1255 = 0.1e2 / 0.3e1 * t1254;
  t1257 = t1006 * t109 * t1253;
  t1258 = 0.25e2 / 0.6e1 * t1257;
  t1259 = 0.1e2 / 0.3e1 * t1072 + 0.3125e4 / 0.432e3 * t1225 * t966 * t84 * t317 - t1232 - 0.5e1 / 0.6e1 * t1234 + 0.5e1 / 0.3e1 * t171 * t433 * t129 + 0.5e1 / 0.9e1 * t171 * t172 * t326 + 0.25e2 / 0.12e2 * t163 * t415 * t129 + 0.125e3 / 0.24e2 * t422 * t315 * t178 * t111 + 0.25e2 / 0.36e2 * t163 * t164 * t326 - t1255 - t1258;
  tv4rho41 = t1120 + t1165 + t1212 - 0.125e3 / 0.72e2 * t1018 - 0.5e1 / 0.6e1 * t1025 - 0.15e2 * t1039 - 0.25e2 / 0.12e2 * t1042 - 0.5e1 / 0.2e1 * t1049 + 0.5e1 / 0.27e2 * t1052 + 0.25e2 / 0.6e1 * t1060 - 0.25e2 / 0.18e2 * t1063 + 0.5e1 * t1066 - 0.5e1 / 0.3e1 * t1069 + t1259;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1263 = t10 * t451;
  t1264 = t99 * t1263;
  t1267 = t115 * t495 * t440;
  t1270 = t340 * t499 * t440;
  t1273 = t340 * t471 * t440;
  t1275 = t78 * t178;
  t1277 = t340 * t164 * t1275;
  t1280 = t1016 * t478 * t440;
  t1282 = t56 * t178;
  t1286 = 0.5e1 / 0.3e1 * t1077 + 0.5e1 / 0.3e1 * t1264 - t876 - t880 + t911 - t927 - 0.1e2 / 0.9e1 * t1267 - 0.25e2 / 0.18e2 * t1270 - 0.25e2 / 0.9e1 * t1273 - 0.25e2 / 0.9e1 * t1277 - 0.125e3 / 0.36e2 * t1280 + 0.5e2 / 0.9e1 * t163 * t398 * t1282;
  t1291 = t115 * t485 * t440;
  t1294 = t115 * t172 * t1275;
  t1307 = 0.125e3 / 0.18e2 * t422 * t423 * t1282 + 0.1e2 / 0.27e2 * t1291 - 0.2e2 / 0.9e1 * t1294 - 0.2e2 / 0.27e2 * t171 * t406 * t1282 - 0.2e2 / 0.9e1 * t1084 + 0.1e2 * t1087 - 0.2e2 / 0.9e1 * t1091 - 0.25e2 / 0.9e1 * t1094 - 0.1e2 / 0.9e1 * t1097 + 0.4e2 / 0.9e1 * t1105 + 0.5e2 / 0.9e1 * t1108 - 0.25e2 / 0.9e1 * t1112;
  t1314 = t1006 * t468;
  t1316 = t275 * t472;
  t1318 = t275 * t475;
  t1320 = t921 * t479;
  t1322 = t305 * t482;
  t1324 = 0.1e2 / 0.27e2 * t1115 - 0.25e2 / 0.9e1 * t1118 - 0.25e2 / 0.18e2 * t1122 - 0.125e3 / 0.36e2 * t1131 + 0.1e2 * t929 + t941 + t944 - 0.25e2 / 0.18e2 * t1314 + 0.25e2 / 0.9e1 * t1316 + 0.25e2 / 0.9e1 * t1318 + 0.125e3 / 0.36e2 * t1320 - 0.1e2 / 0.9e1 * t1322;
  t1325 = t99 * t486;
  t1327 = t99 * t489;
  t1329 = t305 * t492;
  t1331 = t99 * t496;
  t1333 = t275 * t500;
  t1335 = my_piecewise3(t5, t1147, -t1147);
  t1336 = my_piecewise3(t7, t1335, 0);
  t1340 = t178 * t178;
  t1352 = -0.1e2 / 0.27e2 * t1325 + 0.2e2 / 0.9e1 * t1327 - 0.5e1 / 0.3e1 * t1329 + 0.1e2 / 0.9e1 * t1331 + 0.25e2 / 0.18e2 * t1333 + 0.5e1 / 0.6e1 * t49 * t50 * t1336 + 0.1e2 / 0.9e1 * t49 * t120 * t1340 + 0.25e2 / 0.18e2 * t108 * t110 * t1340 - 0.5e1 * t1136 + 0.1e2 / 0.9e1 * t1138 + 0.25e2 / 0.9e1 * t1140 + 0.25e2 / 0.18e2 * t1142 + 0.125e3 / 0.36e2 * t1144;
  t1365 = -0.2e2 / 0.3e1 * t1155 + 0.2e2 / 0.9e1 * t1157 + 0.25e2 / 0.9e1 * t1159 + 0.1e2 * t1161 - 0.1e2 / 0.27e2 * t1163 - t959 - 0.5e1 * t960 + t983 - 0.1e2 / 0.9e1 * t984 - 0.5e1 / 0.3e1 * t1000 - 0.25e2 / 0.18e2 * t1007 + 0.1e2 * t1010;
  t1367 = t1058 * t457 * t135;
  t1374 = t369 * t460 * t135;
  t1381 = t369 * t463 * t135;
  t1392 = t115 * t463 * t156;
  t1408 = 0.25e2 / 0.18e2 * t1367 + 0.25e2 / 0.81e2 * t163 * t990 * t184 * t111 + 0.1e2 / 0.9e1 * t1374 + 0.2e2 / 0.81e2 * t171 * t946 * t184 * t111 + 0.5e1 / 0.3e1 * t1381 - 0.5e1 / 0.27e2 * t171 * t358 * t196 * t111 - 0.1e2 * t1179 + 0.1e2 / 0.9e1 * t171 * t172 * t387 - 0.5e1 / 0.6e1 * t1392 + 0.5e1 / 0.9e1 * t171 * t495 * t129 + 0.25e2 / 0.18e2 * t163 * t9 * t196 * t111 + 0.25e2 / 0.36e2 * t163 * t499 * t129 + 0.125e3 / 0.72e2 * t422 * t315 * t196 * t111;
  t1411 = t340 * t457 * t156;
  t1431 = t115 * t460 * t156;
  t1437 = t115 * t1263 * t78;
  t1448 = -0.25e2 / 0.36e2 * t1411 + 0.25e2 / 0.18e2 * t163 * t471 * t129 + 0.125e3 / 0.18e2 * t422 * t8 * t184 * t111 + 0.25e2 / 0.18e2 * t163 * t164 * t387 + 0.125e3 / 0.72e2 * t422 * t478 * t129 + 0.3125e4 / 0.432e3 * t1225 * t966 * t184 * t111 - 0.5e1 / 0.9e1 * t1431 - 0.5e1 / 0.27e2 * t171 * t485 * t129 - 0.5e1 / 0.3e1 * t1437 + 0.1e2 / 0.9e1 * t171 * t119 * t451 * t56 + 0.25e2 / 0.18e2 * t163 * t109 * t451 * t56 - 0.5e1 / 0.3e1 * t1186;
  t1462 = 0.2e2 / 0.3e1 * t1205 - 0.5e1 / 0.3e1 * t1014 - 0.1e2 * t1039 - 0.25e2 / 0.36e2 * t1042 - 0.5e1 / 0.6e1 * t1049 + 0.25e2 / 0.18e2 * t1060 + 0.5e1 / 0.3e1 * t1066 - 0.5e1 / 0.9e1 * t1069 + 0.1e2 / 0.9e1 * t1072 - 0.1e2 / 0.3e1 * t1231 - 0.5e1 / 0.3e1 * t1234 - 0.4e2 / 0.9e1 * t1254 - 0.5e2 / 0.9e1 * t1257;
  tv4rho42 = t1286 + t1307 + t1324 + t1352 + t1365 + t1408 + t1448 + t1462;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1466 = t196 * t78;
  t1468 = t340 * t164 * t1466;
  t1470 = t196 * t56;
  t1478 = t115 * t172 * t1466;
  t1491 = 0.5e1 / 0.2e1 * t1264 - t876 - t880 + t911 - t927 - 0.25e2 / 0.12e2 * t1468 + 0.25e2 / 0.6e1 * t163 * t398 * t1470 + 0.125e3 / 0.24e2 * t422 * t423 * t1470 - 0.5e1 / 0.3e1 * t1478 - 0.5e1 / 0.9e1 * t171 * t406 * t1470 - 0.5e1 / 0.3e1 * t1267 - 0.25e2 / 0.12e2 * t1270 - 0.25e2 / 0.6e1 * t1273 - 0.25e2 / 0.6e1 * t1277 - 0.125e3 / 0.24e2 * t1280 + 0.5e1 / 0.9e1 * t1291 - 0.1e2 / 0.3e1 * t1294 + 0.15e2 * t1087 - t1092 - t1095;
  t1506 = t1106 + t1109 + 0.5e1 * t929 + t941 + t944 - 0.25e2 / 0.6e1 * t1314 + 0.25e2 / 0.6e1 * t1316 + 0.25e2 / 0.6e1 * t1318 + 0.125e3 / 0.24e2 * t1320 - 0.1e2 / 0.3e1 * t1322 - 0.5e1 / 0.9e1 * t1325 + 0.1e2 / 0.3e1 * t1327 - 0.5e1 * t1329 + 0.5e1 / 0.3e1 * t1331 + 0.25e2 / 0.12e2 * t1333 - 0.15e2 / 0.2e1 * t1136 - t1156 + 0.15e2 * t1161 - t959 - 0.5e1 / 0.2e1 * t960;
  t1509 = t358 * t511;
  t1511 = t115 * t1509 * t78;
  t1526 = t10 * t519;
  t1528 = t115 * t1526 * t78;
  t1530 = t119 * t519;
  t1534 = t109 * t519;
  t1538 = t315 * t511;
  t1540 = t1016 * t1538 * t78;
  t1556 = t9 * t511;
  t1558 = t340 * t1556 * t78;
  t1567 = t983 + 0.5e1 * t1010 + 0.5e1 / 0.27e2 * t1511 + 0.2e2 / 0.81e2 * t171 * t946 * t511 * t56 - 0.5e1 / 0.9e1 * t171 * t485 * t178 + 0.5e1 / 0.3e1 * t171 * t433 * t196 + 0.5e1 / 0.3e1 * t171 * t172 * t451 - 0.5e1 / 0.6e1 * t1528 + 0.5e1 / 0.9e1 * t171 * t1530 * t56 + 0.25e2 / 0.36e2 * t163 * t1534 * t56 - 0.125e3 / 0.72e2 * t1540 + 0.125e3 / 0.18e2 * t422 * t8 * t511 * t56 + 0.125e3 / 0.24e2 * t422 * t478 * t178 + 0.3125e4 / 0.432e3 * t1225 * t966 * t511 * t56 + 0.25e2 / 0.6e1 * t1367 + 0.1e2 / 0.3e1 * t1374 + 0.5e1 * t1381 - 0.25e2 / 0.18e2 * t1558 + 0.25e2 / 0.81e2 * t163 * t990 * t511 * t56 + 0.25e2 / 0.6e1 * t163 * t471 * t178;
  t1583 = t275 * t1556;
  t1585 = t99 * t1509;
  t1587 = t921 * t1538;
  t1589 = t99 * t1526;
  t1591 = t275 * t530;
  t1593 = t99 * t536;
  t1595 = t1146 + t1147;
  t1597 = my_piecewise3(t5, t1595, -t1595);
  t1598 = my_piecewise3(t7, t1597, 0);
  t1602 = -t1232 - 0.5e1 / 0.2e1 * t1234 - t1255 - t1258 + 0.25e2 / 0.18e2 * t1583 - 0.5e1 / 0.27e2 * t1585 + 0.125e3 / 0.72e2 * t1587 + 0.5e1 / 0.6e1 * t1589 + 0.25e2 / 0.12e2 * t1591 + 0.5e1 / 0.3e1 * t1593 + 0.5e1 / 0.6e1 * t49 * t50 * t1598;
  tv4rho43 = t1491 + t1506 + t1567 + 0.25e2 / 0.12e2 * t163 * t415 * t196 + 0.25e2 / 0.12e2 * t163 * t164 * t451 - 0.15e2 * t1179 - 0.5e1 / 0.2e1 * t1392 - 0.25e2 / 0.12e2 * t1411 - 0.5e1 / 0.3e1 * t1431 - 0.5e1 / 0.2e1 * t1437 + t1206 - 0.5e1 / 0.6e1 * t1014 - 0.5e1 * t1039 + t1602;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1610 = -t876 - t880 + t911 - t927 - 0.25e2 / 0.3e1 * t1468 - 0.2e2 / 0.3e1 * t1478 + 0.2e2 * t1087 + t941 + t944 - 0.25e2 / 0.3e1 * t1314 - 0.2e2 / 0.3e1 * t1322;
  t1621 = -0.1e2 * t1329 - 0.1e2 * t1136 + 0.2e2 * t1161 - t959 + t983 + 0.2e2 / 0.27e2 * t1511 - 0.1e2 / 0.3e1 * t1528 - 0.125e3 / 0.18e2 * t1540 + 0.25e2 / 0.3e1 * t1367 + 0.2e2 / 0.3e1 * t1374 + 0.1e2 * t1381 - 0.5e2 / 0.9e1 * t1558;
  t1644 = -0.2e2 * t1179 - 0.5e1 * t1392 - 0.25e2 / 0.6e1 * t1411 - 0.1e2 / 0.3e1 * t1431 - 0.1e2 / 0.3e1 * t1234 - 0.1e2 / 0.9e1 * t171 * t485 * t196 + 0.25e2 / 0.3e1 * t163 * t471 * t196 + 0.125e3 / 0.12e2 * t422 * t478 * t196 + 0.2e2 / 0.9e1 * t171 * t1530 * t84 + 0.25e2 / 0.9e1 * t163 * t1534 * t84 + 0.5e2 / 0.9e1 * t1583;
  t1650 = t196 * t196;
  t1654 = t184 * t184;
  t1671 = 0.24e2 * t20 + 0.24e2 * t971;
  t1673 = my_piecewise3(t5, t1671, -t1671);
  t1674 = my_piecewise3(t7, t1673, 0);
  t1678 = -0.2e2 / 0.27e2 * t1585 + 0.125e3 / 0.18e2 * t1587 + 0.1e2 / 0.3e1 * t1589 + 0.25e2 / 0.3e1 * t1591 + 0.2e2 / 0.3e1 * t1593 + 0.5e1 / 0.3e1 * t49 * t120 * t1650 + 0.25e2 / 0.81e2 * t108 * t991 * t1654 + 0.25e2 / 0.12e2 * t108 * t110 * t1650 + 0.2e2 / 0.81e2 * t49 * t947 * t1654 + 0.125e3 / 0.18e2 * t314 * t986 * t1654 + 0.3125e4 / 0.432e3 * t965 * t967 * t1654 + 0.5e1 / 0.6e1 * t49 * t50 * t1674;
  tv4rho44 = t1610 + t1621 + t1644 + t1678;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t1681 = t1058 * t547 * t1110;
  t1687 = t369 * t554 * t440;
  t1690 = t369 * t201 * t931;
  t1693 = t369 * t201 * t1089;
  t1696 = t1036 * t201 * t1103;
  t1699 = t369 * t558 * t1110;
  t1705 = 0.3e1 * t103 * t584;
  t1709 = 0.6e1 * t60 * t134 * t584 * t78;
  t1712 = 0.6e1 * t60 * t569 * t156;
  t1715 = 0.2e1 * t60 * t205 * t302;
  t1719 = 0.24e2 * t60 * t872 * t93 * t332;
  t1720 = t305 * t559;
  t1725 = 0.18e2 * t60 * t331 * t216 * t135;
  t1726 = t305 * t555;
  t1728 = 0.25e2 / 0.6e1 * t1681 - 0.25e2 / 0.12e2 * t340 * t547 * t1099 + 0.1e2 * t1687 + 0.5e1 * t1690 + 0.5e1 * t1693 - 0.15e2 * t1696 + 0.1e2 / 0.3e1 * t1699 - 0.5e1 / 0.3e1 * t115 * t558 * t1099 + t1705 - t1709 - t1712 - t1715 - t1719 - 0.5e1 / 0.3e1 * t1720 + t1725 - 0.5e1 * t1726;
  t1729 = t305 * t562;
  t1731 = t1006 * t548;
  t1733 = t93 * t315;
  t1737 = t584 * t10;
  t1739 = t115 * t1737 * t56;
  t1742 = t115 * t554 * t129;
  t1749 = 0.18e2 * t734 * t542 * t156;
  t1750 = t1009 * t93;
  t1751 = t1750 * t116;
  t1753 = t216 * t109;
  t1755 = t340 * t1753 * t111;
  t1757 = t93 * t9;
  t1761 = t216 * t119;
  t1763 = t115 * t1761 * t111;
  t1765 = t93 * t358;
  t1772 = t885 / t22 / t887 * t15;
  t1775 = t28 * t284 * t16;
  t1777 = t139 * t288;
  t1779 = t89 * t292;
  t1784 = t60 * t62 * (-0.27723378092447916668e0 * t1772 - 0.12198286360677083334e2 * t1775 - 0.18521162065972222222e2 * t1777 - 0.24902402777777777778e1 * t1779 - 0.6612e0 * t296);
  t1787 = 0.12e2 * t279 * t216 * t78;
  t1790 = 0.6e1 * t279 * t93 * t156;
  t1793 = 0.18e2 * t942 * t93 * t135;
  t1794 = -0.5e1 / 0.2e1 * t1729 - 0.25e2 / 0.12e2 * t1731 - 0.125e3 / 0.72e2 * t1016 * t1733 * t317 - 0.5e1 / 0.2e1 * t1739 - 0.5e1 / 0.2e1 * t1742 - 0.5e1 / 0.6e1 * t115 * t201 * t326 + t1749 + 0.1e2 * t1751 - 0.25e2 / 0.12e2 * t1755 - 0.25e2 / 0.18e2 * t340 * t1757 * t317 - 0.5e1 / 0.3e1 * t1763 + 0.5e1 / 0.27e2 * t115 * t1765 * t317 + t1784 - t1787 - t1790 + t1793;
  tv4rho3sigma0 = t1728 + t1794;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t1799 = t369 * t601 * t440;
  t1802 = t369 * t220 * t931;
  t1805 = t369 * t220 * t1089;
  t1811 = t1036 * t220 * t1103;
  t1814 = t369 * t605 * t1110;
  t1817 = t1058 * t594 * t1110;
  t1821 = 0.6e1 * t279 * t97 * t156;
  t1824 = 0.18e2 * t942 * t97 * t135;
  t1832 = t60 * t62 * (-0.55446756184895833332e0 * t1772 - 0.24396572721354166667e2 * t1775 - 0.37042324131944444444e2 * t1777 - 0.49804805555555555557e1 * t1779 - 0.13224e1 * t296);
  t1835 = 0.12e2 * t279 * t231 * t78;
  t1837 = 0.3e1 * t103 * t627;
  t1838 = t331 * t231;
  t1841 = 0.18e2 * t60 * t1838 * t135;
  t1842 = t134 * t627;
  t1845 = 0.6e1 * t60 * t1842 * t78;
  t1848 = 0.6e1 * t60 * t616 * t156;
  t1849 = -0.25e2 / 0.12e2 * t340 * t594 * t1099 + 0.1e2 * t1799 + 0.5e1 * t1802 + 0.5e1 * t1805 - 0.5e1 / 0.3e1 * t115 * t605 * t1099 - 0.15e2 * t1811 + 0.1e2 / 0.3e1 * t1814 + 0.25e2 / 0.6e1 * t1817 - t1821 + t1824 + t1832 - t1835 + t1837 + t1841 - t1845 - t1848;
  t1852 = 0.2e1 * t60 * t224 * t302;
  t1853 = t305 * t602;
  t1855 = t305 * t609;
  t1857 = t1006 * t595;
  t1859 = t872 * t97;
  t1862 = 0.24e2 * t60 * t1859 * t332;
  t1863 = t305 * t606;
  t1865 = t97 * t315;
  t1869 = t627 * t10;
  t1871 = t115 * t1869 * t56;
  t1874 = t115 * t601 * t129;
  t1881 = 0.18e2 * t734 * t589 * t156;
  t1882 = t1009 * t97;
  t1883 = t1882 * t116;
  t1885 = t231 * t109;
  t1887 = t340 * t1885 * t111;
  t1889 = t97 * t9;
  t1893 = t231 * t119;
  t1895 = t115 * t1893 * t111;
  t1897 = t97 * t358;
  t1901 = -t1852 - 0.5e1 * t1853 - 0.5e1 / 0.2e1 * t1855 - 0.25e2 / 0.12e2 * t1857 - t1862 - 0.5e1 / 0.3e1 * t1863 - 0.125e3 / 0.72e2 * t1016 * t1865 * t317 - 0.5e1 / 0.2e1 * t1871 - 0.5e1 / 0.2e1 * t1874 - 0.5e1 / 0.6e1 * t115 * t220 * t326 + t1881 + 0.1e2 * t1883 - 0.25e2 / 0.12e2 * t1887 - 0.25e2 / 0.18e2 * t340 * t1889 * t317 - 0.5e1 / 0.3e1 * t1895 + 0.5e1 / 0.27e2 * t115 * t1897 * t317;
  tv4rho3sigma1 = t1849 + t1901;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  tv4rho3sigma2 = tv4rho3sigma0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t1902 = t84 * t156;
  t1904 = t369 * t201 * t1902;
  t1908 = 0.1e2 / 0.9e1 * t115 * t1761 * t633;
  t1909 = t84 * t111;
  t1913 = t84 * t135;
  t1915 = t1036 * t201 * t1913;
  t1923 = t84 * t129;
  t1929 = 0.25e2 / 0.18e2 * t340 * t1753 * t633;
  t1940 = t369 * t554 * t637;
  t1942 = 0.5e1 / 0.3e1 * t1904 - t1908 - 0.25e2 / 0.18e2 * t340 * t1757 * t1909 - 0.5e1 * t1915 + 0.5e1 / 0.27e2 * t115 * t1765 * t1909 - 0.1e2 / 0.9e1 * t115 * t558 * t1282 - 0.5e1 / 0.9e1 * t115 * t558 * t1923 - t1929 - 0.25e2 / 0.18e2 * t340 * t547 * t1282 - 0.25e2 / 0.36e2 * t340 * t547 * t1923 - 0.125e3 / 0.72e2 * t1016 * t1733 * t1909 + 0.1e2 / 0.3e1 * t1940;
  t1945 = 0.1e2 / 0.3e1 * t369 * t201 * t1275;
  t1954 = 0.2e2 / 0.9e1 * t49 * t205 * t444;
  t1957 = 0.25e2 / 0.9e1 * t108 * t205 * t441;
  t1958 = t1945 + 0.25e2 / 0.18e2 * t1681 + 0.2e2 / 0.3e1 * t1687 + 0.5e1 / 0.3e1 * t1690 + 0.1e2 / 0.3e1 * t1693 - 0.1e2 * t1696 + 0.1e2 / 0.9e1 * t1699 + t1954 + t1957 + t1705 - t1709 - t1712;
  t1964 = t305 * t641;
  t1967 = 0.5e1 / 0.3e1 * t305 * t647;
  t1970 = -t1715 - t1719 - 0.5e1 / 0.9e1 * t1720 + t1725 - 0.1e2 / 0.3e1 * t1726 - 0.5e1 / 0.6e1 * t1729 - 0.25e2 / 0.36e2 * t1731 - 0.5e1 / 0.3e1 * t1964 - t1967 - 0.5e1 / 0.3e1 * t1739 - 0.5e1 / 0.6e1 * t1742 + t1749;
  t1975 = t115 * t1737 * t84;
  t1979 = 0.5e1 / 0.3e1 * t115 * t554 * t178;
  t1983 = t1750 * t168;
  t1987 = 0.1e2 / 0.9e1 * t305 * t93 * t173;
  t1990 = 0.25e2 / 0.18e2 * t1006 * t93 * t165;
  t1991 = 0.2e2 / 0.3e1 * t1751 - 0.25e2 / 0.36e2 * t1755 - 0.5e1 / 0.9e1 * t1763 - 0.5e1 / 0.6e1 * t1975 - t1979 - 0.5e1 / 0.6e1 * t115 * t201 * t387 + 0.1e2 / 0.3e1 * t1983 - t1987 - t1990 + t1784 - t1787 - t1790 + t1793;
  tv4rho3sigma3 = t1942 + t1958 + t1970 + t1991;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  t1997 = t1036 * t220 * t1913;
  t2004 = 0.25e2 / 0.18e2 * t340 * t1885 * t633;
  t2015 = t369 * t601 * t637;
  t2019 = 0.1e2 / 0.3e1 * t369 * t220 * t1275;
  t2021 = t369 * t220 * t1902;
  t2025 = 0.1e2 / 0.9e1 * t115 * t1893 * t633;
  t2029 = -0.25e2 / 0.18e2 * t340 * t1889 * t1909 - 0.5e1 * t1997 + 0.5e1 / 0.27e2 * t115 * t1897 * t1909 - t2004 - 0.25e2 / 0.18e2 * t340 * t594 * t1282 - 0.25e2 / 0.36e2 * t340 * t594 * t1923 - 0.125e3 / 0.72e2 * t1016 * t1865 * t1909 + 0.1e2 / 0.3e1 * t2015 + t2019 + 0.5e1 / 0.3e1 * t2021 - t2025 - 0.1e2 / 0.9e1 * t115 * t605 * t1282;
  t2039 = t108 * t224;
  t2041 = 0.25e2 / 0.9e1 * t2039 * t441;
  t2042 = t49 * t224;
  t2044 = 0.2e2 / 0.9e1 * t2042 * t444;
  t2045 = -0.5e1 / 0.9e1 * t115 * t605 * t1923 + 0.2e2 / 0.3e1 * t1799 + 0.5e1 / 0.3e1 * t1802 + 0.1e2 / 0.3e1 * t1805 - 0.1e2 * t1811 + 0.1e2 / 0.9e1 * t1814 + 0.25e2 / 0.18e2 * t1817 + t2041 + t2044 - t1821 + t1824 + t1832;
  t2047 = t305 * t661;
  t2050 = 0.5e1 / 0.3e1 * t305 * t667;
  t2054 = -t1835 - 0.5e1 / 0.3e1 * t2047 - t2050 + t1837 + t1841 - t1845 - t1848 - t1852 - 0.1e2 / 0.3e1 * t1853 - 0.5e1 / 0.6e1 * t1855 - 0.25e2 / 0.36e2 * t1857 - t1862;
  t2061 = t1882 * t168;
  t2065 = 0.1e2 / 0.9e1 * t305 * t97 * t173;
  t2068 = 0.25e2 / 0.18e2 * t1006 * t97 * t165;
  t2070 = t115 * t1869 * t84;
  t2074 = 0.5e1 / 0.3e1 * t115 * t601 * t178;
  t2078 = -0.5e1 / 0.9e1 * t1863 - 0.5e1 / 0.3e1 * t1871 - 0.5e1 / 0.6e1 * t1874 + t1881 + 0.2e2 / 0.3e1 * t1883 - 0.25e2 / 0.36e2 * t1887 - 0.5e1 / 0.9e1 * t1895 + 0.1e2 / 0.3e1 * t2061 - t2065 - t2068 - 0.5e1 / 0.6e1 * t2070 - t2074 - 0.5e1 / 0.6e1 * t115 * t220 * t387;
  tv4rho3sigma4 = t2029 + t2045 + t2054 + t2078;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  tv4rho3sigma5 = tv4rho3sigma3;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t2080 = t184 * t78;
  t2082 = t1058 * t547 * t2080;
  t2084 = t184 * t56;
  t2088 = t84 * t178;
  t2096 = t369 * t558 * t2080;
  t2105 = t369 * t201 * t1466;
  t2114 = 0.25e2 / 0.18e2 * t2082 - 0.25e2 / 0.18e2 * t340 * t1757 * t2084 - 0.25e2 / 0.18e2 * t340 * t547 * t2088 - 0.125e3 / 0.72e2 * t1016 * t1733 * t2084 + 0.1e2 / 0.9e1 * t2096 + 0.5e1 / 0.27e2 * t115 * t1765 * t2084 - 0.1e2 / 0.9e1 * t115 * t558 * t2088 + 0.5e1 / 0.3e1 * t2105 - 0.5e1 / 0.9e1 * t115 * t558 * t1470 - 0.25e2 / 0.36e2 * t340 * t547 * t1470 + 0.1e2 / 0.3e1 * t1904 - t1908;
  t2120 = t305 * t678;
  t2122 = t305 * t681;
  t2124 = t1006 * t673;
  t2126 = -0.1e2 * t1915 - t1929 + 0.2e2 / 0.3e1 * t1940 + t1945 + 0.1e2 / 0.3e1 * t1687 + 0.5e1 / 0.3e1 * t1693 - 0.5e1 * t1696 + t1954 + t1957 - 0.5e1 / 0.9e1 * t2120 - 0.5e1 / 0.6e1 * t2122 - 0.25e2 / 0.36e2 * t2124;
  t2132 = t1705 - t1709 - t1712 - t1715 - t1719 + t1725 - 0.5e1 / 0.3e1 * t1726 - 0.1e2 / 0.3e1 * t1964 - t1967 - 0.5e1 / 0.6e1 * t1739 + t1749 + 0.1e2 / 0.3e1 * t1751;
  t2136 = t115 * t1761 * t184;
  t2139 = t115 * t554 * t196;
  t2145 = t340 * t1753 * t184;
  t2147 = -0.5e1 / 0.3e1 * t1975 - t1979 + 0.2e2 / 0.3e1 * t1983 - t1987 - t1990 - 0.5e1 / 0.9e1 * t2136 - 0.5e1 / 0.6e1 * t2139 - 0.5e1 / 0.6e1 * t115 * t201 * t451 - 0.25e2 / 0.36e2 * t2145 + t1784 - t1787 - t1790 + t1793;
  tv4rho3sigma6 = t2114 + t2126 + t2132 + t2147;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  t2153 = t369 * t220 * t1466;
  t2162 = t1058 * t594 * t2080;
  t2174 = t369 * t605 * t2080;
  t2180 = -0.1e2 / 0.9e1 * t115 * t605 * t2088 + 0.5e1 / 0.3e1 * t2153 - 0.5e1 / 0.9e1 * t115 * t605 * t1470 - 0.25e2 / 0.36e2 * t340 * t594 * t1470 + 0.25e2 / 0.18e2 * t2162 - 0.25e2 / 0.18e2 * t340 * t1889 * t2084 - 0.25e2 / 0.18e2 * t340 * t594 * t2088 - 0.125e3 / 0.72e2 * t1016 * t1865 * t2084 + 0.1e2 / 0.9e1 * t2174 + 0.5e1 / 0.27e2 * t115 * t1897 * t2084 - 0.1e2 * t1997 - t2004;
  t2186 = t305 * t690;
  t2188 = t305 * t693;
  t2190 = 0.2e2 / 0.3e1 * t2015 + t2019 + 0.1e2 / 0.3e1 * t2021 - t2025 + 0.1e2 / 0.3e1 * t1799 + 0.5e1 / 0.3e1 * t1805 - 0.5e1 * t1811 + t2041 + t2044 - t1821 - 0.5e1 / 0.9e1 * t2186 - 0.5e1 / 0.6e1 * t2188;
  t2192 = t1006 * t685;
  t2196 = -0.25e2 / 0.36e2 * t2192 + t1824 + t1832 - t1835 - 0.1e2 / 0.3e1 * t2047 - t2050 + t1837 + t1841 - t1845 - t1848 - t1852 - 0.5e1 / 0.3e1 * t1853;
  t2202 = t115 * t1893 * t184;
  t2205 = t115 * t601 * t196;
  t2211 = t340 * t1885 * t184;
  t2213 = -t1862 - 0.5e1 / 0.6e1 * t1871 + t1881 + 0.1e2 / 0.3e1 * t1883 + 0.2e2 / 0.3e1 * t2061 - t2065 - t2068 - 0.5e1 / 0.3e1 * t2070 - t2074 - 0.5e1 / 0.9e1 * t2202 - 0.5e1 / 0.6e1 * t2205 - 0.5e1 / 0.6e1 * t115 * t220 * t451 - 0.25e2 / 0.36e2 * t2211;
  tv4rho3sigma7 = t2180 + t2190 + t2196 + t2213;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  tv4rho3sigma8 = tv4rho3sigma6;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t2215 = t84 * t196;
  t2231 = -0.25e2 / 0.12e2 * t340 * t547 * t2215 - 0.5e1 / 0.3e1 * t115 * t558 * t2215 + 0.25e2 / 0.6e1 * t2082 + 0.1e2 / 0.3e1 * t2096 + 0.5e1 * t2105 + 0.5e1 * t1904 - 0.15e2 * t1915 + 0.1e2 * t1940 - 0.5e1 / 0.3e1 * t2120 - 0.5e1 / 0.2e1 * t2122 - 0.25e2 / 0.12e2 * t2124 + t1705 - t1709 - t1712 - t1715 - t1719;
  t2250 = t1725 - 0.5e1 * t1964 + t1749 - 0.5e1 / 0.2e1 * t1975 + 0.1e2 * t1983 - 0.5e1 / 0.3e1 * t2136 - 0.5e1 / 0.2e1 * t2139 - 0.25e2 / 0.12e2 * t2145 - 0.5e1 / 0.6e1 * t115 * t201 * t519 - 0.125e3 / 0.72e2 * t1016 * t1733 * t511 + 0.5e1 / 0.27e2 * t115 * t1765 * t511 - 0.25e2 / 0.18e2 * t340 * t1757 * t511 + t1784 - t1787 - t1790 + t1793;
  tv4rho3sigma9 = t2231 + t2250;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  t2267 = -0.5e1 / 0.3e1 * t115 * t605 * t2215 - 0.25e2 / 0.12e2 * t340 * t594 * t2215 + 0.5e1 * t2153 + 0.25e2 / 0.6e1 * t2162 + 0.1e2 / 0.3e1 * t2174 - 0.15e2 * t1997 + 0.1e2 * t2015 + 0.5e1 * t2021 - t1821 - 0.5e1 / 0.3e1 * t2186 - 0.5e1 / 0.2e1 * t2188 - 0.25e2 / 0.12e2 * t2192 + t1824 + t1832 - t1835 - 0.5e1 * t2047;
  t2285 = t1837 + t1841 - t1845 - t1848 - t1852 - t1862 + t1881 + 0.1e2 * t2061 - 0.5e1 / 0.2e1 * t2070 - 0.5e1 / 0.3e1 * t2202 - 0.5e1 / 0.2e1 * t2205 - 0.25e2 / 0.12e2 * t2211 - 0.5e1 / 0.6e1 * t115 * t220 * t519 - 0.125e3 / 0.72e2 * t1016 * t1865 * t511 - 0.25e2 / 0.18e2 * t340 * t1889 * t511 + 0.5e1 / 0.27e2 * t115 * t1897 * t511;
  tv4rho3sigma10 = t2267 + t2285;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  tv4rho3sigma11 = tv4rho3sigma9;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t2288 = t885 / t22 / t283;
  t2290 = t718 * t296;
  t2292 = t245 * t142;
  t2294 = t249 * t146;
  t2298 = t60 * t62 * (0.1039626678466796875e0 * t2288 + 0.26337209187825520833e1 * t2290 + 0.81711009114583333337e0 * t2292 - 0.37353604166666666667e0 * t2294);
  t2301 = 0.4e1 * t279 * t252 * t78;
  t2304 = 0.12e2 * t942 * t240 * t78;
  t2307 = 0.8e1 * t279 * t93 * t216;
  t2308 = t216 * t216;
  t2311 = 0.4e1 * t60 * t134 * t2308;
  t2313 = t1036 * t698 * t440;
  t2317 = t369 * t201 * t56 * t216;
  t2320 = t369 * t710 * t440;
  t2323 = 0.2e1 * t103 * t725;
  t2324 = t305 * t711;
  t2329 = 0.4e1 * t60 * t134 * t725 * t78;
  t2332 = 0.2e1 * t60 * t714 * t156;
  t2333 = t2298 - t2301 + t2304 - t2307 - t2311 - 0.1e2 * t2313 + 0.2e2 / 0.3e1 * t2317 + 0.1e2 / 0.3e1 * t2320 + t2323 - 0.5e1 / 0.3e1 * t2324 - t2329 - t2332;
  t2334 = t1009 * t699;
  t2338 = 0.6e1 * t60 * t702 * t156;
  t2342 = 0.6e1 * t60 * t331 * t252 * t135;
  t2346 = 0.24e2 * t60 * t872 * t240 * t135;
  t2349 = 0.4e1 * t60 * t205 * t584;
  t2350 = t725 * t10;
  t2352 = t115 * t2350 * t56;
  t2357 = t252 * t109;
  t2364 = t240 * t109;
  t2370 = 0.24e2 * t734 * t542 * t216;
  t2371 = t240 * t119;
  t2375 = t252 * t119;
  t2379 = 0.1e2 / 0.3e1 * t2334 + t2338 + t2342 - t2346 - t2349 - 0.5e1 / 0.3e1 * t2352 - 0.5e1 / 0.6e1 * t115 * t710 * t129 - 0.25e2 / 0.36e2 * t340 * t2357 * t111 + 0.5e1 / 0.3e1 * t369 * t698 * t129 + 0.25e2 / 0.18e2 * t1058 * t2364 * t111 + t2370 + 0.1e2 / 0.9e1 * t369 * t2371 * t111 - 0.5e1 / 0.9e1 * t115 * t2375 * t111;
  tv4rho2sigma20 = t2333 + t2379;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t2386 = t60 * t62 * (0.207925335693359375e0 * t2288 + 0.52674418375651041667e1 * t2290 + 0.16342201822916666666e1 * t2292 - 0.74707208333333333333e0 * t2294);
  t2387 = t97 * t216;
  t2389 = 0.4e1 * t279 * t2387;
  t2392 = 0.4e1 * t279 * t260 * t78;
  t2393 = t231 * t93;
  t2395 = 0.4e1 * t279 * t2393;
  t2397 = t369 * t745 * t440;
  t2400 = t369 * t2393 * t100;
  t2403 = t369 * t2387 * t100;
  t2415 = 0.2e1 * t103 * t756;
  t2416 = t49 * t612;
  t2417 = t2416 * t551;
  t2419 = t134 * t756;
  t2422 = 0.4e1 * t60 * t2419 * t78;
  t2425 = 0.2e1 * t60 * t749 * t156;
  t2426 = t2386 - t2389 - t2392 - t2395 + 0.1e2 / 0.3e1 * t2397 + 0.1e2 / 0.3e1 * t2400 + 0.1e2 / 0.3e1 * t2403 + 0.5e1 / 0.3e1 * t369 * t728 * t272 + 0.25e2 / 0.18e2 * t1058 * t728 * t276 + 0.1e2 / 0.9e1 * t369 * t728 * t308 + t2415 - 0.1e2 * t2417 - t2422 - t2425;
  t2429 = 0.2e1 * t60 * t1842 * t93;
  t2432 = 0.4e1 * t60 * t616 * t216;
  t2435 = 0.2e1 * t60 * t224 * t584;
  t2436 = t305 * t746;
  t2439 = 0.12e2 * t942 * t735;
  t2440 = t331 * t260;
  t2443 = 0.6e1 * t60 * t2440 * t135;
  t2444 = t756 * t10;
  t2446 = t115 * t2444 * t56;
  t2451 = t260 * t109;
  t2455 = t1882 * t202;
  t2459 = 0.12e2 * t734 * t2393 * t78;
  t2462 = 0.12e2 * t734 * t2387 * t78;
  t2465 = 0.6e1 * t734 * t728 * t156;
  t2466 = t260 * t119;
  t2470 = t60 * t872;
  t2473 = 0.24e2 * t2470 * t728 * t135;
  t2474 = -t2429 - t2432 - t2435 - 0.5e1 / 0.3e1 * t2436 + t2439 + t2443 - 0.5e1 / 0.3e1 * t2446 - 0.5e1 / 0.6e1 * t115 * t745 * t129 - 0.25e2 / 0.36e2 * t340 * t2451 * t111 + 0.1e2 / 0.3e1 * t2455 + t2459 + t2462 + t2465 - 0.5e1 / 0.9e1 * t115 * t2466 * t111 - t2473;
  tv4rho2sigma21 = t2426 + t2474;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = tv4rho2sigma20;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  t2475 = t305 * t774;
  t2477 = t134 * t784;
  t2480 = 0.4e1 * t60 * t2477 * t78;
  t2483 = 0.2e1 * t60 * t777 * t156;
  t2484 = t872 * t263;
  t2487 = 0.24e2 * t60 * t2484 * t135;
  t2488 = t331 * t269;
  t2491 = 0.6e1 * t60 * t2488 * t135;
  t2492 = t1009 * t762;
  t2496 = 0.6e1 * t60 * t765 * t156;
  t2499 = 0.4e1 * t60 * t224 * t627;
  t2501 = 0.2e1 * t103 * t784;
  t2503 = t369 * t773 * t440;
  t2506 = t1036 * t761 * t440;
  t2510 = t369 * t220 * t56 * t231;
  t2512 = -0.5e1 / 0.3e1 * t2475 - t2480 - t2483 - t2487 + t2491 + 0.1e2 / 0.3e1 * t2492 + t2496 - t2499 + t2501 + 0.1e2 / 0.3e1 * t2503 - 0.1e2 * t2506 + 0.2e2 / 0.3e1 * t2510;
  t2519 = t60 * t62 * (0.41585067138671875e0 * t2288 + 0.10534883675130208333e2 * t2290 + 0.32684403645833333334e1 * t2292 - 0.14941441666666666667e1 * t2294);
  t2522 = 0.4e1 * t279 * t269 * t78;
  t2525 = 0.12e2 * t942 * t263 * t78;
  t2528 = 0.8e1 * t279 * t97 * t231;
  t2529 = t231 * t231;
  t2532 = 0.4e1 * t60 * t134 * t2529;
  t2536 = t263 * t109;
  t2542 = 0.24e2 * t734 * t589 * t231;
  t2543 = t784 * t10;
  t2545 = t115 * t2543 * t56;
  t2550 = t269 * t109;
  t2554 = t269 * t119;
  t2558 = t263 * t119;
  t2562 = t2519 - t2522 + t2525 - t2528 - t2532 + 0.5e1 / 0.3e1 * t369 * t761 * t129 + 0.25e2 / 0.18e2 * t1058 * t2536 * t111 + t2542 - 0.5e1 / 0.3e1 * t2545 - 0.5e1 / 0.6e1 * t115 * t773 * t129 - 0.25e2 / 0.36e2 * t340 * t2550 * t111 - 0.5e1 / 0.9e1 * t115 * t2554 * t111 + 0.1e2 / 0.9e1 * t369 * t2558 * t111;
  tv4rho2sigma23 = t2512 + t2562;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = tv4rho2sigma21;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  tv4rho2sigma25 = tv4rho2sigma22;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2566 = t305 * t790;
  t2568 = t1009 * t787;
  t2572 = t2298 - t2301 + t2304 - t2307 - t2311 - 0.5e1 * t2313 + 0.1e2 / 0.3e1 * t2317 + 0.5e1 / 0.3e1 * t2320 + t2323 - 0.5e1 / 0.6e1 * t2566 + 0.5e1 / 0.3e1 * t2568 - 0.5e1 / 0.6e1 * t2324 - t2329 - t2332 + 0.5e1 / 0.3e1 * t2334;
  t2575 = t115 * t2350 * t84;
  t2584 = t1036 * t698 * t637;
  t2588 = t369 * t201 * t84 * t216;
  t2597 = t369 * t710 * t637;
  t2605 = t2338 + t2342 - t2346 - t2349 - 0.5e1 / 0.6e1 * t2352 + t2370 - 0.5e1 / 0.6e1 * t2575 - 0.5e1 / 0.6e1 * t115 * t710 * t178 + 0.5e1 / 0.3e1 * t369 * t698 * t178 - 0.5e1 * t2584 + 0.1e2 / 0.3e1 * t2588 + 0.1e2 / 0.9e1 * t369 * t2371 * t633 + 0.25e2 / 0.18e2 * t1058 * t2364 * t633 + 0.5e1 / 0.3e1 * t2597 - 0.5e1 / 0.9e1 * t115 * t2375 * t633 - 0.25e2 / 0.36e2 * t340 * t2357 * t633;
  tv4rho2sigma26 = t2572 + t2605;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  t2609 = t2416 * t638;
  t2616 = t305 * t796;
  t2618 = t2386 - t2389 - t2392 - t2395 + 0.5e1 / 0.3e1 * t2397 + 0.5e1 / 0.3e1 * t2400 + 0.5e1 / 0.3e1 * t2403 + t2415 - 0.5e1 * t2609 + 0.1e2 / 0.9e1 * t2042 * t644 + 0.25e2 / 0.18e2 * t2039 * t634 - 0.5e1 * t2417 - 0.5e1 / 0.6e1 * t2616 - t2422 - t2425 - t2429 - t2432 - t2435;
  t2622 = t1882 * t234;
  t2625 = t115 * t2444 * t84;
  t2631 = t369 * t2393 * t160;
  t2634 = t369 * t2387 * t160;
  t2640 = t369 * t745 * t637;
  t2648 = -0.5e1 / 0.6e1 * t2436 + t2439 + t2443 - 0.5e1 / 0.6e1 * t2446 + 0.5e1 / 0.3e1 * t2455 + t2459 + t2462 + t2465 - t2473 + 0.5e1 / 0.3e1 * t2622 - 0.5e1 / 0.6e1 * t2625 - 0.5e1 / 0.6e1 * t115 * t745 * t178 + 0.5e1 / 0.3e1 * t2631 + 0.5e1 / 0.3e1 * t2634 + 0.5e1 / 0.3e1 * t369 * t728 * t392 + 0.5e1 / 0.3e1 * t2640 - 0.5e1 / 0.9e1 * t115 * t2466 * t633 - 0.25e2 / 0.36e2 * t340 * t2451 * t633;
  tv4rho2sigma27 = t2618 + t2648;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = tv4rho2sigma26;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  t2649 = t305 * t802;
  t2651 = t1009 * t799;
  t2658 = -0.5e1 / 0.6e1 * t2649 + 0.5e1 / 0.3e1 * t2651 - 0.5e1 / 0.6e1 * t2475 - t2480 - t2483 - t2487 + t2491 + 0.5e1 / 0.3e1 * t2492 + t2496 - t2499 + t2501 + 0.5e1 / 0.3e1 * t2503 - 0.5e1 * t2506 + 0.1e2 / 0.3e1 * t2510 + t2519;
  t2661 = t115 * t2543 * t84;
  t2670 = t1036 * t761 * t637;
  t2674 = t369 * t220 * t84 * t231;
  t2683 = t369 * t773 * t637;
  t2691 = -t2522 + t2525 - t2528 - t2532 + t2542 - 0.5e1 / 0.6e1 * t2545 - 0.5e1 / 0.6e1 * t2661 - 0.5e1 / 0.6e1 * t115 * t773 * t178 + 0.5e1 / 0.3e1 * t369 * t761 * t178 - 0.5e1 * t2670 + 0.1e2 / 0.3e1 * t2674 + 0.1e2 / 0.9e1 * t369 * t2558 * t633 + 0.25e2 / 0.18e2 * t1058 * t2536 * t633 + 0.5e1 / 0.3e1 * t2683 - 0.5e1 / 0.9e1 * t115 * t2554 * t633 - 0.25e2 / 0.36e2 * t340 * t2550 * t633;
  tv4rho2sigma29 = t2658 + t2691;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = tv4rho2sigma27;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  tv4rho2sigma211 = tv4rho2sigma28;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2694 = t2298 - t2301 + t2304 - t2307 - t2311 + t2323 - 0.5e1 / 0.3e1 * t2566 + 0.1e2 / 0.3e1 * t2568 - t2329 - t2332 + t2338 + t2342;
  t2717 = -t2346 - t2349 + t2370 - 0.5e1 / 0.3e1 * t2575 - 0.5e1 / 0.6e1 * t115 * t710 * t196 - 0.25e2 / 0.36e2 * t340 * t2357 * t184 + 0.5e1 / 0.3e1 * t369 * t698 * t196 + 0.25e2 / 0.18e2 * t1058 * t2364 * t184 + 0.1e2 / 0.9e1 * t369 * t2371 * t184 - 0.5e1 / 0.9e1 * t115 * t2375 * t184 - 0.1e2 * t2584 + 0.2e2 / 0.3e1 * t2588 + 0.1e2 / 0.3e1 * t2597;
  tv4rho2sigma212 = t2694 + t2717;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  t2720 = t2386 - t2389 - t2392 - t2395 + t2415 - 0.1e2 * t2609 - 0.5e1 / 0.3e1 * t2616 - t2422 - t2425 - t2429 - t2432 - t2435 + t2439 + t2443;
  t2744 = t2459 + t2462 + t2465 - t2473 + 0.1e2 / 0.3e1 * t2622 - 0.5e1 / 0.3e1 * t2625 - 0.5e1 / 0.6e1 * t115 * t745 * t196 - 0.25e2 / 0.36e2 * t340 * t2451 * t184 - 0.5e1 / 0.9e1 * t115 * t2466 * t184 + 0.1e2 / 0.3e1 * t2631 + 0.1e2 / 0.3e1 * t2634 + 0.1e2 / 0.3e1 * t2640 + 0.1e2 / 0.9e1 * t369 * t728 * t460 + 0.5e1 / 0.3e1 * t369 * t728 * t463 + 0.25e2 / 0.18e2 * t1058 * t728 * t457;
  tv4rho2sigma213 = t2720 + t2744;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = tv4rho2sigma212;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  t2759 = -0.5e1 / 0.3e1 * t2649 + 0.1e2 / 0.3e1 * t2651 - t2480 - t2483 - t2487 + t2491 + t2496 - t2499 - 0.5e1 / 0.6e1 * t115 * t773 * t196 - 0.25e2 / 0.36e2 * t340 * t2550 * t184 + 0.5e1 / 0.3e1 * t369 * t761 * t196 + 0.25e2 / 0.18e2 * t1058 * t2536 * t184;
  t2770 = -0.5e1 / 0.9e1 * t115 * t2554 * t184 + 0.1e2 / 0.9e1 * t369 * t2558 * t184 + t2501 + t2519 - t2522 + t2525 - t2528 - t2532 + t2542 - 0.5e1 / 0.3e1 * t2661 - 0.1e2 * t2670 + 0.2e2 / 0.3e1 * t2674 + 0.1e2 / 0.3e1 * t2683;
  tv4rho2sigma215 = t2759 + t2770;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = tv4rho2sigma213;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  tv4rho2sigma217 = tv4rho2sigma214;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2772 = 0.6e1 * t942 * t805;
  t2773 = t805 * t10;
  t2780 = 0.24e2 * t60 * t872 * t805 * t78;
  t2783 = 0.18e2 * t60 * t702 * t216;
  t2784 = t93 * t252;
  t2786 = 0.6e1 * t279 * t2784;
  t2792 = 0.18e2 * t734 * t2784 * t78;
  t2795 = 0.6e1 * t60 * t569 * t252;
  t2798 = 0.6e1 * t60 * t205 * t725;
  t2799 = t103 * t825;
  t2800 = t825 * t10;
  t2807 = 0.2e1 * t60 * t134 * t825 * t78;
  t2811 = t885 * t244 / t22 / t295;
  t2813 = t817 * t210;
  t2815 = t822 * t70;
  t2819 = t60 * t62 * (-0.38986000442504882812e-1 * t2811 + 0.52528505859375e0 * t2813 - 0.2401303125e0 * t2815);
  tv4rhosigma30 = t2772 - 0.5e1 * t1036 * t2773 * t56 - t2780 + t2783 - t2786 + 0.5e1 * t369 * t2784 * t100 + t2792 - t2795 - t2798 + t2799 - 0.5e1 / 0.6e1 * t115 * t2800 * t56 - t2807 + t2819;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t2820 = t97 * t240;
  t2822 = 0.6e1 * t942 * t2820;
  t2828 = 0.24e2 * t2470 * t2820 * t78;
  t2831 = 0.6e1 * t60 * t1838 * t240;
  t2834 = 0.12e2 * t734 * t728 * t216;
  t2835 = t260 * t93;
  t2837 = 0.4e1 * t279 * t2835;
  t2843 = 0.12e2 * t734 * t2835 * t78;
  t2846 = 0.4e1 * t60 * t2419 * t93;
  t2849 = 0.4e1 * t60 * t749 * t216;
  t2850 = t97 * t252;
  t2852 = 0.2e1 * t279 * t2850;
  t2858 = 0.6e1 * t734 * t2850 * t78;
  t2861 = 0.2e1 * t60 * t616 * t252;
  t2864 = 0.2e1 * t60 * t224 * t725;
  t2865 = t103 * t840;
  t2866 = t840 * t10;
  t2870 = t134 * t840;
  t2873 = 0.2e1 * t60 * t2870 * t78;
  t2879 = t60 * t62 * (-0.77972000885009765625e-1 * t2811 + 0.10505701171875e1 * t2813 - 0.480260625e0 * t2815);
  tv4rhosigma31 = t2822 - 0.5e1 * t1036 * t2820 * t100 - t2828 + t2831 + t2834 - t2837 + 0.1e2 / 0.3e1 * t369 * t2835 * t100 + t2843 - t2846 - t2849 - t2852 + 0.5e1 / 0.3e1 * t369 * t2850 * t100 + t2858 - t2861 - t2864 + t2865 - 0.5e1 / 0.6e1 * t115 * t2866 * t56 - t2873 + t2879;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = tv4rhosigma30;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  t2880 = t263 * t93;
  t2882 = 0.6e1 * t942 * t2880;
  t2888 = 0.24e2 * t2470 * t2880 * t78;
  t2891 = 0.12e2 * t734 * t728 * t231;
  t2894 = 0.6e1 * t60 * t765 * t216;
  t2895 = t97 * t260;
  t2897 = 0.4e1 * t279 * t2895;
  t2903 = 0.12e2 * t734 * t2895 * t78;
  t2906 = 0.4e1 * t60 * t616 * t260;
  t2909 = 0.4e1 * t60 * t224 * t756;
  t2910 = t269 * t93;
  t2912 = 0.2e1 * t279 * t2910;
  t2918 = 0.6e1 * t734 * t2910 * t78;
  t2921 = 0.2e1 * t60 * t2477 * t93;
  t2924 = 0.2e1 * t60 * t777 * t216;
  t2925 = t103 * t855;
  t2926 = t855 * t10;
  t2930 = t134 * t855;
  t2933 = 0.2e1 * t60 * t2930 * t78;
  t2939 = t60 * t62 * (-0.15594400177001953125e0 * t2811 + 0.2101140234375e1 * t2813 - 0.96052125e0 * t2815);
  tv4rhosigma33 = t2882 - 0.5e1 * t1036 * t2880 * t100 - t2888 + t2891 + t2894 - t2897 + 0.1e2 / 0.3e1 * t369 * t2895 * t100 + t2903 - t2906 - t2909 - t2912 + 0.5e1 / 0.3e1 * t369 * t2910 * t100 + t2918 - t2921 - t2924 + t2925 - 0.5e1 / 0.6e1 * t115 * t2926 * t56 - t2933 + t2939;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = tv4rhosigma31;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = tv4rhosigma32;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  t2941 = 0.6e1 * t942 * t858;
  t2942 = t858 * t10;
  t2946 = t872 * t858;
  t2949 = 0.24e2 * t60 * t2946 * t78;
  t2952 = 0.18e2 * t60 * t765 * t231;
  t2953 = t97 * t269;
  t2955 = 0.6e1 * t279 * t2953;
  t2961 = 0.18e2 * t734 * t2953 * t78;
  t2964 = 0.6e1 * t60 * t616 * t269;
  t2967 = 0.6e1 * t60 * t224 * t784;
  t2968 = t103 * t868;
  t2969 = t868 * t10;
  t2973 = t134 * t868;
  t2976 = 0.2e1 * t60 * t2973 * t78;
  t2982 = t60 * t62 * (-0.3118880035400390625e0 * t2811 + 0.420228046875e1 * t2813 - 0.19210425e1 * t2815);
  tv4rhosigma36 = t2941 - 0.5e1 * t1036 * t2942 * t56 - t2949 + t2952 - t2955 + 0.5e1 * t369 * t2953 * t100 + t2961 - t2964 - t2967 + t2968 - 0.5e1 / 0.6e1 * t115 * t2969 * t56 - t2976 + t2982;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = tv4rhosigma33;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = tv4rhosigma34;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  tv4rhosigma39 = tv4rhosigma35;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  tv4rhosigma310 = t2772 - 0.5e1 * t1036 * t2773 * t84 - t2780 + t2783 - t2786 + 0.5e1 * t369 * t2784 * t160 + t2792 - t2795 - t2798 + t2799 - 0.5e1 / 0.6e1 * t115 * t2800 * t84 - t2807 + t2819;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = t2822 - 0.5e1 * t1036 * t2820 * t160 - t2828 + t2831 + t2834 - t2837 + 0.1e2 / 0.3e1 * t369 * t2835 * t160 + t2843 - t2846 - t2849 - t2852 + 0.5e1 / 0.3e1 * t369 * t2850 * t160 + t2858 - t2861 - t2864 + t2865 - 0.5e1 / 0.6e1 * t115 * t2866 * t84 - t2873 + t2879;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = tv4rhosigma310;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = t2882 - 0.5e1 * t1036 * t2880 * t160 - t2888 + t2891 + t2894 - t2897 + 0.1e2 / 0.3e1 * t369 * t2895 * t160 + t2903 - t2906 - t2909 - t2912 + 0.5e1 / 0.3e1 * t369 * t2910 * t160 + t2918 - t2921 - t2924 + t2925 - 0.5e1 / 0.6e1 * t115 * t2926 * t84 - t2933 + t2939;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = tv4rhosigma311;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = tv4rhosigma312;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = t2941 - 0.5e1 * t1036 * t2942 * t84 - t2949 + t2952 - t2955 + 0.5e1 * t369 * t2953 * t160 + t2961 - t2964 - t2967 + t2968 - 0.5e1 / 0.6e1 * t115 * t2969 * t84 - t2976 + t2982;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = tv4rhosigma313;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = tv4rhosigma314;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  tv4rhosigma319 = tv4rhosigma315;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t3025 = t240 * t240;
  t3032 = t252 * t252;
  t3040 = t885 * t816 * t901;
  t3043 = t28 * t821 * t20;
  t3045 = t815 * t15;
  t3048 = t139 / t3045 * t65;
  t3053 = t67 / t16 / t3045 * t24;
  tv4sigma40 = -0.24e2 * t60 * t872 * t3025 + 0.36e2 * t60 * t702 * t252 - 0.6e1 * t60 * t134 * t3032 - 0.8e1 * t60 * t205 * t825 + t60 * t62 * (0.14619750165939331055e-1 * t3040 - 0.46783200531005859376e0 * t3043 + 0.98490948486328125e0 * t3048 - 0.4502443359375e0 * t3053);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = -0.24e2 * t60 * t1859 * t805 + 0.18e2 * t60 * t2440 * t240 + 0.18e2 * t734 * t728 * t252 - 0.6e1 * t60 * t2870 * t93 - 0.6e1 * t60 * t749 * t252 - 0.2e1 * t60 * t224 * t825 + t60 * t62 * (0.29239500331878662109e-1 * t3040 - 0.9356640106201171875e0 * t3043 + 0.19698189697265625e1 * t3048 - 0.900488671875e0 * t3053);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = tv4sigma40;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  t3092 = t260 * t260;
  tv4sigma43 = -0.24e2 * t60 * t2484 * t240 + 0.24e2 * t734 * t728 * t260 + 0.6e1 * t60 * t765 * t252 - 0.4e1 * t60 * t134 * t3092 - 0.4e1 * t60 * t224 * t840 + 0.6e1 * t60 * t2488 * t240 - 0.4e1 * t60 * t2930 * t93 - 0.2e1 * t60 * t777 * t252 + t60 * t62 * (0.58479000663757324219e-1 * t3040 - 0.1871328021240234375e1 * t3043 + 0.3939637939453125e1 * t3048 - 0.180097734375e1 * t3053);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = tv4sigma41;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = tv4sigma42;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = -0.24e2 * t60 * t2946 * t93 + 0.18e2 * t60 * t765 * t260 + 0.18e2 * t734 * t2953 * t93 - 0.6e1 * t60 * t749 * t269 - 0.6e1 * t60 * t224 * t855 - 0.2e1 * t60 * t2973 * t93 + t60 * t62 * (0.11695800132751464844e0 * t3040 - 0.374265604248046875e1 * t3043 + 0.787927587890625e1 * t3048 - 0.36019546875e1 * t3053);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = tv4sigma43;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = tv4sigma44;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = tv4sigma45;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  t3140 = t263 * t263;
  t3147 = t269 * t269;
  tv4sigma410 = -0.24e2 * t60 * t872 * t3140 + 0.36e2 * t60 * t765 * t269 - 0.6e1 * t60 * t134 * t3147 - 0.8e1 * t60 * t224 * t868 + t60 * t62 * (0.23391600265502929688e0 * t3040 - 0.74853120849609375e1 * t3043 + 0.157585517578125e2 * t3048 - 0.7203909375e1 * t3053);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = tv4sigma46;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = tv4sigma47;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = tv4sigma48;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  tv4sigma414 = tv4sigma49;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

