/*
  DrawTextQt - a test program for libosmscout
  Copyright (C) 2017  Lukas Karas

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
 * Data Copyright: OpenStreetMap contributors, license ODbL
 */

#ifndef TEST_WAY_H
#define TEST_WAY_H

#include <cassert>
#include <vector>

#include <osmscout/Point.h>

std::vector<double> TEST_WAY = {
  43.8910045, 8.0720529,
  43.891019, 8.0720859,
  43.8910465, 8.0721617,
  43.8910746, 8.0722418,
  43.8911047, 8.0723307,
  43.8911321, 8.0724051,
  43.8911505, 8.072451,
  43.8911666, 8.0725112,
  43.8911251, 8.0725652,
  43.891089, 8.072634,
  43.8910706, 8.0727132,
  43.891093, 8.0727342,
  43.8911399, 8.072699,
  43.8911837, 8.0726317,
  43.891228, 8.0725733,
  43.8912466, 8.0725861,
  43.8912665, 8.0726616,
  43.8912921, 8.0727234,
  43.8913179, 8.0728109,
  43.8913243, 8.0728799,
  43.8913411, 8.072946,
  43.8913672, 8.0729844,
  43.8913913, 8.0730906,
  43.8914332, 8.073175,
  43.8914538, 8.0732058,
  43.8914858, 8.0732489,
  43.8915257, 8.0732611,
  43.8915636, 8.0733011,
  43.8915947, 8.0733343,
  43.8916101, 8.073353,
  43.8916384, 8.0734224,
  43.8916917, 8.0735388,
  43.8917257, 8.0736301,
  43.8917608, 8.0737228,
  43.8917808, 8.0737793,
  43.8917799, 8.0738087,
  43.8917781, 8.0738829,
  43.891788, 8.0739573,
  43.8917932, 8.0740028,
  43.891807, 8.0740169,
  43.8918225, 8.0739514,
  43.8918235, 8.0738786,
  43.8918486, 8.0739263,
  43.8918771, 8.0740053,
  43.8919057, 8.0740714,
  43.8919364, 8.0741352,
  43.8919886, 8.0741858,
  43.8920365, 8.0742433,
  43.8920917, 8.0743292,
  43.8921185, 8.0743897,
  43.8921237, 8.0744099,
  43.8921653, 8.0744547,
  43.8922223, 8.0745106,
  43.8922513, 8.0745916,
  43.8922845, 8.0746373,
  43.8923226, 8.0746969,
  43.8923798, 8.074762,
  43.8924, 8.0748118,
  43.892443, 8.0748639,
  43.8924849, 8.0749266,
  43.8925449, 8.0750071,
  43.8925744, 8.0750451,
  43.8925832, 8.0750716,
  43.8925894, 8.0751382,
  43.8925953, 8.075178,
  43.8926333, 8.0751652,
  43.8926776, 8.0751901,
  43.8927294, 8.0752657,
  43.8927678, 8.0753286,
  43.8928056, 8.0753854,
  43.892842, 8.0754175,
  43.8928918, 8.0754558,
  43.8929548, 8.0755227,
  43.8929932, 8.0755688,
  43.8930334, 8.0756238,
  43.8930816, 8.0756571,
  43.8931199, 8.0756941,
  43.8931522, 8.0757596,
  43.8931832, 8.0758247,
  43.8932123, 8.0758806,
  43.8932455, 8.0759136,
  43.8933137, 8.0759549,
  43.8933876, 8.0760107,
  43.8933939, 8.0760488,
  43.8934172, 8.0761179,
  43.893458, 8.0761612,
  43.8934808, 8.0762001,
  43.8935028, 8.0762563,
  43.8935251, 8.0763087,
  43.893539, 8.0763882,
  43.8935614, 8.0764615,
  43.8935945, 8.0765422,
  43.8936186, 8.0766091,
  43.893672, 8.0766883,
  43.8937056, 8.0767434,
  43.8937504, 8.0768203,
  43.8937846, 8.0768711,
  43.893808, 8.076927,
  43.8938196, 8.0769738,
  43.8938581, 8.0770314,
  43.8938976, 8.077102,
  43.8939285, 8.0771417,
  43.8939905, 8.0771797,
  43.8940391, 8.0772159,
  43.8940678, 8.0772807,
  43.894127, 8.0773301,
  43.894191, 8.0773829,
  43.8942393, 8.0774146,
  43.894299, 8.0774768,
  43.8943347, 8.0775095,
  43.8943701, 8.0775548,
  43.8943911, 8.0776039,
  43.8944281, 8.0776306,
  43.8944477, 8.0776434,
  43.8945023, 8.0776881,
  43.894553, 8.0777273,
  43.8945847, 8.0777613,
  43.8945927, 8.0777908,
  43.8946053, 8.0778196,
  43.8946374, 8.077817,
  43.8946898, 8.0778251,
  43.89473, 8.0778499,
  43.8947795, 8.0778812,
  43.8948395, 8.0779171,
  43.8948787, 8.0779553,
  43.894934, 8.0780075,
  43.8950118, 8.0780892,
  43.8950792, 8.0781288,
  43.8951116, 8.0781542,
  43.8951569, 8.0781966,
  43.8951899, 8.0782451,
  43.8952047, 8.0782829,
  43.8952378, 8.0783228,
  43.8952752, 8.0783608,
  43.8953012, 8.0783963,
  43.8953228, 8.0784414,
  43.8953606, 8.0785129,
  43.8953855, 8.0785344,
  43.8954094, 8.0785109,
  43.89544, 8.0785453,
  43.8954667, 8.0785861,
  43.8954894, 8.0786254,
  43.8955229, 8.0786373,
  43.8955416, 8.0787011,
  43.8955803, 8.0787751,
  43.8956233, 8.0788087,
  43.8956584, 8.0788713,
  43.8956802, 8.0789027,
  43.8957232, 8.0789511,
  43.8957598, 8.0789901,
  43.895792, 8.0790272,
  43.8958269, 8.0790578,
  43.8958696, 8.0790683,
  43.8958994, 8.0790731,
  43.8959356, 8.0790813,
  43.8959648, 8.0790965,
  43.8959847, 8.0791052,
  43.8960204, 8.0791328,
  43.8960563, 8.0791529,
  43.8960823, 8.079168,
  43.8961627, 8.07922,
  43.8962117, 8.0792034,
  43.8962622, 8.0792278,
  43.896413, 8.0793328,
  43.8965527, 8.0794675,
  43.8968063, 8.0798204,
  43.896969, 8.080046,
  43.8971106, 8.0802991,
  43.8972678, 8.0806284,
  43.8974067, 8.0809085,
  43.8975012, 8.0811701,
  43.8975101, 8.0813079,
  43.8975017, 8.0815375,
  43.8974934, 8.0817438,
  43.8974954, 8.0818411,
  43.8974819, 8.081991,
  43.8974783, 8.0821184,
  43.8974786, 8.0822595,
  43.897464, 8.0824262,
  43.8974595, 8.0826256,
  43.8974697, 8.0827251,
  43.8975002, 8.0828129,
  43.8975625, 8.0828799,
  43.8976357, 8.0829037,
  43.8976933, 8.0829123,
  43.8977348, 8.0828767,
  43.8977862, 8.0828027,
  43.897816, 8.0827378,
  43.8978299, 8.0826438,
  43.8978039, 8.0825578,
  43.8977665, 8.0825189,
  43.8977245, 8.0824886,
  43.8977096, 8.0824275,
  43.8977075, 8.0823418,
  43.8977062, 8.0820354,
  43.8977134, 8.0818529,
  43.8977145, 8.0816685,
  43.8977121, 8.081308,
  43.8976722, 8.0809392,
  43.8976662, 8.0807592,
  43.8976931, 8.080589,
  43.8977525, 8.0804614,
  43.8978491, 8.0803271,
  43.8979101, 8.0802573,
  43.8979072, 8.0802195,
  43.8978639, 8.080239,
  43.8978503, 8.0802038,
  43.8978199, 8.0801262,
  43.8978153, 8.080004,
  43.8978312, 8.0799142,
  43.8979288, 8.0798951,
  43.898033, 8.0797707,
  43.8981948, 8.0796933,
  43.8982187, 8.0796391,
  43.8981891, 8.0795922,
  43.8980843, 8.0796174,
  43.8980809, 8.0795309,
  43.898085, 8.0794505,
  43.8981066, 8.0793868,
  43.8981838, 8.079332,
  43.8982122, 8.0793126,
  43.8982255, 8.0793459,
  43.8982427, 8.0793952,
  43.8982424, 8.079461,
  43.8982751, 8.0795251,
  43.898321, 8.0795102,
  43.8983309, 8.0794648,
  43.8983198, 8.0793937,
  43.8983186, 8.0793228,
  43.8983202, 8.0792448,
  43.8984776, 8.0791654,
  43.8985919, 8.0791518,
  43.898736, 8.0791474,
  43.8988163, 8.079132,
  43.8989206, 8.0790665,
  43.8989917, 8.0790035,
  43.8990361, 8.0789647,
  43.899147, 8.0789077,
  43.8992481, 8.0788935,
  43.8992846, 8.0789306,
  43.899289, 8.0789963,
  43.8992705, 8.0790581,
  43.899267, 8.0791033,
  43.8993023, 8.07914,
  43.8993551, 8.0791476,
  43.8993942, 8.0791306,
  43.8994234, 8.0790834,
  43.8994201, 8.0790238,
  43.8993631, 8.0789865,
  43.8993315, 8.0789249,
  43.8992912, 8.0788557,
  43.8993116, 8.0787924,
  43.8993674, 8.0787128,
  43.8994432, 8.0786393,
  43.8997413, 8.0782764,
  43.8998019, 8.0782092,
  43.9000115, 8.0779983,
  43.9000779, 8.0779649,
  43.9001246, 8.0779933,
  43.9001686, 8.0779584,
  43.9001352, 8.0778836,
  43.9001908, 8.0778429,
  43.9002871, 8.0778122,
  43.9003918, 8.0778101,
  43.9004335, 8.0778279,
  43.9004689, 8.0778715,
  43.9005754, 8.0781364,
  43.9005944, 8.0781542,
  43.9006574, 8.0781073,
  43.9006549, 8.0780745,
  43.9006023, 8.0779484,
  43.9005925, 8.0778918,
  43.9007319, 8.077727,
  43.9007529, 8.0776809,
  43.9007024, 8.0775637,
  43.900762, 8.0775143,
  43.9008203, 8.0774881,
  43.9008843, 8.0774791,
  43.9009496, 8.0774602,
  43.9009905, 8.0776356,
  43.9010955, 8.0775911,
  43.9010479, 8.0773632,
  43.9012062, 8.0773318,
  43.9013288, 8.0772992,
  43.9015223, 8.0772987,
  43.9017661, 8.0773289,
  43.9023091, 8.0774511,
  43.9025977, 8.0775606,
  43.9031598, 8.0777868,
  43.9032844, 8.0778446,
  43.9037381, 8.0780618,
  43.9039815, 8.078245,
  43.9040954, 8.078329,
  43.9046549, 8.0787253,
  43.9046242, 8.0787764,
  43.9046494, 8.0788056,
  43.904689, 8.0787438,
  43.90487, 8.0788967,
  43.9049895, 8.0789815,
  43.9049277, 8.079087,
  43.9049211, 8.07913,
  43.9049636, 8.0791688,
  43.9049809, 8.0791519,
  43.9050385, 8.0790679,
  43.9053087, 8.0793371,
  43.905269, 8.0794078,
  43.9053555, 8.0794946,
  43.9054672, 8.0795556,
  43.9055989, 8.0796968,
  43.9055217, 8.0798618,
  43.9055614, 8.0799017,
  43.9056363, 8.0797422,
  43.9058158, 8.0799546,
  43.9057236, 8.080131,
  43.9058963, 8.0802976,
  43.9059605, 8.0801787,
  43.9060282, 8.0802006,
  43.9061175, 8.080311,
  43.9062963, 8.0806182,
  43.9063292, 8.0806882,
  43.9058813, 8.0813234,
  43.9059952, 8.0814799,
  43.906017, 8.0814601,
  43.9060366, 8.0814288,
  43.9060656, 8.0813961,
  43.9060745, 8.0814065,
  43.9062594, 8.0811208,
  43.9063041, 8.0810513,
  43.9063937, 8.0809069,
  43.9064902, 8.0809342,
  43.9065712, 8.0809562,
  43.9066309, 8.0809881,
  43.9066862, 8.0810329,
  43.906748, 8.0810844,
  43.9068106, 8.0811379,
  43.906859, 8.081195,
  43.9069135, 8.0812609,
  43.9069703, 8.0813292,
  43.9070275, 8.0813924,
  43.9070754, 8.0814562,
  43.9071249, 8.0815127,
  43.9071821, 8.0815752,
  43.9072278, 8.0816373,
  43.9072831, 8.0817082,
  43.9073373, 8.0817743,
  43.9073925, 8.0818402,
  43.9074485, 8.0819049,
  43.9075054, 8.081967,
  43.9075512, 8.0820276,
  43.9076024, 8.082102,
  43.9076517, 8.0821754,
  43.9076909, 8.082244,
  43.9077293, 8.0823129,
  43.9077732, 8.082376,
  43.9078299, 8.0824558,
  43.9078665, 8.0825125,
  43.9078892, 8.0825523,
  43.9079397, 8.0826506,
  43.9079618, 8.0827044,
  43.9079851, 8.0827717,
  43.9080091, 8.0828455,
  43.9080392, 8.0829082,
  43.9080996, 8.0830748,
  43.9081252, 8.0831508,
  43.9081683, 8.0832893,
  43.9081992, 8.0833804,
  43.9082105, 8.0834219,
  43.9081046, 8.0835519,
  43.9079669, 8.0837458,
  43.9078259, 8.0839133,
  43.9077509, 8.083993,
  43.907704, 8.084043,
  43.9076601, 8.0840619,
  43.9076233, 8.0840831,
  43.9075915, 8.0841058,
  43.9075667, 8.0841264,
  43.9075386, 8.0841486,
  43.9075203, 8.0841652,
  43.9074928, 8.0841956,
  43.9074754, 8.0842223,
  43.9074582, 8.0842546,
  43.9074324, 8.08432,
  43.9074182, 8.0843794,
  43.9074146, 8.0844132,
  43.9074142, 8.0844428,
  43.9074156, 8.0844708,
  43.9074179, 8.0844937,
  43.9074217, 8.0845185,
  43.9074258, 8.0845419,
  43.907431, 8.0845722,
  43.9074385, 8.0845989,
  43.9074467, 8.0846236,
  43.9074557, 8.0846429,
  43.9074679, 8.0846614,
  43.9074823, 8.0846795,
  43.9074934, 8.0846914,
  43.9075062, 8.0847044,
  43.9075201, 8.0847172,
  43.9075648, 8.0847456,
  43.9075892, 8.0847561,
  43.9076178, 8.0847642,
  43.907636, 8.0847663,
  43.9076835, 8.0847656,
  43.9077039, 8.0847622,
  43.9077242, 8.084754,
  43.9077454, 8.0847436,
  43.9077646, 8.0847325,
  43.9077876, 8.0847177,
  43.9078061, 8.0846998,
  43.907832, 8.0846726,
  43.9078437, 8.0846565,
  43.9078603, 8.084631,
  43.9078728, 8.0846066,
  43.9078876, 8.0845753,
  43.9078977, 8.0845502,
  43.9079122, 8.0845091,
  43.9079216, 8.0844735,
  43.9079296, 8.0844435,
  43.9079387, 8.0844044,
  43.9079501, 8.0843665,
  43.907963, 8.0843293,
  43.9079745, 8.0843086,
  43.9079879, 8.0842846,
  43.907994, 8.0842735,
  43.908067, 8.0841826,
  43.9081642, 8.0840733,
  43.9081972, 8.0840323,
  43.9082177, 8.0840043,
  43.9082294, 8.0839866,
  43.9082469, 8.0839685,
  43.9082651, 8.0839545,
  43.9082869, 8.0839402,
  43.9083048, 8.0839255,
  43.9083236, 8.0839054,
  43.9083433, 8.0838806,
  43.9083565, 8.0838632,
  43.9083725, 8.0838494,
  43.9083882, 8.0838363,
  43.9084023, 8.0838202,
  43.908422, 8.0838039,
  43.9084431, 8.083795,
  43.9084685, 8.0837895,
  43.9084881, 8.0837877,
  43.9085099, 8.0837866,
  43.9085716, 8.0837945,
  43.9085925, 8.0837916,
  43.9086112, 8.0837869,
  43.908632, 8.0837901,
  43.9086501, 8.0837953,
  43.9086697, 8.0838005,
  43.9086916, 8.0838056,
  43.9087093, 8.0838065,
  43.9087346, 8.0838081,
  43.9087561, 8.0838081,
  43.9087811, 8.0838127,
  43.908803, 8.0838217,
  43.9088292, 8.0838365,
  43.9088481, 8.0838491,
  43.9088641, 8.0838644,
  43.9088878, 8.0838913,
  43.908903, 8.0839105,
  43.9089539, 8.0839795,
  43.90898, 8.0840336,
  43.9090434, 8.0841465,
  43.9091068, 8.0842924,
  43.9091316, 8.08435,
  43.9091487, 8.0843932,
  43.9091615, 8.0844422,
  43.9091714, 8.0844719,
  43.9091824, 8.0845187,
  43.9091951, 8.0845872,
  43.9092062, 8.0846642,
  43.9092112, 8.0847181,
  43.9092219, 8.0847908,
  43.9092247, 8.0848551,
  43.9092303, 8.0849121,
  43.9092287, 8.084968,
  43.9092268, 8.0850311,
  43.9092061, 8.0851498,
  43.9091774, 8.0853118,
  43.9091363, 8.0854576,
  43.9091093, 8.0855363,
  43.9090596, 8.085645,
  43.9090027, 8.085734,
  43.908973, 8.0857663,
  43.9089539, 8.0857832,
  43.9089247, 8.085779,
  43.9089089, 8.0857603,
  43.9088898, 8.0857454,
  43.9088725, 8.0857225,
  43.9088613, 8.0857171,
  43.908843, 8.0856958,
  43.9087905, 8.0856543,
  43.9087631, 8.0856298,
  43.9087197, 8.085602,
  43.9086788, 8.085581,
  43.9086079, 8.0855638,
  43.9086009, 8.0855677,
  43.9085883, 8.0855836,
  43.9085788, 8.0856049,
  43.9085768, 8.0856326,
  43.9085812, 8.0856621,
  43.9086017, 8.0856898,
  43.9086287, 8.0856983,
  43.9086564, 8.0857217,
  43.9086599, 8.0857749,
  43.9086955, 8.085819,
  43.90877, 8.0857046,
  43.9089019, 8.0858819,
  43.9088269, 8.0859841,
  43.908836, 8.0860171,
  43.9088595, 8.0860479,
  43.9088772, 8.0860643,
  43.9088957, 8.086073,
  43.9089133, 8.0860723,
  43.9089325, 8.0860665,
  43.9089509, 8.0860558,
  43.908982, 8.0860299,
  43.9090676, 8.0859368,
  43.9092327, 8.0857447,
  43.9093708, 8.0855741,
  43.9094636, 8.0854665,
  43.9095178, 8.085403,
  43.9095598, 8.0853553,
  43.909606, 8.0853059,
  43.9096324, 8.0852786,
  43.9096679, 8.0852461,
  43.9096943, 8.0852256,
  43.909707, 8.0852234,
  43.9097222, 8.0852325,
  43.9097199, 8.0852845,
  43.9097286, 8.0853174,
  43.9097704, 8.0853041,
  43.9098111, 8.0852879,
  43.9099545, 8.0854912,
  43.9092213, 8.0863417,
  43.9092431, 8.0863709,
  43.9099751, 8.0855285,
  43.9101281, 8.085758,
  43.9094897, 8.0865242,
  43.9095091, 8.0865551,
  43.9101524, 8.0857945,
  43.9102643, 8.0859487,
  43.9102707, 8.0860182,
  43.9099557, 8.0864798,
  43.9096758, 8.0868876,
  43.9096327, 8.0869153,
  43.9092411, 8.0867499,
  43.9089269, 8.0866204,
  43.9086852, 8.0865218,
  43.9082942, 8.0863567,
  43.908358, 8.0861273,
  43.9083291, 8.0861127,
  43.9082699, 8.0863382,
  43.9082148, 8.0862991,
  43.9081945, 8.0862864,
  43.9081778, 8.0862645,
  43.9081586, 8.0862337,
  43.9081497, 8.0862065,
  43.9081446, 8.0861689,
  43.9081355, 8.0861305,
  43.9081254, 8.0860945,
  43.9081158, 8.0860631,
  43.9081059, 8.0860407,
  43.9080872, 8.0860117,
  43.9080678, 8.0859941,
  43.9080387, 8.085983,
  43.9080072, 8.0859842,
  43.9079848, 8.0859942,
  43.9079616, 8.0860136,
  43.9079413, 8.0860432,
  43.9079302, 8.0860764,
  43.9079235, 8.0861049,
  43.9079192, 8.086135,
  43.9079221, 8.0861707,
  43.9079372, 8.0862176,
  43.9079592, 8.0862697,
  43.9079715, 8.0863003,
  43.9079924, 8.0863408,
  43.908018, 8.086386,
  43.9080421, 8.0864219,
  43.9080758, 8.0864661,
  43.9081028, 8.0864988,
  43.9081274, 8.0865382,
  43.9081733, 8.0865591,
  43.908206, 8.0865925,
  43.9082447, 8.0866066,
  43.9082793, 8.0866212,
  43.9083196, 8.0866338,
  43.908353, 8.0866463,
  43.9083964, 8.0866654,
  43.9084412, 8.0866818,
  43.9085087, 8.08671,
  43.9085385, 8.0867244,
  43.9086262, 8.0867604,
  43.908719, 8.0868061,
  43.908765, 8.0868193,
  43.9088058, 8.0868324,
  43.908852, 8.0868487,
  43.9089178, 8.0868777,
  43.9089556, 8.086897,
  43.9089933, 8.0869182,
  43.9090319, 8.0869366,
  43.9090804, 8.0869562,
  43.9091299, 8.0869745,
  43.9091752, 8.0869878,
  43.9092532, 8.0870243,
  43.9093072, 8.08705,
  43.9093617, 8.0870756,
  43.909412, 8.0870986,
  43.9094559, 8.0871201,
  43.9094958, 8.0871367,
  43.9095431, 8.0871569,
  43.909589, 8.0871772,
  43.9096314, 8.0871882,
  43.909664, 8.0871768,
  43.9096784, 8.0871612,
  43.9096917, 8.087152,
  43.9097095, 8.0871277,
  43.9097331, 8.0870962,
  43.9097695, 8.0870477,
  43.9098062, 8.0869985,
  43.9098387, 8.0869513,
  43.9098993, 8.0868534,
  43.9100385, 8.0866369,
  43.9101311, 8.0864845,
  43.9101924, 8.0863905,
  43.9102219, 8.0863461,
  43.9102455, 8.0863131,
  43.9102753, 8.0862702,
  43.9103031, 8.0862273,
  43.9103255, 8.0861908,
  43.9103476, 8.0861531,
  43.9103548, 8.0861374,
  43.910381, 8.0860876,
  43.9104056, 8.0860498,
  43.9105441, 8.0862014,
  43.9106541, 8.0863326,
  43.9106153, 8.0864064,
  43.9105691, 8.0865086,
  43.910551, 8.0865489,
  43.9105409, 8.086584,
  43.9105294, 8.0866266,
  43.9105312, 8.0866468,
  43.9105459, 8.0866659,
  43.9105573, 8.086673,
  43.9105743, 8.0866824,
  43.9105878, 8.0866846,
  43.9106065, 8.0866781,
  43.9106197, 8.0866488,
  43.9106294, 8.0866232,
  43.9106475, 8.086584,
  43.9106681, 8.0865416,
  43.9106873, 8.0864994,
  43.9107073, 8.0864589,
  43.9107216, 8.0864338,
  43.9107348, 8.0864212,
  43.9107528, 8.0864154,
  43.9107743, 8.0864193,
  43.9108011, 8.0864361,
  43.9108158, 8.0864456,
  43.9108382, 8.086469,
  43.9108527, 8.0864958,
  43.9108086, 8.0865592,
  43.9108202, 8.0865776,
  43.910863, 8.0865227,
  43.9108785, 8.0865447,
  43.9108872, 8.0865753,
  43.9108972, 8.0866094,
  43.9109063, 8.0866415,
  43.9109153, 8.0866787,
  43.9109226, 8.0867121,
  43.9109273, 8.0867385,
  43.910928, 8.0867629,
  43.9109225, 8.0867857,
  43.9109079, 8.0868198,
  43.9108842, 8.0868528,
  43.9108583, 8.0868863,
  43.9108333, 8.0869182,
  43.9108049, 8.0869459,
  43.910777, 8.0869634,
  43.9107622, 8.0869667,
  43.9107358, 8.0869505,
  43.9107171, 8.0869394,
  43.9106953, 8.0869311,
  43.9106771, 8.0869365,
  43.9106371, 8.0869659,
  43.9106308, 8.0869894,
  43.9106327, 8.0870264,
  43.9106481, 8.0870604,
  43.910666, 8.0870792,
  43.9106968, 8.087097,
  43.9107191, 8.0870992,
  43.9107384, 8.0871021,
  43.9107599, 8.0871041,
  43.9107841, 8.0871046,
  43.9108088, 8.0870861,
  43.9108343, 8.0870728,
  43.9108644, 8.0870512,
  43.9108912, 8.0870228,
  43.9109173, 8.0869916,
  43.9109372, 8.0869641,
  43.9109506, 8.0869499,
  43.9109737, 8.086934,
  43.9109959, 8.0869243,
  43.911033, 8.0869117,
  43.9110631, 8.0869053,
  43.9110871, 8.0868987,
  43.9111183, 8.0868935,
  43.9111523, 8.0868895,
  43.9112089, 8.0868809,
  43.9112348, 8.0868615,
  43.9112595, 8.0868393,
  43.9112799, 8.0868234,
  43.9113025, 8.0868133,
  43.91134, 8.0868119,
  43.9113802, 8.0868293,
  43.9114115, 8.0868475,
  43.9114454, 8.086877,
  43.911475, 8.0869076,
  43.9115117, 8.0869452,
  43.9115369, 8.0869743,
  43.9115596, 8.0870009,
  43.9115788, 8.0870255,
  43.9115759, 8.0870573,
  43.9116043, 8.087167,
  43.9116463, 8.0872567,
  43.911679, 8.0873497,
  43.9117205, 8.0874906,
  43.9117351, 8.0875671,
  43.9117394, 8.0876264,
  43.9117273, 8.0876769,
  43.9116966, 8.0877087,
  43.9116745, 8.0877367,
  43.9116518, 8.0877681,
  43.9116411, 8.0877857,
  43.9116343, 8.087799,
  43.9116328, 8.0878366,
  43.9116466, 8.0878613,
  43.9116635, 8.0878784,
  43.9116817, 8.087884,
  43.9116997, 8.0878617,
  43.9117537, 8.0877994,
  43.9117703, 8.0877719,
  43.911911, 8.0879484,
  43.9120138, 8.0880997,
  43.9121072, 8.0882294,
  43.9121695, 8.0883181,
  43.9122069, 8.0883916,
  43.9122411, 8.0884067,
  43.912282, 8.0883502,
  43.9122442, 8.0882813,
  43.9121773, 8.088197,
  43.9120932, 8.0880781,
  43.9119982, 8.087929,
  43.9118246, 8.0876898,
  43.9118512, 8.0876214,
  43.9118803, 8.0876008,
  43.9119211, 8.087606,
  43.9119392, 8.0876167,
  43.9119654, 8.0876381,
  43.9119813, 8.0876565,
  43.9120016, 8.0876815,
  43.9120187, 8.0877026,
  43.9120297, 8.087716,
  43.9120399, 8.0877232,
  43.9120524, 8.0877247,
  43.9120654, 8.0877182,
  43.9120793, 8.0877122,
  43.912097, 8.0877103,
  43.9121163, 8.0877112,
  43.9121439, 8.0876996,
  43.9121788, 8.0877008,
  43.9122128, 8.0876995,
  43.912258, 8.0877075,
  43.9123213, 8.0877334,
  43.9123509, 8.0877497,
  43.9123806, 8.0877725,
  43.9124189, 8.0878023,
  43.9124408, 8.087823,
  43.9124594, 8.0878344,
  43.9124854, 8.0878646,
  43.9125086, 8.0878884,
  43.9125395, 8.0879255,
  43.9125836, 8.0879695,
  43.9126191, 8.0880098,
  43.9126379, 8.0880344,
  43.9126587, 8.0880634,
  43.9126774, 8.0880902,
  43.9126947, 8.0881169,
  43.9127266, 8.0881662,
  43.91276, 8.0882408,
  43.9127659, 8.0882792,
  43.9127656, 8.088301,
  43.9127568, 8.0883229,
  43.9127487, 8.088343,
  43.9127517, 8.0883655,
  43.9127648, 8.0883793,
  43.9127813, 8.0883778,
  43.9127948, 8.0883718,
  43.9128177, 8.0883785,
  43.9128655, 8.0884544,
  43.912876, 8.0884703,
  43.9128938, 8.0884935,
  43.912866, 8.0885484,
  43.912885, 8.0885701,
  43.9129193, 8.088542,
  43.9129423, 8.0885775,
  43.9129613, 8.088597,
  43.9129846, 8.0886206,
  43.9130103, 8.0886528,
  43.9130316, 8.0886783,
  43.9130437, 8.0886942,
  43.913174, 8.0888879,
  43.9132292, 8.0887793,
  43.9132472, 8.0887559,
  43.9132634, 8.0887369,
  43.9132836, 8.0887466,
  43.9133051, 8.0887711,
  43.9133304, 8.0887999,
  43.9133408, 8.0888158,
  43.9133616, 8.0888397,
  43.9133831, 8.0888732,
  43.9134041, 8.088901,
  43.913451, 8.0889574,
  43.9134805, 8.0889837,
  43.9135098, 8.0890175,
  43.9135404, 8.0890533,
  43.9135716, 8.0890882,
  43.9135938, 8.0891193,
  43.9136188, 8.0891552,
  43.9136401, 8.0891919,
  43.9136644, 8.0892327,
  43.9136908, 8.0892717,
  43.9137051, 8.089294,
  43.9137171, 8.0893117,
  43.9137542, 8.0893513,
  43.9137948, 8.0893767,
  43.9138328, 8.0894072,
  43.9138496, 8.0894198,
  43.913872, 8.0894331,
  43.913904, 8.0894494,
  43.9139276, 8.0894599,
  43.9139517, 8.0894704,
  43.9139878, 8.0894816,
  43.9140241, 8.0894888,
  43.914047, 8.0894919,
  43.9140563, 8.0894945,
  43.9140791, 8.089514,
  43.9140825, 8.089535,
  43.9140769, 8.0895647,
  43.9140719, 8.0895822,
  43.9140681, 8.0896159,
  43.9140809, 8.0896371,
  43.9140986, 8.0896645,
  43.9141203, 8.0896992,
  43.914145, 8.0897358,
  43.914165, 8.0897648,
  43.9141761, 8.0897837,
  43.914187, 8.0898126,
  43.9141899, 8.0898383,
  43.9141889, 8.0898584,
  43.9141615, 8.0898932,
  43.9141713, 8.0899243,
  43.9141971, 8.0899376,
  43.9142801, 8.0898329,
  43.9143148, 8.0897895,
  43.914349, 8.0898337,
  43.9143802, 8.0898854,
  43.9144145, 8.0899289,
  43.9144425, 8.0899669,
  43.9144663, 8.0900124,
  43.9145088, 8.0900906,
  43.9145252, 8.0901316,
  43.9145448, 8.0901758,
  43.9145569, 8.0902231,
  43.914554, 8.0902544,
  43.9145163, 8.0903192,
  43.9144721, 8.0903674,
  43.914455, 8.0903984,
  43.9144526, 8.0904288,
  43.9144598, 8.0904512,
  43.9144711, 8.0904764,
  43.914482, 8.0904891,
  43.9144924, 8.0904971,
  43.9145047, 8.0905013,
  43.9145158, 8.0905011,
  43.9145259, 8.0904997,
  43.9145353, 8.0904909,
  43.9145494, 8.0904733,
  43.9145662, 8.0904551,
  43.9145834, 8.0904424,
  43.9146431, 8.0904031,
  43.9146788, 8.0903892,
  43.9146995, 8.0904124,
  43.9147212, 8.0904425,
  43.9147524, 8.0904783,
  43.9147948, 8.090566,
  43.9147976, 8.0906196,
  43.914763, 8.0906383,
  43.9147401, 8.0906389,
  43.9147224, 8.0906397,
  43.9147042, 8.0906527,
  43.9147194, 8.0907014,
  43.9147437, 8.0907372,
  43.914777, 8.0907589,
  43.9147998, 8.0907601,
  43.9148295, 8.0907581,
  43.9149195, 8.0907504,
  43.9149493, 8.0907563,
  43.9149734, 8.0907716,
  43.914993, 8.0908013,
  43.9150114, 8.0908278,
  43.9150583, 8.0909144,
  43.9151688, 8.0911076,
  43.9153185, 8.0914072,
  43.9154691, 8.0915925,
  43.9155233, 8.0916288,
  43.9155387, 8.09169,
  43.9155564, 8.0917334,
  43.9155832, 8.0917338,
  43.9156171, 8.0917399,
  43.9156665, 8.0917577,
  43.9157112, 8.0917667,
  43.9157374, 8.091776,
  43.9157647, 8.091789,
  43.9157905, 8.0917982,
  43.9158477, 8.0918232,
  43.9158804, 8.0918581,
  43.915896, 8.0918831,
  43.9159067, 8.0919122,
  43.9159658, 8.0920398,
  43.9158376, 8.0921452,
  43.9158205, 8.0921696,
  43.9158217, 8.0921863,
  43.9158301, 8.092201,
  43.9158444, 8.0922112,
  43.9158581, 8.092213,
  43.9158704, 8.0922152,
  43.9158925, 8.0922319,
  43.9159077, 8.0922555,
  43.9159207, 8.0922883,
  43.9159299, 8.0923151,
  43.9159326, 8.092345,
  43.9159222, 8.0923599,
  43.9159155, 8.0923896,
  43.9159182, 8.092416,
  43.9159249, 8.0924393,
  43.9159382, 8.0924644,
  43.9159485, 8.0924747,
  43.91598, 8.0924685,
  43.916102, 8.0923634,
  43.9161324, 8.0924027,
  43.9161419, 8.0924239,
  43.916152, 8.0924534,
  43.9161593, 8.0924793,
  43.9161673, 8.0925076,
  43.9161724, 8.0925311,
  43.9161767, 8.0925518,
  43.9160361, 8.0926761,
  43.9159717, 8.0927444,
  43.9159392, 8.0927908,
  43.9159181, 8.0928207,
  43.9159085, 8.0928465,
  43.9159051, 8.0928703,
  43.9159103, 8.0928897,
  43.9159237, 8.0929054,
  43.9159423, 8.0929172,
  43.9159587, 8.0929194,
  43.9159758, 8.0929086,
  43.9159906, 8.0928881,
  43.9160097, 8.0928543,
  43.9160306, 8.0928075,
  43.9160764, 8.0927477,
  43.9161277, 8.0927024,
  43.9162134, 8.0926397,
  43.9162305, 8.0926569,
  43.916239, 8.0926615,
  43.9162608, 8.0926887,
  43.9163086, 8.0927494,
  43.9163733, 8.0928479,
  43.9163943, 8.092908,
  43.9163993, 8.0929444,
  43.9163614, 8.0929802,
  43.9163097, 8.0930259,
  43.9162624, 8.0930626,
  43.9162382, 8.0931191,
  43.9162437, 8.0931604,
  43.9162767, 8.0931925,
  43.9163163, 8.0931696,
  43.9163406, 8.0931497,
  43.9163835, 8.0930977,
  43.9164292, 8.0931603,
  43.9164613, 8.0932099,
  43.9164781, 8.0932456,
  43.9165042, 8.0933022,
  43.9165224, 8.0933278,
  43.9165456, 8.0933786,
  43.9165557, 8.0933988,
  43.9165776, 8.0934381,
  43.9165728, 8.0934661,
  43.9165476, 8.0935017,
  43.9165136, 8.0935364,
  43.9164926, 8.093585,
  43.9165128, 8.0936174,
  43.9165517, 8.0936271,
  43.9165642, 8.093612,
  43.9165868, 8.0936779,
  43.9165964, 8.0937394,
  43.9166008, 8.0938195,
  43.9166039, 8.0938855,
  43.9165989, 8.0939693,
  43.9165959, 8.094064,
  43.9165804, 8.0942124
};

static inline std::vector<osmscout::Point> GetTestWay(){
  std::vector<osmscout::Point> out(TEST_WAY.size()/2);
  assert(TEST_WAY.size()%2==0);
  for (size_t i=0;i<TEST_WAY.size();i+=2){
    out[i/2]=osmscout::Point(0,osmscout::GeoCoord(TEST_WAY[i],TEST_WAY[i+1]));
  }
  return out;
}

#endif /* TEST_WAY_H */
