; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1200 < %s | FileCheck -check-prefix=GFX12 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx940 < %s | FileCheck -check-prefix=GFX940 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 < %s | FileCheck -check-prefix=GFX11 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 < %s | FileCheck -check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx90a < %s | FileCheck -check-prefix=GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx908 < %s | FileCheck -check-prefix=GFX908 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=tonga < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=hawaii < %s | FileCheck -check-prefix=GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=tahiti < %s | FileCheck -check-prefix=GFX6 %s

; --------------------------------------------------------------------
; float
; --------------------------------------------------------------------

define float @local_atomic_fadd_ret_f32(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_ret_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_f32:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX940-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_f32:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX90A-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_f32:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX908-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, v1
; GFX7-NEXT:    v_add_f32_e32 v1, 4.0, v2
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB0_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, v1
; GFX6-NEXT:    v_add_f32_e32 v1, 4.0, v2
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB0_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, float 4.0 seq_cst
  ret float %result
}

define float @local_atomic_fadd_ret_f32__offset(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_ret_f32__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_add_rtn_f32 v0, v0, v1 offset:65532
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_f32__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX940-NEXT:    ds_add_rtn_f32 v0, v0, v1 offset:65532
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_f32__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_add_rtn_f32 v0, v0, v1 offset:65532
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_f32__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_add_rtn_f32 v0, v0, v1 offset:65532
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_f32__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX90A-NEXT:    ds_add_rtn_f32 v0, v0, v1 offset:65532
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_f32__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX908-NEXT:    ds_add_rtn_f32 v0, v0, v1 offset:65532
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_f32__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_rtn_f32 v0, v0, v1 offset:65532
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_f32__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v1, v0 offset:65532
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, v1
; GFX7-NEXT:    v_add_f32_e32 v1, 4.0, v2
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65532
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB1_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_f32__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, 0xfffc, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v0, v1
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, v0
; GFX6-NEXT:    v_add_f32_e32 v0, 4.0, v2
; GFX6-NEXT:    ds_cmpst_rtn_b32 v0, v1, v2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v2
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB1_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(3) %ptr, i32 16383
  %result = atomicrmw fadd ptr addrspace(3) %gep, float 4.0 seq_cst
  ret float %result
}

define void @local_atomic_fadd_noret_f32(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_noret_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_add_f32 v0, v1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_f32:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX940-NEXT:    ds_add_f32 v0, v1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_add_f32 v0, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_add_f32 v0, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_f32:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX90A-NEXT:    ds_add_f32 v0, v1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_f32:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX908-NEXT:    ds_add_f32 v0, v1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_f32 v0, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v2, 4.0, v1
; GFX7-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB2_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v2, 4.0, v1
; GFX6-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v1, v2
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB2_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, float 4.0 seq_cst
  ret void
}

define void @local_atomic_fadd_noret_f32__offset(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_noret_f32__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_add_f32 v0, v1 offset:65532
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_f32__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX940-NEXT:    ds_add_f32 v0, v1 offset:65532
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_f32__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_add_f32 v0, v1 offset:65532
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_f32__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_add_f32 v0, v1 offset:65532
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_f32__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX90A-NEXT:    ds_add_f32 v0, v1 offset:65532
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_f32__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX908-NEXT:    ds_add_f32 v0, v1 offset:65532
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_f32__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_f32 v0, v1 offset:65532
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_f32__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v1, v0 offset:65532
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v2, 4.0, v1
; GFX7-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65532
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB3_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_f32__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffc, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v2, 4.0, v1
; GFX6-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v1, v2
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB3_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(3) %ptr, i32 16383
  %unused = atomicrmw fadd ptr addrspace(3) %gep, float 4.0 seq_cst
  ret void
}

; --------------------------------------------------------------------
; double
; --------------------------------------------------------------------

define double @local_atomic_fadd_ret_f64(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_ret_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, v0
; GFX12-NEXT:    ds_load_b64 v[0:1], v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, v1 :: v_dual_mov_b32 v3, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_f64_e32 v[0:1], 4.0, v[3:4]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b64 v[0:1], v2, v[0:1], v[3:4]
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[3:4]
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB4_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_f64:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b64_e32 v[2:3], 4.0
; GFX940-NEXT:    ds_add_rtn_f64 v[0:1], v0, v[2:3]
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-NEXT:    ds_load_b64 v[0:1], v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v4, v1 :: v_dual_mov_b32 v3, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b64 v[0:1], v2, v[0:1], v[3:4]
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[3:4]
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB4_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v2, v0
; GFX10-NEXT:    ds_read_b64 v[0:1], v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v1
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b64 v[0:1], v2, v[3:4], v[0:1]
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[3:4]
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB4_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_f64:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0x40100000
; GFX90A-NEXT:    ds_add_rtn_f64 v[0:1], v0, v[2:3]
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_f64:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v2, v0
; GFX908-NEXT:    ds_read_b64 v[0:1], v0
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v1
; GFX908-NEXT:    v_mov_b32_e32 v3, v0
; GFX908-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX908-NEXT:    ds_cmpst_rtn_b64 v[0:1], v2, v[3:4], v[0:1]
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[3:4]
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB4_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    ds_read_b64 v[0:1], v0
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, v0
; GFX8-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX8-NEXT:    ds_cmpst_rtn_b64 v[0:1], v2, v[3:4], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[3:4]
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB4_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v2, v0
; GFX7-NEXT:    ds_read_b64 v[0:1], v0
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v1
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX7-NEXT:    ds_cmpst_rtn_b64 v[0:1], v2, v[3:4], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[3:4]
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB4_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_f64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v2, v0
; GFX6-NEXT:    ds_read_b64 v[0:1], v0
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, v1
; GFX6-NEXT:    v_mov_b32_e32 v3, v0
; GFX6-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX6-NEXT:    ds_cmpst_rtn_b64 v[0:1], v2, v[3:4], v[0:1]
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[3:4]
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB4_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, double 4.0 seq_cst
  ret double %result
}

define double @local_atomic_fadd_ret_f64__offset(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_ret_f64__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, v0
; GFX12-NEXT:    ds_load_b64 v[0:1], v0 offset:65528
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, v1 :: v_dual_mov_b32 v3, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_f64_e32 v[0:1], 4.0, v[3:4]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b64 v[0:1], v2, v[0:1], v[3:4] offset:65528
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[3:4]
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB5_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_f64__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b64_e32 v[2:3], 4.0
; GFX940-NEXT:    ds_add_rtn_f64 v[0:1], v0, v[2:3] offset:65528
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_f64__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-NEXT:    ds_load_b64 v[0:1], v0 offset:65528
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v4, v1 :: v_dual_mov_b32 v3, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b64 v[0:1], v2, v[0:1], v[3:4] offset:65528
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[3:4]
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB5_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_f64__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v2, v0
; GFX10-NEXT:    ds_read_b64 v[0:1], v0 offset:65528
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v1
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b64 v[0:1], v2, v[3:4], v[0:1] offset:65528
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[3:4]
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB5_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_f64__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0x40100000
; GFX90A-NEXT:    ds_add_rtn_f64 v[0:1], v0, v[2:3] offset:65528
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_f64__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v2, v0
; GFX908-NEXT:    ds_read_b64 v[0:1], v0 offset:65528
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v1
; GFX908-NEXT:    v_mov_b32_e32 v3, v0
; GFX908-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX908-NEXT:    ds_cmpst_rtn_b64 v[0:1], v2, v[3:4], v[0:1] offset:65528
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[3:4]
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB5_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_f64__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    ds_read_b64 v[0:1], v0 offset:65528
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, v0
; GFX8-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX8-NEXT:    ds_cmpst_rtn_b64 v[0:1], v2, v[3:4], v[0:1] offset:65528
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[3:4]
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB5_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_f64__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v2, v0
; GFX7-NEXT:    ds_read_b64 v[0:1], v0 offset:65528
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v1
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX7-NEXT:    ds_cmpst_rtn_b64 v[0:1], v2, v[3:4], v[0:1] offset:65528
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[3:4]
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB5_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_f64__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, 0xfff8, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b64 v[0:1], v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, v1
; GFX6-NEXT:    v_mov_b32_e32 v3, v0
; GFX6-NEXT:    v_add_f64 v[0:1], v[3:4], 4.0
; GFX6-NEXT:    ds_cmpst_rtn_b64 v[0:1], v2, v[3:4], v[0:1]
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[3:4]
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB5_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr addrspace(3) %ptr, i32 8191
  %result = atomicrmw fadd ptr addrspace(3) %gep, double 4.0 seq_cst
  ret double %result
}

define void @local_atomic_fadd_noret_f64(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_noret_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    ds_load_b64 v[1:2], v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[3:4], 4.0, v[1:2]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b64 v[3:4], v0, v[3:4], v[1:2]
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[3:4], v[1:2]
; GFX12-NEXT:    v_dual_mov_b32 v1, v3 :: v_dual_mov_b32 v2, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB6_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_f64:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b64_e32 v[2:3], 4.0
; GFX940-NEXT:    ds_add_f64 v0, v[2:3]
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b64 v[1:2], v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_add_f64 v[3:4], v[1:2], 4.0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b64 v[3:4], v0, v[3:4], v[1:2]
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[3:4], v[1:2]
; GFX11-NEXT:    v_dual_mov_b32 v1, v3 :: v_dual_mov_b32 v2, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB6_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b64 v[1:2], v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_add_f64 v[3:4], v[1:2], 4.0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b64 v[3:4], v0, v[1:2], v[3:4]
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[3:4], v[1:2]
; GFX10-NEXT:    v_mov_b32_e32 v1, v3
; GFX10-NEXT:    v_mov_b32_e32 v2, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB6_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_f64:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0x40100000
; GFX90A-NEXT:    ds_add_f64 v0, v[2:3]
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_f64:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b64 v[1:2], v0
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_add_f64 v[3:4], v[1:2], 4.0
; GFX908-NEXT:    ds_cmpst_rtn_b64 v[3:4], v0, v[1:2], v[3:4]
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[3:4], v[1:2]
; GFX908-NEXT:    v_mov_b32_e32 v1, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v2, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB6_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b64 v[1:2], v0
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_add_f64 v[3:4], v[1:2], 4.0
; GFX8-NEXT:    ds_cmpst_rtn_b64 v[3:4], v0, v[1:2], v[3:4]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[3:4], v[1:2]
; GFX8-NEXT:    v_mov_b32_e32 v1, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v2, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB6_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b64 v[1:2], v0
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_add_f64 v[3:4], v[1:2], 4.0
; GFX7-NEXT:    ds_cmpst_rtn_b64 v[3:4], v0, v[1:2], v[3:4]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[3:4], v[1:2]
; GFX7-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v2, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB6_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_f64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b64 v[1:2], v0
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_add_f64 v[3:4], v[1:2], 4.0
; GFX6-NEXT:    ds_cmpst_rtn_b64 v[3:4], v0, v[1:2], v[3:4]
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[3:4], v[1:2]
; GFX6-NEXT:    v_mov_b32_e32 v1, v3
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v2, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB6_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, double 4.0 seq_cst
  ret void
}

define void @local_atomic_fadd_noret_f64__offset(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_noret_f64__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    ds_load_b64 v[1:2], v0 offset:65528
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[3:4], 4.0, v[1:2]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b64 v[3:4], v0, v[3:4], v[1:2] offset:65528
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[3:4], v[1:2]
; GFX12-NEXT:    v_dual_mov_b32 v1, v3 :: v_dual_mov_b32 v2, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB7_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_f64__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b64_e32 v[2:3], 4.0
; GFX940-NEXT:    ds_add_f64 v0, v[2:3] offset:65528
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_f64__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b64 v[1:2], v0 offset:65528
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_add_f64 v[3:4], v[1:2], 4.0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b64 v[3:4], v0, v[3:4], v[1:2] offset:65528
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[3:4], v[1:2]
; GFX11-NEXT:    v_dual_mov_b32 v1, v3 :: v_dual_mov_b32 v2, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB7_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_f64__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b64 v[1:2], v0 offset:65528
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_add_f64 v[3:4], v[1:2], 4.0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b64 v[3:4], v0, v[1:2], v[3:4] offset:65528
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[3:4], v[1:2]
; GFX10-NEXT:    v_mov_b32_e32 v1, v3
; GFX10-NEXT:    v_mov_b32_e32 v2, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB7_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_f64__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0x40100000
; GFX90A-NEXT:    ds_add_f64 v0, v[2:3] offset:65528
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_f64__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b64 v[1:2], v0 offset:65528
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_add_f64 v[3:4], v[1:2], 4.0
; GFX908-NEXT:    ds_cmpst_rtn_b64 v[3:4], v0, v[1:2], v[3:4] offset:65528
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[3:4], v[1:2]
; GFX908-NEXT:    v_mov_b32_e32 v1, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v2, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB7_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_f64__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b64 v[1:2], v0 offset:65528
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_add_f64 v[3:4], v[1:2], 4.0
; GFX8-NEXT:    ds_cmpst_rtn_b64 v[3:4], v0, v[1:2], v[3:4] offset:65528
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[3:4], v[1:2]
; GFX8-NEXT:    v_mov_b32_e32 v1, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v2, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB7_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_f64__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b64 v[1:2], v0 offset:65528
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_add_f64 v[3:4], v[1:2], 4.0
; GFX7-NEXT:    ds_cmpst_rtn_b64 v[3:4], v0, v[1:2], v[3:4] offset:65528
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[3:4], v[1:2]
; GFX7-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v2, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB7_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_f64__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, 0xfff8, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b64 v[0:1], v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_add_f64 v[3:4], v[0:1], 4.0
; GFX6-NEXT:    ds_cmpst_rtn_b64 v[3:4], v2, v[0:1], v[3:4]
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[3:4], v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v1, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB7_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr addrspace(3) %ptr, i32 8191
  %unused = atomicrmw fadd ptr addrspace(3) %gep, double 4.0 seq_cst
  ret void
}

; --------------------------------------------------------------------
; half
; --------------------------------------------------------------------

define half @local_atomic_fadd_ret_f16(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_ret_f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    ds_load_b32 v2, v1
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v0, 0xffff
; GFX12-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_not_b32_e32 v3, v3
; GFX12-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v4, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, v0, v4
; GFX12-NEXT:    v_add_f16_e32 v2, 4.0, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, v0, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v2, v1, v2, v4
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB8_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v0, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_f16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX940-NEXT:    ds_read_b32 v2, v1
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v0
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_and_b32_e32 v0, 24, v3
; GFX940-NEXT:    v_lshlrev_b32_e64 v3, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v3, v3
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, v2
; GFX940-NEXT:    v_lshrrev_b32_e32 v2, v0, v4
; GFX940-NEXT:    v_add_f16_e32 v2, 4.0, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, v0, v2
; GFX940-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX940-NEXT:    ds_cmpst_rtn_b32 v2, v1, v4, v2
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB8_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v0, v2
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    ds_load_b32 v2, v1
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v0, 0xffff
; GFX11-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_not_b32_e32 v3, v3
; GFX11-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, v0, v4
; GFX11-NEXT:    v_add_f16_e32 v2, 4.0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v2, v1, v2, v4
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB8_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    ds_read_b32 v2, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v0, 0xffff
; GFX10-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX10-NEXT:    v_not_b32_e32 v3, v3
; GFX10-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, v0, v4
; GFX10-NEXT:    v_add_f16_e32 v2, 4.0, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v2, v1, v4, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB8_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_f16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX90A-NEXT:    ds_read_b32 v2, v1
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_and_b32_e32 v0, 24, v3
; GFX90A-NEXT:    v_lshlrev_b32_e64 v3, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v3, v3
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, v2
; GFX90A-NEXT:    v_lshrrev_b32_e32 v2, v0, v4
; GFX90A-NEXT:    v_add_f16_e32 v2, 4.0, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, v0, v2
; GFX90A-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v2, v1, v4, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB8_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v0, v2
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_f16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX908-NEXT:    ds_read_b32 v2, v1
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v0
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_and_b32_e32 v0, 24, v3
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v3, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v2
; GFX908-NEXT:    v_lshrrev_b32_e32 v2, v0, v4
; GFX908-NEXT:    v_add_f16_e32 v2, 4.0, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, v0, v2
; GFX908-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX908-NEXT:    ds_cmpst_rtn_b32 v2, v1, v4, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB8_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v0, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v3, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v2, s4
; GFX8-NEXT:    v_not_b32_e32 v2, v2
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, v0, v4
; GFX8-NEXT:    v_add_f16_e32 v3, 4.0, v3
; GFX8-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v0, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB8_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v2
; GFX7-NEXT:    v_not_b32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, v0, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX7-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, v0, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX7-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB8_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_f16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v3, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX6-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v2
; GFX6-NEXT:    v_not_b32_e32 v2, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, v0, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX6-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, v0, v3
; GFX6-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX6-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB8_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, half 4.0 seq_cst
  ret half %result
}

define half @local_atomic_fadd_ret_f16__offset(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_ret_f16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX12-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX12-NEXT:    ds_load_b32 v3, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX12-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v2, v2
; GFX12-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v1, v4
; GFX12-NEXT:    v_add_f16_e32 v3, 4.0, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v1, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v3, v0, v3, v4
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB9_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_f16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_u32_e32 v0, 0xfffe, v0
; GFX940-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX940-NEXT:    ds_read_b32 v2, v1
; GFX940-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX940-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v3, v0, s0
; GFX940-NEXT:    v_not_b32_e32 v3, v3
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, v2
; GFX940-NEXT:    v_lshrrev_b32_e32 v2, v0, v4
; GFX940-NEXT:    v_add_f16_e32 v2, 4.0, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, v0, v2
; GFX940-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX940-NEXT:    ds_cmpst_rtn_b32 v2, v1, v4, v2
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB9_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v0, v2
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_f16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX11-NEXT:    ds_load_b32 v3, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v2, v2
; GFX11-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v1, v4
; GFX11-NEXT:    v_add_f16_e32 v3, 4.0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v3, v0, v3, v4
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB9_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_f16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX10-NEXT:    ds_read_b32 v2, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v1, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v3, v3
; GFX10-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, v1, v4
; GFX10-NEXT:    v_add_f16_e32 v2, 4.0, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v2, v0, v4, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB9_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_f16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_u32_e32 v0, 0xfffe, v0
; GFX90A-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX90A-NEXT:    ds_read_b32 v2, v1
; GFX90A-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v3, v0, s4
; GFX90A-NEXT:    v_not_b32_e32 v3, v3
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, v2
; GFX90A-NEXT:    v_lshrrev_b32_e32 v2, v0, v4
; GFX90A-NEXT:    v_add_f16_e32 v2, 4.0, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, v0, v2
; GFX90A-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v2, v1, v4, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB9_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v0, v2
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_f16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_u32_e32 v0, 0xfffe, v0
; GFX908-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX908-NEXT:    ds_read_b32 v2, v1
; GFX908-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX908-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v0, s4
; GFX908-NEXT:    v_not_b32_e32 v3, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v2
; GFX908-NEXT:    v_lshrrev_b32_e32 v2, v0, v4
; GFX908-NEXT:    v_add_f16_e32 v2, 4.0, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, v0, v2
; GFX908-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX908-NEXT:    ds_cmpst_rtn_b32 v2, v1, v4, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB9_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v0, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_f16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffe, v0
; GFX8-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v3, v1
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX8-NEXT:    v_not_b32_e32 v2, v2
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, v0, v4
; GFX8-NEXT:    v_add_f16_e32 v3, 4.0, v3
; GFX8-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v0, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB9_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_f16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v1, vcc, 0xfffe, v0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v1
; GFX7-NEXT:    v_not_b32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, v1, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX7-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, v1, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX7-NEXT:    ds_cmpst_rtn_b32 v3, v0, v4, v3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB9_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v1, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_f16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, 0xfffe, v0
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v3, v0
; GFX6-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v1
; GFX6-NEXT:    v_not_b32_e32 v2, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, v1, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX6-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, v1, v3
; GFX6-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX6-NEXT:    ds_cmpst_rtn_b32 v3, v0, v4, v3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB9_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v1, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(3) %ptr, i32 32767
  %result = atomicrmw fadd ptr addrspace(3) %gep, half 4.0 seq_cst
  ret half %result
}

define void @local_atomic_fadd_noret_f16(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_noret_f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    ds_load_b32 v2, v1
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v0, 0xffff
; GFX12-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_not_b32_e32 v3, v3
; GFX12-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v4, v0, v2
; GFX12-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v4, v2, v3, v4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v4, v1, v4, v2
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX12-NEXT:    v_mov_b32_e32 v2, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB10_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_f16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX940-NEXT:    ds_read_b32 v3, v1
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX940-NEXT:    v_lshlrev_b32_e64 v2, v2, s0
; GFX940-NEXT:    v_not_b32_e32 v2, v2
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v0, v3
; GFX940-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX940-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX940-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB10_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    ds_load_b32 v2, v1
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v0, 0xffff
; GFX11-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_not_b32_e32 v3, v3
; GFX11-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, v0, v2
; GFX11-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v4, v2, v3, v4
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v4, v1, v4, v2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX11-NEXT:    v_mov_b32_e32 v2, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB10_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    ds_read_b32 v2, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v0, 0xffff
; GFX10-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX10-NEXT:    v_not_b32_e32 v3, v3
; GFX10-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, v0, v2
; GFX10-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v4, v2, v3, v4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v4, v1, v2, v4
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB10_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_f16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX90A-NEXT:    ds_read_b32 v3, v1
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX90A-NEXT:    v_lshlrev_b32_e64 v2, v2, s4
; GFX90A-NEXT:    v_not_b32_e32 v2, v2
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v0, v3
; GFX90A-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX90A-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB10_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_f16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX908-NEXT:    ds_read_b32 v3, v1
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX908-NEXT:    v_lshlrev_b32_e64 v2, v2, s4
; GFX908-NEXT:    v_not_b32_e32 v2, v2
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v4, v0, v3
; GFX908-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX908-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX908-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB10_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v3, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v2, s4
; GFX8-NEXT:    v_not_b32_e32 v2, v2
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, v0, v3
; GFX8-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX8-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX8-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX8-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB10_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v2
; GFX7-NEXT:    v_not_b32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, v0, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX7-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX7-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX7-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB10_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_f16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v3, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX6-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v2
; GFX6-NEXT:    v_not_b32_e32 v2, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, v0, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX6-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX6-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX6-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX6-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB10_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, half 4.0 seq_cst
  ret void
}

define void @local_atomic_fadd_noret_f16__offset(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_noret_f16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX12-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX12-NEXT:    ds_load_b32 v3, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX12-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v2, v2
; GFX12-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX12-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX12-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v4, v0, v4, v3
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v3
; GFX12-NEXT:    v_mov_b32_e32 v3, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB11_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_f16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_u32_e32 v1, 0xfffe, v0
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX940-NEXT:    ds_read_b32 v3, v0
; GFX940-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX940-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v2, v1, s0
; GFX940-NEXT:    v_not_b32_e32 v2, v2
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX940-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX940-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX940-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB11_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_f16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX11-NEXT:    ds_load_b32 v3, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v2, v2
; GFX11-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX11-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX11-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v4, v0, v4, v3
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB11_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_f16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX10-NEXT:    ds_read_b32 v3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v2, v2
; GFX10-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX10-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB11_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_f16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_u32_e32 v1, 0xfffe, v0
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX90A-NEXT:    ds_read_b32 v3, v0
; GFX90A-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX90A-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v2, v1, s4
; GFX90A-NEXT:    v_not_b32_e32 v2, v2
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX90A-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX90A-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB11_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_f16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_u32_e32 v1, 0xfffe, v0
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX908-NEXT:    ds_read_b32 v3, v0
; GFX908-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX908-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v2, v1, s4
; GFX908-NEXT:    v_not_b32_e32 v2, v2
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX908-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX908-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX908-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB11_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_f16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, 0xfffe, v0
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v3, v0
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v1, s4
; GFX8-NEXT:    v_not_b32_e32 v2, v2
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX8-NEXT:    v_add_f16_e32 v4, 4.0, v4
; GFX8-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX8-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX8-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB11_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_f16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v1, vcc, 0xfffe, v0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v1
; GFX7-NEXT:    v_not_b32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX7-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX7-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX7-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB11_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_f16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, 0xfffe, v0
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v3, v0
; GFX6-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v1
; GFX6-NEXT:    v_not_b32_e32 v2, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX6-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX6-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX6-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX6-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB11_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(3) %ptr, i32 32767
  %unused = atomicrmw fadd ptr addrspace(3) %gep, half 4.0 seq_cst
  ret void
}

define half @local_atomic_fadd_ret_f16__offset__align4(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_ret_f16__offset__align4:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    ds_load_b32 v1, v0 offset:65534
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v1, 4.0, v2
; GFX12-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v1, 0xffff0000, v2, v1
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:65534
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v1, v2
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB12_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_mov_b32_e32 v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_f16__offset__align4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_mov_b32 s2, 0xffff0000
; GFX940-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v2, v1
; GFX940-NEXT:    v_add_f16_e32 v1, 4.0, v2
; GFX940-NEXT:    v_and_or_b32 v1, v2, s2, v1
; GFX940-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB12_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v0, v1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_f16__offset__align4:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v1, v0 offset:65534
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v1, 4.0, v2
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v1, 0xffff0000, v2, v1
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:65534
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v1, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB12_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_f16__offset__align4:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v2, v1
; GFX10-NEXT:    v_add_f16_e32 v1, 4.0, v2
; GFX10-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX10-NEXT:    v_and_or_b32 v1, 0xffff0000, v2, v1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v1, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB12_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_f16__offset__align4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX90A-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_add_f16_e32 v1, 4.0, v2
; GFX90A-NEXT:    v_and_or_b32 v1, v2, s6, v1
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB12_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_f16__offset__align4:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX908-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v2, v1
; GFX908-NEXT:    v_add_f16_e32 v1, 4.0, v2
; GFX908-NEXT:    v_and_or_b32 v1, v2, s6, v1
; GFX908-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB12_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_f16__offset__align4:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, v1
; GFX8-NEXT:    v_add_f16_e32 v1, 4.0, v2
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX8-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX8-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB12_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_f16__offset__align4:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX7-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB12_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_f16__offset__align4:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffe, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX6-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB12_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(3) %ptr, i32 32767
  %result = atomicrmw fadd ptr addrspace(3) %gep, half 4.0 seq_cst, align 4
  ret half %result
}

define void @local_atomic_fadd_noret_f16__offset__align4(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_noret_f16__offset__align4:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    ds_load_b32 v1, v0 offset:65534
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_add_f16_e32 v2, 4.0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX12-NEXT:    v_and_or_b32 v2, 0xffff0000, v1, v2
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v2, v0, v2, v1 offset:65534
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX12-NEXT:    v_mov_b32_e32 v1, v2
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB13_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_f16__offset__align4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_mov_b32 s2, 0xffff0000
; GFX940-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_add_f16_e32 v2, 4.0, v1
; GFX940-NEXT:    v_and_or_b32 v2, v1, s2, v2
; GFX940-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v1, v2
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB13_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_f16__offset__align4:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v1, v0 offset:65534
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_add_f16_e32 v2, 4.0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    v_and_or_b32 v2, 0xffff0000, v1, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v2, v0, v2, v1 offset:65534
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX11-NEXT:    v_mov_b32_e32 v1, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB13_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_f16__offset__align4:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_add_f16_e32 v2, 4.0, v1
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX10-NEXT:    v_and_or_b32 v2, 0xffff0000, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX10-NEXT:    v_mov_b32_e32 v1, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB13_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_f16__offset__align4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX90A-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_add_f16_e32 v2, 4.0, v1
; GFX90A-NEXT:    v_and_or_b32 v2, v1, s6, v2
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB13_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_f16__offset__align4:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX908-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_add_f16_e32 v2, 4.0, v1
; GFX908-NEXT:    v_and_or_b32 v2, v1, s6, v2
; GFX908-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v1, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB13_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_f16__offset__align4:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_add_f16_e32 v2, 4.0, v1
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v1, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB13_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_f16__offset__align4:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX7-NEXT:    v_add_f32_e32 v2, 4.0, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB13_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_f16__offset__align4:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffe, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX6-NEXT:    v_add_f32_e32 v2, 4.0, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX6-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v1, v2
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB13_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(3) %ptr, i32 32767
  %unused = atomicrmw fadd ptr addrspace(3) %gep, half 4.0 seq_cst, align 4
  ret void
}

; --------------------------------------------------------------------
; bfloat
; --------------------------------------------------------------------

define bfloat @local_atomic_fadd_ret_bf16(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_ret_bf16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    ds_load_b32 v3, v1
; GFX12-NEXT:    v_lshlrev_b32_e64 v2, v0, 0xffff
; GFX12-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_not_b32_e32 v2, v2
; GFX12-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v0, v4
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX12-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v5, v5, v3, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v0, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v3, v1, v3, v4
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB14_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_bf16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX940-NEXT:    ds_read_b32 v3, v1
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX940-NEXT:    v_lshlrev_b32_e64 v2, v2, s0
; GFX940-NEXT:    v_not_b32_e32 v2, v2
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, v3
; GFX940-NEXT:    v_lshrrev_b32_sdwa v3, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX940-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX940-NEXT:    v_add3_u32 v5, v5, v3, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v3, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX940-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB14_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    ds_load_b32 v3, v1
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v0, 0xffff
; GFX11-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_not_b32_e32 v2, v2
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v0, v4
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX11-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v5, v5, v3, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v3, v1, v3, v4
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB14_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    ds_read_b32 v3, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v0, 0xffff
; GFX10-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX10-NEXT:    v_not_b32_e32 v2, v2
; GFX10-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_lshrrev_b32_sdwa v3, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX10-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_add3_u32 v5, v5, v3, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB14_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_bf16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX90A-NEXT:    ds_read_b32 v3, v1
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX90A-NEXT:    v_lshlrev_b32_e64 v2, v2, s4
; GFX90A-NEXT:    v_not_b32_e32 v2, v2
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, v3
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v3, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX90A-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX90A-NEXT:    v_add3_u32 v5, v5, v3, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v3, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB14_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_bf16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX908-NEXT:    ds_read_b32 v3, v1
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX908-NEXT:    v_lshlrev_b32_e64 v2, v2, s4
; GFX908-NEXT:    v_not_b32_e32 v2, v2
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_lshrrev_b32_sdwa v3, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX908-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX908-NEXT:    v_add3_u32 v5, v5, v3, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX908-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v3, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX908-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB14_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v3, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v2, s4
; GFX8-NEXT:    v_not_b32_e32 v2, v2
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_lshrrev_b32_sdwa v3, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX8-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v3
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v3
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v6, v7, vcc
; GFX8-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB14_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v2
; GFX7-NEXT:    v_not_b32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, v0, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, v0, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX7-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB14_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_bf16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v3, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX6-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v2
; GFX6-NEXT:    v_not_b32_e32 v2, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, v0, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, v0, v3
; GFX6-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX6-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB14_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, bfloat 4.0 seq_cst
  ret bfloat %result
}

define bfloat @local_atomic_fadd_ret_bf16__offset(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_ret_bf16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX12-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX12-NEXT:    ds_load_b32 v3, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX12-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v2, v2
; GFX12-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v1, v4
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX12-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v5, v5, v3, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v1, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v3, v0, v3, v4
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB15_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_bf16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_u32_e32 v0, 0xfffe, v0
; GFX940-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX940-NEXT:    ds_read_b32 v3, v1
; GFX940-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX940-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v2, v0, s0
; GFX940-NEXT:    v_not_b32_e32 v2, v2
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v4, v3
; GFX940-NEXT:    v_lshrrev_b32_sdwa v3, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX940-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX940-NEXT:    v_add3_u32 v5, v5, v3, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v3, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX940-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB15_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_bf16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX11-NEXT:    ds_load_b32 v3, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v2, v2
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v1, v4
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX11-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v5, v5, v3, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v3, v0, v3, v4
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB15_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_bf16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX10-NEXT:    ds_read_b32 v3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v2, v2
; GFX10-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_lshrrev_b32_sdwa v3, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX10-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_add3_u32 v5, v5, v3, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v3, v0, v4, v3
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB15_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_bf16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_u32_e32 v0, 0xfffe, v0
; GFX90A-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX90A-NEXT:    ds_read_b32 v3, v1
; GFX90A-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX90A-NEXT:    v_not_b32_e32 v2, v2
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, v3
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v3, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX90A-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX90A-NEXT:    v_add3_u32 v5, v5, v3, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v3, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB15_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_bf16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_u32_e32 v0, 0xfffe, v0
; GFX908-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX908-NEXT:    ds_read_b32 v3, v1
; GFX908-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX908-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX908-NEXT:    v_not_b32_e32 v2, v2
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_lshrrev_b32_sdwa v3, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX908-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX908-NEXT:    v_add3_u32 v5, v5, v3, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX908-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v3, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v3, v4, v2, v3
; GFX908-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB15_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_bf16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffe, v0
; GFX8-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v3, v1
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX8-NEXT:    v_not_b32_e32 v2, v2
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_lshrrev_b32_sdwa v3, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX8-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v3
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v3
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v6, v7, vcc
; GFX8-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    ds_cmpst_rtn_b32 v3, v1, v4, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB15_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_bf16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v1, vcc, 0xfffe, v0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v1
; GFX7-NEXT:    v_not_b32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, v1, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, v1, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX7-NEXT:    ds_cmpst_rtn_b32 v3, v0, v4, v3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB15_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v1, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_bf16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, 0xfffe, v0
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v3, v0
; GFX6-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v1
; GFX6-NEXT:    v_not_b32_e32 v2, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, v1, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_f32_e32 v3, 4.0, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_and_b32_e32 v5, v4, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, v1, v3
; GFX6-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX6-NEXT:    ds_cmpst_rtn_b32 v3, v0, v4, v3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB15_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v1, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(3) %ptr, i32 32767
  %result = atomicrmw fadd ptr addrspace(3) %gep, bfloat 4.0 seq_cst
  ret bfloat %result
}

define void @local_atomic_fadd_noret_bf16(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_noret_bf16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    ds_load_b32 v2, v1
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v0, 0xffff
; GFX12-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_not_b32_e32 v3, v3
; GFX12-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v4, v0, v2
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX12-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v5, v5, v4, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v4, v2, v3, v4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v4, v1, v4, v2
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX12-NEXT:    v_mov_b32_e32 v2, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB16_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_bf16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX940-NEXT:    ds_read_b32 v3, v1
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX940-NEXT:    v_lshlrev_b32_e64 v2, v2, s0
; GFX940-NEXT:    v_not_b32_e32 v2, v2
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v4, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX940-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX940-NEXT:    v_add3_u32 v5, v5, v4, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v4, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX940-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB16_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    ds_load_b32 v2, v1
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v0, 0xffff
; GFX11-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_not_b32_e32 v3, v3
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, v0, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX11-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v5, v5, v4, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v4, v2, v3, v4
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v4, v1, v4, v2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX11-NEXT:    v_mov_b32_e32 v2, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB16_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    ds_read_b32 v2, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v0, 0xffff
; GFX10-NEXT:    v_and_b32_e32 v0, 24, v0
; GFX10-NEXT:    v_not_b32_e32 v3, v3
; GFX10-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v4, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX10-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_add3_u32 v5, v5, v4, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v4, v2, v3, v4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v4, v1, v2, v4
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB16_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_bf16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX90A-NEXT:    ds_read_b32 v3, v1
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX90A-NEXT:    v_lshlrev_b32_e64 v2, v2, s4
; GFX90A-NEXT:    v_not_b32_e32 v2, v2
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v4, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX90A-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX90A-NEXT:    v_add3_u32 v5, v5, v4, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v4, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB16_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_bf16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX908-NEXT:    ds_read_b32 v3, v1
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX908-NEXT:    v_lshlrev_b32_e64 v2, v2, s4
; GFX908-NEXT:    v_not_b32_e32 v2, v2
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v4, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX908-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX908-NEXT:    v_add3_u32 v5, v5, v4, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX908-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v4, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX908-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB16_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v3, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v2, s4
; GFX8-NEXT:    v_not_b32_e32 v2, v2
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v4, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX8-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v4
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v4
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v6, v7, vcc
; GFX8-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX8-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB16_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v2
; GFX7-NEXT:    v_not_b32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, v0, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX7-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX7-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB16_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_bf16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, -4, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v3, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX6-NEXT:    v_and_b32_e32 v0, 24, v2
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v2
; GFX6-NEXT:    v_not_b32_e32 v2, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, v0, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, v0, v4
; GFX6-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX6-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB16_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, bfloat 4.0 seq_cst
  ret void
}

define void @local_atomic_fadd_noret_bf16__offset(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_noret_bf16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX12-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX12-NEXT:    ds_load_b32 v3, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX12-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v2, v2
; GFX12-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-NEXT:    v_add3_u32 v5, v5, v4, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX12-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v4, v0, v4, v3
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v3
; GFX12-NEXT:    v_mov_b32_e32 v3, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB17_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_bf16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_u32_e32 v1, 0xfffe, v0
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX940-NEXT:    ds_read_b32 v3, v0
; GFX940-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX940-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v2, v1, s0
; GFX940-NEXT:    v_not_b32_e32 v2, v2
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v4, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX940-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX940-NEXT:    v_add3_u32 v5, v5, v4, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v4, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX940-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB17_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_bf16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX11-NEXT:    ds_load_b32 v3, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v2, v2
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_add3_u32 v5, v5, v4, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX11-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v4, v0, v4, v3
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB17_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_bf16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0xfffe, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX10-NEXT:    ds_read_b32 v3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v2, v2
; GFX10-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v4, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX10-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_add3_u32 v5, v5, v4, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB17_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_bf16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_u32_e32 v1, 0xfffe, v0
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX90A-NEXT:    ds_read_b32 v3, v0
; GFX90A-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX90A-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v2, v1, s4
; GFX90A-NEXT:    v_not_b32_e32 v2, v2
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v4, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX90A-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX90A-NEXT:    v_add3_u32 v5, v5, v4, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v4, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB17_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_bf16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_u32_e32 v1, 0xfffe, v0
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX908-NEXT:    ds_read_b32 v3, v0
; GFX908-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX908-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v2, v1, s4
; GFX908-NEXT:    v_not_b32_e32 v2, v2
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v4, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX908-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX908-NEXT:    v_add3_u32 v5, v5, v4, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX908-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v4, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v4, v3, v2, v4
; GFX908-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB17_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_bf16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, 0xfffe, v0
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v3, v0
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v1, s4
; GFX8-NEXT:    v_not_b32_e32 v2, v2
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v4, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX8-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v4
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v4
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v6, v7, vcc
; GFX8-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX8-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB17_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_bf16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v1, vcc, 0xfffe, v0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v1
; GFX7-NEXT:    v_not_b32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX7-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX7-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB17_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_bf16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, 0xfffe, v0
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v3, v0
; GFX6-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v1
; GFX6-NEXT:    v_not_b32_e32 v2, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, v1, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_add_f32_e32 v4, 4.0, v4
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_and_b32_e32 v5, v3, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, v1, v4
; GFX6-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX6-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB17_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(3) %ptr, i32 32767
  %unused = atomicrmw fadd ptr addrspace(3) %gep, bfloat 4.0 seq_cst
  ret void
}

define bfloat @local_atomic_fadd_ret_bf16__offset__align4(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_ret_bf16__offset__align4:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    ds_load_b32 v1, v0 offset:65534
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX12-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX12-NEXT:    v_add3_u32 v3, v3, v1, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v1, 0xffff0000, v2, v1
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:65534
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v1, v2
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB18_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_mov_b32_e32 v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_bf16__offset__align4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:    s_mov_b32 s3, 0xffff0000
; GFX940-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v2, v1
; GFX940-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX940-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX940-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX940-NEXT:    v_add3_u32 v3, v3, v1, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX940-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX940-NEXT:    v_and_or_b32 v1, v2, s3, v1
; GFX940-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB18_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v0, v1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_bf16__offset__align4:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v1, v0 offset:65534
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX11-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_add3_u32 v3, v3, v1, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v1, 0xffff0000, v2, v1
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:65534
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v1, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB18_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_bf16__offset__align4:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v2, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX10-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX10-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX10-NEXT:    v_add3_u32 v3, v3, v1, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX10-NEXT:    v_and_or_b32 v1, 0xffff0000, v2, v1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v1, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB18_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_bf16__offset__align4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX90A-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX90A-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX90A-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX90A-NEXT:    v_add3_u32 v3, v3, v1, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX90A-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX90A-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX90A-NEXT:    v_and_or_b32 v1, v2, s7, v1
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB18_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_bf16__offset__align4:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX908-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v2, v1
; GFX908-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX908-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX908-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX908-NEXT:    v_add3_u32 v3, v3, v1, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX908-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX908-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX908-NEXT:    v_and_or_b32 v1, v2, s7, v1
; GFX908-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB18_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_bf16__offset__align4:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX8-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, v4, v1
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; GFX8-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX8-NEXT:    v_or_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB18_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_bf16__offset__align4:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1 offset:65534
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB18_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_bf16__offset__align4:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffe, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX6-NEXT:    v_add_f32_e32 v1, 4.0, v1
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB18_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(3) %ptr, i32 32767
  %result = atomicrmw fadd ptr addrspace(3) %gep, bfloat 4.0 seq_cst, align 4
  ret bfloat %result
}

define void @local_atomic_fadd_noret_bf16__offset__align4(ptr addrspace(3) %ptr) nounwind {
; GFX12-LABEL: local_atomic_fadd_noret_bf16__offset__align4:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    ds_load_b32 v1, v0 offset:65534
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v2, 4.0, v2
; GFX12-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v3, v3, v2, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    v_and_or_b32 v2, 0xffff0000, v1, v2
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_cmpstore_rtn_b32 v2, v0, v2, v1 offset:65534
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX12-NEXT:    v_mov_b32_e32 v1, v2
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB19_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_bf16__offset__align4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:    s_mov_b32 s3, 0xffff0000
; GFX940-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX940-NEXT:    v_add_f32_e32 v2, 4.0, v2
; GFX940-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX940-NEXT:    v_add3_u32 v3, v3, v2, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX940-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    v_and_or_b32 v2, v1, s3, v2
; GFX940-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v1, v2
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB19_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_bf16__offset__align4:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v1, v0 offset:65534
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v2, 4.0, v2
; GFX11-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v3, v3, v2, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_and_or_b32 v2, 0xffff0000, v1, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v2, v0, v2, v1 offset:65534
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX11-NEXT:    v_mov_b32_e32 v1, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB19_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_bf16__offset__align4:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX10-NEXT:    v_add_f32_e32 v2, 4.0, v2
; GFX10-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_add3_u32 v3, v3, v2, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    v_and_or_b32 v2, 0xffff0000, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX10-NEXT:    v_mov_b32_e32 v1, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB19_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_bf16__offset__align4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX90A-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX90A-NEXT:    v_add_f32_e32 v2, 4.0, v2
; GFX90A-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX90A-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX90A-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    v_and_or_b32 v2, v1, s7, v2
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB19_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_bf16__offset__align4:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX908-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX908-NEXT:    v_add_f32_e32 v2, 4.0, v2
; GFX908-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX908-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX908-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX908-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    v_and_or_b32 v2, v1, s7, v2
; GFX908-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v1, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB19_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_bf16__offset__align4:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_add_f32_e32 v2, 4.0, v2
; GFX8-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, v4, v2
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; GFX8-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc
; GFX8-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v1, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB19_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_bf16__offset__align4:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v1, v0 offset:65534
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v2, 4.0, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2 offset:65534
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB19_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_bf16__offset__align4:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffe, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX6-NEXT:    v_add_f32_e32 v2, 4.0, v2
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX6-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v1, v2
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB19_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(3) %ptr, i32 32767
  %unused = atomicrmw fadd ptr addrspace(3) %gep, bfloat 4.0 seq_cst, align 4
  ret void
}

; --------------------------------------------------------------------
; <2 x half>
; --------------------------------------------------------------------

define <2 x half> @local_atomic_fadd_ret_v2f16(ptr addrspace(3) %ptr, <2 x half> %val) {
; GFX12-LABEL: local_atomic_fadd_ret_v2f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_pk_add_rtn_f16 v0, v0, v1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_v2f16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_pk_add_rtn_f16 v0, v0, v1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v2, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v2, v3, v1
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v2, v0, v2, v3
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB20_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_v2f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v2, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    v_pk_add_f16 v2, v3, v1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v2, v0, v3, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB20_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_v2f16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v2, v0
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    v_pk_add_f16 v2, v3, v1
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v2, v0, v3, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB20_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_v2f16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v2, v0
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    v_pk_add_f16 v2, v3, v1
; GFX908-NEXT:    ds_cmpst_rtn_b32 v2, v0, v3, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB20_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v2, v0
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    v_add_f16_sdwa v2, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v4, v3, v1
; GFX8-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX8-NEXT:    ds_cmpst_rtn_b32 v2, v0, v3, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB20_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_v2f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v1
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v7, v2, v1
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v5
; GFX7-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX7-NEXT:    ds_cmpst_rtn_b32 v5, v0, v7, v1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB20_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_v2f16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v3, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v1
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX6-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v7, v2, v1
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v5
; GFX6-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX6-NEXT:    ds_cmpst_rtn_b32 v5, v0, v7, v1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB20_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v0, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(3) %ptr, i32 16383
  %result = atomicrmw fadd ptr addrspace(3) %ptr, <2 x half> %val seq_cst
  ret <2 x half> %result
}

define <2 x half> @local_atomic_fadd_ret_v2f16__offset(ptr addrspace(3) %ptr, <2 x half> %val) {
; GFX12-LABEL: local_atomic_fadd_ret_v2f16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_pk_add_rtn_f16 v0, v0, v1 offset:65532
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_v2f16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_pk_add_rtn_f16 v0, v0, v1 offset:65532
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_v2f16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v2, v0 offset:65532
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v2, v3, v1
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v2, v0, v2, v3 offset:65532
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB21_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_v2f16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    v_pk_add_f16 v2, v3, v1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v2, v0, v3, v2 offset:65532
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB21_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_v2f16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    v_pk_add_f16 v2, v3, v1
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v2, v0, v3, v2 offset:65532
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB21_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_v2f16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    v_pk_add_f16 v2, v3, v1
; GFX908-NEXT:    ds_cmpst_rtn_b32 v2, v0, v3, v2 offset:65532
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB21_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_v2f16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    v_add_f16_sdwa v2, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v4, v3, v1
; GFX8-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX8-NEXT:    ds_cmpst_rtn_b32 v2, v0, v3, v2 offset:65532
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB21_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_v2f16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v0 offset:65532
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v1
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v7, v2, v1
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v5
; GFX7-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX7-NEXT:    ds_cmpst_rtn_b32 v5, v0, v7, v1 offset:65532
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB21_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_v2f16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, 0xfffc, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v4, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v1
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX6-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v7, v0, v1
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; GFX6-NEXT:    v_or_b32_e32 v0, v6, v0
; GFX6-NEXT:    ds_cmpst_rtn_b32 v5, v3, v7, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB21_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(3) %ptr, i32 16383
  %result = atomicrmw fadd ptr addrspace(3) %gep, <2 x half> %val seq_cst
  ret <2 x half> %result
}

define void @local_atomic_fadd_noret_v2f16(ptr addrspace(3) %ptr, <2 x half> %val) {
; GFX12-LABEL: local_atomic_fadd_noret_v2f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_pk_add_f16 v0, v1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_v2f16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_pk_add_f16 v0, v1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v2, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v2, v1
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v3, v0, v3, v2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v2, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB22_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_v2f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v2, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v2, v1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v3, v0, v2, v3
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB22_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_v2f16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v2, v0
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_pk_add_f16 v3, v2, v1
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v3, v0, v2, v3
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB22_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_v2f16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v2, v0
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_pk_add_f16 v3, v2, v1
; GFX908-NEXT:    ds_cmpst_rtn_b32 v3, v0, v2, v3
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v2, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB22_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v2, v0
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_add_f16_sdwa v3, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v4, v2, v1
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX8-NEXT:    ds_cmpst_rtn_b32 v3, v0, v2, v3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v2, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB22_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_v2f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v1
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX7-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v7, v3, v4
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_or_b32_e32 v3, v6, v3
; GFX7-NEXT:    ds_cmpst_rtn_b32 v5, v0, v7, v3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB22_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_v2f16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v3, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v1
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX6-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_or_b32_e32 v7, v3, v4
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_or_b32_e32 v3, v6, v3
; GFX6-NEXT:    ds_cmpst_rtn_b32 v5, v0, v7, v3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB22_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, <2 x half> %val seq_cst
  ret void
}

define void @local_atomic_fadd_noret_v2f16__offset(ptr addrspace(3) %ptr, <2 x half> %val) {
; GFX12-LABEL: local_atomic_fadd_noret_v2f16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_pk_add_f16 v0, v1 offset:65532
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_v2f16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_pk_add_f16 v0, v1 offset:65532
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_v2f16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v2, v0 offset:65532
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v2, v1
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v3, v0, v3, v2 offset:65532
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v2, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB23_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_v2f16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v2, v1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v3, v0, v2, v3 offset:65532
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB23_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_v2f16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_pk_add_f16 v3, v2, v1
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v3, v0, v2, v3 offset:65532
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB23_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_v2f16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_pk_add_f16 v3, v2, v1
; GFX908-NEXT:    ds_cmpst_rtn_b32 v3, v0, v2, v3 offset:65532
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v2, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB23_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_v2f16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_add_f16_sdwa v3, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v4, v2, v1
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX8-NEXT:    ds_cmpst_rtn_b32 v3, v0, v2, v3 offset:65532
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v2, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB23_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_v2f16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v0 offset:65532
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v1
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX7-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v7, v3, v4
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_or_b32_e32 v3, v6, v3
; GFX7-NEXT:    ds_cmpst_rtn_b32 v5, v0, v7, v3 offset:65532
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB23_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_v2f16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffc, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v4, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v1
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX6-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_or_b32_e32 v7, v3, v4
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_or_b32_e32 v3, v6, v3
; GFX6-NEXT:    ds_cmpst_rtn_b32 v5, v0, v7, v3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB23_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(3) %ptr, i32 16383
  %result = atomicrmw fadd ptr addrspace(3) %gep, <2 x half> %val seq_cst
  ret void
}

; --------------------------------------------------------------------
; <2 x bfloat>
; --------------------------------------------------------------------

define <2 x bfloat> @local_atomic_fadd_ret_v2bf16(ptr addrspace(3) %ptr, <2 x bfloat> %val) {
; GFX12-LABEL: local_atomic_fadd_ret_v2bf16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_pk_add_rtn_bf16 v0, v0, v1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_v2bf16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_pk_add_rtn_bf16 v0, v0, v1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v2, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_cndmask_b32 v5, v7, v9 :: v_dual_lshlrev_b32 v2, 16, v4
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    v_add3_u32 v6, v6, v2, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v6, v8, s0
; GFX11-NEXT:    v_perm_b32 v2, v5, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v2, v0, v2, v4
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v4
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB24_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_v2bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v2, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX10-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX10-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v6, v6, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v9, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v6, v8, s4
; GFX10-NEXT:    v_perm_b32 v2, v5, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v2, v0, v4, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB24_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_v2bf16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v2, v0
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX90A-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX90A-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v2, s8
; GFX90A-NEXT:    v_add3_u32 v8, v8, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e64 v2, v6, v7, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX90A-NEXT:    v_perm_b32 v2, v5, v2, s9
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v2, v0, v4, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB24_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_v2bf16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v2, v0
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX908-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX908-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX908-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v6, v6, v2, s8
; GFX908-NEXT:    v_add3_u32 v8, v8, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX908-NEXT:    v_cndmask_b32_e64 v2, v6, v7, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX908-NEXT:    v_perm_b32 v2, v5, v2, s9
; GFX908-NEXT:    ds_cmpst_rtn_b32 v2, v0, v4, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB24_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v2, v0
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX8-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX8-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX8-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v6, v7, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v2, v5, v2, 16
; GFX8-NEXT:    ds_cmpst_rtn_b32 v2, v0, v4, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB24_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_v2bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v0
; GFX7-NEXT:    v_mov_b32_e32 v4, v1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v4
; GFX7-NEXT:    v_alignbit_b32 v1, v1, v3, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    v_alignbit_b32 v3, v3, v5, 16
; GFX7-NEXT:    ds_cmpst_rtn_b32 v3, v0, v1, v3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB24_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_v2bf16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v3, v0
; GFX6-NEXT:    v_mov_b32_e32 v4, v1
; GFX6-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX6-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v4
; GFX6-NEXT:    v_alignbit_b32 v1, v1, v3, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; GFX6-NEXT:    v_alignbit_b32 v3, v3, v5, 16
; GFX6-NEXT:    ds_cmpst_rtn_b32 v3, v0, v1, v3
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v3
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB24_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, <2 x bfloat> %val seq_cst
  ret <2 x bfloat> %result
}

define <2 x bfloat> @local_atomic_fadd_ret_v2bf16__offset(ptr addrspace(3) %ptr, <2 x bfloat> %val) {
; GFX12-LABEL: local_atomic_fadd_ret_v2bf16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_pk_add_rtn_bf16 v0, v0, v1 offset:65532
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_v2bf16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_pk_add_rtn_bf16 v0, v0, v1 offset:65532
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_v2bf16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v2, v0 offset:65532
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_cndmask_b32 v5, v7, v9 :: v_dual_lshlrev_b32 v2, 16, v4
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    v_add3_u32 v6, v6, v2, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v6, v8, s0
; GFX11-NEXT:    v_perm_b32 v2, v5, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v2, v0, v2, v4 offset:65532
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v4
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB25_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_v2bf16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX10-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX10-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v6, v6, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v9, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v6, v8, s4
; GFX10-NEXT:    v_perm_b32 v2, v5, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v2, v0, v4, v2 offset:65532
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB25_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_v2bf16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX90A-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX90A-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v2, s8
; GFX90A-NEXT:    v_add3_u32 v8, v8, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e64 v2, v6, v7, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX90A-NEXT:    v_perm_b32 v2, v5, v2, s9
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v2, v0, v4, v2 offset:65532
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB25_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_v2bf16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX908-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX908-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX908-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v6, v6, v2, s8
; GFX908-NEXT:    v_add3_u32 v8, v8, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX908-NEXT:    v_cndmask_b32_e64 v2, v6, v7, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX908-NEXT:    v_perm_b32 v2, v5, v2, s9
; GFX908-NEXT:    ds_cmpst_rtn_b32 v2, v0, v4, v2 offset:65532
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB25_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_v2bf16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v2, v0 offset:65532
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX8-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX8-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX8-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v6, v7, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v2, v5, v2, 16
; GFX8-NEXT:    ds_cmpst_rtn_b32 v2, v0, v4, v2 offset:65532
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB25_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_v2bf16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v3, v0 offset:65532
; GFX7-NEXT:    v_mov_b32_e32 v4, v1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v4
; GFX7-NEXT:    v_alignbit_b32 v1, v1, v3, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    v_alignbit_b32 v3, v3, v5, 16
; GFX7-NEXT:    ds_cmpst_rtn_b32 v3, v0, v1, v3 offset:65532
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB25_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_v2bf16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0xfffc, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v0, v4
; GFX6-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX6-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX6-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX6-NEXT:    v_alignbit_b32 v1, v1, v5, 16
; GFX6-NEXT:    ds_cmpst_rtn_b32 v5, v4, v0, v1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v0
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v5
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB25_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr addrspace(3) %ptr, i32 16383
  %result = atomicrmw fadd ptr addrspace(3) %gep, <2 x bfloat> %val seq_cst
  ret <2 x bfloat> %result
}

define void @local_atomic_fadd_noret_v2bf16(ptr addrspace(3) %ptr, <2 x bfloat> %val) {
; GFX12-LABEL: local_atomic_fadd_noret_v2bf16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_pk_add_bf16 v0, v1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_v2bf16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_pk_add_bf16 v0, v1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v3, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_add_f32 v5, v5, v1 :: v_dual_lshlrev_b32 v4, 16, v3
; GFX11-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v4
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    v_add3_u32 v6, v6, v4, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v4, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v7, v9, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v4, v6, v8, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v4, v5, v4, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v4, v0, v4, v3
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v4
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB26_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_v2bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX10-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX10-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v4
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v6, v6, v4, 0x7fff
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v4, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v9, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v6, v8, s4
; GFX10-NEXT:    v_perm_b32 v4, v5, v4, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB26_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_v2bf16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v3, v0
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX90A-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX90A-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v7, 0x400000, v4
; GFX90A-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v4, s8
; GFX90A-NEXT:    v_add3_u32 v8, v8, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v4, v4
; GFX90A-NEXT:    v_cndmask_b32_e64 v4, v6, v7, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX90A-NEXT:    v_perm_b32 v4, v5, v4, s9
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB26_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_v2bf16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v3, v0
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX908-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX908-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX908-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v7, 0x400000, v4
; GFX908-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v6, v6, v4, s8
; GFX908-NEXT:    v_add3_u32 v8, v8, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v4, v4
; GFX908-NEXT:    v_cndmask_b32_e64 v4, v6, v7, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX908-NEXT:    v_perm_b32 v4, v5, v4, s9
; GFX908-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v3, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB26_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v3, v0
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX8-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX8-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v4
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v4
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v4, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v6, v7, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; GFX8-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB26_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_v2bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v4, v0
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX7-NEXT:    v_alignbit_b32 v3, v3, v4, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v6
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v5, 16
; GFX7-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB26_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_v2bf16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v4, v0
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX6-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX6-NEXT:    v_alignbit_b32 v3, v3, v4, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v6
; GFX6-NEXT:    v_alignbit_b32 v4, v4, v5, 16
; GFX6-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB26_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, <2 x bfloat> %val seq_cst
  ret void
}

define void @local_atomic_fadd_noret_v2bf16__ofset(ptr addrspace(3) %ptr, <2 x bfloat> %val) {
; GFX12-LABEL: local_atomic_fadd_noret_v2bf16__ofset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_pk_add_bf16 v0, v1 offset:65532
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_v2bf16__ofset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ds_pk_add_bf16 v0, v1 offset:65532
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_v2bf16__ofset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    ds_load_b32 v3, v0 offset:65532
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_add_f32 v5, v5, v1 :: v_dual_lshlrev_b32 v4, 16, v3
; GFX11-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v4
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    v_add3_u32 v6, v6, v4, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v4, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v7, v9, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v4, v6, v8, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v4, v5, v4, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_cmpstore_rtn_b32 v4, v0, v4, v3 offset:65532
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v4
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB27_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_v2bf16__ofset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    ds_read_b32 v3, v0 offset:65532
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX10-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX10-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v4
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v6, v6, v4, 0x7fff
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v4, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v9, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v6, v8, s4
; GFX10-NEXT:    v_perm_b32 v4, v5, v4, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4 offset:65532
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB27_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_v2bf16__ofset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ds_read_b32 v3, v0 offset:65532
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX90A-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX90A-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v7, 0x400000, v4
; GFX90A-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v4, s8
; GFX90A-NEXT:    v_add3_u32 v8, v8, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v4, v4
; GFX90A-NEXT:    v_cndmask_b32_e64 v4, v6, v7, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX90A-NEXT:    v_perm_b32 v4, v5, v4, s9
; GFX90A-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4 offset:65532
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB27_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_v2bf16__ofset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    ds_read_b32 v3, v0 offset:65532
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX908-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX908-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX908-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v7, 0x400000, v4
; GFX908-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v6, v6, v4, s8
; GFX908-NEXT:    v_add3_u32 v8, v8, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v4, v4
; GFX908-NEXT:    v_cndmask_b32_e64 v4, v6, v7, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX908-NEXT:    v_perm_b32 v4, v5, v4, s9
; GFX908-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4 offset:65532
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v3, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB27_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_v2bf16__ofset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_read_b32 v3, v0 offset:65532
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX8-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX8-NEXT:    v_bfe_u32 v6, v4, 16, 1
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v4
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v4
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v4, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v6, v7, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; GFX8-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4 offset:65532
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB27_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_v2bf16__ofset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v4, v0 offset:65532
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX7-NEXT:    v_alignbit_b32 v3, v3, v4, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v6
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v5, 16
; GFX7-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4 offset:65532
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB27_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_v2bf16__ofset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffc, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v4, v0
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX6-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX6-NEXT:    v_alignbit_b32 v3, v3, v4, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v6
; GFX6-NEXT:    v_alignbit_b32 v4, v4, v5, 16
; GFX6-NEXT:    ds_cmpst_rtn_b32 v4, v0, v3, v4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB27_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr addrspace(3) %ptr, i32 16383
  %result = atomicrmw fadd ptr addrspace(3) %gep, <2 x bfloat> %val seq_cst
  ret void
}

; --------------------------------------------------------------------
; misc
; --------------------------------------------------------------------

define amdgpu_kernel void @local_ds_fadd(ptr addrspace(1) %out, ptr addrspace(3) %ptrf, i32 %idx) {
; GFX12-LABEL: local_ds_fadd:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x8
; GFX12-NEXT:    s_mov_b32 s6, exec_lo
; GFX12-NEXT:    ; implicit-def: $vgpr1
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_add_co_i32 s1, s5, 4
; GFX12-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX12-NEXT:    s_cbranch_execz .LBB28_2
; GFX12-NEXT:  ; %bb.1:
; GFX12-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_cvt_f32_ubyte0_e32 v1, s5
; GFX12-NEXT:    s_lshl_b32 s5, s1, 3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, s5 :: v_dual_mul_f32 v1, 0x42280000, v1
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:  .LBB28_2:
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    s_mov_b32 s7, exec_lo
; GFX12-NEXT:    v_readfirstlane_b32 s5, v1
; GFX12-NEXT:    v_mbcnt_lo_u32_b32 v2, s7, 0
; GFX12-NEXT:    s_mov_b32 s6, exec_lo
; GFX12-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX12-NEXT:    s_cbranch_execz .LBB28_4
; GFX12-NEXT:  ; %bb.3:
; GFX12-NEXT:    s_bcnt1_i32_b32 s0, s7
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX12-NEXT:    s_lshl_b32 s0, s1, 4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, s0 :: v_dual_mul_f32 v1, 0x42280000, v1
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    ds_add_f32 v2, v1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:  .LBB28_4:
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s6
; GFX12-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX12-NEXT:    s_mov_b32 s1, exec_lo
; GFX12-NEXT:    s_brev_b32 s0, 1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX12-NEXT:    v_add_f32_e32 v0, s5, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e64 v1, v0, s5, vcc_lo
; GFX12-NEXT:    ; implicit-def: $vgpr0
; GFX12-NEXT:  .LBB28_5: ; %ComputeLoop
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_ctz_i32_b32 s5, s1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_readlane_b32 s6, v1, s5
; GFX12-NEXT:    s_lshl_b32 s7, 1, s5
; GFX12-NEXT:    v_writelane_b32 v0, s0, s5
; GFX12-NEXT:    s_and_not1_b32 s1, s1, s7
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_cmp_lg_u32 s1, 0
; GFX12-NEXT:    s_add_f32 s0, s0, s6
; GFX12-NEXT:    s_cbranch_scc1 .LBB28_5
; GFX12-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX12-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX12-NEXT:    ; implicit-def: $vgpr1
; GFX12-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX12-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX12-NEXT:    s_cbranch_execz .LBB28_8
; GFX12-NEXT:  ; %bb.7:
; GFX12-NEXT:    v_dual_mov_b32 v1, s4 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    ds_add_rtn_f32 v1, v1, v2
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:  .LBB28_8:
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    v_readfirstlane_b32 s2, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_add_f32 v0, s2, v0
; GFX12-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
;
; GFX940-LABEL: local_ds_fadd:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x8
; GFX940-NEXT:    s_mov_b64 s[0:1], exec
; GFX940-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX940-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_add_i32 s5, s5, 4
; GFX940-NEXT:    ; implicit-def: $vgpr1
; GFX940-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX940-NEXT:    s_cbranch_execz .LBB28_2
; GFX940-NEXT:  ; %bb.1:
; GFX940-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX940-NEXT:    s_lshl_b32 s8, s5, 3
; GFX940-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX940-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX940-NEXT:    v_mov_b32_e32 v2, s8
; GFX940-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:  .LBB28_2:
; GFX940-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX940-NEXT:    s_mov_b64 s[8:9], exec
; GFX940-NEXT:    v_readfirstlane_b32 s10, v1
; GFX940-NEXT:    v_mbcnt_lo_u32_b32 v1, s8, 0
; GFX940-NEXT:    v_mbcnt_hi_u32_b32 v1, s9, v1
; GFX940-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX940-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX940-NEXT:    s_cbranch_execz .LBB28_4
; GFX940-NEXT:  ; %bb.3:
; GFX940-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX940-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX940-NEXT:    s_lshl_b32 s0, s5, 4
; GFX940-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX940-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NEXT:    ds_add_f32 v2, v1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:  .LBB28_4:
; GFX940-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX940-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX940-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX940-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX940-NEXT:    v_mov_b32_e32 v1, s10
; GFX940-NEXT:    s_mov_b64 s[0:1], exec
; GFX940-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX940-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX940-NEXT:    ; implicit-def: $vgpr0
; GFX940-NEXT:  .LBB28_5: ; %ComputeLoop
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX940-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX940-NEXT:    v_readfirstlane_b32 s8, v1
; GFX940-NEXT:    v_readlane_b32 s9, v2, s5
; GFX940-NEXT:    s_mov_b32 m0, s5
; GFX940-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX940-NEXT:    v_writelane_b32 v0, s8, m0
; GFX940-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX940-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX940-NEXT:    s_cbranch_scc1 .LBB28_5
; GFX940-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX940-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX940-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX940-NEXT:    ; implicit-def: $vgpr2
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX940-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execz .LBB28_8
; GFX940-NEXT:  ; %bb.7:
; GFX940-NEXT:    v_mov_b32_e32 v2, s4
; GFX940-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:  .LBB28_8:
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX940-NEXT:    v_readfirstlane_b32 s2, v2
; GFX940-NEXT:    v_mov_b32_e32 v1, 0
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX940-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    global_store_dword v1, v0, s[0:1] sc0 sc1
; GFX940-NEXT:    s_endpgm
;
; GFX11-LABEL: local_ds_fadd:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[4:5], s[2:3], 0x8
; GFX11-NEXT:    s_mov_b32 s6, exec_lo
; GFX11-NEXT:    ; implicit-def: $vgpr1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_i32 s1, s5, 4
; GFX11-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-NEXT:    s_cbranch_execz .LBB28_2
; GFX11-NEXT:  ; %bb.1:
; GFX11-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v1, s5
; GFX11-NEXT:    s_lshl_b32 s5, s1, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v2, s5 :: v_dual_mul_f32 v1, 0x42280000, v1
; GFX11-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:  .LBB28_2:
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    s_mov_b32 s7, exec_lo
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_mbcnt_lo_u32_b32 v2, s7, 0
; GFX11-NEXT:    s_mov_b32 s6, exec_lo
; GFX11-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX11-NEXT:    s_cbranch_execz .LBB28_4
; GFX11-NEXT:  ; %bb.3:
; GFX11-NEXT:    s_bcnt1_i32_b32 s0, s7
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX11-NEXT:    s_lshl_b32 s0, s1, 4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v2, s0 :: v_dual_mul_f32 v1, 0x42280000, v1
; GFX11-NEXT:    ds_add_f32 v2, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:  .LBB28_4:
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s6
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX11-NEXT:    v_add_f32_e32 v0, s5, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v0, s5, vcc_lo
; GFX11-NEXT:    ; implicit-def: $vgpr0
; GFX11-NEXT:  .LBB28_5: ; %ComputeLoop
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_ctz_i32_b32 s1, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readlane_b32 s6, v2, s1
; GFX11-NEXT:    s_lshl_b32 s7, 1, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    s_and_not1_b32 s0, s0, s7
; GFX11-NEXT:    v_writelane_b32 v0, s5, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v1, s6, v1
; GFX11-NEXT:    s_cmp_lg_u32 s0, 0
; GFX11-NEXT:    s_cbranch_scc1 .LBB28_5
; GFX11-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX11-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX11-NEXT:    ; implicit-def: $vgpr2
; GFX11-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execz .LBB28_8
; GFX11-NEXT:  ; %bb.7:
; GFX11-NEXT:    v_mov_b32_e32 v2, s4
; GFX11-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:  .LBB28_8:
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_readfirstlane_b32 s2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_add_f32 v0, s2, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX10-LABEL: local_ds_fadd:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x8
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:    ; implicit-def: $vgpr1
; GFX10-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_i32 s1, s5, 4
; GFX10-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX10-NEXT:    s_cbranch_execz .LBB28_2
; GFX10-NEXT:  ; %bb.1:
; GFX10-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v1, s5
; GFX10-NEXT:    s_lshl_b32 s5, s1, 3
; GFX10-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX10-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:  .LBB28_2:
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX10-NEXT:    s_mov_b32 s7, exec_lo
; GFX10-NEXT:    v_readfirstlane_b32 s5, v1
; GFX10-NEXT:    v_mbcnt_lo_u32_b32 v2, s7, 0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v2
; GFX10-NEXT:    s_and_saveexec_b32 s6, s0
; GFX10-NEXT:    s_cbranch_execz .LBB28_4
; GFX10-NEXT:  ; %bb.3:
; GFX10-NEXT:    s_bcnt1_i32_b32 s0, s7
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX10-NEXT:    s_lshl_b32 s0, s1, 4
; GFX10-NEXT:    v_mov_b32_e32 v2, s0
; GFX10-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_add_f32 v2, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:  .LBB28_4:
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s6
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX10-NEXT:    s_mov_b32 s0, exec_lo
; GFX10-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX10-NEXT:    v_add_f32_e32 v0, s5, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v0, s5, vcc_lo
; GFX10-NEXT:    ; implicit-def: $vgpr0
; GFX10-NEXT:  .LBB28_5: ; %ComputeLoop
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_ff1_i32_b32 s1, s0
; GFX10-NEXT:    v_readfirstlane_b32 s5, v1
; GFX10-NEXT:    v_readlane_b32 s6, v2, s1
; GFX10-NEXT:    s_lshl_b32 s7, 1, s1
; GFX10-NEXT:    s_andn2_b32 s0, s0, s7
; GFX10-NEXT:    v_writelane_b32 v0, s5, s1
; GFX10-NEXT:    v_add_f32_e32 v1, s6, v1
; GFX10-NEXT:    s_cmp_lg_u32 s0, 0
; GFX10-NEXT:    s_cbranch_scc1 .LBB28_5
; GFX10-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX10-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX10-NEXT:    ; implicit-def: $vgpr2
; GFX10-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX10-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX10-NEXT:    s_cbranch_execz .LBB28_8
; GFX10-NEXT:  ; %bb.7:
; GFX10-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:  .LBB28_8:
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_mov_b32 null, 0
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX90A-LABEL: local_ds_fadd:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x8
; GFX90A-NEXT:    s_mov_b64 s[0:1], exec
; GFX90A-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX90A-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_add_i32 s5, s5, 4
; GFX90A-NEXT:    ; implicit-def: $vgpr1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_cbranch_execz .LBB28_2
; GFX90A-NEXT:  ; %bb.1:
; GFX90A-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX90A-NEXT:    s_lshl_b32 s8, s5, 3
; GFX90A-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX90A-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX90A-NEXT:    v_mov_b32_e32 v2, s8
; GFX90A-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:  .LBB28_2:
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_mov_b64 s[8:9], exec
; GFX90A-NEXT:    v_readfirstlane_b32 s10, v1
; GFX90A-NEXT:    v_mbcnt_lo_u32_b32 v1, s8, 0
; GFX90A-NEXT:    v_mbcnt_hi_u32_b32 v1, s9, v1
; GFX90A-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX90A-NEXT:    s_cbranch_execz .LBB28_4
; GFX90A-NEXT:  ; %bb.3:
; GFX90A-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX90A-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX90A-NEXT:    s_lshl_b32 s0, s5, 4
; GFX90A-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX90A-NEXT:    v_mov_b32_e32 v2, s0
; GFX90A-NEXT:    ds_add_f32 v2, v1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:  .LBB28_4:
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX90A-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX90A-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX90A-NEXT:    v_mov_b32_e32 v1, s10
; GFX90A-NEXT:    s_mov_b64 s[0:1], exec
; GFX90A-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX90A-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:  .LBB28_5: ; %ComputeLoop
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX90A-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX90A-NEXT:    v_readfirstlane_b32 s8, v1
; GFX90A-NEXT:    v_readlane_b32 s9, v2, s5
; GFX90A-NEXT:    s_mov_b32 m0, s5
; GFX90A-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX90A-NEXT:    v_writelane_b32 v0, s8, m0
; GFX90A-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX90A-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX90A-NEXT:    s_cbranch_scc1 .LBB28_5
; GFX90A-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX90A-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX90A-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX90A-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX90A-NEXT:    s_cbranch_execz .LBB28_8
; GFX90A-NEXT:  ; %bb.7:
; GFX90A-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:  .LBB28_8:
; GFX90A-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX90A-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX90A-NEXT:    v_readfirstlane_b32 s2, v2
; GFX90A-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX90A-NEXT:    v_mov_b32_e32 v2, s2
; GFX90A-NEXT:    v_mov_b32_e32 v1, 0
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX90A-NEXT:    s_endpgm
;
; GFX908-LABEL: local_ds_fadd:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x8
; GFX908-NEXT:    s_mov_b64 s[0:1], exec
; GFX908-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX908-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_add_i32 s5, s5, 4
; GFX908-NEXT:    ; implicit-def: $vgpr1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_cbranch_execz .LBB28_2
; GFX908-NEXT:  ; %bb.1:
; GFX908-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX908-NEXT:    s_lshl_b32 s8, s5, 3
; GFX908-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX908-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX908-NEXT:    v_mov_b32_e32 v2, s8
; GFX908-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:  .LBB28_2:
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_mov_b64 s[8:9], exec
; GFX908-NEXT:    v_readfirstlane_b32 s10, v1
; GFX908-NEXT:    v_mbcnt_lo_u32_b32 v1, s8, 0
; GFX908-NEXT:    v_mbcnt_hi_u32_b32 v1, s9, v1
; GFX908-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX908-NEXT:    s_cbranch_execz .LBB28_4
; GFX908-NEXT:  ; %bb.3:
; GFX908-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX908-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX908-NEXT:    s_lshl_b32 s0, s5, 4
; GFX908-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX908-NEXT:    v_mov_b32_e32 v2, s0
; GFX908-NEXT:    ds_add_f32 v2, v1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:  .LBB28_4:
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX908-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX908-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX908-NEXT:    v_mov_b32_e32 v1, s10
; GFX908-NEXT:    s_mov_b64 s[0:1], exec
; GFX908-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX908-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX908-NEXT:    ; implicit-def: $vgpr0
; GFX908-NEXT:  .LBB28_5: ; %ComputeLoop
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX908-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX908-NEXT:    v_readfirstlane_b32 s8, v1
; GFX908-NEXT:    v_readlane_b32 s9, v2, s5
; GFX908-NEXT:    s_mov_b32 m0, s5
; GFX908-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX908-NEXT:    v_writelane_b32 v0, s8, m0
; GFX908-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX908-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX908-NEXT:    s_cbranch_scc1 .LBB28_5
; GFX908-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX908-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX908-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX908-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX908-NEXT:    s_cbranch_execz .LBB28_8
; GFX908-NEXT:  ; %bb.7:
; GFX908-NEXT:    v_mov_b32_e32 v2, s4
; GFX908-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:  .LBB28_8:
; GFX908-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX908-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX908-NEXT:    v_readfirstlane_b32 s2, v2
; GFX908-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX908-NEXT:    v_mov_b32_e32 v2, s2
; GFX908-NEXT:    v_mov_b32_e32 v1, 0
; GFX908-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX908-NEXT:    s_endpgm
;
; GFX8-LABEL: local_ds_fadd:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x8
; GFX8-NEXT:    s_mov_b64 s[0:1], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_i32 s5, s5, 4
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB28_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX8-NEXT:    s_lshl_b32 s8, s5, 3
; GFX8-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX8-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, s8
; GFX8-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB28_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_mov_b64 s[8:9], exec
; GFX8-NEXT:    v_readfirstlane_b32 s10, v1
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v1, s8, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v1, s9, v1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX8-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX8-NEXT:    s_cbranch_execz .LBB28_4
; GFX8-NEXT:  ; %bb.3:
; GFX8-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX8-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX8-NEXT:    s_lshl_b32 s0, s5, 4
; GFX8-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    ds_add_f32 v2, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB28_4:
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX8-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, s10
; GFX8-NEXT:    s_mov_b64 s[0:1], exec
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX8-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:  .LBB28_5: ; %ComputeLoop
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX8-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX8-NEXT:    v_readfirstlane_b32 s8, v1
; GFX8-NEXT:    v_readlane_b32 s9, v2, s5
; GFX8-NEXT:    s_mov_b32 m0, s5
; GFX8-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX8-NEXT:    v_writelane_b32 v0, s8, m0
; GFX8-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX8-NEXT:    s_cbranch_scc1 .LBB28_5
; GFX8-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr2
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8-NEXT:    s_cbranch_execz .LBB28_8
; GFX8-NEXT:  ; %bb.7:
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:  .LBB28_8:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    v_readfirstlane_b32 s2, v2
; GFX8-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: local_ds_fadd:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x2
; GFX7-NEXT:    s_mov_b64 s[0:1], exec
; GFX7-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s0, 0
; GFX7-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s1, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_i32 s5, s5, 4
; GFX7-NEXT:    ; implicit-def: $vgpr1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX7-NEXT:    s_cbranch_execz .LBB28_4
; GFX7-NEXT:  ; %bb.1:
; GFX7-NEXT:    s_lshl_b32 s8, s5, 3
; GFX7-NEXT:    v_mov_b32_e32 v2, s8
; GFX7-NEXT:    ds_read_b32 v1, v2
; GFX7-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX7-NEXT:    v_cvt_f32_ubyte0_e32 v3, s0
; GFX7-NEXT:    v_mul_f32_e32 v3, 0x42280000, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB28_2: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v1
; GFX7-NEXT:    v_add_f32_e32 v1, v4, v3
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v2, v4, v1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], v1, v4
; GFX7-NEXT:    s_or_b64 s[8:9], s[0:1], s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB28_2
; GFX7-NEXT:  ; %bb.3: ; %Flow22
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:  .LBB28_4: ; %Flow23
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_mov_b64 s[8:9], exec
; GFX7-NEXT:    v_readfirstlane_b32 s10, v1
; GFX7-NEXT:    v_mbcnt_lo_u32_b32_e64 v1, s8, 0
; GFX7-NEXT:    v_mbcnt_hi_u32_b32_e32 v1, s9, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX7-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX7-NEXT:    s_cbranch_execz .LBB28_7
; GFX7-NEXT:  ; %bb.5:
; GFX7-NEXT:    s_lshl_b32 s0, s5, 4
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    ds_read_b32 v3, v1
; GFX7-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX7-NEXT:    v_cvt_f32_ubyte0_e32 v2, s0
; GFX7-NEXT:    v_mul_f32_e32 v2, 0x42280000, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB28_6: ; %atomicrmw.start2
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v4, v3, v2
; GFX7-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], v4, v3
; GFX7-NEXT:    s_or_b64 s[8:9], s[0:1], s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB28_6
; GFX7-NEXT:  .LBB28_7: ; %Flow21
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX7-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, s10
; GFX7-NEXT:    s_mov_b64 s[0:1], exec
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX7-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX7-NEXT:    ; implicit-def: $vgpr0
; GFX7-NEXT:  .LBB28_8: ; %ComputeLoop
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX7-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX7-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX7-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX7-NEXT:    v_readfirstlane_b32 s8, v1
; GFX7-NEXT:    v_readlane_b32 s9, v2, s5
; GFX7-NEXT:    s_mov_b32 m0, s5
; GFX7-NEXT:    v_writelane_b32 v0, s8, m0
; GFX7-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX7-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_vccnz .LBB28_8
; GFX7-NEXT:  ; %bb.9: ; %ComputeEnd
; GFX7-NEXT:    v_mbcnt_lo_u32_b32_e64 v2, exec_lo, 0
; GFX7-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, exec_hi, v2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7-NEXT:    ; implicit-def: $vgpr2
; GFX7-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7-NEXT:    s_xor_b64 s[6:7], exec, s[0:1]
; GFX7-NEXT:    s_cbranch_execz .LBB28_13
; GFX7-NEXT:  ; %bb.10:
; GFX7-NEXT:    v_mov_b32_e32 v3, s4
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v2, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB28_11: ; %atomicrmw.start8
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v4, v1
; GFX7-NEXT:    ds_cmpst_rtn_b32 v2, v3, v4, v2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], v2, v4
; GFX7-NEXT:    s_or_b64 s[4:5], s[0:1], s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB28_11
; GFX7-NEXT:  ; %bb.12: ; %Flow
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:  .LBB28_13: ; %Flow19
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    v_readfirstlane_b32 s4, v2
; GFX7-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX6-LABEL: local_ds_fadd:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x2
; GFX6-NEXT:    s_mov_b64 s[0:1], exec
; GFX6-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s0, 0
; GFX6-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s1, v0
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_add_i32 s5, s5, 4
; GFX6-NEXT:    ; implicit-def: $vgpr1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX6-NEXT:    s_cbranch_execz .LBB28_4
; GFX6-NEXT:  ; %bb.1:
; GFX6-NEXT:    s_lshl_b32 s8, s5, 3
; GFX6-NEXT:    v_mov_b32_e32 v2, s8
; GFX6-NEXT:    ds_read_b32 v1, v2
; GFX6-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX6-NEXT:    v_cvt_f32_ubyte0_e32 v3, s0
; GFX6-NEXT:    v_mul_f32_e32 v3, 0x42280000, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB28_2: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, v1
; GFX6-NEXT:    v_add_f32_e32 v1, v4, v3
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v2, v4, v1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[0:1], v1, v4
; GFX6-NEXT:    s_or_b64 s[8:9], s[0:1], s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB28_2
; GFX6-NEXT:  ; %bb.3: ; %Flow20
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:  .LBB28_4: ; %Flow21
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    s_mov_b64 s[8:9], exec
; GFX6-NEXT:    v_readfirstlane_b32 s10, v1
; GFX6-NEXT:    v_mbcnt_lo_u32_b32_e64 v1, s8, 0
; GFX6-NEXT:    v_mbcnt_hi_u32_b32_e32 v1, s9, v1
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX6-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX6-NEXT:    s_cbranch_execz .LBB28_7
; GFX6-NEXT:  ; %bb.5:
; GFX6-NEXT:    s_lshl_b32 s0, s5, 4
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    ds_read_b32 v3, v1
; GFX6-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX6-NEXT:    v_cvt_f32_ubyte0_e32 v2, s0
; GFX6-NEXT:    v_mul_f32_e32 v2, 0x42280000, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB28_6: ; %atomicrmw.start2
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v4, v3, v2
; GFX6-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[0:1], v4, v3
; GFX6-NEXT:    s_or_b64 s[8:9], s[0:1], s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB28_6
; GFX6-NEXT:  .LBB28_7: ; %Flow19
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX6-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, s10
; GFX6-NEXT:    s_mov_b64 s[0:1], exec
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX6-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX6-NEXT:    ; implicit-def: $vgpr0
; GFX6-NEXT:  .LBB28_8: ; %ComputeLoop
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX6-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX6-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX6-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX6-NEXT:    v_readfirstlane_b32 s8, v1
; GFX6-NEXT:    v_readlane_b32 s9, v2, s5
; GFX6-NEXT:    s_mov_b32 m0, s5
; GFX6-NEXT:    v_writelane_b32 v0, s8, m0
; GFX6-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX6-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX6-NEXT:    s_cbranch_vccnz .LBB28_8
; GFX6-NEXT:  ; %bb.9: ; %ComputeEnd
; GFX6-NEXT:    v_mbcnt_lo_u32_b32_e64 v2, exec_lo, 0
; GFX6-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, exec_hi, v2
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX6-NEXT:    ; implicit-def: $vgpr2
; GFX6-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX6-NEXT:    s_xor_b64 s[6:7], exec, s[0:1]
; GFX6-NEXT:    s_cbranch_execz .LBB28_13
; GFX6-NEXT:  ; %bb.10:
; GFX6-NEXT:    v_mov_b32_e32 v3, s4
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v2, v3
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB28_11: ; %atomicrmw.start8
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    v_add_f32_e32 v2, v4, v1
; GFX6-NEXT:    ds_cmpst_rtn_b32 v2, v3, v4, v2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[0:1], v2, v4
; GFX6-NEXT:    s_or_b64 s[4:5], s[0:1], s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB28_11
; GFX6-NEXT:  ; %bb.12: ; %Flow
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:  .LBB28_13: ; %Flow17
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX6-NEXT:    v_readfirstlane_b32 s4, v2
; GFX6-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
  %idx.add = add nuw i32 %idx, 4
  %shl0 = shl i32 %idx.add, 3
  %shl1 = shl i32 %idx.add, 4
  %ptr0 = inttoptr i32 %shl0 to ptr addrspace(3)
  %ptr1 = inttoptr i32 %shl1 to ptr addrspace(3)
  %a1 = atomicrmw fadd ptr addrspace(3) %ptr0, float 4.2e+1 seq_cst
  %a2 = atomicrmw fadd ptr addrspace(3) %ptr1, float 4.2e+1 seq_cst
  %a3 = atomicrmw fadd ptr addrspace(3) %ptrf, float %a1 seq_cst
  store float %a3, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @local_ds_fadd_one_as(ptr addrspace(1) %out, ptr addrspace(3) %ptrf, i32 %idx) {
; GFX12-LABEL: local_ds_fadd_one_as:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x8
; GFX12-NEXT:    s_mov_b32 s6, exec_lo
; GFX12-NEXT:    ; implicit-def: $vgpr1
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_add_co_i32 s1, s5, 4
; GFX12-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX12-NEXT:    s_cbranch_execz .LBB29_2
; GFX12-NEXT:  ; %bb.1:
; GFX12-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_cvt_f32_ubyte0_e32 v1, s5
; GFX12-NEXT:    s_lshl_b32 s5, s1, 3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, s5 :: v_dual_mul_f32 v1, 0x42280000, v1
; GFX12-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX12-NEXT:  .LBB29_2:
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    s_mov_b32 s7, exec_lo
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_readfirstlane_b32 s5, v1
; GFX12-NEXT:    v_mbcnt_lo_u32_b32 v2, s7, 0
; GFX12-NEXT:    s_mov_b32 s6, exec_lo
; GFX12-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX12-NEXT:    s_cbranch_execz .LBB29_4
; GFX12-NEXT:  ; %bb.3:
; GFX12-NEXT:    s_bcnt1_i32_b32 s0, s7
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX12-NEXT:    s_lshl_b32 s0, s1, 4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, s0 :: v_dual_mul_f32 v1, 0x42280000, v1
; GFX12-NEXT:    ds_add_f32 v2, v1
; GFX12-NEXT:  .LBB29_4:
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s6
; GFX12-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX12-NEXT:    s_mov_b32 s1, exec_lo
; GFX12-NEXT:    s_brev_b32 s0, 1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX12-NEXT:    v_add_f32_e32 v0, s5, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e64 v1, v0, s5, vcc_lo
; GFX12-NEXT:    ; implicit-def: $vgpr0
; GFX12-NEXT:  .LBB29_5: ; %ComputeLoop
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_ctz_i32_b32 s5, s1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_readlane_b32 s6, v1, s5
; GFX12-NEXT:    s_lshl_b32 s7, 1, s5
; GFX12-NEXT:    v_writelane_b32 v0, s0, s5
; GFX12-NEXT:    s_and_not1_b32 s1, s1, s7
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_cmp_lg_u32 s1, 0
; GFX12-NEXT:    s_add_f32 s0, s0, s6
; GFX12-NEXT:    s_cbranch_scc1 .LBB29_5
; GFX12-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX12-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX12-NEXT:    ; implicit-def: $vgpr1
; GFX12-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX12-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX12-NEXT:    s_cbranch_execz .LBB29_8
; GFX12-NEXT:  ; %bb.7:
; GFX12-NEXT:    v_dual_mov_b32 v1, s4 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    ds_add_rtn_f32 v1, v1, v2
; GFX12-NEXT:  .LBB29_8:
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    v_readfirstlane_b32 s2, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_add_f32 v0, s2, v0
; GFX12-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
;
; GFX940-LABEL: local_ds_fadd_one_as:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x8
; GFX940-NEXT:    s_mov_b64 s[0:1], exec
; GFX940-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX940-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_add_i32 s5, s5, 4
; GFX940-NEXT:    ; implicit-def: $vgpr1
; GFX940-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX940-NEXT:    s_cbranch_execz .LBB29_2
; GFX940-NEXT:  ; %bb.1:
; GFX940-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX940-NEXT:    s_lshl_b32 s8, s5, 3
; GFX940-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX940-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX940-NEXT:    v_mov_b32_e32 v2, s8
; GFX940-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX940-NEXT:  .LBB29_2:
; GFX940-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX940-NEXT:    s_mov_b64 s[8:9], exec
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_readfirstlane_b32 s10, v1
; GFX940-NEXT:    v_mbcnt_lo_u32_b32 v1, s8, 0
; GFX940-NEXT:    v_mbcnt_hi_u32_b32 v1, s9, v1
; GFX940-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX940-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX940-NEXT:    s_cbranch_execz .LBB29_4
; GFX940-NEXT:  ; %bb.3:
; GFX940-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX940-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX940-NEXT:    s_lshl_b32 s0, s5, 4
; GFX940-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX940-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NEXT:    ds_add_f32 v2, v1
; GFX940-NEXT:  .LBB29_4:
; GFX940-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX940-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX940-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX940-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX940-NEXT:    v_mov_b32_e32 v1, s10
; GFX940-NEXT:    s_mov_b64 s[0:1], exec
; GFX940-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX940-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX940-NEXT:    ; implicit-def: $vgpr0
; GFX940-NEXT:  .LBB29_5: ; %ComputeLoop
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX940-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX940-NEXT:    v_readfirstlane_b32 s8, v1
; GFX940-NEXT:    v_readlane_b32 s9, v2, s5
; GFX940-NEXT:    s_mov_b32 m0, s5
; GFX940-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX940-NEXT:    v_writelane_b32 v0, s8, m0
; GFX940-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX940-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX940-NEXT:    s_cbranch_scc1 .LBB29_5
; GFX940-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX940-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX940-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX940-NEXT:    ; implicit-def: $vgpr2
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX940-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execz .LBB29_8
; GFX940-NEXT:  ; %bb.7:
; GFX940-NEXT:    v_mov_b32_e32 v2, s4
; GFX940-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX940-NEXT:  .LBB29_8:
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_readfirstlane_b32 s2, v2
; GFX940-NEXT:    v_mov_b32_e32 v1, 0
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX940-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX940-NEXT:    global_store_dword v1, v0, s[0:1] sc0 sc1
; GFX940-NEXT:    s_endpgm
;
; GFX11-LABEL: local_ds_fadd_one_as:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[4:5], s[2:3], 0x8
; GFX11-NEXT:    s_mov_b32 s6, exec_lo
; GFX11-NEXT:    ; implicit-def: $vgpr1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_i32 s1, s5, 4
; GFX11-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-NEXT:    s_cbranch_execz .LBB29_2
; GFX11-NEXT:  ; %bb.1:
; GFX11-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v1, s5
; GFX11-NEXT:    s_lshl_b32 s5, s1, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v2, s5 :: v_dual_mul_f32 v1, 0x42280000, v1
; GFX11-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX11-NEXT:  .LBB29_2:
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    s_mov_b32 s7, exec_lo
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_mbcnt_lo_u32_b32 v2, s7, 0
; GFX11-NEXT:    s_mov_b32 s6, exec_lo
; GFX11-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX11-NEXT:    s_cbranch_execz .LBB29_4
; GFX11-NEXT:  ; %bb.3:
; GFX11-NEXT:    s_bcnt1_i32_b32 s0, s7
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX11-NEXT:    s_lshl_b32 s0, s1, 4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v2, s0 :: v_dual_mul_f32 v1, 0x42280000, v1
; GFX11-NEXT:    ds_add_f32 v2, v1
; GFX11-NEXT:  .LBB29_4:
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s6
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX11-NEXT:    v_add_f32_e32 v0, s5, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v0, s5, vcc_lo
; GFX11-NEXT:    ; implicit-def: $vgpr0
; GFX11-NEXT:  .LBB29_5: ; %ComputeLoop
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_ctz_i32_b32 s1, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readlane_b32 s6, v2, s1
; GFX11-NEXT:    s_lshl_b32 s7, 1, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    s_and_not1_b32 s0, s0, s7
; GFX11-NEXT:    v_writelane_b32 v0, s5, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v1, s6, v1
; GFX11-NEXT:    s_cmp_lg_u32 s0, 0
; GFX11-NEXT:    s_cbranch_scc1 .LBB29_5
; GFX11-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX11-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX11-NEXT:    ; implicit-def: $vgpr2
; GFX11-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execz .LBB29_8
; GFX11-NEXT:  ; %bb.7:
; GFX11-NEXT:    v_mov_b32_e32 v2, s4
; GFX11-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX11-NEXT:  .LBB29_8:
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_readfirstlane_b32 s2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_add_f32 v0, s2, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX10-LABEL: local_ds_fadd_one_as:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x8
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:    ; implicit-def: $vgpr1
; GFX10-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_i32 s1, s5, 4
; GFX10-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX10-NEXT:    s_cbranch_execz .LBB29_2
; GFX10-NEXT:  ; %bb.1:
; GFX10-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v1, s5
; GFX10-NEXT:    s_lshl_b32 s5, s1, 3
; GFX10-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX10-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX10-NEXT:  .LBB29_2:
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX10-NEXT:    s_mov_b32 s7, exec_lo
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_readfirstlane_b32 s5, v1
; GFX10-NEXT:    v_mbcnt_lo_u32_b32 v2, s7, 0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v2
; GFX10-NEXT:    s_and_saveexec_b32 s6, s0
; GFX10-NEXT:    s_cbranch_execz .LBB29_4
; GFX10-NEXT:  ; %bb.3:
; GFX10-NEXT:    s_bcnt1_i32_b32 s0, s7
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX10-NEXT:    s_lshl_b32 s0, s1, 4
; GFX10-NEXT:    v_mov_b32_e32 v2, s0
; GFX10-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX10-NEXT:    ds_add_f32 v2, v1
; GFX10-NEXT:  .LBB29_4:
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s6
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX10-NEXT:    s_mov_b32 s0, exec_lo
; GFX10-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX10-NEXT:    v_add_f32_e32 v0, s5, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v0, s5, vcc_lo
; GFX10-NEXT:    ; implicit-def: $vgpr0
; GFX10-NEXT:  .LBB29_5: ; %ComputeLoop
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_ff1_i32_b32 s1, s0
; GFX10-NEXT:    v_readfirstlane_b32 s5, v1
; GFX10-NEXT:    v_readlane_b32 s6, v2, s1
; GFX10-NEXT:    s_lshl_b32 s7, 1, s1
; GFX10-NEXT:    s_andn2_b32 s0, s0, s7
; GFX10-NEXT:    v_writelane_b32 v0, s5, s1
; GFX10-NEXT:    v_add_f32_e32 v1, s6, v1
; GFX10-NEXT:    s_cmp_lg_u32 s0, 0
; GFX10-NEXT:    s_cbranch_scc1 .LBB29_5
; GFX10-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX10-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX10-NEXT:    ; implicit-def: $vgpr2
; GFX10-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX10-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX10-NEXT:    s_cbranch_execz .LBB29_8
; GFX10-NEXT:  ; %bb.7:
; GFX10-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX10-NEXT:  .LBB29_8:
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX90A-LABEL: local_ds_fadd_one_as:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x8
; GFX90A-NEXT:    s_mov_b64 s[0:1], exec
; GFX90A-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX90A-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_add_i32 s5, s5, 4
; GFX90A-NEXT:    ; implicit-def: $vgpr1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_cbranch_execz .LBB29_2
; GFX90A-NEXT:  ; %bb.1:
; GFX90A-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX90A-NEXT:    s_lshl_b32 s8, s5, 3
; GFX90A-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX90A-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX90A-NEXT:    v_mov_b32_e32 v2, s8
; GFX90A-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX90A-NEXT:  .LBB29_2:
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_mov_b64 s[8:9], exec
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_readfirstlane_b32 s10, v1
; GFX90A-NEXT:    v_mbcnt_lo_u32_b32 v1, s8, 0
; GFX90A-NEXT:    v_mbcnt_hi_u32_b32 v1, s9, v1
; GFX90A-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX90A-NEXT:    s_cbranch_execz .LBB29_4
; GFX90A-NEXT:  ; %bb.3:
; GFX90A-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX90A-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX90A-NEXT:    s_lshl_b32 s0, s5, 4
; GFX90A-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX90A-NEXT:    v_mov_b32_e32 v2, s0
; GFX90A-NEXT:    ds_add_f32 v2, v1
; GFX90A-NEXT:  .LBB29_4:
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX90A-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX90A-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX90A-NEXT:    v_mov_b32_e32 v1, s10
; GFX90A-NEXT:    s_mov_b64 s[0:1], exec
; GFX90A-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX90A-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:  .LBB29_5: ; %ComputeLoop
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX90A-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX90A-NEXT:    v_readfirstlane_b32 s8, v1
; GFX90A-NEXT:    v_readlane_b32 s9, v2, s5
; GFX90A-NEXT:    s_mov_b32 m0, s5
; GFX90A-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX90A-NEXT:    v_writelane_b32 v0, s8, m0
; GFX90A-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX90A-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX90A-NEXT:    s_cbranch_scc1 .LBB29_5
; GFX90A-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX90A-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX90A-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX90A-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX90A-NEXT:    s_cbranch_execz .LBB29_8
; GFX90A-NEXT:  ; %bb.7:
; GFX90A-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX90A-NEXT:  .LBB29_8:
; GFX90A-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX90A-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    v_readfirstlane_b32 s2, v2
; GFX90A-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX90A-NEXT:    v_mov_b32_e32 v2, s2
; GFX90A-NEXT:    v_mov_b32_e32 v1, 0
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX90A-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX90A-NEXT:    s_endpgm
;
; GFX908-LABEL: local_ds_fadd_one_as:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x8
; GFX908-NEXT:    s_mov_b64 s[0:1], exec
; GFX908-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX908-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_add_i32 s5, s5, 4
; GFX908-NEXT:    ; implicit-def: $vgpr1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_cbranch_execz .LBB29_2
; GFX908-NEXT:  ; %bb.1:
; GFX908-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX908-NEXT:    s_lshl_b32 s8, s5, 3
; GFX908-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX908-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX908-NEXT:    v_mov_b32_e32 v2, s8
; GFX908-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX908-NEXT:  .LBB29_2:
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_mov_b64 s[8:9], exec
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_readfirstlane_b32 s10, v1
; GFX908-NEXT:    v_mbcnt_lo_u32_b32 v1, s8, 0
; GFX908-NEXT:    v_mbcnt_hi_u32_b32 v1, s9, v1
; GFX908-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX908-NEXT:    s_cbranch_execz .LBB29_4
; GFX908-NEXT:  ; %bb.3:
; GFX908-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX908-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX908-NEXT:    s_lshl_b32 s0, s5, 4
; GFX908-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX908-NEXT:    v_mov_b32_e32 v2, s0
; GFX908-NEXT:    ds_add_f32 v2, v1
; GFX908-NEXT:  .LBB29_4:
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX908-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX908-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX908-NEXT:    v_mov_b32_e32 v1, s10
; GFX908-NEXT:    s_mov_b64 s[0:1], exec
; GFX908-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX908-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX908-NEXT:    ; implicit-def: $vgpr0
; GFX908-NEXT:  .LBB29_5: ; %ComputeLoop
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX908-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX908-NEXT:    v_readfirstlane_b32 s8, v1
; GFX908-NEXT:    v_readlane_b32 s9, v2, s5
; GFX908-NEXT:    s_mov_b32 m0, s5
; GFX908-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX908-NEXT:    v_writelane_b32 v0, s8, m0
; GFX908-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX908-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX908-NEXT:    s_cbranch_scc1 .LBB29_5
; GFX908-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX908-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX908-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX908-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX908-NEXT:    s_cbranch_execz .LBB29_8
; GFX908-NEXT:  ; %bb.7:
; GFX908-NEXT:    v_mov_b32_e32 v2, s4
; GFX908-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX908-NEXT:  .LBB29_8:
; GFX908-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX908-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    v_readfirstlane_b32 s2, v2
; GFX908-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX908-NEXT:    v_mov_b32_e32 v2, s2
; GFX908-NEXT:    v_mov_b32_e32 v1, 0
; GFX908-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX908-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX908-NEXT:    s_endpgm
;
; GFX8-LABEL: local_ds_fadd_one_as:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x8
; GFX8-NEXT:    s_mov_b64 s[0:1], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_i32 s5, s5, 4
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB29_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX8-NEXT:    s_lshl_b32 s8, s5, 3
; GFX8-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX8-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, s8
; GFX8-NEXT:    ds_add_rtn_f32 v1, v2, v1
; GFX8-NEXT:  .LBB29_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_mov_b64 s[8:9], exec
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s10, v1
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v1, s8, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v1, s9, v1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX8-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX8-NEXT:    s_cbranch_execz .LBB29_4
; GFX8-NEXT:  ; %bb.3:
; GFX8-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX8-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX8-NEXT:    s_lshl_b32 s0, s5, 4
; GFX8-NEXT:    v_mul_f32_e32 v1, 0x42280000, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    ds_add_f32 v2, v1
; GFX8-NEXT:  .LBB29_4:
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX8-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, s10
; GFX8-NEXT:    s_mov_b64 s[0:1], exec
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX8-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:  .LBB29_5: ; %ComputeLoop
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX8-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX8-NEXT:    v_readfirstlane_b32 s8, v1
; GFX8-NEXT:    v_readlane_b32 s9, v2, s5
; GFX8-NEXT:    s_mov_b32 m0, s5
; GFX8-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX8-NEXT:    v_writelane_b32 v0, s8, m0
; GFX8-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX8-NEXT:    s_cbranch_scc1 .LBB29_5
; GFX8-NEXT:  ; %bb.6: ; %ComputeEnd
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr2
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8-NEXT:    s_cbranch_execz .LBB29_8
; GFX8-NEXT:  ; %bb.7:
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_rtn_f32 v2, v2, v1
; GFX8-NEXT:  .LBB29_8:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v2
; GFX8-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: local_ds_fadd_one_as:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x2
; GFX7-NEXT:    s_mov_b64 s[0:1], exec
; GFX7-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s0, 0
; GFX7-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s1, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_i32 s5, s5, 4
; GFX7-NEXT:    ; implicit-def: $vgpr1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX7-NEXT:    s_cbranch_execz .LBB29_4
; GFX7-NEXT:  ; %bb.1:
; GFX7-NEXT:    s_lshl_b32 s8, s5, 3
; GFX7-NEXT:    v_mov_b32_e32 v2, s8
; GFX7-NEXT:    ds_read_b32 v1, v2
; GFX7-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX7-NEXT:    v_cvt_f32_ubyte0_e32 v3, s0
; GFX7-NEXT:    v_mul_f32_e32 v3, 0x42280000, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB29_2: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v1
; GFX7-NEXT:    v_add_f32_e32 v1, v4, v3
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v2, v4, v1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], v1, v4
; GFX7-NEXT:    s_or_b64 s[8:9], s[0:1], s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB29_2
; GFX7-NEXT:  ; %bb.3: ; %Flow22
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:  .LBB29_4: ; %Flow23
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_mov_b64 s[8:9], exec
; GFX7-NEXT:    v_readfirstlane_b32 s10, v1
; GFX7-NEXT:    v_mbcnt_lo_u32_b32_e64 v1, s8, 0
; GFX7-NEXT:    v_mbcnt_hi_u32_b32_e32 v1, s9, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX7-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX7-NEXT:    s_cbranch_execz .LBB29_7
; GFX7-NEXT:  ; %bb.5:
; GFX7-NEXT:    s_lshl_b32 s0, s5, 4
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    ds_read_b32 v3, v1
; GFX7-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX7-NEXT:    v_cvt_f32_ubyte0_e32 v2, s0
; GFX7-NEXT:    v_mul_f32_e32 v2, 0x42280000, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB29_6: ; %atomicrmw.start2
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v4, v3, v2
; GFX7-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], v4, v3
; GFX7-NEXT:    s_or_b64 s[8:9], s[0:1], s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB29_6
; GFX7-NEXT:  .LBB29_7: ; %Flow21
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX7-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, s10
; GFX7-NEXT:    s_mov_b64 s[0:1], exec
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX7-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX7-NEXT:    ; implicit-def: $vgpr0
; GFX7-NEXT:  .LBB29_8: ; %ComputeLoop
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX7-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX7-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX7-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX7-NEXT:    v_readfirstlane_b32 s8, v1
; GFX7-NEXT:    v_readlane_b32 s9, v2, s5
; GFX7-NEXT:    s_mov_b32 m0, s5
; GFX7-NEXT:    v_writelane_b32 v0, s8, m0
; GFX7-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX7-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_vccnz .LBB29_8
; GFX7-NEXT:  ; %bb.9: ; %ComputeEnd
; GFX7-NEXT:    v_mbcnt_lo_u32_b32_e64 v2, exec_lo, 0
; GFX7-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, exec_hi, v2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7-NEXT:    ; implicit-def: $vgpr2
; GFX7-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7-NEXT:    s_xor_b64 s[6:7], exec, s[0:1]
; GFX7-NEXT:    s_cbranch_execz .LBB29_13
; GFX7-NEXT:  ; %bb.10:
; GFX7-NEXT:    v_mov_b32_e32 v3, s4
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v2, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB29_11: ; %atomicrmw.start8
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v4, v1
; GFX7-NEXT:    ds_cmpst_rtn_b32 v2, v3, v4, v2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], v2, v4
; GFX7-NEXT:    s_or_b64 s[4:5], s[0:1], s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB29_11
; GFX7-NEXT:  ; %bb.12: ; %Flow
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:  .LBB29_13: ; %Flow19
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    v_readfirstlane_b32 s4, v2
; GFX7-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX6-LABEL: local_ds_fadd_one_as:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x2
; GFX6-NEXT:    s_mov_b64 s[0:1], exec
; GFX6-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s0, 0
; GFX6-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s1, v0
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_add_i32 s5, s5, 4
; GFX6-NEXT:    ; implicit-def: $vgpr1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX6-NEXT:    s_cbranch_execz .LBB29_4
; GFX6-NEXT:  ; %bb.1:
; GFX6-NEXT:    s_lshl_b32 s8, s5, 3
; GFX6-NEXT:    v_mov_b32_e32 v2, s8
; GFX6-NEXT:    ds_read_b32 v1, v2
; GFX6-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX6-NEXT:    v_cvt_f32_ubyte0_e32 v3, s0
; GFX6-NEXT:    v_mul_f32_e32 v3, 0x42280000, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB29_2: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, v1
; GFX6-NEXT:    v_add_f32_e32 v1, v4, v3
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v2, v4, v1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[0:1], v1, v4
; GFX6-NEXT:    s_or_b64 s[8:9], s[0:1], s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB29_2
; GFX6-NEXT:  ; %bb.3: ; %Flow20
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:  .LBB29_4: ; %Flow21
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    s_mov_b64 s[8:9], exec
; GFX6-NEXT:    v_readfirstlane_b32 s10, v1
; GFX6-NEXT:    v_mbcnt_lo_u32_b32_e64 v1, s8, 0
; GFX6-NEXT:    v_mbcnt_hi_u32_b32_e32 v1, s9, v1
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v1
; GFX6-NEXT:    s_and_saveexec_b64 s[6:7], s[0:1]
; GFX6-NEXT:    s_cbranch_execz .LBB29_7
; GFX6-NEXT:  ; %bb.5:
; GFX6-NEXT:    s_lshl_b32 s0, s5, 4
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    ds_read_b32 v3, v1
; GFX6-NEXT:    s_bcnt1_i32_b64 s0, s[8:9]
; GFX6-NEXT:    v_cvt_f32_ubyte0_e32 v2, s0
; GFX6-NEXT:    v_mul_f32_e32 v2, 0x42280000, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB29_6: ; %atomicrmw.start2
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v4, v3, v2
; GFX6-NEXT:    ds_cmpst_rtn_b32 v4, v1, v3, v4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[0:1], v4, v3
; GFX6-NEXT:    s_or_b64 s[8:9], s[0:1], s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB29_6
; GFX6-NEXT:  .LBB29_7: ; %Flow19
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GFX6-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, s10
; GFX6-NEXT:    s_mov_b64 s[0:1], exec
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX6-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX6-NEXT:    ; implicit-def: $vgpr0
; GFX6-NEXT:  .LBB29_8: ; %ComputeLoop
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_ff1_i32_b64 s5, s[0:1]
; GFX6-NEXT:    s_lshl_b64 s[6:7], 1, s5
; GFX6-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[6:7]
; GFX6-NEXT:    v_cmp_ne_u64_e64 s[6:7], s[0:1], 0
; GFX6-NEXT:    v_readfirstlane_b32 s8, v1
; GFX6-NEXT:    v_readlane_b32 s9, v2, s5
; GFX6-NEXT:    s_mov_b32 m0, s5
; GFX6-NEXT:    v_writelane_b32 v0, s8, m0
; GFX6-NEXT:    v_add_f32_e32 v1, s9, v1
; GFX6-NEXT:    s_and_b64 vcc, exec, s[6:7]
; GFX6-NEXT:    s_cbranch_vccnz .LBB29_8
; GFX6-NEXT:  ; %bb.9: ; %ComputeEnd
; GFX6-NEXT:    v_mbcnt_lo_u32_b32_e64 v2, exec_lo, 0
; GFX6-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, exec_hi, v2
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX6-NEXT:    ; implicit-def: $vgpr2
; GFX6-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX6-NEXT:    s_xor_b64 s[6:7], exec, s[0:1]
; GFX6-NEXT:    s_cbranch_execz .LBB29_13
; GFX6-NEXT:  ; %bb.10:
; GFX6-NEXT:    v_mov_b32_e32 v3, s4
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v2, v3
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB29_11: ; %atomicrmw.start8
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    v_add_f32_e32 v2, v4, v1
; GFX6-NEXT:    ds_cmpst_rtn_b32 v2, v3, v4, v2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[0:1], v2, v4
; GFX6-NEXT:    s_or_b64 s[4:5], s[0:1], s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB29_11
; GFX6-NEXT:  ; %bb.12: ; %Flow
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:  .LBB29_13: ; %Flow17
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX6-NEXT:    v_readfirstlane_b32 s4, v2
; GFX6-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
  %idx.add = add nuw i32 %idx, 4
  %shl0 = shl i32 %idx.add, 3
  %shl1 = shl i32 %idx.add, 4
  %ptr0 = inttoptr i32 %shl0 to ptr addrspace(3)
  %ptr1 = inttoptr i32 %shl1 to ptr addrspace(3)
  %a1 = atomicrmw fadd ptr addrspace(3) %ptr0, float 4.2e+1 syncscope("one-as") seq_cst
  %a2 = atomicrmw fadd ptr addrspace(3) %ptr1, float 4.2e+1 syncscope("one-as") seq_cst
  %a3 = atomicrmw fadd ptr addrspace(3) %ptrf, float %a1 syncscope("one-as") seq_cst
  store float %a3, ptr addrspace(1) %out
  ret void
}

define float @local_atomic_fadd_ret_f32__amdgpu_ignore_denormal_mode(ptr addrspace(3) %ptr) {
; GFX12-LABEL: local_atomic_fadd_ret_f32__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_ret_f32__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX940-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_ret_f32__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_ret_f32__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_ret_f32__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX90A-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_ret_f32__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX908-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_ret_f32__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_rtn_f32 v0, v0, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_ret_f32__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, v1
; GFX7-NEXT:    v_add_f32_e32 v1, 4.0, v2
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB30_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_ret_f32__amdgpu_ignore_denormal_mode:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, v1
; GFX6-NEXT:    v_add_f32_e32 v1, 4.0, v2
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v2, v1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB30_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, float 4.0 seq_cst, !amdgpu.ignore.denormal.mode !0
  ret float %result
}

define void @local_atomic_fadd_noret_f32__amdgpu_ignore_denormal_mode(ptr addrspace(3) %ptr) {
; GFX12-LABEL: local_atomic_fadd_noret_f32__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    ds_add_f32 v0, v1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: local_atomic_fadd_noret_f32__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX940-NEXT:    ds_add_f32 v0, v1
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: local_atomic_fadd_noret_f32__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ds_add_f32 v0, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: local_atomic_fadd_noret_f32__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ds_add_f32 v0, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: local_atomic_fadd_noret_f32__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX90A-NEXT:    ds_add_f32 v0, v1
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: local_atomic_fadd_noret_f32__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX908-NEXT:    ds_add_f32 v0, v1
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: local_atomic_fadd_noret_f32__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 4.0
; GFX8-NEXT:    s_mov_b32 m0, -1
; GFX8-NEXT:    ds_add_f32 v0, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: local_atomic_fadd_noret_f32__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v2, 4.0, v1
; GFX7-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB31_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: local_atomic_fadd_noret_f32__amdgpu_ignore_denormal_mode:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v2, 4.0, v1
; GFX6-NEXT:    ds_cmpst_rtn_b32 v2, v0, v1, v2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v1, v2
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB31_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(3) %ptr, float 4.0 seq_cst, !amdgpu.ignore.denormal.mode !0
  ret void
}

!0 = !{}
