; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=aarch64 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define double @exp_f64(double %a) {
; CHECK-LABEL: exp_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    b exp
entry:
  %c = call double @llvm.exp.f64(double %a)
  ret double %c
}

define float @exp_f32(float %a) {
; CHECK-LABEL: exp_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    b expf
entry:
  %c = call float @llvm.exp.f32(float %a)
  ret float %c
}

define half @exp_f16(half %a) {
; CHECK-LABEL: exp_f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %c = call half @llvm.exp.f16(half %a)
  ret half %c
}

define <1 x double> @exp_v1f64(<1 x double> %x) {
; CHECK-LABEL: exp_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl exp
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %c = call <1 x double> @llvm.exp.v1f64(<1 x double> %x)
  ret <1 x double> %c
}

define <2 x double> @exp_v2f64(<2 x double> %a) {
; CHECK-SD-LABEL: exp_v2f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    bl exp
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl exp
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp_v2f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #32
; CHECK-GI-NEXT:    str d8, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl exp
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl exp
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d8, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #32
; CHECK-GI-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.exp.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @exp_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: exp_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -8
; CHECK-SD-NEXT:    .cfi_offset b8, -16
; CHECK-SD-NEXT:    .cfi_offset b9, -24
; CHECK-SD-NEXT:    .cfi_offset b10, -32
; CHECK-SD-NEXT:    fmov d8, d2
; CHECK-SD-NEXT:    fmov d9, d1
; CHECK-SD-NEXT:    bl exp
; CHECK-SD-NEXT:    fmov d10, d0
; CHECK-SD-NEXT:    fmov d0, d9
; CHECK-SD-NEXT:    bl exp
; CHECK-SD-NEXT:    fmov d9, d0
; CHECK-SD-NEXT:    fmov d0, d8
; CHECK-SD-NEXT:    bl exp
; CHECK-SD-NEXT:    fmov d1, d9
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fmov d2, d0
; CHECK-SD-NEXT:    fmov d0, d10
; CHECK-SD-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    fmov d8, d1
; CHECK-GI-NEXT:    fmov d9, d2
; CHECK-GI-NEXT:    bl exp
; CHECK-GI-NEXT:    fmov d10, d0
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl exp
; CHECK-GI-NEXT:    fmov d8, d0
; CHECK-GI-NEXT:    fmov d0, d9
; CHECK-GI-NEXT:    bl exp
; CHECK-GI-NEXT:    fmov d1, d8
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fmov d2, d0
; CHECK-GI-NEXT:    fmov d0, d10
; CHECK-GI-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.exp.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @exp_v4f64(<4 x double> %a) {
; CHECK-SD-LABEL: exp_v4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl exp
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl exp
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    bl exp
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl exp
; CHECK-SD-NEXT:    fmov d1, d0
; CHECK-SD-NEXT:    ldp q2, q0, [sp] // 32-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.d[1], v2.d[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp_v4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    stp d9, d8, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #64] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    mov d9, v1.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl exp
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl exp
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl exp
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d9
; CHECK-GI-NEXT:    bl exp
; CHECK-GI-NEXT:    ldp q1, q2, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #64] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v2.d[1], v1.d[0]
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.exp.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @exp_v2f32(<2 x float> %a) {
; CHECK-SD-LABEL: exp_v2f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp_v2f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #32
; CHECK-GI-NEXT:    str d8, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d8, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v0.s[0]
; CHECK-GI-NEXT:    fmov d0, d1
; CHECK-GI-NEXT:    add sp, sp, #32
; CHECK-GI-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.exp.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @exp_v3f32(<3 x float> %a) {
; CHECK-SD-LABEL: exp_v3f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp_v3f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #64
; CHECK-GI-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldp q2, q1, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #64
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.exp.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @exp_v4f32(<4 x float> %a) {
; CHECK-SD-LABEL: exp_v4f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp_v4f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    str d10, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #56] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #72] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #72] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #56] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr d10, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.exp.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @exp_v8f32(<8 x float> %a) {
; CHECK-SD-LABEL: exp_v8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    stp q0, q1, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fmov s2, s0
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[3], v2.s[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp_v8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #176
; CHECK-GI-NEXT:    stp d13, d12, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #144] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #160] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 176
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    mov s11, v1.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    mov s12, v1.s[2]
; CHECK-GI-NEXT:    mov s13, v1.s[3]
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s11
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s12
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s13
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #48] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #160] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #144] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.s[2], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[3], v2.s[0]
; CHECK-GI-NEXT:    mov v3.s[3], v0.s[0]
; CHECK-GI-NEXT:    mov v2.16b, v1.16b
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    add sp, sp, #176
; CHECK-GI-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.exp.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @exp_v7f16(<7 x half> %a) {
; CHECK-SD-LABEL: exp_v7f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp_v7f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #160
; CHECK-GI-NEXT:    stp d13, d12, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #144] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 160
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    mov h11, v0.h[4]
; CHECK-GI-NEXT:    mov h12, v0.h[5]
; CHECK-GI-NEXT:    mov h13, v0.h[6]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #64] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #144] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #32] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #160
; CHECK-GI-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.exp.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @exp_v4f16(<4 x half> %a) {
; CHECK-SD-LABEL: exp_v4f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    fcvt s1, h1
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s1
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s0
; CHECK-SD-NEXT:    mov h1, v1.h[2]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v2.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q2, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s0
; CHECK-SD-NEXT:    mov h1, v1.h[3]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[3], v1.h[0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp_v4f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    str d10, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #56] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #72] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #56] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #72] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d10, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.exp.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @exp_v8f16(<8 x half> %a) {
; CHECK-SD-LABEL: exp_v8f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp_v8f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #176
; CHECK-GI-NEXT:    str d14, [sp, #112] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d13, d12, [sp, #120] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #136] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #152] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #168] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 176
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    .cfi_offset b11, -40
; CHECK-GI-NEXT:    .cfi_offset b12, -48
; CHECK-GI-NEXT:    .cfi_offset b13, -56
; CHECK-GI-NEXT:    .cfi_offset b14, -64
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    mov h11, v0.h[4]
; CHECK-GI-NEXT:    mov h12, v0.h[5]
; CHECK-GI-NEXT:    mov h13, v0.h[6]
; CHECK-GI-NEXT:    mov h14, v0.h[7]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h14
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #80] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #152] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #168] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #136] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr d14, [sp, #112] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #48] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #120] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[6], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[7], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #176
; CHECK-GI-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.exp.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @exp_v16f16(<16 x half> %a) {
; CHECK-SD-LABEL: exp_v16f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    stp q1, q0, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[7], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl expf
; CHECK-SD-NEXT:    fmov s1, s0
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s1
; CHECK-SD-NEXT:    ldp q1, q0, [sp, #16] // 32-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[7], v2.h[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp_v16f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #320
; CHECK-GI-NEXT:    stp d15, d14, [sp, #240] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d13, d12, [sp, #256] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #272] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #288] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x29, x30, [sp, #304] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 320
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    .cfi_offset b14, -72
; CHECK-GI-NEXT:    .cfi_offset b15, -80
; CHECK-GI-NEXT:    mov v2.16b, v1.16b
; CHECK-GI-NEXT:    str q1, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov h14, v1.h[1]
; CHECK-GI-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NEXT:    mov h15, v0.h[1]
; CHECK-GI-NEXT:    mov h8, v0.h[2]
; CHECK-GI-NEXT:    mov h9, v0.h[3]
; CHECK-GI-NEXT:    mov h10, v0.h[4]
; CHECK-GI-NEXT:    mov h11, v0.h[5]
; CHECK-GI-NEXT:    mov h12, v0.h[6]
; CHECK-GI-NEXT:    mov h13, v0.h[7]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    str h1, [sp, #16] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[3]
; CHECK-GI-NEXT:    str h1, [sp, #32] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[4]
; CHECK-GI-NEXT:    str h1, [sp, #48] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[5]
; CHECK-GI-NEXT:    str h1, [sp, #64] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[6]
; CHECK-GI-NEXT:    str h1, [sp, #96] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[7]
; CHECK-GI-NEXT:    str h1, [sp, #160] // 2-byte Folded Spill
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h15
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #192] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #224] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #208] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #176] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #144] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldr q1, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    fcvt s1, h14
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldr h1, [sp, #16] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldr h1, [sp, #32] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldr h1, [sp, #48] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldr h1, [sp, #64] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldr h1, [sp, #96] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldr h1, [sp, #160] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #160] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl expf
; CHECK-GI-NEXT:    ldr q3, [sp, #192] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr q2, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp x29, x30, [sp, #304] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q1, q2, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #288] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #272] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #224] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #256] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[2], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d15, d14, [sp, #240] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #208] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #176] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[4], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #144] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[5], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    fcvt h2, s0
; CHECK-GI-NEXT:    ldr q0, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[6], v0.h[0]
; CHECK-GI-NEXT:    ldr q0, [sp, #160] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-GI-NEXT:    ldr q0, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[7], v0.h[0]
; CHECK-GI-NEXT:    mov v1.h[7], v2.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v3.16b
; CHECK-GI-NEXT:    add sp, sp, #320
; CHECK-GI-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.exp.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

define double @exp2_f64(double %a) {
; CHECK-LABEL: exp2_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    b exp2
entry:
  %c = call double @llvm.exp2.f64(double %a)
  ret double %c
}

define float @exp2_f32(float %a) {
; CHECK-LABEL: exp2_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    b exp2f
entry:
  %c = call float @llvm.exp2.f32(float %a)
  ret float %c
}

define half @exp2_f16(half %a) {
; CHECK-LABEL: exp2_f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %c = call half @llvm.exp2.f16(half %a)
  ret half %c
}

define <1 x double> @exp2_v1f64(<1 x double> %x) {
; CHECK-LABEL: exp2_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl exp2
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %c = call <1 x double> @llvm.exp2.v1f64(<1 x double> %x)
  ret <1 x double> %c
}

define <2 x double> @exp2_v2f64(<2 x double> %a) {
; CHECK-SD-LABEL: exp2_v2f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    bl exp2
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl exp2
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp2_v2f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #32
; CHECK-GI-NEXT:    str d8, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl exp2
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl exp2
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d8, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #32
; CHECK-GI-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.exp2.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @exp2_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: exp2_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -8
; CHECK-SD-NEXT:    .cfi_offset b8, -16
; CHECK-SD-NEXT:    .cfi_offset b9, -24
; CHECK-SD-NEXT:    .cfi_offset b10, -32
; CHECK-SD-NEXT:    fmov d8, d2
; CHECK-SD-NEXT:    fmov d9, d1
; CHECK-SD-NEXT:    bl exp2
; CHECK-SD-NEXT:    fmov d10, d0
; CHECK-SD-NEXT:    fmov d0, d9
; CHECK-SD-NEXT:    bl exp2
; CHECK-SD-NEXT:    fmov d9, d0
; CHECK-SD-NEXT:    fmov d0, d8
; CHECK-SD-NEXT:    bl exp2
; CHECK-SD-NEXT:    fmov d1, d9
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fmov d2, d0
; CHECK-SD-NEXT:    fmov d0, d10
; CHECK-SD-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp2_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    fmov d8, d1
; CHECK-GI-NEXT:    fmov d9, d2
; CHECK-GI-NEXT:    bl exp2
; CHECK-GI-NEXT:    fmov d10, d0
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl exp2
; CHECK-GI-NEXT:    fmov d8, d0
; CHECK-GI-NEXT:    fmov d0, d9
; CHECK-GI-NEXT:    bl exp2
; CHECK-GI-NEXT:    fmov d1, d8
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fmov d2, d0
; CHECK-GI-NEXT:    fmov d0, d10
; CHECK-GI-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.exp2.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @exp2_v4f64(<4 x double> %a) {
; CHECK-SD-LABEL: exp2_v4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl exp2
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl exp2
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    bl exp2
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl exp2
; CHECK-SD-NEXT:    fmov d1, d0
; CHECK-SD-NEXT:    ldp q2, q0, [sp] // 32-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.d[1], v2.d[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp2_v4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    stp d9, d8, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #64] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    mov d9, v1.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl exp2
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl exp2
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl exp2
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d9
; CHECK-GI-NEXT:    bl exp2
; CHECK-GI-NEXT:    ldp q1, q2, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #64] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v2.d[1], v1.d[0]
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.exp2.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @exp2_v2f32(<2 x float> %a) {
; CHECK-SD-LABEL: exp2_v2f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp2_v2f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #32
; CHECK-GI-NEXT:    str d8, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d8, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v0.s[0]
; CHECK-GI-NEXT:    fmov d0, d1
; CHECK-GI-NEXT:    add sp, sp, #32
; CHECK-GI-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.exp2.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @exp2_v3f32(<3 x float> %a) {
; CHECK-SD-LABEL: exp2_v3f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp2_v3f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #64
; CHECK-GI-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #64
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.exp2.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @exp2_v4f32(<4 x float> %a) {
; CHECK-SD-LABEL: exp2_v4f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp2_v4f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    str d10, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #56] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #72] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #72] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #56] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr d10, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.exp2.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @exp2_v8f32(<8 x float> %a) {
; CHECK-SD-LABEL: exp2_v8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    stp q0, q1, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fmov s2, s0
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[3], v2.s[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp2_v8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #176
; CHECK-GI-NEXT:    stp d13, d12, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #144] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #160] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 176
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    mov s11, v1.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    mov s12, v1.s[2]
; CHECK-GI-NEXT:    mov s13, v1.s[3]
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s11
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s12
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s13
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #48] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #160] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #144] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.s[2], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[3], v2.s[0]
; CHECK-GI-NEXT:    mov v3.s[3], v0.s[0]
; CHECK-GI-NEXT:    mov v2.16b, v1.16b
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    add sp, sp, #176
; CHECK-GI-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.exp2.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @exp2_v7f16(<7 x half> %a) {
; CHECK-SD-LABEL: exp2_v7f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp2_v7f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #160
; CHECK-GI-NEXT:    stp d13, d12, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #144] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 160
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    mov h11, v0.h[4]
; CHECK-GI-NEXT:    mov h12, v0.h[5]
; CHECK-GI-NEXT:    mov h13, v0.h[6]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #64] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #144] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #32] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #160
; CHECK-GI-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.exp2.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @exp2_v4f16(<4 x half> %a) {
; CHECK-SD-LABEL: exp2_v4f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    fcvt s1, h1
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s1
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s0
; CHECK-SD-NEXT:    mov h1, v1.h[2]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v2.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q2, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s0
; CHECK-SD-NEXT:    mov h1, v1.h[3]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[3], v1.h[0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp2_v4f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    str d10, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #56] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #72] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #56] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #72] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d10, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.exp2.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @exp2_v8f16(<8 x half> %a) {
; CHECK-SD-LABEL: exp2_v8f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp2_v8f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #176
; CHECK-GI-NEXT:    str d14, [sp, #112] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d13, d12, [sp, #120] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #136] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #152] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #168] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 176
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    .cfi_offset b11, -40
; CHECK-GI-NEXT:    .cfi_offset b12, -48
; CHECK-GI-NEXT:    .cfi_offset b13, -56
; CHECK-GI-NEXT:    .cfi_offset b14, -64
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    mov h11, v0.h[4]
; CHECK-GI-NEXT:    mov h12, v0.h[5]
; CHECK-GI-NEXT:    mov h13, v0.h[6]
; CHECK-GI-NEXT:    mov h14, v0.h[7]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h14
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #80] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #152] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #168] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #136] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr d14, [sp, #112] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #48] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #120] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[6], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[7], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #176
; CHECK-GI-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.exp2.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @exp2_v16f16(<16 x half> %a) {
; CHECK-SD-LABEL: exp2_v16f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    stp q1, q0, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[7], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl exp2f
; CHECK-SD-NEXT:    fmov s1, s0
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s1
; CHECK-SD-NEXT:    ldp q1, q0, [sp, #16] // 32-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[7], v2.h[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: exp2_v16f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #320
; CHECK-GI-NEXT:    stp d15, d14, [sp, #240] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d13, d12, [sp, #256] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #272] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #288] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x29, x30, [sp, #304] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 320
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    .cfi_offset b14, -72
; CHECK-GI-NEXT:    .cfi_offset b15, -80
; CHECK-GI-NEXT:    mov v2.16b, v1.16b
; CHECK-GI-NEXT:    str q1, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov h14, v1.h[1]
; CHECK-GI-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NEXT:    mov h15, v0.h[1]
; CHECK-GI-NEXT:    mov h8, v0.h[2]
; CHECK-GI-NEXT:    mov h9, v0.h[3]
; CHECK-GI-NEXT:    mov h10, v0.h[4]
; CHECK-GI-NEXT:    mov h11, v0.h[5]
; CHECK-GI-NEXT:    mov h12, v0.h[6]
; CHECK-GI-NEXT:    mov h13, v0.h[7]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    str h1, [sp, #16] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[3]
; CHECK-GI-NEXT:    str h1, [sp, #32] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[4]
; CHECK-GI-NEXT:    str h1, [sp, #48] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[5]
; CHECK-GI-NEXT:    str h1, [sp, #64] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[6]
; CHECK-GI-NEXT:    str h1, [sp, #96] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[7]
; CHECK-GI-NEXT:    str h1, [sp, #160] // 2-byte Folded Spill
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h15
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #192] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #224] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #208] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #176] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #144] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldr q1, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    fcvt s1, h14
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldr h1, [sp, #16] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldr h1, [sp, #32] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldr h1, [sp, #48] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldr h1, [sp, #64] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldr h1, [sp, #96] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldr h1, [sp, #160] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #160] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl exp2f
; CHECK-GI-NEXT:    ldr q3, [sp, #192] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr q2, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp x29, x30, [sp, #304] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q1, q2, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #288] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #272] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #224] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #256] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[2], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d15, d14, [sp, #240] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #208] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #176] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[4], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #144] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[5], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    fcvt h2, s0
; CHECK-GI-NEXT:    ldr q0, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[6], v0.h[0]
; CHECK-GI-NEXT:    ldr q0, [sp, #160] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-GI-NEXT:    ldr q0, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[7], v0.h[0]
; CHECK-GI-NEXT:    mov v1.h[7], v2.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v3.16b
; CHECK-GI-NEXT:    add sp, sp, #320
; CHECK-GI-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.exp2.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

define double @log_f64(double %a) {
; CHECK-LABEL: log_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    b log
entry:
  %c = call double @llvm.log.f64(double %a)
  ret double %c
}

define float @log_f32(float %a) {
; CHECK-LABEL: log_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    b logf
entry:
  %c = call float @llvm.log.f32(float %a)
  ret float %c
}

define half @log_f16(half %a) {
; CHECK-LABEL: log_f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %c = call half @llvm.log.f16(half %a)
  ret half %c
}

define <1 x double> @log_v1f64(<1 x double> %x) {
; CHECK-LABEL: log_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl log
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %c = call <1 x double> @llvm.log.v1f64(<1 x double> %x)
  ret <1 x double> %c
}

define <2 x double> @log_v2f64(<2 x double> %a) {
; CHECK-SD-LABEL: log_v2f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    bl log
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl log
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log_v2f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #32
; CHECK-GI-NEXT:    str d8, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl log
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl log
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d8, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #32
; CHECK-GI-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.log.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @log_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: log_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -8
; CHECK-SD-NEXT:    .cfi_offset b8, -16
; CHECK-SD-NEXT:    .cfi_offset b9, -24
; CHECK-SD-NEXT:    .cfi_offset b10, -32
; CHECK-SD-NEXT:    fmov d8, d2
; CHECK-SD-NEXT:    fmov d9, d1
; CHECK-SD-NEXT:    bl log
; CHECK-SD-NEXT:    fmov d10, d0
; CHECK-SD-NEXT:    fmov d0, d9
; CHECK-SD-NEXT:    bl log
; CHECK-SD-NEXT:    fmov d9, d0
; CHECK-SD-NEXT:    fmov d0, d8
; CHECK-SD-NEXT:    bl log
; CHECK-SD-NEXT:    fmov d1, d9
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fmov d2, d0
; CHECK-SD-NEXT:    fmov d0, d10
; CHECK-SD-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    fmov d8, d1
; CHECK-GI-NEXT:    fmov d9, d2
; CHECK-GI-NEXT:    bl log
; CHECK-GI-NEXT:    fmov d10, d0
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl log
; CHECK-GI-NEXT:    fmov d8, d0
; CHECK-GI-NEXT:    fmov d0, d9
; CHECK-GI-NEXT:    bl log
; CHECK-GI-NEXT:    fmov d1, d8
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fmov d2, d0
; CHECK-GI-NEXT:    fmov d0, d10
; CHECK-GI-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.log.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @log_v4f64(<4 x double> %a) {
; CHECK-SD-LABEL: log_v4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl log
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    bl log
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl log
; CHECK-SD-NEXT:    fmov d1, d0
; CHECK-SD-NEXT:    ldp q2, q0, [sp] // 32-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.d[1], v2.d[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log_v4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    stp d9, d8, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #64] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    mov d9, v1.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl log
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl log
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl log
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d9
; CHECK-GI-NEXT:    bl log
; CHECK-GI-NEXT:    ldp q1, q2, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #64] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v2.d[1], v1.d[0]
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.log.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @log_v2f32(<2 x float> %a) {
; CHECK-SD-LABEL: log_v2f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log_v2f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #32
; CHECK-GI-NEXT:    str d8, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d8, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v0.s[0]
; CHECK-GI-NEXT:    fmov d0, d1
; CHECK-GI-NEXT:    add sp, sp, #32
; CHECK-GI-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.log.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @log_v3f32(<3 x float> %a) {
; CHECK-SD-LABEL: log_v3f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log_v3f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #64
; CHECK-GI-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldp q2, q1, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #64
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.log.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @log_v4f32(<4 x float> %a) {
; CHECK-SD-LABEL: log_v4f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log_v4f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    str d10, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #56] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #72] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #72] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #56] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr d10, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.log.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @log_v8f32(<8 x float> %a) {
; CHECK-SD-LABEL: log_v8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    stp q0, q1, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fmov s2, s0
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[3], v2.s[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log_v8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #176
; CHECK-GI-NEXT:    stp d13, d12, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #144] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #160] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 176
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    mov s11, v1.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    mov s12, v1.s[2]
; CHECK-GI-NEXT:    mov s13, v1.s[3]
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s11
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s12
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s13
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #48] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #160] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #144] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.s[2], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[3], v2.s[0]
; CHECK-GI-NEXT:    mov v3.s[3], v0.s[0]
; CHECK-GI-NEXT:    mov v2.16b, v1.16b
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    add sp, sp, #176
; CHECK-GI-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.log.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @log_v7f16(<7 x half> %a) {
; CHECK-SD-LABEL: log_v7f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log_v7f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #160
; CHECK-GI-NEXT:    stp d13, d12, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #144] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 160
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    mov h11, v0.h[4]
; CHECK-GI-NEXT:    mov h12, v0.h[5]
; CHECK-GI-NEXT:    mov h13, v0.h[6]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #64] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #144] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #32] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #160
; CHECK-GI-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.log.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @log_v4f16(<4 x half> %a) {
; CHECK-SD-LABEL: log_v4f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    fcvt s1, h1
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s1
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s0
; CHECK-SD-NEXT:    mov h1, v1.h[2]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v2.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q2, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s0
; CHECK-SD-NEXT:    mov h1, v1.h[3]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[3], v1.h[0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log_v4f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    str d10, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #56] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #72] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #56] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #72] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d10, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.log.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @log_v8f16(<8 x half> %a) {
; CHECK-SD-LABEL: log_v8f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log_v8f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #176
; CHECK-GI-NEXT:    str d14, [sp, #112] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d13, d12, [sp, #120] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #136] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #152] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #168] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 176
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    .cfi_offset b11, -40
; CHECK-GI-NEXT:    .cfi_offset b12, -48
; CHECK-GI-NEXT:    .cfi_offset b13, -56
; CHECK-GI-NEXT:    .cfi_offset b14, -64
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    mov h11, v0.h[4]
; CHECK-GI-NEXT:    mov h12, v0.h[5]
; CHECK-GI-NEXT:    mov h13, v0.h[6]
; CHECK-GI-NEXT:    mov h14, v0.h[7]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h14
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #80] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #152] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #168] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #136] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr d14, [sp, #112] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #48] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #120] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[6], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[7], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #176
; CHECK-GI-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.log.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @log_v16f16(<16 x half> %a) {
; CHECK-SD-LABEL: log_v16f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    stp q1, q0, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[7], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl logf
; CHECK-SD-NEXT:    fmov s1, s0
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s1
; CHECK-SD-NEXT:    ldp q1, q0, [sp, #16] // 32-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[7], v2.h[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log_v16f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #320
; CHECK-GI-NEXT:    stp d15, d14, [sp, #240] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d13, d12, [sp, #256] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #272] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #288] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x29, x30, [sp, #304] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 320
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    .cfi_offset b14, -72
; CHECK-GI-NEXT:    .cfi_offset b15, -80
; CHECK-GI-NEXT:    mov v2.16b, v1.16b
; CHECK-GI-NEXT:    str q1, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov h14, v1.h[1]
; CHECK-GI-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NEXT:    mov h15, v0.h[1]
; CHECK-GI-NEXT:    mov h8, v0.h[2]
; CHECK-GI-NEXT:    mov h9, v0.h[3]
; CHECK-GI-NEXT:    mov h10, v0.h[4]
; CHECK-GI-NEXT:    mov h11, v0.h[5]
; CHECK-GI-NEXT:    mov h12, v0.h[6]
; CHECK-GI-NEXT:    mov h13, v0.h[7]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    str h1, [sp, #16] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[3]
; CHECK-GI-NEXT:    str h1, [sp, #32] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[4]
; CHECK-GI-NEXT:    str h1, [sp, #48] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[5]
; CHECK-GI-NEXT:    str h1, [sp, #64] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[6]
; CHECK-GI-NEXT:    str h1, [sp, #96] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[7]
; CHECK-GI-NEXT:    str h1, [sp, #160] // 2-byte Folded Spill
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h15
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #192] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #224] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #208] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #176] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #144] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldr q1, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    fcvt s1, h14
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldr h1, [sp, #16] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldr h1, [sp, #32] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldr h1, [sp, #48] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldr h1, [sp, #64] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldr h1, [sp, #96] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldr h1, [sp, #160] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #160] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl logf
; CHECK-GI-NEXT:    ldr q3, [sp, #192] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr q2, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp x29, x30, [sp, #304] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q1, q2, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #288] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #272] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #224] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #256] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[2], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d15, d14, [sp, #240] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #208] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #176] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[4], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #144] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[5], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    fcvt h2, s0
; CHECK-GI-NEXT:    ldr q0, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[6], v0.h[0]
; CHECK-GI-NEXT:    ldr q0, [sp, #160] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-GI-NEXT:    ldr q0, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[7], v0.h[0]
; CHECK-GI-NEXT:    mov v1.h[7], v2.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v3.16b
; CHECK-GI-NEXT:    add sp, sp, #320
; CHECK-GI-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.log.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

define double @log2_f64(double %a) {
; CHECK-LABEL: log2_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    b log2
entry:
  %c = call double @llvm.log2.f64(double %a)
  ret double %c
}

define float @log2_f32(float %a) {
; CHECK-LABEL: log2_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    b log2f
entry:
  %c = call float @llvm.log2.f32(float %a)
  ret float %c
}

define half @log2_f16(half %a) {
; CHECK-LABEL: log2_f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %c = call half @llvm.log2.f16(half %a)
  ret half %c
}

define <1 x double> @log2_v1f64(<1 x double> %x) {
; CHECK-LABEL: log2_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl log2
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %c = call <1 x double> @llvm.log2.v1f64(<1 x double> %x)
  ret <1 x double> %c
}

define <2 x double> @log2_v2f64(<2 x double> %a) {
; CHECK-SD-LABEL: log2_v2f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    bl log2
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl log2
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log2_v2f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #32
; CHECK-GI-NEXT:    str d8, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl log2
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl log2
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d8, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #32
; CHECK-GI-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.log2.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @log2_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: log2_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -8
; CHECK-SD-NEXT:    .cfi_offset b8, -16
; CHECK-SD-NEXT:    .cfi_offset b9, -24
; CHECK-SD-NEXT:    .cfi_offset b10, -32
; CHECK-SD-NEXT:    fmov d8, d2
; CHECK-SD-NEXT:    fmov d9, d1
; CHECK-SD-NEXT:    bl log2
; CHECK-SD-NEXT:    fmov d10, d0
; CHECK-SD-NEXT:    fmov d0, d9
; CHECK-SD-NEXT:    bl log2
; CHECK-SD-NEXT:    fmov d9, d0
; CHECK-SD-NEXT:    fmov d0, d8
; CHECK-SD-NEXT:    bl log2
; CHECK-SD-NEXT:    fmov d1, d9
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fmov d2, d0
; CHECK-SD-NEXT:    fmov d0, d10
; CHECK-SD-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log2_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    fmov d8, d1
; CHECK-GI-NEXT:    fmov d9, d2
; CHECK-GI-NEXT:    bl log2
; CHECK-GI-NEXT:    fmov d10, d0
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl log2
; CHECK-GI-NEXT:    fmov d8, d0
; CHECK-GI-NEXT:    fmov d0, d9
; CHECK-GI-NEXT:    bl log2
; CHECK-GI-NEXT:    fmov d1, d8
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fmov d2, d0
; CHECK-GI-NEXT:    fmov d0, d10
; CHECK-GI-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.log2.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @log2_v4f64(<4 x double> %a) {
; CHECK-SD-LABEL: log2_v4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log2
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl log2
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    bl log2
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl log2
; CHECK-SD-NEXT:    fmov d1, d0
; CHECK-SD-NEXT:    ldp q2, q0, [sp] // 32-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.d[1], v2.d[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log2_v4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    stp d9, d8, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #64] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    mov d9, v1.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl log2
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl log2
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl log2
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d9
; CHECK-GI-NEXT:    bl log2
; CHECK-GI-NEXT:    ldp q1, q2, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #64] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v2.d[1], v1.d[0]
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.log2.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @log2_v2f32(<2 x float> %a) {
; CHECK-SD-LABEL: log2_v2f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log2_v2f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #32
; CHECK-GI-NEXT:    str d8, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d8, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v0.s[0]
; CHECK-GI-NEXT:    fmov d0, d1
; CHECK-GI-NEXT:    add sp, sp, #32
; CHECK-GI-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.log2.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @log2_v3f32(<3 x float> %a) {
; CHECK-SD-LABEL: log2_v3f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log2_v3f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #64
; CHECK-GI-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #64
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.log2.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @log2_v4f32(<4 x float> %a) {
; CHECK-SD-LABEL: log2_v4f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log2_v4f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    str d10, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #56] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #72] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #72] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #56] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr d10, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.log2.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @log2_v8f32(<8 x float> %a) {
; CHECK-SD-LABEL: log2_v8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    stp q0, q1, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fmov s2, s0
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[3], v2.s[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log2_v8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #176
; CHECK-GI-NEXT:    stp d13, d12, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #144] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #160] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 176
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    mov s11, v1.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    mov s12, v1.s[2]
; CHECK-GI-NEXT:    mov s13, v1.s[3]
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s11
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s12
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s13
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #48] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #160] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #144] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.s[2], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[3], v2.s[0]
; CHECK-GI-NEXT:    mov v3.s[3], v0.s[0]
; CHECK-GI-NEXT:    mov v2.16b, v1.16b
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    add sp, sp, #176
; CHECK-GI-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.log2.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @log2_v7f16(<7 x half> %a) {
; CHECK-SD-LABEL: log2_v7f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log2_v7f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #160
; CHECK-GI-NEXT:    stp d13, d12, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #144] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 160
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    mov h11, v0.h[4]
; CHECK-GI-NEXT:    mov h12, v0.h[5]
; CHECK-GI-NEXT:    mov h13, v0.h[6]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #64] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #144] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #32] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #160
; CHECK-GI-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.log2.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @log2_v4f16(<4 x half> %a) {
; CHECK-SD-LABEL: log2_v4f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    fcvt s1, h1
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s1
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s0
; CHECK-SD-NEXT:    mov h1, v1.h[2]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v2.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q2, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s0
; CHECK-SD-NEXT:    mov h1, v1.h[3]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[3], v1.h[0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log2_v4f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    str d10, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #56] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #72] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #56] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #72] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d10, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.log2.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @log2_v8f16(<8 x half> %a) {
; CHECK-SD-LABEL: log2_v8f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log2_v8f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #176
; CHECK-GI-NEXT:    str d14, [sp, #112] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d13, d12, [sp, #120] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #136] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #152] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #168] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 176
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    .cfi_offset b11, -40
; CHECK-GI-NEXT:    .cfi_offset b12, -48
; CHECK-GI-NEXT:    .cfi_offset b13, -56
; CHECK-GI-NEXT:    .cfi_offset b14, -64
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    mov h11, v0.h[4]
; CHECK-GI-NEXT:    mov h12, v0.h[5]
; CHECK-GI-NEXT:    mov h13, v0.h[6]
; CHECK-GI-NEXT:    mov h14, v0.h[7]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h14
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #80] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #152] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #168] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #136] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr d14, [sp, #112] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #48] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #120] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[6], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[7], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #176
; CHECK-GI-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.log2.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @log2_v16f16(<16 x half> %a) {
; CHECK-SD-LABEL: log2_v16f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    stp q1, q0, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[7], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log2f
; CHECK-SD-NEXT:    fmov s1, s0
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s1
; CHECK-SD-NEXT:    ldp q1, q0, [sp, #16] // 32-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[7], v2.h[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log2_v16f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #320
; CHECK-GI-NEXT:    stp d15, d14, [sp, #240] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d13, d12, [sp, #256] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #272] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #288] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x29, x30, [sp, #304] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 320
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    .cfi_offset b14, -72
; CHECK-GI-NEXT:    .cfi_offset b15, -80
; CHECK-GI-NEXT:    mov v2.16b, v1.16b
; CHECK-GI-NEXT:    str q1, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov h14, v1.h[1]
; CHECK-GI-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NEXT:    mov h15, v0.h[1]
; CHECK-GI-NEXT:    mov h8, v0.h[2]
; CHECK-GI-NEXT:    mov h9, v0.h[3]
; CHECK-GI-NEXT:    mov h10, v0.h[4]
; CHECK-GI-NEXT:    mov h11, v0.h[5]
; CHECK-GI-NEXT:    mov h12, v0.h[6]
; CHECK-GI-NEXT:    mov h13, v0.h[7]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    str h1, [sp, #16] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[3]
; CHECK-GI-NEXT:    str h1, [sp, #32] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[4]
; CHECK-GI-NEXT:    str h1, [sp, #48] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[5]
; CHECK-GI-NEXT:    str h1, [sp, #64] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[6]
; CHECK-GI-NEXT:    str h1, [sp, #96] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[7]
; CHECK-GI-NEXT:    str h1, [sp, #160] // 2-byte Folded Spill
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h15
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #192] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #224] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #208] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #176] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #144] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldr q1, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    fcvt s1, h14
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldr h1, [sp, #16] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldr h1, [sp, #32] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldr h1, [sp, #48] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldr h1, [sp, #64] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldr h1, [sp, #96] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldr h1, [sp, #160] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #160] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log2f
; CHECK-GI-NEXT:    ldr q3, [sp, #192] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr q2, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp x29, x30, [sp, #304] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q1, q2, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #288] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #272] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #224] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #256] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[2], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d15, d14, [sp, #240] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #208] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #176] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[4], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #144] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[5], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    fcvt h2, s0
; CHECK-GI-NEXT:    ldr q0, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[6], v0.h[0]
; CHECK-GI-NEXT:    ldr q0, [sp, #160] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-GI-NEXT:    ldr q0, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[7], v0.h[0]
; CHECK-GI-NEXT:    mov v1.h[7], v2.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v3.16b
; CHECK-GI-NEXT:    add sp, sp, #320
; CHECK-GI-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.log2.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

define double @log10_f64(double %a) {
; CHECK-LABEL: log10_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    b log10
entry:
  %c = call double @llvm.log10.f64(double %a)
  ret double %c
}

define float @log10_f32(float %a) {
; CHECK-LABEL: log10_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    b log10f
entry:
  %c = call float @llvm.log10.f32(float %a)
  ret float %c
}

define half @log10_f16(half %a) {
; CHECK-LABEL: log10_f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %c = call half @llvm.log10.f16(half %a)
  ret half %c
}

define <1 x double> @log10_v1f64(<1 x double> %x) {
; CHECK-LABEL: log10_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl log10
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %c = call <1 x double> @llvm.log10.v1f64(<1 x double> %x)
  ret <1 x double> %c
}

define <2 x double> @log10_v2f64(<2 x double> %a) {
; CHECK-SD-LABEL: log10_v2f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    bl log10
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl log10
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log10_v2f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #32
; CHECK-GI-NEXT:    str d8, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl log10
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl log10
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d8, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #32
; CHECK-GI-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.log10.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @log10_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: log10_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -8
; CHECK-SD-NEXT:    .cfi_offset b8, -16
; CHECK-SD-NEXT:    .cfi_offset b9, -24
; CHECK-SD-NEXT:    .cfi_offset b10, -32
; CHECK-SD-NEXT:    fmov d8, d2
; CHECK-SD-NEXT:    fmov d9, d1
; CHECK-SD-NEXT:    bl log10
; CHECK-SD-NEXT:    fmov d10, d0
; CHECK-SD-NEXT:    fmov d0, d9
; CHECK-SD-NEXT:    bl log10
; CHECK-SD-NEXT:    fmov d9, d0
; CHECK-SD-NEXT:    fmov d0, d8
; CHECK-SD-NEXT:    bl log10
; CHECK-SD-NEXT:    fmov d1, d9
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fmov d2, d0
; CHECK-SD-NEXT:    fmov d0, d10
; CHECK-SD-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log10_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    str d10, [sp, #-32]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #8] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    fmov d8, d1
; CHECK-GI-NEXT:    fmov d9, d2
; CHECK-GI-NEXT:    bl log10
; CHECK-GI-NEXT:    fmov d10, d0
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl log10
; CHECK-GI-NEXT:    fmov d8, d0
; CHECK-GI-NEXT:    fmov d0, d9
; CHECK-GI-NEXT:    bl log10
; CHECK-GI-NEXT:    fmov d1, d8
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #8] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fmov d2, d0
; CHECK-GI-NEXT:    fmov d0, d10
; CHECK-GI-NEXT:    ldr d10, [sp], #32 // 8-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.log10.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @log10_v4f64(<4 x double> %a) {
; CHECK-SD-LABEL: log10_v4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log10
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl log10
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov d0, v0.d[1]
; CHECK-SD-NEXT:    bl log10
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl log10
; CHECK-SD-NEXT:    fmov d1, d0
; CHECK-SD-NEXT:    ldp q2, q0, [sp] // 32-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.d[1], v2.d[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log10_v4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    stp d9, d8, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #64] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    mov d9, v1.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl log10
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    bl log10
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl log10
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov d0, d9
; CHECK-GI-NEXT:    bl log10
; CHECK-GI-NEXT:    ldp q1, q2, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #64] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v2.d[1], v1.d[0]
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.log10.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @log10_v2f32(<2 x float> %a) {
; CHECK-SD-LABEL: log10_v2f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log10_v2f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #32
; CHECK-GI-NEXT:    str d8, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #24] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #24] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d8, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v0.s[0]
; CHECK-GI-NEXT:    fmov d0, d1
; CHECK-GI-NEXT:    add sp, sp, #32
; CHECK-GI-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.log10.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @log10_v3f32(<3 x float> %a) {
; CHECK-SD-LABEL: log10_v3f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log10_v3f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #64
; CHECK-GI-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldp q2, q1, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #64
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.log10.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @log10_v4f32(<4 x float> %a) {
; CHECK-SD-LABEL: log10_v4f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log10_v4f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    str d10, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #56] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #72] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #72] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #56] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr d10, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.log10.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @log10_v8f32(<8 x float> %a) {
; CHECK-SD-LABEL: log10_v8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    stp q0, q1, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[2]
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s0, v0.s[3]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fmov s2, s0
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.s[3], v2.s[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log10_v8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #176
; CHECK-GI-NEXT:    stp d13, d12, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #144] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #160] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 176
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    mov s11, v1.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    mov s12, v1.s[2]
; CHECK-GI-NEXT:    mov s13, v1.s[3]
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s11
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s12
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s13
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #48] // 32-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    ldr x30, [sp, #160] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #144] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.s[1], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.s[2], v2.s[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.s[3], v2.s[0]
; CHECK-GI-NEXT:    mov v3.s[3], v0.s[0]
; CHECK-GI-NEXT:    mov v2.16b, v1.16b
; CHECK-GI-NEXT:    mov v1.16b, v3.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    add sp, sp, #176
; CHECK-GI-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.log10.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @log10_v7f16(<7 x half> %a) {
; CHECK-SD-LABEL: log10_v7f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log10_v7f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #160
; CHECK-GI-NEXT:    stp d13, d12, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #144] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 160
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    mov h11, v0.h[4]
; CHECK-GI-NEXT:    mov h12, v0.h[5]
; CHECK-GI-NEXT:    mov h13, v0.h[6]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #64] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #144] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #32] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #160
; CHECK-GI-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.log10.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @log10_v4f16(<4 x half> %a) {
; CHECK-SD-LABEL: log10_v4f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    fcvt s1, h1
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s1
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s0
; CHECK-SD-NEXT:    mov h1, v1.h[2]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v2.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q2, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s0
; CHECK-SD-NEXT:    mov h1, v1.h[3]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[3], v1.h[0]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log10_v4f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #80
; CHECK-GI-NEXT:    str d10, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #56] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #72] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 80
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #56] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #72] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldr d10, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    add sp, sp, #80
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.log10.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @log10_v8f16(<8 x half> %a) {
; CHECK-SD-LABEL: log10_v8f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #48
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h1, s0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log10_v8f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #176
; CHECK-GI-NEXT:    str d14, [sp, #112] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp d13, d12, [sp, #120] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #136] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #152] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #168] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 176
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset b8, -16
; CHECK-GI-NEXT:    .cfi_offset b9, -24
; CHECK-GI-NEXT:    .cfi_offset b10, -32
; CHECK-GI-NEXT:    .cfi_offset b11, -40
; CHECK-GI-NEXT:    .cfi_offset b12, -48
; CHECK-GI-NEXT:    .cfi_offset b13, -56
; CHECK-GI-NEXT:    .cfi_offset b14, -64
; CHECK-GI-NEXT:    mov h8, v0.h[1]
; CHECK-GI-NEXT:    mov h9, v0.h[2]
; CHECK-GI-NEXT:    mov h10, v0.h[3]
; CHECK-GI-NEXT:    mov h11, v0.h[4]
; CHECK-GI-NEXT:    mov h12, v0.h[5]
; CHECK-GI-NEXT:    mov h13, v0.h[6]
; CHECK-GI-NEXT:    mov h14, v0.h[7]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h14
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldp q2, q1, [sp, #80] // 32-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #152] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #168] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #136] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr d14, [sp, #112] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #48] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #120] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldp q2, q3, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v3.h[0]
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[6], v2.h[0]
; CHECK-GI-NEXT:    mov v1.h[7], v0.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    add sp, sp, #176
; CHECK-GI-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.log10.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @log10_v16f16(<16 x half> %a) {
; CHECK-SD-LABEL: log10_v16f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    stp q1, q0, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    fcvt s0, h1
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[7], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[1]
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[2], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[3], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[4]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[4], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[5]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[5], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[6]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    bl log10f
; CHECK-SD-NEXT:    fmov s1, s0
; CHECK-SD-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcvt h2, s1
; CHECK-SD-NEXT:    ldp q1, q0, [sp, #16] // 32-byte Folded Reload
; CHECK-SD-NEXT:    mov v1.h[7], v2.h[0]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: log10_v16f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #320
; CHECK-GI-NEXT:    stp d15, d14, [sp, #240] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d13, d12, [sp, #256] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d11, d10, [sp, #272] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #288] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x29, x30, [sp, #304] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 320
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    .cfi_offset b10, -40
; CHECK-GI-NEXT:    .cfi_offset b11, -48
; CHECK-GI-NEXT:    .cfi_offset b12, -56
; CHECK-GI-NEXT:    .cfi_offset b13, -64
; CHECK-GI-NEXT:    .cfi_offset b14, -72
; CHECK-GI-NEXT:    .cfi_offset b15, -80
; CHECK-GI-NEXT:    mov v2.16b, v1.16b
; CHECK-GI-NEXT:    str q1, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov h14, v1.h[1]
; CHECK-GI-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NEXT:    mov h15, v0.h[1]
; CHECK-GI-NEXT:    mov h8, v0.h[2]
; CHECK-GI-NEXT:    mov h9, v0.h[3]
; CHECK-GI-NEXT:    mov h10, v0.h[4]
; CHECK-GI-NEXT:    mov h11, v0.h[5]
; CHECK-GI-NEXT:    mov h12, v0.h[6]
; CHECK-GI-NEXT:    mov h13, v0.h[7]
; CHECK-GI-NEXT:    fcvt s0, h0
; CHECK-GI-NEXT:    str h1, [sp, #16] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[3]
; CHECK-GI-NEXT:    str h1, [sp, #32] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[4]
; CHECK-GI-NEXT:    str h1, [sp, #48] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[5]
; CHECK-GI-NEXT:    str h1, [sp, #64] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[6]
; CHECK-GI-NEXT:    str h1, [sp, #96] // 2-byte Folded Spill
; CHECK-GI-NEXT:    mov h1, v2.h[7]
; CHECK-GI-NEXT:    str h1, [sp, #160] // 2-byte Folded Spill
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h15
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #192] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h8
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h9
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #224] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h10
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #208] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h11
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #176] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h12
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #144] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h13
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldr q1, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    fcvt s1, h14
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldr h1, [sp, #16] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldr h1, [sp, #32] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldr h1, [sp, #48] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldr h1, [sp, #64] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldr h1, [sp, #96] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldr h1, [sp, #160] // 2-byte Folded Reload
; CHECK-GI-NEXT:    fcvt h0, s0
; CHECK-GI-NEXT:    fcvt s1, h1
; CHECK-GI-NEXT:    str q0, [sp, #160] // 16-byte Folded Spill
; CHECK-GI-NEXT:    fmov s0, s1
; CHECK-GI-NEXT:    bl log10f
; CHECK-GI-NEXT:    ldr q3, [sp, #192] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr q2, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp x29, x30, [sp, #304] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldp q1, q2, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #288] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #272] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[1], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #224] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d13, d12, [sp, #256] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[2], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d15, d14, [sp, #240] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #208] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #176] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[4], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[4], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #144] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[5], v2.h[0]
; CHECK-GI-NEXT:    ldr q2, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[5], v2.h[0]
; CHECK-GI-NEXT:    fcvt h2, s0
; CHECK-GI-NEXT:    ldr q0, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[6], v0.h[0]
; CHECK-GI-NEXT:    ldr q0, [sp, #160] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v1.h[6], v0.h[0]
; CHECK-GI-NEXT:    ldr q0, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v3.h[7], v0.h[0]
; CHECK-GI-NEXT:    mov v1.h[7], v2.h[0]
; CHECK-GI-NEXT:    mov v0.16b, v3.16b
; CHECK-GI-NEXT:    add sp, sp, #320
; CHECK-GI-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.log10.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

declare <16 x half> @llvm.exp.v16f16(<16 x half>)
declare <16 x half> @llvm.exp2.v16f16(<16 x half>)
declare <16 x half> @llvm.log.v16f16(<16 x half>)
declare <16 x half> @llvm.log10.v16f16(<16 x half>)
declare <16 x half> @llvm.log2.v16f16(<16 x half>)
declare <2 x double> @llvm.exp.v2f64(<2 x double>)
declare <2 x double> @llvm.exp2.v2f64(<2 x double>)
declare <2 x double> @llvm.log.v2f64(<2 x double>)
declare <2 x double> @llvm.log10.v2f64(<2 x double>)
declare <2 x double> @llvm.log2.v2f64(<2 x double>)
declare <2 x float> @llvm.exp.v2f32(<2 x float>)
declare <2 x float> @llvm.exp2.v2f32(<2 x float>)
declare <2 x float> @llvm.log.v2f32(<2 x float>)
declare <2 x float> @llvm.log10.v2f32(<2 x float>)
declare <2 x float> @llvm.log2.v2f32(<2 x float>)
declare <3 x double> @llvm.exp.v3f64(<3 x double>)
declare <3 x double> @llvm.exp2.v3f64(<3 x double>)
declare <3 x double> @llvm.log.v3f64(<3 x double>)
declare <3 x double> @llvm.log10.v3f64(<3 x double>)
declare <3 x double> @llvm.log2.v3f64(<3 x double>)
declare <3 x float> @llvm.exp.v3f32(<3 x float>)
declare <3 x float> @llvm.exp2.v3f32(<3 x float>)
declare <3 x float> @llvm.log.v3f32(<3 x float>)
declare <3 x float> @llvm.log10.v3f32(<3 x float>)
declare <3 x float> @llvm.log2.v3f32(<3 x float>)
declare <4 x double> @llvm.exp.v4f64(<4 x double>)
declare <4 x double> @llvm.exp2.v4f64(<4 x double>)
declare <4 x double> @llvm.log.v4f64(<4 x double>)
declare <4 x double> @llvm.log10.v4f64(<4 x double>)
declare <4 x double> @llvm.log2.v4f64(<4 x double>)
declare <4 x float> @llvm.exp.v4f32(<4 x float>)
declare <4 x float> @llvm.exp2.v4f32(<4 x float>)
declare <4 x float> @llvm.log.v4f32(<4 x float>)
declare <4 x float> @llvm.log10.v4f32(<4 x float>)
declare <4 x float> @llvm.log2.v4f32(<4 x float>)
declare <4 x half> @llvm.exp.v4f16(<4 x half>)
declare <4 x half> @llvm.exp2.v4f16(<4 x half>)
declare <4 x half> @llvm.log.v4f16(<4 x half>)
declare <4 x half> @llvm.log10.v4f16(<4 x half>)
declare <4 x half> @llvm.log2.v4f16(<4 x half>)
declare <7 x half> @llvm.exp.v7f16(<7 x half>)
declare <7 x half> @llvm.exp2.v7f16(<7 x half>)
declare <7 x half> @llvm.log.v7f16(<7 x half>)
declare <7 x half> @llvm.log10.v7f16(<7 x half>)
declare <7 x half> @llvm.log2.v7f16(<7 x half>)
declare <8 x float> @llvm.exp.v8f32(<8 x float>)
declare <8 x float> @llvm.exp2.v8f32(<8 x float>)
declare <8 x float> @llvm.log.v8f32(<8 x float>)
declare <8 x float> @llvm.log10.v8f32(<8 x float>)
declare <8 x float> @llvm.log2.v8f32(<8 x float>)
declare <8 x half> @llvm.exp.v8f16(<8 x half>)
declare <8 x half> @llvm.exp2.v8f16(<8 x half>)
declare <8 x half> @llvm.log.v8f16(<8 x half>)
declare <8 x half> @llvm.log10.v8f16(<8 x half>)
declare <8 x half> @llvm.log2.v8f16(<8 x half>)
declare double @llvm.exp.f64(double)
declare double @llvm.exp2.f64(double)
declare double @llvm.log.f64(double)
declare double @llvm.log10.f64(double)
declare double @llvm.log2.f64(double)
declare float @llvm.exp.f32(float)
declare float @llvm.exp2.f32(float)
declare float @llvm.log.f32(float)
declare float @llvm.log10.f32(float)
declare float @llvm.log2.f32(float)
declare half @llvm.exp.f16(half)
declare half @llvm.exp2.f16(half)
declare half @llvm.log.f16(half)
declare half @llvm.log10.f16(half)
declare half @llvm.log2.f16(half)
