; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Check that no freeze instruction gets inserted before landingpad in a basic block
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i32 @propagate_freeze_in_landingpad() personality ptr null {
; CHECK-LABEL: @propagate_freeze_in_landingpad(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[INVOKE_BB1:%.*]]
; CHECK:       invoke.bb1:
; CHECK-NEXT:    [[X:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[NORMAL_RETURN:%.*]] ]
; CHECK-NEXT:    [[RES0:%.*]] = invoke i32 @foo()
; CHECK-NEXT:    to label [[INVOKE_BB2:%.*]] unwind label [[EXCEPTIONAL_RETURN:%.*]]
; CHECK:       invoke.bb2:
; CHECK-NEXT:    [[RES1:%.*]] = invoke i32 @foo()
; CHECK-NEXT:    to label [[NORMAL_RETURN]] unwind label [[EXCEPTIONAL_RETURN]]
; CHECK:       normal_return:
; CHECK-NEXT:    [[INC]] = add nuw nsw i32 [[X]], 1
; CHECK-NEXT:    br label [[INVOKE_BB1]]
; CHECK:       exceptional_return:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ [[X]], [[INVOKE_BB1]] ], [ 0, [[INVOKE_BB2]] ]
; CHECK-NEXT:    [[LANDING_PAD:%.*]] = landingpad { ptr, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    [[FR:%.*]] = freeze i32 [[PHI]]
; CHECK-NEXT:    [[RES:%.*]] = shl i32 [[FR]], 1
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  br label %invoke.bb1

invoke.bb1:                                 ; preds = %normal_return, %entry
  %x = phi i32 [ 0, %entry ], [ %inc, %normal_return ]
  %res0 = invoke i32 @foo()
  to label %invoke.bb2 unwind label %exceptional_return

invoke.bb2:                                  ; preds = %invoke.bb1
  %res1 = invoke i32 @foo()
  to label %normal_return unwind label %exceptional_return

normal_return:                                ; preds = %invoke.bb2
  %inc = add nuw nsw i32 %x, 1
  br label %invoke.bb1

exceptional_return:                             ; preds = %invoke.bb2, %invoke.bb1
  %phi = phi i32 [ %x, %invoke.bb1 ], [ 0, %invoke.bb2 ]
  %landing_pad = landingpad { ptr, i32 }
  cleanup
  %fr = freeze i32 %phi
  %res = add i32 %fr, %phi
  ret i32 %res
}

declare i32 @foo()

