; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=jump-table-to-switch -verify-dom-info -S | FileCheck %s
; RUN: opt < %s -passes=jump-table-to-switch -jump-table-to-switch-size-threshold=0 -verify-dom-info -S | FileCheck %s --check-prefix=THRESHOLD-0

@func_array = constant [2 x ptr] [ptr @func0, ptr @func1]

define i32 @func0() {
  ret i32 1
}

define i32 @func1() {
  ret i32 2
}

define i32 @function_with_jump_table(i32 %index) {
; CHECK-LABEL: define i32 @function_with_jump_table(
; CHECK-SAME: i32 [[INDEX:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds [2 x ptr], ptr @func_array, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR:%.*]] = load ptr, ptr [[GEP]], align 8
; CHECK-NEXT:    switch i32 [[INDEX]], label [[DEFAULT_SWITCH_CASE_UNREACHABLE:%.*]] [
; CHECK-NEXT:      i32 0, label [[CALL_0:%.*]]
; CHECK-NEXT:      i32 1, label [[CALL_1:%.*]]
; CHECK-NEXT:    ]
; CHECK:       default.switch.case.unreachable:
; CHECK-NEXT:    unreachable
; CHECK:       call.0:
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @func0()
; CHECK-NEXT:    br label [[DOTTAIL:%.*]]
; CHECK:       call.1:
; CHECK-NEXT:    [[TMP2:%.*]] = call i32 @func1()
; CHECK-NEXT:    br label [[DOTTAIL]]
; CHECK:       .tail:
; CHECK-NEXT:    [[TMP3:%.*]] = phi i32 [ [[TMP1]], [[CALL_0]] ], [ [[TMP2]], [[CALL_1]] ]
; CHECK-NEXT:    ret i32 [[TMP3]]
;
; THRESHOLD-0-LABEL: define i32 @function_with_jump_table(
; THRESHOLD-0-SAME: i32 [[INDEX:%.*]]) {
; THRESHOLD-0-NEXT:    [[GEP:%.*]] = getelementptr inbounds [2 x ptr], ptr @func_array, i32 0, i32 [[INDEX]]
; THRESHOLD-0-NEXT:    [[FUNC_PTR:%.*]] = load ptr, ptr [[GEP]], align 8
; THRESHOLD-0-NEXT:    [[RESULT:%.*]] = call i32 [[FUNC_PTR]]()
; THRESHOLD-0-NEXT:    ret i32 [[RESULT]]
;
  %gep = getelementptr inbounds [2 x ptr], ptr @func_array, i32 0, i32 %index
  %func_ptr = load ptr, ptr %gep
  %result = call i32 %func_ptr()
  ret i32 %result
}

define i32 @basic_block_splitted_twice(i32 %index) {
; CHECK-LABEL: define i32 @basic_block_splitted_twice(
; CHECK-SAME: i32 [[INDEX:%.*]]) {
; CHECK-NEXT:    [[GEP1:%.*]] = getelementptr inbounds [2 x ptr], ptr @func_array, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR1:%.*]] = load ptr, ptr [[GEP1]], align 8
; CHECK-NEXT:    switch i32 [[INDEX]], label [[DEFAULT_SWITCH_CASE_UNREACHABLE:%.*]] [
; CHECK-NEXT:      i32 0, label [[CALL_0:%.*]]
; CHECK-NEXT:      i32 1, label [[CALL_1:%.*]]
; CHECK-NEXT:    ]
; CHECK:       default.switch.case.unreachable:
; CHECK-NEXT:    unreachable
; CHECK:       call.0:
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @func0()
; CHECK-NEXT:    br label [[DOTTAIL:%.*]]
; CHECK:       call.1:
; CHECK-NEXT:    [[TMP2:%.*]] = call i32 @func1()
; CHECK-NEXT:    br label [[DOTTAIL]]
; CHECK:       .tail:
; CHECK-NEXT:    [[TMP3:%.*]] = phi i32 [ [[TMP1]], [[CALL_0]] ], [ [[TMP2]], [[CALL_1]] ]
; CHECK-NEXT:    [[GEP2:%.*]] = getelementptr inbounds [2 x ptr], ptr @func_array, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR2:%.*]] = load ptr, ptr [[GEP2]], align 8
; CHECK-NEXT:    switch i32 [[INDEX]], label [[DEFAULT_SWITCH_CASE_UNREACHABLE1:%.*]] [
; CHECK-NEXT:      i32 0, label [[CALL_02:%.*]]
; CHECK-NEXT:      i32 1, label [[CALL_13:%.*]]
; CHECK-NEXT:    ]
; CHECK:       default.switch.case.unreachable1:
; CHECK-NEXT:    unreachable
; CHECK:       call.02:
; CHECK-NEXT:    [[TMP4:%.*]] = call i32 @func0()
; CHECK-NEXT:    br label [[DOTTAIL_TAIL:%.*]]
; CHECK:       call.13:
; CHECK-NEXT:    [[TMP5:%.*]] = call i32 @func1()
; CHECK-NEXT:    br label [[DOTTAIL_TAIL]]
; CHECK:       .tail.tail:
; CHECK-NEXT:    [[TMP6:%.*]] = phi i32 [ [[TMP4]], [[CALL_02]] ], [ [[TMP5]], [[CALL_13]] ]
; CHECK-NEXT:    [[RESULT:%.*]] = add i32 [[TMP3]], [[TMP6]]
; CHECK-NEXT:    ret i32 [[RESULT]]
;
; THRESHOLD-0-LABEL: define i32 @basic_block_splitted_twice(
; THRESHOLD-0-SAME: i32 [[INDEX:%.*]]) {
; THRESHOLD-0-NEXT:    [[GEP1:%.*]] = getelementptr inbounds [2 x ptr], ptr @func_array, i32 0, i32 [[INDEX]]
; THRESHOLD-0-NEXT:    [[FUNC_PTR1:%.*]] = load ptr, ptr [[GEP1]], align 8
; THRESHOLD-0-NEXT:    [[RESULT1:%.*]] = call i32 [[FUNC_PTR1]]()
; THRESHOLD-0-NEXT:    [[GEP2:%.*]] = getelementptr inbounds [2 x ptr], ptr @func_array, i32 0, i32 [[INDEX]]
; THRESHOLD-0-NEXT:    [[FUNC_PTR2:%.*]] = load ptr, ptr [[GEP2]], align 8
; THRESHOLD-0-NEXT:    [[RESULT2:%.*]] = call i32 [[FUNC_PTR2]]()
; THRESHOLD-0-NEXT:    [[RESULT:%.*]] = add i32 [[RESULT1]], [[RESULT2]]
; THRESHOLD-0-NEXT:    ret i32 [[RESULT]]
;
  %gep1 = getelementptr inbounds [2 x ptr], ptr @func_array, i32 0, i32 %index
  %func_ptr1 = load ptr, ptr %gep1
  %result1 = call i32 %func_ptr1()
  %gep2 = getelementptr inbounds [2 x ptr], ptr @func_array, i32 0, i32 %index
  %func_ptr2 = load ptr, ptr %gep2
  %result2 = call i32 %func_ptr2()
  %result = add i32 %result1, %result2
  ret i32 %result
}

define void @void_func0() {
  ret void
}

define void @void_func1() {
  ret void
}

@void_func_array = constant [2 x ptr] [ptr @void_func0, ptr @void_func1]

define void @void_function_with_jump_table(i32 %index) {
; CHECK-LABEL: define void @void_function_with_jump_table(
; CHECK-SAME: i32 [[INDEX:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds [2 x ptr], ptr @void_func_array, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR:%.*]] = load ptr, ptr [[GEP]], align 8
; CHECK-NEXT:    switch i32 [[INDEX]], label [[DEFAULT_SWITCH_CASE_UNREACHABLE:%.*]] [
; CHECK-NEXT:      i32 0, label [[CALL_0:%.*]]
; CHECK-NEXT:      i32 1, label [[CALL_1:%.*]]
; CHECK-NEXT:    ]
; CHECK:       default.switch.case.unreachable:
; CHECK-NEXT:    unreachable
; CHECK:       call.0:
; CHECK-NEXT:    call void @void_func0()
; CHECK-NEXT:    br label [[DOTTAIL:%.*]]
; CHECK:       call.1:
; CHECK-NEXT:    call void @void_func1()
; CHECK-NEXT:    br label [[DOTTAIL]]
; CHECK:       .tail:
; CHECK-NEXT:    ret void
;
; THRESHOLD-0-LABEL: define void @void_function_with_jump_table(
; THRESHOLD-0-SAME: i32 [[INDEX:%.*]]) {
; THRESHOLD-0-NEXT:    [[GEP:%.*]] = getelementptr inbounds [2 x ptr], ptr @void_func_array, i32 0, i32 [[INDEX]]
; THRESHOLD-0-NEXT:    [[FUNC_PTR:%.*]] = load ptr, ptr [[GEP]], align 8
; THRESHOLD-0-NEXT:    call void [[FUNC_PTR]]()
; THRESHOLD-0-NEXT:    ret void
;
  %gep = getelementptr inbounds [2 x ptr], ptr @void_func_array, i32 0, i32 %index
  %func_ptr = load ptr, ptr %gep
  call void %func_ptr()
  ret void
}

define void @void_function_with_jump_table_and_call_site_attr(i32 %index) {
; CHECK-LABEL: define void @void_function_with_jump_table_and_call_site_attr(
; CHECK-SAME: i32 [[INDEX:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds [2 x ptr], ptr @void_func_array, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR:%.*]] = load ptr, ptr [[GEP]], align 8
; CHECK-NEXT:    switch i32 [[INDEX]], label [[DEFAULT_SWITCH_CASE_UNREACHABLE:%.*]] [
; CHECK-NEXT:      i32 0, label [[CALL_0:%.*]]
; CHECK-NEXT:      i32 1, label [[CALL_1:%.*]]
; CHECK-NEXT:    ]
; CHECK:       default.switch.case.unreachable:
; CHECK-NEXT:    unreachable
; CHECK:       call.0:
; CHECK-NEXT:    call void @void_func0() #[[ATTR0:[0-9]+]]
; CHECK-NEXT:    br label [[DOTTAIL:%.*]]
; CHECK:       call.1:
; CHECK-NEXT:    call void @void_func1() #[[ATTR0]]
; CHECK-NEXT:    br label [[DOTTAIL]]
; CHECK:       .tail:
; CHECK-NEXT:    ret void
;
; THRESHOLD-0-LABEL: define void @void_function_with_jump_table_and_call_site_attr(
; THRESHOLD-0-SAME: i32 [[INDEX:%.*]]) {
; THRESHOLD-0-NEXT:    [[GEP:%.*]] = getelementptr inbounds [2 x ptr], ptr @void_func_array, i32 0, i32 [[INDEX]]
; THRESHOLD-0-NEXT:    [[FUNC_PTR:%.*]] = load ptr, ptr [[GEP]], align 8
; THRESHOLD-0-NEXT:    call void [[FUNC_PTR]]() #[[ATTR0:[0-9]+]]
; THRESHOLD-0-NEXT:    ret void
;
  %gep = getelementptr inbounds [2 x ptr], ptr @void_func_array, i32 0, i32 %index
  %func_ptr = load ptr, ptr %gep
  call void %func_ptr() nounwind
  ret void
}


define i32 @func0_addrspace_42() addrspace(42) {
  ret i32 1
}

define i32 @func1_addrspace_42() addrspace(42) {
  ret i32 2
}

@func_array_addrspace_42 = addrspace(42) constant [2 x ptr addrspace(42)] [ptr addrspace(42) @func0_addrspace_42, ptr addrspace(42) @func1_addrspace_42]

define i32 @function_with_jump_table_addrspace_42(i32 %index) addrspace(42) {
; CHECK-LABEL: define i32 @function_with_jump_table_addrspace_42(
; CHECK-SAME: i32 [[INDEX:%.*]]) addrspace(42) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds [2 x ptr addrspace(42)], ptr addrspace(42) @func_array_addrspace_42, i32 0, i32 [[INDEX]]
; CHECK-NEXT:    [[FUNC_PTR:%.*]] = load ptr addrspace(42), ptr addrspace(42) [[GEP]], align 8
; CHECK-NEXT:    switch i32 [[INDEX]], label [[DEFAULT_SWITCH_CASE_UNREACHABLE:%.*]] [
; CHECK-NEXT:      i32 0, label [[CALL_0:%.*]]
; CHECK-NEXT:      i32 1, label [[CALL_1:%.*]]
; CHECK-NEXT:    ]
; CHECK:       default.switch.case.unreachable:
; CHECK-NEXT:    unreachable
; CHECK:       call.0:
; CHECK-NEXT:    [[TMP1:%.*]] = call addrspace(42) i32 @func0_addrspace_42()
; CHECK-NEXT:    br label [[DOTTAIL:%.*]]
; CHECK:       call.1:
; CHECK-NEXT:    [[TMP2:%.*]] = call addrspace(42) i32 @func1_addrspace_42()
; CHECK-NEXT:    br label [[DOTTAIL]]
; CHECK:       .tail:
; CHECK-NEXT:    [[TMP3:%.*]] = phi i32 [ [[TMP1]], [[CALL_0]] ], [ [[TMP2]], [[CALL_1]] ]
; CHECK-NEXT:    ret i32 [[TMP3]]
;
; THRESHOLD-0-LABEL: define i32 @function_with_jump_table_addrspace_42(
; THRESHOLD-0-SAME: i32 [[INDEX:%.*]]) addrspace(42) {
; THRESHOLD-0-NEXT:    [[GEP:%.*]] = getelementptr inbounds [2 x ptr addrspace(42)], ptr addrspace(42) @func_array_addrspace_42, i32 0, i32 [[INDEX]]
; THRESHOLD-0-NEXT:    [[FUNC_PTR:%.*]] = load ptr addrspace(42), ptr addrspace(42) [[GEP]], align 8
; THRESHOLD-0-NEXT:    [[RESULT:%.*]] = call addrspace(42) i32 [[FUNC_PTR]]()
; THRESHOLD-0-NEXT:    ret i32 [[RESULT]]
;
  %gep = getelementptr inbounds [2 x ptr addrspace(42)], ptr addrspace(42) @func_array_addrspace_42, i32 0, i32 %index
  %func_ptr = load ptr addrspace(42), ptr addrspace(42) %gep, align 8
  %result = call addrspace(42) i32 %func_ptr()
  ret i32 %result
}

