; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use(i32)
declare i32 @llvm.abs.i32(i32, i1)
declare <4 x i32> @llvm.abs.v4i32(<4 x i32>, i1)

define i32 @test_sdiv_canonicalize_op0(i32 %x, i32 %y) {
; CHECK-LABEL: @test_sdiv_canonicalize_op0(
; CHECK-NEXT:    [[SDIV1:%.*]] = sdiv i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SDIV:%.*]] = sub nsw i32 0, [[SDIV1]]
; CHECK-NEXT:    ret i32 [[SDIV]]
;
  %neg = sub nsw i32 0, %x
  %sdiv = sdiv i32 %neg, %y
  ret i32 %sdiv
}

define i32 @test_sdiv_canonicalize_op0_exact(i32 %x, i32 %y) {
; CHECK-LABEL: @test_sdiv_canonicalize_op0_exact(
; CHECK-NEXT:    [[SDIV1:%.*]] = sdiv exact i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SDIV:%.*]] = sub nsw i32 0, [[SDIV1]]
; CHECK-NEXT:    ret i32 [[SDIV]]
;
  %neg = sub nsw i32 0, %x
  %sdiv = sdiv exact i32 %neg, %y
  ret i32 %sdiv
}

; (X/-Y) is not equal to -(X/Y), don't canonicalize.
define i32 @test_sdiv_canonicalize_op1(i32 %x, i32 %z) {
; CHECK-LABEL: @test_sdiv_canonicalize_op1(
; CHECK-NEXT:    [[Y:%.*]] = mul i32 [[Z:%.*]], 3
; CHECK-NEXT:    [[NEG:%.*]] = sub nsw i32 0, [[X:%.*]]
; CHECK-NEXT:    [[SDIV:%.*]] = sdiv i32 [[Y]], [[NEG]]
; CHECK-NEXT:    ret i32 [[SDIV]]
;
  %y = mul i32 %z, 3
  %neg = sub nsw i32 0, %x
  %sdiv = sdiv i32 %y, %neg
  ret i32 %sdiv
}

define i32 @test_sdiv_canonicalize_nonsw(i32 %x, i32 %y) {
; CHECK-LABEL: @test_sdiv_canonicalize_nonsw(
; CHECK-NEXT:    [[NEG:%.*]] = sub i32 0, [[X:%.*]]
; CHECK-NEXT:    [[SDIV:%.*]] = sdiv i32 [[NEG]], [[Y:%.*]]
; CHECK-NEXT:    ret i32 [[SDIV]]
;
  %neg = sub i32 0, %x
  %sdiv = sdiv i32 %neg, %y
  ret i32 %sdiv
}

define <2 x i32> @test_sdiv_canonicalize_vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @test_sdiv_canonicalize_vec(
; CHECK-NEXT:    [[SDIV1:%.*]] = sdiv <2 x i32> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SDIV:%.*]] = sub nsw <2 x i32> zeroinitializer, [[SDIV1]]
; CHECK-NEXT:    ret <2 x i32> [[SDIV]]
;
  %neg = sub nsw <2 x i32> <i32 0, i32 0>, %x
  %sdiv = sdiv <2 x i32> %neg, %y
  ret <2 x i32> %sdiv
}

define i32 @test_sdiv_canonicalize_multiple_uses(i32 %x, i32 %y) {
; CHECK-LABEL: @test_sdiv_canonicalize_multiple_uses(
; CHECK-NEXT:    [[NEG:%.*]] = sub nsw i32 0, [[X:%.*]]
; CHECK-NEXT:    [[SDIV:%.*]] = sdiv i32 [[NEG]], [[Y:%.*]]
; CHECK-NEXT:    [[SDIV2:%.*]] = sdiv i32 [[SDIV]], [[NEG]]
; CHECK-NEXT:    ret i32 [[SDIV2]]
;
  %neg = sub nsw i32 0, %x
  %sdiv = sdiv i32 %neg, %y
  %sdiv2 = sdiv i32 %sdiv, %neg
  ret i32 %sdiv2
}

; There is combination: -(X/CE) -> (X/-CE).
; If combines (X/-CE) to -(X/CE), make sure don't combine them endless.

@X = global i32 5

define i64 @test_sdiv_canonicalize_constexpr(i64 %L1) {
; currently opt folds (sub nsw i64 0, constexpr) -> (sub i64, 0, constexpr).
; sdiv canonicalize requires a nsw sub.
; CHECK-LABEL: @test_sdiv_canonicalize_constexpr(
; CHECK-NEXT:    [[B4:%.*]] = sdiv i64 [[L1:%.*]], sub (i64 0, i64 ptrtoint (ptr @X to i64))
; CHECK-NEXT:    ret i64 [[B4]]
;
  %v1 = ptrtoint ptr @X to i64
  %B8 = sub nsw i64 0, %v1
  %B4 = sdiv i64 %L1, %B8
  ret i64 %B4
}

define i32 @sdiv_abs_nsw(i32 %x) {
; CHECK-LABEL: @sdiv_abs_nsw(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[X:%.*]], -1
; CHECK-NEXT:    [[R:%.*]] = select i1 [[TMP1]], i32 1, i32 -1
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = call i32 @llvm.abs.i32(i32 %x, i1 true)
  %r = sdiv i32 %a, %x
  ret i32 %r
}

define <4 x i32> @sdiv_abs_nsw_vec(<4 x i32> %x) {
; CHECK-LABEL: @sdiv_abs_nsw_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt <4 x i32> [[X:%.*]], <i32 -1, i32 -1, i32 -1, i32 -1>
; CHECK-NEXT:    [[R:%.*]] = select <4 x i1> [[TMP1]], <4 x i32> <i32 1, i32 1, i32 1, i32 1>, <4 x i32> <i32 -1, i32 -1, i32 -1, i32 -1>
; CHECK-NEXT:    ret <4 x i32> [[R]]
;
  %a = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %x, i1 true)
  %r = sdiv <4 x i32> %x, %a
  ret <4 x i32> %r
}

; Negative test - requires poison int min (nsw)

define i32 @sdiv_abs(i32 %x) {
; CHECK-LABEL: @sdiv_abs(
; CHECK-NEXT:    [[A:%.*]] = call i32 @llvm.abs.i32(i32 [[X:%.*]], i1 false)
; CHECK-NEXT:    [[R:%.*]] = sdiv i32 [[A]], [[X]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = call i32 @llvm.abs.i32(i32 %x, i1 false)
  %r = sdiv i32 %a, %x
  ret i32 %r
}

; Negative test

define i32 @sdiv_abs_extra_use(i32 %x) {
; CHECK-LABEL: @sdiv_abs_extra_use(
; CHECK-NEXT:    [[A:%.*]] = call i32 @llvm.abs.i32(i32 [[X:%.*]], i1 true)
; CHECK-NEXT:    call void @use(i32 [[A]])
; CHECK-NEXT:    [[R:%.*]] = sdiv i32 [[A]], [[X]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = call i32 @llvm.abs.i32(i32 %x, i1 true)
  call void @use(i32 %a)
  %r = sdiv i32 %a, %x
  ret i32 %r
}
