; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT

declare float @llvm.ldexp.f32.i32(float, i32)
declare float @llvm.ldexp.f32.i64(float, i64)
declare <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float>, <2 x i32>)
declare double @llvm.ldexp.f64.i32(double, i32)
declare half @llvm.ldexp.f16.i32(half, i32)
declare bfloat @llvm.ldexp.bf16.i32(bfloat, i32)
declare i32 @llvm.smin.i32(i32, i32)

define float @ret_ldexp_f32(float %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32
; CHECK-SAME: (float [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float [[ARG0]], i32 [[ARG1]]) #[[ATTR10:[0-9]+]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_0(float %arg0) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_0
; CHECK-SAME: (float [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub(float nofpclass(psub) %arg0) #0 {
; CHECK-LABEL: define nofpclass(psub) float @ret_ldexp_f32_0_nopsub
; CHECK-SAME: (float nofpclass(psub) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(psub) float @llvm.ldexp.f32.i32(float nofpclass(psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nonsub(float nofpclass(nsub) %arg0) #0 {
; CHECK-LABEL: define nofpclass(nsub) float @ret_ldexp_f32_0_nonsub
; CHECK-SAME: (float nofpclass(nsub) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nsub) float @llvm.ldexp.f32.i32(float nofpclass(nsub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nosub(float nofpclass(sub) %arg0) #0 {
; CHECK-LABEL: define nofpclass(sub) float @ret_ldexp_f32_0_nosub
; CHECK-SAME: (float nofpclass(sub) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(sub) float @llvm.ldexp.f32.i32(float nofpclass(sub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nosub_nosnan(float nofpclass(sub snan) %arg0) #0 {
; CHECK-LABEL: define nofpclass(snan sub) float @ret_ldexp_f32_0_nosub_nosnan
; CHECK-SAME: (float nofpclass(snan sub) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan sub) float @llvm.ldexp.f32.i32(float nofpclass(snan sub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_nopzero(float nofpclass(psub pzero) %arg0) #0 {
; CHECK-LABEL: define nofpclass(pzero psub) float @ret_ldexp_f32_0_nopsub_nopzero
; CHECK-SAME: (float nofpclass(pzero psub) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pzero psub) float @llvm.ldexp.f32.i32(float nofpclass(pzero psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nonsub_nonzero(float nofpclass(nsub nzero) %arg0) #0 {
; CHECK-LABEL: define nofpclass(nzero nsub) float @ret_ldexp_f32_0_nonsub_nonzero
; CHECK-SAME: (float nofpclass(nzero nsub) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nzero nsub) float @llvm.ldexp.f32.i32(float nofpclass(nzero nsub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nosub_nozero(float nofpclass(sub zero) %arg0) #0 {
; CHECK-LABEL: define nofpclass(zero sub) float @ret_ldexp_f32_0_nosub_nozero
; CHECK-SAME: (float nofpclass(zero sub) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(zero sub) float @llvm.ldexp.f32.i32(float nofpclass(zero sub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_daz(float nofpclass(psub) %arg0) #1 {
; CHECK-LABEL: define nofpclass(psub) float @ret_ldexp_f32_0_nopsub_daz
; CHECK-SAME: (float nofpclass(psub) [[ARG0:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(psub) float @llvm.ldexp.f32.i32(float nofpclass(psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nonsub_daz(float nofpclass(nsub) %arg0) #1 {
; CHECK-LABEL: define nofpclass(nsub) float @ret_ldexp_f32_0_nonsub_daz
; CHECK-SAME: (float nofpclass(nsub) [[ARG0:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nsub) float @llvm.ldexp.f32.i32(float nofpclass(nsub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nosub_daz(float nofpclass(sub) %arg0) #1 {
; CHECK-LABEL: define nofpclass(sub) float @ret_ldexp_f32_0_nosub_daz
; CHECK-SAME: (float nofpclass(sub) [[ARG0:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(sub) float @llvm.ldexp.f32.i32(float nofpclass(sub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nosub_nosnan_daz(float nofpclass(sub snan) %arg0) #1 {
; CHECK-LABEL: define nofpclass(snan sub) float @ret_ldexp_f32_0_nosub_nosnan_daz
; CHECK-SAME: (float nofpclass(snan sub) [[ARG0:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan sub) float @llvm.ldexp.f32.i32(float nofpclass(snan sub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_nozero_daz(float nofpclass(psub pzero) %arg0) #1 {
; CHECK-LABEL: define nofpclass(pzero psub) float @ret_ldexp_f32_0_nopsub_nozero_daz
; CHECK-SAME: (float nofpclass(pzero psub) [[ARG0:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pzero psub) float @llvm.ldexp.f32.i32(float nofpclass(pzero psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nonsub_nonzero_daz(float nofpclass(nsub nzero) %arg0) #1 {
; CHECK-LABEL: define nofpclass(nzero nsub) float @ret_ldexp_f32_0_nonsub_nonzero_daz
; CHECK-SAME: (float nofpclass(nzero nsub) [[ARG0:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nzero nsub) float @llvm.ldexp.f32.i32(float nofpclass(nzero nsub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nosub_nozero_daz(float nofpclass(sub zero) %arg0) #1 {
; CHECK-LABEL: define nofpclass(zero sub) float @ret_ldexp_f32_0_nosub_nozero_daz
; CHECK-SAME: (float nofpclass(zero sub) [[ARG0:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(zero sub) float @llvm.ldexp.f32.i32(float nofpclass(zero sub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_dapz(float nofpclass(psub) %arg0) #2 {
; CHECK-LABEL: define nofpclass(psub) float @ret_ldexp_f32_0_nopsub_dapz
; CHECK-SAME: (float nofpclass(psub) [[ARG0:%.*]]) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(psub) float @llvm.ldexp.f32.i32(float nofpclass(psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nonsub_dapz(float nofpclass(nsub) %arg0) #2 {
; CHECK-LABEL: define nofpclass(nsub) float @ret_ldexp_f32_0_nonsub_dapz
; CHECK-SAME: (float nofpclass(nsub) [[ARG0:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nsub) float @llvm.ldexp.f32.i32(float nofpclass(nsub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nosub_dapz(float nofpclass(sub) %arg0) #2 {
; CHECK-LABEL: define nofpclass(sub) float @ret_ldexp_f32_0_nosub_dapz
; CHECK-SAME: (float nofpclass(sub) [[ARG0:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(sub) float @llvm.ldexp.f32.i32(float nofpclass(sub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_nozero_dapz(float nofpclass(psub zero) %arg0) #2 {
; CHECK-LABEL: define nofpclass(nzero psub) float @ret_ldexp_f32_0_nopsub_nozero_dapz
; CHECK-SAME: (float nofpclass(zero psub) [[ARG0:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nzero psub) float @llvm.ldexp.f32.i32(float nofpclass(zero psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nonsub_nonzero_dapz(float nofpclass(nsub nzero) %arg0) #2 {
; CHECK-LABEL: define nofpclass(nzero nsub) float @ret_ldexp_f32_0_nonsub_nonzero_dapz
; CHECK-SAME: (float nofpclass(nzero nsub) [[ARG0:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nzero nsub) float @llvm.ldexp.f32.i32(float nofpclass(nzero nsub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nosub_nozero_dapz(float nofpclass(sub zero) %arg0) #2 {
; CHECK-LABEL: define nofpclass(zero sub) float @ret_ldexp_f32_0_nosub_nozero_dapz
; CHECK-SAME: (float nofpclass(zero sub) [[ARG0:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(zero sub) float @llvm.ldexp.f32.i32(float nofpclass(zero sub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_nozero_dapz_dapz(float nofpclass(psub zero) %arg0) #2 {
; CHECK-LABEL: define nofpclass(nzero psub) float @ret_ldexp_f32_0_nopsub_nozero_dapz_dapz
; CHECK-SAME: (float nofpclass(zero psub) [[ARG0:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nzero psub) float @llvm.ldexp.f32.i32(float nofpclass(zero psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_nozero_daz_ieee(float nofpclass(psub zero) %arg0) #3 {
; CHECK-LABEL: define nofpclass(pzero psub) float @ret_ldexp_f32_0_nopsub_nozero_daz_ieee
; CHECK-SAME: (float nofpclass(zero psub) [[ARG0:%.*]]) #[[ATTR4:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pzero psub) float @llvm.ldexp.f32.i32(float nofpclass(zero psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_nozero_daz_dynamic(float nofpclass(psub zero) %arg0) #4 {
; CHECK-LABEL: define nofpclass(psub) float @ret_ldexp_f32_0_nopsub_nozero_daz_dynamic
; CHECK-SAME: (float nofpclass(zero psub) [[ARG0:%.*]]) #[[ATTR5:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(psub) float @llvm.ldexp.f32.i32(float nofpclass(zero psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_nozero_ieee_daz(float nofpclass(psub zero) %arg0) #5 {
; CHECK-LABEL: define nofpclass(pzero psub) float @ret_ldexp_f32_0_nopsub_nozero_ieee_daz
; CHECK-SAME: (float nofpclass(zero psub) [[ARG0:%.*]]) #[[ATTR6:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pzero psub) float @llvm.ldexp.f32.i32(float nofpclass(zero psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_nozero_dynamic_daz(float nofpclass(psub zero) %arg0) #6 {
; CHECK-LABEL: define nofpclass(psub) float @ret_ldexp_f32_0_nopsub_nozero_dynamic_daz
; CHECK-SAME: (float nofpclass(zero psub) [[ARG0:%.*]]) #[[ATTR7:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(psub) float @llvm.ldexp.f32.i32(float nofpclass(zero psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_nozero_dynamic_dapz(float nofpclass(psub zero) %arg0) #7 {
; CHECK-LABEL: define nofpclass(psub) float @ret_ldexp_f32_0_nopsub_nozero_dynamic_dapz
; CHECK-SAME: (float nofpclass(zero psub) [[ARG0:%.*]]) #[[ATTR8:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(psub) float @llvm.ldexp.f32.i32(float nofpclass(zero psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopsub_nozero_dapz_dynamic(float nofpclass(psub zero) %arg0) #8 {
; CHECK-LABEL: define nofpclass(psub) float @ret_ldexp_f32_0_nopsub_nozero_dapz_dynamic
; CHECK-SAME: (float nofpclass(zero psub) [[ARG0:%.*]]) #[[ATTR9:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(psub) float @llvm.ldexp.f32.i32(float nofpclass(zero psub) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopnorm(float nofpclass(pnorm) %arg0) #0 {
; CHECK-LABEL: define nofpclass(pnorm) float @ret_ldexp_f32_0_nopnorm
; CHECK-SAME: (float nofpclass(pnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pnorm) float @llvm.ldexp.f32.i32(float nofpclass(pnorm) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nnorm(float nofpclass(nnorm) %arg0) #0 {
; CHECK-LABEL: define nofpclass(nnorm) float @ret_ldexp_f32_0_nnorm
; CHECK-SAME: (float nofpclass(nnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nnorm) float @llvm.ldexp.f32.i32(float nofpclass(nnorm) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define float @ret_ldexp_f32_0_nopnorm_nonsub(float nofpclass(pnorm nsub) %arg0) #0 {
; CHECK-LABEL: define nofpclass(nsub pnorm) float @ret_ldexp_f32_0_nopnorm_nonsub
; CHECK-SAME: (float nofpclass(nsub pnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nsub pnorm) float @llvm.ldexp.f32.i32(float nofpclass(nsub pnorm) [[ARG0]], i32 noundef 0) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 0)
  ret float %call
}

define <2 x float> @ret_ldexp_v2f32_0(<2 x float> %arg0) #0 {
; CHECK-LABEL: define <2 x float> @ret_ldexp_v2f32_0
; CHECK-SAME: (<2 x float> [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> [[ARG0]], <2 x i32> <i32 undef, i32 0>) #[[ATTR10]]
; CHECK-NEXT:    ret <2 x float> [[CALL]]
;
  %call = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> %arg0, <2 x i32> <i32 undef, i32 0>)
  ret <2 x float> %call
}

define float @ret_ldexp_f32_i64(float %arg0, i64 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_i64
; CHECK-SAME: (float [[ARG0:%.*]], i64 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i64(float [[ARG0]], i64 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i64(float %arg0, i64 %arg1)
  ret float %call
}

define <2 x float> @ret_ldexp_v2f32(<2 x float> %arg0, <2 x i32> %arg1) #0 {
; CHECK-LABEL: define <2 x float> @ret_ldexp_v2f32
; CHECK-SAME: (<2 x float> [[ARG0:%.*]], <2 x i32> [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> [[ARG0]], <2 x i32> [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret <2 x float> [[CALL]]
;
  %call = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> %arg0, <2 x i32> %arg1)
  ret <2 x float> %call
}

define float @ret_ldexp_f32_nonan(float nofpclass(nan) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(nan) float @ret_ldexp_f32_nonan
; CHECK-SAME: (float nofpclass(nan) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nan) float @llvm.ldexp.f32.i32(float nofpclass(nan) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_nosnan(float nofpclass(snan) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(snan) float @ret_ldexp_f32_nosnan
; CHECK-SAME: (float nofpclass(snan) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan) float @llvm.ldexp.f32.i32(float nofpclass(snan) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noqnan(float nofpclass(qnan) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_noqnan
; CHECK-SAME: (float nofpclass(qnan) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(qnan) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noneg(float nofpclass(ninf nsub nnorm) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(ninf nsub nnorm) float @ret_ldexp_f32_noneg
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(ninf nsub nnorm) float @llvm.ldexp.f32.i32(float nofpclass(ninf nsub nnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noneg_nonzero(float nofpclass(ninf nsub nnorm nzero) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(ninf nzero nsub nnorm) float @ret_ldexp_f32_noneg_nonzero
; CHECK-SAME: (float nofpclass(ninf nzero nsub nnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(ninf nzero nsub nnorm) float @llvm.ldexp.f32.i32(float nofpclass(ninf nzero nsub nnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noneg_nozero(float nofpclass(ninf nsub nnorm) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(ninf nsub nnorm) float @ret_ldexp_f32_noneg_nozero
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(ninf nsub nnorm) float @llvm.ldexp.f32.i32(float nofpclass(ninf nsub nnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_nonzero(float nofpclass(nzero) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_nonzero
; CHECK-SAME: (float nofpclass(nzero) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(nzero) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_nopzero(float nofpclass(pzero) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_nopzero
; CHECK-SAME: (float nofpclass(pzero) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(pzero) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noneg_ftz_daz(float nofpclass(ninf nsub nnorm) %arg0, i32 %arg1) #1 {
; CHECK-LABEL: define nofpclass(ninf nsub nnorm) float @ret_ldexp_f32_noneg_ftz_daz
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(ninf nsub nnorm) float @llvm.ldexp.f32.i32(float nofpclass(ninf nsub nnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noneg_nonzero_ftz_daz(float nofpclass(ninf nsub nnorm nzero) %arg0, i32 %arg1) #1 {
; CHECK-LABEL: define nofpclass(ninf nzero nsub nnorm) float @ret_ldexp_f32_noneg_nonzero_ftz_daz
; CHECK-SAME: (float nofpclass(ninf nzero nsub nnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(ninf nzero nsub nnorm) float @llvm.ldexp.f32.i32(float nofpclass(ninf nzero nsub nnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noneg_nonzero_ftpz_dapz(float nofpclass(ninf nsub nnorm nzero) %arg0, i32 %arg1) #2 {
; CHECK-LABEL: define nofpclass(ninf nzero nsub nnorm) float @ret_ldexp_f32_noneg_nonzero_ftpz_dapz
; CHECK-SAME: (float nofpclass(ninf nzero nsub nnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(ninf nzero nsub nnorm) float @llvm.ldexp.f32.i32(float nofpclass(ninf nzero nsub nnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noninf_nonnorm(float nofpclass(ninf nnorm) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_noninf_nonnorm
; CHECK-SAME: (float nofpclass(ninf nnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(ninf nnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noninf_nonnorm_ftz_daz(float nofpclass(ninf nnorm) %arg0, i32 %arg1) #1 {
; CHECK-LABEL: define float @ret_ldexp_f32_noninf_nonnorm_ftz_daz
; CHECK-SAME: (float nofpclass(ninf nnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(ninf nnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noneg_ftz_ieee(float nofpclass(ninf nsub nnorm) %arg0, i32 %arg1) #3 {
; CHECK-LABEL: define nofpclass(ninf nsub nnorm) float @ret_ldexp_f32_noneg_ftz_ieee
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR4]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(ninf nsub nnorm) float @llvm.ldexp.f32.i32(float nofpclass(ninf nsub nnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noneg_nonzero_ftz_ieee(float nofpclass(ninf nsub nnorm nzero) %arg0, i32 %arg1) #3 {
; CHECK-LABEL: define nofpclass(ninf nzero nsub nnorm) float @ret_ldexp_f32_noneg_nonzero_ftz_ieee
; CHECK-SAME: (float nofpclass(ninf nzero nsub nnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR4]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(ninf nzero nsub nnorm) float @llvm.ldexp.f32.i32(float nofpclass(ninf nzero nsub nnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_nopos(float nofpclass(pinf psub pnorm) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(pinf psub pnorm) float @ret_ldexp_f32_nopos
; CHECK-SAME: (float nofpclass(pinf psub pnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf psub pnorm) float @llvm.ldexp.f32.i32(float nofpclass(pinf psub pnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_nopos_nopzero(float nofpclass(pinf psub pnorm pzero) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(pinf pzero psub pnorm) float @ret_ldexp_f32_nopos_nopzero
; CHECK-SAME: (float nofpclass(pinf pzero psub pnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf pzero psub pnorm) float @llvm.ldexp.f32.i32(float nofpclass(pinf pzero psub pnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_nopos_nozero(float nofpclass(pinf psub pnorm zero) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(pinf pzero psub pnorm) float @ret_ldexp_f32_nopos_nozero
; CHECK-SAME: (float nofpclass(pinf zero psub pnorm) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf pzero psub pnorm) float @llvm.ldexp.f32.i32(float nofpclass(pinf zero psub pnorm) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_nozero(float nofpclass(zero) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_nozero
; CHECK-SAME: (float nofpclass(zero) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(zero) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noinf(float nofpclass(inf) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_noinf
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(inf) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_noinf_nonan(float nofpclass(inf nan) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(nan) float @ret_ldexp_f32_noinf_nonan
; CHECK-SAME: (float nofpclass(nan inf) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nan) float @llvm.ldexp.f32.i32(float nofpclass(nan inf) [[ARG0]], i32 [[ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_pos_exp(float %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_known_pos_exp
; CHECK-SAME: (float [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[AND_ARG1:%.*]] = and i32 [[ARG1]], 127
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float [[ARG0]], i32 [[AND_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %and.arg1 = and i32 %arg1, 127
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %and.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_neg_exp(float %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_known_neg_exp
; CHECK-SAME: (float [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[OR_ARG1:%.*]] = or i32 [[ARG1]], -16
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float [[ARG0]], i32 [[OR_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %or.arg1 = or i32 %arg1, -16
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %or.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_pos_exp_nosub(float nofpclass(sub) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(sub) float @ret_ldexp_f32_known_pos_exp_nosub
; CHECK-SAME: (float nofpclass(sub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[AND_ARG1:%.*]] = and i32 [[ARG1]], 127
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(sub) float @llvm.ldexp.f32.i32(float nofpclass(sub) [[ARG0]], i32 [[AND_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %and.arg1 = and i32 %arg1, 127
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %and.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_neg_exp_nosub(float nofpclass(sub) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_known_neg_exp_nosub
; CHECK-SAME: (float nofpclass(sub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[OR_ARG1:%.*]] = or i32 [[ARG1]], -16
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(sub) [[ARG0]], i32 [[OR_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %or.arg1 = or i32 %arg1, -16
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %or.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_pos_exp_nopsub(float nofpclass(psub) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(psub) float @ret_ldexp_f32_known_pos_exp_nopsub
; CHECK-SAME: (float nofpclass(psub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[AND_ARG1:%.*]] = and i32 [[ARG1]], 127
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(psub) float @llvm.ldexp.f32.i32(float nofpclass(psub) [[ARG0]], i32 [[AND_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %and.arg1 = and i32 %arg1, 127
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %and.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_neg_exp_nopsub(float nofpclass(psub) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_known_neg_exp_nopsub
; CHECK-SAME: (float nofpclass(psub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[OR_ARG1:%.*]] = or i32 [[ARG1]], -16
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(psub) [[ARG0]], i32 [[OR_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %or.arg1 = or i32 %arg1, -16
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %or.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_pos_exp_nonsub(float nofpclass(nsub) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(nsub) float @ret_ldexp_f32_known_pos_exp_nonsub
; CHECK-SAME: (float nofpclass(nsub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[AND_ARG1:%.*]] = and i32 [[ARG1]], 127
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nsub) float @llvm.ldexp.f32.i32(float nofpclass(nsub) [[ARG0]], i32 [[AND_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %and.arg1 = and i32 %arg1, 127
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %and.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_neg_exp_nonsub(float nofpclass(nsub) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_known_neg_exp_nonsub
; CHECK-SAME: (float nofpclass(nsub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[OR_ARG1:%.*]] = or i32 [[ARG1]], -16
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(nsub) [[ARG0]], i32 [[OR_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %or.arg1 = or i32 %arg1, -16
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %or.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_pos_exp_noinf(float nofpclass(inf) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_known_pos_exp_noinf
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[AND_ARG1:%.*]] = and i32 [[ARG1]], 127
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(inf) [[ARG0]], i32 [[AND_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %and.arg1 = and i32 %arg1, 127
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %and.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_neg_exp_noinf(float nofpclass(inf) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(inf) float @ret_ldexp_f32_known_neg_exp_noinf
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[OR_ARG1:%.*]] = or i32 [[ARG1]], -16
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(inf) float @llvm.ldexp.f32.i32(float nofpclass(inf) [[ARG0]], i32 [[OR_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %or.arg1 = or i32 %arg1, -16
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %or.arg1)
  ret float %call
}

define <2 x float> @ret_ldexp_v2f32_known_pos_exp_noinf(<2 x float> nofpclass(inf) %arg0, <2 x i32> %arg1) #0 {
; CHECK-LABEL: define <2 x float> @ret_ldexp_v2f32_known_pos_exp_noinf
; CHECK-SAME: (<2 x float> nofpclass(inf) [[ARG0:%.*]], <2 x i32> [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[AND_ARG1:%.*]] = and <2 x i32> [[ARG1]], <i32 127, i32 64>
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> nofpclass(inf) [[ARG0]], <2 x i32> [[AND_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret <2 x float> [[CALL]]
;
  %and.arg1 = and <2 x i32> %arg1, <i32 127, i32 64>
  %call = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> %arg0, <2 x i32> %and.arg1)
  ret <2 x float> %call
}

define <2 x float> @ret_ldexp_v2f32_known_neg_exp_noinf(<2 x float> nofpclass(inf) %arg0, <2 x i32> %arg1) #0 {
; CHECK-LABEL: define <2 x float> @ret_ldexp_v2f32_known_neg_exp_noinf
; CHECK-SAME: (<2 x float> nofpclass(inf) [[ARG0:%.*]], <2 x i32> [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[OR_ARG1:%.*]] = or <2 x i32> [[ARG1]], <i32 -16, i32 -32>
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> nofpclass(inf) [[ARG0]], <2 x i32> [[OR_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret <2 x float> [[CALL]]
;
  %or.arg1 = or <2 x i32> %arg1, <i32 -16, i32 -32>
  %call = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> %arg0, <2 x i32> %or.arg1)
  ret <2 x float> %call
}

define float @ret_ldexp_f32_known_pos_exp_nopinf(float nofpclass(pinf) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_known_pos_exp_nopinf
; CHECK-SAME: (float nofpclass(pinf) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[AND_ARG1:%.*]] = and i32 [[ARG1]], 127
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(pinf) [[ARG0]], i32 [[AND_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %and.arg1 = and i32 %arg1, 127
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %and.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_neg_exp_nopinf(float nofpclass(pinf) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_ldexp_f32_known_neg_exp_nopinf
; CHECK-SAME: (float nofpclass(pinf) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[OR_ARG1:%.*]] = or i32 [[ARG1]], -16
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.ldexp.f32.i32(float nofpclass(pinf) [[ARG0]], i32 [[OR_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %or.arg1 = or i32 %arg1, -16
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %or.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_pos_exp_noninf(float nofpclass(ninf) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_known_pos_exp_noninf
; CHECK-SAME: (float nofpclass(ninf) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[AND_ARG1:%.*]] = and i32 [[ARG1]], 127
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(ninf) [[ARG0]], i32 [[AND_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %and.arg1 = and i32 %arg1, 127
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %and.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_neg_exp_noninf(float nofpclass(ninf) %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define nofpclass(ninf) float @ret_ldexp_f32_known_neg_exp_noninf
; CHECK-SAME: (float nofpclass(ninf) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[OR_ARG1:%.*]] = or i32 [[ARG1]], -16
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(ninf) float @llvm.ldexp.f32.i32(float nofpclass(ninf) [[ARG0]], i32 [[OR_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %or.arg1 = or i32 %arg1, -16
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %or.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_pos_exp_nopsub_nopzero_daz(float nofpclass(psub pzero) %arg0, i32 %arg1) #1 {
; CHECK-LABEL: define nofpclass(pzero psub) float @ret_ldexp_f32_known_pos_exp_nopsub_nopzero_daz
; CHECK-SAME: (float nofpclass(pzero psub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[AND_ARG1:%.*]] = and i32 [[ARG1]], 127
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pzero psub) float @llvm.ldexp.f32.i32(float nofpclass(pzero psub) [[ARG0]], i32 [[AND_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %and.arg1 = and i32 %arg1, 127
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %and.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_neg_exp_nopsub_nopzero_daz(float nofpclass(psub pzero) %arg0, i32 %arg1) #1 {
; CHECK-LABEL: define float @ret_ldexp_f32_known_neg_exp_nopsub_nopzero_daz
; CHECK-SAME: (float nofpclass(pzero psub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[OR_ARG1:%.*]] = or i32 [[ARG1]], -16
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(pzero psub) [[ARG0]], i32 [[OR_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %or.arg1 = or i32 %arg1, -16
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %or.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_pos_exp_nonsub_nonzero_daz(float nofpclass(nsub nzero) %arg0, i32 %arg1) #1 {
; CHECK-LABEL: define nofpclass(nzero nsub) float @ret_ldexp_f32_known_pos_exp_nonsub_nonzero_daz
; CHECK-SAME: (float nofpclass(nzero nsub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[AND_ARG1:%.*]] = and i32 [[ARG1]], 127
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nzero nsub) float @llvm.ldexp.f32.i32(float nofpclass(nzero nsub) [[ARG0]], i32 [[AND_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %and.arg1 = and i32 %arg1, 127
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %and.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_neg_exp_nonsub_nonzero_daz(float nofpclass(nsub nzero) %arg0, i32 %arg1) #1 {
; CHECK-LABEL: define float @ret_ldexp_f32_known_neg_exp_nonsub_nonzero_daz
; CHECK-SAME: (float nofpclass(nzero nsub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[OR_ARG1:%.*]] = or i32 [[ARG1]], -16
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(nzero nsub) [[ARG0]], i32 [[OR_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %or.arg1 = or i32 %arg1, -16
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %or.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_pos_exp_nosub_nozero_daz(float nofpclass(sub zero) %arg0, i32 %arg1) #1 {
; CHECK-LABEL: define nofpclass(zero sub) float @ret_ldexp_f32_known_pos_exp_nosub_nozero_daz
; CHECK-SAME: (float nofpclass(zero sub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[AND_ARG1:%.*]] = and i32 [[ARG1]], 127
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(zero sub) float @llvm.ldexp.f32.i32(float nofpclass(zero sub) [[ARG0]], i32 [[AND_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %and.arg1 = and i32 %arg1, 127
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %and.arg1)
  ret float %call
}

define float @ret_ldexp_f32_known_neg_exp_nosub_nozero_daz(float nofpclass(sub zero) %arg0, i32 %arg1) #1 {
; CHECK-LABEL: define float @ret_ldexp_f32_known_neg_exp_nosub_nozero_daz
; CHECK-SAME: (float nofpclass(zero sub) [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[OR_ARG1:%.*]] = or i32 [[ARG1]], -16
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float nofpclass(zero sub) [[ARG0]], i32 [[OR_ARG1]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %or.arg1 = or i32 %arg1, -16
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %or.arg1)
  ret float %call
}

define float @ret_ldexp_f32_22(float %arg0) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_22
; CHECK-SAME: (float [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float [[ARG0]], i32 noundef 22) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 22)
  ret float %call
}

define float @ret_ldexp_f32_23(float %arg0) #0 {
; CHECK-LABEL: define nofpclass(sub) float @ret_ldexp_f32_23
; CHECK-SAME: (float [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(sub) float @llvm.ldexp.f32.i32(float [[ARG0]], i32 noundef 23) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 23)
  ret float %call
}

define float @ret_ldexp_f32_24(float %arg0) #0 {
; CHECK-LABEL: define nofpclass(sub) float @ret_ldexp_f32_24
; CHECK-SAME: (float [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(sub) float @llvm.ldexp.f32.i32(float [[ARG0]], i32 noundef 24) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 24)
  ret float %call
}

define float @ret_ldexp_f32_min24(float %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_min24
; CHECK-SAME: (float [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[MIN:%.*]] = call i32 @llvm.smin.i32(i32 [[ARG1]], i32 noundef 24) #[[ATTR10]]
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float [[ARG0]], i32 [[MIN]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %min = call i32 @llvm.smin.i32(i32 %arg1, i32 24)
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 %min)
  ret float %call
}

define float @ret_ldexp_f32_23_nnan(float nofpclass(nan) %arg0) #0 {
; CHECK-LABEL: define nofpclass(nan sub) float @ret_ldexp_f32_23_nnan
; CHECK-SAME: (float nofpclass(nan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nan sub) float @llvm.ldexp.f32.i32(float nofpclass(nan) [[ARG0]], i32 noundef 23) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 23)
  ret float %call
}

define double @ret_ldexp_f64_24(double %arg0) #0 {
; CHECK-LABEL: define double @ret_ldexp_f64_24
; CHECK-SAME: (double [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call double @llvm.ldexp.f64.i32(double [[ARG0]], i32 noundef 24) #[[ATTR10]]
; CHECK-NEXT:    ret double [[CALL]]
;
  %call = call double @llvm.ldexp.f64.i32(double %arg0, i32 24)
  ret double %call
}

define double @ret_ldexp_f64_51(double %arg0) #0 {
; CHECK-LABEL: define double @ret_ldexp_f64_51
; CHECK-SAME: (double [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call double @llvm.ldexp.f64.i32(double [[ARG0]], i32 noundef 51) #[[ATTR10]]
; CHECK-NEXT:    ret double [[CALL]]
;
  %call = call double @llvm.ldexp.f64.i32(double %arg0, i32 51)
  ret double %call
}

define double @ret_ldexp_f64_52(double %arg0) #0 {
; CHECK-LABEL: define nofpclass(sub) double @ret_ldexp_f64_52
; CHECK-SAME: (double [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(sub) double @llvm.ldexp.f64.i32(double [[ARG0]], i32 noundef 52) #[[ATTR10]]
; CHECK-NEXT:    ret double [[CALL]]
;
  %call = call double @llvm.ldexp.f64.i32(double %arg0, i32 52)
  ret double %call
}

define double @ret_ldexp_f64_53(double %arg0) #0 {
; CHECK-LABEL: define nofpclass(sub) double @ret_ldexp_f64_53
; CHECK-SAME: (double [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(sub) double @llvm.ldexp.f64.i32(double [[ARG0]], i32 noundef 53) #[[ATTR10]]
; CHECK-NEXT:    ret double [[CALL]]
;
  %call = call double @llvm.ldexp.f64.i32(double %arg0, i32 53)
  ret double %call
}

define half @ret_ldexp_f16_8(half %arg0) #0 {
; CHECK-LABEL: define half @ret_ldexp_f16_8
; CHECK-SAME: (half [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call half @llvm.ldexp.f16.i32(half [[ARG0]], i32 noundef 8) #[[ATTR10]]
; CHECK-NEXT:    ret half [[CALL]]
;
  %call = call half @llvm.ldexp.f16.i32(half %arg0, i32 8)
  ret half %call
}

define half @ret_ldexp_f16_9(half %arg0) #0 {
; CHECK-LABEL: define half @ret_ldexp_f16_9
; CHECK-SAME: (half [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call half @llvm.ldexp.f16.i32(half [[ARG0]], i32 noundef 9) #[[ATTR10]]
; CHECK-NEXT:    ret half [[CALL]]
;
  %call = call half @llvm.ldexp.f16.i32(half %arg0, i32 9)
  ret half %call
}

define half @ret_ldexp_f16_10(half %arg0) #0 {
; CHECK-LABEL: define nofpclass(sub) half @ret_ldexp_f16_10
; CHECK-SAME: (half [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(sub) half @llvm.ldexp.f16.i32(half [[ARG0]], i32 noundef 10) #[[ATTR10]]
; CHECK-NEXT:    ret half [[CALL]]
;
  %call = call half @llvm.ldexp.f16.i32(half %arg0, i32 10)
  ret half %call
}

define bfloat @ret_ldexp_bf16_6(bfloat %arg0) #0 {
; CHECK-LABEL: define bfloat @ret_ldexp_bf16_6
; CHECK-SAME: (bfloat [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call bfloat @llvm.ldexp.bf16.i32(bfloat [[ARG0]], i32 noundef 6) #[[ATTR10]]
; CHECK-NEXT:    ret bfloat [[CALL]]
;
  %call = call bfloat @llvm.ldexp.bf16.i32(bfloat %arg0, i32 6)
  ret bfloat %call
}

define bfloat @ret_ldexp_bf16_7(bfloat %arg0) #0 {
; CHECK-LABEL: define nofpclass(sub) bfloat @ret_ldexp_bf16_7
; CHECK-SAME: (bfloat [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(sub) bfloat @llvm.ldexp.bf16.i32(bfloat [[ARG0]], i32 noundef 7) #[[ATTR10]]
; CHECK-NEXT:    ret bfloat [[CALL]]
;
  %call = call bfloat @llvm.ldexp.bf16.i32(bfloat %arg0, i32 7)
  ret bfloat %call
}

define bfloat @ret_ldexp_bf16_8(bfloat %arg0) #0 {
; CHECK-LABEL: define nofpclass(sub) bfloat @ret_ldexp_bf16_8
; CHECK-SAME: (bfloat [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(sub) bfloat @llvm.ldexp.bf16.i32(bfloat [[ARG0]], i32 noundef 8) #[[ATTR10]]
; CHECK-NEXT:    ret bfloat [[CALL]]
;
  %call = call bfloat @llvm.ldexp.bf16.i32(bfloat %arg0, i32 8)
  ret bfloat %call
}

define float @ret_ldexp_f32_neg22(float %arg0) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_neg22
; CHECK-SAME: (float [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float [[ARG0]], i32 noundef -22) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 -22)
  ret float %call
}

define float @ret_ldexp_f32_neg23(float %arg0) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_neg23
; CHECK-SAME: (float [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float [[ARG0]], i32 noundef -23) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 -23)
  ret float %call
}

define float @ret_ldexp_f32_neg24(float %arg0) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_neg24
; CHECK-SAME: (float [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float [[ARG0]], i32 noundef -24) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 -24)
  ret float %call
}

define float @ret_ldexp_f32_neg126(float %arg0) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_neg126
; CHECK-SAME: (float [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float [[ARG0]], i32 noundef -126) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 -126)
  ret float %call
}

define float @ret_ldexp_f32_neg127(float %arg0) #0 {
; CHECK-LABEL: define float @ret_ldexp_f32_neg127
; CHECK-SAME: (float [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.ldexp.f32.i32(float [[ARG0]], i32 noundef -127) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.ldexp.f32.i32(float %arg0, i32 -127)
  ret float %call
}

attributes #0 = { "denormal-fp-math"="ieee,ieee" }
attributes #1 = { "denormal-fp-math"="preserve-sign,preserve-sign" }
attributes #2 = { "denormal-fp-math"="positive-zero,positive-zero" }
attributes #3 = { "denormal-fp-math"="preserve-sign,ieee" }
attributes #4 = { "denormal-fp-math"="ieee,dynamic" }
attributes #5 = { "denormal-fp-math"="ieee,preserve-sign" }
attributes #6 = { "denormal-fp-math"="dynamic,preserve-sign" }
attributes #7 = { "denormal-fp-math"="dynamic,positive-zero" }
attributes #8 = { "denormal-fp-math"="positive-zero,dynamic" }

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; TUNIT: {{.*}}
