; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvl1024b -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvl1024b -verify-machineinstrs < %s | FileCheck %s

; There is no corresponding v1i256 type, so make sure we don't crash if we try
; to lower via lowerBitreverseShuffle.
define <256 x i1> @reverse_v256i1(<256 x i1> %a) {
; CHECK-LABEL: reverse_v256i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 256
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vid.v v10
; CHECK-NEXT:    vrsub.vi v10, v10, -1
; CHECK-NEXT:    vrgather.vv v12, v8, v10
; CHECK-NEXT:    vmsne.vi v0, v12, 0
; CHECK-NEXT:    ret
  %res = call <256 x i1> @llvm.vector.reverse.v256i1(<256 x i1> %a)
  ret <256 x i1> %res
}

declare <256 x i1> @llvm.vector.reverse.v256i1(<256 x i1>)
