; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdhsa -verify-machineinstrs -stop-after=irtranslator < %s | FileCheck %s

define amdgpu_kernel void @system_one_as_acquire() {
  ; CHECK-LABEL: name: system_one_as_acquire
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 4, 2
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("one-as") acquire
  ret void
}

define amdgpu_kernel void @system_one_as_release() {
  ; CHECK-LABEL: name: system_one_as_release
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 5, 2
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("one-as") release
  ret void
}

define amdgpu_kernel void @system_one_as_acq_rel() {
  ; CHECK-LABEL: name: system_one_as_acq_rel
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 6, 2
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("one-as") acq_rel
  ret void
}

define amdgpu_kernel void @system_one_as_seq_cst() {
  ; CHECK-LABEL: name: system_one_as_seq_cst
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 7, 2
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("one-as") seq_cst
  ret void
}

define amdgpu_kernel void @singlethread_one_as_acquire() {
  ; CHECK-LABEL: name: singlethread_one_as_acquire
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 4, 3
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("singlethread-one-as") acquire
  ret void
}

define amdgpu_kernel void @singlethread_one_as_release() {
  ; CHECK-LABEL: name: singlethread_one_as_release
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 5, 3
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("singlethread-one-as") release
  ret void
}

define amdgpu_kernel void @singlethread_one_as_acq_rel() {
  ; CHECK-LABEL: name: singlethread_one_as_acq_rel
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 6, 3
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("singlethread-one-as") acq_rel
  ret void
}

define amdgpu_kernel void @singlethread_one_as_seq_cst() {
  ; CHECK-LABEL: name: singlethread_one_as_seq_cst
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 7, 3
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("singlethread-one-as") seq_cst
  ret void
}

define amdgpu_kernel void @agent_one_as_acquire() {
  ; CHECK-LABEL: name: agent_one_as_acquire
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 4, 4
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("agent-one-as") acquire
  ret void
}

define amdgpu_kernel void @agent_one_as_release() {
  ; CHECK-LABEL: name: agent_one_as_release
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 5, 4
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("agent-one-as") release
  ret void
}

define amdgpu_kernel void @agent_one_as_acq_rel() {
  ; CHECK-LABEL: name: agent_one_as_acq_rel
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 6, 4
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("agent-one-as") acq_rel
  ret void
}

define amdgpu_kernel void @agent_one_as_seq_cst() {
  ; CHECK-LABEL: name: agent_one_as_seq_cst
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 7, 4
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("agent-one-as") seq_cst
  ret void
}

define amdgpu_kernel void @workgroup_one_as_acquire() {
  ; CHECK-LABEL: name: workgroup_one_as_acquire
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 4, 5
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("workgroup-one-as") acquire
  ret void
}

define amdgpu_kernel void @workgroup_one_as_release() {
  ; CHECK-LABEL: name: workgroup_one_as_release
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 5, 5
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("workgroup-one-as") release
  ret void
}

define amdgpu_kernel void @workgroup_one_as_acq_rel() {
  ; CHECK-LABEL: name: workgroup_one_as_acq_rel
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 6, 5
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("workgroup-one-as") acq_rel
  ret void
}

define amdgpu_kernel void @workgroup_one_as_seq_cst() {
  ; CHECK-LABEL: name: workgroup_one_as_seq_cst
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 7, 5
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("workgroup-one-as") seq_cst
  ret void
}

define amdgpu_kernel void @wavefront_one_as_acquire() {
  ; CHECK-LABEL: name: wavefront_one_as_acquire
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 4, 6
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("wavefront-one-as") acquire
  ret void
}

define amdgpu_kernel void @wavefront_one_as_release() {
  ; CHECK-LABEL: name: wavefront_one_as_release
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 5, 6
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("wavefront-one-as") release
  ret void
}

define amdgpu_kernel void @wavefront_one_as_acq_rel() {
  ; CHECK-LABEL: name: wavefront_one_as_acq_rel
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 6, 6
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("wavefront-one-as") acq_rel
  ret void
}

define amdgpu_kernel void @wavefront_one_as_seq_cst() {
  ; CHECK-LABEL: name: wavefront_one_as_seq_cst
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 7, 6
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("wavefront-one-as") seq_cst
  ret void
}

define amdgpu_kernel void @system_acquire() {
  ; CHECK-LABEL: name: system_acquire
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   S_ENDPGM 0
entry:
  ret void
}

define amdgpu_kernel void @system_release() {
  ; CHECK-LABEL: name: system_release
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 5, 1
  ; CHECK-NEXT:   S_ENDPGM 0
  fence release
  ret void
}

define amdgpu_kernel void @system_acq_rel() {
  ; CHECK-LABEL: name: system_acq_rel
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 6, 1
  ; CHECK-NEXT:   S_ENDPGM 0
  fence acq_rel
  ret void
}

define amdgpu_kernel void @system_seq_cst() {
  ; CHECK-LABEL: name: system_seq_cst
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 7, 1
  ; CHECK-NEXT:   S_ENDPGM 0
  fence seq_cst
  ret void
}

define amdgpu_kernel void @singlethread_acquire() {
  ; CHECK-LABEL: name: singlethread_acquire
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 4, 0
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("singlethread") acquire
  ret void
}

define amdgpu_kernel void @singlethread_release() {
  ; CHECK-LABEL: name: singlethread_release
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 5, 0
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("singlethread") release
  ret void
}

define amdgpu_kernel void @singlethread_acq_rel() {
  ; CHECK-LABEL: name: singlethread_acq_rel
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 6, 0
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("singlethread") acq_rel
  ret void
}

define amdgpu_kernel void @singlethread_seq_cst() {
  ; CHECK-LABEL: name: singlethread_seq_cst
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 7, 0
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("singlethread") seq_cst
  ret void
}

define amdgpu_kernel void @agent_acquire() {
  ; CHECK-LABEL: name: agent_acquire
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 4, 7
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("agent") acquire
  ret void
}

define amdgpu_kernel void @agent_release() {
  ; CHECK-LABEL: name: agent_release
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 5, 7
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("agent") release
  ret void
}

define amdgpu_kernel void @agent_acq_rel() {
  ; CHECK-LABEL: name: agent_acq_rel
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 6, 7
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("agent") acq_rel
  ret void
}

define amdgpu_kernel void @agent_seq_cst() {
  ; CHECK-LABEL: name: agent_seq_cst
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 7, 7
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @workgroup_acquire() {
  ; CHECK-LABEL: name: workgroup_acquire
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 4, 8
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("workgroup") acquire
  ret void
}

define amdgpu_kernel void @workgroup_release() {
  ; CHECK-LABEL: name: workgroup_release
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 5, 8
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("workgroup") release
  ret void
}

define amdgpu_kernel void @workgroup_acq_rel() {
  ; CHECK-LABEL: name: workgroup_acq_rel
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 6, 8
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("workgroup") acq_rel
  ret void
}

define amdgpu_kernel void @workgroup_seq_cst() {
  ; CHECK-LABEL: name: workgroup_seq_cst
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 7, 8
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @wavefront_acquire() {
  ; CHECK-LABEL: name: wavefront_acquire
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 4, 9
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("wavefront") acquire
  ret void
}

define amdgpu_kernel void @wavefront_release() {
  ; CHECK-LABEL: name: wavefront_release
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 5, 9
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("wavefront") release
  ret void
}

define amdgpu_kernel void @wavefront_acq_rel() {
  ; CHECK-LABEL: name: wavefront_acq_rel
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 6, 9
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("wavefront") acq_rel
  ret void
}

define amdgpu_kernel void @wavefront_seq_cst() {
  ; CHECK-LABEL: name: wavefront_seq_cst
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $sgpr6_sgpr7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p4) = COPY $sgpr6_sgpr7
  ; CHECK-NEXT:   G_FENCE 7, 9
  ; CHECK-NEXT:   S_ENDPGM 0
  fence syncscope("wavefront") seq_cst
  ret void
}
