; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-ONLY,AVX512-SLOW,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-ONLY,AVX512-FAST,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512DQ-ONLY,AVX512-SLOW,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512DQ-ONLY,AVX512-FAST,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-ONLY,AVX512-SLOW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-ONLY,AVX512-FAST,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512DQBW-ONLY,AVX512-SLOW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512DQBW-ONLY,AVX512-FAST,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i64_stride3_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride3_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movapd (%rdi), %xmm0
; SSE-NEXT:    movapd (%rsi), %xmm1
; SSE-NEXT:    movapd (%rdx), %xmm2
; SSE-NEXT:    movapd %xmm0, %xmm3
; SSE-NEXT:    unpcklpd {{.*#+}} xmm3 = xmm3[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm2[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, 16(%rcx)
; SSE-NEXT:    movapd %xmm1, 32(%rcx)
; SSE-NEXT:    movapd %xmm3, (%rcx)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride3_vf2:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX1-ONLY-NEXT:    vmovaps %xmm1, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm0, (%rcx)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride3_vf2:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %xmm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps %xmm1, 32(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride3_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovaps (%rdi), %xmm0
; AVX512-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vinsertf32x4 $2, (%rdx), %zmm0, %zmm0
; AVX512-NEXT:    vmovaps {{.*#+}} zmm1 = [0,2,4,1,3,5,u,u]
; AVX512-NEXT:    vpermpd %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    vextractf32x4 $2, %zmm0, 32(%rcx)
; AVX512-NEXT:    vmovaps %ymm0, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <2 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i64>, ptr %in.vecptr2, align 64
  %1 = shufflevector <2 x i64> %in.vec0, <2 x i64> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i64> %in.vec2, <2 x i64> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %3 = shufflevector <4 x i64> %1, <4 x i64> %2, <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
  %interleaved.vec = shufflevector <6 x i64> %3, <6 x i64> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride3_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride3_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps (%rsi), %xmm2
; SSE-NEXT:    movaps 16(%rsi), %xmm3
; SSE-NEXT:    movaps (%rdx), %xmm4
; SSE-NEXT:    movaps 16(%rdx), %xmm5
; SSE-NEXT:    movaps %xmm3, %xmm6
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm1[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm0[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    movaps %xmm4, 16(%rcx)
; SSE-NEXT:    movaps %xmm3, 32(%rcx)
; SSE-NEXT:    movaps %xmm1, 48(%rcx)
; SSE-NEXT:    movaps %xmm5, 64(%rcx)
; SSE-NEXT:    movaps %xmm6, 80(%rcx)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride3_vf4:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovapd (%rsi), %ymm0
; AVX1-ONLY-NEXT:    vmovapd (%rdx), %ymm1
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovapd 16(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm4 = xmm2[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm4 = ymm0[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm1[2,3],ymm4[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2],ymm3[3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2],ymm0[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovapd %ymm3, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, (%rcx)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride3_vf4:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1],ymm3[2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm4 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm0[4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm2[2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 32(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, (%rcx)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride3_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm2 = [10,3,7,11]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,4,8,1,5,9,2,6]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <4 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i64>, ptr %in.vecptr2, align 64
  %1 = shufflevector <4 x i64> %in.vec0, <4 x i64> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i64> %in.vec2, <4 x i64> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <8 x i64> %1, <8 x i64> %2, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  %interleaved.vec = shufflevector <12 x i64> %3, <12 x i64> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride3_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride3_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm3
; SSE-NEXT:    movaps 16(%rdi), %xmm2
; SSE-NEXT:    movaps 32(%rdi), %xmm1
; SSE-NEXT:    movaps 48(%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm7
; SSE-NEXT:    movaps 16(%rsi), %xmm8
; SSE-NEXT:    movaps 32(%rsi), %xmm9
; SSE-NEXT:    movaps 48(%rsi), %xmm10
; SSE-NEXT:    movaps (%rdx), %xmm11
; SSE-NEXT:    movaps 16(%rdx), %xmm12
; SSE-NEXT:    movaps 32(%rdx), %xmm6
; SSE-NEXT:    movaps 48(%rdx), %xmm5
; SSE-NEXT:    movaps %xmm10, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm10[0]
; SSE-NEXT:    movaps %xmm9, %xmm10
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm6[1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm9[0]
; SSE-NEXT:    movaps %xmm8, %xmm9
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm2[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm8[0]
; SSE-NEXT:    movaps %xmm7, %xmm8
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,1],xmm3[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm7[0]
; SSE-NEXT:    movaps %xmm3, (%rcx)
; SSE-NEXT:    movaps %xmm11, 16(%rcx)
; SSE-NEXT:    movaps %xmm8, 32(%rcx)
; SSE-NEXT:    movaps %xmm2, 48(%rcx)
; SSE-NEXT:    movaps %xmm12, 64(%rcx)
; SSE-NEXT:    movaps %xmm9, 80(%rcx)
; SSE-NEXT:    movaps %xmm1, 96(%rcx)
; SSE-NEXT:    movaps %xmm6, 112(%rcx)
; SSE-NEXT:    movaps %xmm10, 128(%rcx)
; SSE-NEXT:    movaps %xmm0, 144(%rcx)
; SSE-NEXT:    movaps %xmm5, 160(%rcx)
; SSE-NEXT:    movaps %xmm4, 176(%rcx)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride3_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovapd (%rsi), %ymm0
; AVX1-ONLY-NEXT:    vmovapd 32(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovapd (%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovapd 32(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovapd 16(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vmovapd 48(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm8 = xmm4[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm8, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm8, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm8[0,1],ymm4[2,3],ymm8[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm8 = xmm6[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm8, %ymm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm8, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm8[0,1],ymm6[2,3],ymm8[4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm7[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm8 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm3[2,3],ymm8[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2],ymm7[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm8 = ymm0[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm2[2,3],ymm8[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm8[0],ymm5[1],ymm8[2],ymm5[3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2],ymm0[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm2[1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],mem[2],ymm1[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovapd %ymm5, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm7, 160(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm1, 128(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, (%rcx)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride3_vf8:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %ymm4
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %ymm5
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm2[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm0[4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm4[2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm7 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm8 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1],ymm7[2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd (%rdx), %ymm8
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm8 = ymm3[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm1[4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm5[2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1],ymm3[2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm5 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm5[2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 32(%rdx), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm5[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm2[1],ymm0[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm4[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 96(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 160(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 128(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, (%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 32(%rcx)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride3_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,8,u,1,9,u,2,10]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,8,3,4,9,6,7]
; AVX512-NEXT:    vpermi2q %zmm2, %zmm3, %zmm4
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [u,3,11,u,4,12,u,5]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [10,1,2,11,4,5,12,7]
; AVX512-NEXT:    vpermi2q %zmm2, %zmm3, %zmm5
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [5,u,14,6,u,15,7,u]
; AVX512-NEXT:    vpermi2q %zmm0, %zmm1, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,13,2,3,14,5,6,15]
; AVX512-NEXT:    vpermi2q %zmm2, %zmm3, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <8 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i64>, ptr %in.vecptr2, align 64
  %1 = shufflevector <8 x i64> %in.vec0, <8 x i64> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i64> %in.vec2, <8 x i64> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <16 x i64> %1, <16 x i64> %2, <24 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %interleaved.vec = shufflevector <24 x i64> %3, <24 x i64> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride3_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride3_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movapd 64(%rdi), %xmm5
; SSE-NEXT:    movapd (%rdi), %xmm1
; SSE-NEXT:    movapd 16(%rdi), %xmm2
; SSE-NEXT:    movapd 32(%rdi), %xmm3
; SSE-NEXT:    movapd 48(%rdi), %xmm6
; SSE-NEXT:    movapd 64(%rsi), %xmm9
; SSE-NEXT:    movapd (%rsi), %xmm4
; SSE-NEXT:    movapd 16(%rsi), %xmm7
; SSE-NEXT:    movapd 32(%rsi), %xmm11
; SSE-NEXT:    movapd 48(%rsi), %xmm10
; SSE-NEXT:    movapd 64(%rdx), %xmm15
; SSE-NEXT:    movapd (%rdx), %xmm0
; SSE-NEXT:    movapd 16(%rdx), %xmm12
; SSE-NEXT:    movapd 32(%rdx), %xmm13
; SSE-NEXT:    movapd 48(%rdx), %xmm14
; SSE-NEXT:    movapd %xmm1, %xmm8
; SSE-NEXT:    unpcklpd {{.*#+}} xmm8 = xmm8[0],xmm4[0]
; SSE-NEXT:    movapd %xmm8, (%rsp) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm0[1]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm2, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm7[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm12[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm12[1]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm3, %xmm12
; SSE-NEXT:    unpcklpd {{.*#+}} xmm12 = xmm12[0],xmm11[0]
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm13[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm13[1]
; SSE-NEXT:    movapd %xmm6, %xmm13
; SSE-NEXT:    unpcklpd {{.*#+}} xmm13 = xmm13[0],xmm10[0]
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm14[0],xmm6[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm14[1]
; SSE-NEXT:    movapd %xmm5, %xmm14
; SSE-NEXT:    unpcklpd {{.*#+}} xmm14 = xmm14[0],xmm9[0]
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm15[0],xmm5[1]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm15[1]
; SSE-NEXT:    movapd 80(%rdi), %xmm15
; SSE-NEXT:    movapd 80(%rsi), %xmm7
; SSE-NEXT:    movapd %xmm15, %xmm8
; SSE-NEXT:    unpcklpd {{.*#+}} xmm8 = xmm8[0],xmm7[0]
; SSE-NEXT:    movapd 80(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm0[0],xmm15[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm0[1]
; SSE-NEXT:    movapd 96(%rdi), %xmm4
; SSE-NEXT:    movapd 96(%rsi), %xmm3
; SSE-NEXT:    movapd %xmm4, %xmm6
; SSE-NEXT:    unpcklpd {{.*#+}} xmm6 = xmm6[0],xmm3[0]
; SSE-NEXT:    movapd 96(%rdx), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm2[0],xmm4[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movapd 112(%rdi), %xmm2
; SSE-NEXT:    movapd 112(%rsi), %xmm0
; SSE-NEXT:    movapd %xmm2, %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movapd 112(%rdx), %xmm5
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm5[0],xmm2[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm5[1]
; SSE-NEXT:    movapd %xmm0, 368(%rcx)
; SSE-NEXT:    movapd %xmm2, 352(%rcx)
; SSE-NEXT:    movapd %xmm1, 336(%rcx)
; SSE-NEXT:    movapd %xmm3, 320(%rcx)
; SSE-NEXT:    movapd %xmm4, 304(%rcx)
; SSE-NEXT:    movapd %xmm6, 288(%rcx)
; SSE-NEXT:    movapd %xmm7, 272(%rcx)
; SSE-NEXT:    movapd %xmm15, 256(%rcx)
; SSE-NEXT:    movapd %xmm8, 240(%rcx)
; SSE-NEXT:    movapd %xmm9, 224(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rcx)
; SSE-NEXT:    movapd %xmm14, 192(%rcx)
; SSE-NEXT:    movapd %xmm10, 176(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rcx)
; SSE-NEXT:    movapd %xmm13, 144(%rcx)
; SSE-NEXT:    movapd %xmm11, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rcx)
; SSE-NEXT:    movapd %xmm12, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride3_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovapd (%rsi), %ymm6
; AVX1-ONLY-NEXT:    vmovapd 32(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vmovapd 64(%rsi), %ymm5
; AVX1-ONLY-NEXT:    vmovapd 96(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovapd (%rdx), %ymm9
; AVX1-ONLY-NEXT:    vmovapd 32(%rdx), %ymm4
; AVX1-ONLY-NEXT:    vmovapd 64(%rdx), %ymm8
; AVX1-ONLY-NEXT:    vmovapd 96(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vmovapd 48(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm7 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm7, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0,1],ymm0[2,3],ymm7[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm11 = xmm7[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm11, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0,1],ymm7[2,3],ymm11[4,5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm11 = xmm10[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm10
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1],ymm10[2,3],ymm11[4,5],ymm10[6,7]
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm12 = xmm11[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm12, %ymm11
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%rdx), %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0,1],ymm11[2,3],ymm12[4,5],ymm11[6,7]
; AVX1-ONLY-NEXT:    vmovapd 80(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm12 = ymm12[0,1],ymm8[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm5[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm8[2,3],ymm14[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm12 = ymm14[0],ymm12[1],ymm14[2],ymm12[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm13 = ymm13[0,1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm2[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm4[2,3],ymm14[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm13 = ymm14[0],ymm13[1],ymm14[2],ymm13[3]
; AVX1-ONLY-NEXT:    vmovapd 112(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm14[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm15 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm3[2,3],ymm15[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2],ymm14[3]
; AVX1-ONLY-NEXT:    vmovapd 16(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm15 = ymm15[0,1],ymm9[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm6[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm9[2,3],ymm0[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0],ymm15[1],ymm0[2],ymm15[3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0,1],mem[2],ymm6[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0],ymm9[1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0,1],mem[2],ymm5[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0],ymm8[1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1],mem[2],ymm2[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],mem[2],ymm1[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm14, 352(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm1, 320(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm13, 160(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm2, 128(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm5, 224(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm12, 256(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm6, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 288(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 192(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rcx)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride3_vf16:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm7
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm10
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %ymm6
; AVX2-ONLY-NEXT:    vmovaps 64(%rdx), %ymm11
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm4[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm8[1],ymm9[1],ymm8[3],ymm9[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm5 = ymm11[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm5 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm12 = ymm8[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm12[0,1],ymm5[2,3],ymm12[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 64(%rdx), %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm12[4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %ymm12
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm9 = ymm9[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5],ymm9[6,7]
; AVX2-ONLY-NEXT:    vmovaps 96(%rdx), %ymm13
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm11[2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm9 = ymm10[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm7[4,5],ymm9[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1],ymm12[2,3],ymm9[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm7[1],ymm10[1],ymm7[3],ymm10[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm11 = ymm12[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1],ymm10[2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm11 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm11[2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 32(%rdx), %ymm11
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm11[4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm11 = ymm6[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm3[4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm13[2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm3[1],ymm6[1],ymm3[3],ymm6[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm12 = ymm13[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm12[0,1],ymm6[2,3,4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm12 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm12[2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 96(%rdx), %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm12[4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm12 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm0[4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1],ymm1[2,3],ymm12[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 288(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 352(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 320(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 96(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 160(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 128(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 224(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 192(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 256(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, (%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm12, 32(%rcx)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride3_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,8,u,1,9,u,2,10]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-NEXT:    vpermt2q %zmm2, %zmm6, %zmm7
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [0,1,8,3,4,9,6,7]
; AVX512-NEXT:    vpermt2q %zmm4, %zmm8, %zmm7
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [5,u,14,6,u,15,7,u]
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512-NEXT:    vpermt2q %zmm1, %zmm9, %zmm10
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [0,13,2,3,14,5,6,15]
; AVX512-NEXT:    vpermt2q %zmm5, %zmm11, %zmm10
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [u,3,11,u,4,12,u,5]
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm13
; AVX512-NEXT:    vpermt2q %zmm3, %zmm12, %zmm13
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [10,1,2,11,4,5,12,7]
; AVX512-NEXT:    vpermt2q %zmm5, %zmm14, %zmm13
; AVX512-NEXT:    vpermt2q %zmm3, %zmm6, %zmm1
; AVX512-NEXT:    vpermt2q %zmm5, %zmm8, %zmm1
; AVX512-NEXT:    vpermi2q %zmm0, %zmm2, %zmm9
; AVX512-NEXT:    vpermt2q %zmm4, %zmm11, %zmm9
; AVX512-NEXT:    vpermt2q %zmm2, %zmm12, %zmm0
; AVX512-NEXT:    vpermt2q %zmm4, %zmm14, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm0, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm9, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm1, 192(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm13, 256(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm10, 320(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <16 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i64>, ptr %in.vecptr2, align 64
  %1 = shufflevector <16 x i64> %in.vec0, <16 x i64> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i64> %in.vec2, <16 x i64> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <32 x i64> %1, <32 x i64> %2, <48 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47>
  %interleaved.vec = shufflevector <48 x i64> %3, <48 x i64> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride3_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride3_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $408, %rsp # imm = 0x198
; SSE-NEXT:    movapd 64(%rdi), %xmm8
; SSE-NEXT:    movapd (%rdi), %xmm5
; SSE-NEXT:    movapd 16(%rdi), %xmm6
; SSE-NEXT:    movapd 32(%rdi), %xmm7
; SSE-NEXT:    movapd 48(%rdi), %xmm9
; SSE-NEXT:    movapd 64(%rsi), %xmm13
; SSE-NEXT:    movapd (%rsi), %xmm10
; SSE-NEXT:    movapd 16(%rsi), %xmm11
; SSE-NEXT:    movapd 32(%rsi), %xmm12
; SSE-NEXT:    movapd 48(%rsi), %xmm14
; SSE-NEXT:    movapd 64(%rdx), %xmm0
; SSE-NEXT:    movapd (%rdx), %xmm1
; SSE-NEXT:    movapd 16(%rdx), %xmm2
; SSE-NEXT:    movapd 32(%rdx), %xmm3
; SSE-NEXT:    movapd 48(%rdx), %xmm4
; SSE-NEXT:    movapd %xmm5, %xmm15
; SSE-NEXT:    unpcklpd {{.*#+}} xmm15 = xmm15[0],xmm10[0]
; SSE-NEXT:    movapd %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm1[0],xmm5[1]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm1[1]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm6, %xmm5
; SSE-NEXT:    unpcklpd {{.*#+}} xmm5 = xmm5[0],xmm11[0]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm2[0],xmm6[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm2[1]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm7, %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm12[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm3[0],xmm7[1]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm3[1]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm9, %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm14[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm4[0],xmm9[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm4[1]
; SSE-NEXT:    movapd %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm8, %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm13[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm0[0],xmm8[1]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movapd %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rdi), %xmm1
; SSE-NEXT:    movapd 80(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rdi), %xmm1
; SSE-NEXT:    movapd 96(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rdi), %xmm1
; SSE-NEXT:    movapd 112(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rdi), %xmm1
; SSE-NEXT:    movapd 128(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rdi), %xmm1
; SSE-NEXT:    movapd 144(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rdi), %xmm1
; SSE-NEXT:    movapd 160(%rsi), %xmm15
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm15[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movapd 176(%rdi), %xmm13
; SSE-NEXT:    movapd 176(%rsi), %xmm12
; SSE-NEXT:    movapd %xmm13, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm12[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm13 = xmm0[0],xmm13[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movapd 192(%rdi), %xmm9
; SSE-NEXT:    movapd 192(%rsi), %xmm8
; SSE-NEXT:    movapd %xmm9, %xmm14
; SSE-NEXT:    unpcklpd {{.*#+}} xmm14 = xmm14[0],xmm8[0]
; SSE-NEXT:    movapd 192(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm0[0],xmm9[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movapd 208(%rdi), %xmm10
; SSE-NEXT:    movapd 208(%rsi), %xmm7
; SSE-NEXT:    movapd %xmm10, %xmm11
; SSE-NEXT:    unpcklpd {{.*#+}} xmm11 = xmm11[0],xmm7[0]
; SSE-NEXT:    movapd 208(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm0[0],xmm10[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm0[1]
; SSE-NEXT:    movapd 224(%rdi), %xmm4
; SSE-NEXT:    movapd 224(%rsi), %xmm3
; SSE-NEXT:    movapd %xmm4, %xmm6
; SSE-NEXT:    unpcklpd {{.*#+}} xmm6 = xmm6[0],xmm3[0]
; SSE-NEXT:    movapd 224(%rdx), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm2[0],xmm4[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movapd 240(%rdi), %xmm2
; SSE-NEXT:    movapd 240(%rsi), %xmm0
; SSE-NEXT:    movapd %xmm2, %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movapd 240(%rdx), %xmm5
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm5[0],xmm2[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm5[1]
; SSE-NEXT:    movapd %xmm0, 752(%rcx)
; SSE-NEXT:    movapd %xmm2, 736(%rcx)
; SSE-NEXT:    movapd %xmm1, 720(%rcx)
; SSE-NEXT:    movapd %xmm3, 704(%rcx)
; SSE-NEXT:    movapd %xmm4, 688(%rcx)
; SSE-NEXT:    movapd %xmm6, 672(%rcx)
; SSE-NEXT:    movapd %xmm7, 656(%rcx)
; SSE-NEXT:    movapd %xmm10, 640(%rcx)
; SSE-NEXT:    movapd %xmm11, 624(%rcx)
; SSE-NEXT:    movapd %xmm8, 608(%rcx)
; SSE-NEXT:    movapd %xmm9, 592(%rcx)
; SSE-NEXT:    movapd %xmm14, 576(%rcx)
; SSE-NEXT:    movapd %xmm12, 560(%rcx)
; SSE-NEXT:    movapd %xmm13, 544(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rcx)
; SSE-NEXT:    movapd %xmm15, 512(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rcx)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    addq $408, %rsp # imm = 0x198
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride3_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $424, %rsp # imm = 0x1A8
; AVX1-ONLY-NEXT:    vmovapd (%rsi), %ymm6
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 32(%rsi), %ymm5
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd (%rdx), %ymm11
; AVX1-ONLY-NEXT:    vmovapd 32(%rdx), %ymm13
; AVX1-ONLY-NEXT:    vmovapd 64(%rdx), %ymm7
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovapd 16(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovapd 48(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm4 = xmm2[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm3[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm2[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm2[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm2[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, 128(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm2[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm2[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, 192(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm2[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, 224(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm11[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm6[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm11[2,3],ymm2[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm13[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm5[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm13[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 80(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovapd 64(%rsi), %ymm10
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm10[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm7[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 96(%rdx), %ymm5
; AVX1-ONLY-NEXT:    vmovapd 112(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovapd 96(%rsi), %ymm9
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm9[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm5[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 128(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vmovapd 144(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovapd 128(%rsi), %ymm7
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm7[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm3[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 160(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vmovapd 176(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovapd 160(%rsi), %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm8 = ymm6[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm1[2,3],ymm8[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm8[0],ymm0[1],ymm8[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 192(%rdx), %ymm0
; AVX1-ONLY-NEXT:    vmovapd 208(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm8[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovapd 192(%rsi), %ymm4
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm15 = ymm4[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm0[2,3],ymm15[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm15[0],ymm8[1],ymm15[2],ymm8[3]
; AVX1-ONLY-NEXT:    vmovapd 224(%rdx), %ymm15
; AVX1-ONLY-NEXT:    vmovapd 240(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vmovapd 224(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm12 = ymm2[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm15[2,3],ymm12[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm12 = ymm12[0],ymm14[1],ymm12[2],ymm14[3]
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm14 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm14[0,1],mem[2],ymm14[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm11 = ymm14[0],ymm11[1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm14 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm14[0,1],mem[2],ymm14[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm13 = ymm14[0],ymm13[1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm10 = ymm10[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm10 = ymm10[0,1],mem[2],ymm10[3]
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm10 = ymm10[0],mem[1],ymm10[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm9 = ymm9[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm9 = ymm9[0,1],mem[2],ymm9[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm9[0],ymm5[1],ymm9[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm7 = ymm7[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm7[0,1],mem[2],ymm7[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm7[0],ymm3[1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0,1],mem[2],ymm6[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm6[0],ymm1[1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0,1],mem[2],ymm4[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm4[0],ymm0[1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1],mem[2],ymm2[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0],ymm15[1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovapd %ymm12, 736(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm2, 704(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm8, 640(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 608(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 544(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm1, 512(%rcx)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 448(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm3, 416(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm5, 320(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm10, 224(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm13, 128(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm11, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 576(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rcx)
; AVX1-ONLY-NEXT:    addq $424, %rsp # imm = 0x1A8
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride3_vf32:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $168, %rsp
; AVX2-ONLY-NEXT:    vmovaps 128(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %ymm12
; AVX2-ONLY-NEXT:    vmovaps 128(%rsi), %ymm13
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm3
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %ymm14
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %ymm4
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %ymm6
; AVX2-ONLY-NEXT:    vmovaps 64(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 96(%rdx), %ymm15
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm7 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm10 = ymm2[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1],ymm7[2,3],ymm10[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd (%rdx), %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm10[4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm3[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm2[4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm4[2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm3 = ymm4[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm3 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 32(%rdx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm5[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm6[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm5[1],ymm0[3],ymm5[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm6[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm8[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 64(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm9[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm8[1],ymm9[1],ymm8[3],ymm9[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm12[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 96(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm12[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0,1],ymm15[2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm12[1],ymm14[1],ymm12[3],ymm14[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm15[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm11[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 128(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm13[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm11[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm11[1],ymm13[1],ymm11[3],ymm13[3]
; AVX2-ONLY-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 160(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps 160(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1],ymm1[2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 192(%rdx), %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm4[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps 192(%rsi), %ymm4
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm5 = ymm4[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm0[4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm4[1],ymm0[3],ymm4[3]
; AVX2-ONLY-NEXT:    vmovaps 192(%rdx), %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm4[2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1],ymm0[2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vmovaps 224(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm7 = ymm4[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0,1],ymm0[2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 224(%rdx), %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm7[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 224(%rsi), %ymm7
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm8 = ymm7[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm4[4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm7[1],ymm4[3],ymm7[3]
; AVX2-ONLY-NEXT:    vmovaps 224(%rdx), %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm7[2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1],ymm4[2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 736(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 704(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 672(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 640(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 608(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 576(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 544(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 512(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm15, 480(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm13, 448(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 416(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm14, 384(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm12, 352(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 320(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 288(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 224(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-ONLY-NEXT:    addq $168, %rsp
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride3_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512-NEXT:    vmovdqa64 128(%rdx), %zmm10
; AVX512-NEXT:    vmovdqa64 192(%rdx), %zmm11
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [0,8,u,1,9,u,2,10]
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512-NEXT:    vpermt2q %zmm4, %zmm12, %zmm13
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [0,1,8,3,4,9,6,7]
; AVX512-NEXT:    vpermt2q %zmm8, %zmm14, %zmm13
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm15 = [5,u,14,6,u,15,7,u]
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm16
; AVX512-NEXT:    vpermt2q %zmm0, %zmm15, %zmm16
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,13,2,3,14,5,6,15]
; AVX512-NEXT:    vpermt2q %zmm11, %zmm17, %zmm16
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm18 = [u,3,11,u,4,12,u,5]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm19
; AVX512-NEXT:    vpermt2q %zmm7, %zmm18, %zmm19
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [10,1,2,11,4,5,12,7]
; AVX512-NEXT:    vpermt2q %zmm11, %zmm20, %zmm19
; AVX512-NEXT:    vpermt2q %zmm7, %zmm12, %zmm0
; AVX512-NEXT:    vpermt2q %zmm11, %zmm14, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm7
; AVX512-NEXT:    vpermt2q %zmm1, %zmm15, %zmm7
; AVX512-NEXT:    vpermt2q %zmm10, %zmm17, %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512-NEXT:    vpermt2q %zmm6, %zmm18, %zmm11
; AVX512-NEXT:    vpermt2q %zmm10, %zmm20, %zmm11
; AVX512-NEXT:    vpermt2q %zmm6, %zmm12, %zmm1
; AVX512-NEXT:    vpermt2q %zmm10, %zmm14, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512-NEXT:    vpermt2q %zmm2, %zmm15, %zmm6
; AVX512-NEXT:    vpermt2q %zmm9, %zmm17, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512-NEXT:    vpermt2q %zmm5, %zmm18, %zmm10
; AVX512-NEXT:    vpermt2q %zmm9, %zmm20, %zmm10
; AVX512-NEXT:    vpermt2q %zmm5, %zmm12, %zmm2
; AVX512-NEXT:    vpermt2q %zmm9, %zmm14, %zmm2
; AVX512-NEXT:    vpermi2q %zmm3, %zmm4, %zmm15
; AVX512-NEXT:    vpermt2q %zmm8, %zmm17, %zmm15
; AVX512-NEXT:    vpermt2q %zmm4, %zmm18, %zmm3
; AVX512-NEXT:    vpermt2q %zmm8, %zmm20, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm2, 192(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm10, 256(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm6, 320(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm1, 384(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm11, 448(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm7, 512(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm0, 576(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm19, 640(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm16, 704(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm13, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <32 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i64>, ptr %in.vecptr2, align 64
  %1 = shufflevector <32 x i64> %in.vec0, <32 x i64> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i64> %in.vec2, <32 x i64> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <64 x i64> %1, <64 x i64> %2, <96 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95>
  %interleaved.vec = shufflevector <96 x i64> %3, <96 x i64> poison, <96 x i32> <i32 0, i32 32, i32 64, i32 1, i32 33, i32 65, i32 2, i32 34, i32 66, i32 3, i32 35, i32 67, i32 4, i32 36, i32 68, i32 5, i32 37, i32 69, i32 6, i32 38, i32 70, i32 7, i32 39, i32 71, i32 8, i32 40, i32 72, i32 9, i32 41, i32 73, i32 10, i32 42, i32 74, i32 11, i32 43, i32 75, i32 12, i32 44, i32 76, i32 13, i32 45, i32 77, i32 14, i32 46, i32 78, i32 15, i32 47, i32 79, i32 16, i32 48, i32 80, i32 17, i32 49, i32 81, i32 18, i32 50, i32 82, i32 19, i32 51, i32 83, i32 20, i32 52, i32 84, i32 21, i32 53, i32 85, i32 22, i32 54, i32 86, i32 23, i32 55, i32 87, i32 24, i32 56, i32 88, i32 25, i32 57, i32 89, i32 26, i32 58, i32 90, i32 27, i32 59, i32 91, i32 28, i32 60, i32 92, i32 29, i32 61, i32 93, i32 30, i32 62, i32 94, i32 31, i32 63, i32 95>
  store <96 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride3_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride3_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1176, %rsp # imm = 0x498
; SSE-NEXT:    movapd 64(%rdi), %xmm8
; SSE-NEXT:    movapd (%rdi), %xmm5
; SSE-NEXT:    movapd 16(%rdi), %xmm6
; SSE-NEXT:    movapd 32(%rdi), %xmm7
; SSE-NEXT:    movapd 48(%rdi), %xmm9
; SSE-NEXT:    movapd 64(%rsi), %xmm13
; SSE-NEXT:    movapd (%rsi), %xmm10
; SSE-NEXT:    movapd 16(%rsi), %xmm11
; SSE-NEXT:    movapd 32(%rsi), %xmm12
; SSE-NEXT:    movapd 48(%rsi), %xmm14
; SSE-NEXT:    movapd 64(%rdx), %xmm0
; SSE-NEXT:    movapd (%rdx), %xmm1
; SSE-NEXT:    movapd 16(%rdx), %xmm2
; SSE-NEXT:    movapd 32(%rdx), %xmm3
; SSE-NEXT:    movapd 48(%rdx), %xmm4
; SSE-NEXT:    movapd %xmm5, %xmm15
; SSE-NEXT:    unpcklpd {{.*#+}} xmm15 = xmm15[0],xmm10[0]
; SSE-NEXT:    movapd %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm1[0],xmm5[1]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm1[1]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm6, %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm11[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm2[0],xmm6[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm2[1]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm7, %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm12[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm3[0],xmm7[1]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm3[1]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm9, %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm14[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm4[0],xmm9[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm4[1]
; SSE-NEXT:    movapd %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm8, %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm13[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm0[0],xmm8[1]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movapd %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rdi), %xmm1
; SSE-NEXT:    movapd 80(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rdi), %xmm1
; SSE-NEXT:    movapd 96(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rdi), %xmm1
; SSE-NEXT:    movapd 112(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rdi), %xmm1
; SSE-NEXT:    movapd 128(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rdi), %xmm1
; SSE-NEXT:    movapd 144(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rdi), %xmm1
; SSE-NEXT:    movapd 160(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%rdi), %xmm1
; SSE-NEXT:    movapd 176(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%rdi), %xmm1
; SSE-NEXT:    movapd 192(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%rdi), %xmm1
; SSE-NEXT:    movapd 208(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 224(%rdi), %xmm1
; SSE-NEXT:    movapd 224(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 224(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rdi), %xmm1
; SSE-NEXT:    movapd 240(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rdi), %xmm1
; SSE-NEXT:    movapd 256(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 272(%rdi), %xmm1
; SSE-NEXT:    movapd 272(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 272(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rdi), %xmm1
; SSE-NEXT:    movapd 288(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rdi), %xmm1
; SSE-NEXT:    movapd 304(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rdi), %xmm1
; SSE-NEXT:    movapd 320(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rdi), %xmm1
; SSE-NEXT:    movapd 336(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%rdi), %xmm1
; SSE-NEXT:    movapd 352(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rdi), %xmm1
; SSE-NEXT:    movapd 368(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 384(%rdi), %xmm1
; SSE-NEXT:    movapd 384(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movapd 384(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rdi), %xmm1
; SSE-NEXT:    movapd 400(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%rdi), %xmm1
; SSE-NEXT:    movapd 416(%rsi), %xmm15
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm15[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movapd 432(%rdi), %xmm14
; SSE-NEXT:    movapd 432(%rsi), %xmm12
; SSE-NEXT:    movapd %xmm14, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm12[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 432(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm14 = xmm0[0],xmm14[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movapd 448(%rdi), %xmm9
; SSE-NEXT:    movapd 448(%rsi), %xmm8
; SSE-NEXT:    movapd %xmm9, %xmm13
; SSE-NEXT:    unpcklpd {{.*#+}} xmm13 = xmm13[0],xmm8[0]
; SSE-NEXT:    movapd 448(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm0[0],xmm9[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movapd 464(%rdi), %xmm10
; SSE-NEXT:    movapd 464(%rsi), %xmm7
; SSE-NEXT:    movapd %xmm10, %xmm11
; SSE-NEXT:    unpcklpd {{.*#+}} xmm11 = xmm11[0],xmm7[0]
; SSE-NEXT:    movapd 464(%rdx), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm0[0],xmm10[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm0[1]
; SSE-NEXT:    movapd 480(%rdi), %xmm4
; SSE-NEXT:    movapd 480(%rsi), %xmm3
; SSE-NEXT:    movapd %xmm4, %xmm6
; SSE-NEXT:    unpcklpd {{.*#+}} xmm6 = xmm6[0],xmm3[0]
; SSE-NEXT:    movapd 480(%rdx), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm2[0],xmm4[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movapd 496(%rdi), %xmm2
; SSE-NEXT:    movapd 496(%rsi), %xmm0
; SSE-NEXT:    movapd %xmm2, %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movapd 496(%rdx), %xmm5
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm5[0],xmm2[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm5[1]
; SSE-NEXT:    movapd %xmm0, 1520(%rcx)
; SSE-NEXT:    movapd %xmm2, 1504(%rcx)
; SSE-NEXT:    movapd %xmm1, 1488(%rcx)
; SSE-NEXT:    movapd %xmm3, 1472(%rcx)
; SSE-NEXT:    movapd %xmm4, 1456(%rcx)
; SSE-NEXT:    movapd %xmm6, 1440(%rcx)
; SSE-NEXT:    movapd %xmm7, 1424(%rcx)
; SSE-NEXT:    movapd %xmm10, 1408(%rcx)
; SSE-NEXT:    movapd %xmm11, 1392(%rcx)
; SSE-NEXT:    movapd %xmm8, 1376(%rcx)
; SSE-NEXT:    movapd %xmm9, 1360(%rcx)
; SSE-NEXT:    movapd %xmm13, 1344(%rcx)
; SSE-NEXT:    movapd %xmm12, 1328(%rcx)
; SSE-NEXT:    movapd %xmm14, 1312(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1296(%rcx)
; SSE-NEXT:    movapd %xmm15, 1280(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1232(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1216(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1200(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1168(%rcx)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1136(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1120(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1072(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1056(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1040(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1024(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1008(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 976(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 960(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 912(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 896(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    addq $1176, %rsp # imm = 0x498
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride3_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $1480, %rsp # imm = 0x5C8
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 128(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 192(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 224(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 256(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 256(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 288(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 288(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 320(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 320(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 352(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 352(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 384(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 384(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 416(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 416(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 448(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 448(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 480(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 480(%rdx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd (%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovupd %ymm2, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 16(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovapd (%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 32(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 48(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovapd 32(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 64(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 80(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovapd 64(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 96(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 112(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovapd 96(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 128(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 144(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovapd 128(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 160(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 176(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovapd 160(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 192(%rdx), %ymm14
; AVX1-ONLY-NEXT:    vmovapd 208(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vmovapd 192(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm14[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 224(%rdx), %ymm13
; AVX1-ONLY-NEXT:    vmovapd 240(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm13[2,3]
; AVX1-ONLY-NEXT:    vmovapd 224(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm13[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 256(%rdx), %ymm11
; AVX1-ONLY-NEXT:    vmovapd 272(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm11[2,3]
; AVX1-ONLY-NEXT:    vmovapd 256(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm11[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 288(%rdx), %ymm9
; AVX1-ONLY-NEXT:    vmovapd 304(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm9[2,3]
; AVX1-ONLY-NEXT:    vmovapd 288(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm9[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 320(%rdx), %ymm7
; AVX1-ONLY-NEXT:    vmovapd 336(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovapd 320(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm7[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 352(%rdx), %ymm6
; AVX1-ONLY-NEXT:    vmovapd 368(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vmovapd 352(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm6[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 384(%rdx), %ymm5
; AVX1-ONLY-NEXT:    vmovapd 400(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovapd 384(%rsi), %ymm12
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm12[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm5[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 416(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vmovapd 432(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovapd 416(%rsi), %ymm10
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm10[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm3[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 448(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovapd 464(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovapd 448(%rsi), %ymm8
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm4 = ymm8[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm4[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm4[0],ymm0[1],ymm4[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 480(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vmovapd 496(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm4[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovapd 480(%rsi), %ymm4
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm15 = ymm4[0,0,3,2]
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm1[2,3],ymm15[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm15[0],ymm0[1],ymm15[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2],ymm0[3]
; AVX1-ONLY-NEXT:    vblendpd $2, (%rsp), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2],ymm0[3]
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2],ymm0[3]
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2],ymm0[3]
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2],ymm0[3]
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2],ymm0[3]
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm15 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm15 = ymm15[0,1],mem[2],ymm15[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm15 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm15 = ymm15[0,1],mem[2],ymm15[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm13 = ymm15[0],ymm13[1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm15 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm15 = ymm15[0,1],mem[2],ymm15[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm11 = ymm15[0],ymm11[1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm15 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm15 = ymm15[0,1],mem[2],ymm15[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm9 = ymm15[0],ymm9[1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm15 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm15 = ymm15[0,1],mem[2],ymm15[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm15[0],ymm7[1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm15 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm15 = ymm15[0,1],mem[2],ymm15[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm15[0],ymm6[1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm12 = ymm12[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm12 = ymm12[0,1],mem[2],ymm12[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm12[0],ymm5[1],ymm12[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm10 = ymm10[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm10 = ymm10[0,1],mem[2],ymm10[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm10[0],ymm3[1],ymm10[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm8 = ymm8[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm8[0,1],mem[2],ymm8[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm8[0],ymm2[1],ymm8[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0,1],mem[2],ymm4[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm4[0],ymm1[1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1504(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm1, 1472(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 1408(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm2, 1376(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 1312(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm3, 1280(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 1216(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm5, 1184(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 1120(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm6, 1088(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 1024(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm7, 992(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 928(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm9, 896(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 832(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm11, 800(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 736(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm13, 704(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 640(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm14, 608(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 544(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 512(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 448(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1440(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1344(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1248(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1152(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1056(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 960(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 864(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 768(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 576(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rcx)
; AVX1-ONLY-NEXT:    addq $1480, %rsp # imm = 0x5C8
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride3_vf64:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $936, %rsp # imm = 0x3A8
; AVX2-ONLY-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm5
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm11
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %ymm6
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %ymm4
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %ymm12
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %ymm13
; AVX2-ONLY-NEXT:    vmovaps 64(%rdx), %ymm10
; AVX2-ONLY-NEXT:    vmovaps 96(%rdx), %ymm7
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm14 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm15 = ymm8[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3],ymm15[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd (%rdx), %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm14 = ymm11[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm8[4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm12[2,3],ymm14[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm8 = ymm8[1],ymm11[1],ymm8[3],ymm11[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm11 = ymm12[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0,1],ymm8[2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm8 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm11 = ymm5[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0,1],ymm8[2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 32(%rdx), %ymm11
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm11[4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm8 = ymm9[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm5[4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm13[2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm5[1],ymm9[1],ymm5[3],ymm9[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm8 = ymm13[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1],ymm5[2,3,4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm5 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm8 = ymm3[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1],ymm5[2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 64(%rdx), %ymm8
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm8[4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm5 = ymm6[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm3[4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm10[2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm6[1],ymm3[3],ymm6[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm5 = ymm10[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1],ymm3[2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm5 = ymm2[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1],ymm3[2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 96(%rdx), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm5[4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm2[4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm7[2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm4[1],ymm2[3],ymm4[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm3 = ymm7[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm3 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 128(%rdx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps 128(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 160(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps 160(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 192(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps 192(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 224(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps 224(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 256(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps 256(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 288(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps 288(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 320(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps 320(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 352(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 352(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps 352(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps 352(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps 384(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 384(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps 384(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps 384(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps 416(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 416(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps 416(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovaps 416(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps 448(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm15 = ymm0[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm15[0,1],ymm1[2,3],ymm15[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 448(%rdx), %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm15[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovaps 448(%rsi), %ymm15
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm14 = ymm15[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm0[4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm15[1],ymm0[3],ymm15[3]
; AVX2-ONLY-NEXT:    vmovaps 448(%rdx), %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3],ymm14[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm15[0,1],ymm0[2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovaps 480(%rdi), %ymm15
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm13 = ymm15[0,1,2,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm13[0,1],ymm0[2,3],ymm13[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 480(%rdx), %ymm13
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm13[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 480(%rsi), %ymm13
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm12 = ymm13[2,3,0,1,6,7,4,5]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm15[4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm15[1],ymm13[1],ymm15[3],ymm13[3]
; AVX2-ONLY-NEXT:    vmovaps 480(%rdx), %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1],ymm15[2,3],ymm12[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[0,2,3,3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,1,2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0,1],ymm13[2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm13, 1504(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm12, 1472(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1440(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 1408(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm14, 1376(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 1344(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 1312(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 1280(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 1248(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 1216(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 1184(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 1152(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 1120(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 1088(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 1056(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1024(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 992(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 960(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 928(%rcx)
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 896(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 864(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 832(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 800(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 768(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 736(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 704(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 672(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 640(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 608(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 576(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 544(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 512(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 480(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 448(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 416(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 384(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 224(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-ONLY-NEXT:    addq $936, %rsp # imm = 0x3A8
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride3_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512-NEXT:    vmovdqa64 384(%rdi), %zmm11
; AVX512-NEXT:    vmovdqa64 320(%rdi), %zmm16
; AVX512-NEXT:    vmovdqa64 256(%rdi), %zmm24
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm13
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm20
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm27
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm30
; AVX512-NEXT:    vmovdqa64 448(%rsi), %zmm9
; AVX512-NEXT:    vmovdqa64 384(%rsi), %zmm8
; AVX512-NEXT:    vmovdqa64 320(%rsi), %zmm7
; AVX512-NEXT:    vmovdqa64 256(%rsi), %zmm4
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm1
; AVX512-NEXT:    vmovdqa64 128(%rsi), %zmm2
; AVX512-NEXT:    vmovdqa64 192(%rsi), %zmm6
; AVX512-NEXT:    vmovdqa64 448(%rdx), %zmm12
; AVX512-NEXT:    vmovdqa64 384(%rdx), %zmm18
; AVX512-NEXT:    vmovdqa64 320(%rdx), %zmm26
; AVX512-NEXT:    vmovdqa64 256(%rdx), %zmm28
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm15
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm25
; AVX512-NEXT:    vmovdqa64 128(%rdx), %zmm29
; AVX512-NEXT:    vmovdqa64 192(%rdx), %zmm31
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [0,8,u,1,9,u,2,10]
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm3
; AVX512-NEXT:    vpermt2q %zmm0, %zmm14, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm19 = [0,1,8,3,4,9,6,7]
; AVX512-NEXT:    vpermt2q %zmm15, %zmm19, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [u,3,11,u,4,12,u,5]
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm10
; AVX512-NEXT:    vpermt2q %zmm0, %zmm17, %zmm10
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm21 = [10,1,2,11,4,5,12,7]
; AVX512-NEXT:    vpermt2q %zmm15, %zmm21, %zmm10
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [5,u,14,6,u,15,7,u]
; AVX512-NEXT:    vpermt2q %zmm13, %zmm22, %zmm0
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm23 = [0,13,2,3,14,5,6,15]
; AVX512-NEXT:    vpermt2q %zmm15, %zmm23, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm20, %zmm13
; AVX512-NEXT:    vpermt2q %zmm1, %zmm14, %zmm13
; AVX512-NEXT:    vpermt2q %zmm25, %zmm19, %zmm13
; AVX512-NEXT:    vmovdqa64 %zmm20, %zmm15
; AVX512-NEXT:    vpermt2q %zmm1, %zmm17, %zmm15
; AVX512-NEXT:    vpermt2q %zmm25, %zmm21, %zmm15
; AVX512-NEXT:    vpermt2q %zmm20, %zmm22, %zmm1
; AVX512-NEXT:    vpermt2q %zmm25, %zmm23, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm27, %zmm20
; AVX512-NEXT:    vpermt2q %zmm2, %zmm14, %zmm20
; AVX512-NEXT:    vpermt2q %zmm29, %zmm19, %zmm20
; AVX512-NEXT:    vmovdqa64 %zmm27, %zmm25
; AVX512-NEXT:    vpermt2q %zmm2, %zmm17, %zmm25
; AVX512-NEXT:    vpermt2q %zmm29, %zmm21, %zmm25
; AVX512-NEXT:    vpermt2q %zmm27, %zmm22, %zmm2
; AVX512-NEXT:    vpermt2q %zmm29, %zmm23, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm30, %zmm27
; AVX512-NEXT:    vpermt2q %zmm6, %zmm14, %zmm27
; AVX512-NEXT:    vpermt2q %zmm31, %zmm19, %zmm27
; AVX512-NEXT:    vmovdqa64 %zmm30, %zmm29
; AVX512-NEXT:    vpermt2q %zmm6, %zmm17, %zmm29
; AVX512-NEXT:    vpermt2q %zmm31, %zmm21, %zmm29
; AVX512-NEXT:    vpermt2q %zmm30, %zmm22, %zmm6
; AVX512-NEXT:    vpermt2q %zmm31, %zmm23, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm30
; AVX512-NEXT:    vpermt2q %zmm4, %zmm14, %zmm30
; AVX512-NEXT:    vpermt2q %zmm28, %zmm19, %zmm30
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm31
; AVX512-NEXT:    vpermt2q %zmm4, %zmm17, %zmm31
; AVX512-NEXT:    vpermt2q %zmm28, %zmm21, %zmm31
; AVX512-NEXT:    vpermt2q %zmm24, %zmm22, %zmm4
; AVX512-NEXT:    vpermt2q %zmm28, %zmm23, %zmm4
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm24
; AVX512-NEXT:    vpermt2q %zmm7, %zmm14, %zmm24
; AVX512-NEXT:    vpermt2q %zmm26, %zmm19, %zmm24
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm28
; AVX512-NEXT:    vpermt2q %zmm7, %zmm17, %zmm28
; AVX512-NEXT:    vpermt2q %zmm26, %zmm21, %zmm28
; AVX512-NEXT:    vpermt2q %zmm16, %zmm22, %zmm7
; AVX512-NEXT:    vpermt2q %zmm26, %zmm23, %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512-NEXT:    vpermt2q %zmm8, %zmm14, %zmm16
; AVX512-NEXT:    vpermt2q %zmm18, %zmm19, %zmm16
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm26
; AVX512-NEXT:    vpermt2q %zmm8, %zmm17, %zmm26
; AVX512-NEXT:    vpermt2q %zmm18, %zmm21, %zmm26
; AVX512-NEXT:    vpermt2q %zmm11, %zmm22, %zmm8
; AVX512-NEXT:    vpermt2q %zmm18, %zmm23, %zmm8
; AVX512-NEXT:    vpermi2q %zmm9, %zmm5, %zmm14
; AVX512-NEXT:    vpermt2q %zmm12, %zmm19, %zmm14
; AVX512-NEXT:    vpermi2q %zmm9, %zmm5, %zmm17
; AVX512-NEXT:    vpermt2q %zmm12, %zmm21, %zmm17
; AVX512-NEXT:    vpermt2q %zmm5, %zmm22, %zmm9
; AVX512-NEXT:    vpermt2q %zmm12, %zmm23, %zmm9
; AVX512-NEXT:    vmovdqa64 %zmm9, 1472(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm17, 1408(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm14, 1344(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm8, 1280(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm26, 1216(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm16, 1152(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm7, 1088(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm28, 1024(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm24, 960(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm4, 896(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm31, 832(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm30, 768(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm6, 704(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm29, 640(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm27, 576(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm2, 512(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm25, 448(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm20, 384(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm1, 320(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm15, 256(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm13, 192(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm10, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <64 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i64>, ptr %in.vecptr2, align 64
  %1 = shufflevector <64 x i64> %in.vec0, <64 x i64> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i64> %in.vec2, <64 x i64> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <128 x i64> %1, <128 x i64> %2, <192 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191>
  %interleaved.vec = shufflevector <192 x i64> %3, <192 x i64> poison, <192 x i32> <i32 0, i32 64, i32 128, i32 1, i32 65, i32 129, i32 2, i32 66, i32 130, i32 3, i32 67, i32 131, i32 4, i32 68, i32 132, i32 5, i32 69, i32 133, i32 6, i32 70, i32 134, i32 7, i32 71, i32 135, i32 8, i32 72, i32 136, i32 9, i32 73, i32 137, i32 10, i32 74, i32 138, i32 11, i32 75, i32 139, i32 12, i32 76, i32 140, i32 13, i32 77, i32 141, i32 14, i32 78, i32 142, i32 15, i32 79, i32 143, i32 16, i32 80, i32 144, i32 17, i32 81, i32 145, i32 18, i32 82, i32 146, i32 19, i32 83, i32 147, i32 20, i32 84, i32 148, i32 21, i32 85, i32 149, i32 22, i32 86, i32 150, i32 23, i32 87, i32 151, i32 24, i32 88, i32 152, i32 25, i32 89, i32 153, i32 26, i32 90, i32 154, i32 27, i32 91, i32 155, i32 28, i32 92, i32 156, i32 29, i32 93, i32 157, i32 30, i32 94, i32 158, i32 31, i32 95, i32 159, i32 32, i32 96, i32 160, i32 33, i32 97, i32 161, i32 34, i32 98, i32 162, i32 35, i32 99, i32 163, i32 36, i32 100, i32 164, i32 37, i32 101, i32 165, i32 38, i32 102, i32 166, i32 39, i32 103, i32 167, i32 40, i32 104, i32 168, i32 41, i32 105, i32 169, i32 42, i32 106, i32 170, i32 43, i32 107, i32 171, i32 44, i32 108, i32 172, i32 45, i32 109, i32 173, i32 46, i32 110, i32 174, i32 47, i32 111, i32 175, i32 48, i32 112, i32 176, i32 49, i32 113, i32 177, i32 50, i32 114, i32 178, i32 51, i32 115, i32 179, i32 52, i32 116, i32 180, i32 53, i32 117, i32 181, i32 54, i32 118, i32 182, i32 55, i32 119, i32 183, i32 56, i32 120, i32 184, i32 57, i32 121, i32 185, i32 58, i32 122, i32 186, i32 59, i32 123, i32 187, i32 60, i32 124, i32 188, i32 61, i32 125, i32 189, i32 62, i32 126, i32 190, i32 63, i32 127, i32 191>
  store <192 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX: {{.*}}
; AVX1: {{.*}}
; AVX2: {{.*}}
; AVX2-FAST: {{.*}}
; AVX2-FAST-PERLANE: {{.*}}
; AVX2-SLOW: {{.*}}
; AVX512-FAST: {{.*}}
; AVX512-SLOW: {{.*}}
; AVX512BW: {{.*}}
; AVX512BW-FAST: {{.*}}
; AVX512BW-ONLY: {{.*}}
; AVX512BW-ONLY-FAST: {{.*}}
; AVX512BW-ONLY-SLOW: {{.*}}
; AVX512BW-SLOW: {{.*}}
; AVX512DQ-FAST: {{.*}}
; AVX512DQ-ONLY: {{.*}}
; AVX512DQ-SLOW: {{.*}}
; AVX512DQBW-FAST: {{.*}}
; AVX512DQBW-ONLY: {{.*}}
; AVX512DQBW-SLOW: {{.*}}
; AVX512F: {{.*}}
; AVX512F-FAST: {{.*}}
; AVX512F-ONLY: {{.*}}
; AVX512F-ONLY-FAST: {{.*}}
; AVX512F-ONLY-SLOW: {{.*}}
; AVX512F-SLOW: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK10: {{.*}}
; FALLBACK11: {{.*}}
; FALLBACK12: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; FALLBACK8: {{.*}}
; FALLBACK9: {{.*}}
