; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine  -S < %s | FileCheck %s

declare i32 @memcmp(ptr nocapture, ptr nocapture, i64)
declare ptr @memcpy(ptr nocapture, ptr nocapture, i64)
declare ptr @memmove(ptr nocapture, ptr nocapture, i64)
declare ptr @memset(ptr nocapture, i32, i64)
declare ptr @memchr(ptr nocapture, i32, i64)
declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1)
declare void @llvm.memmove.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1)
declare void @llvm.memset.p0.i64(ptr nocapture, i8, i64, i1)

define i32 @memcmp_const_size_set_deref(ptr nocapture readonly %d, ptr nocapture readonly %s) {
; CHECK-LABEL: @memcmp_const_size_set_deref(
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @memcmp(ptr noundef nonnull dereferenceable(16) [[D:%.*]], ptr noundef nonnull dereferenceable(16) [[S:%.*]], i64 16)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = tail call i32 @memcmp(ptr %d, ptr %s, i64 16)
  ret i32 %call
}

define i32 @memcmp_const_size_update_deref(ptr nocapture readonly %d, ptr nocapture readonly %s) {
; CHECK-LABEL: @memcmp_const_size_update_deref(
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @memcmp(ptr noundef nonnull dereferenceable(16) [[D:%.*]], ptr noundef nonnull dereferenceable(16) [[S:%.*]], i64 16)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = tail call i32 @memcmp(ptr dereferenceable(4) %d, ptr dereferenceable(8) %s, i64 16)
  ret i32 %call
}

define i32 @memcmp_const_size_update_deref2(ptr nocapture readonly %d, ptr nocapture readonly %s) {
; CHECK-LABEL: @memcmp_const_size_update_deref2(
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @memcmp(ptr noundef nonnull dereferenceable(16) [[D:%.*]], ptr noundef nonnull dereferenceable(16) [[S:%.*]], i64 16)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = tail call i32 @memcmp(ptr %d, ptr dereferenceable_or_null(8) %s, i64 16)
  ret i32 %call
}

define i32 @memcmp_const_size_update_deref3(ptr nocapture readonly %d, ptr nocapture readonly %s) {
; CHECK-LABEL: @memcmp_const_size_update_deref3(
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @memcmp(ptr noundef nonnull dereferenceable(40) [[D:%.*]], ptr noundef nonnull dereferenceable(16) [[S:%.*]], i64 16)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = tail call i32 @memcmp(ptr dereferenceable(40) %d, ptr %s, i64 16)
  ret i32 %call
}

define i32 @memcmp_const_size_update_deref4(ptr nocapture readonly %d, ptr nocapture readonly %s) {
; CHECK-LABEL: @memcmp_const_size_update_deref4(
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @memcmp(ptr noundef nonnull dereferenceable(16) [[D:%.*]], ptr noundef nonnull dereferenceable(16) [[S:%.*]], i64 16)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = tail call i32 @memcmp(ptr dereferenceable_or_null(16) %d, ptr %s, i64 16)
  ret i32 %call
}

define i32 @memcmp_const_size_update_deref5(ptr nocapture readonly %d, ptr nocapture readonly %s) {
; CHECK-LABEL: @memcmp_const_size_update_deref5(
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @memcmp(ptr noundef nonnull dereferenceable(40) [[D:%.*]], ptr noundef nonnull dereferenceable(16) [[S:%.*]], i64 16)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = tail call i32 @memcmp(ptr dereferenceable_or_null(40) %d, ptr %s, i64 16)
  ret i32 %call
}

define i32 @memcmp_const_size_update_deref6(ptr nocapture readonly %d, ptr nocapture readonly %s) null_pointer_is_valid {
; CHECK-LABEL: @memcmp_const_size_update_deref6(
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @memcmp(ptr noundef dereferenceable(16) dereferenceable_or_null(40) [[D:%.*]], ptr noundef dereferenceable(16) [[S:%.*]], i64 16)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = tail call i32 @memcmp(ptr dereferenceable_or_null(40) %d, ptr %s, i64 16)
  ret i32 %call
}

define i32 @memcmp_const_size_update_deref7(ptr nocapture readonly %d, ptr nocapture readonly %s) null_pointer_is_valid {
; CHECK-LABEL: @memcmp_const_size_update_deref7(
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @memcmp(ptr noundef nonnull dereferenceable(40) [[D:%.*]], ptr noundef dereferenceable(16) [[S:%.*]], i64 16)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = tail call i32 @memcmp(ptr nonnull dereferenceable_or_null(40) %d, ptr %s, i64 16)
  ret i32 %call
}

define i32 @memcmp_const_size_no_update_deref(ptr nocapture readonly %d, ptr nocapture readonly %s) {
; CHECK-LABEL: @memcmp_const_size_no_update_deref(
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @memcmp(ptr noundef nonnull dereferenceable(40) [[D:%.*]], ptr noundef nonnull dereferenceable(20) [[S:%.*]], i64 16)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = tail call i32 @memcmp(ptr dereferenceable(40) %d, ptr dereferenceable(20) %s, i64 16)
  ret i32 %call
}

define i32 @memcmp_nonconst_size(ptr nocapture readonly %d, ptr nocapture readonly %s, i64 %n) {
; CHECK-LABEL: @memcmp_nonconst_size(
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @memcmp(ptr [[D:%.*]], ptr [[S:%.*]], i64 [[N:%.*]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = tail call i32 @memcmp(ptr %d, ptr %s, i64 %n)
  ret i32 %call
}

define ptr @memcpy_const_size_set_deref(ptr nocapture readonly %d, ptr nocapture readonly %s) {
; CHECK-LABEL: @memcpy_const_size_set_deref(
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(64) [[D:%.*]], ptr noundef nonnull align 1 dereferenceable(64) [[S:%.*]], i64 64, i1 false)
; CHECK-NEXT:    ret ptr [[D]]
;
  %call = tail call ptr @memcpy(ptr %d, ptr %s, i64 64)
  ret ptr %call
}

define ptr @memmove_const_size_set_deref(ptr nocapture readonly %d, ptr nocapture readonly %s) {
; CHECK-LABEL: @memmove_const_size_set_deref(
; CHECK-NEXT:    tail call void @llvm.memmove.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(64) [[D:%.*]], ptr noundef nonnull align 1 dereferenceable(64) [[S:%.*]], i64 64, i1 false)
; CHECK-NEXT:    ret ptr [[D]]
;
  %call = tail call ptr @memmove(ptr %d, ptr %s, i64 64)
  ret ptr %call
}

define ptr @memset_const_size_set_deref(ptr nocapture readonly %s, i32 %c) {
; CHECK-LABEL: @memset_const_size_set_deref(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[C:%.*]] to i8
; CHECK-NEXT:    tail call void @llvm.memset.p0.i64(ptr noundef nonnull align 1 dereferenceable(64) [[S:%.*]], i8 [[TMP1]], i64 64, i1 false)
; CHECK-NEXT:    ret ptr [[S]]
;
  %call = tail call ptr @memset(ptr %s, i32 %c, i64 64)
  ret ptr %call
}

define ptr @memchr_const_size_set_deref(ptr nocapture readonly %s, i32 %c) {
; CHECK-LABEL: @memchr_const_size_set_deref(
; CHECK-NEXT:    [[CALL:%.*]] = tail call ptr @memchr(ptr noundef nonnull dereferenceable(1) [[S:%.*]], i32 [[C:%.*]], i64 64)
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = tail call ptr @memchr(ptr %s, i32 %c, i64 64)
  ret ptr %call
}

define ptr @llvm_memcpy_const_size_set_deref(ptr nocapture readonly %d, ptr nocapture readonly %s) {
; CHECK-LABEL: @llvm_memcpy_const_size_set_deref(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(16) [[D:%.*]], ptr noundef nonnull align 1 dereferenceable(16) [[S:%.*]], i64 16, i1 false)
; CHECK-NEXT:    ret ptr [[D]]
;
  call void @llvm.memcpy.p0.p0.i64(ptr align 1 %d, ptr align 1 %s, i64 16, i1 false)
  ret ptr %d
}

define ptr @llvm_memmove_const_size_set_deref(ptr nocapture readonly %d, ptr nocapture readonly %s) {
; CHECK-LABEL: @llvm_memmove_const_size_set_deref(
; CHECK-NEXT:    call void @llvm.memmove.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(16) [[D:%.*]], ptr noundef nonnull align 1 dereferenceable(16) [[S:%.*]], i64 16, i1 false)
; CHECK-NEXT:    ret ptr [[D]]
;
  call void @llvm.memmove.p0.p0.i64(ptr align 1 %d, ptr align 1 %s, i64 16, i1 false)
  ret ptr %d
}
define ptr @llvm_memset_const_size_set_deref(ptr nocapture readonly %s, i8 %c) {
; CHECK-LABEL: @llvm_memset_const_size_set_deref(
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr noundef nonnull align 1 dereferenceable(16) [[S:%.*]], i8 [[C:%.*]], i64 16, i1 false)
; CHECK-NEXT:    ret ptr [[S]]
;
  call void @llvm.memset.p0.i64(ptr align 1 %s, i8 %c, i64 16, i1 false)
  ret ptr %s
}
