; RUN: llvm-mc -arch=amdgcn -mcpu=gfx1200 -show-encoding %s | FileCheck --check-prefixes=GFX12 %s

image_sample v64, v32, s[4:11], s[100:103] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x46,0xe4,0x40,0x08,0x00,0x32,0x20,0x00,0x00,0x00]

image_sample v64, [v32, v33], s[4:11], s[100:103] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x06,0xe6,0x40,0x08,0x00,0x32,0x20,0x21,0x00,0x00]

image_sample v[64:65], [v32, v33, v34], s[4:11], s[100:103] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0xc6,0xe4,0x40,0x08,0x00,0x32,0x20,0x21,0x22,0x00]

image_sample v[64:65], [v32, v33, v34], s[4:11], s[100:103] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x06,0xe7,0x40,0x08,0x00,0x32,0x20,0x21,0x22,0x00]

image_sample v[64:66], [v32, v33], s[4:11], s[100:103] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xc6,0xe6,0x40,0x08,0x00,0x32,0x20,0x21,0x00,0x00]

image_sample v[64:67], [v32, v33, v34], s[4:11], s[100:103] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xc6,0xe7,0x40,0x08,0x00,0x32,0x20,0x21,0x22,0x00]

image_sample v0, v1, s[0:7], s[100:103] dmask:0x2 dim:SQ_RSRC_IMG_1D a16
// GFX12: encoding: [0x40,0xc0,0x86,0xe4,0x00,0x00,0x00,0x32,0x01,0x00,0x00,0x00]

image_sample v2, v3, s[4:11], s[96:99] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0xc0,0x06,0xe5,0x02,0x08,0x00,0x30,0x03,0x00,0x00,0x00]

image_sample v[4:5], [v6, v7], s[8:15], s[92:95] dmask:0x6 dim:SQ_RSRC_IMG_3D a16
// GFX12: encoding: [0x42,0xc0,0x86,0xe5,0x04,0x10,0x00,0x2e,0x06,0x07,0x00,0x00]

image_sample v[8:9], [v10, v11], s[12:19], s[88:91] dmask:0x9 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0xc0,0x46,0xe6,0x08,0x18,0x00,0x2c,0x0a,0x0b,0x00,0x00]

image_sample v[12:14], v15, s[16:23], s[84:87] dmask:0x7 dim:SQ_RSRC_IMG_1D_ARRAY a16
// GFX12: encoding: [0x44,0xc0,0xc6,0xe5,0x0c,0x20,0x00,0x2a,0x0f,0x00,0x00,0x00]

image_sample v[16:19], [v20, v21], s[20:27], s[80:83] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0xc0,0xc6,0xe7,0x10,0x28,0x00,0x28,0x14,0x15,0x00,0x00]

image_sample v[22:24], v25, s[24:31], s[76:79] dmask:0xd dim:SQ_RSRC_IMG_1D unorm
// GFX12: encoding: [0x00,0xe0,0x46,0xe7,0x16,0x30,0x00,0x26,0x19,0x00,0x00,0x00]

// FIXME: This test is incorrect because r128 assumes a 128-bit SRSRC.
image_sample v[22:24], v25, s[24:31], s[76:79] dmask:0xd dim:SQ_RSRC_IMG_1D r128
// GFX12: encoding: [0x10,0xc0,0x46,0xe7,0x16,0x30,0x00,0x26,0x19,0x00,0x00,0x00]

image_sample v26, [v27, v28], s[28:35], s[72:75] dmask:0x1 dim:SQ_RSRC_IMG_2D scope:SCOPE_CU
// GFX12: encoding: [0x01,0xc0,0x46,0xe4,0x1a,0x38,0x00,0x24,0x1b,0x1c,0x00,0x00]

image_sample v26, [v27, v28], s[28:35], s[72:75] dmask:0x2 dim:SQ_RSRC_IMG_2D scope:SCOPE_SE
// GFX12: encoding: [0x01,0xc0,0x86,0xe4,0x1a,0x38,0x04,0x24,0x1b,0x1c,0x00,0x00]

image_sample v26, [v27, v28], s[28:35], s[72:75] dmask:0x4 dim:SQ_RSRC_IMG_2D scope:SCOPE_DEV
// GFX12: encoding: [0x01,0xc0,0x06,0xe5,0x1a,0x38,0x08,0x24,0x1b,0x1c,0x00,0x00]

image_sample v26, [v27, v28], s[28:35], s[72:75] dmask:0x8 dim:SQ_RSRC_IMG_2D scope:SCOPE_SYS
// GFX12: encoding: [0x01,0xc0,0x06,0xe6,0x1a,0x38,0x0c,0x24,0x1b,0x1c,0x00,0x00]

image_sample v[29:30], [v31, v32, v33], s[32:39], s[68:71] dmask:0x3 dim:SQ_RSRC_IMG_3D th:TH_LOAD_RT
// GFX12: encoding: [0x02,0xc0,0xc6,0xe4,0x1d,0x40,0x00,0x22,0x1f,0x20,0x21,0x00]

image_sample v[29:30], [v31, v32, v33], s[32:39], s[68:71] dmask:0x5 dim:SQ_RSRC_IMG_3D th:TH_LOAD_NT
// GFX12: encoding: [0x02,0xc0,0x46,0xe5,0x1d,0x40,0x10,0x22,0x1f,0x20,0x21,0x00]

image_sample v[29:30], [v31, v32, v33], s[32:39], s[68:71] dmask:0x9 dim:SQ_RSRC_IMG_3D th:TH_LOAD_HT
// GFX12: encoding: [0x02,0xc0,0x46,0xe6,0x1d,0x40,0x20,0x22,0x1f,0x20,0x21,0x00]

image_sample v[29:30], [v31, v32, v33], s[32:39], s[68:71] dmask:0x6 dim:SQ_RSRC_IMG_3D th:TH_LOAD_LU
// GFX12: encoding: [0x02,0xc0,0x86,0xe5,0x1d,0x40,0x30,0x22,0x1f,0x20,0x21,0x00]

image_sample v[29:30], [v31, v32, v33], s[32:39], s[68:71] dmask:0xa dim:SQ_RSRC_IMG_3D th:TH_LOAD_NT_RT
// GFX12: encoding: [0x02,0xc0,0x86,0xe6,0x1d,0x40,0x40,0x22,0x1f,0x20,0x21,0x00]

image_sample v[29:30], [v31, v32, v33], s[32:39], s[68:71] dmask:0xc dim:SQ_RSRC_IMG_3D th:TH_LOAD_RT_NT
// GFX12: encoding: [0x02,0xc0,0x06,0xe7,0x1d,0x40,0x50,0x22,0x1f,0x20,0x21,0x00]

image_sample v[29:30], [v31, v32, v33], s[32:39], s[68:71] dmask:0x3 dim:SQ_RSRC_IMG_3D th:TH_LOAD_NT_HT
// GFX12: encoding: [0x02,0xc0,0xc6,0xe4,0x1d,0x40,0x60,0x22,0x1f,0x20,0x21,0x00]

image_sample v[29:30], [v31, v32, v33], s[32:39], s[68:71] dmask:0x5 dim:SQ_RSRC_IMG_3D th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x02,0xc0,0x46,0xe5,0x1d,0x40,0x3c,0x22,0x1f,0x20,0x21,0x00]

image_sample v[34:35], v37, s[36:43], s[64:67] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0xc6,0xe4,0x22,0x48,0x00,0x20,0x25,0x00,0x00,0x00]

image_sample v[34:36], v37, s[36:43], s[64:67] dmask:0x3 dim:SQ_RSRC_IMG_1D tfe
// GFX12: encoding: [0x08,0xc0,0xc6,0xe4,0x22,0x48,0x00,0x20,0x25,0x00,0x00,0x00]

image_sample v34, v37, s[36:43], s[64:67] dmask:0x3 dim:SQ_RSRC_IMG_1D d16
// GFX12: encoding: [0x20,0xc0,0xc6,0xe4,0x22,0x48,0x00,0x20,0x25,0x00,0x00,0x00]

image_sample v[34:35], v37, s[36:43], s[64:67] dmask:0x3 dim:SQ_RSRC_IMG_1D tfe d16
// GFX12: encoding: [0x28,0xc0,0xc6,0xe4,0x22,0x48,0x00,0x20,0x25,0x00,0x00,0x00]

image_sample v[34:35], v37, s[36:43], s[64:67] dmask:0x3 dim:SQ_RSRC_IMG_1D lwe
// GFX12: encoding: [0x00,0xc0,0xc6,0xe4,0x22,0x49,0x00,0x20,0x25,0x00,0x00,0x00]

// FIXME: This test is incorrect because r128 assumes a 128-bit SRSRC.
image_sample v[38:39], [v40, v41], s[40:47], s[60:63] dmask:0xc dim:SQ_RSRC_IMG_CUBE unorm th:TH_LOAD_HT scope:SCOPE_DEV r128 a16 tfe lwe d16
// GFX12: encoding: [0x7b,0xe0,0x06,0xe7,0x26,0x51,0x28,0x1e,0x28,0x29,0x00,0x00]

image_sample_d v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x47,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_d v64, [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x07,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d v[64:65], [v32, v33, v34, v[35:40]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xc7,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d v[64:65], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x07,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d v[64:66], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xc7,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d v[64:67], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xc7,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_l v64, [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x47,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_sample_l v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x07,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_l v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0xc7,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_l v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x07,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_l v[64:66], [v32, v33, v34], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xc7,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_l v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xc7,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b v64, [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x47,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_sample_b v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x07,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_b v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xc7,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x07,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b v[64:66], [v32, v33, v34], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xc7,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_b v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xc7,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_lz v64, v32, s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x47,0xe4,0x40,0x08,0x00,0x02,0x20,0x00,0x00,0x00]

image_sample_lz v64, [v32, v33], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x07,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_sample_lz v[64:65], [v32, v33, v34], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0xc7,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_lz v[64:65], [v32, v33, v34], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x07,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_lz v[64:66], [v32, v33], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xc7,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_sample_lz v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xc7,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_c v64, [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x48,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_sample_c v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x08,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_c v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xc8,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x08,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c v[64:66], [v32, v33, v34], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xc8,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_c v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xc8,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x48,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d v64, [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x08,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d v[64:65], [v32, v33, v34, v[35:41]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0xc8,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d v[64:65], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x08,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xc8,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d v[64:67], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xc8,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_l v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x48,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_c_l v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x08,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_l v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xc8,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_l v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x08,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_l v[64:66], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xc8,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_l v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xc8,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x48,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_c_b v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x08,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0xc8,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x08,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b v[64:66], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xc8,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xc8,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_lz v64, [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x49,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_sample_c_lz v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x09,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_c_lz v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xc9,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_lz v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x09,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_lz v[64:66], [v32, v33, v34], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xc9,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_c_lz v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xc9,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_o v64, [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x49,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_sample_o v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x09,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_o v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0xc9,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_o v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x09,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_o v[64:66], [v32, v33, v34], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xc9,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_o v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xc9,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x49,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o v64, [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x09,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o v[64:65], [v32, v33, v34, v[35:41]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xc9,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o v[64:65], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x09,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xc9,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o v[64:67], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xc9,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_l_o v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x49,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_l_o v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x09,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_l_o v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0xc9,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_l_o v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x09,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_l_o v[64:66], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xc9,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_l_o v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xc9,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_o v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x4a,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_b_o v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x0a,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_o v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xca,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_o v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x0a,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_o v[64:66], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xca,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_o v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xca,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_lz_o v64, [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x4a,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_sample_lz_o v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x0a,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_lz_o v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0xca,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_lz_o v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x0a,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_lz_o v[64:66], [v32, v33, v34], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xca,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_lz_o v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xca,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_o v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x4a,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_c_o v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x0a,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_o v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xca,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_o v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x0a,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_o v[64:66], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xca,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_o v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xca,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x4a,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o v64, [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x0a,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o v[64:65], [v32, v33, v34, v[35:42]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0xca,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o v[64:65], [v32, v33, v34, v[35:40]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x0a,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o v[64:66], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xca,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o v[64:67], [v32, v33, v34, v[35:40]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xca,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_l_o v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x4b,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_l_o v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x0b,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_l_o v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xcb,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_l_o v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x0b,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_l_o v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xcb,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_l_o v[64:67], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xcb,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_o v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x4b,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_o v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x0b,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_o v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0xcb,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_o v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x0b,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_o v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xcb,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_o v[64:67], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xcb,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_lz_o v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x4b,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_c_lz_o v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x0b,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_lz_o v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xcb,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_lz_o v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x0b,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_lz_o v[64:66], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xcb,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_lz_o v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xcb,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4 v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x4b,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4 v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x8b,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4 v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0x0b,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4 v[64:67], v32, s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0xc0,0x4b,0xe4,0x40,0x08,0x00,0x02,0x20,0x00,0x00,0x00]

image_gather4 v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0xc0,0x8b,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4 v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0xc0,0x0b,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4 v[0:3], [v4, v5], s[0:7], s[100:103] dmask:0x8 dim:SQ_RSRC_IMG_2D unorm
// GFX12: encoding: [0x01,0xe0,0x0b,0xe6,0x00,0x00,0x00,0x32,0x04,0x05,0x00,0x00]

// FIXME: This test is incorrect because r128 assumes a 128-bit SRSRC.
image_gather4 v[6:9], [v10, v11], s[8:15], s[96:99] dmask:0x1 dim:SQ_RSRC_IMG_2D r128
// GFX12: encoding: [0x11,0xc0,0x4b,0xe4,0x06,0x10,0x00,0x30,0x0a,0x0b,0x00,0x00]

image_gather4 v[12:15], [v16, v17], s[16:23], s[92:95] dmask:0x2 dim:SQ_RSRC_IMG_2D scope:SCOPE_CU
// GFX12: encoding: [0x01,0xc0,0x8b,0xe4,0x0c,0x20,0x00,0x2e,0x10,0x11,0x00,0x00]

image_gather4 v[12:15], [v16, v17], s[16:23], s[92:95] dmask:0x2 dim:SQ_RSRC_IMG_2D scope:SCOPE_SE
// GFX12: encoding: [0x01,0xc0,0x8b,0xe4,0x0c,0x20,0x04,0x2e,0x10,0x11,0x00,0x00]

image_gather4 v[12:15], [v16, v17], s[16:23], s[92:95] dmask:0x2 dim:SQ_RSRC_IMG_2D scope:SCOPE_DEV
// GFX12: encoding: [0x01,0xc0,0x8b,0xe4,0x0c,0x20,0x08,0x2e,0x10,0x11,0x00,0x00]

image_gather4 v[12:15], [v16, v17], s[16:23], s[92:95] dmask:0x2 dim:SQ_RSRC_IMG_2D scope:SCOPE_SYS
// GFX12: encoding: [0x01,0xc0,0x8b,0xe4,0x0c,0x20,0x0c,0x2e,0x10,0x11,0x00,0x00]

image_gather4 v[18:21], [v22, v23], s[24:31], s[88:91] dmask:0x4 dim:SQ_RSRC_IMG_2D th:TH_LOAD_RT
// GFX12: encoding: [0x01,0xc0,0x0b,0xe5,0x12,0x30,0x00,0x2c,0x16,0x17,0x00,0x00]

image_gather4 v[18:21], [v22, v23], s[24:31], s[88:91] dmask:0x4 dim:SQ_RSRC_IMG_2D th:TH_LOAD_NT
// GFX12: encoding: [0x01,0xc0,0x0b,0xe5,0x12,0x30,0x10,0x2c,0x16,0x17,0x00,0x00]

image_gather4 v[18:21], [v22, v23], s[24:31], s[88:91] dmask:0x4 dim:SQ_RSRC_IMG_2D th:TH_LOAD_HT
// GFX12: encoding: [0x01,0xc0,0x0b,0xe5,0x12,0x30,0x20,0x2c,0x16,0x17,0x00,0x00]

image_gather4 v[18:21], [v22, v23], s[24:31], s[88:91] dmask:0x4 dim:SQ_RSRC_IMG_2D th:TH_LOAD_LU
// GFX12: encoding: [0x01,0xc0,0x0b,0xe5,0x12,0x30,0x30,0x2c,0x16,0x17,0x00,0x00]

image_gather4 v[18:21], [v22, v23], s[24:31], s[88:91] dmask:0x4 dim:SQ_RSRC_IMG_2D th:TH_LOAD_NT_RT
// GFX12: encoding: [0x01,0xc0,0x0b,0xe5,0x12,0x30,0x40,0x2c,0x16,0x17,0x00,0x00]

image_gather4 v[18:21], [v22, v23], s[24:31], s[88:91] dmask:0x4 dim:SQ_RSRC_IMG_2D th:TH_LOAD_RT_NT
// GFX12: encoding: [0x01,0xc0,0x0b,0xe5,0x12,0x30,0x50,0x2c,0x16,0x17,0x00,0x00]

image_gather4 v[18:21], [v22, v23], s[24:31], s[88:91] dmask:0x4 dim:SQ_RSRC_IMG_2D th:TH_LOAD_NT_HT
// GFX12: encoding: [0x01,0xc0,0x0b,0xe5,0x12,0x30,0x60,0x2c,0x16,0x17,0x00,0x00]

image_gather4 v[18:21], [v22, v23], s[24:31], s[88:91] dmask:0x4 dim:SQ_RSRC_IMG_2D th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x01,0xc0,0x0b,0xe5,0x12,0x30,0x3c,0x2c,0x16,0x17,0x00,0x00]

image_gather4 v[28:31], [v33, v34], s[40:47], s[80:83] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x4b,0xe4,0x1c,0x50,0x00,0x28,0x21,0x22,0x00,0x00]

image_gather4 v[28:29], [v33, v34], s[40:47], s[80:83] dmask:0x1 dim:SQ_RSRC_IMG_2D d16
// GFX12: encoding: [0x21,0xc0,0x4b,0xe4,0x1c,0x50,0x00,0x28,0x21,0x22,0x00,0x00]

image_gather4 v[35:38], [v39, v40], s[48:55], s[76:79] dmask:0x2 dim:SQ_RSRC_IMG_2D lwe
// GFX12: encoding: [0x01,0xc0,0x8b,0xe4,0x23,0x61,0x00,0x26,0x27,0x28,0x00,0x00]

image_gather4_l v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x4c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_l v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x8c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_l v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0x0c,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_l v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x00,0x4c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_l v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x00,0x8c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_l v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x00,0x0c,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_b v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x4c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_b v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x8c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_b v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0x0c,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_b v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x40,0x4c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_b v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x40,0x8c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_b v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x40,0x0c,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_lz v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x4c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_lz v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x8c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_lz v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0x0c,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_lz v[64:67], v32, s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x80,0x4c,0xe4,0x40,0x08,0x00,0x02,0x20,0x00,0x00,0x00]

image_gather4_lz v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x80,0x8c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_lz v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x80,0x0c,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_c v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x4c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x8c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0x0c,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0xc0,0x4c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_c v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0xc0,0x8c,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0xc0,0x0c,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_lz v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x4d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_lz v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x8d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_lz v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0x0d,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_lz v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x00,0x4d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_c_lz v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x00,0x8d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_lz v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x00,0x0d,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_o v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x4d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_o v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x8d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_o v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0x0d,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_o v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x40,0x4d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_o v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x40,0x8d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_o v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x40,0x0d,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_lz_o v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x4d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_lz_o v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x8d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_lz_o v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0x0d,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_lz_o v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x80,0x4d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_lz_o v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x80,0x8d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_lz_o v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x80,0x0d,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_lz_o v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x4d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_lz_o v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x8d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_lz_o v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0x0d,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_lz_o v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0xc0,0x4d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_lz_o v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0xc0,0x8d,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_lz_o v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0xc0,0x0d,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_get_lod v64, v32, s[4:11], s[100:103] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x4e,0xe4,0x40,0x08,0x00,0x32,0x20,0x00,0x00,0x00]

image_get_lod v64, [v32, v33], s[4:11], s[100:103] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x0e,0xe6,0x40,0x08,0x00,0x32,0x20,0x21,0x00,0x00]

image_get_lod v[64:65], [v32, v33, v34], s[4:11], s[100:103] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xce,0xe4,0x40,0x08,0x00,0x32,0x20,0x21,0x22,0x00]

image_get_lod v[64:65], [v32, v33, v34], s[4:11], s[100:103] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x0e,0xe7,0x40,0x08,0x00,0x32,0x20,0x21,0x22,0x00]

image_get_lod v[64:66], [v32, v33], s[4:11], s[100:103] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xce,0xe6,0x40,0x08,0x00,0x32,0x20,0x21,0x00,0x00]

image_get_lod v[64:67], [v32, v33, v34], s[4:11], s[100:103] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xce,0xe7,0x40,0x08,0x00,0x32,0x20,0x21,0x22,0x00]

image_sample_d_g16 v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x4e,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_d_g16 v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x0e,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_g16 v[64:65], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0xce,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_g16 v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x0e,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_g16 v[64:66], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xce,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_g16 v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xce,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_g16 v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x4e,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_g16 v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x0e,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_g16 v[64:65], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xce,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_g16 v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x0e,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_g16 v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xce,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_g16 v[64:67], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xce,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o_g16 v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x4e,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o_g16 v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x0e,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o_g16 v[64:65], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0xce,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o_g16 v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x0e,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o_g16 v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xce,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_o_g16 v[64:67], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xce,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x4f,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v64, [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x0f,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v[64:65], [v32, v33, v34, v[35:40]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xcf,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v[64:65], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x0f,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v[64:66], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xcf,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v[64:67], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xcf,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D a16
// GFX12: encoding: [0x40,0x00,0x4f,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x00,0x0f,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v[64:65], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX12: encoding: [0x42,0x00,0xcf,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x00,0x0f,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY a16
// GFX12: encoding: [0x44,0x00,0xcf,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_o_g16 v[64:67], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x00,0xcf,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_cl v64, [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x50,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_sample_cl v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x10,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_cl v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xd0,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_cl v[64:65], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x10,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_cl v[64:66], [v32, v33, v34], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xd0,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_cl v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xd0,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x50,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl v64, [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x10,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl v[64:65], [v32, v33, v34, v[35:41]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0xd0,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl v[64:65], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x10,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xd0,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl v[64:67], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xd0,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_cl v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x50,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_b_cl v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x10,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_cl v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xd0,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_cl v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x10,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_cl v[64:66], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xd0,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_cl v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xd0,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_cl v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x50,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_c_cl v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x10,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_cl v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0xd0,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_cl v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x10,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_cl v[64:66], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xd0,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_cl v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xd0,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x51,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl v64, [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x11,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl v[64:65], [v32, v33, v34, v[35:42]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xd1,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl v[64:65], [v32, v33, v34, v[35:40]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x11,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl v[64:66], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xd1,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl v[64:67], [v32, v33, v34, v[35:40]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xd1,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x51,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x11,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0xd1,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x11,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xd1,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl v[64:67], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xd1,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_cl_o v64, [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x51,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_sample_cl_o v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x11,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_cl_o v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xd1,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_cl_o v[64:65], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x11,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_cl_o v[64:66], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xd1,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_cl_o v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xd1,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x51,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o v64, [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x11,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o v[64:65], [v32, v33, v34, v[35:42]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0xd1,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o v[64:65], [v32, v33, v34, v[35:40]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x11,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o v[64:66], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xd1,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o v[64:67], [v32, v33, v34, v[35:40]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xd1,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_cl_o v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x52,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_cl_o v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x12,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_cl_o v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xd2,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_cl_o v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x12,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_cl_o v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xd2,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_b_cl_o v[64:67], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xd2,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_cl_o v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x52,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_cl_o v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x12,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_cl_o v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0xd2,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_cl_o v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x12,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_cl_o v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xd2,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_cl_o v[64:67], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xd2,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o v64, [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x52,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o v64, [v32, v33, v34, v[35:40]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x12,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o v[64:65], [v32, v33, v34, v[35:43]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xd2,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o v[64:65], [v32, v33, v34, v[35:41]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x12,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o v[64:66], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xd2,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o v[64:67], [v32, v33, v34, v[35:41]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xd2,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl_o v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x52,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl_o v64, [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x12,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl_o v[64:65], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0xd2,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl_o v[64:65], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x12,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl_o v[64:66], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xd2,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_b_cl_o v[64:67], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xd2,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_g16 v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x55,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_g16 v64, [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x15,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_g16 v[64:65], [v32, v33, v34, v[35:40]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xd5,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_g16 v[64:65], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x15,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_g16 v[64:66], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xd5,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_g16 v[64:67], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xd5,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o_g16 v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x55,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o_g16 v64, [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x15,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o_g16 v[64:65], [v32, v33, v34, v[35:40]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0xd5,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o_g16 v[64:65], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x15,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o_g16 v[64:66], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xd5,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_o_g16 v[64:67], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xd5,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o_g16 v64, [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x55,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o_g16 v64, [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x15,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o_g16 v[64:65], [v32, v33, v34, v[35:41]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xd5,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o_g16 v[64:65], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x15,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o_g16 v[64:66], [v32, v33, v34, v[35:38]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xd5,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_c_d_cl_o_g16 v[64:67], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xd5,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_g16 v64, [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x57,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_g16 v64, [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x17,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_g16 v[64:65], [v32, v33, v34, v[35:39]], s[4:11], s[4:7] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0xd7,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_g16 v[64:65], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xc dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x17,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_g16 v[64:66], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xd7,0xe6,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_sample_d_cl_g16 v[64:67], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xd7,0xe7,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_cl v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x58,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_cl v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x98,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_cl v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0x18,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_cl v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x00,0x58,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_cl v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x00,0x98,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_cl v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x00,0x18,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4_b_cl v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x58,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_b_cl v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x98,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_b_cl v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0x18,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_b_cl v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x40,0x58,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_b_cl v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x40,0x98,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_b_cl v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x40,0x18,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_cl v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x58,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_cl v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x98,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_cl v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0x18,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_cl v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x80,0x58,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_cl v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x80,0x98,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_cl v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x80,0x18,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_l v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x58,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_l v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x98,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_l v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0x18,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_l v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0xc0,0x58,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_l v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0xc0,0x98,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_l v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0xc0,0x18,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_b v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x59,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_b v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x99,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_b v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0x19,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_b v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x00,0x59,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4_c_b v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x00,0x99,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_b v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x00,0x19,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_b_cl v[64:67], [v32, v33, v34, v[35:36]], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x59,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_b_cl v[64:67], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x99,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_b_cl v[64:67], [v32, v33, v34, v[35:37]], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0x19,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_b_cl v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x40,0x59,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_b_cl v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x40,0x99,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4_c_b_cl v[64:67], [v32, v33, v34, v35], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x40,0x19,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x23]

image_gather4h v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x64,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4h v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0xa4,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4h v[64:67], [v32, v33, v34], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0x24,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x22,0x00]

image_gather4h v[64:67], v32, s[4:11], s[4:7] dmask:0x8 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x00,0x24,0xe6,0x40,0x08,0x00,0x02,0x20,0x00,0x00,0x00]

image_gather4h v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x2 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x00,0xa4,0xe4,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_gather4h v[64:67], [v32, v33], s[4:11], s[4:7] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x00,0x24,0xe5,0x40,0x08,0x00,0x02,0x20,0x21,0x00,0x00]

image_msaa_load v[1:4], [v5, v6, v7], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x00,0x46,0xe4,0x01,0x10,0x00,0x00,0x05,0x06,0x07,0x00]

image_msaa_load v[1:4], [v5, v6, v7], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX12: encoding: [0x06,0x20,0x46,0xe4,0x01,0x10,0x00,0x00,0x05,0x06,0x07,0x00]

image_msaa_load v[1:2], [v1, v2, v3], s[16:23] dmask:0x1 dim:SQ_RSRC_IMG_2D_MSAA unorm d16
// GFX12: encoding: [0x26,0x20,0x46,0xe4,0x01,0x20,0x00,0x00,0x01,0x02,0x03,0x00]

image_msaa_load v[1:4], [v1, v2], s[8:15] dmask:0x2 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX12: encoding: [0x46,0x20,0x86,0xe4,0x01,0x10,0x00,0x00,0x01,0x02,0x00,0x00]

image_msaa_load v[1:2], [v2, v1], s[8:15] dmask:0x2 dim:SQ_RSRC_IMG_2D_MSAA unorm a16 d16
// GFX12: encoding: [0x66,0x20,0x86,0xe4,0x01,0x10,0x00,0x00,0x02,0x01,0x00,0x00]

image_msaa_load v[1:4], [v8, v6, v5, v7], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX12: encoding: [0x07,0x20,0x06,0xe5,0x01,0x10,0x00,0x00,0x08,0x06,0x05,0x07]

image_msaa_load v[1:2], [v204, v11, v14, v19], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm d16
// GFX12: encoding: [0x27,0x20,0x06,0xe5,0x01,0xc0,0x00,0x00,0xcc,0x0b,0x0e,0x13]

image_msaa_load v[1:4], [v8, v6], s[8:15] dmask:0x8 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX12: encoding: [0x47,0x20,0x06,0xe6,0x01,0x10,0x00,0x00,0x08,0x06,0x00,0x00]

image_msaa_load v[1:2], [v5, v7], s[8:15] dmask:0x8 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16 d16
// GFX12: encoding: [0x67,0x20,0x06,0xe6,0x01,0x10,0x00,0x00,0x05,0x07,0x00,0x00]

image_msaa_load v[0:4], [v5, v7, v11, v55], s[8:15] dmask:0x8 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm tfe
// GFX12: encoding: [0x0f,0x20,0x06,0xe6,0x00,0x10,0x00,0x00,0x05,0x07,0x0b,0x37]

image_msaa_load v[1:4], [v5, v6, v7, v8], s[8:15] dmask:0x8 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY lwe
// GFX12: encoding: [0x07,0x00,0x06,0xe6,0x01,0x11,0x00,0x00,0x05,0x06,0x07,0x08]

image_msaa_load v[0:2], [v5, v7, v11, v55], s[8:15] dmask:0x8 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm tfe d16
// GFX12: encoding: [0x2f,0x20,0x06,0xe6,0x00,0x10,0x00,0x00,0x05,0x07,0x0b,0x37]

image_msaa_load v[1:4], [v5, v6, v7], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_2D_MSAA unorm th:TH_LOAD_NT
// GFX12: encoding: [0x06,0x20,0x46,0xe4,0x01,0x10,0x10,0x00,0x05,0x06,0x07,0x00]
