// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1200 -show-encoding %s | FileCheck --check-prefix=GFX12 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1200 -show-encoding %s 2>&1 | FileCheck --check-prefixes=GFX12-ERR --implicit-check-not=error: %s

buffer_load_dword v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dword v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dword v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dword v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dword v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dword v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dword v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_dword v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_dword v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_dword v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_dword v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_dword v5, off, s[8:11], s3 offset:8388607 lds
// GFX12-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx3 v[253:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0xfd,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx3 v[5:7], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx3 v[5:7], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx3 v[5:7], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx3 v[5:7], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx4 v[252:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0xfc,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx4 v[5:8], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx4 v[5:8], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx4 v[5:8], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx4 v[5:8], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x05,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_short_d16 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_short_d16 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_short_d16 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_short_d16 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_short_d16 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_x v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_x v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_x v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_x v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_x v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_x v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_x v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_x v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_format_d16_xy v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xy v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xy v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xy v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xy v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xy v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xy v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xy v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xy v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_d16_xy v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_d16_xy v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyz v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyz v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyz v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyz v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyz v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyzw v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyzw v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyzw v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyzw v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyzw v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x02,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_short_d16_hi v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16_hi v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16_hi v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16_hi v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16_hi v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16_hi v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_short_d16_hi v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_short_d16_hi v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_short_d16_hi v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_short_d16_hi v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_short_d16_hi v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_hi_x v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_hi_x v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_hi_x v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_hi_x v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_hi_x v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_hi_x v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_hi_x v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x09,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16_hi v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16_hi v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16_hi v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16_hi v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16_hi v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16_hi v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16_hi v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16_hi v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16_hi v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16_hi v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16_hi v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16_hi v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x08,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_sbyte_d16 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_sbyte_d16 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_sbyte_d16 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_sbyte_d16 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_ubyte_d16 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_ubyte_d16 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_ubyte_d16 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_ubyte_d16 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x07,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_sbyte v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sbyte v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_sbyte v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_sbyte v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_sbyte v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_sbyte v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_sshort v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sshort v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sshort v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sshort v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sshort v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sshort v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_sshort v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_sshort v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_sshort v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_sshort v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_sshort v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_ubyte v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ubyte v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_ubyte v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_ubyte v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_ubyte v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_ubyte v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_load_ushort v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ushort v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ushort v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ushort v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ushort v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ushort v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_load_ushort v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_load_ushort v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_load_ushort v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_ushort v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_load_ushort v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x04,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]


buffer_store_byte v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_byte v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_byte v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_byte v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_byte v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x00,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_short v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_short v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_short v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_short v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_short v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x40,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_dword v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dword v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dword v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dword v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dword v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dword v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dword v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_dword v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_dword v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_dword v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_dword v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x80,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx2 v[254:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0xfe,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx2 v[1:2], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx2 v[1:2], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx2 v[1:2], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx2 v[1:2], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0xc0,0x06,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx3 v[253:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0xfd,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx3 v[1:3], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx3 v[1:3], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx3 v[1:3], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx3 v[1:3], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x00,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx4 v[252:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0xfc,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx4 v[1:4], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx4 v[1:4], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx4 v[1:4], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx4 v[1:4], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x40,0x07,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_x v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_x v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_x v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_x v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_x v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_x v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_x v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_x v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x00,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_format_d16_xy v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xy v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xy v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xy v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xy v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xy v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xy v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xy v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xy v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_d16_xy v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_d16_xy v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x40,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyz v[254:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0xfe,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyz v[1:2], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyz v[1:2], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyz v[1:2], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyz v[1:2], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x80,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyzw v[254:255], off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0xfe,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyzw v[1:2], off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyzw v[1:2], off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyzw v[1:2], v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyzw v[1:2], v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0xc0,0x03,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_byte_d16_hi v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte_d16_hi v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte_d16_hi v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte_d16_hi v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte_d16_hi v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte_d16_hi v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_byte_d16_hi v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_byte_d16_hi v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_byte_d16_hi v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_byte_d16_hi v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_byte_d16_hi v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x00,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_short_d16_hi v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short_d16_hi v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short_d16_hi v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short_d16_hi v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short_d16_hi v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short_d16_hi v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_short_d16_hi v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_short_d16_hi v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_short_d16_hi v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_short_d16_hi v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_short_d16_hi v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0x40,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_hi_x v255, off, s[12:15], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0xff,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_hi_x v1, off, s[16:19], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x20,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_hi_x v1, off, s[96:99], s4 offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_hi_x v1, off, s[12:15], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_hi_x v1, off, s[12:15], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_hi_x v1, v0, s[12:15], s4 idxen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_hi_x v1, v0, s[12:15], s4 offen offset:8388607
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4 offset:0
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4 offset:7
// GFX12: encoding: [0x04,0xc0,0x09,0xc4,0x01,0x18,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_add v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_add v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_add v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_add v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_add v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_add v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_add_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_add_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x10,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_and v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_and v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_and v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_and v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_and v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x0f,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_and_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_and_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x12,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_x2 v[252:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0xfc,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_x2 v[5:8], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_x2 v[5:8], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_x2 v[5:8], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_x2 v[5:8], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x10,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub v255, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0xff,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub v5, off, s[12:15], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x18,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub v5, off, s[96:99], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0xc0,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub v5, off, s[8:11], s101 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x65,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub v5, off, s[8:11], m0 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7d,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub v5, v0, s[8:11], s3 idxen offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_csub v5, v0, s[8:11], s3 offen offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_csub v5, off, s[8:11], s3 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_csub v5, off, s[8:11], s3 offset:0 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_csub v5, off, s[8:11], s3 offset:7 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_csub v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub_u32 v255, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0xff,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub_u32 v5, off, s[12:15], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x18,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub_u32 v5, off, s[96:99], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0xc0,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub_u32 v5, off, s[8:11], s101 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x65,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub_u32 v5, off, s[8:11], m0 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7d,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_csub_u32 v5, v0, s[8:11], s3 idxen offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_csub_u32 v5, v0, s[8:11], s3 offen offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 offset:0 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 offset:7 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_dec v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_dec v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_dec v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_dec v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_dec v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x10,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x13,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_inc v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_inc v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_inc v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_inc v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_inc v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0f,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x13,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmax v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmax v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmax v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmax v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmax v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmax v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmax v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_fmax v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_fmax v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_fmax v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_fmax v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_fmax v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_f32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_f32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_f32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_f32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_f32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_f32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_max_f32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_max_f32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_max_f32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_f32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_max_f32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_max_f32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x14,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_smax v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_smax v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_smax v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_smax v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_smax v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x0e,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smax_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_smax_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x11,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_umax v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_umax v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_umax v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_umax v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_umax v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0e,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umax_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_umax_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x12,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmin v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmin v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmin v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmin v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmin v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmin v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_fmin v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_fmin v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_fmin v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_fmin v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_fmin v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_fmin v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_f32 v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_f32 v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_f32 v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_f32 v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_f32 v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_f32 v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_min_f32 v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_min_f32 v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_min_f32 v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_f32 v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_min_f32 v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_min_f32 v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x14,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_smin v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_smin v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_smin v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_smin v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_smin v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x0e,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_smin_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_smin_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x11,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_umin v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_umin v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_umin v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_umin v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_umin v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x0e,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_umin_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_umin_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x11,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_or v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_or v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_or v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_or v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_or v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x0f,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_or_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_or_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x12,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_sub v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_sub v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_sub v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x0d,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x00,0x11,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_swap v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_swap v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_swap v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_swap v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_swap v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x0c,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x40,0x10,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor v5, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor v255, off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0xff,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor v5, off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor v5, off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor v5, off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor v5, off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor v5, v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_xor v5, v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_xor v5, off, s[8:11], s3
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_xor v5, off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_xor v5, off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_xor v5, off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0x80,0x0f,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_x2 v[254:255], off, s[8:11], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0xfe,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_x2 v[5:6], off, s[12:15], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x18,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_x2 v[5:6], off, s[96:99], s3 offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0xc0,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s101 offset:8388607
// GFX12: encoding: [0x65,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], m0 offset:8388607
// GFX12: encoding: [0x7d,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_x2 v[5:6], v0, s[8:11], s3 idxen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x80,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_x2 v[5:6], v0, s[8:11], s3 offen offset:8388607
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x40,0x00,0xff,0xff,0x7f]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x00,0x00,0x00]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x80,0x00,0x00,0x07,0x00,0x00]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:8388607 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x03,0xc0,0x12,0xc4,0x05,0x10,0x90,0x00,0x00,0xff,0xff,0x7f]
